var jsvalue = '';
var tsvalue = '';
var opt2 = '';
var opt3 = '';
var opt4 = '';
var comptype='';
Ext.define('BTMProfilerDownload.controller.Main', {
    extend: 'Ext.app.Controller',

    views: ['BTMJars', 'BTMJar', 'BTMJarAgentInfo', 'BTMJarAgentLessInfo','TreeMainView','BTMJarNodejsInfo','BTMJarNodejsLessInfo','BTMLogJarGrid','BTMLogJars'],
    requires: ['BTMProfilerDownload.view.BTMJar', 'BTMProfilerDownload.view.BTMJarGrid', 'BTMProfilerDownload.view.BTMJarAgentInfo', 'BTMProfilerDownload.view.BTMJarAgentLessInfo',  'BTMProfilerDownload.view.TreeMainView','BTMProfilerDownload.view.BTMJarNodejsInfo', 'BTMProfilerDownload.view.BTMJarNodejsLessInfo','BTMProfilerDownload.view.BTMLogJarGrid','BTMProfilerDownload.view.BTMLogJars'],
	stores: ['BTMProfilerDownload.store.LogTreeStore'],

    refs: [{
            selector: 'btmjars',
            ref: 'btmjars'
        }, {
            selector: 'btmjar',
            ref: 'btmjar'
        }, {
            selector: 'btmjargrid',
            ref: 'btmjargrid'
        },{
            selector: 'btmlogjars',
            ref: 'btmlogjars'
        },{
            selector: 'btmlogjargrid',
            ref: 'btmlogjargrid'
        },{
            selector: 'btmjarAgentInfo',
            ref: 'btmjarAgentInfo'
        },
        {
			selector: 'logTreePanel',
            ref: 'myLogTreePanel'
        },
		{
            selector: 'btmjarnodejsInfo',
            ref: 'btmjarnodejsInfo'
        },
		{
            selector: 'btmjarnodejsLessInfo',
            ref: 'btmjarnodejsLessInfo'
        },
    ],

    init: function () {
        appRmtCnt = this;
        this.buildMainData()

        this.control({
            'btmjars': {
                'afterrender': this.afterMainRender
            },
            'btmjars trigger[name="gridRmtSearch"]': {
                'change': this.mainGridSearch
            },
            'btmjars button[id="showGuid"]': {
                'click': this.showGuidDetails
            },
            'btmjar button[id="updateBtn"]': {
                'click': this.addUpdate
            },
            'assignremoteagent button[id="backbutton"]': {
                'click': this.backbutton
            },
            'btmjarAgentInfo button[action="copyAgentInfo"]' : {
				'click' : this.copyAgentInfo
			},
			'btmlogjars button[id="savePropsLog"]': {
				'click': this.savePropsDetails
			},
			'btmlogjars button[id="resetPropsLog"]': {
				'click': this.resetPropsDetails
			},
			'btmjarAgentLessInfo button[action="copyAgentLessInfo"]' : {
				'click' : this.copyAgentLessInfo
            },'treeMainView':{
				'afterrender': this.mainAfterRender,
			},
            'listofmeasures': {
                'afterrender': this.afterAccordionRender,
                'boxready': this.accordionTreeExpand
             },
			 'logTreePanel': {
				'afterrender':this.afterFunctionRender,
				'load': this.functionTreeLoad,
                'collapse': this.functionPanelCollapse,
                'expand': this.functionPanelExpand,
                'itemclick': this.functionPanelItemClick,
                'beforeitemexpand': this.functionPanelBeforeExpand,
                'afteritemexpand': this.functionPanelAfterExpand,
                'beforeitemcollapse': this.functionPanelBeforeCollapse,
                'afteritemcollapse': this.functionPanelAfterCollapse
            },
			'btmjarnodejsInfo button[action="copyAgentInfo"]' : {
				'click' : this.copyNodejsInfo
			},
			'btmjarnodejsLessInfo button[action="copyAgentLessNodejs"]' : {
				'click' : this.copyAgentLessNodejs
			}
        });
    },
    buildMainData: function () {
        Ext.Ajax.request({
            url: 'BTMProfilerDownload/data/EgDispBtmComponentsJson.jsp',
            method: 'POST',
            async: false,
            success: function (response) {
                if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
                    var jsonText = response.responseText;
                    publicJSON = Ext.decode(jsonText);

                }
            }
        });
    },

    handleDownloadIconClick: function (gridView, rowIndex, colIndex) {

        var DispValues = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
        var apmType = DispValues.get('APMName');
    		if(apmType=="NODE.JS"){
    			var form = document.createElement("form");
    			form.setAttribute("method", "post");
    			form.setAttribute("action", "/final/servlet/com.eg.ProfilerScriptDownloader?&Stype=NodeJS");
    			document.body.appendChild(form);
    			form.submit();
    		}else{
    			var compName = DispValues.get('CompNickName');
    			var compType = DispValues.get('compType');
    			var port = DispValues.get('comPort');
    			var hostIP = DispValues.get('hostIP');
    			var agentIP = DispValues.get('agentIP');
    			var appname = DispValues.get('appName');
    			var tierName = DispValues.get('tierName');
    			var monitoring = DispValues.get('monitoring');
    			this.downloadTask(apmType, compName, port, agentIP, monitoring, appname, tierName, hostIP, compType);
    		}
    },

    handleEditIconClick: function (gridView, rowIndex, colIndex) {
        btnText = 'Change RUM';
        var rec = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
        var CompName = rec.get('CompNickName');
        var rumUrl = rec.get('hostIP');
        var compPort = rec.get('comPort');
        var comAppName = rec.get('appName');
        var comTierName = rec.get('tierName');
        var compType1 = rec.get('compType');
        this.showEditWindow(CompName, comAppName, compPort, comTierName, compType1);
    },

    showEditWindow: function (CompName, comAppName, compPort, comTierName, compType1) {

        Ext.widget('btmjar').show();
        Ext.getCmp('AppName').setFieldLabel('Application Name');
        Ext.getCmp('AppName').setValue(comAppName);
        Ext.getCmp('tierName').setFieldLabel('Tier Name');
        Ext.getCmp('tierName').setValue(comTierName);
        Ext.getCmp('compType').setValue(compType1);
        Ext.getCmp('compName').setValue(CompName);
        Ext.getCmp('compPort').setValue(compPort);
        Ext.getCmp('updateBtn').setText('Update');
        Ext.getCmp('AddModRmtView').setTitle(rmtModPageTitle);
        Ext.getCmp('interLinkYes').setValue(true);
        // alert('comTierName : '+comTierName);

    },
    downloadTask: function (apmType, compName, port, agentIP, monitoring, appname, tierName, hostIP, compType) {
        // alert('appname- '+appname)
        // alert('apmType -'+apmType)
        // alert('compName- '+compName)
        // alert('port- '+port)
        // alert('hostIP- '+hostIP)
        // alert('monitoring- '+monitoring)
        // alert('tierName- '+tierName)
        var serverType = compName + "_" + port;
        var form = document.createElement("form");
        var qrString = "&apmType=" + encodeURIComponent(apmType) + "&compIp=" + encodeURIComponent(hostIP) + "&compName=" + encodeURIComponent(compName) + "&port=" + encodeURIComponent(port) + "&agentIP=" + encodeURIComponent(agentIP) + "&monitoring=" + encodeURIComponent(monitoring) + "&appName=" + encodeURIComponent(appname) + "&tierName=" + encodeURIComponent(tierName) + "&Stype=" + encodeURIComponent(serverType) + "&BTM=" + encodeURIComponent("true") + "&compType=" + encodeURIComponent(parent.filterEncode(compType));
        form.setAttribute("method", "post");
        form.setAttribute("action", "/final/servlet/com.eg.ProfilerScriptDownloader?" + qrString);
        document.body.appendChild(form);
        form.submit();
    },

    multiDownloadTask: function (apmType, compName, port, agentIP, monitoring, appname, tierName, hostIP, compType, counter) {

        var serverType = compName + "_" + port;

		var qrString = "";

		if(apmType=="NODE.JS"){
			 serverType = "NodeJS";
			 qrString = "&Stype=" + encodeURIComponent(serverType);
		}
		else{
			qrString = "&apmType=" + encodeURIComponent(apmType) + "&compIp=" + encodeURIComponent(hostIP) + "&compName=" + encodeURIComponent(compName) + "&port=" + encodeURIComponent(port) + "&agentIP=" + encodeURIComponent(agentIP) + "&monitoring=" + encodeURIComponent(monitoring) + "&appName=" + encodeURIComponent(appname) + "&tierName=" + encodeURIComponent(tierName) + "&Stype=" + encodeURIComponent(serverType) + "&BTM=" + encodeURIComponent("true") + "&compType=" + encodeURIComponent(parent.filterEncode(compType));
		}
        var id = "#btmIframe" + counter;
            var iFrameExists = Ext.query(id);
        if (Ext.isEmpty(iFrameExists)) {
            Ext.DomHelper.append(document.body, {
                tag: 'iframe',
                frameBorder: 0,
                width: 0,
                height: 0,
                css: 'display:none;visibility:hidden;height:1px;',
                src: "/final/servlet/com.eg.ProfilerScriptDownloader?" + qrString,
                id: id
            });
        } else {
            Ext.select(id).set({
                src: "/final/servlet/com.eg.ProfilerScriptDownloader?" + qrString
            });
        }
    },

    mainGridSearch: function (obj) {
        var gridsearch = Ext.getCmp('gridRmtSearch').getValue();
        if (gridsearch == "" || gridsearch.length == 0) {
            Ext.get('MyTrigger_0').setStyle('display', 'none');
            Ext.get('MyTrigger_1').setStyle('display', 'block');
        } else {
            Ext.get('MyTrigger_1').setStyle('display', 'none');
            Ext.get('MyTrigger_0').setStyle('display', 'block');
        }

        Ext.Ajax.request({
            url: 'BTMProfilerDownload/data/EgDispBtmComponentsJson.jsp?egTitleSearchStr=' + encodeURIComponent(filterEncode(gridsearch)),
            method: 'POST',
            success: function (response) {
                if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
                    var jsonText = response.responseText;
                    publicJSON = Ext.decode(jsonText);
                }
                var value = publicJSON['gridRmtAgents'];
                // Ext.getCmp('gridRmtDisplay').show();
                if (value != null && value.length > 0) {
                    Ext.getCmp('showGuid').enable();
                    hideGuids();
                    addGuidGridEx(value);

                } else {
                    addGuidGridEx([]);
                    Ext.getCmp('showGuid').disable();
                    Ext.getCmp('gridRmtDisplay').getStore().removeAll();
                    Ext.getCmp('mainBTMJarsgrid').getView().emptyText = '<div class="egFlexCenterByColumnWise" style="height:98%"><div class="iconExclamation"></div><div class="commonErrorMsgText">' + NoBtmFound + ' : ' + "'" + gridsearch + "'" + '</div></div>';
                    Ext.getCmp('mainBTMJarsgrid').getView().refresh();
                }
            }
        });
    },
	    filterByBTMApps: function (obj) {
			 var gridsearch = Ext.getCmp('gridRmtSearch').getValue();
        if (gridsearch == "" || gridsearch.length == 0) {
            Ext.get('MyTrigger_0').setStyle('display', 'none');
            Ext.get('MyTrigger_1').setStyle('display', 'block');
        } else {
            Ext.get('MyTrigger_1').setStyle('display', 'none');
            Ext.get('MyTrigger_0').setStyle('display', 'block');
        }
        var filterByValue = Ext.getCmp('filterByBTMApps').getValue();
        Ext.Ajax.request({
            url: 'BTMProfilerDownload/data/EgDispBtmComponentsJson.jsp?filterByBTMApps=' +encodeURIComponent(parent.filterEncode(filterByValue)),
            method: 'POST',
            success: function (response) {
                if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
                    var jsonText = response.responseText;
                    publicJSON = Ext.decode(jsonText);
                }
                var value = publicJSON['gridRmtAgents'];
                if (value != null && value.length > 0) {
                    Ext.getCmp('showGuid').enable();
                    hideGuids();
                    addGuidGridEx(value);
                } else {
                    addGuidGridEx([]);
                    Ext.getCmp('showGuid').disable();
                    Ext.getCmp('gridRmtDisplay').getStore().removeAll();
                    Ext.getCmp('mainBTMJarsgrid').getView().emptyText = '<div class="egFlexCenterByColumnWise" style="height:98%"><div class="iconExclamation"></div><div class="commonErrorMsgText">' + NoBtmFound +'</div></div>';
                    Ext.getCmp('mainBTMJarsgrid').getView().refresh();
                }
            }
        });
    },
    specialCharacterCheck: function (text) {
        var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
        try {
            for (count = 0; count < text.length; count++) {
                var check_char = s_spl.indexOf(text.charAt(count));
                if (check_char >= 0)
                    return true;
            }
        } catch (e) {}
        return false;
    },
    validationForAddModify: function () {
        var appname = Ext.getCmp('AppName').getValue();
        var tierName = Ext.getCmp('tierName').getValue();

        if (appname != null && appname == '') {
            Ext.Msg.alert("Agent Jar Download", "Please Enter Application name");
            Ext.getCmp('AppName').focus(true);
            return false;
        } else if (!checkblank(appname)) {
            Ext.Msg.alert("Agent Jar Download", "Please Enter Application name"); ;
            Ext.getCmp('AppName').focus(true);
            return false;
        } else if (tierName != null && tierName == '') {
            Ext.Msg.alert("Agent Jar Download", "Please Enter Tier name ");
            Ext.getCmp('tierName').focus(true);
            return false;
        } else if (!checkblank(tierName)) {
            Ext.Msg.alert("Agent Jar Download", "Please Enter Tier name "); ;
            Ext.getCmp('tierName').focus(true);
            return false;
        } else {
            return true;
        }
    },
    backbutton: function () {
        Ext.getCmp('remoteviewport').removeAll();
        this.buildMainData();
        Ext.getCmp('remoteviewport').add({
            xtype: 'btmjars'
        });
        this.afterMainRender();
    },
    showGuidDetails: function () {

        var textName = Ext.getCmp('showGuid').getText();

        if (textName != null && textName == 'Show GUIDs') {
            Ext.getCmp('DispMonitoring').hide();
            Ext.getCmp('DispAgentIP').hide();
            Ext.getCmp('DispTierName').hide();
            Ext.getCmp('DispappName').hide();
            Ext.getCmp('DispGuid').show();
            Ext.getCmp('showGuid').setText('Hide GUIDs');
        } else {
            Ext.getCmp('DispMonitoring').show();
            Ext.getCmp('DispAgentIP').show();

            Ext.getCmp('DispTierName').show();
            Ext.getCmp('DispappName').show();
            Ext.getCmp('DispGuid').hide();
            Ext.getCmp('showGuid').setText('Show GUIDs');
        }
    },

    handleDownloadSelected: function () {
        //alert("handleDeleteSelected");
        var grid = Ext.getCmp('mainBTMJarsgrid').getSelectionModel().getSelection();
        var gridValues = '';
        var array = new Array();
        var selectedGroups = "";
        if (grid == "") {
            Ext.MessageBox.alert('Profiler Download', "No component(s) selected");
            return false;
        }
        var gridLength = grid.length;
        if (gridLength > 20) {
            Ext.MessageBox.alert('Profiler Download', "Selected components should not be more than 20, Currently selected components: " + gridLength);
            return false;
        }
        for (var i = 0; i < grid.length; i++) {
            gridValues = grid[i];

            var apmType = gridValues.get('APMName');
            var compName = gridValues.get('CompNickName');
            var compType = gridValues.get('compType');
            var port = gridValues.get('comPort');
            var hostIP = gridValues.get('hostIP');
            var agentIP = gridValues.get('agentIP');
            var appname = gridValues.get('appName');
            var tierName = gridValues.get('tierName');
            var monitoring = gridValues.get('monitoring');

            this.multiDownloadTask(apmType, compName, port, agentIP, monitoring, appname, tierName, hostIP, compType, i);
            // setTimeout("",300);
        }
    },

    backDelButton: function (btn) {
        Ext.getCmp('remoteviewport').removeAll();
        this.buildMainData();
        Ext.getCmp('remoteviewport').add({
            xtype: 'btmjars'
        });
        this.afterMainRender();
    },
    afterMainRender: function () {
        var resultsData = publicJSON['gridRmtAgents'];
        //console.log('',resultsData);
        if (Ext.isEmpty(resultsData)) {
            var nodata = {
                xtype: 'component',
                html: '<div class="egFlexCenterByColumnWise" style="height:100%"><div class="iconExclamation"></div><div class="commonErrorMsgText">' + NoBtmDesc + '</div></div>',
                width: '100%',
	    	flex: 1
            };
            var resultPanelObj = Ext.getCmp('resultpanel');
            resultPanelObj.show();
            resultPanelObj.removeAll();
            resultPanelObj.add(nodata);

            Ext.getCmp('gridRmtSearch').hide();
            Ext.getCmp('showGuid').hide();
			
            // addGuidGridEx([]);
            // Ext.getCmp('showGuid').disable();
			// Ext.getCmp('gridRmtSearch').disable();
            // Ext.getCmp('gridRmtDisplay').getStore().removeAll();
            // Ext.getCmp('mainBTMJarsgrid').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoBtmDesc+'</td></tr></table></td></tr></table>';
            // Ext.getCmp('mainBTMJarsgrid').getView().refresh();
        } else {
            Ext.getCmp('gridRmtSearch').enable();
            Ext.getCmp('showGuid').enable();
            addGuidGridEx(resultsData);
            hideGuids();
        }
    },
    addUpdate: function (btn) {
        var me = this;
        var appname = Ext.getCmp('AppName').getValue();
        var tierName = Ext.getCmp('tierName').getValue();
        var compType = Ext.getCmp('compType').getValue();
        var compName = Ext.getCmp('compName').getValue();
        var compPort = Ext.getCmp('compPort').getValue();
        var interLinkFlag = Ext.getCmp('interLinkYes').getValue();
        var updateInterLinkComp = 'Yes';
        if (!interLinkFlag) {
            updateInterLinkComp = 'No';
        }
        var compNameWithPort = compName + ":" + compPort
            // alert(compNameWithPort);

            var mode = '';
        if (btnText == 'Add New Collector') {
            mode = 'add';
        } else {
            mode = 'modifyUrl';
        }
        var me = this;
        var checkAppValidation = this.specialCharacterCheck(appname);
        var checkTierValidation = this.specialCharacterCheck(tierName);
        var qstring = "appName=" + encodeURIComponent(appname) + "&tierName=" + encodeURIComponent(tierName) + "&compType=" + encodeURIComponent(parent.filterEncode(compType)) + "&compName=" + encodeURIComponent(compName) + "&compNameWithPort=" + encodeURIComponent(compNameWithPort) + "&updateInterLinkComp=" + encodeURIComponent(updateInterLinkComp);
        // alert(qstring);

        if (checkAppValidation) {
            Ext.Msg.alert("Profiler Download", "Special characters not allowed"); ;
            Ext.getCmp('AppName').focus();
        }
        if (checkTierValidation) {
            Ext.Msg.alert("Profiler Download", "Special characters not allowed"); ;
            Ext.getCmp('tierName').focus();
        }
        if (!checkAppValidation && !checkTierValidation) {
            Ext.Ajax.request({
                url: 'BTMProfilerDownload/data/EgBtmAppNameUpdate.jsp?' + qstring,
                method: 'POST',
                async: false,
                success: function (response) {
                    if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
                        var jsonText = response.responseText;
                        publicJSON = Ext.decode(jsonText);
                    }
                }
            });
            Ext.getCmp('AddModRmtView').destroy();
            me.buildMainData();
            me.afterMainRender();
        }
    },
    copyComponentGuid: function(grid, rowIndex, colIndex){
	var obj = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
	var guid = obj.get('GUID');
	var apmType = obj.get('APMName');
	var monitoring = obj.get('monitoring');
	var egServerType = obj.get('egServerType');
	var copyText = "";
	var rplcText = "";
	var copyOptionTitle = "";
	var tsText = "";
	var option2 = obj.get('option2');
	var option3 = obj.get('option3');
	var option4 = obj.get('option4');	
	
		if(monitoring.indexOf('Agentless')!=-1){
		if(apmType=="NODE.JS"){
			var nodejsScript = obj.get('nodejsScript');		
			var typeScript = obj.get('typeScript');	
			
			opt2 =splitSnippet(option2);
			opt3 =splitSnippet(option3);
			opt4 =splitSnippet(option4);
			
			copyText = splitSnippet(nodejsScript);
			tsText = splitSnippet(typeScript);			
			jsvalue = copyText;
			tsvalue = tsText;
			
			copyOptionTitle = copyNodeJsOption;			
			Ext.widget('btmjarnodejsLessInfo').show();
			Ext.getCmp("btmjarnodejsLessInfo").setTitle(copyOptionTitle);
		}else{
			copyText = "1.	"+copyText1+".\r\n2.	"+copyText2.replace("zip", ".zip")+".\r\n3.	"+copyText3+".\r\n4.	"+copyText4.replace("btmJarLoc","\"-javaagent:<PATH_TO_eg_btm.jar>\"")+".\r\n5.	"+copyText5.replace("13700","\"13700\"").replace("egbtmjar","eg_btm.jar")+".\r\n\r\n"+copyText6+" ...";
			copyOptionTitle = copyJVMOption;
			
			Ext.widget('btmjarAgentLessInfo').show();
			Ext.getCmp("btmjarAgentLessInfo").setTitle(copyOptionTitle);
			Ext.getCmp('copyMessage').setValue(copyText);
		}
		
	}else{
		if(apmType=="NODE.JS"){
			var nodejsScript = obj.get('nodejsScript');
			var typeScript = obj.get('typeScript');	
			
			var eghomedir = "<<EGURKHA_AGENT_HOME>>"+"+lib+apm+NodeJS+default";		
			
			typeScript = changeEghomedir(typeScript, eghomedir);
			nodejsScript = changeEghomedir(nodejsScript, eghomedir);
			option2 = changeEghomedir(option2, eghomedir);
			option3 = changeEghomedir(option3, eghomedir);
			option4 = changeEghomedir(option4, eghomedir);	
						
			opt2 =splitSnippet(option2);
			opt3 =splitSnippet(option3);
			opt4 =splitSnippet(option4);
			
			copyText = splitSnippet(nodejsScript);
			tsText = splitSnippet(typeScript);
			
			copyOptionTitle = copyNodeJsOption;			
			jsvalue = copyText;
			//tsvalue = tsText;
						
			Ext.widget('btmjarnodejsInfo').show();
			Ext.getCmp("btmjarnodejsInfo").setTitle(copyOptionTitle);
			
		}else{
			copyText = "-javaagent:<<EGURKHA_AGENT_HOME>>/lib/apm/Java/default/eg_btm.jar=component_guid="+guid;
			if(egServerType!=null && egServerType!=""){
				copyText = copyText+",server_type="+egServerType;
			}
			copyOptionTitle = copyJVMOption;
			
			Ext.widget('btmjarAgentInfo').show();
			Ext.getCmp("btmjarAgentInfo").setTitle(copyOptionTitle);
			Ext.getCmp('copyMessage').setValue(copyText);
		}	
	}
	/*
		if(apmType=="NODE.JS"){
			Ext.getCmp('includeJSScript').setValue(copyText);
			Ext.getCmp('includeScript').setValue(tsText);
			if(Ext.getCmp('radioOne').getValue()){
				Ext.getCmp('includeJSScript').show();
				Ext.getCmp('includeScript').hide();
			}
		}
		*/
    }, 
    copyAgentInfo: function (){
		var dummy = document.createElement("textarea");
		document.body.appendChild(dummy);
		dummy.value = Ext.getCmp('copyMessage').getValue();
		dummy.select();
		document.execCommand("copy");
		document.body.removeChild(dummy);
		Ext.getCmp('btmjarAgentInfo').destroy();
    },
	copyAgentLessInfo: function (){
		Ext.getCmp('btmjarAgentLessInfo').destroy();
    },
	copyAgentLessNodejs: function (){
		var dummy = document.createElement("textarea");
		document.body.appendChild(dummy);
		
		if(Ext.DomQuery.select('[name=optionmsg]').length>0){
			dummy.value = 	Ext.DomQuery.select('[name=optionmsg]')[0].value;	
		}else{
			if(Ext.getCmp('radioOne').getValue()){
				dummy.value = Ext.getCmp('includeJSScript').getValue();
			}else if(Ext.getCmp('radioTwo').getValue()){
				dummy.value = Ext.getCmp('includeScript').getValue();	
			}
		}		
		dummy.select();
		document.execCommand("copy");
		document.body.removeChild(dummy);
		Ext.getCmp('btmjarnodejsLessInfo').destroy();
    },
	copyNodejsInfo: function (){
		var dummy = document.createElement("textarea");
		document.body.appendChild(dummy);		
				
		if(Ext.DomQuery.select('[name=optionmsg]').length>0){
			dummy.value = 	Ext.DomQuery.select('[name=optionmsg]')[0].value;	
		}else{
			if(Ext.getCmp('radioOne').getValue()){
				dummy.value = Ext.getCmp('includeJSScript').getValue();
			}else if(Ext.getCmp('radioTwo').getValue()){
				dummy.value = Ext.getCmp('includeScript').getValue();	
			}
		}
		dummy.select();
		document.execCommand("copy");
		document.body.removeChild(dummy);
		Ext.getCmp('btmjarnodejsInfo').destroy();
		
	},
	showAdvancedSettiongsOption: function(grid, rowIndex, colIndex){
	
		sessionStorage.removeItem("guidValue");
		var obj = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		sessionStorage.setItem("guidValue", obj.get('GUID'));
		sessionStorage.setItem("compType", obj.get('compType'));
		sessionStorage.setItem("compNickName", obj.get('CompNickName'));
		sessionStorage.setItem("comPort", obj.get('comPort'));
		sessionStorage.setItem("hostIP", obj.get('hostIP'));
		Ext.widget('treeMainView').show();
		Ext.getCmp('mainBTMLogJars').setTitle("<div style='float:right;'>"+obj.get('CompNickName')+" ("+obj.get('compType')+")</div>");
		comptype="<div style='float:right;'>"+obj.get('CompNickName')+" ("+obj.get('compType')+")</div>";
	},
	mainAfterRender:function()
	{
		var westRegion=Ext.getCmp('westRegion');
		if (Ext.get('westRegion-splitter-collapseEl')!=null)
		{
			Ext.get('westRegion-splitter-collapseEl').on('click',function(){

				if (westRegion.collapsed==true || westRegion.collapsed=='left')
				{
					sessionStorage.setItem("borderCollapse", true);
				}
				else
				{
					sessionStorage.setItem("borderCollapse", false);
				}
 			});
		}
	},
	afterAccordionRender:function()
	{

 		if (lastAccessedURL == null || lastAccessedURL == 'null' || lastAccessedURL == '' || lastAccessedURL == undefined)
        {
            if (dashBoardHomeUrl == 'false')
            {
                 this.componentTreeLoad();
            }
            else
            {
                  this.setFrameSource(this.getLoadUrl());
				  this.btmAdvancedSettingPage(this.getLoadUrl());
            }
        }
        else
        {
            if (!Ext.isEmpty(loadKey) && loadKey != 'null')
            {
                this.setFrameSource(this.getLoadUrl());
            }
            else
            {
				var expanedPane=sessionStorage.getItem("expanedPane");
				var nodeId=sessionStorage.getItem("nodeId");
				var isLeafNode=sessionStorage.getItem("isLeafNode");
 				var nodeMode=sessionStorage.getItem("nodeMode");
				var lastAccessedNodeId=sessionStorage.getItem("lastAccessedNodeId");
 				var borderCollapse=sessionStorage.getItem("borderCollapse");

				if(expanedPane!=null)
				{
					if(expanedPane=='function')
					{
						if(isLeafNode=='true')
						{
							this.setFrameSource(lastAccessedURL);
						}
						else
						{
							if(!Ext.isEmpty(lastAccessedNodeId) && lastAccessedNodeId!='null')
								this.refreshCenterRegion(lastAccessedNodeId);
							else
								this.setFrameSource(lastAccessedURL);
						}
					}
					else
					{
						if(!Ext.isEmpty(lastAccessedNodeId) && lastAccessedNodeId!='null')
							this.refreshCenterRegion(lastAccessedNodeId);
						else
							this.setFrameSource(lastAccessedURL);
					}
				}
				else
					this.setFrameSource(lastAccessedURL);
            }
        }
	},
	accordionTreeExpand: function() {
		var startUpPanel='function';
		if (startUpPanel=='function')
		{
			this.getMyLogTreePanel().expand();
		}
		else
		{
			this.getMyLogTreePanel().expand();
		}
    },   
	getLoadUrl: function()
    {
        var loadUrl;
        if (loadKey == '')
        {
			loadUrl = sessionStorage.getItem("firstChildURL");
        }
		return loadUrl;
    },
	setFrameSource:function(sourceURL)
	{
		if (Ext.get('reportFrame')==null)
		{
			var sourceURLIframe = sourceURL;
			var iframeObj = {
				xtype: 'component',
				id: 'reportFrame',
				name: 'reportFrame',
				sourceURL:sourceURLIframe,
				autoEl: {
					tag: 'iframe',
					src: sourceURL
				},
				margin: '-12px',
			};
			this.btmAdvancedSettingPage(sourceURL);
		}
		else
		{
			document.getElementById('reportFrame').src=sourceURL;
		}
	},    
	
	btmAdvancedSettingPage: function(sourceURL)
	{
		var guidValues=sessionStorage.getItem("guidValue");
		var params=sourceURL.split("?");
			Ext.Ajax.request({
            url: 'BTMProfilerDownload/data/BTMLogPropertiesJson.jsp?'+params[1]+"&guidValue="+encodeURIComponent(filterEncode(guidValues)),
            method: 'POST',
            async: false,
            success: function (response) {
				var pageTitle=params[1].split("&")[2].split("=")[1];
				pageTitle=pageTitle.replaceAll("_"," ");
					 Ext.getCmp('mainBTMLogJars').setTitle(pageTitle+comptype);
                if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
                    var jsonText = response.responseText;
                    publicJSON = Ext.decode(jsonText);
					var resultsData = publicJSON['gridLogEntries'];
					if (Ext.isEmpty(resultsData)) {
						var nodata = {
							xtype: 'component',
							html: '<div class="egFlexCenterByColumnWise" style="padding-top:100px;height:100%"><div class="iconExclamation"></div><div  class="commonErrorMsgText">' + NoDataFound + '</div></div>',
							width: '100%',
						flex: 1
						};
						var resultPanelObj = Ext.getCmp('resultpanel');
						resultPanelObj.show();
						resultPanelObj.removeAll();
						resultPanelObj.add(nodata);
						Ext.get("saveProps").hide();
						Ext.get("resetPropsLog").hide();
						
					} else {
					   addGuidLogGridEx(resultsData);
							 if(pageTitle=="Overview"){
							  Ext.get("savePropsLog").hide();
							  Ext.get("resetPropsLog").hide();
							 }
					}
                }
            }
        });
	},
	afterFunctionRender: function()
    {
         var myController=this;
		 Ext.get('ex').on('click', function(event, target, options)
         {
			var myTree = myController.getMyLogTreePanel();
            var node = myTree.getRootNode();
            var toolText = document.getElementById('exx').innerHTML;

            if (toolText.toLowerCase() == 'expand all')
            {
                document.getElementById('exx').innerHTML='Collapse all';
                myTree.expandAll();
            }
            else
            {
                document.getElementById('exx').innerHTML='Expand all';
                myTree.collapseAll();
            }
        });
    },    
	functionTreeLoad: function(treestore, node, records, successful, eOpts)
    {
 		if (successful)
		{			
			var treepanel = this.getMyLogTreePanel();
			this.addNoRecordFoundNode(treepanel,'No logs found');
			this.refreshTreeNodes('function',treestore,treepanel);
			this.setTextForExpandCollpaseTool();
		}
		else
		{
			console.log('Error!... Treestore is not loaded');
		}
    },    
	functionPanelCollapse: function() {
		this.setTextForExpandCollpaseTool();
        var myTree = this.getMyLogTreePanel();
        myTree.collapseAll();
		
    },	
	functionPanelExpand: function() {
		this.setSessionItems('function',null,null,null,null);
		this.setTextForExpandCollpaseTool();
    },
    functionPanelItemClick: function(view, node) {
        if (node.isLeaf()) {
            this.ajaxFunctionNodeUpdate(node);
			this.setSessionItems('function',node.get('id'),true,'expand',null);
			var node_title = node.get('text');
			if(collapseMenu != undefined && collapseMenu.toLowerCase()=='true')
			{
				var westPanel=Ext.getCmp('westRegion');
				westPanel.collapse();
				if (westPanel.collapsed==true || westPanel.collapsed=='left')
				{
					sessionStorage.setItem("borderCollapse", true);
				}
				else
				{
					sessionStorage.setItem("borderCollapse", false);
				}
			}
        }
        else if (node.isExpanded()) {
            node.collapse();
			this.setSessionItems('function',node.get('id'),false,'collapse',null);
			this.setTextForExpandCollpaseTool();
        }
        else {
            node.expand();
			this.setSessionItems('function',node.get('id'),false,'expand',null);
			this.setTextForExpandCollpaseTool();
        }
	
    },	
	functionPanelBeforeExpand:function(node){
		if (appConstants.detectIEVersion!=false)
		{
			if (appConstants.detectIEVersion>9)
			{
				node.set('cls', 'x-grid-tree-node-expanded');
			}
		}
		this.getMyLogTreePanel().getEl().mask("Expanding...", 'x-mask-loading');
	},
	functionPanelAfterExpand:function(node){
		this.getMyLogTreePanel().getEl().unmask();
	},	
	functionPanelBeforeCollapse:function(node){
		this.getMyLogTreePanel().getEl().mask("Collapsing...", 'x-mask-loading');
	},	
	functionPanelAfterCollapse:function(node){
		var me= this;
		if (appConstants.detectIEVersion!=false)
		{
			if (appConstants.detectIEVersion>9)
			{
				setTimeout(function(){
					node.set('cls', 'x-grid-tree-node-collpased');
					me.getMyLogTreePanel().getEl().unmask();
				},100);
			}
		}
		else
		{
			me.getMyLogTreePanel().getEl().unmask();
		}

	}, 
	setSessionItems:function(expanedPane,nodeId,isLeafNode,nodeMode,lastAccessedNodeId)
	{
 		sessionStorage.setItem("expanedPane", expanedPane);
 		sessionStorage.setItem("nodeId", nodeId);
		sessionStorage.setItem("isLeafNode", isLeafNode);
		sessionStorage.setItem("nodeMode", nodeMode);
		if(!Ext.isEmpty(lastAccessedNodeId))
		sessionStorage.setItem("lastAccessedNodeId", lastAccessedNodeId);
	},	
	ajaxFunctionNodeUpdate: function(node)
    {

		var isBaseNode = false;
		var unparsedId = node.get('id');
		if(unparsedId!=null && unparsedId!='undefined'){
			var parsedId = unparsedId.substring(0, unparsedId.indexOf("Mylink_"));
			if (parsedId == "" || parsedId == null)
			{
				return;
			}
			sessionStorage.setItem("borderCollapse", true);
			this.setFrameSource(parsedId);
		}
     },	
	 
savePropsDetails: function () {
		var allelements = document.getElementById('keyIdentityList').value.split(',');
		var guid=sessionStorage.getItem("guidValue");
		var compNickName=sessionStorage.getItem("compNickName");
		var comPort=sessionStorage.getItem("comPort");
		var parentNodeArray='';
		if(sessionStorage.getItem("nodeId")!=null){
			parentNodeArray=sessionStorage.getItem("nodeId").split("?");
		}
		else
		{
			parentNodeArray='/final/admin/EgBTMProfilerDownload.jsp?action=read&parentNode=RUM_Integration&fromPage=RUM_injection_Via_BTM';
			parentNodeArray=parentNodeArray.split("?")
		}
		var parentNodeWithfrompage=parentNodeArray[1].split("My");
		var parentNodeArray2=parentNodeWithfrompage[0].split("&");
		var parentNode='';
		for(var count=0;count<parentNodeArray2.length;count++)
			{
			if(!parentNodeArray2[count].includes('action'))
				{
					parentNode+=parentNodeArray2[count];
				}
			}
		
		parentNodeWithfrompage[0]=parentNodeWithfrompage[0].replaceAll("read","save");
		var params = parentNodeWithfrompage[0]+'&comPort='+comPort+'&compNickName='+compNickName;
		for (var i=0;i<allelements.length;i++){
			if(document.getElementById(allelements[i])!=null ){
				if (document.getElementById(allelements[i]).type === "radio"){
					var enableBusinessTransaction = document.getElementsByName(allelements[i]);
					for(var index=0; index<enableBusinessTransaction.length;index++){
						if(enableBusinessTransaction[index].checked){
							params = params+"&"+allelements[i]+"="+encodeURIComponent(filterEncode(enableBusinessTransaction[index].value));
						}					
					}
				}else{
					if(document.getElementById(allelements[i]).value!=""){
						params = params+"&"+allelements[i]+"="+encodeURIComponent(filterEncode(document.getElementById(allelements[i]).value));
					}else{
						showMsg(plsSelectTxt+" "+allelements[i].replace(/_/gi,' '));
						document.getElementById(allelements[i]).focus();
						return;
					}
					
				}
			}
		}
		if(params.endsWith("&Enable_rum_integration=false")){
			resetPropsJsFn();
		}else{
			var guid=sessionStorage.getItem("guidValue");
			params=params.replace("null",guid);
			
			Ext.get("savePropsLog").hide();
			Ext.Ajax.request({
				url: "BTMProfilerDownload/data/BTMLogPropertiesJson.jsp?"+params,
				method: 'POST',
				async: false,
				success: function (response) {
					var jsonText = response.responseText;
					var restJSON = Ext.decode(jsonText)
					var restJSONData = restJSON['result'];	
					var keys = Object.keys(restJSONData);
					for(var outerCount=0; outerCount<keys.length; outerCount++){
						var key = keys[outerCount];
						if(document.getElementById(key)!=null){
							if(document.getElementById(key).type == "radio" || document.getElementById(key).type == "hidden"){
								var currVariable = document.getElementsByName(key)
								for (innerCount = 0; innerCount < currVariable.length; innerCount++) {
									if (currVariable[innerCount].value==restJSONData[key]) {
										currVariable[innerCount].checked=true;
									}
								}
							}else{
								document.getElementById(key).value = restJSONData[key];
							}
						}
					}	
					showMsg(settingSavedAlert);
					Ext.get("savePropsLog").show();
				}
			});
		}
    },
showSettiongsOption: function(grid, rowIndex, colIndex){
		Ext.widget('treeMainView').show();
		var obj = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
		guidValue = obj.get('GUID');
		sessionStorage.setItem("guidValue", obj.get('GUID'));
		sessionStorage.setItem("compType", obj.get('compType'));
		sessionStorage.setItem("compNickName", obj.get('CompNickName'));
		sessionStorage.setItem("comPort", obj.get('comPort'));
		sessionStorage.setItem("hostIP", obj.get('hostIP'));
    },
resetPropsDetails: function () {
		
		Ext.get("resetPropsLog").hide();
		var parentNodeArray='';
		if(sessionStorage.getItem("nodeId")!=null){
			parentNodeArray=sessionStorage.getItem("nodeId").split("?");
		}
		else
		{
			parentNodeArray='/final/admin/EgBTMProfilerDownload.jsp?action=read&parentNode=RUM_Integration&fromPage=RUM_injection_Via_BTM';
			parentNodeArray=parentNodeArray.split("?")
		}
		
		var parentNodeWithfrompage=parentNodeArray[1].split("My");
		var parentNodeArray2=parentNodeWithfrompage[0].split("&");
		var parentNode='';
		for(var count=0;count<parentNodeArray2.length;count++)
			{
			if(!parentNodeArray2[count].includes('action'))
				{
					parentNode+=parentNodeArray2[count];
				}
			}
		
		var guid=sessionStorage.getItem("guidValue");
		var paramsValue=parentNodeWithfrompage[0].replaceAll("read","reset");
		
		var params = "&"+paramsValue+'&comPort='+comPort+'&compNickName='+compNickName+'&guidValue='+encodeURIComponent(filterEncode(guid));
		
		Ext.Ajax.request({
			url: "BTMProfilerDownload/data/BTMLogPropertiesJson.jsp?"+params,
			method: 'POST',
			async: false,
			success: function (response) {
				var jsonText = response.responseText;
				var restJSON = Ext.decode(jsonText)
				var restJSONData = restJSON['result'];
				var keys = Object.keys(restJSONData);
				var restRum=false;
				var restSampling=false;
				for(var outerCount=0; outerCount<keys.length; outerCount++){
					var key = keys[outerCount];
					if(key=="Enable_rum_integration"){
						restRum=true;
					}
					if(key=="Enable_Diagnostic_Session"){
						restSampling=true;
					}
					if(document.getElementById(key)!=null){
						if(document.getElementById(key).type == "radio"){
							var currVariable = document.getElementsByName(key)
							for (innerCount = 0; innerCount < currVariable.length; innerCount++) {
								if (currVariable[innerCount].value==restJSONData[key]) {
									currVariable[innerCount].checked=true;
								}
							}
						}else{
							document.getElementById(key).value = restJSONData[key];
						}
					}
				}
				Ext.get("resetPropsLog").show();
				 if(restRum){
					 restRum.value=false;
					 clearRumIntegrationFilter(restRum);
					 Ext.getCmp("savePropsLog").setDisabled(true);
					 Ext.getCmp("resetPropsLog").setDisabled(true);
				 }
				 if(restSampling)
				 {
					 restSampling.value=false;
					 clearDiagnosticSession(restSampling);
					 Ext.getCmp("savePropsLog").setDisabled(true);
					 Ext.getCmp("resetPropsLog").setDisabled(true); 
				 }
				 showMsg(settingSavedAlert);
			}
		});
	
    },

	 setTextForExpandCollpaseTool:function(){
		var childNodes=this.getMyLogTreePanel().getRootNode().childNodes;
 		var allCollapseFlag=0;
		for (var key in childNodes)
		{
			if (childNodes[key].isExpanded())
			{
				allCollapseFlag++;
			}
		}
		childNodes=null; delete childNodes;
 		if (allCollapseFlag>2)
		{
			document.getElementById('exx').innerHTML='Collapse all';
		}
		else
		{
			document.getElementById('exx').innerHTML='Expand all';
		}
	},

});

function hideGuids() {
    Ext.getCmp('DispMonitoring').show();
    Ext.getCmp('DispAgentIP').show();

    Ext.getCmp('DispTierName').show();
    Ext.getCmp('DispappName').show();
    Ext.getCmp('DispGuid').hide();
    Ext.getCmp('showGuid').setText('Show GUIDs');
}

function splitSnippet(nodeScript) {		
	var rplcText = "";
	var snipscrpt = "";
	var splitscript = nodeScript.split('\\r\\n');
	for (var i = 0; i < splitscript.length; i++)
	{
		nscript = splitscript[i].replace(/\\/g, '');
		rplcText = nscript.replaceAll("+", "/");
		snipscrpt = snipscrpt+rplcText+"\r\n";
	}
   return snipscrpt;
}

function changeEghomedir (scripts, eghomedir){
	var changeScript = scripts.replaceAll("eg-node-monitor", eghomedir);
	return changeScript;
}

function addGuidGridEx(dataToRender) {

    var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
            selType: 'checkboxmodel',
            mode: 'MULTI',
            checkOnly: true,
            renderer: function (val, meta, record, rowIndex, colIndex, store, view) {
                if (record.get('isDisabled')) {
                    meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
                    return '<div class="iconLock" style="position:relative;left:-5px">&#160;</div>';
                } else {
                    meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
                    return '<div class="' + Ext.baseCSSPrefix + 'grid-row-checker">&#160;</div>';
                }
            },
            selectAll: function () {
                var rowIndex = 0;
                while (typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex)) != 'undefined') {
                    var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
                    if (record.get('isDisabled')) {
                        Ext.getCmp('mainBTMJarsgrid').getSelectionModel().deselect(rowIndex, true);
                    } else {
                        Ext.getCmp('mainBTMJarsgrid').getSelectionModel().select(rowIndex, true);
                    }
                    rowIndex++;
                }
                var view = Ext.getCmp('mainBTMJarsgrid').getView();
                var headerCt = view.headerCt;
                var hdSelectStatus = this.selected.getCount() === this.store.getCount();
                var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
                if (checkHd) {
                    checkHd.el.addCls(Ext.baseCSSPrefix + 'grid-hd-checker-on');
                }
            },
            deselectAll: function () {
                var rowIndex = 0;
                while (typeof(Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex)) != 'undefined') {
                    var record = Ext.getCmp('gridRmtDisplay').getStore().getAt(rowIndex);
                    Ext.getCmp('mainBTMJarsgrid').getSelectionModel().deselect(rowIndex, true);
                    rowIndex++;
                }
                var view = Ext.getCmp('mainBTMJarsgrid').getView();
                var headerCt = view.headerCt;
                var hdSelectStatus = this.selected.getCount() === this.store.getCount();
                var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
                if (checkHd) {
                    checkHd.el.removeCls(Ext.baseCSSPrefix + 'grid-hd-checker-on');
                }
            }
        });

    var gridpanel = Ext.widget('btmjargrid', {
            store: new Ext.data.Store({
                fields: ['APMName', 'monitoring', 'appName', 'tierName', 'compType', 'offloadMode', 'CompNickName', 'hostIP', 'comPort', 'agentIP', 'AssoDissRemAgnt', 'internalRemAgent', 'isDisabled', 'GUID' ,'egServerType','nodejsScript','typeScript','option2','option3','option4'],
                data: dataToRender,
                proxy: {
                    type: "pagingmemory",
                    reader: {
                        type: "json"
                    }
                },
                id: 'gridRmtDisplay',
                remoteFilter: true,
                remoteSort: true,
                autoLoad: true,
                pageSize: 30,
                simpleSortMode: true
            }),
            selModel: mySelectionModel,
            viewConfig: {
                forceFit: true,
                stripeRows: true,
                deferEmptyText: true
            },
            sortOnLoad: true,
            sortInfo: {
                property: 'APMName',
                direction: 'DESC'
            },
        });

    var resultPanelObj = Ext.getCmp('resultpanel');
    resultPanelObj.show();
    resultPanelObj.removeAll();
    resultPanelObj.add(gridpanel);
}

function addGuidLogGridEx(dataToRender) {
    var gridpanel = Ext.widget('btmlogjargrid', {
            store: new Ext.data.Store({
                fields: ['propName', 'propValue', 'propDesc'],
                data: dataToRender,
                proxy: {
                    type: "pagingmemory",
                    reader: {
                        type: "json"
                    }
                },
                id: 'gridLogEntryDisplay',
				listeners:{
					load:function(a,b){
						console.log("b[0] : ",b[0])
						if(b[0].data.propName.indexOf("Enable RUM injection")!=-1 && b[0].data.propValue.indexOf("checked value=\"false\"")!=-1){
							a.remove(b[1]);
							a.remove(b[2]);
							a.remove(b[3]);
							Ext.getCmp("savePropsLog").setDisabled(true);
							Ext.getCmp("resetPropsLog").setDisabled(true);
						}
						else
						{
							a.remove(b[1]);
							a.remove(b[2]);
							a.remove(b[3]);
							Ext.getCmp("savePropsLog").setDisabled(false);
							Ext.getCmp("resetPropsLog").setDisabled(false);
						}
						
						if(b[0].data.propName.indexOf("Inject RUM script via BTM")!=-1 && b[0].data.propValue.indexOf("checked value=\"true\"")!=-1){
							Ext.getCmp("savePropsLog").setDisabled(false);
							Ext.getCmp("resetPropsLog").setDisabled(false);
						}
						
						if(b[0].data.propName.indexOf("Enable Diagnostic Session")!=-1 && b[0].data.propValue.indexOf("checked value=\"false\"")!=-1){
							a.remove(b[1]);
							a.remove(b[2]);
							a.remove(b[3]);
							a.remove(b[4]);
							a.remove(b[5]);
							a.remove(b[6]);
							a.remove(b[7]);
							a.remove(b[8]);
							Ext.getCmp("savePropsLog").setDisabled(true);
							Ext.getCmp("resetPropsLog").setDisabled(true);
						}
					}
				},
                remoteFilter: true,
                remoteSort: true,
                autoLoad: true,
                pageSize: dataToRender.length,
                simpleSortMode: true
            }),
        });

    var resultPanelObj = Ext.getCmp('resultpanellog');
    resultPanelObj.show();
    resultPanelObj.removeAll();
    resultPanelObj.add(gridpanel);
}

function filterEncode(text)
{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','&','%','\'',';','\\','"'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|ampsnd|','|per|','|squot|','|scol|','|slash|','|dqt|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e){
		}
		return text;
}

function clearRumIntegrationFilter(data){
	var resultsData = publicJSON['gridLogEntries'];
	var grid = Ext.getCmp('mainBTMLogJarsgrid');
	if(data.value=="true"){
		grid.store.add(resultsData[1]);
		grid.store.add(resultsData[2]);
		Ext.getCmp("savePropsLog").setDisabled(false);
		Ext.getCmp("resetPropsLog").setDisabled(false);
		data.checked = true;	
	}else{
		grid.store.removeAt(3);
		grid.store.removeAt(2);
		grid.store.removeAt(1);
		var valueCheck = JSON.stringify(resultsData[2]).replace(/\\\"/g, "");
		if(valueCheck.indexOf("id=Inject_rum_script_via_btm autocomplete=off  checked  value=true")==-1){
			Ext.getCmp("savePropsLog").setDisabled(true);
			Ext.getCmp("resetPropsLog").setDisabled(true);
		}else{
			Ext.getCmp("savePropsLog").setDisabled(false);
			Ext.getCmp("resetPropsLog").setDisabled(false);
			var container = document.getElementById("mainBTMLogJarsgrid");
			var hiddenField = document.createElement('input');
			hiddenField.setAttribute('type','hidden');
			hiddenField.setAttribute('id','keyIdentityList');
			hiddenField.setAttribute('name','keyIdentityList');
			hiddenField.setAttribute('value','Enable_rum_integration,guidValue');
			container.appendChild(hiddenField);
		}
	}
}
function clearDiagnosticSession(data){
	var resultsData = publicJSON['gridLogEntries'];
	var grid = Ext.getCmp('mainBTMLogJarsgrid');

	if(data.value=="true"){
		grid.store.add(resultsData[1]);
		grid.store.add(resultsData[2]);
		grid.store.add(resultsData[3]);
		grid.store.add(resultsData[4]);
		grid.store.add(resultsData[5]);
		grid.store.add(resultsData[6]);
		grid.store.add(resultsData[7]);
		grid.store.add(resultsData[8]);
		Ext.getCmp("savePropsLog").setDisabled(false);
		Ext.getCmp("resetPropsLog").setDisabled(false);
		data.checked = true;	
	}else{
		var valueCheck = JSON.stringify(resultsData[0]).replace(/\\\"/g, "");
		if(valueCheck.indexOf("id=Enable_Diagnostic_Session autocomplete=off  checked  value=true")==-1){
		grid.store.removeAt(8);
		grid.store.removeAt(7);
		grid.store.removeAt(6);
		grid.store.removeAt(5);
		grid.store.removeAt(4);
		grid.store.removeAt(3);
		grid.store.removeAt(2);
		grid.store.removeAt(1);
		Ext.getCmp("savePropsLog").setDisabled(true);
		Ext.getCmp("resetPropsLog").setDisabled(true);
		var container = document.getElementById("mainBTMLogJarsgrid");
		var hiddenField = document.createElement('input');
		hiddenField.setAttribute('type','hidden');
		hiddenField.setAttribute('id','keyIdentityList');
		hiddenField.setAttribute('name','keyIdentityList');
		hiddenField.setAttribute('value','Enable_Diagnostic_Session,guidValue');
		container.appendChild(hiddenField);
		}
	}
	
}

function showHideInjectRumScript(data){
	var resultsData = publicJSON['gridLogEntries'];
	var grid = Ext.getCmp('mainBTMLogJarsgrid');
	if(data.value=="true"){
		data.checked = true;
		grid.store.add(resultsData[3]);
		Ext.getCmp("savePropsLog").setDisabled(false);
		Ext.getCmp("resetPropsLog").setDisabled(false);
	}else{
		grid.store.removeAt(3);
		Ext.getCmp("savePropsLog").setDisabled(true);
		Ext.getCmp("resetPropsLog").setDisabled(true);
	}
}

function showMsg(alertInfo){
	Ext.Msg.show({
	title: advanceSettingsTxt,
	msg:alertInfo,
	buttons: Ext.Msg.OK,
	icon: 'iconExclamation',
		fn: function(){
			
		}
	});
}