Ext.define('BTMProfilerDownload.view.BTMLogJarGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.btmlogjargrid',
    id: 'mainBTMLogJarsgrid',
    ui: 'newGridPanel',
    emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">' + NoDataFound + '</td></tr></table></td></tr></table>',
    requires: [
        'Ext.ux.RowExpander',
        'Ext.grid.*',
        'utilities.CustomGrid',
        'Ext.ux.data.PagingMemoryProxy',
    ],
    viewConfig: {
        deferEmptyText: true
    },
    margin: '10 0 10 10',
    cls: 'outerpanel',
    initComponent: function () {
        this.callParent();
    },
    tools: [],
    dockedItems: [
	
					{ 	xtype: 'container',
						dock:"bottom",
						margin: '20 0 0 5',
						layout: {
						type: 'hbox',
						align: 'center',
						pack: 'center',
						defaultMargins: 5
						},
					items: [{
							xtype: 'button',
							ui:'newButtonSmall',
							margin: '0 0 0 5',
							text: 'Save',
							id: 'savePropsLog',
							name:'savePropsLog',
						},{
							xtype: 'button',
							ui:'newButtonSmall',
							margin: '0 0 0 5',
							text: 'Reset',
							id: 'resetPropsLog',
							name: 'resetPropsLog',
					}]}],
    columns: [{
			header: '<div style="height:23px;margin-top:9px">Name</div>',
            text: 'nameTxt',
			dataIndex: 'propName',
			id: 'LogAPMName',
            flex: 0.4,
        }, {
			header: '<div style="height:23px;margin-top:9px">Value</div>',
            text: 'valueTxt',
			dataIndex: 'propValue',
            id: 'LogCompType',
            flex: 0.6,
        }, {
			header: '<div style="height:23px;margin-top:9px">Description</div>',
            text: 'descriptionTxt',
            dataIndex: 'propDesc',
            id: 'LogCompNickName',
            flex: 0.3,
			renderer: function (value, metaData, record, row, col, store, gridView) {
				 return '<div style="white-space:normal;">' + value + '</div>';
			}
      }
    ]
});