<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="java.text.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	String username = (String)session.getAttribute("usernameForRC");
	username = StringUtils.decodeSecurityChar(username);
	String selectedCompType = request.getParameter("compType");
	selectedCompType = (selectedCompType == null  || selectedCompType.trim().length()==0 ||  selectedCompType.trim().equalsIgnoreCase("null")) ? "-1" : selectedCompType;
	boolean isValidUser = username != null && (username=username.trim()).length()>0 &&
		!username.equalsIgnoreCase("null") && !username.equalsIgnoreCase("-1") &&
		!username.equalsIgnoreCase("egenterprise");
	String defaultSelType = isValidUser ? "Select a component type" : "Not Applicable";
	boolean isComponentsAssociated=false;
	JSONArray rcCompTypes = new JSONArray();
	JSONObject rcCompTypeObj = new JSONObject();
	rcCompTypeObj.put("displayField",_mapping.getTextDescription("admin.remote."+defaultSelType));
	rcCompTypeObj.put("valueField","-1");
	rcCompTypes.add(rcCompTypeObj);
	Vector virtualization_platforms=null;
	IniFile uiIni=null;
	boolean isCompTypeFound=false;
	boolean findHypervisorComps=false;
	ArrayList windowsAndLinuxVMsAvailable=new ArrayList();
	windowsAndLinuxVMsAvailable.add("Xen_desktop_server");//=Citrix Hypervisor - VDI
	windowsAndLinuxVMsAvailable.add("KVM_vdi_server");//=KVM VDI
	windowsAndLinuxVMsAvailable.add("HyperV_VDI_server");//=Microsoft Hyper-V VDI
	windowsAndLinuxVMsAvailable.add("Nutanix_Acropolis_Vdi");//=Nutanix Acropolis VDI
	windowsAndLinuxVMsAvailable.add("Oracle_vdi");//=Oracle VDI Broker
	windowsAndLinuxVMsAvailable.add("Redhat_linux_vdi");//=RHEV Hypervisor - VDI
	windowsAndLinuxVMsAvailable.add("VmVdi_i_server");//=VMware vSphere VDI
	boolean hybridVmsAvailable=windowsAndLinuxVMsAvailable.contains(selectedCompType);
	ErUserData userData = null;
	if(isValidUser)
	{
		userData = new ErUserData(username,false);
		IniFile egInfra=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini");
		virtualization_platforms=egInfra.getVariables("VIRTUALIZATION_PLATFORMS",true);
		uiIni=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");

		Hashtable order = new Hashtable();
		Vector serverTypesForUser = userData.getServerTypes();
		User userObj = userData.getUser(username);
		List vmTypes=userObj.getUserVMServers(false,true);
		Set allComTypes=new TreeSet();
		if(serverTypesForUser != null && !serverTypesForUser.isEmpty())
		{
			allComTypes.addAll(serverTypesForUser);
		}
		if(vmTypes != null && !vmTypes.isEmpty())
		{
			int starIndex=vmTypes.indexOf("*all*");
			if(starIndex>-1)
			{
				findHypervisorComps=true;
				vmTypes.remove(starIndex);
				List hyperTypes = getAllAssigendHypervisorTypes();
				if(hyperTypes != null && !hyperTypes.isEmpty())
				{
					allComTypes.addAll(hyperTypes);
				}
			}
			if(vmTypes != null && !vmTypes.isEmpty())
			{
				allComTypes.addAll(vmTypes);
			}
		}
		if(allComTypes != null)
		{
			int serverCount=allComTypes.size();
			Iterator itr=allComTypes.iterator();
			while(itr.hasNext())
			{
				isComponentsAssociated=true;
				String compType = (String)itr.next();
				if(compType.startsWith("Agg_"))
				{
					continue;
				}
				if(compType.equalsIgnoreCase(selectedCompType))
				{
					isCompTypeFound=true;
				}
				order.put(_mapping.getComponentTypeDescription(compType),compType);
			}
		}
		int serverCount=order.size();
		ArrayList lablesInOrder=new ArrayList();
		lablesInOrder.addAll(order.keySet());
		Collections.sort(lablesInOrder,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<serverCount;i++)
		{
			String label = (String)lablesInOrder.get(i);
			String compType = (String)order.get(label);
			rcCompTypeObj.put("displayField",_mapping.getComponentTypeDescription(compType));
			rcCompTypeObj.put("valueField",compType);
			rcCompTypes.add(rcCompTypeObj);
		}
	}
	rootJson.put("rcCompTypes",rcCompTypes);
	if(!isCompTypeFound)
	{
		selectedCompType="-1";
	}
	JSONArray associated_commands = new JSONArray();
	JSONArray associatedCommandsObj = new JSONArray();
	JSONArray allCommandsObj = new JSONArray();
	JSONObject allCmdObj = new JSONObject();

	String checkEnabledTasks = "";
	String checkDisabledTasks = "";
	if(isValidUser && !selectedCompType.equalsIgnoreCase("-1"))
	{
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		EgExternalInfo extInfo = new EgExternalInfo("manager");

		IniFile userCommandsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_usercommands.ini");
		ArrayList permittedCommandIds = new ArrayList();
		String alreadyPermittedOsCmds = null;
		String existRcEntry = userCommandsIni.getValue("ALLOWED_COMMANDS",username);
		if(existRcEntry != null && (existRcEntry = existRcEntry.trim()).length() >0 && existRcEntry.indexOf("#") >-1)
		{
			alreadyPermittedOsCmds = existRcEntry.substring(existRcEntry.indexOf("#")+1);
		}

		if(alreadyPermittedOsCmds != null && (alreadyPermittedOsCmds=alreadyPermittedOsCmds.trim()).length()>0 && !alreadyPermittedOsCmds.equalsIgnoreCase("null"))
		{
			boolean found=false;
			String searchKey=","+selectedCompType+"|";
			String array[]=StringUtils.getTokens(alreadyPermittedOsCmds,"#");
			for(int i=0;i<array.length;i++)
			{
				String str=","+array[i];
				if(str.startsWith(searchKey))
				{
					str=array[i];
					alreadyPermittedOsCmds=str.substring(str.indexOf("|")+1);
					found=true;
				}
			}
			if(found)
			{
				permittedCommandIds = StringUtils.myTokenizer(alreadyPermittedOsCmds,",");
			}
			if(permittedCommandIds == null)
			{
				permittedCommandIds = new ArrayList();
			}
		}
		Set uniqueOSNames=new TreeSet();
		String key=selectedCompType+":";
		List userServers=null;
		if(userData !=null)
		{
			userServers=userData.usr.getServers(false);
		}
		if(findHypervisorComps)
		{
			EgDiscInfo discIni = new EgDiscInfo(EgConstants.MANAGER);
			String hyperComps[]=discIni.getAllServersOfType(selectedCompType);
			if(hyperComps != null && hyperComps.length>0)
			{
				if(userServers==null)
				{
					userServers = Arrays.asList(hyperComps);
				}
				else
				{
					userServers.addAll(Arrays.asList(hyperComps));
				}
			}
		}
		if(userServers != null)
		{
			EgExternalInfo e = new EgExternalInfo("manager");
			Iterator itr = userServers.iterator();
			while(itr.hasNext())
			{
				String hostName = (String)itr.next();
				if(hostName.startsWith(key))
				{
					int idx=hostName.indexOf(":");
					String compType=hostName.substring(0,idx);
					String agentOS = null;
					if(compType.equalsIgnoreCase("WVD_RDS_server"))
					{
						agentOS="Windows";
					}
					else
					{
						hostName=hostName.substring(idx+1);
						hostName=hostName.substring(0,hostName.indexOf(":"));

						boolean isAgentBased=isServerAgentBased(hostName,compType,specsInfo,extInfo);
						String internalAgentHostName = e.getAgentFor(hostName,true);
						if(internalAgentHostName == null || internalAgentHostName.trim().length()==0 || internalAgentHostName.trim().equalsIgnoreCase("null"))
						{
							internalAgentHostName=hostName;
						}
						if(isAgentBased)
						{
							agentOS = AgentConfig.getAgentConfig().getAgentOS(internalAgentHostName);
						}
						else
						{
							String rmtOrExtAgentIp = null;
							String remoteAgent = e.getRemoteAgentForHost(hostName);
							if(!StringUtils.isNull(remoteAgent))
							{
								rmtOrExtAgentIp = remoteAgent;
							}
							else
							{
								String[] externalAgentsArr = e.getExternalAgentsForHost(hostName);
								if(externalAgentsArr != null)
								{
									String externalAgent = externalAgentsArr[0];
									if(externalAgent != null && !(externalAgent.trim().equals("")))
									{
										rmtOrExtAgentIp = externalAgent;
									}
								}
							}
							if(!StringUtils.isNull(rmtOrExtAgentIp))
							{
								agentOS = AgentConfig.getAgentConfig().getAgentOS(rmtOrExtAgentIp);
							}
						}
					}
					if(agentOS == null)
					{
						continue;
					}
					if(agentOS.toUpperCase().indexOf("AIX")>-1)
					{
						uniqueOSNames.add("AIX");
					}
					else if(agentOS.toUpperCase().indexOf("HPUX")>-1)
					{
						uniqueOSNames.add("HPUX");
					}
					else if(agentOS.toUpperCase().indexOf("LINUX")>-1)
					{
						uniqueOSNames.add("Linux");
					}
					else if(agentOS.toUpperCase().indexOf("SOLARIS")>-1)
					{
						uniqueOSNames.add("Solaris");
					}
					else if(agentOS.toUpperCase().indexOf("WINDOWS")>-1)
					{
						uniqueOSNames.add("Windows");
					}
				}
			}
		}
		boolean windowsOSAvailable=uniqueOSNames.contains("Windows");
		boolean linuxOSAvailable=uniqueOSNames.contains("Linux");
		boolean linuxVmAdded=false;
		boolean windowsVmAdded=false;
		Hashtable uniqueLabelsForUI=new Hashtable();
		String osname[]=(String[])uniqueOSNames.toArray(new String[uniqueOSNames.size()]);
		for(int i=0;i<osname.length;i++)
		{
			uniqueLabelsForUI.clear();
			Hashtable cmdMap = new Hashtable();
			String thisOS=osname[i];
			int appendSpace=0;
			if(thisOS.equalsIgnoreCase("AIX"))
			{
				appendSpace=1;
			}
			else if(thisOS.equalsIgnoreCase("HPUX"))
			{
				appendSpace=2;
			}
			else if(thisOS.equalsIgnoreCase("Linux"))
			{
				appendSpace=3;
			}
			else if(thisOS.equalsIgnoreCase("Solaris"))
			{
				appendSpace=4;
			}
			else if(thisOS.equalsIgnoreCase("Windows"))
			{
				appendSpace=5;
			}
			String groupName=thisOS+" Operating System";
			String subject=thisOS.toUpperCase()+"_COMMANDS";
			Vector cmdIds = uiIni.getVariables(subject,true);
			Vector cmdLabels = uiIni.getAllValues(subject);
			if(cmdLabels != null)
			{
				for(int j=0;j<cmdLabels.size();j++)
				{
					String str = (String)cmdLabels.get(j);
					int pipe_idx = str.indexOf("|");
					if(pipe_idx<0)
					{
						continue;
					}
					str = str.substring(0,pipe_idx);
					cmdLabels.set(j,str);
					uniqueLabelsForUI.put(str,str);
				}
			}
			if(cmdIds != null)
			{
				int cmdCount = cmdIds.size();
				for(int j=0;j<cmdCount;j++)
				{
					String cmdId = (String)cmdIds.get(j);
					String cmdLabel =(String)cmdLabels.get(j);
					cmdMap.put(cmdLabel,cmdId);
				}
			}
			List cmdList = new ArrayList(cmdMap.keySet());
			Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
			Iterator itr = cmdList.iterator();
			while(itr.hasNext())
			{
				String displayCmd = (String)itr.next();
				String actualCmd = (String)cmdMap.get(displayCmd);
				for(int s=0;s<appendSpace;s++)
				{
					displayCmd+=" ";
				}
				allCmdObj.put("displayField",displayCmd);
				allCmdObj.put("valueField",actualCmd);
				allCmdObj.put("groupField",groupName);
				if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
				{
					checkDisabledTasks += ","+actualCmd;
					allCommandsObj.add(allCmdObj);
				}
				else if(permittedCommandIds.contains(actualCmd))
				{
					checkEnabledTasks += ","+actualCmd;
					associated_commands.add(actualCmd);
					associatedCommandsObj.add(allCmdObj);
				}
			}
			if(subject.equalsIgnoreCase("WINDOWS_COMMANDS"))
			{
				Vector cmdIds1 = uiIni.getVariables("WINDOWS_RCA_COMMANDS",true);
				Vector cmdLabels1 = uiIni.getAllValues("WINDOWS_RCA_COMMANDS");
				if(cmdIds1 != null && !cmdIds1.isEmpty())
				{
					List alreadyAddedCmdList = new ArrayList(cmdMap.keySet());
					cmdMap.clear();
					cmdIds.clear();
					cmdLabels.clear();
					for(int j=0;j<cmdLabels1.size();j++)
					{
						String str = (String)cmdLabels1.get(j);
						int pipe_idx = str.indexOf("|");
						if(pipe_idx<0)
						{
							continue;
						}
						str = str.substring(0,pipe_idx);
						if(!cmdLabels.contains(str))
						{
							cmdIds.add(cmdIds1.get(j));
							if(uniqueLabelsForUI.containsKey(str))
							{
								str=(String)uniqueLabelsForUI.get(str);
								String updatedStr=str+" ";
								uniqueLabelsForUI.put(str,updatedStr);
								str=updatedStr;
							}
							cmdLabels.add(str);
							cmdMap.put(str,cmdIds1.get(j));
						}
					}
					cmdList = new ArrayList(cmdMap.keySet());
					Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
					itr = cmdList.iterator();
					while(itr.hasNext())
					{
						String displayCmd = (String)itr.next();
						if(alreadyAddedCmdList.contains(displayCmd))
						{
							continue;
						}
						String actualCmd = (String)cmdMap.get(displayCmd);
						allCmdObj.put("displayField",displayCmd);
						allCmdObj.put("valueField",actualCmd);
						allCmdObj.put("groupField",groupName);

						if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
						{
							checkDisabledTasks += ","+actualCmd;
							allCommandsObj.add(allCmdObj);
						}
						else if(permittedCommandIds.contains(actualCmd))
						{
							checkEnabledTasks += ","+actualCmd;
							associated_commands.add(actualCmd);
							associatedCommandsObj.add(allCmdObj);
						}
					}
					alreadyAddedCmdList.clear();
					alreadyAddedCmdList=null;
				}
			}
			Set groupWiseShow=new TreeSet();
			Set compTypeSpecifcTasks=new TreeSet();
			if(subject.equalsIgnoreCase("WINDOWS_COMMANDS"))
			{
				Vector vars = uiIni.getVariables("COMP_TYPE_TEST_NAME_RC",true);
				Vector vals = uiIni.getAllValues("COMP_TYPE_TEST_NAME_RC");
				if(vars != null && !vars.isEmpty())
				{
					for(int j=0;j<vars.size();j++)
					{
						String str = (String)vars.get(j);
						if(str.startsWith(key))
						{
							String val=(String)vals.get(j);
							String arr[]=StringUtils.getTokens(val,",");
							if(str.endsWith("#GP_1"))
							{
								groupWiseShow.addAll(Arrays.asList(arr));
							}
							else
							{
								compTypeSpecifcTasks.addAll(Arrays.asList(arr));
							}
						}
					}
				}
				if(!compTypeSpecifcTasks.isEmpty())
				{
					String compTypeLabel=_mapping.getComponentTypeDescription(selectedCompType);
					Vector cmdIds2 = uiIni.getVariables("WINDOWS_COMMANDS_REMOTE_CONTROL",true);
					Vector cmdLabels2 = uiIni.getAllValues("WINDOWS_COMMANDS_REMOTE_CONTROL");
					if(cmdIds2 != null && !cmdIds2.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels2.size();j++)
						{
							String cmdIdNow = (String)cmdIds2.get(j);
							if(!compTypeSpecifcTasks.contains(cmdIdNow))
							{
								continue;
							}
							String str = (String)cmdLabels2.get(j);
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds2.get(j));
								if(uniqueLabelsForUI.containsKey(str))
								{
									str=(String)uniqueLabelsForUI.get(str);
									String updatedStr=str+" ";
									uniqueLabelsForUI.put(str,updatedStr);
									str=updatedStr;
								}
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds2.get(j));
							}
						}
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd);
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField",compTypeLabel);
							if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
							{
								checkDisabledTasks += ","+actualCmd;
								allCommandsObj.add(allCmdObj);
							}
							else if(permittedCommandIds.contains(actualCmd))
							{
								checkEnabledTasks += ","+actualCmd;
								associated_commands.add(actualCmd);
								associatedCommandsObj.add(allCmdObj);
							}
						}
					}
				}
				if(!groupWiseShow.isEmpty())
				{
					String compTypeLabel="User/Session";
					Vector cmdIds2 = uiIni.getVariables("WINDOWS_COMMANDS_REMOTE_CONTROL",true);
					Vector cmdLabels2 = uiIni.getAllValues("WINDOWS_COMMANDS_REMOTE_CONTROL");
					if(cmdIds2 != null && !cmdIds2.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels2.size();j++)
						{
							String cmdIdNow = (String)cmdIds2.get(j);
							if(!groupWiseShow.contains(cmdIdNow))
							{
								continue;
							}
							String str = (String)cmdLabels2.get(j);
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds2.get(j));
								if(uniqueLabelsForUI.containsKey(str))
								{
									str=(String)uniqueLabelsForUI.get(str);
									String updatedStr=str+" ";
									uniqueLabelsForUI.put(str,updatedStr);
									str=updatedStr;
								}
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds2.get(j));
							}
						}
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd);
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField",compTypeLabel);
							if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
							{
								checkDisabledTasks += ","+actualCmd;
								allCommandsObj.add(allCmdObj);
							}
							else if(permittedCommandIds.contains(actualCmd))
							{
								checkEnabledTasks += ","+actualCmd;
								associated_commands.add(actualCmd);
								associatedCommandsObj.add(allCmdObj);
							}
						}
					}
				}
			}
			if(virtualization_platforms.contains(selectedCompType))
			{
				if(!windowsVmAdded && ((windowsOSAvailable && thisOS.equals("Windows")) || (!windowsOSAvailable && hybridVmsAvailable)))
				{
					windowsVmAdded=true;
					Vector cmdIds1 = uiIni.getVariables("WINDOWS_VMAGENT_COMMANDS",true);
					Vector cmdLabels1 = uiIni.getAllValues("WINDOWS_VMAGENT_COMMANDS");
					if(cmdIds1 != null && !cmdIds1.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels1.size();j++)
						{
							String str = (String)cmdLabels1.get(j);
							int pipe_idx = str.indexOf("|");
							if(pipe_idx<0)
							{
								continue;
							}
							str = str.substring(0,pipe_idx);
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds1.get(j));
								if(uniqueLabelsForUI.containsKey(str))
								{
									str=(String)uniqueLabelsForUI.get(str);
									String updatedStr=str+" ";
									uniqueLabelsForUI.put(str,updatedStr);
									str=updatedStr;
								}
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds1.get(j));
							}
						}
						ArrayList userSession_1=new ArrayList();
						ArrayList userSession_2=new ArrayList();
						ArrayList allCommands_3=new ArrayList();
						ArrayList associatedCommands_3=new ArrayList();
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd+"      ");
							allCmdObj.put("valueField",actualCmd);
							boolean userSessionTask=false;
							if(actualCmd.equals("WV26") || actualCmd.equals("WV27") || actualCmd.equals("WV28") || actualCmd.equals("WV29") || actualCmd.equals("WV32"))
							{
								userSession_1.add(displayCmd);
								userSession_2.add(actualCmd);
								userSessionTask=true;
							}
							else
							{
								allCmdObj.put("groupField","Windows VM Agent");
							}
							if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
							{
								checkDisabledTasks += ","+actualCmd;
								if(userSessionTask)
								{
									allCommands_3.add(actualCmd);
								}
								else
								{
									allCommandsObj.add(allCmdObj);
								}
							}
							else if(permittedCommandIds.contains(actualCmd))
							{
								checkEnabledTasks += ","+actualCmd;
								associated_commands.add(actualCmd);
								if(userSessionTask)
								{
									associatedCommands_3.add(actualCmd);
								}
								else
								{
									associatedCommandsObj.add(allCmdObj);
								}
							}
						}
						int ucount=userSession_1.size();
						for(int m=0;m<ucount;m++)
						{
							String displayCmd = (String)userSession_1.get(m);
							String actualCmd = (String)userSession_2.get(m);
							allCmdObj.put("displayField",displayCmd+"      ");
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField","Windows VM Agent - User/Session");
							if(allCommands_3.contains(actualCmd))
							{
								allCommandsObj.add(allCmdObj);
							}
							else if(associatedCommands_3.contains(actualCmd))
							{
								associatedCommandsObj.add(allCmdObj);
							}
						}
						userSession_1.clear();
						userSession_2.clear();
						allCommands_3.clear();
						associatedCommands_3.clear();
					}
				}
				if(!linuxVmAdded && ((linuxOSAvailable && thisOS.equals("Linux")) || (!linuxOSAvailable && hybridVmsAvailable)))
				{
					linuxVmAdded=true;
					Vector cmdIds1 = uiIni.getVariables("LINUX_VMAGENT_COMMANDS",true);
					Vector cmdLabels1 = uiIni.getAllValues("LINUX_VMAGENT_COMMANDS");
					if(cmdIds1 != null && !cmdIds1.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels1.size();j++)
						{
							String str = (String)cmdLabels1.get(j);
							str = str.substring(0,str.indexOf("|"));
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds1.get(j));
								if(uniqueLabelsForUI.containsKey(str))
								{
									str=(String)uniqueLabelsForUI.get(str);
									String updatedStr=str+" ";
									uniqueLabelsForUI.put(str,updatedStr);
									str=updatedStr;
								}
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds1.get(j));
							}
						}
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd+"       ");
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField","Linux VM Agent");
							if(permittedCommandIds.isEmpty() || (!permittedCommandIds.isEmpty() && !permittedCommandIds.contains(actualCmd)))
							{
								checkDisabledTasks += ","+actualCmd;
								allCommandsObj.add(allCmdObj);
							}
							else if(permittedCommandIds.contains(actualCmd))
							{
								checkEnabledTasks += ","+actualCmd;
								associated_commands.add(actualCmd);
								associatedCommandsObj.add(allCmdObj);
							}
						}
					}
				}
			}
		}
	}

	rootJson.put("selectedCommand",selectedCompType);
	rootJson.put("available_commands",allCommandsObj);
	rootJson.put("associatedCommandsObj",associatedCommandsObj);

	rootJson.put("associated_commands",associated_commands);
	rootJson.put("checkEnabledTasks",checkEnabledTasks);
	rootJson.put("checkDisabledTasks",checkDisabledTasks);

	rootJson.put("checkEnabledTasks",checkEnabledTasks);
	rootJson.put("checkDisabledTasks",checkDisabledTasks);

	rootJson.put("isComponentsAssociated",new Boolean(isComponentsAssociated));

	out.println(rootJson.toString());
%>
<%!

	private boolean isServerAgentBased(String hostName, String hostType,EgSpecsInfo specsInfo,EgExternalInfo extInfo)
	{
		boolean isAgentBasedServer = false;
		try
		{
			String[] extTypes = specsInfo.getAllExternalServerTypes();
			List extCompTypes = new ArrayList();
			if (extTypes != null)
			{
				extCompTypes = new ArrayList(Arrays.asList(extTypes));
			}
			String agentType = "Agent-based";
			if(hostType.equals("Real_user_monitor"))
			{
				agentType = "Agentless";
				//ip = "Not Applicable";
			}
			if(extInfo.isRemoteBased(hostName))
			{
				agentType = "Agentless";
			}
			else if (extCompTypes.contains(hostType))
			{
				agentType = "External Agent";
			}
			if(agentType != null && agentType.equalsIgnoreCase("Agent-based"))
			{
				isAgentBasedServer = true;
			}
			else
			{
				isAgentBasedServer = false;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return isAgentBasedServer;
	}
	public List getAllAssigendHypervisorTypes()
	{
		List allHt = new ArrayList();
		EgExternalInfo extInfo = new EgExternalInfo("manager");
		Vector list = getAllManagedComponents();
		Vector temp_extVServers = extInfo.getVirtualServers();
		int plen = temp_extVServers.size();
		for(int k=0; k <plen;k++)
		{
			String temp_serv=(String)temp_extVServers.get(k);
			if(list != null && list.contains(temp_serv))
			{
				allHt.add(temp_serv);
			}
		}			
		return allHt;
	}
	public Vector getAllManagedComponents()
	{
		Vector allComp = new Vector();
		EgDiscInfo2 discIni = new EgDiscInfo2(EgConstants.MANAGER);
		Vector list = discIni.getAllManagedComponents();	
		int plen = list.size();
		for(int k=0; k <plen;k++)
		{
			String temp_serv=(String)list.get(k);
			int ii = temp_serv.indexOf(",");
			if(ii != -1)
			{
				temp_serv = temp_serv.substring(0,ii);
			}
			allComp.add(temp_serv);
		}
		return allComp;
	}
%>


