<%
/*
 *       Name            :		EgaddudtestpJson.jsp
 *       Purpose         :		IC - Test - Add new test Process page
 *       CreationDate    :      01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="egurkha.TestBean" %>
<%@ page import="egurkha.EgTestParamBean" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import= "egurkha.EgUIUtils"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	String add = request.getParameter("add");
	TestBean testBean = new TestBean(true);
	String typeReq = request.getParameter("typeVal");
	String test = request.getParameter("test");
	String testType = request.getParameter("testtype");
	String type = request.getParameter("type");
	String port = request.getParameter("port");
	String os = request.getParameter("os");
	String dbType = request.getParameter("dbType");
	String testname = request.getParameter("testname"); 

	
	/* code for auditlog starts */
	boolean isAggregate = false;
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	//auditLogThread.setValue("Activity","Add Test");
	/* code for auditlog ends */
			

	if(add.equalsIgnoreCase("test"))
	{
		/* code for auditlog starts */
		auditLogThread.setValue("Activity","Add Test");
		/* code for auditlog ends */

		//skm
		if (testType.equalsIgnoreCase("Aggregate"))
		{
			//String testname = request.getParameter("testname");
			IniFile aggregateInfo = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini");
			ArrayList siteOrientedTests = new ArrayList();
			siteOrientedTests.add("WebSiteTest");
			siteOrientedTests.add("WebSiteTransactionTest");
			if(siteOrientedTests.contains(testname))
				aggregateInfo.setValue("SITE_AGGREGATE_TEST",test,"yes");
			aggregateInfo.setValue("AGGREGATE_TEST",test,testname);
			aggregateInfo.saveFile();
			EgConfigFilesSync.releaseInstance(aggregateInfo);
			isAggregate = true;
		}
		//skm

		if(testBean.doesTestExist(test))
		{
			
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add a Test"));
			String msg = _mapping.getTextDescription("admin.error.You are trying to add a test which already exists")+". <br>";
			msg += _mapping.getTextDescription("admin.error.Please enter a unique test name")+".";
			rootJSON.put("AlertMsg",msg);
	               
			/* code for auditlog starts */
			if(isAggregate)
			{
				if(test.endsWith("_ex"))
					auditLogThread.setValue("Description","You are trying to add a aggregate test " + test + " which already exists");
				else
					auditLogThread.setValue("Description","You are trying to add a aggregate test " + "$test$:"+test + " which already exists");
				auditLogThread.sendItToDB();
			}
			else
			{
				if(test.endsWith("_ex"))
					auditLogThread.setValue("Description","You are trying to add a test " + test + " which already exists");
				else
					auditLogThread.setValue("Description","You are trying to add a test " + "$test$:"+test + " which already exists");
				auditLogThread.sendItToDB();
			}
			/* code for auditlog ends */
		}
		else
		{
			boolean portBased = port.equalsIgnoreCase("Yes");
			boolean internal = type.equalsIgnoreCase("Internal");
			IniFile udTestsIni = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_udtests.ini");
			if(typeReq != null && !typeReq.equalsIgnoreCase(" ") && typeReq.length() > 0 && !typeReq.equalsIgnoreCase("null"))
			{
				udTestsIni.setValue("TEST_TYPE",test,typeReq);
			}
			udTestsIni.saveFile();
			EgConfigFilesSync.releaseInstance(udTestsIni);
			testBean.addTest
				(test,testType,internal,portBased,os,dbType);
			//response.sendRedirect("EgAddUDTest.jsp?" + "test=" + 
			//	test + "&port=" + port + "&type=" + type +
			//	"&testtype=" + testType + "&added=done");
			String ur = "EgAddUDTestJson.jsp?" + "test=" + test + "&port=" + port + "&type=" + type +"&testtype=" + testType +"&typeValue="+ typeReq+"&added=done";
			if(testType.equalsIgnoreCase("Jmx"))
			{
				testBean.addParamForTest(test, "Jmx_Remote_Port", "unconfigured");
				testBean.addParamForTest(test, "Jndi_Name", "jmxrmi");
				testBean.addParamForTest(test, "user", "none");
				testBean.addParamForTest(test, "password", "none");
				testBean.addParamForTest(test, "Dynamic_Info_Test", "true");
				Hashtable ht = testBean.getTestParam(test);
				testBean.addTestToSpecs
				(test,portBased,internal,ht,os,dbType);
			}
			
			if (testType.equalsIgnoreCase("Snmp"))
			{
				EgTestParamBean testParamIni = new EgTestParamBean();
				//testParamIni.createFile("eg_testparam.ini","save");
				testParamIni.createSyncFile("eg_testparam.ini","save");
				testParamIni.setValues("SELECT",test,"snmpversion,encrypttype,authtype");
				//testParamIni.setValues("RADIO",test,"encryptflag,data_over_tcp");
				testParamIni.setValues("RADIO",test,"encryptflag,data_over_tcp,engineid");
				testParamIni.setValues("PASSWORD",test,"authpass,encryptpassword");
				testParamIni.saveFile();
				testParamIni.releaseInstance();
			}

			if(testType.equalsIgnoreCase("Sql Query"))
			{
				EgTestParamBean testParamIni = new EgTestParamBean();
				testParamIni.createSyncFile("eg_testparam.ini","save");
				if(dbType.equalsIgnoreCase("Sybase"))
				{
					testParamIni.setValues("RADIO",test,"ssl,isntlmv2,Encrypt_password");
				}
				else if(dbType.equalsIgnoreCase("MySql"))
				{
					testParamIni.setValues("RADIO",test,"ssl,isntlmv2,allow_public_key,verify_ca");
					testParamIni.setValues("PASSWORD",test,"truststore_password,keystore_password");
				}
				else
				{
					testParamIni.setValues("RADIO",test,"ssl,isntlmv2");
				}
				testParamIni.saveFile();
				testParamIni.releaseInstance();
			}

			/* code for auditlog starts */
			auditLogThread.setCurrentValue("01~~Test name", test);
			auditLogThread.setCurrentValue("02~~Execution type", type);
			auditLogThread.setCurrentValue("03~~Port based", portBased==true?"Yes":"No");
			auditLogThread.setCurrentValue("04~~Test type", testType);
			if(os != null && !os.equalsIgnoreCase("null") && os.trim().length()>0)
				auditLogThread.setCurrentValue("05~~Operating system", os.trim());
			if(dbType != null && !dbType.equalsIgnoreCase("null") && dbType.trim().length()>0)
				auditLogThread.setCurrentValue("06~~DB type", dbType.trim());
			if(isAggregate)
			{
				auditLogThread.setCurrentValue("07~~Test to be aggregated","$test$:"+request.getParameter("testname"));
				if(test.endsWith("_ex"))
					auditLogThread.setValue("Description","Aggregate test "+test+" has been added");
				else
					auditLogThread.setValue("Description","Aggregate test "+"$test$:"+test+" has been added");
				auditLogThread.sendItToDB();

				EgTestParamBean testParamIni = new EgTestParamBean();
				//testParamIni.createFile("eg_testparam.ini","save");
				testParamIni.createSyncFile("eg_testparam.ini","save");
				testParamIni.setValues("RADIO",test,"aggregateDescriptor");
				testParamIni.saveFile();
				testParamIni.releaseInstance();

			}
			else
			{
				if(test.endsWith("_ex"))
					auditLogThread.setValue("Description","Test "+test+" has been added");
				else
					auditLogThread.setValue("Description","Test "+"$test$:"+test+" has been added");
				auditLogThread.sendItToDB();
			}
			/* code for auditlog ends */
			rootJSON.put("forwardPage",true);
			rootJSON.put("forwardURL",ur);
			rootJSON.put("AlertType","Result");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.title.INTEGRATION CONSOLE - TEST"));
			rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Test has been added successfully")+".");
		}
	}
	else if(add.equals("param"))
	{
		/* code for auditlog starts */
		auditLogThread.setValue("Activity","Configure Test");
		/* code for auditlog ends */
		String param = EgUIUtils.decodeSecurityChar(request.getParameter("param"));
		String value = EgUIUtils.decodeSecurityChar(request.getParameter("value"));
		param = param.trim();
		value = value.trim();
			
		if(value.indexOf(",")!=-1)
			value=StringUtils.replace(value, ',', '|'); //replace , with # to write to eg_udtests.ini

		if(test == null || test.length() == 0 || port == null ||
		port.length() == 0 || type == null || type.length() == 0)
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add Parameter To Test"));
			String msg = _mapping.getTextDescription("admin.error.You are trying to add parameters to a test which is not yet added")+". <br>";
			msg += _mapping.getTextDescription("admin.error.Please add a test and try again")+".";
			rootJSON.put("AlertMsg",msg);
			
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","You are trying to add parameters to a test " + test + " which is not yet added");
			else
				auditLogThread.setValue("Description","You are trying to add parameters to a test " + "$test$:"+test + " which is not yet added");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
		else if(!testBean.doesTestExist(test))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add Parameter To Test"));
			String msg = _mapping.getTextDescription("admin.error.The test has not been added yet")+ ". <br>";
			msg += _mapping.getTextDescription("admin.error.Please add a test and try again")+".";
			rootJSON.put("AlertMsg",msg);
	               
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","The test " + test + " has not been added yet");
			else
				auditLogThread.setValue("Description","The test "+"$test$:"+ test + " has not been added yet");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}	
		else if(testBean.doesParamExistFor(param, test))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add Parameter To Test"));
			String msg = _mapping.getTextDescription("admin.error.You are trying to add a parameter which is already existing for this test")+". <br>";
			msg += _mapping.getTextDescription("admin.error.Please enter a new parameter name")+".";
			rootJSON.put("AlertMsg",msg);


	       	/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","You are trying to add a parameter "+ param + " which is already existing for test " + test);
			else
				auditLogThread.setValue("Description","You are trying to add a parameter "+ param + " which is already existing for test " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
		else
		{						
			/* code for auditlog starts */
			auditLogThread.setCurrentValue("01~~Parameter",param);
			auditLogThread.setCurrentValue("02~~Default Value",value);
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Parameter " + param + " has been added to the test "+ test);
			else
				auditLogThread.setValue("Description","Parameter " + param + " has been added to the test "+ "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			testBean.addParamForTest(test, param, value);
			Hashtable ht = testBean.getTestParam(test);
			boolean portBased = port.equalsIgnoreCase("Yes");
			boolean internal = type.equalsIgnoreCase("Internal");
			testBean.addTestToSpecs
				(test,portBased,internal,ht,os,dbType);
			//response.sendRedirect("EgAddUDTest.jsp?" + "test=" + 
			//	test + "&port=" + port + "&type=" + type +
			//	"&testtype=" + testType + "&added=done");
			String ur = "EgAddUDTestJson.jsp?" + "test=" + 
				test + "&port=" + port + "&type=" + type +
				"&testtype=" + testType + "&added=done";

			rootJSON.put("forwardPage",true);
			rootJSON.put("forwardURL",ur);
			rootJSON.put("AlertType","Result");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.title.INTEGRATION CONSOLE - TEST"));
			rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Parameter has been added successfully")+".");
		}
	}
	out.println(rootJSON);
%>






