<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.json.simple.*"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgCrypt"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONArray jsonArr = new JSONArray();

	String[] installMethodArr = new String[]{"Command Line (One-liner)","ZIP/TAR Package"};
	String[] osTypeArr = new String[]{"AIX","HPUX","Linux","Windows","Solaris"};

	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");

	String agentType = request.getParameter("agentType");
	String monitors = request.getParameter("monitors");
	String osType = request.getParameter("osType");
	String installMethod = request.getParameter("installMethod");
	String versionName = request.getParameter("agentVersion");
	if (StringUtils.isNull(versionName))
	{
		versionName = "Latest";
	}
	
	ArrayList serverList = new ArrayList();
	if (agentType != null && agentType.equalsIgnoreCase("Internal"))
	{
		if (monitors != null)
		{
			String agentBasedStr = mgrIni.getValue("AgentBased_Mappings",monitors);
			String var [] = mgrIni.getVariables(agentBasedStr);
			ArrayList varList = var==null?new ArrayList():new ArrayList(Arrays.asList(var));
			serverList.addAll(varList);
		}
	}
	
	TreeSet platformSpecificList = new TreeSet();
	for (int i=0;i<serverList.size();i++)
	{
		String serverName = (String)serverList.get(i);
		String platformNames = mgrIni.getValue("COMPONENT_TYPE_OS_MAPPING",serverName);
		if (platformNames != null && platformNames.trim().length() > 0)
		{
			if (platformNames.indexOf(",") != -1)
			{
				ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(platformNames,",")));
				platformSpecificList.addAll(valueList);
			}
			else
			{
				platformSpecificList.add(platformNames);
			}
		}
	}
	
	String enableOneLinerCommand = mgrIni.getValue("MISC_ARGS","enableOneLinerCommand");
	if (StringUtils.isNull(enableOneLinerCommand))
	{
		enableOneLinerCommand = "true";
	}

	JSONArray installArr = new JSONArray();
	for (int x=0; x<installMethodArr.length; x++)
	{
		String installStr = installMethodArr[x];
		if (enableOneLinerCommand.equalsIgnoreCase("false") && installStr.equals("Command Line (One-liner)"))
		{
			continue;
		}
		JSONObject intallObj = new JSONObject();
		intallObj.put("displayField",installStr);
		intallObj.put("valueField",installStr);
		if (!StringUtils.isNull(installMethod) && installMethod.equalsIgnoreCase(installStr))
		{
			rootJson.put("selectedInstallMethods",installMethod);
		}
		installArr.add(intallObj);
	}
	rootJson.put("installMethods",installArr);

	String sep = System.getProperty("file.separator");
	ArrayList osTypeList = new ArrayList();
	JSONArray osArr = new JSONArray();
	String selectedOSType = "";
	File folderStr = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+"Universal"+sep+versionName);
	File[] fileList = folderStr.listFiles();
	if (fileList != null && fileList.length > 0)
	{
		for (int k = 0; k < fileList.length; k++)
		{
			String osNameStr = fileList[k].getName();
			int idxVal = osNameStr.indexOf(".");
			String osName = "";
			if (idxVal != -1)
			{
				osName = osNameStr.substring(0,idxVal);
				int os_idx = osName.indexOf("_");
				if (os_idx != -1)
				{
					osName = osName.substring(0,os_idx);
				}
			}
			if (agentType.equalsIgnoreCase("internal"))
			{
				if (platformSpecificList.contains(osName.toLowerCase()))
				{
					if (osNameStr.startsWith("AIX") || osNameStr.startsWith("HPUX") || 
					osNameStr.startsWith("Linux") || osNameStr.startsWith("Solaris") || 
					osNameStr.startsWith("Windows"))
					{
						if (osNameStr.startsWith("Windows"))
						{
							if (osTypeList !=null && !osTypeList.contains(osName))
							{
								osTypeList.add(osName);
								JSONObject osObj = new JSONObject();
								osObj.put("displayField",osName);
								osObj.put("valueField",osName);
								if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase(osName))
								{
									selectedOSType = osName;
									rootJson.put("selectedOSType",osName);
								}
								osArr.add(osObj);
							}
						}
						else if (osNameStr.endsWith(".tar.gz"))
						{
							if (osTypeList !=null && !osTypeList.contains(osName))
							{
								osTypeList.add(osName);
								JSONObject osObj = new JSONObject();
								osObj.put("displayField",osName);
								osObj.put("valueField",osName);
								if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase(osName))
								{
									selectedOSType = osName;
									rootJson.put("selectedOSType",osName);
								}
								osArr.add(osObj);
							}
						}
					}
				}
			}
			else
			{
				if (agentType.equalsIgnoreCase("external") && monitors.equalsIgnoreCase("LogonSimulator")) 
				{
					if (osNameStr.startsWith("Windows"))
					{
						if (osTypeList !=null && !osTypeList.contains(osName))
						{
							osTypeList.add(osName);
							JSONObject osObj = new JSONObject();
							osObj.put("displayField",osName);
							osObj.put("valueField",osName);
							if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase(osName))
							{
								selectedOSType = osName;
								rootJson.put("selectedOSType",osName);
							}
							osArr.add(osObj);
						}
					}
				}
				else
				{
					if (osNameStr.startsWith("Linux") || 
					osNameStr.startsWith("Windows"))
					{
						if (osNameStr.startsWith("Windows"))
						{
							if (osTypeList !=null && !osTypeList.contains(osName))
							{
								osTypeList.add(osName);
								JSONObject osObj = new JSONObject();
								osObj.put("displayField",osName);
								osObj.put("valueField",osName);
								if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase(osName))
								{
									selectedOSType = osName;
									rootJson.put("selectedOSType",osName);
								}
								osArr.add(osObj);
							}
						}
						else if (osNameStr.endsWith(".tar.gz"))
						{
							if (osTypeList !=null && !osTypeList.contains(osName))
							{
								osTypeList.add(osName);
								JSONObject osObj = new JSONObject();
								osObj.put("displayField",osName);
								osObj.put("valueField",osName);
								if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase(osName))
								{
									selectedOSType = osName;
									rootJson.put("selectedOSType",osName);
								}
								osArr.add(osObj);
							}
						}
					}
				}
			}
		}
	}
	rootJson.put("osTypes",osArr);

	if (osArr != null && !osArr.isEmpty() && StringUtils.isNull(selectedOSType))
	{
		JSONObject jsonObject = (JSONObject) osArr.get(0);
		osType = (String)jsonObject.get("valueField");
		rootJson.put("selectedOSType",osType);
	}

	ArrayList finalAgentList = new ArrayList();
	if(osType != null)
	{
		String agentNames = mgrIni.getValue("OS_AGENT_MAPPING",osType.toLowerCase());
		if (agentNames != null && agentNames.trim().length() > 0)
		{
			if (agentNames.indexOf(",") != -1)
			{
				ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(agentNames,",")));
				finalAgentList.addAll(valueList);
			}
			else
			{
				finalAgentList.add(agentNames);
			}
		}
	}
	
	ArrayList defaultAgentFolders = new ArrayList();
	ArrayList unixList = new ArrayList();
	ArrayList winList = new ArrayList();
	String defaultAgents = mgrIni.getValue("MISC_ARGS","DefaultAgentFolders");
	if (defaultAgents != null && defaultAgents.length() > 0)
	{
		StringTokenizer st = new StringTokenizer(defaultAgents,",");
		while (st.hasMoreTokens())
		{
			defaultAgentFolders.add(st.nextToken());
		}
	}

	String unix [] = mgrIni.getVariables("UNIX_AGENT_FOLDER_NAMES");
	String win [] = mgrIni.getVariables("WINDOWS_AGENT_FOLDER_NAMES");

	if (finalAgentList != null && finalAgentList.size() > 0)
	{
		if (unix != null && unix.length > 0)
		{
			for (int i=0;i<unix.length;i++)
			{
				String unixAgent = unix[i];
				if (finalAgentList.contains(unixAgent))
				{
					unixList.add(unixAgent);
				}
			}
		}
		if (win != null && win.length > 0)
		{
			for (int i=0;i<win.length;i++)
			{
				String winAgent = win[i];
				if (finalAgentList.contains(winAgent))
				{
					winList.add(winAgent);
				}
			}
		}
	}
	else
	{
		if (!agentType.equalsIgnoreCase("internal"))
		{
			unixList = unix==null?new ArrayList():new ArrayList(Arrays.asList(unix));
			winList = win==null?new ArrayList():new ArrayList(Arrays.asList(win));
		}
	}

	if (!StringUtils.isNull(installMethod) && installMethod.equalsIgnoreCase("ZIP/TAR Package"))
	{
		JSONObject packCountObj = new JSONObject();
		String aixPack = "";
		String hpuxPack = "";
		String solarisPack = "";
		String linuxPack = "";
		
		if (defaultAgentFolders != null && !defaultAgentFolders.isEmpty())
		{
			for (int j = 0; j < defaultAgentFolders.size(); j++)
			{
				String folderName = (String)defaultAgentFolders.get(j);
				
				File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderName+sep+versionName);
				File[] listOfFiles = folder.listFiles();
				
				if (listOfFiles != null && listOfFiles.length > 0)
				{
					for (int k = 0; k < listOfFiles.length; k++)
					{
						JSONObject jsonObj = new JSONObject();
						String dirName = listOfFiles[k].getName();
						String imageName = mgrIni.getValue("AGENT_IMAGE_CLASS",dirName);
						if (unixList.contains(dirName))
						{
							String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Unix");

							if (dirName.indexOf("Linux") != -1)
							{
								if (dirName.indexOf("x64") != -1 || dirName.indexOf("ppc") != -1)
								{
									jsonObj.put("bit","64-bit");
								}
								else
								{
									jsonObj.put("bit","32-bit");
								}
							}
							
							String packName = dirName.substring(0,dirName.indexOf("."));
							
							if (dirName.startsWith("AIX"))
							{
								aixPack += ", eGAgent_"+packName;
							}
							else if (dirName.startsWith("HPUX"))
							{
								hpuxPack += ", eGAgent_"+packName;
							}
							else if (dirName.startsWith("Solaris"))
							{
								solarisPack += ", eGAgent_"+packName;
							}
							else if (dirName.startsWith("Linux"))
							{
								linuxPack += ", eGAgent_"+packName;
							}

							jsonObj.put("version",displayName);

							jsonArr.add(jsonObj);
						}
						else if (winList.contains(dirName))
						{
							if (dirName.toLowerCase().startsWith("vm") && !folderName.equalsIgnoreCase("vm"))
							{
								continue;
							}
							
							if (!StringUtils.isNull(monitors) && monitors.equalsIgnoreCase("MSAVDSessionHost") && (dirName.startsWith("Windows_2008") || dirName.equalsIgnoreCase("Windows_2012.zip")))
							{
								continue;
							}

							String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Windows");

							if (dirName.indexOf("x64")!= -1)
							{
								jsonObj.put("bit","64-bit");
							}
							else
							{
								jsonObj.put("bit","32-bit");
							}

							String version = mgrIni.getValue("WINDOWS_AGENT_VERSION",displayName);
							if (version != null && version.length() > 0)
							{
								jsonObj.put("version",version);
							}
							else
							{
								jsonObj.put("version",displayName);
							}

							jsonArr.add(jsonObj);
						}
					}
				}
			}
		}
		
		if (osType.equalsIgnoreCase("AIX"))
		{
			if (!StringUtils.isNull(aixPack))
			{
				aixPack = aixPack.substring(2);
			}
			rootJson.put("AIX",aixPack);
		}
		else if (osType.equalsIgnoreCase("HPUX"))
		{
			if (!StringUtils.isNull(hpuxPack))
			{
				hpuxPack = hpuxPack.substring(2);
			}
			rootJson.put("HPUX",hpuxPack);
		}
		else if (osType.equalsIgnoreCase("Solaris"))
		{
			if (!StringUtils.isNull(solarisPack))
			{
				solarisPack = solarisPack.substring(2);
			}
			rootJson.put("Solaris",solarisPack);
		}
		else if (osType.equalsIgnoreCase("Linux"))
		{
			if (!StringUtils.isNull(linuxPack))
			{
				linuxPack = linuxPack.substring(2);
			}
			rootJson.put("Linux",linuxPack);
		}
		
		rootJson.put("listOfOS",jsonArr);
	}
	else
	{
		String osVersion = request.getParameter("osVersion");
		String isGoldenImageServer = request.getParameter("isGoldenImageServer");
		String isCliEmu = request.getParameter("isCliEmu");
		if (StringUtils.isNull(osVersion))
		{
			if (osType.equalsIgnoreCase("Windows"))
			{
				osVersion = "win2022";
			}
			else if (osType.equalsIgnoreCase("Linux"))
			{
				osVersion = "linux_64";
			}
			else if (osType.equalsIgnoreCase("HPUX"))
			{
				osVersion = "hpux_itnm";
			}
			else if (osType.equalsIgnoreCase("Solaris"))
			{
				osVersion = "solaris_sparc";
			}
			else if (osType.equalsIgnoreCase("AIX"))
			{
				osVersion = "aix";
			}
		}
		String selectedOSVersion = "";
		JSONArray osVerArr = new JSONArray();
		if (defaultAgentFolders != null && !defaultAgentFolders.isEmpty())
		{
			for (int j = 0; j < defaultAgentFolders.size(); j++)
			{
				String folderName = (String)defaultAgentFolders.get(j);
				
				File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderName+sep+versionName);
				File[] listOfFiles = folder.listFiles();
				if (listOfFiles != null && listOfFiles.length > 0)
				{
					for (int k = 0; k < listOfFiles.length; k++)
					{
						JSONObject jsonObj = new JSONObject();
						String displayNameStr = "";
						String dirName = listOfFiles[k].getName();
						if (dirName.startsWith("Windows_2008"))
						{
							continue;
						}
						if (unixList.contains(dirName))
						{
							String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}

							if (dirName.indexOf("Linux") != -1)
							{
								if (dirName.indexOf("x64") != -1 || dirName.indexOf("ppc") != -1)
								{
									displayNameStr = displayName+" (64-bit)";
								}
								else
								{
									displayNameStr = displayName+" (32-bit)";
								}
							}
							else
							{
								if (displayName.indexOf("HP-UX") != -1)
								{
									displayName = displayName.replace("-","");
								}
								displayNameStr = displayName;
							}
							String osValField = mgrIni.getValue("All_OS_Version",displayNameStr);
							jsonObj.put("displayField",displayNameStr);
							jsonObj.put("valueField",osValField);
							if (!StringUtils.isNull(osVersion) && osValField.equalsIgnoreCase(osVersion))
							{
								rootJson.put("selectedOSVersion",osVersion);
								selectedOSVersion = osVersion;
							}
							osVerArr.add(jsonObj);
						}
						else if (winList.contains(dirName))
						{
							if (dirName.toLowerCase().startsWith("vm") && !folderName.equalsIgnoreCase("vm"))
							{
								continue;
							}

							String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							
							displayName = mgrIni.getValue("WINDOWS_AGENT_VERSION",displayName);
						
							if (dirName.startsWith("Windows_2012"))
							{
								displayName = displayName.replace("8.x/","");
							}

							if (dirName.indexOf("x64")!= -1)
							{
								displayNameStr = displayName+" (64-bit)";
							}
							else
							{
								if (StringUtils.isNull(monitors) || !monitors.equalsIgnoreCase("MSAVDSessionHost"))
								{
									displayNameStr = displayName+" (32-bit)";
								}
							}
							String osValField = mgrIni.getValue("All_OS_Version",displayNameStr);
							jsonObj.put("displayField",displayNameStr);
							jsonObj.put("valueField",osValField);
							if (!StringUtils.isNull(osVersion) && osValField.equalsIgnoreCase(osVersion))
							{
								rootJson.put("selectedOSVersion",osVersion);
								selectedOSVersion = osVersion;
							}
							osVerArr.add(jsonObj);
						}
					}
				}
			}
		}

		StringBuffer cmdBuff = new StringBuffer();
		StringBuffer cmdBuffAI = new StringBuffer();
		String installCmd = "";
		String installCmdAI = "";
		if (osVerArr != null && !osVerArr.isEmpty())
		{
			if (StringUtils.isNull(selectedOSVersion))
			{
				JSONObject jsonObject = (JSONObject) osVerArr.get(0);
				osVersion = (String)jsonObject.get("valueField");
				rootJson.put("selectedOSVersion",osVersion);
			}
			
			if (osVersion.equalsIgnoreCase("hpux_os"))
			{
				osVersion = osVersion.substring(0,osVersion.indexOf("_"));
			}
			
			IniFile egSerIni =  new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
			String mgrUrl = egSerIni.getValue("MISC_ARGS","MailHomeUrl");
			String mgrReferrer = mgrIni.getValue("AGT_DLD_DEF_PARAMS","rf");
			String userName = _user.getLoginID();
			String akValue = "";
			String atValue = "";
			String dwdFileName = "";
			if (StringUtils.isNull(agentType))
			{
				atValue = "ia";
				dwdFileName = "eG_Agent_Installer";
			}
			else
			{
				if (agentType.equalsIgnoreCase("remote"))
				{
					atValue = "ra";
					dwdFileName = "eG_RAgent_Installer";
				}
				else if (agentType.equalsIgnoreCase("external"))
				{
					atValue = "ea";
					if (!StringUtils.isNull(isCliEmu) && isCliEmu.equalsIgnoreCase("true"))
					{
						dwdFileName = "eG_CEAgent_Installer";
					}
					else
					{
						dwdFileName = "eG_EAgent_Installer";
					}
				}
				else if (agentType.equalsIgnoreCase("vm"))
				{
					atValue = "va";
					dwdFileName = "eG_VMAgent_Installer";
				}
				else
				{
					atValue = "ia";
					dwdFileName = "eG_Agent_Installer";
				}	
			}
			
			String giValue ="";
			if (StringUtils.isNull(isGoldenImageServer))
			{
				giValue = "n";
			}
			else
			{
				if (isGoldenImageServer.equalsIgnoreCase("true"))
				{
					giValue = "y";
				}
				else
				{
					giValue = "n";
				}
			}
			
			String ceValue ="";
			if (StringUtils.isNull(isCliEmu))
			{
				ceValue = "n";
			}
			else
			{
				if (isCliEmu.equalsIgnoreCase("true"))
				{
					ceValue = "y";
				}
				else
				{
					ceValue = "n";
				}
			}
			
			String maValue = "n";
			if (!StringUtils.isNull(monitors) && monitors.equalsIgnoreCase("MSAVDSessionHost") && atValue.equals("ia"))
			{
				maValue = "y";
			}

			if (osType.equalsIgnoreCase("Windows"))
			{
				cmdBuff.append("cd /; mkdir -Force eGAgent; cd eGAgent; Remove-Item ./* -Force; ");
				cmdBuff.append("Invoke-WebRequest -Uri \"");
				cmdBuff.append(mgrUrl+"/final/ega?");
				cmdBuff.append("rf="+mgrReferrer);
				cmdBuff.append("&gp="+EgCrypt.encrypt(userName));
				
				cmdBuffAI.append("cd /; mkdir -Force eGAgentInstaller; cd eGAgentInstaller; Remove-Item ./* -Force; ");
				cmdBuffAI.append("Invoke-WebRequest -Uri \"");
				cmdBuffAI.append(mgrUrl+"/final/ega?");
				cmdBuffAI.append("rf="+mgrReferrer);
				cmdBuffAI.append("&gp="+EgCrypt.encrypt(userName));

				String bitStr = "";
				int idx = osVersion.indexOf("_");
				if (idx != -1)
				{
					String osStr = osVersion.substring(0,idx);
					akValue = akValue+"os="+osStr;
					String bit = osVersion.substring(idx+1);
					osVersion=osStr;
					if (bit.equals("32"))
					{
						bitStr = "";
						akValue = akValue+"&bt=32";
					}
					else
					{
						bitStr = "_x64";
					}
				}
				else
				{
					bitStr = "_x64";
					akValue = akValue+"os="+osVersion;
				}
				akValue = akValue+"&at="+atValue;
				akValue = akValue+"&gi="+giValue;
				akValue = akValue+"&ce="+ceValue;
				akValue = akValue+"&ma="+maValue;
				cmdBuff.append("&ak="+EgCrypt.encrypt(akValue));
				
				cmdBuffAI.append("&ak="+EgCrypt.encrypt("os=aiwin&at="+atValue+"&ce="+ceValue));


				String fileName = "";
				if (osVersion.equalsIgnoreCase("win2008") || osVersion.equalsIgnoreCase("win7"))
				{
					fileName = "Windows_2008"+bitStr+".zip";
				}
				else if (osVersion.equalsIgnoreCase("win2012") || osVersion.equalsIgnoreCase("win8"))
				{
					fileName = "Windows_2012"+bitStr+".zip";
				}
				else if (osVersion.equalsIgnoreCase("win2016") || osVersion.equalsIgnoreCase("win10"))
				{
					fileName = "Windows_2016"+bitStr+".zip";
				}
				else if (osVersion.equalsIgnoreCase("win2019"))
				{
					fileName = "Windows_2019"+bitStr+".zip";
				}
				else if (osVersion.equalsIgnoreCase("win2022"))
				{
					fileName = "Windows_2022"+bitStr+".zip";
				}
				cmdBuff.append("\" -OutFile .\\eGAgent_"+fileName);
				installCmd = "; Expand-Archive -Path eGAgent_"+fileName+" -DestinationPath .; .\\setup.bat nopause";
				
				cmdBuffAI.append("\" -OutFile .\\"+dwdFileName+".zip");
				installCmdAI = "; Expand-Archive -Path "+dwdFileName+".zip -DestinationPath .; .\\eG_Agent_Installer.exe";
			}
			else
			{
				String fileNameStr = "";
				String bitStr = "";
				String osStr = "";
				String bit = "";
				if (osType.equalsIgnoreCase("Linux"))
				{
					int idx = osVersion.indexOf("_");
					if (idx != -1)
					{
						osStr = osVersion.substring(0,idx);
						bit = osVersion.substring(idx+1);
						osVersion=osStr;
						if (bit.equals("32"))
						{
							bitStr = "";
							bit = "32";
						}
						else
						{
							bit = "";
							bitStr = "_x64";
						}
					}
					else
					{
						osStr = osVersion;
						bitStr = "_x64";
						bit = "";
					}
					
					if (osVersion.equalsIgnoreCase("linuxppc"))
					{
						fileNameStr = "Linux_x64_ppc.tar.gz";
					}
					else
					{
						fileNameStr = "Linux"+bitStr+".tar.gz";
					}
				}
				else
				{
					osStr = osVersion;
					if (osVersion.equalsIgnoreCase("aix"))
					{
						fileNameStr = "AIX.tar.gz";
					}
					else if (osVersion.equalsIgnoreCase("hpux"))
					{
						fileNameStr = "HPUX.tar.gz";
					}
					else if (osVersion.equalsIgnoreCase("hpux_itnm"))
					{
						fileNameStr = "HPUX_Itanium.tar.gz";
					}
					else if (osVersion.equalsIgnoreCase("solaris_amd"))
					{
						fileNameStr = "Solaris_AMD.tar.gz";
					}
					else if (osVersion.equalsIgnoreCase("solaris_sparc"))
					{
						fileNameStr = "Solaris_SPARC.tar.gz";
					}
				}
				cmdBuff.append("cd / && mkdir -p eGAgent && cd eGAgent && rm -f ./* && ");
				cmdBuff.append("curl -o eGAgent_"+fileNameStr+" \"");
				cmdBuff.append(mgrUrl+"/final/ega?");
				cmdBuff.append("rf="+mgrReferrer);
				cmdBuff.append("&gp="+EgCrypt.encrypt(userName));
				akValue = akValue+"os="+osStr;
				if (!StringUtils.isNull(bit))
				{
					akValue = akValue+"&bt="+bit;
				}
				akValue = akValue+"&at="+atValue;
				akValue = akValue+"&gi="+giValue;
				akValue = akValue+"&ce="+ceValue;
				cmdBuff.append("&ak="+EgCrypt.encrypt(akValue));
				cmdBuff.append("\"");
				String fileNameTar = fileNameStr.substring(0,fileNameStr.indexOf(".gz"));
				installCmd = " && chmod 750 eGAgent_"+fileNameStr+" && gunzip eGAgent_"+fileNameStr+" && tar -xvf eGAgent_"+fileNameTar+" && chmod 750 ./setup.sh && ./setup.sh";
			}
		}
		String downloadUrlStr = cmdBuff.toString();
		if (downloadUrlStr.indexOf("curl ") != -1)
		{
			String wgetDwdUrlStr = downloadUrlStr.replace("curl -o ","wget -O ");
			rootJson.put("wgetDownloadUrlStr",wgetDwdUrlStr+installCmd);
		}
		else if (downloadUrlStr.indexOf("Invoke-WebRequest ") != -1)
		{
			String agentInstallerCmd = cmdBuffAI.toString();
			rootJson.put("wgetDownloadUrlStr",agentInstallerCmd+installCmdAI);
		}
		
		rootJson.put("downloadUrlStr",downloadUrlStr+installCmd);
		rootJson.put("osVersions",osVerArr);
	}
	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootJson);
%>




