<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "net.sf.json.*" %>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String strComponentType = request.getParameter("comptype");
	String strComponentName = request.getParameter("compname");
	String strTestName = request.getParameter("test");
	String from = request.getParameter("from");
	String descriptorName = request.getParameter("descName");
	if(!StringUtils.isNull(descriptorName))
	{
		descriptorName = StringUtils.decodeSecurityChar(descriptorName);
	}
	String isRefine = request.getParameter("isRefine");
	boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(strTestName);
	String displayComponentName = "";
	if (strComponentName.indexOf(":NULL") > -1)
	{
		displayComponentName = strComponentName.substring(0,strComponentName.indexOf(":"));
	}
	else
	{
		displayComponentName = strComponentName;
	}

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] componentsList = null;
	ArrayList aListExpectedComponents = (ArrayList) session.getAttribute("aListExpectedComponents");
	if(aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
	{
		if(aListExpectedComponents.contains(strComponentName))
		{
			aListExpectedComponents.remove(strComponentName);
		}
		Collections.sort(aListExpectedComponents,String.CASE_INSENSITIVE_ORDER);
	}
	//remove the component from the aListExpectedComponents whose test is excluded - starts
	ArrayList excludeComponents  = new ArrayList();
	prgBean.createFile("eg_disable.ini");
	if (isPortRelevantForTest)
	{
		String[] variables = prgBean.getVariables(strComponentType);
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String pattern = tempComp;
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue(strComponentType,pattern);
				if (value.indexOf(strTestName) > -1)
				{
					excludeComponents.add(tempComp);
				}
			}
		}
	}
	else
	{
		String[] variables = prgBean.getVariables("Default_server");
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String strCompName = tempComp.substring(0,tempComp.indexOf(":"));
			String pattern = "Default_server:"+strCompName;
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue("Default_server",pattern);
				if (value.indexOf(strTestName) > -1)
				{
					excludeComponents.add(tempComp);
				}
			}
		}
	}

	if(excludeComponents != null && excludeComponents.size() > 0)
	{
		aListExpectedComponents.removeAll(excludeComponents);
	}

	if(aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
	{
		List tempList = new ArrayList();
		for(int a=0;a<aListExpectedComponents.size();a++)
		{
			String strExpectComp = (String) aListExpectedComponents.get(a);
			String fullCompName = strComponentType+":"+strExpectComp;
			tempList.add(fullCompName);
		}
		aListExpectedComponents = new ArrayList(tempList);
	}
	//remove the component from the aListExpectedComponents whose test is excluded - ends

	//For Zones, Services, Segments and Components - Start
	String ea_criteria = request.getParameter("ea_criteria");
	if (ea_criteria == null)
	{
		ea_criteria = "Component";
	}
	String ea_criteriaPrevious = request.getParameter("ea_criteriaPrevious");
	String ea_userOption = request.getParameter("ea_userOption");
	if (ea_criteria != null && 
		ea_criteriaPrevious != null && 
		!ea_criteriaPrevious.equals(ea_criteria))
	{
		ea_userOption = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	EgGroupInfo egGroupInfo = new EgGroupInfo();
	EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();
	Vector vecUserOptions = null;
	ArrayList aListAssociatedComponents = new ArrayList();
	if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Zone"))
	{
		List zoneList = _user.getZones();
		//To fetch all components from user associated zones
		ArrayList aListComponentsFromZone = new ArrayList();
		if (zoneList != null && !zoneList.isEmpty())
		{
			vecUserOptions = new Vector(zoneList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strZone = (String)vecUserOptions.get(i);
				ArrayList aListCompsUnderZone = egGroupInfo.getAllComponentsUnderZone(strZone,true);
				aListComponentsFromZone.addAll(aListCompsUnderZone);
				for (int j=0;j<aListCompsUnderZone.size();j++)
				{
					String compUnderZone = (String)aListCompsUnderZone.get(j);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						vecTemp.add(strZone);
						break;
					}
				}
			}
			vecUserOptions = vecTemp;
		}

		if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
		{
			boolean defaultZoneExists = false;
			for (int i=0;i<aListExpectedComponents.size();i++)
			{
				String component = (String)aListExpectedComponents.get(i);
				if (!aListComponentsFromZone.contains(component))
				{
					defaultZoneExists = true;
					break;
				}
			}

			if (defaultZoneExists)
			{
				vecUserOptions.add(0,"--Default--");
			}
		}
		else
		{
			if (aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
			{
				vecUserOptions = new Vector();
				vecUserOptions.add("--Default--");
			}
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			if (!ea_userOption.equalsIgnoreCase("--Default--"))
			{
				ArrayList aListCompsUnderChosenZone = egGroupInfo.getAllComponentsUnderZone(ea_userOption,true);
				for (int i=0;i<aListCompsUnderChosenZone.size();i++)
				{
					String compUnderZone = (String)aListCompsUnderChosenZone.get(i);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						aListAssociatedComponents.add(compUnderZone);
					}
				}
			}
			else
			{
				aListAssociatedComponents = new ArrayList();
				for (int i=0;i<aListExpectedComponents.size();i++)
				{
					String userComponent = (String)aListExpectedComponents.get(i);
					int index = aListComponentsFromZone.indexOf(userComponent);
					if (index == -1)
					{
						aListAssociatedComponents.add(userComponent);
					}
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Service"))
	{
		List serviceList = new ArrayList();
		serviceList.addAll(_user.getServices());
		ArrayList aListSites = new ArrayList();
		aListSites.addAll(_user.getSites());
		aListSites.removeAll(serviceList);
		serviceList.addAll(aListSites);
		if (serviceList != null && !serviceList.isEmpty())
		{
			vecUserOptions = new Vector(serviceList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strService = (String)vecUserOptions.get(i);
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(strService);
				for (int j=0;j<vecServiceComponents.size();j++)
				{
					String compUnderService = (String)vecServiceComponents.get(j);
					int index = aListExpectedComponents.indexOf(compUnderService);
					if (index != -1)
					{
						vecTemp.add(strService);
						break;
					}
				}
			}
			vecUserOptions = vecTemp;
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ea_userOption);
			for (int i=0;i<vecServiceComponents.size();i++)
			{
				String compUnderService = (String)vecServiceComponents.get(i);
				int index = aListExpectedComponents.indexOf(compUnderService);
				if (index != -1)
				{
					aListAssociatedComponents.add(compUnderService);
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Segment"))
	{
		List segmentList = _user.getSegments();
		if (segmentList != null && !segmentList.isEmpty())
		{
			vecUserOptions = new Vector(segmentList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strSegment = (String)vecUserOptions.get(i);
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(strSegment,2);
				if (vecSegmentComponents != null && vecSegmentComponents.size() > 0)
				{
					for (int j=0;j<vecSegmentComponents.size();j++)
					{
						String compUnderSegment = (String)vecSegmentComponents.get(j);
						int index = aListExpectedComponents.indexOf(compUnderSegment);
						if (index != -1)
						{
							vecTemp.add(strSegment);
							break;
						}
					}
				}
			}
			vecUserOptions = vecTemp;
		}
		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ea_userOption,2);
			if (vecSegmentComponents != null && vecSegmentComponents.size() > 0)
			{
				for (int i=0;i<vecSegmentComponents.size();i++)
				{
					String compUnderSegment = (String)vecSegmentComponents.get(i);
					int index = aListExpectedComponents.indexOf(compUnderSegment);
					if (index != -1)
					{
						aListAssociatedComponents.add(compUnderSegment);
					}
				}
			}
		}
	}

	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase("Component"))
	{
		aListExpectedComponents = aListAssociatedComponents;
	}
	//For Zones, Services, Segments and Components - End


	if(!StringUtils.isNull(descriptorName))
	{
		String temp = "<table border='0' cellspacing='0' cellpadding='0' width='100%'><tr><td align='center' style='font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:12px'><b>"+_mapping.getTextDescription("admin.test.Specific thresholds for the")+"&nbsp;'"+_mapping.getTestDescription(strTestName)+"'&nbsp;test&nbsp;(Descriptor:&nbsp;"+descriptorName+")&nbsp;";
		temp +="of&nbsp;"+displayComponentName+"&nbsp;("+_mapping.getComponentTypeDescription(strComponentType)+") component</td></tr></table>";
		screenLabels.put("disp_msg",temp);
	}
	else
	{
		String temp = "<table border='0' cellspacing='0' cellpadding='0' width='100%' align='center'><tr><td align='center' style='font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;font-size:12px'><b>"+_mapping.getTextDescription("admin.test.Specific thresholds for the")+"&nbsp;'"+_mapping.getTestDescription(strTestName)+"'&nbsp;test of&nbsp;"+displayComponentName+"&nbsp;("+_mapping.getComponentTypeDescription(strComponentType)+") component</td></tr></table>";
		screenLabels.put("disp_msg",temp);
	}


	JSONArray viewByComboArr = new JSONArray();
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			JSONObject viewByComboObj = new JSONObject();
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ea_criteria != null && strCriteria.equals(ea_criteria))
			{
				rootJson.put("selectedViewType",strCriteria);
				selected = "selected";
			}
			viewByComboObj.put("displayField",strCriteria);
			viewByComboObj.put("valueField",strCriteria);
			viewByComboArr.add(viewByComboObj);
		}
	}
	else
	{
		JSONObject viewByComboObj = new JSONObject();
		viewByComboObj.put("displayField","<egui:intnl text='configmgmt.common.Not Applicable'/>");
		viewByComboObj.put("valueField","-1");

		viewByComboArr.add(viewByComboObj);
	}
	rootJson.put("viewByComboArr",viewByComboArr);

	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase(criterias[3]) && !ea_criteria.equals("-1"))
	{
		rootJson.put("isSelectedTypeCombo",true);

		if (ea_criteria.equalsIgnoreCase(criterias[0]))
		{
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[1]))
		{
		}
		else
		{

		}

		JSONArray vecUserOptionsArr = new JSONArray();
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			JSONObject vecUserOptionsObj = new JSONObject();

			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ea_userOption != null && strUserOption.equals(ea_userOption))
				{
					rootJson.put("seletedUserOption",strUserOption);
					selected = "selected";
				}
				vecUserOptionsObj.put("displayField",strUserOption);
				vecUserOptionsObj.put("valueField",strUserOption);

				vecUserOptionsArr.add(vecUserOptionsObj);
			}
		}
		else
		{
			JSONObject vecUserOptionsObj = new JSONObject();
			vecUserOptionsObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
			vecUserOptionsObj.put("valueField","-1");


			vecUserOptionsArr.add(vecUserOptionsObj);
		}
		rootJson.put("vecUserOptionsArr",vecUserOptionsArr);

	}
	else
	{
		rootJson.put("isSelectedTypeCombo",false);

	}

	JSONArray compNameArr = new JSONArray();
	JSONArray existCompNameArr = new JSONArray();
	for (int i=0;i<aListExpectedComponents.size();i++)
	{
		JSONObject compNameObj = new JSONObject();
		String strComponent = (String)aListExpectedComponents.get(i);
		strComponent = strComponent.substring(strComponent.indexOf(":")+1,strComponent.length());
		String str = strComponent;
		if (str.indexOf(":NULL") > -1)
		{
			str = str.substring(0,str.indexOf(":"));
		}
		compNameObj.put("displayField",str);
		compNameObj.put("valueField",strComponent);
		compNameArr.add(compNameObj);
		existCompNameArr.add(strComponent);
	}

	rootJson.put("compNameArr",compNameArr);
	rootJson.put("existCompNameArr",existCompNameArr);

	hiddenObj.put("comptype",strComponentType);
	hiddenObj.put("compname",strComponentName);
	hiddenObj.put("test",strTestName);
	hiddenObj.put("descName",descriptorName);
	hiddenObj.put("from",from);
	hiddenObj.put("isRefine",isRefine);
	hiddenObj.put("ea_criteriaPrevious",ea_criteria);
	hiddenObj.put("requestFrom","EgApplyThresholdsToOtherComponents.jsp");

	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("screenLabels",screenLabels);

	out.println(rootJson.toString());
%>


