<!DOCTYPE html>
<%
/**************************************************************************************************
* File name			: EcSoftwareHotfixDashboardPrint.jsp
* Purpose			: For Software/Hotfix dashboard
* Last Modified 	:
* Author			: 
**************************************************************************************************/
%>

<%@ page import = "com.eg.EgURLEncoder"%>
<%@ include file = "EcTracker.jsp" %>

<%@ page import="java.text.*"%>
<%@ page import = "java.util.*"%>

<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.*"%>

<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "egurkha.config.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%!
	private User getCurrentUser(HttpSession session)
	{
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		return user;
	}
	private String getUserLanguage(User user)
	{
		IniUI iniUI = IniUI.getInstance();
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		return userLanguage;
	}
	private String getCurrentDateFormat(User user)
	{
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		
		String currentDateFormat = null;
		
		String mgrDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDateFormat = user.getUserDateFormat();
		
		if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
		{
			userDateFormat = mgrDateFormat;
		}
		
		if (userDateFormat != null)
		{
			currentDateFormat = userDateFormat;
		}
		else
		{
			currentDateFormat = mgrDateFormat;
		}
		
		return currentDateFormat;
	}
%>

<%
	
	User curUser = getCurrentUser(session);

	if(curUser != null)
	{
		String lableOfSftwrHotfix = null;
		String lableOfSftwrsHotfixs = null;
		String totalCmpntStr = "";
		String totalCountCommanSep = "";
		String totalDonutColor = "";
		String instldOSCommaSep = "";
		String instldCountCommaSep = ""; 
		String instldDonutClrs = "";
		String instldLable = null;
		String uninstldOSCommaSep = "";
		String uninstldCountCommaSep = "";
		String uninstldDonutClrs = "";
		String uninstldLable = null;
		String instldGrapLbl = null;
		String uninstldGrapLbl = null;
		String gridHeaderLbl = null;
		String curInstldMngrDtFrmtStr = null;
		
		String userLanguage = getUserLanguage(curUser);
		String currentDateFormat = getCurrentDateFormat(curUser);
		
		SimpleDateFormat dateTimeFormat = new SimpleDateFormat(currentDateFormat+" "+"HH:mm");
		
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
		String labelNotAvailable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Unknown");
		
		String ec_forPDF = request.getParameter("ec_forPDF"); 
		
		//doNut colors Info
		String dashboardIniFileName = EcSoftwareHotfixHandler.iniFileName;
		IniFile dashboardIni = new IniFile(EgConfigInfo.egMgrConfigDir +dashboardIniFileName );
		String totalCmpntsColors = (String) dashboardIni.getValue("DONUT_COLORS", "TotalCmpntsColors");    
		String[] totalDonutClrsArr = totalCmpntsColors.split(",");
		String installedColors = (String) dashboardIni.getValue("DONUT_COLORS", "InstalledColors");    
		String[] instldDonutClrsArr = installedColors.split(",");
		String uninstalledColors = (String) dashboardIni.getValue("DONUT_COLORS", "UninstalledColors");    
		String[] uninstldDonutClrsArr = uninstalledColors.split(",");
		
		//Read data from session 
		Map sftwrHotfixDashBoardInfo = (Map)session.getAttribute("SftwrHotfixDashBoardInfo");
		if(sftwrHotfixDashBoardInfo != null && sftwrHotfixDashBoardInfo.size() > 0)
		{
			//View By ,SoftwareOrHotfix, Timeline Details
			String viewBy = (String)sftwrHotfixDashBoardInfo.get("viewBy");
			String softwareOrHotfix = (String)sftwrHotfixDashBoardInfo.get("softwareOrHotfix");
			Calendar fromDate = (Calendar)sftwrHotfixDashBoardInfo.get("fromDate");
			Calendar toDate = (Calendar)sftwrHotfixDashBoardInfo.get("toDate");
			String timeline = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.timeline."+(String)sftwrHotfixDashBoardInfo.get("timeline"));
			String ec_userOption = (String)sftwrHotfixDashBoardInfo.get("ec_userOption");
			List latestInstldDtls = (List)sftwrHotfixDashBoardInfo.get("latestInstldDtls");
			Map avlblCmpntNmType = (Map)sftwrHotfixDashBoardInfo.get("avlblCmpntNmType");
			String gridSftwrHtfxLblName = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid."+softwareOrHotfix+" name");
			curInstldMngrDtFrmtStr = (String) sftwrHotfixDashBoardInfo.get("curInstldMngrDtFrmtStr");
			
			//Total components Details
			List ttlOsNmsDtls = (ArrayList) sftwrHotfixDashBoardInfo.get("totalCmpnts");
			Integer totalcount =(Integer)ttlOsNmsDtls.get(0);
			LinkedHashMap ttlOsNmCount = (LinkedHashMap)ttlOsNmsDtls.get(1);
			
			//Installation Details
			List instldOsNmDtls = (ArrayList)sftwrHotfixDashBoardInfo.get("insltdosNms");
			Integer instldCount =(Integer)instldOsNmDtls.get(0);
			LinkedHashMap instldOsNmCount = (LinkedHashMap)instldOsNmDtls.get(1);
			LinkedHashMap top10Instld = (LinkedHashMap) sftwrHotfixDashBoardInfo.get("topInsltdBar");
			
			//Uninstallation Details
			List unInstldOsNmDtls = (ArrayList)sftwrHotfixDashBoardInfo.get("uninsltdosNms");
			Integer unInstldCount =(Integer)unInstldOsNmDtls.get(0);
			LinkedHashMap unInstldOsNmCount = (LinkedHashMap)unInstldOsNmDtls.get(1);
			LinkedHashMap top10Uninstld = (LinkedHashMap) sftwrHotfixDashBoardInfo.get("topUninsltdBar");
			
			String osName = (String)sftwrHotfixDashBoardInfo.get("osName");
			String cmpntType = (String)sftwrHotfixDashBoardInfo.get("cmpntType");
			
			String weekLabel = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.week");
			String monthLabel = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.month");
			String timelineLabel = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.timeline."+timeline);
			String instlInTheLable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.installations in the last");
			String uninstlInTheLable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.uninstallations in the last");
			String instlTop10GrapLbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Top 10 installed");
			String unInstlTop10GrapLbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Top 10 uninstalled");
			String instlInTheLableLtst = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.in the last");


			
			//Lables Details of lang Entry
			if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
			{
				lableOfSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Software")+" ";
				lableOfSftwrsHotfixs = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.softwares")+" ";
				
				if("Last week".equalsIgnoreCase(timeline))
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+weekLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+weekLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+weekLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+weekLabel;
				}
				else if("Last month".equalsIgnoreCase(timeline))
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+monthLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+monthLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+monthLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+monthLabel;				
				}
				else
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+timelineLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+timelineLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+timelineLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLableLtst+" "+timelineLabel;				
				}
				gridHeaderLbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Most recent software installation details on")+" "+curInstldMngrDtFrmtStr;
			}
			else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareOrHotfix))
			{
				lableOfSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Hotfix")+" ";
				lableOfSftwrsHotfixs = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.hotfixes")+" ";
				
				if("Last week".equalsIgnoreCase(timeline))
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+weekLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+weekLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+weekLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+weekLabel;
				}
				else if("Last month".equalsIgnoreCase(timeline))
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+monthLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+monthLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+monthLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+monthLabel;				
				}
				else
				{
					instldLable = lableOfSftwrHotfix+" "+instlInTheLable+" "+timelineLabel;
					uninstldLable =lableOfSftwrHotfix+" "+uninstlInTheLable+" "+timelineLabel;
					instldGrapLbl = instlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+timelineLabel;
					uninstldGrapLbl = unInstlTop10GrapLbl+" "+lableOfSftwrsHotfixs+" "+instlInTheLable+" "+timelineLabel;				
				}
				gridHeaderLbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Most recent hotfix installation details on")+" "+curInstldMngrDtFrmtStr;
			}
			
			if(ttlOsNmCount != null && ttlOsNmCount.size()>0)
			{	
				Iterator totalItr = ttlOsNmCount.keySet().iterator();
				int ttlCnt = 0;
				while(totalItr.hasNext())
				{	 
					String currentKey = (String) totalItr.next();
					String countAndClrsVal = (String)ttlOsNmCount.get(currentKey);
					totalCmpntStr += currentKey+ ",";
					totalCountCommanSep += countAndClrsVal+",";
					totalDonutColor +=totalDonutClrsArr[ttlCnt]+",";
					if(totalDonutClrsArr.length == ttlCnt)
					{
						ttlCnt = 0;
					}
					ttlCnt++;
				}
				totalCmpntStr = (totalCmpntStr.lastIndexOf(",") != -1) ? (totalCmpntStr.substring(0, totalCmpntStr.length()-1)): totalCmpntStr;
				totalCountCommanSep = (totalCountCommanSep.lastIndexOf(",") != -1) ? (totalCountCommanSep.substring(0, totalCountCommanSep.length()-1)): totalCountCommanSep;
				totalDonutColor = (totalDonutColor.lastIndexOf(",") != -1) ? (totalDonutColor.substring(0, totalDonutColor.length()-1)): totalDonutColor;
			}
			if(instldOsNmCount != null && instldOsNmCount.size()>0)
			{
				Iterator instaldItr = instldOsNmCount.keySet().iterator();
				int instldCnt = 0;
				while(instaldItr.hasNext())
				{	
					String currentKey = (String) instaldItr.next();
					String countAndClrsVal = (String)instldOsNmCount.get(currentKey);
					instldOSCommaSep += currentKey+ ",";
					instldCountCommaSep += countAndClrsVal+",";
					instldDonutClrs += instldDonutClrsArr[instldCnt]+",";
					if(instldDonutClrsArr.length == instldCnt)
					{
						instldCnt = 0;
					}
					instldCnt++;
				}
				instldOSCommaSep = (instldOSCommaSep.lastIndexOf(",") != -1) ? (instldOSCommaSep.substring(0, instldOSCommaSep.length()-1)): instldOSCommaSep;		
				instldCountCommaSep = (instldCountCommaSep.lastIndexOf(",") != -1) ? (instldCountCommaSep.substring(0, instldCountCommaSep.length()-1)): instldCountCommaSep;
				instldDonutClrs = (instldDonutClrs.lastIndexOf(",") != -1) ? (instldDonutClrs.substring(0, instldDonutClrs.length()-1)): instldDonutClrs;
			}
			if(unInstldOsNmCount != null && unInstldOsNmCount.size()>0)
			{
				Iterator uninstaldItr = unInstldOsNmCount.keySet().iterator();
				int unInstldCnt =0;
				while(uninstaldItr.hasNext())
				{
					String currentKey = (String) uninstaldItr.next();
					String countAndClrsVal = (String)unInstldOsNmCount.get(currentKey);
					uninstldOSCommaSep += currentKey+ ",";
					uninstldCountCommaSep += countAndClrsVal+",";
					uninstldDonutClrs += uninstldDonutClrsArr[unInstldCnt]+",";
					if(instldDonutClrsArr.length == unInstldCnt)
					{
						unInstldCnt = 0;
					}
					unInstldCnt++;
				}
				uninstldOSCommaSep = (uninstldOSCommaSep.lastIndexOf(",") != -1) ? (uninstldOSCommaSep.substring(0, uninstldOSCommaSep.length()-1)): uninstldOSCommaSep;
				uninstldCountCommaSep = (uninstldCountCommaSep.lastIndexOf(",") != -1) ? (uninstldCountCommaSep.substring(0, uninstldCountCommaSep.length()-1)): uninstldCountCommaSep;
				uninstldDonutClrs = (uninstldDonutClrs.lastIndexOf(",") != -1) ? (uninstldDonutClrs.substring(0, uninstldDonutClrs.length()-1)): uninstldDonutClrs;	
			}
		
%>

<!Doctype html>
	<head>
		<title><egui:intnl text="configmgmt.SoftwareHotfix.Dashboard"/> <%= " "+lableOfSftwrHotfix +" " %> <egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results"/> </title>
		<meta name="Author" content="">
		<meta  charset="UTF-8">
		<egui:skin ui = "configcompliancecheck"/>
		<link rel="stylesheet" type="text/css" href="/final/styles/componentsLight.css" />
		<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
		<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
		<link rel="stylesheet" type="text/css" href="/final/config/styles/newConfigStyles_Light.css" />
		
		
	</head>
	<body style="padding:10px;background-color:#ffffff">
		<%  
			if(ec_forPDF != null && "No".equalsIgnoreCase(ec_forPDF))
			{
		%>
				<div class="printHeaderBoxLogo"><img src="/final/images/eGLogo.png" border="0"></div>
				<div class="printHeaderBox">
					<div class="printHeaderBoxTitle" style="float:left;"><%=lableOfSftwrHotfix %><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results" /></div>
					<div class="printHeaderBoxPrintIcon" style="float:left;">
						<img class="mouse iconPrinter" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<%=(String)mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.PRINT")%>' title='<%=(String)mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.PRINT")%>'/>
					</div>
				</div>
		<%		
			}
			else if(ec_forPDF != null && "Yes".equalsIgnoreCase(ec_forPDF))
			{
		%>
				<div class="printHeaderBoxLogo" style="top:10px"><img src="/final/images/eGLogo.png" border="0"></div>
				<div class="printHeaderBox" style="padding-top:20px;padding-bottom:10px">
					<div class="printHeaderBoxTitle" style="float:left;"><%=lableOfSftwrHotfix %><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results" /></div>
					
				</div>
		<%		
			}
		%>
		
		

		<div class="printOuterBox" style="background:#ffffff;margin-top:10px;display:inline-block">
				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.View By :" /><span class="bold">&nbsp;<%=viewBy%></span></div>
				<%
				  if(!("Component".equalsIgnoreCase(viewBy)))
				  {
				%>
					<div class="printSelectionFields"><%=viewBy+" :"%><span class="bold"><%=ec_userOption%></span></div>
				<%
				  }
				%>
				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hotfix/Software :" /><span class="bold">&nbsp;<%=softwareOrHotfix%></span></div>
				
				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Operating system :" /><span class="bold">&nbsp;<%=osName%></span></div>
						
				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component type :" /><span class="bold">&nbsp;<%=cmpntType%></span></div>

				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From Date :" /><span class="bold">&nbsp;<%=dateTimeFormat.format(fromDate.getTime())%></span></div>

				<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To Date :" /><span class="bold">&nbsp;<%=dateTimeFormat.format(toDate.getTime())%></span></div>		
		</div>
		
		<div class="printOuterBox" style="margin-top:10px;"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Total components details" />
			</div>
			<div>
				<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
					<%
						if(ttlOsNmCount != null && ttlOsNmCount.size()>0)
						{
							if(ec_forPDF != null)
							{
					%>		

								<tr>
									<td align="right" valign="middle" width="15%">
										<table>
											<tr>
												<td ><div class="iconTotalComponents"></div></td>
												<td ><div class="f45-normal"  style="margin:0 5px; "><%=totalcount%></div></td>
											</tr>
										</table>
									</td>
									<td align="right" valign="middle" width="20%">
										<div style="width:137px;margin-top:10px;padding-left: 13px;padding-right: 13px;">
											<img style="background-color:white; margin:0 0 0 0;" src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=SOFTWARE_HOTFIX&chartType=PieChart&height=110&width=110&sampleValues=<%=EgURLEncoder.encode(totalCountCommanSep,"UTF-8")%>&sampleLabels=<%=EgURLEncoder.encode(totalCmpntStr,"UTF-8")%>&sampleColors=<%=EgURLEncoder.encode(totalDonutColor,"UTF-8")%>&chartTitle=&titleFontSizeInPx=40&titleVrtclPosAdjst=0" border="0" hspace="0">
										</div>
									</td>
									<td align="left" valign="middle" width="65%">
										<div>
														<%
															Iterator itr =ttlOsNmCount.keySet().iterator();
															int incr = 0;
															while(itr.hasNext())
															{
																String currentkey = (String)itr.next();
																String currentVal = (String) ttlOsNmCount.get(currentkey);
																if(EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(currentkey))
																{
																	currentkey = labelNotAvailable;
																}
														%>
																<div><svg xmlns="http://www.w3.org/2000/svg" width="500" height="20"><g>

																<circle cx="10" cy="10" r="4" fill="<%=totalDonutClrsArr[incr] %>" stoke-width="0" ></circle>

																<text x="0" y="0" font-family="'Roboto',sans-serif" text-anchor="start" fill="#000000" dx="20" dy="15"><%=currentkey+" ("+currentVal+")"%></text>

																</g></svg></div>
															
														<%
																incr++;
																}
														%>
										</div>
									</td>
								</tr>
							<%
							}
						}
						else
						{
					%>
					
						<tr>
							<td width="100%" style="text-align:center;height:100px;border:0px solid none" align="center" valign="middle">
							
								<table width="100%" height="100%" style="height:100px"><tr><td align="center" valign="middle"><table><tr><td align="center" height="30" valign="bottom"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" ><div class="commonErrorMsgText" style="padding:5px;"><%= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Total components details not available") %></td></tr></table></div></td></tr>
								
								</table>								
							</td>
						</tr>
						
							
							
					<%
						}
					%>
				</table>
			</div>
		</div>
		<div class="printOuterBox" style="margin-top:10px;"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=instldLable%></div>
			<div >
				<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
					<%
						if(instldOsNmCount!= null && instldOsNmCount.size()>0)
						{
							if(ec_forPDF != null)
							{
					%>
								<tr>
									<td  align="right" valign="middle" width="15%">
										<table>
											<tr>
												<td ><div class="iconSoftwareChanges"></div></td>
												<td ><div class="f45-normal"  style="margin:0 5px; "><%=instldCount%></div></td>
											</tr>
										</table>
									</td>
									<td  align="right" valign="middle" width="20%">
										<div style="width:137px;margin-top:10px;padding-left: 13px;padding-right: 13px;">
											<img style="background-color:white; margin:0 0 0 0;" src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=SOFTWARE_HOTFIX&chartType=PieChart&height=110&width=110&sampleValues=<%=EgURLEncoder.encode(instldCountCommaSep,"UTF-8")%>&sampleLabels=<%=EgURLEncoder.encode(instldOSCommaSep,"UTF-8")%>&sampleColors=<%=EgURLEncoder.encode(instldDonutClrs,"UTF-8")%>&chartTitle=&titleFontSizeInPx=40&titleVrtclPosAdjst=0" border="0" hspace="0">								
										</div>
									</td>
									<td align="left" valign="middle" width="65%">
										<div>
											<%
											
													Iterator itr1 =instldOsNmCount.keySet().iterator();
													int cnt =0;
													while(itr1.hasNext())
													{
														String currentkey = (String)itr1.next();
														String currentVal = (String) instldOsNmCount.get(currentkey);
														if(EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(currentkey))
														{
															currentkey = labelNotAvailable;
														}
											%>
														<div><svg xmlns="http://www.w3.org/2000/svg" width="500" height="20"><g>

															<circle cx="10" cy="10" r="4" fill="<%=instldDonutClrsArr[cnt] %>" stoke-width="0" ></circle>

															<text x="0" y="0" font-family="'Roboto',sans-serif" text-anchor="start" fill="#000000" dx="20" dy="15"><%=currentkey+" ("+currentVal+")"%></text>

															</g></svg></div>																
														
											<%
													cnt++;
													}
											%>
										</div>
										
									</td>
								</tr>
					
							<%
							}
						}
						else
						{
					%>
					
						<tr>
							<td width="100%" style="text-align:center;height:100px;border:0px solid none" align="center" valign="middle">
							
								<table width="100%" height="100%" style="height:100px"><tr><td align="center" valign="middle"><table><tr><td align="center" height="30" valign="bottom"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" ><div class="commonErrorMsgText" style="padding:5px;"><%= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.No")+" "+instldLable %></td></tr></table></div></td></tr>
								
								</table>								
							</td>
						</tr>
										
					<%
						}
					%>
				</table>
			</div>
		</div>
		<div class="printOuterBox" style="margin-top:10px;"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=uninstldLable %></div>
			<div>
				<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
					<%
						if(unInstldOsNmCount != null && unInstldOsNmCount.size()>0)
						{
							if(ec_forPDF != null)
							{
					%>
								<tr>
									<td align="right" valign="middle" width="15%">
										<table>
											<tr>
												<td ><div class="iconSoftwareChanges"></div></td>
												<td ><div class="f45-normal"  style="margin:0 5px; "><%=unInstldCount%></div></td>
											</tr>
										</table>
									</td>
									<td align="right" valign="middle" width="20%">
										<div style="width:137px;margin-top:10px;padding-left: 13px;padding-right: 13px;">
											<img style="background-color:white; margin:0 0 0 0;" src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=SOFTWARE_HOTFIX&chartType=PieChart&height=110&width=110&sampleValues=<%=EgURLEncoder.encode(uninstldCountCommaSep,"UTF-8")%>&sampleLabels=<%=EgURLEncoder.encode(uninstldOSCommaSep,"UTF-8")%>&sampleColors=<%=EgURLEncoder.encode(uninstldDonutClrs,"UTF-8")%>&chartTitle=&titleFontSizeInPx=40&titleVrtclPosAdjst=0" border="0" hspace="0">
										</div>
									</td>
									<td align="left" valign="middle" width="65%">
										<div >
											<%	
												Iterator itr2 =unInstldOsNmCount.keySet().iterator();
												int incr = 0;
												while(itr2.hasNext())
												{
													String currentkey = (String)itr2.next();
													String currentVal = (String) unInstldOsNmCount.get(currentkey);
													if(EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(currentkey))
													{
														currentkey = labelNotAvailable;
													}
											%>
																						
													<div><svg xmlns="http://www.w3.org/2000/svg" width="500" height="20"><g>

														<circle cx="10" cy="10" r="4" fill="<%=uninstldDonutClrsArr[incr] %>" stoke-width="0" ></circle>

														<text x="0" y="0" font-family="'Roboto',sans-serif" text-anchor="start" fill="#000000" dx="20" dy="15"><%=currentkey+" ("+currentVal+")"%></text>

														</g></svg></div>															
													
											<%
													incr++;
												}
											%>
										</div>
									</td>
								</tr>
					<%
							}
						}
						else 
						{
					%>
					
					
					<tr>
							<td width="100%" style="text-align:center;height:100px;border:0px solid none" align="center" valign="middle">
							
								<table width="100%" height="100%" style="height:100px"><tr><td align="center" valign="middle"><table><tr><td align="center" height="30" valign="bottom"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" ><div class="commonErrorMsgText" style="padding:5px;"><%= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.No")+" "+uninstldLable %></td></tr></table></div></td></tr>
								
								</table>								
							</td>
						</tr>
						
					
						
					<%
						}
					%>
				</table>
			</div>
		</div>
		<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=instldGrapLbl%></div>
			
					<%
						if(top10Instld != null && top10Instld.size()>0)
						{
					%>	
					<div class="newTable">
						<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
							<thead>
								<tr>
									<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.SerialNumber" /></th>
									<th style="width:60%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software Name" /></th>
									<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Percentage" /></th>
									</th>
								</tr>
							</thead>
							<tbody>
							<%
								if(top10Instld != null && top10Instld.size()>0)
								{
									Iterator topInstalledItr =top10Instld.keySet().iterator();
									int instCount = 0;
									while(topInstalledItr.hasNext())
									{
										instCount++;
										String currentKey = (String) topInstalledItr.next();
							%>
										<tr>
											<td align="left" style="word-break:break-all"><%=instCount%></td>
											<td align="left" style="word-break:break-all"><%=currentKey%></td>
											<td align="left" style="word-break:break-all"><%=(String)top10Instld.get(currentKey)%></td>
										</tr>
							<%
										
									}
								}
							%>
							</tbody>
						</table>
					</div>
			<%
				}
				else
				{
			%>
					<div >
						<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
							<tr>
							
							
							<td width="100%" style="text-align:center;height:100px;border:0px solid none" align="center" valign="middle">
							
								<table width="100%" height="100%" style="height:100px"><tr><td align="center" valign="middle"><table><tr><td align="center" height="30" valign="bottom"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" ><div class="commonErrorMsgText" style="padding:5px;"><%= instldGrapLbl+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Not available") %></td></tr></table></div></td></tr>
								
								</table>								
							</td>								
							</tr>
						</table>
					</div>
			<%		
				}
			%>
		</div>
		<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=uninstldGrapLbl%></div>			
					<%
						if(top10Uninstld != null && top10Uninstld.size()>0)
						{
					%>
					<div class="newTable">
						<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
							<thead>
								<tr>
									<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.SerialNumber" /></th>
									<th style="width:60%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software Name" /></th>
									<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Percentage" /></th>
									</th>
								</tr>
							</thead>
							<tbody>
								<%
									if(top10Uninstld != null && top10Uninstld.size()>0)
									{
										Iterator topUnistdItr =top10Uninstld.keySet().iterator();
										int uninstCount = 0;
										while(topUnistdItr.hasNext())
										{
											uninstCount++;
											String currentKey = (String) topUnistdItr.next();
								%>
											<tr>
												<td align="left" style="word-break:break-all"><%=uninstCount%></td>
												<td align="left" style="word-break:break-all"><%=currentKey%></td>
												<td align="left" style="word-break:break-all"><%=(String)top10Uninstld.get(currentKey)%></td>
											</tr>
								<%
										}
									}
								%>
							</tbody>
						</table>
					</div>
					<%
						}
						else
						{
					%>
					<div>
						<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
							<tr>
							<td width="100%" style="text-align:center;height:100px;border:0px solid none" align="center" valign="middle">
							
								<table width="100%" height="100%" style="height:100px"><tr><td align="center" valign="middle"><table><tr><td align="center" height="30" valign="bottom"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" ><div class="commonErrorMsgText" style="padding:5px;"><%= uninstldGrapLbl+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Not available") %></td></tr></table></div></td></tr>
								
								</table>								
							</td>
							</tr>							
						</table>
					</div>
					<%	
						}
					%>
				
		</div>
		<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
			<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=gridHeaderLbl%></div>
			<div class="newTable">
				<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
					<thead>
						<tr>
							<th style="width:10%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Component type" /></th>
							<th style="width:15%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Component name" /></th>
							<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Operating System" /></th>
							<th style="width:20%;white-space: normal;"  align="left"><%=gridSftwrHtfxLblName%></th>
							<%
								if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
								{
							%>
									<th style="width:10%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Version" /></th>
							<%
								}
							%>
							
							<th style="width:10%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Installed Date" />
							<th style="width:10%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.When reported?" />
							</th>
						</tr>
					</thead>
					<tbody>
						<%
							if(latestInstldDtls != null && latestInstldDtls.size()>0)
							{
								DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
								for(int incr=0; incr<latestInstldDtls.size(); incr++)
								{
									List currentRow = (List)latestInstldDtls.get(incr);
						%>
									<tr>
										<td align="left" style="word-break:break-all"><%= mappingInfo.getComponentTypeDescription((String)avlblCmpntNmType.get((String)currentRow.get(0)))%></td>
										<td align="left" style="word-break:break-all"><%=(String)currentRow.get(0)%></td>
										<%
											String curOsName = (String)currentRow.get(1);
											if(curOsName != null && !EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(curOsName))
											{
										%>
												<td align="left" style="word-break:break-all"><%=curOsName%></td>
										<%
											}
											else
											{
										%>
												<td align="left" style="word-break:break-all"><%=labelNotAvailable%></td>
										<%
											}
										%>
												<td align="left" style="word-break:break-all"><%=(String)currentRow.get(2)%></td>
										<%
											if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
											{
										%>
												<td align="left" style="word-break:break-all"><%=(String)currentRow.get(5)%></td>
										<%
											}
										%>
										<td align="left" style="word-break:break-all"><%=new SimpleDateFormat(currentDateFormat).format((Date)currentRow.get(3))%></td>
										<td align="left" style="word-break:break-all"><%=new SimpleDateFormat(currentDateFormat+" HH:mm:ss").format((Date)currentRow.get(4))%></td>
									</tr>
						<%
								}
							}								
						%>
					</tbody>
				</table>		
			</div>
		</div>
	</body>
</html>
<%	
		}
		session.setAttribute("configLastAccessedURL","/final/config/EcSoftwareHotfixIndex.jsp?cmd=SoftwareHotfix");
	}		
%>


