Ext.define('EgCorAlarm.controller.UnknownController', {
	extend: 'Ext.app.Controller',
	views:['currentAlarms.view.AlarmFilters'],
	refs:[
		{selector:'alarmfilters', ref:'alarmfilters'},
		{selector:'currentalarmssummary', ref:'currentalarmssummary'}
	],
	init: function () {
		this.control({
	   		'alarmfilters combo[name="showCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="filterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="subFilterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="searchByCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters textfield[name="searchTextBox"]':
			{
				'keyup' : this.searchAlarms,
				'ontriggerclick': this.searchAlarms
			},
			'#searchTextBox' : {
				afterrender:function(){
					var searchTextBox = Ext.fly(Ext.select('#searchTextBox').elements[0]).dom.className;
					if(searchTextBox.indexOf("incidentMgmt") == -1){
						Ext.fly(Ext.select('#searchTextBox').elements[0]).addCls('incidentMgmt');
					}
					$('#searchTextBox').css({'margin':'8px 10px 0px 0px'});
				}
			},
			'alarmfilters button[action=Save CSV]':{
				click : this.saveInCSVFormat
			},
			'alarmfilters button[action=Save PDF]' : {
				click : this.saveInPDFFormat
			},
			'button[action=UpdateSettings1]' : {
				click : this.showOtherData
			},
			'combo[id="eg_timeline"]': {
				"select": this.changeTimeline
			},
			'radio[id="current1"]':{
				"afterrender":this.changeFilters,
				"change":this.changeFilters
			}
		});
	},
	changeFilters : function(e){
		if(e.checked){
			Ext.getCmp('eg_timeline').setDisabled(true);
			if(Ext.getCmp('eg_timeline').getValue() == "Any"){
				Ext.getCmp('eg_stdate').setDisabled(true);
				Ext.getCmp('starthr').setDisabled(true);
				Ext.getCmp('eg_enddate').setDisabled(true);
				Ext.getCmp('endhr').setDisabled(true);
			}
		}else{
			Ext.getCmp('eg_timeline').setDisabled(false);
			if(Ext.getCmp('eg_timeline').getValue() == "Any"){
				Ext.getCmp('eg_stdate').setDisabled(false);
				Ext.getCmp('starthr').setDisabled(false);
				Ext.getCmp('eg_enddate').setDisabled(false);
				Ext.getCmp('endhr').setDisabled(false);
			}
		}
	},
	changeTimeline : function(obj) {

		var getTimelineVal = Ext.getCmp('eg_timeline').getValue();
		var stDateObj = Ext.getCmp('eg_stdate');
		var endDateObj = Ext.getCmp('eg_enddate');
		var stHrObj = Ext.getCmp('starthr');
		var endHrObj = Ext.getCmp('endhr');
		var startminObj = Ext.getCmp('startmin');
		var endminObj = Ext.getCmp('endmin');
		
		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
			startminObj.setDisabled(false);
			endminObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
			startminObj.setDisabled(true);
			endminObj.setDisabled(true);
		}
		if(getTimelineVal!='Any')
		{
    		var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
    		var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
    		if (!Ext.isEmpty(obj)) {
    			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
    					+ getTimelineVal
    					+ '&P1='
    					+ encodeURIComponent(strtdt)
    					+ '&P2='
    					+ encodeURIComponent(enddt)
    					+ '&P3='
    					+ stHrObj.getValue()
    					+ '&P4='
    					+ endHrObj.getValue()
    					+ '&P5=' + encodeURIComponent(currentDateFormat);
    			var me = this;
    			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					timeout:300000,
					success : function(response) {
					var formdata = Ext.decode(response.responseText);
					/*stDateObj.setValue(formdata[0]);
					endDateObj.setValue(formdata[1]);
					stHrObj.setValue(formdata[2]);
					endHrObj.setValue(formdata[3]);*/

					stDateObj.dataArray = formdata[0];
					endDateObj.dataArray = formdata[1];
					stHrObj.dataArray = formdata[2];
					endHrObj.dataArray = formdata[3];

					stDateObj.setValue(formdata[6]);
					endDateObj.setValue(formdata[7]);
					stHrObj.setValue(formdata[8]);
					endHrObj.setValue(formdata[9]);
					//params = form.findField('eg_timeline').getValue();
					//alert(params);
					Ext.Ajax.request({
						url : '/final/monitor/EgTimeSelect.jsp?time_line='+getTimelineVal,
						timeout:300000,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							me.dbStartDate = formdata.hiddenFields.dbstrtdate;
							me.dbEndDate = formdata.hiddenFields.dbenddate;
						}
					});
					}
				});
    		}
		}
	},
	showOtherData : function(){
		var getTimelineVal = Ext.getCmp('eg_timeline').getValue();
		var stdate = Ext.getCmp('eg_stdate').getRawValue();
		var enddate = Ext.getCmp('eg_enddate').getRawValue();
		var sthr = Ext.getCmp('starthr').getValue();
		var stmin = Ext.getCmp('startmin').getValue();
		var endhr = Ext.getCmp('endhr').getValue();
		var endmin = Ext.getCmp('endmin').getValue();

		var dur = Ext.ComponentQuery.query('[name="duration"]')[0].getValue();
		var ts = Ext.ComponentQuery.query('[name="timeselect"]')[0].getValue();
		var cond = Ext.ComponentQuery.query('[name="glduration"]')[0].getValue();
				
		if(cond!=null && cond=='<')
			dur = -dur;
		else if(cond)
			dur = "0" + dur;

		var sortBy = Ext.ComponentQuery.query('[name="sortBy"]')[0].getValue();
		var params1 = this.updateQueryString(Ext.getCmp("subFilterCombo"));
		var params =  params1+"&duration="+dur+"&timeselect="+ts+"&eg_timeline="+ getTimelineVal +"&eg_stdate=" +  stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&startmin="+  stmin  +"&endmin="+  endmin  +"&endhr=" + endhr +"&arrangeUnknown="+sortBy;
		var showCurrentUnk = Ext.getCmp('current1').checked;
		var defaultParams = "currentMainPage=NotAlarms&newWindowAlarm=true&alarmType=CurrentUnknown&isForCurrent="+showCurrentUnk;
		var browser=get_browser_info();
		
		Ext.getBody().mask("Loading...");
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCurrentAlarmsC',
			method : 'POST',
			timeout:300000,
			params: defaultParams+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&maxDurationAlarmIds="+maxDurationAlarmIds+"&isFromQuickLink="+isFromQuickLink+"&getdiffTest=UNKNOWN_HISTORY"+params,
			scope:this,
			success: function(response)
			{
				//var jsonText = response.responseText;
				//var jsonData=Ext.decode(jsonText);
				var jsonData = JSON.parse( response.responseText);
				publicJson = jsonData;
				var currentAlmsGrid = Ext.getCmp('currentAlarmsGrid');
				//var fullyDataq = currentAlmsGrid.fullData;
				//var fullyData = JSON.parse(JSON.stringify(fullyDataq));
				Ext.ComponentQuery.query('[itemId="unknownLabel"]')[0].setText((showCurrentUnk)?"<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Current Unknowns":"<span class='iconFullTime' style='margin-right: 5px;display: inline-block;'></span>Showing Last "+getTimelineVal,false);
				try
				{
					if(publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData")){
						publicJson.gridJson.fullData = JSON.parse(JSON.stringify(publicJson.gridJson.gridData));
					}
					if(showCurrentUnk){
						if(publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData"))
							publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){return columnData["COLUMN_8"] === "Current"});
					}/*
					else{
						if(publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData"))
							publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){return columnData["COLUMN_8"] !== "Current"});
					}*/	
					publicJson['DefaultPageSize'] = Ext.ComponentQuery.query('[name="eventsPerPage"]')[0].getValue();
					currentAlmsGrid.generateAlarmGrid();
					currentAlmsGrid.headerCt.gridDataColumns[0].hide();
					EgCorAlarm.app.getController('Main').closeConfig(false);
					Ext.getBody().unmask();
					setSession(activeView,showCurrent,showCurrentUnk);	
				}
				catch (e)
				{
					Ext.getBody().unmask();
				}
			}
		});			
	},
	saveInCSVFormat : function()
	{
		if(!Ext.isEmpty(this.getCurrentalarmssummary()) && this.getCurrentalarmssummary().getStore().getCount()>0){
			try{
				var searchValue = "";
				var s_qryString = "";
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				var equals = encodeURIComponent("|eq|");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getFieldLabel()+equals+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+equals+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+equals+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue())){
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getCurrentalarmssummary().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems)){
					var prop = soringItems[0].property;
					var index= parseInt(prop.substring(prop.length-1));
					if(!Ext.isEmpty(prop) && prop == 'COLUMN_8_Ref'){
						prop = 'COLUMN_8';
						index = 8;
					}
					var columnsDataIndex = [];
					this.getCurrentalarmssummary().columns.map(function(item,i){
						var allow = (item.hasOwnProperty("hidden") && item.hidden)?false:true; 
						if(item.hasOwnProperty("dataIndex") && !Ext.isEmpty(item.dataIndex) && allow){
							columnsDataIndex.push(item.dataIndex);
						}
					});
					index = columnsDataIndex.indexOf(prop)+1;
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+index;
				}
				if(!Ext.isEmpty(searchValue) || !Ext.isEmpty(soringItems)){
					Ext.Ajax.request({
						url : '/final/monitor/currentAlarmsPdf.jsp?loadCSV=true'+s_qryString,
						scope:this,
						timeout:300000,
						success: function(response){
							var jsonText = response.responseText;
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes&searchSorting=true"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						},
						failure:function(){
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						}
					});
				}
				else
					window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
			catch (e){
				window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	saveInPDFFormat : function()
	{
		var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?from=currentAlarm";
		if(!Ext.isEmpty(this.getCurrentalarmssummary()) && this.getCurrentalarmssummary().getStore().getCount()>0)
		{
			try
			{
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getFieldLabel()+" : "+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+" : "+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+" : "+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				var searchValue = "";
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue()))
				{
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getCurrentalarmssummary().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems))
				{
					var prop = soringItems[0].property;
					var index = parseInt(prop.substring(prop.length-1));
					if(!Ext.isEmpty(prop) && prop == 'COLUMN_8_Ref'){
						prop = 'COLUMN_8';
						index = 8;
					}
					var columnsDataIndex = [];
					this.getCurrentalarmssummary().columns.map(function(item,i){
						var allow = (item.hasOwnProperty("hidden") && item.hidden)?false:true; 
						if(item.hasOwnProperty("dataIndex") && !Ext.isEmpty(item.dataIndex) && allow){
							columnsDataIndex.push(item.dataIndex);
						}
					});
					index = columnsDataIndex.indexOf(prop)+1;
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+index;
				}
				var  progressBar= Ext.MessageBox.progress({
					title: 'Downloading',
					value: 5,
					width: 350,
					increment: 15,
					closable: false,
					progressText: 'Connecting..',
					wait: true,
					waitConfig: {
						interval: 200
					},
					msg: '<b>Downloading, please wait...</b>',
					scope: this,
					handler: function () {
						this.updateText('Done!');
					}
				});
				var iFrameExists = Ext.query("#pdfIframe");
				if(Ext.isEmpty(iFrameExists))
				{
					Ext.DomHelper.append(document.body, {
						tag: 'iframe',
						frameBorder: 0,
						width: 0,
						height: 0,
						css: 'display:none;visibility:hidden;height:1px;',
						src: s_qryString,
						id: 'pdfIframe'
					});
				}
				else
				{
					Ext.select('#pdfIframe').set( { src :  s_qryString });
				}
				Ext.Ajax.request({
					url : '/final/monitor/EgSaveStatus.jsp?downloadFile=true',
					scope:this,
					timeout:300000,
					//timeout:5000,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							var downloadStatus = jsonData.downloadStatus;
							try
							{
								if(downloadStatus.toUpperCase() == 'DONE')
								{
									progressBar.hide();
								}
							}
							catch (e)
							{
								progressBar.hide();
							}
						}
					},
					failure:function(response){
						progressBar.hide();
					}
				});
			}
			catch (e)
			{
				progressBar.hide();
				//console.log(e)
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	searchAlarms:function(field, event ){
		var isTrigger = false;
		if(!Ext.isEmpty(event) && !Ext.isEmpty(event.type) && event.type!=null && event.type!=undefined && event.type=='click')
			isTrigger = true;
		else if(!Ext.isEmpty(event) && event=='fire')
			isTrigger = true;

		searchAck=false;
		 
		var alarmType = publicJson['pageParams']['alarmType'];
		var showDeleteBtn = publicJson['pageParams']['showDeleteBtn'];
		var showAcknowledgeBtn = publicJson['pageParams']['showAcknowledgeBtn'];
		var emptText= '';
		if(alarmType!=null && ( alarmType=='CurrentAlarms' ||alarmType=='longestAlarms' ) )
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconNoalarms" style="margin:10% auto 0% auto"></div>No alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoalarms" style="margin:0px auto"></div><div style="text-align:center">No alarms found</div></div></div>';
		}
		else if(alarmType!=null && alarmType=='unAcknowledged')
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:10% auto 0% auto"></div>No UnAcknowledged alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No UnAcknowledged alarms found</div></div></div>';
		}
		else if(alarmType!=null && alarmType=='Acknowledged')
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:10% auto 0% auto"></div>No Acknowledged alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Acknowledged alarms found</div></div></div>';
		}
		else
			emptText = '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoalarms" style="margin:0px auto"></div><div style="text-align:center">No unknowns found</div></div></div>';

			if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
			{
				if(showDeleteBtn!=null && showDeleteBtn=='true' && alarmType!="CurrentUnknown")
				{
					Ext.getCmp('AlarmDeleteBtn').show();
				}
				else if((showDeleteBtn==undefined || showDeleteBtn==null || showDeleteBtn=='false') && alarmType=="CurrentUnknown")
				{
					Ext.getCmp('AlarmDeleteBtn').hide();
				}
				if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && alarmType!="CurrentUnknown")
				{
					Ext.getCmp('AlarmAcknowledgeBtn').show();
				}
				else if((showAcknowledgeBtn==undefined || showAcknowledgeBtn==null || showAcknowledgeBtn=='false') && alarmType=="CurrentUnknown")
				{
					Ext.getCmp('AlarmAcknowledgeBtn').hide();
				}
			}
		if( isTrigger || event.getKey() == event.ENTER  ){
			if(field == null || field == undefined || field.value == null || field.value == undefined)
				return;
			if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
			{
				this.getCurrentalarmssummary().getView().emptyText=emptText;
				//this.getCurrentalarmssummary().getView().emptyText='';
				if(field.value == '*')
				{
					this.getCurrentalarmssummary().getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
					
				}
				else if(field.value == '(' || field.value == ')' || field.value == '\\' || field.value == '?' || field.value == '[')
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please enter the valid search pattern',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					this.getCurrentalarmssummary().getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
					
				}
				else
				{
					var showCombo = Ext.getCmp('showCombo').getValue();
					
					//field.value = field.value.replace(".","\\.");
					field.value = field.value.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
					var regex = RegExp(field.value,'i');
					
					var cGrid = this.getCurrentalarmssummary().getStore();
					var pagingData=[];
					cGrid.clearFilter(true);
					cGrid.filter(new Ext.util.Filter({
						caseSensitive:true,
						filterFn: function (object) {
							var match = false;
							Ext.Object.each(object.data, function (property, value) {								
								if(showCombo != "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_5));
								else if(showCombo == "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_1)) || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4)));
								//match = match || regex.test(String(value));
							});
							if(true)
							{
								searchAck=true;
								pagingData.push(object.data);
							}
							return match;
						}
					}));
					
					//Filtering based on user input for pagination
					var pagingData = Ext.getCmp('pagingtoolbarid').getStore();
					pagingData.clearFilter(true);
					pagingData.filter(new Ext.util.Filter({
						caseSensitive:true,
						filterFn: function (object){
							var match = false;
							Ext.Object.each(object.data, function (property, value){								
								if(showCombo != "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_5));
								else if(showCombo == "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_1)) || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4)));
								//match = match || regex.test(String(value));
							});		
							searchAck=true;
							return match;
						}
					
					}));
					pagingData.loadPage(1);
					var meme = this;
					Ext.defer(function(){
						if(cGrid!=null && cGrid.data.length>0)
						{
							$('.x-grid-view').css('height','auto');
							if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								Ext.getCmp('ackOptionsid').show();
								//meme.getCurrentalarmssummary().getView().emptyText='';
							}
							//else
								//meme.getCurrentalarmssummary().getView().emptyText='';
								meme.getCurrentalarmssummary().getView().refresh();
						}
						else
						{
							$('.x-grid-view').css('height','100%');
							if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								//meme.getCurrentalarmssummary().getView().emptyText=emptText;
								Ext.getCmp('ackOptionsid').hide();
							}
							//else
								//meme.getCurrentalarmssummary().getView().emptyText=emptText;							

							meme.getCurrentalarmssummary().getView().refresh();
						}
					},10);
				}
			}
			else
			{
				this.getCurrentalarmssummary().getView().emptyText=emptText;
				this.getCurrentalarmssummary().getStore().clearFilter();
				Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
				Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
				
				if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
				{
					Ext.getCmp('ackOptionsid').show();
					//this.getCurrentalarmssummary().getView().emptyText=emptText;
				}
				var cGrid = this.getCurrentalarmssummary().getStore();
				Ext.defer(function(){
					if(!Ext.isEmpty(cGrid) && cGrid.data.length > 0)
						$('.x-grid-view').css('height','auto');
					else
						$('.x-grid-view').css('height','100%');
				},10);
			}
		}
		field.focus();
	},
	updateQueryString : function(objId)
	{
		var filterCombo = Ext.getCmp('filterCombo').getValue();
		var showCombo = Ext.getCmp('showCombo').getValue();
		var subFilterCombo = Ext.getCmp('subFilterCombo').getValue();
	//	var searchByCombo = Ext.getCmp('searchByCombo').getValue();
	//	var searchText = Ext.getCmp('searchTextBox').getValue();

		var QStr = '';// "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;


		/* if(filterCombo!=null && filterCombo=='componentTypes')
		{
		console.log('--');
			//Ext.getCmp('subFilterCombo').setWidth(250);
			Ext.getCmp('subFilterCombo').labelWidth= 150;
			Ext.getCmp('subFilterCombo').setWidth(250);
		} */

		var defaultAllAlarmsVal=publicJson['pageParams']['AllAlarmsOptVal'];
		if(defaultAllAlarmsVal!=null && !Ext.isEmpty(defaultAllAlarmsVal))
		{
			while (defaultAllAlarmsVal.indexOf("&")>-1)
			{
				defaultAllAlarmsVal=defaultAllAlarmsVal.replace('&','|amp|');
			}
		}
		/*if(defaultAllAlarmsVal!=null && (defaultAllAlarmsVal=='' || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal=='null'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}
		if((Ext.isEmpty(defaultAllAlarmsVal) || defaultAllAlarmsVal==undefined || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal == null || defaultAllAlarmsVal=='null') && filterCombo!=null && (filterCombo=='componentTypes' || filterCombo=='services' || filterCombo=='segments' || filterCombo=='zones' || filterCombo=='States'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}*/
		if(objId!=null && objId!='filterCombo') // if clicked combo is not filtercombo box
		{
			if((filterCombo!=null && filterCombo=='States')) // if priority is selected in filter combo box
			{
				if(objId!=null && objId=='subFilterCombo')  // if clicked combo is subfilter combo
				{
					showAlarms = subFilterCombo; // set priority value for alarms
					do{
						showAlarms=showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&')>0);
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	// encode and add subfilter combo value to query string
				}
				else if(objId!=null && objId=='searchByCombo') // if clicked combo is searchby combo
				{
					showAlarms = defaultAllAlarmsVal; // change priority value to all by default
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	 	// encode and add subfilter combo value to query string
				}
				else
				{
					//QStr = QStr+"&selectedSubFilterOption="+subFilterCombo; // add selected subfilter combo value to query string
					showAlarms = subFilterCombo; // set priority value for alarms
					do {
						showAlarms = showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&') > 0);
					QStr = QStr + "&selectedSubFilterOption=" + encodeURIComponent(showAlarms);
				
				}
			}
			else
			{
				QStr = QStr+"&selectedSubFilterOption="+subFilterCombo;	 // add selected subfilter combo value to query string
			}
		}
		else // if clicked combo is filter combo, then don't send subfiltercombo value
		{
			showAlarms = defaultAllAlarmsVal;
			QStr = QStr+"&selectedSubFilterOption="; // add empty value for subfilter combo in query string
		}
		if(showCombo!=null && ( showCombo=='CurrentAlarms' || showCombo=='Acknowledged' || showCombo=='unAcknowledged' ) )
		{
			QStr = QStr + "&showAlarms="+encodeURIComponent(showAlarms); // encode and add priority value to query string
		}

		QStr = QStr +'&alarmType='+showCombo;


		var hidQstr = '';
		var hiddenParams = publicJson['hiddenParams'];
		for(var hid in hiddenParams)
		{
			var hidVal = hiddenParams[hid];

			if(hidVal!=null)
				hidQstr = hidQstr+'&'+hid+'='+encodeURIComponent(hidVal);
			else
				hidQstr = hidQstr+'&'+hid+'='+hidVal;
		}
		QStr = QStr+"&selectedFilterOption="+filterCombo+hidQstr;
		QStr = QStr+"&isFromDashBoard="+!hideBackButton;

		return QStr;
	},
	loadAlarms : function(combo)
	{
		var combId = '';
		//var mainView1 = this.getMain();
		if(combo!=null)
			combId = combo.getId();
		var QStr = this.updateQueryString(combId);
		var currentAlmsGrid=this.getCurrentalarmssummary();
		var showCombo = Ext.getCmp('showCombo');
		var tmpQStr = '';
		if(!Ext.isEmpty(QStr) && QStr!=null && QStr!=undefined && QStr.indexOf('zoneDashboard')!=-1 && QStr.indexOf('zoneName')!=-1)
			tmpQStr = QStr;
		if(combId!=null && combId=='showCombo')
		{
			if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined && showCombo.getValue()=='CurrentAlarms'))
			{
				QStr='currentMainPage=NotAlarms';
				if(!Ext.isEmpty(tmpQStr))
					QStr+=tmpQStr;
			}
		}
		if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined) && showCombo.getValue()!='CurrentAlarms' && (isPopupWindow!=null && isPopupWindow=="true"))
		{
			QStr +="&isPopupWindow="+true;
		}
		if(!Ext.isEmpty(longestAlarms) && longestAlarms!=null && longestAlarms!=undefined)
			QStr +="&maxDurationAlarmIds="+longestAlarms;
		
		var emtText = Ext.get("emptyTextTb");
		try
		{
			if(emtText != null)
			Ext.get("emptyTextTb").hide();
		}
		catch (e)
		{
		}

		try
		{
			if(isCitrix)
			{
				if(loadUnknown)
					QStr = ctx_defaultParams+"&state=UNKNOWN";
				else{
					var state_sel = Ext.getCmp('subFilterCombo').getValue();
					if(!Ext.isEmpty(state_sel) && state_sel!=null && state_sel!=undefined && state_sel.indexOf('&')!=-1)
						state_sel= state_sel.replace(/&/g, '|amp|');
					QStr = ctx_defaultParams+"&state="+encodeURIComponent(state_sel);
				}
			}
		}
		catch (ee)
		{
		}
		alarmLoadMask.show();
		var browser=get_browser_info();
		var getTimelineVal = Ext.getCmp('eg_timeline').getValue();
		var stdate = Ext.getCmp('eg_stdate').getRawValue();
		var enddate = Ext.getCmp('eg_enddate').getRawValue();
		var sthr = Ext.getCmp('starthr').getValue();
		var stmin = Ext.getCmp('startmin').getValue();
		var endhr = Ext.getCmp('endhr').getValue();
		var endmin = Ext.getCmp('endmin').getValue();

		var dur = Ext.ComponentQuery.query('[name="duration"]')[0].getValue();
		var ts = Ext.ComponentQuery.query('[name="timeselect"]')[0].getValue();
		var cond = Ext.ComponentQuery.query('[name="glduration"]')[0].getValue();
				
		if(cond!=null && cond=='<')
			dur = -dur;
		else if(cond)
			dur = "0" + dur;

		var sortBy = Ext.ComponentQuery.query('[name="sortBy"]')[0].getValue();
		
		var showCurrentUnk = Ext.getCmp('current1').checked;
		var params =  "&duration="+dur+"&timeselect="+ts+"&eg_timeline="+ getTimelineVal +"&eg_stdate=" +  stdate + "&eg_enddate=" + enddate + "&starthr=" + sthr + "&startmin="+  stmin  +"&endmin="+  endmin  +"&endhr=" + endhr +"&arrangeUnknown="+sortBy+"&isForCurrent="+showCurrentUnk;

		Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				timeout:300000,
				params: QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&getdiffTest=UNKNOWN_HISTORY"+params,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					publicJson = jsonData;
					try
					{
						publicJson.gridJson.fullData = JSON.parse(JSON.stringify(publicJson.gridJson.gridData));
						currentAlmsGrid.fullData = JSON.parse(JSON.stringify(publicJson));
						if(showCurrentUnk){
							if(publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData")){
								publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){return columnData["COLUMN_8"] === "Current"});
							}
						}/*
						else{
							if(publicJson.hasOwnProperty("gridJson") && publicJson.gridJson.hasOwnProperty("gridData")){
								publicJson.gridJson.gridData = publicJson.gridJson.gridData.filter(function(columnData){return columnData["COLUMN_8"] !== "Current"});
							}
						}*/						
					}
					catch (e)
					{
					}
					publicJson.showOptionsJson = [{displayField: 'Unknowns', valueField: 'CurrentUnknown'}];
					alarmLoadMask.hide();
					var meApp = this;
					if(isPopupWindow!=null && isPopupWindow=="true")
					{
						AlarmsMainTitle='';
					}

					metaRefreshUrl = publicJson['pageParams']['metaRefreshUrl'];
					metaRefreshUrl = urlParamReplace(metaRefreshUrl);
					var pageParams = publicJson['pageParams'];
					var showCombo = Ext.getCmp('showCombo');
					showCombo.getStore().loadRawData();
					showCombo.getStore().loadRawData(publicJson['showOptionsJson']);
					showCombo.setValue(pageParams['selectedShowOption']);

					var filterCombo = Ext.getCmp('filterCombo');
					filterCombo.getStore().loadRawData();
					filterCombo.getStore().loadRawData(publicJson['filterOptions']);
					filterCombo.setValue(pageParams['selectedFilterOption']);


					var subFilterCombo = Ext.getCmp('subFilterCombo');
					subFilterCombo.getStore().loadRawData();
					subFilterCombo.getStore().loadRawData(publicJson['optionsForFilterSelection']);
					var totalCount = subFilterCombo.getStore().getCount();
					var lastVal = subFilterCombo.getStore().getAt(totalCount-1).get('valueField');

					if(combId!=null && combId !='subFilterCombo'){
						if(pageParams.hasOwnProperty('selectedSubFilterOption') && !Ext.isEmpty(pageParams['selectedSubFilterOption']))
							subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
						else
							subFilterCombo.setValue(lastVal);
					}else{
						subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
					}
					if(!Ext.isEmpty(subFilterCombo) && Ext.isEmpty(subFilterCombo.getValue()) || subFilterCombo.getValue()==undefined || subFilterCombo.getValue()==null)
					{
						subFilterCombo.setValue(subFilterCombo.getStore().getAt(0).get('valueField'));
					}

					subFilterCombo.setFieldLabel(filterCombo.getRawValue());
					var zoneNameTxt = publicJson['hiddenParams']['zoneName'];
					var isZoneDash = false;
					if(!Ext.isEmpty(zoneNameTxt)&& zoneNameTxt!=null && zoneNameTxt!=undefined && zoneNameTxt!='null' && zoneNameTxt!='undefined')
						isZoneDash = true;
					if((publicJson['pageParams']['alarmType']!='longestAlarms'))
					{
						if(!isZoneDash)
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').show();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').show();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').show();
						}
						else
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').hide();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').hide();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').hide();
						}
					}
					else if(publicJson['pageParams']['alarmType']=='longestAlarms')
					{
						if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
							Ext.getCmp('filterCombo').hide();
						if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
							Ext.getCmp('subFilterCombo').hide();
						if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
							Ext.getCmp('searchTextBox').hide();
						disablerefresh = true;
					}

					var showDeleteBtn = pageParams['showDeleteBtn'];
					var showAcknowledgeBtn = pageParams['showAcknowledgeBtn'];
					if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
					{
						//Ext.getCmp('ackOptionsContainer').show();
					}
					if(showDeleteBtn!=null && showDeleteBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					{						
						if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
						{							
							//mainView1.add({xtype:'acknowledgementoptions'});							
						}
						Ext.getCmp('ackOptionsid').show();	
						Ext.getCmp('AlarmDeleteBtn').show();
					}
					else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					{	
						Ext.getCmp('ackOptionsid').hide();						
					}
					if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					{
						if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
						{							
							//mainView1.add({xtype:'acknowledgementoptions'});
						}
						Ext.getCmp('ackOptionsid').show();	
						Ext.getCmp('AlarmAcknowledgeBtn').show();
					}
					else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					{
						Ext.getCmp('ackOptionsid').hide();						
					}
					currentAlmsGrid.generateAlarmGrid();

					var searchField = Ext.getCmp('searchTextBox');					
					//if(searchAck)
					if(true)
					{
						if(!Ext.isEmpty(searchField.getValue())){
							this.searchAlarms(searchField,'fire');
						}
					}
					else
					{
						searchField.setValue('');
						
					}					
					
					get_row = document.getElementsByClassName('x-grid-row');								//autoscroll hide/show functionality
					row_hei = Math.round(get_row.length * $('.x-grid-row').height());
					if(row_hei > $('#currentAlarmsGrid-body').height()){
						//Ext.getCmp('iconAutomaticScrollRun').show();
						Ext.getCmp('removeLineForTvMode').show();
						//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
					}else{
						Ext.getCmp('iconAutomaticScrollRun').hide();
						Ext.getCmp('removeLineForTvMode').hide();
						Ext.getCmp('iconAutomaticScrollJumpToTop').hide()
					}				
					Ext.getCmp('iconAutomaticScrollStop').hide();

					try
					{
						if(isCitrix)
						{
							showCombo.hide();
							filterCombo.hide();
							Ext.getCmp('AlarmDeleteBtn').hide();
							Ext.getCmp('AlarmAcknowledgeBtn').hide();	
						}
					}
					catch (e)
					{
					}
					clearTimeout(scrolldelay);
				}
			});
			//document.location = '/final/monitor/EgAlarms.jsp?'+QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height);
	}
});