var isChildNodeAvailable = false;
Ext.define('Task', {
    extend: 'Ext.data.Model',
    fields: [{
            name: 'COLUMN_0',
            type: 'string'
        }, {
            name: 'COLUMN_1',
            type: 'string'
        }, {
            name: 'COLUMN_2',
            type: 'string'
        }, {
            name: 'COLUMN_3',
            type: 'string'
        }, {
            name: 'COLUMN_4',
            type: 'string'
        }, {
            name: 'COLUMN_5',
            type: 'string'
        }, {
            name: 'COLUMN_6',
            type: 'string'
        }, {
            name: 'COLUMN_7',
            type: 'string'
        },{
            name: 'COLUMN_MeasGraph_url',
            type: 'string'
        },{
            name: 'COLUMN_1_ChkBoxVal',
            type: 'string'
        },{
            name: 'COLUMN_DD_url',
            type: 'string'
        },{
            name: 'COLUMN_SS_name',
            type: 'string'
        },{
            name: 'COLUMN_AssetMgmt_url',
            type: 'string'
        },{
            name: 'task',
            type: 'string'
        },{
            name: 'state',
            type: 'string'
        },{
            name: 'user',
            type: 'string'
        },{
            name: 'duration',
            type: 'string'
        },{
            name: 'done',
            type: 'boolean'
        },{
            name: 'rowGrp',
            type: 'boolean'
        },{
            name: 'parent',
            type: 'boolean'
        },{
            name: 'lastChild',
            type: 'boolean'
        },{
            name: 'odd',
            type: 'boolean'
        },{
            name: 'hasParent',
            type: 'boolean'
        },{
            name: 'eventid',
            type: 'string'
        },{
            name: 'level',
            type: 'string'
        },{
            name: 'parentLevel',
            type: 'string'
        },{
            name: 'elbow',
            type: 'boolean'
        },{
            name: 'elbowx',
            type: 'boolean'
        },{
            name: 'lastFello',
            type: 'boolean'
        },{
            name: 'lastSubParent',
            type: 'boolean'
        },{
            name: 'levelEnd',
            type: 'boolean'
        },{
            name: 'nth',
            type: 'string'
        },{
            name: 'ACCESS_EVENT_ID',
            type: 'string'
        },{
            name: 'mouseOverUrl',
            type: 'string'
        },{
            name: 'COLUMN_Config_url',
            type: 'string'
        },{
            name: 'mouseDivGridData',
            type: 'string'
        },{
            name: 'rowIndexValue',
            type: 'int'
        },{
            name: 'mouseOverAckDiv',
            type: 'string'
        }
    ]
});

var treegridstore = Ext.create("Ext.data.TreeStore", {
    model: "Task",
    root: {
        text: ".",
        children: []
    },
    //folderSort: true,
    //groupField: 'department'
});

Ext.require(["Ext.data.*", "Ext.grid.*", "Ext.tree.*"]);
var lastEventId ="";
function resetIconsAndOpenWindows(){
	for(var i=0;i< Ext.select('.iconAlarmTriangle').elements.length;i++){
		var iconAlarmTriangleClassName = Ext.fly(Ext.select('.iconAlarmTriangle').elements[i]).dom.className;
		if(iconAlarmTriangleClassName.indexOf("iconAlarmTriangleUp")>-1){
			Ext.fly(Ext.select('.iconAlarmTriangle').elements[i]).removeCls('iconAlarmTriangleUp');
			Ext.fly(Ext.select('.iconAlarmTriangle').elements[i]).addCls('iconAlarmTriangleDown');
		}
	}
	if(!Ext.isEmpty(lastEventId)){
		$('#rowBody'+lastEventId).html("");
		$('#rowBody'+lastEventId).css({'display':'none'});
	}
}
function showEnventDetails(mrow,evt,rowIndex){
	if(!Ext.isEmpty(publicJson.gridJson) && !Ext.isEmpty(publicJson.gridJson.eventDetails)){
		var fields = ["ddLink","measureLink","mouseOverUrl"];
		var columns = [];
		var data ={};
		publicJson.gridJson.eventDetails[mrow][0].map(function(item){
			fields.push(item.dataIndex);
			data = {};
			if(item.dataIndex == 'priority'){
				data = {
					dataIndex:item.dataIndex,
					text:"",
					width:'40px',
					menuDisabled: true,
					sortable:false,
					renderer:function(value,metaData){
						 //metaData.tdCls = 'statecolumntd'; 
						 metaData.style='text-align:center';
						var classState = value;//.substring(value.indexOf('_') + 1);
						var img = "alarm_" + value + ".png";
						if(value.indexOf('Ack') > -1)
							img = classState+ ".png";
						if(showFlashingIcon && classState.toLowerCase().indexOf("ack") == -1){
							return '<div class="flashingAlarm'+classState+'"></div>';
						}
						else
							return '<img src=./eg_scripts/EgCorAlarm/images/Light/' + img + '>';
					},
					listeners: {
						'click':function(grid, rowIndex, colIndex, item, event, record, row)
						{
							var href = record.get('mouseOverUrl');
							if(!Ext.isEmpty(href) && href!=null && href!="-" )
								wayToLayerModel(href);
							return;
						}
					}
				};
			}else if(item.dataIndex == 'icons'){
				data ={
					xtype:'actioncolumn', 
					menuDisabled: true,	
					sortable:false,
					border:0,
					width:60,
					align : 'center',			
					items:[{
							icon: '',
							getClass: function(Value, metaData, record){
								var ddhref = record.get('ddLink');
								if(Ext.isEmpty(ddhref) || ddhref==null || ddhref=="-")
								{
									return 'iconSpacer actionIcon mouseOverRemove';
								}
								else
								{
									return 'iconDiagnosis actionIcon'
								}
							},
							handler: function(view, rowIndex, colIndex, item, e, record, row){
								var ddhref = record.get('ddLink');
								if(!Ext.isEmpty(ddhref) && ddhref!=null && ddhref!="-")
								{
									this.fireEvent('itemClick', loadPopup(ddhref));
						
								}
							}
						},
						{
							icon: '',
							tooltip:'Graph',
							getClass: function(Value, metaData, record){
								var graphhref = record.get('measureLink');
								if(Ext.isEmpty(graphhref) || graphhref==null || graphhref=="-"){
									return 'iconSpacer mouseOverRemove';
								}else{
									return 'iconLineChart actionIcon'
								}
							},
							handler: function(view, rowIndex, colIndex, item, e, record, row){
								var graphhref = record.get('measureLink');
								if(!Ext.isEmpty(graphhref) &&  graphhref!=null && graphhref!="-")
								{
									//graphhref = decodeURIComponent(graphhref);
								}
								this.fireEvent('itemClick', loadPopup(graphhref));
							}
					}]
				};
			}else{
				data = {
					dataIndex:item.dataIndex,
					text:item.text,
					flex:(item.dataIndex == 'description')?2:1,
					menuDisabled: true,
					sortable:false,
					renderer:function(value,metaData){
						value=value.replaceAll("\"","'");
						metaData.style='cursor:pointer';
						metaData.tdAttr = 'data-qtip="'+value+'" data-qclass=yellowTip ';
						return value;
					},
					listeners: {
						'click':function(grid, rowIndex, colIndex, item, event, record, row){
							var href = record.get('mouseOverUrl');
							if(!Ext.isEmpty(href) && href!=null && href!="-" )
							wayToLayerModel(href);
							return;
						}
					}
				};
			}
			columns.push(data);
		});
		if(!Ext.isEmpty(Ext.getCmp('showCombo')) && Ext.getCmp('showCombo').getValue() =='CorrelatedAlarms'){
			var className = evt.target.classList[evt.target.classList.length-1];
			var gdata=Ext.create('Ext.panel.Panel',{
				items:[{
					xtype: 'grid',
					autoScroll:true,
					maxHeight:125,
					store:Ext.create('Ext.data.Store', {
					fields:fields,
					data:publicJson.gridJson.eventDetails[mrow][1],
					}),
					cls:'eventDetails alarmTree',
					columns:columns
				}]
			});
			var gridRowCount = publicJson.gridJson.eventDetails[mrow][1].length;
			var tooltipHeight = 37;
			var gridHeaderHeight = 23;
			var gridRowHeight = 24;
			var totalTooltipHeight = tooltipHeight+gridHeaderHeight+(gridRowHeight*gridRowCount);
			if(totalTooltipHeight>162)
				totalTooltipHeight = 162;
			resetTooltip();
			alarmDetailsToolTip= alarmDetailsToolTipTop;
			alarmDetailsToolTip.removeAll();
			alarmDetailsToolTip.add(gdata);
			alarmDetailsToolTip.setTarget($('.'+className)[0]);
			alarmDetailsToolTip.setHeight(totalTooltipHeight);
			alarmDetailsToolTip.show();
			alarmDetailsToolTip.anchorOffset=alarmDetailsToolTip.getWidth()-44;
			alarmDetailsToolTip.mouseOffset=[-(alarmDetailsToolTip.getWidth()-29), 0];
			alarmDetailsToolTip.show();
			var extraValue =(alarmDetailsToolTip.getHeight()+alarmDetailsToolTip.y) - (Ext.getBody().getHeight()-77);
			if(extraValue > 0){
				resetTooltip();
				alarmDetailsToolTip= alarmDetailsToolTipBottom;
				alarmDetailsToolTip.setHeight(totalTooltipHeight);
				alarmDetailsToolTip.removeAll();
				alarmDetailsToolTip.add(gdata);
				alarmDetailsToolTip.setTarget($('.'+className)[0]);
				alarmDetailsToolTip.show();
				alarmDetailsToolTip.anchorOffset=alarmDetailsToolTip.getWidth()-44;
				alarmDetailsToolTip.mouseOffset=[-(alarmDetailsToolTip.getWidth()-29), 2];
				alarmDetailsToolTip.show();
			}
			alarmDetailsToolTip.setTitle("ALARM DETAILS");
		}else{
			var iconAlarmTriangleClassName = Ext.fly(Ext.select('.iconAlarmTriangle').elements[rowIndex]).dom.className;
			if(iconAlarmTriangleClassName.indexOf("iconAlarmTriangleUp")>-1){
				resetIconsAndOpenWindows();
				return;
			}
			resetIconsAndOpenWindows();
			var target = null;
			for(var i =mrow;i>-1;i--){
				if(!Ext.isEmpty(Ext.get('rowBody'+i))){
					$('#rowBody'+i).css({'display':'block'});
					$('#rowBody'+i).append("<div id='iconAlarmDetailsClose' onclick='resetIconsAndOpenWindows()' class='alarmsTab iconAlarmDetailsClose mouse'></div><div id='eventDetails' ></div>");
					target = Ext.get('eventDetails');
					lastEventId = i;
					break;
				}
			}
			if(target != null){
				Ext.create('Ext.grid.Panel', {
					store:Ext.create('Ext.data.Store', {
						fields:fields,
						data:publicJson.gridJson.eventDetails[mrow][1],
					}),
					cls:'eventDetails alarmTree',
					columns:columns,
					renderTo: target,
				});
			}
			Ext.fly(Ext.select('.iconAlarmTriangle').elements[rowIndex]).removeCls('iconAlarmTriangleDown');
			Ext.fly(Ext.select('.iconAlarmTriangle').elements[rowIndex]).addCls('iconAlarmTriangleUp');
		}
	}
}
function configDetails(qstring,grow,evt,record){
	if(!Ext.isEmpty(Ext.getCmp('showCombo')) && Ext.getCmp('showCombo').getValue() =='CorrelatedAlarms'){
		resetTooltip();
		alarmDetailsToolTip= alarmDetailsToolTipTop;
		var className = evt.target.classList[evt.target.classList.length-1];
		alarmDetailsToolTip.setTarget($('.'+className)[0]);
		alarmDetailsToolTip.removeAll();
		alarmDetailsToolTip.update('<div class="configWidow">'+
			'<div style="display:flex;margin:10px 10px 0px 10px" class="header">'+
				'<div style="margin:auto auto auto 0px;padding:0px 0px 10px 0px;font-size: 13px;font-weight:400" class="configPopfont">CONFIGURATION CHANGES FOR <span style="font-weight:600">'+record.get('COLUMN_3')+'</span>  DURING LAST 24 hrs</div>'+
				'<div style="margin:auto 0px auto auto;padding:0px 0px 10px 0px"><a class="configLink" href="javascript:void(0)" id="configLink">More Details</a></div>'+
			'</div>'+
			'<iframe id="iframeId" width="100%" height="150" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" style="padding-bottom:10px" > </iframe>'+
		'<div>');
		alarmDetailsToolTip.setHeight(180);
		alarmDetailsToolTip.show();
		alarmDetailsToolTip.setHeight($('#iframeId').height()+77);
		alarmDetailsToolTip.anchorOffset=alarmDetailsToolTip.getWidth()-44;
		alarmDetailsToolTip.mouseOffset=[-(alarmDetailsToolTip.getWidth()-30), -3];
		alarmDetailsToolTip.show();
		var extraValue =(alarmDetailsToolTip.getHeight()+alarmDetailsToolTip.y) - (Ext.getBody().getHeight()-77);
		if(extraValue > 0){
			resetTooltip();
			alarmDetailsToolTip= alarmDetailsToolTipBottom;
			alarmDetailsToolTip.setHeight(180);
			alarmDetailsToolTip.removeAll();
			alarmDetailsToolTip.update('<div class="configWidow">'+
				'<div style="display:flex;margin:10px 10px 0px 10px" class="header">'+
					'<div style="margin:auto auto auto 0px;padding:0px 0px 10px 0px;font-size: 13px;font-weight:400" class="configPopfont">CONFIGURATION CHANGES FOR <span style="font-weight:600">'+record.get('COLUMN_3')+'</span>  DURING LAST 24 hrs</div>'+
					'<div style="margin:auto 0px auto auto;padding:0px 0px 10px 0px"><a class="configLink" href="javascript:void(0)" id="configLink">More Details</a></div>'+
				'</div>'+
				'<iframe id="iframeId" width="100%" height="150" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" style="padding-bottom:10px" > </iframe>'+
			'<div>');
			alarmDetailsToolTip.setTarget($('.'+className)[0]);
			alarmDetailsToolTip.show();
			alarmDetailsToolTip.setHeight($('#iframeId').height()+77);
			alarmDetailsToolTip.anchorOffset=alarmDetailsToolTip.getWidth()-44;
			alarmDetailsToolTip.mouseOffset=[-(alarmDetailsToolTip.getWidth()-30), 8];
			alarmDetailsToolTip.show();
		}
		alarmDetailsToolTip.setTitle("");
	}else{
		resetIconsAndOpenWindows();
		for(var i =grow;i>-1;i--){
			if(!Ext.isEmpty(Ext.get('rowBody'+i))){
				$('#rowBody'+i).css({'display':'block'});
				$('#rowBody'+i).append(
					'<div id="iconAlarmDetailsClose" onclick="resetIconsAndOpenWindows()" class="alarmsTab config iconAlarmDetailsClose mouse "></div>'+
					'<div class="configWidow">'+
						'<div style="display:flex;margin:10px 10px 0px 10px" class="header">'+
							'<div style="margin:auto auto auto 0px;padding:0px 0px 10px 0px;font-size: 13px;font-weight:400" class="configPopfont">CONFIGURATION CHANGES FOR <span style="font-weight:600">'+record.get('COLUMN_3')+'</span>  DURING LAST 24 hrs</div>'+
							'<div style="margin:auto 0px auto auto;padding:0px 0px 10px 0px"><a class="configLink" href="javascript:void(0)" id="configLink">More Details</a></div>'+
						'</div>'+
						'<iframe id="iframeId" width="100%" height="100%" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0" style="padding-bottom:10px" > </iframe>'+
					'<div>'
				);
				target = Ext.get('eventDetails');
				lastEventId = i;
				break;
			}
		}
	}
	var iframeID = document.getElementById("iframeId");
	var isFromMonitor = true;
	var compName = "";
	if(qstring != null && qstring != "" && qstring != "empty")
	{
		var tmp_qstring = decodeURIComponent(qstring);
		var params = tmp_qstring.substring(tmp_qstring.indexOf("?")+1,tmp_qstring.length);
		var paramsArray = params.split("&");

		for(var i=0;i<paramsArray.length;i++)
		{
			var temp_param = paramsArray[i];
			if(temp_param.indexOf("componentName") > -1)
			{
				compName = temp_param.substring(temp_param.indexOf("=")+1);
			}
		}
	}
	var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+encodeURIComponent(compName)+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
	iframeID.src=url;
	document.getElementById("configLink").href=qstring;
	return;
}
/*function mouseDivPop1(mrow,evt,rowIndex){
	var mouseDivData = publicJson.gridJson.mouseDivGridData;
	var htmlData = mouseDivData[mrow].mouseOverDiv;
	htmlData = htmlData.replace("currAlmcrollDiv","");
	//Ext.getCmp('gridWindow').destroy();
	try
	{
		Ext.create('Ext.window.Window',{
			cls:'alarmsbg lightbox',
			//ui:'blackWindow',
			width:"80%",
			//height:250,
			closeAction:'destroy',
			autoDestroy:true,
			frame:false,
			resizable:false,
			modal:true,
			ghost:false,
			height:115,
			id:'gridWindow',
			header:{
				style:{
					"padding":"15px 20px 15px 12px",
				}
			},
			title:"Alarm Details",
			//margin:10,
			layout:'fit',			
			//style:{"overflow":"auto"},
			//bodyStyle:{"overflow":"auto"},
			listeners:{
				beforedestroy:function(e)
				{
					refTimer = setInterval("execute()",refreshFrequency);	
				},
				show: function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.get(dom[0]);
						el.addCls('windowModalLight');
						if(dom.length > 1)
						{
							var el1 = Ext.get(dom[1]);
							el1.addCls('windowModalLight');
						}
					}
				},
				close:  function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.get(dom[0]);
						el.removeCls('windowModalLight');
						if(dom.length > 1)
						{
							var el1 = Ext.get(dom[1]);
							el1.removeCls('windowModalLight');
						}
					}
				},
				afterrender:function(e)
				{
					e.add({
						//xtype:"label",
						html:htmlData,
						padding:'1',
						border:false,
						bodyStyle:{"overflow":"auto"}
					})	
				}
			},
			flex : 1
		}).show().alignTo(evt.target,"br-l?",[0,8]);
	}
	catch (e)
	{
	}
	
}*/

Ext.override(Ext.tree.Column, {
    treeRenderer: function(value, metaData, record, rowIdx, colIdx, store, view) {
        var me = this,
            buf = [],
            format = Ext.String.format,
            depth = record.getDepth(),
            treePrefix = me.treePrefix,
            elbowPrefix = me.elbowPrefix,
            expanderCls = me.expanderCls,
            imgText = me.imgText,
            checkboxText = me.checkboxText,
            formattedValue = me.origRenderer.apply(me.origScope, arguments),
            blank = Ext.BLANK_IMAGE_URL,
            href = record.get('href'),
            target = record.get('hrefTarget'),
            cls = record.get('cls'),

            lastChild = record.get('lastChild'),
            hasParent = record.get('hasParent'),
            parent = record.get('parent'),
            level = record.get('level'),
            levelEnd = record.get('levelEnd'),
            parentLevel = record.get('parentLevel'),
			mouseOverAckDiv = record.get("mouseOverAckDiv"),
            nth = record.get('nth');


        var level1 = true;
        var level2 = false;
        var level3 = false;
        var elbow = false;
        var level3elbow = false;
        var level1elbow = false;
        var child = false;
        //var depth
        var lastDO = false;
        var haveChildren = false;
		if(!Ext.isEmpty(level)){
			if(level == "level1" && !Ext.isEmpty(record.childNodes)){ 
				 var eGExpander = parent ? 'parentExpander' : 'childExpander';
				 buf.unshift(format(imgText, (elbowPrefix + 'plus ' + expanderCls + ' ' + eGExpander), blank));
			}
			else if(level == "level2" && !Ext.isEmpty(record.parentNode.data.level)){
				if(!Ext.isEmpty(record.childNodes)){
					 var eGExpander = parent ? 'parentExpander' : 'childExpander';
					 buf.unshift(format(imgText, (elbowPrefix + 'plus ' + expanderCls + ' ' + eGExpander), blank));
					 if(!Ext.isEmpty(record.nextSibling)){
						buf.unshift(format(imgText, (elbowPrefix + 'line tplus level2'), blank));
					}else{
						buf.unshift(format(imgText, (elbowPrefix + 'end'), blank));
					}
				}else{
					if(!Ext.isEmpty(record.nextSibling)){
						buf.unshift(format(imgText, (elbowPrefix + 'line tplus'), blank));
					}else{
						buf.unshift(format(imgText, (elbowPrefix + 'end'), blank));
					}
				}
			}else if(level == "level3" && !Ext.isEmpty(record.parentNode.data.level)){
				var alignClass = "";
				if(!Ext.isEmpty(record.parentNode.nextSibling)){
					alignClass = "alignStright";
				} 
				if(!Ext.isEmpty(record.nextSibling)){
					buf.unshift(format(imgText, (elbowPrefix + 'line tplus '), blank));
				}else{
					buf.unshift(format(imgText, (elbowPrefix + 'end '), blank));
				}
				if(!Ext.isEmpty(record.parentNode.nextSibling)){
					buf.unshift(format(imgText, (elbowPrefix + 'line alignStright'), blank));
				}else{
					buf.unshift(format(imgText, (elbowPrefix + 'empty width ' + level), blank));
				}
			}
		}else{
		   while (record) {
				if (!record.isRoot() || (record.isRoot() && view.rootVisible)) {
					if (record.getDepth() === depth) {
						var eGExpander = parent ? 'parentExpander' : 'childExpander';
						//console.log("record.isExpandable()=--==->>",record.isExpandable())
						if (record.isLast()) {
							if (record.isExpandable()) {
								buf.unshift(format(imgText, (elbowPrefix + 'end-plus ' + expanderCls + ' ' + eGExpander), blank));
								//repeated
								if (record.hasChildNodes) {
									record.eachChild(function(node) {
										if (node.isLast()) {
											elbow = true;
										} else {
											elbow = false;
										}
									})
								}
							} else {
								//repeated
								if (record.hasChildNodes) {
									record.eachChild(function(node) {
										if (node.isLast()) {
											elbow = true;
										} else {
											elbow = false;
										}
									});
								}
								elbow = true;
							}
						} else {
							if (record.isExpandable()) {
								lastDO = true;
								buf.unshift(format(imgText, (elbowPrefix + 'plus ' + expanderCls + ' ' + eGExpander), blank));
								//repeated
								if (record.hasChildNodes) {
									record.eachChild(function(node) {
										if (node.isLast()) {
											elbow = true;
											node.child = true;
										} else {
											elbow = false;
											node.child = false;
										}
									})
								}
							} else {
								//repeated
								if (record.hasChildNodes) {
									record.eachChild(function(node) {
										if (node.isLast()) {
											elbow = true;
										} else {
											elbow = false;
										}
									})
								}
							}
						}
					} else {
						if (elbow) {
							if (lastChild) {
								var lastOne = false;
								for (var i = 1; i < depth; i++) {
									if (i === record.getDepth()) {
										lastOne = true;
									} else {
										lastOne = false;
									}
								}
								if (lastOne) {
									buf.unshift(format(imgText, (elbowPrefix + 'end '), blank));
								} else {
                                buf.unshift(format(imgText, (elbowPrefix + 'empty width'), blank));
								}
							} else {

								if (record.childLast) {
									buf.unshift(format(imgText, (elbowPrefix + 'end'), blank));
								} else {

									if (record.get('level') === 'level' + (buf.length - 1) + '') {
										buf.unshift(format(imgText, (elbowPrefix + 'line'), blank));
									} else {
										var lastOne = false;

										for (var i = 1; i < depth - 1; i++) {

											if (i === record.getDepth()) {
												lastOne = true;
											} else {
												lastOne = false;
											}
										}
										//console.log('record.isExpandable()', record.isExpandable())

										if (lastOne) {
											buf.unshift(format(imgText, (elbowPrefix + 'line tplus' + record.getDepth()), blank));
										} else {

											if (lastDO) {
												buf.unshift(format(imgText, (elbowPrefix + 'end tplus1'), blank));
											} else {
												buf.unshift(format(imgText, (elbowPrefix + 'end tplus' + record.getDepth()), blank));
											}
											//buf.unshift(format(imgText, (elbowPrefix + 'end ssssssssss tplus'+record.getDepth()), blank));
										}
									}
								}
							}
						} else {
							//console.log(record.get('nth'), record.getDepth(), 'xxx', record.childNodes.length);
							if (parseInt(record.get('nth')) == record.getDepth()) {
								console.log(parentLevel, levelEnd);
								if (levelEnd) {
									buf.unshift(format(imgText, (elbowPrefix + 'empty width ' + level), blank));
								} else {
									buf.unshift(format(imgText, (elbowPrefix + 'line'), blank));
								}


                        } else {


                            buf.unshift(format(imgText, (elbowPrefix + 'line  tplus ' + record.get('level')), blank));
                        }
                        //check for level two -TODO
                        //buf.unshift(format(imgText, (elbowPrefix + 'line fffffffffffffffffffffffffffff'), blank));


						}

					}

				}
				record = record.parentNode;
		   }
		}
        if (href) {
            //buf.push('<a href="', href, '" target="', target, '">', formattedValue, '</a>');
        } else {
            // buf.push(formattedValue);
        }
        if (cls) {
            metaData.tdCls += ' ' + cls;
        }
		if(!Ext.isEmpty(mouseOverAckDiv))
			metaData.tdAttr = "data-qclass=perWidth data-qtip='"+Ext.util.Format.htmlEncode("<div class='x-table corTip'>"+mouseOverAckDiv+"</div>")+"'"; 
		metaData.style="display:flex"; 
		if(!Ext.isEmpty(value) && value.indexOf("_")>-1){
			value = value.substring(value.indexOf('_') + 1);
		}
		if(!Ext.isEmpty(value) && value.indexOf("#~#") > 0)
		{
			value = value.substring(0,value.indexOf("#~#"));
			if(value.toLowerCase() == 'critical')
				value = "HIGH";
			if(value.toLowerCase() == 'major')
				value = "INTERMEDIATE";
			if(value.toLowerCase() == 'minor')
				value = "LOW";
		}
		var stateIcon = "";
		if(!Ext.isEmpty(value)){
			var  classState = value;
			var img = "alarm_" + value + ".png";
			if(value.indexOf('Ack') > -1)
				img = classState+ ".png";
			if(showFlashingIcon && classState.toLowerCase().indexOf("ack") == -1){
				stateIcon = '<div class="flashingAlarm'+classState+'"></div></div>';
			}
			else
				stateIcon = '<img src=./eg_scripts/EgCorAlarm/images/Light/' + img + '>';
		}
		if((!Ext.isEmpty(Ext.getCmp('showCombo')) && Ext.getCmp('showCombo').getValue() =='CorrelatedAlarms') || (Ext.isEmpty(Ext.getCmp('showCombo')) && !Ext.isEmpty(showEventHistory) && !showEventHistory)){
			var style = "margin:auto 0px auto 10px;width:30px";
			if(showFlashingIcon)
				style = "margin:auto 0px auto 14px;width:30px";
			if(stateIcon.toLowerCase().indexOf("ack")>-1){
				style = "margin:auto 0px auto 10px;width:30px;position:relative;left:5px";
				if(showFlashingIcon)
					style = "margin:auto 0px auto 13px;width:30px";
			}
			value = "<div class='gridTreeIcon'style='margin:auto 0px auto 5px;width:13px'>"+buf.join('')+"</div><div class='gridStateIcon' style='"+style+"'>"+stateIcon+"</div>";
		}else{
			if(stateIcon.toLowerCase().indexOf("ack")>-1){
				value = "<div style='margin:auto auto auto auto;position:relative;left:5px'>"+stateIcon+"</div>";
			}else{
				value = "<div style='margin:auto auto auto auto;'>"+stateIcon+"</div>";
			}
		}
        return value;
    }
});

Ext.define("EgCorAlarm.view.Alarms.AlarmsGroupedView", {
    extend: "Ext.tree.Panel",
    alias: "widget.alarmsgroupedview",
    margin: 0,
    requires: ["Ext.ux.grid.FiltersFeature", "Ext.ux.RowExpander"],
    useArrows: false,
    ui: "treeColumn",
    //cls:'alarmTree',
    //cls:'usePlusMinus',
    rootVisible: false,
    store: treegridstore,
    multiSelect: true,
    //singleExpand: true,
    //singleExpand: true,
    alarmDetails: null,
    viewConfig: {
        ui: "treeColumn",
        getRowClass: function(record, index, rowParams, store) {
            if (record.isExpanded() || record.isExpandable()) {
                record.eachChild(function(x, j) {
                    x.expanded = true;
                });
            } else {
                record.eachChild(function(x, j) {
                    x.expanded = false;
                });
            }
            var className = "eGCls";
            var lastChild = record.childLast ? "childLast" : " ";
            if (record.get("parent")) {
                var parentExpaned = record.isExpanded() ? "expanded" : " ";
                if (record.get("rowGrp")) {
                    className =
                        "firstChild " +
                        record.get("parentLevel") +
                        " inGrp " +
                        lastChild +
                        " " +
                        record.get("level") +
                        " " +
                        lastChild + parentExpaned;
                } else {
                    className = "firstChild";
                }
            } else if (record.get("lastChild")) {
                var lastChildExpand = record.expanded ? "expanded" : " ";
                var parentExpaned = record.isExpanded() ? "expandedChild" : "collapseChild";
                if (record.get("rowGrp")) {
                    if (record.isLeaf()) {
						if(record.data.level == 'level3' && !Ext.isEmpty(record.parentNode.nextSibling)){
							className =
								"eGCls " +
								record.get("parentLevel") +
								" inGrp " +
								lastChildExpand +
								"  " +
								record.get("level") +
								" " +
								lastChild +
								"";
						}else{
							className =
								"lastChild " +
								record.get("parentLevel") +
								" inGrp isLeaf "+
								lastChildExpand +
								"  " +
								record.get("level") +
								" " +
								lastChild + parentExpaned;
						}
                    } else {
                        className =
                            "lastChild " +
                            record.get("parentLevel") +
                            " inGrp " +
                            lastChildExpand +
                            "  " +
                            record.get("level") +
                            " " +
                            lastChild + parentExpaned;
                    }
                } else {
                    className = "lastChild";
                }
            } else {
                if (record.get("rowGrp")) {
                    var lastChildExpand = record.expanded ? "expanded" : " ";
                    className =
                        "eGCls " +
                        record.get("parentLevel") +
                        " inGrp " +
                        lastChildExpand +
                        "  " +
                        record.get("level") +
                        " " +
                        lastChild +
                        "";
                } else {
                    className = "eGCls";
                }
            }
			if(!Ext.isEmpty(record.data.level)){
				if(record.data.level == "level1" && Ext.isEmpty(record.childNodes))
					className = "";
				if((record.data.level == "level2" ||  record.data.level == "level3") && Ext.isEmpty(record.parentNode.data.level))
					className = "";
			}
            return record.get("odd") ?
                "even-row" + " " + className :
                "odd-row" + " " + className;
        },
    },
    //scroll: true,
    //autoScroll: true,
    rowLines: true,
    lines: true,
    selModel: {
        checkOnly: true,
        headerWidth: 14,
        width:10,
        padding:'0',
        injectCheckbox: 0,
        showHeaderCheckbox: false,
    },
	features:[{
		ftype: 'rowbody',
		disabled:false,
		id:'configFilter',
		getAdditionalData: function (data, rowIndex, record, orig){
			var headerCt = this.view.headerCt,
			colspan = headerCt.getColumnCount();
			var divTitle = 'ALARM DETAILS';
			if(!Ext.isEmpty(data['COLUMN_0']) && data['COLUMN_0']!=undefined && data['COLUMN_0']=='state_UNKNOWN')
				divTitle = 'UNKNOWN DETAILS';
			var rowIndexValue = record.get('rowIndexValue');
			if(Ext.isEmpty(rowIndexValue) || rowIndexValue==undefined || rowIndexValue==null)
			{
				rowIndexValue=rowIndex;
			}
			return {
				rowBody: "<div class='bottomBorder' id='rowBody"+rowIndexValue+"' style='display:none;padding:10px 50px 10px 50px'></div>",
				rowBodyCls: "my-body-class"+rowIndexValue,
				rowBodyColspan: colspan
			};
		}
	 }],
    //plugins: [
    //  {
    //    ptype: "rowexpander",
    //    expandOnEnter: false,
    //    id: "rowexpander",
    //    selectRowOnExpand: false,
    //    expandOnDblClick: false,
    //    rowBodyTpl: ['<div class="htmlTemplate"></div>'],
    //    toggleRow: function (rowIdx, record, orgin) {
    //      var view = this.view,
    //        rowNode = view.getNode(rowIdx),
    //        row = Ext.get(rowNode),
    //        nextBd = Ext.get(row).down(this.rowBodyTrSelector),
    //        record = view.getRecord(rowNode),
    //        grid = this.getCmp();

    //      if (Ext.isEmpty(orgin)) {
    //        //alert('plus')
    //        if (row.hasCls(this.rowCollapsedCls)) {
    //          row.removeCls(this.rowCollapsedCls);
    //          nextBd.addCls(this.rowBodyHiddenCls);
    //          this.recordsExpanded[record.internalId] = true;
    //          view.refreshSize();
    //          view.fireEvent("expandColsBody", rowNode, record, nextBd.dom);
    //          $(".htmlTemplate").html("");
    //        } else {
    //          row.addCls(this.rowCollapsedCls);
    //          nextBd.addCls(this.rowBodyHiddenCls);
    //          this.recordsExpanded[record.internalId] = false;
    //          view.refreshSize();
    //          view.fireEvent("collapseColsBody", rowNode, record, nextBd.dom);
    //        }
    //      } else {
    //        //from action column
    //        //alert('orgin')
    //        if (
    //          row.hasCls(this.rowCollapsedCls) ||
    //          nextBd.hasCls(this.rowBodyHiddenCls)
    //        ) {
    //          row.addCls(this.rowCollapsedCls);
    //          nextBd.removeCls(this.rowBodyHiddenCls);

    //          this.recordsExpanded[record.internalId] = true;
    //          view.refreshSize();
    //          //view.fireEvent('expandbody', rowNode, record, nextBd.dom);
    //          $(".htmlTemplate").html("");
    //          $(nextBd.dom)
    //            .find(".htmlTemplate")
    //            .html(
    //              '<div class="htmlTemplateheader"><img src="/final/images/clear.png" data-qtip="Close Details" class="iconAlarmClose mouse"/></div>' +
    //                record.alarmDetails.mouseOverDiv
    //            );
    //          view.fireEvent("collapseColsBody", rowNode, record, nextBd.dom);
    //          //CLOSE Details
    //          $(".iconAlarmClose").on("click", function () {
    //            $(".htmlTemplate").html("");
    //            view.fireEvent("collapsebody", rowNode, record, nextBd.dom);
    //          });
    //          // alert('orgin if')
    //        } else {
    //          // alert('orgin else')

    //          row.removeCls(this.rowCollapsedCls);
    //          nextBd.addCls(this.rowBodyHiddenCls);
    //          this.recordsExpanded[record.internalId] = false;
    //          view.refreshSize();
    //          view.fireEvent("collapsebody", rowNode, record, nextBd.dom);
    //          //$(nextBd.dom).find('.htmlTemplate').html('');
    //        }
    //      }
    //    },
    //    getHeaderConfig: function () {
    //      var me = this,
    //        toggleRow = Ext.Function.bind(me.toggleRow, me),
    //        selectRowOnExpand = me.selectRowOnExpand;
    //      return {
    //        id: this.getHeaderId(),
    //        width: 24,
    //        sortable: false,
    //        resizable: false,
    //        draggable: false,
    //        hideable: false,
    //        menuDisabled: true,
    //        //cls: Ext.baseCSSPrefix + 'grid-header-special',
    //        cls: Ext.baseCSSPrefix + "grid-header",
    //        renderer: function (value, metadata, record) {
    //          //metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
    //          metadata.tdCls = Ext.baseCSSPrefix + "grid-cell";
    //          if (record.data.hidden || !record.data.isParent) {
    //            return "<div>&#160;</div>";
    //          } else {
    //            return (
    //              '<div class="' +
    //              Ext.baseCSSPrefix +
    //              'grid-row-expander">&#160;</div>'
    //            );
    //          }
    //        },
    //        processEvent: function (type, view, cell, recordIndex, cellIndex, e) {
    //          if (type == "mousedown" && e.getTarget(".x-grid-row-expander")) {
    //            var row = e.getTarget(".x-grid-row");
    //            toggleRow(row);
    //            return selectRowOnExpand;
    //          }
    //        },
    //      };
    //    },
    //  },
    //],
    columns: [{
            xtype: "treecolumn", //this is so we know which column will show the tree
            //id: "treecolumn",
            menuDisabled: true,
            //height: 35,
			align:'center',
			shrinkWrap:1,
			sortable:true,
            width: isCorrelatedAlarmsAsDefault?65:45,
			dataIndex: 'COLUMN_0',
            sortable: false,
            resizable: false,
			text:"<div style='display:flex'><div style='margin:auto auto auto auto;' class='resetIcon'></div></div>",
            //dataIndex: "COLUMN_2",
            cls: "treecolumn",
            overCls: "headeover",
			renderer: function(value, metaData, record) {
                metaData.style = 'padding:0px 0px 0px 10px';
			},
			listeners:{
				'headerclick':function(){
					this.up('panel').updateGrid(Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson,false);
				}
			}
        },
        /*{
            text: '',
            width: 35,
            //height: 35,
            align: 'left',
            padding: 0,
            headerCls: 'statecolumn',
            cls: 'statecolumn',
            dataIndex: 'COLUMN_0',
            menuDisabled: true,
            sortable: false,
            resizable: false,
            renderer: function(value, metaData, record) {
                metaData.tdCls = 'statecolumntd';
				if(!Ext.isEmpty(record.get("mouseOverAckDiv")))
					metaData.tdAttr = "data-qclass=perWidth data-qtip='"+Ext.util.Format.htmlEncode("<div class='x-table corTip'>"+record.get("mouseOverAckDiv")+"</div>")+"'";     
				var classState = value.substring(value.indexOf('_') + 1);
                var img = "alarm_" + classState + ".png";
				if(value.indexOf('Ack') > -1)
					img = classState+ ".png";
				if(showFlashingIcon && classState.toLowerCase().indexOf("ack") == -1){
					//return (record.get("odd"))?'<img 306 src=/final/monitor/eg_scripts/EgCorAlarm/images/flash_icons/critical-white-lighttheme.gif>':'<img 306 src=/final/monitor/eg_scripts/EgCorAlarm/images/flash_icons/critical-grey-lighttheme.gif>';
					return '<div class="flashingAlarm'+classState+'"></div>';
				}
				else
					return '<img src=./eg_scripts/EgCorAlarm/images/Light/' + img + '>';
				
				//return '<div class="' + img + '"></div>';

            },
			listeners:{
				'headerclick':function(){
					this.up('panel').updateGrid(Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson,false);
				}
			}
        },*/ {
            text: "Alarm Id",
            flex: 1.35,
            //height: 35,           
            menuDisabled: true,
            sortable: true,
			hidden: !showEventIdFlag,
            dataIndex: "ACCESS_EVENT_ID",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
				if(value.indexOf(":") > -1)
					value = value.substring(0,value.indexOf(":"));
                return (
                    "<div data-qtip="+value+" style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState);	
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },{
            text: "Component Type",
            flex: 1,
            //height: 35,
           
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_2",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    "<div data-qtip=\'"+value+"\' style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState);	
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        }, {
            text: "Component Name",
            flex: 1,
            //height: 35,
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_3",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    "<div data-qtip=\'"+value+"\' style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState);	
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },
        {
            text: "description",
            flex: 2,
            //height: 35,
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_4",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    '<div data-qclass=yellowtip data-qtip=\"'+value+'\" style="text-overflow: ellipsis;overflow: hidden;">' +
                    value +
                    '</div>'
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState);	
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },
        {
            text: "layer",
            flex: 1,
            //height: 35,
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_5",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    "<div data-qtip=\'"+value+"\' style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState);	
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },
        {
            text: "start Time",
            //flex: 1,
            //height: 35,
			width:130,
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_6",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    "<div data-qtip=\'"+value+"\' style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = [];	
					if(!Ext.isEmpty(Ext.getCmp('searchTextBox').getValue())){
						sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState,Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson);	
					}else{
						sortedData = this.up('panel').customSorting("COLUMN_0","ASC",null,true);
						sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState,sortedData);
					}
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },{
            text: "Manager ID",
            //flex: 1,
            //height: 35,
			width:90,
			hidden:true,
            menuDisabled: true,
            sortable: true,
            dataIndex: "COLUMN_7",
            renderer: function(value, metaData, record, rowIndex, colIndex) {
                return (
                    "<div data-qtip=\'"+value+"\' style='text-overflow: ellipsis;overflow: hidden;'>" +
                    value +
                    "</div>"
                );
            },
            listeners: {
                'click':function(grid, rowIndex, colIndex, item, event, record, row)
				{
					var href = record.get('mouseOverUrl');
					if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
					return;
				},
				'headerclick':function(){
					var sortedData = [];	
					if(!Ext.isEmpty(Ext.getCmp('searchTextBox').getValue())){
						sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState,Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson);	
					}else{
						sortedData = this.up('panel').customSorting("COLUMN_0","ASC",null,true);
						sortedData = this.up('panel').customSorting(this.dataIndex,this.sortState,sortedData);
					}
					this.up('panel').updateGrid(sortedData,true);
				}
            }
        },
        {
			xtype:'actioncolumn', 
			menuDisabled: true,		
            border:0,
			text:'<div id="collapseExpand" data-qtip="Expand All" style="display:'+(isCorrelatedAlarmsAsDefault?"block":"none")+'"onclick="collapseExpand()" value="false" class="expandIcon"></div>',
			width:165,
			align : 'left',
			//style:{marginRight: '10px'},			
			items: [
				{
					icon: '',
					itemId:'ddID',
					//tooltip:ddTooltipLbl,
					getClass: function(Value, metaData, record){
						var ddhref = record.get('COLUMN_DD_url');
						if(Ext.isEmpty(ddhref) || ddhref==null || ddhref=="-")
						{
							return 'iconSpacer actionIcon mouseOverRemove';
						}
						else
						{
							return 'iconDiagnosis actionIcon'
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row){
						var ddhref = record.get('COLUMN_DD_url');
						if(!Ext.isEmpty(ddhref) && ddhref!=null && ddhref!="-")
						{
							//ddhref = decodeURIComponent(ddhref);
							this.fireEvent('itemClick', loadPopup(ddhref));
				
						}
					}
				},
				{
					icon: '',
					tooltip:'Graph',
					itemId:'grpahID',
					getClass: function(Value, metaData, record){
						var graphhref = record.get('COLUMN_MeasGraph_url');
						if(Ext.isEmpty(graphhref) || graphhref==null || graphhref=="-"){
							return 'iconSpacer actionIcon mouseOverRemove';
						}else{
							return 'iconLineChart actionIcon'
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row){
						var graphhref = record.get('COLUMN_MeasGraph_url');
						if(!Ext.isEmpty(graphhref) &&  graphhref!=null && graphhref!="-")
						{
							//graphhref = decodeURIComponent(graphhref);
						}
						this.fireEvent('itemClick', loadPopup(graphhref));
					}
				},
				{
					icon: '',
					tooltip: 'Fix History',
					itemId:'fxHistoryID',
					getClass: function(Value, metaData, record){
						return 'iconHistory actionIcon';
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row) 
					{
						var graphhref = record.get('COLUMN_MeasGraph_url');
						if(!Ext.isEmpty(graphhref) && graphhref!=null && graphhref!="-")
						{
							//graphhref = decodeURIComponent(graphhref);
							graphhref = graphhref.replace('&clicked=graph','&clicked=history');
							graphhref += "&directClick=true";
							this.fireEvent('itemClick', loadPopup(graphhref));
						}
					}
				},
				{
					icon: '',
					tooltip: 'Configuration',
					getClass: function(Value, metaData, record){
						var rowId = -1;
						if(!Ext.isEmpty(this.rowId)){
							rowId = this.rowId
						}
						rowId++;
						metaData.rowId = rowId;
						this.rowId = rowId;
						var confighref = record.get('COLUMN_Config_url');
						if(Ext.isEmpty(confighref) || confighref==null || confighref=="-")
						{
							return 'iconSpacer actionIcon mouseOverRemove configuration_'+this.rowId;
						}
						else
						{
							return 'iconConfigure actionIcon configuration_'+this.rowId;
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row) {
						var confighref = record.get('COLUMN_Config_url');
						if(!Ext.isEmpty(confighref) && confighref!=null && confighref!="-")
						{
							var rowIndexValue = record.get('rowIndexValue');
							if(Ext.isEmpty(rowIndexValue) || rowIndexValue==undefined || rowIndexValue==null)
							{
								rowIndexValue=rowIndex;
							}
							this.fireEvent('itemClick', configDetails(confighref,rowIndexValue,e,record));
						}
					}
				},
				{
					icon: '',
					itemId:'ssID',
					tooltip:'Screenshot',
					getClass: function(Value, metaData, record){
						var sshref = record.get('COLUMN_SS_name');
						if(Ext.isEmpty(sshref) || sshref==null || sshref=="-")
						{
							return 'iconSpacer actionIcon mouseOverRemove';
						}
						else
						{
							return 'iconScreenshot actionIcon'
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row){
						var sshref = record.get('COLUMN_SS_name');
						if(!Ext.isEmpty(sshref) && sshref!=null && sshref!="-")
						{
							openScreenShot(sshref);
						}
					}
				},
				{
					icon: '',
					tooltip: 'Asset',
					itemId:'assestID',
					getClass: function(Value, metaData, record){
						var assethref = record.get('COLUMN_AssetMgmt_url');
						if(Ext.isEmpty(assethref) || assethref==null || assethref=="-")
						{
							return 'iconSpacer actionIcon mouseOverRemove';
						}
						else
						{
							return 'iconAssetConfiguration actionIcon'
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row) 
					{
						var assethref = record.get('COLUMN_AssetMgmt_url');
						if(!Ext.isEmpty(assethref) && assethref!=null && assethref!="-")
						{
							assethref = decodeURIComponent(assethref);
							this.fireEvent('itemClick', loadPopup(assethref));
						}
					}
				},{
					icon: '', 
					tooltip:'Alarm Details',
					//id:'mouseDivID',
					getClass: function(Value, metaData, record){
						var rowId = -1;
						if(!Ext.isEmpty(this.rowId)){
							rowId = this.rowId
						}
						rowId++;
						metaData.rowId = rowId;
						this.rowId = rowId;
						var mouseovrdivref = record.get('mouseOverUrl');
						if(Ext.isEmpty(mouseovrdivref) || mouseovrdivref==null || mouseovrdivref=="-")
						{
							return 'iconSpacer mouseOverRemove actionIconAlarmDetails alarmDetails_'+this.rowId;
						}
						else if(!isCitrix)
						{
							return 'iconAlarmTriangle actionIcon actionIconAlarmDetails AlarmDetails_'+this.rowId;
						}
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row) 
					{
						var mouseovrdivref = record.get('mouseOverUrl');
						var rowIndexValue = record.get('rowIndexValue');
						if(Ext.isEmpty(rowIndexValue) || rowIndexValue==undefined || rowIndexValue==null)
						{
							rowIndexValue=rowIndex;
						}

						if(!Ext.isEmpty(mouseovrdivref) && mouseovrdivref!=null && mouseovrdivref!="-")
						{
							this.fireEvent('itemClick', showEnventDetails(rowIndexValue,e,rowIndex));
						}
						doFitAlarmDetailsTable();
					}
				}												
				/*{
					icon: '',
					tooltip: 'Fix FeedBack',
					id:'fxFeedBackID',
					getClass: function(Value, metaData, record){
						return 'iconModify actionIcon';
					},
					handler: function(view, rowIndex, colIndex, item, e, record, row) 
					{
						var graphhref = record.get('COLUMN_MeasGraph_url');
						if(!Ext.isEmpty(graphhref) && graphhref!=null && graphhref!="-")
						{
							graphhref = decodeURIComponent(graphhref);
							graphhref = graphhref.replace('&clicked=graph','&clicked=feedback');
							graphhref += "&directClick=true";
							this.fireEvent('itemClick', loadPopup(graphhref));
						}
					}
				}*/
			],
			listeners: {
				/*'headerclick': function(gridheader,eventobj, tml) {
					if(coloumns != null && coloumns != undefined )
					{
						var key=eventobj.dataIndex;
						sortbyalarm=coloumns.get(key);
					}
					var sortState=eventobj.sortState;
					orderbyalarm=sortState.toLowerCase();
				}*/
			}
		},
    ],
    updateGrid: function(data,sorting) {
		var me = this;
		resetTooltip();
		if(!Ext.isEmpty(data)){
			try {
				$("#collapseExpand").attr("value","false");
				$("#collapseExpand").attr("class","expandIcon");
				$("#collapseExpand").attr("data-qtip","Expand All");
				var jsonData = data;
				if (Ext.isEmpty(jsonData.gridJson)) {
					jsonData.gridJson = [];
					jsonData.gridJson.gridData = [];
					jsonData.gridJson.groupHeaderArray = [];
					jsonData.gridJson.gridData = [];
				}
				var gridData = jsonData.gridJson.gridData;
				var mouseDivGridData = jsonData.gridJson.mouseDivGridData;
				var groupHeaderArray = jsonData.gridJson.groupHeaderArray;
				me.alarmDetails = jsonData.gridJson.mouseDivGridData;
				alarmLoadMask.hide();
				if (gridData.length == 0) {
					/*this.getView().emptyText =
						'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';*/
					this.getView().refresh();
				}
				var pc=15;
				if(!Ext.isEmpty(sorting)){
						Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].localSortedData=jsonData;
				}else{
					if(!Ext.isEmpty(Ext.getCmp('showCombo')) && Ext.getCmp('showCombo').getValue() =='CorrelatedAlarms'){
						var sortedData = this.customSorting("COLUMN_0","ASC",jsonData,false);
						if(!Ext.isEmpty(sortedData) && !Ext.isEmpty(sortedData.gridJson) && !Ext.isEmpty(sortedData.gridJson.gridData)){
							jsonData.gridJson.gridData = sortedData.gridJson.gridData;
							if(Ext.isEmpty(Ext.getCmp('searchTextBox').getValue())){
								publicJson.gridJson.gridData = sortedData.gridJson.gridData;
							}
						}
					}
					Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson=jsonData;
					Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].localSortedData=jsonData;
				}
				var pageNumber = Ext.ComponentQuery.query('[itemId=inputItem]')[0].value;
				Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].pageCount=Math.ceil(gridData.length / pc);
				Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].getStore().loadRawData(gridData);
				Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].moveFirst();
				if(Ext.isEmpty(sorting) || !sorting){
					this.store.sorters.clear();
					this.getView().refresh();
				}
				if(!isChildNodeAvailable){
					if(!Ext.isEmpty($('.gridTreeIcon')) && $('.gridTreeIcon').length>0 && !Ext.isEmpty($('.gridStateIcon')) && $('.gridStateIcon').length>0){
						$('.gridTreeIcon').css("display","none");
						$('.gridStateIcon').css("margin","auto auto");
					}
				}
				this.hideShowFields();
			} catch (e) {
				/*this.getView().emptyText =
					'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';*/
				this.getView().refresh();
			}
		}else{
			/*this.getView().emptyText =
					'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';*/
			this.getView().refresh();
		}
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();
		}
	},
    updatePage: function() {
        var me = this;
        var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
            msg: "Loading ...",
        });
        alarmLoadMask.show();
        try {
            Ext.Ajax.request({
                url: "/final/servlet/com.eg.EgCurrentAlarmsC",
                method: "POST",
				timeout:300000,
                params: this.param_qstr + "&loadAlertDetails=true",
                scope: this,
                success: function(response) {
                    var jsonText = response.responseText;
                    //console.log(jsonText);
                    var jsonData = Ext.decode(jsonText);
                    if (Ext.isEmpty(jsonData.gridJson)) {
                        jsonData.gridJson = [];
                        jsonData.gridJson.gridData = [];
                        jsonData.gridJson.groupHeaderArray = [];
                        jsonData.gridJson.gridData = [];
                    }
                    var gridData = jsonData.gridJson.gridData;
                    var mouseDivGridData = jsonData.gridJson.mouseDivGridData;
                    var groupHeaderArray = jsonData.gridJson.groupHeaderArray;
                    me.alarmDetails = jsonData.gridJson.mouseDivGridData;

                    alarmLoadMask.hide();
                    if (gridData.length == 0) {
                        this.getView().emptyText =
                            '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';
                        this.getView().refresh();
                    }
                    try {
                        this.getView().getTreeStore().getRootNode().removeAll();
                        this.getView().getTreeStore().getRootNode().appendChild(gridData);
                        this.getView().refresh();
                    } catch (e) {
                        this.getView().emptyText =
                            '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';
                        this.getView().refresh();
                    }
                },
            });
        } catch (e) {
            alarmLoadMask.hide();
        }
    },
    listeners: {
        boxready: function(grid) {
            //grid.getView().getHeaderAtIndex(1).hide();
			$("#alarmsgroupedview-body > .x-grid-view").on("scroll", function() {
				resetTooltip();
			});
			$("#alarmsgroupedview-body").on("scroll", function() {
				resetTooltip();
			});
			$( window ).resize(function() {
				resetTooltip();
			});
        },
        afterrender: function(grid) {
            var me = this;
			this.mask = new Ext.LoadMask(this, {
				msg : "Loading ..."
			});
            //var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
            //	msg : "Loading ..."
            //});
            //alarmLoadMask.show();
			this.hideShowFields();

            try {
                var jsonData = grid.jsonData;
                if (Ext.isEmpty(jsonData.gridJson)) {
                    jsonData.gridJson = [];
                    jsonData.gridJson.gridData = [];
                    jsonData.gridJson.groupHeaderArray = [];
                    jsonData.gridJson.gridData = [];
                }else{
					if(!Ext.isEmpty(jsonData.gridJson.gridColumns) && jsonData.gridJson.gridColumns.hasOwnProperty('COLUMN_7')){
						if(jsonData.gridJson.gridColumns['COLUMN_7'].trim().toLowerCase() == 'manager id'){
							me.columns.map(function(i){
								if(i.dataIndex == 'COLUMN_7')
									i.show();
							});
						}
					}
					if(!Ext.isEmpty(Ext.getCmp('showCombo')) && Ext.getCmp('showCombo').getValue() =='CorrelatedAlarms'){
						var sortedData = this.customSorting("COLUMN_0","ASC",jsonData,false);
						if(!Ext.isEmpty(sortedData) && !Ext.isEmpty(sortedData.gridJson) && !Ext.isEmpty(sortedData.gridJson.gridData)){
							jsonData.gridJson.gridData = sortedData.gridJson.gridData;
							publicJson.gridJson.gridData = sortedData.gridJson.gridData;
						}
						if(!Ext.isEmpty(this.mask)){
							this.mask.hide();
						}
					}
                }
                var gridData = jsonData.gridJson.gridData;
                var mouseDivGridData = jsonData.gridJson.mouseDivGridData;
                var groupHeaderArray = jsonData.gridJson.groupHeaderArray;
                me.alarmDetails = jsonData.gridJson.mouseDivGridData;

                if (gridData.length == 0) {
                    /*this.getView().emptyText =
                        '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';*/
                    this.getView().refresh();
                }
				var pc=15;
				var t_gridData = loadPageData(gridData,pc,1);
                grid.addDocked({
                    xtype: 'pagingtoolbar',
                    itemId: 'pagingtoolbarId',
                    cls: 'pagingtoolbar pagingtoolbarborder',
					rawAndSearchGridJson:jsonData,
					localSortedData:jsonData,
					pageCount:Math.ceil(gridData.length / pc),
                    store: Ext.create('Ext.data.Store', {
                        pageSize: pc,
                        itemId: 'pagingtoolbarStoreId',
                        fields: ['cls', 'iconCls', 'iconTooltip', 'leaf', 'measuresLink', 'qtip', 'selected', 'text'],
                        autoLoad: true,
                        proxy: {
                            type: 'memory'
                        },
                        data: gridData
                    }),
                    //cls:'newPagination',
                    dock: 'bottom',
                    listeners: {
                        afterrender: function(ef) {
                            var refresh = ef.child('#refresh');
                            refresh.previousSibling().hide();
                            refresh.hide();
                        }
                    },
                    displayInfo: true,
                    moveFirst: function() {
                        var me = this;
                        grid.getEl().mask('Loading..');
						try
						{
							if (this.fireEvent('beforechange', this, 1) !== false) {
								this.store.loadPage(1);
							}
							me.setPageRequest();
						}
						catch (e)
						{
						}
                        grid.getEl().unmask();
                    },
                    movePrevious: function() {
                        var me = this,
                            prev = me.store.currentPage - 1;
                        grid.getEl().mask('Loading..');

                        if (prev > 0) {
                            if (me.fireEvent('beforechange', me, prev) !== false) {
                                me.store.previousPage();
                            }
                        }

                        me.setPageRequest();
                        grid.getEl().unmask();
                    },
                    moveNext: function(er) {
                        var me = this,
                            total = me.getPageData().pageCount,
                            next = me.store.currentPage + 1;
                        grid.getEl().mask('Loading..');
                        if (next <= total) {
                            if (me.fireEvent('beforechange', me, next) !== false) {
                                me.store.nextPage();
                            }
                        }

                        me.setPageRequest();
                        grid.getEl().unmask();
                    },
                    moveLast: function() {
                        var me = this,
                            last = me.getPageData().pageCount;
                        if (me.fireEvent('beforechange', me, last) !== false) {
                            me.store.loadPage(last);
                        }

                        me.setPageRequest();
                        grid.getEl().unmask();
                    },
                
                    onPagingKeyDown: function(field, et) {
                        var me = this,
                            pageData = me.getPageData(),
                            k = et.getKey();
                        if (k == et.RETURN) {
                            var pageVal = Ext.ComponentQuery.query('[itemId=inputItem]')[0].value;
                            if (pageVal == null || pageVal == '' || pageVal == undefined || pageVal == 'undefined')
                                return;
                            else if (pageVal > this.pageCount) {
                                Ext.Msg.alert('alert', 'No More Pages');
                                return;
                            } else {
                                me.setPageRequest(pageVal);
                            }
                        }
                    },
					 updateInfos : function(gridStore){
						var me = this,
							displayItem = me.child('#displayItem'),
							store = me.store,
							pageData = me.getPageDatas(gridStore),
							count, msg;
						if (displayItem) {
							count = store.getCount();
							if (count === 0 || gridStore.totalCount == 0) {
								msg = me.emptyMsg;
							} else {
								msg = Ext.String.format(
									me.displayMsg,
									pageData.fromRecord,
									pageData.toRecord,
									pageData.total
								);
							}
							displayItem.setText(msg);
						}
					},
					 getPageDatas : function(gridStore){
						var store = gridStore,
							totalCount = store.totalCount;
						return {
							total : totalCount,
							currentPage : store.currentPage,
							pageCount: Math.ceil(totalCount / store.pageSize),
							fromRecord: ((store.currentPage - 1) * store.pageSize) + 1,
							toRecord: Math.min(store.currentPage * store.pageSize, totalCount)
						};
					},
					getPageData : function(){
						var store = this.store,
						totalCount = this.localSortedData.gridJson.gridData.length;
						return {
							total : totalCount,
							currentPage : store.currentPage,
							pageCount: Math.ceil(totalCount / store.pageSize),
							fromRecord: ((store.currentPage - 1) * store.pageSize) + 1,
							toRecord: Math.min(store.currentPage * store.pageSize, totalCount)
						}
					},
					setChildDisabled: function(selector, disabled){
						var item = this.child(selector);
						if (item) {
							item.setDisabled(disabled);
						}
					},
                    setPageRequest: function(pageVal) {
						var gridLoadData = this.localSortedData.gridJson.gridData;
						var pageSize = this.store.pageSize;
						var currentPage = this.store.currentPage;
						if(!Ext.isEmpty(pageVal))
							currentPage = pageVal;
						var pageCount = Math.ceil(gridLoadData.length / pageSize);
						if(currentPage>pageCount)
							currentPage = pageCount;
						var tempStore = {
							pageSize :pageSize,
							currentPage:currentPage,
							totalCount: gridLoadData.length
						};
						this.updateInfos(tempStore);
						var afterTextItem = this.child('#afterTextItem');
						if(afterTextItem){
							afterTextItem.setText(Ext.String.format(pageCount+""));
						}
						var inputItem = this.child('#inputItem');
						if(inputItem){
							inputItem.setValue(currentPage);
						}
						var isEmpty = (gridLoadData.length == 0)? true:false;
						this.setChildDisabled('#first', currentPage === 1 || isEmpty);
						this.setChildDisabled('#prev', currentPage === 1 || isEmpty);
						this.setChildDisabled('#next', currentPage === pageCount  || isEmpty);
						this.setChildDisabled('#last', currentPage === pageCount  || isEmpty);
						var pageNumber = Ext.ComponentQuery.query('[itemId=inputItem]')[0].value;
						var t_gridData = loadPageData(gridLoadData,pc,currentPage);
						grid.getView().getTreeStore().getRootNode().removeAll();
						grid.getView().getTreeStore().getRootNode().appendChild(t_gridData);
						grid.getView().refresh();
						if(!isChildNodeAvailable){
							if(!Ext.isEmpty($('.gridTreeIcon')) && $('.gridTreeIcon').length>0 && !Ext.isEmpty($('.gridStateIcon')) && $('.gridStateIcon').length>0){
								$('.gridTreeIcon').css("display","none");
								$('.gridStateIcon').css("margin","auto auto");
							}
						}
						if($("#collapseExpand").is(':visible')){
							var value = $("#collapseExpand").attr("value");
							if(value == 'true'){
								EgCorAlarm.app.getController("CorrelatedController").collapseExpand(true);
							}
						}
                    }
                });
				
				
                try {
					//var el = Ext.ComponentQuery.query('[itemId=inputItem]')[0];
					//el.setValue(1);
					//console.log('aa-->',Ext.ComponentQuery.query('[itemId=inputItem]')[0])
                    this.getView().getTreeStore().getRootNode().removeAll();
                    this.getView().getTreeStore().getRootNode().appendChild(t_gridData);
                    this.getView().refresh();
					if(!isChildNodeAvailable){
						if(!Ext.isEmpty($('.gridTreeIcon')) && $('.gridTreeIcon').length>0 && !Ext.isEmpty($('.gridStateIcon')) && $('.gridStateIcon').length>0){
							$('.gridTreeIcon').css("display","none");
							$('.gridStateIcon').css("margin","auto auto");
						}
					}
                } catch (e) {
                    /*this.getView().emptyText =
                        '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';*/
                    this.getView().refresh();
                }
            } catch (e) {
                console.log(e);
                //alarmLoadMask.hide();
            }
        },
		afteritemexpand: function ( node, index, item, eOpts ){
			resetTooltip();
			resetIconsAndOpenWindows();
		},
		afteritemcollapse: function ( node, index, item, eOpts ){
			resetTooltip();
			resetIconsAndOpenWindows();
		}
    },
	customSorting:function(field,state,gridDataList,childSort){
		if(!Ext.isEmpty(this.mask)){
			this.mask.show();
		}
		var me = this;
		var data = []
		var tempData = []
		var isChildSort = true;
		if(!Ext.isEmpty(childSort) && !childSort)
			isChildSort = false;
		if(!Ext.isEmpty(Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0])){
			tempData = Ext.ComponentQuery.query("[itemId=pagingtoolbarId]")[0].rawAndSearchGridJson;
		}
		if(!Ext.isEmpty(gridDataList)){
			tempData = gridDataList;
		}
		if(!Ext.isEmpty(tempData) && !Ext.isEmpty(tempData.gridJson) && !Ext.isEmpty(tempData.gridJson.gridData))
			data = JSON.parse(JSON.stringify(tempData.gridJson.gridData))
		var valueList = [];
		var sortedGridData = [];
		if(!Ext.isEmpty(data)){
			var gridDatas = [];
			var count = 0;
			data.map(function(value,i){
				var fieldValue = JSON.parse(JSON.stringify(value[field]));
				if(field == 'COLUMN_6'){
					if(fieldValue.indexOf('.')>-1 && fieldValue.indexOf(' ')>-1)
					{
						var tmp = fieldValue.substring(0, fieldValue.lastIndexOf(' '));
						var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
						var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
						fieldValue = formDate + fieldValue.substring(fieldValue.lastIndexOf(' '), fieldValue.length);
					}
					if(!isNaN(new Date(fieldValue)))
					{
						fieldValue=new Date(fieldValue).getTime(); 
					}
					fieldValue +="";
				}
				fieldValue = fieldValue.toLowerCase();
				if(field == 'COLUMN_0')
					fieldValue = me.changeStateValue(fieldValue);
				valueList.push({key:fieldValue.trim().replace(/<\/?[^>]+(>|$)/g, ""),value:count++});
				var children1 = [];
				if(isChildSort && !Ext.isEmpty(value.children)){
					children1 = JSON.parse(JSON.stringify(value.children));
					value.children = [];
				}
				gridDatas.push(value);
				if(isChildSort && !Ext.isEmpty(children1)){
					var child1 = JSON.parse(JSON.stringify(children1));
					child1.map(function(childValue1){
						fieldValue = JSON.parse(JSON.stringify(childValue1[field]));
						if(field == 'COLUMN_6'){
							if(fieldValue.indexOf('.')>-1 && fieldValue.indexOf(' ')>-1)
							{
								var tmp = fieldValue.substring(0, fieldValue.lastIndexOf(' '));
								var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
								var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
								fieldValue = formDate + fieldValue.substring(fieldValue.lastIndexOf(' '), fieldValue.length);
							}
							if(!isNaN(new Date(fieldValue)))
							{
								fieldValue=new Date(fieldValue).getTime(); 
							}
							fieldValue +="";
						}
						fieldValue = fieldValue.toLowerCase();
						if(field == 'COLUMN_0')
							fieldValue = me.changeStateValue(fieldValue);
						valueList.push({key:fieldValue.trim().replace(/<\/?[^>]+(>|$)/g, ""),value:count++});
						var children2 = [];
						if(!Ext.isEmpty(childValue1.children)){
							children2 = JSON.parse(JSON.stringify(childValue1.children));
							childValue1.children = [];
						}
						gridDatas.push(childValue1);
						if(!Ext.isEmpty(children2)){
							var child2 = JSON.parse(JSON.stringify(children2));
							child2.map(function(childValue2){
								fieldValue = JSON.parse(JSON.stringify(childValue2[field]));
								if(field == 'COLUMN_6'){
									if(fieldValue.indexOf('.')>-1 && fieldValue.indexOf(' ')>-1)
									{
										var tmp = fieldValue.substring(0, fieldValue.lastIndexOf(' '));
										var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
										var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
										fieldValue = formDate + fieldValue.substring(fieldValue.lastIndexOf(' '), fieldValue.length);
									}
									if(!isNaN(new Date(fieldValue)))
									{
										fieldValue=new Date(fieldValue).getTime(); 
									}
									fieldValue +="";
								}
								fieldValue = fieldValue.toLowerCase();
								if(field == 'COLUMN_0')
									fieldValue = me.changeStateValue(fieldValue);
								valueList.push({key:fieldValue.trim().replace(/<\/?[^>]+(>|$)/g, ""),value:count++});
								gridDatas.push(childValue2);
							});
						}
					});
				}
			});
			if(state == "ASC"){
				 valueList.sort(function(a, b){
					var x = a.key;//.toLowerCase();
					var y = b.key;//.toLowerCase();
					if (x < y) {return -1;}
					if (x > y) {return 1;}
					return 0;
				  });
			}else{
				valueList.sort(function(a, b){
					var x = a.key;//.toLowerCase();
					var y = b.key;//.toLowerCase();
					if (x > y) {return -1;}
					if (x < y) {return 1;}
					return 0;
				  });
			}
			valueList.map(function(item){
				sortedGridData.push(gridDatas[item.value]);
			});
			var jsonFormat ={gridJson:{gridData:sortedGridData}};
				jsonFormat = processDataforGrid(jsonFormat);
			return jsonFormat;
		}
		return null;
	},
	hideShowFields: function(){
		var dataAvailable = publicJson['dataAvailable'];
		var showDeleteBtn = publicJson['pageParams']['showDeleteBtn'];
		var showAcknowledgeBtn = publicJson['pageParams']['showAcknowledgeBtn'];
        var showChkBox = publicJson['pageParams']['showCheckBox'];
		this.columns[0].hide();
		Ext.getCmp('searchTextBox').hide();
		Ext.getCmp('AlarmTabAckDelToolbar').hide();
		Ext.getCmp('alarmTabDelteBtn').hide();
		Ext.getCmp('alarmTabAckBtn').hide();
		if(!Ext.isEmpty(dataAvailable) && dataAvailable=="true"){
			Ext.getCmp('searchTextBox').show();
			if(!Ext.isEmpty(showDeleteBtn) && showDeleteBtn=='true'){
				Ext.getCmp('AlarmTabAckDelToolbar').show();
				Ext.getCmp('alarmTabDelteBtn').show();
			}
			if(!Ext.isEmpty(showAcknowledgeBtn) && showAcknowledgeBtn=='true'){
				Ext.getCmp('AlarmTabAckDelToolbar').show();
				Ext.getCmp('alarmTabAckBtn').show();
			}
			if(!Ext.isEmpty(showChkBox) && showChkBox=='true'){
				this.columns[0].show();
			}
		}
	},
	changeStateValue :function(value){
			if(!Ext.isEmpty(value)){
				if(value.indexOf('critical')>-1)
					value = "state_high";
				else if(value.indexOf('major')>-1)
					value = "state_intermediate";
				else if(value.indexOf('minor')>-1)
					value = "state_low";
			}
			return value;
	}
});

function numPages(objJson,records_per_page)
{
    return Math.ceil(objJson.length / records_per_page);
}
function loadPageData(objJson,records_per_page,page)
{
	isChildNodeAvailable = false;
	objJson = JSON.parse(JSON.stringify(objJson))
	var ret_obj = [];

	if (page < 1) 
		page = 1;
	var l = numPages(objJson,records_per_page);
	if (page > l)
		page = l;

	try
	{
		for (var i = (page-1) * records_per_page; i < (page * records_per_page) && i < objJson.length; i++) {
			ret_obj.push(objJson[i]);
			if(!Ext.isEmpty(objJson[i].children)){
				isChildNodeAvailable = true;
			}
		}
	}
	catch (e)
	{
	}
	return ret_obj;
}
