var showStarMsg = false;
Ext.define("RumRequestFlow.view.TransactionDetails", {
	extend: "Ext.form.Panel",
	alias: "widget.transactionDetails",
	id: "transactionDetails",
	//cls:'outerpanel',
	flex:1,
	//height:1500,
	//margin:'8 8 0 8',
	//title:"Transaction Details",
	requires: [
		'utilities.ScrollCombo'
	],
	//header:{cls:'textUpper'},
	layout:
	{
		type: 'vbox',
		align: 'stretch'
	},

	listeners:{
		afterrender:function(c){
			(function(data){
				if(Ext){
					Ext.tip.QuickTipManager.init();	
				}
				//console.log(data);
					var url = data.rumTopology.header_Info.URL,
					urlParam = data.rumTopology.header_Info.URL_PARAMS ||'',
					urlRquestDataTime = data.rumTopology.header_Info.REQUEST_DATE,
					urlZone = data.rumTopology.header_Info.REQUEST_TIME_ZONE,
					userData = data.rumTopology.user_Info,
					browserData = data.rumTopology.browser_Info,
					contentData = data.rumTopology.contentDownload_Info,
					contentData = data.rumTopology.contentDownload_Info,
					networkData = data.rumTopology.network_Info,
					backendData = data.rumTopology.backend_Info,
					btmTopologyURL = data.rumTopology.backend_Info.BTM_TOPOLOGY_URL,
					pieChartData = data.rumTopology.pieChart_Info,
					navSupport = data.navSupport,
					msgForResourceTab = data.rumTopology.msgResourceTab,
					mappingNameData = data.rumTopology.mappingName_Info,
					ajaxType = data.rumTopology.browser_Info.PAGETYPE,
					skin = data.rumTopology.skin,
					error_Count = userData.ERROR_MSG_COUNT,
					resourceData = data.gridData;
					if(!btmTopologyURL || btmTopologyURL == 'null' || btmTopologyURL == '-'){
						btmTopologyURL = "";
					}
				var loadResourceData = function(data,x,y){
					//console.log(data);
					if(!Ext.isEmpty(data)){
							var store = Ext.create('Ext.data.Store', {
								 storeId: 'resourceStore',
								 fields: ['Resource_Name', 'Resource_Domain', 'Resource_Type', 'Resource_Time'],
								data: data
							});
						
						var grid = Ext.create('Ext.grid.Panel', {
								closeAction:'destroy',
								cls:'gridSkin',
								flex:1,
								emptyText: mappingNameData.NO_DATA_FOUND,
								store: store,
								columns: [{
									text: '<span style="text-transform: uppercase">'+mappingNameData['RESOURCES']+'</span>',
									dataIndex: 'Resource_Name',
									flex: 1.98
								},{
									text: '<span style="text-transform: uppercase">'+mappingNameData['DOMAIN']+'</span>',
									dataIndex: 'Resource_Domain',
									flex: 0.9
								},{
									text: '<span style="text-transform: uppercase">'+mappingNameData['TYPE']+'</span>',
									dataIndex: 'Resource_Type',
									flex: 0.5
								}, {
									text: '<span style="text-transform: uppercase">'+mappingNameData['DURATION']+'<span style="text-transform: lowercase"><br>('+mappingNameData['MILLISEC']+')</span>',
									flex: 0.62,
									dataIndex: 'Resource_Time'
								}]
							});

							Ext.create('Ext.window.Window',{
								floating:true,
								width:500,
								height:300,
								modal:true,
								tools:[
								{
									xtype:'button',
									tooltip:'Maximize',
									border:false,
									margin:'0 5 0 5',
									handler:function(){
												 var win = this.up('window');
												 win.setWidth(Ext.getBody().getViewSize().width - 20,true);
												win.setHeight(Ext.getBody().getViewSize().height - 20,true);
												win.center();
												this.hide();
												this.next('button').show();
									},
									cls:'iconMaximizeGray'
								},
								{
									xtype:'button',
									hidden:true,
									tooltip:'Minimize',
									border:false,
									margin:'0 5 0 5',
									handler:function(){
										var win = this.up('window');
												win.setWidth(500,true);
												win.setHeight(300,true);
												win.showAt(x,y);
												this.hide();
												this.prev('button').show();
									},
									cls:'iconMinimizeGray'
								}
								],
								ghost:false,
								padding:'5 10 10 10',
								
								renderTo:Ext.getBody(),
								layout:{
									type:'vbox',
									align:'stretch'
								},
								closeAction:'destroy',
								//title: '<span style="text-transform: uppercase;font-size:12px;">Details Of Page Contents</span>',
								items:[grid]
							}).showAt(x,y);
					}else{
						return false;
					}
				}
				$.fn.loadData = function(){
					this.msgBlock = function(data){	
						var _this = $(this);
						
						var textInfo = '<div style="display:inline-block;"><table class="rumRequestInfoBox">';
						
						if(navSupport != null && navSupport == 'false')
						{
							textInfo = textInfo + '<tr><td><table><tr><td><img src="/final/images/Light/iconInformationSmall.png" style="vertical-align: middle;"></td><td class="rumRequestText" >'+mappingNameData['BROWSER_NOT_SUPPORT']+'</td></tr></table></td></tr>';
						}
						if(hideResourceTab)
						{
							textInfo = textInfo + '<tr><td><table><tr><td ><img src="/final/images/Light/iconInformationSmall.png" style="vertical-align: middle;"></td><td class="rumRequestText">'+mappingNameData['BROWSER_NOT_SUPPORT_RESOURCE_API']+'</td></tr></table></td></tr>';
						}
							
						textInfo = textInfo + '</table></div>';

						_this.append(textInfo);
					};
					this.userBlock = function(data) {

						$toogle = $("<div>",{id:"toogleGrp","class":"toogleGrp"});
						$toogleList = $("<div>",{id:"toogleList"});
						$toogle.append($toogleList);
						$toogle.append('<button id="toggleButton" class="rumtogglearrow"></button>');
						if(userData){
							var _this = $(this);
							for (var keys in data)
							{
								if (data.hasOwnProperty(keys)) {
									// console.log(keys);
									switch(keys){
										case 'USER_NAME':
											_this.append('<div class="username">'+data['USER_NAME']+'</div>');
										break;
										case "DEVICE":
											var device = "DEVICE";
											_this.append('<div class="rumuserIcon"><div class="deviceinfo" data-qtip='+mappingNameData['DEVICE']+':&nbsp;'+data['DEVICE']+' "data-qclass="yellowTip"><div class='+data['DEVICE']+' ></div></div></div>');
										break;
										case "RUM_USER_EXPERIENCE":
											_this.append('<div class="rumUX'+data['RUM_USER_EXPERIENCE']+'"></div><div class="font24">'+data['PAGE_LOAD_TIME']+'</div><div class="font_bold" style="margin:5px auto;">'+mappingNameData["PAGE_LOAD_TIME"]+' ('+mappingNameData['MILLISEC']+')</div>');
										break;
										case "PAGE_LOAD_TIME":
											_this.append('');
										break;
										default:
											$list = $("<div>",{"class":"list","style":"margin-bottom:5px"});
											var tipdata = "", tipmessage;

											if(keys === "CITY"){
											
											$list.html('<div class="iconRUM'+keys+'" style="float:left" data-qtip='+mappingNameData['LOCATION']+' data-qclass="yellowTip"></div><div class="block'+keys+' listblk brlist" style="float:left;margin-left:5px;" data-qtip='+mappingNameData['LOCATION']+' data-qclass="yellowTip">'+data["CITY"]+', '+data["REGION"]+', '+data["COUNTRY"]+', '+data["COUNTRY_CODE"]+'</div><div style="clear:both"></div></div>');
											}else{
											if(keys == "ERROR_MESSAGE"){
												tipdata = mappingNameData[keys]+"&nbsp;:&nbsp;"+data[keys];
												_this.append('<div id="rum_errorview" class="rum_errorview"></div>');
												_this.append('<div class="rum_error" style="height:45px"><div id="error_minimizeButton" style="position: relative;top: 65px;float: right;" class="error_tgleButt rumtogglearrow mouse"><img src="/final/images/clear.png" width="20" height="20"/></div><div class="rumErrorMinimise" style="display:none;overflow:hidden;">'+mappingNameData['ERROR']+'</div><div class="rumError_cont" style="height:70px"><div style="padding:1px;font-size:12px;word-wrap:break-word;" class="error_con">'+tipdata+'</div></div><div>');
												//console.log($('.error_con').height())
												//if($('.error_con').height() > 58){
													//$('.rum_error').append('<button id="error_toggleButton" class="error_tgleButt rumtogglearrow"></button>');
												//}
												tipmessage = trimString(data[keys],70,8);

											}else{
												tipdata = mappingNameData[keys];
												tipmessage = data[keys];
											}
												if(keys != "ERROR_MESSAGE" && keys != "DOCUMENT_CONTENT_LOADED"){
													$list.html('<div class="iconRUM'+keys+'" style="float:left;" data-qtip="'+tipdata+'" data-qclass="yellowTip"></div><div style="float:left;margin-left:5px;width: 100px;text-align: left;word-wrap: break-word;word-break: break-word;" class="block'+keys+' listblk brlist" data-qtip="'+tipdata+'" data-qclass="yellowTip">'+tipmessage+'</div><div style="clear:both"></div></div>');
												}
												if(keys == "ERROR_MSG_COUNT"){
														$list.html(' ');
												}
											}
											_this.append($toogle);
											$toogleList.append($list);
										break;
									}
								}
							}						
						}
					};
					this.browserBlock = function(browserData){
						
						if(navSupport != null && navSupport == 'true')
						{
							$bwrDiv = $('<div>',{"class":"bwrDiv"});
							$bwrContentDiv = $('<div>',{"class":"bwrContent"});
							$bwrlistDiv = $('<div>',{"class":"bwrlistDiv",id:"listDiv"});
							$bwrFooter = $('<div>',{"class":"bwrfooter"});
							
							$bwrFooter.append('<button id="browserToggle" class="rumtogglearrow" style="margin-left:170px;position: relative; z-index: 1;"> </button>');
							$bwrDiv.append($bwrContentDiv);
							$bwrDiv.append($bwrFooter);
							if(browserData){
								var _this = $(this);
								for(var keys in browserData){
									if(browserData.hasOwnProperty(keys)){
										if(keys == "BROWSER" || keys == "VERSION" || keys == "PAGETYPE")
										{
											var bdValue = browserData[keys];
											if(keys == "PAGETYPE" && bdValue == 'AjaxPage'){
												bdValue = 'Ajax';
											}
											$list = $("<div>",{"class":"list","style":"margin-bottom:5px" ,"data-qtip":""+mappingNameData[keys]+"" , "data-qclass":"yellowTip"});
											$list.html('<div class="iconRUM'+keys+'" style="float:left"></div><div style="float:left;margin-left:5px;width: 100px;text-align: left;word-wrap: break-word;word-break: break-word;" class="brlist" >'+bdValue+'</div></div><div style="clear:both;padding:0px 0px!important"></div>');
										}
										if(keys == "REFERRER")
										{
											$list = $("<div>",{"class":"list","style":"margin-bottom:5px" ,"data-qtip":""+mappingNameData[keys]+" : "+browserData[keys]+"" , "data-qclass":"yellowTip"});
											$list.html('<div class="iconRUM'+keys+'" style="float:left"></div><div style="float:left;margin-left:5px;width:135px;height:15px;text-align:left;overflow: hidden;text-overflow:ellipsis;" class="brlist" >'+browserData[keys]+'</div></div><div style="clear:both;padding:0px 0px!important"></div>');

										}
										if(keys == "PAGE_RENDER_TIME"){
										
											//var contentAjax = ajaxType == "Ajax" ? "Ajax Callback Time" : "Browser Time";
											//$bwrContentDiv.append("<div style='padding:15px 0px 0px 0px'><div class='font24 bfont' >"+browserData["PAGE_RENDER_TIME"]+"<span style='font-size:12px;letter-spacing: 0px;vertical-align: 2px' class='ms'> (ms)</span></div><div><div class='font_bold' style='margin:5px auto 0px auto;padding:0px 0px 15px 0px '>"+contentAjax+"</div>");
											var $requestTemplate = "<div style='padding:3px 0px 0px 0px'>"+
																		"<fieldset class='bwrFieldset'>"+
																		"<legend>"+mappingNameData['REQUEST']+"</legend>"+
																			"<ul>"+
																				"<li><span class='browserWaitIcon'></span><span>"+mappingNameData["BROWSER_WAIT_TIME"]+"</span><span style='float:right; margin-right:10px;'>"+browserData["BROWSER_WAIT_TIME"]+"</span></li>"+
																				 "<li><span class='redirectionIcon'> </span><span>"+mappingNameData["REDIRECTION_TIME"]+"</span><span style='float:right; margin-right:10px;'>"+browserData["REDIRECTION_TIME"]+"</span></li>"+
																				"<li><span class='appCacheIcon'></span><span>"+mappingNameData["APP_CACHE_TIME"]+"</span><span style='float:right; margin-right:10px;'>"+browserData["APP_CACHE_TIME"]+"</span></li>"+
																			"</ul>"+
																		"</fieldset>"+
																  "<div>";
											
											var pageRenderTime_text = mappingNameData['RESOURCE_FETCH_RENDERING_TIME'];
											var pageRenderTime_ddImg ="<img src='/final/images/clear.png' class='mouse rumtopologyDDIcon' style='position:absolute;background-color: transparent;'/>";
											if(ajaxType == "AjaxPage"){
												pageRenderTime_text = mappingNameData.AJAX_CALLBACK_TIME_MS;
												pageRenderTime_ddImg ='';
											}
											var $responseTemplate = "<div style='padding:0px 0px 0px 0px'>"+
																		"<fieldset class='bwrFieldset bwrFieldset2bg'>"+
																		"<legend >"+mappingNameData['RESPONSE']+"</legend>"+
																			"<ul>"+
																				"<li><span  class='renderingIcon' style='display: inline-block;vertical-align:middle'></span><span onclick='moveTab()' style='cursor:pointer;display: inline-block;width:94px;vertical-align: middle;'>"+pageRenderTime_text+"&nbsp;&nbsp;"+pageRenderTime_ddImg+"</span><span style='vertical-align: middle;display: inline-block;width: 50px;text-align:right;'>"+browserData["PAGE_RENDER_TIME"]+"</span><div style='clear:both'></div></li>"+
																			"</ul>"+
																		"</fieldset>"+
																  "<div>";
											if(ajaxType == "Ajax"){
												dataText = mappingNameData.AJAX_CALLBACK_TIME_MS;
												$responseTemplate = "<div style='padding:10px 0px 0px 0px'>"+
																		"<fieldset class='bwrFieldset bwrFieldset2bg'>"+
																			
																			"<ul>"+
																				"<li>"+
																					"<span class='renderingIcon'></span>"+
																					"<span style='display: inline-block;width:90px;vertical-align: middle;'>"+dataText+"</span>"+
																					"<span style='vertical-align: middle;display: inline-block;width: 62px;text-align:right;'>"+browserData["PAGE_RENDER_TIME"]+"</span>"+
																				"</li>"+
																			"</ul>"+
																		"</fieldset>"+
																	"</div>";
											
												$bwrContentDiv.append($responseTemplate);
												
											}else{
												$bwrContentDiv.append($requestTemplate,$responseTemplate);
											}
											
											_this.append($bwrDiv);
										}else{
											
											$bwrContentDiv.append($bwrlistDiv);
											
											$bwrlistDiv.append($list);
											
											_this.append($bwrDiv);
										}
									}
								} 
							}
						}
						else if(ajaxType == "Ajax" || (navSupport != null && navSupport == 'false'))
						{

							var dataText = mappingNameData.BROWSER_TIME_MS;
							if(ajaxType == "Ajax")
								dataText = mappingNameData.AJAX_CALLBACK_TIME_MS;

							var _this = $(this);
							$bwrDiv = $('<div>',{"class":"bwrDiv"});
							$bwrlistDiv = $('<div>',{"class":"bwrlistDiv",id:"listDiv"});
							$bwrContentDiv = $('<div>',{"class":"bwrContent"});
							$bwrFooter = $('<div>',{"class":"bwrfooter"});
							//$bwrFooter.append('<button id="browserToggle" class="rumtogglearrow" style="margin-left:170px;position: relative; z-index: 1;"> </button>');
							
							$bwrDiv.append($bwrContentDiv);
							$bwrContentDiv.append("<div style='padding:10px 0px 0px 0px'><fieldset class='bwrFieldset bwrFieldset2bg'><legend>"+mappingNameData['RESPONSE']+"</legend> <ul><li><span class='renderingIcon'></span><span style='display: inline-block;width:90px;vertical-align: middle;'>"+dataText+"</span><span style='vertical-align: middle;display: inline-block;width: 62px;text-align:right;'>"+browserData["PAGE_RENDER_TIME"]+"</span></li></ul> </fieldset> </div>");
							//$bwrContentDiv.append("<div style='padding:10px 0px 0px 0px'><span>Browser Time (ms)</span><span style='float:right; margin-right:10px; '>"+browserData["PAGE_RENDER_TIME"]+"</span> </div>");
							$bwrContentDiv.append($bwrlistDiv)
							$bwrDiv.append($bwrContentDiv);
							$bwrDiv.append($bwrFooter);
							_this.append($bwrDiv);
						}
					};
					this.contentDownload = function(contentdownloaddata){
						var contentDownloadTimeText = ( ajaxType == "Ajax" || ajaxType == "AjaxPage") ? mappingNameData.CONTENT_DOWNLOAD_TIME : mappingNameData.HTML_DOWNLOAD_TIME;
						if(navSupport != null && navSupport == 'true')
						{
							//$src_details = '<img data-qtip="Resource details" style="cursor:pointer;vertical-align:middle" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconTopologySearch"/>';
							$src_details = '<img style="cursor:pointer;vertical-align:middle" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconTopologySearch"/>';
							
							//$cntlistDiv = $('<div>',{"class":"listDiv contentdownload",id:"cntDiv","data-qclass":"yellowTip","data-qtip":contentDownloadTimeText+" Break-up","style":"min-width: 250px;"});
							$cntlistDiv = $('<div>',{"class":"listDiv contentdownload",id:"cntDiv","style":"min-width: 250px;"});
							$cntlistdetail = $('<div>',{"class":"cntlistdetail","style":"padding:20px 20px 10px 0px;color:#FFF"});
							$cntlistdetail.html('<div class="font24" style="color:#FFF; padding-bottom:10px; float:left; margin:0px 20px 0px 0px;line-height:24px;">'+contentdownloaddata['DOCUMENT_READY_TIME']+'</div><div onclick="moveTab()"  class="mouse font_bold"  style="color:#FFF;margin:0px auto; text-align: left;" >'+contentDownloadTimeText+'&nbsp;'+$src_details+'</div><div style="clear:both"></div>');
								$cntlistDiv.append($cntlistdetail);
							if(contentdownloaddata){
								var _this = $(this);
								var pointer ="cursor:auto";
								for (var keys in contentdownloaddata)
								{
									if(contentdownloaddata.hasOwnProperty(keys)){
										if(keys == "DOCUMENT_READY_TIME"){
											
											var contentAjax = (ajaxType == "Ajax" || ajaxType == "AjaxPage") ? "hidden" : "visible";
											_this.append('<div><div class="font24 cfont"><span class="fbg cntText">'+contentdownloaddata[keys]+'</span><button id="contentdownload" style="visibility:'+contentAjax+'"></button></div><div class="font_bold" style="margin:0px auto;width:150px"><span class="fbg">'+contentDownloadTimeText+'</span></div></div>');
										}else{
											$list = $("<div>",{"class":"list"});
											var resourceDetaillinkID ="";
											$src_details = "";
												if(!Ext.isEmpty(data.gridData)){
													if(keys == "Document Processing Time (ms)"){
														//pointer ="cursor:pointer";
														//resourceDetaillinkID = "link";
														//$src_details = '<img  data-qtip="Resource details" style="cursor:pointer;vertical-align:middle" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconTopologySearch"/>';											
													}
												}

											$list.html('<div style="float:left;width:70%;white-space: nowrap;"><div><span id='+resourceDetaillinkID+' data-qtip='+mappingNameData['RESOURCE_DETAILS']+' style="'+pointer+';position:relative;z-index:1">'+keys+' '+$src_details+'</span></div></div><div style="float:right;text-align:right;width:30%">'+contentdownloaddata[keys]+'</div><div style="clear:both;padding:0px 0px!important"></div>');
											$cntlistDiv.append($list);
											_this.append($cntlistDiv);
										}
									}
								}
							}
						}
						else
						{
							var _this = $(this);
							_this.append('<div><div class="font24 nfont"><span class="fbg ntText">'+contentdownloaddata["DOCUMENT_READY_TIME"]+'</span></div><div class="font_bold" style="margin:0px auto;width:150px"><span class="fbg">'+contentDownloadTimeText+' </span></div></div>');
						}
					};
					this.isAjax = function(ajaxType){
							var _this = $(this);
							$nwtDetail = $('<div>',{"class":"nwtDetail","style":"padding:20px 20px 10px 20px;"});
							//$nwtDetail.html('<div class="fbg" style="padding:10px;width:40px;margin:-20px  auto"><span class="font_bold14">'+ajaxType+'<br>Call</span></div>');
							$nwtDetail.html('<div class="fbg" style="padding:10px;width:40px;margin:-45px  auto"><span class="font_bold">'+ajaxType+'<br>'+mappingNameData['CALL']+'</span></div>');
							_this.append($nwtDetail);
					}
					this.networkInfo = function(networkInfodata){
						if(navSupport != null && navSupport == 'true')
						{
							//$nwtlistDiv = $('<div>',{"class":"listDiv",id:"nwtDiv","data-qclass":"yellowTip","data-qtip":mappingNameData.NETWORK_CONNECTION_BREAK_UP,"style":"min-width: 250px;"});
							$nwtlistDiv = $('<div>',{"class":"listDiv",id:"nwtDiv","style":"min-width: 250px;"});
							$nwtDetail = $('<div>',{"class":"nwtDetail","style":"padding:20px 20px 10px 0px;color:#FFF"});
							$nwtDetail.html('<div class="font24" style="line-height:24px;color:#FFF; padding-bottom:10px; float:left; margin:0px 20px 0px 0px; ">'+networkInfodata['SERVER_CONNECTION_TIME']+'</div><div class="font_bold"  style="color:#FFF;margin:0px auto;text-align:left;float:left;width:130px;" >'+mappingNameData['NETWORK_CONNECTION_TIME']+'</div><div style="clear:both;"></div>');
							$nwtlistDiv.append($nwtDetail);

							if(contentDownloadInfo){
								var _this = $(this);
								for (var keys in networkInfodata)
								{
									if(networkInfodata.hasOwnProperty(keys)){
										if(keys == "SERVER_CONNECTION_TIME"){
													
													if(networkInfodata["SERVER_CONNECTION_TIME"] == 0)
													{
														_this.append('<div id="networkBlock"><div class="font24 nfont"><span class="fbg ntText" style="padding: 0px 10px 0px 5px;" >'+networkInfodata["SERVER_CONNECTION_TIME"]+'</span><span  class="font24" style="font-size:16px;position:absolute;margin:-5px 0px 0px -12px;" >*</span><button id="shownetworkconnections"></button></div>  <div class="font_bold" style="margin:0px auto;width:150px"><span class="fbg">'+mappingNameData['NETWORK_CONNECTION_TIME']+'</span></div></div>');	
														showStarMsg = true;
													}
													else
													{
														_this.append('<div id="networkBlock"><div class="font24 nfont"><span class="fbg ntText" style="padding: 0px 5px;" >'+networkInfodata["SERVER_CONNECTION_TIME"]+'</span>   <button id="shownetworkconnections"></button></div>  <div class="font_bold" style="margin:0px auto;width:150px"><span class="fbg">'+mappingNameData['NETWORK_CONNECTION_TIME']+'</span></div></div>');				
														showStarMsg = false;
													}
										}else{
											$list = $("<div>",{"class":"list"});
											$list.html('<div><div style="float:left;width:70%;white-space: nowrap;">'+keys+'</div><div style="float:right">'+networkInfodata[keys]+'</div><div style="clear:both;padding:0px 0px!important"></div></div>');
											$nwtlistDiv.append($list);
										}
									}
								}
								_this.append($nwtlistDiv);
							}
						}
					};
					this.backendInfo = function(backendInfodata){
						if(backendInfodata){
							var _this = $(this);
							for (var keys in backendInfodata)
							{
								if(backendInfodata.hasOwnProperty(keys) && keys == 'RESPONSE_AVAILABLE_TIME'){ 
										var dd_icon = '<button class="rumtopologyDDIcon" style="vertical-align: middle;margin-left:5px;"></button>';
										var condition_apply = '<sup class="font24" style="font-size:16px;">**</sup>';
										var linkTag ='a';
										if(!btmTopologyURL){
											btmTopologyURL='#';
											dd_icon='';
											//condition_apply='';
											linkTag = 'span';
										}
									 _this.append('<div style="position:absolute;top:35%;bottom:50%;left:0%;right:0%"><div class="font24 be_font"><'+linkTag+' href="'+btmTopologyURL+'" class="be_font">'+backendInfodata[keys]+condition_apply+''+dd_icon+'</'+linkTag+'></div><div class="font_bold" style="margin:0px auto;">'+mappingNameData['SERVER_TIME']+' ('+mappingNameData['MILLISEC']+')</div></div>');
								}
							}
						}
					};
					this.loadChart = function(pieChartData){
						if(pieChartData){
							var _this = $(this),chartData=[],k=0;
							// console.log(pieChartData);
							for (k;k<pieChartData.length;k++ )
							{
								//console.log("pieChartData[k]",pieChartData[k])
									chartData.push({
										name: pieChartData[k].value,
										y: pieChartData[k].value,
										legend: pieChartData[k].legend,
										color: pieChartData[k].color,
										dataLabels: {
											enabled: true,
											formatter: function(){
											 return((this.point.percentage>9.9?Highcharts.numberFormat(this.point.percentage,0)+" % ": null));
											}
										}	
									});
							}
							// console.log(chartData);
							_this.highcharts({
								chart: {
									type: 'pie',
									marginLeft:11,
									marginTop:10,
									marginRight:11,
									marginBottom:36,
									style: {
											fontFamily: 'Roboto',
											fontWeight: 'normal'
									},
									styledMode: false,
									backgroundColor:'transparent'							
								},
								exporting: {
								 enabled: false
								},
								credits: {
								  enabled: false
							  },
								title: {
									text: mappingNameData.BREAKUP_OF_PAGE_LOAD_TIME,
									
									style: {
										color: skin == "Dark" ? '#c6c6c6' : '#000000',
										fontSize:"12px",
										fontWeight: 'normal',
										fontFamily:'Roboto'
									}
								},
								plotOptions: {
									 
									pie: {
										showInLegend: true,
										point:{
											events : {
												 legendItemClick: function(e){
												 this.select();
												 var chart =  $('#chartBlock').highcharts();
												 chart.tooltip.refresh(this);
												 return false;
												}
											}
										},
										startAngle: 0,
										endAngle: 360,
										borderWidth: 0,
										shadow: false,										
										dataLabels: {
											distance:-25,
											enabled: true,
											style: {
												fontWeight:'bold',
												color: '#FFFFFF',
												textShadow:false,
												textOutline:false
											}
										}
									}								
								},
								tooltip: {
									formatter: function() {
										var tooltipText;
										switch(this.point.legend){
											case "CONTENT_DOWNLOAD_PERCENTAGE":
												tooltipText = (ajaxType == "Ajax" || ajaxType == "AjaxPage") ? mappingNameData.CONTENT_DOWNLOAD_TIME : mappingNameData.HTML_DOWNLOAD_TIME;
											break;
											case "BROWSER_PERCENTAGE":
												tooltipText  = ajaxType == "Ajax" ? mappingNameData.AJAX_CALL_BACK_TIME : mappingNameData.BROWSER_TIME;
											break;
											case "NETWORK_PERCENTAGE":
												tooltipText = mappingNameData.NETWORK_CONNECTION_TIME;
											break;
											case "BACKEND_PERCENTAGE":
												tooltipText = mappingNameData.SERVER_TIME;
											break;
										}
										return tooltipText;
									}
								},
								/*"tooltip": {
									"formatter": function(){
										return this.point.name+": <b>"+this.y+" ms </b>("+Highcharts.numberFormat(this.percentage,2)+" %) ";
									}
								},*/
								legend: {
									align: 'left',
									
									 labelFormatter: function () {
										var legendText;
										switch(this.legend){
											case "CONTENT_DOWNLOAD_PERCENTAGE":
												legendText = (ajaxType == "Ajax" || ajaxType == "AjaxPage") ? mappingNameData.CONTENT_DOWNLOAD_TIME : mappingNameData.HTML_DOWNLOAD_TIME;
											break;
											case "BROWSER_PERCENTAGE":
												legendText = ajaxType == "Ajax" ? mappingNameData.AJAX_CALL_BACK_TIME : mappingNameData.BROWSER_TIME;
											break;
											case "NETWORK_PERCENTAGE":
												legendText = mappingNameData.NETWORK_CONNECTION_TIME;
											break;
											case "BACKEND_PERCENTAGE":
												legendText = mappingNameData.SERVER_TIME;
											break;
										}
										return legendText;
									},
									layout: 'vertical',
									itemHoverStyle:{
										"color": "#84b8e4"
									},
									itemStyle:{
												"fontSize": "11px", 
												"dy":"10px",
												"fontWeight": "normal",
												"color": skin == "Dark" ? '#c6c6c6' : '#000000',
											},
									lineHeight:10,
									symbolHeight:8,
									symbolWidth:8,
									verticalAlign: 'bottom',
									x: -10,
									dy:5,
									y: 3
									
								},
								series: [{
									data: chartData,
									innerSize: '44%',
									size: '100%'
								}]
							});

							_this.append('<div class="chartMirror"></div>');
						}					
					}		 
					return this;
				}

				var $mainDiv = $("<div>", {id: "rumTopology", "class": "RUMTopologywrapper"});
				var $mainBODY = $("<div>", {id: "rumTopology-body", "class": "RUMTopologybodywrapper"});
				var $headerDiv = $("<div>", {"class": "rumTopologyheader"});
				var $rumTopologyTitle = $("<div>", {"class": "rumTopologyTitle"});
				var $rumTopologySubTitle = $("<div>", {"style":"text-align:center; font-size:12px;padding-left: 20px;line-height:15px;position:absolute;top:50px;width:65%;white-space:nowrap;left:0;right:0;margin:0 auto;"});
				var $msgBlock =  $("<div>", {"class": "rumRequestflowInfo"});
				var $topologyBlock = $("<div >", {id:"topologyBlock","class": "topologyBlock","style":"z-index:2"});
				var $userBlock = $("<div>", {"class": "userBlock"});
				var $arrowBlock = $("<div>", {"class": "arrowBlock"});
				var $browerBlock = $("<div>", {"class": "browerblock"});
				if(ajaxType == "Ajax"){
					$browerBlock = $("<div>", {"class": "browerblock browerblock-margin"});
				}
				
				var $browerlayerBlock = $("<div>", {"class": "browerlayer"});
				var $requestrespondblock = $("<div>", {"class": "requestrespondblock1","style":"height:360px"});
				var $contentDownloadInfo = $("<div>", {"class": "contentdownloadinfo"});
				if((navSupport != null && navSupport == 'false') || ajaxType == "Ajax"){
					 $requestrespondblock = $("<div>", {"class": "requestrespondblock ajax"});
					 $contentDownloadInfo = $("<div>", {"class": "contentdownloadinfo ajax"});
				}
				//var $requestrespondblockarrow = $("<div>", {class: "requestrespondblockarrow"});
				
				var $networkInfo = $("<div>", {"class": "networkinfo"});
				var $cloudBlock = $("<div>", {"class": "cloudBlock"});
				var $ajaxBlock = $("<div>",{"class":"ajaxBlock","style":"height:95px"});
				var $chartBlock = $("<div>", {"class": "chartBlock",id:"chartBlock"});
				var $footerDiv = $("<div>", {id: "footerText"});
				//console.info(data);
				
				//this.renderFlowDiagram()
				$('#'+c.body.id).append($mainDiv);
				
				//$mainDiv.append($headerDiv);

				$mainDiv.append($mainBODY);
				$headerDiv.html('<span>'+mappingNameData['RUM_TRANSACTION_DETAILS']+'</span>');
				// back button
				$headerDiv.html('<span style="float:left;font-size:13px">'+mappingNameData['RUM_TRANSACTION_DETAILS']+'</span> <div  id="rumbackbt" class="x-btn backbutton x-box-item x-btn-default-small x-icon-text-left x-btn-icon-text-left x-btn-default-small-icon-text-left" style="float:right;position:relative !important;margin-top: 7px;" data-qclass="yellowTip" data-qtip='+mappingNameData['BACK']+'<em ><button type="button" class="x-btn-center" hidefocus="true" role="button" autocomplete="off" style="height: 16px;"><span  class="x-btn-inner" style="">'+mappingNameData['BACK']+'</span><span class="x-btn-icon iconBack"></span></button></em></div>');

				$mainBODY.append($rumTopologyTitle);
				$rumTopologyTitle.html('<span class="outerBg"><span class="bold">'+mappingNameData['REQUEST_FOR']+'</span><span data-qclass="yellowTip" data-qtip='+url+' >'+trimString(url,10,50)+'</span><span class="bold">'+mappingNameData['AT']+' </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
				
				var encodedUrlParam = encodeURI(urlParam);
				$rumTopologySubTitle.append('<span><span style="font-weight:bold;">'+mappingNameData["URL_PARAMETERS"]+':</span> <span data-qclass="yellowTip stdWidth" data-qtip="'+encodedUrlParam+'" style="word-wrap: break-word;">'+trimUrlStirng(urlParam)+'</span></span>');
				if(urlParam){
					$mainBODY.append($rumTopologySubTitle);
				}
				$mainBODY.append($topologyBlock);
				$topologyBlock.append($userBlock);
				$topologyBlock.append($arrowBlock);
				$topologyBlock.append($browerBlock);
				//$browerBlock.append($browerlayerBlock);
				$topologyBlock.append($requestrespondblock);
				$mainBODY.append($chartBlock);
				
				if(hideResourceTab)
					$mainBODY.append($msgBlock);
				//$topologyBlock.append($requestrespondblockarrow);
				$topologyBlock.append($cloudBlock);
				
				if(ajaxType == "Ajax"){
					$mainBODY.append('<div style="position:absolute;bottom:10px;left:20px;">'+mappingNameData['FOR_AJAX_REQUEST']+'</div>');
					$requestrespondblock.append($ajaxBlock);
					$requestrespondblock.append($contentDownloadInfo);
				}else{
					$requestrespondblock.append($networkInfo);
					$requestrespondblock.append($contentDownloadInfo);
					
				}
				$topologyBlock.append('<div style="clear:both"></div>');
				/*
				* Initialization of each block
				*/
				var initUserdata = $userBlock.loadData(),
					initBrowserdata = $browerBlock.loadData(),
					contentDownloadInfo = $contentDownloadInfo.loadData(),
					networkInfo = $networkInfo.loadData(),
					backendInfo = $cloudBlock.loadData(),
					ajaxBlock = $ajaxBlock.loadData(),
					chartBlock = $chartBlock.loadData(),
					textBlock = $msgBlock.loadData();
				/*
				*	Loading each data
				*/
				initUserdata.userBlock(userData);
				initBrowserdata.browserBlock(browserData);
				contentDownloadInfo.contentDownload(contentData);
				networkInfo.networkInfo(networkData);
				backendInfo.backendInfo(backendData);
				chartBlock.loadChart(pieChartData);
				ajaxBlock.isAjax(ajaxType);
				if(hideResourceTab)
					textBlock.msgBlock(msgForResourceTab);

				//Events

				if(ajaxType != "Ajax" && showStarMsg)
				{
					$footerDiv.html("<div style='bottom: 0.5%;position: absolute;margin-left: 20px;' class='f12-normal'><div style='padding-bottom:3px'>* A very low Network Connection time may be a result of the browser using HTTP Keep-Alive</div><div>** Server time (TTFB) includes both server-side processing and round-trip latency. See time-to-first-byte (TTFB) in documentation for various scenarios</div></div>");
					$mainBODY.append($footerDiv);
				}

				//Error box minimise
				$('#error_minimizeButton').click(function(){
					//alert("minimise function here");
					var _this = $(this);

					//alert($('.rumError_cont').width());
					var rumErroContWidth=$('.rumError_cont').width();

					/*if ($('.rumError_cont'))
						$('.rumError_cont').animate({height:80,width:724});

					if ($('.rum_error'))
						$('.rum_error').animate({height:30,width:734});*/

					

					if (rumErroContWidth>170)
					{
						//alert("minimise");
						
							$('.rumError_cont').animate({height:25,width:175},500,function(){
								$('.rum_error').css({height:12,width:186});
								_this.css({top:9});
								$('.rumError_cont').css({"overflow":"hidden"});
								$('.rumErrorMinimise').show();
								$('.rumError_cont').hide();
								//$(this).find('.error_con').animate({marginTop:$(this).scrollTop()});

								_this.removeClass('rumtogglearrow');
								_this.addClass('rumtogglearrowRotate');
								
								Ext.defer(function(){
									$('.rum_error').css({"z-index":"0"});
								},550);
							//_this.removeClass('rumtogglearrowRotate');
						});
					}
					else
					{
								//alert("maximise");
								$('.rumError_cont').show(function(){
								
										$('.rumError_cont').animate({height:70,width:724},500,function(){
											$('.rum_error').css({height:30,width:736});
											_this.css({top:65});
											$('.rumError_cont').css({"overflow":"auto"});
											$('.rumErrorMinimise').hide();
											
											//$(this).find('.error_con').animate({marginTop:$(this).scrollTop()});

											_this.removeClass('rumtogglearrowRotate');
											_this.addClass('rumtogglearrow');
											
											Ext.defer(function(){
												$('.rum_error').css({"z-index":"0"});
												
											},550);

											if ($bwrlistDiv.is(':hidden')){
											}else{
												$bwrlistDiv.slideToggle();
												$('#browserToggle').removeClass('rumtogglearrowRotate');
											}
										//_this.removeClass('rumtogglearrowRotate');
									});
								});
								
					
					}
						
				})
				
				//Window close
				$('#rumbackbt').click(function(){

					var rr_tab = Ext.getCmp('rr_tab').getActiveTab();
					var ard = Ext.getCmp('additionalResourceDetails');
					if(!Ext.isEmpty(ard) && ard.isVisible() && rr_tab.index == 2)
					{
						ard.destroy();
						Ext.getCmp('resourceDetails').show();
						if(hide_bck_button)
							Ext.getCmp('rumbackbt').setVisible(false);
					}
					else
					{
						var win = window.parent.Ext.getCmp('rumTopologyBuildWindow');
						if(win)win[win.closeAction]();
					}
				});

				$('#toggleButton').click(function(){
					var _this = $(this);
					//_this.css('z-index',999);
					
					//$(_this).css({bottom:$('#toogleList').height - 50+"px"});
					if ($toogleList.is(':hidden')) {
								//$('.toogleGrp').css('z-index',99);
								//$('.rumuserIcon').css('z-index',100);	
								
							}
									var togleHeight = $toogleList.height();
									$toogleList.slideToggle({
									duration: "slow",
									progress: functionToExecute,
									complete: function () {
									
														if ($toogleList.is(':hidden')) {
																//$('.toogleGrp').css('z-index',999);
																_this.removeClass('rumtogglearrowRotate');
																//$(_this).css({bottom:"-25px"});
															}else{
																_this.addClass('rumtogglearrowRotate');
																//$(_this).css({bottom:"-3px"});
																if ($bwrlistDiv.is(':hidden')){
																}else{
																	$bwrlistDiv.slideToggle();
																	$('#browserToggle').removeClass('rumtogglearrowRotate');
																	//$('.toogleGrp').css('z-index',99);
																	
																}
															}
									}
								  });

								function functionToExecute(animation, progress, remainingMs) {
								   
								   if($toogleList.height() <= 50){
										$(_this).css({bottom:"-25px"});
										_this.css('z-index',999);
										$('.rumuserIcon').css('z-index',991);
								   }else{
										$(_this).css({bottom:0});
										_this.css('z-index',99);
										$('.rumuserIcon').css('z-index',999);

								   }
								     
								}

					
				});
				$('#browserToggle').click(function(){
					var _this = $(this);
					
					$bwrlistDiv.slideToggle({
					duration: 400,
					progress:function(animation, progress, remainingMs){
							var elementTop =  $browerBlock[0].offsetTop + $('.browerblock').outerHeight();
							var viewportBottom = (c.getHeight() - ($('.browerblock').outerHeight()-50)) + $('#'+c.id).scrollTop();
							if(elementTop < viewportBottom){
								$('.browerblock').css({"margin-top":"50px"})
							}else{
								$('.browerblock').css({"margin-top":"-20px"})
							}
					},	
					complete:function() {
						if ($bwrlistDiv.is(':hidden')) {
								_this.removeClass('rumtogglearrowRotate');
								//$('.rumError_cont').animate({"width":"724px"});
								//$('.rum_error').animate({"width":"734px"});
								//$("#error_minimizeButton").css({"position":"relative","top":"-50px","float":"right"});
									$('.rumError_cont').animate({height:25,width:175},500,function(){
											//$('.rumError_cont').css({"overflow":"hidden"});
											$('.rum_error').css({"height":"12px","width":"186px"});
											$('.rumErrorMinimise').show();
											$('.rumError_cont').hide();
									});
									

							}else{
								_this.addClass('rumtogglearrowRotate');
								
								$('.rumError_cont').animate({height:25,width:175},500,function(){
									//$('.rumError_cont').css({"overflow":"hidden"});
									$('.rum_error').css({"height":"12px","width":"186px"});
									$('.rumErrorMinimise').show();
									$('.rumError_cont').hide();
									$("#error_minimizeButton").css({"position":"relative","top":"10px","float":"right"});
									$('#error_minimizeButton').removeClass('rumtogglearrow');
									$('#error_minimizeButton').addClass('rumtogglearrowRotate');
								});
								
								//$('.rumError_cont').css({"overflow-y":"hidden !important"});

								

								if($toogleList.is(':hidden')) {
									$('.toogleGrp').css('z-index',999);
								}else{
									$toogleList.slideToggle();
									//$('#toggleButton').css({bottom:"-50px"});
									$('#error_minimizeButton').removeClass('rumtogglearrow');
									$('#error_minimizeButton').addClass('rumtogglearrowRotate');
									$('.rumuserIcon').css('z-index',991);
									$('.toogleGrp').css('z-index',999);
									$('#toggleButton').css({bottom:"-25px"});
									$('#toggleButton').removeClass('rumtogglearrowRotate');
									$('.rumError_cont').css({"overflow":"hidden !important"});
								}						
							}
					}});
				});
				$('#error_toggleButton').click(function(){
					var _this = $(this);

					if($('#error_toggleButton').hasClass("rumtogglearrowRotate")){
						$('.rumError_cont').animate({height:58},500,function(){
								$('.rum_error').animate({top:0});
								$(this).css({"overflow":"hidden"});
								$(this).find('.error_con').animate({marginTop:$(this).scrollTop()});
								
								Ext.defer(function(){
									$('.rum_error').css({"z-index":"0"});
								},550);
							//_this.removeClass('rumtogglearrowRotate');
						});					
					}else{
						$('.rumError_cont').animate({height:177},500,function(){
							$(this).css({"overflow-y":"auto","z-index":"9"});
							$(this).find('.error_con').animate({marginTop:0});
							$(this).animate({scrollTop: 0 });
							
							$('.rum_error').animate({top:0});
							
							$('.rum_error').css({"z-index":"9999"});
							//_this.addClass('rumtogglearrowRotate')
						});					
					}
				})
				$('#shownetworkconnections, .ntText').mouseover(function() {
					$nwtlistDiv.show();
				}).mouseout(function() {
					//$nwtlistDiv.show();
				});
				$('#nwtDiv, .ntText').mouseenter(function() {
					$('#nwtDiv').show();
				}).mouseleave(function() {
					$('#nwtDiv').hide();
				});
				$('body').on('click','#link',function(e){
				
					loadResourceData(resourceData,e.clientX - 300,e.clientY-280);	
					//loadResourceData(resourceData,372,370);
					//loadResourceData(resourceData,650,437);
				});	   
				$('#contentdownload, .cntText').mouseover(function() {
					
					if(ajaxType != "Ajax" && ajaxType != "AjaxPage")  $cntlistDiv.show();
					
				}).mouseout(function() {
					//$nwtlistDiv.show();
				});
				$('#cntDiv, .cntText').mouseenter(function() {
					if(ajaxType != "Ajax" && ajaxType != "AjaxPage") $('#cntDiv').show();
				}).mouseleave(function() {
					$('#cntDiv').hide();
				});

				$(window).resize(function(){
				// console.log($(document).width());
					if($mainBODY){
						//$mainBODY.width($(document).width() - 10);
						//console.log('--',$('.outerBg').width() + 105);
						var titleWidth = $('.outerBg').width();
						var outerWidth = $mainBODY.width();
						var lengthURL = parseInt(url.length)*16;
						var urlLength = parseInt(url.length);
						//console.log(lengthURL);
						var len = 40;
						/*	if(lengthURL > outerWidth){
								len = 35;
							}*/
						if(outerWidth >= 500 && outerWidth <= 1190){
							if (urlLength > 52)
							{
								$rumTopologyTitle.html('<span class="outerBg"><span class="bold">'+mappingNameData['REQUEST_FOR']+' </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+trimString(url,10,len)+'</span><span class="bold"> '+mappingNameData['AT']+' </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
							} else {
								$rumTopologyTitle.html('<span class="outerBg"><span class="bold">'+mappingNameData['REQUEST_FOR']+' </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+url+'</span><span class="bold"> '+mappingNameData['AT']+' </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');
							}
						}else{
							$rumTopologyTitle.html('<span class="outerBg"><span class="bold">'+mappingNameData['REQUEST_FOR']+' </span><span data-qclass="yellowTip" data-qtip='+url+' data-qclass="yellow-tip">'+url+'</span><span class="bold"> '+mappingNameData['AT']+'  </span>'+urlRquestDataTime+'&nbsp;'+ urlZone+'<span>');				
						}
						delete $rumTopologyTitle;
					}
				}).resize();
			})(data);
		}
	}
});

function trimUrlStirng(url)
{
	try{
		if(url && url.length > 75)
			url =  url.substring(0,75)+'...';
	}catch(e){}
	return url;
}

function moveTab(){
	try
	{
		Ext.getCmp('rr_tab').setActiveTab(1);
	}
	catch (e)
	{
		console.log(e)
	}
}