function openDetailsPopUp(data,titl){
	var dataArray = data.split(",");
	
	var configWindow = Ext.create('Ext.window.Window',{
		cls:'alarmsbg lightbox',
		width:350,
		closeAction:'destroy',
		autoDestroy:true,
		frame:true,
		modal:true,
		id:'gridWindow',
		title:'MACHINE DETAILS',
		height:200,
		margin:10,
		layout:'fit',
		items : [{
			xtype:'panel',
			margin:8,
			tpl:new Ext.XTemplate(
				'<div>',
				'<span class="f15-bold">List of machines under '+titl+'</span>',
				'<div style="overflow:scroll;height:85%;" class="f12-normal">',
					'<tpl for=".">',
						'<div style="margin:8px 0px; 0px 0px">{.}</div>',						
					'</tpl>',
				'</div>',
				'</div>'
			),
			listeners:{
				afterrender:function(e)
				{
					e.tpl.overwrite(e.body,dataArray);
				}
			}
		}],		
		flex : 1
	});
	configWindow.show();	
}

function openDetails(mrow,dataLength,id)
{
	for(var u=0;u<dataLength;u++)
	{
		if(u != mrow)
		{
			if(!Ext.isEmpty(Ext.get(id+"mouseDivRow"+u)) && Ext.get(id+"mouseDivRow"+u).isVisible())
			{
				Ext.get(id+"mouseDivRow"+u).setVisibilityMode(Ext.Element.DISPLAY);
				Ext.get(id+"mouseDivRow"+u).hide();	
			}
		}
	}

	if(!Ext.isEmpty(Ext.get(id+"mouseDivRow"+mrow)) && Ext.get(id+"mouseDivRow"+mrow).isVisible())
	{
		Ext.get(id+"mouseDivRow"+mrow).setVisibilityMode(Ext.Element.DISPLAY);
		Ext.get(id+"mouseDivRow"+mrow).hide();		
	}
	else 
	{
		Ext.get(id+"mouseDivRow"+mrow).setVisibilityMode(Ext.Element.DISPLAY);
		Ext.get(id+"mouseDivRow"+mrow).show();
	}
}

Ext.define('MyExpander', {
    extend: 'Ext.ux.RowExpander',
	alias: 'plugin.myexpander',
	init: function (grid) {
        var me = this;
        me.callParent(arguments);
		me.grid = grid;
        //grid.on('viewready', function () {
            //grid.getStore().each(function (rec) {
                //var cell = grid.view.getCell(rec, grid.down('headercontainer').items.getAt(0));
                //var ex = Ext.get(cell).down('.' + Ext.baseCSSPrefix + 'grid-row-expander');
                //if (!me.hasRequiredFields(rec)) {
                    //ex.removeCls(Ext.baseCSSPrefix + 'grid-row-expander');
                //}
            //});
        //});
		grid.on('viewready', me.evalExpander, me);
		grid.on('sortchange', me.evalExpander, me);
		//grid.getStore().on('datachanged', me.evalExpander, me);
    },
	evalExpander: function () {
        var me = this,
		grid = me.grid,
		cell, ex;
        grid.getStore().each(function (rec) {
            cell = grid.getView().getCell(rec, grid.down('headercontainer').items.getAt(0));
			if(!Ext.isEmpty(cell))
			{
				ex = Ext.get(cell).down('.' + Ext.baseCSSPrefix + 'grid-row-expander');
				if (!Ext.isEmpty(ex) && !me.hasRequiredFields(rec)) {
					ex.removeCls(Ext.baseCSSPrefix + 'grid-row-expander');
					ex.addCls(Ext.baseCSSPrefix + 'grid-row-expander1212');
				}
			}
        });
    },
	requiredFields: ['machinesArr'],
	hasRequiredFields: function (rec) {
        var valid = false;
        Ext.each(this.requiredFields, function (field) {
            if (!Ext.isEmpty(rec.get(field))) { valid = true; }
        });
        return valid;
    },
	toggleRow: function (rowIdx, record) {
        var me = this,rec;
        
        rec = Ext.isNumeric(rowIdx) ? me.view.getStore().getAt(rowIdx) : me.view.getRecord(rowIdx);
        if (me.hasRequiredFields(rec)) { me.callParent(arguments) }
    }
});

var normal = 0;
var refresh = 0;
Ext.define('citrixDashboard.view.CommonGrid', {
	extend:'Ext.panel.Panel',
	alias:'widget.commongrid',
	//title: 'Top 5 slow page groups for the site',
	//ui:'eg-grid-skin',
	autoDestroy:true,
	header:false,
	bodyPadding:'0 0 0 0',
	layout:'fit',
	margin:'0 5 5 5',
	enablePagination:false,
	pageSize:10,
	//style:{'border':'1px solid red'},
	alignR:'',
	overriderRenderer:function(value,row,data,i){
			var me = this;
			return function(value){ return value};
			me.callParent();
	},	
	config: {
		data: {},
		storeData:[],
		storefileds:[],
		gridColumns:[]
     },
	
     constructor: function(config) {
		 var me = this;
         me.initConfig(config);
         me.callParent(arguments);
     },
	loadData:function(data){
		 var me = this;
		 me.storefileds = [];
		 me.storeData = [];
		 me.gridColumns = [];
			
		 if(!Ext.isEmpty(data)){
				if(data.title){
					Ext.getCmp(me.id).setTitle(data.title);
				}

				if(data.hasOwnProperty("data"))
					data["DataSet"] = [{"data":data.data}];

				if(me.data.columns){
					var g_t = me.data.title;
					for (var i=0;i< data.columns.length;i++ )
					{
						if(data.dataSet && data.dataSet.items != null)
						{
							data.columns[i].renderer = me.overriderRenderer(data.columns[i],data.dataSet.items[i],data.fields,i);
							data.columns[i].renderer=function(value,metaData,record,rowIndex,colIndex){
								var subjectVariable,testMeas,desc;
								var colDataIndex;
								try
								{
									subjectVariable =  me.data.dataSet.items[rowIndex].subjectVariable;
									testMeas =  me.data.dataSet.items[rowIndex].test+"~!~"+me.data.dataSet.items[rowIndex].measure;
									desc =  me.data.dataSet.items[rowIndex].DESCRIPTION;
									if(desc.indexOf("'") > 0)
										desc = desc.replace("'","$quote$");
									colDataIndex = me.data.columns[colIndex].dataIndex;
								}
								catch (e)
								{
								}
								
								if(!Ext.isEmpty(subjectVariable) && value != '-')
								{
									var st;
									if(colDataIndex == 'HIGH')
										st = colDataIndex;
									if(colDataIndex == 'INTERMEDIATE')
										st = colDataIndex;
									if(colDataIndex == 'LOW')
										st = colDataIndex;

									if(value == 'HIGH')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_HIGH">';
									else if(value == 'INTERMEDIATE')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE"';
									else if(value == 'LOW')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_LOW"';

									if(colIndex != 0 && (me.alignR!= undefined && me.alignR != null && me.alignR))
									{
										var alignProperty = (data.columns[colIndex].hasOwnProperty('align'))?data.columns[colIndex]['align']:'center';
										value = '<div style="text-align:'+alignProperty+'">'+value+'</div>';
									}
									
									var linkAlarm = "javascript:openAlarmPopup('"+g_t+"','"+subjectVariable+"','$"+st+"','"+testMeas+"','"+desc+"')";
									value = '<a href="'+linkAlarm+'">'+value+'</a>';
								}
								else
								{
									if(value == 'HIGH')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_HIGH">';
									else if(value == 'INTERMEDIATE')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE"';
									else if(value == 'LOW')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_LOW"';

									if(colIndex != 0 && (me.alignR!= undefined && me.alignR != null && me.alignR))
									{
										var alignProperty = (data.columns[colIndex].hasOwnProperty('align'))?data.columns[colIndex]['align']:'center';
										value = '<div style="text-align:'+alignProperty+'">'+value+'</div>';
									}

									if(requestParams.activeView == 'Applications_View' && !Ext.isEmpty(data) && !Ext.isEmpty(data.dataSet) && !Ext.isEmpty(data.dataSet.items[rowIndex]) && !Ext.isEmpty(data.dataSet.items[rowIndex].layerURL) && data.dataSet.items[rowIndex].layerURL != undefined && data.dataSet.items[rowIndex].layerURL != null){
										var urlLink = "layerURL";
										if(dashboard == "WVD_Dashboard")
											urlLink = "insideView_url";
										
										value = "<a href='"+data.dataSet.items[rowIndex][urlLink]+"'>"+value+"</a>";
									}
								}

								return value;
							}
							data.columns[i].menuDisabled =  true;
							data.columns[i].draggable=false;
						}
						else
						{
							if((!Ext.isEmpty(this.iSBrro) && this.iSBrro) || (!Ext.isEmpty(this.iSLogon) && this.iSLogon) || requestParams.activeView == 'Sessions_View' || requestParams.activeView == 'sessions'){
								var colTextVal = data.columns[i].text;
								if(data.DataSet && data.DataSet[0].data != undefined && data.DataSet[0].data != null){
									data.columns[i].renderer = me.overriderRenderer(data.columns[i],data.DataSet[0].data,data.fields,i);
									data.columns[i].renderer=function(value,metaData,record,rowIndex,colIndex)
									{
										if(this.columns[colIndex].dataIndex == "Users" || this.columns[colIndex].dataIndex == "User Name"){
											try{
												if(dashboard == "Cloud_Dashboard" || dashboard.indexOf("Cloud_Dashboard") > -1)
													asdfdf;

												if(!Ext.isEmpty(data.DataSet[0].data[rowIndex].showSlowLogonIcon) && data.DataSet[0].data[rowIndex].showSlowLogonIcon)
													value = "<span><img src='../images/clear.png' class='showSlowLogonIcon' style='vertical-align: middle'/>&nbsp;"+value+"</span>";
												else
													value = "<span><img width='16' height='16' src='../images/clear.png' class='' style='vertical-align: middle'/>&nbsp;"+value+"</span>";
													//value = "<span>"+value+"</span>";
											}catch(er){
												value = "<span>"+value+"</span>";			
											}

											try
											{
												if(!Ext.isEmpty(data.DataSet[0].data[rowIndex].linkUrl) && data.DataSet[0].data[rowIndex].linkUrl != undefined && data.DataSet[0].data[rowIndex].linkUrl != null){
													value = "<a href='"+data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
												}												
											}
											catch (v)
											{
											}
										}
										else if(this.columns[colIndex].dataIndex == 'Server' || this.columns[colIndex].dataIndex == 'Component')
										{
											var subVar = "layerLink";
											if(dashboard == "Cloud_Dashboard" || dashboard.indexOf("Cloud_Dashboard") > -1)
												subVar = "linkUrl";
											
											if(data.DataSet[0].data[rowIndex].hasOwnProperty(subVar) && !Ext.isEmpty(data.DataSet[0].data[rowIndex][subVar]))
												value = "<a href='"+data.DataSet[0].data[rowIndex][subVar]+"'>"+value+"</a>";
																						
										}
										else if(this.columns[colIndex].dataIndex == 'Session Hosts')
										{
											var subVar = "insideView_url";											
											if(data.DataSet[0].data[rowIndex].hasOwnProperty(subVar) && !Ext.isEmpty(data.DataSet[0].data[rowIndex][subVar]))
												value = "<a href='"+data.DataSet[0].data[rowIndex][subVar]+"'>"+value+"</a>";
											
										}
										else if(this.columns[colIndex].dataIndex == 'Established Sessions')
										{
											var comp_name = record.get("Server");
											if(dashboard == "Cloud_Dashboard" || dashboard.indexOf("Cloud_Dashboard") > -1)
												comp_name = record.get("Component");

											if(comp_name.indexOf(":") == -1)
												comp_name += ":NULL";
											try
											{
												value = "<a class=ctxMouse onclick=loadView('UED','null','-','-','-','-','-','"+record.get("componentType")+":"+comp_name+"')>"+value+"</a>";
											}
											catch (v)
											{
											}
										}

										if(data.chartType == "GroupGrid")
										{
											var valTemp = "";
																							
											if(data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(data.DataSet[0].data[rowIndex].linkUrl))
												valTemp = "<a href='"+data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";

											if(this.columns[colIndex].dataIndex == 'Server' || this.columns[colIndex].dataIndex == 'Site' || this.columns[colIndex].dataIndex == 'Delivery Group')
											{
												if(data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(data.DataSet[0].data[rowIndex].linkUrl))
													valTemp = "<a data-qtip='"+jQuery(value).text()+"' href='"+data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
												else
													valTemp = "<span style='cursor:default' data-qtip='"+jQuery(value).text()+"'>"+value+"</span>";
											}
											
											
											/*if(data.DataSet[0].data[rowIndex].hasOwnProperty("machines") && !Ext.isEmpty(data.DataSet[0].data[rowIndex].machines) && this.columns[colIndex].dataIndex == 'Delivery Group')
											{
												var machineData = data.DataSet[0].data[rowIndex].machines;
												valTemp = "<a onclick=openDetails('"+rowIndex+"','"+data.DataSet[0].data.length+"','"+me.id+"') style='cursor:hand;text-decoration: underline;color: blue;'>"+value+"</a>";
											}*/
											value = valTemp;
										}
										
										if(data.chartType == "TopNGrid" && value.indexOf("<") == -1)
										{
											if(data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(data.DataSet[0].data[rowIndex].linkUrl))
												value = "<a href='"+data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
										}

										return value;
									}
								}
							}
						}
						if(me.alignR!= undefined && me.alignR != null && me.alignR)
						{
							var colTextVal = data.columns[i].text;
							if(colTextVal != undefined && colTextVal != null)
							{
								if(colTextVal == "alarmCritical")
									data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_HIGH">';
								else if(colTextVal == "alarmMajor")
									data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE">';
								else if(colTextVal == "alarmMinor")
									data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_LOW">';
								//else if(colTextVal != "DESCRIPTION")
									//data.columns[i].text='<span style="text-align:center;">'+colTextVal+'</span>';
							}
						}
					}
					var columnObj = me.data.columns;
					for(var t=0;t<columnObj.length;t++)
					{
						if(columnObj[t].dataIndex == 'USER' || columnObj[t].dataIndex == 'APPLICATION' || columnObj[t].dataIndex == 'SERVER' || columnObj[t].dataIndex == 'PROBLEM')
							columnObj[t]['align'] = 'center';
						
						if(columnObj[t].dataIndex != 'USER' || columnObj[t].dataIndex != 'APPLICATION' || columnObj[t].dataIndex != 'SERVER' || columnObj[t].dataIndex != 'PROBLEM')
						{
							columnObj[t].doSort= function(state) {													
								var ds = this.up('grid').store; 
								var field = this.getSortParam();
								ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									/*v1 = v1.raw['sort'+field];
									v2 = v2.raw['sort'+field];*/
									v1 = v1.get(field);
									v2 = v2.get(field);
									/*v1=v1.substring(v1.indexOf('<span>')+6);
									v2=v2.substring(v2.indexOf('<span>')+6);

									v1=v1.substring(0,v1.indexOf('</span>'));
									v2=v2.substring(0,v2.indexOf('</span>'));*/

										if(isNaN(v1) && isNaN(v2))
										{
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
										else
										{
											v1= isNaN(v1) ? isHyphen(v1) : v1;
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2= isNaN(v2) ? isHyphen(v2) : v2;
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);

											// transform v1 and v2 here
										return (v1 > v2) ? 1 : ((v1 < v2) ? -1 : 0);
										}
									}
								});
							}
						}
					}
					me.gridColumns = columnObj;
				}
				if(data.fields){
					me.storefileds = data.fields;
				}
				
				if((!Ext.isEmpty(this.iSBrro) && this.iSBrro) || (!Ext.isEmpty(this.ifSessions) && this.ifSessions) || (!Ext.isEmpty(this.iSLogon) && this.iSLogon)){
					if(!Ext.isEmpty(data.DataSet) && data.DataSet[0].hasOwnProperty("data") && !Ext.isEmpty(data.DataSet[0].data) && !data.DataSet[0].data.hasOwnProperty("Error"))
						me.storeData = data.DataSet[0].data;					
				}
				else
				{
					if(data.dataSet && data.dataSet.items != undefined && data.dataSet.items != null)
						me.storeData = data.dataSet.items;
				}
			}				
		if(me.id == "serverGrp" || me.id == "desktopGrp")
		{
			me.storefileds.push({"name":"machinesArr"});
		}
		Ext.getCmp(me.id+'_grid').suspendLayouts();
		if(me.enablePagination){
			me.store = new  Ext.create('Ext.data.Store', {
				fields: me.storefileds,
				data:me.storeData,
				autoLoad: false,
				pageSize:me.pageSize,
				proxy: {
					type: 'pagingmemory',
				}
			});
			Ext.getCmp(me.id+'_grid').reconfigure(me.store,me.gridColumns);	
			if(!Ext.isEmpty(Ext.getCmp(me.id+'_gridPagingToolbar')))
			{
				Ext.getCmp(me.id+'_gridPagingToolbar').bindStore(me.store);
			}
		}else{
			Ext.getCmp(me.id+'_grid').reconfigure(Ext.getCmp(me.id+'_grid').getStore(), me.gridColumns);
			Ext.getCmp(me.id+'_grid').getStore().loadData(me.storeData);
		}
		Ext.getCmp(me.id+'_grid').resumeLayouts(true);	
		Ext.getCmp(me.id+'_grid').getView().refresh();
		
		Ext.defer(function(){
			if(!Ext.isEmpty(Ext.getCmp(me.id+'_grid').plugins))
				Ext.getCmp(me.id+'_grid').plugins[0].evalExpander();
		},10);		
	 },
	initComponent:function(){
			var me = this;
			if(!Ext.isEmpty(me.data)){
				//if(me.data.title){
					////me.title = me.data.title;
					//me.title = "";
					////Ext.getCmp("grid_id").setTitle(me.data.title);
					//if(Ext.getCmp("grid_id") != undefined && Ext.getCmp("grid_id") != null)
						//Ext.getCmp("grid_id").setTitle(me.data.title);
				//}
				if(me.data.hasOwnProperty("data"))
					me.data["DataSet"] = [{"data":me.data.data}];
				
				if(me.data.columns){
					var g_t = me.data.title;
					for (var i=0;i< me.data.columns.length;i++ )
					{
						if(me.data.dataSet && me.data.dataSet.items != undefined && me.data.dataSet.items != null){
							me.data.columns[i].renderer = me.overriderRenderer(me.data.columns[i],me.data.dataSet.items[i],me.data.fields,i);
							me.data.columns[i].renderer=function(value,metaData,record,rowIndex,colIndex)
							{
								var subjectVariable,testMeas,desc;
								var colDataIndex;
								try
								{
									subjectVariable =  me.data.dataSet.items[rowIndex].subjectVariable;
									testMeas =  me.data.dataSet.items[rowIndex].test+"~!~"+me.data.dataSet.items[rowIndex].measure;
									desc =  me.data.dataSet.items[rowIndex].DESCRIPTION;
									if(desc.indexOf("'") > 0)
										desc = desc.replace("'","$quote$");
									colDataIndex = me.data.columns[colIndex].dataIndex;
								}
								catch (e)
								{
								}
								
								if(!Ext.isEmpty(subjectVariable) && value != '-')
								{
									var st;
									if(colDataIndex == 'HIGH')
										st = colDataIndex;
									if(colDataIndex == 'INTERMEDIATE')
										st = colDataIndex;
									if(colDataIndex == 'LOW')
										st = colDataIndex;

									if(value == 'HIGH')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_HIGH">';
									else if(value == 'INTERMEDIATE')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE"';
									else if(value == 'LOW')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_LOW"';

									if(colIndex != 0 && (me.alignR!= undefined && me.alignR != null && me.alignR))
									{
										var alignProperty = (me.data.columns[colIndex].hasOwnProperty('align'))?me.data.columns[colIndex]['align']:'center';
										value = '<div style="text-align:'+alignProperty+'">'+value+'</div>';
									}
									var linkAlarm = "javascript:openAlarmPopup('"+g_t+"','"+subjectVariable+"','$"+st+"','"+testMeas+"','"+desc+"')";
									value = '<a href="'+linkAlarm+'">'+value+'</a>';
								}
								else
								{
									if(value == 'HIGH')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_HIGH">';
									else if(value == 'INTERMEDIATE')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE"';
									else if(value == 'LOW')
										value = '<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="style="margin-top: -1px;" class="x-action-col-icon x-action-col-0   state_LOW"';

									if(colIndex != 0 && (me.alignR!= undefined && me.alignR != null && me.alignR))
									{
										var alignProperty = (me.data.columns[colIndex].hasOwnProperty('align'))?me.data.columns[colIndex]['align']:'center';
										value = '<div style="text-align:'+alignProperty+'">'+value+'</div>';
									}

									if(requestParams.activeView == 'Applications_View' && !Ext.isEmpty(me.data) && !Ext.isEmpty(me.data.dataSet) && !Ext.isEmpty(me.data.dataSet.items[rowIndex]) && !Ext.isEmpty(me.data.dataSet.items[rowIndex].layerURL) &&  me.data.dataSet.items[rowIndex].layerURL != undefined && me.data.dataSet.items[rowIndex].layerURL != null){
										var urlLink = "layerURL";
										if(dashboard == "WVD_Dashboard")
											urlLink = "insideViewUrl";
										
										value = "<a href='"+me.data.dataSet.items[rowIndex][urlLink]+"'>"+value+"</a>";
									}
								}

								return value;
							}
							me.data.columns[i].menuDisabled =  true;
							me.data.columns[i].draggable=false;
							//me.data.columns[i].sortable = false;
						}
						else
						{
							
							if((!Ext.isEmpty(this.iSBrro) && this.iSBrro) || (!Ext.isEmpty(this.iSLogon) && this.iSLogon) || requestParams.activeView == 'Sessions_View' || requestParams.activeView == 'sessions' || requestParams.activeView == 'Alerts_View'){
								var colTextVal = me.data.columns[i].text;
								if(me.data.DataSet && me.data.DataSet[0].data != undefined && me.data.DataSet[0].data != null){
									me.data.columns[i].renderer = me.overriderRenderer(me.data.columns[i],me.data.DataSet[0].data,me.data.fields,i);
									me.data.columns[i].renderer=function(value,metaData,record,rowIndex,colIndex)
									{
										if(this.columns[colIndex].dataIndex == "Users" || this.columns[colIndex].dataIndex == "User Name"){
											try{
												if(!Ext.isEmpty(me.data.DataSet[0].data[rowIndex].showSlowLogonIcon) && me.data.DataSet[0].data[rowIndex].showSlowLogonIcon)
													value = "<span><img src='../images/clear.png' class='showSlowLogonIcon' style='vertical-align: middle'/>&nbsp;"+value+"</span>";
												else
													value = "<span><img width='16' height='16' src='../images/clear.png' class='' style='vertical-align: middle'/>&nbsp;"+value+"</span>";
													//value = "<span>"+value+"</span>";
											}catch(er){
												value = "<span>"+value+"</span>";			
											}
												
											try
											{

												if(!Ext.isEmpty(me.data.DataSet[0].data[rowIndex].linkUrl)){
													value = "<a href='"+me.data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
												}												
											}
											catch (v)
											{
											}											
										}
										else if(this.columns[colIndex].dataIndex == 'Server' || this.columns[colIndex].dataIndex == 'Component')
										{
											var subVar = "layerLink";
											if(dashboard == "Cloud_Dashboard" || dashboard.indexOf("Cloud_Dashboard") > -1)
												subVar = "linkUrl";
											
											if(me.data.DataSet[0].data[rowIndex].hasOwnProperty(subVar) && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex][subVar]))
												value = "<a href='"+me.data.DataSet[0].data[rowIndex][subVar]+"'>"+value+"</a>";
											
										}
										else if(this.columns[colIndex].dataIndex == 'Session Hosts')
										{
											var subVar = "insideView_url";											
											if(me.data.DataSet[0].data[rowIndex].hasOwnProperty(subVar) && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex][subVar]))
												value = "<a href='"+me.data.DataSet[0].data[rowIndex][subVar]+"'>"+value+"</a>";
											
										}
										else if(this.columns[colIndex].dataIndex == 'Established Sessions')
										{
											var comp_name = record.get("Server");
											if(dashboard == "Cloud_Dashboard" || dashboard.indexOf("Cloud_Dashboard") > -1)
												comp_name = record.get("Component");
											else if(dashboard == "WVD_Dashboard")
												comp_name = record.get("Host Pool");
											
											if(comp_name.indexOf(":") == -1)
												comp_name += ":NULL";
											try
											{
												value = "<a class=ctxMouse onclick=loadView('UED','null','-','-','-','-','-','"+record.get("componentType")+":"+comp_name+"')>"+value+"</a>";
											}
											catch (v)
											{
											}

										}
																				
										if(me.data.chartType == "GroupGrid")
										{
											var valTemp = "";
																							
											if(me.data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex].linkUrl))
												valTemp = "<a href='"+me.data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
											
											if(this.columns[colIndex].dataIndex == 'Server' || this.columns[colIndex].dataIndex == 'Site' || this.columns[colIndex].dataIndex == 'Delivery Group')
											{
												if(me.data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex].linkUrl))
													valTemp = "<a data-qtip='"+jQuery(value).text()+"' href='"+me.data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
												else
													valTemp = "<span style='cursor:default' data-qtip='"+jQuery(value).text()+"'>"+value+"</span>";
											}

											/*if(me.data.DataSet[0].data[rowIndex].hasOwnProperty("machines") && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex].machines) && this.columns[colIndex].dataIndex == 'Delivery Group')
											{
												var machineData = me.data.DataSet[0].data[rowIndex].machines;
												valTemp = "<a onclick=openDetails('"+rowIndex+"','"+me.data.DataSet[0].data.length+"','"+me.id+"') style=''>"+value+"</a>";
											}*/
											value = valTemp;
										}

										if(me.data.chartType == "TopNGrid" && value.indexOf("<") == -1)
										{
											if(me.data.DataSet[0].data[rowIndex].hasOwnProperty("linkUrl") && !Ext.isEmpty(me.data.DataSet[0].data[rowIndex].linkUrl))
												value = "<a href='"+me.data.DataSet[0].data[rowIndex].linkUrl+"'>"+value+"</a>";
										}
										return value;
									}
								}
							}
						}
						if(me.alignR!= undefined && me.alignR != null && me.alignR)
						{
							var colTextVal = me.data.columns[i].text;
							if(colTextVal != undefined && colTextVal != null)
							{
								if(colTextVal == "alarmCritical")
									me.data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="height:17px !important;position:relative" class="x-action-col-icon x-action-col-0   state_HIGH">';

								else if(colTextVal == "alarmMajor")
									me.data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="height:17px !important;position:relative" class="x-action-col-icon x-action-col-0   state_INTERMEDIATE">';
								
								else if(colTextVal == "alarmMinor")
									me.data.columns[i].text='<img alt="" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="height:17px !important;position:relative" class="x-action-col-icon x-action-col-0   state_LOW">';
								//else if(colTextVal != "DESCRIPTION")
									//me.data.columns[i].text='<span style="text-align:center;">'+colTextVal+'</span>';
							}
						}
					}
					var columnObj = me.data.columns;
					for(var t=0;t<columnObj.length;t++)
					{
						if(columnObj[t].dataIndex == 'USER' || columnObj[t].dataIndex == 'APPLICATION' || columnObj[t].dataIndex == 'SERVER' || columnObj[t].dataIndex == 'PROBLEM')
							columnObj[t]['align'] = 'center';
						
						if(columnObj[t].dataIndex != 'USER' || columnObj[t].dataIndex != 'APPLICATION' || columnObj[t].dataIndex != 'SERVER' || columnObj[t].dataIndex != 'PROBLEM')
						{
							columnObj[t].doSort= function(state) {													
								var ds = this.up('grid').store; 
								var field = this.getSortParam();
								ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									/*v1 = v1.raw['sort'+field];
									v2 = v2.raw['sort'+field];*/
									v1 = v1.get(field);
									v2 = v2.get(field);
									/*v1=v1.substring(v1.indexOf('<span>')+6);
									v2=v2.substring(v2.indexOf('<span>')+6);

									v1=v1.substring(0,v1.indexOf('</span>'));
									v2=v2.substring(0,v2.indexOf('</span>'));*/

										if(isNaN(v1) && isNaN(v2))
										{
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
										else
										{
											v1= isNaN(v1) ? isHyphen(v1) : v1;
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2= isNaN(v2) ? isHyphen(v2) : v2;
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);

											// transform v1 and v2 here
										return (v1 > v2) ? 1 : ((v1 < v2) ? -1 : 0);
										}
									}
								});
							}
						}
					}
					me.gridColumns = columnObj;
				}

				if(me.data.fields){
					me.storefileds = me.data.fields;
				}				

				if((!Ext.isEmpty(this.iSBrro) && this.iSBrro) || (!Ext.isEmpty(this.ifSessions) && this.ifSessions) || (!Ext.isEmpty(this.iSLogon) && this.iSLogon)){
					if(!Ext.isEmpty(me.data.DataSet) && me.data.DataSet[0].hasOwnProperty("data") && !Ext.isEmpty(me.data.DataSet[0].data) && !me.data.DataSet[0].data.hasOwnProperty("Error"))
						me.storeData = me.data.DataSet[0].data;
				}
				else
				{
					if(me.data.dataSet && me.data.dataSet.items != undefined && me.data.dataSet.items != null)
						me.storeData = me.data.dataSet.items;
				}
				
			}
			me.items = me.loadGrid();
			me.callParent();
	},
	loadGrid:function(){
		var me = this;
		var featuresArr = [];
		var pluginArr = [];
		if(me.id == "serverGrp" || me.id == "desktopGrp")
		{
			//var divWidth = Ext.getBody().getWidth() - 185;
			me.storefileds.push({"name":"machinesArr"});
			pluginArr = [{
				ptype: 'myexpander',
				rowBodyTpl:[
					//'<div class="f15-bold" style="position: relative;margin: 10px;border: 1px solid #c0c0c0;padding: 10px;width:'+divWidth+';">Machine Details:',
					'<div class="f15-bold" style="position: relative;margin: 10px;border: 1px solid #c0c0c0;padding: 10px;">Machine Details:',
						'<div style="display:grid;overflow: auto;padding-right: 10px;max-height: 100px;grid-template-columns:auto auto auto auto auto auto;margin: 10px 0px;justify-content: space-between;">',
							'<tpl for="machinesArr">',	
								'<tpl if="link">',
									'<a class="f12-normal" style="margin:5px 0px;white-space:nowrap" href={link}><span class="state_{state}" style="float: left;display: block;margin-top: -2px;margin-right: 6px;"></span>{name}</a>',	
								'<tpl else>',
									'<a class="f12-normal" style="cursor:context-menu;margin:5px 0px;white-space:nowrap;"><span class="state_{state}" style="float: left;display: block;margin-top: -2px;margin-right: 6px;"></span>{name}</a>',
								'</tpl>',
							'</tpl>',
						'</div>',
					'</div>'					
				]
			}];

			/*featuresArr = [{
				ftype: 'rowbody',
				disabled:false,
				id:'configFilter',
				getAdditionalData: function (data, rowIndex, record, orig) {
					var headerCt = this.view.headerCt,
					colspan = headerCt.getColumnCount();
					var tableData = "";
					if(!Ext.isEmpty(record.raw.machinesArr))
					{
						var machinesArrData = record.raw.machinesArr;
						for(var u=0;u<machinesArrData.length;u++)
						{
							if(machinesArrData[u].hasOwnProperty("link") && !Ext.isEmpty(machinesArrData[u].link))
								tableData += "<a class='f12-normal' style='margin:5px 0px;white-space:nowrap' href="+machinesArrData[u].link+">"+machinesArrData[u].name+"</a>";
							else
								tableData += "<a class='f12-normal' style='cursor:context-menu;margin:5px 0px;white-space:nowrap'>"+machinesArrData[u].name+"</a>"
						}
					}
					return {
						rowBody: '<div class="f15-bold" id="'+me.id+'mouseDivRow'+rowIndex+'" style="position: relative;display: none;margin: 10px;border: 1px solid #c0c0c0;padding: 10px;">Machine Details:<div style="display:grid;grid-template-columns:auto auto auto auto auto auto;margin: 10px 0px;justify-content: space-between;">'+tableData+'</div></div>',
						rowBodyCls: "my-body-class"+rowIndex,
						rowBodyColspan: colspan
					};
				}
			}];*/
		}
		var hiddenob = true;
		var ovObj = 'auto';
		if(this.iSBrro)
		{
			if(!Ext.isEmpty(me.data.timeline))
				hiddenob = false;
			
			//if (me.gridColumns.length > 5)
				//ovObj = 'auto';
			//else
				ovObj = 'scroll';
		}
		var emptytext = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data Found!</div></div></div>';
		if(me.iSAlerts != undefined && me.iSAlerts != null && me.iSAlerts)
			emptytext = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No Alerts Found!</div></div></div>';
		
		if(me.data.hasOwnProperty("DataSet") && me.data.DataSet[0].hasOwnProperty("data") && !Ext.isEmpty(me.data.DataSet[0].data) && me.data.DataSet[0].data[0].hasOwnProperty("Error"))
			emptytext = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+me.data.DataSet[0].data[0].Error+'</div></div></div>';
		

		if(me.data.hasOwnProperty("errorMsg") && !Ext.isEmpty(me.data.errorMsg))
			emptytext = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>'+me.data.errorMsg+'</div></div></div>';
		var store = new  Ext.create('Ext.data.Store', {
			fields: me.storefileds,
			data:me.storeData
		});
		if(me.enablePagination){
			store = new  Ext.create('Ext.data.Store', {
				fields: me.storefileds,
				data:me.storeData,
				autoLoad: false,
				pageSize:me.pageSize,
				proxy: {
					type: 'pagingmemory',
				}
			});
		}
		var grid = Ext.create('Ext.grid.Panel', {
			flex:1,
			ui:'newGridPanel usePlusMinus',
			//ui:'newGridPanel usePlusMinus height30',
			border:true,
			frame:false,
			id:me.id+'_grid',
			height:(me.id == "serverGrp" || me.id == "desktopGrp")?'100%':170,
			header:false,
			scroll:true,
			autoScroll:true,
			overflowX: ovObj,
			dockedItems: [{
				xtype: 'pagingtoolbar',
				store: store,   // same store GridPanel is using
				dock: 'bottom',
				id:me.id+'_gridPagingToolbar',
				cls:"pagingtoolbar border",
				displayInfo: true,
				hidden:!me.enablePagination,
				getPagingItems: function() {
					var me = this;
					return [{
						itemId: 'first',
						tooltip: me.firstText,
						overflowText: me.firstText,
						iconCls: Ext.baseCSSPrefix + 'tbar-page-first',
						disabled: true,
						handler: me.moveFirst,
						scope: me
					},{
						itemId: 'prev',
						tooltip: me.prevText,
						overflowText: me.prevText,
						iconCls: Ext.baseCSSPrefix + 'tbar-page-prev',
						disabled: true,
						handler: me.movePrevious,
						scope: me
					},
					'-',
					me.beforePageText,
					{
						xtype: 'numberfield',
						itemId: 'inputItem',
						name: 'inputItem',
						cls: Ext.baseCSSPrefix + 'tbar-page-number',
						allowDecimals: false,
						minValue: 1,
						hideTrigger: true,
						enableKeyEvents: true,
						keyNavEnabled: false,
						selectOnFocus: true,
						submitValue: false,
						// mark it as not a field so the form will not catch it when getting fields
						isFormField: false,
						width: me.inputItemWidth,
						margins: '-1 2 3 2',
						listeners: {
							scope: me,
							keydown: me.onPagingKeyDown,
							blur: me.onPagingBlur
						}
					},{
						xtype: 'tbtext',
						itemId: 'afterTextItem',
						text: Ext.String.format(me.afterPageText, 1)
					},
					'-',
					{
						itemId: 'next',
						tooltip: me.nextText,
						overflowText: me.nextText,
						iconCls: Ext.baseCSSPrefix + 'tbar-page-next',
						disabled: true,
						handler: me.moveNext,
						scope: me
					},{
						itemId: 'last',
						tooltip: me.lastText,
						overflowText: me.lastText,
						iconCls: Ext.baseCSSPrefix + 'tbar-page-last',
						disabled: true,
						handler: me.moveLast,
						scope: me
					}/*,
					'-',
					{
						itemId: 'refresh',
						tooltip: me.refreshText,
						overflowText: me.refreshText,
						iconCls: Ext.baseCSSPrefix + 'tbar-loading',
						handler: me.doRefresh,
						scope: me
					}*/];
				},
				onLoad : function(){
					var me = this,
						pageData,
						currPage,
						pageCount,
						afterText,
						count,
						isEmpty;
					count = me.store.getCount();
					isEmpty = count === 0;
					if (!isEmpty) {
						pageData = me.getPageData();
						currPage = pageData.currentPage;
						pageCount = pageData.pageCount;
						afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
					} else {
						currPage = 0;
						pageCount = 0;
						afterText = Ext.String.format(me.afterPageText, 0);
					}
					Ext.suspendLayouts();
					me.child('#afterTextItem').setText(afterText);
					me.child('#inputItem').setDisabled(isEmpty).setValue(currPage);
					me.child('#first').setDisabled(currPage === 1 || isEmpty);
					me.child('#prev').setDisabled(currPage === 1  || isEmpty);
					me.child('#next').setDisabled(currPage === pageCount  || isEmpty);
					me.child('#last').setDisabled(currPage === pageCount  || isEmpty);
					//me.child('#refresh').enable();
					me.updateInfo();
					Ext.resumeLayouts(true);
					if (me.rendered) {
						me.fireEvent('change', me, pageData);
					}
				} 
			},{
				xtype:'label',
				hidden:hiddenob,
				html:'<span class="font_normal11 fontStyleRobotRegular" style="float:right">Last '+me.data.timeline+'</span>',
				height:'15px'
			}],	
			features:featuresArr,
			plugins: pluginArr,
			columnLines : true,
			//ui:'newGridPanel',
			store: store,
			viewConfig: {
				emptyText: emptytext,
				deferEmptyText: false,
			},
			columns: me.gridColumns
		});	
		
		try
		{
			grid.getView().on('collapsebody',function(rowNode, record, expandRow, eopts){
				var rowExpander = grid.plugins[0];
				var nodes = rowExpander.view.getNodes();
				var length = nodes.length;
				var allCollapsed = false;
				for (var i = 0; i < length; i++) {
					var node = Ext.fly(nodes[i]);
					if (node.hasCls(rowExpander.rowCollapsedCls) === true)
						allCollapsed = true;
					else
					{
						allCollapsed = false;
						break;
					}

				}
				if(allCollapsed)
					citrixDashboard.app.getController("Main").addUpdateDeliverGrPView(me.fullDdata,true);
				
			});

			grid.getView().on('expandbody',function(rowNode, record, expandRow, eopts){
				//window.clearInterval(timerId);
				var rowExpander = grid.plugins[0];
				var nodes = rowExpander.view.getNodes();
				var length = nodes.length;
				for (var i = 0; i < length; i++) {
					
					if(rowNode == nodes[i])
						continue;
					
					var node = Ext.fly(nodes[i]);
					if (node.hasCls(rowExpander.rowCollapsedCls) === false) {
						rowExpander.toggleRow(i, grid.store.getAt(i));
					}
				}
			});
			
		}
		catch (er)
		{
		}		

		return grid;
	}
   
});
