Ext.define('insideViewDashboard.view.TestInfo',{
	alias:'widget.testinfo',
	extend:'Ext.window.Window',
	height:520,
	width:895,
	bodyBorder:false,
	bodyPadding:10,
	padding:'4 10 10 10',
	frame:true,
	title:'Test Details',
	autoScroll:true,
	modal: true,
	ghost:false,
	frame:true,
	closable:true,
	draggable:true,
	closeAction:'hide',
	layout:'anchor',
	//title:testStatusInfoTitle,
	//currentImgCls:null,
	shadow:'sides',
	shadowOffset:40,
	//style:{'border':'1px solid orange'},
	items:[{
		xtype:'fieldcontainer',
		itemId:'top',
		width:'100%',
		defaults:{
			labelSeparator:'',
			cls:'font_12',
			margin:'0 0 3 0',
			columnWidth:0.5
		},
		layout : {
			type : 'column',
			pack  : 'center',
		},
			items:[{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'measurementshost',
			id: 'measurementshost',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			id: 'componenttype',
			name: 'componenttype',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'component',
			id: 'component',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testname',
			id: 'testname',
		
		},{
			xtype: 'fieldcontainer',
			layout: 'column',
			labelSeparator: ' ',
			labelAlign:'left',
			labelWidth:200,
			name: 'testnameConfig',
			id: 'testnameConfig',
			//hidden: true,
			items: [
				{
					xtype: 'displayfield',
					name: 'testname1',
					id: 'testname1',
					testName:'',
					compType:'',
					compName:'',
					testStateName:'',
					layerName:''
				},
				{
					xtype: 'button',
					margin:'0 0 0 10',
					iconCls:'iconModify',
					itemId:'iconTestConfig',
					style: {
						background: 'none',
						border: '0px'
					},
					listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Configure test'
							});
						}
					}
				}
			]
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'description',
			id: 'description',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testtype',
			id: 'testtype',

		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testfrequency',
			id: 'testfrequency',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'urlaccess',
			id: 'urlaccess',
			fullValue:null,
			tip:null,
			 listeners: {
					afterrender: function () {
						var dislayString = this.value;
						this.tip= Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: this.fullValue
						});
					}
				}
 		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'time',
			id: 'time',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'teststate',
			id: 'teststate',
		
		},
		{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'threshgroupname',
			id: 'threshgroupname',
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'threshrulename',
			id: 'threshrulename',
		},
		{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'patternname',
			id: 'patternname',
		}]
	},
	{
		xtype: 'fieldcontainer',
		itemId:'center',
		layout: {
			type: 'hbox',
			pack: 'start'
		},
		defaults:{
			labelSeparator:'',
			cls:'font_12',
		},

		margin: '10 0 5 0',
		flex: 1,
		items: [
			{
				xtype: 'displayfield',
				id: 'threshMsgLbl',
				name: 'threshMsgLbl',
				labelAlign:'left',
				labelWidth:500
			}
		]
	},
	{
		xtype:'container',
		width:'100%',
		itemId:'tableContainer',
	},{
		xtype:'fieldset',
		itemId:'bottom',
		title:'Quick Maintenance Details',
		width:'100%',
		layout : {
			type : 'vbox',
			pack  : 'center',
		},
		items:[/*{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'quick',
			id: 'quick',
		
		},*/{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:100,
			name: 'policyname',
			id: 'policyname',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:100,
			name: 'policytime',
			id: 'policytime',
		
		}]
	}],
	
	initComponent:function(){
		this.callParent();
	},
	listeners: {
                    show: function (f) {

                        if (this.modal) {
                            var g = Ext.dom.Query.select(".x-mask");
                            var e = Ext.fly(g[0]);
                            e.addCls("windowModal");
                        }
                    },
                    hide: function (f) {
                        if (this.modal) {
                            var g = Ext.dom.Query.select(".x-mask");
                            var e = Ext.fly(g[0]);
                            e.removeCls("windowModal");
                        }
                    },
                    afterrender: function () {
                        Ext.EventManager.onWindowResize(function () {
                            var e = this;
                            e.center();
                        }, this);
                    }
                },
	setTestDetailsData:function(json){
		var fieldContainer = this.child('fieldcontainer#top');
		var containerLabel = this.child('fieldcontainer#center');
		var bottomFieldContainer = this.child('fieldset#bottom');
		fieldContainer.getComponent('measurementshost').setFieldLabel(json.screenLabels.MeasurementHost);
		fieldContainer.getComponent('measurementshost').setValue("<div class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:200px;cursor:pointer;cursor:hand;'>"+json.measureHost.MeasurementHostValue+"</div>");
		fieldContainer.getComponent('measurementshost').show();

		fieldContainer.getComponent('componenttype').setFieldLabel(json.screenLabels.ComponentTypeDisplay);
		fieldContainer.getComponent('componenttype').setValue('<div class="font_bold11">'+json.displayValue.ComponentTypeValue+'</div>');

		if(!Ext.isEmpty(json.ipAddress)){
			var value = json.displayComponentValue.Component;
			var data = json.ipAddress.ipAddr;
			if(value.indexOf(data) > -1)
			{
				
				fieldContainer.getComponent('component').setFieldLabel(json.screenLabels.ComponentValue);
				fieldContainer.getComponent('component').setValue("<div data-qclass=yellowTip data-qtip='"+json.displayComponentValue.Component+"' style='overflow:hidden;text-overflow:ellipsis;width:200px;white-space: nowrap;cursor:pointer;cursor:hand;'>"+json.displayComponentValue.Component+"</div>");
			}
			else
			{
				
				fieldContainer.getComponent('component').setFieldLabel(json.screenLabels.ComponentValue);

				if(!Ext.isEmpty(json.ipAddress.ipAddr) && json.ipAddress.ipAddr!=undefined && json.ipAddress.ipAddr!='undefined')
				{
					fieldContainer.getComponent('component').setValue("<div data-qclass=yellowTip data-qtip='"+json.displayComponentValue.Component + "("+json.ipAddress.ipAddr +")' class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:200px;cursor:pointer;cursor:hand;' >"+json.displayComponentValue.Component + "("+json.ipAddress.ipAddr +") </div>");
				}
				else
				{
					fieldContainer.getComponent('component').setValue("<div data-qclass=yellowTip data-qtip='"+json.displayComponentValue.Component+"' class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:200px;cursor:pointer;cursor:hand;'>"+json.displayComponentValue.Component+"</div>");
				}
			}
		}
		else {
		fieldContainer.getComponent('component').setFieldLabel(json.screenLabels.ComponentValue);
		fieldContainer.getComponent('component').setValue("<div data-qclass=yellowTip data-qtip='"+json.displayComponentValue.Component+"' class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:200px;cursor:pointer;cursor:hand;'>"+json.displayComponentValue.Component+"</div>");
		}

		if (json.isAdminTestConfigLinkEnabled)
		{
			fieldContainer.getComponent('testname').hide();
			fieldContainer.getComponent('testnameConfig').show();

			fieldContainer.getComponent('testnameConfig').setFieldLabel(json.screenLabels.Testname);
			if(json.testNameValue.TestNameData != null && json.testNameValue.TestNameData != undefined && json.testNameValue.TestNameData !='' && json.testNameValue.TestNameData.length>0)
			{
				if(json.testNameValue.TestNameData.length>25)
				{
					fieldContainer.getComponent('testnameConfig').getComponent('testname1').setValue("<div data-qclass=yellowTip data-qtip='"+json.testNameValue.TestNameData+"' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:170px;cursor:pointer;cursor:hand;'>"+json.testNameValue.TestNameData+"</div>");
				}
				else
				{
					var widthOfTestName = json.testNameValue.TestNameData.length * 8;
					fieldContainer.getComponent('testnameConfig').getComponent('testname1').setValue("<div data-qclass=yellowTip data-qtip='"+json.testNameValue.TestNameData+"' class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:'"+widthOfTestName+"'px;cursor:pointer;cursor:hand;'>"+json.testNameValue.TestNameData+"</div>");
				}
			}
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').compName = json.componentName;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').compType = json.componentType;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').testName = json.strTestName;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').testStateName = json.testState;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').layerName = json.layerName;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').monDescName = json.monDescName;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').monTestState = json.monTestState;
			fieldContainer.getComponent('testnameConfig').getComponent('testname1').monSource = 'insideview';
		}
		else
		{
			fieldContainer.getComponent('testname').show();
			fieldContainer.getComponent('testnameConfig').hide();

			fieldContainer.getComponent('testname').setFieldLabel(json.screenLabels.Testname);
			fieldContainer.getComponent('testname').setValue("<div class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:170px;cursor:pointer;cursor:hand;'>"+json.testNameValue.TestNameData+"</div>");
		}

		//fieldContainer.getComponent('testname').setFieldLabel(json.screenLabels.Testname);
		//fieldContainer.getComponent('testname').setValue(json.testNameValue.TestNameData);
		
		if(!Ext.isEmpty(json.getReverse)){
			fieldContainer.getComponent('description').setFieldLabel(json.screenLabels.Description);
			fieldContainer.getComponent('description').setValue("<div data-qclass=yellowTip data-qtip='"+json.getReverse.getReverseValue+"' class='font_bold11' style='overflow:hidden;text-overflow:ellipsis;white-space: nowrap;width:200px;cursor:pointer;cursor:hand;'>"+json.getReverse.getReverseValue+"</div>");
		}
	
		fieldContainer.getComponent('testtype').setFieldLabel(json.screenLabels.TestTypeDisplay);
		fieldContainer.getComponent('testtype').setValue('<div class="font_bold11">'+json.testTypeValue.TestType+'</div>');

		fieldContainer.getComponent('testfrequency').setFieldLabel(json.screenLabels.TestFrequency);
		fieldContainer.getComponent('testfrequency').setValue('<div class="font_bold11">'+json.testFrequencyValue.frequencyOfTest+'</div>');

		if(!Ext.isEmpty(json.urlAccess))
		{
			var urlaccessid= Ext.getCmp("urlaccess").show();
			fieldContainer.getComponent('urlaccess').setFieldLabel(json.screenLabels.UrlAccessed);
			var dislayString = json.urlAccess.urlLastAccessed;
			if (dislayString.length>25)
			{
				dislayString=dislayString.substring(0,30);
				dislayString = dislayString + "...";
				fieldContainer.getComponent('urlaccess').setValue(dislayString);
				fieldContainer.getComponent('urlaccess').fullValue=json.urlAccess.urlLastAccessed;
			}
			else
			{
				fieldContainer.getComponent('urlaccess').setValue(json.urlAccess.urlLastAccessed);
			}
 		}
		else
		{
			var urlaccessid= Ext.getCmp("urlaccess").hide();
			fieldContainer.getComponent('urlaccess').setFieldLabel("");
			fieldContainer.getComponent('urlaccess').setValue("");
		}

		fieldContainer.getComponent('time').setFieldLabel(json.screenLabels.TimeSincelast);
		fieldContainer.getComponent('time').setValue('<div class="font_bold11">'+json.timeSince.timeSinceLastMeasure+'</div>');

		fieldContainer.getComponent('teststate').setFieldLabel(json.screenLabels.Teststate);
		fieldContainer.getComponent('teststate').setValue('<div class="font_bold11">'+json.testStateValue.TestStateData+'</div>');
		
		var threshType = json.threshValue.ThreshInfo;
		if (!Ext.isEmpty(threshType) && threshType.toLowerCase() == 'group')
		{
			fieldContainer.getComponent('threshgroupname').show();
			fieldContainer.getComponent('threshgroupname').setFieldLabel(json.screenLabels.threshGroupname);
			fieldContainer.getComponent('threshgroupname').setValue('<div class="font_bold11">'+json.threshValue.threshGroupname+'</div>');

			fieldContainer.getComponent('threshrulename').show();
			fieldContainer.getComponent('threshrulename').setFieldLabel(json.screenLabels.threshRulename);
			fieldContainer.getComponent('threshrulename').setValue('<div class="font_bold11">'+json.threshValue.threshRulename+'</div>');
		}
		else
		{
			fieldContainer.getComponent('threshgroupname').hide();
			fieldContainer.getComponent('threshrulename').hide();
		}

		if (!Ext.isEmpty(json.threshValue.patternname))
		{
			fieldContainer.getComponent('patternname').show();
			fieldContainer.getComponent('patternname').setFieldLabel(json.screenLabels.patternname);
			fieldContainer.getComponent('patternname').setValue('<div class="font_bold11">'+json.threshValue.patternname+'</div>');
		}
		else
		{
			fieldContainer.getComponent('patternname').hide();
		}
			
		containerLabel.getComponent('threshMsgLbl').setFieldLabel(json.screenLabels.Threshold);
		bottomFieldContainer.hide();
		
		if(!Ext.isEmpty(json.policyNames1Object) && !Ext.isEmpty(json.policyNames1Obj)){
			//bottomFieldContainer.getComponent('quick').setFieldLabel(json.screenLabels.QuickMaintenanceDetails);
			
			bottomFieldContainer.getComponent('policyname').setFieldLabel(json.screenLabels.policyName);
			bottomFieldContainer.getComponent('policyname').setValue('<div class="font_bold11">'+json.policyNames1Object.policyNames1+'</div>');
			bottomFieldContainer.getComponent('policytime').setFieldLabel(json.screenLabels.PolicyTime);
			bottomFieldContainer.getComponent('policytime').setValue('<div class="font_bold11">'+json.policyNames1Obj.PolicyTime+'</div>');
			bottomFieldContainer.show();
		}

		this.doLayout();
		this.show();
	}
});