Ext.define('MyDashBoard.controller.ExternalIntegrationController',
{
	extend : 'Ext.app.Controller',
	requires : ['MyDashBoard.view.RESTWidgetConfigPopup','MyDashBoard.view.RESTWidgetSettings','MyDashBoard.view.DSNSettings','utilities.TreeScrollPanel','MyDashBoard.view.RESTFileUploadForm','MyDashBoard.view.RestFileUploadFormExcel','MyDashBoard.view.AddExternalMetrics','MyDashBoard.view.RESTDataGrid','MyDashBoard.view.WidgetOptionsWindow'],
	refs :[
		{
		ref : 'RESTHeaderGrid',
		selector : 'RESTHeaderGrid'
	},{
		ref : 'RESTParamsGrid',
		selector : 'RESTParamsGrid'
	},{
		ref : 'RESTFileUploadGrid',
		selector : 'RESTFileUploadGrid'
	},{
		ref : 'RestFileUploadFormExcel',
		selector : 'RestFileUploadFormExcel'
	},{
		ref : 'RESTFileUploadForm',
		selector : 'RESTFileUploadForm'
	},
	  {
		ref : 'RESTBodyUrlEncodedGrid',
		selector : 'RESTBodyUrlEncodedGrid'
	},
	  {
		ref : 'restwidgetsettings',
		selector : 'restwidgetsettings'
	},
	{
		ref:'restwidgetconfpopup',
		selector:'restwidgetconfpopup'
	},
	{
		ref:'dsnSettingspopup',
		selector:'dsnSettingspopup'
	},
	{
		ref:'addexternalmetrics',
		selector:'addexternalmetrics'
	},
	{
		ref : 'widgetOptionsWindow',
		selector : 'widgetOptionsWindow'
	}
	],
	init : function() {
		
		this.control({
			'dsnSettingspopup combo[id="restHttpMethod"]' :
			{
				'select' : this.restHttpMethodChange
			},
			'dsnSettingspopup checkbox[id="User_Authentication_Required"]' : {
				'change' : this.enableUserAuthenticationSettings
			},
			'dsnSettingspopup checkbox[id="Header_Required"]' : {
				'change' : this.enableHeaderRequiredSettings
			},
			'dsnSettingspopup checkbox[id="params_Required"]' : {
				'change' : this.enableParamsRequiredSettings
			},
			'dsnSettingspopup button[id="addHeader"]' :
			{
					'click' : this.addHeader
			},
			'dsnSettingspopup button[id="addParam"]' :
			{
					'click' : this.addParam
			},
			'dsnSettingspopup radiogroup[id="body_type"]' : {
				'change' : this.body_typeSettings
			},
			'dsnSettingspopup button[id="restPreviewBtn"]' : {
				'click' : this.restPreviewBtn
			},
			'dsnSettingspopup button[id="sqlPreviewBtn"]' : {
				'click' : this.sqlPreviewBtn
			},
			'dsnSettingspopup button[id="addBody_urlencoded"]' :
			{
					'click' : this.addBody_urlencoded
			},
			'dsnSettingspopup button[id="getData"]' :
			{
					'click' : this.getData
			},
			'dsnSettingspopup button[id="saveFldsBtn"]' :
			{
					'click' : this.saveRESTDSN
			},
			'restwidgetsettings button[id="addRestWidget"]' :
			{
				'click' : this.saveRestWidgetConfig
			},
			'dsnSettingspopup combo[id="integration"]' :
			{
				'select' : this.integrationChange
			},
			'dsnSettingspopup fileuploadfield[id="fileUpload"]' :
			{
				'change' : this.csvDSFileUpload
			},
			'dsnSettingspopup fileuploadfield[id="fileUploadExcel"]' :
			{
				'change' : this.csvDSFileUpload
			},
			'dsnSettingspopup numberfield[id="headerRowCsv"]' :
			{
				'change' : this.csvDSFileUpdate
			},
			'dsnSettingspopup numberfield[id="headerRowExcel"]' :
			{
				'change' : this.csvDSFileUpdate
			},
			'dsnSettingspopup button[id="saveCsv"]' :
			{
				'click' : this.saveCsvDsnSettings
			},
			'dsnSettingspopup button[id="addNewDS"]' :
			{
				'click' : this.addNewDataSource
			},
			'dsnSettingspopup button[id="backBtn"]' :
			{
				'click' : this.dsnBackBtn
			},
			'dsnSettingspopup button[id="executeQuery"]' :
			{
				'click' : this.executeSQLIntegrationQuery
			},
			'dsnSettingspopup combo[id="dbType"]' :
			{
				'change' : this.sqlIntegrationDbTypeChange
			},
			'dsnSettingspopup button[id="saveSql"]' :
			{
				'click' : this.saveSqlFields
			},
			'dsnSettingspopup button[id="saveExcel"]' :
			{
				'click' : this.saveExcelDsnSettings
			},
			'dsnSettingspopup button[id="test"]' :
			{
				'click' : this.testConnection
			},
			'addexternalmetrics combo[id="Data_Source"]' :
			{
				'select' : this.dataSourceChange
			}
		});
	},
	saveRESTDSN : function()
	{	
		var validationResult=this.valForm();
		if(validationResult)
		{
		var dsnListContObj=Ext.getCmp('dsnListCont');
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var restdsnname=restdsnnameObj.getValue();
		if (restdsnname != null && restdsnname !=''){
		restdsnname = restdsnname.trim();
		}
		var txtFieldObj=Ext.getCmp('urltextbox');
		var tabPanelBox12 = Ext.getCmp('tabPanelBox');
		var activeTab = Ext.getCmp('tabPanelBox').setActiveTab(0);
		var integrationType=activeTab.id;
		var restURL=txtFieldObj.getValue();
		var restPortNo=Ext.getCmp('restPortNo').getValue();
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		var rest_output_window=Ext.getCmp('restfieldmappingpnl');
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var widgetId=restDashMainPnl.widgetID;
	//	var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var radioGrpObj=Ext.getCmp('body_type');
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawBody=rawJsonBodyObj.getValue();
		var rawJsonBody="";
		var bodyUrlEncodedGridObj = this.getRESTBodyUrlEncodedGrid();
		var bodyUrlEncodedGridStore = bodyUrlEncodedGridObj.getStore();
		var configuredBodyUrlEncoded = '';
		var selectedBodyType = '';
		if(restHttpMethod == "POST")
		{
			selectedBodyType = body_name;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				var  bodyUrlEncodedGridCount = bodyUrlEncodedGridObj.getStore().getCount();
				for ( var i = 0; i < bodyUrlEncodedGridCount; i++) {
					var key = bodyUrlEncodedGridObj.getStore().getAt(i).get('key');
					var value = bodyUrlEncodedGridObj.getStore().getAt(i).get('value');
					var bodyData=key+"$!$"+value;
					configuredBodyUrlEncoded=configuredBodyUrlEncoded+'!^!'+bodyData;
				}
				if (configuredBodyUrlEncoded != null && configuredBodyUrlEncoded.indexOf("!^!") == 0) {
					configuredBodyUrlEncoded = configuredBodyUrlEncoded.substring(3);
				}
			}
			else
			{
				if(rawBody!=null && rawBody!="")
				{
					var rawBodyJson = JSON.parse(rawBody);
					rawJsonBody=JSON.stringify(rawBodyJson);
				}
			}
		}
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		for ( var i = 0; i < gridRecordCount; i++) {
			var key = gridObj.getStore().getAt(i).get('key');
			var value = gridObj.getStore().getAt(i).get('value');
			var header=key+"$!$"+value;
			configuredHeaders=configuredHeaders+'!^!'+header;
		}
		var authRequiredObj=Ext.getCmp('User_Authentication_Required');
		if(authRequiredObj.checked)
		{
			var rest_username=Ext.getCmp('rest_username').getValue();
			var password=Ext.getCmp('rest_password').getValue();
			var auth=btoa(rest_username+':'+password);
			var authHeader="Authorization"+"$!$"+"Basic "+auth;
			configuredHeaders=configuredHeaders+'!^!'+authHeader;
		}

		if (configuredHeaders != null && configuredHeaders.indexOf("!^!") == 0) {
			configuredHeaders = configuredHeaders.substring(3);
		}
		
		var dataTypeMapping=restDashMainPnl.dataTypeMapping;
		var dataFieldMapping='';
		var checkedValue = [];
		var selectedFields="";
		var dataFieldParentNode=Ext.getCmp('restDataGrid').dataFieldParentNode;
		var inputElements = document.getElementsByClassName('messageCheckbox');
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
				  //selectedFields = selectedFields+","+inputElements[i].value;
				var selectedDataFld=inputElements[i].value;
				selectedFields = selectedFields+","+selectedDataFld;
				 if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
				  {
					  var dataTyp=dataTypeMapping[inputElements[i].value];
					//  restWS_Fields = restWS_Fields+","+selectedDataFld;
					  if(!Ext.isEmpty(dataTyp))
					  {
						   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
					  }
					  else
					  {
						  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
					  }
				  }
			  }
		}
		if (selectedFields != null && selectedFields.indexOf(",")==0) {
					selectedFields = selectedFields.substring(1);
				}
		if(selectedFields==null || selectedFields=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Please Select Data Fields.',
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
		restURL=myDashApp.getController("Main").filterEncode(restURL);
		configuredHeaders=myDashApp.getController("Main").filterEncode(configuredHeaders);
		rawJsonBody=myDashApp.getController("Main").filterEncode(rawJsonBody);
		configuredBodyUrlEncoded=myDashApp.getController("Main").filterEncode(configuredBodyUrlEncoded);
		selectedFields=myDashApp.getController("Main").filterEncode(selectedFields);
		dataFieldParentNode=myDashApp.getController("Main").filterEncode(dataFieldParentNode);
		var paramsForRestURL='restDSNName='+encodeURIComponent(restdsnname)+'&restWS_URL='+encodeURIComponent(restURL)+'&restWS_Port='+encodeURIComponent(restPortNo)+'&httpMethod='+encodeURIComponent(restHttpMethod)+'&action=saveRESTDSN'+'&widgetId='+encodeURIComponent(widgetId)+'&configuredHeaders='+encodeURIComponent(configuredHeaders)+'&selectedBodyType='+encodeURIComponent(selectedBodyType)+'&rawJsonBody='+encodeURIComponent(rawJsonBody)+'&configuredBodyUrlEncoded='+encodeURIComponent(configuredBodyUrlEncoded)+'&integrationType='+encodeURIComponent(integrationType)+'&restWS_Fields='+encodeURIComponent(selectedFields)+'&dataFieldParentNode='+encodeURIComponent(dataFieldParentNode);
		if(!Ext.isEmpty(dataFieldMapping))
		{
			dataFieldMapping=myDashApp.getController("Main").filterEncode(dataFieldMapping);
			paramsForRestURL=paramsForRestURL+"&dataFieldDataTypes="+encodeURIComponent(dataFieldMapping);
		}

			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: 'Data Source Configuration is saved successffully',
							buttons: Ext.MessageBox.OK,
							});
						Ext.getCmp('getData').enable();
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						var win = Ext.getCmp('dsnSettingspopup');
						var dsnListContObj = Ext.getCmp('dsnListCont');
						var csvExcelConfigCont=Ext.getCmp('csvExcelConfigCont');
						var restTreePnlObj=Ext.getCmp('restTreePnl');
						var dsnConfigCont=Ext.getCmp('dsnConfigCont');
						var dsnListObj=Ext.getCmp('dsnListGrid_id');
						var saveFldsBtnObj= Ext.getCmp('saveFldsBtn');
						var restPreviewBtnObj=Ext.getCmp('restPreviewBtnBox');
						var containeridObj=Ext.getCmp('containerid');
						var dsnListStore = dsnListObj.getStore();
						dsnListStore.removeAll();
						 var addNewDSobj = Ext.getCmp('addNewDS');
						addNewDSobj.show();
						dsnListStore.add(jsonData['dsnOpts']['dsnOptsArr']);
						Ext.each(Ext.getCmp('dsnListGrid_id').columns,function(d){
							this.hidden =  false;
						});
						containeridObj.show();
						dsnListContObj.show();
						csvExcelConfigCont.hide();
						restTreePnlObj.hide();
						dsnConfigCont.hide();
						restPreviewBtnObj.hide();
						saveFldsBtnObj.hide();
						/*{
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
							myDashApp.getController("Main").goToPage(viewUrl, 'showMyDashboard');
						}*/
							
					}
			});
		}

	},
	saveExcelDsnSettings : function()
	{
		var dsnSettingsPanel = Ext.getCmp('dsnSettingspopup');
		var dsn_type = 'NEW';
		var existingDsnName = '';
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var csvdsnname=restdsnnameObj.getValue();
		if (csvdsnname != null && csvdsnname !=''){
		csvdsnname = csvdsnname.trim();
		}
		var splChar = "%&+=\"?#:$!^~";
		if(restdsnnameObj.readOnly == false)
		{
		}
		if(dsn_type != null && dsn_type=='NEW')
		{
			if(csvdsnname==null || csvdsnname=='')
			{
				Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: 'Please Enter DSN Name.',
					buttons: Ext.MessageBox.OK
				});
				return;
			}
			if(csvdsnname!="" || csvdsnname!=null)
			{
				for ( var i = 0; i < csvdsnname.length; i++) {
					check_char = splChar.indexOf(csvdsnname.charAt(i))
					if (check_char >= 0) {
						Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['specialCharsDSNAlertMsg'],
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation'
						});
						return;
					}
				}
			}
		}
		else
		{
			existingDsnName='';
		}
		var checkedValue = [];
		var restWS_Fields="";
		var dataTypeMapping=dsnSettingsPanel.dataTypeMapping;
		var dataFieldMapping='';
		var inputElements = document.getElementsByClassName('messageCheckbox');
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
				var selectedDataFld=inputElements[i].value;
				 if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
				  {
					  var dataTyp=dataTypeMapping[inputElements[i].value];
					  restWS_Fields = restWS_Fields+","+selectedDataFld;
					  if(!Ext.isEmpty(dataTyp))
					  {
						   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
					  }
					  else
					  {
						  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
					  }
				  }
			  }
		}
		if (restWS_Fields != null ) {
					restWS_Fields = restWS_Fields.substring(1);
				}
		if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
		if(restWS_Fields==null || restWS_Fields=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Please Select Data Fields.',
				buttons: Ext.MessageBox.OK
			});
			return;
		}
//		var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBoxobj.getActiveTab(); 
		var integration=activeTab.id;
		var headerRow=Ext.getCmp('headerRowExcel').getValue();	
		var dstFilepath = Ext.getCmp('FILE_0_dstFile1').getValue();
		var thisWind = new Ext.LoadMask(dsnSettingsPanel.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
		thisWind.show();
		var paramsForCSV='DSNName='+encodeURIComponent(csvdsnname)+'&action=saveCsvDSN'+'&widgetId='+encodeURIComponent('RESTAPIWidget')+'&dsn_type='+encodeURIComponent(dsn_type)+'&integrationType='+encodeURIComponent(integration)+'&headerRow='+encodeURIComponent(headerRow)+'&restWS_Fields='+encodeURIComponent(restWS_Fields)+'&dataFieldParentNode='+encodeURIComponent('gridJson!DOT!gridData')+'&dstFilepath='+encodeURIComponent(dstFilepath)+'&existingDsnName='+encodeURIComponent(existingDsnName);

		if(!Ext.isEmpty(dataFieldMapping))
		{
			paramsForCSV=paramsForCSV+"&dataFieldDataTypes="+encodeURIComponent(dataFieldMapping);
		}

		Ext.Ajax.request({
					url : '/final/servlet/com.eg.CsvExcelIntegrationController',
					method : 'POST',
					params : paramsForCSV,
					scope : this,
					success : function(response) {
						thisWind.hide();
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: 'Data Source Configuration is saved successffully',
							buttons: Ext.MessageBox.OK
						});
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						var win = Ext.getCmp('dsnSettingspopup');
						var dsnListContObj = Ext.getCmp('dsnListCont');
						var RESTConfigCont=Ext.getCmp('csvExcelConfigCont');
						var csvExcelConfigCont1Obj=Ext.getCmp('csvExcelConfigCont1');
						var dsnConfigCont=Ext.getCmp('dsnConfigCont');
						var dsnListObj=Ext.getCmp('dsnListGrid_id');
						var dsnListStore = dsnListObj.getStore();
						dsnListStore.removeAll();
						dsnListStore.add(jsonData['dsnOpts']['dsnOptsArr']);
						Ext.each(Ext.getCmp('dsnListGrid_id').columns,function(d){
							this.hidden =  false;
						});
						dsnListContObj.show();
						RESTConfigCont.hide();
						dsnConfigCont.hide();
						csvExcelConfigCont1Obj.hide();
					/*	{
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
							myDashApp.getController("Main").goToPage(viewUrl, 'showMyDashboard');
						}*/
							
					}
			});
			
	},
	csvDSFileUpload  : function(item)
	{
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tabPanelBox = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBox.getActiveTab();
		var integrationType=activeTab.id;		
		if(integrationType == "EXCEL"){
			var restForm = this.getRestFileUploadFormExcel().getForm();
			var dstFilepath = Ext.getCmp('FILE_0_dstFile1').getValue();
			var maxFileSize = Ext.getCmp('maxFileSize1').getValue();
			var fileUploadObj = Ext.getCmp('fileUploadExcel');
		}	
		if(integrationType == "CSV"){
		var restForm = this.getRESTFileUploadForm().getForm();
		var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
		var maxFileSize = Ext.getCmp('maxFileSize').getValue();
		var fileUploadObj = Ext.getCmp('fileUpload');
		}
		var fileName = fileUploadObj.getValue();
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var csvdsnname=restdsnnameObj.getValue();
		if (csvdsnname != null && csvdsnname !=''){
		csvdsnname = csvdsnname.trim();
		}
		var maxSize = maxFileSize*1024*1024; //10MB
		var fileSize = fileUploadObj.fileInputEl.dom.files[0].size;
		var dsnSettingsPanel = Ext.getCmp('dsnSettingspopup');
		var dsnlistgridObj = Ext.getCmp('dsnListGrid_id');
		var dIdx=-1;
		if(restdsnnameObj.readOnly == false)
		{
			if(csvdsnname==null || csvdsnname=='')
			{
				Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: 'Please Enter DSN Name.',
					buttons: Ext.MessageBox.OK
				});
				fileUploadObj.reset();
				return;
			}
			if(!Ext.isEmpty(dsnlistgridObj))
			{
				var dsnlistgridStore = dsnlistgridObj.getStore();
				var profRecord = dsnlistgridStore.findRecord('datasourcename', csvdsnname, 0, false, false, true);
				dIdx = dsnlistgridStore.indexOf(profRecord);
				if(dIdx != -1)
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: 'Data Source Name Already Exist',
						buttons: Ext.MessageBox.OK
					});
					fileUploadObj.reset();
					return;
				}
			}
			if(fileSize > maxSize)
			{
				Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: 'File size should be less than '+maxFileSize+'Mb',
					buttons: Ext.MessageBox.OK
				});
				fileUploadObj.reset();
				return;
			}
		}

		if(activeTab.id == 'CSV')
		{
			if(!fileName.endsWith('.csv'))
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Please upload a valid CSV file.',
					buttons : Ext.MessageBox.OK,
					icon : 'iconInformation'
				});
				return;
			}
		}
		else if(activeTab != null && activeTab.id == 'EXCEL')
		{
			if(!fileName.endsWith('.xls') &&  !fileName.endsWith('.xlsx'))
			{
				Ext.Msg.show({
					title : myDashboardAlertLbl,
					msg : 'Please upload a valid Excel file.',
					buttons : Ext.MessageBox.OK,
					icon : 'iconInformation'
				});
				return;
			}
		}
		else
		{
			//return;
		}
		var thisWind = new Ext.LoadMask(dsnSettingsPanel.getEl(), {
				msg: screenLabelsObj['loadingMsg']
			});
		thisWind.show();
		if (restForm.isValid())
		{
			restForm.submit(
			{
				url : "/final/servlet/com.eg.CsvExcelIntegrationController?action=fileUpload&dstFilepath="+encodeURIComponent(dstFilepath)+'&DS_name='+encodeURIComponent(csvdsnname)+'&integrationType='+encodeURIComponent(integrationType),
				scope:this,
				async : true,
				method : 'POST',
				enctype : 'multipart/form-data',
				success:function (form, action)
				{
					var jsonText = action.response.responseText;
					jsonText = Ext.decode(jsonText);
					if(integrationType=="CSV"){
					var restDS=Ext.getCmp('csvExcelConfigCont');
					restDS.remove('gridMap',true);
					var rowSelectorCsv=Ext.getCmp('rowSelectorCsv');
					var headerRow=Ext.getCmp('headerRowCsv');

					var saveCsv=Ext.getCmp('saveCsv');
					rowSelectorCsv.show();
					headerRow.setValue(0);
					var csvRowPanelCountObj= Ext.getCmp('csvRowPanelCount');
					csvRowPanelCountObj.show();
					var csvSaveButtonObj= Ext.getCmp('csvSaveButton');
					csvSaveButtonObj.show();
					saveCsv.show();
					}
					if(integrationType=="EXCEL"){
						var restDS=Ext.getCmp('csvExcelConfigCont1');
					restDS.remove('gridMap',true);
					var rowSelectorExcel=Ext.getCmp('rowSelectorExcel');
					var headerRow=Ext.getCmp('headerRowExcel');

					var saveExcel=Ext.getCmp('saveExcel');
					rowSelectorExcel.show();
					headerRow.setValue(0);
					var excelRowPanelCountObj= Ext.getCmp('excelRowPanelCount');
					excelRowPanelCountObj.show();
					var ExcelSaveButtonObj= Ext.getCmp('ExcelSaveButton');
					ExcelSaveButtonObj.show();
					saveExcel.show();
					}
					var gridCols = jsonText['gridJson']['gridCols'];
					var gridData = jsonText['gridJson']['gridData'];
					var dataTypeMapping = jsonText['gridJson']['dataTypeMapping'];
					var colsArr = [];
					var fields2Store = [];
					var filtersArr = [];
					var widthForEachColumn = 105;
					for ( var colVal in gridCols) {
						var colName = gridCols[colVal].toString();
						//colName=colName.replace('.','');
						var dispColName=colName.replace('|DOT|','.');
						fields2Store.push({
							name : colName,
							//type : 'string'
							type : 'FLOATORSTRING'
						});
						
						var sm=  new Ext.selection.CheckboxModel({
											checkOnly: true,
											headerWidth:30,
											injectCheckbox: 0
										});
						var flex1= 0.14;
							colsArr
								.push({
									header : "<span class='newFont_normal11 DsWrapText' style='display:block;min-width:90px;' data-qtip='" + dispColName + "'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='"+colName+"' ><span class='labelCheckBOx'></span></label>"+dispColName+"</span>",
									
								     selModel: sm,
									dataIndex : colName,
									sortable: false,
									minWidth: 100,
                                    tdCls: 'DsWrapText',
									flex : 1,
									tdCls : 'newFont_normal11',
									cls: 'x-grid-checkheader-editor',
									listeners: {
										headerclick: function(ct, column, e, t, eOpts){
										}
									},
									renderer : function(value, metaData, record, row, col, store, gridView) {
										 var value = '<span class="newFont_normal11 DsWrapText" style="" data-qtip="' + value + '">' + value + '</span>';
										return value;
									}
										
								});
							
					}
					var tabPanelBox = Ext.getCmp('tabPanelBox');
					var activeTab = tabPanelBox.getActiveTab();
					if (activeTab.id == 'EXCEL'){
					var gridObj = Ext.getCmp('fileupload_gridExcel');
					gridObj.getStore().removeAll();
					}
					if (activeTab.id == 'CSV'){
					var gridObj = Ext.getCmp('fileupload_gridCsv');
					gridObj.getStore().removeAll();
					}

					var storeVal1 = Ext.create('Ext.data.Store',{
						fields:fields2Store,
						data:gridData,
					});
					dsnSettingsPanel.dataTypeMapping=dataTypeMapping;
					gridObj.reconfigure(storeVal1,colsArr);
					gridObj.show();
					thisWind.hide();
				},
				failure:function (form, action)
				{
					console.log('Failer..function');
				}
			});
			
		}
		
	},
	csvDSFileUpdate  : function()
	{
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		
		var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
		var fileName = Ext.getCmp('fileUpload').getValue();
		var tabPanelBox = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBox.getActiveTab();
		var integrationType=activeTab.id;
		
		
		if(integrationType == "EXCEL"){
		var restForm = this.getRestFileUploadFormExcel().getForm();
		var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
		var fileName = Ext.getCmp('fileUpload').getValue();
		var headerRow=Ext.getCmp('headerRowExcel').getValue();
		
		}
		if(integrationType == "CSV"){
		var restForm = this.getRESTFileUploadForm().getForm();
		var dstFilepath = Ext.getCmp('FILE_0_dstFile1').getValue();
		var fileName = Ext.getCmp('fileUploadExcel').getValue();
		var headerRow=Ext.getCmp('headerRowCsv').getValue();
		}
		var dsnSettingsPanel = Ext.getCmp('dsnSettingspopup');
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var csvSaveButtonObj= Ext.getCmp('csvSaveButton');
		var csvdsnname=restdsnnameObj.getValue();
		if (csvdsnname != null && csvdsnname !=''){
		csvdsnname = csvdsnname.trim();
		}
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.CsvExcelIntegrationController?action=csvGridUpdate&dstFilepath='+encodeURIComponent(dstFilepath)+'&headerRow='+encodeURIComponent(headerRow)+'&DS_name='+encodeURIComponent(csvdsnname)+'&integrationType='+encodeURIComponent(integrationType),
			method : 'POST',
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				jsonText = Ext.decode(jsonText);

				var restDS=Ext.getCmp('csvExcelConfigCont');
				restDS.remove('gridMap',true);

				if( integrationType == "EXCEL"){
					var rowSelector=Ext.getCmp('rowSelectorExcel');
				}
				if(integrationType == "CSV"){
					var rowSelector=Ext.getCmp('rowSelectorCsv');
				}
				var excelRowPanelCount = Ext.getCmp('excelRowPanelCount').show();
				rowSelector.show();
				var gridCols = jsonText['gridJson']['gridCols'];
				var gridData = jsonText['gridJson']['gridData'];
				var colsArr = [];
				var fields2Store = [];
				var widthForEachColumn = 105;
				for ( var colVal in gridCols) {
					var colName = gridCols[colVal].toString();
					fields2Store.push({
						name : colName,
						type : 'FLOATORSTRING'
					});
					var dispColName=colName.replace('|DOT|','.');
					var flex1= 0.14;
						colsArr
							.push({
								header : "<span class='newFont_normal11 DsWrapText' style='display:block;' data-qtip='" + dispColName + "'><label class='dsCustomCheckBox' style='margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='"+colName+"' ><span class='labelCheckBOx'></span></label>"+dispColName+"</span>",
								dataIndex : colName,
								sortable: false,
								flex : 1,
								minWidth: 100,
								tdCls : 'DsWrapText',
								renderer : function(value, metaData, record, row, col, store, gridView) {
									 var value = '<span class="newFont_normal11" style="cursor:default; word-wrap: break-word;" data-qtip="' + value + '">' + value + '</span>';
									return value;
								},
								listeners: {
									headerclick: function(ct, column, e, t, eOpts){
										
									}
								},
							});
							
				}
				for ( var colVal in colsArr) {
					var colName = colsArr[colVal];
				}
				for ( var colVal in fields2Store) {
					var colName = fields2Store[colVal];
				}

				var tabPanelBox = Ext.getCmp('tabPanelBox');
					var activeTab = tabPanelBox.getActiveTab();
					if (activeTab.id == 'EXCEL'){
					var gridObj = Ext.getCmp('fileupload_gridExcel');
					gridObj.getStore().removeAll();
					var excelRowPanelCount = Ext.getCmp('excelRowPanelCount').show();
					}
					if (activeTab.id == 'CSV'){
					var gridObj = Ext.getCmp('fileupload_gridCsv');
					gridObj.getStore().removeAll();
					var csvRowPanelCount = Ext.getCmp('csvRowPanelCount').show();
					}
				var storeVal1=null;
				if(Ext.isEmpty(gridObj) || gridObj.store==null)
				{
					storeVal1 = Ext.create('Ext.data.Store',{
						fields:fields2Store,
						data:gridData,
						selModel: {
						 selType: 'cellmodel'
					}
					});
				}
				else
				{
					storeVal1 = new Ext.data.Store({
						fields:fields2Store,
						data:gridData,
						selModel: {
						 selType: 'cellmodel'
					}
					});
				}
				var dataTypeMapping = jsonText['gridJson']['dataTypeMapping'];
				dsnSettingsPanel.dataTypeMapping=dataTypeMapping;
				gridObj.reconfigure(storeVal1,colsArr);
				gridObj.show();

				gridData=null;
				delete gridData;
			}
	});
	},
	saveCsvDsnSettings : function()
	{
		var dsnSettingsPanel = Ext.getCmp('dsnSettingspopup');
		var dsn_type = 'NEW';
		var existingDsnName = '';
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var csvdsnname=restdsnnameObj.getValue();
		if (csvdsnname != null && csvdsnname !=''){
		csvdsnname = csvdsnname.trim();
		}
		var splChar = "%&+=\"?#:$!^~";
		if(restdsnnameObj.readOnly == false)
		{
		}
		if(dsn_type != null && dsn_type=='NEW')
		{
			if(csvdsnname==null || csvdsnname=='')
			{
				Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: 'Please Enter DSN Name.',
					buttons: Ext.MessageBox.OK
				});
				return;
			}
			if(csvdsnname!="" || csvdsnname!=null)
			{
				for ( var i = 0; i < csvdsnname.length; i++) {
					check_char = splChar.indexOf(csvdsnname.charAt(i))
					// Returns value 1 if the special character listed
					if (check_char >= 0) {
						Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['specialCharsDSNAlertMsg'],
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation'
						});
						return;
					}
				}
			}
		}
		else
		{
			existingDsnName='';
		}
		var checkedValue = [];
		var restWS_Fields="";
		var dataTypeMapping=dsnSettingsPanel.dataTypeMapping;
		var dataFieldMapping='';
		var inputElements = document.getElementsByClassName('messageCheckbox');
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
				  var selectedDataFld=inputElements[i].value;
				  if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
				  {
					  var dataTyp=dataTypeMapping[inputElements[i].value];
					  restWS_Fields = restWS_Fields+","+selectedDataFld;
					  if(!Ext.isEmpty(dataTyp))
					  {
						   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
					  }
					  else
					  {
						  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
					  }
				  }
			  }
		}
		if (restWS_Fields != null ) {
					restWS_Fields = restWS_Fields.substring(1);
				}
		if(restWS_Fields==null || restWS_Fields=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Please Select Data Fields.',
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
	//	var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBoxobj.getActiveTab(); 
		var integration=activeTab.id;
		var headerRow=Ext.getCmp('headerRowCsv').getValue();	
		var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
		var thisWind = new Ext.LoadMask(dsnSettingsPanel.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
		thisWind.show();
		var paramsForCSV='DSNName='+encodeURIComponent(csvdsnname)+'&action=saveCsvDSN'+'&widgetId='+encodeURIComponent('RESTAPIWidget')+'&dsn_type='+encodeURIComponent(dsn_type)+'&integrationType='+encodeURIComponent(integration)+'&headerRow='+encodeURIComponent(headerRow)+'&restWS_Fields='+encodeURIComponent(restWS_Fields)+'&dataFieldParentNode='+encodeURIComponent('gridJson!DOT!gridData')+'&dstFilepath='+encodeURIComponent(dstFilepath)+'&existingDsnName='+encodeURIComponent(existingDsnName);
		if(!Ext.isEmpty(dataFieldMapping))
		{
			paramsForCSV=paramsForCSV+"&dataFieldDataTypes="+encodeURIComponent(dataFieldMapping);
		}
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.CsvExcelIntegrationController',
					method : 'POST',
					params : paramsForCSV,
					scope : this,
					success : function(response) {
						thisWind.hide();
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: 'Data Source Configuration is saved successffully',
							buttons: Ext.MessageBox.OK
						});
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						var win = Ext.getCmp('dsnSettingspopup');
						var dsnListContObj = Ext.getCmp('dsnListCont');
						var RESTConfigCont=Ext.getCmp('csvExcelConfigCont');
						var dsnConfigCont=Ext.getCmp('dsnConfigCont');
						var dsnConfigCont1=Ext.getCmp('dsnConfigCont1');
						var dsnListObj=Ext.getCmp('dsnListGrid_id');
						//dsnListObj.removeAll();
						var dsnListStore = dsnListObj.getStore();
						dsnListStore.removeAll();
						var dsnListData=jsonData['dsnOpts']['dsnOptsArr'];
						if(!Ext.isEmpty(dsnListData))
						{
							dsnListStore.add(dsnListData);
						}
						Ext.each(Ext.getCmp('dsnListGrid_id').columns,function(d){
							this.hidden =  false;
						});
						
						RESTConfigCont.hide();
						dsnConfigCont.hide();
						dsnListContObj.show();
						/*{
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
							myDashApp.getController("Main").goToPage(viewUrl, 'showMyDashboard');
						}*/
							
					}
			});
			
	},
	sqlIntegrationDbTypeChange : function()
	{
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var dsnName=restdsnnameObj.getValue();
		if (dsnName != null && dsnName !=''){
		dsnName = dsnName.trim();
		}
		var dbTypeObj = Ext.getCmp('dbType');
		var sqlContainerObj = Ext.getCmp('sqlAttrContainer');
		var sqlContainerObj1 = Ext.getCmp('sqlAttrContainer1');
		var sqlContainerObj2 = Ext.getCmp('sqlAttrContainer2');
		var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');
		var dbType=dbTypeObj.getValue();
		if(dbType==null || dbType=='')
		{
			return;
		}
		var params='dbType='+encodeURIComponent(dbType)+'&dsnName='+encodeURIComponent(dsnName)+'&action=sqlDbAttributes';
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.SQLIntegrationController',
					method : 'POST',
					params : params,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('sqlDbAttributes'))
						{
							var sqlAttrArray=jsonData['sqlDbAttributes']['sqlAttrArray'];
							var fieldsComboArr=[];
							var fieldsComboIdArr=[];
							for(var widA in sqlAttrArray)
							{
								var sqlAttrOpt=sqlAttrArray[widA];
								var dispLbl=sqlAttrOpt['displayField'];
								var valLbl=sqlAttrOpt['valueField'];
								var UI_Control=sqlAttrOpt['UI_Control'];
								var val=sqlAttrOpt['value'];
								if(UI_Control!='button')
								{
									fieldsComboIdArr.push(valLbl);
								}
								if(valLbl=='password')
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
														id: valLbl,
														labelWidth: 150,
														width:400,
														margin:'0 0 17 10',
														inputType : 'password',
														name: valLbl,
														cls: 'textbox',
														value : val
													});
								}
								else if(valLbl=='test')
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														text: '<span class="newFont_normal12" style="float:left; color:#ffffff;">'+dispLbl+'</span>',
														id: valLbl,
														name: valLbl,
														cls: 'textbox',
														layout: {
															type:'column'
														},
														width:107,
														margin:'0 0 10 0',
														cls:'button20',
														style: {
															'float': 'right',
															'height' : '21px',
															'padding' : '1px 0 0 0',
															'border-style'  : 'solid',
															'border-width' : '1px 1px 1px 1px',
															'border-color': strSkin == ('Light')? "transparent":'#252525'
														},
													});
								}
								else if(valLbl=='sid')
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
														id: valLbl,
														name: valLbl,
														cls: 'textbox',
														layout: {
															type:'column'
														},
														style: {
															'float': 'left'
														},
														labelWidth: 150,
														margin:'0 10 17 10',
														width : 283

													});
								}
								
								else if(valLbl=='sqlquery')
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
														labelWidth: 100,
														margin:'0 0 0 40',
														height: 220,
														cls: 'text-area',
														id: valLbl,
														name: valLbl,
														width : 370,
														value : val

													});
								}
								else if(valLbl=='database')
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
														id: valLbl,
														name: valLbl,
														cls: 'textbox',
														layout: {
															type:'column'
														},
														style: {
															'float': 'left'
														},
														labelWidth: 150,
														margin:'0 0 0 10',
														width : 283,
														value: val

													});
								}
								else
								{
									fieldsComboArr.push({
														xtype : UI_Control,
														fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
														labelWidth: 150,
														margin:'0 0 17 10',
														id: valLbl,
														cls: 'textbox',
														name: valLbl,
														width : 400,
														value : val
													});
								}
							}
							var total_len = fieldsComboArr.length;
							var left_side = fieldsComboArr.splice(0,6);
							var right_side = fieldsComboArr.splice(left_side,total_len);
							sqlContainerObj1.removeAll();
							sqlContainerObj1.add(left_side);
							sqlContainerObj2.removeAll();
							sqlContainerObj2.add(right_side);
							sqlContainerObj1.show();
							sqlContainerObj2.show();
							dsnSettingspopupObj.sqlDbTypeFieldsIdArr=fieldsComboIdArr;
							Ext.getCmp('executeQueryContainer').show();
							if(jsonData['sqlDbAttributes']['editDsn']==true)
							{
								//Ext.getCmp('sqlSaveButton').show();
								//Ext.getCmp('sqlData_grid').show();
								Ext.getCmp('sqlPreviewBox').show();
							}
							else
							{
								Ext.getCmp('sqlPreviewBox').hide();
								//Ext.getCmp('sqlSaveButton').hide();
								//Ext.getCmp('sqlData_grid').hide();
							}
							//Ext.getCmp('clearQuery');

						}
					}
		})
	},
	executeSQLIntegrationQuery : function()
	{
		var dbTypeObj=Ext.getCmp('dbType');
		var dbType=dbTypeObj.getValue();
		var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBoxobj.getActiveTab(); 
		var integrationType=activeTab.id;
		//var sqlDbTypeFieldsIdArr=dsnSettingspopupObj.sqlDbTypeFieldsIdArr;
		//alert('query-->'+sqlDbTypeFieldsIdArr[0]);
		
		if(!Ext.isEmpty(dsnSettingspopupObj) && dsnSettingspopupObj.hasOwnProperty('sqlDbTypeFieldsIdArr'))
		{
			var selectedFieldVals='';
			var sqlDbTypeFieldsIdArr=dsnSettingspopupObj.sqlDbTypeFieldsIdArr;
			if(!Ext.isEmpty(sqlDbTypeFieldsIdArr))
			{
				for(var didx in sqlDbTypeFieldsIdArr)
				{
					var fieldId=sqlDbTypeFieldsIdArr[didx];
					var fieldValue=Ext.getCmp(fieldId).getValue();
					selectedFieldVals=selectedFieldVals+'!^!'+fieldId+':'+fieldValue;
					if(fieldId=='sqlquery')
					{
						if(!Ext.isEmpty(fieldValue))
						{
							fieldValue=fieldValue.toLowerCase();
						}
						if(fieldValue==null||fieldValue=='')
						{
							Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: screenLabelsObj['emptyQryAlertMsg'],
								icon : 'iconInformation',
								buttons: Ext.MessageBox.OK
							});
							return;
						}
						else if(fieldValue.indexOf('select')==-1)
						{
							Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: screenLabelsObj['selectQryAlertMsg'],
								icon : 'iconInformation',
								buttons: Ext.MessageBox.OK
							});
							return;
						}
					}
					else
					{
						if(fieldValue==null||fieldValue=='')
						{
							var valMsg="-";
							if(fieldId=='ip')
							{
								valMsg=screenLabelsObj['emptyDBHostNameAlert'];
							}
							else if(fieldId=='port')
							{
								valMsg=screenLabelsObj['emptyPortAlert'];
							}
							else if(fieldId=='user')
							{
								valMsg=screenLabelsObj['emptyDBUNameAlert'];
								
							}
							else if(fieldId=='password')
							{
								valMsg=screenLabelsObj['emptyDBPassAlert'];
								
							}
							else if(fieldId=='database')
							{
								valMsg=screenLabelsObj['emptyDBNameAlert'];
								
							}
							else if(fieldId=='sid')
							{
								valMsg=screenLabelsObj['emptyDBSIDAlert'];
								
							}
							if(valMsg!='-')
							{
								Ext.Msg.show({
									title: screenLabelsObj['DSNTitle'],
									msg: valMsg,
									buttons: Ext.MessageBox.OK
								});
								return;
							}
						}
					}
				}
			}
		}
		if(selectedFieldVals!=null && selectedFieldVals.indexOf('!^!')>-1)
		{
			selectedFieldVals=selectedFieldVals.substring(selectedFieldVals.indexOf('!^!')+3,selectedFieldVals.length);
		}
		var thisWind = new Ext.LoadMask(dsnSettingspopupObj.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
		thisWind.show();
		selectedFieldVals=myDashApp.getController("Main").filterEncode(selectedFieldVals);
		var params='dbType='+encodeURIComponent(dbType)+'&action=executeSqlQuery'+'&dbFields='+encodeURIComponent(selectedFieldVals)+'&integrationType='+encodeURIComponent(integrationType);
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.SQLIntegrationController',
					method : 'POST',
					params : params,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						jsonData = Ext.decode(jsonText);
					
						var gridCols = jsonData['gridJson']['gridCols'];
						var gridData = jsonData['gridJson']['gridData'];
						var dataTypeMapping = jsonData['gridJson']['dataTypeMapping'];
						dsnSettingspopupObj.dataTypeMapping=dataTypeMapping;
						var errMsg = jsonData['gridJson']['errMsg'];
						if(errMsg=='-')
						{
							var dsnConfigCont = Ext.getCmp('dsnConfigCont').hide();
							var colsArr = [];
							var fields2Store = [];
							var filtersArr = [];
							var widthForEachColumn = 105;
							for ( var colVal in gridCols) {
								var colName = gridCols[colVal].toString();
								fields2Store.push({
									name : colName,
									type : 'string'
								});
								var flex1= 0.14;
									colsArr
										.push(
											
                                           
											{
											header : "<span class='newFont_normal11  DsWrapText' style='display:block;' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style='margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='"+colName+"' ><span class='labelCheckBOx'></span></label>"+colName+"</span>",
											dataIndex : colName,
											sortable: false,
											flex : 1,
											minWidth: 100,
											tdCls : 'DsWrapText', //gridCellWrap
											cls: 'x-grid-checkheader-editor',
											listeners: {
												headerclick: function(ct, column, e, t, eOpts){
												}
											},
											renderer : function(value, metaData, record, row, col, store, gridView) {
												 var value = '<span class="newFont_normal11 DsWrapText" style="cursor:default; word-wrap: break-word;" data-qtip="' + value + '">' + value + '</span>';
												return value;
											}
												
										});
									
							}
							for ( var colVal in colsArr) {
								var v = colsArr[colVal];
							}				
							var gridObj = Ext.getCmp('sqlData_grid');
							gridObj.getStore().removeAll();

							var storeVal1 = Ext.create('Ext.data.Store',{
								fields:fields2Store,
								data:gridData,
							});
							gridObj.reconfigure(storeVal1,colsArr);
							gridObj.show();
							Ext.getCmp('DsintegrateText').hide();
							Ext.getCmp('tabPanelBox').hide();
							Ext.getCmp('containerid').hide();
							//Ext.getCmp('sqlSaveButton').show();
							Ext.getCmp('sqlPreviewBox').show();
							
							//Ext.getCmp('sqlPreviewBtnBox').show();
							 
							thisWind.hide();
						}
						else
						{
							thisWind.hide();
							Ext.getCmp('tabPanelBox').show();
							Ext.getCmp('containerid').show();
							Ext.Msg.show({
								title: 'Query error',
								msg: errMsg,
								icon : 'iconInformation',
								buttons: Ext.MessageBox.OK
							});
						}
					}
		});
	},
	saveSqlFields : function()
	{
		var dsnSettingsPanel = Ext.getCmp('dsnSettingspopup');
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var dsnName=restdsnnameObj.getValue();
		if (dsnName != null && dsnName !=''){
		dsnName = dsnName.trim();
		}
		var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');
		var dataTypeMapping=dsnSettingspopupObj.dataTypeMapping;
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab =  tabPanelBoxobj.setActiveTab(0); 
		var integrationType = activeTab.id;
		var dbType = Ext.getCmp('dbType').getValue();
		var splChar = "%&+=\"?#:$!^~";
		var dsnlistgridObj = Ext.getCmp('dsnListGrid_id');
		var dIdx=-1;
		if(restdsnnameObj.readOnly == false)
		{
		}
		if(dsnName==null || dsnName=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Please Enter DSN Name.',
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		if(dsnName!="" || dsnName!=null)
		{
			for ( var i = 0; i < dsnName.length; i++) {
				check_char = splChar.indexOf(dsnName.charAt(i))
				// Returns value 1 if the special character listed
				if (check_char >= 0) {
					Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: 'Please Enter DSN Name without special characters.',
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation'
					});
					return;
				}
			}
		}
		if(restdsnnameObj.readOnly == false)
		{
			if(!Ext.isEmpty(dsnlistgridObj))
			{
				var dsnlistgridStore = dsnlistgridObj.getStore();
				var profRecord = dsnlistgridStore.findRecord('datasourcename', dsnName, 0, false, false, true);
				dIdx = dsnlistgridStore.indexOf(profRecord);
				if(dIdx != -1)
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: 'Data Source Name Already Exist.',
						buttons: Ext.MessageBox.OK
					});
					return;
				}
			}
		}
		var checkedValue = [];
		var sql_Fields="";
		var dataFieldMapping='';
		var inputElements = document.getElementsByClassName('messageCheckbox');
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
					var selectedDataFld=inputElements[i].value;
					 if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
					  {
						  var dataTyp=dataTypeMapping[inputElements[i].value];
						   sql_Fields = sql_Fields+","+inputElements[i].value;
						  if(!Ext.isEmpty(dataTyp))
						  {
							   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
						  }
						  else
						  {
							  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
						  }
					  }

				 


			  }
		}
		if (sql_Fields != null ) {
					sql_Fields = sql_Fields.substring(1);
				}
		 if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
		if(sql_Fields==null || sql_Fields=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Please Select Data Fields.',
				buttons: Ext.MessageBox.OK
			});
			return;
		}
	//	var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab =  tabPanelBoxobj.setActiveTab(1); 
		var integrationType = activeTab.id;
		var integration = activeTab.id;
		if(!Ext.isEmpty(dsnSettingspopupObj) && dsnSettingspopupObj.hasOwnProperty('sqlDbTypeFieldsIdArr'))
		{
			var selectedFieldVals='';
			var sqlDbTypeFieldsIdArr=dsnSettingspopupObj.sqlDbTypeFieldsIdArr;
			if(!Ext.isEmpty(sqlDbTypeFieldsIdArr))
			{
				for(var didx in sqlDbTypeFieldsIdArr)
				{
					var fieldId=sqlDbTypeFieldsIdArr[didx];
					var fieldValue=Ext.getCmp(fieldId).getValue();
					selectedFieldVals=selectedFieldVals+'!^!'+fieldId+':'+fieldValue
				}
			}
		}
		if(selectedFieldVals!=null && selectedFieldVals.indexOf('!^!')>-1)
		{
			selectedFieldVals=selectedFieldVals.substring(selectedFieldVals.indexOf('!^!')+3,selectedFieldVals.length);
		}
		sql_Fields=myDashApp.getController("Main").filterEncode(sql_Fields);
		selectedFieldVals=myDashApp.getController("Main").filterEncode(selectedFieldVals);
		var thisWind = new Ext.LoadMask(dsnSettingsPanel.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
		thisWind.show();
		var paramsForCSV='DSNName='+encodeURIComponent(dsnName)+'&action=saveSqlDSN'+'&widgetId='+encodeURIComponent('RESTAPIWidget')+'&integrationType='+encodeURIComponent(integration)+'&sql_Fields='+encodeURIComponent(sql_Fields)+'&dbFields='+encodeURIComponent(selectedFieldVals)+'&dataFieldParentNode='+encodeURIComponent('gridData')+'&dbType='+encodeURIComponent(dbType);
		if(!Ext.isEmpty(dataFieldMapping))
		{
			dataFieldMapping=myDashApp.getController("Main").filterEncode(dataFieldMapping);
			paramsForCSV=paramsForCSV+"&dataFieldDataTypes="+encodeURIComponent(dataFieldMapping);
		}
			Ext.Ajax.request({
					url : '/final/servlet/com.eg.SQLIntegrationController',
					method : 'POST',
					params : paramsForCSV,
					scope : this,
					success : function(response) {
						thisWind.hide();
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: 'Data Source Configuration is saved successffully',
							buttons: Ext.MessageBox.OK
						});
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						var win = Ext.getCmp('dsnSettingspopup');
						var dsnListContObj = Ext.getCmp('dsnListCont');
						var RESTConfigCont=Ext.getCmp('csvExcelConfigCont');
						var dsnConfigCont=Ext.getCmp('dsnConfigCont');
						var dsnListObj=Ext.getCmp('dsnListGrid_id');
						var dsBackContainerObj=Ext.getCmp('dsBackContainer');
						var containeridObj=Ext.getCmp('containerid');
						var dsnListStore = dsnListObj.getStore();
						dsnListStore.removeAll();
						//dsnListStore.add(jsonData['dsnList']);
						dsnListStore.add(jsonData['dsnOpts']['dsnOptsArr']);
						Ext.getCmp('sqlPreviewBox').hide();
						//Ext.getCmp('sqlPreviewBtnBox').hide();
						//Ext.getCmp('sqlData_grid').hide();
						//Ext.getCmp('sqlSaveButton').hide();
						//Ext.getCmp('sqlSaveButton').hide();
						Ext.each(Ext.getCmp('dsnListGrid_id').columns,function(d){
							this.hidden =  false;
						});
						containeridObj.show();
						dsnListContObj.show();
						RESTConfigCont.hide();
						dsnConfigCont.hide();
						dsnListObj.show();

						//win.close();
						//if(jsonData['dsnOpts']['selectedDSN'] == csvdsnname)
					/*	{
							var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
							myDashApp.getController("Main").goToPage(viewUrl, 'showMyDashboard');
						}*/
							
					}
			});
	},
	testConnection: function()
	{
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var dsnName=restdsnnameObj.getValue();
		var dbType = Ext.getCmp('dbType').getValue();
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBoxobj.getActiveTab(1); 
		var integrationType = activeTab.id;
		var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');
		if(!Ext.isEmpty(dsnSettingspopupObj) && dsnSettingspopupObj.hasOwnProperty('sqlDbTypeFieldsIdArr'))
		{
			var selectedFieldVals='';
			var sqlDbTypeFieldsIdArr=dsnSettingspopupObj.sqlDbTypeFieldsIdArr;
			if(!Ext.isEmpty(sqlDbTypeFieldsIdArr))
			{
				for(var didx in sqlDbTypeFieldsIdArr)
				{
					var fieldId=sqlDbTypeFieldsIdArr[didx];
					var fieldValue=Ext.getCmp(fieldId).getValue();
					selectedFieldVals=selectedFieldVals+'!^!'+fieldId+':'+fieldValue
				}
			}
		}
		if(selectedFieldVals!=null && selectedFieldVals.indexOf('!^!')>-1)
		{
			selectedFieldVals=selectedFieldVals.substring(selectedFieldVals.indexOf('!^!')+3,selectedFieldVals.length);
		}
		var sqlDbTypeFieldsIdArr=dsnSettingspopupObj.sqlDbTypeFieldsIdArr;
		var valMsg='-';
		if(!Ext.isEmpty(sqlDbTypeFieldsIdArr))
		{
			for(var didx in sqlDbTypeFieldsIdArr)
			{
				var fieldId=sqlDbTypeFieldsIdArr[didx];
				var fieldValue=Ext.getCmp(fieldId).getValue();
				if(fieldValue==null || fieldValue=="")
				{
					if(fieldId=='ip')
					{
						valMsg=screenLabelsObj['emptyDBHostNameAlert'];
						break;
					}
					else if(fieldId=='port')
					{
						valMsg=screenLabelsObj['emptyPortAlert'];
						break;
					}
					else if(fieldId=='user')
					{
						valMsg=screenLabelsObj['emptyDBUNameAlert'];
						break;
					}
					else if(fieldId=='password')
					{
						valMsg=screenLabelsObj['emptyDBPassAlert'];
						break;
					}
					else if(fieldId=='database')
					{
						valMsg=screenLabelsObj['emptyDBNameAlert'];
						break;
					}
					else if(fieldId=='sid')
					{
						valMsg=screenLabelsObj['emptyDBSIDAlert'];
						break;
					}
					else
					{
					}
				}
			}
		}
		if(valMsg!='-')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: valMsg,
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		var thisWind = new Ext.LoadMask(dsnSettingspopupObj.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
		thisWind.show();
		selectedFieldVals=myDashApp.getController("Main").filterEncode(selectedFieldVals);
		var paramsForCSV='DSNName='+encodeURIComponent(dsnName)+'&action=testConnection'+'&dbFields='+encodeURIComponent(selectedFieldVals)+'&dbType='+encodeURIComponent(dbType);

		Ext.Ajax.request({
				url : '/final/servlet/com.eg.SQLIntegrationController',
				method : 'POST',
				params : paramsForCSV,
				scope : this,
				success : function(response) {
					thisWind.hide();
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: jsonData['testDbCon']['validateMsg']+'!',
							buttons: Ext.MessageBox.OK
						});
				}
		});

	},
	addNewDataSource : function()
	{
		var dsnConfigCont=Ext.getCmp('dsnConfigCont');
		var restdsnname = Ext.getCmp('restdsnname');
		var DsintegrateText = Ext.getCmp('DsintegrateText');
		DsintegrateText.show();

		var dsBackContainer = Ext.getCmp('DsintegrateText');
		dsBackContainer.show();
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var excelRowPanelCount = Ext.getCmp('excelRowPanelCount').hide();
		var fileupload_gridCsvObj = Ext.getCmp('fileupload_gridCsv').hide();
		var fileupload_gridExcelObj = Ext.getCmp('fileupload_gridExcel').hide();
		var csvRowPanelCountObj = Ext.getCmp('csvRowPanelCount').hide();
		var csvSaveButtonObj = Ext.getCmp('csvSaveButton').hide();
		var csvRowPanelCountObj = Ext.getCmp('excelRowPanelCount').hide();
		var ExcelSaveButtonObj = Ext.getCmp('ExcelSaveButton').hide();
		var dsnListObj = Ext.getCmp('dsnListCont');
		var RESTConfigCont=Ext.getCmp('csvExcelConfigCont');
		var dsBackContainerObj=Ext.getCmp('dsBackContainer');
		tabPanelBoxobj.show();
		restdsnname.show();
		restdsnname.reset();
		restdsnname.setReadOnly(false);
		dsnListObj.hide();
		dsnConfigCont.show();
		var activeTab = tabPanelBoxobj.setActiveTab(0);
		var integrationType=activeTab.id;		
		var executeQueryObj=Ext.getCmp('executeQueryContainer').hide();
		
	},
	dsnBackBtn : function()
	{
		var dsnListContObj = Ext.getCmp('dsnListCont');
		var RESTConfigCont=Ext.getCmp('csvExcelConfigCont');
		var RESTConfigContObj2 = Ext.getCmp('csvExcelConfigCont1');
		var dsnConfigCont=Ext.getCmp('dsnConfigCont');
		var dsnListObj=Ext.getCmp('dsnListGrid_id');
		var dsBackContainerObj=Ext.getCmp('dsBackContainer');
		var SQLDataGridObj=Ext.getCmp('sqlData_grid');

		var sqlPreviewBtnObj=Ext.getCmp('sqlPreviewBox');

		if (!Ext.isEmpty(sqlPreviewBtnObj))
		{
			sqlPreviewBtnObj.hide();
		}
		SQLDataGridObj.hide();
		
		
		Ext.getCmp('addNewDS').show();
		var sqlContainerObj=Ext.getCmp('sqlContainer');
		var restTree=Ext.getCmp('restTreePnl');
		if(!Ext.isEmpty(restTree))
		{
			restTree.hide();
		}
		
		dsnListContObj.show();
		RESTConfigCont.hide();
		RESTConfigContObj2.hide();
		dsnConfigCont.hide();
		var tabPanelBox = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBox.getActiveTab();
		var integrationType=activeTab.id;
		if(integrationType=="SQL"){
			var sqlContainerObj1 = Ext.getCmp('sqlAttrContainer1');
			var sqlContainerObj2 = Ext.getCmp('sqlAttrContainer2');
			//var sqlSaveButtonObj = Ext.getCmp('sqlSaveButton');
			sqlContainerObj1.hide();
			sqlContainerObj2.hide();
			//sqlSaveButtonObj.hide();
		}
		
	},
	valForm : function()
	{
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var urltextboxObj=Ext.getCmp('urltextbox');
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawJsonBody=rawJsonBodyObj.getValue();
		//var rawBodyJson = JSON.parse(rawBody);
		var restdsnname=restdsnnameObj.getValue();
		var url=urltextboxObj.getValue();
		var splChar = "%&+=\"?#:$!^~";
		var headerSplChar = "=\"@()!^;?><:,";
		var re = /^(http[s]?:\/\/){0,1}(www\.){0,1}[a-zA-Z0-9\.\-]+\.[a-zA-Z]{2,5}[\.]{0,1}/;
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		
		if(restdsnname=="" || restdsnname==null)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['emptyDSNAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
			return false;
		}
		if(restdsnname!="" || restdsnname!=null)
		{
		for ( var i = 0; i < restdsnname.length; i++) {
			check_char = splChar.indexOf(restdsnname.charAt(i))
			// Returns value 1 if the special character listed
			if (check_char >= 0) {
				Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['specialCharsDSNAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
			}
		}
		}
		if(url=="" || url==null)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['emptyRESTURLAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
			return false;
		}
		if(gridRecordCount>0)
		{
			for ( var i = 0; i < gridRecordCount; i++) 
				{
						var key = gridObj.getStore().getAt(i).get('key');
						if(key!="" || key!=null)
						{
						for ( var j = 0; j < key.length; j++) {
							check_char = headerSplChar.indexOf(key.charAt(j))
							// Returns value 1 if the special character listed
							if (check_char >= 0) {
								Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: key+' '+screenLabelsObj['invalidHTTPKeyAlertMsg'],
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation'
								});
								return false;
							}
						}
						}
				}
		}
		if(rawJsonBody!="" && rawJsonBody!=null)
		{
			try {
				var rawBodyJson = JSON.parse(rawJsonBody);
			} catch (e) {
				Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: screenLabelsObj['invalidJSONyAlertMsg'],
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation'
								});
				return false;
			}
		}
	return true;
	},
	getData : function()
	{
		var validationResult=this.valForm();
		if(!validationResult)
		{
			return;
		}
		var restdsnnameObj=Ext.getCmp('restdsnname');
		this.getResponseForRestURL(restdsnnameObj);
		var containeridObj=Ext.getCmp('containerid');
		containeridObj.hide();
		var restPreviewBtn=Ext.getCmp('restPreviewBtnBox');
		restPreviewBtn.show();
	},
	getResponseForRestURL : function(compObj)
	{
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var widgetId=restDashMainPnl.widgetID;
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var selectedDSN='';
		if(compObj!=null && compObj.id=='restdsnname')
		{
			selectedDSN=compObj.getValue();
		}
		//rest_output_window.removeAll();

	/*	var validationResult=this.valForm();
		console.log("validationResult ",validationResult);
		if(!validationResult)
		{
			return;
		}*/
		var meC=this;
		var RESTConfigContObj=Ext.getCmp('csvExcelConfigCont');
		RESTConfigContObj.hide();
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var restdsnname=restdsnnameObj.getValue();
		var urltextboxObj=Ext.getCmp('urltextbox');
		var tabPanelBox = Ext.getCmp('tabPanelBox');
		var activeTab = tabPanelBox.getActiveTab();
		var integrationType=activeTab.id;
		var restURL=urltextboxObj.getValue();
		var restPortNo=Ext.getCmp('restPortNo').getValue();
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		var rest_output_window=Ext.getCmp('restfieldmappingpnl');
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var widgetId=restDashMainPnl.widgetID;
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var radioGrpObj=Ext.getCmp('body_type');
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawBody=rawJsonBodyObj.getValue();
		var rawJsonBody="";
		var bodyUrlEncodedGridObj = this.getRESTBodyUrlEncodedGrid();
		var bodyUrlEncodedGridStore = bodyUrlEncodedGridObj.getStore();
		var configuredBodyUrlEncoded = '';
		var selectedBodyType = '';
		if(restHttpMethod == "POST")
		{
			selectedBodyType = body_name;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				var  bodyUrlEncodedGridCount = bodyUrlEncodedGridObj.getStore().getCount();
				for ( var i = 0; i < bodyUrlEncodedGridCount; i++) {
					var key = bodyUrlEncodedGridObj.getStore().getAt(i).get('key');
					var value = bodyUrlEncodedGridObj.getStore().getAt(i).get('value');
					var bodyData=key+"$!$"+value;
					configuredBodyUrlEncoded=configuredBodyUrlEncoded+'!^!'+bodyData;
				}
				if (configuredBodyUrlEncoded != null && configuredBodyUrlEncoded.indexOf("!^!") == 0) {
					configuredBodyUrlEncoded = configuredBodyUrlEncoded.substring(3);
				}
			}
			else
			{
				if(rawBody!=null && rawBody!="")
				{
					var rawBodyJson = JSON.parse(rawBody);
					rawJsonBody=JSON.stringify(rawBodyJson);
				}
			}
		}
		
		//rest_output_window.removeAll();
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		for ( var i = 0; i < gridRecordCount; i++) {
			var key = gridObj.getStore().getAt(i).get('key');
			var value = gridObj.getStore().getAt(i).get('value');
			var header=key+"$!$"+value;
			configuredHeaders=configuredHeaders+'!^!'+header;
		}

		var authRequiredObj=Ext.getCmp('User_Authentication_Required');
		//var authReq = authRequiredObj.getChecked();
		//var isAuthRequired = authReq[0].inputValue;
		//console.log('isAuthRequired-->',isAuthRequired)
		if(authRequiredObj.checked)
		{
			var rest_username=Ext.getCmp('rest_username').getValue();
			var password=Ext.getCmp('rest_password').getValue();
			var auth=btoa(rest_username+':'+password);
			var authHeader="Authorization"+"$!$"+"Basic "+auth;
			configuredHeaders=configuredHeaders+'!^!'+authHeader;
		}

		if (configuredHeaders != null && configuredHeaders.indexOf("!^!") == 0) {
			configuredHeaders = configuredHeaders.substring(3);
		}
		var paramGridObj = this.getRESTParamsGrid();
		var paramGridStore = paramGridObj.getStore();
		var configuredParams='';
		var paramGridRecordCount = paramGridStore.getCount();
		for ( var i = 0; i < paramGridRecordCount; i++) {
			var paramKey = paramGridStore.getAt(i).get('key');
			var paramValue = paramGridStore.getAt(i).get('value');
			var params=paramKey+"="+paramValue;
			configuredParams=configuredParams+'&'+params;
		}
		if (configuredParams != null && configuredParams.indexOf("&") == 0) {
			configuredParams = configuredParams.substring(1);
		}

		if (configuredParams != null && configuredParams != "") {
			if (restURL != null && restURL.indexOf("?") >= 0) {
				restURL = restURL.substring(0,restURL.indexOf('?'));
			}
			restURL = restURL+"?"+configuredParams;
			urltextboxObj.setValue(restURL);
		}
		restURL=myDashApp.getController("Main").filterEncode(restURL);
		configuredHeaders=myDashApp.getController("Main").filterEncode(configuredHeaders);
		rawJsonBody=myDashApp.getController("Main").filterEncode(rawJsonBody);
		configuredBodyUrlEncoded=myDashApp.getController("Main").filterEncode(configuredBodyUrlEncoded);
		var paramsForRestURL='restDSNName='+encodeURIComponent(restdsnname)+'&restWS_URL='+encodeURIComponent(restURL)+'&restWS_Port='+encodeURIComponent(restPortNo)+'&httpMethod='+encodeURIComponent(restHttpMethod)+'&widgetId='+encodeURIComponent(widgetId)+'&configuredHeaders='+encodeURIComponent(configuredHeaders)+'&selectedBodyType='+encodeURIComponent(selectedBodyType)+'&rawJsonBody='+encodeURIComponent(rawJsonBody)+'&configuredBodyUrlEncoded='+encodeURIComponent(configuredBodyUrlEncoded)+'&integrationType='+encodeURIComponent(integrationType);//+'&restWS_Fields='+encodeURIComponent(selectedFields)+'&dataFieldParentNode='+encodeURIComponent(dataFieldParentNode);

		 var thisWind = new Ext.LoadMask(restDashMainPnl.getEl(), {
            msg: screenLabelsObj['loadingMsg']
        });
        thisWind.show();
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController?action=loadDataForConfigWindow',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							
							//var hierarchyObjs=flatToHierarchy(jsonData['rawData']);
							//console.log("hierarchyObjs test---->"+hierarchyObjs);
							
							var rootNode = {};
							rootNode["expanded"]="true";
							rootNode["children"]=jsonData['jsonkeys']['restTree'];
							restDashMainPnl.remove('restTreePnl');
							Ext.EventManager.removeAll('restTreePnl');
							restDashMainPnl.remove('restfieldmappingpnl');
							Ext.EventManager.removeAll('restfieldmappingpnl');
							var tabview= Ext.getCmp('dsnConfigCont').hide();
							var dataTypeMapping = {};//jsonData['gridJson']['dataTypeMapping'];
							
							//var restPreviewBtnObj = Ext.getCmp('restPreviewBtn').show();
								
							if(!Ext.isEmpty(rootNode.children))
							{
								 var contArr= new Array();
								 contArr.push({
									xtype: 'treescrollPanel',
									rootVisible: false,
									width:"100 px",
									height:300,
									ui:"newTreePanelWithLines",
									id:'treeP',
									store: Ext.create('Ext.data.TreeStore', {
											root: rootNode
									}),
									restTreeNodeData : jsonData['jsonkeys']['restTreeNodeData'],
									restTreeNodeFields : jsonData['jsonkeys']['resTreeNodefields'],
									listeners:
									{
										select: function (node, record, index, eOpts)
										{
											var fldsArr=[];
											var saveField=Ext.getCmp('saveFldsBtn');
											var restGridData=jsonData['jsonkeys']['restGrid'][record.raw.jPath];
											var gridCols=restGridData['gridCols'];
											var gridData=restGridData['gridData'];
											var colsArr = [];
											var fields2Store = [];
											var filtersArr = [];
											for ( var colVal in gridCols) {
												var colName = gridCols[colVal].toString();
												fields2Store.push({
													name : colName,
													type : 'string'
												});
												var flex1= 0.14;
												colsArr
													.push({
														//header : "<input class='messageCheckbox' type='checkbox' name='header' value='"+colName+"'>"+colName,
														header : "<span class='newFont_normal11 DsWrapText' style='display:block;' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style='margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='"+colName+"' ><span class='labelCheckBOx'></span></label>"+colName+"</span>",
														dataIndex : colName,
														sortable: false,
														flex : 1,
														tdCls: 'DsWrapText',
														cls: 'x-grid-checkheader-editor',
														renderer : function(value, metaData, record, row, col, store, gridView) {
															 var value = '<span class="newFont_normal11 DsWrapText"  data-qtip="' + value + '">' + value + '</span>';
															return value;
														}
															
													});
											}
											var gridObj = Ext.getCmp('restDataGrid');
											gridObj.getStore().removeAll();
											var storeVal1 = Ext.create('Ext.data.Store',{
												fields:fields2Store,
												data:gridData
											});
											gridObj.reconfigure(storeVal1,colsArr);
											gridObj.dataFieldParentNode=record.raw.jPath;
											restDashMainPnl.dataTypeMapping=restGridData['dataTypeMapping'];
											gridObj.show();
											gridObj.view.refresh();
											Ext.getCmp('saveFldsBtn').show();
										}
									}
									
									});
									contArr.push({
											xtype : 'RESTDataGrid',
											//maxheight: 300,
											flex:2.35,
											padding: 0,
											cls:'restGridPreview',
											//scroll:true,
											//autoScroll:true,
											//flex:1,
											
											tdCls: 'DsWrapText',
											margin: 0,			
										id : 'restDataGrid',
										hidden  : false
									});
									restDashMainPnl.add({
														xtype: 'panel',
														title: '<span class="font_bold11" style="text-transform:uppercase;">Data Field Configuration</span>',
														autoScroll: true,
														layout: {
															type: 'hbox',
															align:'stretch'
														},
														margin: '0 20 0 20',
														id: 'restTreePnl',
														ui: 'newTreePanelWithLines hideFolder DsTreePanel',
														cls: 'x-tree-arrows',
														name: 'restTreePnl',
														flex:1,
														items :	contArr,
														dockedItems: [{
																xtype: 'toolbar',
																dock: 'bottom',
																items: ['->',{
																	xtype: 'button',
																	id: 'saveFldsBtn',
																	name: 'saveFldsBtn',
																	margin: '20 0 0 0',
																	width: 106,
																	height: 27,
																	cls: 'button20 restBgButton',
																	text: '<span class="newFont_normal14" style="color:#ffffff;line-height:26px;">Save</span>',
																	//hidden: true,
																	//disabled: true,
																	//iconCls : 'iconSave',
																	tooltip: 'click here to Add',
																},'->']
														}]
															/* tools :[{
																			xtype : 'button',
																			id : 'saveFldsBtn',
																			name : 'saveFldsBtn',
																			text : 'Save',
																			//iconCls : 'iconSave',
																			enabled : true,
																			tooltip : 'click here to save'
																   }]*/
										});
										
							}
							else
							{
								//var parentContObj=Ext.getCmp('containerid');
							//	parentContObj.removeAll();
								restDashMainPnl.add({
									xtype : 'container',
									id:'restEmptyGrid',
									flex:1,
									html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Data Available!</div></div></div>'
								});
							}
							thisWind.hide();
							//	rest_output_window.update('<pre>'+JSON.stringify(jsonData)+'<pre>');
							var rest_output_window=Ext.getCmp('restfieldmappingpnl');
							if(!Ext.isEmpty(rest_output_window))
							{
								rest_output_window.show();
							}
						}
					},
					failure : function(response, opts) {
						
					}
		  });
	},
	enableUserAuthenticationSettings : function(radioGrpObj)
	{
		if(radioGrpObj.checked)
		{
			//alert("===>"+radioGrpObj)
			Ext.getCmp('rest_username').show();
			Ext.getCmp('rest_password').show();
		}
		else
		{
			Ext.getCmp('rest_username').hide();
			Ext.getCmp('rest_password').hide();
		}
	},
	enableHeaderRequiredSettings : function(radioGrpObj)
	{
		
		if(radioGrpObj.checked)
		{
			Ext.getCmp('key').show();
			Ext.getCmp('value').show();
			Ext.getCmp('addHeader').show();
			Ext.getCmp('header_grid').show();
		}
		else
		{
			Ext.getCmp('key').hide();
			Ext.getCmp('value').hide();
			Ext.getCmp('addHeader').hide();
			Ext.getCmp('header_grid').hide();
		}
	},
	enableParamsRequiredSettings : function(radioGrpObj)
	{
		
		if(radioGrpObj.checked)
		{
			Ext.getCmp('param_key').show();
			Ext.getCmp('param_value').show();
			Ext.getCmp('addParam').show();
			Ext.getCmp('param_grid').show();
		}
		else
		{
			Ext.getCmp('param_key').hide();
			Ext.getCmp('param_value').hide();
			Ext.getCmp('addParam').hide();
			Ext.getCmp('param_grid').hide();
		}
	},
	body_typeSettings : function(radioGrpObj)
	{
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		if(body_name!=null && body_name=="x-www-form-urlencoded")
		{
			Ext.getCmp('rawJsonBody').hide();
			Ext.getCmp('body_urlencoded_key').show();
			Ext.getCmp('body_urlencoded_value').show();
			Ext.getCmp('addBody_urlencoded').show();
			Ext.getCmp('bodyUrlEncodedGrid').show();
			
		}
		else 
		{
			Ext.getCmp('rawJsonBody').show();
			Ext.getCmp('body_urlencoded_key').hide();
			Ext.getCmp('body_urlencoded_value').hide();
			Ext.getCmp('addBody_urlencoded').hide();
			Ext.getCmp('bodyUrlEncodedGrid').hide();
		}
		
	},
	restPreviewBtn: function() {
		 var restDashMainPnl = Ext.getCmp('dsnSettingspopup');

		
		 var restTreePnl=Ext.getCmp('restTreePnl');
		 if(!Ext.isEmpty(restTreePnl))
		 {
			 Ext.getCmp('restTreePnl').hide();
			 Ext.getCmp('saveFldsBtn').hide();
			
		 }
		 var restEmptyGrid=Ext.getCmp('restEmptyGrid');
			if(!Ext.isEmpty(restEmptyGrid)){
				Ext.getCmp('restEmptyGrid').hide();
			}
		  
		 var restPreviewBtnObj = Ext.getCmp('restPreviewBtnBox').hide();
		 if(restPreviewBtnObj){
			//alert("restpreview");
		 }
		 
		 Ext.getCmp('containerid').show();
		 Ext.getCmp('dsnConfigCont').show();		 
		  Ext.getCmp('restdsnname').show();
		 Ext.getCmp('DsintegrateText').show();
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab =  tabPanelBoxobj.setActiveTab(0); 
		var integrationType = activeTab.id;
		//this.enableHeaderRequiredSettings();
		 
		// Ext.getCmp('dsBackContainer').show();
		
		 
		 
		
		Ext.getCmp('tabPanelBox').show();

		
	},
	sqlPreviewBtn: function() {
		 var restDashMainPnl = Ext.getCmp('dsnSettingspopup');
		restDashMainPnl.remove('restTreePnl');
		 Ext.EventManager.removeAll('restTreePnl');
		 Ext.getCmp('sqlPreviewBox').hide();
		 //Ext.getCmp('sqlPreviewBtnBox').hide();
		 //Ext.getCmp('sqlSaveButton').hide();
		 //Ext.getCmp('sqlData_grid').hide();
		
		 var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		 tabPanelBoxobj.setActiveTab(1);
		 Ext.getCmp('containerid').show();
		 Ext.getCmp('dsnConfigCont').show();		 
		  Ext.getCmp('restdsnname').show();
		 Ext.getCmp('DsintegrateText').show();
		tabPanelBoxobj.show();

		
	},
	dataSourceChange : function()
	{
		var restDashMainPnl=this.getAddexternalmetrics();
		var addMetricsObj = '';
		var widgetId=restDashMainPnl.widgetID;
		var widgetType=restDashMainPnl.widgetType;
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var dsName =  Ext.getCmp('Data_Source').getValue();
		var paramsForRestURL='dataSourceName='+encodeURIComponent(dsName)+'&action=loadDataSourceFields'+'&widgetId='+encodeURIComponent(widgetId)+'&selectedWidgetType='+encodeURIComponent(widgetType);
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RESTIntegrationController',
			method : 'POST',
			params : paramsForRestURL,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') 
				{
					var jsonData=Ext.decode(jsonText);
					var widgetAttrsOptions=jsonData['widgetAttrsJson']['widgetAttrsOptions'];
					var dataFieldsOpts=jsonData['dataFieldsOpts'];
					if(!Ext.isEmpty(widgetAttrsOptions))
					{
						for(var widA in widgetAttrsOptions)
						{
							var widAttrOpt=widgetAttrsOptions[widA];
							var dispLbl=widAttrOpt['displayField'];
							var valLbl=widAttrOpt['valueField'];
							var UI_Control=widAttrOpt['UI_Control'];
							var combDataArr=[];
							if(widAttrOpt!=null && widAttrOpt.hasOwnProperty('options'))
							{
								combDataArr=widAttrOpt['options'];
							}
							if(Ext.isEmpty(combDataArr))
							{
								combDataArr=dataFieldsOpts;
							}
							if(valLbl!=null && valLbl!='Data_Source' && valLbl!='Measure_Data')
							{
								var comObj =  Ext.getCmp(valLbl);
								var comStore = comObj.getStore();
								comStore.removeAll();
								comStore.add(combDataArr);
								comObj.setValue(combDataArr[0]['valueField']);
								//comStore.add(combDataArr);
							}
							else if(valLbl=='Measure_Data')
							{
								var comObj =  Ext.getCmp(valLbl);
								var comStore = comObj.getStore();
								comObj.setValue('type');
							}
						}
					}
				}
			}
		});

	},
	saveAddExternalMetrics : function()
	{
		return saveAddExternalMetrics(false,'');
	},
	saveAddExternalMetrics : function(isWidgetPreviewMode,previewImageContainer)
	{
		var meC=this;
		var validationResult=true;//this.measureFieldValidation();
		if(validationResult)
		{
		var restDashMainPnl=this.getAddexternalmetrics();
		var addMetricsObj = '';
		//var restDashMainPnl=Ext.getCmp('externalMetrics');

		//var widgetTypeCombo=Ext.getCmp('widgetTypeCombo');
		//var rest_output_window=Ext.getCmp('restfieldmappingpnl');
		var widgetId=restDashMainPnl.widgetID;
		var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var useExternalDataObj =  Ext.getCmp('useExternalData');
		var useExternalData = useExternalDataObj.getValue();
		if(!Ext.isEmpty(useExternalData) && useExternalData == true)
		{
			useExternalData = 'yes';
		}
		else
		{
			useExternalData = 'no';
		}
		var selectedWidTyp=restDashMainPnl.widgetType;
		var dataSource=Ext.getCmp('Data_Source').getValue();
	
		if(!isWidgetPreviewMode && (dataSource==null || dataSource=='-1'))
		{
			Ext.Msg.show({
				title: 'Widget Type Configuration',
				msg: 'Please Choose a Data Source!',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
			return;
		}
		var addMetricsObj = myDashApp.getController("WidgetConfigurationController").getWidgetConfigurationWindowObj();
		if(!isWidgetPreviewMode && (selectedWidTyp != null && (selectedWidTyp == 'dialChart' || selectedWidTyp == 'digitalChart' )))
		{
			
			var measureAggregate=Ext.getCmp('Measure_Data').getValue();
			if(measureAggregate==null || measureAggregate=='type')
			{
				Ext.Msg.show({
					title: 'Widget Type Configuration',
					msg: 'Please Choose a Aggregation type!',
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation'
					});
				return;
			}
		}
		var paramsForRestURL='&action=saveRestWidgetConfig'+'&widgetId='+encodeURIComponent(widgetId)+'&dashboardName='+encodeURIComponent(dashboardName)+'&selectedWidgetType='+encodeURIComponent(selectedWidTyp)+'&useExternalData='+encodeURIComponent(useExternalData);
		if(!Ext.isEmpty(restDashMainPnl) && restDashMainPnl.hasOwnProperty('dataFieldsComboIdArr'))
		{
			var selectedWidgetAttrs='';
			var dataFieldsComboIdArr=restDashMainPnl.dataFieldsComboIdArr;
			if(!Ext.isEmpty(dataFieldsComboIdArr))
			{
				for(var didx in dataFieldsComboIdArr)
				{
					var datFieldCombId=dataFieldsComboIdArr[didx];
					var selectedDataFieldVal=Ext.getCmp(datFieldCombId).getValue();
					selectedWidgetAttrs=selectedWidgetAttrs+'!^!'+datFieldCombId+':'+selectedDataFieldVal
				}
			}
		}
		if(selectedWidgetAttrs!=null && selectedWidgetAttrs.indexOf('!^!')>-1)
		{
			selectedWidgetAttrs=selectedWidgetAttrs.substring(selectedWidgetAttrs.indexOf('!^!')+3,selectedWidgetAttrs.length);
		}
		selectedWidgetAttrs=myDashApp.getController("Main").filterEncode(selectedWidgetAttrs);
		paramsForRestURL=paramsForRestURL+'&selectedWidgetAttrs='+encodeURIComponent(selectedWidgetAttrs);
		var gridStackObj=myDashApp.getController("WidgetConfigurationController").getGSPanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForRestURL=paramsForRestURL+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridSterObj=null;
		delete gridSterObj;
		var settingsCtrlArr=restDashMainPnl.widgetSettingsJsonArr;
		if(!Ext.isEmpty(settingsCtrlArr))
		{
			var widgetSettingsParam='';
			for(var setObj in  settingsCtrlArr)
			{
				var settingOptObj=settingsCtrlArr[setObj];
				widgetSettingsParam+="!^!"+meC.getSettingValue(settingOptObj);

			}
		}
		if(widgetSettingsParam!=null && widgetSettingsParam.indexOf('!^!')>-1)
		{
			widgetSettingsParam=widgetSettingsParam.substring(widgetSettingsParam.indexOf('!^!')+3,widgetSettingsParam.length);
		}
		widgetSettingsParam=myDashApp.getController("Main").filterEncode(widgetSettingsParam);
		paramsForRestURL=paramsForRestURL+'&widgetSettingsParams='+encodeURIComponent(widgetSettingsParam);

		var configPanl = null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
			paramsForRestURL=paramsForRestURL+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		else
		{
			addMetricsObj.close();
			configPanl=Ext.getCmp(widgetId);
		}
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							var updateBxId=widgetId;
							if(isWidgetPreviewMode)
							{
								updateBxId=widgetId+"_previewImage";
							}
							configPanl.isConfigured=true;
							configPanl.isExternalDataSourceWidget=true;
							this.showExternalDataForBlock(jsonData, configPanl, updateBxId);
							//this.showLiveDataForBlock(jsonData, configPanl, widgetId);
							//console.log("After update click--json--->>",jsonData);
						}
					}
		});
		}

	},

	saveAddExternalMetricsForKPI : function()
	{
		return saveAddExternalMetricsForKPI(false,'');
	},
	saveAddExternalMetricsForKPI : function(isWidgetPreviewMode,previewImageContainer)
	{
		var meC=this;
		var validationResult=true;//this.measureFieldValidation();
		if(validationResult)
		{
		var restDashMainPnl=this.getAddexternalmetrics();
		var addMetricsObj = '';

		var widgetId=restDashMainPnl.widgetID;
		var isKpi = restDashMainPnl.isKpi;
		var Kpicount = restDashMainPnl.Kpicount;
		var totalKpiCount = restDashMainPnl.totalKpiCount;
		var blockId = '';
		var kpiBlckId = '';
		if(restDashMainPnl.isKpi==true)
		{
			
			kpiBlckId = restDashMainPnl.kpiBlckId;
			blockId = kpiBlckId+'_'+widgetId;
		}
		var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var useExternalDataObj =  Ext.getCmp('useExternalData');
		var useExternalData = useExternalDataObj.getValue();
		if(!Ext.isEmpty(useExternalData) && useExternalData == true)
		{
			useExternalData = 'yes';
		}
		else
		{
			useExternalData = 'no';
		}
		var selectedWidTyp=restDashMainPnl.widgetType;
		var dataSource=Ext.getCmp('Data_Source').getValue();
	
		if(!isWidgetPreviewMode && (dataSource==null || dataSource=='-1'))
		{
			Ext.Msg.show({
				title: 'Widget Type Configuration',
				msg: 'Please Choose a Data Source!',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
			return;
		}
		var addMetricsObj = myDashApp.getController("WidgetConfigurationController").getWidgetConfigurationWindowObj();
		if(!isWidgetPreviewMode && (selectedWidTyp != null && (selectedWidTyp == 'dialChart' || selectedWidTyp == 'digitalChart' )))
		{
			
			var measureAggregate=Ext.getCmp('Measure_Data').getValue();
			if(measureAggregate==null || measureAggregate=='type')
			{
				Ext.Msg.show({
					title: 'Widget Type Configuration',
					msg: 'Please Choose a Aggregation type!',
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation'
					});
				return;
			}
		}
		var paramsForRestURL='&action=saveRestWidgetConfigForKpi'+'&widgetId='+encodeURIComponent(widgetId)+'&dashboardName='+encodeURIComponent(dashboardName)+'&selectedWidgetType='+encodeURIComponent(selectedWidTyp)+'&useExternalData='+encodeURIComponent(useExternalData)+'&blockId='+blockId+'&KpiWidgetCount='+totalKpiCount;
		if(!Ext.isEmpty(restDashMainPnl) && restDashMainPnl.hasOwnProperty('dataFieldsComboIdArr'))
		{
			var selectedWidgetAttrs='';
			var dataFieldsComboIdArr=restDashMainPnl.dataFieldsComboIdArr;
			if(!Ext.isEmpty(dataFieldsComboIdArr))
			{
				for(var didx in dataFieldsComboIdArr)
				{
					var datFieldCombId=dataFieldsComboIdArr[didx];
					var selectedDataFieldVal=Ext.getCmp(datFieldCombId).getValue();
					selectedWidgetAttrs=selectedWidgetAttrs+'!^!'+datFieldCombId+':'+selectedDataFieldVal
				}
			}
		}
		if(selectedWidgetAttrs!=null && selectedWidgetAttrs.indexOf('!^!')>-1)
		{
			selectedWidgetAttrs=selectedWidgetAttrs.substring(selectedWidgetAttrs.indexOf('!^!')+3,selectedWidgetAttrs.length);
		}
		selectedWidgetAttrs=myDashApp.getController("Main").filterEncode(selectedWidgetAttrs);
		paramsForRestURL=paramsForRestURL+'&selectedWidgetAttrs='+encodeURIComponent(selectedWidgetAttrs);
		var gridStackObj=myDashApp.getController("WidgetConfigurationController").getGSPanel();
		var posStrVal=gridStackObj._serializationStr();
		if(posStrVal!=null && posStrVal!='')
		{
			paramsForRestURL=paramsForRestURL+'&layoutConfig='+encodeURIComponent(posStrVal);
		}
		gridSterObj=null;
		delete gridSterObj;
		var settingsCtrlArr=restDashMainPnl.widgetSettingsJsonArr;
		if(!Ext.isEmpty(settingsCtrlArr))
		{
			var widgetSettingsParam='';
			for(var setObj in  settingsCtrlArr)
			{
				var settingOptObj=settingsCtrlArr[setObj];
				widgetSettingsParam+="!^!"+meC.getSettingValue(settingOptObj);

			}
		}
		if(widgetSettingsParam!=null && widgetSettingsParam.indexOf('!^!')>-1)
		{
			widgetSettingsParam=widgetSettingsParam.substring(widgetSettingsParam.indexOf('!^!')+3,widgetSettingsParam.length);
		}
		widgetSettingsParam=myDashApp.getController("Main").filterEncode(widgetSettingsParam);
		paramsForRestURL=paramsForRestURL+'&widgetSettingsParams='+encodeURIComponent(widgetSettingsParam);


		var configPanl = null;
		if(isWidgetPreviewMode)
		{
			configPanl=previewImageContainer;
			paramsForRestURL=paramsForRestURL+"&widgetPreviewMode=yes";
			configPanl.setLoading(true, true);
			configPanl.showLoadingMsg=true;
		}
		else
		{
			addMetricsObj.close();
			configPanl=Ext.getCmp(widgetId);
		}
			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							if(!isWidgetPreviewMode)
							{
								var win = Ext.widget('kpiConfigurationWindow', {
									blockId : kpiBlckId,
									blckType : 'KpiWidget',
									isFluidWindowConfigPopup : true,
									isConfigured:true,
									count:Kpicount
								});
							
								if (win != null) {
									win.setTitle('KPI Configuration');
									win.show();
								}							
							}
						}
					}
			});
		}

	},

	getSettingValue : function(filter){
			var settingVal='';
			switch(filter.ControlType){
				case "colorpalette":
								var palette=Ext.get('PaletteId').getValue();
								settingVal=filter.internalName+":"+palette;
								break;
				case "combo": 
							  settingVal=filter.internalName+":"+Ext.getCmp(filter.internalName).getValue();
								break;
				case "Checkbox": 
							var chkboxObjArr=filter['options']['optsArr'];
							for(var chkboxIdx in chkboxObjArr)
							{
								var chkBxObj=chkboxObjArr[chkboxIdx];
								settingVal+="!^!"+chkBxObj+":"+Ext.getCmp(chkBxObj).getValue();
							}
								break;
				case "ToggleBtnSelector": 
								var colorPaletteObj=Ext.getCmp(filter.internalName).getValue();
								var colorPalette=colorPaletteObj.ColorPickerOpt;
								if(colorPalette!=null && colorPalette!='')
								{
									settingVal=filter.internalName+":"+colorPalette;
								}
								break;
				case "Switch": 
								var switchVal=Ext.getCmp(filter.internalName).getValue();
								var switchSelectedVal='no';
								if(switchVal!=null && switchVal==true)
								{
									switchSelectedVal='yes';
								}
								settingVal=filter.internalName+":"+switchSelectedVal;
								break;
				case "TextBox": settingVal=filter.internalName+":"+Ext.getCmp(filter.internalName).getValue();
								break;
				case "ImageIcon":
								var templateImageIconObj=$('#dashboardImageIcon');
								if(!Ext.isEmpty(templateImageIconObj))
								{
									var fileName = templateImageIconObj[0].src;
									var imgPath = null;
									if(fileName!=null && fileName.lastIndexOf("/")>0)
									{
										imgPath = fileName.substring(0,fileName.lastIndexOf("/"));
										fileName=fileName.substring(fileName.lastIndexOf("/")+1);
									}
									else if(fileName!=null && fileName.lastIndexOf("\\")>0)
									{
										imgPath = fileName.substring(0,fileName.lastIndexOf("\\"));
										fileName=fileName.substring(fileName.lastIndexOf("\\")+1);
									}
									else
									{
										var digitalChartImgContObj=Ext.getCmp('digitalChartImgCont');					
										fileName =digitalChartImgContObj.iconClass;
									}

									if(fileName!=null)
									{
										if(imgPath!=null && !imgPath.endsWith("/final/images/"+strSkin))
										{
											fileName = "Custom:"+fileName;
											settingVal = "imgIcon:" + fileName;
										}
										else if(imgPath == null)
										{
											fileName = "Default:"+fileName;
											settingVal = "imgIcon:" + fileName;
										}
									}
								}
								break;
			}
			return settingVal;
	},
	saveRESTFields : function()
	{
		var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
		var activeTab =  tabPanelBoxobj.setActiveTab(0); 
		var integrationType = activeTab.id;
		//var RESTConfigContObj=Ext.getCmp('csvExcelConfigCont');		var selectedFields=Ext.getCmp('fieldsMultiSelect').getValue();		var dataFieldParentNode=Ext.getCmp('fieldsMultiSelect').dataFieldParentNode;
		if(selectedFields == null || selectedFields=="")
		{
			Ext.Msg.show({
				title: 'Data Field Configuration',
				msg: 'Please select required Data Field!',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
		}
		else
		{
//var treep = Ext.getCmp('treeP');
//var treepdata = treep.getStore().getCount();
//console.log("treepdata------->>",treepdata);
		var restdsnnameObj=null;
		var dsn_type ='New';
		if(dsn_type!=null && dsn_type=='New'){
			restdsnnameObj=Ext.getCmp('restdsnname');
		}
		else
			restdsnnameObj='';

		var restdsnname=restdsnnameObj.getValue();
		//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var restfieldmappingpnl=Ext.getCmp('restfieldmappingpnl');
		var widgetId=restDashMainPnl.widgetID;
		selectedFields=myDashApp.getController("Main").filterEncode(selectedFields);
		dataFieldParentNode=myDashApp.getController("Main").filterEncode(dataFieldParentNode);
		var paramsForRestURL='restDSNName='+encodeURIComponent(restdsnname)+'&restWS_Fields='+encodeURIComponent(selectedFields)+'&action=saveRESTFields'+'&widgetId='+encodeURIComponent(widgetId)+'&dataFieldParentNode='+encodeURIComponent(dataFieldParentNode);

		Ext.Ajax.request({
				url : '/final/servlet/com.eg.RESTIntegrationController',
				method : 'POST',
				params : paramsForRestURL,
				scope : this,
				success : function(response) {
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('widgetOpts'))
						{
							var widgetsOpt=jsonData['widgetOpts']['comboOpts'];
							var selectedWidgetType=jsonData['widgetOpts']['selectedWidgetType'];
							var widgetTypeComboObj=Ext.getCmp('widgetTypeCombo');
							widgetTypeComboObj.getStore().loadData(widgetsOpt);
							widgetTypeComboObj.setValue(selectedWidgetType);
							widgetTypeComboObj.show();
							restfieldmappingpnl.show();
						}
					}
				}
		});
		}
	},
	addHeader : function()
	{
		var keyobj=Ext.getCmp('key');
		var valueobj=Ext.getCmp('value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var validationResult=this.headerValForm();
		//Ext.getCmp('RESTHeaderGrid').getStore().add(this.up('form').getForm().getValues());
		//Ext.getCmp('gridID').reconfigure(Ext.getCmp('gridID').getStore()) 
		//this.up('form').getForm().reset();
		if(validationResult)
		{
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredData = [];
		configuredData.push({
			key : key,
			value : value
		});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}

	},
	addParam : function()
	{
		var keyobj=Ext.getCmp('param_key');
		var valueobj=Ext.getCmp('param_value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		//var validationResult=this.headerValForm();
		//console.log("validationResult-->",validationResult);
		//Ext.getCmp('RESTHeaderGrid').getStore().add(this.up('form').getForm().getValues());
		//Ext.getCmp('gridID').reconfigure(Ext.getCmp('gridID').getStore()) 
		//this.up('form').getForm().reset();
		if(true)
		{
		var gridObj = this.getRESTParamsGrid();
		var gridStore = gridObj.getStore();
		var configuredData = [];
		configuredData.push({
			key : key,
			value : value
		});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}

	},
	headerValForm : function()
	{
		var keyobj=Ext.getCmp('key');
		var valueobj=Ext.getCmp('value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var splChar = "=\"@()!^;?><:,";
		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Header key required',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Header value required',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
		}
		if(key!="" || key!=null)
		{
		for ( var i = 0; i < key.length; i++) {
			check_char = splChar.indexOf(key.charAt(i))
			// Returns value 1 if the special character listed
			if (check_char >= 0) {
				Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: key+' is not a valid HTTP header field key',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
			}
		}
		}
		return true;
	},
	addBody_urlencoded : function()
	{
		var validationResult=this.bodyValForm();
		if(validationResult)
		{
		var keyobj=Ext.getCmp('body_urlencoded_key');
		var valueobj=Ext.getCmp('body_urlencoded_value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var validationResult=true;//this.headerValForm();
		//Ext.getCmp('RESTHeaderGrid').getStore().add(this.up('form').getForm().getValues());
		//Ext.getCmp('gridID').reconfigure(Ext.getCmp('gridID').getStore()) 
		//this.up('form').getForm().reset();
		if(key!=null && key!="" && value!=null && value!="")
		{
		var gridObj = this.getRESTBodyUrlEncodedGrid();
		var gridStore = gridObj.getStore();
		var configuredData = [];
		configuredData.push({
			key : key,
			value : value
		});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}
		}

	},
	bodyValForm : function()
	{
		var keyobj=Ext.getCmp('body_urlencoded_key');
		var valueobj=Ext.getCmp('body_urlencoded_value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		
		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Body key required',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: 'Body value required',
				buttons: Ext.MessageBox.OK,
				icon: 'iconInformation'
				});
				return false;
		}
		return true;
	},
	integrationChange : function()
	{
			//var integrationType=Ext.getCmp('integration').getValue();
			//console.log("integrationType--->>",integrationType);
			if(integrationType!="" && integrationType=="REST")
			{
				Ext.getCmp('sqlContainer').hide();
				Ext.getCmp('csvExcelConfigCont').hide();
				Ext.getCmp('User_Authentication_Required').show();
				Ext.getCmp('getData').show();
				Ext.getCmp('RESTUrlConfig').show();
				//Ext.getCmp('body_urlencoded_keyContainer').show();
				//Ext.getCmp('body_urlencoded_keyContainer2').show();
				Ext.getCmp('body_type').hide();
				Ext.getCmp('body_urlencoded_key').hide();
				Ext.getCmp('body_urlencoded_value').hide();
				Ext.getCmp('addBody_urlencoded').hide();
				Ext.getCmp('bodyUrlEncodedGrid').hide();
				var httpMethod=Ext.getCmp('restHttpMethod');
				httpMethod.setValue('GET');
				httpMethod.show();
				var urltextbox=Ext.getCmp('urltextbox');
				urltextbox.reset();
				urltextbox.show();
				var rawJsonBody = Ext.getCmp('rawJsonBody');
				rawJsonBody.reset();
				rawJsonBody.hide();
				var gridObj=Ext.getCmp('bodyUrlEncodedGrid');
				var gridStore = gridObj.getStore();
				gridStore.removeAll();
				var viewTypeOptObj = Ext.getCmp('Header_Required');
				viewTypeOptObj.suspendEvents(false);
				viewTypeOptObj.setValue({
				 header_req: 'no'
				 });
				viewTypeOptObj.show();

				var gridObj=Ext.getCmp('header_grid');
				var gridStore = gridObj.getStore();
				gridStore.removeAll();

				var params_Required = Ext.getCmp('params_Required');
				params_Required.suspendEvents(false);
				params_Required.setValue({
				 Params_req: 'no'
				 });
				viewTypeOptObj.show();

				var paramgridObj=Ext.getCmp('param_grid');
				var paramgridStore = paramgridObj.getStore();
				paramgridStore.removeAll();
			}
			if(integrationType!="" && integrationType=="SQL")
			{
				Ext.getCmp('urltextbox').hide();
				Ext.getCmp('restHttpMethod').hide();
				Ext.getCmp('User_Authentication_Required').hide();
				Ext.getCmp('getData').hide();
				Ext.getCmp('fileUploadForm').hide();
				Ext.getCmp('csvExcelConfigCont').hide();
				Ext.getCmp('RESTUrlConfig').hide();
				Ext.getCmp('sqlContainer').show();
				Ext.getCmp('dbType').reset();
				Ext.getCmp('executeQueryContainer').hide();
				Ext.getCmp('sqlAttrContainer').hide();
				//Ext.getCmp('saveSql').hide();
				//Ext.getCmp('sqlData_grid').hide();
				Ext.getCmp('sqlPreviewBox').hide();
				var restTree=Ext.getCmp('restTreePnl');
				if(!Ext.isEmpty(restTree))
				{
					restTree.hide();
				}
				
				//Ext.getCmp('sqlquery').show();
			}
			if(integrationType!="" && integrationType=="EXCEL")
			{
				Ext.getCmp('urltextbox').hide();
				Ext.getCmp('restHttpMethod').hide();
				Ext.getCmp('User_Authentication_Required').hide();
				Ext.getCmp('getData').hide();
				//Ext.getCmp('sqlquery').hide();
				Ext.getCmp('fileupload_gridExcel').hide();
				Ext.getCmp('csvSaveButton').hide();
				Ext.getCmp('saveCsv').hide();
				Ext.getCmp('rowSelector').hide();
				Ext.getCmp('sqlContainer').hide();
				Ext.getCmp('RESTUrlConfig').hide();
				Ext.getCmp('fileUploadForm').show();
				Ext.getCmp('csvExcelConfigCont').show();
				var restTree=Ext.getCmp('restTreePnl');
				if(!Ext.isEmpty(restTree))
				{
					restTree.hide();
				}
			}
			if(integrationType!="" && integrationType=="CSV")
			{
				
				Ext.getCmp('sqlContainer').hide();
				Ext.getCmp('fileupload_gridCsv').hide();
				Ext.getCmp('csvSaveButton').hide();
				Ext.getCmp('saveCsv').hide();
				Ext.getCmp('rowSelector').hide();
				Ext.getCmp('RESTUrlConfig').hide();
				Ext.getCmp('fileUploadForm').show();
				Ext.getCmp('csvExcelConfigCont').show();
				var restTree=Ext.getCmp('restTreePnl');
				if(!Ext.isEmpty(restTree))
				{
					restTree.hide();
				}
			
			}
	},
	restHttpMethodChange : function()
	{
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		if(restHttpMethod!="" && restHttpMethod=="GET")
		{
			Ext.getCmp('body_type').hide();
			Ext.getCmp('rawJsonBody').hide();
			Ext.getCmp('body_urlencoded_key').hide();
			Ext.getCmp('body_urlencoded_value').hide();
			Ext.getCmp('addBody_urlencoded').hide();
			Ext.getCmp('bodyUrlEncodedGrid').hide();
		}
		if(restHttpMethod!="" && restHttpMethod=="POST")
		{
			Ext.getCmp('body_type').show();
			var radioGrpObj=Ext.getCmp('body_type');
			var body_typeObj = radioGrpObj.getChecked();
			var body_name = body_typeObj[0].inputValue;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				Ext.getCmp('rawJsonBody').hide();
				Ext.getCmp('body_urlencoded_key').show();
				Ext.getCmp('body_urlencoded_value').show();
				Ext.getCmp('addBody_urlencoded').show();
				Ext.getCmp('bodyUrlEncodedGrid').show();
				
			}
			else 
			{
				Ext.getCmp('rawJsonBody').show();
				Ext.getCmp('body_urlencoded_key').hide();
				Ext.getCmp('body_urlencoded_value').hide();
				Ext.getCmp('addBody_urlencoded').hide();
				Ext.getCmp('bodyUrlEncodedGrid').hide();
			}
		}
	},
	loadRESTWidgetOptions : function()
	{
		
			var RESTConfigContObj=Ext.getCmp('csvExcelConfigCont');
			//var selectedFields=Ext.getCmp('fieldsMultiSelect').getValue();
			//var restdsnnameObj=Ext.getCmp('restdsnname');
			//var restdsnname=restdsnnameObj.getValue();
			//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
			//var restDashMainPnl=Ext.getCmp('restwidgetsettings');
			var restDashMainPnl=Ext.getCmp('restDashWidgetSettings');
			var widgetId=restDashMainPnl.widgetID;
			//var widgetId='RESTAPIWidget';
			var widgetType=Ext.getCmp('widgetTypeCombo').getValue();


			var paramsForRestURL='restDSNName='+encodeURIComponent('')+'&action=loadWidgetOptions'+'&widgetId='+encodeURIComponent(widgetId)+'&selectedWidgetType='+encodeURIComponent(widgetType);

			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {

							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var jsonData=Ext.decode(jsonText);
								var widgetChartAttrsContObj=Ext.getCmp('widgetChartAttrsCont');
								if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('widgetAttrsJson'))
								{
									var widgetAttrsOptions=jsonData['widgetAttrsJson']['widgetAttrsOptions'];
									var selectedWidgetAttrValsJson=jsonData['widgetAttrsJson']['selectedWidgetAttrValsJson'];
									var dataFieldsOpts=[];
									if(jsonData.hasOwnProperty('dataFieldsOpts'))
									{
										dataFieldsOpts=jsonData['dataFieldsOpts'];
									}
									if(!Ext.isEmpty(widgetAttrsOptions))
									{
										widgetChartAttrsContObj.removeAll();
										var fieldsComboArr=[];
										var firstWidgetAttr=dataFieldsOpts[0];
										var defaultDataFieldVal=firstWidgetAttr['valueField'];
										var widgetAtrrsComboIds=[];
										for(var widA in widgetAttrsOptions)
										{
											var widAttrOpt=widgetAttrsOptions[widA];
											var dispLbl=widAttrOpt['displayField'];
											var valLbl=widAttrOpt['valueField'];
											var UI_Control=widAttrOpt['UI_Control'];

											var selectedDataField=defaultDataFieldVal;
										
											if(!Ext.isEmpty(selectedWidgetAttrValsJson) && selectedWidgetAttrValsJson.hasOwnProperty(valLbl))
											{
												//selectedDataField=selectedWidgetAttrValsJson[valLbl];
											}
											widgetAtrrsComboIds.push(valLbl);
											if(UI_Control!=null && UI_Control=='combo')
											{
												if(valLbl!=null && valLbl=='Widget_Title')
												{
													fieldsComboArr.push({
													xtype : 'combo',
													cls: 'dropdown',
													fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
													id: valLbl,
													name: valLbl,
													width: 280,
													margin:'0 0 17 10',
													store: Ext.create('Ext.data.Store', {
														fields: ['displayField', 'valueField'],
														data: dataFieldsOpts
													}),
													editable: true,
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													value : selectedDataField
												});
												}
												else if(valLbl!=null && valLbl=='Measure_Data')
												{
													fieldsComboArr.push({
													xtype : 'combo',
													cls: 'dropdown',
													fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
													id: valLbl,
													name: valLbl,
													width: 280,
													margin:'0 0 17 0',
													store: Ext.create('Ext.data.Store', {
														fields: ['displayField', 'valueField'],
														data: [
															{displayField: 'Please choose aggregate type', valueField: 'type'},
															{displayField: 'Sum', valueField: 'sum'},
															{displayField: 'Average', valueField: 'average'},
															{displayField: 'Count', valueField: 'count'},
															{displayField: 'Minimum', valueField: 'Minimum'},
															{displayField: 'Maximum', valueField: 'maximum'},
															]
													}),
													editable: false,
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													value : 'type'
													});
												}
												else
												{
												fieldsComboArr.push({
													xtype : 'combo',
													cls: 'dropdown',
													fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
													id: valLbl,
													name: valLbl,
													width: 280,
													margin:'0 0 17 0',
													store: Ext.create('Ext.data.Store', {
														fields: ['displayField', 'valueField'],
														data: dataFieldsOpts
													}),
													editable: false,
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													value : selectedDataField
												});
												}
											}
											else if(UI_Control!=null && UI_Control=='multiselect')
											{
												fieldsComboArr.push(	{
																xtype : 'multiselect',
																width: 280,
																margin:'0 0 17 10',
																height : 50,
															//	layout : 'fit',
																border : 0,
																// msgTarget: 'side',
																autoScroll : true,
																scroll : true,
																labelAlign : 'left',
																// height:50,
																baseCls : 'egmultiselect',
																multiSelect : true,
																fieldLabel: '<span class="newFont_normal12">'+dispLbl+'</span>',
																id : valLbl,
																name : valLbl,
																// value: '',
																store :  Ext.create('Ext.data.Store', {
																	fields: ['displayField', 'valueField'],
																	data: dataFieldsOpts
																}),
																value : selectedDataField,
																displayField : 'displayField',
																valueField : 'valueField',
																queryMode : 'local'
												});
											}
										}
										widgetChartAttrsContObj.add(fieldsComboArr);
										widgetChartAttrsContObj.show();
										Ext.getCmp('addRestWidget').show();
									}
									restDashMainPnl.dataFieldsComboIdArr=widgetAtrrsComboIds;
								}
							}
					}
				});
		
	},
	showExternalDataForBlock : function(jsonData, configPanl, widgetID) {
		configPanl.destoryChart();
		configPanl.hideLoadingMask();
		configPanl.suspendEvents(true);
		//configPanl.removeAll();
		Ext.EventManager.removeAll(widgetID+'_chart');
		var meC = this;
		var widgetType = widgetID;
		if (widgetID != null && widgetID.indexOf("_") > 0) {
			widgetType = widgetID.substr(0, widgetID.indexOf("_"));
		}
		if(configPanl.rendered){
			//configPanl.setTitle(jsonData['tableTitle']);
			if(jsonData!=null && jsonData.hasOwnProperty('tableTitle'))
			{
				configPanl.porletSetTitle(jsonData['tableTitle']);
			}
			else if(jsonData!=null && jsonData.hasOwnProperty('title'))
			{
				configPanl.porletSetTitle(jsonData['title']);
			}
		}
		var confPanlHei = configPanl.getHeight() - 35;
		var confPanlWid = configPanl.getWidth();
		if(widgetType!=null && widgetType=='digitalChart')
		{
			var errorMsg = jsonData['errMsg'];
			if (errorMsg == "-")		
			{
				errorMsg = jsonData['widgetJsonData']['errorMsg'];
			}
			if (errorMsg == "-")		
			{
				var isSummaryWidget=jsonData['widgetJsonData']['isSummaryWidget'];
				var digChartCont=Ext.getCmp(widgetID+'_chart');
				if(!Ext.isEmpty(digChartCont))
				{
					digChartCont.removeAll();
				}
				configPanl.remove(widgetID+'_scwid');
				configPanl.removeAll();
				
				if(isSummaryWidget!=null && isSummaryWidget=='yes')
				{
					var displayTitle=jsonData['widgetJsonData']['tableTitle'];
					configPanl.porletSetTitle(displayTitle);
					configPanl.add(
					{
						xtype : 'summarywidget',
						id : widgetID+'_summaryWidgetCont',
						chartID: widgetID+'_scwid',
						chartType:'',
						useStateColorForFonts :'no',
						fontColor:jsonData['widgetJsonData']['summaryWidgetData'][0]['fontColor'],
					//	resizeFont:resizeFont,
						chartData : jsonData['widgetJsonData']['summaryWidgetData'],
						measureValue : jsonData['widgetJsonData']['summaryWidgetData'][0]['value'],
						gridStackPnlWid : configPanl.getWidth(),
						gridStackPnlHei : configPanl.getHeight(),
						toolTipText : '',
						showToolTip:true
					});
					if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('widgetJsonData'))
					{
						if(!Ext.isEmpty(jsonData.summaryWidgetData) && jsonData.hasOwnProperty('summaryWidgetData'))
						{
							configPanl.measureValue=jsonData['widgetJsonData']['summaryWidgetData'][0]['value'];
						}
					}
				}
				else
				{
					var valColor = (strSkin == 'Light')?"#000000":'#999999';
					var measureValue = jsonData['widgetJsonData']['measureValue'];
					var unitForMeas = jsonData['widgetJsonData']['Unit'];
					var displayTitle=jsonData['widgetJsonData']['tableTitle'];
					configPanl.porletSetTitle(displayTitle); 
					confPanlHei = configPanl.getHeight() - 105;
					configPanl.layerModelUrl = jsonData['widgetJsonData']['layerTesturl'];
					var temp_split = configPanl.id.split('_')[1];
					var digtalChartHtml='<div style="height:100%;width:100%;display:table"><div style="text-align:center;margin-top:40px;vertical-align:middle;display:table-cell;cursor:pointer" onclick="javascript:dialOnClick(\''+configPanl.id+'\');"><h1 style="line-height:90px;font-family:digital-7regular;font-size:70px;font-weight:normal;color:#35c8c2" id="dgChart_'+temp_split+'" class="count">'+measureValue+'</h1><div>';
					if(unitForMeas!=null && unitForMeas!='')
					{
						digtalChartHtml=digtalChartHtml+'('+unitForMeas+')</div></div>';
					}
					digtalChartHtml=digtalChartHtml+'</div>';

					configPanl.add({
						xtype : 'container',
						id : widgetID + '_chart',
						margin : '0 0 0 0',
						flex : 1,
						height : confPanlHei,
						listeners : {
							'afterrender' : function(c) {
								try {
									this.update(digtalChartHtml);
									configPanl.digital_chart = digtalChartHtml;

								} catch (fusnChrtExcp) {
									if (Ext.isChrome) {
										console.log(fusnChrtExcp);
									}
								}
							}
						}
					});
					//configPanl.update(digtalChartHtml);
					configPanl.isHighChartUpdate = true;
				}
			}
			else {
				var configPanlHeight = configPanl.getHeight() - 40;
				configPanl.isHighChartUpdate=false;
				
				configPanl.add({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
							+ '!</div></div></div>'
				});
			}
		}
		else if(widgetType!=null && widgetType=='dialChart')
		{
			var errorMsg = jsonData['errMsg'];
			if (errorMsg == "-")		
			{
				errorMsg = jsonData['widgetJsonData']['errorMsg'];
			}
			//var widgetErrorMsg = jsonData['widgetJsonData']['errorMsg'];
			var thisController = this;
			
			if (errorMsg == "-") {
				var gaugeChartJsonData=jsonData['widgetJsonData'];
				configPanl.isHighChartUpdate=true;
				configPanl.add({
					xtype : 'container',
					id : widgetID + '_chart',
					margin : '0 0 0 0',
					flex : 1,
					height : confPanlHei,
					listeners : {
						'afterrender' : function(c) {
							try {

									var prevButtonObj = Ext.getCmp('prevButton');
									var nextButtonObj = Ext.getCmp('nextButton');
									if(!Ext.isEmpty(prevButtonObj) && !Ext.isEmpty(nextButtonObj))
									{
										prevButtonObj.setDisabled(true);
										nextButtonObj.setDisabled(true);
									}

									var width =  $('#'+configPanl.id)[0].offsetWidth;
									var height  =  $('#'+configPanl.id)[0].offsetHeight-20;
									var gaugeChartObj = {};
									var displayTitle=jsonData['widgetJsonData']['tableTitle'];
									configPanl.porletSetTitle(displayTitle); 
									//gaugeChartObj = jQuery.extend(true, {}, getGuageChartsForMyDashboard(c.id, 'myDashboard',(configPanl.getWidth()-10),(confPanlHei-10)), gaugeChartObj);
									gaugeChartObj = jQuery.extend(true, {}, getGuageChartsForMyDashboard(c.id, 'myDashboard',width,height,function(){
										thisController.loadNextPreviewButtons();
									}), gaugeChartObj);
									gaugeChartObj.setData(gaugeChartJsonData);
									gaugeChartObj.drawChart();
									configPanl.highChartObj = gaugeChartObj;
									gaugeChartObj=null;
									delete gaugeChartObj;
								
							} catch (fusnChrtExcp) {
								if (Ext.isChrome) {
									console.log(fusnChrtExcp);
								}
							}
						}
					}
				});
				highcharts=null;
				delete highcharts;
			} else {
				var configPanlHeight = configPanl.getHeight() - 40;
				configPanl.isHighChartUpdate=false;
				
				configPanl.add({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
							+ '!</div></div></div>'
				});
			}
		}
		else if(widgetType!=null && widgetType=='table')
		{
			configPanl.setAutoScroll(true);
			var grdObj=Ext.getCmp(widgetID+'_Grid');
			if(!Ext.isEmpty(grdObj))
			{
				Ext.EventManager.removeAll(grdObj);
			}
			grdObj=null;
			delete grdObj;
			var errorMsg = jsonData['errMsg'];
			if (errorMsg != null && errorMsg == "-") {
				var tableGridHeight = configPanl.getHeight();
				if(configPanl.rendered){
				//configPanl.setTitle(jsonData['tableTitle']);
			//	configPanl.porletSetTitle(jsonData['widgetJsonData']['Widget_Title']);
				}
				var viewDashLayoutObj = Ext.getCmp('dashboardLayoutObj');
				var profName = viewDashLayoutObj.profileName;
				var gridCols = jsonData['widgetJsonData']['gridCols'];
				var gridData = jsonData['widgetJsonData']['gridData'];
				var colsArr = [];
				var fields2Store = [];
				var widthForEachColumn = 105;
				var displayTitle=jsonData['widgetJsonData']['tableTitle'];
				configPanl.porletSetTitle(displayTitle); 
				for ( var colVal in gridCols) {
					var colName = gridCols[colVal];
					if(!Ext.isEmpty(colName) && typeof colName !== 'string')
					{
						continue;
					}

					var dispColumn = '';
					if (colName != null && colName.indexOf("|DOT|")>-1)
					{
						dispColumn=colName.replace('|DOT|','.');
					}
					else
					{
						dispColumn=colName;
					}					

					fields2Store.push({
						name : colName,
						type : 'FLOATORSTRING'
					});
					var flex1= 0.14;
						colsArr
							.push({
								header : dispColumn,
								dataIndex : colName,
								flex : flex1,
								tdCls : 'gridCellWrap',
								renderer : function(value, metaData, record, row, col, store, gridView) {
									return value;
								}
							});
				
				}
				if(configPanl.rendered){
				configPanl.add({
					xtype : 'grid',
					menuDisabled : true,
					enableColumnHide : true,
					margin : 0,
					width : configPanl.getWidth() - 15,
					height : tableGridHeight - 20,
					store : Ext.data.Store({
						fields : fields2Store,
						data : gridData
					}),
					stateId : 'RESTWidget_data_' + widgetID,
					stateful : true,
					border : false,
					autoScroll : true,
					stripeRows : false,
					ui:'newGridPanel mydashboard_grid',
					//cls : 'gridSkin',
					layout : 'fit',
					flex : 1,
					shrinkWrap : 0,
					columns : colsArr,
					viewConfig : {
						forceFit : true
					},
					emptyText : '<table width="100%" height="10px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconNoalarms"></div><div styel="margin:10px auto">'+ noAlarmFound +'</div></td></tr></table>',
					id : widgetID+'_Grid'
				});
				}
				gridData=null;
				delete gridData;
			} else {
				

				/*configPanl.hideLoadingMask();
				var configPanlHeight = configPanl.getHeight() - 40;
				configPanl.destoryChart();
				configPanl.add({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
							+ '!</div></div></div>'
				});*/
				var configPanlHeight = configPanl.getHeight() - 20;
				configPanl.add({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg + '!</div></div></div>'
				});
			}
			
		}
		else if (widgetType != null && (widgetType == 'BarChart' || widgetType == 'CombinedTimelineChart'))
        {
			var charHeight = '100%';
			configPanl.selectedGraphPalette=jsonData['selectedColorPalette'];
			
			var errorMsg = jsonData['errMsg'];
			if (errorMsg == "-")		
			{
				errorMsg = jsonData['widgetJsonData']['errorMsg'];
			}
			if (errorMsg == "-") {
				configPanl.showTopNCombo=true;
				if (widgetType != null && widgetType == 'Bar_Chart') {
					Ext.EventManager.removeAll('BarChart_'+ widgetID);
					var defaultAction = publicJson['action'];
					var isTopNChart = jsonData['isTopNChart'];
					if (defaultAction != null && defaultAction == 'showMyDashboard') {
						if (isTopNChart != null && isTopNChart == 'yes') {
							var comboObj1 = configPanl.getDockedItems()[0].items.items[1];
							if(!Ext.isEmpty(comboObj1))
							{
								if(comboObj1.xtype=='combobox')
								{
									this.setValueWithOptionInList(comboObj1, jsonData['topNOptions'], jsonData['topNOption'], '');
								}
							}
						}
					}
				} else {
					charHeight = configPanl.getHeight() - 35;
	//				Ext.EventManager.removeAll(widgetID+"_chart");
				}
				if(widgetType == 'BarChart')
				{
					configPanl.isHighChartUpdate=true;
					var charWidth = configPanl.getWidth() - 15;
					charHeight = configPanl.getHeight();
					var columnCharHeight = charHeight;
					if(fusionChartsEnabled)
					{
						var xmlData = jsonData['widgetJsonData']['chartData'];
						var swfPath = jsonData['widgetJsonData']['swfPath'];
						var rndrChartId = 'block_' + widgetID + "_ChartId"; 
						if (FusionCharts(rndrChartId) != null) {
							FusionCharts(rndrChartId).dispose();
						}
						var panHtml = '<div id="BarChart_'+ widgetID + '" style="height:' + charHeight + 'px"></div>';
							if(configPanl.rendered){
						configPanl.add({
							xtype : 'container',
							width : 500,
							flex : 1,
								/*layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'center'
								},*/
							html : panHtml,
							listeners : {
								'afterrender' : function() {
									try {
										var myChart = new FusionCharts(swfPath, rndrChartId, "100%", "100%", "0", "1");
										myChart.setXMLData(xmlData);
										myChart.setTransparent(true);
										myChart.render('barChart_'+widgetID);
									} catch (fusnChrtExcp) {
										if (Ext.isChrome) {
											console.log(fusnChrtExcp);
										}
									}
								}
							}
						});
						}
					}
					else
					{
						var barChartContId='';
					
						var chartLegendData1=null;
						var chart_checkbox1=null;
						var rndrDivHeight=configPanl.getHeight();
						var isScrollRequired=false;
						var chartType = jsonData['widgetJsonData']['chartData']['chartType'];
						if (isTopNChart != null && isTopNChart == 'yes') {
							chart_checkbox1 = jsonData['widgetJsonData']['chart_checkbox'];	
							var barChartHeight = jsonData['widgetJsonData']['topNChartHeight'];
							rndrDivHeight=configPanl.getHeight()-30;
						
							charWidth=charWidth-10;
							chartLegendData1 = jsonData['widgetJsonData']['chartData']['DataSet'][0]['data'];
							if(chartType!=null && chartType == 'bar')
							{
								barChartHeight = parseFloat(barChartHeight);
								if(charHeight>barChartHeight)
								{
									charHeight= charHeight-40;
								}else{
									charHeight= barChartHeight;
									isScrollRequired=true;
								}
								configPanl.scroll=true;
								configPanl.autoScroll=true;								
								configPanl.chartType='bar';
								configPanl.barHeight = charHeight;
								
								//Ext.getCmp('ChartArea_'+widgetID).addCls('HorzBar_panel');
							}else{
								charHeight=charHeight-35;
								configPanl.chartType='column';
							}
							configPanl.isTopNChart=true;
							barChartContId='ChartPnl_' + widgetID;
						}
						else
						{
							chart_checkbox1 = jsonData['widgetJsonData']['chartData']['chart_checkbox'];	
							chartLegendData1 = jsonData['widgetJsonData']['chartData']['DataSet'];
							var displayTitle=jsonData['widgetJsonData']['tableTitle'];
							configPanl.porletSetTitle(displayTitle); 
							barChartContId='ChartPnl_' + widgetID;
							if(chartType!=null && chartType == 'bar')
							{
								var barChartHeight = jsonData['widgetJsonData']['chartData']['barChartHeight'];
								barChartHeight = parseFloat(barChartHeight);
								configPanl.barHeight = barChartHeight;
								if(charHeight>barChartHeight)
								{
									charHeight= charHeight-20;
								}else{
									charHeight= barChartHeight;
								}
								charHeight=charHeight-30;
								charWidth=charWidth-50;
							/*	var chartCont=Ext.getCmp('ChartArea_'+widgetID);
								chartCont.scroll=true;
								chartCont.autoScroll=true;*/
								isScrollRequired=true;
														
								configPanl.chartType='bar';
								//configPanl.barHeight = charHeight;
								//Ext.getCmp('ChartArea_'+widgetID).addCls('HorzBar_panel');
								//chartCls='HorzBar_panel';
							}else{
								charHeight=charHeight-35;
								configPanl.chartType='column';
							}
							//configPanl.update('<div id="barChart_' + widgetID + '" class="timelineDiv" style="border:0px solid yellow;width:100%;">');
						}
						configPanl.errorMsg="-";
						//configPanl.loadFilterOptions(chart_checkbox1);
						//configPanl.loadLegendPanelData(chartLegendData1);
						var chartContainer=Ext.getCmp('ChartArea_'+widgetID);
						//chartContainer.removeAll();
						//chartContainer.add({
						configPanl.add({
							xtype : 'container',
							width : '100%',
							height : '100%',
							flex : 1,
							layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'center'
							},
							//cls : chartCls,
							id : barChartContId,
							scroll : isScrollRequired,
							autoScroll : isScrollRequired,
							listeners : {
								'resize' : function(c)
								{
									if(configPanl.rendered) {
										configPanl.resizeChart(c);
									}
								},
								'afterrender' : function(c) {
									//var charWidth = configPanl.getWidth() - 15;
									//charHeight = configPanl.getHeight() - 25;
									//console.log('charHeightBB_FF-->> ',charHeight);
									
										try
										{
											var barChart = {};
											barChart = jQuery.extend(true, {}, getHighChartsBarInstance(barChartContId, charHeight,charWidth), barChart);
											//chartData=jsonData['chartData'];
											chartData=jsonData['widgetJsonData']['chartData'];
											barChart.setData(chartData, currentDateFormat, '',jsonData['widgetJsonData']['chartData']['chartType']);
											barChart.drawChart();
											configPanl.highChartObj = barChart;
											barChart=null;
											delete barChart;

											/* var chartContObj=Ext.getCmp(barChartContId);
											if(!Ext.isEmpty(chartContObj))
											{
												if(chartContObj.hasListener('resize'))
												{
													chartContObj.mun( chartContObj,'resize');
												}
												chartContObj.mon(chartContObj,'resize',function(){
													configPanl.resizeChart(chartContObj);
												});
											}*/
										}
										catch (barChartEx)
										{
											console.log(barChartEx);
										}
//										configPanl.isInitialResizeCompleted = true;
								}
							}
						});
						//chartContainer.doLayout();
						configPanl.doLayout();
						//configPanl.updateErrorMsg('My Test Message.......');
					}
				}
				else if(widgetType == 'CombinedTimelineChart')
				{
					configPanl.isHighChartUpdate=true;
					var charWidth = configPanl.getWidth() - 15;
					charHeight = configPanl.getHeight() - 25;
					if(fusionChartsEnabled)
					{
						var xmlData = jsonData['widgetJsonData']['xmlData'];
						var swfPath = jsonData['widgetJsonData']['swfPath'];
						var rndrChartId = 'block_' + widgetID + "_ChartId";
						if (FusionCharts(rndrChartId) != null) {
							FusionCharts(rndrChartId).dispose();
						}
							if(configPanl.rendered){
						configPanl.add({
							xtype : 'container',
							width : 500,
							flex : 1,
							layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'center'
							},
							html : panHtml,
							listeners : {
								'afterrender' : function(cont) {
									try {
										var myChart = new FusionCharts(swfPath, rndrChartId, "100%", "100%", "0", "1");
										myChart.setXMLData(xmlData);
										myChart.setTransparent(true);
										myChart.render(cont.id);
									} catch (fusnChrtExcp) {
										if (Ext.isChrome) {
											console.log(fusnChrtExcp);
										}
									}
								}
							}
						});
						}
					}
					else
					{
						if(configPanl.rendered)
						{
							chart_checkbox = jsonData['widgetJsonData']['xmlData']['chart_checkbox'];
							chartLegendData = jsonData['widgetJsonData']['xmlData']['DataSet'];
							configPanl.errorMsg="-";
							var displayTitle=jsonData['widgetJsonData']['tableTitle'];
							configPanl.porletSetTitle(displayTitle); 
						/*	configPanl.loadFilterOptions(chart_checkbox);
							configPanl.loadLegendPanelData(chartLegendData);*/

							var chartContainer=Ext.getCmp('ChartArea_'+widgetID);
							//chartContainer.removeAll();
							//chartContainer.add({
							
							configPanl.add({
								xtype : 'container',
								width : '100%',
								height : '100%',
								flex : 1,
								layout : {
									type : 'vbox',
									align : 'stretch',
									pack : 'center'
								},
								id : 'ChartPnl_' + widgetID,
								listeners : {
									'resize' : function(c)
									{										
										if(configPanl.rendered) {
											configPanl.resizeChart(c);
										}
									},
									'afterrender' : function(c) {
										var charWidth = configPanl.getWidth() - 15;
										charHeight = configPanl.getHeight() - 25;
										
											try
											{
												var lineChart = {};
												lineChart = jQuery.extend(true, {}, getLineChartForMyDashboard('ChartPnl_' + widgetID,charHeight,charWidth,false), lineChart);
												//lineChart = jQuery.extend(true, {}, getLineChartForRESTWidget('ChartPnl_' + widgetID,charHeight,charWidth,false), lineChart);
												var d=jsonData['widgetJsonData']['xmlData'];
												lineChart.setData(jsonData['widgetJsonData']['xmlData'], currentDateFormat,'' ,'line');
												lineChart.drawChart();
												configPanl.highChartObj = lineChart;
												/*var chartContObj=Ext.getCmp('ChartPnl_' + widgetID);
												if(!Ext.isEmpty(chartContObj))
												{
													if(chartContObj.hasListener('resize'))
													{
														chartContObj.mun( chartContObj,'resize');
													}
													chartContObj.mon(chartContObj,'resize',function(){
														configPanl.resizeChart(chartContObj);
													});
												}*/
											}
											catch (barChartEx)
											{
												console.log("Exception-->>",barChartEx);
											}
//											configPanl.isInitialResizeCompleted = true;
									}
								}
							});
							//chartContainer.doLayout();
							configPanl.doLayout();
						}
					}
				}
			} else {
				configPanl.showTopNCombo =false;
				configPanl.updateErrorMsg(errorMsg);
				configPanl.isHighChartUpdate=false;
					
				/*	chartContainer.add({
						xtype : 'panel',
						html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
								+ '!</div></div></div>'
					});*/
			}
			configPanl.resumeEvents();
		}
		else if (widgetType != null && widgetType == 'pieChart') {
			//configPanl.removeAll();
			//var IsOneClickDashboard = jsonData['widgetJsonData']['IsOneClickDashboard'];
			//var oneClickChartDistribution = jsonData['widgetJsonData']['isOneClickChartDistribution'];
			var showLegandPanelForWidgetsVal=false;
			var errorMsg = jsonData['errMsg'];
			if (errorMsg == "-")		
			{
				errorMsg = jsonData['widgetJsonData']['errorMsg'];
			}
			if (errorMsg == "-") {
				var pieChartData = jsonData['widgetJsonData']['DataSet'];
				//var pieChartData = jsonData['DataSet'][0].data;
				var xmlData = jsonData['widgetJsonData']['xmlData'];
				var swfPath = jsonData['widgetJsonData']['swfPath'];
				configPanl.isHighChartUpdate=true;
				var IsOneClickDashboard = jsonData['widgetJsonData']['IsOneClickDashboard'];
				var oneClickChartDistribution = jsonData['widgetJsonData']['isOneClickChartDistribution'];
				configPanl.errorMsg="-";
				//configPanl.renderChart(configPanl,chart_checkbox,chartLegendData);
				var charWidth = configPanl.getWidth() - 15;
				charHeight = configPanl.getHeight() - 35;
				if(showLegandPanelForWidgetsVal)
				{
				var chartContainer=Ext.getCmp('ChartArea_'+widgetID);
				chartContainer.removeAll();
				}
				var oneClickChartDistribution = jsonData['widgetJsonData']['isOneClickChartDistribution'];
				var isShowMoreDataOption = jsonData['widgetJsonData']['isShowMoreDataOption'];
				var dataViewArr=[];			
				var pieChartLegendData = '';
				if((IsOneClickDashboard!=null && IsOneClickDashboard!=undefined) && IsOneClickDashboard =="yes")
				{
					if(oneClickChartDistribution!=null && oneClickChartDistribution!=undefined && oneClickChartDistribution =='multiple')
					{
						pieChartLegendData = jsonData['widgetJsonData']['multiplePieChartJson'][0]['DataSet'][0]['data'];
					}else{
						pieChartLegendData = jsonData['widgetJsonData']['DataSet'][0]['data'];
					}
				}else{
					pieChartLegendData = jsonData['widgetJsonData']['DataSet'][0]['data'];
				}
				var chartLegendsTpl = new Ext.XTemplate(
					'<ul class="pielegend" style="display: table;margin-right: auto;margin-left: auto;top: 50%;bottom: 50%;margin: auto;position: inherit;width: 100%;" >',
						'<tpl for=".">',
							'<li  style="list-style-type: none;vertical-align: middle;margin:1px 0 ;">',
				            '<div style="width:13px; float:left;"><span style="margin-right:5px;background:{color};height:8px;width:8px;display:inline-block"></span></div>',
					        '<div style="white-space:nowrap; text-overflow:ellipsis; overflow:hidden;"><span class="set_cls" data-qtip="{legendName}" data-qclass="yellowTip">{legendName}</span></div></li>',
						'</tpl>',
					'</ul>'
										);
				chartContainerInnerLegend = {
					xtype:'dataview',
					cls:'viewcon', 
					padding:0,
					flex:1,
					margin:0,
					id:'pieLegend_dataview'+widgetID,
					layout:{
						type:'fit',
					},
					scrollFix:function(me){
						//@ updating the center position of UL tag
						if ($('#' + me.id+'.viewcon').has_scrollbar()) {
							$('#' + me.id + ' .pielegend').css({
								'position': 'relative',
								'top': '0'
							});
						} else {
							$('#' + me.id + ' .pielegend').css({
								'position': 'inherit',
								'top': '50%'
							});
						}
					},
					listeners:{
						refresh: function() {
							var me = this;
								me.scrollFix(me)
						},
						resize: function() {
							var me = this;
						//@ updating the center position of UL tag
						 me.scrollFix(me)
						},'viewready' : function(c) {	
							if(!Ext.isEmpty(pieChartLegendData))
							{
								var legendData=Ext.getCmp(this);
								this.getStore().loadData(pieChartLegendData);
							}
						}
					},
					padding:'0',
					flex:4,
					autoScroll:true,
					//overflowY:'auto',
					//storeId:'legend_Store',
					store:Ext.data.Store({
						fields:['color','legendName'],
						data:pieChartLegendData
					}),
					tpl:chartLegendsTpl,
				}
				var chartContainerInnerGraph = {
					xtype : 'container',
					height :'100%',
					width:'100%',
					flex :6,
					border:true,
					margin:0,
					padding:0,
					layout : {
						type : 'vbox',
						align : 'stretch',
						pack : 'center'
					},
					id : 'ChartPnl_' + widgetID,
					listeners : {
						'resize' : function(c)
						{
							if(configPanl.rendered) {
								configPanl.resizeChart(c);
							}
						},
						'boxready' : function(c) {
							var ChartPnlWidth = Ext.getCmp('ChartPnl_'+ widgetID).getWidth();
							var charWidth = configPanl.getWidth() - 15;
							//charHeight = configPanl.getHeight() - 25;
							charHeight = configPanl.getHeight() - 38;
							try
							{
								var pieChart = {};
								pieChart = jQuery.extend(true, {}, getPieChartsforMyDashboard('ChartPnl_' + widgetID, charHeight,ChartPnlWidth), pieChart);
								if((IsOneClickDashboard!=null && IsOneClickDashboard!=undefined) && IsOneClickDashboard =="yes")
								{
									if(oneClickChartDistribution!=null && oneClickChartDistribution!=undefined && oneClickChartDistribution =='multiple')
									{
										chart_checkbox = jsonData['widgetJsonData']['chart_checkbox'];
										chartLegendData = jsonData['widgetJsonData']['multiplePieChartJson'][0]['DataSet'][0]['data'];
										if(isShowMoreDataOption == 'yes') {
											configPanl.showMoreDataOption = true;
										} else
										{
											configPanl.showMoreDataOption = false;
										}
										jsonData['enableDrilldownLink']=isPublishedDashboard?false:true;
										pieChart.setData(jsonData['widgetJsonData']['multiplePieChartJson'][0], currentDateFormat, '', 'myDashboardPieChart');
									}
									else
									{
										jsonData['enableDrilldownLink']=isPublishedDashboard?false:true;
										pieChart.setData(jsonData, currentDateFormat, '', 'myDashboardPieChart');
										chart_checkbox = jsonData['widgetJsonData']['chart_checkbox'];
										chartLegendData = jsonData['widgetJsonData']['DataSet'][0]['data'];
										configPanl.showMoreDataOption=false;
									}
								}
								else
								{
									chart_checkbox = jsonData['widgetJsonData']['chart_checkbox'];
									chartLegendData = jsonData['widgetJsonData']['DataSet'][0]['data'];
									//pieChart.chartConfig(jsonData['DataSet']);
									jsonData['enableDrilldownLink']=isPublishedDashboard?false:true;
									pieChart.setData(jsonData['widgetJsonData'], currentDateFormat, '', 'myDashboardPieChart');
									var displayTitle=jsonData['widgetJsonData']['tableTitle'];
									configPanl.porletSetTitle(displayTitle); 
								}
								if(showLegandPanelForWidgetsVal)
								{
									//configPanl.loadFilterOptions(chart_checkbox);
									//configPanl.loadLegendPanelData(chartLegendData);
								}
								pieChart.drawChart();
								configPanl.highChartObj = pieChart;
//								configPanl.isInitialResizeCompleted = true;
								/*var chartContObj=Ext.getCmp('ChartPnl_' + widgetID);
								if(!Ext.isEmpty(chartContObj))
								{
									if(chartContObj.hasListener('resize'))
									{
										chartContObj.mun( chartContObj,'resize');
									}
									chartContObj.mon(chartContObj,'resize',function(){
										configPanl.resizeChart(chartContObj);
									});
								}*/
								pieChart=null;
								delete pieChart;
							}
							catch (pieChartEx)
							{
								console.log("Pie exception-->>",pieChartEx);
							}
						}
					}
				};
				if(showLegandPanelForWidgetsVal)
				{
					//configPanl.add({
					chartContainer.add({
						xtype : 'container',
						width : '100%',
						height: '100%',
						border:true,
						flex : 1,
						id:'pieChartContainerOuter'+widgetID,
						layout : {
							type : 'hbox',
							align : 'stretch',
						},
						items:[
							chartContainerInnerGraph,chartContainerInnerLegend
						]
					});
					configPanl.doLayout();
				}else{
					configPanl.add({
					//chartContainer.add({
						xtype : 'container',
						heighnewsWindowt: '100%',
						border:true,
						flex : 1,
						id:'pieChartContainerOuter'+widgetID,
						layout : {
							type : 'hbox',
							align : 'stretch',
							pack : 'center'
						},
						items:[
							chartContainerInnerGraph,chartContainerInnerLegend
						]
					});
					configPanl.resumeEvents();
					configPanl.doComponentLayout();
				}

			} else {
				configPanl.hideLoadingMask();
				configPanl.updateErrorMsg(errorMsg);
				//var configPanlHeight = configPanl.getHeight() - 20;
					//configPanl.add({
				/*	chartContainer.add({
						xtype : 'panel',
						html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg + '!</div></div></div>'
					});
				
				configPanl.isHighChartUpdate=false;
				var configPanlHeight = configPanl.getHeight() - 40;
					var oneClickChartDistribution = jsonData['widgetJsonData']['isOneClickChartDistribution'];
					var isShowMoreDataOption = jsonData['widgetJsonData']['isShowMoreDataOption'];
					if(oneClickChartDistribution!=null && oneClickChartDistribution!=undefined && oneClickChartDistribution =='multiple')
					{
						//showMoreDataOption pieChart
						if(isShowMoreDataOption == 'yes') {
							configPanl.showMoreDataOption = true;
						} else
						{
							configPanl.showMoreDataOption = false;
						}
					}
					else
					{
						configPanl.showMoreDataOption = false;
					}
					if(showLegandPanelForWidgetsVal)
					{
						configPanl.updateErrorMsg(errorMsg);
					}
					else{
						configPanl.add({
							xtype : 'panel',
							html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
								+ '!</div></div></div>'
						});
					}
					*/
			}
			configPanl.resumeEvents();
			configPanl.doComponentLayout();
		}
		else if (widgetType != null && widgetType == 'activityChart') {
			configPanl.destoryChart();
			configPanl.hideLoadingMask();
			configPanl.suspendEvents(true);
			var errorMsg = jsonData['errMsg'];
			var IsOneClickDashboard = jsonData['IsOneClickDashboard'];
			
			if(errorMsg == "-") {
			var activityJson=jsonData['widgetJsonData']['DataSet'];
			var activityChartObj={};
			if(configPanl.rendered){
				configPanl.add([
				{
					xtype : 'container',
					flex : 1,
					items:[
							{
								xtype : 'container',
								flex : 0.3,
								cls  : 'timelineDiv',
								id : 'ChartPnl_' + widgetID,
								height :'100%',
								width:'100%',
								listeners : {
									'resize' : function(c)
									{
										if(configPanl.rendered) {
											configPanl.resizeChart(c);
										}
									},
									'boxready' : function(c) {
										var ChartPnlWidth = Ext.getCmp('ChartPnl_' + widgetID).getWidth();
										var width = configPanl.getWidth() - 10;
										height = configPanl.getHeight() - 25;
										
										if((IsOneClickDashboard!=null && IsOneClickDashboard!=undefined) && IsOneClickDashboard =="yes")
										{
											var oneClickChartDistribution = jsonData['isOneClickChartDistribution'];
											var isShowMoreDataOption = jsonData['isShowMoreDataOption'];
											if(oneClickChartDistribution!=null && oneClickChartDistribution!=undefined && oneClickChartDistribution =='multiple')
											{
												chart_checkbox = jsonData['chart_checkbox'];
												if(isShowMoreDataOption == 'yes') {
													configPanl.showMoreDataOption = true;
												} else
												{
													configPanl.showMoreDataOption = false;
												}
												var activityJsonData=jsonData['multiplePieChartJson'][0]['DataSet'];
												var activityJsonVal=jsonData['multiplePieChartJson'][0];
												if(isComponentDashboard)
												{
													activityJsonVal['showChartTitle']=false;
												}
												else
												{
													var chartTitle=activityJsonVal['title'];
													if(chartTitle!=null && chartTitle!="")
													{
														chartTitle = ( Ext.isEmpty( jsonData['unit'] ) )?chartTitle:chartTitle+'('+jsonData['unit']+')';
													}
													var componentDrillDownURL=jsonData['componentDrillDownURL'];
													if(!Ext.isEmpty(componentDrillDownURL) && componentDrillDownURL!="-")
													{
														chartTitle='<a href=\'javascript:goToLayerModel("' + componentDrillDownURL + '")\'>'+chartTitle+'</a>';
													}
													if(jsonData!=null && jsonData.hasOwnProperty('tableTitle'))
													{
														if(!Ext.isEmpty(chartTitle))
														{
															configPanl.porletSetTitle(jsonData['tableTitle']+ ' - '+chartTitle);
														}
														else
														{
															configPanl.porletSetTitle(jsonData['tableTitle']);
														}
													}
													else
													{
														configPanl.porletSetTitle(chartTitle);
													}
													activityJsonVal['showChartTitle']=false;
											}
										activityJsonVal['enableDrilldownLink']=isPublishedDashboard?false:true;
										activityChartObj = getChartForActivityChart(c.id,height,width,activityJsonData);
										configPanl.highChartObj = activityChartObj;
										configPanl.activeData= activityJsonData;
									}
									else
									{
										activityJson['enableDrilldownLink']=isPublishedDashboard?false:true;
										activityChartObj = getChartForActivityChart(c.id,height,width,activityJson);
										configPanl.highChartObj = activityChartObj;
										configPanl.activeData= activityJson;
										configPanl.showMoreDataOption=false;
									}
								}
								else
								{
									activityJson['enableDrilldownLink']=isPublishedDashboard?false:true;
									activityChartObj = getChartForActivityChart(c.id,height,width,activityJson);
									configPanl.highChartObj = activityChartObj;
									configPanl.activeData= activityJson;
								}
								activeData=null;
								delete activeData;

									}
								}
							}
						]
					}]);
				}
			}
			else {
						configPanl.add({
							xtype : 'panel',
							html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg
								+ '!</div></div></div>'
						});
			}
		configPanl.resumeEvents();
		configPanl.doComponentLayout();
		}
		else if (widgetType != null && widgetType == "heatMapChart")
		{
			var errorMsg = jsonData["errMsg"];
			configPanl.destoryChart();
			configPanl.hideLoadingMask();
			configPanl.suspendEvents(true);
			if(errorMsg!=null && errorMsg == '-' && errorMsg!='undefined')
			{
				configPanl.isHighChartUpdate=true;
				var heatmappanelCon=Ext.getCmp('heatmappanel'+widgetID);
				if(!Ext.isEmpty(heatmappanelCon))
				{
					heatmappanelCon.removeAll();
				}
				var heatMapData = jsonData['widgetJsonData']['heatMapChartDataArr'];
				if(!Ext.isEmpty(heatMapData))
				{
					var IsOneClickDashboard = publicJson['myDashboardConfigDetails']['IsOneClickDashboard'];
					var isShowMoreDataOption = false;//jsonData['widgetJsonData']['isShowMoreDataOption'];
					
					if(IsOneClickDashboard!=null && IsOneClickDashboard=="yes")
					{ 
						if(isShowMoreDataOption == 'yes'){

							configPanl.showMoreDataOption = true;
						} else
						{
							configPanl.showMoreDataOption = false;
						}
					}

					var componentDrillDownURL = jsonData['componentDrillDownURL'];
					var showheader = false;
					//&& !Ext.isEmpty(componentDrillDownURL)
					
					if(!Ext.isEmpty(heatMapData[0].heatmapchart[0].title) && heatMapData[0].heatmapchart[0].title != '-')
					{
							showheader =  true;
					}
					var heatMapSubTitle='&nbsp;';
					if(showheader)
					{
						if(jsonData!=null && jsonData.hasOwnProperty('tableTitle'))
						{
								heatMapSubTitle=jsonData['tableTitle']+" - "+heatMapData[0].heatmapchart[0].title;
						}
						else
						{
							heatMapSubTitle=heatMapData[0].heatmapchart[0].title;
						}
						configPanl.porletSetTitle(heatMapSubTitle);
					}
					configPanl.add({
						xtype : 'heatmappanel',
						id:'heatmappanel'+widgetID,
						header:false,
						margin : '0 0 0 0',
						data:heatMapData
	//					title: heatMapSubTitle
					});
				}
			}
			else
			{		
				configPanl.isHighChartUpdate=false;
				var configPanlHeight = configPanl.getHeight() - 40;
				var IsOneClickDashboard = publicJson['myDashboardConfigDetails']['IsOneClickDashboard'];
				if(IsOneClickDashboard != null && IsOneClickDashboard == 'yes')
				{
					configPanl.showMoreDataOption = false;
				}
				configPanl.removeAll();
				configPanl.add({
					xtype : 'panel',					
					html : '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="' + configPanlHeight
					+ '"><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + errorMsg
					+ '!</div></td></tr></table></div>'
				});
			}
			configPanl.resumeEvents();
			configPanl.doComponentLayout();
		}
	   else if (widgetType != null && (widgetType == 'TimelineChart' || widgetType == 'areaChart')) 
		{
		   //configPanl.removeAll();
		    configPanl.destoryChart();
			configPanl.suspendEvents(true);
			var errorMsg = jsonData['errMsg'];
			if (errorMsg == "-")		
			{
				errorMsg = jsonData['widgetJsonData']['errorMsg'];
			}
			if (errorMsg != null && errorMsg == "-") {
				var chartContainer=Ext.getCmp('ChartArea_'+widgetID);
				//chartContainer.removeAll();
				configPanl.removeAll();
				var chartContainerInnerLegend = {
					xtype : 'container',
					width : '100%',
					//height : '20%',
					minHeight:42,
					//maxHeight:40,
					autoScroll:true,
					//border:true,
					//style:{'border':'1px solid blue'}, // jaiwin
					flex : 0.3,
					margin:0,
					padding:0,
					border:false,
					//style:{'border':'1px solid blue'},
					layout : {
						type : 'vbox',
						align : 'stretch',
						pack : 'center'
					},
					id : 'CurrentMesPnl_' + widgetID,
				};
				var chartContainerInnerGraph = {
					xtype : 'container',
					width : '100%',
					height :'100%',
					flex :0.7,
					border:false,
					margin:0,
					padding:0,
					//style:{'border':'1px solid yellow'},
					layout : {
						type : 'vbox',
						align : 'stretch',
						pack : 'center'
					},
					id :'ChartPnl_' + widgetID
				};
				//chartContainer.add({
					configPanl.add({
					xtype : 'container',
					width : '100%',
					height: '100%',
					border:true,
					//style:{'border':'1px solid red'},
					flex : 1,
					id:'lineChartContainerOuter'+widgetID,
					layout : {
						type : 'vbox',
						align : 'stretch',
						pack : 'center'
					},
					items:[
						chartContainerInnerLegend,chartContainerInnerGraph
					]
				});
				//chartContainer.doLayout();
				configPanl.resumeEvents();
				configPanl.doComponentLayout();
				
				var CurrentMesPnlFLEX = Ext.getCmp('CurrentMesPnl_'+ widgetID).flex;
				configPanl.selectedGraphPalette='Palette2';//jsonData['selectedColorPalette'];
				//var smallViewUrl = jsonData['smallViewURL'] + "&imgSttime=" + new Date().getTime();
				var liveMeasHtml = "";
				var isHighChart="true";//jsonData['HIGH_CHART'];
				var panHtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div id="measuregraph_' + widgetID
					+ '" style="border:0px solid yellow;height:100%;width:100%;"></div></td></tr></table>';
				if (isHighChart == 'true') {
					//if (true) {
					var measWidth = configPanl.getWidth() - 15;
				//var showChartCurrentValueData = jsonData['showChartSummaryVal'];
				var showChartCurrentValueData = false;
				var showChartCurrentValue='';
				if(showChartCurrentValueData)
				{
					showChartCurrentValue='yes';
				}else{
					showChartCurrentValue='no';
				}
	
				var measHeight = null;
				if(showCharLegend.toLowerCase() == "no" && showChartCurrentValue.toLowerCase()=="no")
				{
					measHeight = configPanl.getHeight() - 35;
				}				
				else if (widgetType == 'TimeLineChart') {
					measHeight = configPanl.getHeight() - 70;
				} else {
					measHeight = configPanl.getHeight() - 70;
				}
				//var hideLegend=jsonData['widgetJsonData']['hideLegend'];
				var hideLegend = false;
				if(hideLegend)
				{
					if(showChartCurrentValue!=null && showChartCurrentValue.toLowerCase()!="yes")
					{
						measHeight = configPanl.getHeight() - 20;
					}
				}
				var newLineChartContainer = Ext.getCmp('lineChartContainerOuter'+widgetID).getHeight();
				var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ widgetID).getHeight();
				var charHeight = configPanl.getHeight();
				var CurrentMesPnlHeight = Ext.getCmp('CurrentMesPnl_'+ widgetID).getHeight();
				//var measHeightVal= charHeight-CurrentMesPnlHeight-32;
				var measHeightVal= ChartPnlHeight-35;
				var lineChartHeight = newLineChartContainer - CurrentMesPnlHeight
					configPanl.isHighChartUpdate=true;
					//var chart_checkbox = jsonData['chart_checkbox'];
					//configPanl.loadFilterOptions(chart_checkbox);
					//console.log("smallViewUrl---->>>",smallViewUrl);
				/*	iAjax.request({
								url : smallViewUrl,
								method : 'GET',
								scope : this,*/
							//	success : function(response) {
									//if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
										//var tmpJsonTxt = response.responseText;
										//console.log("tmpJsonTxt-->>"+tmpJsonTxt);
										//if (tmpJsonTxt.indexOf('iconExclamation') == -1) {
											configPanl.errorMsg="-";
											var chartData = jsonData['widgetJsonData'];
											configPanl.hideLoadingMask();
											chartLegendData = chartData['DataSet'];
											//configPanl.loadLegendPanelData(chartLegendData);
											//configPanl.renderChart(configPanl,chart_checkbox,chartLegendData);
											try {
												var dataSetObj = chartData['DataSet'];
												if(chartData.showChartSummary)
												{
													configPanl.isCurrentValAvail=true;
													this.loadSummaryDetails(widgetID,configPanl,chartData,hideLegend);
												}else{
													configPanl.isCurrentValAvail=false;
													var currentMesPnl=Ext.getCmp('CurrentMesPnl_'+widgetID);
													currentMesPnl.hide();
												}
												var lineChart = {};
												if (widgetType == 'areaChart') {
													var displayTitle=chartData['tableTitle'];
													configPanl.porletSetTitle(displayTitle);
													lineChart.isExternalIntegrationWidget=true;
													lineChart = jQuery.extend(true, {}, getHighStockAreaChartForMyDashboard('ChartPnl_' + widgetID, measHeightVal,(measWidth-50), '', dataSetObj), lineChart);
													lineChart.setData(chartData, currentDateFormat, '', false, 'bottom');
												}
												else {
													var displayTitle=chartData['tableTitle'];
													configPanl.porletSetTitle(displayTitle);
													lineChart = jQuery.extend(true, {}, 
													getHighChartsForMyDashboard('ChartPnl_' + widgetID, lineChartHeight, measWidth,''), lineChart);
													lineChart.isExternalIntegrationWidget=true;
													lineChart.setData(chartData, currentDateFormat, '', false, 'bottom');
													 
												}
												lineChart.drawChart();
												configPanl.highChartObj = lineChart;
												configPanl.chartData = chartData;
												configPanl.hideLegend = hideLegend;
												var chartContObj=Ext.getCmp('ChartPnl_' + widgetID);
												if(!Ext.isEmpty(chartContObj))
												{
													if(chartContObj.hasListener('resize'))
													{
														chartContObj.mun( chartContObj,'resize');
													}
													chartContObj.mon(chartContObj,'resize',function(){
														configPanl.resizeChart(chartContObj);
													});
												}
												configPanl.isInitialResizeCompleted=true;
												dataSetObj=null;
												delete dataSetObj;
												lineChart=null;
												delete lineChart;
											} catch (e) {
											console.log("TimeLine exception----->> ",e);
											}
											chartData=null;
											delete chartData;
											tmpJsonTxt=null;
											delete tmpJsonTxt;
				} else {
					panHtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="' + smallViewUrl+ '" border="0" /></td></tr></table>';
					configPanl.hideLoadingMask();
					configPanl.updateErrorMsg(panHtml);
				}
			}
			else
			{
				configPanl.hideLoadingMask();
				//configPanl.updateErrorMsg(errorMsg);
				configPanl.removeAll();
				configPanl.add({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + errorMsg + '!</div></div></div>'
				});
			
			}
			configPanl.resumeEvents();
			smallViewUrl=null;
			delete smallViewUrl;
		}

		configPanl.nextRefreshTime=(new Date().getTime()+parseInt(dashboardRefFreq)+3000);
		configPanl.lastRefreshedTime=new Date().getTime();
		isPanelRefreshing=false;
		jsonData=null;
		delete jsonData;
	},

	loadNextPreviewButtons: function() {
		var configWinObj = this.getWidgetOptionsWindow();
		if(!Ext.isEmpty(configWinObj))
		{
			if(configWinObj.isKpi)
			{
				var prevButtonObj = Ext.getCmp('prevButton');
				var nextButtonObj = Ext.getCmp('nextButton');
				if(!Ext.isEmpty(prevButtonObj) && !Ext.isEmpty(nextButtonObj))
				{
					if(configWinObj.Kpicount==1)
					{
						prevButtonObj.needToDisable = true;
						prevButtonObj.setDisabled(true);
					}

					if(configWinObj.Kpicount==configWinObj.totalKpiCount)
					{
						nextButtonObj.needToDisable = true;
						nextButtonObj.setDisabled(true);
					}			

					if(!prevButtonObj.needToDisable)
					{
						prevButtonObj.setDisabled(false);
					}

					if(!nextButtonObj.needToDisable)
					{	
						nextButtonObj.setDisabled(false);
					}
					
					configWinObj.doLayout();
				}
			}
		}
	}
});