Ext.define('netscaler.controller.Main', {
	extend : 'Ext.app.Controller',
	refs:[
		{selector:'main',ref:'main'}
	],
	init: function() {
		app = this;
		this.control({
		});
	},
	refresh : function(compName)
	{
		//var selectedVirtualServers = Ext.getCmp('virtualServerCombo').getValue();
		selectedVirtualServer = this.filterEncode(selectedVirtualServer);
		var me = this;
		Ext.getBody().mask("Loading...");
		Ext.Ajax.request(
		{
			url: '/final/monitor/serviceNetscalerTopology.jsp?compName='+compName+'&selectedVirtualServers='+encodeURIComponent(selectedVirtualServer),
			method: 'POST',
			timeout:120000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					 jsonData = Ext.decode( jsonText );
					
					 meMeasApp.getController('Main').loadTopologyData(jsonData);

					/*-- set scrollPostion at auto refresh--*/
					var mainID = Ext.get('mainId-body');
					//var scrollPostionY =  mainID.getScrollable().getScroller().position.y;
					mainID.scrollBy({x:0,y:scrollPostion}, true);
					/*--------------------------------------*/

					if (Ext.get('loadmask') != undefined) {
						Ext.get('loadmask').remove();
					}
				}
				Ext.getBody().unmask();
			}
		});
	},
	filterEncode: function(text)
	{
		var filterEncodeChar = ['(',')','[',']','%','=','\'','&',';','\"'];
		var filterDecodeText = ['|lbr|','|rbr|','|lsbr|','|rsbr|','|per|','|eq|','|squot|','|ampsnd|','|scol|','|dqt|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	createTabularViewforAAAStats : function(virtualServersData,obj,height)
	{
		if(!Ext.isEmpty(virtualServersData))
		{
			var gridCols = virtualServersData['gridColumns'];
			var gridData = virtualServersData['gridData'];
			var title = virtualServersData['title'];
			var ErrorMsg = virtualServersData['ErrorMsg'];			
			if(!Ext.isEmpty(ErrorMsg) && ErrorMsg=='-')
			{
				if(gridData!=null && gridData.length>0)
				{
					var fieldModel = new Array();
					var columns = new Array();
					var colIdx = 0;					
					for (var key in gridCols) { 
						fieldModel.push({
							name : 'Column_' + colIdx + '_url',
							type : 'string'
						}); 
						fieldModel.push({
							name: 'Column_' + colIdx,
							type: 'FLOATORSTRING'
						});
						var flexheader = 0.5;							
						columns.push({
							header: gridCols[key],
							dataIndex: 'Column_' + colIdx,
							align: 'left',
							flex: flexheader,
							sortable: true,
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var column = gridView.getHeaderAtIndex(col);
								var dataIndexVal = column.dataIndex;
								//if (dataIndexVal != null && dataIndexVal == "Column_0") {
									var href = record.get(dataIndexVal+'_url');									
									if (href != null && !Ext.isEmpty(href) && href != "-") {
										if(value!=null && value=="NA")
										{
											href=decodeURI(href);
											value = '<a href=\'javascript:wayToLayerModel("' + href + '")\'>'+value+'</a>';
										}
										else
										{
											href=decodeURI(href);
											value = '<a href=\'javascript:wayToLayerModel("' + href + '")\' >'+value+'</a>';
										}
									}
								//}						
								return value;
							}
						});
						colIdx++;
					}			
					var ackStore = Ext.data.Store({
						fields: fieldModel,
						data: gridData,
						sortOnLoad : true,
						/*sorters : {
							property : 'COLUMVal_1',
							direction : 'DESC'
						}*/
					});
					if (strSkin=="Light")
					{
						fontColor="#2a292a";
					}
					else if (strSkin=="Dark")
					{
						fontColor="#c6c6c6";
					}
					obj.add({
						xtype: 'grid',
						id: 'gridDisplay_'+title,
						store: ackStore,
						height: height,
						margin:'0 10 10 10',
						title:title,
						//cls: 'gridSkin',
						ui:'newGridPanel headerTextWrap',
						header:{
							style:{
								'padding':'10px 10px 10px 0px','color':fontColor,'font-size':'14px','font-weight':'500' 
							}
						},
						columns: columns
					});
				}
			}
			else
			{
				obj.add({
					xtype: 'panel',
					ui:'newGraphPanel',
					title:title,
					height: height,
					margin:'0 10 10 0',
					style:{'box-shadow':'none'},
					html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + noMeasLbl	+ '!</div></td></tr></table>'
				});
			}
		}
		else
		{
			obj.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				//title:title,
				height: height,
				margin:'0 10 10 0',
				style:{'box-shadow':'none'},	
				html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + noMeasLbl	+ '!</div></td></tr></table>'
			});
		}
	},
	createTabularView : function(virtualServersData,obj,height)
	{
		if(!Ext.isEmpty(virtualServersData))
		{
			var gridCols = virtualServersData['gridColumns'];
			var gridData = virtualServersData['gridData'];
			var title = virtualServersData['title'];
			var ErrorMsg = virtualServersData['ErrorMsg'];			
			if(!Ext.isEmpty(ErrorMsg) && ErrorMsg=='-')
			{
				if(gridData!=null && gridData.length>0)
				{
					var fieldModel = new Array();
					var columns = new Array();
					var colIdx = 0;
					fieldModel.push({
						name : 'Column_1_barValue',
						type : 'FLOATORSTRING'
					});
					fieldModel.push({
						name : 'Column_0_url',
						type : 'string'
					}); 
					fieldModel.push({
						name : 'Column_0_toolTip',
						type : 'string'
					});
					for (var key in gridCols) { 
						fieldModel.push({
							name: 'Column_' + colIdx,
							type: 'FLOATORSTRING'
						});
						var flexheader = 0.5;
						if(obj.id == 'servicegrps'){
							if(key == 'Column_0'){
								flexheader=0.5;
							}else if (key == 'Column_1'){
								flexheader=0.4;
							}else if (key == 'Column_2'){
								flexheader=0.35;
							}else if (key == 'Column_3'){
								flexheader=0.25;
							}
						}else if(obj.id == 'services'){
							if(key == 'Column_0'){
								flexheader=0.9;
							}else if (key == 'Column_1'){
								flexheader=0.8;
							}else if (key == 'Column_2'){
								flexheader=0.7;
							}else if (key == 'Column_3'){
								flexheader=0.7;
							}else if (key == 'Column_4'){
								flexheader=0.5;
							}
						}else{
							if(key == 'Column_0'){
								flexheader=1;
							}else if (key == 'Column_1'){
								flexheader=1.1;
							}else if (key == 'Column_2'){
								flexheader=0.9;
							}else if (key == 'Column_3'){
								flexheader=0.6;
							}
						}
						columns.push({
							header: gridCols[key],
							dataIndex: 'Column_' + colIdx,
							align: 'left',
							flex: flexheader,
							sortable: true,
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								var column = gridView.getHeaderAtIndex(col);
								var dataIndexVal = column.dataIndex;
								if (dataIndexVal != null && dataIndexVal == "Column_0") {
									var href = record.get(dataIndexVal+'_url');
									var toolTip = record.get('Column_0_toolTip');
									if (href != null && !Ext.isEmpty(href) && href != "-") {
										if(value!=null && value=="NA")
										{
											href=decodeURI(href);
											value = '<a href=\'javascript:wayToLayerModel("' + href + '")\'>'+value+'</a>';
										}
										else
										{
											href=decodeURI(href);
											value = '<a href=\'javascript:wayToLayerModel("' + href + '")\' data-qtip="'+toolTip+'">'+value+'</a>';
										}
									}
								}
								else if (dataIndexVal != null && dataIndexVal == "Column_1") {
									var barPercent = record.get(dataIndexVal + '_barValue');									
									if (barPercent != null && parseFloat(barPercent) >= 0) {
											var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
											barStr += '<tr>';
											barStr += '<td align="left" width="100%" height="8" >';
											barStr += '<table width="' + barPercent + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
											barStr += '<tr>';
											barStr += '<td class="netscalerProgressBar" width="100%"> </td>';
											barStr += '</tr>';
											barStr += '</table>';
											barStr += '</td>';
											barStr += '</tr>';
											barStr += '</table>';
											value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:100px'><span>" + value
													+ "</span></td><td > " + barStr + "</td></tr></table>";
										}
								}
								return value;
							}
						});
						colIdx++;
					}			
					var ackStore = Ext.data.Store({
						fields: fieldModel,
						data: gridData,
						sortOnLoad : true,
						sorters : {
							property : 'COLUMVal_1',
							direction : 'DESC'
						}
					});
					if (strSkin=="Light")
					{
						fontColor="#2a292a";
					}
					else if (strSkin=="Dark")
					{
						fontColor="#c6c6c6";
					}
					obj.add({
						xtype: 'grid',
						id: 'gridDisplay_'+title,
						store: ackStore,
						height: height,
						margin:'0 10 10 10',
						title: title,
						//cls: 'gridSkin',
						ui:'newGridPanel headerTextWrap',
						header:{
							style:{
								'padding':'10px 10px 10px 0px','color':fontColor,'font-size':'14px','font-weight':'500' 
							}
						},
						columns: columns
					});
				}
			}
			else
			{
				obj.add({
					xtype: 'panel',
					ui:'newGraphPanel',
					title:title,
					height: height,
					margin:'0 10 10 0',
					style:{'box-shadow':'none'},
					html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + noMeasLbl	+ '!</div></td></tr></table>'
				});
			}
		}
		else
		{
			obj.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				//title:title,
				height: height,
				margin:'0 10 10 0',
				style:{'box-shadow':'none'},	
				html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + noMeasLbl	+ '!</div></td></tr></table>'
			});
		}
	},
	loadTopologyData: function(jsonData)
	{
		var viewPortObj=Ext.getCmp('netScalerViewPort');
		if(viewPortObj!=null && viewPortObj!=undefined)
		{
			//Ext.suspendLayouts();
			Ext.getCmp('netscalerTopo').destroy();
			viewPortObj.removeAll();
			$('#graph-attach').remove();
			viewPortObj.add({
				xtype:'main',
				data: jsonData['TextMetrics']
			});
			//Ext.resumeLayouts(true);
			viewPortObj.doComponentLayout();
			viewPortObj=null;
		}
		else
		{
			Ext.create('Ext.container.Viewport', {
				layout: 'fit',
				id : 'netScalerViewPort',
				name : 'netScalerViewPort',
				items: [{
					data: jsonData['TextMetrics'],
					xtype: 'main'
				}]
			});
		}
	}
});
