Ext.define('netscaler.view.Main', {
	extend: 'utilities.NewOuterPanel',
	alias: 'widget.main',
	requires: ['netscaler.view.lineChart', 'netscaler.view.gaugeChart', 'netscaler.view.netscalerTopology','netscaler.view.virtualServers','netscaler.view.ServiceGrps','utilities.CheckCombobox'],
	layout: 'column',
	//title: '<div style="width:100%;display:inline-block;margin-top:2px"><div style="float:left;margin-right:10px" class="newFont_bold15">Netscaler Load Balancing Flow</div><div id="comboId" style="float:left"></div></div>',
	title: '<div style="width:100%;display:inline-block;margin-top:2px"><div style="float:left;margin-right:10px" class="newFont_bold15">'+title+'</div><div id="comboId" style="float:left"></div><span id="high-availability" style="float:left"><span></div>',
	ui: 'newOuterPanel',
	id:'mainId',
	cls:'netscalerPanelBody',
	name:'mainId',
	data:'',
	margin: '10 10 0 10',
	padding: '0 0 15 0',
	tools:[
	{
		xtype : 'button',
		margin:'4 4 0 8',
		iconCls:'iconBack',
		text : backBtnLbl,
		action : 'back',
		hidden:hideBackBtn,
		cls:'backbutton',
		listeners:{
			'click': function()
			{
				window.history.go(-1);
			}
		}
	}],		
	listeners:{
		render: function(){
			var getComboId = Ext.get('comboId');
			//render high-availability
			Ext.create('Ext.Img', {
				src: '../images/'+strSkin+'/high-availability.svg',
				width:22,
				height:22,
				floating:true,
				margin:'12 20 0 20',				
				padding:'0',
				renderTo: 'high-availability',
				hidden:  jsonData['isHAEnabled']?false:true,
				listeners: {
					afterrender: function(img) {
						Ext.create('Ext.tip.ToolTip', {
							target: img.getEl(),
							html:HALbl,
						});
					}
				}
			});

			var combo = new Ext.create('utilities.ScrollCombo', {
				fieldLabel:' - ',
				id: 'componentsDropDown',
				itemId:'componentsDropDown',
				//cls:'dropdown',
				name:'',
				labelWidth:10,
				queryMode: 'local',
				labelSeparator: '',
				editable: false,
				labelAlign:'left',
				queryMode: 'local',		
				valueField: 'valueField',
				displayField: 'displayField',
				store:new Ext.data.Store({
					fields: ['state','valueField','displayField'],
					data: jsonData['compArr']
				}),
				value: jsonData['selectedCompName'],				
				renderTo: getComboId,
				tpl: Ext.create('Ext.XTemplate',
					'<ul style="white-space:nowrap">',
						'<tpl for=".">',
							'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{displayField}</li>',
						'</tpl>',
					'</ul>'
				),
				listeners:
				{
					'afterrender':function(){
						$('#componentsDropDown-inputEl').addClass('state_'+jsonData['selectedCompState']);
					},
					'select': function(obj)
					{
						selectedVirtualServer = "";
						var compName = obj.getValue();
						Ext.getBody().mask("Loading...");
						Ext.Ajax.request(
						{
							url: '/final/monitor/serviceNetscalerTopology.jsp?compName='+compName,
							method: 'POST',
							timeout:120000,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonText = response.responseText;
									 jsonData = Ext.decode( jsonText );

									 meMeasApp.getController('Main').loadTopologyData(jsonData);
									 componentName = compName;

									if (Ext.get('loadmask') != undefined) {
										Ext.get('loadmask').remove();
									}
									var disableAllSelector = jsonData['disableAllSelector'];
									if(!disableAllSelector || disableAllSelector=='false')
									{
										var virtualServersObj = Ext.getCmp('virtualServerCombo');
										var store = virtualServersObj.getStore();
										virtualServersObj.setValue(['All']);
										virtualServersObj.select(store.getRange());	
										lastSelectValue = 'All';
									}
								}
								Ext.getBody().unmask();
							}
						});						
					}
				}
			});
		},
		scrollPos:0,
		'afterrender':function(cmp){
			//alert('hii.');
			
			var mainID = Ext.get('mainId-body');
			var getScrollPosition = mainID.getScroll();
			
			//console.log('getScrollPosition ===>',getScrollPosition)

			//console.log('$(#mainId-body).scrollTop() ===>',$('#mainId-body').scrollTop())
			//console.log('mainID ===>',mainID)
			
			Ext.get('mainId-body').on('scroll',function(){
				scrollPostion = $('#mainId-body').scrollTop();
				//console.log('scrollPostion ===>',scrollPostion)
			})
		},
	},
	items: [
	
	{
		xtype: 'netscalertopology'
	},
	{
		xtype: 'gaugechart'
	},
	{
		xtype: 'servicegrps'
	},
	{
		xtype: 'virtualservers'
	}
	
	/*{
		xtype: 'linechart'
	}*/] 
});
