
<!--
***************************************************************************************
*	File name		: endUserDashboardMain.jsp
*	Purpose			: This is the main page for End User Dashboard
*	Version			: eG 6.0.1 and Above
*	Creation Date	: 04/12/2014
*	Authtor			: Saravanan . A
*	Design			: Jaiwin
******************************************************************************************/
-->
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgDbaseInfo"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*" %>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.math.*" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<script language="JavaScript1.2" type="text/JavaScript"> 
	var vdComboArray = new Array();
</script>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");
%>

<%

	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());

	String fromMenuStr = request.getParameter("fromMenu");
	boolean isFromMenu=false;
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
	{
		isFromMenu=true;
	}

	String showKeyUserStr = request.getParameter("showKeyUser");
	boolean showKeyUser=false;
	if(showKeyUserStr!=null && (showKeyUserStr.equalsIgnoreCase("true") || showKeyUserStr.equalsIgnoreCase("yes")))
	{
		showKeyUser=true;
	}

	String updateUserAssociateStr = request.getParameter("updateUserAssociate");
	boolean updateUserAssociateFlag=false;
	if(showKeyUser && updateUserAssociateStr!=null && (updateUserAssociateStr.equalsIgnoreCase("true") || updateUserAssociateStr.equalsIgnoreCase("yes")))
	{
		updateUserAssociateFlag=true;
	}
	String isMetricsLayerModel = request.getParameter("isMetricsLayerModel");
	boolean isMetricsLayerModelFlg=false;
	if(isMetricsLayerModel!=null && (isMetricsLayerModel.equalsIgnoreCase("true") || isMetricsLayerModel.equalsIgnoreCase("yes")))
		isMetricsLayerModelFlg=true;

	boolean isFromGeo=false;
	String fromGeoStr = request.getParameter("fromGeo");
	if(fromGeoStr!=null && (fromGeoStr.equalsIgnoreCase("true") || fromGeoStr.equalsIgnoreCase("yes")))
	{
		isFromGeo=true;
	}
	if(isFromMenu || isFromGeo)
	{
		user = registry.getUser(session.getId(),true);
	}
	else
	{
		user = registry.getUser(session.getId());
	}

	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isManagerLogin=false;
	String userName = "admin";
	String desktopName = request.getParameter("username");
	desktopName=(desktopName==null)?"":desktopName;
	desktopName=com.egurkha.util.StringUtils.decodeSecurityChar(desktopName);
	
	String installdir = EgInstallInfo.getInstallDir();
	IniFile in = new IniFile(installdir+"/manager/config/eg_endUserDetails.ini");

	String strEGManagerUser=in.getValue("END_USER_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;

	String moreOptionsWithGrid = in.getValue("END_USER_DASHBOARD_SETTINGS","MoreOptionsWithGrid");
	moreOptionsWithGrid = (moreOptionsWithGrid==null || moreOptionsWithGrid.trim().length()==0)?"false":moreOptionsWithGrid;
	boolean isMoreOptionsGrid = (moreOptionsWithGrid.equalsIgnoreCase("true") || moreOptionsWithGrid.equalsIgnoreCase("yes"))?true:false;

	if(user==null && (!isFromMenu || !isFromGeo))
	{
		String login_user = "";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
		{
			user = userData.usr;
		}

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isManagerLogin = true;
	}
	List userComponentsList = new LinkedList();
	boolean isComponentAvailable = true;
	String componentTypeName = request.getParameter("vdiType");
	if(user!=null && componentTypeName != null && componentTypeName.trim().length()>0 && !componentTypeName.equalsIgnoreCase("undefined") && !componentTypeName.equalsIgnoreCase("null")){
		String component_Type = (componentTypeName.indexOf(":")>-1)?componentTypeName.substring(0,componentTypeName.indexOf(":")):"";
		if(component_Type.trim().length() >0){
			userComponentsList.addAll(user.getServerTypes());
			int serSize = userComponentsList.size();
			if(serSize == 0)
				isComponentAvailable = false;
			if(serSize > 0 ){
				if(!userComponentsList.contains(component_Type))
					isComponentAvailable = false;
				else{
						List userComponentsNameList = user.getServersForType(component_Type);
						if(userComponentsNameList != null && userComponentsNameList.size()>0 && !userComponentsNameList.contains(componentTypeName))
							isComponentAvailable = false;
				}
			}
		}
	}

	String userType = request.getParameter("userType");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType = (userType==null || userType.equalsIgnoreCase(""))?"VDI":userType;

	String strTemplate=null;
	if(userType!=null)
	{
		String templateNames[] = in.getVariables("TEMPLATE_USER_TYPE_FOR_ADMIN_SETTING");
		if(templateNames!=null && templateNames.length>0)
		{
			boolean isGotTemplate=false;
			for(int i=0;i<templateNames.length;i++)
			{
				String templateName=(String)templateNames[i];
				String tmpUserTypes=(String)in.getValue("TEMPLATE_USER_TYPE_FOR_ADMIN_SETTING",templateName);
				ArrayList template_ut_list=new ArrayList();
				if(tmpUserTypes!=null && tmpUserTypes.trim().length()>0)
				{
					template_ut_list = com.egurkha.util.StringUtils.egTokenizer(tmpUserTypes, ",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim

					if(template_ut_list!=null && template_ut_list.contains(userType))
					{
						strTemplate = templateName;
						isGotTemplate=true;
					}
				}

				if(isGotTemplate)
					break;
			}
		}
	}

	boolean isOnlyVMAssigned=false;
	boolean isVMAssigned=false;
	if(user!=null && user.isOnlyVMAssigned() && (!user.isVMAssigned()) && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
	{
		isOnlyVMAssigned=true;
	}
	else if(user!=null && (!user.isOnlyVMAssigned()) && user.isVMAssigned() && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
	{
		isVMAssigned=true;
	}
	else if(user!=null && user.isOnlyVMAssigned() && user.isVMAssigned() && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
	{
		isOnlyVMAssigned=true;
		isVMAssigned=true;
	}
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	if (user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	
	
	boolean showComboFil=false;
	if(userType!=null && (userType.equalsIgnoreCase("ESX")|| userType.equalsIgnoreCase("VCDataStore") || userType.equalsIgnoreCase("NCDataStore") || userType.equalsIgnoreCase("RHEVDataStore")))
	{
		showComboFil=true;
	}

	ArrayList supportedTypesList = new ArrayList();
	String supportedTypes = in.getValue("RESOURCE_APPLICATION","SupportedTypes");
	String enableApplicationTab = in.getValue("RESOURCE_APPLICATION","EnableApplicationTab");
	if(supportedTypes != null && supportedTypes.trim().length() > 0){
		supportedTypesList = com.egurkha.util.StringUtils.egTokenizer(supportedTypes, ",", true,false,true);
	}
	boolean hideApplicationTab = true;
	if(enableApplicationTab != null && enableApplicationTab.equalsIgnoreCase("true") && supportedTypesList != null && supportedTypesList.contains(userType))
		hideApplicationTab = false;
	ArrayList enableadList = new ArrayList();
	String enablead = in.getValue("END_USER_DASHBOARD_SETTINGS","EnableADGroup");
	String byDefaultADGroupView = in.getValue("END_USER_DASHBOARD_SETTINGS","ByDefaultADGroupView");

	if(enablead != null && enablead.trim().length() > 0){
		enableadList = com.egurkha.util.StringUtils.egTokenizer(enablead, ",", true,false,true);
	}
	boolean enableAd = false;
	boolean byDefaultAdView = false;
	boolean byDefaultAdViewWithText = false;
	if(userType != null && !userType.equalsIgnoreCase("ESX") && enableadList.contains(userType))
		enableAd = true;

	if(enableAd && byDefaultADGroupView!=null && (byDefaultADGroupView.equalsIgnoreCase("true") || byDefaultADGroupView.equalsIgnoreCase("yes")))
	{
		byDefaultAdView = true;
	}
	else if(enableAd && byDefaultADGroupView!=null && byDefaultADGroupView.trim().length()>0 && !byDefaultADGroupView.equalsIgnoreCase("false") && !byDefaultADGroupView.equalsIgnoreCase("no"))
	{
		byDefaultAdViewWithText = true;
	}

	ArrayList enableFilterList = new ArrayList();
	String enableFilter = in.getValue("END_USER_DASHBOARD_SETTINGS","EnableFilter");
	String defaultFilter = in.getValue("END_USER_DASHBOARD_SETTINGS","defaultFilter");
	String subFilterStr = in.getValue("END_USER_DASHBOARD_SETTINGS","subFilter");
	if(defaultFilter == null || defaultFilter.trim().length() == 0)
		defaultFilter="Vendor";
	
	if(enableFilter != null && enableFilter.trim().length() > 0){
		enableFilterList = com.egurkha.util.StringUtils.egTokenizer(enableFilter, ",", true,false,true);
	}
	String subFilLbl1 = "Search";
	String subFilLbl2 = "Search";
	if(subFilterStr != null && subFilterStr.trim().length() > 0 && subFilterStr.indexOf(",")!=-1){
		subFilLbl1 = subFilterStr.substring(0,subFilterStr.indexOf(","));
		subFilLbl2 = subFilterStr.substring(subFilterStr.indexOf(",")+1);
	} else {
		subFilLbl1 = subFilterStr;
	}

	String enableadAppFilter = in.getValue("END_USER_DASHBOARD_SETTINGS","EnableAppFilter");
	String byDefaultAppFilterView = in.getValue("END_USER_DASHBOARD_SETTINGS","ByDefaultAppFilterView");
	ArrayList enableadAppFilList = new ArrayList();
	if(enableadAppFilter != null && enableadAppFilter.trim().length() > 0){
		enableadAppFilList = com.egurkha.util.StringUtils.egTokenizer(enableadAppFilter, ",", true,false,true);
	}

	boolean enableAppFilterView = false;
	boolean byDefaultAppFilTestView = false;
	boolean byDefaultAppFilDDView = false;
	if(userType != null && !userType.equalsIgnoreCase("ESX") && enableadAppFilList.contains(userType))
		enableAppFilterView = true;

	if(enableAppFilterView && byDefaultAppFilterView!=null && byDefaultAppFilterView.equalsIgnoreCase("TESTVIEW"))
	{
		byDefaultAppFilTestView = true;
	}
	else if(enableAppFilterView && byDefaultAppFilterView!=null && byDefaultAppFilterView.equalsIgnoreCase("DDVIEW"))
	{
		byDefaultAppFilDDView = true;
	}


	boolean enableFilt = false;
	boolean enableAppFilt = false;
	if(userType != null && enableFilterList.contains(userType))
		enableFilt = true;
	if(userType != null && enableadAppFilList.contains(userType))
		enableAppFilt = true;

	//Citrix Dashboard params
	String iniName = null,user_name = null,isUserBased = null,dashboard_name = null,view_name = null,geoInfo = null, filterName = null,filterViewName = null,countryCode = null,time_line = null,regionName = "",usercountval = null,dashboard_mapping = null,fromServiceHomePage = null,fromZonePage = null,selectedTest=null,selectedMeasure=null;

	String isFromXenVdi = request.getParameter("isFromXenVdi");
	boolean isFromXenVdiFlag=false;
	if(isFromXenVdi!=null && (isFromXenVdi.equalsIgnoreCase("true") || isFromXenVdi.equalsIgnoreCase("yes")))
	{
		isFromXenVdiFlag=true;
	}
	boolean is_csv_pdf_hide=false;
	if(isFromXenVdi!=null && (isFromXenVdi.equals("true") || isFromXenVdi.equals("yes")))
	{
		isMoreOptionsGrid  = false;
		is_csv_pdf_hide=true;
	}

	if(isFromGeo){
		IniFile geoIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_geodetails.ini",true);

		iniName = request.getParameter("iniName");
		user_name = request.getParameter("user_name");
		isUserBased = request.getParameter("isUserBased");
		dashboard_name = request.getParameter("dashboard_name");
		view_name = request.getParameter("view_name");
		time_line = request.getParameter("time_line");
		geoInfo = request.getParameter("ginfo");
		usercountval = request.getParameter("usercountval");
		dashboard_mapping = request.getParameter("dashboard_mapping");
		fromServiceHomePage = request.getParameter("fromServiceHomePage");
		fromZonePage = request.getParameter("fromZonePage");
		selectedTest = request.getParameter("selectedTest");
		selectedTest=(selectedTest==null)?"":selectedTest;
		selectedMeasure = request.getParameter("selectedMeasure");
		selectedMeasure=(selectedMeasure==null)?"":selectedMeasure;
		if(geoInfo != null && !geoInfo.equalsIgnoreCase("null") && geoInfo.trim().length() > 0){
			if(geoInfo.indexOf("-") > 0){
				regionName = geoInfo.substring(0,geoInfo.indexOf("-"));
				regionName = regionName.trim();
				String countryInfo = geoInfo.substring(geoInfo.indexOf("-")+1);
				String locCode = geoIni.getValue("COUNTRY_NAME_TO_CODE_MAPPING",countryInfo.trim());
				if(locCode == null || locCode.trim().length() == 0)
					locCode = countryInfo;
				countryCode = locCode;
				filterName = geoInfo;
				filterViewName = "Geo_Region_View";
			}
			else if(!geoInfo.equalsIgnoreCase("All") && !geoInfo.equalsIgnoreCase("World")){
				String locCode = geoIni.getValue("COUNTRY_NAME_TO_CODE_MAPPING",geoInfo);
				if(locCode == null || locCode.trim().length() == 0)
					locCode = geoInfo;
				filterName = locCode;
				filterViewName="Geo_Country_View";
			}
			else{
				filterName = "World";
				filterViewName="";
			}
		}
		else{
			filterName = "World";
			filterViewName="";
		}
	}else{
		iniName = request.getParameter("iniName");
		user_name = request.getParameter("user_name");
		isUserBased = request.getParameter("isUserBased");
		dashboard_name = request.getParameter("dashboard_name");
		view_name = request.getParameter("view_name");
		dashboard_mapping = request.getParameter("dashboard_mapping");
		fromServiceHomePage = request.getParameter("fromServiceHomePage");
		selectedTest = request.getParameter("selectedTest");
		selectedTest=(selectedTest==null)?"":selectedTest;
		selectedMeasure = request.getParameter("selectedMeasure");
		selectedMeasure=(selectedMeasure==null)?"":selectedMeasure;
	}
	user_name =(user_name!=null && user_name.trim().length()>0)?EgURLEncoder.encode(com.egurkha.util.StringUtils.encodeSecurityChar(user_name),"UTF-8"):"";
	selectedMeasure = (selectedMeasure==null ||selectedMeasure.trim().length() == 0)?"":EgURLEncoder.encode(selectedMeasure,"UTf-8");
	ErUtils erUtils = new ErUtils();
	String monitor_Skin = user.getMonitorSkin();
	String  script_src="script_item_"+thisLanguage+".js";
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String title = mappingInfo.getTextDescription("monitor.endUserDashboard.END USER DASHBOARD");
	String strVdiHostCombo=in.getValue("END_USER_DASHBOARD_SETTINGS","showVdiHostCombo");
	strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;
	boolean showVdiHostCombo = strVdiHostCombo.equalsIgnoreCase("true")?true:false;
	String default_vdi_type=in.getValue("END_USER_DASHBOARD_SETTINGS","Default_VdiType");
	default_vdi_type=(default_vdi_type==null || default_vdi_type.trim().length()==0)?"":default_vdi_type;
	String default_vdi_type2 = "";
	String default_vdi_Name = "";

	String vdiReq = request.getParameter("vdiType");
	if(vdiReq!=null && vdiReq.length()>0)
	{
			default_vdi_type = vdiReq;
			if(vdiReq.indexOf(":") >0)
			{
				default_vdi_type2 = vdiReq.substring(0,vdiReq.indexOf(":"));
				default_vdi_Name = vdiReq.substring(vdiReq.indexOf(":")+1);

			}
			else
				default_vdi_type2 = vdiReq;
	}
	else
		default_vdi_type2 = default_vdi_type;
	
	boolean addtionalSearchFlag = false;
	String addSeachSubject = "Additional_Search";
	String additionalSearch = in.getValue(addSeachSubject,"EnableAddtionalSearch");
	if (additionalSearch!=null && additionalSearch.trim().length()>0 && (additionalSearch.equalsIgnoreCase("true") || additionalSearch.equalsIgnoreCase("yes")))
		addtionalSearchFlag = true;

	String adtnlSearchStr = request.getParameter("adtnlSearchStr");
	adtnlSearchStr = (adtnlSearchStr==null || adtnlSearchStr.trim().length()==0 || adtnlSearchStr.equalsIgnoreCase("NULL"))?"":adtnlSearchStr;
	if (adtnlSearchStr!=null && adtnlSearchStr.trim().length()>0)
		adtnlSearchStr = com.egurkha.util.StringUtils.replace(adtnlSearchStr, "\\", "\\\\");

	StringTokenizer s_colTokens = null;
	String adtnlSearchEmptyText = "";
	StringBuffer addSearchBuf = new StringBuffer();
	String adtnlSearchColumns = in.getValue(addSeachSubject,userType+":SelectedSearchColumn");
	if(adtnlSearchColumns!=null && adtnlSearchColumns.trim().length()>0 && !adtnlSearchColumns.equalsIgnoreCase("NULL"))
		s_colTokens = new StringTokenizer(adtnlSearchColumns,",");
	else
		addtionalSearchFlag = false;

	ArrayList addString=new ArrayList();
	if(s_colTokens!=null)
	{
		while(s_colTokens.hasMoreTokens())
		{
			String tmpSearchCol = (String)s_colTokens.nextToken();
			if(tmpSearchCol!=null && tmpSearchCol.trim().length()>0 && tmpSearchCol.indexOf(":")!=-1)
			{
				String new_addString=tmpSearchCol.substring(tmpSearchCol.lastIndexOf(":")+1);
				if(new_addString!=null && !addString.contains(new_addString))
				{
					addSearchBuf.append(new_addString +",");

					addString.add(new_addString);
				}
			}
		}
	}

	if(addSearchBuf!=null)
		adtnlSearchEmptyText = "Search "+addSearchBuf.toString();
	if(adtnlSearchEmptyText!=null && adtnlSearchEmptyText.endsWith(","))
		adtnlSearchEmptyText = adtnlSearchEmptyText.substring(0,adtnlSearchEmptyText.lastIndexOf(","));

	String searchStringReq = request.getParameter("searchString");
	if(searchStringReq==null || searchStringReq.trim().length()==0)
		searchStringReq = request.getParameter("selectedString");
	searchStringReq=(searchStringReq==null || searchStringReq.trim().length()==0)?"":searchStringReq;
	searchStringReq = com.egurkha.util.StringUtils.replace(searchStringReq, "\\", "\\\\");
	String searchStringReqVCDS="";
	if(userType!=null && (userType.equalsIgnoreCase("VDIESX") || userType.equalsIgnoreCase("NCVDIESX") || userType.equalsIgnoreCase("RHEVVDIESX")) && searchStringReq!=null && searchStringReq.trim().length()>0)
	{
		searchStringReqVCDS=searchStringReq;
		searchStringReq="";
	}
	
	String pageNo = request.getParameter("pageNo");

	String refreshFreq=in.getValue("END_USER_DASHBOARD_SETTINGS","Refresh frequency");
	if(strTemplate!=null && !strTemplate.equals("UED"))
	{
		String refreshFreq_tmp=in.getValue("END_USER_DASHBOARD_SETTINGS","Refresh frequency:"+strTemplate);
		if(refreshFreq_tmp!=null && refreshFreq_tmp.trim().length()>0)
			refreshFreq=refreshFreq_tmp;
	}
	long refFrequency = 60 * 1000L;
	if(refreshFreq!=null && refreshFreq.length()>0)
	{
		refFrequency =  Long.valueOf(refreshFreq).longValue() * 1000L;
	}


	boolean isHaveCloudDesktop=false;
	boolean isHaveOnlyCloudDesktop=false;
	boolean isOtherType=false;
	ArrayList cloudServerTypes = (ArrayList)user.getServersForType("Cloud_VMs");
	if(cloudServerTypes!=null && cloudServerTypes.size()>0)
	{
		isHaveCloudDesktop=true;
		String str_comp_type=in.getValue("USER_TYPE_COMPONENTS","VDI");

		ArrayList comp_typ_list = (ArrayList)com.egurkha.util.StringUtils.egTokenizer(str_comp_type, ",",false,true,true);		//param 3-->includeEmpty,4-->unique,5-->trim

		if(comp_typ_list!=null)
		{
			comp_typ_list.remove("Cloud_VMs");
			
			for(int gg=0;gg<comp_typ_list.size();gg++)
			{
				String ctype_str=(String)comp_typ_list.get(gg);
				ArrayList otherServerTypes = (ArrayList)user.getServersForType(ctype_str);
				if(otherServerTypes!=null && otherServerTypes.size()>0)
				{
					isOtherType=true;
				}

				if(isOtherType)
					break;
			}

			if(!isOtherType)
			{
				isHaveOnlyCloudDesktop=true;
			}
		}
	}

	String appOverviewTypesStr = in.getValue("Applications_Overview","OverviewTypes");
	String appDetailsTypesStr = in.getValue("Applications_Overview","DetailsTypes");

	ArrayList appOverviewSupportTypeList = new ArrayList();
	ArrayList appDetailsSupportTypeList = new ArrayList();

	if(appOverviewTypesStr!=null && appOverviewTypesStr.length()>0)
		appOverviewSupportTypeList =  com.egurkha.util.StringUtils.egTokenizer(appOverviewTypesStr, ",",false,true,true);

	if(appDetailsTypesStr!=null && appDetailsTypesStr.length()>0)
		appDetailsSupportTypeList =  com.egurkha.util.StringUtils.egTokenizer(appDetailsTypesStr, ",",false,true,true);

	String otherUserTypesStr = in.getValue("OTHERTHEN_XENAPPS_USER_TYPES","UserTypes");
	ArrayList otherUserTypesList = new ArrayList();

	if(otherUserTypesStr!=null && otherUserTypesStr.length()>0)
		otherUserTypesList =  com.egurkha.util.StringUtils.egTokenizer(otherUserTypesStr, ",",false,true,true);

	String fromctx = request.getParameter("fromctx");
	fromctx = (fromctx==null || fromctx.trim().length()==0)?"":fromctx;

	boolean isMetricsSessionHostFlg=false;
	String fromMetricsSessionHost = request.getParameter("isMetricsSessionHost");
	if(fromMetricsSessionHost!=null && (fromMetricsSessionHost.equalsIgnoreCase("true") || fromMetricsSessionHost.equalsIgnoreCase("yes")))
		isMetricsSessionHostFlg=true;

	boolean isMetricsCloudDesktopsFlg=false;
	String fromMetricsCloudDesktops = request.getParameter("isMetricsCloudDesktops");
	if(fromMetricsCloudDesktops!=null && (fromMetricsCloudDesktops.equalsIgnoreCase("true") || fromMetricsCloudDesktops.equalsIgnoreCase("yes")))
		isMetricsCloudDesktopsFlg=true;

	boolean isMetricsAWSCloudDesktopsFlg=false;
	String fromMetricsAWSCloudDesktops = request.getParameter("isMetricsAWSCloudDesktops");
	if(fromMetricsAWSCloudDesktops!=null && (fromMetricsAWSCloudDesktops.equalsIgnoreCase("true") || fromMetricsAWSCloudDesktops.equalsIgnoreCase("yes")))
		isMetricsAWSCloudDesktopsFlg=true;

	boolean isMetricsPhysicalDesktopsFlg=false;
	String fromMetricsPhysicalDesktops = request.getParameter("isMetricsPhysicalDesktops");
	if(fromMetricsPhysicalDesktops!=null && (fromMetricsPhysicalDesktops.equalsIgnoreCase("true") || fromMetricsPhysicalDesktops.equalsIgnoreCase("yes")))
		isMetricsPhysicalDesktopsFlg=true;

	String compCombo = request.getParameter("compCombo");
	String sessionhostName=null;
	String compDisplyName=null;
	if((isMetricsSessionHostFlg || isMetricsCloudDesktopsFlg || isMetricsAWSCloudDesktopsFlg || isMetricsPhysicalDesktopsFlg) && compCombo!=null && compCombo.trim().length()>0)
	{
		ArrayList sessionHostList  = StringUtils.egTokenizer(compCombo,":",false,true,true);
		if(sessionHostList!=null && sessionHostList.size()==3)
		{
			if(isMetricsSessionHostFlg)
				sessionhostName = (String)sessionHostList.get(1);
			else if(isMetricsCloudDesktopsFlg)
				compDisplyName = (String)sessionHostList.get(1);
			else if(isMetricsPhysicalDesktopsFlg)
				compDisplyName = (String)sessionHostList.get(1);
			else if(isMetricsAWSCloudDesktopsFlg)
				compDisplyName = (String)sessionHostList.get(1);
		}
	}
	
	String s_default_priority=in.getValue("User_Default_Limits",userName);
	if(s_default_priority==null || s_default_priority.trim().length()==0)
	{
		s_default_priority=in.getValue("END_USER_DASHBOARD_SETTINGS","Default");
		if(strTemplate!=null && !strTemplate.equals("UED"))
		{
			String s_default_pri=in.getValue("END_USER_DASHBOARD_SETTINGS","Default"+strTemplate);
			if(s_default_pri!=null && s_default_pri.trim().length()>0)
				s_default_priority=s_default_pri;
		}
	}
	//if(userType!=null && userType.equalsIgnoreCase("VCDataStore"))
		//s_default_priority=in.getValue("END_USER_DASHBOARD_SETTINGS","DefaultDatastore");
	String s_default_limit=s_default_priority;
	String limitReq = request.getParameter("priority");
	if(limitReq!=null && limitReq.length()>0)
		s_default_priority = limitReq;

	if((s_default_limit==null || s_default_limit.trim().length()==0) && limitReq!=null && limitReq.length()>0)
	{
		s_default_limit=limitReq;
	}
	String searchEmptyText = "";
	String searchNoText = mappingInfo.getTextDescription("monitor.common.Users/Desktops");
	if(userType!=null && userType.trim().length()>0)
	{
		if(userType.equalsIgnoreCase("VCDataStore") || userType.equalsIgnoreCase("NCDataStore") || userType.equalsIgnoreCase("RHEVDataStore"))
		{
			searchEmptyText = "Search Datastores";
			searchNoText=mappingInfo.getTextDescription("monitor.common.Datastores");
		}
		else if(userType.equalsIgnoreCase("VDIESX") || userType.equalsIgnoreCase("NCVDIESX") || userType.equalsIgnoreCase("RHEVVDIESX"))
			searchEmptyText = "Search Users/Desktops";
		else if(userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7") || userType.equalsIgnoreCase("CitrixXenVDI"))
		{
			searchEmptyText = "Search Users";
		}
		else if(userType.equalsIgnoreCase("VDI") || userType.equalsIgnoreCase("AWS") || userType.equalsIgnoreCase("PDESK")  || userType.equalsIgnoreCase("Terminal") || userType.equalsIgnoreCase("Horizon") || userType.equalsIgnoreCase("WVD") || userType.equalsIgnoreCase("DWINVD"))
		{
			if(userType.equalsIgnoreCase("WVD") && fromctx!=null && fromctx.trim().length()>0 && !fromctx.equalsIgnoreCase("null"))
				searchEmptyText = "Search Desktops";
			else if(userType.equalsIgnoreCase("DWINVD"))
			{
				searchEmptyText = "Search Session Hosts";
				searchNoText=mappingInfo.getTextDescription("monitor.common.Session Hosts");
			}
			else
				searchEmptyText = "Search Users/Desktops";
		}
		else if(userType.equalsIgnoreCase("ESX"))
		{
			if(isMetricsLayerModelFlg)
			{
				searchEmptyText = "Search VMs/Users";
				searchNoText=mappingInfo.getTextDescription("monitor.common.VMs/Users");
			}
			else
			{
				searchEmptyText = "Search VMs";
				searchNoText=mappingInfo.getTextDescription("monitor.common.VMs");
			}
			
		}
		else if(userType.equalsIgnoreCase("IGEL"))
		{
			searchEmptyText = "Search IGEL Endpoint";
			searchNoText=mappingInfo.getTextDescription("monitor.common.IGEL Endpoint");
		}
		//else if(userType.equalsIgnoreCase("AppXenApp7") || userType.equalsIgnoreCase("AppDDXenApp7") || userType.equals("OverviewAppXenApp7") || userType.equals("OverviewAppVDI"))
		else if(appOverviewSupportTypeList.contains(userType) || appDetailsSupportTypeList.contains(userType))
		{
			searchEmptyText = "Search Applications";
			searchNoText=mappingInfo.getTextDescription("monitor.common.Applications");
		}
	}

	boolean disableSearchString=false;
	if(appDetailsSupportTypeList!=null && appDetailsSupportTypeList.contains(userType))
	{
		disableSearchString=true;
	}

	String userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for")+" "+userType;
	boolean endUserOverviewFlag = false;

	String usersByLocation = in.getValue("END_USER_DASHBOARD_SETTINGS","UsersByLocation");
	usersByLocation = (usersByLocation==null || usersByLocation.trim().length()==0)?"false":usersByLocation;
	boolean isUsersByLocation = (usersByLocation.equalsIgnoreCase("true") || usersByLocation.equalsIgnoreCase("yes"))?true:false;

	String showUsersByLocation = in.getValue("END_USER_DASHBOARD_SETTINGS","ShowUsersByLocation");
	showUsersByLocation = (showUsersByLocation==null || showUsersByLocation.trim().length()==0)?"false":showUsersByLocation;
	boolean isShowUsersByLocation = (showUsersByLocation.equalsIgnoreCase("true") || showUsersByLocation.equalsIgnoreCase("yes"))?true:false;

	String endUserDashOverview = request.getParameter("endUserDashOverview");
	endUserDashOverview = (endUserDashOverview==null || endUserDashOverview.trim().length()==0)?"":endUserDashOverview;
	String endUserOverviewParams = "";
	if(endUserDashOverview!=null && endUserDashOverview.trim().length()>0 && (endUserDashOverview.equalsIgnoreCase("yes")||endUserDashOverview.equalsIgnoreCase("true")))
	{
		endUserOverviewFlag =  true;
		String groupByStr = in.getValue("LOC_USER_DESKTOP_METRICS","Header:"+userType);
		if(groupByStr!=null && groupByStr.trim().length()>0 && !groupByStr.equalsIgnoreCase("null"))
		{
			//if(groupByStr.indexOf(":")>-1 && groupByStr.indexOf(",")>-1)
				//groupByStr = groupByStr.substring(groupByStr.indexOf(":")+1,groupByStr.indexOf(","));

			ArrayList group_list = com.egurkha.util.StringUtils.egTokenizer(groupByStr, ",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
			StringBuffer sb_new=new StringBuffer(128);
			for(int kk=0;kk<group_list.size();kk++)
			{
				String grpStr=(String)group_list.get(kk);
				if(grpStr.startsWith("Total_Users"))
					break;
				else
				{
					String groupByStrTmp = (String)grpStr.substring(grpStr.indexOf(":")+1);

					if(groupByStrTmp!=null && groupByStrTmp.trim().length()>0)
						sb_new.append("/"+groupByStrTmp);
				}
			}
			groupByStr = sb_new.toString();

			if(groupByStr!=null)
				groupByStr = groupByStr.substring(1);
			if(groupByStr!=null && groupByStr.trim().length()>0)
				searchEmptyText = "Search "+groupByStr;
		}
		if(userType!=null && userType.trim().length()>0 && (userType.equalsIgnoreCase("XenApp") || userType.equalsIgnoreCase("XenApp7")))
			userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
		else
			userExpDashTitle = mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience By Location for")+" "+userType;
	}
	searchEmptyText = mappingInfo.getTextDescription("monitor.common."+searchEmptyText);
	String enableBackButton = request.getParameter("enableBackButton");
	enableBackButton=(enableBackButton==null || enableBackButton.trim().length()==0)?"false":enableBackButton;
	String overviewSearchStr = request.getParameter("overviewsearchstr");
	overviewSearchStr = (overviewSearchStr==null || overviewSearchStr.trim().length()==0)?"":overviewSearchStr;
	String isFromUEDOverview = request.getParameter("isfromuedoverview");
	isFromUEDOverview = (isFromUEDOverview==null || isFromUEDOverview.trim().length()==0)?"":isFromUEDOverview;
	boolean isFromUEDSort = false;
	String fromuedsort = request.getParameter("isfromuedsort");
	fromuedsort = (fromuedsort==null || fromuedsort.trim().length()==0)?"":fromuedsort;
	if(fromuedsort!=null && fromuedsort.trim().length()>0 && (fromuedsort.equalsIgnoreCase("true")||fromuedsort.equalsIgnoreCase("yes")))
		isFromUEDSort = true;
	String Limits_to=in.getValue("END_USER_DASHBOARD_SETTINGS","Limits to");
	VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
	List types =vmDashHelper.getUserTypeComponentsComboData(userType);
	int size = (types!=null && types.size()>0)?types.size():0;
	String access = request.getParameter("access");
	if(access==null)
		access = request.getParameter("Access");
	access=(access==null || access.trim().length()==0)?"":access;

	if(desktopName!=null && desktopName.trim().length()>0 && (access==null || access.trim().length()==0))
		access="allusers";

	IniFile dashIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_dashboardConfig.ini",true);
	boolean isDetailsFromADOnly = false;
	String locStr = dashIni.getValue("USER_LOCATION_TEST_CONFIG",userType+":ShowLocationFromADOnly");
	if(locStr != null && locStr.trim().length() > 0 && (locStr.equalsIgnoreCase("true") || locStr.equalsIgnoreCase("yes"))){
		isDetailsFromADOnly = true;
	}

	ArrayList uedMenuList=new ArrayList();	
	List utc_list = new LinkedList();
	List new_types = new LinkedList();

	String new_selection="";
	String fMV = request.getParameter("fromMetricView");
	String fmvtowvd = request.getParameter("fromMetricViewToWVDView");
	String ApplicationExpDash = request.getParameter("ApplicationExpDash");
	boolean isApplicationExpDash=(ApplicationExpDash != null && ApplicationExpDash.trim().length()>0 && ApplicationExpDash.equalsIgnoreCase("true"))?true:false;
	
	try{		
		
		Hashtable getResult =vmDashHelper.getUserTypeComponentsComboNewTypesData(in,fMV,fmvtowvd,ApplicationExpDash,isFromGeo,showVdiHostCombo,types,appOverviewSupportTypeList,userType,vmDashHelper);
		
		types = (List)getResult.get("types");
		size = ((Integer)getResult.get("size")).intValue();
		showVdiHostCombo = ((Boolean)getResult.get("showVdiHostCombo")).booleanValue();
		utc_list = (List)getResult.get("utc_list");
		new_types = (List)getResult.get("new_types");
		uedMenuList = (ArrayList)getResult.get("uedMenuList");

	}catch(Exception em){}

	String currOrderBy =request.getParameter("orderBy");
	currOrderBy=(currOrderBy==null || currOrderBy.trim().length()==0)?"":currOrderBy;

	String currOrderByColumn = request.getParameter("orderByColumn");
	currOrderByColumn=(currOrderByColumn==null || currOrderByColumn.trim().length()==0)?"":EgURLEncoder.encode(currOrderByColumn,"UTf-8");
	String currColType = request.getParameter("columnType");
	currColType = (currColType==null || currColType.trim().length()==0)?"":currColType;
	String currColdispName = request.getParameter("columnDispName");
	currColdispName = (currColdispName==null || currColdispName.trim().length()==0)?"":currColdispName;

	String fromMetricView = request.getParameter("fromMetricView");
	fromMetricView = (fromMetricView==null || fromMetricView.trim().length()==0)?"":fromMetricView;

	String fromMetricViewToWVDView = request.getParameter("fromMetricViewToWVDView");
	fromMetricViewToWVDView = (fromMetricViewToWVDView==null || fromMetricViewToWVDView.trim().length()==0)?"":fromMetricViewToWVDView;
	
	String comptype = request.getParameter("comptype");
	String treeTitle = request.getParameter("treeTitle");
	String ltest = request.getParameter("ltest");
	String monitorsBy = request.getParameter("monitorsBy");
	String isLogonType = request.getParameter("isLogonType");
	String componentNameSearch = request.getParameter("componentNameSearch");
	String fromPageView = request.getParameter("fromPageView");
	String isMetricsSessionHost = request.getParameter("isMetricsSessionHost");
	String isMetricsEndpoints = request.getParameter("isMetricsEndpoints");
	String isMetricsCloudDesktops = request.getParameter("isMetricsCloudDesktops");
	String isMetricsAWSCloudDesktops = request.getParameter("isMetricsAWSCloudDesktops");
	String isMetricsPhysicalDesktops = request.getParameter("isMetricsPhysicalDesktops");
	String isWhichInsideGrid = request.getParameter("isWhichInsideGrid");
	String selectedState = request.getParameter("selectedState");
	String viewPageTitle = request.getParameter("viewPageTitle");
	String action = request.getParameter("action");
	String fromHomepage = request.getParameter("fromHomepage");
	String isfromCitrix = request.getParameter("isfromCitrix");
	String isfromRum = request.getParameter("isfromRum");
	String isFromZone = request.getParameter("isFromZone");
	String iszoneName = request.getParameter("iszoneName");
	String parentZone = request.getParameter("parentZone");
	String appliesTo = request.getParameter("appliesTo");
	String fromSerComboChange = request.getParameter("fromSerComboChange");
	String filterByFlag = request.getParameter("filterByFlag");
	String filterByParamFlag = request.getParameter("filterByParamFlag");
	String aduserFilter = request.getParameter("aduserFilter");
	String appFilter = request.getParameter("appFilter");
	String overviewType = request.getParameter("overviewType");
	String uedOverviewType = request.getParameter("uedOverviewType");
	//back to service 
	
	String filter = request.getParameter("filter");
	String selectedRum = request.getParameter("selectedRum");
	String isFromServiceMenu = request.getParameter("isFromServiceMenu");
	String isFromZoneMain = request.getParameter("isFromZoneMain");
	String isFromZoneMenu = request.getParameter("isFromZoneMenu");
	String isFromServiceGroup = request.getParameter("isFromServiceGroup");
	String serviceComponent = request.getParameter("serviceComponent");
	String segmentComponent = request.getParameter("segmentComponent");
	String fromHostPanel = request.getParameter("fromHostPanel");
	String zoneComponent = request.getParameter("zoneComponent");
	String zoneAggregate = request.getParameter("zoneAggregate");
	if(byDefaultAdView)
		aduserFilter = (aduserFilter==null || aduserFilter.trim().length()==0)?"All":aduserFilter;
	else if(byDefaultAdViewWithText)
		aduserFilter = (aduserFilter==null || aduserFilter.trim().length()==0)?byDefaultADGroupView:aduserFilter;
	else
		aduserFilter = (aduserFilter==null || aduserFilter.trim().length()==0)?"":aduserFilter;

	aduserFilter=  com.egurkha.util.StringUtils.replace(aduserFilter,"|eq|","=");

	if(byDefaultAppFilTestView)
		appFilter = (appFilter==null || appFilter.trim().length()==0)?"TESTVIEW":appFilter;
	else if(byDefaultAppFilDDView)
		appFilter = (appFilter==null || appFilter.trim().length()==0)?byDefaultAppFilterView:appFilter;
	else
		appFilter = (appFilter==null || appFilter.trim().length()==0)?"":appFilter;

	appFilter=  com.egurkha.util.StringUtils.replace(appFilter,"|eq|","=");

	String filterParam="";

	String filterFlag = request.getParameter("filterFlag");
	String detail = request.getParameter("detail");
	//String compCombo = request.getParameter("compCombo");
	String filterBy = request.getParameter("filterBy");
	if(filterBy==null || filterBy.trim().length()==0)
	{
		if(isOnlyVMAssigned && !isVMAssigned)
		{
			filterBy="Virtual_Machine";
		}
		else
			filterBy="All";
	}
	if(comptype != null && comptype.equalsIgnoreCase("WVD_RDS_server")){
		filterByFlag = filterBy;
		filterBy = "All";
	}
	String subFilter = request.getParameter("subFilter");
	String searchFilter = request.getParameter("searchFilter");
	String nextSearch = request.getParameter("nextSearch");
	String nextSubSearch = request.getParameter("nextSubSearch");
	String fromf5 = request.getParameter("fromf5");
	String priorityFilter = request.getParameter("priorityFilter");
	String gatewayFilter = request.getParameter("gatewayFilter");
	String bpoNameFilter = request.getParameter("bpoNameFilter");

	String compComboType="";
	String compComboComp="";
	if(compCombo!=null && compCombo.trim().length()>0 && compCombo.indexOf(":")!=-1)
	{
		compComboType = compCombo.substring(0,compCombo.indexOf(":"));
		compComboComp = compCombo.substring(compCombo.indexOf(":")+1);
	}

	String gatewayOption=in.getValue("END_USER_DASHBOARD_SETTINGS",userType+":Gateway");
	boolean isGateway=true;
	if(gatewayOption==null || gatewayOption.trim().length()==0 || gatewayOption.equalsIgnoreCase("false") || gatewayOption.equalsIgnoreCase("no"))
	{
		gatewayFilter = "";
		isGateway=false;
	}

	String bpoNameOption=in.getValue("END_USER_DASHBOARD_SETTINGS","EnableBPOFilter");
	boolean isBPONameEnable=true;
	if(bpoNameOption==null || bpoNameOption.trim().length()==0 || bpoNameOption.equalsIgnoreCase("false") || bpoNameOption.equalsIgnoreCase("no"))
	{
		bpoNameFilter = "";
		isBPONameEnable=false;
	}

	if(isMetricsLayerModel!=null && isMetricsLayerModel.trim().length()>0)
		showVdiHostCombo = false;

	String isFromVCDS = request.getParameter("isFromVCDS");
	isFromVCDS = (isFromVCDS==null || isFromVCDS.trim().length()==0)?"":isFromVCDS;

	String dsUserType = request.getParameter("dsUserType");
	dsUserType = (dsUserType==null || dsUserType.trim().length()==0)?"":dsUserType;

	if(filterFlag != null && filterFlag.equalsIgnoreCase("true")){
		//if(isFromVCDS!=null && (isFromVCDS.equalsIgnoreCase("true") || isFromVCDS.equalsIgnoreCase("yes")))
		//{
			//filterParam ="&filterFlag=false";
		//}
		//else
			filterParam ="&filterFlag=true";

		filterParam+="&detail="+detail;
		filterParam+="&compCombo="+compCombo;
		filterParam+="&filterBy="+filterBy;
		filterParam+="&searchFilter="+searchFilter;
		filterParam+="&nextSearch="+nextSearch;
		filterParam+="&nextSubSearch="+nextSubSearch;
		filterParam+="&fromf5="+fromf5;
		filterParam+="&priorityFilter="+priorityFilter;
		filterParam+="&gatewayFilter="+gatewayFilter;
		filterParam+="&isMetricsSessionHost="+isMetricsSessionHost;
		filterParam+="&isMetricsEndpoints="+isMetricsEndpoints;
		filterParam+="&isMetricsLayerModel="+isMetricsLayerModel;
		filterParam+="&isMetricsCloudDesktops="+isMetricsCloudDesktops;
		filterParam+="&isMetricsAWSCloudDesktops="+isMetricsAWSCloudDesktops;
		filterParam+="&isMetricsPhysicalDesktops="+isMetricsPhysicalDesktops;
		filterParam+="&isWhichInsideGrid="+isWhichInsideGrid;
		filterParam+="&bpoNameFilter="+bpoNameFilter;
	}

	if(isFromVCDS!=null && (isFromVCDS.equalsIgnoreCase("true") || isFromVCDS.equalsIgnoreCase("yes")))
	{
		String dscomp = request.getParameter("dscomp");
		String dscomptype = request.getParameter("dscomptype");
		String dsInfo = request.getParameter("dsInfo");
		String dscompName = request.getParameter("dscompName");
		String dscomponentName = request.getParameter("dscomponentName");
		String dsmsmt_host = request.getParameter("dsmsmt_host");

		filterParam+="&isFromVCDS="+isFromVCDS;
		filterParam+="&dscomp="+dscomp;
		filterParam+="&dscomptype="+dscomptype;
		filterParam+="&dsInfo="+dsInfo;
		filterParam+="&dscompName="+dscompName;
		filterParam+="&dscomponentName="+dscomponentName;
		filterParam+="&dsmsmt_host="+dsmsmt_host;
		filterParam+="&dsUserType="+dsUserType;

	}
	

	String aggregateTab = request.getParameter("aggregateTab");
	String selectedParam=request.getParameter("selectedParam");
	String currentTab=request.getParameter("currentTab");
	String selectNode = request.getParameter("selectNode");
	String ctxCsrfToken = request.getParameter("com.eg.CSRF_NONCE");
	ctxCsrfToken = (ctxCsrfToken==null||ctxCsrfToken.trim().length()==0)?"":ctxCsrfToken;
	String fromCtxParams = "";
	if(fromctx!=null && fromctx.trim().length()>0 && !fromctx.equalsIgnoreCase("null"))
	{
		String sel_Node= "Zone^"+selectedParam;
		sel_Node = com.egurkha.util.StringUtils.replace(sel_Node, "^", "|cap|");
		fromCtxParams = "&fromctx="+fromctx+"&selectNode="+EgURLEncoder.encode(sel_Node,"UTf-8")+"&selectedParam="+selectedParam+"&fromHomepage="+fromHomepage+"&aggregateTab="+aggregateTab+"&zoneName="+selectedParam;
		filterParam+="&comptype="+comptype;
		
		fromCtxParams+="&parentZone="+parentZone+"&iszoneName="+iszoneName+"&isFromZoneMenu="+isFromZoneMenu+"&fromPageView="+fromPageView+"&filterBy="+filterBy;
	
		filterParam += fromCtxParams;

		addtionalSearchFlag = false;
	}
	if(ctxCsrfToken!=null && ctxCsrfToken.trim().length()>0 && !ctxCsrfToken.equalsIgnoreCase("null"))
		fromCtxParams = fromCtxParams + "&com.eg.CSRF_NONCE="+ctxCsrfToken;
	String treeFlag_SBD = request.getParameter("treeFlag_SBD");
	String outsideService_SBD = request.getParameter("outsideService_SBD");
	String titleText_SBD = request.getParameter("titleText_SBD");
	String selectNode_SBD = request.getParameter("selectNode_SBD");
	String isEmulTrans_SBD = request.getParameter("isEmulTrans_SBD");
	String serviceName = request.getParameter("serviceName");
	String serviceState_SBD = request.getParameter("serviceState_SBD");
	String isServiceBusiDash = request.getParameter("isServiceBusiDash");
	String isServiceBusiViewMetrics = request.getParameter("isServiceBusiViewMetrics");

	String showUserLocations = in.getValue("GEO_LOCATION_SETTINGS",userType+":ShowUserLocations");
	showUserLocations = (showUserLocations==null || showUserLocations.trim().length()==0)?"":showUserLocations;
	boolean isShowUserLocation = false;
	if(showUserLocations!=null && showUserLocations.trim().length()>0 && (showUserLocations.equalsIgnoreCase("true") || showUserLocations.equalsIgnoreCase("yes")))
	{
		isShowUserLocation = true;
	}
	String cityFilter = "";
	String vendorFilter = "";
	String filterNames = new String();
	String cType = (comptype == null || comptype.length() == 0 || comptype.equals("null"))?default_vdi_type2:comptype;
%>
<html>
<head>
		<script language="JavaScript1.2" type="text/JavaScript"> 
			var backObject = new Object();
			backObject.comptype='<%=cType%>';
			backObject.cmpType='<%=cType%>';
			backObject.cmpName='<%=default_vdi_Name%>';
			backObject.treeTitle='<%=treeTitle%>';
			backObject.ltest='<%=ltest%>';
			backObject.monitorsBy='<%=monitorsBy%>';
			backObject.isLogonType='<%=isLogonType%>';
			backObject.componentNameSearch='<%=componentNameSearch%>';
			backObject.fromPageView='<%=fromPageView%>';
			backObject.isMetricsSessionHost='<%=isMetricsSessionHost%>';
			backObject.isWhichInsideGrid='<%=isWhichInsideGrid%>';
			backObject.isMetricsEndpoints='<%=isMetricsEndpoints%>';
			backObject.isMetricsLayerModel='<%=isMetricsLayerModel%>';
			backObject.isMetricsCloudDesktops='<%=isMetricsCloudDesktops%>';
			backObject.isMetricsPhysicalDesktops='<%=isMetricsPhysicalDesktops%>';
			backObject.isMetricsAWSCloudDesktops='<%=isMetricsAWSCloudDesktops%>';
			backObject.selectedState='<%=selectedState%>';
			backObject.viewPageTitle='<%=viewPageTitle%>';
			backObject.action='<%=action%>';
			backObject.fromHomepage='<%=fromHomepage%>';
			backObject.overviewType='<%=overviewType%>';
			backObject.uedOverviewType='<%=uedOverviewType%>';

			var searchComponents='<%= mappingInfo.getTextDescription("monitor.common.Components")%>';
			var searchSimulations='<%= mappingInfo.getTextDescription("monitor.common.Simulations")%>';
			var searchSystems='<%= mappingInfo.getTextDescription("monitor.common.Systems")%>';
			var searchRecords='<%= mappingInfo.getTextDescription("monitor.common.Records")%>';
			var searchUsers='<%=searchNoText%>';
			var searchNo='<%= mappingInfo.getTextDescription("monitor.common.No")%>';
			var searchFound='<%= mappingInfo.getTextDescription("monitor.common.found")%>';
			var applications='<%= mappingInfo.getTextDescription("monitor.common.Applications")%>';
			var searchAppEmptyText = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Search Applications")%>';
			var isFromXenVdi=<%=isFromXenVdiFlag%>;
			var hideApplicationTab=<%=hideApplicationTab%>;
			var isComponentAvailable=<%=isComponentAvailable%>;
			var isAllCompAccess=<%=isAllCompAccess%>;
			var disableSearchString=<%=disableSearchString%>;

			var strSkin='<%=monitor_Skin%>';
			var timeZoneOffsetVal='';
			var fromctx="<%=fromctx%>";
			var fromctxparams = '';
			var marginHeader='0 0 0 0';
			if(fromctx != undefined && (fromctx || fromctx=='true'))
			{
				marginHeader='0 0 0 10';
				fromctxparams ="<%=fromCtxParams%>"
			}
			var fromMetricView="<%=fromMetricView%>";
			var fromMetricsSessionHost="<%=isMetricsSessionHost%>";
			var fromMetricsEndpoints="<%=isMetricsEndpoints%>";
			var fromMetricsLayerModel="<%=isMetricsLayerModel%>";
			var fromMetricsCloudDesktops="<%=isMetricsCloudDesktops%>";
			var fromisMetricsAWSCloudDesktops="<%=isMetricsAWSCloudDesktops%>";
			var fromisMetricsPhysicalDesktops="<%=isMetricsPhysicalDesktops%>";
			var isWhichInsideGrid="<%=isWhichInsideGrid%>";
			var fromMetricViewToWVDView="<%=fromMetricViewToWVDView%>";
			var disptxt = '<egui:intnl text="monitor.common.Displaying"/>';
			var errorMsgTitle = '<egui:intnl text="monitor.common.Resource Usage Analysis"/>';
			var errorMsg = "<egui:intnl text='monitor.common.Sorry! You don\'t have rights to access this page.'/>";
			var res_consum_Lbl = '<egui:intnl text="monitor.common.Server Resource Consumption"/>';
			var oftxt = '<egui:intnl text="monitor.common.of"/>';
			var isOnlyVMAssigned=<%=isOnlyVMAssigned%>;
			var isfromCitrix="<%=isfromCitrix%>";
			var isfromRum="<%=isfromRum%>";
			var isFromZone="<%=isFromZone%>";
			var iszoneName="<%=iszoneName%>";
			var parentZone="<%=parentZone%>";
			var appliesTo="<%=appliesTo%>";
			var fromSerComboChange="<%=fromSerComboChange%>";
			var filterByFlag="<%=filterByFlag%>";
			var filter="<%=filter%>";
			var filterByParamFlag="<%=filterByParamFlag%>";
			var enableAd="<%=enableAd%>";
			var enableFilt="<%=enableFilt%>";
			var enableAppFilt="<%=enableAppFilt%>";
			var filterParam="<%=filterParam%>";
			var compComboType="<%=compComboType%>";
			var compComboComp="<%=compComboComp%>";
			var sessionhostName="<%=sessionhostName%>";
			var compDisplyName="<%=compDisplyName%>";

			var enableAppFilterView="<%=enableAppFilterView%>";

			var isHaveCloudDesktop=<%=isHaveCloudDesktop%>;
			var isHaveOnlyCloudDesktop=<%=isHaveOnlyCloudDesktop%>;

			var isApplicationExpDash=<%=isApplicationExpDash%>;
			//back to service
			
			var selectedRum = "<%=selectedRum%>";
			
			var isFromServiceMenu = "<%=isFromServiceMenu%>";
			var isFromZoneMain = "<%=isFromZoneMain%>";
			var isFromZoneMenu = "<%=isFromZoneMenu%>";
			var isFromServiceGroup = "<%=isFromServiceGroup%>";
			var serviceComponent = "<%=serviceComponent%>";
			var segmentComponent = "<%=segmentComponent%>";
			var fromHostPanel = "<%=fromHostPanel%>";
			var zoneComponent = "<%=zoneComponent%>";
			var zoneAggregate = "<%=zoneAggregate%>";

			var filterByGl="<%=filterBy%>";
			var subFilterGl="<%=subFilter%>";
			var searchFilterGl="<%=searchFilter%>";
			var nextSearchGl="<%=nextSearch%>";
			var nextSubSearchGl="<%=nextSubSearch%>";
			var priorityFilterGl="<%=priorityFilter%>";
			var bpoNameFilterGl="<%=bpoNameFilter%>";
			var gatewayFilterGl="<%=gatewayFilter%>";
			var detail="<%=detail%>";
			var compComboValues="<%=compCombo%>";
			var compComboArray=[];
			if(compComboValues != null && compComboValues != undefined && compComboValues != "null")
			{
				if(compComboValues.indexOf(",")>-1)
					compComboArray=compComboValues.split(",");
				else
					compComboArray[0] = compComboValues;
			}

			var fromf5="<%=fromf5%>";
			var ShowComEnableFilt=<%=showComboFil%>;
			var defaultFilter="<%=defaultFilter%>";
			var isDetailsFromADOnly = <%=isDetailsFromADOnly%>;
			var isGateway = <%=isGateway%>;
			var isBPONameEnable = <%=isBPONameEnable%>;

			var showFilter = true;
			var showAppFilter = true;
			if(enableFilt == true || enableFilt == 'true')
				showFilter = false;
			if(enableAppFilt == true || enableAppFilt == 'true')
				showAppFilter = false;
			


			var showComFilter = true;
			if(ShowComEnableFilt)
				showComFilter = false;

			var showgroupInfo = true;
			if(enableAd == true || enableAd == 'true')
				showgroupInfo = false;

			var showAppFilterView = true;
			if(enableAppFilterView == true || enableAppFilterView == 'true')
				showAppFilterView = false;
			
			var panelADFilter=false;
			if(showFilter && showgroupInfo )
				panelADFilter = true;

			var aduserFilter="<%=aduserFilter%>";
			var advalue='user';
			if(aduserFilter != null && aduserFilter != undefined && aduserFilter !="")
				advalue='ad_group';

			var appFilter="<%=appFilter%>";
			var appFilValue='TESTVIEW';
			if(appFilter != null && appFilter != undefined && appFilter !="")
				appFilValue=appFilter;

			var monSkin='<%=monitor_Skin%>';

			var groupInfo = new Array();
			groupInfo.push({
					name:'User',
					value:'user'
				});

				groupInfo.push({
					name:'AD Group',
					value:'ad_group'
				});

			var appFilterInfo = new Array();
				appFilterInfo.push({
					name:'Host and User',
					value:'DDVIEW'
				});

				appFilterInfo.push({
					name:'Host',
					value:'TESTVIEW'
				});

			var vdiComboListJSON = new Array();
<%
			for(int i=0;i<size;i++)
			{
				String type = (String)types.get(i);
				String selected = "";
				if((default_vdi_type2 == null || default_vdi_type2.trim().length() == 0) && (userType!=null  && 
					utc_list!=null && utc_list.contains(userType) && userType.equalsIgnoreCase("XenApp7") && type.trim().equals("Citrix_XcXenApp_server")))
					default_vdi_type2 = type;
				else if((default_vdi_type2 == null || default_vdi_type2.trim().length() == 0) && (userType!=null  && 
					utc_list!=null && utc_list.contains(userType) && userType.equalsIgnoreCase("XenApp") && type.trim().equals("Citrix_server")))
					default_vdi_type2 = type;
				else if((default_vdi_type2 == null || default_vdi_type2.trim().length() == 0) && userType!=null && 
					utc_list!=null && utc_list.contains(userType))
					default_vdi_type2 = userType;

				if(default_vdi_type2!=null && default_vdi_type2.trim().length()>0 && type.equalsIgnoreCase(default_vdi_type2))
					selected = "true";

				String newUserType = userType;
				if(types!=null && uedMenuList!=null && uedMenuList.contains("XenApp") && uedMenuList.contains("XenApp7"))
				{
					if(userType!=null && userType.equalsIgnoreCase("XenApp"))
					{
						new_selection=mappingInfo.getComponentTypeDescription("Citrix_server");
						if(new_types!=null && new_types.contains(type))
						{
							newUserType="XenApp7";
						}
					}
					else if(userType!=null && userType.equalsIgnoreCase("XenApp7"))
					{
						new_selection=mappingInfo.getComponentTypeDescription("Citrix_XcXenApp_server");
						if(new_types!=null && new_types.contains(type))
						{
							newUserType="XenApp";
						}
					}
				}

				boolean isLocOverviewSupport=false;

				if(isUsersByLocation && isShowUsersByLocation)
				{
					String groupByStrtmp = in.getValue("LOC_USER_DESKTOP_METRICS","Header:"+type);

					if(type!=null && type.trim().equals("Citrix_XcXenApp_server"))
						groupByStrtmp = in.getValue("LOC_USER_DESKTOP_METRICS","Header:XenApp7");
					else if(type!=null && type.trim().equals("Citrix_server"))
						groupByStrtmp = in.getValue("LOC_USER_DESKTOP_METRICS","Header:XenApp");

					if(groupByStrtmp!=null && groupByStrtmp.trim().length()>0 && !groupByStrtmp.equalsIgnoreCase("null"))
					{
						isLocOverviewSupport=true;
					}
				}
				String display_name = in.getValue("DISPLAY_USERTYPE_IN_COMBO",type);
				if(display_name==null || display_name.trim().length()==0 || display_name.equals("Mapping") || display_name.equals("Default"))
				{
					if(display_name.equals("Mapping"))
					{
						String comp_type_str = in.getValue("USER_TYPE_COMPONENTS",type);
						if(comp_type_str!=null && comp_type_str.indexOf(",")==-1)
						{
							display_name = mappingInfo.getComponentTypeDescription(comp_type_str);
						}
						else
							display_name = type;
					}
					else if(display_name.equals("Default"))
					{
						if(type!=null && type.equals("VDI"))
						{
							if(isHaveOnlyCloudDesktop)
							{
								display_name = mappingInfo.getComponentTypeDescription("Cloud_VMs");
							}
							else if(isHaveCloudDesktop)
							{
								display_name = type +" & "+mappingInfo.getComponentTypeDescription("Cloud_VMs");
							}
							else
								display_name = type;
						}
						else
							display_name = type;
					}
					else
						display_name = mappingInfo.getComponentTypeDescription(type);
				}
				else if(display_name!=null && display_name.indexOf("~!~")>=0)
				{
					ArrayList disply_list = com.egurkha.util.StringUtils.egTokenizer(display_name, "~!~",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
					if(disply_list!=null && disply_list.size()==2)
					{
						String f_part=(String)disply_list.get(0);
						String s_part=(String)disply_list.get(1);
						String innerCompTypes=in.getValue("USER_TYPE_COMPONENTS",s_part);
						if(innerCompTypes!=null && innerCompTypes.indexOf(",")==-1)
							display_name = f_part+" "+mappingInfo.getComponentTypeDescription(innerCompTypes);
						else
							display_name = f_part+" "+s_part;
					}
					else if(disply_list!=null && disply_list.size()==1)
					{
						String f_part=(String)disply_list.get(0);
						String innerCompTypes=in.getValue("USER_TYPE_COMPONENTS",f_part);
						if(innerCompTypes!=null && innerCompTypes.indexOf(",")==-1)
							display_name = mappingInfo.getComponentTypeDescription(innerCompTypes);
						else
							display_name = f_part;
					}
				}

%>
				vdiComboListJSON.push({
					name:'<%=display_name%>',
					value:'<%=type%>',
					selected:'<%=selected%>',
					usertype:'<%=newUserType%>',
					isLocOverviewSupport:'<%=isLocOverviewSupport%>'
				});
<%
			}
%>
			var limtsComboJson = new Array();
			var appOverviewArrays = new Array();
			var appDetailsArrays = new Array();
			var otherUserTypeArrays = new Array();
<%
			if(Limits_to.indexOf(",")>-1){
				String[] limitsArray = Limits_to.split(",");
				for(int k=0;k<limitsArray.length;k++){
					String limit = limitsArray[k];
%>
					limtsComboJson.push({
						name:'<%=limit%>',
						value:'<%=limit%>'	
					});
<%				}
			}

			if(appOverviewSupportTypeList!=null)
			{
				for(int kk=0;kk<appOverviewSupportTypeList.size();kk++)
				{
%>
					appOverviewArrays.push("<%=(String)appOverviewSupportTypeList.get(kk)%>");
<%
				}
			}

			if(appDetailsSupportTypeList!=null)
			{
				for(int kk=0;kk<appDetailsSupportTypeList.size();kk++)
				{
%>
					appDetailsArrays.push("<%=(String)appDetailsSupportTypeList.get(kk)%>");
<%
				}
			}


			if(otherUserTypesList!=null)
			{
				for(int kk=0;kk<otherUserTypesList.size();kk++)
				{
%>
					otherUserTypeArrays.push("<%=(String)otherUserTypesList.get(kk)%>");
<%
				}
			}
%>			
			var iniName="<%=iniName%>";
			var user_name="<%=user_name%>";
			var isUserBased="<%=isUserBased%>";
			var dashboard_name="<%=dashboard_name%>";
			var view_name="<%=view_name%>";
			var filterName="<%=filterName%>";
			var filterViewName="<%=filterViewName%>";
			var countryCode="<%=countryCode%>";
			var time_line="<%=time_line%>";
			var geoInfo="<%=geoInfo%>";
			var regionName="<%=regionName%>";
			var usercountval="<%=usercountval%>";
			var dashboard_mapping="<%=dashboard_mapping%>";
			var fromServiceHomePage="<%=fromServiceHomePage%>";
			var fromZonePage="<%=fromZonePage%>";
			var selectedTest="<%=selectedTest%>";
			var selectedMeasure="<%=selectedMeasure%>";
			var searchString='<%=searchStringReq%>';
			var searchStringVCDS='<%=searchStringReqVCDS%>';
			var searchEmptyText = '<%=searchEmptyText%>';
			var adtnlSearchStr='<%=adtnlSearchStr%>';
			var adtnlSearchEmptyText = '<%=adtnlSearchEmptyText%>';
			var addtionalSearchFlag=<%=addtionalSearchFlag%>;
			var userExpDashTitle = '<%=userExpDashTitle%>';
			var endUserDashOverview = '<%=endUserDashOverview%>';
			var enableBackButton = '<%=enableBackButton%>';
			var overviewSearchStr = '<%=overviewSearchStr%>';
			var isFromUEDOverview = '<%=isFromUEDOverview%>';
			var endUserOverviewParams = '';
			var endUserOverviewFlag = <%=endUserOverviewFlag%>;
			var isfromuedsort = <%=isFromUEDSort%>;
			var pageNo='<%=pageNo%>';
			var userType='<%=userType%>';
			var isFromVCDS='<%=isFromVCDS%>';
			var dsUserType='<%=dsUserType%>';
			var refFreq = '<%=refFrequency%>';
			var refreshFreq = '<%=refreshFreq%>';
			var defaultLimit = '<%=s_default_limit%>';
			var defaultDispLimit = '<%=s_default_priority%>';
			var defaultVdiType = '<%=default_vdi_type%>';
			var defaultVdiType2 = '<%=default_vdi_type2%>'
			var showVdiHostCombo = <%=!showVdiHostCombo%>;
			var user = '<%=EgURLEncoder.encode(userName,"UTF-8")%>';
			var userName = '<%=EgURLEncoder.encode(desktopName,"UTF-8")%>';
			var desktopName = '<%=EgURLEncoder.encode(desktopName,"UTF-8")%>';
			var orderByColumn = "<%=currOrderByColumn%>";
			var orderBy = '<%=request.getParameter("orderBy")%>';
			var freqError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Refresh Frequency must be valid positive Integer and greater than 0")%>';
			var measureError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Please Select Measure")%>';
			var displayNameError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Please Enter Display Name")%>';
			var vdiComboLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Type")%>';

			var currOrderByColumn="<%=currOrderByColumn%>";
			var currOrderBy="<%=currOrderBy%>";
			var currColumnType="<%=currColType%>";
			var currColumndispName="<%=currColdispName%>";
			var tipSpe='<egui:intnl text="monitor.services.Special characters are not allowed"/>';
			var isFromMenu=<%=isFromMenu%>;
			var isFromGeo=<%=isFromGeo%>;
			var showKeyUser=<%=showKeyUser%>;
			var updateUserAssociateFlag=<%=updateUserAssociateFlag%>;
			var isDataAva = true;
			var noDataMsg = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found")%>';
			var csrfToken = "<%=ctxCsrfToken%>";
			var requestParams=new Object();
			requestParams.isServiceBusiDash="<%=isServiceBusiDash%>";
			requestParams.treeFlag_SBD = "<%=treeFlag_SBD%>";
			requestParams.outsideService_SBD = "<%=outsideService_SBD%>";
			requestParams.titleText_SBD = "<%=titleText_SBD%>";
			requestParams.selectNode_SBD = "<%=selectNode_SBD%>";
			requestParams.isEmulTrans_SBD = "<%=isEmulTrans_SBD%>";
			requestParams.serviceState_SBD = "<%=serviceState_SBD%>";
			requestParams.serviceName = "<%=serviceName%>";
			requestParams.isServiceBusiViewMetrics = "<%=isServiceBusiViewMetrics%>";
			requestParams.selectedParam = "<%=selectedParam%>";
			requestParams.currentTab = "<%=currentTab%>";
			requestParams.selectNode = "<%=selectNode%>";
			requestParams.aggregateTab = "<%=aggregateTab%>";
			requestParams.fromPageView="<%=fromPageView%>";
			requestParams.isWhichInsideGrid="<%=isWhichInsideGrid%>";
			requestParams.isMetricsSessionHost="<%=isMetricsSessionHost%>";
			requestParams.isMetricsEndpoints="<%=isMetricsEndpoints%>";
			requestParams.isMetricsLayerModel="<%=isMetricsLayerModel%>";
			requestParams.isMetricsCloudDesktops="<%=isMetricsCloudDesktops%>";
			requestParams.isMetricsAWSCloudDesktops="<%=isMetricsAWSCloudDesktops%>";
			requestParams.isMetricsPhysicalDesktops="<%=isMetricsPhysicalDesktops%>";
			var isServiceBusiViewMetrics = "<%=isServiceBusiViewMetrics%>";
<%
			if(new_types!=null && new_types.size()>0)
			{
%>
			var vdiComboEmptyText = '<%=new_selection%>';
<%
			}
			else
			{
%>
			var vdiComboEmptyText = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Select a Type")%>';
<%
			}
%>
			var searchLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Search")%>';
			var limitComboLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Limits")%>';
			var limitComboEmptyText = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Select a Limit")%>';
			var defaultSettings = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Default Settings")%>';
			var refFrequency = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Refresh Frequency")%>';
			var addOrDelete = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Add/Delete")%>';
			var addLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Add")%>';
			var deleteLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Delete")%>';
			var TestLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Test")%>';
			var MeasureLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Measure")%>';
			var DisplayLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Display Name")%>';
			var priority='<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Priority")%>';
			var bponame='<%= mappingInfo.getTextDescription("monitor.endUserDashboard.BPO Name")%>';
			//var gateway='<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Gateway")%>';
			var gateway='<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Netscaler")%>';
			var submit='<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Submit")%>';
			var UpdateLabel = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Update")%>';
			var UpdateError = '<%= mappingInfo.getTextDescription("monitor.endUserDashboard.Already Exists")%>';
			var optionsLabel = '<egui:intnl text="monitor.endUserDashboard.What would you like to do?"/>';
			var savePdfLabel = '<egui:intnl text="monitor.endUserDashboard.Save as PDF"/>';
			var saveExcelLabel = '<egui:intnl text="monitor.endUserDashboard.Save as Excel"/>';
			var dragDisabledMsg = '<egui:intnl text="monitor.endUserDashboard.Dragging not allowed for disabled measures"/>';
			var dragUnSelectedMsg = '<egui:intnl text="monitor.endUserDashboard.Dragging not allowed for unselected measures"/>';
			var resourceUsageBack = '<egui:intnl text="monitor.common.Back"/>';
			var filterLabel = (<%=isDetailsFromADOnly%> == true || <%=isDetailsFromADOnly%> == 'true')?'Filter BY':defaultFilter;
			var subFilLbl1 = '<%=subFilLbl1%>';
			var subFilLbl2 = '<%=subFilLbl2%>';
			var desktopNameHideFlag=false;
			if(userName!=null && userName!= undefined && userName!="")
			{
				desktopNameHideFlag=true;
			}
			var isMoreOptionsGrid = <%=isMoreOptionsGrid%>;
			var csv_pdf_hide = <%=is_csv_pdf_hide%>;
			if(fromctx!=null && fromctx!='null' && fromctx!='' && fromctx!='undefined')
				csv_pdf_hide = true;
			//var headerPadding ='0 0 0 10';
			//if(endUserOverviewFlag)
			var headerPadding = '10 0 0 0'; 
			var rca;

			function openRemoteControl(url)
			{
				var agentIP;
				if(url.indexOf("ipaddress=")>-1){
					agentIP = url.substr(url.indexOf("ipaddress=")+10);
					if(agentIP.indexOf("&")>-1){
						agentIP= agentIP.substr(0,agentIP.indexOf("&"));
					}
				}
				var fontColorCode =('<%=monitor_Skin%>'=="Light")?"#6c6c6c":"#7d7d7d";

				var bWidth = Ext.getBody().dom.clientWidth;
				var bHeight = Ext.getBody().dom.clientHeight;

				//console.log("url---->"+url);
				rca=Ext.widget("window",{
					extend: 'Ext.panel.Panel',
					title: '<egui:intnl text="admin.common.Remote Control Actions"/>',
					id:'remoteControl',
					//height: '98.5%',
					//width: '99%',
					width:bWidth-16,
					height:bHeight-9,
					x:8,
					y:8,
					resizable:false,
					border:false,
					ui:'grayHeaderWindow',
					modal: true,
					bodyPadding:0,
					ghost:false,
					closeAction:'destroy',
					//header:{
						//cls:'textUpper'
					//},
					html: '<iframe src='+url+' frameborder="0" width="100%" height="100%" ></iframe>',
					listeners:{
						'render': function (panel) {
							Ext.EventManager.onWindowResize(function (w, h) {
								panel.setHeight(h-8);
								panel.setWidth(w-15);
								panel.doComponentLayout();
							});
						},
						show: function(win) {
							if (this.modal) {
								var doms = Ext.dom.Query.select('.x-mask'); 
								for (var key in doms)
								{
									this.dom=doms[key];
									if (!Ext.isEmpty(this.dom.offsetParent))
									{
										if (this.dom.offsetParent.tagName=='BODY')
										{
											Ext.fly(this.dom).addCls('windowModalLight');
										}
									} 
								} 
							}
						},
						hide:  function(win) {
							if (this.modal) { 
								Ext.fly(this.dom).removeCls('windowModalLight');
							}
						},
						destroy:  function(win) {
							Ext.Ajax.request({
								url : "/final/monitor/RemoteControlActionUtils.jsp?action=delete&agentIP="+agentIP,
								method : 'POST',
								scope:this,
								success: function(response)
								{
									//alert("deleted");	
								},
								failure:function()
								{
								}
							});
						}
					},
				}).show();
			}
		</script>
<%
	if((access!=null && (access.equalsIgnoreCase("allusers") || access.equalsIgnoreCase("Application") )) || (desktopName!=null && desktopName.trim().length()>0))
	{
%>
		<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="endUserDashboard" appFile="app.js"/>
		<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
		<link rel="stylesheet" href="/final/styles/uxDashboard<%=monitor_Skin%>.css" />
		
		<egui:skin ui="monitor"/>
		<script language = "JavaScript1.2" src = "/final/scripts/<%=script_src%>"></script>
		<script src="/final/jquery/jquery.js"></script>
		<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/dashboardutils.js"></script>
		<!--<link rel="stylesheet" href="/final/styles/ext-custom-com-uxdashboard.css" />-->
		<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
		<script src="/final/Highcharts/js/highcharts-more.js"></script>
		<script src="/final/Highcharts/js/solid-gauge.src.js"></script>
		<script src="../monitor/eg_scripts/EgHighChart.js"></script>
		<script language="javascript" type="text/javascript" src="/final/monitor/eg_scripts/egDashboardHighChart.js"></script>

		<script src="/final/scripts/d3.v5.min.js"></script>

		<script src="../monitor/eg_scripts/dashboards/GeneralMeasuresGrid.js"></script>
		<script src="../monitor/eg_scripts/dashboards/GeneralMeasuresGridPanel.js"></script>
		<style>
		.stateSymbol_15_HIGH,.stateSymbol_15_INTERMEDIATE,.stateSymbol_15_LOW,.stateSymbol_15_UNKNOWN,.stateSymbol_15_GOOD {
			background: url('/final/monitor/eg_scripts/endUserDashboard/images/state-icon.png') no-repeat top left!important
		}

		.stateSymbol_15_HIGH {
			background-position: -106px -69px !important;
			width: 15px;
			height: 18px;
		}

		.stateSymbol_15_INTERMEDIATE {
			background-position: -146px -67px !important;
			width: 15px;
			height: 18px;
		}

		.stateSymbol_15_LOW {
			background-position: -183px -67px!important;
			width: 15px;
			height: 18px;
		}

		.stateSymbol_15_UNKNOWN {
			background-position: -270px -67px !important;
			width: 15px;
			height: 18px;
		}

		.stateSymbol_15_GOOD {
			background-position: -225px -69px !important;
			width: 15px;
			height: 18px;
		}

		.stateSymbol_15_GRAY {
			background-position: -300px -199px !important;
			width: 16px;
			height: 18px;
		}
/*  
hidden for using default newGridPanel styles for row height issue.
		.x-panel-newGridPanel .x-grid-cell-inner{
			padding: 6px 10px 6px 10px !important;
		}

		.x-panel-newGridPanel .x-grid-cell.x-grid-cell-first .x-grid-cell-inner{
			padding: 5px 10px 3px 10px !important;
		}
*/
		/* more option check box alignment issue fix. 
		over written here - because the above class !important overwrite the default/below class.-  */
		.x-panel-newGridPanel .x-grid-cell-special.x-grid-cell-row-checker .x-grid-cell-inner{
			/*padding: 5px 4px 3px 4px !important;*/
		}

		.prog_line{
			height: 5px;
		}
		
		.x-panel-newGridPanel.removeTableBg .x-grid-row .x-grid-cell table{
			line-height: normal;
		}

		span.decimal-align{float: left; text-align: right; width:50%;}
		span.decimal-align2{float: right; text-align: left; width:50%;}
		.uxTool .x-form-item-label
		{
			padding:3px 0px 0px 0px !important;
		}
	</style>
	<script>
		Ext.onReady(function()
		{
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		});
	</script>
<%
		if(monitor_Skin!=null && monitor_Skin.equalsIgnoreCase("Dark"))
		{
%>
			<style>
				.multiselect .x-toolbar{
					border-color: #252525 !important;
					border-width: 1px 1px 0px 1px !important;
					border-style: solid !important;
					background: #444444 !important;
				}
			</style>
<%
		}
		else
		{
%>
				<style>
					.multiselect .x-toolbar{
						border-color:#abb2bd !important;
						border-width:1px 1px 0px 1px !important;
						border-style:solid !important;
					}
				</style>
<%
		}
%>
	</head>
<%
	if(isFromXenVdiFlag)
%>
		<body class="">
<%
	else
%>
		<body class="content-frame">
<%
	}else
	{
%>
		<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
		<egui:skin ui="monitor"/>

		<!--<link rel="stylesheet" type="text/css" href="/final/styles/eGDarkTheme.css" />
		<link rel="stylesheet" type="text/css" href="/final/styles/eGDarkThemeIcons.css" />
		<link rel="stylesheet" href="/final/styles/ext-custom-com-uxdashboard.css" />-->
		<script language = "JavaScript1.2" src = "/final/scripts/<%=script_src%>"></script>
		<script src="/final/jquery/jquery.js"></script>
		<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/dashboardutils.js"></script>
		<script src="../monitor/eg_scripts/dashboards/GeneralMeasuresGrid.js"></script>
		<script src="../monitor/eg_scripts/dashboards/GeneralMeasuresGridPanel.js"></script>
		<style>
			span.decimal-align{float: left; text-align: right; width:50%;}
			span.decimal-align2{float: right; text-align: left; width:50%;}
		</style>
<%
		if(monitor_Skin!=null && monitor_Skin.equalsIgnoreCase("Dark"))
		{
%>
			<style>
				.multiselect .x-toolbar{
					border-color: #252525 !important;
					border-width: 1px 1px 0px 1px !important;
					border-style: solid !important;
					background: #444444 !important;
				}
			</style>
<%
		}
		else
		{
%>
				<style>
					.multiselect .x-toolbar{
						border-color:#abb2bd !important;
						border-width:1px 1px 0px 1px !important;
						border-style:solid !important;
					}
				</style>
<%
		}
%>
	</head>
	<body class="content-frame"><div class="content-frame" style="border:0px solid red;" id="endUserDashboardDiv">
		<table border="0" width="100%" height="100%" bordercolor="green">
			<tr>
				<td align="center" class="commonErrorMsgText" width="100%" height="100%">
					<img src = "/final/images/spacer.gif" class="iconInformation" align = "center" border = "0"  vspace = "10"/>
					<br><egui:intnl text='monitor.endUserDashboard.UnAuthorised Access'/>&nbsp;!
				</td>
			</tr>
		</table>
	</div>
<%
	}
%>
	
</body>
</html>