var runner = new Ext.util.TaskRunner();
var task = runner.newTask({
	run: function()
	{
		Ext.getCmp('resendOtpCnt').show();
		task.stop();
	},
	interval: 20000 // run for every 20 secs
});
var credObj = new Object();

Ext.define('PortalLogin.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Viewport','RegForm','LoginForm','ForgetPassword','TwoFA','LogonSimulatorView','CitrixView','RegFormCS','LoginFormCS','ForgetPasswordCS','TwoFACS','SaaSRegistrationView','LoginFormSaaS','RegFormSaaS','TwoFASaaS','ForgetPasswordSaaS'],
	refs : [
		{selector:'viewport', ref:'viewport'},
		{selector:'RegForm', ref:'RegForm'},
		{selector:'LoginForm', ref:'LoginForm'},
		{selector:'ForgetPassword', ref:'ForgetPassword'},
		{selector:'TwoFA', ref:'TwoFA'},
		{selector:'LogonSimulatorView', ref:'LogonSimulatorView'},
		{selector:'CitrixView', ref:'CitrixView'},
		{selector:'RegFormCS', ref:'RegFormCS'},
		{selector:'LoginFormCS', ref:'LoginFormCS'},
		{selector:'ForgetPasswordCS', ref:'ForgetPasswordCS'},
		{selector:'TwoFACS', ref:'TwoFACS'},
		{selector:'SaaSRegistrationView', ref:'SaaSRegistrationView'},
		{selector:'LoginFormSaaS', ref:'LoginFormSaaS'},
		{selector:'RegFormSaaS', ref:'RegFormSaaS'},
		{selector:'TwoFASaaS', ref:'TwoFASaaS'},
		{selector:'ForgetPasswordSaaS', ref:'ForgetPasswordSaaS'}
	],
	init : function(){
		thisController = this;
		appCnt = this;
		this.control({
			'LogonSimulatorView':
			{
				'afterrender':this.afterrender
			},
			'CitrixView':
			{
				'afterrender':this.afterrender
			},
			'SaaSRegistrationView':
			{
				'afterrender':this.afterrender
			},
			'RegForm button[id="reg"]':
			{
				'click':this.register
			},
			'RegForm' : 
			{
				'afterrender':this.OnKeyupregform
			},
			'LoginForm button[id="login"]':
			{
				'click':this.login
			},
			'LoginForm' : 
			{
				'afterrender':this.OnKeyuploginform
			},
			'ForgetPassword button[id="getPassword"]':
			{
				'click':this.getPassword
			},
			'TwoFA button[id="2fa_submit"]':
			{
				'click' : this.twofalogin
			},
			'RegFormCS button[id="reg"]':
			{
				'click':this.register
			},
			'RegFormCS' : 
			{
				'afterrender':this.OnKeyupregform
			},
			'LoginFormCS button[id="login"]':
			{
				'click':this.login
			},
			'LoginFormCS' : 
			{
				'afterrender':this.OnKeyuploginform
			},
			'ForgetPasswordCS button[id="getPassword"]':
			{
				'click':this.getPassword
			},
			'TwoFACS button[id="2fa_submit"]':
			{
				'click' : this.twofalogin
			},
			'RegFormSaaS button[id="reg"]':
			{
				'click':this.register
			},
			'RegFormSaaS' : 
			{
				'afterrender':this.OnKeyupregform
			},
			'LoginFormSaaS button[id="login"]':
			{
				'click':this.login
			},
			'LoginFormSaaS' : 
			{
				'afterrender':this.OnKeyuploginform
			},
			'ForgetPasswordSaaS button[id="getPassword"]':
			{
				'click':this.getPassword
			},
			'TwoFASaaS button[id="2fa_submit"]':
			{
				'click' : this.twofalogin
			}
		});
	},
	
	afterrender : function()
	{
		var tabPanel = Ext.getCmp('mainTab');
		if (isSecondaryMgr)
		{
			if (reqFrom == 'citrix' && cloudModel == 'default')
			{
				if(!Ext.isEmpty(logoMessage))
				{
					var msgLblContainer = Ext.getCmp("custom_msg_container");
					if(!Ext.isEmpty(msgLblContainer))
					{
						var msgLbl = Ext.get("custom_msg_div");
						msgLbl.update(logoMessage);
						msgLblContainer.show();
					}
				}
				
				Ext.getCmp('changeShade').removeCls("loginShade");
				Ext.getCmp('changeShade').addCls("loginShadeSecondary");
			}

			Ext.get("gotologindiv").show();

			Ext.getCmp('signup').setVisible(false);
			Ext.getCmp('RegForm').setVisible(false);
			Ext.getCmp('ForgetPassword').setVisible(false);
			Ext.getCmp('forgotpwd').setVisible(false);

			Ext.getCmp('auth').setVisible(false);
			Ext.getCmp('TwoFA').setVisible(false);

			Ext.getCmp('signin').setVisible(false);
			Ext.getCmp('LoginForm').setVisible(true);

			Ext.get("forgetpwddiv").on('click',function(){
				if (!Ext.isEmpty(Ext.getCmp('errorState')))
				{
					Ext.getCmp('errorState').hide();
				}

				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('signup').setVisible(false);
				Ext.getCmp('RegForm').setVisible(false);
				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);

				Ext.getCmp('ForgetPassword').setVisible(true);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('fpusername').focus(true, 500);
			});

			Ext.get("gotologindiv").on('click',function(){
				if (!Ext.isEmpty(Ext.getCmp('errorState')))
				{
					Ext.getCmp('errorState').hide();
				}

				Ext.getCmp('signup').setVisible(false);
				Ext.getCmp('RegForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);

				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);

				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(true);
			});
		}
		else if (!Ext.isEmpty(isComeFrom2faUI) && (isComeFrom2faUI == 'fwdToGoogleAuthLoginPage' || isComeFrom2faUI == 'forwardTo2faLoginPg' || isComeFrom2faUI == 'enable2FaForLogin')) 
		{

			if (isComeFrom2faUI == 'fwdToGoogleAuthLoginPage' || isComeFrom2faUI == 'forwardTo2faLoginPg')
			{
				var _mailIDLblClsPrefix = '';
				if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() == 'default') 
				//if (cloudModel != null && cloudModel.toLowerCase() == 'default')
				{
					_mailIDLblClsPrefix = "cs_";
				}

				if (!Ext.isEmpty(localStorage.loggedInUser))
				{
					var splitName = localStorage.loggedInUser;
					if (splitName.length > 40)
					{
						splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
					}
					Ext.get('userIdLbl').update(splitName);		
				}
				else
				{
					var splitName = localStorage.loginUsr;
					if (splitName.length > 40)
					{
						splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
					}
					Ext.get('userIdLbl').update(splitName);
				}

				if (isComeFrom2faUI == 'fwdToGoogleAuthLoginPage')
				{
					Ext.getCmp('mailIdLabel').update('<div class="'+_mailIDLblClsPrefix+'verificationMsg">Enter the verification code generated on your Google Authenticator</div>');
					credObj.twoFA = localStorage.twoFA;
				}
				else if (isComeFrom2faUI == 'forwardTo2faLoginPg')
				{
					Ext.getCmp('mailIdLabel').update('<div class="'+_mailIDLblClsPrefix+'verificationMsg">Enter the verification code sent to your email address <span class="'+_mailIDLblClsPrefix+'mailText">'+localStorage.mailAddr+'</span></div>');

					credObj.username = localStorage.loginUsr;
					credObj.password = localStorage.loginPwd;
					credObj.twoFA = localStorage.twoFA;
					credObj.from = 'login';
					if (!Ext.isEmpty(localStorage.loggedInUser))
					{
						credObj.loggedInUserFor2FA = localStorage.loggedInUser;		
					}
				}

				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('signup').setVisible(false);
				Ext.getCmp('RegForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('TwoFA').getForm().reset();

				if (!isSecondaryMgr)
				{
					Ext.getCmp('auth').setVisible(true);
				}
				Ext.getCmp('TwoFA').setVisible(true);
					
				if ((reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() == 'phoenix') || (reqFrom != null && reqFrom == 'clsTrial'))
				{
					Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_selected">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_disable">REGISTER</td></tr></table></div></div>');
				}
				else if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
				{
					if(!Ext.isEmpty(logoMessage))
					{
						var msgLblContainer = Ext.getCmp("custom_msg_container");
						if(!Ext.isEmpty(msgLblContainer))
						{
							var msgLbl = Ext.get("custom_msg_div");
							msgLbl.update(logoMessage);
							msgLblContainer.show();
						}
					}
					
					Ext.getCmp('changeShade').removeCls("registerShade");
					if (isSecondaryMgr)
					{
						Ext.getCmp('changeShade').addCls("loginShadeSecondary");
					}
					else
					{
						Ext.getCmp('changeShade').addCls("loginShade");
					}

					Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected">SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" width="50%"><div class="cs_signIn_Register_Text" >REGISTER</div></td></tr></table></div></div>');
				}
				else
				{
					Ext.getCmp('otperrorState').hide();
				}
					
				Ext.getCmp('resendOtpCnt').hide();

				Ext.getCmp('otp').setValue("");
				Ext.getCmp('otp').focus(true);
					
				Ext.getCmp('_empcode').setValue(localStorage.mailAddr);
				Ext.getCmp('_from').setValue(localStorage.from);
				Ext.getCmp('_twoFA').setValue(localStorage.twoFA);
			}
			else 
			{
				var splitName = localStorage.loginUsr;
				if (splitName.length > 40)
				{
					splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
				}
				Ext.get('userIdLbl').update(splitName);

				credObj.from = 'login';
				credObj.username = localStorage.mailAddr;
				credObj.twoFA = '';

				Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code sent to your email address <span class="mailText">'+localStorage.mailAddr+'</span></div>');

				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('signup').setVisible(false);
				Ext.getCmp('RegForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('TwoFA').getForm().reset();

				if (!isSecondaryMgr)
				{
					Ext.getCmp('auth').setVisible(true);
				}
				Ext.getCmp('TwoFA').setVisible(true);

				if (reqFrom != null && (reqFrom == 'clsTrial' || (reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() == 'phoenix')))
				{
					if (!Ext.isEmpty(localStorage.from) && localStorage.from =='register')
					{
						if (!Ext.isEmpty(Ext.getCmp('otperrorState')))
						{
							Ext.getCmp('otperrorState').hide();
						}

						Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_disable">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_selected">REGISTER</td></tr></table></div></div>');
					}
					else
					{
						Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_selected">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_disable">REGISTER</td></tr></table></div></div>');
					}
				}
				else if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
				{
					if(!Ext.isEmpty(logoMessage))
					{
						var msgLblContainer = Ext.getCmp("custom_msg_container");
						if(!Ext.isEmpty(msgLblContainer))
						{
							var msgLbl = Ext.get("custom_msg_div");
							msgLbl.update(logoMessage);
							msgLblContainer.show();
						}
					}
					
					if (!Ext.isEmpty(localStorage.from) && localStorage.from =='register')
					{
						if (!Ext.isEmpty(Ext.getCmp('otperrorState')))
						{
							Ext.getCmp('otperrorState').hide();
						}

						Ext.getCmp('changeShade').removeCls("registerShade");
						Ext.getCmp('changeShade').addCls("loginShade");

						Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signIn_Register_Text" >SIGN IN</div></td><td align="left" width="50%"><div class="cs_registerButtonOuter"><div class="cs_tabButtonShadeRegister"></div><div class="cs_signIn_Register_Text_selected">REGISTER</div></div></td></tr></table></div></div>');
					}
					else if (!Ext.isEmpty(localStorage.from) && localStorage.from =='login')
					{
						Ext.getCmp('changeShade').removeCls("registerShade");
						if (isSecondaryMgr)
						{
							Ext.getCmp('changeShade').addCls("loginShadeSecondary");
						}
						else
						{
							Ext.getCmp('changeShade').addCls("loginShade");
						}

						Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected" >SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" width="50%"><div class="cs_signIn_Register_Text">REGISTER</div></td></tr></table></div></div>');
					}
				}
				else
				{
					Ext.getCmp('otperrorState').hide();
				}
				
				Ext.getCmp('resendOtpCnt').hide();

				Ext.getCmp('otp').setValue("");
				Ext.getCmp('otp').focus(true);
				
				Ext.getCmp('_empcode').setValue(localStorage.mailAddr);
				Ext.getCmp('_from').setValue(localStorage.from);
			}

			if (isComeFrom2faUI != 'fwdToGoogleAuthLoginPage')
			{
				var cacheMaxCnt = localStorage.maxResendCount;
				var cacheResndCnt = localStorage.resendCount;
				if (Ext.isEmpty(localStorage.maxResendCount))
				{
					cacheMaxCnt = 3;
				}
				cacheMaxCnt = parseInt(cacheMaxCnt);

				if (Ext.isEmpty(localStorage.resendCount))
				{
					cacheResndCnt = 0;
				}
				cacheResndCnt = parseInt(cacheResndCnt);
				if (cacheResndCnt < cacheMaxCnt)
				{
					task.start();
				}

			}
		}
		else
		{
			if (reqFrom == 'citrix' && cloudModel == 'default')
			{
				if(!Ext.isEmpty(logoMessage))
				{
					var msgLblContainer = Ext.getCmp("custom_msg_container");
					if(!Ext.isEmpty(msgLblContainer))
					{
						var msgLbl = Ext.get("custom_msg_div");
						msgLbl.update(logoMessage);
						msgLblContainer.show();
					}
				}
				
				Ext.getCmp('changeShade').removeCls("loginShadeSecondary");
				Ext.getCmp('changeShade').addCls("loginShade");
			}

			Ext.get("gotologindiv").hide();
			if (email != 'null' && first_name != 'null' && 
			last_name != 'null' && phoneNo != 'null' && 
			ckey != 'null' && pkey != 'null' && tZone != 'null' && 
			company != 'null' && !Ext.isEmpty(email) && 
			!Ext.isEmpty(first_name) && !Ext.isEmpty(last_name) && 
			!Ext.isEmpty(pkey) && !Ext.isEmpty(ckey) && 
			!Ext.isEmpty(tZone) && !Ext.isEmpty(phoneNo) && 
			!Ext.isEmpty(company))
			{
				
				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);

				Ext.getCmp('signup').setVisible(true);
				Ext.getCmp('RegForm').setVisible(true);
				
				Ext.getCmp('fname').setValue(first_name);
				Ext.getCmp('lname').setValue(last_name);
				Ext.getCmp('emailid').setValue(email);
				Ext.getCmp('phoneNo').setValue(phoneNo);
				Ext.getCmp('company').setValue(company);
				Ext.getCmp('password').setValue(pkey);
				Ext.getCmp('cpassword').setValue(ckey);
				first_name = "";
				last_name = "";
				email = "";
				phoneNo = "";
				company = "";
				pkey = "";
				ckey = "";
				
				Ext.Ajax.request({
					url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
					params: 'comeFrom=getTimeZoneAndSimulator',
					method: 'POST',
					success: function(response)
					{
						var jsonText = response.responseText;
						var publicJSON = Ext.decode(jsonText);
						Ext.getCmp('timeZone').getStore().loadRawData(publicJSON['timeZone']);
						Ext.getCmp('timeZone').setValue(tZone);
						if (simul != 'null' && !Ext.isEmpty(simul))
						{
							Ext.getCmp('simulator').getStore().loadRawData(publicJSON['simulator']);
							Ext.getCmp('simulator').setValue(simul);
						}
						tZone = "";
						simul = "";
						appCnt.register();
					}
				});
			}
			else if (email != 'null' && first_name != 'null' && last_name != 'null' && !Ext.isEmpty(email) && !Ext.isEmpty(first_name) && !Ext.isEmpty(last_name))
			{
				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);

				Ext.getCmp('signup').setVisible(true);
				Ext.getCmp('RegForm').setVisible(true);
				
				Ext.getCmp('fname').setValue(first_name);
				Ext.getCmp('lname').setValue(last_name);
				Ext.getCmp('emailid').setValue(email);

				if (phoneNo != 'null' && company != 'null' && !Ext.isEmpty(phoneNo) && !Ext.isEmpty(company))
				{
					Ext.getCmp('phoneNo').setValue(phoneNo);
					Ext.getCmp('company').setValue(company);
				}
				Ext.getCmp('password').focus(true, 500);
			}
			else
			{
				Ext.getCmp('signup').setVisible(false);
				Ext.getCmp('RegForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);

				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);
				Ext.getCmp('signin').setVisible(true);
				Ext.getCmp('LoginForm').setVisible(true);
				if (uName != 'null' && !Ext.isEmpty(uName) && key != 'null' &&  !Ext.isEmpty(key))
				{
					Ext.getCmp('username').setValue(uName);
					Ext.getCmp('pass').setValue(key);
					appCnt.login();
				}
				else if (uName != 'null' && !Ext.isEmpty(uName))
				{
					Ext.getCmp('username').setValue(uName);
					Ext.getCmp('pass').focus(true, 500);
				}
				else
				{
					Ext.getCmp('username').focus(true, 500);
				}
			}

			if (action.toLowerCase() == 'registration')
			{
				Ext.getCmp('signin').setVisible(false);
				Ext.getCmp('LoginForm').setVisible(false);
				Ext.getCmp('ForgetPassword').setVisible(false);
				Ext.getCmp('forgotpwd').setVisible(false);
				Ext.getCmp('auth').setVisible(false);
				Ext.getCmp('TwoFA').setVisible(false);

				Ext.getCmp('signup').setVisible(true);
				Ext.getCmp('RegForm').setVisible(true);
			}
			if ((Ext.isEmpty(errText) || errText == 'none') && sessionStorage.getItem('Register_Msg') != null)
			{
				errText = sessionStorage.getItem('Register_Msg');
				sessionStorage.clear();
			}
		
			if(!Ext.isEmpty(errText) && errText!='none')
			{
				thisController.validateErrorTextTooltip('',errText,Ext.getCmp('errorState'));
			}
			
			Ext.get("forgetpwddiv").on('click',function(){
					if (!Ext.isEmpty(Ext.getCmp('errorState')))
					{
						Ext.getCmp('errorState').hide();
					}

					Ext.getCmp('signin').setVisible(false);
					Ext.getCmp('LoginForm').setVisible(false);
					Ext.getCmp('signup').setVisible(false);
					Ext.getCmp('RegForm').setVisible(false);
					Ext.getCmp('auth').setVisible(false);
					Ext.getCmp('TwoFA').setVisible(false);

					Ext.getCmp('ForgetPassword').setVisible(true);
					Ext.getCmp('forgotpwd').setVisible(true);
					Ext.getCmp('fpusername').focus(true, 500);
				}
			);
		
			Ext.Ajax.request({
				url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
				params: 'comeFrom=getTimeZoneAndSimulator',
				method: 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var publicJSON = Ext.decode(jsonText);
					var timeZone = Ext.getCmp('timeZone');
					timeZone.getStore().loadRawData(publicJSON['timeZone']);
					var simulator = Ext.getCmp('simulator');
					simulator.getStore().suspendEvents(true);
					simulator.getStore().loadRawData(publicJSON['simulator']);
					if (platform != 'null' && !Ext.isEmpty(platform))
					{
						var simulatorValue = "";
						if (platform.toLowerCase() == 'citrix xenapp/xendesktop')
						{
							simulatorValue = "Citrix_XcLogon_Emulation";
						}
						else if (platform.toLowerCase() == 'vmware horizon')
						{
							simulatorValue = "Hrzn_Logon_Emulation";
						}
						else if (platform.toLowerCase() == 'microsoft avd')
						{
							simulatorValue = "WVD_Logon_Emulation";
						}
						Ext.getCmp('simulator').setValue(simulatorValue);
					}
          
					if (simul != 'null' && !Ext.isEmpty(simul))
					{
						var simulatorValue = "";
						if (simul.toLowerCase() == 'citrix virtual apps/desktops')
						{
							simulatorValue = "Citrix_XcLogon_Emulation";
						}
						else if (simul.toLowerCase() == 'vmware horizon')
						{
							simulatorValue = "Hrzn_Logon_Emulation";
						}
						else if (simul.toLowerCase() == 'microsoft avd')
						{
							simulatorValue = "WVD_Logon_Emulation";
						}
						Ext.getCmp('simulator').setValue(simulatorValue);
					}
					simulator.getStore().resumeEvents();
					
					var curTimeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
					
					if (!Ext.isEmpty(curTimeZone) && curTimeZone.indexOf('/') != -1 && curTimeZone.indexOf('Etc/') == -1 && curTimeZone.indexOf('SystemV') == -1)
					{
						timeZone.setValue(curTimeZone);
					}
					else
					{
						var timezoneoffset = new Date().getTimezoneOffset();
						var value = -Math.round(timezoneoffset/60)+':'+-(timezoneoffset%60);
						var tempValue = value;
						tempValue = tempValue.replace(":",".");
						if (tempValue > 0)
						{
							value = '+' + value;
						}
						var index = timeZone.getStore().find('displayField',value,0,true,false,false);
						if (index != -1)
						{
							timeZone.setValue(timeZone.getStore().getAt(index));
						}
					}
				}
			});
		}
	},
	
	goToSignIn : function()
	{
		if (!Ext.isEmpty(Ext.getCmp('errorState')))
		{
			Ext.getCmp('errorState').hide();
		}

		Ext.getCmp('signin').setVisible(true);
		Ext.getCmp('LoginForm').setVisible(true);

		Ext.getCmp('username').focus(true);

		Ext.getCmp('signup').setVisible(false);
		Ext.getCmp('RegForm').setVisible(false);
		Ext.getCmp('ForgetPassword').setVisible(false);
		Ext.getCmp('forgotpwd').setVisible(false);
		Ext.getCmp('auth').setVisible(false);
		Ext.getCmp('TwoFA').setVisible(false);
		
		if (reqFrom != null && reqFrom == 'citrix')
		{
			if (cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
			{
				Ext.getCmp('changeShade').removeCls("registerShade");
				Ext.getCmp('changeShade').addCls("loginShade");
			}
		}
	},

	goToSignUp : function()
	{
		if (!Ext.isEmpty(Ext.getCmp('errorState')))
		{
			Ext.getCmp('errorState').hide();
		}

		Ext.getCmp('signin').setVisible(false);
		Ext.getCmp('LoginForm').setVisible(false);
		Ext.getCmp('ForgetPassword').setVisible(false);
		Ext.getCmp('forgotpwd').setVisible(false);
		Ext.getCmp('auth').setVisible(false);
		Ext.getCmp('TwoFA').setVisible(false);

		Ext.getCmp('signup').setVisible(true);
		Ext.getCmp('RegForm').setVisible(true);
		
		Ext.getCmp('fname').focus(true);
		
		if (reqFrom != null && reqFrom == 'citrix')
		{
			if (cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
			{
				if(!Ext.isEmpty(logoMessage))
				{
					var msgLblContainer = Ext.getCmp("custom_msg_container");
					if(!Ext.isEmpty(msgLblContainer))
					{
						var msgLbl = Ext.get("custom_msg_div");
						msgLbl.update(logoMessage);
						msgLblContainer.show();
					}
				}
				Ext.getCmp('changeShade').removeCls("loginShade");
				Ext.getCmp('changeShade').addCls("registerShade");
			}
		}
	},

	OnKeyuploginform: function(view, options){
		Ext.EventManager.on(view.getEl(), 'keyup', function(evt, t, o) {
			if (evt.keyCode === Ext.EventObject.ENTER) 
			{
				this.login();
			}
		}, this);
	},

	OnKeyupregform: function(view, options){
		Ext.EventManager.on(view.getEl(), 'keyup', function(evt, t, o) {
			if (evt.keyCode === Ext.EventObject.ENTER) 
			{
				this.register();
			}
		}, this);
	},
	
	termsOfService : function()
	{
		var docName = "";
		if (reqFrom != null && reqFrom == 'clsTrial')
		{
			docName = "Terms_of_Service_eG_Enterprise_Express_Logon_Simulator";
		}
		else if (reqFrom != null && reqFrom == 'citrix')
		{
			if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
			{
				docName = "Terms_of_Service_eG_Express_Cloud";
			}
			else
			{
				docName = "Terms_of_Service_eG_Enterprise_Cloud";
			}
		}
		if(Ext.isEmpty(Ext.getCmp('termsOfServWindow')))
		{
			Ext.create('Ext.window.Window', {
					title: "<span style='text-transform:none;'>Terms of Service</span>",
					modal:true,
					ui:'newPopupWindow newplainHeader_border popupWindowBlueHeader', 
					ghost:false,
					id:'termsOfServWindow',
					closeAction:'destroy',
					height:500,
					width: 800,
					border:true,
					bodyPadding:0,
					header:{
						padding:'12 0',
						margin:'0 20 0 20',
					},
					listeners: {
						show: function(h) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								for (var f in g) {
									this.dom = g[f];
									if (!Ext.isEmpty(this.dom.offsetParent)) {
										if (this.dom.offsetParent.tagName == "BODY") {
											Ext.fly(this.dom).addCls("windowModal");
										}
									}
								}
							}
						},
						hide: function(f) {
							if (this.modal) {
								Ext.fly(this.dom).removeCls("windowModal");
							}
						},
						afterrender: function() {
							Ext.EventManager.onWindowResize(function() {
								var f = this;
								f.center();
							}, this);
						}
					},
					resizable:false,
					layout: 'fit',
					html:'<iframe width="800" frameborder="0" height="465" src="/final/docs/'+docName+'.pdf#toolbar=0&navpanes=0&scrollbar=0" name="aaa" frameborder="0" allowfullscreen allowtransparency="true"></iframe>'
			}).show();
		}
	},
	
	pwdComplexityCheck : function(loginPassword,pwdComplexity)
	{
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			result = "false#";
			if(pwdComplexity.indexOf(",") > -1)
			{
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+passCheckMsg1;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+passCheckMsg2;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+passCheckMsg3;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+passCheckMsg4;
					}
				}
			}
			else
			{
				var temp = pwdComplexity.toString().toLowerCase();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result += passCheckMsg1;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  passCheckMsg2;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  passCheckMsg3;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  passCheckMsg4;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},

	register : function()
	{
		var fname = Ext.getCmp('fname').getValue();
		var lname = Ext.getCmp('lname').getValue();
		var email = Ext.getCmp('emailid').getValue();
		var password = Ext.getCmp('password').getValue();
		password = Ext.String.trim(password);
		var cpassword = Ext.getCmp('cpassword').getValue();
		cpassword = Ext.String.trim(cpassword);
		var company = Ext.getCmp('company').getValue();
		var errorCmp = Ext.getCmp('errorState1');
		var timeZone = Ext.getCmp('timeZone').getValue();
		var phoneNo = Ext.getCmp('phoneNo').getValue();
		var simulator = Ext.getCmp('simulator').getValue();

		var regExp = /[\#]?([a-zA-Z0-9]+[\#\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var toMailResult= email.match(regExp);
		var valMobNo = false;
		if (phoneNo != '')
		{
			valMobNo = validateMobileNo(phoneNo);
		}
		
		if(fname == '')
		{
			thisController.validateErrorTextTooltip('fname',fnameMsg,errorCmp);
			return false;
		}
		else if (fname.length <= 1)
		{
			thisController.validateErrorTextTooltip('fname',fnamevalMsg,errorCmp);
			return false;
		}
		else if (!checkDoubleSpaces(fname))
		{
			thisController.validateErrorTextTooltip('fname',_checkSpaces,errorCmp);
			return false;
		}
		else if (!checkForAlphaNumeric(fname))
		{
			thisController.validateErrorTextTooltip('fname',_checkspecial,errorCmp);
			return false;
		}
		else if(lname == '')
		{
			thisController.validateErrorTextTooltip('lname',lnameMsg,errorCmp);
			return false;
		}
		else if (lname.length <= 1)
		{
			thisController.validateErrorTextTooltip('lname',lnamevalMsg,errorCmp);
			return false;
		}
		else if (!checkDoubleSpaces(lname))
		{
			thisController.validateErrorTextTooltip('lname',_checkSpaces,errorCmp);
			return false;
		}
		else if (!checkForAlphaNumeric(lname))
		{
			thisController.validateErrorTextTooltip('lname',_checkspecial,errorCmp);
			return false;
		}
		else if(email == '')
		{
			thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
			return false;
		}
		else if (toMailResult != email.toString())
		{
			thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
			return false;
		}
		else if (toMailResult == email.toString())
		{
			var validEmail = false;
			Ext.Ajax.request({
				url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
				params: 'emailid='+encodeURIComponent(parent.filterEncode(email))+'&comeFrom=emailValidation&reqFrom='+reqFrom,
				method: 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var publicJson = Ext.decode(jsonText);
					var validEmail = publicJson['validEmail'];
					var domainAllowed = publicJson['domainAllowed'];

					var pwdminlen = publicJson['pwdLength'];
					var pwdComplexityLength = publicJson['pwdComplexityCount'];
					var pwdComplexity = publicJson['pwdComplexity'];
					if (pwdminlen == "" || pwdminlen < 2)
					{
						pwdminlen = 8;
					}
					else if(pwdminlen != "" && pwdminlen < pwdComplexityLength)
					{
						pwdminlen = pwdComplexityLength;
					}
					var pwdComplexityvar = appCnt.pwdComplexityCheck(password,pwdComplexity);

					if (validEmail==false)
					{
						thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
						return false;
					}
					else if (domainAllowed==false)
					{
						thisController.validateErrorTextTooltip('emailid',domainRestrictedMsg,errorCmp);
						return false;
					}
					else if (password == '')
					{
						thisController.validateErrorTextTooltip('password',passMsg,errorCmp);
						return false;
					}
					else if (Ext.String.trim(email.toLowerCase()) == password.toLowerCase())
					{
						thisController.validateErrorTextTooltip('password',emailpassMsg,errorCmp);
						return false;
					}
					else if(!checkloginpass(password))
					{
						thisController.validateErrorTextTooltip('password',_checkspecial,errorCmp);
						return false;
					}
					else if(password.length<pwdminlen)
					{
						thisController.validateErrorTextTooltip('password',passCheckMsg5+' '+pwdminlen+' '+passCheckMsg6,errorCmp);
						return false;
					}
					else if(pwdComplexityvar.indexOf("false") > -1)
					{
						var resMsg = pwdComplexityvar.substring(pwdComplexityvar.indexOf("false#")+6);
						thisController.validateErrorTextTooltip('password',passCheckMsg7+'. '+ passCheckMsg5+' '+resMsg+'.',errorCmp);
						return false;
					}
					else if (cpassword == '')
					{
						thisController.validateErrorTextTooltip('cpassword',confPassMsg,errorCmp);
						return false;
					}
					else if (password != cpassword)
					{
						thisController.validateErrorTextTooltip('cpassword',pwdInCorrect,errorCmp);
						return false;
					}
					else if (company == '')
					{
						thisController.validateErrorTextTooltip('company',validCompMsg,errorCmp);
						return false;
					}
					else if (!checkspecial(company, "=#"))
					{
						thisController.validateErrorTextTooltip('company',_checkspecial,errorCmp);
						return false;
					}
					else if (phoneNo == '')
					{
						thisController.validateErrorTextTooltip('phoneNo',enterPhoneNoMsg,errorCmp);
						return false;
					}
					else if (valMobNo == false)
					{
						thisController.validateErrorTextTooltip('phoneNo',validPhoneNoMsg,errorCmp);
						return false;
					}
					else if (timeZone == null || timeZone == '')
					{
						thisController.validateErrorTextTooltip('timeZone',validTimeZoneMsg,errorCmp);
						return false;
					}
					else if (defaultLS.toLowerCase() == 'all' && reqFrom.toLowerCase() != 'citrix' && (simulator == null || simulator == ''))
					{
						thisController.validateErrorTextTooltip('simulator',validSimulatorMsg,errorCmp);
						return false;
					}
					else
					{
						if (simulator == null || simulator == '')
						{
							if (defaultLS != 'all')
							{
								Ext.getCmp('simulator').setValue(defaultLS);
							}
							else
							{
								Ext.getCmp('simulator').setValue("Citrix_XcLogon_Emulation");
							}
						}

						var _emailid = Ext.getCmp('emailid').getValue();
						var _password = Ext.getCmp('password').getValue();
						var _cpassword = Ext.getCmp('cpassword').getValue();
						var _company = Ext.getCmp('company').getValue();
			
						_emailid = parent.filterEncode(_emailid);
						_password = parent.filterEncode(_password);
						_cpassword = parent.filterEncode(_cpassword);
						_company = parent.filterEncode(_company);

						Ext.getCmp('emailid').setValue(_emailid);
						Ext.getCmp('password').setValue(_password);
						Ext.getCmp('cpassword').setValue(_cpassword);
						Ext.getCmp('company').setValue(_company);

						var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
						myRegMask.show(); 

						if (reqFrom != null && reqFrom == 'clsTrial')
						{
							errorCmp.show();
						}
						else
						{
							if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
							{
								errorCmp.show();
							}
						}

						var thisForm = Ext.getCmp('RegForm').getForm();
						thisForm.submit({
							url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
							params: 'comeFrom=register&reqFrom='+reqFrom,
							method: 'POST',
							success: function(form,action)
							{
								myRegMask.hide();
								if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText))
								{
									var jsonText = action.response.responseText;
									var resultObj = Ext.decode(jsonText);
									if (resultObj['success']=='user')
									{
										thisController.validateErrorTextTooltip('',resultObj['screenLabels']['userErr'],errorCmp);
										return false;
									}
									else if (resultObj['success']=='mail')
									{
										thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
										return false;
									}
									else if (resultObj['success']=='extagent')
									{
										thisController.validateErrorTextTooltip('',resultObj['screenLabels']['extAgentErr'],errorCmp);
										return false;
									}
									else if (resultObj['success']=='comp')
									{
										thisController.validateErrorTextTooltip('',resultObj['screenLabels']['compErr'],errorCmp);
										return false;
									}
									else if (resultObj['success']=='true')
									{
										if (!Ext.isEmpty(Ext.getCmp('errorState')))
										{
											Ext.getCmp('errorState').hide();
										}
										var email = Ext.getCmp('emailid').getValue();
										var passwd = Ext.getCmp('password').getValue();
										var company = Ext.getCmp('company').getValue();
										Ext.getCmp('hiddenFName').setValue(fname);
										Ext.getCmp('hiddenLName').setValue(lname);
										Ext.getCmp('hiddenEmail').setValue(email);
										Ext.getCmp('hiddenpass').setValue(passwd);
										Ext.getCmp('hiddenComp').setValue(company);
										Ext.getCmp('hiddenTimeZone').setValue(timeZone);
										Ext.getCmp('hiddenPhoneNo').setValue(phoneNo);
										if (reqFrom == 'clsTrial')
										{
											Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code sent to your email address <span class="mailText">'+email+'</span></div>');
										}
										else if (reqFrom == 'citrix')
										{
											if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
											{
												Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code sent to your email address <span class="mailText">'+email+'</span></div>');
											}
											else
											{
												Ext.getCmp('mailIdLabel').update('<div class="cs_verificationMsg">Enter the verification code sent to your email address<br/> <span class="cs_mailText">'+email+'</span></div>');
											}
										}
										if (resultObj['2FA']=='true')
										{
											Ext.getCmp('userIdLblCont').hide();
											Ext.getCmp('2fa_cancel').hide();
											thisController.sendOtp(email,'register','sendOTP');
										}
										else
										{
											thisController.finalReg("register");
										}
									}
								}
							},
							failure: function(form,action)
							{
								myRegMask.hide();
							}
						});
					}
				},
				failure: function(response)
				{
					if (response.status == 403)
					{
						var url = "/final/eglgn?email="+email+"&first_name="+fname+"&last_name="+lname+"&phoneNo="+phoneNo+"&password="+password+"&cpassword="+cpassword+"&company="+company+"&timeZone="+timeZone+"&simulator="+simulator+"&reqFrom="+reqFrom+"&fromST=register";
						postCustomFormSubmit(url);
					}
				}
			});
		}
	},

	sendOtp : function(email,from,action)
	{
		var errorCmp = Ext.getCmp("errorState");
		if (Ext.isEmpty(errorCmp))
		{
			errorCmp =  Ext.getCmp('errorState1');
		}

		if (Ext.isEmpty(errorCmp))
		{
			errorCmp =  Ext.getCmp('otperrorState');
		}

		errorCmp.hide();

		var thisForm = '';
		if (from != null && from == 'register')
		{
			thisForm = Ext.getCmp('RegForm').getForm();
		}
		else
		{
			thisForm = Ext.getCmp('TwoFA').getForm();
		}
		var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Verification code is being sent to your email address...'});
		myRegMask.show(); 
		thisForm.submit({
			url : '/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
			method : 'POST',
			params: {
				'email': parent.filterEncode(email),
				'requestFrom': 'sendOTP',
				'from': from,
				'action':action,
				'reqFrom':reqFrom
			},
			async: false,
			success: function(form, action)
			{
				myRegMask.hide();
				if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) ) 
				{
					var jsonText = action.response.responseText;
					publicJSON = Ext.decode(jsonText);
					var mailStatus = publicJSON.mailStatus;
					var errorCmp = Ext.getCmp("errorState1");
					if (!Ext.isEmpty(mailStatus) && (parseInt(mailStatus) == 1 || parseInt(mailStatus) == 2 || parseInt(mailStatus) == 3))
					{
						thisController.validateErrorTextTooltip('',mailNotSentMsg,errorCmp);
					}
					else if (!Ext.isEmpty(mailStatus) && parseInt(mailStatus) == 4)
					{
						thisController.validateErrorTextTooltip('',invalidMailID,errorCmp);
					}
					else if (!Ext.isEmpty(mailStatus) && parseInt(mailStatus) == -1)
					{
						thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
						return false;
					}
					else
					{
						Ext.getCmp('signin').setVisible(false);
						Ext.getCmp('LoginForm').setVisible(false);
						Ext.getCmp('signup').setVisible(false);
						Ext.getCmp('RegForm').setVisible(false);
						Ext.getCmp('ForgetPassword').setVisible(false);
						Ext.getCmp('forgotpwd').setVisible(false);
						Ext.getCmp('TwoFA').getForm().reset();

						if (!isSecondaryMgr)
						{
							Ext.getCmp('auth').setVisible(true);
						}
						Ext.getCmp('TwoFA').setVisible(true);

						if (reqFrom != null && (reqFrom == 'clsTrial' || (reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() == 'phoenix')))
						{
							if (from!=null && from=='register')
							{
								if (!Ext.isEmpty(Ext.getCmp('otperrorState')))
								{
									Ext.getCmp('otperrorState').hide();
								}

								Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_disable">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_selected">REGISTER</td></tr></table></div></div>');
							}
							else
							{
								Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_selected">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_disable">REGISTER</td></tr></table></div></div>');
							}
						}
						else if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
						{
							if(!Ext.isEmpty(logoMessage))
							{
								var msgLblContainer = Ext.getCmp("custom_msg_container");
								if(!Ext.isEmpty(msgLblContainer))
								{
									var msgLbl = Ext.get("custom_msg_div");
									msgLbl.update(logoMessage);
									msgLblContainer.show();
								}
							}
							
							if (from!=null && from=='register')
							{
								if (!Ext.isEmpty(Ext.getCmp('otperrorState')))
								{
									Ext.getCmp('otperrorState').hide();
								}

								Ext.getCmp('changeShade').removeCls("registerShade");
								Ext.getCmp('changeShade').addCls("loginShade");

								Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signIn_Register_Text" >SIGN IN</div></td><td align="left" width="50%"><div class="cs_registerButtonOuter"><div class="cs_tabButtonShadeRegister"></div><div class="cs_signIn_Register_Text_selected">REGISTER</div></div></td></tr></table></div></div>');
							}
							else if (from!=null && from=='login')
							{
								Ext.getCmp('changeShade').removeCls("registerShade");
								if (isSecondaryMgr)
								{
									Ext.getCmp('changeShade').addCls("loginShadeSecondary");
								}
								else
								{
									Ext.getCmp('changeShade').addCls("loginShade");
								}

								Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected" >SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" width="50%"><div class="cs_signIn_Register_Text">REGISTER</div></td></tr></table></div></div>');
							}
						}
						else
						{
							Ext.getCmp('otperrorState').hide();
						}
						
						Ext.getCmp('resendOtpCnt').hide();

						Ext.getCmp('otp').setValue("");
						Ext.getCmp('otp').focus(true);
						
						Ext.getCmp('_empcode').setValue(email);
						Ext.getCmp('_from').setValue(from);

						if (from != null && from == 'login')
						{
							maxResendCount = thisController.getMaxResendCount();
							localStorage.setItem('maxResendCount',maxResendCount);
							localStorage.setItem('resendCount',resendCount);

							if (localStorage.resendCount < maxResendCount)
							{
								task.start();
							}
						}
						else
						{
							task.start();
						}
					}
				}
			},
			failure: function(form, action)
			{
				localStorage.clear();
				myRegMask.hide();
				window.location.href = "/final";
			}
		});
	},

	resendOTP: function(uname, loggedInUsr, from, action, twoFA)
	{	
		var cacheResndCnt = localStorage.resendCount;
		if (!Ext.isEmpty(cacheResndCnt) && cacheResndCnt >= localStorage.maxResendCount)
		{
      Ext.getCmp('resendOtpCnt').hide();
			return;
		}

		var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
		var parameters = 'uname='+encodeURIComponent(uname)+'&from='+encodeURIComponent(from)+'&requestFrom=resendOTP&userTimeZoneDate='+parent.filterEncode(encodeURIComponent(userTZDate))+'&reqFrom='+reqFrom+'&action='+action+'&twoFA='+twoFA;
		if (!Ext.isEmpty(loggedInUsr))
		{
			parameters += '&loggedInUserFor2FA='+loggedInUsr;
		}

		var errorCmp = Ext.getCmp("errorState");
		if (Ext.isEmpty(errorCmp))
		{
			errorCmp =  Ext.getCmp('errorState1');
		}

		if (Ext.isEmpty(errorCmp))
		{
			errorCmp =  Ext.getCmp('otperrorState');
		}

		errorCmp.hide();
		Ext.Ajax.request({
			url:'/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
			params: parameters,
			scope:this,
			timeout: 120000,
			async: false,
			success:function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					resendCount++;
					var cacheResndCnt = localStorage.resendCount;
					if (!Ext.isEmpty(cacheResndCnt))
					{
						var count = parseInt(cacheResndCnt);
						count++;
						localStorage.setItem('resendCount',count);
					}
					else
					{
						localStorage.setItem('resendCount',resendCount);
					}
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var errorLink = publicJSON.ErrorLink;
					if (!Ext.isEmpty(errorLink))
					{
						localStorage.clear();
						window.location.href = errorLink;
					}
					else
					{
						var mailStatus = publicJSON.mailStatus;
						
						if (!Ext.isEmpty(mailStatus) && (parseInt(mailStatus) == 1 || parseInt(mailStatus) == 2 || parseInt(mailStatus) == 3))
						{
							thisController.validateErrorTextTooltip('',mailNotSentMsg,errorCmp);
						}
						else if (!Ext.isEmpty(mailStatus) && parseInt(mailStatus) == 4)
						{
							thisController.validateErrorTextTooltip('',invalidMailID,errorCmp);
						}
						else
						{
							Ext.getCmp('signin').setVisible(false);
							Ext.getCmp('LoginForm').setVisible(false);
							Ext.getCmp('signup').setVisible(false);
							Ext.getCmp('RegForm').setVisible(false);
							Ext.getCmp('ForgetPassword').setVisible(false);
							Ext.getCmp('forgotpwd').setVisible(false);
							Ext.getCmp('TwoFA').getForm().reset();

							if (!isSecondaryMgr)
							{
								Ext.getCmp('auth').setVisible(true);
							}
							Ext.getCmp('TwoFA').setVisible(true);
							
							if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
							{
								if(!Ext.isEmpty(logoMessage))
								{
									var msgLblContainer = Ext.getCmp("custom_msg_container");
									if(!Ext.isEmpty(msgLblContainer))
									{
										var msgLbl = Ext.get("custom_msg_div");
										msgLbl.update(logoMessage);
										msgLblContainer.show();
									}
								}
								
								if (from!=null && from=='register')
								{
									Ext.getCmp('otperrorState').hide();

									Ext.getCmp('changeShade').removeCls("registerShade");
									Ext.getCmp('changeShade').addCls("loginShade");

								}
								else if (from!=null && from=='login')
								{
									Ext.getCmp('changeShade').removeCls("registerShade");
									if (isSecondaryMgr)
									{
										Ext.getCmp('changeShade').addCls("loginShadeSecondary");
									}
									else
									{
										Ext.getCmp('changeShade').addCls("loginShade");
									}

								}
							}
							else
							{
								Ext.getCmp('otperrorState').hide();
							}
							
							Ext.getCmp('resendOtpCnt').hide();

							Ext.getCmp('otp').setValue("");
							Ext.getCmp('otp').focus(true);
							
							Ext.getCmp('_empcode').setValue(uname);
							Ext.getCmp('_from').setValue('login');
							Ext.getCmp('_twoFA').setValue(twoFA);
						}
					}
				}
			},
			failure : function(response, options)
			{
				localStorage.clear();
				window.location.href = "/final";
			}
		});

		Ext.getCmp('resendOtpCnt').hide();
		if (!Ext.isEmpty(localStorage.maxResendCount))
		{
			var cacheMaxCnt = localStorage.maxResendCount;
			cacheMaxCnt = parseInt(cacheMaxCnt);

			var cacheResndCnt = localStorage.resendCount;
			if (Ext.isEmpty(localStorage.resendCount))
			{
				cacheResndCnt = 0;
			}
			cacheResndCnt = parseInt(cacheResndCnt);
			if (cacheResndCnt < cacheMaxCnt)
			{
				task.start();
			}
		}
		else
		{
			if (resendCount < maxResendCount)
			{
				task.start();
			}
		}
	},
	
	getMaxResendCount: function()
	{
		var count = 0;
		Ext.Ajax.request({
			url:'/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
			params:'requestFrom=getMaxResendCount',
			scope:this,
			timeout: 120000,
			async: false,
			success:function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = Ext.decode(response.responseText);
					count = jsonText.maxResendCount;
				}
			},
			failure: function(form, action)
			{
				alert(action);
			}
		});
		return count;
	},

	sendOtpForLogin : function(email,from,action,twoFA)
	{
		var thisForm = Ext.getCmp('TwoFA').getForm();
		var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Verification code is being sent to your email address...'});
		myRegMask.show(); 
		var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
		thisForm.submit({
			url : '/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
			method : 'POST',
			params: {
				'email': parent.filterEncode(email),
				'requestFrom': 'sendOTP',
				'from': from,
				'action':action,
				'reqFrom':reqFrom,
				'twoFA':twoFA,
				'userTimeZoneDate':parent.filterEncode(encodeURIComponent(userTZDate))
			},
			async: false,
			success: function(form, action)
			{
				myRegMask.hide();
				if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) ) 
				{
					var jsonText = action.response.responseText;
					publicJSON = Ext.decode(jsonText);
					var mailStatus = publicJSON.mailStatus;
					var errorCmp = Ext.getCmp("errorState1");
					if (!Ext.isEmpty(mailStatus) && (parseInt(mailStatus) == 1 || parseInt(mailStatus) == 2 || parseInt(mailStatus) == 3))
					{
						thisController.validateErrorTextTooltip('',mailNotSentMsg,errorCmp);
					}
					else if (!Ext.isEmpty(mailStatus) && parseInt(mailStatus) == 4)
					{
						thisController.validateErrorTextTooltip('',invalidMailID,errorCmp);
					}
					else
					{
						Ext.getCmp('signin').setVisible(false);
						Ext.getCmp('LoginForm').setVisible(false);
						Ext.getCmp('signup').setVisible(false);
						Ext.getCmp('RegForm').setVisible(false);
						Ext.getCmp('ForgetPassword').setVisible(false);
						Ext.getCmp('forgotpwd').setVisible(false);
						Ext.getCmp('TwoFA').getForm().reset();

						if (!isSecondaryMgr)
						{
							Ext.getCmp('auth').setVisible(true);
						}
						Ext.getCmp('TwoFA').setVisible(true);
						
						if ((reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() == 'phoenix') || (reqFrom != null && reqFrom == 'clsTrial'))
						{
							Ext.getCmp('authInnerCont').update('<div id="loginHeader"><div class=""><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="center" width="50%" class="signIn_Register_Text_selected">SIGN IN</td><td align="center" width="50%" class="signIn_Register_Text_disable">REGISTER</td></tr></table></div></div>');
						}
						else if (reqFrom != null && reqFrom == 'citrix' && cloudModel != null && cloudModel.toLowerCase() != 'phoenix')
						{
							if(!Ext.isEmpty(logoMessage))
							{
								var msgLblContainer = Ext.getCmp("custom_msg_container");
								if(!Ext.isEmpty(msgLblContainer))
								{
									var msgLbl = Ext.get("custom_msg_div");
									msgLbl.update(logoMessage);
									msgLblContainer.show();
								}
							}
							
							Ext.getCmp('changeShade').removeCls("registerShade");
							if (isSecondaryMgr)
							{
								Ext.getCmp('changeShade').addCls("loginShadeSecondary");
							}
							else
							{
								Ext.getCmp('changeShade').addCls("loginShade");
							}

							Ext.getCmp('auth').update('<div id="loginHeader"><div style="z-index:4"><table width="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr><td align="right" width="50%"><div class="cs_signInButtonOuter"><div class="cs_signIn_Register_Text_selected">SIGN IN</div><div class="cs_tabButtonShadeSignIn"></div></div></td><td align="left" width="50%"><div class="cs_signIn_Register_Text" >REGISTER</div></td></tr></table></div></div>');
						}
						else
						{
							Ext.getCmp('otperrorState').hide();
						}
						
						Ext.getCmp('resendOtpCnt').hide();

						Ext.getCmp('otp').setValue("");
						Ext.getCmp('otp').focus(true);
						
						Ext.getCmp('_empcode').setValue(email);
						Ext.getCmp('_from').setValue(from);
						Ext.getCmp('_twoFA').setValue(twoFA);

						if (twoFA == 'forwardTo2faLoginPg')
						{
							maxResendCount = thisController.getMaxResendCount();
							var cacheResndCnt = localStorage.resendCount;
							if (Ext.isEmpty(cacheResndCnt))
							{
								localStorage.setItem('resendCount',resendCount);
							}
							localStorage.setItem('maxResendCount',maxResendCount);
							if (localStorage.resendCount < maxResendCount)
							{
								task.start();
							}
						}
					}
				}
			},
			failure: function(form, action)
			{
				localStorage.clear();
				myRegMask.hide();
				window.location.href = "/final";
			}
		});

	},
	
	twofalogin: function()
	{
		var cancelClicked = localStorage.cancelClicked;
		if (!Ext.isEmpty(cancelClicked) && cancelClicked.toLowerCase() == 'true')
		{
			window.location.href = "/final";
			return;
		}

		var otpVal = Ext.getCmp('otp').getValue();
		otpVal = otpVal.replace(/-|\s/g,"");
		var  errorCmp = Ext.getCmp('otperrorState');
		var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
		if (Ext.isEmpty(otpVal))
		{
			thisController.validateErrorTextTooltip('otp',verificationMsg,errorCmp);
			return false;
		}
		else
		{
			var email = Ext.getCmp('_empcode').getValue();
			var from = Ext.getCmp('_from').getValue();
			var twoFA = Ext.getCmp('_twoFA').getValue();
			if (!Ext.isEmpty(twoFA) && (twoFA == 'fwdToGoogleAuthLoginPage' || twoFA == 'forwardTo2faLoginPg'))
			{
				thisController.authenticate(otpVal);
			}
			else
			{
				var thisForm = Ext.getCmp('TwoFA').getForm();

				var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Verification in progress...'});
				myRegMask.show();

				Ext.Ajax.request({
					url : '/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
					method : 'POST',
					params: {
						'email': parent.filterEncode(email),
						'requestFrom': 'validateOTP',
						'otp': otpVal,
						'from': from,
						'reqFrom':reqFrom,
						'twoFA':twoFA,
						'userTimeZoneDate':parent.filterEncode(encodeURIComponent(userTZDate))
					},
					async: false,
					success: function(response)
					{
						myRegMask.hide();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						var status = publicJSON.status;
						var mfa_status = publicJSON.mfa_status;
						if (!Ext.isEmpty(status) && status == 'right')
						{
							if (from!=null && from=='register')
							{
								thisController.finalReg("twofa");
							}
							else if (from!=null && from=='login')
							{
								thisController.finalLogin("twofa");
							}
						}
						else if (!Ext.isEmpty(status) && status == 'expired')
						{
							localStorage.clear();
							window.location.href ="/final/logout";
							return false;
						}
						else if (!Ext.isEmpty(status) && status == 'wrong')
						{
							if (mfa_status == 'lock')
							{
								localStorage.clear();
								window.location.href ="/final/logout";
							}
							else
							{
								thisController.validateErrorTextTooltip('',invalidVerMsg,errorCmp);
								return false;
							}
						}
					}
				});
			}
		}
	},

	finalReg : function(from)
	{
		var firstName = Ext.getCmp('hiddenFName').getValue();
		var lastName = Ext.getCmp('hiddenLName').getValue();
		var email = Ext.getCmp('hiddenEmail').getValue();
		var pass = Ext.getCmp('hiddenpass').getValue();
		var comp = Ext.getCmp('hiddenComp').getValue();
		var timeZone = Ext.getCmp('hiddenTimeZone').getValue();
		var phoneNo = Ext.getCmp('hiddenPhoneNo').getValue();
		var errorCmp;
		if (from != null && from=="register")
		{
			errorCmp = Ext.getCmp('errorState1');
		}
		else if (from != null && from=="twofa")
		{
			errorCmp = Ext.getCmp('otperrorState');
		}

		var _emailid = Ext.getCmp('emailid').getValue();
		var _password = Ext.getCmp('password').getValue();
		var _cpassword = Ext.getCmp('cpassword').getValue();

		_emailid = parent.filterEncode(_emailid);
		_password = parent.filterEncode(_password);
		_cpassword = parent.filterEncode(_cpassword);

		Ext.getCmp('emailid').setValue(_emailid);
		Ext.getCmp('password').setValue(_password);
		Ext.getCmp('cpassword').setValue(_cpassword);

		var myRegMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
		myRegMask.show();
		var thisForm = Ext.getCmp('RegForm').getForm();
		thisForm.submit({
			url: '/final/portal/PortalLogin/data/EgLogonp.jsp?comeFrom=register'+'&from=twofalogin&reqFrom='+reqFrom,
			method: 'POST',
			timeout: 120,
			success: function(form,action)
			{
				myRegMask.hide();
				if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText))
				{
					var jsonText = action.response.responseText;
					var resultObj = Ext.decode(jsonText);
					if (resultObj['success']=='user')
					{
						thisController.validateErrorTextTooltip('',resultObj['screenLabels']['userErr'],errorCmp);
						return false;
					}
					else if (resultObj['success']=='mail')
					{
						thisController.validateErrorTextTooltip('emailid',validMailIdMsg,errorCmp);
						return false;
					}
					else if (resultObj['success']=='extagent')
					{
						thisController.validateErrorTextTooltip('',resultObj['screenLabels']['extAgentErr'],errorCmp);
						return false;
					}
					else if (resultObj['success']=='comp')
					{
						thisController.validateErrorTextTooltip('',resultObj['screenLabels']['compErr'],errorCmp);
						return false;
					}
					else if (resultObj['success']=='true')
					{
						if (enableUserTracking != null && (enableUserTracking=='true' || enableUserTracking=='yes'))
						{
							var page_url =  window.location.href;
							_gaq.push(["_trackEvent", "logon simulator registration", "submit", page_url]);
						}
						var enc = resultObj['enc'];
						var defaultLS = resultObj['defaultLS'];
						if (resultObj['autoLogin']=='true')
						{
							sessionStorage.clear();
							var myRegMask1 = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
							myRegMask1.show();
							Ext.Ajax.request({
								url:'/final/servlet/com.egurkha.LoginServlet',
								params:'uname='+encodeURIComponent(email)+'&upass='+encodeURIComponent(enc),
								scope:this,
								timeout: 120000,

								success:function(response)
								{
									myRegMask1.hide();

									var pathname = window.location.pathname;
									if (pathname.endsWith("eglgn"))
									{
										var stateObj_admin = { foo: 1000 + Math.random()*1001 };
										history.pushState(stateObj_admin, "....", "/final/#!");
									}
									var v = response.responseText;
									var myarr = v.split(":");
									if(myarr[0]=="Error")
									{
										var errorCmp;
										if (from != null && from=="register")
										{
											errorCmp = Ext.getCmp('errorState1');
										}
										else if (from != null && from=="twofa")
										{
											errorCmp = Ext.getCmp('otperrorState');
										}
										var errorText = myarr[1];

										if (!Ext.isEmpty(errorText) && errorText != null && (errorText.indexOf("The session is being used") != -1))
										{
											errorText = "The user has been registered successfully. Please sign in to continue";
										}
										
										thisController.validateErrorTextTooltip('',errorText,errorCmp);
										return false;
									}
									else
									{
										if (reqFrom.toLowerCase() == 'citrix')
										{
											// successful registration mail to user
											if (cloudModel.toLowerCase() == 'phoenix')
											{
												var myRegMask2 = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
												myRegMask2.show();
												Ext.Ajax.request({
													url : '/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
													method : 'POST',
													params: {
														'email': parent.filterEncode(email),
														'fname': firstName,
														'requestFrom': 'sendSuccessfulRegMail'
													},
													async: false,
													success: function(response)
													{
														myRegMask2.hide();
														var jsonText = response.responseText;
														publicJSON = Ext.decode(jsonText);
													}
												});
											}
											else
											{
												var myRegMask2 = new Ext.LoadMask(Ext.getBody(), {msg: 'Registration in progress...'});
												myRegMask2.show();
												Ext.Ajax.request({
													url : '/final/portal/PortalLogin/data/twoFactorAuthenticationPage.jsp',
													method : 'POST',
													params: {
														'email': parent.filterEncode(email),
														'fname': firstName,
														'lname': lastName,
														'comp': comp,
														'timeZone': timeZone,
														'phoneNo': phoneNo,
														'remoteIP': remoteIP,
														'requestFrom': 'sendSelfRegMail'
													},
													async: false,
													success: function(response)
													{
														myRegMask2.hide();
														var jsonText = response.responseText;
														publicJSON = Ext.decode(jsonText);
													}
												});
											}

											Ext.Ajax.request({
												url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
												params: "reqFrom="+reqFrom+"&via=register&refurl="+refurl,
												method : 'POST',
												scope:this,
												timeout: 120000,
												success : function(response)
												{
													localStorage.clear();
													window.location.href ="/final/egm";
												},
												failure : function(response)
												{
													//console.log("failure");
												}
											});
										}
										else
										{
											if (defaultLS!=null && defaultLS.toLowerCase()=="all")
											{
												Ext.Ajax.request({
													url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
													params: "entry=admin&reqFrom="+reqFrom+"&tab=comp&help=true&url="+url,
													method : 'POST',
													scope:this,
													timeout: 120000,
													success : function(response)
													{
														localStorage.clear();
														window.location.href ="/final/egm";
													},
													failure : function(response)
													{
														//console.log("failure");
													}
												});
											}
											else
											{
												Ext.Ajax.request({
													url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
													params: "entry=admin&reqFrom="+reqFrom+"&tab=configure&help=true&url="+url+'&refurl='+refurl,
													method : 'POST',
													scope:this,
													timeout: 120000,
													success : function(response)
													{
														localStorage.clear();
														window.location.href ="/final/egm";
													},
													failure : function(response)
													{
														//console.log("failure");
													}
												});
											}
										}
									}
								},
								failure : function(response, options)
								{
									thisController.validateErrorTextTooltip('','Failed!,Sorry! Problem occured while logging in',errorCmp);
								}
							});
						}
						else
						{
							localStorage.clear();
							sessionStorage.setItem("Register_Msg", 'Registered successfully. Please sign in to continue.');
							window.location.href ="/final";
							//thisController.validateErrorTextTooltip('','Registered successfully. Please sign in to continue.',errorCmp);
						}
					}
				}
			},
			failure: function(form,action)
			{
				myRegMask.hide();
			}
		});
	},
	
	login : function()
	{
		credObj = new Object();
		var username = Ext.getCmp('username').getValue();
		var pass = Ext.getCmp('pass').getValue();
		var errorCmp = Ext.getCmp('errorState');
		if(username!=null && username=='')
		{
			thisController.validateErrorTextTooltip('username',mailIDMsg,errorCmp);
			return false;
		}
		else if (username.indexOf(' ') == 0 )
		{
			thisController.validateErrorTextTooltip('username',userIDValidationMsg1,errorCmp);
			return false;
		}
		else if (username.lastIndexOf(' ')==username.length-1)
		{
			thisController.validateErrorTextTooltip('username',userIDValidationMsg2,errorCmp);
			return false;
		}
		else if (pass!=null && pass=='')
		{
			thisController.validateErrorTextTooltip('pass',passMsg,errorCmp);
			return false;
		}
		else
		{
			if (reqFrom == 'citrix'  || reqFrom == 'clsTrial') //&& (cloudModel != null && cloudModel.toLowerCase() == 'default'))
			{
				Ext.Ajax.request({
					url:'/final/portal/PortalLogin/data/encval.jsp',
					method: 'POST',
					params:
					{
						"key":pass,
						"reqFrom": reqFrom,
						"username": username,
						"fromST": fromST
					},
					standardSubmit: false,
					timeout: 300000,
					async: false,
					success: function(response)
					{
						if(response.status == 200)
						{
							var publicJSON = Ext.decode(response.responseText);
							eKey = publicJSON['eKey'];
							Ext.getCmp('hiddenuser').setValue(username);
							Ext.getCmp('hiddenpwd').setValue(eKey);
							var userCheck = publicJSON['userCheck'];
							if (userCheck!=null && userCheck!='undefined' && userCheck=='failure')
							{
								thisController.validateErrorTextTooltip('',mailIDCheckMsg,errorCmp);
								return false;
							}
							else if (userCheck!=null && userCheck!='undefined' && userCheck=='error')
							{
								thisController.validateErrorTextTooltip('',mailIDAuthMsg,errorCmp);
								return false;
							}
							else
							{
								thisController.finalLogin("login");
							}
						}
					},
					failure : function(response)
					{
						if (response.status == 403)
						{
							var url = "/final/eglgn?userName="+username+"&pass="+pass+"&reqFrom="+reqFrom+"&fromST=login";
							postCustomFormSubmit(url);
						}
					}
				});
			}
		}
	},

	authenticate : function(otp)
	{
		var username = Ext.getCmp('hiddenuser').getValue();
		var pass = Ext.getCmp('hiddenpwd').getValue();
		if (Ext.isEmpty(username))
		{
			username = localStorage.loginUsr;
		}
		if (Ext.isEmpty(pass))
		{
			pass = localStorage.loginPwd;
		}

		var loadmask = new Ext.LoadMask(Ext.getBody(), {msg: 'Signing in...'});
		loadmask.show();
		var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');

		Ext.Ajax.request({
			url:'/final/servlet/com.egurkha.LoginServlet',
			params:'uname='+encodeURIComponent(username)+'&upass='+encodeURIComponent(pass)+'&requestFrom=check2faotp&otp='+encodeURIComponent(otp)+'&userTimeZoneDate='+parent.filterEncode(encodeURIComponent(userTZDate))+'&fromPortal='+reqFrom+'&cloudModel='+cloudModel,
			scope:this,
			timeout: 120000,
			success:function(response)
			{
				loadmask.hide();
				var v = response.responseText;
				var myarr = v.split(":");
				if(myarr[0]=="Error")
				{
					if (myarr[1].startsWith('MFA_WRONG_OTP'))
					{	
						localStorage.clear();
						window.location.href ="/final/logout";
					}
					else
					{
						var errorCmp = Ext.getCmp('otperrorState');
						var errorText = myarr[1];
						var focusfield = '';

						if (!Ext.isEmpty(errorText) && errorText.toLowerCase() == "your verification code has expired.")
						{
							localStorage.clear();
							window.location.href ="/final/logout";
						}
						else
						{
							var pathname = window.location.pathname;
							if (pathname.endsWith("eglgn"))
							{
								var stateObj_admin = { foo: 1000 + Math.random()*1001 };
								history.pushState(stateObj_admin, "....", "/final/#!");
							}

							if (!Ext.isEmpty(errorText) && errorText != null && ((errorText.indexOf("The password is incorrect") != -1) || (errorText.indexOf("password may be incorrect") != -1)))
							{
								var password=Ext.getCmp('pass').getValue();
								focusfield = 'pass';
							}
							thisController.validateErrorTextTooltip(focusfield,errorText,errorCmp);
						}
						return false;
					}
				}
				else
				{
					var pathname = window.location.pathname;
					if (pathname.endsWith("eglgn"))
					{
						var stateObj_admin = { foo: 1000 + Math.random()*1001 };
						history.pushState(stateObj_admin, "....", "/final/#!");
					}

					if (reqFrom != null && reqFrom.toLowerCase() == 'clstrial')
					{
						if (enableUserTracking != null && (enableUserTracking=='true' || enableUserTracking=='yes'))
						{
							var page_url =  window.location.href;
							_gaq.push(["_trackEvent", "logon simulator login", "login",  page_url]);
						}

						credObj = new Object();
						Ext.Ajax.request({
							url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
							params: 'username='+encodeURIComponent(parent.filterEncode(username))+'&comeFrom=login&reqFrom='+reqFrom,
							method: 'POST',
							success: function(response)
							{
								var entry = '';
								var help = 'false';
								var jsonText = response.responseText;
								var jsonObj = Ext.decode(jsonText);
								var tab = jsonObj['tab'];
								if (tab != null  && tab != "monitor")
								{
									entry = 'admin';
									help = 'yes';
								}
							
								var compType = jsonObj['compType'];
								Ext.Ajax.request({
									url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
									params: "entry="+entry+"&reqFrom="+reqFrom+"&tab="+tab+"&compType="+compType+"&help="+help,
									method : 'POST',
									scope:this,
									timeout: 120000,
									success : function(response)
									{
										localStorage.clear();
										credObj = new Object();
										window.location.href ="/final/egm";
									},
									failure : function(response)
									{
										//console.log("failure");
									}
								});
							}
						});
					}
					else if (reqFrom != null && reqFrom.toLowerCase() == 'citrix')
					{
						Ext.Ajax.request({
							url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
							params: "entry=&reqFrom="+reqFrom,
							method : 'POST',
							scope:this,
							timeout: 120000,
							success : function(response)
							{
								localStorage.clear();
								credObj = new Object();
								window.location.href ="/final/egm";
							},
							failure : function(response)
							{
							}
						});
					}
				}
			},
			failure : function(response)
			{
				loadmask.hide();
				Ext.Msg.alert('Failed!','Sorry! Problem occured while logging in.');
			}
		});
	},

	finalLogin : function(from)
	{
		var username = Ext.getCmp('hiddenuser').getValue();
		var pass = Ext.getCmp('hiddenpwd').getValue();
		if (Ext.isEmpty(username))
		{
			username = localStorage.loginUsr;
		}
		if (Ext.isEmpty(pass))
		{
			pass = localStorage.loginPwd;
		}

		if (Ext.isEmpty(from))
		{
			pass = localStorage.from;
		}

		var loadmask = new Ext.LoadMask(Ext.getBody(), {msg: 'Signing in...'});
		loadmask.show();
		if (from != null && from=="login")
		{
			var errorCmp = Ext.getCmp('errorState');
		}
		else if (from != null && from=="twofa")
		{
			var errorCmp = Ext.getCmp('otperrorState');
		}
		
		Ext.Ajax.request({
			url:'/final/servlet/com.egurkha.LoginServlet',
			params:'uname='+encodeURIComponent(username)+'&upass='+encodeURIComponent(pass)+'&comeFrom=clsTrial&fromPortal='+reqFrom+'&portalReqFor='+from+'&cloudModel='+cloudModel,
			scope:this,
			timeout: 120000,
			success:function(response){
				loadmask.hide();
				var v = response.responseText;
				var myarr = v.split(":");
				var resultPg = v.split("~$~");
				if(myarr[0]=="Error")
				{
					var pathname = window.location.pathname;
					if (pathname.endsWith("eglgn"))
					{
						var stateObj_admin = { foo: 1000 + Math.random()*1001 };
						history.pushState(stateObj_admin, "....", "/final/#!");
					}

					var errorCmp;
					if (from != null && from=="login")
					{
						errorCmp = Ext.getCmp('errorState');
					}
					else if (from != null && from=="twofa")
					{
						errorCmp = Ext.getCmp('otperrorState');
					}
					var errorText = myarr[1];
					var focusfield = '';
					if (!Ext.isEmpty(errorText) && errorText != null && ((errorText.indexOf("The password is incorrect") != -1) || (errorText.indexOf("password may be incorrect") != -1)))
					{
						var password=Ext.getCmp('pass').getValue();
						focusfield = 'pass';
					}
					thisController.validateErrorTextTooltip(focusfield,errorText,errorCmp);
					return false;
				}
				else
				{
					var pathname = window.location.pathname;
					if (pathname.endsWith("eglgn"))
					{
						var stateObj_admin = { foo: 1000 + Math.random()*1001 };
						history.pushState(stateObj_admin, "....", "/final/#!");
					}

					if (reqFrom != null && reqFrom.toLowerCase() == 'clstrial')
					{
						if (enableUserTracking != null && (enableUserTracking=='true' || enableUserTracking=='yes'))
						{
							var page_url =  window.location.href;
							_gaq.push(["_trackEvent", "logon simulator login", "login",  page_url]);
						}
				
						if (!Ext.isEmpty(Ext.getCmp('errorState')))
						{
							Ext.getCmp('errorState').hide();
						}
						
						if (v.startsWith('fwdToGoogleAuthLoginPage'))
						{
							localStorage.setItem('cancelClicked', false);
							localStorage.setItem('loginUsr',username);
							localStorage.setItem('loginPwd', pass);
							localStorage.setItem('mailAddr',resultPg[1]);
							localStorage.setItem('twoFA','fwdToGoogleAuthLoginPage');

							var splitName = username;
							if (splitName.length > 40)
							{
								splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
							}
							Ext.getCmp('userIdLblCont').fullname = username;
							Ext.get('userIdLbl').update(splitName);
							Ext.get('userIdLblCont').show();

							Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code generated on your Google Authenticator</div>');
							thisController.sendOtpForLogin(username,'login','sendOTP','fwdToGoogleAuthLoginPage');
							credObj.twoFA = "fwdToGoogleAuthLoginPage";
						}
						else if (!Ext.isEmpty(resultPg) && resultPg[0] == "forwardTo2faLoginPg")
						{
							Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code sent to your email address <span class="mailText">'+resultPg[1]+'</span></div>');
							
							localStorage.setItem('cancelClicked', false);
							localStorage.setItem('loginUsr',username);
							localStorage.setItem('loginPwd', pass);
							localStorage.setItem('mailAddr',resultPg[1]);
							localStorage.setItem('twoFA',resultPg[0]);
							localStorage.setItem('from','login');

							var splitName = username;
							if (splitName.length > 40)
							{
								splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
							}
							Ext.getCmp('userIdLblCont').fullname = username;
							Ext.get('userIdLbl').update(splitName);
							Ext.get('userIdLblCont').show();

							credObj.username = username;
							credObj.password = pass;
							credObj.twoFA = resultPg[0];
							credObj.from = 'login';
							if (!Ext.isEmpty(resultPg[2]))
							{
								localStorage.setItem('loggedInUser',resultPg[2]);
								credObj.loggedInUserFor2FA = resultPg[2];		
							}
							thisController.sendOtpForLogin(username,'login','sendOTP',resultPg[0]);
						}
						else if (v.startsWith('enable2FaForLogin'))
						{
							localStorage.setItem('cancelClicked', false);
							localStorage.setItem('loginUsr',resultPg[1]);
							localStorage.setItem('loginPwd', pass);
							localStorage.setItem('mailAddr',resultPg[1]);
							localStorage.setItem('twoFA','');
							localStorage.setItem('from','login');

							var splitName = resultPg[1];
							if (splitName.length > 40)
							{
								splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
							}
							Ext.getCmp('userIdLblCont').fullname = resultPg[1];
							Ext.get('userIdLbl').update(splitName);
							Ext.get('userIdLblCont').show();

							Ext.getCmp('mailIdLabel').update('<div class="verificationMsg">Enter the verification code sent to your email address <span class="mailText">'+resultPg[1]+'</span></div>');
							thisController.sendOtp(resultPg[1],'login','sendOTP');
							credObj.from = 'login';
							credObj.username = resultPg[1];
							credObj.twoFA = '';

						}
						else
						{
							Ext.Ajax.request({
								url: '/final/portal/PortalLogin/data/EgLogonp.jsp?',
								params: 'username='+encodeURIComponent(parent.filterEncode(username))+'&comeFrom=login&reqFrom='+reqFrom,
								method: 'POST',
								success: function(response)
								{
									var entry = '';
									var help = 'false';
									var jsonText = response.responseText;
									var jsonObj = Ext.decode(jsonText);
									var tab = jsonObj['tab'];
									if (tab != null  && tab != "monitor")
									{
										entry = 'admin';
										help = 'yes';
									}
								
									var compType = jsonObj['compType'];
									Ext.Ajax.request({
										url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
										params: "entry="+entry+"&reqFrom="+reqFrom+"&tab="+tab+"&compType="+compType+"&help="+help,
										method : 'POST',
										scope:this,
										timeout: 120000,
										success : function(response)
										{
											localStorage.clear();
											credObj = new Object();
											window.location.href ="/final/egm";
										},
										failure : function(response)
										{
											//console.log("failure");
										}
									});
								}
							});
						}
					}
					else if (reqFrom != null && reqFrom.toLowerCase() == 'citrix')
					{
						// 2FA code starts here
						if (!Ext.isEmpty(Ext.getCmp('errorState')))
						{
							Ext.getCmp('errorState').hide();
						}
						
						var _mailIDLblClsPrefix = '';
						if (cloudModel != null && cloudModel.toLowerCase() == 'default')
						{
							_mailIDLblClsPrefix = "cs_";
						}
						

						if (v.startsWith('fwdToGoogleAuthLoginPage'))
						{
							localStorage.setItem('cancelClicked', false);
							localStorage.setItem('loginUsr',username);
							localStorage.setItem('loginPwd', pass);
							localStorage.setItem('mailAddr',resultPg[1]);
							localStorage.setItem('twoFA','fwdToGoogleAuthLoginPage');
							Ext.getCmp('mailIdLabel').update('<div class="'+_mailIDLblClsPrefix+'verificationMsg">Enter the verification code generated on your Google Authenticator</div>');

							var splitName = username;
							if (splitName.length > 40)
							{
								splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
							}
							Ext.getCmp('userIdLblCont').fullname = username;
							Ext.get('userIdLbl').update(splitName);
							Ext.get('userIdLblCont').show();
							
							credObj.twoFA = "fwdToGoogleAuthLoginPage";
							thisController.sendOtpForLogin(username,'login','sendOTP','fwdToGoogleAuthLoginPage');
						}
						else if (!Ext.isEmpty(resultPg) && resultPg[0] == "forwardTo2faLoginPg")
						{
							localStorage.setItem('cancelClicked', false);
							localStorage.setItem('loginUsr',username);
							localStorage.setItem('loginPwd', pass);
							localStorage.setItem('mailAddr',resultPg[1]);
							localStorage.setItem('twoFA',resultPg[0]);
							localStorage.setItem('from','login');

							var splitName = username;
							if (splitName.length > 40)
							{
								splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
							}
							Ext.getCmp('userIdLblCont').fullname = username;
							Ext.get('userIdLbl').update(splitName);
							Ext.get('userIdLblCont').show();

							Ext.getCmp('mailIdLabel').update('<div class="'+_mailIDLblClsPrefix+'verificationMsg">Enter the verification code sent to your email address<br/> <span class="'+_mailIDLblClsPrefix+'mailText">'+resultPg[1]+'</span></div>');
							
							credObj.username = username;
							credObj.password = pass;
							if (!Ext.isEmpty(resultPg[2]))
							{
								localStorage.setItem('loggedInUser',resultPg[2]);
								credObj.loggedInUserFor2FA = resultPg[2];		
							}
							thisController.sendOtpForLogin(username,'login','sendOTP',resultPg[0]);
						}
						// 2FA code ends here
						else
						{
							Ext.Ajax.request({
								url : "/final/portal/PortalLogin/data/EgSetSessionAttribute.jsp?",
								params: "entry=&reqFrom="+reqFrom,
								method : 'POST',
								scope:this,
								timeout: 120000,
								success : function(response)
								{
									localStorage.clear();
									credObj = new Object();
									window.location.href ="/final/egm";
								},
								failure : function(response)
								{
									//console.log("failure");
								}
							});
						}
					}
				}
			},
			failure: function(response, options)
			{
				localStorage.clear();
				loadmask.hide();
				thisController.validateErrorTextTooltip('','Failed!,Sorry! Problem occured while logging in',errorCmp);
			}
		});
	},

	getPassword : function()
	{
		var user = Ext.getCmp("fpusername").getValue();
		var  errorCmp = Ext.getCmp('errorState2');
		if(user!=null && user=='')
		{
			thisController.validateErrorTextTooltip('fpusername',fmailIdMsg,errorCmp);
			return false;
		}
		else
		{
			var loadmask = new Ext.LoadMask(Ext.getBody(), {
								msg : "Fetching..."
							});
			loadmask.show();
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.LoginHelperServlet',
				params:'user='+encodeURIComponent(user),
				scope:this,
				timeout:120000,
				success:function(response){
					loadmask.hide();
					var jsontext = response.responseText;
					var fieldId = '';
					if (jsontext != null && ((jsontext.indexOf("Username does not exist") != -1)))
					{
						jsontext = mailIDCheckMsg;
						fieldId = 'fpusername';
					}
					var errorCmp = Ext.getCmp("errorState2");
					thisController.validateErrorTextTooltip(fieldId,jsontext+'.',errorCmp);
				},
				failure: function(response){
					loadmask.hide();
					thisController.validateErrorTextTooltip('','Problem occured while fetching the password.',errorCmp);
				}
			});
		}
	},
	
	closeGenericErrorTip : function()
	{
		Ext.getCmp('errorState').hide();
	},

	validateErrorTextTooltip : function(target,msg,errorCmp)
	{
		if (reqFrom == "clsTrial")
		{
			var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="ls_loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+msg+'</td></tr></table>';
			errorCmp.show();
			errorCmp.setErrors(htm1);
			if (!Ext.isEmpty(target))
			{
				Ext.getCmp(target).focus();
			}
		}
		else if (reqFrom == "citrix")
		{
			if (cloudModel != null && cloudModel.toLowerCase() == 'phoenix')
			{
				var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="ls_loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+msg+'</td></tr></table>';
				errorCmp.show();
				errorCmp.setErrors(htm1);
				if (!Ext.isEmpty(target))
				{
					Ext.getCmp(target).focus();
				}
			}
			else
			{
				if (!Ext.isEmpty(target))
				{
					var x = Ext.fly(target).getXY()[0];
					var y = Ext.fly(target).getXY()[1];

					if (target == 'otp')
					{
						y = y+6;
					}

					var tooltip = new Ext.ToolTip({
						anchor: 'top',
						anchorOffset: 0,
						anchortoTarget : true,
						mouseOffset: [0, -5],
						html: msg,
						autoHide: false,
						cls: "cs_validateErrorTextTooltip",
					}).showAt([x , y + 43]);
					Ext.getCmp(target).addCls('cs_warning');
				}
				else
				{
					var htm1 = '<div class="cs_loginErrorMsg">'+msg+'</div><div style="float:right"><img src="/final/images/spacer.gif" class="errorClose" id="errorClose" style="cursor:pointer;" onclick="javascript:thisController.closeGenericErrorTip();"></div>';
					Ext.getCmp('errorState').update(htm1);
					Ext.getCmp('errorState').show();
				}
			}
		}
	}
});

function checkspecial(fieldValue,s_spl)
{
	var obj_val = fieldValue;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function validateMobileNo(phoneNo)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	//var regExp2= /^\(*\+*[1-9]{0,3}\)*-*[1-9]{0,3}[-. /]*\(*[2-9]\d{2}\)*[-. /]*\d{3}[-. /]*\d{4} *e*x*t*\.* *\d{0,4}$/gm;
	var regExp2= /(\+?( |-|\.)?\d{1,2}( |-|\.)?)?(\(?\d{3}\)?|\d{3})( |-|\.)?(\d{3}( |-|\.)?\d{4})/gm;
	var arr = phoneNo.split(',');
	var arrCnt = arr.length;
	var isValidNumber = false;

	if(arrCnt != null && arrCnt == 1)
	{
		if (arr.toString().length >= 7 && arr.toString().length <= 20)
		{
			var toSmsResult= arr.toString().match(regExp1);
			var toSmsResult1= arr.toString().match(regExp2);
			if (arr != null && toSmsResult == arr.toString())
			{
				isValidNumber = true;
			}
			else if (arr != null && toSmsResult1 == arr.toString())
			{
				isValidNumber = true;
			}
			else
			{
				isValidNumber = false;
			}

			if (arr.toString().indexOf("123456789") != -1)
			{
				isValidNumber = false;
			}
			if (arr.toString().match(/^(.)\1+$/gm) == arr.toString())
			{
				isValidNumber = false;
			}
		}
		else
		{
			isValidNumber = false;
		}
	}
	else
	{
		for(var i=0; i<arr.length; i++)
		{
			if (arr[i].length >= 7 && arr[i].length <= 20)
			{
				var toSmsResult= arr[i].match(regExp1);
				var toSmsResult1= arr[i].match(regExp2);
				if (arr != null && toSmsResult == arr[i])
				{
					isValidNumber = true;
				}
				else if (arr != null && toSmsResult1 == arr[i])
				{
					isValidNumber = true;
				}
				else
				{
					isValidNumber = false;
					break;
				}

				if (arr[i].indexOf("123456789") != -1)
				{
					isValidNumber = false;
					break;
				}
				if (arr[i].match(/^(.)\1+$/gm) == arr[i])
				{
					isValidNumber = false;
					break;
				}
			}
			else
			{
				isValidNumber = false;
				break;
			}
		}
	}
	return isValidNumber;
}

function postCustomFormSubmit(QString)
{
	var url = '';
	var params = '';
	var len = QString.indexOf('?');
	if (len > -1)
	{
		url = QString.substring(0,len);
		params = QString.substring(len+1);
	}
	var strArr = params.split('&');

	var form = document.createElement('form');
	form.setAttribute('method', 'post');
	form.setAttribute('action', url);

	for (var i=0; i<strArr.length; i++) 
	{
		var name = '';
		var value = '';
		var paramValue = strArr[i];
		var paramLen = paramValue.indexOf('=');
		if (paramLen > -1)
		{
			name = paramValue.substring(0,paramLen);
			value = paramValue.substring(paramLen+1);
		}
		if (strArr.hasOwnProperty(i)) 
		{
			var hiddenField = document.createElement('input');
			hiddenField.setAttribute('type', 'hidden');
			hiddenField.setAttribute('name', name);
			hiddenField.setAttribute('value', value);

			form.appendChild(hiddenField);
		}
	}

	document.body.appendChild(form);
	form.submit();
}

function checkDoubleSpaces(fieldvalue)
{
	var s_val = fieldvalue;
	for (var k=0;k < s_val.length;k++)
	{
		if (s_val.charAt(k) == ' ' && s_val.charAt(k + 1) == ' ')
		{
			return false;
		}
	}
	return true;
}

function checkForAlphaNumeric(value)
{
	var aphabets = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_- ";
	var hasNonAphabets = "false";
	for (var i=0;i<value.length;i++)
	{
		var strChar = value.charAt(i);
		if (aphabets.indexOf(strChar) == -1)
		{
			hasNonAphabets = "true";
			break;
		}
	}

	if (hasNonAphabets == "true")
	{
		return false;
	}
	else
	{
		return true;
	}
}


