Ext.define('CapacityPlanningReports.view.Configdatas', {
	requires : ['Ext.selection.CheckboxModel'],
	extend : 'utilities.CustomGrid',
	alias : 'widget.configdatas',
 	id : 'configdatasCapacity',
	margin : 10,
	ui:'newGridPanel',
	enableColumnMove : false,
	enableColumnHide : false,
	sortableColumns : false,
	selModel : new Ext.selection.CheckboxModel({
		checkOnly : true,
		width : 100,
			style:{'padding':'10px'},
		injectCheckbox : 0
	}),
	height : 130,
	store : new Ext.data.Store({
		fields : ['Name', 'Type', 'Test', 'Measure', 'Descriptor',
				'Name_value', 'Type_value', 'Test_value',
				'Measure_value', 'Descriptor_value','Hiddens']
		}),
	viewConfig : {
		deferEmptyText : false,
		emptyText : '</br><div class="x-grid-empty" style="text-align:center;height:82px" ><div><b  style="cursor:pointer" id="linkId" ><div class="iconConfigUser" style="margin:0px auto" data-qtip="'+plsDefineConfigLabel+'" data-qclass="yellowTip"></div>'+plsDefineConfigLabel+'</b></div></div></div>'
	},
	border : true,
	columns : [
			{
				text : 'Name',
				dataIndex : 'Name',
				flex : 1
			}, {
				text : 'Type',
				dataIndex : 'Type',
				flex : 1
			}, {
				text : 'Test',
				dataIndex : 'Test',
				flex : 1
			}, {
				text : 'Measure',
				dataIndex : 'Measure',
				flex : 1
			}, {
				text : 'Descriptor',
				dataIndex : 'Descriptor',
				flex : 1
			},
			{
				//header : '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconModify" id="modifyALL" style="cursor:pointer;margin-top: 5px" />',
				header : '',
				xtype : 'actioncolumn',
				iconCls: 'iconModify',
				style:{'padding':'0px !important'},
				width : 30,
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Modify Configuration'
						});
					}
				},
				items : [{
					iconCls: 'iconModify',
					tooltip:'Edit',
					style:{'padding':'0px'},
					handler : function(grid, htmlRow, index, columnIndex,
                            mouseEvent, record) {
							var myMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
							myMask.show();
							Ext.getCmp('configdatasCapacity').showModificationWindow(grid,record);				  
						setTimeout(function() {
							myMask.hide();
						}, 2000);
                    }
					//iconCls : 'data-qclass=yellowTip data-qtip=MMMMMM" style="margin-top:2px"'
					//cls: 'yellowTip',

				}]
			},{
				//header : '<img src="/final/images/removeall_single_icon.png" id="removeALL" style="cursor:pointer" />',
				header: '<div style="cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				renderer: function(value, metaData) {
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove" ';
							return value;
						},
				width : 36,
				items : [{
					//icon : '/final/images/remove-row.png',
					iconCls:'iconDelete',
					tooltip:'Remove',
					handler : function(grid, htmlRow, index, columnIndex,
							mouseEvent, record) {
						grid.getStore().remove(record);
						grid.refresh();
						var noOfrecords =grid.getStore().getCount();
						if (noOfrecords==0)
						{
							Ext.getCmp("scheduleTool").setDisabled(true);
							Ext.getCmp("favoriteTool").setDisabled(true);
							Ext.getCmp('configsettings').hide();
						}
						//grid.reload();
					}
				}]
			}],

	loadColumnHeaders : function(screenLabels) {
		if (!Ext.isEmpty(this.columns)) {
			this.columns[1].setText(screenLabels["graphLang"]);
			this.columns[2].setText(screenLabels["nameLang"]);
			this.columns[3].setText(screenLabels["typeLang"]);
			this.columns[4].setText(screenLabels["layerLang"]);
			this.columns[5].setText(screenLabels["testLang"]);
			this.columns[6].setText(screenLabels["measureLang"]);
			this.columns[7].setText(screenLabels["descLang"]);
		}
	},
	listeners : {
		afterLayout : function(c) {
		},
		'afterrender' : function(grid, scle) {
 			//Ext.select('.x-grid-row-checker').setStyle('margin-left','0px');
			//Ext.select('.x-action-col-icon').setStyle('padding-left','0px');
			grid.mon(Ext.select('#modifyALL'),'click',function(){
				Ext.getCmp('configdatasCapacity').showModificationWindow(grid,grid.getSelectionModel().getSelection());
			});
			grid.mon(Ext.select('#removeALL'), 'click', function() {
				var selectionArray = grid.getSelectionModel().getSelection();
				var selectionArrayLen=selectionArray.length;
				if (selectionArrayLen>0)
				{
					Ext.Msg.show({
					title : 'Alert',
					msg : 'Are you sure you want to remove selected configurations?',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal) {
							if (buttonVal == "yes") {
								var noOfrecords =grid.getStore().getCount();
								for (i = 0; i < selectionArrayLen; i++) {
									grid.getStore().remove(selectionArray[i]);
								}
								if(selectionArrayLen==noOfrecords)
								{
									Ext.getCmp("scheduleTool").setDisabled(true);
									Ext.getCmp("favoriteTool").setDisabled(true);
									Ext.getCmp('configsettings').hide();
								}
							}
						}
					});
				}
				else
				{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'No selected configurations to remove',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
			});
		}
	},
	showModificationWindow : function(grid,record){
		var configDatasGrid = grid.getStore();
		var noOfrecords = configDatasGrid.getCount();
        var selectionModelObj = grid.getSelectionModel();
        var s_measures = [];
        var s_desc = [];
        var meas = [];
        var test;
        var type;
        var name;
		var name_value;
        var meas;
        var measname;
		var desc_value;
		var hiddens;
        for (var i = 0; i < noOfrecords; i++) {
            var rec = configDatasGrid.getAt(i);
            if(selectionModelObj.isSelected(rec))
            {
                var Descriptor = rec.get('Descriptor');
                type = rec.get('Type_value');
                test = rec.get('Test_value');
                name = rec.get('Name');
				measname = rec.get('Measure');
				name_value = rec.get('Name_value');
				hiddens = rec.get('Hiddens');
				if(meas!=null && meas.indexOf(rec.get('Measure_value'))==-1)
				{
					meas.push(rec.get('Measure_value'));
				}
				if(s_desc!=null && s_desc.indexOf(Descriptor)==-1)
				{
					if(Descriptor=='-')
						Descriptor = '-1';
					s_desc.push(Descriptor);
				}
            }
        }
		var er_measure =Ext.getCmp('er_measure').getValue();
        for(var l=0; l < er_measure.length; l++) {
             s_measures.push(er_measure[l]);
        }
		var param = 'modifyTest='+test+'&modifycompname='+name+'&type='+type+'&from=modify';
        for(var j=0; j < meas.length; j++) {
            param += "&er_moddify_measure=" + meas[j];
        }
        for (var k = 0; k < s_desc.length; k++) {
            param += "&er_moddify_desc=" + s_desc[k];
        }
		Ext.Ajax.request({
		      url:'/final/servlet/com.eg.ErCapacityReportC',
		      params:param,
		      scope:this,
		      success:function(response)
		      {
		      	var jsontext = response.responseText;
		      	var jsonObject = Ext.decode(jsontext);
		      	var modifymeasure = Ext.getCmp('modifymeasure');

		        modifymeasure.getStore().loadRawData(jsonObject.measurearr);
		      	modifymeasure.setValue(meas);
		      	var itemselector = Ext.getCmp('itemSelector-Field');
                var itemselectorinclude = Ext.getCmp('itemselector-field');
		      	itemselector.getStore().loadRawData(jsonObject.excludedDesc);
		      	itemselector.setValue(s_desc);
                Ext.getCmp('comp').update('<span  style="width:100px" class="font_normal12">Component</span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.compname+'</span>');
                Ext.getCmp('test').update('<span  style="width:100px" class="font_normal12">Test</span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.test+'</span>');
                Ext.getCmp('type').update('<span  style="width:100px" class="font_normal12">Type</span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.comptype+'</span>');
		      }
		});
		Ext.getCmp('modifypopup').doLayout();
		Ext.getCmp('modifypopup').show();
	}
});
