Ext.define('ComparisonReportTests.view.Configdatas',{
	requires:[ 'Ext.selection.CheckboxModel','Ext.ux.data.PagingMemoryProxy'],
	extend:'Ext.grid.Panel',
	alias:'widget.configdatas',
	id:'configdatas',
	margin : '10 10',
	padding:'0 0 0 0',
	//scroll:false,
	//cls:'gridSkin',
	ui:'newGridPanel',
	frame:false,
	border:true,
	//scroll:true,
	//autoScroll:true,
	//enableColumnResize:false,
	enableColumnMove:false,
	enableColumnHide:false,
	sortableColumns: false,
	/*selModel :new Ext.selection.CheckboxModel(
		{   checkOnly: true,
			width:45,
			injectCheckbox: 'first'
		}),*/
	selModel: {mode: 'SIMPLE', headerWidth:26}, //added
	selType: 'checkboxmodel', //added
	pageLimit:4,
	activePage:1,
	dataArray:null,
	height:166,
	viewConfig: 
	{
		deferEmptyText: false,
		emptyText: '<div class="x-grid-empty" style="padding-top:30px;text-align:center" ><div><b style="cursor:pointer" id="linkId" title="Please define configuration"><div class="iconConfigUser" style="margin:0px auto" ></div>Please define configuration</b></div></div></div>',
		plugins: 
		{
			ptype: 'gridviewdragdrop',
			dragText:'Drag and drop to reorganize',		
			onViewRender : function(view) 
			{
				var me = this,
					scrollEl;
				if (me.enableDrag) 
				{
					if (me.containerScroll) {
						scrollEl = view.getEl();
					}
					me.dragZone = new Ext.view.DragZone({
						view: view,
						ddGroup: me.dragGroup || me.ddGroup,
						dragText: me.dragText,
						containerScroll: me.containerScroll,
						scrollEl: scrollEl,
						//to remember if the row was selected originally or not
						onBeforeDrag: function(data, e) 
						{
							var me = this,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							if (!selectionModel.isSelected(record)) {
								data.rowSelected = false;
							} 
							return true;
						},

						onInitDrag: function(x, y) 
						{
							var me = this,
								data = me.dragData,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							//for deselect the dragged record
							if (selectionModel.isSelected(record) && data.rowSelected == false) {
								selectionModel.deselect(record, true);                                
							}
							//added the original row so it will handle that in the drag drop
							data.records = [record];                            
							me.ddel.update(me.getDragText());
							me.proxy.update(me.ddel.dom);
							me.onStartDrag(x, y);
							return true;
						}
					});
				}
				if (me.enableDrop) 
				{
					me.dropZone = new Ext.grid.ViewDropZone({
						view: view,
						ddGroup: me.dropGroup || me.ddGroup,
						//changed the selection at the end of this method
						handleNodeDrop : function(data, record, position) {
							var view = this.view,
								store = view.getStore(),
								index, records, i, len;

							if (data.copy) {
								records = data.records;
								data.records = [];
								for (i = 0, len = records.length; i < len; i++) {
									data.records.push(records[i].copy());
								}
							} else {
								data.view.store.remove(data.records, data.view === view);
							}
							if (record && position) {
								index = store.indexOf(record);
								if (position !== 'before') {
									index++;
								}
								store.insert(index, data.records);
							}
							else {
								store.add(data.records);
							}
							if (view != data.view) {
								view.getSelectionModel().select(data.records);
							}
						}
					});
				}
			}
		}
	},
	initComponent:function()
	{
		var me=this;
		this.selModel  = new Ext.selection.CheckboxModel(
		{
			mode: 'SIMPLE',
			checkOnly: true,
			headerWidth:26
		});
			if(Ext.isEmpty(this.dataArray))
			this.dataArray=[];
		this.store = Ext.create('Ext.data.Store', {
			 proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:this.pageLimit,
			autoLoad : true,
			data : this.dataArray,
			fields: ['Name','Type','Test','Measure','Descriptor','Hiddens', 'testVal'],
			id: 'tmpStore',
		});

		this.columns= [{
			text: nameLang,
			dataIndex: 'Name',
			flex: 1
		}, {
			text: typeLang,
			dataIndex: 'Type',
			flex: 1
		}, {
			text: testLang,
			dataIndex: 'Test',
			flex: 1
		}, {
			text: measureLang,
			dataIndex: 'Measure',
			flex: 1
		}, {
			text: descLang,
			dataIndex: 'Descriptor',
			flex: 1
		},
		{
			dataIndex: 'Hiddens',
			hidden: true
		}, {
			dataIndex: 'testVal',
			hidden: true

		},{
			header: '<div style="cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
			xtype: 'actioncolumn',
			width:40,
			renderer: function(value, metaData) 
			{
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove" ';
				return value;
			},
			items: [{
				 iconCls:'iconDelete',
				 handler: function (grid, htmlRow, index, columnIndex, mouseEvent, record)
				 {
					var showReportObj =Ext.getCmp('resultPanel');
					grid.getStore().removeAt(record.index);
					grid.refresh();
					var gridObj = Ext.getCmp('configdatas');
					var datArray=gridObj.dataArray;
					datArray.splice(record.index, 1);
					var pageingTool = Ext.getCmp('pageingTool');
					var last = pageingTool.store.currentPage ;
					if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
					{
						if(grid.getStore().getCount() == 0)
						{
							last = last-1;
						}
						pageingTool.store.loadPage(last);
					}
					var noOfrecords =datArray.length;
					if (noOfrecords==0)
					{
						Ext.getCmp('my_formouter').hide();
						showReportObj.hide();
					}
				 }
			}]
		}];
		this.dockedItems=[
		{
			xtype:'pagingtoolbar',
			cls:'newPagination',
			dock: 'bottom',
			displayInfo: true,
			id:'pageingTool',
			style:strSkin =="Light"?{'border-top':'0px !important'}:{'border-top':'1px'},
			pageSize:this.pageLimit,
			store: this.store,
			displayMsg: 'Displaying Booklets {0} - {1} of {2}',
			listeners: {
				change : function(thisd, params)
				{
					if(!Ext.isEmpty(params))
						me.activePage = params.currentPage;
					else
						me.activePage=0;
				}
			}
		}];
		this.callParent();
	},
	listeners: 
	{
		'afterrender': function (grid, scle) 
		{
			grid.mon(Ext.select('#removeALL'), 'click', function() {
				var selectionArray = grid.getSelectionModel().getSelection();
				var selectionArrayLen=selectionArray.length;
				if (selectionArrayLen>0)
				{
					Ext.Msg.show({
					title : 'Alert',
					msg : 'Are you sure you want to remove selected configurations?',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal) {
							if (buttonVal == "yes") {
								var datArray=grid.dataArray;
								if(datArray != undefined)
								{
									var showReportObj =Ext.getCmp('resultPanel');
                 	//if(grid.store.pageSize == selectionArrayLen || selectionArrayLen == grid.getStore().getCount())
									if(selectionArrayLen == grid.dataArray.length)
									{
										grid.getStore().removeAll();
										datArray.splice(0, datArray.length);
									}
									else if(selectionArrayLen < datArray.length)
									{
										for(var i=selectionArrayLen-1; i >= 0; i--)
										{
											var row = selectionArray[i];
											grid.getStore().removeAt(row.index);
											datArray.splice(row.index, 1);
										}
									}
									var pageingTool = Ext.getCmp('pageingTool');
									var last = pageingTool.store.currentPage ;
									if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
									{
										var lastPage = (datArray.length/grid.store.pageSize);
										if(lastPage==last-1)
										{
											lastPage = last-1;
										}
										else
										{
											lastPage = last;
										}
										pageingTool.store.loadPage(lastPage);
									}
									var noOfrecords =datArray.length;
									if (noOfrecords==0)
									{
										Ext.getCmp('my_formouter').hide();
										showReportObj.hide();
									}
								}
							}
						}
					});
				}
				else
				{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'No selected configurations to remove',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
			}
			);
		}
	}
});