$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsInstance(container_Id,chartHeight,chartWidth){
	var drawChart = true;
	var chartBgColor =  "#404040";
	if(strSkin == 'Light'){
		chartBgColor =  "#ffffff";
	}
 var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			backgroundColor:chartBgColor,
			plotBackgroundColor: 'white',
			plotShadow: false,
			shadow: false,
			zoomType:'xy', 
			ignoreHiddenSeries:false,
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
			border :0,
			//min:0,
			minPadding :0,
			startOnTick: false,
			gridLineWidth: 0,
			tickPixelInterval: 50,
			tickmarkPlacement: 'on',
			reversedStacks: false,
			labels: {
				align: 'right',
				x: -10,
				y: 3,
				formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					val = (parseFloat(val));
					/*var val_ar = val.split('.');
					if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
					}*/
					return val;
				},
				style: {
					color : 'black',
					fontWeight: 'bold',
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'normal',
				},
			},
			showLastLabel: true,
		},
		plotOptions: {
			series: {
			connectNulls : false,
			smoothed: true,
			lineWidth: 3,
			marker: {
				enabled: false
				}
			},
			line: {
				shadow: false,
				linewidth :10
			}
		},
		scrollbar: {
			enabled: false
		},
		//legend: {		},
		labels :{
			itemStyle: {
				color : 'black',
				fontWeight: 'bold',
				fontSize: '11px',
			},
		},
		tooltip: {
			shared: true,
			//backgroundColor : 'white',
			borderColor: 'black',
			valueDecimals: 4,
			//headerFormat: '{point.key}<br>',
			//pointFormat: '{series.name}  <b>:  {point.y}</b><br>',
			style: {
					color : 'black',
					padding: 10,
					fontWeight: 'bold',
					fontSize: '11px',
				},
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
			border :1,
			lineWidth: 1,
			//minPadding:0.02,
			//maxPadding:0.02,
			type: 'datetime',
			ordinal: false,
			showLastLabel: true,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: false,
			tickmarkPlacement: 'on',
			labels: {
				rotation:270,
				//y:40,
				//x:4,
				//align: 'center',
				style: {
					color : '#636363',
					fontWeight: 'Regular',
					fontSize: '10px',
				},
				overflow: 'justify',
				//maxStaggerLines : 7,
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: false,
				useHTML: false,
				tickPixelInterval: 50,
			},
			title: {
				enabled: true,
			}
		},
		title: {
				text: '',
				offset: '',
				margin: 0
			},
		series: {
		}
	},
	setData: function(jsonData,currentDateFormat,drilldownurl) {
 		var toolTipFmt = '';
		var chartType = 'line';
		toolTipFmt = tooltipDateFormate(currentDateFormat);
		var timeline_out_format = '';
		ymax = null;// jsonData['maxRange'];
		var commonmax= jsonData['commonmaxRange']
	
		ymin = jsonData['minRange'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		startTime = jsonData['lowerLimit'];
		yaxisTitle = jsonData['yLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xLabel'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		chartType='scatter';
		var line_width=jsonData['LineWidth'];
		var reportType=jsonData['reportType'];	
		var HealthPlotBandsValue=jsonData['HealthPlotBandsValue'];	
		var SlowPlotBandsValue=jsonData['SlowPlotBandsValue'];	
		var StalledPlotBandsValue = SlowPlotBandsValue+590000;
		//
		var isCapacityCumulationReport=jsonData['isCapacityCumulationReport'];	
		//
		var s_time_fout = jsonData['TimeFormatOut'];
		var s_showdisconnectedline = jsonData['showdisconnectedline'];
		var LegendValues = jsonData['ShowLegendinTableFormatforUI'];
		var showdisconnectedline=true;
		if(s_showdisconnectedline != null && s_showdisconnectedline =='No') 
			showdisconnectedline = false;
		needXtype=false;
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		commonmax =(commonmax == null || commonmax == 0)?null:commonmax;
		ymax =(ymax == null || ymax == 0)?null:ymax;
		if(yaxisTitle == '%' || yaxisTitle =='(%)')
		{
			if(ymax>90)
				commonmax =(commonmax == null || commonmax == 0)?100:commonmax;

		}
		if(yaxisTitle == null || yaxisTitle == '')
			spacing=[20, 5, 0, 20];
		else
			spacing=[20, 5, 0, 20];
		if(commonmax == null || commonmax == 0)
			commonmax=ymax;
		ymin =(ymin == null )?0:ymin;
		if(ymin ==ymax )
			ymax = ymin+1;
		var mpad = null;
		if(setyaxismin!=null && setyaxismin =='True')
		{
			ymin=null;
			mpad=0;
		}
		fontFamily='Arial';
		LegendFont='Arial';
		var bgcolor='rgba(255, 255, 255, 0.85)';
		if(strSkin=='Dark' || strSkin=='dark')
		{
			bgcolor='#000000';
		}
		var seriesCounter = 0;
		var XaixLineWidth=1;
		var YaixLineWidth=0;
		var linecount=0;
		if(!(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined))
		{
			if(jsonData['DataSet'].length>10 && (LegendPosition == undefined || LegendPosition == 'undefined') ){
				LegendPosition = 'right';
			}
			seriesCounter=jsonData['DataSet'].length;
			if(jsonData['DataSet'].length==1)
			{
				bgcolor=jsonData['DataSet'][0]['color'];
			}
			linecount=jsonData['DataSet'].length;
		}
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['ylabel']:yaxisTitle;
		line_width =(line_width == null || line_width == '')?1:line_width;
		if(yaxisTitle!=null && yaxisTitle.length>0)
		{
			if(yaxisTitle.length>32){
				var strtt1 = yaxisTitle.substring(32);
				if(strtt1.length>3)
					yaxisTitle = yaxisTitle.substring(0,32)+"...";
			}
		}
		
		if(YtitleEnable==false)
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
 
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xtitleEnable =(xLabel == null || xLabel == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		startTime =(startTime == null || startTime == '')?null:startTime;
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
		timeline_out_format = getTimeLineOutputFormat(s_time_fout);
		var marker_enabled =false;
		var isVMPeakSession = jsonData['isVMPeakSession'];		
		if(isVMPeakSession)
		{
			if(timeline_out_format.lastIndexOf(',') > -1)
			{
				timeline_out_format = timeline_out_format.substring(0, timeline_out_format.lastIndexOf(','));
			}
			if(toolTipFmt.lastIndexOf(' ') > -1)
			{
				toolTipFmt = toolTipFmt.substring(0, toolTipFmt.lastIndexOf(' '));
			}
			marker_enabled = true;
		}	
		legendWidth = (LegendPosition == 'right')?400:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:37;
		var fixXlabel=jsonData['fixXlabel'];
		var chartContObj_1=document.getElementById(container_Id);
		if($(chartContObj_1).width()>1000)
			legendWidth=800;

		maxLegendHeight=45;
		if(((linecount*8)/37)>1)
			maxLegendHeight=60;
		if(linecount<=2)
			legendWidth=190;
		valign = (LegendPosition == 'right')?'middle':'top';
		LegendPosition='center';
		if(legendWidth>190 && valign =='top')
			LegendPosition='right';

		var chartFor = jsonData['chartFor'];
		var yAxisLabelYval = jsonData['yAxisLabelYval'];
		var xType = 'datetime';
		var stacked = null;		
		var tooltipObj =null;
		over_line_width=line_width-2;
		if(over_line_width == 0)
			over_line_width = line_width
		var yVal = "";
		if(s_time_fout == "HH:mm")
		{
			yVal = 33;
		}
		else
		{
			yVal = 51;
			if(yAxisLabelYval!=null && yAxisLabelYval=='21')
				yVal = 21;
		}
		if(xtitleEnable)
		{
			if(s_time_fout == "HH:mm")
			{
				yVal = 20;
				if(yAxisLabelYval!=null)
					yVal = 28;
			}else
			if(s_time_fout.indexOf("HH:mm:ss")>-1)
			{
				yVal = 60;
				if(yAxisLabelYval!=null)
					yVal = 21;
			}
			else if((s_time_fout.indexOf("HH:mm:ss")>-1 || (s_time_fout.indexOf("dd")>-1 && s_time_fout.indexOf("HH:mm")>-1) || (s_time_fout.indexOf("d")>-1 && s_time_fout.indexOf("HH:mm")>-1)) && LegendValues == undefined)
			{
				yVal = 60;
				if(yAxisLabelYval!=null)
					yVal = 21;
			}
			else
			{
				yVal = 21;
				if(yAxisLabelYval!=null && yAxisLabelYval=='21')
					yVal = 21;
			}
		}
		//
		if(isCapacityCumulationReport)
		{
		  yVal = 51;
		}
		//
		if(fixXlabel != null && fixXlabel !='undefined' && fixXlabel != undefined)
		{
			yVal = 20;
		}

		if(xtitleEnable)
			spacing=[20, 5, 10, 20];
		var chartContObj=document.getElementById(container_Id);
		var reflowVal = true;
			reflowVal=jsonData['reflow'];
		if(reflowVal == null || reflowVal =='undefined' || reflowVal == undefined)
				reflowVal=true;
		
		
		var isCapacityPlanningReport=jsonData['isCapacityPlanningReport'];
		if(isCapacityPlanningReport != null && isCapacityPlanningReport !='undefined' && isCapacityPlanningReport != undefined && isCapacityPlanningReport == 'true')
				spacing=[20,20, 10, 20];
		
//		var showLegends = false;
//		if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
		
		var showLegends = false;
		if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
		{
			showLegends = Ext.getCmp('showLegend').getValue();
		}
		var strShowLeg= jsonData['showLegends'];
		if(strShowLeg!=null && strShowLeg == 'true')
			showLegends= true;
		//showLegends = false;
		if(chartType!=null && chartType=='stack')
		{
			
			chartType = 'area',
			stacked ='normal';
		}
		if(chartType!=null && chartType=='scatter')
		{
			if(jsonData['needXtype'] != undefined && jsonData['needXtype']=='yes')
			{
				needXtype=true;
				//XaixLineWidth=0;
			}
			else
				xType = null;
			line_width = null;
			marker_enabled = true;
			tooltipObj ={
						//headerFormat: '',
						pointFormat: yaxisTitle+':  {point.x}<br>'+xLabel+':  {point.y}'
					}
		}
		var yRange=-25;
		
		if (!Ext.isEmpty(reportType) && reportType=='TCR')
		{
			spacing=[35, 5, 0, 20];
			//yRange=-35;
		}
		//
		var xRange=0;
		var chartContainerWidth=document.getElementById(container_Id);
		if($(chartContainerWidth).width()>1000)
		{
			if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
			{
				if (jsonData['DataSet'].length==1)
				{
					xRange = 80;
				}
				else if (jsonData['DataSet'].length==2)
				{
					xRange = 280;
				}
				else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=4)
				{
					xRange = 300;
				}
				else if (jsonData['DataSet'].length>=5 && jsonData['DataSet'].length<=8)
				{
					xRange = 110;
				}
				else if(jsonData['DataSet'].length>8)
				{
					xRange = -10;
				}
			}
		}
		else if($(chartContainerWidth).width()<1000)
		{
			if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
			{
				if (jsonData['DataSet'].length==1)
				{
					xRange = 80;
				}
				else if (jsonData['DataSet'].length==2)
				{
					xRange = 80;
				}
				else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=8)
				{
					xRange = 0;
				}
				else if(jsonData['DataSet'].length>8)
				{
					xRange = -10;
				}
			}
		}
		var spacing_top = jsonData['spacingTop'];
		var spacing_left = jsonData['spacingLeft'];
		var margin_top = jsonData['marginTop'];
		if (spacing_top==null || spacing_top==undefined || spacing_top=='')
		{
			spacing_top=20;
		}
		if (spacing_left==null || spacing_left==undefined || spacing_left=='')
		{
			spacing_left=5;
		}
		if (margin_top==null || margin_top==undefined || margin_top=='')
		{
			margin_top=20;
		}
		var margin_bottom=90;
		if(s_time_fout!=null && s_time_fout=='HH:mm')
			margin_bottom=50;
		if(xtitleEnable)
			margin_bottom = null;

		if(spacing_left =='15')
			spacing_left=15;
		var fromPopup = jsonData['fromPopup'];
		var valgn='top';
		var chartLegendDatas = jsonData['ShowLegendinTableFormatforUIData'];
		var enableHtmlforLegend=false;
		legendWidth=legendWidth+20;
		if(LegendValues != undefined && chartLegendDatas.length > 0){
			enableHtmlforLegend=true
			if (jsonData['DataSet'] != null && jsonData['DataSet'].length > 0){
				var legCnt=jsonData['DataSet'].length;
				var legvll=chartLegendDatas.length/5;
				if(legvll != undefined && legvll > 0 )
					legCnt=legvll;

				var legVal=(legCnt*25)+60;
				yRange=chartHeight;
				maxLegendHeight=legVal;
				if((xLabel != undefined && (xLabel.indexOf('MM') > -1 ) || xLabel == '' )){
					margin_bottom=legVal+70;
				}
				else
					margin_bottom=legVal+50;
				LegendPosition='left';
				legendWidth=null;
				chartHeight='';
				margin_top=null;
				var leg_Container=Ext.getCmp('legend_'+container_Id);
				var leg_div=document.getElementById('legend_'+container_Id);
				var leg_window=document.getElementById(container_Id+'_legend');
				var leg_panel=Ext.getCmp(container_Id+'_legendPanel');
				if(leg_Container != undefined || (leg_div != null && leg_div != undefined) || (leg_window != null && leg_window != undefined)|| (leg_panel != null && leg_panel != undefined)){
					margin_bottom=null;
				}
			}
		}
    		if(ymin == 0.0)
		   ymin = 0;
			
		var width1=97;
		var width2=99;
		var width3=82;
		if(s_time_fout == "HH:mm")
		{
			width1=110;
			width2=110;
			width3=95;
		}
		if(chartType == null || chartType == undefined)
			chartType = "line";
		if(chartType!=null && chartType == 'line')
			chartType = 'line';
		else if(chartType!=null && chartType == 'area')
			chartType = 'area';
		var xRangeArry = null;
		if(jsonData['xRangeArry'] != undefined)
			xRangeArry = jsonData['xRangeArry'];
		var tickintevalVal=null;
		if(chartType!=null && chartType == 'xrange' && jsonData['tickIntervalValue'] != undefined && jsonData['tickIntervalValue'] != '')
			tickintevalVal=jsonData['tickIntervalValue'];
		var url_default='/final/servlet/com.eg.ErBTMScatterChartAppC?er_type=No';
			url_default+='&drillDown=yes&isSubmit=true&requestFor=clearSessionInfo&showMainForm=no&viaEntryNode=yes&getGUID=yes';

		url_default+='&er_option='+jsonData['er_option'];
		url_default+='&er_site='+jsonData["er_site"];
		url_default+='&er_compType='+jsonData["er_compType"];
		url_default+='&er_timeline='+jsonData["er_timeline"];
		url_default+='&startdate='+jsonData["startdate"];
		url_default+='&enddate='+jsonData["enddate"];
		url_default+='&starthr='+jsonData["starthr"];
		url_default+='&endhr='+jsonData["endhr"];
		url_default+='&startmin='+jsonData["startmin"];
		url_default+='&endmin='+jsonData["endmin"];
		var er_component=jsonData["er_component"];
		for (var c in er_component)
		{
			url_default+='&er_component='+er_component[c];
		}
		var healthBandColor='#f4fef3';
		var slowBandColor='#fdfdf5';
		var stalledBandColor='#fdf6fe';
		var plotBorderColor='#dddddd';
		var gridLineColor='#eeeeee';
		var bandFontColor ='#969696';
		var tooltipBg = '#ffffff';
		var tooltipBorder = '#ffffff';
		var tdLineColor = '#ffffff';
		if(strSkin == 'Dark'){
			healthBandColor='#d5ebd3';
			slowBandColor='#ebebdb';
			stalledBandColor='#e7dce9';
			plotBorderColor='#666666';
			gridLineColor='#5c5c5c';
			bandFontColor ='#1a1a1a';
			tooltipBg = '#4e4e4e';
			tooltipBorder = '#1a1a1a';
			tdLineColor = '#404040';
		}
		var chartingOptions = {
			chart:{
				reflow: reflowVal,
				type : chartType,
				hasUserSize : false,
				spacing:[20,20,20,20],
				plotBorderWidth: 1,
				plotBorderColor :plotBorderColor,
				//spacingTop: spacing_top,
				//spacingLeft: spacing_left,
				//spacingRight: spacing[1],
				//spacingBottom: spacing[2],
				padding:0,
				tableFormatLegend:chartLegendDatas,
				//marginTop:margin_top,
				//marginBottom:margin_bottom,
				zoomType:'xy',
				events: {
					load: function(event) {
						if(LegendValues != undefined ){//event.target.pointer
							create_new_legend(event,true,container_Id);
						}
						else{
							$('.highcharts-legend-item rect').attr('height', '8').attr('y', '6');
							$('.highcharts-legend-item rect').attr('width', '8').attr('x', '10');
						}
					},
				/*	selection: selectPointsByDrag,
					selectedpoints: selectedPoints,
					click: unselectByClick*/
					selection: function(e) {
						var url=url_default;
						var mainContentText='<table width=100%><tbody>';	
						
						var points = this.getSelectedPoints();
						var healthyCount=0;
						var stalledCount=0;
						var errorCount=0;
						var slowCount=0;
						var chart1 =null;
						var startTime=0;
						var endTime=0;
						var responseStart=0;
						var responseEnd=0;
						var start_pointFound=0;
						Highcharts.each(this.series, function (series) {
							 Highcharts.each(series.points, function (point) {
								  if (point.x >= e.xAxis[0].min && point.x <= e.xAxis[0].max && point.y >= e.yAxis[0].min && point.y <= e.yAxis[0].max) 
								  {
										if(point.y>=e.yAxis[0].axis.dataMin && point.y<=e.yAxis[0].axis.dataMax )
										{
											if(point.series.name == 'Error')
												errorCount++;
											if(point.series.name == 'Healthy')
												healthyCount++;
											if(start_pointFound==0)
											{
												endTime = point.x;
												start_pointFound =1;
												startTime = endTime;
											}else
											{
												if(startTime>point.x)
													startTime = point.x;
											}
											if(responseStart ==0 || responseStart>point.y)
												responseStart = point.y;
											if(responseEnd==0 || responseEnd<point.y)
												responseEnd=point.y;
											if(endTime<point.x)
												endTime = point.x
										}

								  }
								  if (point.x >= e.xAxis[0].min && point.x <= e.xAxis[0].max && point.y >= e.yAxis[1].min && point.y <= e.yAxis[1].max) 
								  {
										if(point.y>=e.yAxis[1].axis.dataMin && point.y<=e.yAxis[1].axis.dataMax )
										{
											if(point.series.name == 'Slow/Stalled')
											  slowCount++;
											else if(point.series.name == 'Error')
												errorCount++;
											if(start_pointFound==0)
											{
												endTime = point.x;
												start_pointFound =1;
												startTime = endTime;
											}else
											{
												if(startTime>point.x)
													startTime = point.x;
											}
											if(responseStart ==0 || responseStart>point.y)
												responseStart = point.y;
											if(responseEnd==0 || responseEnd<point.y)
												responseEnd=point.y;
											if(endTime<point.x)
												endTime = point.x

										}
								  }
								  if (point.x >= e.xAxis[0].min && point.x <= e.xAxis[0].max && point.y >= e.yAxis[2].min && point.y <= e.yAxis[2].max) 
								  {
									  if(point.y>=e.yAxis[2].axis.dataMin && point.y<=e.yAxis[2].axis.dataMax )
									  {
											console.log(point.x);
										  if(point.series.name == 'Slow/Stalled')
											  stalledCount++;
										  else if(point.series.name == 'Error')
											  errorCount++;
										  if(start_pointFound==0)
										   {
											  endTime = point.x;
											  start_pointFound =1;
											  startTime = endTime;
											}else
											{
												if(startTime>point.x)
													startTime = point.x;
											}
											if(responseStart ==0 || responseStart>point.y)
												responseStart = point.y;
											if(responseEnd==0 || responseEnd<point.y)
												responseEnd=point.y;
											if(endTime<point.x)
												endTime = point.x
										console.log(point.y,endTime);

									  }
								  }
							 });
						});
						points = this.getSelectedPoints();
						console.log(startTime,responseStart);
						console.log(endTime,responseEnd);
						url=url+"&er_userstartTime="+startTime+"&er_userendTime="+endTime+"&";
						url+="er_durationStart="+(responseStart)+"&er_durationEnd="+(responseEnd)+"&checkedFilterData="+appConstants.appObj.getController(appConstants.appController).getCheckedInfo();
						//mainContentText+='<div id="container" style="min-width: 200px; height: 200px; margin: 0 auto"></div><tr><td style="font-size: 12px;color:black;white-space:nowrap;">Healthy</td><td>&nbsp;:</td>'
						mainContentText+='<tr><td style="font-weight:500;width:115px;padding:4px 5px 4px 0px;"><div style="width:2px;height:9px;background:#69c7b3;float:left;margin:2px 5px 0px 0px"></div><div style="float:left">Healthy</div> </td>'
						+ '<td width=30% style="padding:4px 5px 4px 5px;">:&nbsp;'+healthyCount+'</td>'
						+'<td  width=10% style="padding:4px 0px 4px 5px;"><a href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'eGPipeeGRequest_ProcessingeGHasheGHealthy&er_experience=healthy'+'\',\'Detail\');"><div class=\'tootipDdIcon mouse\'></div></a></td></tr>';

						mainContentText+='<tr><td style="font-weight:500;width:115px;padding:4px 5px 4px 0px;"><div style="width:2px;height:9px;background:#f49242;float:left;margin:2px 5px 0px 0px"></div><div style="float:left">Slow</div> </td>'
						+ '<td width=30% style="padding:4px 5px 4px 5px;">:&nbsp;'+slowCount+'</td>'
						+'<td  width=10% style="padding:4px 0px 4px 5px;"><a href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'eGPipeeGRequest_ProcessingeGHasheGSlow&er_experience=slow'+'\',\'Detail\');"><div class=\'tootipDdIcon mouse\'></div></a></td></tr>';
;
						mainContentText+='<tr><td style="font-weight:500;width:115px;padding:4px 5px 4px 0px;"><div style="width:2px;height:9px;background:#f49242;float:left;margin:2px 5px 0px 0px"></div><div style="float:left">Stalled</div></td>'
						+ '<td width=30% style="padding:4px 5px 4px 5px;">:&nbsp;'+stalledCount+'</td>'
						+'<td  width=10% style="padding:4px 0px 4px 5px;"><a href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'eGPipeeGRequest_ProcessingeGHasheGStalled&er_experience=stalled'+'\',\'Detail\');"><div class=\'tootipDdIcon mouse\'></div></a></td></tr>';

						mainContentText+='<tr><td style="font-weight:500;width:115px;padding:4px 5px 4px 0px;"><div style="width:2px;height:9px;background:#ff0059;float:left;margin:2px 5px 0px 0px"></div><div style="float:left">Error</div></td>'
						+ '<td width=30% style="padding:4px 5px 4px 5px;">:&nbsp;'+errorCount+'</td>'
						+'<td  width=10% style="padding:4px 0px 4px 5px;"><a href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'eGPipeeGRequest_ProcessingeGHasheGError&er_experience=error'+'\',\'Detail\');"><div class="tootipDdIcon mouse"></div></a></td></tr>';
						
						mainContentText+='</tbody></table>';
						hs.allowMultipleInstances = false;
						/*hs.Expander.prototype.onFocus =function(){
							drawChart_1(healthyCount,slowCount,stalledCount,errorCount);
						}*/
						var filterStr =null;
						if(stalledCount>0)
						{
							filterStr ='Stalled';
						}
						if(healthyCount>0)
						{
							if(filterStr ==null)
								filterStr ='Healthy';
							else
								filterStr =filterStr+',Healthy';
						}
						if(errorCount>0)
						{
							if(filterStr ==null)
								filterStr ='Error';
							else
								filterStr =filterStr+',Error';
						}
						if(slowCount>0)
						{
							if(filterStr ==null)
								filterStr ='Slow';
							else
								filterStr =filterStr+',Slow';
						}
						
						hs.htmlExpand(null, {
							pageOrigin: {
								x: e.originalEvent.pageX || e.originalEvent.clientX,
								y: e.originalEvent.pageY || e.originalEvent.clientY
							},
							//headingText: '<span style="color:#2a292a">Total Request ('+(stalledCount+healthyCount+errorCount+slowCount)+')</span>',
							headingText: '<div style="font-weight:600;font-size:13px">Selected Requests<a style="color:#fff;text-decoration:underline;cursor: pointer;margin-left:10px" href="javascript:void(0);"	onClick="javascript:parent.printWindowFnWithHeaderBuilder(\''+url+'RequesteGundereGProcessingeGHasheG'+filterStr+'&er_experience='+filterStr+'\');">'+(stalledCount+healthyCount+errorCount+slowCount)+'</a></div>',							
							maincontentText:mainContentText,							
							width: 210,
						});
						 return false; // Don't zoom
					},
				}
			},
			tooltip: {
					xDateFormat:toolTipFmt,
					valueDecimals: 4,
					backgroundColor: tooltipBg,
					borderRadius:5,
					borderWidth:0,
				//	padding:0,
				//	class="highslide-html" style="padding:10px"
				//	shadow:false,
					borderColor:tooltipBorder,
					useHTML	: true,
					formatter: function() {
						var bodyContent = '<div ><table border="0px" cellspacing="0px" cellpadding="0px" style="background-color:'+tooltipBg+'" class="f12-normal"><tbody><tr><td align="center" style="white-space:nowrap;padding:2px 2px 0px 2px" class="f12-normal">'+this.y+' ms</td></tr>';
						bodyContent+='<tr><td style="white-space:nowrap;" class="f12-normal">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</td></tr></tbody></table></div>';
						return bodyContent;
					},
				},
			yAxis: [
					{
					min: 0,
					minRange : 0,
					maxRange : HealthPlotBandsValue,
					max : HealthPlotBandsValue,
					tickPositions: [0,HealthPlotBandsValue],
					//tickLength: 10,
			        tickWidth: 0,
					endOnTick: false,
					alignTicks: true,
					//gridLineWidth: YaixLineWidth,
					gridLineWidth: 1,
					gridLineColor: gridLineColor,
					lineWidth: 0,
					tickInterval:50,
					 offset: false,
					 height: '35%',
		                top: '65%',
					labels: {
						x:-4,
						y:6,
						//enabled: false,
						 style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
							formatter: function () {
								var label = this.axis.defaultLabelFormatter.call(this);
									return Highcharts.numberFormat(this.value, 0);
								return label;
								}
						},
					title: {
						useHTML:true,
						text: '<div style="text-align:center;width:110px;height:25px;padding:5px;background-color:#f4fef3"><span style="fontFamily: Roboto;fontSize: 11px;color : #969696;font-weight: 400;font-style:normal"> Healthy </span></div>',
						enabled: false,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						},
					plotBands: [{ 
							from:0,
							to:HealthPlotBandsValue,
							borderWidth:0,
							color: healthBandColor,
						},
						]

				},
			    {
					min : HealthPlotBandsValue,
					minRange : HealthPlotBandsValue,
					maxRange : SlowPlotBandsValue,
					max : SlowPlotBandsValue,
					tickPositions: [HealthPlotBandsValue,SlowPlotBandsValue],
					tickLength: 10,
			        tickWidth:0,
					startOnTick: false,
					//endOnTick: false,
					alignTicks: true,
					tickInterval:1,
					gridLineWidth: 0,
					gridLineColor: gridLineColor,
					lineWidth:0,
					 offset: false,
					 height: '35%',
		                top: '30%',
					labels: {
						x:-4,
						y:5,
						//enabled: false,
						 style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
							formatter: function () {
								var label = this.axis.defaultLabelFormatter.call(this);
									return Highcharts.numberFormat(this.value, 0);
								return label;
								}
						},
					title: {
						useHTML:true,
						text: '<div style="text-align:center;width:110px;height:25px;padding:5px;background-color:#fdfdf5"><span style="fontFamily: Roboto;fontSize: 11px;color : #969696;font-weight: 400;font-style:normal"> Slow </span></div>',
						enabled: false,
						rotation:270,
						//x:10,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						},
						plotBands: [
						{ 
							from: HealthPlotBandsValue,
							to: SlowPlotBandsValue,
							borderWidth:0,
							color: slowBandColor,
						}
						],
					opposite: false,
					//visible:false,
				},{
					min : SlowPlotBandsValue,
					minRange : SlowPlotBandsValue,
					maxRange : StalledPlotBandsValue,
					tickPositions: [SlowPlotBandsValue,StalledPlotBandsValue],
					tickLength: 0,
			        tickWidth: 10,
					alignTicks:true,
					startOnTick: false,
					alignTicks: false,
					gridLineWidth: 1,//YaixLineWidth,
					gridLineColor:gridLineColor,
					lineWidth: 0,
					 offset: false,
					 height: '30%',
		                top: '0%',
					labels: {
						//enabled: false,
						x:-4,
						y:5,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
							formatter: function () {
								var label = this.axis.defaultLabelFormatter.call(this);
									return Highcharts.numberFormat(this.value, 0);
								return label;
								}
						},
					title: {
						useHTML:true,
						text: '<div style="text-align:center;width:80px;height:25px;padding:5px;background-color:#fdf6fe"><span style="fontFamily: Roboto;fontSize: 11px;color : #969696;font-weight: 400;font-style:normal"> Stalled </span></div>',
						enabled: false,
						rotation:270,
						x:10,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						},
						plotBands: [
						{ 
							from:SlowPlotBandsValue,
							to:StalledPlotBandsValue,	
							borderWidth:0,
							color: stalledBandColor,
						}
						],
					//opposite: true,
					//visible:false,
				},
				{
					min : SlowPlotBandsValue,
					minRange : SlowPlotBandsValue,
					maxRange : StalledPlotBandsValue,
					tickPositions: [SlowPlotBandsValue,StalledPlotBandsValue],
					tickLength: 10,
			        tickWidth: 0,
					startOnTick: false,
					alignTicks: true,
					gridLineWidth: 0,
					gridLineColor:gridLineColor,
					lineWidth: 0,
					 offset: 70,
					labels: {
						enabled: false,
						 style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
							formatter: function () {
								var label = this.axis.defaultLabelFormatter.call(this);
									return Highcharts.numberFormat(this.value, 0);
								return label;
								}
						},
					title: {
						text: 'Response Time (ms)',
						enabled: true,
						rotation:270,
						x:-5,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						}
				},
				{
					min : SlowPlotBandsValue,
					minRange : SlowPlotBandsValue,
					maxRange : StalledPlotBandsValue,
					tickPositions: [SlowPlotBandsValue,StalledPlotBandsValue],
					startOnTick: true,
					endOnTick: true,
					alignTicks: true,
					//gridLineWidth: YaixLineWidth,
					gridLineWidth: 0,
					gridLineColor:gridLineColor,
					lineWidth: 0,
					labels: {
						enabled: false,
						},
					title: {
						useHTML:true,
						//text: '<div id="legend_right" style="border:0px solid red;fontFamily: Roboto;fontSize: 11px;color : #969696;font-weight: 400;font-style:normal;width:'+($(chartContainerWidth).height())+'px;display:flex"><div style="text-align:center;width:37%;height:22px;padding:2px;background-color:#f4fef3;font-size:11px;margin-right:2px">Healthy</div><div style="text-align:center;width:34%;height:25px;padding:5px;background-color:#fdfdf5;font-size:11px;margin-right:2px">Slow</div><div style="text-align:center;width:34%;height:25px;padding:5px;background-color:#fdf6fe;font-size:11px;margin-right:2px">Stalled</div>',
						text: '<table id="legend_right" width="'+($(chartContainerWidth).height()+5)+'" height="100%" style="border:1px solid '+tdLineColor+';fontFamily: Roboto;fontSize: 11px;font-weight: 400;font-style:normal;border-collapse: collapse;"><col width="35%"><col width="35%"><col width="30%"><tr><td style="border:1px solid '+tdLineColor+';"><div style="text-align:center;height:25px;padding:5px;background-color:'+healthBandColor+';font-size:11px;margin-right:0px;color:'+bandFontColor+'!important">Healthy</div></td><td style="border:1px solid '+tdLineColor+';"><div style="text-align:center;height:25px;padding:5px;background-color:'+slowBandColor+';font-size:11px;margin-right:0px;color:'+bandFontColor+'!important">Slow</div></td><td style="border:1px solid '+tdLineColor+';"><div style="text-align:center;height:25px;padding:5px;background-color:'+stalledBandColor+';font-size:11px;margin-right:0px;color:'+bandFontColor+'!important">Stalled</div></td></tr></table>',
						enabled: true,
						rotation:270,
						margin:10,
						x:0,
						y:0,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						},
					opposite: true,
					//visible:false,
				}
				],
				xAxis: {
					type : xType,
					gridLineWidth: 0,
					gridLineColor: '#e5e5e5',
					lineWidth:0,
					tickWidth:0,
					alignTicks:true,
					offset: false,
					minPadding:0,
					maxPadding:0,
					tickInterval:tickintevalVal,//900000
					labels: {
						 style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
							x:-1,
							//y:yVal,
							formatter: function() {
								if(xType == null){
									var val = Highcharts.numberFormat (this.value,4, '.','');
									val = (parseFloat(val));
									return  val;
								}else
									return  Highcharts.dateFormat(timeline_out_format, this.value);
						}
						},
					title: {
						text: xLabel,
						enabled:xtitleEnable,
						style: {
							fontFamily: 'Roboto',
							fontSize: '11px',
							color : '#969696',
						    'font-weight': 400,
						    'font-style': 'normal'
							},
						},
					dateTimeLabelFormats: {
						minute: timeline_out_format,
						hour: timeline_out_format,
						day:timeline_out_format,
						month:timeline_out_format,
						year:timeline_out_format
					}
				},
			plotOptions: {
					series: {
						connectNulls : false,
						shadow:false,
						fillOpacity: 0.5,
						lineWidth : 0,
						marker: {
							enabled: true,
						},
						
						cursor: 'pointer',
						turboThreshold:10000000000,
						stacking: stacked,
						//pointStart:startTime,
						//pointInterval: 60*1000,
						states: {
							 hover: {
								enabled: true,
								lineWidth: line_width,
								lineWidthPlus: 0
							}
						},
				events: {
						legendItemClick: function(event) {
								if (!this.visible)
									return true;
								var seriesIndex = this.index;
								var seriesName = this.name;
								var series = this.chart.series;
								$.each(series, function (i,seriesItem) {
									if (seriesItem.index != seriesIndex && seriesName!=seriesItem.name)
									{
										seriesItem.visible ? seriesItem.hide() : seriesItem.show();
									}
										
								});
								return false;
							},
							mouseOver: function(e) {
								//alert('mouseOver==>>>')
							},
							click: function(e) {
									//parent.printWindowFnWithHeaderBuilder('../monitor/eGBTMd3Topology.jsp?isReporterRequest=yes&EG_GUID='+e.point.EG_GUID+'&fromNodeOrder=1&er_RmDispName=Business%20Transaction%20Monitoring%20-%20Scatter%20Chart');
								
									if(e.point.EG_GUID!=null )
										loadPopup('../monitor/eGBTMd3Topology.jsp?isReporterRequest=yes&EG_GUID='+e.point.EG_GUID+'&fromNodeOrder=1&er_RmDispName=Business%20Transaction%20Monitoring%20-%20Scatter%20Chart');
							}
						},
						
						
					},
					scatter: {
						tooltip: tooltipObj,
					},
				},
			legend: {
				enabled: showLegends,
					verticalAlign: valgn, 
					//align: 'center',
					//width:legendWidth,
					//align:LegendPosition, 
					y:yRange,
					//x:xRange,
					//itemMarginBottom: 6,
					//itemDistance:5,
					itemStyle: {
					   textAlign: 'top',
						fontFamily: 'Roboto',
						fontSize: '11px',
						color : '#969696',
					    'font-weight': 400,
					    'font-style': 'normal'
						},
				   	useHTML: enableHtmlforLegend,
					maxHeight :maxLegendHeight,
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
							retrunvar= strval;
						}
						return retrunvar;
					},
					
				}
			};
		
		var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/noMeasureImg_new.png" /></td></tr></table>';
		var prhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/prediction_warning.png" /></td></tr></table>';

		//Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		var chartData=[];
		var chartContObj=document.getElementById(container_Id);
		if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
		{
			drawChart = false;
			if(chartContObj!=null)
			{	// for prediction report if prediction goes negavtive,show prediction_warning.png
				if(jsonData['PredictionStatus'] != 'undefined' && jsonData['PredictionStatus'] != undefined && jsonData['PredictionStatus'] == 'negative')
				{
				chartContObj.innerHTML=prhtml;
				}
				else
				{
				chartContObj.innerHTML=myhtml;
				}				
				$('#showLegend-inputEl').click(function () {
					var leg_window=document.getElementById(container_Id+'_legend');
					if(leg_window != null && leg_window != undefined){
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						showLegendChangeEvent(container_Id,isShowLegendEnable);
					}
				});
			}
		}else{
			this.highchart.series=jsonData['DataSet'];
			this.highchart.chart.renderTo = container_Id;
		}

	},

	drawChart: function() {
		if(drawChart)
		{
			Highcharts.setOptions({
				lang: {
						thousandsSep: ''
					}
			});
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset: timezoneOffsetValue
				}
			});

			//this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
			new Highcharts.Chart(this.highchart,function(chart){
				$('#showLegend-inputEl').click(function () {
					var leg_window=document.getElementById(container_Id+'_legend');
					var leg_panel=Ext.getCmp(container_Id+'_legendPanel');
					if((leg_window != null && leg_window != undefined) || (leg_panel != null && leg_panel != undefined)){
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						showLegendChangeEvent(container_Id,isShowLegendEnable);
					}
					else if(chart.options.legend.useHTML){
						var isShowLegendEnable=Ext.getCmp("showLegend").getValue();
						create_new_legend(chart,isShowLegendEnable,container_Id) 
					}
					else
						chart.legendToggle(); 
	          });
	        });
		}
	}

};
return ErHighStockChart;
}
var chartOptionTemp={
			chart: {
				plotBackgroundColor: null,
				plotBorderWidth: null,
				plotShadow: false,
				type: 'pie',
				 preserveContent: false
			},
			title:{
				text:''
			},
			tooltip: {
				pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
			},
			plotOptions: {
				pie: {
					innerSize: 40,
					allowPointSelect: true,
					cursor: 'pointer',
					dataLabels: {
						enabled: true,
						format: '<b>{point.name}</b>: {point.percentage:.1f} %',
						style: {
							color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
						}
					}
				}
			},
			series: [],
		};
function drawChart_1(healthyCount,slowcount,stalledCount,errorCount)
{
	
	var ss = {series: [{
				data: [{
					name: 'Healthy',
					y: healthyCount,
					color:'#71cab4'
				   
				}, {
					name: 'Slow',
					y: slowcount,
					color:'#ee9f50'
				}, {
					name: 'Stalled',
					y: stalledCount,
					color:'#ff0059'
				},
				 {
					name: 'Error',
					y: errorCount,
					color:'#BF0B23'
				}]
			}]
	}
	ddd= jQuery.extend(true, chartOptionTemp, ss);
	ddd.chart.renderTo=document.getElementById('container');
	new Highcharts.Chart(ddd);
}


function showLegendChangeEvent(cont_Id,val) {
	var legPnl=Ext.getCmp(cont_Id+'_legendPanel');
	if(legPnl != undefined && legPnl != null){
		if(val){
			legPnl.show();
		}
		else{
			legPnl.hide();
			var grphPnl=Ext.getCmp(cont_Id+'_GraphPanel');
			if(grphPnl != undefined && grphPnl.isHidden()){
				grphPnl.show();
				legPnl.setHeight(53);
				var leg_close=document.getElementById(cont_Id+'_legendClose');
				var leg_xpand=document.getElementById(cont_Id+'_legendExpand');
				leg_close.className=leg_close.className.replace('showDiv', 'hideDiv');
				leg_xpand.className=leg_xpand.className.replace('hideDiv', 'showDiv');
			}
		}
	}
	else{
	if(val){
		var lg_div=document.getElementById('commonLeg_'+cont_Id);
		if(lg_div != null && lg_div != undefined){
			lg_div.className=lg_div.className.replace('hideDiv', 'showDiv');
			lg_div.style.height=60;
		}

		var leg_div=document.getElementById(cont_Id+'_legend');
		var leg_close=document.getElementById(cont_Id+'_legendClose');
		var leg_xpand=document.getElementById(cont_Id+'_legendExpand');
		leg_div.style.height='55px';
		leg_div.style.paddingTop='0px';
		leg_div.style.overflow='hidden';
		if(leg_xpand != null && leg_xpand != undefined)
			leg_xpand.className=leg_xpand.className.replace('hideDiv', 'showDiv');
		if(leg_close != null && leg_close != undefined)
			leg_close.className=leg_close.className.replace('showDiv', 'hideDiv');
	}
	else
	{
	//to hide legend when disable showlegend flag
		var lg_div=document.getElementById('commonLeg_'+cont_Id);
		if(lg_div != null && lg_div != undefined)
			lg_div.className=lg_div.className.replace('showDiv', 'hideDiv');
	//when disable showlegend flag, there is a possibility of user expanding maximize icon in UI and the following code is added to handle that sceneario
		var grp_div=document.getElementById(cont_Id);
		if(grp_div != null && grp_div != undefined)
			grp_div.className=grp_div.className.replace('hideDiv', 'showDiv');
	}
}
}
function create_new_legend(evnt,val,cont_Id) {
	var leg_Container=Ext.getCmp('legend_'+cont_Id);
	var leg_div=document.getElementById('legend_'+cont_Id);
	var leg_window=document.getElementById(cont_Id+'_legend');
	var leg_panel=Ext.getCmp(cont_Id+'_legendPanel');
	var isNewDesign=false;
	if((leg_window != null && leg_window != undefined) || (leg_panel != null && leg_panel != undefined))
		isNewDesign=true;
	if(val){
		var legDatas=evnt;
		if(legDatas.target != undefined)
			legDatas=legDatas.target;
		var chrtWidth=legDatas.containerWidth-50;
		var rowColr='#616161';
		if(strSkin != undefined && strSkin == 'Light' )
			rowColr='#DBDBDB';
		var tmpObj=legDatas.options.chart.tableFormatLegend;
		var html='';
		if(tmpObj != undefined && tmpObj.length > 0){
			var needtoShowlegTitle=false;
			var txtAlgn='left';
			if(tmpObj.length > 5 )
				needtoShowlegTitle=true;
			else if(tmpObj[0] != undefined && tmpObj[0] != 'DATA')
				needtoShowlegTitle=true;
			else
				txtAlgn='center';
			if(isNewDesign)
				html='<div class="newTable" style="padding: 0px 0px 0px 10px;">';
			else
				html='<div class="newTable" style="padding: 0px 0px 0px 20px;">';
			html+='<table cellpadding="0px" cellspacing="0px" style="table-layout:fixed;width:100%;">';
			var tdWidth='33%';
			if(needtoShowlegTitle){
				tdWidth='17%';
				html+='<col width="49%"/>';
			}
			html+='<col width="'+tdWidth+'"/><col width="'+tdWidth+'"/><col width="'+tdWidth+'"/><thead><tr style="background-color:'+rowColr+';font-size:11px;font-family:Arial;" height="22px">';
			if(needtoShowlegTitle ){
				html+='<th>&nbsp;</th>';
			}
			html+='<th style="text-align:'+txtAlgn+';">AVG</th><th style="text-align:'+txtAlgn+';" >MAX</th><th  style="text-align:'+txtAlgn+';">MIN';
			if(isNewDesign && needtoShowlegTitle && tmpObj.length > 5){
				html+='<div id="'+cont_Id+'_legendClose"  class="iconCloseCircle hideDiv" style="float: right;cursor:pointer;" onclick="javascript:changeLegendWindow('+cont_Id+');"></div>';
				html+='<div id="'+cont_Id+'_legendExpand" class="iconDotsCircle showDiv" style="float: right;cursor:pointer;" onclick="javascript:changeLegendWindow('+cont_Id+');"></div>';
			}
			html+='</th></tr></thead><tbody>';
			for (var i = 0; i < tmpObj.length; i=i+5) {
				html+='<tr>';
				if(needtoShowlegTitle )
					html+='<td style="padding-left:9px;" align="'+txtAlgn+'"><div><div style="float:left;margin-top:2px;height:100%;vertical-align:top"><svg height="10" width="10"><circle cx="4" cy="6" r="4" fill="'+tmpObj[i+1]+'" stoke-width="0" /></svg></div><div style="margin-left:16px;line-height:1.5em;word-break:break-all">'+tmpObj[i]+'</div></div></td>';
				html+='<td align="'+txtAlgn+'">'+tmpObj[i+2]+'</td>';
				html+='<td align="'+txtAlgn+'">'+tmpObj[i+3]+'</td>';
				html+='<td align="'+txtAlgn+'">'+tmpObj[i+4]+'</td>';
				html+='</tr>';
			}
			html+='</tbody></table></div>'
		}
		if(leg_Container != undefined){
			if(tmpObj.length > 0){
				var cnn=((tmpObj.length/5)*27)+35;
				leg_Container.setHeight(cnn);
			}
			leg_Container.update(html);
			$('.highcharts-legend').html('');
		}else if(leg_div != null && leg_div != undefined){
			if(tmpObj.length > 0){
				var cnn=((tmpObj.length/5)*27)+35;
				leg_div.style.height = cnn+'px';
			}
			leg_div.innerHTML=html;
			$('.highcharts-legend').html('')
		}else if(leg_panel != null && leg_panel != undefined){
			leg_panel.update(html);
			$('.highcharts-legend').html('')
		}else if(leg_window != null && leg_window != undefined){
			leg_window.innerHTML=html;
			$('.highcharts-legend').html('')
		}else{
			$('.highcharts-legend').html(html);
		}
	}
	else
	{
		$('.highcharts-legend').html('');
		if(leg_Container != undefined){
			leg_Container.setHeight(5);
			leg_Container.update('');
		}else if(leg_div != null && leg_div != undefined){
			leg_div.style.height = '5px';
			leg_div.innerHTML='';
		}
	}
}
// currentDate format in tooltip of HighStockCharts
function tooltipDateFormate(currentDateFormat )
{
	var cdf = currentDateFormat;
	var toolTipFmt = "";
	//Tooltip date format using current date format of Manager
	if(cdf != 'null' && cdf != 'undefined' && cdf !='' && cdf != undefined)
	{
		cdf = cdf.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(cdf.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(cdf.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(cdf.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = cdf.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if (value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';

				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				arrValue[v]=output;
			}
		}
		if (arrValue !=null && arrValue.length >0)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				toolTipFmt += arrValue[v]+symbol;
			}
			if(toolTipFmt!=null && endsWith(toolTipFmt,symbol) && !(cdf!=null && endsWith(cdf,symbol)))
				toolTipFmt = toolTipFmt.substring(0,toolTipFmt.lastIndexOf(symbol));
			toolTipFmt = toolTipFmt+" %H:%M:%S";
		}
	}
	return toolTipFmt;
}
function getTimeLineOutputFormat(s_time)
{
	var return_s_time_fout ='';
	if(s_time != 'null' && s_time !='')
	{
		s_time = s_time.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(s_time.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(s_time.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(s_time.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = s_time.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value.lastIndexOf(' ')>-1)
				{
					value = value.substring(0,value.lastIndexOf(' '));					
				}
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if(value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';
				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				if (!(value == 'hh:mm' || value == 'hh:mm:ss' ))
				{
					arrValue[v]=output;
				}

			}
		}
		if (arrValue !=null && arrValue.length >1)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				return_s_time_fout += arrValue[v]+symbol;
			}
			if(return_s_time_fout!=null && endsWith(return_s_time_fout,symbol))
				return_s_time_fout = return_s_time_fout.substring(0,return_s_time_fout.lastIndexOf(symbol));
			return_s_time_fout = return_s_time_fout+", %H:%M";
		}else
			return_s_time_fout='%H:%M';
	}
	return return_s_time_fout;
}

function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}

 (function (H) {
          H.Chart.prototype.reflow = function () {
				var task = new Ext.util.DelayedTask(function(){
					 var clientWidth=renderTo.clientWidth; 
				 var clientHeight=renderTo.clientHeight; 
				 if(chart.chartHeight>renderTo.clientHeight)
						clientHeight=chart.chartHeight;
				 console.log(clientHeight,clientWidth,renderTo.clientHeight);
					 chart.setSize(clientWidth,  renderTo.clientHeight, false);
  				});

				var chart = this,
				renderTo = chart.renderTo;
 				Ext.EventManager.onWindowResize(function () {
					var initialClientWidth=renderTo.clientWidth; 
					if (initialClientWidth!=0)
					task.delay(100);
				});
      };
    }(Highcharts));


// Plugin for displaying value information in the legend
/*(function (H) {
	H.Chart.prototype.initReflow = function () {
		var chart = this,
			optionsChart = chart.options.chart,
			renderTo = chart.renderTo,
			reflowTimeout;

		function reflow(e) {
			var width = optionsChart.width || HighchartsAdapter.adapterRun(renderTo, 'width'),
				height = optionsChart.height || HighchartsAdapter.adapterRun(renderTo, 'height'),
				target = e ? e.target : window; // #805 - MooTools doesn't supply e
		   // Width and height checks for display:none. Target is doc in IE8 and Opera,
			// win in Firefox, Chrome and IE9.
			if (!chart.hasUserSize && width && height && (target === window || target === document)) {

				if($(window).width()>1000)
					width = width+100;
				else
					width = width-150;
				if (width !== chart.containerWidth || height !== chart.containerHeight) {
					clearTimeout(reflowTimeout);
					chart.reflowTimeout = reflowTimeout = setTimeout(function () {
						if (chart.container) { // It may have been destroyed in the meantime (#1257)
							chart.setSize(width, height, false);
							chart.hasUserSize = null;
						}
					}, 100);
				}
				chart.containerWidth = width;
				chart.containerHeight = height;
			}
		}
		chart.reflow = reflow;
		H.addEvent(window, 'resize', reflow);
		H.addEvent(chart, 'destroy', function () {
			H.removeEvent(window, 'resize', reflow);
		});
	};
}(Highcharts));*/

/**
     * Highcharts plugin for setting a lower opacity for other series than the one that is hovered
     * in the legend
     */
   (function (Highcharts) {
        var each = Highcharts.each;
        
        Highcharts.wrap(Highcharts.Legend.prototype, 'renderItem', function (proceed, item) {
            
            
            proceed.call(this, item);
            
            var series = this.chart.series,
                element = item.legendGroup.element;
            
            element.onmouseover = function () {
               each(series, function (seriesItem) {
                    if (seriesItem !== item && seriesItem.name!== item.name) {
                        each(['group', 'markerGroup'], function (group) {
                            seriesItem[group].attr('opacity', 0.01);
                        });
                    }
                });
            }
            element.onmouseout = function () {
               each(series, function (seriesItem) {
                    if (seriesItem !== item && seriesItem.name!== item.name) {
                        each(['group', 'markerGroup'], function (group) {
                            seriesItem[group].attr('opacity', 1);
                        });
                    }
                });
            }           
            
        });
    }(Highcharts));

(function(b,a){
	if(!b){return}
	var c=b.Chart.prototype,d=b.Legend.prototype;
	b.extend(c,{
		legendSetVisibility:function(h){
			var i=this;
			var k=i.legend,e,g,j;
			var m=i.options.legend,f,l;
			if(m.enabled==h)
				{return}
				m.enabled=h;
			if(!h){
				d.destroy.call(k);
				e=k.allItems;
				if(e){
					for(g=0,j=e.length;g<j;++g)
						{e[g].legendItem=a}
					}
					k.group={}
				}
				c.render.call(i);
				if(!m.floating){
					f=i.scroller;
					if(f&&f.render){
						l=i.xAxis[0].getExtremes();
						f.render(l.min,l.max)
					}
				}
			$('.highcharts-legend-item rect').attr('height', '6').attr('y', '7');
			$('.highcharts-legend-item rect').attr('width', '6').attr('x', '10');
		},
		legendHide:function(){

			this.legendSetVisibility(false)
		},legendShow:function(){

			this.legendSetVisibility(true)
		},
		legendToggle:function(){
			this.legendSetVisibility(this.options.legend.enabled^true);
		}
	})
	
}(Highcharts));












