Ext.define('OperationAlarmsHistory.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController('Main').doFilter();
	}),
	refs:[
		{selector:'main',ref:'main'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'ReporterSettings',ref:'ReporterSettings'}
	],

	init:function(){
		this.control({
			
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
 			},
			'operationsalarmshistoryconfig':{
				'afterrender':this.afterSettingsrender
 			},
			'newUtilities #saveTool button':{
					'click': this.saveReportAsPDF
			},			
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.sendToschedule
			},
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},			
			'operationalarmhistory combo[name="eventfor"]':{
				'select': this.mainFormEvent
			},
			'operationalarmhistory combo[name="event_select"]':{
				'select': this.mainFormEvent
			},
			'operationalarmhistory combo[name="includeSubZone"]':{
				'select': this.mainFormEvent
			},
			'operationalarmhistory combo[name="compTypeList"]':{
				'select': this.mainFormEvent
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},		
			'egcomponent trigger[id="compsearch"]':{
				'change': this.filterMultiselect
			},		
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},			
			'operationsalarmshistoryconfig combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'operationsalarmshistoryconfig button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'operationsalarmshistoryconfig button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},			
			'operationsalarmshistoryconfig combo[name="ack_glduration"]':{
				'change': this.changeAckDuration
			},
			'operationsalarmshistoryconfig combo[name="alarmNature"]':{
				'select': this.onChangeAlarmNature
			},
			'alarmdetailsgrid textfield[name="livesearch"]':{
					'change':this.typewatch
				}
		});
	},
	goTo: function (btn) {
		
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicjsonData.hiddenfields;
		//var from_schedule = hiddenFields["fromScheduleModify"];
		var from_schedule = appConstants.frmSchModify;
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.sendToschedule();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite();
		}
    },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('compNameList'),appConstants.publicjsonData['componentsCombo']);
		 obj.toggleTriggger();
    },
	showLoadIcon:function(){
		appConstants.initLdgMask.show();
	},
	typewatch:function(field, event){
  		 this.searchTask.delay(1000);
		 field.toggleTriggger();
	},
	doFilter:function()
	{
 		var gridobjsearch = Ext.getCmp('alarmDetailsGrid');
		var field=Ext.getCmp('livesearch');
		if(field!=undefined){
		var str=Ext.String.trim(field.value);
		if(str.length > 0 && (str != '' || str != null))
		{
			gridobjsearch.getStore().clearFilter(); 
			var regex = RegExp(field.value, 'i');
			gridobjsearch.getStore().filter(new Ext.util.Filter({
				caseSensitive:true,
				filterFn: function (object) {
					var match = false;
					Ext.Object.each(object.data, function (property, value) {
						match = match || regex.test(String(value));
					});
					
					return match;
				  }
			}));
		}
		else{
			gridobjsearch.getStore().clearFilter(); 
		}
		field.focus();
		Ext.getCmp('id-pagingtoobar').doRefresh()
		}
	},
	toggleForm:function(obj)
	{
 		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	sendToschedule:function(){
		var eventFor=Ext.getCmp("eventfor").getValue();
		var compType=Ext.getCmp("compTypeList");
		if ( eventFor != 'Component')
		{
			var evnselect=Ext.getCmp("event_select");
			if(evnselect.getValue() == '-1' || evnselect.getValue() == 'notapplicable')
			{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: evnselect.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(compType.getValue() == 'notapplicable')
		{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: compType.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;		
		}
		if(Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}
		this.updateQueryString();
		var target="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString+"&isSubmit=true&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.menuForVM=='true')
		{
			target+='&menuForVM=true';
		}
		if (appConstants.formButtonId=='save')
		{
				//	document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
						});
		}
		else
		{
			if (appConstants.menuForVM=='true')
			{
				scheduleWindowFn(target);
			}
			else
			{
				parent.scheduleWindowFn(target);
			}
		}
	},
	saveFavorite:function(){
		var eventFor=Ext.getCmp("eventfor").getValue();
		var compType=Ext.getCmp("compTypeList");
		var favorite_id = "";
		if ( eventFor != 'Component')
		{
			var evnselect=Ext.getCmp("event_select");
			if(evnselect.getValue() == '-1' || evnselect.getValue() == 'notapplicable')
			{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: evnselect.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(compType.getValue() == 'notapplicable')
		{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: compType.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}
		/*if(Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}*/
		this.updateQueryString();
		if(appConstants.publicjsonData.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
		}
		var target="../servlet/com.eg.ErFavoriteC?"+appConstants.queryString+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.menuForVM=='true')
		{
			target+='&menuForVM=true';
		}
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
		
			target+='&showWindow=no'+"&FavoriteId="+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
		
			var formSave = Ext.create('Ext.form.Panel');
								formSave.submit({
									url:urlNw,
									params:queryString,
									standardSubmit: true,
									method: 'POST'
								});
		}
		else
		{
			if (appConstants.menuForVM=='true')
			{ 
				favouriteWindowFn(target);
			}
			else
			{
				 parent.favouriteWindowFn(target); 
			} 
		}
	},
	saveReportAsPDF:function(){
		if(customPaging)
		{
			this.exportDataAlert();
			return;
		}
		var saveQString=appConstants.publicjsonData.saveQstring;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString+"&option=Graph&printGraph=yes&savePrint=yes&er_view=PRINT&pageWidthProces="+appConstants.publicjsonData.hiddenfields.pageWidthProces;
	   if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString=appConstants.publicjsonData.saveQstring;
		var compArray=new Array();
		compArray=Ext.getCmp("compNameList").getValue();
		for(var k=0;compArray.length>k;k++)
		{
			saveQString+="&compNameList="+compArray[k];
		}
		var s_qryString = saveQString+"&option=Graph&savePrint=yes&er_view=PRINT&pageWidthProces="+appConstants.publicjsonData.hiddenfields.pageWidthProces;
		//var s_qryString = saveQString+"&option=Graph&printGraph=yes&savePrint=yes&er_view=PRINT";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		this.updateQueryString();
		var bookletquery=appConstants.queryString+"&isSubmit=true";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function()
	{
		var saveQString=appConstants.publicjsonData.saveQstring;
		var s_qryString = "../reporter/ErAlarmHistoryPrint.jsp?"+saveQString+"&option=Graph&printGraph=yes&pdfPrint=yes&savePrint=yes";
		if (appConstants.menuForVM=='true')
		{
			printWindowFn(s_qryString);
		}
		else
		{
			 parent.printWindowFn(s_qryString); 
		}
	},
	sendMail:function(){
		if (Ext.get('mailtosend') == null)
		{
			Ext.create('utilities.SendMail').show();
			
		} else {
			Ext.getCmp('mailtosend').show();
		}
	},
	saveCsv:function(){
		var saveQString=appConstants.publicjsonData.saveQstring;
		//saveQString="/final/servlet/com.eg.ErAlarmHistoryC?"+saveQString+"&option=csv";
		//window.location=saveQString;
		Ext.Ajax.request(
		{
			url : '../servlet/com.eg.ErAlarmHistoryC',
			params : saveQString+"&option=csv",
			scope:this,
			success: function(response)
			{
				window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
			}
		});
	},
	showResult:function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var thisForm = Ext.getCmp("mainform").getForm();
		var eventFor=Ext.getCmp("eventfor").getValue();
		var compType=Ext.getCmp("compTypeList");
		var timeline = thisForm.findField("er_timeline").getValue();
		var reportgen=appConstants.publicjsonData.reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportgen = Ext.getCmp("reportGeneration").getValue();
		}
		if ( eventFor != 'Component')
		{
			var evnselect=Ext.getCmp("event_select");
			if(evnselect.getValue() == '-1' || evnselect.getValue() == 'not applicable')
			{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: evnselect.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(compType.getValue() == '-1' || compType.getValue() == 'not applicable')
		{
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: compType.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}
        var serverArray=Ext.getCmp('compNameList').getValue();
		if(Ext.Array.contains(serverArray,'All Components') && serverArray.length>1){
			Ext.MessageBox.show({
				title: 'Alert!',
				msg:  'All Components and Individual selection cannot be selected simultaneously!',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
		}
		var stDateTime = thisForm.findField('er_stdate').getValue();
        var tmpStartHour = thisForm.findField('er_sthr').getValue();
        stDateTime.setHours(tmpStartHour);
        var enDateTime = thisForm.findField('er_enddate').getValue();
        var tmpEndHour = thisForm.findField('er_endhr').getValue();
        enDateTime.setHours(tmpEndHour);

        var result = checkDateTime(stDateTime, enDateTime);
		if (!result) {
            return;
        }
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
		if(er_usertimeline!=null && er_usertimeline != '-1')
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDateTime, enDateTime);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		var bgenabled = appConstants.publicjsonData['hiddenfields']['bgenabled']
		var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg']
		var getMaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth']
		if(reportgen!=null && reportgen == 'foreground')
		{
			if (bgenabled == 'Yes' || bgenabled == 'yes') 
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,stDateTime,enDateTime))
				{
					Ext.MessageBox.confirm('Confirm', "Foreground report generation will take some time. Do you want to proceed?",this.showConfirmResult,this);
				} else 
				{
					this.submitReport();
				}
			}
			else 
			{
				this.submitReport();
			}  
		}
		else
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				Ext.MessageBox.show({
				title:'Operation Report Settings',
				msg:_checkspecial,
				buttons:Ext.MessageBox.OK,
				icon:Ext.MessageBox.WARNING
				});
				return
			}
			this.submitReport();
		}
	},
	submitReport:function()
	{
		this.updateQueryString();
		this.getNomeasurepanel().hide();
        var finalParams;
		var reportgen=appConstants.publicjsonData.reportGeneration;
		var urlforAjax="";
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp("reportGeneration").getValue();
		}
		if (reportgen == 'foreground') {
			urlforAjax='../servlet/com.eg.ErAlarmHistoryC';
			finalParams=appConstants.queryString+"&isSubmit=true&contentType=json";
		} 
		else if (reportgen == 'background') {
			urlforAjax='../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
            finalParams=appConstants.queryString+"&bg_reportname="+bg_reportname+"&isSubmit=true&contentType=json"
		}
		else if(reportgen == 'background-csv')
		{
			urlforAjax="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			var bg_reportname = Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
            finalParams=appConstants.queryString+"&bg_reportname="+bg_reportname+"&isSubmit=true&contentType=json"
		}
		appConstants.initLdgMask.show();
			Ext.Ajax.request(
			{
				url :urlforAjax,
				params :finalParams ,
				method :'POST',
				scope:this,
				async :true,
				success: function(response){
					var jsonData=Ext.decode(response.responseText);
					appConstants.publicjsonData=jsonData;
					appConstants.AlluserSelected=jsonData.AllUser;
					this.loadReportData(appConstants.publicjsonData);
				}
			});
	},
	loadReportData:function(jsonData){
		var resultPanelObj=Ext.getCmp('resultPanel');
 		var backgroundresultsObj=Ext.getCmp('backGroundPanel');
		var reportGeneration=appConstants.publicjsonData.reportGeneration;
		Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		if(reportGeneration == 'foreground')
		{
			backgroundresultsObj.hide();
			var showAlarms=jsonData.showAlarms;
			var timeLine = jsonData.selectedTimeline;
			var alarmNature = '';
			if(Ext.getCmp('alarmNature')!=undefined)
			{
				alarmNature = Ext.getCmp('alarmNature').getValue();
			}
			else
			{
				alarmNature = jsonData.selectedAlarmNautre;
			}
			if(timeLine != undefined && timeLine == "Any")
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}			
			if(showAlarms != undefined  && showAlarms == "Yes")
			{
 				var Qstring = appConstants.publicjsonData.alarmResultQueryString;
				Ext.Ajax.request(
				{
					url : '/final/reporter/ErAlarmHistoryResultsJSON.jsp',
					params : Qstring,
					method :'POST',
					scope:this,
					success: function(response){
						var isCurrent = false;
						jsonData=Ext.decode(response.responseText);
						var gridData = jsonData['alarmGridValues'];
						var hideSScolumn = jsonData['hideSScolumn'];
						appConstants.hideSScolumn = hideSScolumn;///check
						var eventperpage=parseInt(jsonData.eventsPerPage);
						this.getNomeasurepanel().hide();
						resultPanelObj.removeAll();
						var alarmType = appConstants.publicjsonData.alarmType;
						var pieChartResults;
						if(alarmType!=undefined && alarmType=="KNOWN")
						{
							appConstants.erUtils = Ext.widget("erutils");
							pieChartResults = jsonData['overViewDataPie'];
							var alarmDistResults = jsonData['alaramDistChartObj'];
							var overViewData = jsonData['overViewData'];
							var overViewDataLabels = jsonData['overViewDataLabels'];
							if (!Ext.isEmpty(pieChartResults)) 
							{	
								var overViewHtml = '<table align="center" style="margin:0px 10px 10px 10px;width:100%;"><tr><td width="25%">'
								+'<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tr><td colspan="1" rowspan="1"><table align="center"><tr><td align="right" style="padding-right:5px"><div class="summaryOpenProblems"></div></td><td class="newFont_bold28">'+overViewData['totalAlarms']+'</td></tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Total_Alarms']+'</td></tr></table></td><td width="25%">';
								if(alarmNature=='Historical')
								{
									overViewHtml+='<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div class="summaryMaximumDuration"></div></td><td class="newFont_bold28">'+overViewData['minDuration']+'</td>	</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Min']+'</td></tr></table></td><td width="25%">'
									+'<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div class="summaryMaximumDuration"></div></td><td class="newFont_bold28">'+overViewData['maxDuration']+'</td></tr></table></td></tr><tr style="text-align: center;"> <td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Max']+'</td></tr></table></td><td width="25%">'
									+'<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div class="summaryAverageDuration"></div></td><td class="newFont_bold28">'+overViewData['avgDuration']+'</td>	</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Avg']+'</td></tr></table></td></tr></table>';
								}
								else
								{
									isCurrent = true;
									overViewHtml+='<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div><img src="/final/images/component_icons/svg/state_HIGH.svg" width="36px" height="36px"/></div></td><td class="newFont_bold28">'+overViewData['criticalCount']+'</td>	</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Critical']+'</td></tr></table></td><td width="25%">'
									+'<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div><img src="/final/images/component_icons/svg/state_INTERMEDIATE.svg" width="36px" height="36px"></div></td><td class="newFont_bold28">'+overViewData['majorCount']+'</td></tr></table></td></tr><tr style="text-align: center;"> <td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Major']+'</td></tr></table></td><td width="25%">'
									+'<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0"><tr><td colspan="1" rowspan="1"><table align="center" style="align:center;margin:auto auto;"><tr><td align="right" style="padding-right:5px"><div><img src="/final/images/component_icons/svg/state_LOW.svg" width="36px" height="36px"></div></td><td class="newFont_bold28">'+overViewData['minorCount']+'</td>	</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_normal13" style="padding-top:5px">'+overViewDataLabels['Minor']+'</td></tr></table></td></tr></table>';
								}
								
								var titleOverview = appConstants.publicjsonData.titleHeading.tmpobj.Overview;
								var titleAlarmPriority = appConstants.publicjsonData.titleHeading.tmpobj.Alarms_By_Priority;
								var titleAlarmDistribution = appConstants.publicjsonData.titleHeading.tmpobj.Alarms_Distribution_By_Duration;
								var titleAlarmStartTime = appConstants.publicjsonData.titleHeading.tmpobj.Alarms_Trend_by_Start_Time;
								resultPanelObj.add({
									xtype: 'panel',
									ui:'newGraphPanel',
									//height:100,
									title:titleOverview,
									margin: '10 0 10 0',
									html:overViewHtml
								});

								resultPanelObj.add({
									xtype: 'container',
									ui:'newGraphPanel',
									id:'overViewChart',
									margin: '0 0 10 0',
									hidden:isCurrent,
									layout:'column',
									style:{
										'border':'0px !important',
									},
									//height:290
								});

								var overViewPieLegend = pieChartResults['overViewLegend'];
								var AlarmDistLegend = alarmDistResults['AlarmDistLegend'];

								var overLegendHtml = '<div style="height:250px;display:table-cell;vertical-align:middle;"><table>';				

								for(var k in overViewPieLegend)
								{
									var legend = overViewPieLegend[k];
									var lenLabel = legend['LEGEND_LABEL'];
									var x = lenLabel.substring(0, lenLabel.indexOf("("));
									var y = lenLabel.substring(lenLabel.indexOf("("), lenLabel.length);
									
									overLegendHtml += '<tr><td><div style="background-color:'+legend['LEGEND_COLOR']+';width:8px;height:8px;border-radius:50%;"></div></td><td style="text-align:left;padding-left:5px;line-height:2" class="rcontrol-load" >'+x+'</td><td style="text-align:left;padding-left:5px;line-height:2" class="rcontrol-load" >'+y+'</td></tr>';
								}

								overLegendHtml += '</table></div>'

								Ext.getCmp('overViewChart').add({
									xtype: 'panel',
									ui:'newGraphPanel',
									height:285,
									title:titleAlarmPriority,
									columnWidth:0.5,
									layout:'column',
									//xtype: 'panel',
									items:[{
											xtype:'container',
											columnWidth:0.65,
											//columnWidth:0.65,
											id:'chartOverView',
											listeners:{
												'boxready':function(){
													var highChart = {};
													highChart = jQuery.extend(true, {}, getHighChartsBarInstance('chartOverView',pieChartResults.chartHeight-10,260), highChart);
													highChart.setData(pieChartResults,'<%=currentDateFormat%>','');
													highChart.drawChart();
												}
											}
										},
										{
											xtype:'container',
											columnWidth:0.35,
											//columnWidth:0.35,
											html:overLegendHtml,
									}]
								});
								if(AlarmDistLegend.length>0)
								{
									var alarmDistLegendHtml = '<div style="height:250px;display:table-cell;vertical-align:middle;"><table>';	
									for(var k in AlarmDistLegend)
									{
										var legend = AlarmDistLegend[k];
										var lenLabel = legend['LEGEND_LABEL'];
										var x = lenLabel.substring(0, lenLabel.indexOf("("));
										var y = lenLabel.substring(lenLabel.indexOf("("), lenLabel.length);
										alarmDistLegendHtml += '<tr ><td><div style="background-color:'+legend['LEGEND_COLOR']+';width:8px;height:8px;border-radius:50%;"></div></td><td style="text-align:left;padding-left:5px;line-height:2" class="rcontrol-load" >'+x+'</td><td style="text-align:left;padding-left:5px;line-height:2" class="rcontrol-load" >'+y+'</td></tr>';
									}
									alarmDistLegendHtml += '</table></div>';
									Ext.getCmp('overViewChart').add({
										xtype: 'panel',
										ui:'newGraphPanel',
										title:titleAlarmDistribution,
										columnWidth:0.5,
										height:285,
										layout:'column',
										margin:'0 0 0 10',
										items:[{
											xtype:'container',
											//columnWidth:0.7,
											columnWidth:0.65,
											id:'chartAlarmDist',
											listeners:{
												'boxready':function(){
													var highChart = {};
													highChart = jQuery.extend(true, {}, getHighChartsBarInstance('chartAlarmDist',alarmDistResults.chartHeight-10,alarmDistResults.chartWidth), highChart);
													highChart.setData(alarmDistResults,'<%=currentDateFormat%>','');
													highChart.drawChart();
												}
											}
										},{
											xtype:'container',
											//columnWidth:0.3,
											columnWidth:0.35,
											html:alarmDistLegendHtml,
										}]	
									});
								}
								else
								{
									var alarmDistLegendHtml = '<table height="100%" width="100%">';
									alarmDistLegendHtml += '<tr height="100%"><td align="center" valign="midle"><div class="iconExclamation"  align="center" valign="midle"></div><div class="font_bold11">Alarms by Durations is not available currently<div></td><tr></table>';
									Ext.getCmp('overViewChart').add({
										xtype: 'panel',
										ui:'newGraphPanel',
										title:titleAlarmDistribution,
										columnWidth:0.5,
										height:285,
										layout:'column',
										margin:'0 0 0 10',	
										html:alarmDistLegendHtml,
									});
								}
							}
							var chartDataVal = jsonData['alaramTrendChartObj'];	
							chartDataVal['drildown'] = 'sametab';
							var trendChartHtml ='<div id="trendChart" style="height:95%;width:100% !important;overflowY:hidden;padding-top:10px"></div>';
							resultPanelObj.add({
								xtype: 'panel',
								title: titleAlarmStartTime,
								ui:'newGraphPanel',
								layout:'column',
								margin: '0 0 0 0',
								height:350,
								html:trendChartHtml,
								listeners:{
									'boxready':function(){
										var topNAppSBar = {};
										topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('trendChart',300,1020), topNAppSBar);
										topNAppSBar.setData(chartDataVal, '<%=currentDateFormat%>','');
										topNAppSBar.drawChart();
									}
								}
							});
						}
						//resultPanelObj.add({xtype:'alarmdetailsgrid',pageLimit:eventperpage,screenLabels:jsonData.gridColumnNames,dataArray:gridData});
						if(gridData.length>recordPerPage)
						{
							customPaging = true;
						}
						else
						{
							customPaging = false;
						}
						resultPanelObj.add(
						{
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'10 0 10 0',
							items:[{
								xtype:'alarmdetailsgrid',
								pageLimit:eventperpage,
								screenLabels:jsonData.gridColumnNames,
								dataArray:gridData
							}]
						});
 						resultPanelObj.getHeader().hide();
						
						resultPanelObj.show();
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("upbutton").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						appConstants.initLdgMask.hide(); 
					}
				});
			}
			else
			{
				this.disableTools();
				Ext.getCmp("upbutton").setDisabled(false);
				resultPanelObj.hide();
				this.getNomeasurepanel().show();
				appConstants.initLdgMask.hide();
			}
		}
		else if(reportGeneration == 'background')
		{
			resultPanelObj.hide();
			var backgroundReportStatus=jsonData.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				var bgroundReportsURL=jsonData.bgroundReportsURL;
				var backgroundAnchor=jsonData.backgroundAnchor;
				var sub = backgroundAnchor;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+sub+ '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate')
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				var bgroundReportsURL=jsonData.bgroundReportsURL;
				var backgroundAnchor=jsonData.backgroundAnchor;
				var sub = backgroundAnchor;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+sub+ '</a></div></td></tr></table></td></tr></table>');
				
			}
			else
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:420px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'</div></td></tr></table></td></tr></table>');
			}
			backgroundresultsObj.show();
			appConstants.initLdgMask.hide();
		}
		else if(reportGeneration == 'background-csv')
		{
			resultPanelObj.hide();
			var backgroundReportStatus=jsonData.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				var bgroundReportsURL=jsonData.bgroundReportsURL;
				var backgroundAnchor=jsonData.backgroundAnchor;
				var sub = backgroundAnchor;
				
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+sub+ '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate')
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				var bgroundReportsURL=jsonData.bgroundReportsURL;
				var backgroundAnchor=jsonData.backgroundAnchor;
				var sub = backgroundAnchor;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+sub+ '</a></div></td></tr></table></td></tr></table>');
				
			}
			else
			{
				var bgroundResponseTxt=jsonData.bgroundResponseTxt;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:420px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'</div></td></tr></table></td></tr></table>');
			}
			backgroundresultsObj.show();
			appConstants.initLdgMask.hide();
		}
	},
	timeLineOnChange:function() {
		Ext.getCmp('resultPanel').hide();
		this.getMain().doLayout();
		this.disableTools();
		var startDateObj=Ext.getCmp('er_stdate');
		var startHrObj=Ext.getCmp('er_sthr');
		var endDateObj=Ext.getCmp('er_enddate');
		var endHrObj=Ext.getCmp('er_endhr');
		
		if(Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			this.updateQueryString();
			Ext.Ajax.request(
			{
				url : '/final/reporter/ErAlarmHistoryJSON.jsp',
				params : appConstants.queryString,
				method :'POST',
				scope:this,
				success: function(response){
					var jsonData=Ext.decode(response.responseText);
					appConstants.publicjsonData=jsonData;
					var start_hour=jsonData.startHour;
					var end_hour=jsonData.endHour;
					var start_date=jsonData.startDate;
					var end_date=jsonData.endDate;
					startDateObj.setDisabled(true);
					startHrObj.setDisabled(true);
					endDateObj.setDisabled(true);
					endHrObj.setDisabled(true);
					startDateObj.setValue(start_date);
					startHrObj.setValue(start_hour);
					endDateObj.setValue(end_date);
					endHrObj.setValue(end_hour);
				}
			});
		}
	},
	mainFormEvent:function(obj)	{
		this.disableTools();
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.hide();
		var clickedButton=obj.getId();
		var alarmType=appConstants.publicjsonData.alarmType;
		var params="";
		if(clickedButton == 'eventfor' || clickedButton == 'event_select' ||  clickedButton == 'includeSubZone' || clickedButton == 'compTypeList' || clickedButton == 'compsearch')
		{
			params="&v_event="+Ext.getCmp("eventfor").getValue()+"&er_timeline="+Ext.getCmp("er_timeline").getValue();
			if(alarmType!=undefined && alarmType=="UNKNOWN"){
				params+="&unknownState=UNKNOWN";
			}
			else if(alarmType!=undefined && alarmType=="ACKNOWLEDGEMENT")
			{
				params+="&unknownState=ACKNOWLEDGEMENT";
			}
			else
			{
				params+="&unknownState=KNOWN";
			}
			if(clickedButton == 'event_select' || clickedButton == 'includeSubZone' || clickedButton == 'compTypeList' || clickedButton == 'compsearch' ){
				params+="&subevent="+Ext.getCmp("event_select").getValue();
				params+="&selectedsubzone="+Ext.getCmp("includeSubZone").getValue();
				params+="&includeSubZone="+Ext.getCmp("includeSubZone").getValue();
			}
			if(clickedButton == 'compTypeList')
			{
				params+="&compTypeList="+Ext.getCmp("compTypeList").getValue();
			}
			if(clickedButton == 'compsearch'){
				params+="&compTypeList="+Ext.getCmp("compTypeList").getValue()+"&compsearch="+Ext.getCmp("compsearch").getValue();
			}
		}
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		favorite_id = hiddenFields["favorite_id"];
		params+=defaultParams+"&FavoriteId="+favorite_id;
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if(fromFavoriteModify!=undefined)
		{
			params+="&fromFavoriteModify="+fromFavoriteModify;
		}
		var fromSchedule = hiddenFields["fromSchedule"];
		if(fromFavoriteModify!=undefined)
		{
			params+="&fromSchedule="+fromSchedule;
		}
		var fromScheduleModify = hiddenFields["fromScheduleModify"];
		if(fromScheduleModify!=undefined)
		{
			params+="&fromScheduleModify="+fromScheduleModify;
		}
		var schedule_id = hiddenFields["schedule_id"];
		if(schedule_id!=undefined)
		{
			params+="&schedule_id="+schedule_id;
		}
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErAlarmHistoryJSON.jsp',
			params : params,
			scope:this,
			async: false,
			method : 'POST',
			success: function(response){
				var jsonData=Ext.decode(response.responseText);
				appConstants.publicjsonData=jsonData;
				if(clickedButton == 'eventfor')
				{
					var selectedAnalysis=jsonData.selectedAnalysis;
					var subzoneObj=Ext.getCmp('includeSubZone');
					var evntSelectObj=Ext.getCmp('event_select');
					subzoneObj.hide();						
					if(selectedAnalysis!='Component'){
						var elementRawData=jsonData.elementsCombo;
						evntSelectObj.setFieldLabel(jsonData.screenLabels['reporter.history.'+selectedAnalysis]);
						evntSelectObj.getStore().loadRawData(elementRawData);
						evntSelectObj.setValue(elementRawData[0].valueField);
						evntSelectObj.show();

						if(selectedAnalysis == 'Zone')
						{
							subzoneObj.show();
						}
					}
					else{
						evntSelectObj.hide();
					}
					var compTypeRawData=jsonData.compTypeCombo;
					var selectedType=jsonData.selectedCompType;
					var compTypeObj=Ext.getCmp('compTypeList');
					compTypeObj.getStore().clearFilter(true); 
					compTypeObj.getStore().loadRawData(compTypeRawData);
					compTypeObj.setValue(compTypeRawData[0].valueField);

					var compRawData=jsonData.componentsCombo;
					var selectedComps=jsonData.selectedComponents;
					var compObj=Ext.getCmp('compNameList');
					compObj.getStore().loadRawData(compRawData);
					compObj.setValue(compRawData[0].valueField);
				}
				else if (clickedButton == 'event_select' || clickedButton == 'includeSubZone' )
				{
					var compTypeRawData=jsonData.compTypeCombo;
					var selectedType=jsonData.selectedCompType;
					var compTypeObj=Ext.getCmp('compTypeList');
					compTypeObj.getStore().clearFilter(true);
					compTypeObj.getStore().loadRawData(compTypeRawData);
					compTypeObj.setValue(compTypeRawData[0].valueField);

					var compRawData=jsonData.componentsCombo;
					var selectedComps=jsonData.selectedComponents;
					var compObj=Ext.getCmp('compNameList');
					compObj.getStore().loadRawData(compRawData);
					compObj.setValue(compRawData[0].valueField);
				}
				else if (clickedButton == 'compTypeList' || clickedButton == 'compsearch')
				{
					var compRawData=jsonData.componentsCombo;
					var selectedComps=jsonData.selectedComponents;
					var compObj=Ext.getCmp('compNameList');
					compObj.getStore().loadRawData(compRawData);
					compObj.setValue(compRawData[0].valueField);
				}
			}
		});
	},
	updateQueryString:function()
	{
		var jsonData = appConstants.publicjsonData;
		var mainForm = Ext.getCmp("operationAlarmHistory").getForm();
		var timeline = Ext.getCmp("er_timeline").getValue();
		var eventForvalue=mainForm.findField("eventfor").getValue();
		var mainFormParams="&eventfor="+eventForvalue+"&v_event="+eventForvalue;
		var settingsFormParams="";
		var hiddenfieldQString="";
		var compArray=new Array();
		compArray=Ext.getCmp("compNameList").getValue();
		if(eventForvalue!='Component')
		{
			var evnselect=mainForm.findField("event_select").getValue();
			if(eventForvalue == 'Zone')
			{
				//mainFormParams+="&includesubzone="+mainForm.findField("includeSubZone").getValue();
			}
			mainFormParams+="&subevent="+evnselect+"&event_select="+evnselect;
		}
		else
		{
			mainFormParams+="&subevent=null&event_select=null";
		}
		mainFormParams+="&includeSubZone="+mainForm.findField("includeSubZone").getValue();
		mainFormParams+="&compTypeList="+mainForm.findField("compTypeList").getValue();
		for(var k=0;compArray.length>k;k++)
		{
			mainFormParams+="&compNameList="+compArray[k];
		}
		var reportGen = jsonData.reportGeneration;
		var state = jsonData.selectedState;
		var showAllRecord = jsonData.selectedShowAllRecord;
		var ack_state = jsonData.selectedAckState;
		var arrangeAlarms = jsonData.selectedSortOption;
		var duraSelect = jsonData.selectedTimeOption;
		var ack_duraSelect = jsonData.selectedAckTimeOption;
		var searchByUser = jsonData.searchByUser;
		var timelineType = jsonData.selectecTimeLineType;
		var duration = jsonData.duration
		var ack_duration = jsonData.ack_duration
		var glduration = jsonData.selectedDuration
		var alarmNature = jsonData.selectedAlarmNautre
		var ack_glduration = jsonData.selectedAckDuration
		var eventsPerPage = jsonData.selectedEvntPerPage;
		var searchBy = jsonData.selectedSearchOption;
		var showuser = '';//jsonData.selectedUser;
		var isDrillDown = jsonData.isDrillDown;
		appConstants.erUtils = Ext.widget("erutils");
		if (isSettingsEnabled)
		{
			reportGen = Ext.getCmp('reportGeneration').getValue();
			state = Ext.getCmp('state').getValue();
			showAllRecord = Ext.getCmp('showAllRecord').getValue();
			ack_state = Ext.getCmp('ack_state').getValue();
			arrangeAlarms = Ext.getCmp('arrangeAlarms').getValue();
			duraSelect = Ext.getCmp('duraSelect').getValue();
			ack_duraSelect = Ext.getCmp('ack_duraSelect').getValue();
			searchByUser = Ext.getCmp('searchByUser').getValue();
			timelineType = Ext.getCmp('timelineType').getValue();
			duration = Ext.getCmp('duration').getValue();
			ack_duration = Ext.getCmp('ack_duration').getValue();
			glduration = Ext.getCmp('glduration').getValue();
			alarmNature = Ext.getCmp('alarmNature').getValue();
			ack_glduration = Ext.getCmp('ack_glduration').getValue();
			eventsPerPage = Ext.getCmp('eventsPerPage').getValue();
			searchBy = Ext.getCmp('searchBy').getValue();
			showuser = Ext.getCmp('showuser').getValue();
		}
		settingsFormParams ="&state="+state
							+"&showAllRecord="+ showAllRecord
							+"&ack_state="+ ack_state
							+"&er_reportgenration="+ reportGen
							+"&arrangeAlarms="+arrangeAlarms
							+"&duraSelect="+duraSelect
							+"&ack_duraSelect="+ack_duraSelect
							+"&searchByUser="+searchByUser
							+"&er_timeLineType="+timelineType
							+"&duration="+duration
							+"&ack_duration="+ack_duration
							+"&glduration="+appConstants.erUtils.specialCharEncode(glduration)
							+"&ack_glduration="+ack_glduration
							+"&alarmNature="+alarmNature
							+"&eventsPerPage="+eventsPerPage
							+"&searchBy="+searchBy
							+"&showuser="+showuser+"&isDrillDown="+isDrillDown;
				
		var startDateConverted=Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted=Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
        	var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		if(appConstants.publicjsonData.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		var extraParamFromJvm="&fromJvm="+appConstants.fromJvm+"&measureName="+appConstants.measureName+"&testName="+appConstants.testName+"&infoName="+appConstants.infoName;
		appConstants.queryString=mainFormParams+settingsFormParams+timelineParams+hiddenfieldQString +"&er_RmDispName="+appConstants.er_RmDispName+extraParamFromJvm;
	},
	loadTools : function() {
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);		
	},
	disableTools: function()
	{
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	showConfigDropdown : function() {
		isSettingsEnabled = true;
		var thisController = this;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container', 
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype:'operationsalarmshistoryconfig',
				parent:this
			}
		],
		renderTo:'alarmHistory-body'
		});
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		if(Ext.get('closeSettings') != null)
		{
			Ext.get('closeSettings').on('click',function(){
				thisController.validateAndCloseSettings();
			});
		}
	},
	validateAndCloseSettings :function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	afterMainRender:function()
	{
		appConstants.initLdgMask.show();
		Ext.getCmp('er_mode').hide();
		this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		// by karthikeyan
		this.fillFormFields(appConstants.publicjsonData);
		//this.refreshReportData();
		if(appConstants.isForceSubmit!=null && appConstants.isForceSubmit !='null' && appConstants.isForceSubmit=='true' )
		{
			appConstants.isForceSubmit='false';
			this.showResult();
		} 
	},
	refreshReportData:function(){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.loadReportData(appConstants.publicjsonData);
		}
	},
	fillFormFields:function(jsonData)
	{
		var isSubmitted="false";
		if(jsonData.hasOwnProperty('isSubmit'))
			isSubmitted=jsonData.isSubmit;
		var screenLabels=jsonData.screenLabels;
		globalScreenLabels=jsonData.screenLabels;

		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
		isSubmitted="false";
		Ext.getCmp("submit").hide();
		Ext.getCmp("save").show();
		Ext.getCmp("favoriteTool").setDisabled(true);
		Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var analysisRawData=jsonData.analysisCombo;
		var selectedAnalysis=jsonData.selectedAnalysis;
		var analysisObj=Ext.getCmp('eventfor');
		analysisObj.setFieldLabel(screenLabels['reporter.common.Analysis by']);
		analysisObj.getStore().loadRawData(analysisRawData);
		if ( !Ext.isEmpty(selectedAnalysis) )
		{
			analysisObj.setValue(selectedAnalysis);
		}
		else
		{
			analysisObj.setValue(analysisRawData[0].valueField);
		}
		if(selectedAnalysis != 'Component'){
			var event_select_obj = Ext.getCmp('event_select');
			if(selectedAnalysis == 'Zone'){
				Ext.getCmp('includeSubZone').show();
			}
		var elementsrawdata=jsonData.elementsCombo;
		if(!Ext.isEmpty(elementsrawdata))
		{
			var selectedElement=jsonData.selectedElement;
			event_select_obj.setFieldLabel(selectedAnalysis);
			event_select_obj.getStore().loadRawData(elementsrawdata);
			if ( !Ext.isEmpty(selectedElement) )
			{
				event_select_obj.setValue(selectedElement);
			}
			else
			{
				event_select_obj.setValue(elementsrawdata[0].valueField);
			}
				event_select_obj.show();
		}
		}
		var subzoneObj=Ext.getCmp('includeSubZone');
		var subzoneRawData=jsonData.subZoneCombo
		subzoneObj.setFieldLabel(jsonData.screenLabels['reporter.history.Include Subzones']);
		subzoneObj.getStore().loadRawData(subzoneRawData);
		subzoneObj.setValue(jsonData.subzone);

		var compTypeRawData=jsonData.compTypeCombo;
		var selectedType=jsonData.selectedCompType;
		var compTypeObj=Ext.getCmp('compTypeList');
		compTypeObj.setFieldLabel(screenLabels['reporter.common.Component Type']);
		compTypeObj.getStore().clearFilter(true);
		compTypeObj.getStore().loadRawData(compTypeRawData);
		if ( !Ext.isEmpty(selectedType) )
		{
			compTypeObj.setValue(selectedType);
		}
		else
		{
			compTypeObj.setValue(compTypeRawData[0].valueField);
		}

		var compRawData=jsonData.componentsCombo;
		var selectedComps=jsonData.selectedComponents;
		var compObj=Ext.getCmp('compNameList');
		Ext.getCmp('systemLabel').setText(screenLabels['reporter.common.Component']);
		compObj.getStore().loadRawData(compRawData);
		if ( !Ext.isEmpty(selectedComps) )
		{
			compObj.setValue(selectedComps);
		}
		else
		{
			compObj.setValue(compRawData[0].valueField);
		}
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=Ext.getCmp('er_timeline');

		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var start_hour=jsonData.startHour;
		var end_hour=jsonData.endHour;
		var start_date=jsonData.startDate;
		var end_date=jsonData.endDate;
		var startDateObj=Ext.getCmp('er_stdate');
	        startDateObj.setValue(jsonData.startDateForDisplay);
	        startDateObj.dataArray = start_date;
	        var startHrObj = Ext.getCmp('er_sthr');
	        startHrObj.setValue(jsonData.startHourForDisplay);
	        startHrObj.dataArray = start_hour;
	        var endDateObj = Ext.getCmp('er_enddate');
	        endDateObj.setValue(jsonData.endDateForDisplay);
	        endDateObj.dataArray = end_date;
	        var endHrObj = Ext.getCmp('er_endhr');
	        endHrObj.setValue(jsonData.endHourForDisplay);
	        endHrObj.dataArray = end_hour;
	        stmin = jsonData.startMinForDisplay;
	        enmin = jsonData.endMinForDisplay;
	        mgr_stmin = jsonData.startmin;
	        mgr_enmin = jsonData.endmin;

		if(!hideBackButton){
			Ext.getCmp('operationAlarmHistory').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: jsonData['ID']
				}
			);
		}
		if(isSubmitted == 'true'  && from_schedule == null){
			this.updateQueryString();
			this.showResult();
		}
		appConstants.initLdgMask.hide();
	},
	afterSettingsrender : function() {
		var favorite_id = appConstants.publicjsonData.hiddenfields.favorite_id;
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		updatingAppSettings();
		var jsonData = appConstants.publicjsonData;
		var enableUsrCombo=jsonData.enableUserCombo;
		var alarmType=jsonData.alarmType;
		var screenLabels=jsonData.screenLabels;
		var priorityObj=Ext.getCmp('state');
		var showAllRecordObj=Ext.getCmp('showAllRecord');
		var ack_stateObj=Ext.getCmp('ack_state');
 		if(alarmType!=undefined && (alarmType=="KNOWN" || alarmType=="ACKNOWLEDGEMENT" ))
		{
			var priorityRawData=jsonData.stateCombo;
			var selectedpriority=jsonData.selectedState;
			priorityObj.setFieldLabel(screenLabels['reporter.alarmHistory.Priority']);
			priorityObj.getStore().loadRawData(priorityRawData);
			if ( !Ext.isEmpty(selectedpriority) )
			{
				priorityObj.setValue(selectedpriority);
			}
			else
			{
				priorityObj.setValue(priorityRawData[0].valueField);
			}
			priorityObj.show();
			if(alarmType=="ACKNOWLEDGEMENT")
			{
				var ack_stateRawData=jsonData.ack_stateCombo;
				var selectedAckState=jsonData.selectedAckState;
				ack_stateObj.setFieldLabel(screenLabels['reporter.alarmHistory.Status']);
				ack_stateObj.getStore().loadRawData(ack_stateRawData);
				
				if ( !Ext.isEmpty(selectedAckState) )
				{
					ack_stateObj.setValue(selectedAckState);
				}
				else
				{
					ack_stateObj.setValue(ack_stateRawData[0].valueField);
				}
				var showAllRecordRawData=jsonData.showAllRecordCombo;
				var selectedShowAllRecord=jsonData.selectedShowAllRecord;
				showAllRecordObj.setFieldLabel(screenLabels['reporter.alarmHistory.Show Acknowledgement']);
				showAllRecordObj.getStore().loadRawData(showAllRecordRawData);
				
				if ( !Ext.isEmpty(selectedShowAllRecord) )
				{
					showAllRecordObj.setValue(selectedShowAllRecord);
				}
				else
				{
					showAllRecordObj.setValue(showAllRecordRawData[0].valueField);
				}
				ack_stateObj.show();
				showAllRecordObj.show();
			}
			else
			{
				ack_stateObj.hide();
				showAllRecordObj.hide();
			}
		}
		else
		{
			priorityObj.hide();
		}
		if(enableUsrCombo!=undefined && enableUsrCombo =="yes")
		{
			var userRawData=jsonData.usersCombo;
			var selecteduser=jsonData.selectedUser;
			var userObj=Ext.getCmp('showuser');
			userObj.setFieldLabel(screenLabels['reporter.common.User']);
			userObj.getStore().loadRawData(userRawData);
			if ( !Ext.isEmpty(selecteduser) )
			{
				userObj.setValue(selecteduser);
			}
			else
			{
				userObj.setValue(userRawData[0].valueField);
			}
			userObj.show();
		}
		var durationRawData=jsonData.durationCombo;
		var ack_durationRawData=jsonData.ack_durationCombo;
		var selectedDuration=jsonData.selectedDuration;
		var selectedAlarmNautre=jsonData.selectedAlarmNautre;
		var selectedAckDuration=jsonData.selectedAckDuration;
		var alarmNatureData=jsonData.alarmNatureCombo;
		var durationObj=Ext.getCmp('glduration');
		var ack_durationObj=Ext.getCmp('ack_glduration');
		
		durationObj.setFieldLabel(screenLabels['reporter.common.Duration']);
		durationObj.getStore().loadRawData(durationRawData);
		if ( !Ext.isEmpty(selectedDuration) )
		{
			durationObj.setValue(selectedDuration);
		}
		else
		{
			durationObj.setValue(durationRawData[0].valueField);
		}
		ack_durationObj.setFieldLabel(screenLabels['reporter.common.Response Time']);
		ack_durationObj.getStore().loadRawData(ack_durationRawData);
		if ( !Ext.isEmpty(selectedAckDuration) )
		{
			ack_durationObj.setValue(selectedAckDuration);
		}
		else
		{
			ack_durationObj.setValue(ack_durationRawData[0].valueField);
		}
		if(alarmType!=undefined && alarmType=="ACKNOWLEDGEMENT")
		{
			ack_durationObj.show();
			Ext.getCmp('ack_splitter').show();
		}
		else
		{
			ack_durationObj.hide();
			Ext.getCmp('ack_splitter').hide();
		}
		var timeOptionRawData=jsonData.timeOptionCombo;
		var selectedtimeOption=jsonData.selectedTimeOption;
		var timeOptionObj=Ext.getCmp('duraSelect');
		timeOptionObj.getStore().loadRawData(timeOptionRawData);
		if ( !Ext.isEmpty(selectedtimeOption) )
		{
			timeOptionObj.setValue(selectedtimeOption);
		}
		else
		{
			timeOptionObj.setValue(timeOptionRawData[0].valueField);
		}

		var alarmNatureObj=Ext.getCmp('alarmNature');		
		alarmNatureObj.setFieldLabel(screenLabels['reporter.alarmHistory.Alarms Type']);
		alarmNatureObj.getStore().loadRawData(alarmNatureData);
		if ( !Ext.isEmpty(selectedAlarmNautre) )
		{
			alarmNatureObj.setValue(selectedAlarmNautre);
		}
		else
		{
			alarmNatureObj.setValue(alarmNatureData[0].valueField);
		}
		if(alarmNatureObj.getValue()!='Historical')
		{
			Ext.getCmp('glduration').hide();
			Ext.getCmp('duration').hide();
			Ext.getCmp('duraSelect').hide();
		}

		var ack_timeOptionRawData=jsonData.ack_timeOptionCombo;
		var selectedAckTimeOption=jsonData.selectedAckTimeOption;
		var ack_timeOptionObj=Ext.getCmp('ack_duraSelect');
		ack_timeOptionObj.getStore().loadRawData(ack_timeOptionRawData);
		if ( !Ext.isEmpty(selectedAckTimeOption) )
		{
			ack_timeOptionObj.setValue(selectedAckTimeOption);
		}
		else
		{
			ack_timeOptionObj.setValue(ack_timeOptionRawData[0].valueField);
		}
		Ext.getCmp('duration').setValue(jsonData.duration);
		Ext.getCmp('ack_duration').setValue(jsonData.ack_duration);
		
		var searchRawData=jsonData.searchCombo;
		var selectedsearch=jsonData.selectedSearchOption;
		var searchObj=Ext.getCmp('searchBy');
		searchObj.setFieldLabel(screenLabels['reporter.common.Search by']);
		searchObj.getStore().loadRawData(searchRawData);
		if ( !Ext.isEmpty(selectedsearch) )
		{
			searchObj.setValue(selectedsearch);
		}
		else
		{
			searchObj.setValue(searchRawData[0].valueField);
		}
		var selectedsearchByUser=jsonData.searchByUser;
		var searchByUserObj=Ext.getCmp('searchByUser');
		if ( !Ext.isEmpty(selectedsearchByUser) )
		{
			searchByUserObj.setValue(selectedsearchByUser);
		}
		var timeLineTypeVal =jsonData.reportTimeLineType;
		var selectecTimeLineType =jsonData.selectecTimeLineType;
		var timeLineTypeObj = Ext.getCmp('timelineType');
		timeLineTypeObj.getStore().loadRawData(timeLineTypeVal);
		if ( !Ext.isEmpty(selectecTimeLineType) )
		{
			timeLineTypeObj.setValue(selectecTimeLineType);
		}
		else
		{
			timeLineTypeObj.setValue(timeLineTypeVal[0].valueField);
		}

		var sortRawData=jsonData.sortCombo;
		var selectedsort=jsonData.selectedSortOption;
		var sortObj=Ext.getCmp('arrangeAlarms');
		sortObj.setFieldLabel(screenLabels['reporter.common.Sort by']);
		sortObj.getStore().loadRawData(sortRawData);
		if ( !Ext.isEmpty(selectedsort) )
		{
			sortObj.setValue(selectedsort);
		}
		else
		{
			sortObj.setValue(sortRawData[0].valueField);
		}
		var eventCntRawData=jsonData.eventPerPageCombo;
		var selectedeventCnt=jsonData.selectedEvntPerPage;
		var eventCntObj=Ext.getCmp('eventsPerPage');
		eventCntObj.setFieldLabel(screenLabels['reporter.alarmHistory.Events per page']);
		eventCntObj.getStore().loadRawData(eventCntRawData);
		if ( !Ext.isEmpty(selectedeventCnt) )
		{
			eventCntObj.setValue(selectedeventCnt);
		}
		else
		{
			eventCntObj.setValue(eventCntRawData[0].valueField);
		}
		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();

		if(reportGenType== 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if(reportGenType== 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	changeAckDuration:function()
	{
		var ack_glduration = Ext.getCmp('ack_glduration').getValue();
		if(ack_glduration!=undefined && ack_glduration=='none')
		{
			Ext.getCmp('ack_duration').hide();
			Ext.getCmp('ack_duraSelect').hide();
		}
		else
		{
			Ext.getCmp('ack_duration').show();
			Ext.getCmp('ack_duraSelect').show();
		}
	},
	onChangeAlarmNature:function(obj)
	{
		var val = obj.getValue();
		if(val=='Historical')
		{
			Ext.getCmp('glduration').show();
			Ext.getCmp('duration').show();
			Ext.getCmp('duraSelect').show();
			Ext.getCmp('glduration').setValue('>');
			Ext.getCmp('duration').setValue(0);
			Ext.getCmp('duraSelect').setValue('seconds');
		}
		else
		{
			Ext.getCmp('glduration').hide();
			Ext.getCmp('duration').hide();
			Ext.getCmp('duraSelect').hide();
			Ext.getCmp('glduration').setValue('<');
			Ext.getCmp('duration').setValue(1);
			Ext.getCmp('duraSelect').setValue('seconds');
		}
	},
	validateSaveSettings :function(){
		var isSettingsOk = true;
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
		
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},
	validateSettings :  function()
	{
		var isSettingsOk = true;
		var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var duration=Ext.getCmp('duration').getValue();
		var ack_duration=Ext.getCmp('ack_duration').getValue();
		var ack_glduration=Ext.getCmp('ack_glduration').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
	
		if(duration.trim()== '' || isNaN(duration.trim()))
		{
			Ext.MessageBox.show({
			title: 'Operation Reports Settings',
			msg: 'Wrong Input Value',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isSettingsOk = false;
		}
		if(ack_glduration!='none' && (ack_duration.trim()== '' || isNaN(ack_duration.trim())))
		{
			Ext.MessageBox.show({
			title: 'Operation Reports Settings',
			msg: 'Wrong Input in Response Time',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			isSettingsOk = false;
		}
		if ( reportgen!=null && reportgen == 'foreground' )
		{
			/*var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
			if(!Ext.isEmpty(limitforbg))
				{
				if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
					isSettingsOk = false;
				}
			}*/
		}
		else
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('compNameList'),Ext.getCmp('systemLabel').text,btn);
	},
	showConfirmResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			this.submitReport();
		}
		else
		{
			this.getReporterSettings().down('button').fireHandler();
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
			return false;
		}
	},
	exportDataAlert:function()
	{
		Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Exporting the report may take too long to complete. Choose the Background option to export this report',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	}
});