Ext.define('OperationUptime.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'ReporterSettings', ref:'ReporterSettings'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'reportgeneration', ref:'reportgeneration'},
 		{selector:'operationuptimemainform', ref:'operationuptimemainform'},
		{selector:'operationuptimesettings', ref:'operationuptimesettings'},
		{selector:'selectiondetails', ref:'selectiondetails'},
		{selector:'operationuptimesubmitteddata', ref:'operationuptimesubmitteddata'},
		{selector:'operationUptimeSubmittedDataForOverview', ref:'operationUptimeSubmittedDataForOverview'},
		{selector:'mainform', ref:'mainform'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'backGroundPanel', ref:'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'newUtilities' :
			{
				'afterrender' : this.loadTools
			},
			'main':{
				'boxready' : this.defaultLoad
			},
			'operationuptimesettings':{
				'afterrender':this.fillSettingsElements
			},
			'operationuptimemainform':{
				'afterrender':this.loadMainElements
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.saveFile
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #printTool > button':
			{
				'click':this.print
			},
			'operationuptimemainform combo[name="uptimeReport"]':
			{
				'select': this.selectReportTypeCombos
			},
			'operationuptimemainform combo[name="analyzeBy"]':
			{
				'select': this.selectReportTypeCombos
			},
			'operationuptimemainform combo[name="compType"]':
			{
				'select': this.selectComponents
			},
			'operationuptimemainform combo[name="zone"]':
			{
				'select': this.selectZoneComponents
			},
			'operationuptimemainform combo[name="segment"]':
			{
				'select': this.selectSegmentComponents
			},
			'operationuptimemainform combo[name="service"]':
			{
				'select': this.selectServiceComponents
			},
			'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'operationuptimemainform combo[name="subzone"]':
			{
				'select': this.includeOrExcludeSubzone
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'operationuptimesettings button[id="moreOptionCloseId"]': {
				'click': this.validateSettings
			},
			'operationuptimesettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'operationuptimesettings combo[name="chartOptionsCombo"]':
			{
				'select': this.showUptimeChartOptions
			},
			/*'operationuptimesettings combo[name="excludeWeekendsCombo"]':
			{
				'select': this.showExcludeWeekendOptions
			},	*/	
			'mainform button[id="submit"]':
			{
				'click': this.beforeFormSubmit
			},
			'mainform button[name="save"]':
			{
				'click': this.addTo
			},
			'mainform combo[id="report_Type"]':
			{
				'select': this.showDetailsRadio
			},			
			'newUtilities > #favoriteTool > button' : {
						'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'print' : {
				'boxready':this.printPageRender
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveDataInCSVFormat
			},
			'timeline combo[name="er_mode"]': 
			 {
				'select': this.changeEr_mode
			 },
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},						
			 'egcomponent trigger[id="filterOpt"]': {
                'change': this.filterMultiselect
            }			
		});
	},
	loadRepData : function()
	{
		var uptimeReportt = Ext.getCmp('uptimeReport');
		var reportType = Ext.getCmp('report_Type');
		if(uptimeReportt!=undefined) 
		{
			if(uptimeReportt.getValue()=='Services')
				uptimeReportt.hide();
			else
				uptimeReportt.show();
		}
		if(reportType!=undefined && uptimeReportt!=undefined)
		{
			if(reportType.getValue()=='data' && uptimeReportt.getValue()=='Systems')
			{
				Ext.getCmp('runningDurationFilter').show();
			}
			else
			{
				Ext.getCmp('runningDurationFilter').hide();
			}
		}
		//
		var myTitle = appConstants.publicJsonData["rm_titleDisplay"];
		if (myTitle!= null && myTitle!= 'undefined')
		{
		 this.getMain().setTitle(myTitle);
		 appConstants.er_RmDispName=myTitle;
		}
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.updateQueryString('submit');
			//
			var uptimeReport = Ext.getCmp('uptimeReport').getValue();
			if(uptimeReport=='Services')
			this.loadUptimeForServiceReportData(appConstants.publicJsonData);
			//
			else
			this.loadReportData(appConstants.publicJsonData);
			appConstants.isSubmit="false";
		}else{
			if(appConstants.isForceSubmit=='true') {
				appConstants.isForceSubmit='false';
				this.beforeFormSubmit();
			} 
		}
	},
	 changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJsonData.hiddenParams["favorite_id"];
		var from_schModify = appConstants.publicJsonData.hiddenParams["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (Ext.get('configMod')!=null)
		{
			Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		}
		
		var fromSchedule =appConstants.publicJsonData.hiddenParams['fromSchedule']; 
		if(!(fromSchedule!=null && fromSchedule=="Yes"))
			this.beforeFormSubmit();
	       
     },
	
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),Ext.getCmp('systemLabel').text,btn);
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		} 
		obj.toggleTriggger();
		if(appConstants.compFilterJSON==undefined)
		{
			appConstants.compFilterJSON = appConstants.publicJsonData['compFilterJSON'];
		}
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('components'),appConstants.compFilterJSON);
   },
	validateSettings :  function()
	{
		var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
		var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
		var timePeriodToHrs = Ext.getCmp('timeto').getValue();
		var timePeriodToMins = Ext.getCmp('minto').getValue();

		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		stDate.setHours(Ext.getCmp('er_sthr').getValue());
		enDate.setHours(Ext.getCmp('er_endhr').getValue());

		//Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		if(!checkTimePeriod(timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins))
		{
			return false;
		}

		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return false;
			}
		}
		 
		var reportgen = Ext.getCmp('reportGeneration').getValue();

		var getMaxDaysInMonth = appConstants.publicJsonData.hiddenParams["getMaxDaysInMonth"];
		//var startdate = Ext.Date.dateFormat(stDate, mgrDateFormat);
		//var enddate = Ext.Date.dateFormat(enDate, mgrDateFormat);
		
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData.hiddenParams["er_usertimeline"];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}

		var isSettingsOk = true;

		/*	var bgenabled = "";
		var bgenabledObj = Ext.getCmp("bgenabled");
		if(bgenabledObj!=null && bgenabledObj!="undefined")
		{
			bgenabled = bgenabledObj.getValue();
		}*/

		/*	if(bgenabled!=null && bgenabled.toLowerCase() =="yes")
		{*/
		if (reportgen!=null && (reportgen == 'background'||reportgen == 'background-csv'))
		{
				var reportNameObj = Ext.getCmp('bgReportName');
				var reportName = reportNameObj.getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					reportNameObj.focus();
					return false;
				}
		}

	//	}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		return true
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},	
	beforeFormSubmit: function()
	{
 		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		stDate.setHours(Ext.getCmp('er_sthr').getValue());
		enDate.setHours(Ext.getCmp('er_endhr').getValue());
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return;
			}
		}
		var isValidForm = this.validateForm();
		if(isValidForm)
		{
			var fromSchedule =appConstants.publicJsonData.hiddenParams['fromSchedule']; 
			if(fromSchedule!=null && fromSchedule=="Yes")
			{
				this.addTo(Ext.getCmp('scheduleImg'),null,'save');
			}
			else
			{
				var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
				if (isSettingsEnabled)
				{
					reportgen = Ext.getCmp('reportGeneration').getValue();
				}
				//if ( reportgen!=null && reportgen == 'foreground' )
				{
					var limitforbg = appConstants.publicJsonData.hiddenParams["limitforbg"];
					var getMaxDaysInMonth = appConstants.publicJsonData.hiddenParams["getMaxDaysInMonth"];
					var maxDaysInMonth = "0";
					var getButtonObj = Ext.getCmp('submit');
					if(!Ext.isEmpty(getMaxDaysInMonth))
					{
						maxDaysInMonth = getMaxDaysInMonth;
					}

					if(!Ext.isEmpty(limitforbg))
					{
						var bglimit = limitforbg;
						if(!checkTimeLineForBgLimit(bglimit,maxDaysInMonth,stDate,enDate))
						{
							Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						} else {
							this.formSubmit(getButtonObj);
						}
					} else {
							this.formSubmit(getButtonObj);
					}
				}
			}
		}
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
			Ext.get('configMod').animate({
				duration: 500,
					to: {
					y: -500
						}
					});	
					
			}
			this.formSubmit(getButtonObj);
		}			
		else
		{
			this.getReporterSettings().down('button').fireHandler();
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.show();
			reportNameObj.focus(false, 1000);
			reportNameObj.setValue('');
			validateTextBoxWithSpecialChars(reportNameObj.getValue(),'Attachment',true);
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
			return false;
		}
	},
	loadpageTitle:function(){
		this.getMain().setTitle('OPERATION REPORTS - UPTIME');
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.beforeFormSubmit();
			fromPageRefresh="false";
		}
		var thisController = this;
		
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	/* showExcludeWeekendOptions : function() {
		var excludeWeekendLbl=Ext.getCmp("excludeWeekendLbl");
		var isExcludeWeekEnd = Ext.getCmp('excludeWeekendsCombo').getValue();
		if(isExcludeWeekEnd == "Yes")
		{
			excludeWeekendLbl.show();
			excludeWeekendLbl.update(appConstants.publicJsonData.screenLabels['reporter.common.Excludes']);
		}
		else
		{
			excludeWeekendLbl.hide();
		}
	},	*/
	saveFile:function(){

		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();		
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var startHr = Ext.getCmp('er_sthr').dataArray;
		var endHr = Ext.getCmp('er_endhr').dataArray;

		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var chartOption = appConstants.publicJsonData.pageParams.er_show;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();

			chartOption = Ext.getCmp('chartOptionsCombo').getValue();
			chartOption = chartOption.replace(new RegExp("%", 'g'), "|pct|");

		}
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var report_Type = Ext.getCmp('report_Type').getValue();

		var er_type = "No";

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
		}

		if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
	    }

		var s_qryString="../reporter/ErHtmlToSavePdf.jsp?er_comptype="+compTypeVal+"&er_datafrom="+ReportForVal
						+"&er_type="+er_type+"&er_uptimetest="+uptimeReport+"&er_show_details="+er_show_details
						+"&startdate="+startdate+"&enddate="+enddate+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&timeto="+timePeriodToHrs+"&minto="+timePeriodToMins+"&starthr="+startHr+"&endhr="+endHr+"&er_timeline="+er_timeline + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+appConstants.iniDate+"&pgTittle=OPERATION&er_show="+appConstants.erUtils.specialCharEncode(chartOption);
		

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(serviceName);
		}
		var erUtils =  Ext.widget('erutils');
		erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();		
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var startHr = Ext.getCmp('er_sthr').dataArray;
		var endHr = Ext.getCmp('er_endhr').dataArray;
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var report_Type = Ext.getCmp('report_Type').getValue();
		var er_type = "No";
		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
		}

		if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
		}
		var s_qryString="er_comptype="+compTypeVal+"&er_datafrom="+ReportForVal
						+"&er_type="+er_type+"&er_uptimetest="+uptimeReport+"&er_show_details="+er_show_details
						+"&startdate="+startdate+"&enddate="+enddate+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&timeto="+timePeriodToHrs+"&minto="+timePeriodToMins+"&starthr="+startHr+"&endhr="+endHr+"&er_timeline="+er_timeline + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+appConstants.iniDate+"&pgTittle=OPERATION";
		var compArr = Ext.getCmp('components').getValue();
		/*if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				s_qryString += '&er_component='+encodeURIComponent(compArr[i]);
			}
		}*/
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(serviceName);
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var showByPriority = appConstants.publicJsonData.pageParams.priority;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		var sortBy = appConstants.publicJsonData.pageParams.sortby;
		var includeMaintenance = appConstants.publicJsonData.pageParams.includeMaintenancePeriod;
		var chartOption = appConstants.publicJsonData.pageParams.er_show;
		var excludeWeekEnd = appConstants.publicJsonData.pageParams.excludeweekend;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			excludeWeekEnd = Ext.getCmp('excludeWeekendsCombo').getValue();
			showByPriority = Ext.getCmp('showByPriority').getValue();
			reportgen = Ext.getCmp('reportGeneration').getValue();
			includeMaintenance = Ext.getCmp('includeMaintenanceCombo').getValue();
			chartOption = Ext.getCmp('chartOptionsCombo').getValue();
			sortBy = Ext.getCmp('sortByCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		chartOption = chartOption.replace(new RegExp("%", 'g'), "|pct|");
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var startHour = Ext.getCmp('er_sthr').dataArray;
		var endHour = Ext.getCmp('er_endhr').dataArray;
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		var report_Type = Ext.getCmp('report_Type').getValue();

		bookletquery+= '&er_uptimetest='+encodeURIComponent(uptimeReport)+'&er_datafrom='+encodeURIComponent(ReportForVal)
			+'&er_comptype='+encodeURIComponent(compTypeVal)+'&er_timeline='+encodeURIComponent(er_timeline)+'&er_option='+encodeURIComponent(ReportForVal);

		var er_type = "No";

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
			var graphMode = Ext.getCmp('er_mode').getValue();
			bookletquery+= "&er_mode="+graphMode;
		}

		if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
		}

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			bookletquery+= '&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			bookletquery+= '&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			bookletquery+= '&er_site='+encodeURIComponent(serviceName);
		}

		var compQStr = '';
		var er_combination = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				compQStr += '&er_component='+encodeURIComponent(compArr[i]);
				er_combination+=compArr[i]+"##";
			}
		}
		bookletquery+= "&er_type="+encodeURIComponent(er_type)+"&er_show_details="+encodeURIComponent(er_show_details)+"&startdate="+encodeURIComponent(startdate)
				+"&enddate="+encodeURIComponent(enddate)+"&starthr="+encodeURIComponent(startHour)+"&endhr="+encodeURIComponent(endHour)
				+"&er_maintenance="+encodeURIComponent(includeMaintenance)+"&er_show="+encodeURIComponent(chartOption)
				+"&timeto="+encodeURIComponent(timePeriodToHrs)+"&minto="+encodeURIComponent(timePeriodToMins)
				+"&er_excwe="+encodeURIComponent(excludeWeekEnd)+"&er_priority="+encodeURIComponent(showByPriority)
				+"&timefrom="+encodeURIComponent(timePeriodFromHrs)+"&minfrom="+encodeURIComponent(timePeriodFromMins)
				+"&er_reportgenration="+encodeURIComponent(reportgen)+"&er_sortby="+sortBy
				+"&er_combination="+encodeURIComponent(er_combination)+compQStr;	

		var hiddenQstr = this.getHiddenFieldValues(true);

		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			bookletquery+= hiddenQstr;
		}
			bookletquery+= '&forwardto=ErUptimeReportData';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	saveDataInCSVFormat  : function()
	{
		var uptimeReport = Ext.getCmp('uptimeReport').getValue()?"Yes":"No";
		var s_qryString = "../servlet/egurkha.reporter.SaveInCSVFormat?reporttype=uptime";
		var erUtils =  Ext.widget('erutils');
		erUtils.savePDF(s_qryString);
	},
	loadTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true	//booklet
			);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);		
		
	},
	hideTools:function(){
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);		
		Ext.getCmp("csvTool").setDisabled(true);		
		Ext.getCmp("upbutton").setDisabled(true);		
		Ext.getCmp("bookletTool").setDisabled(true);		
		Ext.getCmp("saveTool").setDisabled(true);		
	},
	enableTools : function()
	{
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);		
		Ext.getCmp("upbutton").setDisabled(false);		
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	printPageRender : function() {

		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();		
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var startHr = Ext.getCmp('er_sthr').dataArray;
		var endHr = Ext.getCmp('er_endhr').dataArray;
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var report_Type = Ext.getCmp('report_Type').getValue();

		var er_type = "No";

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
		}
		var s_qryString = "/final/reporter/ErUptimePrintData.jsp?er_comptype="+compTypeVal
		+"&er_datafrom="+ReportForVal+"&er_type="+er_type+"&er_uptimetest="+uptimeReport
		+"&er_show_details="+er_show_details+"&startdate="+startdate+"&enddate="+enddate
		+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&timeto="+timePeriodToHrs+"&minto="+timePeriodToMins+"&starthr="+startHr+"&endhr="+endHr+"&er_timeline="+er_timeline+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+appConstants.iniDate+"&pdfPrint=yes&pgTittle=OPERATION";

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(serviceName);
		}
			//parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
//printWindowFn.show(s_qryString);
        
		//var printContentDiv = Ext.get('printContentDiv');
		//printContentDiv.set( { src :  s_qryString });
	
    /* printWindow.on('show',function(){
       // var s_qryString = "YOUR QUERY"  //query string to load the popup
     var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
                    printContentDiv.set({
                        src: s_qryString
                    });
         });
         printWindow.show();*/
 



	},
	print:function()
	{
		//parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();		
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var startHr = Ext.getCmp('er_sthr').dataArray;
		var endHr = Ext.getCmp('er_endhr').dataArray;
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var report_Type = Ext.getCmp('report_Type').getValue();

		var er_type = "No";

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
		}
			if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
		}
var s_qryString="";

	if(uptimeReport=='Services')
		{
		s_qryString = "/final/reporter/ErServiceUptimePrintData.jsp?er_comptype="+compTypeVal
		+"&er_datafrom="+ReportForVal+"&er_type="+er_type+"&er_uptimetest="+uptimeReport
		+"&er_show_details="+er_show_details+"&startdate="+startdate+"&enddate="+enddate
		+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&timeto="+timePeriodToHrs+"&minto="+timePeriodToMins+"&starthr="+startHr+"&endhr="+endHr+"&er_timeline="+er_timeline + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+appConstants.iniDate+"&pdfPrint=yes&pgTittle=OPERATION";
		}
		else
		{
			s_qryString = "/final/reporter/ErUptimePrintData.jsp?er_comptype="+compTypeVal
		+"&er_datafrom="+ReportForVal+"&er_type="+er_type+"&er_uptimetest="+uptimeReport
		+"&er_show_details="+er_show_details+"&startdate="+startdate+"&enddate="+enddate
		+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&timeto="+timePeriodToHrs+"&minto="+timePeriodToMins+"&starthr="+startHr+"&endhr="+endHr+"&er_timeline="+er_timeline + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+appConstants.iniDate+"&pdfPrint=yes&pgTittle=OPERATION";

		}
		
		var chartOption = appConstants.publicJsonData.pageParams.er_show;
		if (isSettingsEnabled)
		{
			chartOption = Ext.getCmp('chartOptionsCombo').getValue();
			chartOption = chartOption.replace(new RegExp("%", 'g'), "|pct|");
		}
		//s_qryString+="&er_show="+encodeURIComponent(chartOption);
		s_qryString+="&er_show="+appConstants.erUtils.specialCharEncode(chartOption);

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			s_qryString = s_qryString+'&er_site='+encodeURIComponent(serviceName);
		}
		
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	includeOrExcludeSubzone: function()
	{
		var getZoneVal = Ext.getCmp('zone').getValue();
		if ( getZoneVal != '-1' )
		{
			var getCompObj = Ext.getCmp('components');
			this.selectZoneComponents();
		}
		else
		{
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	addTo :  function(btn, e, val)
	{
				// by karthikeyan
/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Operation Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		} */
		var btnID = btn.getId();
		var formButtonId=val;
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
		var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
		var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
		var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
		var showByPriority = appConstants.publicJsonData.pageParams.priority;
		var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
		var sortBy = appConstants.publicJsonData.pageParams.sortby;
		var includeMaintenance = appConstants.publicJsonData.pageParams.includeMaintenancePeriod;
		var chartOption = appConstants.publicJsonData.pageParams.er_show;
		var excludeWeekEnd = appConstants.publicJsonData.pageParams.excludeweekend;
		var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		if (isSettingsEnabled)
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			excludeWeekEnd = Ext.getCmp('excludeWeekendsCombo').getValue();
			showByPriority = Ext.getCmp('showByPriority').getValue();
			reportgen = Ext.getCmp('reportGeneration').getValue();
			includeMaintenance = Ext.getCmp('includeMaintenanceCombo').getValue();
			chartOption = Ext.getCmp('chartOptionsCombo').getValue();
			sortBy = Ext.getCmp('sortByCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		chartOption = chartOption.replace(new RegExp("%", 'g'), "|pct|");
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var startHour = Ext.getCmp('er_sthr').dataArray;
		var endHour = Ext.getCmp('er_endhr').dataArray;
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		var report_Type = Ext.getCmp('report_Type').getValue();

		var params = '&er_uptimetest='+encodeURIComponent(uptimeReport)+'&er_datafrom='+encodeURIComponent(ReportForVal)
			+'&er_comptype='+encodeURIComponent(compTypeVal)+'&er_timeline='+encodeURIComponent(er_timeline)+'&er_option='+encodeURIComponent(ReportForVal);

		var er_type = "No";

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
			var graphMode = Ext.getCmp('er_mode').getValue();
			params = params+"&er_mode="+graphMode;
		}

		if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
		}

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			params = params+'&er_site='+encodeURIComponent(zoneName);
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			params = params+'&er_site='+encodeURIComponent(segmentName);
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			params = params+'&er_site='+encodeURIComponent(serviceName);
		}
		var runningDurationBox = Ext.getCmp('runningDurationFilter');
		if(runningDurationBox.isVisible())
		{
			params+="&runningDurationVal="+Ext.getCmp('runningDuration').getValue();
			params+="&runningDurationFun="+Ext.getCmp('runningDurationFun').getValue();
			params+="&runningDurationUnit="+Ext.getCmp('runningDurationUnit').getValue();
		}
		var compQStr = '';
		var er_combination = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				compQStr += '&er_component='+encodeURIComponent(compArr[i]);
				er_combination+=compArr[i]+"##";
			}
		}
		params = params+"&er_type="+encodeURIComponent(er_type)+"&er_show_details="+encodeURIComponent(er_show_details)+"&startdate="+encodeURIComponent(startdate)
				+"&enddate="+encodeURIComponent(enddate)+"&starthr="+encodeURIComponent(startHour)+"&endhr="+encodeURIComponent(endHour)
				+"&er_maintenance="+encodeURIComponent(includeMaintenance)+"&er_show="+encodeURIComponent(chartOption)
				+"&timeto="+encodeURIComponent(timePeriodToHrs)+"&minto="+encodeURIComponent(timePeriodToMins)
				+"&er_excwe="+encodeURIComponent(excludeWeekEnd)+"&er_priority="+encodeURIComponent(showByPriority)
				+"&timefrom="+encodeURIComponent(timePeriodFromHrs)+"&minfrom="+encodeURIComponent(timePeriodFromMins)
				+"&er_reportgenration="+encodeURIComponent(reportgen)+"&er_sortby="+sortBy
				+"&er_combination="+encodeURIComponent(er_combination)+compQStr;	

		var hiddenQstr = this.getHiddenFieldValues(true);

		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			params = hiddenQstr+params;
		}

		if(reportgen=='background')
		{
			params = params+'&forwardto=ErUptimeReportDataJson';
		}
		else
		{
			params = params+'&forwardto=ErUptimeReportData';
		}
		var target = "";  
		var windowClass;
		var frameId;
		//var from_schedule = appConstants.publicJsonData.hiddenParams["fromScheduleModify"];
		if ((btnID != null && btnID == 'scheduleImg') || (appConstants.fromScheduleModify != null && appConstants.fromScheduleModify == "Yes")) {
			
			target = "/final/reporter/ErSaveSchedule.jsp?" + params +"&com.eg.CSRF_NONCE="+csrfToken;
			if (btnID=='save')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
			{
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}

		/*	scheduleWindow.on('show',function(){
		var schContentDiv = parent.Ext.select('#schWin1');  // id of the popup window
						schContentDiv.set({
							src: url
						});
		  });
         scheduleWindow.show();*/
		} else {
			
			var favorite_id = appConstants.publicJsonData.hiddenParams["favorite_id"];
			target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&cmd=client&" + params+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken; //+"&FavoriteId="+favorite_id;
             if (btnID=="save")
			{
				//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id+'&fromFavoriteModify='+appConstants.fromFavoriteModify;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
					});
			}
			else
			{
              parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
			}

			/*favouriteWindow.on('show',function(){
			var favContentDiv = parent.Ext.select('#favWin1');  // id of the popup window
							favContentDiv.set({
								src: url
							});
			  });
			 favouriteWindow.show();*/
		}
		//var target = url;  
	//	Ext.widget(windowClass).show();
		//Ext.select(frameId).set({src :target});
	},
	validateForm : function()
	{
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
	
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		
		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();
			if(zoneName!=null && zoneName=="-1" || zoneName==""   || zoneName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: appConstants.noZoneMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			if(segmentName!=null && segmentName=="-1" || segmentName==""  || segmentName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: appConstants.noSegmentMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			if(serviceName!=null && serviceName=="-1" || serviceName=="" || serviceName=="NotApplicable")
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: appConstants.noServiceMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		if(compArr!=null && compArr=="-1" || compArr=="" || compArr=="NotApplicable")
		{
			Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: appConstants.noComponentMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
			return false;
		}
		
		var runningDurationBox = Ext.getCmp('runningDurationFilter');
		if(runningDurationBox.isVisible())
		{
			var runningDuration = Ext.getCmp('runningDuration').getValue();
			var runningDurationFun = Ext.getCmp('runningDurationFun').getValue();
			var runningDurationUnit = Ext.getCmp('runningDurationUnit').getValue();
			if(runningDurationFun==undefined || runningDurationFun=='')
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: 'Please Choose Running From value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			if(runningDuration==undefined || runningDuration=='')
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: 'Please enter the valid Duration',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
			if(runningDurationUnit==undefined || runningDurationUnit=='')
			{
				Ext.MessageBox.show({
						title: 'Operation Uptime',
						msg: 'Please Choose Valid data for Duration Measure',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}
		return true;
		
	},
	updateQueryString: function(ctrlObjId)
	{
		var isSubmit = false;

		if(ctrlObjId!=null && ctrlObjId=="submit")
			isSubmit = true;

	
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();		
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if(!isSettingsEnabled)
		{
			var timePeriodFromHrs = appConstants.publicJsonData.pageParams.selectHrsFrom;
			var timePeriodFromMins = appConstants.publicJsonData.pageParams.selectMinsFrom;
			var timePeriodToHrs = appConstants.publicJsonData.pageParams.selectHrsTo;
			var timePeriodToMins = appConstants.publicJsonData.pageParams.selectMinsTo;
			var showByPriority = appConstants.publicJsonData.pageParams.priority;
			var reportgen = appConstants.publicJsonData.pageParams.er_reportgenration;
			var sortBy = appConstants.publicJsonData.pageParams.sortby;
			var includeMaintenance = appConstants.publicJsonData.pageParams.includeMaintenancePeriod;
			var chartOption = appConstants.publicJsonData.pageParams.er_show;
			var excludeWeekEnd = appConstants.publicJsonData.pageParams.excludeweekend;
			var er_show_details = appConstants.publicJsonData.pageParams.showDetails;
		}
		//if (isSettingsEnabled)
		else
		{
			er_show_details = Ext.getCmp('showdetailsCombo').getValue();
			excludeWeekEnd = Ext.getCmp('excludeWeekendsCombo').getValue();
			showByPriority = Ext.getCmp('showByPriority').getValue();
			reportgen = Ext.getCmp('reportGeneration').getValue();
			includeMaintenance = Ext.getCmp('includeMaintenanceCombo').getValue();
			chartOption = Ext.getCmp('chartOptionsCombo').getValue();
			sortBy = Ext.getCmp('sortByCombo').getValue();
			timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			timePeriodToHrs = Ext.getCmp('timeto').getValue();
			timePeriodToMins = Ext.getCmp('minto').getValue();
		}
		chartOption = chartOption.replace(new RegExp("%", 'g'), "|pct|");
		var startdate = Ext.getCmp('er_stdate').dataArray;
		var enddate = Ext.getCmp('er_enddate').dataArray;
		var startHour = Ext.getCmp('er_sthr').dataArray;
		var endHour = Ext.getCmp('er_endhr').dataArray;
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		var report_Type = Ext.getCmp('report_Type').getValue();

		var er_type = "No";

		var paramsForCompChange = '&er_uptimetest='+uptimeReport+'&er_datafrom='+ReportForVal
			+'&er_comptype='+compTypeVal+'&er_timeline='+er_timeline+'&er_option='+ReportForVal;

		if(report_Type!=null && report_Type.toLowerCase()=="graph")
		{
			er_type= "Yes";
			var graphMode = Ext.getCmp('er_mode').getValue();
			paramsForCompChange = paramsForCompChange+"&er_mode="+graphMode;
		}
		if(report_Type!=null && report_Type.toLowerCase()=="overview")
		{
			er_type= "overview";
		}

		if ( ReportForVal == 'Zone' )
		{
			var zoneName = Ext.getCmp('zone').getValue();

			paramsForCompChange = paramsForCompChange+'&er_site='+zoneName;
		}
		else if ( ReportForVal == 'Segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			
			paramsForCompChange = paramsForCompChange+'&er_site='+segmentName;
		}
		else if ( ReportForVal == 'Service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			
			paramsForCompChange = paramsForCompChange+'&er_site='+serviceName;
		}
		var compQStr = '';
		var er_combination = '';
		var divQstr = '';
		if(compArr!=null && (compArr!="" && compArr!="null"))
		{
			for ( var i = 0; i < compArr.length; i++ )
			{
				compQStr += '&er_component='+compArr[i];
				divQstr += '&divQstr=img_'+i;
				er_combination+=compArr[i]+"##";
			}
		}

		paramsForCompChange = paramsForCompChange+"&er_type="+er_type+"&er_show_details="+er_show_details+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&er_maintenance="+includeMaintenance
								+"&er_show="+encodeURIComponent(chartOption)+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&er_priority="+showByPriority+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&er_reportgenration="+reportgen
								+"&er_sortby="+sortBy;
		if(isSubmit)
		{
			if(uptimeReport=='Services')
				paramsForCompChange+=divQstr;

			var hiddenQstr = this.getHiddenFieldValues(false);
			if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
			{
				paramsForCompChange = hiddenQstr+paramsForCompChange;
			}
			if ( reportgen!=null && reportgen == 'background' )
			{
				selectedReportGen = 'background';
				var reportName = Ext.getCmp('bgReportName').getValue();
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&bg_reportname="+reportName+'&forwardto=ErUptimeReportDataJson';
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC";
			}
			else if (reportgen!=null && reportgen == 'background-csv' )
			{
				selectedReportGen = 'background-csv';
				var reportName = Ext.getCmp('bgReportName').getValue();
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&bg_reportname="+reportName+'&forwardto=ErUptimeReportDataJson';
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			}
			else
			{
				selectedReportGen = 'foreground';
				paramsForCompChange = paramsForCompChange+'&forwardto=ErUptimeReportData';
				appConstants.urlForSubmit = "../servlet/com.eg.ErUptimeServletC";
			}
			if((selectedReportGen!=null && (selectedReportGen == "background"||selectedReportGen == "background-csv")) ||(uptimeReport!='Services' ))
				paramsForCompChange = paramsForCompChange+"&er_combination="+er_combination+compQStr;
//	
		}
		var runningDurationBox = Ext.getCmp('runningDurationFilter');
		if(runningDurationBox.isVisible())
		{
			paramsForCompChange+="&runningDurationVal="+Ext.getCmp('runningDuration').getValue();
			paramsForCompChange+="&runningDurationFun="+Ext.getCmp('runningDurationFun').getValue();
			paramsForCompChange+="&runningDurationUnit="+Ext.getCmp('runningDurationUnit').getValue();
		}
		paramsForCompChange+="&er_RmDispName="+appConstants.er_RmDispName;

		queryString = paramsForCompChange;

	},
	loadReportData : function(jsonData)
	{
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var dataAvailable = jsonData.dataAvailable;
		var uptimeResultPanel = Ext.getCmp("uptimeResultPanel");
		var backgrdResultPanel = Ext.getCmp("backGroundPanel");
		var mainHeaderTitle = "<div class='font_bold' style='padding:4px 0px 0px 0px'>"+jsonData.screenLabels['Details_Table_Title']+"</div>";
		var mainResultPanel = this.getOperationuptimesubmitteddata();
		var mainRPOverview = this.getOperationUptimeSubmittedDataForOverview();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();
		var compText = 'Components';
		if(uptimeReport=='Network Devices')
		{
			compText = 'Devices';
		}



		if(selectedReportGen!=null && selectedReportGen == "background")
		{
			mainResultPanel.show();
			uptimeResultPanel.hide();
			Ext.getCmp("bookletTool").setDisabled(false);
			mainRPOverview.hide();
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);
			Ext.getCmp("favoriteTool").setDisabled(false);
			Ext.getCmp("upbutton").setDisabled(false);

			Ext.getCmp("bgReportName").setValue(jsonData.pageParams['bg_reportname']);
			Ext.getCmp("bgReportName").show();

			var bgGroundMsg = jsonData.pageParams['bgGroundMsg'];
			var status = jsonData.pageParams['status'];
			var langSupportString = jsonData.pageParams['bckGrdSaveMsg'];
			var bgReportUrl = jsonData.pageParams['bckGrdSaveURL'];
			var bglinkMsg = jsonData.pageParams['bglinkMsg'];
		
			uptimeResultPanel.hide();
			backgrdResultPanel.show();

			var analyzeByObj = Ext.getCmp("analyzeBy");
			var analyzeByStore = analyzeByObj.getStore();
			var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
			var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');

			var compType = Ext.getCmp("compType");
			var compTypeStore = compType.getStore();
			var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
			var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');

			var showByPriorityObj = Ext.getCmp("showByPriority");
			var showByPriorityStore = showByPriorityObj.getStore();
			var showByPriorityIdx= showByPriorityStore.find("valueField",showByPriorityObj.getValue());
			var showByPriority = showByPriorityStore.getAt(showByPriorityIdx).get('displayField');

			var sortByObj = Ext.getCmp("sortByCombo");
			var sortByStore = sortByObj.getStore();
			var sortByIdx= sortByStore.find("valueField",sortByObj.getValue());
			var sortBy = sortByStore.getAt(sortByIdx).get('displayField');

			var startdate = Ext.getCmp('er_stdate').dataArray;
			var enddate = Ext.getCmp('er_enddate').dataArray;
			var startHour = Ext.getCmp('er_sthr').dataArray;
			var endHour = Ext.getCmp('er_endhr').dataArray;

			var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			var timePeriodToHrs = Ext.getCmp('timeto').getValue();
			var timePeriodToMins = Ext.getCmp('minto').getValue();

			var excludeWeekendsComboObj = Ext.getCmp("excludeWeekendsCombo");
			var excludeWeekendStore = excludeWeekendsComboObj.getStore();
			var excludeWeekendIdx= excludeWeekendStore.find("valueField",excludeWeekendsComboObj.getValue());
			var excludeWeekend = excludeWeekendStore.getAt(excludeWeekendIdx).get('displayField');
			
			//var htmlStr = "<div style='text-align:center;margin-top:50px'>";
			

			var statusCssClass='iconSuccess';
			if(status != null && (status == "duplicate" || status == "exceedLimit"))
			{
				statusCssClass = 'iconExclamation';
			}

			var htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bglinkMsg + '</a></div></td></tr></table></td></tr></table>';


			//htmlStr +='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+ langSupportString + '</b>.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bglinkMsg + '</a></div></div></center>';

			var resultObj = this.getBackGroundPanel();
			resultObj.update(htmlStr);
			resultObj.doLayout();
			resultObj.show();
		}
		else if(selectedReportGen!=null && selectedReportGen == "background-csv")
		{
			mainResultPanel.show();
			uptimeResultPanel.hide();
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);
			Ext.getCmp("favoriteTool").setDisabled(false);
			Ext.getCmp("bgReportName").setValue(jsonData.pageParams['bg_reportname']);
			Ext.getCmp("bgReportName").show();
			var bgGroundMsg = jsonData.pageParams['bgGroundMsg'];
			var status = jsonData.pageParams['status'];
			var langSupportString = jsonData.pageParams['bckGrdSaveMsg'];
			var bgReportUrl = jsonData.pageParams['bckGrdSaveURL'];
			var bglinkMsg = jsonData.pageParams['bglinkMsg'];
		
			uptimeResultPanel.hide();
			backgrdResultPanel.show();

			var analyzeByObj = Ext.getCmp("analyzeBy");
			var analyzeByStore = analyzeByObj.getStore();
			var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
			var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');

			var compType = Ext.getCmp("compType");
			var compTypeStore = compType.getStore();
			var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
			var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');

			var showByPriorityObj = Ext.getCmp("showByPriority");
			var showByPriorityStore = showByPriorityObj.getStore();
			var showByPriorityIdx= showByPriorityStore.find("valueField",showByPriorityObj.getValue());
			var showByPriority = showByPriorityStore.getAt(showByPriorityIdx).get('displayField');

			var sortByObj = Ext.getCmp("sortByCombo");
			var sortByStore = sortByObj.getStore();
			var sortByIdx= sortByStore.find("valueField",sortByObj.getValue());
			var sortBy = sortByStore.getAt(sortByIdx).get('displayField');

			var startdate = Ext.getCmp('er_stdate').dataArray;
			var enddate = Ext.getCmp('er_enddate').dataArray;
			var startHour = Ext.getCmp('er_sthr').dataArray;
			var endHour = Ext.getCmp('er_endhr').dataArray;

			var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			var timePeriodToHrs = Ext.getCmp('timeto').getValue();
			var timePeriodToMins = Ext.getCmp('minto').getValue();

			var excludeWeekendsComboObj = Ext.getCmp("excludeWeekendsCombo");
			var excludeWeekendStore = excludeWeekendsComboObj.getStore();
			var excludeWeekendIdx= excludeWeekendStore.find("valueField",excludeWeekendsComboObj.getValue());
			var excludeWeekend = excludeWeekendStore.getAt(excludeWeekendIdx).get('displayField');
			
			//var htmlStr = "<div style='text-align:center;margin-top:50px'>";

			var statusCssClass='iconSuccess';
			if(status != null && (status == "duplicate" || status == "exceedLimit"))
			{
				statusCssClass = 'iconExclamation';
			}
			 var htmlStr ='<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bglinkMsg + '</a></div></td></tr></table></td></tr></table>';

			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			resultObj.update(htmlStr);
			resultObj.doLayout();
			resultObj.show();
		}

		else
		{
            var reportType = jsonData.pageParams.er_type;
			uptimeResultPanel.removeAll();
			if(reportType!= 'overview'){
			//mainResultPanel.setTitle(mainHeaderTitle);
			//mainResultPanel.getHeader().show();
			uptimeResultPanel.show();
		}else{
			uptimeResultPanel.show();
			mainResultPanel.hide();
		}
			backgrdResultPanel.hide();
			if(dataAvailable!=null && dataAvailable=="true")
			{
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);

               
				if(reportType!= 'overview')
					mainResultPanel.show();
				this.getNomeasurepanel().hide();
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);		
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				var reportType = jsonData.pageParams.er_type;
				if(reportType!=null && reportType=="Yes") // graph report
				{
                 	mainRPOverview.hide();
					Ext.getCmp("csvTool").setDisabled(true);
					var html='<div class="graphMainDiv"><div  style="height:375px;width:100%" id="uptimeGraphDiv"></div></div>';
					uptimeResultPanel.add({
						xtype: 'panel',
						margin:'10 10 0 10',
						ui:'newGraphPanel',
						autoScroll:true,
						title:jsonData.screenLabels['Details_Table_Title'],
						html: html
					});
				var graphHeight = jsonData.pageParams.graphHeight;
					
				if(appConstants.chartType=='fusionchart')
					{
						if (FusionCharts("chart2Id" )) 
							FusionCharts("chart2Id").dispose(); 
						var chart2 = new FusionCharts(jsonData.chartData.swfPath, "chart2Id", "100%", graphHeight, "0", "1");
						chart2.setDataXML(jsonData.chartData.xmlData);
						chart2.setTransparent(true);
						chart2.render("uptimeGraphDiv");
					}
 					else if(appConstants.chartType=='highchart')
					{
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('uptimeGraphDiv',jsonData.chartData.chartHeight,jsonData.chartData.chartWidth+100), lineChart);
						lineChart.setData(jsonData.chartData,'<%=currentDateFormat%>','');
						lineChart.drawChart();
					}
				}
				else if(reportType!=null && reportType=="No") // data report
				{
					mainRPOverview.hide();
					//var html='<table class="newTable" style="width:100%;margin:0px 10px 10px 10px"><tr><td align="center" valign="top"><div id="uptimeGraphDiv"></div><div id="uptimeDataDiv"></div></td</tr></table>';

					var html='<div ><table  width="100%"><tr><td align="center" valign="top"><div id="uptimeGraphDiv"></div><div id="uptimeDataDiv" style="margin:0px 10px 10px 10px" class="newTable"></div></td</tr></table></div>';
					uptimeResultPanel.add({
						xtype: 'panel',
						ui:'newGraphPanel',
						title:jsonData.screenLabels['Details_Table_Title'],
						//margin:0,
						margin:'10 10 10 10',
						//bodyPadding:0,
						html: html
					});
					var uptimeReport = Ext.getCmp('uptimeReport').getValue();
					var uptimeDataDiv = Ext.get("uptimeDataDiv");
					Ext.getCmp("csvTool").setDisabled(false);
					var canShowDetails = jsonData['canShowDetails'];

					var analyzeByObj = Ext.getCmp("analyzeBy");
					var analyzeByStore = analyzeByObj.getStore();
					var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
					var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');

					var compType = Ext.getCmp("compType");
					var compTypeStore = compType.getStore();
					var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
					var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');

					var htmlStr ="<table cellspacing='0' cellpadding='0' border='0' width='100%'>"
					+ "<thead>"
					+ "<tr>"
						+ '<th style="text-align:left; vertical-align: middle;width:240px;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Server"]+'</div>'
						+'</th>';
						if(uptimeReport!=undefined && uptimeReport=='Systems')
						{
							htmlStr+= '<th style="text-align:left; vertical-align: middle;">'
							+'<div>'+jsonData.screenLabels["reporter.uptime.Running since"]+'<br><span style="text-transform:none !important;">'+jsonData.screenLabels["reporter.uptime.Uptime (yMdhm)"]+'</span></div>'
							+'</th>';
						}
						htmlStr+= '<th style="text-align:left; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Uptime"]+'<br><span style="text-transform:none !important;">'+jsonData.screenLabels["reporter.uptime.Uptime (yMdhm)"]+'</span></div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.% Uptime"]+'</div>'
						+'</th>'
						+ '<th style="text-align: left; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Downtime"]+'<br><span style="text-transform:none !important;">'+jsonData.screenLabels["reporter.uptime.Downtime (yMdhm)"]+'</span></div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.% Downtime"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Reboots"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;width:60;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Details"]+'</div>'
						+'</th>'
					+ "</tr>"
					+ "</thead>"
					+ "<tbody>";
					var dataTable  = jsonData.dataTable;
					if(!Ext.isEmpty(dataTable))
					{
						
						for(var uptimeInfo in dataTable)
						{
							var uptimeData = dataTable[uptimeInfo];
							htmlStr += "<tr>"
									   +"<td style='width:240px'><div style='text-align:left;'>"+uptimeData.component+"</div></td>";
									   if(uptimeReport!=undefined && uptimeReport=='Systems')
									   {
										   htmlStr+="<td><div style='text-align:left;'>"+uptimeData.runningSince+"</div></td>";									   
									   }
									   htmlStr+="<td><div style='text-align:left;'>"+uptimeData.uptime+"</div></td>"
									   +"<td><div style='text-align:center;'>"+this.getDecimalAlignFormat(uptimeData.uptimePercent)+"</div></td>" 
									   +"<td><div style='text-align:left;' >"+uptimeData.downTime+"</div></td>"  
									   +"<td><div style='text-align:center;'>"+this.getDecimalAlignFormat(uptimeData.downTimePercent)+"</div></td>" 
									   +"<td style='width:90px'><div style='text-align:center;'>"+this.getDecimalAlignFormat(uptimeData.reBoots)+"</div></td>";


							if(uptimeData.hasOwnProperty('detailsLink'))
							{
								if(uptimeData.detailsLink=="NOLINK")
								{
									htmlStr +="<td><div style='text-align:center;' >&nbsp;-&nbsp;</div></td>";
								}
								else
								{
									htmlStr +="<td><div align='center' style='cursor:pointer;padding:4px'><div><img src='../images/spacer.gif' class='iconDetailedList' border='0px' style='display:block;' onClick='javascript:openInGraphWin(\""+uptimeData.detailsLink+"\");'></div></div></td>";
								}
							}
							else
							{
								htmlStr +="<td><div >&nbsp;-&nbsp;</div></td>";
							}

									   htmlStr +="</tr>";
						}
					}
					
					 htmlStr += "</tbody>"
					 htmlStr += "</table>"
					 htmlStr +="<div style='font-size:12px;padding:8px;'><div style='float:left;'>"+jsonData.screenLabels['reporter.uptime.y - year, M - month, d - day, h - hour, m - min']+"</div></div>";

					if(canShowDetails!=null && canShowDetails=="true")
					{
						htmlStr+= "<br><br><div class='newTable'>"
						+ "<table cellspacing='0' cellpadding='0' border='0' width='100%'>"
						+ "<thead>"
						+ "<tr>"
						+ '<th style="text-align:left; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Server"]+'</div>'
						+'</th>'
						+ '<th style="text-align:center; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Shutdown At"]+'</div>'
						+'</th>'
						+ '<th style="text-align:center; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Rebooted At"]+'</div>'
						+'</th>'
						+ '<th style="text-align:center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Downtime"]+"<br>("+jsonData.screenLabels["reporter.uptime.mins"]+")* </div>"
						+'</th>'
						+ '<th style="text-align:center; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.UptimeBeforeReboot"]+'<br><span style="text-transform:none !important;">('+jsonData.screenLabels["reporter.uptime.yMdhm"]+")* </span></div>"
						+'</th>'
						+ "</tr>"
						+ "</thead>"
						+ "<tbody>";
						var detailsData  = jsonData.detailsData;
						if(!Ext.isEmpty(detailsData))
						{
							
							for(var rebootInfo in detailsData)
							{
								var rebootData = detailsData[rebootInfo];
								htmlStr += "<tr>"
										   +"<td style='width:240px;text-align:left'><div >"+rebootData.component+"</div></td>" 
										   +"<td style='text-align:center'><div >"+rebootData.shutDownAt+"</div></td>"
										   +"<td style='text-align:center'><div >"+rebootData.reBootAt+"</div></td>" 
										   +"<td style='text-align:center'><div >"+rebootData.downTime+"</div></td>"  
										   +"<td style='text-align:center'><div >"+rebootData.uptimeBeforeReBoot+"</div></td></tr>";
							}
						}
//								htmlStr +="<tr><td></td><td colspan='5'>"+jsonData.screenLabels['reporter.uptime.y - year, M - month, d - day, h - hour, m - min']+"</td></tr>"
						htmlStr += "</tbody>"
						htmlStr += "</table>";
					}
					uptimeDataDiv.update(htmlStr);
				}else{ //For Overview Start

                     mainRPOverview.show();
					uptimeResultPanel.hide();
					var uptimeRPOverview = Ext.getCmp("uptimeResultPanelOverview");
					uptimeRPOverview.show();
					uptimeRPOverview.removeAll();

					console.log('<< uptimeRPOverview >>>>>>',uptimeRPOverview);
					//uptimeRPOverview.removeAll();
					var dataTemp={
						//xtype:'panel',
						xtype:'container',
						title:'Overview',
						//cls:'selectionDetailsBorder selectionDetailsBg',
						//padding:'0 0 2 0',
						border:true,
						margin:0,
						layout:{
							type:'vbox',
							align:'stretch'
						},
						items:[
							{
								xtype:'panel',
								flex:1,
								frame:false,
								title:'Overview',
								margin:'10 10 10 10',
								ui:'newGraphPanel',
								layout:{
									type:'hbox',
									align:'center'
								},
								defaults:{
									minWidth:180,
									margin:'0 0 5 0',
									//height:100,
									flex:1,
									//cls:'smallIconBox',
									layout:{
										type:'column',
										align:'center',
									},
								},
								items:[{
									xtype:'container',
									align:'center',
									autoSize: true,
									layout: {
										type: 'table',
										columns:1,
										align:'center',
										border:false,
										tableAttrs: {
											style: {
												align:'center',
												margin:'auto auto',
											}
										},
										tdAttrs:{
											style:{
												textAlign:'center',
												padding:'0px 0px 5px 0px'
											}
										}
									},
									defaults: {
											bodyStyle: {'padding':'5px','background':'transparent !important'},
											align:'center',
											xtype:'container',
									},
									items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconServerGray"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+jsonData.overviewData['totalNoOfServers']+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">Total number of '+compText+'</span>',
									}]

								},{
									xtype:'container',
									align:'center',
									autoSize: true,
									layout: {
										type: 'table',
										columns:1,
										align:'center',
										tableAttrs: {
											style: {
												align:'center',
												margin:'auto auto',
											}
										},
										tdAttrs:{
											style:{
												textAlign:'center',
												padding:'0px 0px 5px 0px'
											}
										}
									},
									defaults: {
										bodyStyle: {'padding':'5px','background':'transparent !important'},
										align:'center',
										xtype:'container',
									},
									items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconUpGreen" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+jsonData.overviewData['fullUptimeServerCount']+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">'+compText+' with no downtime</span>',
									}]
								},{
									xtype:'container',
									align:'center',
									autoSize: true,
									layout: {
										type: 'table',
										columns:1,
										align:'center',
										tableAttrs: {
											style: {
												align:'center',
												margin:'auto auto',
											}
										},
										tdAttrs:{
											style:{
												textAlign:'center',
												padding:'0px 0px 5px 0px'
											}
										}
									},
									defaults: {
										bodyStyle: {'padding':'5px','background':'transparent !important'},
										align:'center',
										xtype:'container',
									},
									items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconDownRed"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+jsonData.overviewData['downtimeServerCount']+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">'+compText+' with downtime</span>',
									}]
								},{
									xtype:'container',
									align:'center',
									autoSize: true,
									layout: {
										type: 'table',
										columns:1,
										align:'center',
										tableAttrs: {
											style: {
												align:'center',
												margin:'auto auto',
											}
										},
										tdAttrs:{
											style:{
												textAlign:'center',
												padding:'0px 0px 5px 0px'
											}
										}
									},
									defaults: {
										bodyStyle: {'padding':'5px','background':'transparent !important'},
										align:'center',
										xtype:'container',
									},
									items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconDownRed"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+jsonData.overviewData['avgDownTimeMin']+(jsonData.overviewData['avgDownTimeMin']=='0'?'<span class="newFont_normal13"> mins</span>':' <span class="newFont_normal13">mins</span>')+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">Average downtime</span>',
									}]
								}]
							}]
					};
						uptimeRPOverview.show();
					uptimeRPOverview.add(dataTemp);
				 //  uptimeResultPanel2.show();

				
				 //
				   var content='<div style="width:100%"><table class="htmlGraphTable" width="100%"  style="border:0px;background-color:transparent"><col width="50%"><col width="50%"><tr>';
					content+='<td style="padding:0px 5px 0px 0px">';

					content+='<div width="100%" class="graphMainDiv" >';
					content+='<div class="htmlGraphTableHeader">';
					content+='Top 10 '+compText+' ' +((jsonData.isLowUptimeNotServerFound)?'':' by')+' Downtime';
					content+='</div>';
					content+='<div id="leftChartContent" style="height:305px;width:100% !important;overflow:auto;padding:0px" class="htmlGraphTableBody">';
					//content+='<div class="technique-four"></div>';
					content+='</div>';
					content+='</div></td>';


					content+='<td style="padding:0px 0px 0px 5px">';
					content+='<div width="100%" class="graphMainDiv">';
					content+='<div class="htmlGraphTableHeader">';
					content+='Overall Uptime/Downtime';
					content+='</div>';
					content+='<div id="rightChartContent" style="height:305px;width:100% !important;overflow:auto;padding:0px" class="htmlGraphTableBody">';
					content+='</div>';
					content+='</div></td>';
					content+='</tr></table></div>';
                   uptimeRPOverview.add(
					{
						xtype: 'container',
						flex:1,
						margin:'0 10 10 10',
						html:content,
					});

                   
				   if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					}

                  
				//  appConstants.erUtils.updatePieChart('highchart',distChartData.LEGENDS.LEGEND_LINKS,'COLOR','LINK','LABEL',distChartData.TITLE,distChartData.XMLDATA,distChartData.SWF_PATH,distChartData,Ext.getCmp('rightChartContent'));

                  //  appConstants.erUtils.updatePieChart('highchart',distChartData.LEGENDS.LEGEND_LINKS,'COLOR','LINK','LABEL',chartTitle,xmlData,swfPath,jsonData.overviewPieChat,Ext.getCmp('leftChartContainer'));


	                var lineChart = {};
					lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('leftChartContent',jsonData.overviewLineChat.chartHeight,600), lineChart);
					lineChart.setData(jsonData.overviewLineChat,'<%=currentDateFormat%>','');
					lineChart.drawChart();

                    var highChart_pie = {};
					highChart_pie = jQuery.extend(true, {}, getHighChartsBarInstance('rightChartContent',300,600), highChart_pie);
					highChart_pie.setData(jsonData.overviewPieChat,'<%=currentDateFormat%>','');
					highChart_pie.drawChart();


				}//overview End

			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			}
			else
			{
                                 var uptimeRPOverview = Ext.getCmp("uptimeResultPanelOverview");
				   uptimeRPOverview.removeAll();
				   uptimeRPOverview.hide();
				uptimeResultPanel.hide();
				mainResultPanel.hide();
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				this.hideTools();
				if(reportType!=null && reportType=="Yes") // graph report
				{
					
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
				}
				else
				{
					
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
				}
			}
		}
	},
	loadUptimeForServiceReportData : function(jsonData)
	{
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var uptimeResultPanel = Ext.getCmp("uptimeResultPanel");
		var dataAvailable = jsonData.dataAvailable;
		//var mainHeaderTitle = "<span class='font_bold'>"+jsonData.screenLabels['Details_Table_Title']+"</span>";
				//var mainHeaderTitle = "<span class='font_bold'>"+'Services Uptime Report For Citrix NetScaler'+"</span>";
				//var mainHeaderTitle = 'Services Uptime Report For Citrix NetScaler';
				var mainHeaderTitle = 'Uptime of NetScaler by virtual servers';

		var mainResultPanel = this.getOperationuptimesubmitteddata();
		 		var getComboVal = Ext.getCmp('analyzeBy').getValue();
		if(selectedReportGen!=null && selectedReportGen == "background")
		{
			//
  			loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
			loadMask.show();
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: "responseType=Json&isSubmit=true&"+queryString,
				async:true,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(Ext.isEmpty(jsonText))
					{										
						Ext.getCmp("uptimeResultPanel").hide();	
						loadMask.hide();
						this.getNomeasurepanel().show();
						Ext.getCmp("backGroundPanel").hide();
						Ext.getCmp('panelinsidetoggle').setDisabled(true);
					}
					else
					{
						var jsonData=Ext.decode(jsonText);					
						loadMask.hide();
						//
						//mainResultPanel.show();
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						Ext.getCmp("favoriteTool").setDisabled(false);
						Ext.getCmp("upbutton").setDisabled(false);
						Ext.getCmp("bgReportName").setValue(jsonData.pageParams['bg_reportname']);
						Ext.getCmp("bgReportName").show();
						var bgGroundMsg = jsonData.pageParams['bgGroundMsg'];
						var status = jsonData.pageParams['status'];
						var langSupportString = jsonData.pageParams['bckGrdSaveMsg'];
						var bgReportUrl = jsonData.pageParams['bckGrdSaveURL'];
						var bglinkMsg = jsonData.pageParams['bglinkMsg'];
						uptimeResultPanel.hide();
						var analyzeByObj = Ext.getCmp("analyzeBy");
						var analyzeByStore = analyzeByObj.getStore();
						var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
						var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');
						var compType = Ext.getCmp("compType");
						var compTypeStore = compType.getStore();
						var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
						var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');
						var showByPriorityObj = Ext.getCmp("showByPriority");
						var showByPriorityStore = showByPriorityObj.getStore();
						var showByPriorityIdx= showByPriorityStore.find("valueField",showByPriorityObj.getValue());
						var showByPriority = showByPriorityStore.getAt(showByPriorityIdx).get('displayField');
						var sortByObj = Ext.getCmp("sortByCombo");
						var sortByStore = sortByObj.getStore();
						var sortByIdx= sortByStore.find("valueField",sortByObj.getValue());
						var sortBy = sortByStore.getAt(sortByIdx).get('displayField');
						//var startdate = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
						//var enddate = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
						var startdate = Ext.getCmp('er_stdate').dataArray;
						var enddate = Ext.getCmp('er_enddate').dataArray;
						var startHour = Ext.getCmp('er_sthr').dataArray;
						var endHour = Ext.getCmp('er_endhr').dataArray;
						var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
						var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
						var timePeriodToHrs = Ext.getCmp('timeto').getValue();
						var timePeriodToMins = Ext.getCmp('minto').getValue();
						var excludeWeekendsComboObj = Ext.getCmp("excludeWeekendsCombo");
						var excludeWeekendStore = excludeWeekendsComboObj.getStore();
						var excludeWeekendIdx= excludeWeekendStore.find("valueField",excludeWeekendsComboObj.getValue());
						var excludeWeekend = excludeWeekendStore.getAt(excludeWeekendIdx).get('displayField');
						var htmlStr = "<div style='text-align:center;margin-top:50px'>";

						var statusCssClass='iconSuccess';
						if(status != null && (status == "duplicate" || status == "exceedLimit"))
						{
							//htmlStr += "<img src=\"/final/reporter/images/"+reporter_Skin+"/exclamation-icon.gif\"><br>";
							statusCssClass = 'iconExclamation';
						}
						htmlStr +='<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bglinkMsg + '</a></div></td></tr></table></td></tr></table>';
						
						var resultObj = this.getBackGroundPanel();
						resultObj.removeAll();
						resultObj.update(htmlStr);
						resultObj.doLayout();
						this.getBackGroundPanel().show();
					}
				}
			});
//
		}
		else if(selectedReportGen!=null && selectedReportGen == "background-csv")
		{
				//
  			loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
			loadMask.show();
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: "responseType=Json&isSubmit=true&"+queryString,
				async:true,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(Ext.isEmpty(jsonText)){										
					Ext.getCmp("uptimeResultPanel").hide();	
					loadMask.hide();
 					this.getNomeasurepanel().show();
					Ext.getCmp("backGroundPanel").hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					}
					else
					{
					var jsonData=Ext.decode(jsonText);					
					loadMask.hide();
			//
			uptimeResultPanel.hide();
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);
			Ext.getCmp("favoriteTool").setDisabled(false);
		

			Ext.getCmp("bgReportName").setValue(jsonData.pageParams['bg_reportname']);
			Ext.getCmp("bgReportName").show();

			var bgGroundMsg = jsonData.pageParams['bgGroundMsg'];
			var status = jsonData.pageParams['status'];
			var langSupportString = jsonData.pageParams['bckGrdSaveMsg'];
			var bgReportUrl = jsonData.pageParams['bckGrdSaveURL'];
			var bglinkMsg = jsonData.pageParams['bglinkMsg'];
		
			uptimeResultPanel.hide();
			this.getBackGroundPanel().show();

			var analyzeByObj = Ext.getCmp("analyzeBy");
			var analyzeByStore = analyzeByObj.getStore();
			var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
			var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');

			var compType = Ext.getCmp("compType");
			var compTypeStore = compType.getStore();
			var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
			var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');

			var showByPriorityObj = Ext.getCmp("showByPriority");
			var showByPriorityStore = showByPriorityObj.getStore();
			var showByPriorityIdx= showByPriorityStore.find("valueField",showByPriorityObj.getValue());
			var showByPriority = showByPriorityStore.getAt(showByPriorityIdx).get('displayField');

			var sortByObj = Ext.getCmp("sortByCombo");
			var sortByStore = sortByObj.getStore();
			var sortByIdx= sortByStore.find("valueField",sortByObj.getValue());
			var sortBy = sortByStore.getAt(sortByIdx).get('displayField');

			var startdate = Ext.getCmp('er_stdate').dataArray;
			var enddate = Ext.getCmp('er_enddate').dataArray;
			var startHour = Ext.getCmp('er_sthr').dataArray;
			var endHour = Ext.getCmp('er_endhr').dataArray;

			var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			var timePeriodToHrs = Ext.getCmp('timeto').getValue();
			var timePeriodToMins = Ext.getCmp('minto').getValue();

			var excludeWeekendsComboObj = Ext.getCmp("excludeWeekendsCombo");
			var excludeWeekendStore = excludeWeekendsComboObj.getStore();
			var excludeWeekendIdx= excludeWeekendStore.find("valueField",excludeWeekendsComboObj.getValue());
			var excludeWeekend = excludeWeekendStore.getAt(excludeWeekendIdx).get('displayField');
			var htmlStr='';			
			var statusCssClass='iconSuccess';
			if(status != null && (status == "duplicate" || status == "exceedLimit"))
			{
				statusCssClass = 'iconExclamation';
			}
			htmlStr +='<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bglinkMsg + '</a></div></td></tr></table></td></tr></table>';

			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			resultObj.add({
			xtype: 'panel',
				margin:0,
				bodyPadding:0,
				height: '100%',
				width: '100%',
				html: '<div>'+htmlStr+'</div>'
			});
			resultObj.doLayout();
			resultObj.show();
					}
				}
			});
		}

		else
		{
			uptimeResultPanel.removeAll();
			uptimeResultPanel.show();
			this.getBackGroundPanel().hide();
			if(dataAvailable!=null && dataAvailable=="true")
			{
				//Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);
				mainResultPanel.show();
				this.getNomeasurepanel().hide();
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);		
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
			//	var reportType = jsonData.pageParams.er_type;
				var report_Type = Ext.getCmp('report_Type').getValue();
				var reportType = "No";
				if(report_Type!=null && report_Type.toLowerCase()=="graph")
				{
					reportType= "Yes";
				}
				if(reportType!=null && reportType=="Yes") // graph report
				{
					mainResultPanel.setTitle("<div class='htmlGraphTableHeader' style='padding:4px 0px 0px 0px'>"+mainHeaderTitle+"</div>");
					mainResultPanel.getHeader().hide();
					var compArr = new Array();
					compArr = Ext.getCmp('components').getValue();
					if(compArr!=null && (compArr!="" && compArr!="null"))
					{
						/*loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
						loadMask.show();*/
					//@
					var itemsArray = new Array();
					var doms = new Array();
					var itmArry=new Array();
					var qryArry=new Array();
					var content='';
					noOfCharts=0;
					for (var i = 0; compArr.length> i; i++) {
						var charid = "myChartId" + i;
						var containerId = doms[i];					
							noOfCharts+=1;
							itmArry.push(i);
					}
					if(noOfCharts==1)
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable" style="border:0px;"><col width="50%"><tr>';
						}else
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable" style="border:0px;"><col width="50%"><col width="50%"><tr>';
						}
					var col=0;
					for(var key in itmArry) {
						var evenLastTd=false;
						var j=itmArry[key];
						var component=compArr[j];	
						var title='';
						//
						if ( getComboVal == 'Component' )
						{
						if(component!=undefined)
							title=component.substring(0,component.indexOf(":"));
						}
						else
						{
						if(component!=undefined)
							title=component.substring(component.indexOf(":")+1,component.lastIndexOf(":"));
						}
						//
						if (col==2)
						{
							col=0;
							content+='</tr>';
							content+='<tr>';
						}
						if(key == 0){
							if (itmArry.length>2)
							{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
							else if(itmArry.length==2)
							{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
							else
							{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
						}
						else if(key == 1){
							if (itmArry.length>2)
							{
								content+='<td style="padding:0px 10px 10px 0px">';
							}
							else
							{
								content+='<td style="padding:0px 10px 10px 0px">';
							}
						}
						else if((key%2) == 0){
							if (key==itmArry.length-1)
							{
								evenLastTd=true;
								content+='<td style="padding:0px 10px 10px 10px">';
							}
							else if (key==itmArry.length-2)
							{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
							else{
								content+='<td style="padding:0px 10px 10px 10px">';
							}
						}
						else if((key%2) != 0){
							if (key==itmArry.length-1)
							{
								content+='<td style="padding:0px 10px 10px 0px">';
							}
							else{
								content+='<td style="padding:0px 10px 10px 0px">';
							}
						}
						content+='<div width="100%" class="graphMainDiv">';
						content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
						content+=title;
						content+='</div></div>';
						var dom="img_" + key;
						doms.push(dom);
						if(compArr.length==1)
							content+='<div id="'+dom+'" style="height:330;width:100%;overflow:auto;align-items:baseline;" class="htmlGraphTableBody">';
						else
							content+='<div id="'+dom+'" style="height:310px;width:100%;overflow:auto;" class="htmlGraphTableBody">';

						//
						content+='<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody><tr><td width="100%" height="305px" valign="middle" align="center"><div class="font_bold11">Loading...</div></td></tr></tbody></table>';
						//
						content+='</div>';
						content+='</div></td>';
						if (evenLastTd)
						{
							content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
						}
						col++;
					}
					if (col==2)
					{
						content+='</tr>';
					}
					content+='</table></div>';
					//@
					Ext.getCmp("csvTool").setDisabled(true);
					uptimeResultPanel.removeAll();
						uptimeResultPanel.add({
							xtype:'panel',
							title:mainHeaderTitle,
							margin:'10 10 10 10',
							ui:'multiGraphPanel',
							columnWidth:1,
							html:content,
							id:'html_content'
						});
					for(var i=0;i<itmArry.length;i++) {
					var j=itmArry[i];
					var containerId = doms[i];
					compQStr = encodeURIComponent(compArr[i]);
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: "responseType=Json&isSubmit=true&"+queryString+"&imgDivId="+containerId+"&er_component="+compQStr+"&er_combination="+compQStr+"##",
				method: 'post',
				async:true,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(Ext.isEmpty(jsonText)){	
					}
					else
					{
						jsonData=Ext.decode(jsonText);
						console.log(jsonData)
						var dataAvailable = jsonData.dataAvailable;
						if(dataAvailable!=null && dataAvailable=="true")
						{
							if(jsonData.rImgDivId=='img_0')
								Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(jsonData.rImgDivId,jsonData.chartData.chartHeight-20,jsonData.chartData.chartWidth+100), lineChart);
							lineChart.setData(jsonData.chartData,'<%=currentDateFormat%>','');
							lineChart.drawChart();	
						}
						else
						{
							if(Ext.get(jsonData.rImgDivId)!=null)
							{
								if(jsonData.rImgDivId=='img_0')
									Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);
								Ext.get(jsonData.rImgDivId).update('<div><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
							}
						}
					}
					//loadMask.hide();
				}
			});
					}
					}
				}
				else // data report
				{
					 var dataRep="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+'* y - year, M - month, d - day, h - hour, m - min'+"";
					 //var dataRep='y - year, M - month, d - day, h - hour, m - min';
			var compArr = new Array();
			compArr = Ext.getCmp('components').getValue();
			var doms = new Array();
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
					/*loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
						loadMask.show();*/
			//mainResultPanel.setTitle("<span class='font_bold'>"+mainHeaderTitle+"<label style='text-align:right;'>"+dataRep+"</label></span>");
			//		mainResultPanel.setTitle("<span class='font_bold'>"+mainHeaderTitle+dataRep+"</span>");
					mainResultPanel.setTitle("<div class='font_bold' style='padding:4px 0px 0px 0px'>"+mainHeaderTitle+"</div>");//+dataRep);
					mainResultPanel.getHeader().hide();
					uptimeResultPanel.removeAll();
					//
					var content="";
					content='<div style="width:100%;">'
					for(var k=0;k<compArr.length;k++)
					{
						var component=compArr[k];	
						var title='';
						//
						if ( getComboVal == 'Component' )
						{
						if(component!=undefined)
							title=component.substring(0,component.indexOf(":"));
						}
						else
						{
						if(component!=undefined)
							title=component.substring(component.indexOf(":")+1,component.lastIndexOf(":"));
						}
						//
					content+= '<table width="100%" border="0" class="htmlGraphTable" style="border:0px;"><tr>'
						content+='<td style="padding:0px 0px 10px 0px">';
						content+='<div class="font_bold14">';
						content+=title; 
						content+='</div>';
						var dom="img_"+k;
						doms.push(dom);
						content+='<div id="'+dom+'" style="height:auto;width:100%;margin-bottom:5px" class="htmlGraphTableBody">';
						//
						content+='<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="140px" valign="middle" align="center"><div class="font_bold11">Loading...</div></td></tr></tbody></table>';
						//
						content+='</div>';
						content+='</td></tr>';
						content+='</table>';
					}
						content+='</div>';
					//
					uptimeResultPanel.add({
						xtype: 'panel',
						ui:'newGraphPanel',
						title:mainHeaderTitle + '<div style="float:right" class="font_normal12">* y - year, M - month, d - day, h - hour, m - min</div>',
						margin:10,
						bodyPadding:'0 10 10 10',
						html: content
					});
					var uptimeDataDiv = Ext.get("uptimeDataDiv");
					Ext.getCmp("csvTool").setDisabled(false);
					var analyzeByObj = Ext.getCmp("analyzeBy");
					var analyzeByStore = analyzeByObj.getStore();
					var analyzeByIdx= analyzeByStore.find("valueField",analyzeByObj.getValue());
					var analyzeBy = analyzeByStore.getAt(analyzeByIdx).get('displayField');
					var compType = Ext.getCmp("compType");
					var compTypeStore = compType.getStore();
					var compTypeIdx= compTypeStore.find("valueField",compType.getValue());
					var compTypeVal = compTypeStore.getAt(compTypeIdx).get('displayField');
				for(var y=0;y<compArr.length;y++)
				{
				var compQStr = encodeURIComponent(compArr[y]);
				var containerId=doms[y];
				Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: "responseType=Json&isSubmit=true&"+queryString+"&imgDivId="+containerId+"&er_component="+compQStr+"&er_combination="+compQStr+"##",
				method: 'post',
				async:true,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(Ext.isEmpty(jsonText)){	
						console.log('<<< 10000 >>>');
					}
					else
					{
					jsonData=Ext.decode(jsonText);					
					var dataAvailable = jsonData.dataAvailable;
					var canShowDetails = jsonData['canShowDetails'];
					if(dataAvailable!=null && dataAvailable=="true")
						{
						if(jsonData.rImgDivId=='img_0')
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);
//@
					var htmlStr = "<div class='newTable' style='margin-top:5px'>"
					+ "<table cellspacing='0' cellpadding='0' border='0' >"
					+ "<thead>"
					+ "<tr>"
						+ '<th style="text-align: center; vertical-align: middle;width:240px;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Services"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Uptime"]+'<br><span style="text-transform:none !important;">'+jsonData.screenLabels["reporter.uptime.Uptime (yMdhm)"]+'</span></div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.% Uptime"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div style="width:150px;">'+jsonData.screenLabels["reporter.uptime.Downtime"]+'<br><span style="text-transform:none !important;">'+jsonData.screenLabels["reporter.uptime.Downtime (yMdhm)"]+'</span></div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.% Downtime"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Details"]+'</div>'
						+'</th>'
					+ "</tr>"
					+ "</thead>"
					+ "<tbody>";
					var dataTable  = jsonData.dataTable;
					if(!Ext.isEmpty(dataTable))
					{
						var g=0;
						for(var uptimeInfo in dataTable)
						{
							g++;
							var uptimeData = dataTable[uptimeInfo];
							htmlStr += "<tr>"
									   +"<td style='width:240px'><div style='text-align:left;'>"+uptimeData.component+"</div></td>" 
									   +"<td><div style='text-align:center;'>"+uptimeData.uptime+"</div></td>"
									   +"<td><div style='text-align:center;'>"+uptimeData.uptimePercent+"</div></td>" 
									   +"<td><div style='text-align:center;' >"+uptimeData.downTime+"</div></td>"  
									   +"<td><div style='text-align:center;'>"+uptimeData.downTimePercent+"</div></td>" 
						if(uptimeData.hasOwnProperty('detailsLink'))
							{
								if(uptimeData.detailsLink=="NOLINK")
								{
									htmlStr +="<td><div style='text-align:center;' >&nbsp;-&nbsp;</div></td>";
								}
								else
								{
									htmlStr +="<td><div align='center' style='cursor:pointer;padding:4px'><div><img src='../images/spacer.gif' class='iconDetailedList' border='0px' style='display:block;' onClick='javascript:openInGraphWin(\""+uptimeData.detailsLink+"\");'></div></div></td>";
								}
							}
							else
							{
								htmlStr +="<td><div >&nbsp;-&nbsp;</div></td>";
							}
									   htmlStr +="</tr>";
						}
					}
					 htmlStr += "</tbody>"
					 htmlStr += "</table>"
					 htmlStr += "</div>"
					if(canShowDetails!=null && canShowDetails=="true")
					{
						htmlStr+= "<br><br><div class='newTable' style='margin-top:5px'>"
						+ "<table cellspacing='0' cellpadding='0' border='0'>"
						+ "<thead>"
						+ "<tr>"
						+ '<th style="text-align: center; vertical-align: middle;" >'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Services"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Down At"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Up At"]+'</div>'
						+'</th>'
						+ '<th style="text-align: center; vertical-align: middle;">'
						+'<div>'+jsonData.screenLabels["reporter.uptime.Downtime"]+"<br>("+jsonData.screenLabels["reporter.uptime.mins"]+")* </div>"
						+'</th>'

						+ "</tr>"
						+ "</thead>"
						+ "<tbody>";
						var detailsData  = jsonData.detailsData;
						if(!Ext.isEmpty(detailsData))
						{
							for(var rebootInfo in detailsData)
							{
								var rebootData = detailsData[rebootInfo];
								htmlStr += "<tr>"
										   +"<td style='width:240px'><div>"+rebootData.component+"</div></td>" 
										   +"<td><div style='text-align:center'>"+rebootData.shutDownAt+"</div></td>"
										   +"<td><div style='text-align:center'>"+rebootData.reBootAt+"</div></td>" 
										   +"<td><div style='text-align:center'>"+rebootData.downTime+"</div></td>"  
							  }
					    	}
						htmlStr += "</tbody>"
							htmlStr += "</table></div>";
						   }
							Ext.fly(jsonData.rImgDivId).update(htmlStr);
							}
							else
							{
							if(Ext.get(jsonData.rImgDivId)!=null)
							{
								if(jsonData.rImgDivId=='img_0')
									Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetailsData);
								Ext.get(jsonData.rImgDivId).update('<div class="errorMsgBox"><img src="/final/images/spacer.gif" class="iconExclamation" border="0px" style="border:0px" /> <br/>No measures available</div>');
								}
							}
						}
						//loadMask.hide();
				       }
				     });
				  }
				 }
				}
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			}
			else if(dataAvailable!=null && dataAvailable=="false")
			{
				if(isFromScheOrFav)
				{
					isFromScheOrFav = false;
					this.beforeFormSubmit();									
				}
			}
		}
	},
	formSubmit: function(obj)
	{
		var loadMask = null;
		var ctrlObjID="";
		if(obj!=null && obj!="undefined")
		{
			ctrlObjID = obj.getId();
		}
		if(ctrlObjID != null && ctrlObjID=="submit")
		{
			var uptimeReport = Ext.getCmp('uptimeReport').getValue();
			this.updateQueryString(ctrlObjID);
			if(uptimeReport=='Services')
			{	
				//this.loadUptimeForServiceReportData("");
				var dataObj=new Object();
				dataObj.dataAvailable="true";
				this.loadUptimeForServiceReportData(dataObj);
			}
			else
			{
			loadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			loadMask.show();
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: "responseType=Json&isSubmit=true&"+queryString,
				async:true,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(Ext.isEmpty(jsonText)){
					Ext.getCmp("uptimeResultPanel").hide();	
					loadMask.hide();
 					this.getNomeasurepanel().show();
					Ext.getCmp("backGroundPanel").hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					}
					else
					{
					var jsonData=Ext.decode(jsonText);
					loadMask.hide();
					this.loadReportData(jsonData);
					}
				}
			});
		}
		}
		else
		{
			this.updateQueryString(ctrlObjID);
			Ext.Ajax.request({
				url : '/final/reporter/ErUptimeReportDataJson.jsp',
				params: queryString+"&OperationUptimeUIAction=defaultLoad",
				scope:this,
				async:true,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					if(ctrlObjID!=null && (ctrlObjID!= 'er_timeline'  && ctrlObjID!= 'showdetailsCombo'))
					{
						var getReportForComboVal = Ext.getCmp('analyzeBy').getValue();
						var compTypeCombo = Ext.getCmp('compType');
						var compTypeComboRawData = jsonData['comptypecombo'];
						if ( getReportForComboVal == 'Zone' )
						{
							var zoneCombo = Ext.getCmp('zone');
							var zoneComboRawData = jsonData['vSiteJson'];
							if ( !Ext.isEmpty(zoneComboRawData) )
							{
								zoneCombo.getStore().clearFilter(true);
								zoneCombo.getStore().loadRawData(zoneComboRawData);
								zoneCombo.setValue(jsonData.pageParams.selctedSite);
							}
						}
						else if ( getReportForComboVal == 'Segment' )
						{
							var segmentCombo = Ext.getCmp('segment');
							var segmentComboRawData = jsonData['vSiteJson'];
							if ( !Ext.isEmpty(segmentComboRawData) )
							{
								segmentCombo.getStore().clearFilter(true);
								segmentCombo.getStore().loadRawData(segmentComboRawData);
								segmentCombo.setValue(jsonData.pageParams.selctedSite);
							}
						}
						else if ( getReportForComboVal == 'Service' )
						{
							var serviceCombo = Ext.getCmp('service');
							var serviceComboRawData = jsonData['vSiteJson'];
							if ( !Ext.isEmpty(serviceComboRawData) )
							{
								serviceCombo.getStore().clearFilter(true);
								serviceCombo.getStore().loadRawData(serviceComboRawData);
								serviceCombo.setValue(jsonData.pageParams.selctedSite);
							}
						}
						var compTypeCombo = Ext.getCmp('compType');
						var compTypeComboRawData = jsonData['vCompTypeJson'];
						compTypeCombo.getStore().clearFilter(true);
						compTypeCombo.getStore().loadRawData(compTypeComboRawData);
						compTypeCombo.setValue(jsonData.pageParams.selectedCompType);

						var selectedComps = jsonData.pageParams['selectedComps'];
						var getComponentRawData = jsonData['compFilterJSON'];
						appConstants.compFilterJSON = getComponentRawData;
						var componentsMultiSelectObj = Ext.getCmp('components');
						componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
						componentsMultiSelectObj.setValue(selectedComps);
					}
					var repoGen = Ext.getCmp('reportGeneration');
					
				if(repoGen!= undefined && repoGen!= 'undefined'){
					var reportNameObj = Ext.getCmp('bgReportName');
					var repoGenComboRawData = jsonData.reportGenerationJSONArray;
					var setRepoGen = repoGenComboRawData[0].valueField;
					if (!Ext.isEmpty(repoGenComboRawData) )
					{
						repoGen.getStore().loadRawData(repoGenComboRawData);
						repoGen.setValue(setRepoGen);
						if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
						{
							reportNameObj.hide();
						}
						else
						{
							reportNameObj.show();
						}
					}
				}
					var startdateObj = Ext.getCmp('er_stdate');
					var enddateObj = Ext.getCmp('er_enddate');
					var startHourObj = Ext.getCmp('er_sthr');
					var endHourObj = Ext.getCmp('er_endhr');

					var stDate = jsonData.pageParams['s_st_time'];
					var endDate = jsonData.pageParams['s_en_time'];
					var startHr = jsonData.pageParams['starthr'];
					var endHr = jsonData.pageParams['endhr'];

					startdateObj.setValue(jsonData.pageParams['startDateForDisplay']);
					startdateObj.dataArray = stDate;
					enddateObj.setValue(jsonData.pageParams['endDateForDisplay']);
					enddateObj.dataArray = endDate;
					startHourObj.setValue(jsonData.pageParams['startHourForDisplay']);
					startHourObj.dataArray = startHr;
					endHourObj.setValue(jsonData.pageParams['endHourForDisplay']);
					endHourObj.dataArray = endHr;

					/*startdateObj.setValue(stDate);
					enddateObj.setValue(endDate);
					startHourObj.setValue(startHr);
					endHourObj.setValue(endHr);*/
					
					if(ctrlObjID!=null && ctrlObjID== 'er_timeline')
					{
						var reportgenObj = Ext.getCmp('reportGeneration');

						var reportgen = reportgenObj.getValue();

						if(reportgen!=null && reportgen=="foreground")
						{
							var limitforbg = appConstants.publicJsonData.hiddenParams["limitforbg"];

							if(!Ext.isEmpty(limitforbg))
							{
								var bglimit = limitforbg;

								var getMaxDaysInMonth = appConstants.publicJsonData.hiddenParams["getMaxDaysInMonth"];

								var maxDaysInMonth = "0";
								if(!Ext.isEmpty(getMaxDaysInMonth))
								{
									maxDaysInMonth = getMaxDaysInMonth;
								}
								var startdate = Ext.getCmp('er_stdate').getValue();
								var enddate = Ext.getCmp('er_enddate').getValue();
								startdate.setHours(Ext.getCmp('er_sthr').getValue());
								enddate.setHours(Ext.getCmp('er_endhr').getValue());
								if(!checkTimeLineForBgLimit(bglimit,maxDaysInMonth,startdate,enddate))
								{
									var reportNameObj = Ext.getCmp('bgReportName');
									reportgenObj.setValue("background");
									reportNameObj.show();
								}
								else
								{
									var reportNameObj = Ext.getCmp('bgReportName');
									reportgenObj.setValue("foreground");
									reportNameObj.hide();
								}
							}
						}
					}
				}
			});
		}
	},
	loadMainElements:function(){
		this.getMainform().loadFields();
	},
	fillSettingsElements:function(){
		//var hiddenFields =  appConstants.publicjsonData.hiddenfields;
		var favorite_id = appConstants.publicJsonData.hiddenParams.favorite_id;
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		this.getOperationuptimesettings().loadSettingsData();

	},
	showConfigDropdown : function() {
		var me = this;
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;padding:0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');		

		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		//layout:'vbox',
		height:'auto',
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype:'operationuptimesettings',
				parent:this
			}
		],
		renderTo:'operationuptimedata-body'
		});
     var reportType1 = Ext.getCmp('report_Type').getValue();
      if(reportType1 == 'overview'){
                var chartOptionsCombo = Ext.getCmp('chartOptionsCombo');
                var sortByCombo       =  Ext.get('sortByCombo');
	        var showByPriority    =  Ext.get('showByPriority');
	        var splitterID        =  Ext.get('splitterID');

	        chartOptionsCombo.hide();
	        sortByCombo.hide();
                showByPriority.hide();
                splitterID.hide();
	  }
		Ext.get('closeSettings').on('click',function(){
			me.validateSettings();
		});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateSettings())
		{
			this.beforeFormSubmit();
		}
	},
	defaultLoad: function()
	{
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		
		
		updatingAppSettings();
		 var fromScheduleModify = appConstants.publicJsonData.hiddenParams['fromScheduleModify'];
		var fromFavoriteModify = appConstants.publicJsonData.hiddenParams["fromFavoriteModify"];
		var schedule_id =appConstants.publicJsonData.hiddenParams["schedule_id"]; 
		var favorite_id =appConstants.publicJsonData.hiddenParams["favorite_id"]; 

		if ((fromScheduleModify != null && fromScheduleModify == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			appConstants.fromScheduleModify=fromScheduleModify;
			appConstants.fromFavoriteModify=fromFavoriteModify;
			appConstants.schedule_id=schedule_id;
			appConstants.favorite_id=favorite_id;
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var meController = this;
		this.loadRepData();
		//Ext.getCmp('uptimeResultPanel').hide();
		if(!hideBackButton){
		Ext.getCmp('uptimereportform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJsonData['ID']
			}
		);
		}
	},
	showDetailsRadio: function()
	{
		if (!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		var reportType = Ext.getCmp("report_Type").getValue();
		var showdetailsCombo = Ext.getCmp('showdetailsCombo');
		var chartOptionsCombo = Ext.getCmp('chartOptionsCombo');
		var graphMode = Ext.getCmp('er_mode');

		var sortByCombo    =   Ext.getCmp('sortByCombo');
		var showByPriority =   Ext.getCmp('showByPriority');
		var	splitterID     =   Ext.getCmp('splitterID');
		var	uptimeReport     =   Ext.getCmp('uptimeReport');
		Ext.getCmp('runningDurationFilter').hide();

		if ( reportType == "data" )
		{
			showdetailsCombo.show();
			chartOptionsCombo.hide();
			sortByCombo.show();
            showByPriority.show();
			splitterID.show();
			if(uptimeReport.getValue()=='Systems')
			{
				Ext.getCmp('runningDurationFilter').show();
			}
		}
		else if(reportType== 'graph')
		{
			showdetailsCombo.hide();
			chartOptionsCombo.show();
			sortByCombo.show();
            showByPriority.show();
			splitterID.show();
		}else {
			showdetailsCombo.hide();
            chartOptionsCombo.hide();
			sortByCombo.hide();
            showByPriority.hide();
			splitterID.hide();
		}
		this.formSubmit(showdetailsCombo);
	},
	showBackgroundReport: function(combo)
	{
		var val = combo.getValue();
		var reportNameObj = Ext.getCmp('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if (val == 'background-csv')
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	selectCompComponents: function()
	{
		var getCompTypeObj = Ext.getCmp('compType');
		this.selectComponents(getCompTypeObj);
	},
	selectZoneComponents: function()
	{
		var getZoneComboObj = Ext.getCmp('zone');
		if ( getZoneComboObj.getValue() != '-1' )
		{
			this.selectComponents(getZoneComboObj);
		}
		else
		{
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectServiceComponents: function()
	{
		var getServiceComboObj = Ext.getCmp('service');
		if ( getServiceComboObj.getValue() != '-1' )
		{
			this.selectComponents(getServiceComboObj);
		}
		else
		{
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectSegmentComponents: function()
	{
		var getSegmentComboObj = Ext.getCmp('segment');
		if ( getSegmentComboObj.getValue() != '-1' )
		{
			this.selectComponents(getSegmentComboObj);
		}
		else
		{
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(appConstants.getNotApplicationData, getCompObj);
		}
	},
	selectReportTypeCombos: function()
	{
		//
		var uptimeReport = Ext.getCmp('uptimeReport');
		var reportType = Ext.getCmp('report_Type');
		if(!Ext.isEmpty(uptimeReport))
		{
			var value=uptimeReport.getValue();
			if(reportType.getValue()=='data' && value=='Systems')
			{
				Ext.getCmp('runningDurationFilter').show();
			}
			else
			{
				Ext.getCmp('runningDurationFilter').hide();
			}
			if(value=='Services')
			{
				if (isSettingsEnabled)
				{	
					var showTop=Ext.getCmp('showByPriority');
						if(!Ext.isEmpty(showTop))
							showTop.hide();
					var includeMaintenanceCombo=Ext.getCmp('includeMaintenanceCombo');
						if(!Ext.isEmpty(includeMaintenanceCombo))
							includeMaintenanceCombo.hide();
				//
					var jsonData = appConstants.publicJsonData;
					var chartLbl = jsonData.screenLabels['reporter.uptime.Chart'];
					var chartOptionJSONArray = jsonData['chartOptionJSONArray'];
					var chartOptionsComboObj = Ext.getCmp('chartOptionsCombo');
					var tmpArry=new Array();
					if(chartOptionJSONArray!=undefined)
					{
						for(var k=0;k<chartOptionJSONArray.length;k++)
						{
							if(k==2)
								break;
							tmpArry.push(chartOptionJSONArray[k]);
						}
					}
					chartOptionsComboObj.getStore().loadRawData(tmpArry);
					chartOptionsComboObj.setValue(jsonData.pageParams.er_show);
					chartOptionsComboObj.setFieldLabel(chartLbl);
				//
				var sortJSONArray = jsonData['sortByJSONArray'];
				var sortByComboObj = Ext.getCmp('sortByCombo');
				var sortByLbl = jsonData.screenLabels['reporter.comparison.Sort by'];
				var tmpSortArry=new Array();
					if(sortJSONArray!=undefined && sortJSONArray.length==4)
					{
						for(var k=0;k<sortJSONArray.length;k++)
						{
							if(k==0||k==3)
								continue;
							tmpSortArry.push(sortJSONArray[k]);
						}
					}
				sortByComboObj.getStore().loadRawData(tmpSortArry);
				sortByComboObj.setValue(jsonData.pageParams.sortby);
				sortByComboObj.setFieldLabel(sortByLbl);
				//
				}
			}
			else
			{
				if (isSettingsEnabled)
				{	
					var showTop=Ext.getCmp('showByPriority');
						if(!Ext.isEmpty(showTop))
							showTop.show();
					var includeMaintenanceCombo=Ext.getCmp('includeMaintenanceCombo');
						if(!Ext.isEmpty(includeMaintenanceCombo))
							includeMaintenanceCombo.show();
				//
					var jsonData = appConstants.publicJsonData;
					var chartLbl = jsonData.screenLabels['reporter.uptime.Chart'];
					var chartOptionJSONArray = jsonData['chartOptionJSONArray'];
					var chartOptionsComboObj = Ext.getCmp('chartOptionsCombo');
					chartOptionsComboObj.getStore().loadRawData(chartOptionJSONArray);
					chartOptionsComboObj.setValue(jsonData.pageParams.er_show);
					chartOptionsComboObj.setFieldLabel(chartLbl);
				//
				var sortJSONArray = jsonData['sortByJSONArray'];
				var sortByComboObj = Ext.getCmp('sortByCombo');
				 var sortByLbl = jsonData.screenLabels['reporter.comparison.Sort by'];
				sortByComboObj.getStore().loadRawData(sortJSONArray);
				sortByComboObj.setValue(jsonData.pageParams.sortby);
				sortByComboObj.setFieldLabel(sortByLbl);
				//
				}
			}
		}
 		var getComboVal = Ext.getCmp('analyzeBy').getValue();
		var compTypeCombo = Ext.getCmp('compType');
		var zoneCombo = Ext.getCmp('zone');
		var subzoneRadio = Ext.getCmp('subzone');
		var segmentCombo = Ext.getCmp('segment');
		var serviceCombo = Ext.getCmp('service');

		if ( getComboVal == 'Component' )
		{
			//compTypeCombo.show();
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.hide();
			serviceCombo.hide();

		}
		else if ( getComboVal == 'Zone' )
		{
			//compTypeCombo.hide();
			zoneCombo.show();
			subzoneRadio.show();
			segmentCombo.hide();
			serviceCombo.hide();
		}
		else if ( getComboVal == 'Segment' )
		{
			//compTypeCombo.hide();
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.show();
			serviceCombo.hide();
		}
		else if ( getComboVal == 'Service' )
		{
			//compTypeCombo.hide();
			zoneCombo.hide();
			subzoneRadio.hide();
			segmentCombo.hide();
			serviceCombo.show();
		}
		
		this.formSubmit(compTypeCombo);
	},
	selectComponents: function(combo)
	{
		var comboId = combo.getId();
		var genParams = '';
	//	var graphType = Ext.getCmp('TimelineReportType').getValue();
		var ReportForVal = Ext.getCmp('analyzeBy').getValue();
		var uptimeReport = Ext.getCmp('uptimeReport').getValue();

		var paramsForCompChange = '';
		
		if ( comboId == 'compType' )
		{

			var compTypeVal = Ext.getCmp(comboId).getValue();

			paramsForCompChange = 'er_uptimetest='+uptimeReport+'&er_datafrom='+ReportForVal+'&er_comptype='+compTypeVal;
			
			
			if ( ReportForVal == 'Zone' )
			{
				var zoneName = Ext.getCmp('zone').getValue();
				var isIncludedSubZone = Ext.getCmp('subzone').getValue();
				paramsForCompChange = paramsForCompChange+'&er_site='+zoneName+'&er_dataZone='+isIncludedSubZone;
			}
			else if ( ReportForVal == 'Segment' )
			{
				var segmentName = Ext.getCmp('segment').getValue();
				paramsForCompChange = paramsForCompChange+'&er_site='+segmentName;
			}
			else if ( ReportForVal == 'Service' )
			{
				var serviceName = Ext.getCmp('service').getValue();
				paramsForCompChange = paramsForCompChange+'&er_site='+serviceName;
			}
		}
		else if ( comboId == 'zone' )
		{
			var isIncludedSubZone = Ext.getCmp('subzone').getValue();
			var zoneName = Ext.getCmp('zone').getValue();
			paramsForCompChange = 'er_uptimetest='+uptimeReport+'&er_datafrom='+ReportForVal+'&er_site='+zoneName+'&er_dataZone='+isIncludedSubZone;
		}
		else if ( comboId == 'segment' )
		{
			var segmentName = Ext.getCmp('segment').getValue();
			paramsForCompChange = 'er_uptimetest='+uptimeReport+'&er_datafrom='+ReportForVal+'&er_site='+segmentName;
		}
		else if ( comboId == 'service' )
		{
			var serviceName = Ext.getCmp('service').getValue();
			paramsForCompChange = 'er_uptimetest='+uptimeReport+'&er_datafrom='+ReportForVal+'&er_site='+serviceName;
		}
		Ext.Ajax.request({
			url : '/final/reporter/ErUptimeReportDataJson.jsp',
			method: 'post',
			async:true,
			params: paramsForCompChange+"&OperationUptimeUIAction=loadComponents",
			scope:this,
		    success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				
				if ( comboId == 'compType' )
				{
					if ( ReportForVal == 'Zone' )
					{
						var getComponentRawData = jsonData['compFilterJSON'];
						appConstants.compFilterJSON = getComponentRawData;
						var componentsMultiSelectObj = Ext.getCmp('components');
						componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
					}
					else
					{
				        var getComponentSelectObj = Ext.getCmp('components');
				        var getComponentRawData = jsonData['compFilterJSON'];
						appConstants.compFilterJSON = getComponentRawData;
				        getComponentSelectObj.getStore().loadRawData(getComponentRawData);

						var selectedComps = jsonData.pageParams['selectedComps'];
						getComponentSelectObj.setValue(selectedComps);
					}

				}
				else if ( comboId == 'zone' )
				{
					var getComponentRawData = jsonData['vCompTypeJson'];
					var ComponentTypeObj = Ext.getCmp('compType');
					ComponentTypeObj.getStore().removeAll();
					ComponentTypeObj.getStore().loadRawData(getComponentRawData);
					ComponentTypeObj.setValue(jsonData.pageParams.selectedCompType);
	
					 var getComponentSelectObj = Ext.getCmp('components');
			        var getComponentRawData = jsonData['compFilterJSON'];
					appConstants.compFilterJSON = getComponentRawData;
			        getComponentSelectObj.getStore().loadRawData(getComponentRawData);
					var selectedComps = jsonData.pageParams['selectedComps'];
					getComponentSelectObj.setValue(selectedComps);
				}
				else if ( comboId == 'segment' )
				{
					var getComponentRawData = jsonData['vCompTypeJson'];
					var ComponentTypeObj = Ext.getCmp('compType');
					ComponentTypeObj.getStore().removeAll();
					ComponentTypeObj.getStore().loadRawData(getComponentRawData);
					ComponentTypeObj.setValue(jsonData.pageParams.selectedCompType);

					 var getComponentSelectObj = Ext.getCmp('components');
			        var getComponentRawData = jsonData['compFilterJSON'];
					appConstants.compFilterJSON = getComponentRawData;
			        getComponentSelectObj.getStore().loadRawData(getComponentRawData);
					var selectedComps = jsonData.pageParams['selectedComps'];
					getComponentSelectObj.setValue(selectedComps);
				}
				else if ( comboId == 'service' )
				{
					var getComponentRawData = jsonData['vCompTypeJson'];
					var ComponentTypeObj = Ext.getCmp('compType');
					ComponentTypeObj.getStore().removeAll();
					ComponentTypeObj.getStore().loadRawData(getComponentRawData);
					ComponentTypeObj.setValue(jsonData.pageParams.selectedCompType);

					var getComponentSelectObj = Ext.getCmp('components');
			        var getComponentRawData = jsonData['compFilterJSON'];
					appConstants.compFilterJSON = getComponentRawData;
			        getComponentSelectObj.getStore().loadRawData(getComponentRawData);
					var selectedComps = jsonData.pageParams['selectedComps'];
					getComponentSelectObj.setValue(selectedComps);
				}
			}
			});
	},
	insertTypeAndAll: function( screenLabel , key , loadObj)
	{
		var tmpStore = loadObj.getStore();
		tmpStore.insert(0,{
			'displayField':screenLabel,
			'valueField':'-1'
		});
		if ( tmpStore.getCount() > 2 )
		{
			tmpStore.insert( tmpStore.getCount(),{
			'displayField':'All',
			'valueField':'All'
			});
		}
	},
	insertNotApplicable: function( val, loadObj )
	{
		var tmpStore = loadObj.getStore();
		tmpStore.removeAll();
		tmpStore.insert(0,{
			'displayField': val,
			'valueField': val
		});
		if ( loadObj.getId() != 'components' )
		{
			loadObj.setValue(val);
		}
	},
	showUptimeChartOptions: function(combo)	{
		var selectedChartOption =  combo.getValue();
		var sortByComboObj = Ext.getCmp('sortByCombo');

		if(selectedChartOption!=null && selectedChartOption=="Reboots")
		{
			if(sortByRebootJSONArray!=null)
			{
				sortByComboObj.getStore().loadRawData(sortByRebootJSONArray);
				sortByComboObj.setValue("6");
			}
		}
		else
		{
			//
			var uptimeReport = Ext.getCmp('uptimeReport');
			if(!Ext.isEmpty(uptimeReport))
			{
				var value=uptimeReport.getValue();
				if(value=='Services')
				{
					return;
				}
			}
			//
			if(sortByJSONArray!=null)
			{
				var sortByComboObj = Ext.getCmp('sortByCombo');
				sortByComboObj.getStore().loadRawData(sortByJSONArray);
				sortByComboObj.setValue("1");
			}
		}

	},
	getHiddenFieldValues : function(isNeedToEncodeParameters)
	{
		var er_rtype = "";
		var font="";
		var reporttype = "";
		var er_trgttype = "";
		var eruserid = "";
		var fromSchedule = "";
		var schedule_id = "";
		var er_ViewName = "";
		var er_trenddata = "";
		var inidate = "";
		var userID = "";
		var getMaxDaysInMonth = "";
		var forwardto = "";
		var er_bgreportfrom = "";
		var bgenabled = "";
		var limitforbg = "";
		var savereport = "";
		var servletName = "";
		var divStatus = "";
		var er_usertimeline = "";

		var hiddenFieldsData = appConstants.publicJsonData['hiddenParams'];

		var er_rtypeObj = hiddenFieldsData["er_rtype"];
		var fontObj = hiddenFieldsData["font"];
		var reporttypeObj = hiddenFieldsData["reporttype"];
		var er_trgttypeObj = hiddenFieldsData["er_trgttype"];
		var eruseridObj = hiddenFieldsData["eruserid"];
		var fromScheduleObj = hiddenFieldsData["fromSchedule"];
		var schedule_idObj = hiddenFieldsData["schedule_id"];
		var er_ViewNameObj = hiddenFieldsData["er_ViewName"];
		var er_trenddataObj = hiddenFieldsData["er_trenddata"];
		var inidateObj = hiddenFieldsData["inidate"];
		var userIDObj = hiddenFieldsData["userID"];
		var getMaxDaysInMonthObj = hiddenFieldsData["getMaxDaysInMonth"];
		var forwardtoObj = hiddenFieldsData["forwardto"];
		var er_bgreportfromObj = hiddenFieldsData["er_bgreportfrom"];
		var bgenabledObj = hiddenFieldsData["bgenabled"];
		var limitforbgObj = hiddenFieldsData["limitforbg"];
		var savereportObj = hiddenFieldsData["savereport"];
		var servletNameObj = hiddenFieldsData["servletName"];
		var divStatusObj = hiddenFieldsData["divStatus"];
		var er_usertimelineObj = hiddenFieldsData["er_usertimeline"];

		if(!Ext.isEmpty(er_rtypeObj))
		{
			er_rtype = er_rtypeObj;
		}
		if(!Ext.isEmpty(fontObj))
		{
			font = fontObj;
		}
		if(!Ext.isEmpty(reporttypeObj))
		{
			reporttype = reporttypeObj;
		}
		if(!Ext.isEmpty(er_trgttypeObj))
		{
			er_trgttype = er_trgttypeObj;
		}
		if(!Ext.isEmpty(eruseridObj))
		{
			eruserid = eruseridObj;
		}
		if(!Ext.isEmpty(fromScheduleObj))
		{
			fromSchedule = fromScheduleObj;
		}
		if(!Ext.isEmpty(schedule_idObj))
		{
			schedule_id = schedule_idObj;
		}
		if(!Ext.isEmpty(er_ViewNameObj))
		{
			er_ViewName = er_ViewNameObj;
		}
		if(!Ext.isEmpty(er_trenddataObj))
		{
			er_trenddata = er_trenddataObj;
		}
		if(!Ext.isEmpty(inidateObj))
		{
			inidate = inidateObj;
		}
		if(!Ext.isEmpty(userIDObj))
		{
			userID = userIDObj;
		}
		if(!Ext.isEmpty(getMaxDaysInMonthObj))
		{
			getMaxDaysInMonth = getMaxDaysInMonthObj;
		}
		if(!Ext.isEmpty(forwardtoObj))
		{
			forwardto = forwardtoObj;
		}
		if(!Ext.isEmpty(er_bgreportfromObj))
		{
			er_bgreportfrom = er_bgreportfromObj;
		}
		if(!Ext.isEmpty(bgenabledObj))
		{
			bgenabled = bgenabledObj;
		}
		if(!Ext.isEmpty(limitforbgObj))
		{
			limitforbg = limitforbgObj;
		}
		if(!Ext.isEmpty(savereportObj))
		{
			savereport = savereportObj;
		}
		if(!Ext.isEmpty(servletNameObj))
		{
			servletName = servletNameObj;
		}
		if(!Ext.isEmpty(divStatusObj))
		{
			divStatus = divStatusObj;
		}
		if(!Ext.isEmpty(er_usertimeline))
		{
			er_usertimeline = er_usertimelineObj;
		}

		

		var hiddenQstr ="";

		if(isNeedToEncodeParameters)
		{
			hiddenQstr = "er_rtype="+er_rtype+"&font="+encodeURIComponent(font)
						+"&reporttype="+encodeURIComponent(reporttype)+"&er_trgttype="+er_trgttype+"&eruserid="+encodeURIComponent(eruserid)
						+"&fromSchedule="+fromSchedule+"&schedule_id="+encodeURIComponent(schedule_id)+"&er_ViewName="+encodeURIComponent(er_ViewName)+"&er_trenddata="+er_trenddata
						+"&inidate="+encodeURIComponent(inidate)+"&userID="+encodeURIComponent(userID)+"&getMaxDaysInMonth="+encodeURIComponent(getMaxDaysInMonth)
						+"&er_bgreportfrom="+er_bgreportfrom+"&bgenabled="+bgenabled
						+"&limitforbg="+encodeURIComponent(limitforbg)+"&savereport="+savereport+"&servletName="+encodeURIComponent(servletName)
						+"&divStatus="+divStatus+"&er_usertimeline="+encodeURIComponent(er_usertimeline);
		}
		else
		{
		
			hiddenQstr = "er_rtype="+er_rtype+"&font="+font
						+"&reporttype="+reporttype+"&er_trgttype="+er_trgttype+"&eruserid="+eruserid
						+"&fromSchedule="+fromSchedule+"&schedule_id="+schedule_id+"&er_ViewName="+er_ViewName+"&er_trenddata="+er_trenddata
						+"&inidate="+inidate+"&userID="+userID+"&getMaxDaysInMonth="+getMaxDaysInMonth
						+"&er_bgreportfrom="+er_bgreportfrom+"&bgenabled="+bgenabled
						+"&limitforbg="+limitforbg+"&savereport="+savereport+"&servletName="+servletName
						+"&divStatus="+divStatus+"&er_usertimeline="+er_usertimeline;
			
		}
		return hiddenQstr;
	},
	getDecimalAlignFormat:function(value)
	{
		if(true) // No need of decimal align for table
		{
			return value;
		}
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});