Ext.define('ReporterTemplate.controller.ReporterTemplateController', {
	extend: 'ReporterTemplate.controller.BuilderController',
	refs: [
		{selector:'main', ref:'main'},
		{selector:'reportbuildergridalias', ref:'reportbuildergridalias'},
		{selector:'reportbuilderboxview', ref:'reportbuilderboxview'},
		{selector:'customwindow', ref:'customwindow'},
		{selector:'reportdataconfigwindow', ref:'reportdataconfigwindow'},
		{selector:'reportertemplatetabpane', ref:'reportertemplatetabpane'},
		{selector:'gridsterstackpanel', ref:'gridsterstackpanel'},
		{selector:'graphpalettewindow', ref:'graphpalettewindow'},
		{selector:'configWidgetWindow', ref:'configWidgetWindow'},
	],
	 searchTask: new Ext.util.DelayedTask(function(){
		app.appObj.getController('ReporterTemplateController').doFilter();
	}),
	 boxViweSearchTask: new Ext.util.DelayedTask(function(){
		app.appObj.getController('ReporterTemplateController').boxViewFilter();
		 $('.textView').highlight(Ext.getCmp('reportlivesearchList').getValue());

	}),
	userListSearchTask: new Ext.util.DelayedTask(function(){
		app.appObj.getController('ReporterTemplateController').filterMultiselect();
	}),
	init: function () 
	{

		this.control({

			'reportbuilderboxview textfield[name="reportlivesearchList"]':
			{
				change:this.typewatchBoxView
			},
			'reportbuildergridalias textfield[name="reportlivesearch"]':
			{
				change:this.typewatch
			},
			'reportbuildergridalias' : {
				'render' : this.onRenderReportBuilderGrid,
				'afterrender' : this.registerDeleteRecordEvent
			},
			'main button[name=addTemplate]' : {
				'click' : this.onClickAddTemplate // fresh template event
			},
			'main button[name=createTemplateButtonList]' : {
				'click' : this.onClickAddTemplate // fresh template event
			},
			'main button[name=templateBackId]' : {
				'click' : this.cancelCreation
			},
			'main button[name=cancelTemplate]' : {
				'click' : this.cancelCreation
			},
			'main button[id=createTemplate]' : {
				'click' : this.onClickTempCreate
			},
			'main button[id=addMoreWidget]' : {
				'click' : this.addMoreWidget
			},
			'main button[name=editTemplateDecs]' : {
				'click' : this.editTemplateDecs
			},
			'main button[id=listofwidget]' : {
				'click' : this.openWidgetList
			},
			'reportdescriptionalias': {
				'afterrender': this.loadAllUser
			},
			'reportdescriptionalias button[name=create]' : {
				'click' : this.onClickCreateBtn
			},
			'reportdescriptionalias button[name=saveEdit]' : {
				'click' : this.saveEditInfo
			},
			'clonetemplate button[name=templateClone]' : {
				'click' : this.onClickCloneBtn
			},
			'reportdataconfiguration radiogroup[id=measureTypeId]' : {
				'change' : this.measureChange
			},
			'reportdataconfiguration [id=previewGraphPanelId]' : {
				'afterrender' : this.loadDummyGraph
			},
			'reportdataconfiguration [id=previewId]' : {
				'click' : this.getPreView
			},
			'reportertemplatetabpane' : {
				'afterrender' : this.restTabPane,
				'tabchange': this.mesTabChange,
				'beforetabchange': this.mesTabBeforeChange,
			},
			'reportertemplatetabpane button[id=addMoreMes]' : {
				'click' : this.addMoreTab
			},
			'reportdataconfigwindow button[id=addwidget]' : {
				'click' : this.addwidgetToGridster
			},
			'reportdataconfigwindow button[id=addWidgetDone]' : {
				'click' : this.addWidgetDone
			},
			'reportdataconfigwindow button[id=widgetListId]' : {
				'click' : this.openWidgetList
			},
			'graphpalettewindow button' :
			{
				'click' : this.setPalette
			},
			'widgetListGrid' : {
				'render' : this.loadListOfWidget,
				'afterrender' : this.registerWidegtDeleteEvent,
			}
		});
	},
	loadDummyGraph:function(obj)
	{
		obj.removeAll();
		chartCollectionVal='';
		Ext.getCmp('previewColor').hide();
		if (Ext.isEmpty(app.erUtils))
		{
			app.erUtils = Ext.widget("erutils");
		}
		if(curChartType == 'bar' || curChartType == 'vertbar'|| curChartType == 'stackedbar'||curChartType == 'verticalstackedbar')
		{
			chartCollectionVal = dummyGraphInfo['bar'];
			chartCollectionVal.chartType='bar';
			if(curChartType == 'vertbar'||curChartType == 'verticalstackedbar' )
			{
				chartCollectionVal.chartType='column';
			}
			if(curChartType == 'stackedbar'||curChartType == 'verticalstackedbar' )
			{
				chartCollectionVal.chartSubType='stacked';
			}
			Ext.getCmp('previewColor').show();
		}
		if(curChartType == 'timeline' || curChartType == 'area')
		{
			chartCollectionVal = dummyGraphInfo['timeline'];
			chartCollectionVal.chartType='';
			if(curChartType == 'area' )
			{
				chartCollectionVal.chartType='stack';
			
			}
			Ext.getCmp('previewColor').show();
		}
		if(curChartType == 'distributedPie' || curChartType == 'distribution')
		{
			chartCollectionVal = dummyGraphInfo['pie'];
			Ext.getCmp('previewColor').show();
		}
		if(chartCollectionVal.title!=undefined && chartCollectionVal.title!='')
		{
			obj.add({
				xtype:'container',
				html:'<div class="font_normal11" style="text-align:center;height:20px;">'+chartCollectionVal.title+'</div>',
			});
		}
		obj.add({xtype:'previewGraph'});
	},
	loadLiveData:function(chartType)
	{
		var obj = Ext.getCmp('previewGraphPanelId');
		obj.removeAll();
		if (Ext.isEmpty(app.erUtils))
		{
			app.erUtils = Ext.widget("erutils");
		}
		if(chartCollectionVal.title!=undefined && chartCollectionVal.title.trim()!='')
		{
			obj.add({
				xtype:'container',
				html:'<div class="font_normal11" style="text-align:center;height:20px;">'+chartCollectionVal.title+'</div>',
			});
		}
		else if(Ext.getCmp('WidgetNametextField')!=undefined && Ext.getCmp('WidgetNametextField').getValue().trim()!='' )
		{
			obj.add({
				xtype:'container',
				html:'<div class="font_normal11" style="text-align:center;height:20px;">'+Ext.getCmp('WidgetNametextField').getValue()+'</div>',
			});
		}
		obj.add({xtype:'previewGraph'});
	},
	ajaxQueryMaker:function(obj)
	{
		var objId = obj.id;
		var url='/final/reporter/ReporterTemplateController.jsp';
		var param;
		var val = Ext.getCmp('measureTypeId').getValue().measureType;
		var er_testTypeVal = '';
		activeTabNo = obj.measureTabCount;
		if(val=="DDMeasure")
		{
			er_testTypeVal = 'Details';
		}
		else if(val=='normalMeasure')
		{	
			er_testTypeVal = 'Measures';
		}
		if (objId.indexOf('er_compType')>-1)
		{
			if(Ext.getCmp('er_compType'+obj.measureTabCount).getValue()=='-1')
				return;
			app.method='comptypechange';
			param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType'+obj.measureTabCount).getValue()+"&er_testType="+er_testTypeVal+"&chartType="+curChartType;
		}
		else if (objId.indexOf('er_test')>-1)
		{
			app.method='testchange';
			Ext.getCmp("ddGroupInfoTxtField"+obj.measureTabCount).setValue('');
			Ext.getCmp("ddGroupInfoTxtField"+obj.measureTabCount).fieldValues='';
			param='method='+app.method+'&er_test='+Ext.getCmp('er_test'+obj.measureTabCount).getValue()+"&chartType="+curChartType+"&er_testType="+er_testTypeVal;

		}
		else if (objId.indexOf('er_measure')>-1)
		{
			var component = Ext.ComponentManager.get('disp_MeasureName'+obj.measureTabCount);
			
			app.method='measureChange';
			param='method='+app.method+'&er_measure='+Ext.getCmp('er_measure'+obj.measureTabCount).getValue()+"&chartType="+curChartType+"&er_testType="+er_testTypeVal+'&er_test='+Ext.getCmp('er_test'+obj.measureTabCount).getValue();
		}
		else if (objId.indexOf('er_ddColumn')>-1)
		{			
			app.method='ddMeasureChange';
			param='method='+app.method+'&er_ddColumn='+Ext.widget("erutils").specialCharEncode(Ext.getCmp('er_ddColumn'+obj.measureTabCount).getValue())+'&er_measure='+Ext.getCmp('er_measure'+obj.measureTabCount).getValue()+"&chartType="+curChartType+"&er_testType="+er_testTypeVal+'&er_test='+Ext.getCmp('er_test'+obj.measureTabCount).getValue();
		}
		else  if (objId.indexOf('er_function')>-1)
		{
			app.method='onFunctionChange';
			//param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType'+obj.measureTabCount).getValue()+"&er_testType="+er_testTypeVal+"&chartType="+curChartType+'&er_function='+Ext.widget("erutils").specialCharEncode(erFuncValue);
		}
		else if(objId.indexOf('er_descFilter')>-1)
		{
			app.method='infoChange';
			param='method='+app.method+'&er_test='+Ext.getCmp('er_test'+obj.measureTabCount).getValue()+"&chartType="+curChartType;
		}
		if(param!=undefined && param.length>0)
			this.callAjax(url,param);	
	},
	onAjaxSuccess:function()
	{
		if (app.method=='init')
		{
			this.loadComboField('er_compType'+activeTabNo,'componentTypeCombo',null,'selectedComponentTypeCombo',app.templateJson,false,null,false);
			this.loadComboField('er_test'+activeTabNo,'testCombo',null,'selectedTestCombo',app.templateJson,false,null,false);
			this.loadComboField('er_measure'+activeTabNo,'measureCombo',null,'selectedMeasureCombo',app.templateJson,false,null,false);
			this.loadComboField('er_measureFilter'+activeTabNo,'measureFilterCombo',null,'selectedMeasureFilterCombo',app.templateJson,false,null,false);
			var er_test=Ext.getCmp('er_test'+activeTabNo);
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
			{
				this.loadComboField('er_ddColumn'+activeTabNo,'ddColumnCombo',null,'selectedDDcolumnCombo',app.templateJson,false,null,false);
			}
			Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData = app.templateJson.combo.ddColumnCombo
			this.loadComboField('er_function'+activeTabNo,'functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);

			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			if(component != undefined)
			{
				var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
				if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
					displyName = app.templateJson.selectedFields.selectedDispDDcolCombo;
				component.setValue(displyName);
			}
			this.loadComboField('glduration'+activeTabNo,'gldurationCombo',null,'selectedglduration',app.templateJson,false,null,false);
			this.loadComboField('er_descFilter'+activeTabNo,'descFilterCombo',null,'',app.templateJson,false,null,false);
			this.loadComboField('er_top'+activeTabNo,'topNCombo',null,'selectedTopN',app.templateJson,false,null,false);	
			if (!Ext.isEmpty(Ext.getCmp('er_top'+activeTabNo)))
			{
				if(curChartType!='topn')
				{
					//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:['no']});
					Ext.getCmp('No'+activeTabNo).setValue(true);
					Ext.getCmp('er_top'+activeTabNo).hide();
				}
				else
				{
					//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:['yes']});
					Ext.getCmp('Yes'+activeTabNo).setValue(true);
					Ext.getCmp('er_top'+activeTabNo).show();
				}
			}
						
			Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("Measure");
			Ext.getCmp("er_measureFilter"+activeTabNo).setFieldLabel("Measure Filter");
			Ext.getCmp("ddGroupInfoId"+activeTabNo).hide();
			Ext.getCmp("disp_MeasureName"+activeTabNo).show();
			Ext.getCmp("er_ddColumn"+activeTabNo).hide();
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).setValue('');
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).fieldValues='';
			
			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				Ext.getCmp('tabContainer'+activeTabNo).descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField'+activeTabNo);
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
			if(curChartType=='healthWidget')
			{
				Ext.getCmp('er_test'+activeTabNo).hide();
				Ext.getCmp('er_measure'+activeTabNo).hide();
				Ext.getCmp('er_ddColumn'+activeTabNo).hide();
				Ext.getCmp('er_function'+activeTabNo).hide();
				Ext.getCmp('disp_MeasureName'+activeTabNo).hide();
				Ext.getCmp('primGroupByBoxId'+activeTabNo).hide();
				Ext.getCmp('measureTypeId').hide();
			}
		}
		else if (app.method=='comptypechange')
		{
			var totalTab = this.getReportertemplatetabpane().items.length;						
			this.loadComboField('er_test'+activeTabNo,'testCombo',null,'selectedTestCombo',app.templateJson,false,null,false);
			this.loadComboField('er_measure'+activeTabNo,'measureCombo',null,'selectedMeasureCombo',app.templateJson,false,null,false);
			this.loadComboField('er_measureFilter'+activeTabNo,'measureFilterCombo',null,'selectedMeasureFilterCombo',app.templateJson,false,null,false);
			var er_test=Ext.getCmp('er_test'+activeTabNo);
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				this.loadComboField('er_ddColumn'+activeTabNo,'ddColumnCombo',null,'selectedDDcolumnCombo',app.templateJson,false,null,false);
			Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData = app.templateJson.combo.ddColumnCombo;			
			this.loadComboField('er_function'+activeTabNo,'functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);
			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				displyName = app.templateJson.selectedFields.selectedDispDDcolCombo;
			component.setValue(displyName);
			
			this.loadComboField('glduration'+activeTabNo,'gldurationCombo',null,'selectedglduration',app.templateJson,false,null,false);
			Ext.getCmp('er_durationContainer'+activeTabNo).hide();
			
			//this.loadComboField('er_descFilter'+activeTabNo,'descFilterCombo',null,'',app.templateJson,false,null,false);
			var perviousTabdescFilterData;
			if(totalTab > 1)
			{
				var perviousTabId = this.getReportertemplatetabpane().items.items[totalTab-2].id;
				var perviousTabPerfix = perviousTabId.replace('tabContainer','');
				perviousTabdescFilterData = Ext.getCmp('er_descFilter'+perviousTabPerfix).getStore().proxy.reader.rawData;
				Ext.getCmp('er_descFilter'+activeTabNo).getStore().loadRawData(perviousTabdescFilterData);
			}
			else
			{
				perviousTabdescFilterData = Ext.getCmp('er_descFilter'+activeTabNo).getStore().proxy.reader.rawData;
			}
			Ext.getCmp('er_descFilter'+activeTabNo).setValue(perviousTabdescFilterData[0].valueField);
			Ext.getCmp('descIncluderId'+activeTabNo).hide();
			
			this.loadComboField('er_top'+activeTabNo,'topNCombo',null,'selectedTopN',app.templateJson,false,null,false);
			if (!Ext.isEmpty(Ext.getCmp('er_top'+activeTabNo)))
			{
				if(curChartType!='topn')
				{
					//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:['no']});
					Ext.getCmp('No'+activeTabNo).setValue(true);
					Ext.getCmp('er_top'+activeTabNo).hide();
				}
				else
				{
					//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:['yes']});
					Ext.getCmp('Yes'+activeTabNo).setValue(true);
					Ext.getCmp('er_top'+activeTabNo).show();
				}
			}
			
			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				Ext.getCmp('tabContainer'+activeTabNo).descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField'+activeTabNo);
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
			if(curChartType=='healthWidget')
			{
				Ext.getCmp('er_test'+activeTabNo).hide();
				Ext.getCmp('er_measure'+activeTabNo).hide();
				Ext.getCmp('er_ddColumn'+activeTabNo).hide();
				Ext.getCmp('er_function'+activeTabNo).hide();
				Ext.getCmp('disp_MeasureName'+activeTabNo).hide();
				Ext.getCmp('primGroupByBoxId'+activeTabNo).hide();
				Ext.getCmp('measureTypeId').hide();
			}
		}
		else if (app.method=='testchange')
		{
			this.loadComboField('er_measure'+activeTabNo,'measureCombo',null,'selectedMeasureCombo',app.templateJson,false,null,false);
			this.loadComboField('er_measureFilter'+activeTabNo,'measureFilterCombo',null,'selectedMeasureFilterCombo',app.templateJson,false,null,false);
			var er_test=Ext.getCmp('er_test'+activeTabNo);
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				this.loadComboField('er_ddColumn'+activeTabNo,'ddColumnCombo',null,'selectedDDcolumnCombo',app.templateJson,false,null,false);
			Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData = app.templateJson.combo.ddColumnCombo;
			// no action on function combo
			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				displyName = app.templateJson.selectedFields.selectedDispDDcolCombo;
			if(displyName != null && displyName.indexOf('(')>-1)
				displyName = displyName.substring(0,displyName.indexOf('('));
			component.setValue(displyName);
			
			Ext.getCmp('glduration'+activeTabNo).setValue('None');
			Ext.getCmp('er_durationContainer'+activeTabNo).hide();

			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField'+activeTabNo);
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
			
			this.onSelectDescFilter(Ext.getCmp('er_descFilter'+activeTabNo));
		}
		else if(app.method=='measureChange')
		{
			var er_test=Ext.getCmp('er_test'+activeTabNo);
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				this.loadComboField('er_ddColumn'+activeTabNo,'ddColumnCombo',null,'selectedDDcolumnCombo',app.templateJson,false,null,false);
			Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData = app.templateJson.combo.ddColumnCombo;
			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				displyName = app.templateJson.selectedFields.selectedDispDDcolCombo;
			if(displyName != null && displyName.indexOf('(')>-1)
				displyName = displyName.substring(0,displyName.indexOf('('));
			component.setValue(displyName);
			this.loadComboField('er_function'+activeTabNo,'functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);
			//Ext.getCmp('er_measureFilter'+activeTabNo).setValue(app.templateJson.selectedFields.selectedMeasureFilterCombo);
			this.loadComboField('er_measureFilter'+activeTabNo,'measureFilterCombo',null,'selectedMeasureFilterCombo',app.templateJson,false,null,false);
		}
		else if(app.method=='ddMeasureChange')
		{
			var er_test=Ext.getCmp('er_test'+activeTabNo);
			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			var displyName = app.templateJson.selectedFields.selectedDispMeasureCombo;
			if(er_test != undefined && er_test.getValue() != undefined && er_test.getValue().indexOf("_DDD")>-1)
				displyName = app.templateJson.selectedFields.selectedDispDDcolCombo;
			if(displyName != null && displyName.indexOf('(')>-1)
				displyName = displyName.substring(0,displyName.indexOf('('));
			component.setValue(displyName);
			this.loadComboField('er_function'+activeTabNo,'functionCombo',null,'selectedFunctionCombo',app.templateJson,false,null,false);
			Ext.getCmp('er_measureFilter'+activeTabNo).setValue(app.templateJson.selectedFields.selectedMeasureFilterCombo);
		}
		else if (app.method=='onFunctionChange')
		{
			Ext.getCmp('er_durationContainer'+activeTabNo).hide();
			this.loadComboField('glduration'+activeTabNo,'gldurationCombo',null,'selectedglduration',app.templateJson,false,null,false);
		}
		else if (app.method=='infoChange')
		{
			if(app.templateJson.combo.hasOwnProperty('descriptorCombo'))
			{
				Ext.getCmp('tabContainer'+activeTabNo).descriptorCombo=app.templateJson.combo.descriptorCombo;
				var descriptorTxtField=Ext.getCmp('descriptorTxtField'+activeTabNo);
				descriptorTxtField.setValue(app.templateJson.combo.descriptorCombo[0].valueField);
			}
		}
		else if (app.method=='getini' || app.method=='deleteAndGetIni')
		{
			if(app.templateJson.status=='success')
			{
				this.loadGridData();
			}
		}
		else if (app.method=='setini')
		{
			if (app.templateJson.status=='success')
			{
				Ext.getCmp("reportlivesearch").setValue("");
				var message='Report template is created successfully! Do you want to generate the report now?';
				if(app.updateTemplate)
				{
					app.updateTemplate=false;
					message='Report template is updated successfully! Do you want to generate the report now?'
				}
				
				var me=this;
				Ext.Msg.show({
					title : 'eG custom report',
					msg : message,
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							//var tempParam=app.infoParams;
							me.generateFromListView(app.templateJson.templateName);
						}
						else
						{
							Ext.getCmp('reportbuildertop').show();
							if(app.isCustomLayout=='no')
							{
								me.getReportdataconfigwindow().doClose();
							}
							else
							{
								Ext.getCmp('reportergridstackpanel')._removeAllWidget();
								Ext.getCmp('gridsterstackpanel').hide();
								if (!Ext.isEmpty(me.getCustomwindow()))
								{
									me.getCustomwindow().doClose();
								}

							}
							me.onRenderReportBuilderGrid();//to load ini entries in report builder grid (Shows all templates details)
							me.viweHomePage();
						}

					}
				});
			}
			else
				this.getMessageBox('eG Custom Reports',app.templateJson.msg);
		}
		else if (app.method=='getTemplateInfo')
		{
			if (app.templateJson.status=='success')
			{
				this.onClickCreateBtn(Ext.getCmp('reportbuildergridid'));
			}
			else
			{
				this.getMessageBox('eG Custom Reports',app.templateJson.status);
			}
		}
		else if (app.method=='loadTemplateInfo')
		{
			if (app.templateJson.hasOwnProperty('templateInfo'))
			{
				var templateInfo=app.templateJson.templateInfo;
				app.isCustomLayout=templateInfo.isCustomLayout;
				if (templateInfo.isCustomLayout=='yes')
				{
					var isDataPersent=false;
					if (!Ext.isEmpty(Ext.getCmp('gridsterstackpanel')))
					{
						if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
						{
							Ext.getCmp('reportergridstackpanel')._removeAllWidget();
						}
						Ext.getCmp('gridsterstackpanel').show();
					}
					Ext.getCmp('reportbuildertop').hide();
					Ext.getCmp('listViewBtnId').hide();
					Ext.getCmp('gridViewBtnId').hide();
					for (var key in templateInfo.widgetList)
					{
						var widget=templateInfo.widgetList[key];
						var widgetObj=templateInfo[widget];
						widgetObj['wigId']=widget;
						if (!Ext.isEmpty(widgetObj))
						{
							var noResize = false;
							if(widgetObj.chartType=='digital' || widgetObj.chartType=='multiDigi' || widgetObj.chartType=='healthWidget')
							{
								noResize = true;
							}
							var dyId = 'widget'+(Ext.getCmp('reportergridstackpanel').count++);
							var wid = {
								x: widgetObj.y-1,
								y: widgetObj.x-1,
								width: widgetObj.size_x,
								height: widgetObj.size_y,
								autoPosition: true,
								minWidth: undefined,
								maxWidth: undefined,
								minHeight: undefined,
								widgetType: widgetObj.headerDescription,
								maxHeight: undefined,
								curChartType:widgetObj.chartType,
								widgetConfig:widgetObj,
								iconCls:'iconRight',
								configuredCls:'configuredWidgetDummy',
								selectedPaletteColor:widgetObj.selectedPaletteColor,
								editableObj:widgetObj.editableObj,
								id: dyId,
								//id: Ext.id(),
								noResize: noResize
							}
							Ext.getCmp('reportergridstackpanel').addWidget(wid);
							Ext.getCmp('reportergridstackpanel')._serialization();
							isDataPersent=true;
						}
					}
					if (isDataPersent)
					{
						Ext.getCmp('editTemplateDecs').show();
						Ext.getCmp("createTemplate").setText("UPDATE TEMPLATE");
						var templateNameDisp = mainWindowTitle;
						if(templateNameDisp.indexOf('.')>-1)
						{
							templateNameDisp = templateNameDisp.substring(templateNameDisp.lastIndexOf('.')+1);
						}
						templateNameDisp = app.erUtils.specialCharDecode(templateNameDisp);
						Ext.getCmp('mainWindowHeader').update('<div class="newFont_bold14">'+templateNameDisp+'</div>');
						app.updateTemplate=true;
						this.getMain().doComponentLayout();
						Ext.getCmp('reportergridstackpanel').doComponentLayout();
					}
				}
			}
			else
			{
				this.getMessageBox('eG Custom Reports','No template info data found to load ...');
			}
		}
		else
		{
			console.log('No action done');
		}
	},
	viweHomePage:function()
	{
		Ext.getCmp('reportbuildertop').show();
		if(defaultView=='boxView'){
			Ext.getCmp('reportBuilderBoxViewPage').show();
			Ext.getCmp('reportbuildergridid').hide();
		}
		else{
			Ext.getCmp('reportBuilderBoxViewPage').hide();
			Ext.getCmp('reportbuildergridid').show();
		}
		var thisMain= Ext.getCmp('reportTemplateMain');
		thisMain.doLayout();
		thisMain.doComponentLayout();
		Ext.getCmp('listViewBtnId').show();
		Ext.getCmp('gridViewBtnId').show();
		Ext.getCmp('mainWindowHeader').update('<div class="newFont_bold14">eG Custom Reports</div>');
	},
	callAjax:function(url,param)
	{
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}
		initLdgMask.show();
		var me=this;
		Ext.Ajax.request({
			url:url,
			params:param,
			scope:this,
			async:false,
			success : function(response){
				initLdgMask.hide();
				app.templateJson=Ext.decode(response.responseText);
				if(!Ext.isEmpty(app.templateJson))
					me.onAjaxSuccess();
			},
			faliure:function(err){
				Ext.MessageBox.alert('Error occured in ReporterTemplateController.jsp page');
			}
		});
		params=null;delete params;
	},
	onRenderReportBuilderGrid:function(obj)
	{
		app.method='getini';
		var url='/final/reporter/ReporterTemplateController.jsp';
		var param='method='+app.method+"&builderType="+app.builderType;
	//	console.log(param);
		this.callAjax(url,param);
	},
	loadGridData:function()
	{
		this.getMain().setAutoScroll(false);
		var dataArray=app.templateJson.gridData;
		var datArray=this.getReportbuildergridalias().dataArray;
		var dummyArray=this.getReportbuildergridalias().dummyArray;

		var dataViewIdObj=Ext.getCmp('dataViewId');
		var boxViewDummyArray=this.getReportbuilderboxview().dummyArray;
		dataViewIdObj.getStore().removeAll();
		boxViewDummyArray.splice(0, boxViewDummyArray.length);
		dataViewIdObj.getStore().loadRawData(app.templateJson.listViewData);
		if(app.templateJson.dummyGraphData!=undefined)
			dummyGraphInfo = app.templateJson.dummyGraphData;
		for(var i=0;i<app.templateJson.listViewData.length;i++)
		{
			boxViewDummyArray.push(dataArray[i]);
		}
		this.getReportbuildergridalias().getStore().removeAll();

		datArray.splice(0, datArray.length);
		dummyArray.splice(0, dummyArray.length);
		tempTitleAry=[];//....
		
		for(var i=0;i<dataArray.length;i++)
		{
			tempTitleAry.push(dataArray[i].templateNameDisp.toLowerCase());
			datArray.push(dataArray[i]);
			dummyArray.push(dataArray[i]);
		}
		if(app.builderType == 'generate')
		{
			Ext.getCmp('reportbuildergridid').headerCt.child('gridcolumn[isCheckerHd]').hide();
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharing]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=createdDate]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=goColumn]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=modify]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=remove]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[id=addTemplate]').setVisible(false);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharedBy]').setVisible(true);
			Ext.getCmp('reportbuildergridid').down('[dataIndex=clone]').setVisible(false);
			Ext.getCmp('gridViewBtnId').hide();
			Ext.getCmp('listViewBtnId').hide();
			Ext.getCmp('backToReport').hide();
		}
		else
			Ext.getCmp('reportbuildergridid').down('[dataIndex=sharedBy]').setVisible(false);

		var curpage=this.getReportbuildergridalias().activePage;
		var totalCount=this.getReportbuildergridalias().getStore().totalCount;
		var pageSize=this.getReportbuildergridalias().getStore().pageSize;
		if(Math.round(totalCount/pageSize)<curpage)
		{
			this.getReportbuildergridalias().activePage=Math.round(totalCount/pageSize);
		}
		if(this.getReportbuildergridalias().activePage<=0)
			this.getReportbuildergridalias().activePage=1;
		this.getReportbuildergridalias().getStore().loadPage(this.getReportbuildergridalias().activePage);
	},
	typewatch:function(field, event)
	{
		 this.searchTask.delay(500);
	},
	typewatchBoxView:function(field, event)
	{
		 this.boxViweSearchTask.delay(500);
	},
	typewatchUserList:function(field, event)
	{
		 this.userListSearchTask.delay(500);
	},
	boxViewFilter:function()
	{
		var field=Ext.getCmp('reportlivesearchList');
		var dataViewIdObj=Ext.getCmp('dataViewId');
		var dummyArray=this.getReportbuilderboxview().dummyArray;
		var listViewData=[];
		dataViewIdObj.getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			listViewData.splice(0, listViewData.length);

			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					if(property=="templateName" || property=="templateTitle" || property=="templateDescription")
						if(property=="templateName")
						{
							value = app.erUtils.specialCharDecode(value);
						}
						match =match || regex.test(String(value));
				});
				if(match)
					listViewData.push(obj);
			}
		}
		else
		{
			listViewData.splice(0, listViewData.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				listViewData.push(obj);
			}
		}
		dataViewIdObj.getStore().loadRawData(listViewData);
		field.focus();
	},
	doFilter:function()
	{
		var me=this;
		var field=Ext.getCmp('reportlivesearch');
		var dataArray=this.getReportbuildergridalias().dataArray;
		var dummyArray=this.getReportbuildergridalias().dummyArray;
		this.getReportbuildergridalias().getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					if(property=="templateName" || property=="templateTitle" || property=="templateDescription")
						match =match || regex.test(String(value));
				});
				if(match)
					dataArray.push(obj);
			}
			this.getReportbuildergridalias().getStore().loadRawData(dataArray);
		}
		else
		{
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			this.getReportbuildergridalias().getStore().loadRawData(dataArray);
			this.getReportbuildergridalias().getStore().loadPage(this.getReportbuildergridalias().activePage);
		}
		field.focus();
	},
	filterMultiselect:function()
	{
		var searchFieldObj = Ext.getCmp('userSearch');
		var comboObj = Ext.getCmp('user_list');
		var compStore = app.userCombo;
		var findVal = searchFieldObj.getValue().toLowerCase();
		if (Ext.isEmpty(findVal))
		{
			comboObj.getStore().removeAll();
			comboObj.getStore().loadRawData(compStore);
			comboObj.getSelectionModel().deselectAll();
		} 
		else 
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			});
			for (var i = 0; i < compStore.length; i++) {
				var valueFied = compStore[i]['valueField'].toLowerCase();				
				var getRecord = compStore[i]['displayField'].toLowerCase();
				if (getRecord.indexOf(findVal) > -1) {
					isRecordFound = true;
					genStore.add({
						'displayField': compStore[i]['displayField'],
						'valueField': compStore[i]['valueField']
					});
				}
			}
			if (isRecordFound) 
			{
				comboObj.getStore().removeAll();
				for (var i = 0; i < genStore.getCount(); i++) 
				{
					var getRecord = genStore.getAt(i);
					comboObj.getStore().add(getRecord);
				}
			} 
			else 
			{
				comboObj.getStore().removeAll();
				comboObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
			}
		}
		searchFieldObj.focus();
	},
	getTemplateInfo:function(templateName)
	{
		var record = new Object();
		record.templateName=templateName;
		if(!Ext.isEmpty(Ext.getCmp("updateConfigBtn")))
			Ext.getCmp("updateConfigBtn").setText("Update to Widget");
		isEditTemplate=true;
		var url='/final/reporter/ReporterTemplateController.jsp';
		app.method='getTemplateInfo';
		var param='method='+app.method+'&recordInfo='+Ext.encode(record);
		this.callAjax(url,param);
	},
	onClickAddTemplate:function(obj)
	{
		app.isfreshTemplate='yes';
		curChartType='bar';
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle("Create New Template");
		this.getCustomwindow().add({xtype:'reportdescriptionalias'});
		this.getCustomwindow().show();		
		Ext.getCmp("templateName").setReadOnly(false);
		Ext.getCmp("templateName").setValue('');
		Ext.getCmp("templateName").focus(false, 200);
	},
	onClickCloneTemplate:function(tempName)
	{
		app.orginalTemplate=tempName;
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle("Create Clone Template");
		this.getCustomwindow().add({xtype:'clonetemplate'});
		this.getCustomwindow().show();
	},
	onClickCloneBtn:function(obj)
	{
		var clonedTemplateName=Ext.getCmp('clonedTemplateName').getValue();
		clonedTemplateName = app.erUtils.specialCharEncode(clonedTemplateName);
		if(clonedTemplateName=="" || clonedTemplateName.trim().length==0)
		{
			this.getMessageBox('eG Custom Reports','Template name should not be empty');
			return;
		}
		if(!checkspecial(clonedTemplateName,"`~!@#$%^&*+={}[]|\\:;\"'<>,.?/"))
		{
			Ext.Msg.show({title:"Alert",msg:_checkspecial,buttons:Ext.Msg.OK,icon:Ext.Msg.WARNING});
			return false;
		}

		 if(tempTitleAry.length>0 && tempTitleAry.indexOf(clonedTemplateName.toLowerCase())>-1){
			this.getMessageBox('eG Custom Reports','Template name already exists.');
			return;
		}
		app.isCustomLayout='yes';
		app.method='setini';
		var iniParams='&method=cloneIni&isCustomLayout='+app.isCustomLayout;
		iniParams+='&orginalTemplate='+app.orginalTemplate+'&clonedTemplateName='+clonedTemplateName;
		var url='/final/reporter/ReporterTemplateController.jsp';
		if(iniParams!=undefined && iniParams!='undefined')
		{
			this.callAjax(url,iniParams);
		}
	},
	onClickCreateBtn:function(obj)
	{
		if(app.isfreshTemplate=='yes')
		{
			app.isCustomLayout='yes';
		}
		var templateName;
		var templateDescription;
		var sharing;
		var userList;
		var user_List=[];
		if (obj.getId()=='reportbuildergridid' && app.method=='getTemplateInfo')
		{
			templateName=app.templateJson.templateInfo.templateName;
			templateDescription=app.templateJson.templateInfo.templateDescription;
			sharing=app.templateJson.templateInfo.sharing;
			//userList=app.templateJson.templateInfo.userList;
			user_List=(app.templateJson.templateInfo.userList).split(',');

		}
		else if (obj.getId()=='create')
		{
			isEditTemplate=false;
			app.method=null;
			templateName=Ext.getCmp('templateName').getValue();
			templateName = app.erUtils.specialCharEncode(templateName);
			//templateTitle=Ext.getCmp('templateTitle').getValue();
			templateDescription=Ext.getCmp('templateDescription').getValue();
			
			if(Ext.getCmp('privateId2').pressed)
				sharing="Private";
			else if(Ext.getCmp('PublicId2').pressed)
				sharing="Public";
			else if(Ext.getCmp('shareId2').pressed)
			{
				sharing="Share";

				userList=Ext.getCmp('user_list');
				var selectedUser=userList.getSelectionModel().getSelection();
			}

			if(templateName=="" || templateName.length==0)
			{
				this.getMessageBox('eG Custom Reports','Template name should not be empty');
				return;
			}
			if(!checkspecial(templateName,"`~!@#$%^&*+={}[]|\\:;\"'<>,.?/"))
			{
				Ext.Msg.show({title:"Alert",msg:_checkspecial,buttons:Ext.Msg.OK,icon:Ext.Msg.WARNING});
				return false;
			}

			 if(tempTitleAry.length>0 && tempTitleAry.indexOf(templateName.toLowerCase())>-1){
				this.getMessageBox('eG Custom Reports','Template name already exists.');
				return;
			}

			if(sharing=="Share")
			{
				if(selectedUser=="" || selectedUser.length==0)
				{
					this.getMessageBox('eG Custom Reports','Please Select User list');
					return;
				}
				else
				{
					for (var i=0;i<selectedUser.length;i++)
					{
						var row = userList.getSelectionModel().getSelection()[i];
						user_List.push(row.data.valueField)
					}
				}
			}
			mainWindowTitle = templateName;
			Ext.getCmp("createTemplate").setText("FINISH TEMPLATE");
		}

		if (!Ext.isEmpty(this.getCustomwindow()))
		{
			this.getCustomwindow().doClose();
		}

 		app.infoParams='templateName='+templateName+'&templateDescription='+Ext.widget("erutils").specialCharEncode(templateDescription)+'&sharing='+sharing+'&userList='+user_List;
		if (app.method=='getTemplateInfo')
		{
			app.method='loadTemplateInfo';
			var templateInfo=app.templateJson.templateInfo;
			app.isCustomLayout=templateInfo.isCustomLayout;
			if (templateInfo.isCustomLayout=='yes')
			{
				mainWindowTitle = templateName;
			}
			this.onAjaxSuccess();
		}
		else
		{
			this.openConfigurationWindow();
		}

	},
	addMoreWidget:function()
	{
		isEditTemplate=false;
		curChartType = 'bar';
		this.openConfigurationWindow();
	},
	openConfigurationWindow:function()
	{
		if (!Ext.isEmpty(Ext.getCmp('configWidgetWindowId')))
			Ext.getCmp('configWidgetWindowId').doClose();
		Ext.widget('reportdataconfigwindow');
		this.getReportdataconfigwindow().show();
		var templateNameDisp = mainWindowTitle;
		if(templateNameDisp.indexOf('.'))
		{
			templateNameDisp = templateNameDisp.substring(templateNameDisp.lastIndexOf('.')+1);
		}
		templateNameDisp = app.erUtils.specialCharDecode(templateNameDisp);
		this.getReportdataconfigwindow().setTitle('Config Report Template ('+templateNameDisp+')');
	},
	openWidgetList:function()
	{
		var url="ReporterTemplateController.jsp";
		var me=this;
		Ext.Ajax.request({
			url:url,
			params:'method=listWidgetPopup',
			//async:isAsync,
			success : function(response){
				var gridster_items = 0;
				if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
				{
					var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
					gridster_items = GridStackUI.Utils.sort(gridstackdata);
				}
				if(gridster_items==0 || gridster_items=='0')
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please add the widget to list',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
				Ext.widget({
					xtype:'configWidgetWindow',
					modal: true});
				me.getConfigWidgetWindow().show();
			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ReportTemplateController.jsp page');
			}
		});
	},
	addwidgetToGridster:function()
	{
		var statusObj = this.validateTabPaneInfo()
		if (!statusObj)
		{
			return;
		}
		else
		{
			var winId = Ext.getCmp('reportdataconfigwindowid');
			if(winId!=undefined && winId!='undefined')
			{
				if (winId.modal)
				{
					Ext.fly(winId.dom).removeCls('windowModal');
				}
			}
			app.isCustomLayout='yes';

			Ext.getCmp('reportbuildertop').hide();
			Ext.getCmp('tempCreate').hide();

			Ext.getCmp('listViewBtnId').hide();
			Ext.getCmp('gridViewBtnId').hide();


			Ext.getCmp('reportBuilderBoxViewPage').hide();
			Ext.getCmp('reportbuildergridid').hide();

			var templateNameDisp = mainWindowTitle;
			if(templateNameDisp.indexOf('.')>-1)
			{
				templateNameDisp = templateNameDisp.substring(templateNameDisp.lastIndexOf('.')+1);
			}
			templateNameDisp = app.erUtils.specialCharDecode(templateNameDisp);
			Ext.getCmp('mainWindowHeader').update('<div class="newFont_bold14">'+templateNameDisp+'</div>');
			
			if(Ext.getCmp('gridsterstackpanel')!=undefined)
			{
				Ext.getCmp('gridsterstackpanel').show();
			}
			var noResize = false;
			var xpos=1;
			var ypos=1;
			var xlength=6;
			//var ylength=3;
			var ylength=4; //.. increase the height of each panel
			if(curChartType=='digital')
			{
				//xlength=3;
				//ylength=3;
				xlength=3;
				ylength=2;
				noResize = true;
			}
			if(curChartType=='multiDigi')
			{
				xlength=12;
				ylength=2;
				noResize = true;
			}
			if(curChartType=='healthWidget')
			{
				xlength=12;
				ylength=3;
				noResize = true;
			}
			var widgetConfig = this.getReportertemplatetabpane().widgetConfig;
			var widgetTitle = Ext.getCmp('WidgetNametextField').getValue();
			var perviewColor = Ext.getCmp('previewColor').selectedGraphPalette;
			widgetConfig.selectedPaletteColor=perviewColor;
			widgetConfig.selectedGraphPalette=perviewColor;
			if(app.currentWidget!=null)
			{
				app.currentWidget.widgetConfig=widgetConfig;
				app.currentWidget.editableObj=statusObj;
				app.currentWidget.selectedPaletteColor=perviewColor;
				app.currentWidget.selectedGraphPalette=perviewColor;
				app.currentWidget.setTitle(widgetTitle);
				this.addWidgetDone();
				/* Ext.get(app.currentWidget.getHeader().id).setStyle({'visibility':'visible'});
				var toolId=app.currentWidget.getHeader().tools[0].id;
				Ext.getCmp(toolId).hide(); */
			}
			else
			{
				var dyId = 'widget'+(Ext.getCmp('reportergridstackpanel').count++);
				var wid = {
					x: xpos-1,
					y: ypos-1,
					width: xlength,
					height: ylength,
					autoPosition: true,
					minWidth: undefined,
					maxWidth: undefined,
					minHeight: undefined,
					widgetType: widgetTitle,
					maxHeight: undefined,
					curChartType:curChartType,
					widgetConfig:widgetConfig,
					iconCls:'iconRight',
					configuredCls:'configuredWidgetDummy',
					selectedPaletteColor:perviewColor,
					selectedGraphPalette:perviewColor,
					editableObj:statusObj,
					id: dyId,
					//id: Ext.id(),
					noResize: noResize
				}
				Ext.getCmp('reportergridstackpanel').addWidget(wid);
				Ext.getCmp('reportergridstackpanel')._serialization();
				this.updateChartCountCircle(curChartType,true);
			}
		}
	},
	validateTabPaneInfo:function()
	{
		var me = this;
		var totalTab = me.getReportertemplatetabpane().items.length;
		var totalMeaureAry = new Array();
		if((Ext.getCmp('WidgetNametextField').getValue().trim()).length==0)
		{
			this.getCallbackMessageBox('eG Custom Reports','Please enter widget name','showConfigTab');
			return false;
		}		
		me.getReportertemplatetabpane().widgetConfig = new Object();
		var ids;
		var groupByVal = new Array();
		var topN_val='';
		// Duplicate Checking
		if(curChartType=="multiDigi" && totalTab>5)
		{
			this.getMessageBox('eG Custom Reports','Cannot add More than five measures');
			return false;
		}
		for(var i=0; i<totalTab; i++)
		{
			var currentTabIndex = me.getReportertemplatetabpane().items.items[i].measureTabCount;
			var er_function=Ext.getCmp('er_function'+currentTabIndex);
			var disp_MeasureName=Ext.getCmp('disp_MeasureName'+currentTabIndex);
			var er_measureDisp=Ext.getCmp('er_measure'+currentTabIndex).getRawValue();
			var er_functionVal = er_function.getValue().trim();
			var compChkBtn = Ext.getCmp('primgroupbyComp'+currentTabIndex);
			var desChkBtn = Ext.getCmp('primgroupbyDesc'+currentTabIndex);
			var dateChkBtn = Ext.getCmp('primgroupbyDateChk'+currentTabIndex);
			
			if(dateChkBtn.checked)
			{
				var grpInfo=Ext.getCmp('primGroupByDateId'+currentTabIndex).getValue()['primgroupbybox'+currentTabIndex];
				if(i==0)
					groupByVal.push(grpInfo);
			}
			if(compChkBtn.checked)
			{
				if(i==0)
					groupByVal.push('component');
			}
			if(desChkBtn.checked)
			{
				if(i==0)
					groupByVal.push('descriptors');
			}
			
			if(er_functionVal.toUpperCase()=='AVERAGE')
			{
				er_functionVal='Avg';
			}
			else if(er_functionVal.toUpperCase()=='MAXIMUM')
			{
				er_functionVal='Max';
			}
			else if(er_functionVal.toUpperCase()=='MINIMUM')
			{
				er_functionVal='Min';
			}
			var displayNameFinal = disp_MeasureName.getValue()+' ('+er_functionVal+')';
			if(er_measureDisp.indexOf("(")>-1 && er_measureDisp.indexOf(")")>-1)
					er_measureDisp=er_measureDisp.substring(er_measureDisp.lastIndexOf("(")+1,er_measureDisp.lastIndexOf(")"));
			var diffMesRange=false;
			var functionFound=false;
			for(var j=0; j<totalTab; j++)
			{
				var currentTabIndex_temp = me.getReportertemplatetabpane().items.items[j].measureTabCount;
				if(currentTabIndex_temp==currentTabIndex)
					continue;
				var er_function_temp=Ext.getCmp('er_function'+currentTabIndex_temp);
				var disp_MeasureName_temp=Ext.getCmp('disp_MeasureName'+currentTabIndex_temp);
				var er_measure_temp = Ext.getCmp('er_measure'+currentTabIndex_temp);
				var er_functionVal_temp = er_function_temp.getValue().trim();
				
				if(er_functionVal.toUpperCase()=='AVERAGE')
					er_functionVal_temp='Avg';
				else if(er_functionVal_temp.toUpperCase()=='MAXIMUM')
					er_functionVal_temp='Max';
				else if(er_functionVal_temp.toUpperCase()=='MINIMUM')
					er_functionVal_temp='Min';
				
				var displayNameFinal_temp = disp_MeasureName_temp.getValue()+' ('+er_functionVal_temp+')';
				if(displayNameFinal_temp==displayNameFinal)
				{
					this.getMessageBox('eG Custom Reports','X Axis Label should be unique for each Measure');
					return false;
				}
				if(curChartType!="timeline" && curChartType!="area" && curChartType!="table" && curChartType!="topn" && curChartType!="digital" && curChartType!="multiDigi" && curChartType!="heatMap")
				{
					var mesVal=er_measure_temp.getRawValue();
					if(mesVal.indexOf("(")>-1 && mesVal.indexOf(")")>-1)
						mesVal=mesVal.substring(mesVal.lastIndexOf("(")+1,mesVal.lastIndexOf(")"));
					if (er_measureDisp!=mesVal)
					{
						diffMesRange=true;
					}
					if (er_function.getRawValue()!=er_function_temp.getRawValue())
					{
					  functionFound=true;
					}
				}
			}
			if(diffMesRange)
			{
				this.getMessageBox('eG Custom Reports',"You can't add  different measure units");
				return false;
			}
			if(functionFound)
			{
				this.getMessageBox('eG Custom Reports',"You can't add Different value settings");
				return false;
			}
		}
		if(me.getReportertemplatetabpane().widgetConfig !=null && !Ext.isEmpty(me.getReportertemplatetabpane().widgetConfig.wigId))
		{
			ids=me.getReportertemplatetabpane().widgetConfig.wigId
		}
		else
		{
			ids='widgetInfo'+currWidget;
			currWidget++;
		}
		me.getReportertemplatetabpane().widgetConfig.chartType = curChartType;
		me.getReportertemplatetabpane().widgetConfig.chartConfigArray=new Array();;
		me.getReportertemplatetabpane().widgetConfig.ddChkBoxData=new Array();
		me.getReportertemplatetabpane().widgetConfig.wigId=ids;
		me.getReportertemplatetabpane().widgetConfig.groupBy=groupByVal;
		me.getReportertemplatetabpane().widgetConfig.showMultipleCharts="true";
		if(Ext.getCmp('er_stackedArea').checked)
			me.getReportertemplatetabpane().widgetConfig.er_stackedArea="true";
		else
			me.getReportertemplatetabpane().widgetConfig.er_stackedArea="false";
		if(Ext.getCmp('multiColor').checked)
			me.getReportertemplatetabpane().widgetConfig.multiColor="true";
		else
			me.getReportertemplatetabpane().widgetConfig.multiColor="false";
		if(Ext.getCmp('er_showLegendTable').checked)
			me.getReportertemplatetabpane().widgetConfig.er_showLegendTable="true";
		else
			me.getReportertemplatetabpane().widgetConfig.er_showLegendTable="false";
		var DDGroupAry = new Array();
		var descriptorTxtFieldLabel;
		var descFilterEnable;
		var er_enableTopN;
		var er_top;
		var enableTopN;
		for(var i=0; i<totalTab; i++)
		{
			var currentTabIndex = me.getReportertemplatetabpane().items.items[i].measureTabCount;
			var comboObj = new Object();
			var selectedFieldObj = new Object();
			var measureInfObj = new Object();
			
			var er_testType=Ext.getCmp('measureTypeId');
			var measureTypeVal=er_testType.getValue().measureType;
			var er_testTypeVal = 'Measures';
			if(measureTypeVal=="DDMeasure")
			{
				er_testTypeVal = 'Details';
			}
			var er_compType=Ext.getCmp('er_compType'+currentTabIndex);
			var er_test=Ext.getCmp('er_test'+currentTabIndex);
			var er_measure=Ext.getCmp('er_measure'+currentTabIndex);
			var er_measureFilter=Ext.getCmp('er_measureFilter'+currentTabIndex);
			var er_ddColumn=Ext.getCmp('er_ddColumn'+currentTabIndex);
			var ddGroupInfoTxtField=Ext.getCmp('ddGroupInfoTxtField'+currentTabIndex);
			var er_function=Ext.getCmp('er_function'+currentTabIndex);
			var disp_MeasureName=Ext.getCmp('disp_MeasureName'+currentTabIndex);
			var compChkBtn = Ext.getCmp('primgroupbyComp'+currentTabIndex);
			var desChkBtn = Ext.getCmp('primgroupbyDesc'+currentTabIndex);
			var dateChkBtn = Ext.getCmp('primgroupbyDateChk'+currentTabIndex);
			var yAxisLabel=Ext.getCmp('yAxisLabel'+currentTabIndex);
			var glduration=Ext.getCmp('glduration'+currentTabIndex);
			var gldurationVal=glduration.getValue();
			var er_duration=Ext.getCmp('er_duration'+currentTabIndex);
			var er_dynamic = Ext.getCmp('er_dynamic'+currentTabIndex);
			var er_descFilter=Ext.getCmp('er_descFilter'+currentTabIndex);
			var includeDesc=Ext.getCmp('actionOnDes'+currentTabIndex);
			var digitalSparkFontType=Ext.getCmp('digitalSparkFontType'+currentTabIndex);
			var digitalSparkChartType=Ext.getCmp('digitalSparkChartType'+currentTabIndex);
			var digitalSparkColorPicker=Ext.getCmp('digitalSparkColorPicker'+currentTabIndex);
			var descriptorTxtField=Ext.getCmp('descriptorTxtField'+currentTabIndex);			
			var iconClass=Ext.getCmp('iconClass'+currentTabIndex);			
			var	er_functionVal = er_function.getValue().trim();
			var measureCondtion=Ext.getCmp('er_measurCondition'+currentTabIndex);			
			var measureCritical=Ext.getCmp('measureCritical'+currentTabIndex);			
			var measureMajor=Ext.getCmp('measureMajor'+currentTabIndex);			
			var measureMinor=Ext.getCmp('measureMinor'+currentTabIndex);			
			var measureCondtionVal='';
			var measureCriticalVal='';
			var measureMajorVal='';
			var measureMinorVal='';
			if(measureCondtion.getValue() != undefined)
				measureCondtionVal=measureCondtion.getValue();
			if(measureCritical != undefined)
				measureCriticalVal=measureCritical.getValue();
			if(measureMajor != undefined)
				measureMajorVal=measureMajor.getValue();
			if(measureMinor != undefined)
				measureMinorVal=measureMinor.getValue();
			if(i==0)
			{
				descriptorTxtFieldLabel=Ext.getCmp('descriptorTxtFieldId'+currentTabIndex);
				descFilterEnable=Ext.getCmp('descFilterEnable'+currentTabIndex);
				er_enableTopN=Ext.getCmp('er_enableTopN'+currentTabIndex);
				er_top=Ext.getCmp('er_top'+currentTabIndex);
				enableTopN = er_enableTopN.getValue()['enableTopN'+currentTabIndex];
			}
			if(er_functionVal.toUpperCase()=='AVERAGE')
			{
				er_functionVal='Avg';
			}
			else if(er_functionVal.toUpperCase()=='MAXIMUM')
			{
				er_functionVal='Max';
			}
			else if(er_functionVal.toUpperCase()=='MINIMUM')
			{
				er_functionVal='Min';
			}
			var displayNameFinal = disp_MeasureName.getValue().trim()+' ('+er_functionVal+')';
			
			// validation start
			if(er_compType.getValue()==undefined || er_compType.getValue()=='-1')
			{
				this.getMessageBox('eG Custom Reports','Please choose component types');
				return false;
			}
			if(er_test.getValue()==undefined || er_test.getValue()=='-1')
			{
				this.getMessageBox('eG Custom Reports','Please choose the Test');
				return false;
			}
			if(er_measure.getValue()==undefined || er_measure.getValue()=='-1')
			{
				var msgInfo = 'Measure';
				this.getMessageBox('eG Custom Reports','Please choose the '+msgInfo);
				return false;
			}
			if((er_measureFilter.getValue()==undefined || er_measureFilter.getValue()=='-1') && (curChartType != undefined && curChartType != 'healthWidget'))
			{
				var msgInfo = 'Measure';
				this.getMessageBox('eG Custom Reports','Please choose the '+msgInfo);
				return false;
			}
			if(er_test.getValue().indexOf('DDD')>-1)
			{
				if(er_ddColumn.getValue()==undefined || er_ddColumn.getValue()=='-1')
				{
					var msgInfo = 'DD Columns';
					this.getMessageBox('eG Custom Reports','Please choose the '+msgInfo);
					return false;
				}
			}
			var yLabel='';
			if(compChkBtn.checked && desChkBtn.checked && dateChkBtn.checked)
			{
				yLabel = (yAxisLabel.getValue()).split('/');
				if(yLabel.length!=3)
				{
					this.getMessageBox('eG Custom Reports','Y Axis label should be valid format');
					return false;
				}
			}
			else if(compChkBtn.checked && dateChkBtn.checked)
			{
				yLabel = (yAxisLabel.getValue()).split('/');
				if(yLabel.length!=2)
				{
					this.getMessageBox('eG Custom Reports','Y Axis label should be valid format');
					return false;
				}
			}
			else if(compChkBtn.checked && desChkBtn.checked )
			{
				yLabel = (yAxisLabel.getValue()).split('/');
				if(yLabel.length!=2)
				{
					this.getMessageBox('eG Custom Reports','Y Axis label should be valid format');
					return false;
				}
			}
			else if(desChkBtn.checked && dateChkBtn.checked)
			{
				yLabel = (yAxisLabel.getValue()).split('/');
				if(yLabel.length!=2)
				{
					this.getMessageBox('eG Custom Reports','Y Axis label should be valid format');
					return false;
				}
			}
			else if(compChkBtn.checked || desChkBtn.checked || dateChkBtn.checked)
			{
				if(yAxisLabel.getValue().indexOf('/')>-1)
				{
					this.getMessageBox('eG Custom Reports','Y Axis label should be valid format');
					return false;
				}	
			}
			if(gldurationVal!="cnt" && gldurationVal!="notCnt" && gldurationVal!="like" && gldurationVal!="eq" && gldurationVal!="notEq")
			{
				if(er_duration.getValue()=="")
				{
					this.getMessageBox('eG Custom Reports','Please enter filter data range value');
					return false;
				}
				if (isNaN(parseInt(er_duration.getValue())) || !isFinite(er_duration.getValue()))
				{
					this.getMessageBox('eG Custom Reports','You can add only numeric vaues for certain duration');
					return false;
				}
				else
				{
					if(gldurationVal!="le" && gldurationVal!="lt" && parseInt(er_duration.getValue())<0)
					{
						this.getMessageBox('eG Custom Reports',"Range value can't be less than zero");
						return false;
					}
				}
			}
			if(desChkBtn.checked && descriptorTxtFieldLabel.getValue()=='')
			{
				this.getMessageBox('eG Custom Reports','Please enter Descriptor Header');
				return false;
			}
			if(disp_MeasureName.getValue()=='')
			{
				this.getMessageBox('eG Custom Reports','Please enter X Axis label');
				return false;
			}
			
			//validation end
			//set widget config data start
			if(descriptorTxtFieldLabel.getValue()!='')
				me.getReportertemplatetabpane().widgetConfig.descDisplayName=descriptorTxtFieldLabel.getValue();
			me.getReportertemplatetabpane().widgetConfig.enableMetrics='yes';
			if(compChkBtn.checked )
				me.getReportertemplatetabpane().widgetConfig.enableComp='yes';
			else
				me.getReportertemplatetabpane().widgetConfig.enableComp	='no';
			
			if(desChkBtn.checked )
				me.getReportertemplatetabpane().widgetConfig.enableDesc='yes';
			else
				me.getReportertemplatetabpane().widgetConfig.enableDesc	='no';
			
			me.getReportertemplatetabpane().widgetConfig.yAxisLabel	= yAxisLabel.getValue();
			
			if(er_test.getValue().indexOf('DDD')>-1)
			{
				var DDTxtField = ddGroupInfoTxtField.fieldValues;
				if((DDTxtField!=undefined && DDTxtField.trim().length>0)||(curChartType=='table'&& (er_functionVal=='Raw' || er_functionVal=='None')))
				{
					if(curChartType=='table'&& (er_functionVal=='Raw' || er_functionVal=='None'))
					{
						//var temp = er_measure.getValue()+'$~$'+displayNameFinal+er_measure.getValue();
						var temp = er_measure.getValue();
						if (er_test.getValue().indexOf("_DDD")>-1)
						{
							if(app.templateJson != undefined && app.templateJson.selectedFields != undefined && app.templateJson.selectedFields.ddMeasureCondition != undefined)
							{
								temp+='~'+app.templateJson.selectedFields.ddMeasureCondition;
							}
							temp+='~'+Ext.widget("erutils").specialCharEncode(er_ddColumn.getValue());							
						}
						temp+='$~$'+displayNameFinal;
						if(DDGroupAry.indexOf(temp)==-1)
							DDGroupAry.push(temp.replace("%","EGPERCENTEG"));
					}
					else
					{
						var DDTxtFieldAry = DDTxtField.split(',');
						for(var k = 0; k<DDTxtFieldAry.length; k++)
						{
							var temp = DDTxtFieldAry[k]+'$~$'+displayNameFinal+DDTxtFieldAry[k];
							if(DDGroupAry.indexOf(temp)==-1)
								DDGroupAry.push(temp.replace("%","EGPERCENTEG"));
						}
					}
				}
			}
			me.getReportertemplatetabpane().widgetConfig.ddGroupBy	= DDGroupAry;
			//me.getReportertemplatetabpane().widgetConfig.ddGroupByUI = 
			me.getReportertemplatetabpane().widgetConfig.enableTopN = enableTopN;
			if (enableTopN=='yes')
			{
				me.getReportertemplatetabpane().widgetConfig.basedOnTestMeasure='';
				me.getReportertemplatetabpane().widgetConfig.top=er_top.getValue();
			}
			if(curChartType=="table")
			{
				me.getReportertemplatetabpane().widgetConfig.sortByValue='-1';
			}
			if(curChartType=="vertbar")
			{
				me.getReportertemplatetabpane().widgetConfig.barAlignment = "Vertical";
			}
			else if(curChartType=="bar")
			{
				me.getReportertemplatetabpane().widgetConfig.barAlignment = "Horizontal";
			}
			if(er_dynamic.checked)
			{
				gldurationVal='dynamic'+gldurationVal;
			}
			if(gldurationVal.length>0 && (gldurationVal=="cnt" || gldurationVal=="notCnt"))
			{
				gldurationVal=replaceAll(gldurationVal,",","~~")
			}
			var desTxtValue = descriptorTxtField.getValue();
			
			var configString='';
			var ddconfigString='';
			//if (er_functionVal=='Raw' || er_functionVal=='None')// refer old report builder
			if (er_function=='Raw' || er_function=='None')
			{
				configString=er_compType.getValue()+'='+er_test.getValue()+'|'+er_measure.getValue();
				if (er_test.getValue().indexOf("_DDD")>-1)
				{
					if(app.templateJson != undefined && app.templateJson.selectedFields != undefined && app.templateJson.selectedFields.ddMeasureCondition != undefined)
					{
						configString+='~'+app.templateJson.selectedFields.ddMeasureCondition;
					}
					configString+='~'+Ext.widget("erutils").specialCharEncode(er_ddColumn.getValue());
				}
				configString+="|";
			}
			else
			{
				configString='comptypeid'+er_compType.getValue()+'='+er_test.getValue()+'|'+er_measure.getValue();
				if (er_test.getValue().indexOf("_DDD")>-1)
				{
					if(app.templateJson != undefined && app.templateJson.selectedFields != undefined && app.templateJson.selectedFields.ddMeasureCondition != undefined)
					{
						configString+='~'+app.templateJson.selectedFields.ddMeasureCondition;
					}
					configString+='~'+Ext.widget("erutils").specialCharEncode(er_ddColumn.getValue());
				}
				if(curChartType=="multiDigi" || curChartType=="digital")
				{
					var digitSpark='$spark$';
					if(digitalSparkColorPicker != undefined)
					{
						digitSpark+=digitalSparkColorPicker.getValue()['ColorPickerOpt'+currentTabIndex];
					}
					if(digitalSparkChartType != undefined)
					{
						digitSpark+='$'+digitalSparkChartType.getValue()['chattype'+currentTabIndex];
					}
					if(digitalSparkFontType != undefined)
					{
						digitSpark+='$'+digitalSparkFontType.getValue()['fonttype'+currentTabIndex];
					}
					if(iconClass != undefined)
						displayNameFinal+='@'+iconClass.getValue();
					//if(digitalSparkChartType != undefined && digitalSparkChartType.getValue()['chattype'+currentTabIndex] != 'iconChartTypeNone')
					displayNameFinal+=digitSpark;
				}
				if(curChartType=="heatMap")
				{
					displayNameFinal+='$MeasCon$'+measureCondtionVal+'$'+measureCriticalVal+'$'+measureMajorVal+'$'+measureMinorVal+'$MeasCon$';
				}
				if(gldurationVal != undefined && er_measureFilter != undefined && er_measureFilter.getValue() != undefined)
					gldurationVal=er_measureFilter.getValue()+'#@#'+gldurationVal;
				configString+='$~$'+displayNameFinal+'$~$'+gldurationVal+'$~$'+er_duration.getValue()+'|';

			}
			if (er_descFilter.getValue()=='all')
			{
				configString+='-1';
			}
			else
			{ 
				var descArray=new Array();
				var desTxtValue=descriptorTxtField.getValue();
				descArray=desTxtValue.split(",")
				if (descArray.length>0)
				{
					for (var key in descArray )
					{
						var value=descArray[key];
						if (!Ext.isEmpty(value))
						{
							if (key==0)
								configString+=value;
							else
								configString+='$'+value;
						}
						else
							configString+='-1';
					}
				}
				else
					configString+='-1';
				var includeDescVal=includeDesc.getValue()['actionOnDesBox'+currentTabIndex];
				if (includeDescVal=='exclude')
					configString+='$exclude';
			}
			configString+='|'+er_function.getValue();
			
			var ddconfigString='';
			if (er_test.getValue().indexOf("_DDD")>-1 && (ddGroupInfoTxtField.fieldValues!=''))
			{
				var ddconfigStringPrefix=configString.substring(configString.indexOf('|')+1);
				var ddConfigAry=ddconfigStringPrefix.split("$~$");
				var ddTxtValue=ddGroupInfoTxtField.fieldValues;
				var ddGroupInfoArray=ddTxtValue.split(",")
				for(var v=0;v<ddGroupInfoArray.length;v++)
				{
					ddconfigString+='comptypeid'+er_compType.getValue()+'=';
					ddconfigString+=er_test.getValue()+'|';
					ddconfigString+=ddGroupInfoArray[v]+'$~$'
					ddconfigString+=displayNameFinal+ddGroupInfoArray[v]+'$~$'
					var tempStr=ddConfigAry[3].substring(0,ddConfigAry[3].lastIndexOf('|'));
					ddconfigString+=ddConfigAry[2]+'$~$'+tempStr+'|Raw';

					if(v<ddGroupInfoArray.length-1)
					{
						ddconfigString+='*'
					}
				}
			}
			
			var descArray=desTxtValue.split(",")
			if(er_descFilter.getValue()=='all')
				descArray="-";
			
			var configObject={
				'componentType' :er_compType.getRawValue(),
				'test' : er_test.getRawValue(),
				'testValue' : er_test.getValue(),
				'measure' : er_measure.getRawValue(),
				'measureValue' : er_measure.getValue(),
				'measureFilter' : er_measureFilter.getRawValue(),
				'measureFilterValue' : er_measureFilter.getValue(),
				'ddColumn' : er_ddColumn.getRawValue(),				
				'ddColumnValue' : er_ddColumn.getValue(),
				'displayName' : displayNameFinal,
				'displayNameDummy':(disp_MeasureName.getValue()).trim(),
				'descriptor' : descArray,
				'er_testType' : er_testTypeVal,
				'function':er_function.getRawValue(),
				'glduration':gldurationVal,
				'er_duration':er_duration.getValue(),
				'configString':configString,
				'ddconfigString':ddconfigString,
				'measureCondtion':measureCondtionVal,
				'measureCritical':measureCriticalVal,
				'measureMajor':measureMajorVal,
				'measureMinor':measureMinorVal
			}
			me.getReportertemplatetabpane().widgetConfig.chartConfigArray.push(configObject);
			//set widget config data end
			
			var comboDataAry = new Array();
			var comboData = new Object();
			comboData.displayField = er_compType.getRawValue();
			comboData.valueField = er_compType.getValue();
			comboDataAry.push(comboData);
			comboObj.componentTypeCombo = comboDataAry;
			selectedFieldObj.selectedComponentTypeCombo = er_compType.getValue();
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_test.getRawValue();
			comboData.valueField = er_test.getValue();
			comboDataAry.push(comboData);
			comboObj.testCombo = comboDataAry;
			selectedFieldObj.selectedTestCombo = er_test.getValue();
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_measure.getRawValue();
			comboData.valueField = er_measure.getValue();
			comboDataAry.push(comboData);
			comboObj.measureCombo = comboDataAry;
			selectedFieldObj.selectedMeasureCombo = er_measure.getValue();
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_measureFilter.getRawValue();
			comboData.valueField = er_measureFilter.getValue();
			comboDataAry.push(comboData);
			comboObj.measureFilterCombo = comboDataAry;
			selectedFieldObj.selectedMeasureFilterCombo = er_measureFilter.getValue();
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_ddColumn.getRawValue();
			comboData.valueField = er_ddColumn.getValue();
			comboDataAry.push(comboData);
			comboObj.ddColumnCombo = comboDataAry;
			selectedFieldObj.selectedDDcolumnCombo = er_ddColumn.getValue();

			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_function.getRawValue();
			comboData.valueField = er_function.getValue();
			comboDataAry.push(comboData);
			comboObj.functionCombo = comboDataAry;
			selectedFieldObj.selectedFunctionCombo = er_function.getValue();
			
			selectedFieldObj.ddGroupInfoTxtValue = ddGroupInfoTxtField.getValue();
			selectedFieldObj.ddGroupInfoTxtFieldValues = ddGroupInfoTxtField.fieldValues;
			selectedFieldObj.selectedDispMeasureCombo = (disp_MeasureName.getValue()).trim();
			selectedFieldObj.selectedYaxis = yAxisLabel.getValue();
			
			comboObj.groupByCombo = groupByVal;
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = glduration.getRawValue();
			comboData.valueField = glduration.getValue();
			comboDataAry.push(comboData);
			comboObj.gldurationCombo = comboDataAry;
			selectedFieldObj.selectedglduration = glduration.getValue();
			selectedFieldObj.selectedDuration = er_duration.getValue();
			selectedFieldObj.selectedDynamic = er_dynamic.checked;
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_descFilter.getRawValue();
			comboData.valueField = er_descFilter.getValue();
			comboDataAry.push(comboData);
			comboObj.descFilterCombo = comboDataAry;
			selectedFieldObj.selectedThresholds = er_descFilter.getValue();
			selectedFieldObj.selectedActionOnDes = includeDesc.getValue()['actionOnDesBox'+currentTabIndex];
			selectedFieldObj.selecteddescriptorTxt = descriptorTxtField.getValue();
			
			if(desChkBtn.checked)
			{
				selectedFieldObj.selectedDescriptorTxtField = descriptorTxtFieldLabel.getValue();
				selectedFieldObj.selectedDescFilterEnable = descFilterEnable.checked;
			}
			
			comboDataAry = new Array();
			comboData = new Object();
			comboData.displayField = er_top.getRawValue();
			comboData.valueField = er_top.getValue();
			comboDataAry.push(comboData);
			comboObj.topNCombo = comboDataAry;
			selectedFieldObj.selectedTopN = er_top.getValue(); 
			selectedFieldObj.selectedEnableTopN = er_enableTopN.getValue()['enableTopN'+currentTabIndex];

			selectedFieldObj.selectedMeasureCondtion=measureCondtionVal;
			selectedFieldObj.selectedMeasureCritical=measureCriticalVal;
			selectedFieldObj.selectedMeasureMajor=measureMajorVal;
			selectedFieldObj.selectedMeasureMinor=measureMinorVal;
			
			measureInfObj.combo=comboObj;
			measureInfObj.selectedFields=selectedFieldObj;
			totalMeaureAry.push(measureInfObj);
		}
		return totalMeaureAry;
	},
	addWidgetDone:function()
	{
		if(this.getReportdataconfigwindow()!=undefined)
		{
			this.getReportdataconfigwindow().doClose();
		}
	},
	onClickWidgetModify:function(widgets)
	{
		measureTabCount = 0;
		isEditTemplate=true;
		app.currentWidget=widgets;
		curChartType = widgets.chartType;
		this.openConfigurationWindow();
		
		Ext.getCmp('previewColor').selectedGraphPalette=widgets.selectedGraphPalette;
		Ext.getCmp('addwidget').setText('UPDATE WIDGET');
		var overAllTabAry = widgets.editableObj;
		var totalTab=overAllTabAry.length;
		for(var i=0; i<totalTab; i++)
		{
			this.addTab(false,overAllTabAry[i].selectedFields.selectedDispMeasureCombo);
			this.setTabdata(i,overAllTabAry[i]);
		}
		if(curChartType != undefined && curChartType== 'multiDigi' && totalTab==5)
		{
			Ext.get('addMoreMes').setStyle({"visibility":"hidden"});
		}
		this.getReportertemplatetabpane().setActiveTab(0);
	},
	restTabPane:function()
	{
		if(isEditTemplate)
			return;
		measureTabCount = 0;
		needWidgetSourecReq = false;
		Ext.getCmp('measureTypeId').setValue({"measureType":['normalMeasure']});
		Ext.getCmp('reportertemplatetabid').removeAll();
		var headerTitle = measureTabCount;
		this.addTab(true,headerTitle);//isfullyloaded>>true
	},
	addMoreTab:function()
	{
		var headerTitle = measureTabCount;
		this.addTab(true,headerTitle);//isfullyloaded>>true

	},
	addTab:function(isfullyloaded,headerTitle)
	{
		var reportertemplatetab = Ext.getCmp('reportertemplatetabid');
		var measureTypeId=Ext.getCmp("measureTypeId");
		var measureTypeIdVal = measureTypeId.getValue().measureType;
		var me=this;
		var headerTitleDisp = headerTitle;
		if (!isNaN(parseInt(headerTitle)))
		{
			if(measureTypeIdVal=="DDMeasure")
			{
				headerTitle = 'DD value - '+ headerTitle; 
			}
			else
			{
				headerTitle = 'Measure - '+ headerTitle; 
			}
			headerTitleDisp = headerTitle;
		}
		else if (headerTitle.length>16)
		{
			headerTitleDisp = headerTitle;
			headerTitle = headerTitle.substring(0,15)+'...';
		}
		if(curChartType != undefined && curChartType == 'healthWidget')
		{
			headerTitle='health';
			headerTitleDisp=headerTitle;
		}
		var tempYaxisLabel = 'Y Axis';
		if (curChartType != undefined && (curChartType == 'distributedPie' || curChartType == 'distribution'))
		{
			tempYaxisLabel = 'Group By';
		}
		var toolTipInfo = 'data-qclass=yellowTip data-qtip="'+headerTitleDisp+'"';
		reportertemplatetab.add({
			id:'tabContainer'+measureTabCount,
			ddGroupInfoData:null,
			descriptorCombo:null,
			measureTabCount:measureTabCount,
			isfullyloaded:isfullyloaded,
			headerTitle:headerTitle,
			headerTitleDisp:headerTitleDisp,
			//margin:10,
			//closable:true,
			//title:'<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_normal11" align="right" style="white-space:nowrap">Measure - '+measureTabCount+'</td><td style="float:left;margin-left:5px;" class="iconDeleteReportTemplate" onclick=\'javascript:removeMesure(tabContainer'+measureTabCount+');event.stopPropagation();\'></td></tr></table>',
			title:'<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_normal11" align="right" style="white-space:nowrap;height:20px" '+toolTipInfo+'>'+headerTitle+'</td></tr></table>',
			layout:'accordion',
			ui:'newAccordionPanel',
			items:[
			{
				xtype:'panel',
				title:'<span class="font_bold12">Primary Type</span>',
				layout:'column',
				margin:'10 10 0 10',
				bodyPadding:'0 0 0 10',
				defaults:{
					labelAlign:'top',
					labelSeparator:'',
					margin:'5 10 10 0',
					columnWidth:.333,
					measureTabCount:measureTabCount,
				},
				items:[
					{
						xtype:'scrollcombo',
						fieldLabel:'Component Type',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:noComponentTypeMatch
						},
						cls: 'dropdown',
						id: 'er_compType'+measureTabCount,
						name: 'er_compType'+measureTabCount,
						store: Ext.data.Store
						(
							{
								fields: ['displayField','valueField'],
								data: []
							}
						),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							select:function(obj)
							{
								me.ajaxQueryMaker(obj);
							}
						}
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:noComponentTypeMatch
						},
						fieldLabel: 'Test',
						name: 'er_test'+measureTabCount,
						id: 'er_test'+measureTabCount,
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							select:function(obj)
							{
								me.ajaxQueryMaker(obj);
							}
						}
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:noComponentTypeMatch
						},
						fieldLabel: 'Measure',
						name: 'er_measure'+measureTabCount,
						id: 'er_measure'+measureTabCount,
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							select:function(obj)
							{
								me.ajaxQueryMaker(obj);
							}
						}
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:noComponentTypeMatch
						},
						fieldLabel: 'DD Columns',
						name: 'er_ddColumn'+measureTabCount,
						id: 'er_ddColumn'+measureTabCount,
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							select:function(obj)
							{							
								me.ajaxQueryMaker(obj);
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						fieldLabel:'Summarize DD Data By',
						layout: 'column',
						id:'ddGroupInfoId'+measureTabCount,
						hidden:true,
						items:
						[
							{
								xtype: 'textfield',
								cls: 'textbox',
								width:155,
								columnWidth:.89,
								value:'',
								margin:'0 5 0 0',
								maskRe: /[A-Za-z0-9 .,]/,
								readOnly:true,
								id: 'ddGroupInfoTxtField'+measureTabCount,
								name:'ddGroupInfoTxtField'+measureTabCount,
								fieldValues:'',
							},
							{
								xtype: 'button',
								iconCls: 'iconOneClickMultiselectExpand',
								id: 'ddGroupInfoExpand'+measureTabCount,
								tooltip: '<b>DD Group</b>',
								columnWidth:.11,
								measureTabCount:measureTabCount,
								style: {
									 background: 'none',
									 border: '0px'
								 },
								 handler:function(obj){
									obj.setDisabled(true);
									var ddInfoArray=new Array();
									//var ddTxtValue=Ext.getCmp('ddGroupInfoTxtField').getValue();
									var ddTxtValue=Ext.getCmp('ddGroupInfoTxtField'+obj.measureTabCount).fieldValues
									ddInfoArray=ddTxtValue.split(",");
									Ext.create('Ext.window.Window',{
										title:'DD Group',
										width:400,
										id:'builderSubWindow',
										border:false,
										ui:'newPopupWindow newplainHeader_border',
										frame:false,
										modal: true,
										ghost: false,
										height:300,
										padding:'10 10 5 10',
										//listeners: 
										/*
										{
											show: function (win) {
												if (this.modal)
												{
													var el ;
													var dom = Ext.dom.Query.select('.x-mask');
													for (var y = 0; y < dom.length; y++) {
														 el = Ext.fly(dom[y]);
	
													}
												 el.addCls('windowModal');
												}
											},
											hide: function (win) {
												var dom = Ext.dom.Query.select('.x-mask');
												if (this.modal) {
	
													var el = Ext.fly(dom[0]);
													el.removeCls('windowModal');
												}
											},
											afterrender: function () {
												Ext.EventManager.onWindowResize(function () {
													var me = this;
													me.center();
												}, this);
											}
										},
										*/
										doClose: function() 
										{
											var me = this;
											obj.setDisabled(false);
											// Being called as callback after going through the hide call below
											if (me.hidden) {
												me.fireEvent('close', me);
												if (me.closeAction == 'destroy') {
													this.destroy();
												}
											} else {
												// close after hiding
												me.hide(me.animateTarget, me.doClose, me);
											}
										},
										buttonAlign:'center',
										items:[
										{
											xtype: 'multiselect',
											width:'100%',
											height:225,
											layout: 'fit',
											border : 0,
											autoScroll:false,
											scroll:false,
											labelAlign:'left',
											baseCls: 'egmultiselect',
											multiSelect: true,
											id: 'componentsClone',
											name: 'componentsClone',
											store: new Ext.data.Store({
												fields: ['displayField', 'valueField'],
												data: []
											}),
											value: [],
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											listeners:{
												//boxready
												afterrender: function () {
													this.getStore().loadRawData(Ext.getCmp('tabContainer'+obj.measureTabCount).ddGroupInfoData);
													this.getStore().removeAt(0);
													this.setValue(ddInfoArray);
												},
											},
										}],
										buttons:[
										{
											text:'Select',
											id: 'expand',
											ui:'newButtonSmall',
											name: 'expand',
											handler: function()
											{
												if ( Ext.getCmp('componentsClone').getValue() != '')
												{
	
													var comboVal= Ext.getCmp('componentsClone').getValue();
													var textFieldDisp='';
													var valuesAry = new Array();
													valuesAry=comboVal;
													var comboValField= Ext.getCmp('componentsClone').getStore();
													comboValField.each(function(r){
														if(valuesAry.indexOf(r.data.valueField)>-1)
														{
															textFieldDisp=textFieldDisp+r.data.displayField+','
														}
													});
													textFieldDisp=textFieldDisp.substring(0,textFieldDisp.length-1);
													Ext.getCmp('ddGroupInfoTxtField'+obj.measureTabCount).setValue(textFieldDisp);
													Ext.getCmp('ddGroupInfoTxtField'+obj.measureTabCount).fieldValues=comboVal.toString();
													obj.setDisabled(false);
													this.up('window').destroy();
													if(curChartType != undefined && curChartType=='distributedPie')
													{
														Ext.getCmp('primGroupByBoxId'+activeTabNo).setDisabled(true);
														Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(false);
													}
												}
												else
												{
													Ext.getCmp('ddGroupInfoTxtField'+obj.measureTabCount).setValue('');
													Ext.getCmp('ddGroupInfoTxtField'+obj.measureTabCount).fieldValues='';
													obj.setDisabled(false);
													this.up('window').destroy();
													if(curChartType != undefined && curChartType=='distributedPie')
													{
														Ext.getCmp('primGroupByBoxId'+activeTabNo).setDisabled(false);
														Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(false);
													}
													/* Ext.MessageBox.show({
														title: 'Alert',
														msg: 'Please Choose a DD Group',
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return; */
												}
											}
										}]
									}).show();
								}
							}
						]
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : false,
						fieldLabel: 'Function',
						name: 'er_function'+measureTabCount,
						id: 'er_function'+measureTabCount,
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							select:function(obj)
							{
								me.ajaxQueryMaker(obj);
							}
						}
					},
					{
						xtype: 'textfield',
						fieldLabel: 'Label',
						cls: 'textbox',
						maskRe: /[A-Za-z0-9 .,]/,
						id: 'disp_MeasureName'+measureTabCount,
						name:'disp_MeasureName'+measureTabCount
					},
				{
					xtype: 'menuseparator',
					margin:'5 10 10 0',
					cls:'winSeparator',
					hidden:(curChartType != undefined && curChartType=='healthWidget')?true:false,
					columnWidth:1.0
				},
				{
					xtype:'label',
					text:tempYaxisLabel,
					id:'yAxisJustLabel'+measureTabCount,
					cls:'font_bold12',
					hidden:(curChartType != undefined && curChartType=='healthWidget')?true:false,
					columnWidth:1.0
				},
				{
					xtype: 'fieldcontainer',
					layout:'column',
					fieldLabel: '',
					margin:'0 0 0 0',
					id:'primGroupByBoxId'+measureTabCount,
					columnWidth:1.0,
					defaults:{
						padding:0,
						vertical: true,
						measureTabCount:measureTabCount
					},
					items:[
					{
						xtype: 'checkbox',
						cls:'checkbt',
						boxLabel  : 'Component',
						inputValue: 'component',
						name      : 'primgroupbyComp'+measureTabCount,
						id        : 'primgroupbyComp'+measureTabCount,
						columnWidth:.17,
						listeners:
						{
							'change':function(obj)
							{
								me.processOnGroupLabel(obj.measureTabCount);
							}
						}
					},
					{
						xtype: 'checkbox',
						cls:'checkbt',
						boxLabel  : 'Descriptor',
						inputValue: 'descriptors',
						name      : 'primgroupbyDesc'+measureTabCount,
						id        : 'primgroupbyDesc'+measureTabCount,
						columnWidth:.17,
						listeners:
						{
							'change':function(obj)
							{
								me.processDescpFilter(obj);
							}
						}
					},
					{
						xtype: 'checkbox',
						cls:'checkbt',
						boxLabel  : 'Group by date',
						inputValue: 'dateChk',
						hidden:false,
						name      : 'primgroupbyDateChk'+measureTabCount,
						id        : 'primgroupbyDateChk'+measureTabCount,
						columnWidth:.36,
						listeners:
						{
							'change':function(obj)
							{
								if(obj.checked)
								{
									Ext.getCmp('primgroupbyDateChk'+obj.measureTabCount).hide();
									Ext.getCmp('groupByDateCB'+obj.measureTabCount).show();
									Ext.getCmp('groupByDateCB'+obj.measureTabCount).expand();
								}
								else
								{
									Ext.getCmp('primgroupbyDateChk'+obj.measureTabCount).show();
									Ext.getCmp('groupByDateCB'+obj.measureTabCount).hide();
								}
								me.processOnGroupLabel(obj.measureTabCount);
							}
						}
					},
					{
						xtype:'fieldset',
						title: 'Group by date',
						ui:'simple',
						margin:'-15 10 10 0',
						columnWidth:.36,
						measureTabCount:measureTabCount,
						hidden:true,
						cls: 'checkbt',
						name:'groupByDateCB'+measureTabCount,
						id:'groupByDateCB'+measureTabCount,
						checkboxToggle: true,
						collapsed: true, // fieldset initially collapsed
						layout:{
							type : 'vbox',
						},
						padding:'0 0 5 5',
						width:220,

						/**
						 * @private Collapse or expand the fieldset
						 * This below code for slider hidden issue when toggle the fieldset checkbox start here
						 */
						onCheckChange: function(cmp, checked) {
							if(checked)
							{
								Ext.getCmp('dateRadioBtn'+this.measureTabCount).setValue(true);
							}
							else
							{
								var dateGrp=Ext.getCmp('primGroupByDateId'+this.measureTabCount);
								for(var i=0;i<dateGrp.items.length;i++)
								{
									dateGrp.items.items[i].setValue(false);
								}
								Ext.getCmp('primgroupbyDateChk'+this.measureTabCount).setValue(false);
							}
						},

						/**
						 * @private Collapse or expand the fieldset
						 * This below code for slider hidden issue when toggle the fieldset checkbox end here
						*/

						items: [
						{
							xtype: 'radiogroup',
							id:'primGroupByDateId'+measureTabCount,
							measureTabCount:measureTabCount,
							fieldLabel:'',
							margin :'0 5 0 -3',
							width:190,
							defaults:{
								cls:'radiobt',
								noWrap:true,
								padding:0,
								margin:'0 5 0 0',
								columns:3,
								vertical: true,
							},
							items: [
								{ boxLabel: 'Date',id:'dateRadioBtn'+measureTabCount,name: 'primgroupbybox'+measureTabCount, inputValue: 'date',width:56, },
								{ boxLabel: 'Week',id:'weekRadioBtn'+measureTabCount,name: 'primgroupbybox'+measureTabCount, inputValue: 'week',width:56, },
								{ boxLabel: 'Month',id:'monthRadioBtn'+measureTabCount,name: 'primgroupbybox'+measureTabCount, inputValue: 'month',width:60,}
							],
							listeners:
							{
								change:function(obj)
								{
									me.processOnGroupLabel(obj.measureTabCount);
								}
							}
						}]
					},
					{
						xtype:'container',
						columnWidth:.3,
						layout:'column',
						margin:'10 0 0 0',
						hidden:true,
						style:
						{
							'border':'#abb2bd 1px solid'
						},
						defaults:
						{
							labelSeparator:'',
							cls: 'textboxBuilder',
							measureTabCount:measureTabCount,
							grow:true,
							growMin:35,
							growMax:54,
							growAppend:'eg',
							margin:'4 0 0 0',
						},
						items:
						[{
							xtype:'textfield',
							id:'compnentField'+measureTabCount,
							margin:'3 0 0 4',
						},
						{
							xtype:'textfield',
							id:'desField'+measureTabCount,
							fieldLabel:'/',
							labelWidth:2,
							labelAlign:'left',
						},
						{
							xtype:'textfield',
							id:'dateField'+measureTabCount,
							fieldLabel:'/',
							labelWidth:2,
							labelAlign:'left',
						}]
					},
					{
						xtype:'textfield',
						cls: 'textbox',
						labelAlign:'top',
						labelSeparator:'',
						margin:'-24 10 0 0',
						id:'yAxisLabel'+measureTabCount,
						fieldLabel:'Label',
						columnWidth:.3,
						//hidden:true
					},
					{
						xtype : 'textfield',
						name : 'otp'+measureTabCount,
						id :'otp'+measureTabCount,
						labelSeparator: '',
						labelAlign:'top',
						margin:'0 10 0 0',
						columnWidth:.3,
						enableKeyEvents : true,
						hidden:true,
						listeners :
						{
							'afterrender':function(textbox){
								$("#"+textbox.id+'-inputEl').mask("***/***/***",{placeholder:' '});
								Ext.defer(function(){
									$("#"+textbox.id+'-inputEl').focus();
								},1000)
							}
						}
					}]
				},
				{
					xtype: 'container',
					columnWidth:1.0,
					layout : 'hbox',
					id:'digitalSparkIconFont'+measureTabCount,
					height: 45,
					margin : '7 0 17 0',
					flex:1,
					items: [
						{
							xtype: 'container',
							layout : 'vbox',
							cls: 'reporterRightBorder',
							id:'digitalSparkFontCon'+measureTabCount,
							margin: '0 2 0 0',
							width: 80,
							items: [{
								xtype : 'container',
								layout : 'vbox',
								id:'digitalSparkFont'+measureTabCount,
								items: [
									{
										xtype:'label',
										text:'Font Size',
										id:'digitalSparkFontLabel'+measureTabCount,
										flex:1,
										margin: '0 0 11 0',
										cls:'font_bold12',
										
									},
									
									{
										xtype : 'groupselection',
										fieldLabel: '',
										displayField: 'inputValue',
										labelAlign:'left',
										width: 25,
										cls:'iconFontSizeGroup',
										id:'digitalSparkFontType'+measureTabCount,
										radioType : 'icon',
										items: [{
											iconCls: 'iconFontSizeSmall',
											name: 'fonttype'+measureTabCount,
											id: 'iconFontSmall'+measureTabCount,
											border:false,
											width:7,
											margin:'0',
											padding:0,
											//inputValue: 'iconBarGraph'
											inputValue: 'iconFontSmall'
											
										}, {
											iconCls: 'iconFontSizeMedium',
											width:8,
											border:false,
											margin:0,
											padding:0,
											name: 'fonttype'+measureTabCount,
											id: 'iconFontMedium'+measureTabCount,
											//inputValue: 'iconLineGraph',
											inputValue: 'iconFontMedium',
											checked: true
										},
										{
											iconCls: 'iconFontSizeBig',
											width:10,
											border:false,
											margin:0,
											padding:0,
											name: 'fonttype'+measureTabCount,
											id: 'iconFontLarge'+measureTabCount,
											//inputValue: 'iconLineGraph'
											inputValue: 'iconFontLarge'
										}]
									}

								]
							},
								
							]
						},
						{
							xtype: 'container',
							cls: 'reporterRightBorder',
							margin: '0 2 0 0',
							id:'digitalSparkChartCon'+measureTabCount,
							//layout : 'vbox',
							layout : {
								type : 'hbox',
								align: 'stretch'
							},
							
							margin : '0 0 0 25',
							items: [
									{
									xtype : 'container',
									layout : 'vbox',
									id:'digitalSparkChart'+measureTabCount,
									items: [
									{
										xtype:'label',
										text:'Chart Type & Color',
										id:'digitalSparkChartLabel'+measureTabCount,
										flex:1,
										margin : '0 0 0 7',
										cls:'font_bold12',
										
									},
									{
										xtype : 'groupselection',
										fieldLabel: '',
										margin : '8 0 0 0',
										displayField: 'inputValue',
										labelAlign:'left',
										radioType : 'icon',
										id:'digitalSparkChartType'+measureTabCount,

										cls: 'templateIconCharts',
										items: [
											{
												iconCls: 'iconChartTypeNone',
												name: 'chattype'+measureTabCount,
												id: 'iconChartTypeNone'+measureTabCount,
												inputValue: 'iconChartTypeNone',
												checked: true,
												
											}, {
												iconCls: 'iconChartTypeBar',
												name: 'chattype'+measureTabCount,
												id: 'iconChartTypeBar'+measureTabCount,
												inputValue: 'iconChartTypeBar'
											},
											{
												iconCls: 'iconChartTypeArea',
												name: 'chattype'+measureTabCount,
												id: 'iconChartTypeArea'+measureTabCount,
												inputValue: 'iconChartTypeArea',
											}, {
												iconCls: 'iconChartTypeLine',
												name: 'chattype'+measureTabCount,
												id: 'iconChartTypeLine'+measureTabCount,
												inputValue: 'iconChartTypeLine'
											},
											{
												xtype : 'tbseparator',
												cls: 'menuseparator reporterChartSeparator',
												margin: '5 2 0 0',
												width: 2,
												height: 23,

											},
											{
												xtype : 'container',
												layout: 'column',
												
												margin: '5 20 0 0',
												//id: 'chartColorPicker',
												id:'digitalSparkColorPickerCon'+measureTabCount,
												width: 210,
												items: [
													{
														xtype : 'groupselection',
														fieldLabel: '',
														id:'digitalSparkColorPicker'+measureTabCount,
														displayField: 'inputValue',
														labelAlign:'left',
														radioType : 'color',
														items:[
															{
																"color": "#2E6FB7",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette1",
																"id": "2E6FB7"+measureTabCount,
																"inputValue": "2E6FB7"
																//"checked": false
															}, {
																"color": "#2991D0",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette2",
																"id": "2991D0"+measureTabCount,
																"inputValue": "2991D0"
																//"checked": false
															}, {
																"color": "#01B7B2",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette3",
																"id": "01B7B2"+measureTabCount,
																"inputValue": "01B7B2",
																"checked": true
															}, {
																"color": "#7CC242",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette4",
																"id": "7CC242"+measureTabCount,
																"inputValue": "7CC242"
																//"checked": false
															}, {
																"color": "#A2CD3A",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette5",
																"id": "A2CD3A"+measureTabCount,
																"inputValue": "A2CD3A"
																//"checked": false
															}, {
																"color": "#E3DC1B",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette6",
																"id": "E3DC1B"+measureTabCount,
																"inputValue": "E3DC1B"
																//"checked": false
															}, {
																"color": "#F6891F",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette7",
																"id": "F6891F"+measureTabCount,
																"inputValue": "F6891F"
																//"checked": false
															}, {
																"color": "#EE2C24",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette8",
																"id": "EE2C24"+measureTabCount,
																"inputValue": "EE2C24"
																//"checked": false
															}, {
																"color": "#A19ECE",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette9",
																"id": "A19ECE"+measureTabCount,
																"inputValue": "A19ECE"
																//"checked": false
															}, {
																"color": "#88CFE7",
																"name": "ColorPickerOpt"+measureTabCount,
																"displayName": "Palette10",
																"id": "88CFE7"+measureTabCount,
																"inputValue": "88CFE7"
																//"checked": false
															}
														]														
													}
												]
											}
										]
									},
									
									
									
								]
							},
								
							]

						},
						{
							xtype: 'container',
							layout : 'vbox',
							height: 45,
							width: 100,
							margin: '0 0 0 7',
							id:'digitalSparkIconCon'+measureTabCount,
							items: [{
								xtype : 'container',
								layout : 'vbox',
								id:'digitalSparkIcon'+measureTabCount,
								items: [
									{
										xtype:'label',
										text:'Choose Icon',
										id:'digitalSparkIconLabel'+measureTabCount,
										margin: '0 0 0 14',
										flex:1,
										cls:'font_bold12',
										
									},
									{
										xtype: 'textfield',
										cls: 'textbox',
										value:'Not Applicable',
										margin:'0 0 0 15',
										maskRe: /[A-Za-z0-9 .,]/,
										readOnly:true,
										id: 'iconClass'+measureTabCount,
										hidden:true,
									},
									{
										xtype : 'container',
										fieldLabel: '',
										margin : '8 0 0 14',
										displayField: 'inputValue',
										labelAlign:'left',
										id:'digitalSparkIconType'+measureTabCount,
										radioType : 'icon',
										defaults : {
											margin : '0 10 0 0'
										},
										cls: 'templateIconCharts',
										items: [
											{
												xtype : 'button',
												cls: 'btnTransparent noImageIconBtn',
												toggleGroup: true,
												enableToggle: true,
												style: {
												'width':'18px !important',
												'height':'24px !important'
												},
												padding:'3 3 3 3',
												iconCls: 'iconNoImageChartType',
												iconPadding : '2 0 0 0',
												id: 'iconNoImageChartType'+measureTabCount,
												margin: '0 10 0 0',
												name: 'icontype'+measureTabCount,
												scale: 'small',
												defaultState : function() {
													var btn = this;
													if (btn.pressed)
													{
														btn.addCls('iconReportChartbtnNoImage');
													}

												},
												listeners: {
														afterrender: function () {
														},
														click:function(btn) {

							
															if (btn.pressed)
																{
																btn.addCls('x-btn-pressedIcon');
																}
																else {
																	btn.removeCls('x-btn-pressedIcon');
																}
															
														},
														mouseover: function(btn) {
															btn.addCls('iconReportChartbtnNoImage');
														},
														mouseout: function(btn ){
															if (btn.pressed)
															{
															btn.addCls('iconReportChartbtnNoImage');
															}
															else{
																	btn.removeCls('iconReportChartbtnNoImage');
															}
														}
												}
											},											
											{
												xtype : 'button',
												cls: 'btnTransparent chooseIconBtn',
												padding:'2 3 0 3',
												toggleGroup: true,
												enableToggle: true,
												style: {
												'width':'18px !important',
												'height':'24px !important'
												},
												iconCls: 'iconChartTypeChoose',
												id: 'iconChartTypeChoose'+measureTabCount,
												name: 'icontype'+measureTabCount,
												measureTabCount:measureTabCount,											
												defaultState : function() {
													var btn = this;
													if (btn.pressed)
													{
														btn.toggle(false);
														btn.addCls('iconReportChartbtnChoose');
													}

												},
												listeners: {
														afterrender: function () {
													},
													 mouseover: function(btn) {
															btn.addCls('iconReportChartbtnChoose');
														},
														mouseout: function(btn ){
															if (btn.pressed)
															{
															btn.addCls('iconReportChartbtnChoose');
															}
															else{
																	btn.removeCls('iconReportChartbtnChoose');
															}
														}
												},
												handler: function (e) {						
														var imgUploadWindow = Ext.create('ReporterTemplate.view.IconLibrary',{
															from:'digitialChartWidget',
															windowId:'windowId',
															custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser,
															profileName:'',
															measureTabCount:e.measureTabCount,
														}).show()
														imgUploadWindow.on('close', function() {															
															imgUploadWindow.destroy();
															imgUploadWindow = 'closed';
														});
													}	
											},

										]
									}
									
								]
							},
								
							]

						},
						

					]
				},
			
				

				]
			},
			{
				xtype:'panel',
				title:'<span class="font_bold12">More Options</span>',
				layout:'column',
				margin:10,
				hidden:(curChartType != undefined && curChartType=='healthWidget')?true:false,
				defaults:{
					labelAlign:'top',
					labelSeparator:'',
					measureTabCount:measureTabCount
				},
				items:[
				{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable : true,
						typeAhead:true,
						listConfig:{
							emptyText:noComponentTypeMatch
						},
						fieldLabel: 'Measure Filter',
						columnWidth:.25,
						margin:'5 10 0 10',
						name: 'er_measureFilter'+measureTabCount,
						id: 'er_measureFilter'+measureTabCount,
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					editable: false,
					fieldLabel: 'Data filter',
					columnWidth:.25,
					margin:'5 10 0 10',
					name: 'glduration'+measureTabCount,
					id: 'glduration'+measureTabCount,
					store: new Ext.data.Store({
						fields: ['displayField', 'valueField'],
						data: []
					}),

					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listeners:
					{
						change:function(obj)
						{
							me.onDurationChange(obj)
						}
					}
				
				},
				{
					xtype: 'fieldcontainer',
					layout: 'column',
					columnWidth:.5,
					margin:'5 0 0 10',
					hidden:true,
					id:'er_durationContainer'+measureTabCount,
					defaults:{
						labelSeparator:'',
						labelAlign:'top',
						measureTabCount:measureTabCount
					},
					items:[
					{
						xtype: 'textfield',
						fieldLabel: 'Default Value',
						id: 'er_duration'+measureTabCount,
						name: 'er_duration'+measureTabCount,
						//maskRe:/[0-9.-]/,
						//maskRe:/[a-zA-Z0-9.-]+/,  //.. commented mask because of comma seperation in contains in glduration
						labelSeparator:'',
						//maxLength :16,
						columnWidth:.5,
						//enforceMaxLength :16, //.. commented because of contains needs more characters
						cls: 'textbox',
						allowBlank:false,
						value: 0,
						editable:true,
					},
					{
						xtype:'checkbox',
						cls: 'checkbt',
						margin:'22 0 0 10',
						boxLabel: 'Dynamic?',
						inputValue: 'true',
						id: 'er_dynamic'+measureTabCount,
						name: 'er_dynamic'+measureTabCount,
						columnWidth:.5,
					}]
				},
				{
					xtype: 'menuseparator',
					margin:'10 10 10 10',
					cls:'winSeparator',
					columnWidth:1.0
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					editable: false,
					margin:'0 10 0 10',
					columnWidth:.3,
					fieldLabel: 'Descriptor Filter',
					name: 'er_descFilter'+measureTabCount,
					id: 'er_descFilter'+measureTabCount,
					store: new Ext.data.Store({
						fields: ['displayField', 'valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listeners:
					{
						change:function(obj)
						{
							me.onChangeDescFilter(obj)
						},
						select:function(obj)
						{
							me.onSelectDescFilter(obj)
						}
					}
				},
				{
					xtype: 'fieldcontainer',
					//fieldLabel:'Action on descriptor',
					columnWidth:.65,
					hidden:true,
					margin:'20 10 0 10',
					layout: 'hbox',
					id:'descIncluderId'+measureTabCount,
					defaults:
					{
						measureTabCount:measureTabCount
					},
					items: [
					{
						xtype: 'radiogroup',
						id:'actionOnDes'+measureTabCount,
						fieldLabel:'',
						width:140,
						defaults:{
							cls:'radiobt',
							noWrap:true,
							padding:0,
							margin:'0 5 0 0',
							width:65,
							columns:2,
							vertical: true,
						},
						items: [
						{ boxLabel: 'Include',id:'includeRadioBtn'+measureTabCount,name: 'actionOnDesBox'+measureTabCount, inputValue: 'include',checked:true },
						{ boxLabel: 'Exclude',id:'excludeRadioBtn'+measureTabCount,name: 'actionOnDesBox'+measureTabCount, inputValue: 'exclude' }
						]
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						value:'Not Applicable',
						margin:'0 0 0 15',
						maskRe: /[A-Za-z0-9 .,]/,
						readOnly:true,
						id: 'descriptorTxtField'+measureTabCount,
						name:'descriptorTxtField'+measureTabCount
					},
					{
						xtype: 'splitter'
					},
					{
						xtype: 'button',
						iconCls: 'iconOneClickMultiSelectExpand',
						id: 'expandComp'+measureTabCount,
						tooltip: '<b>Descriptors</b>',
						margin:'2 0 0 0',
						style: {
							background: 'none',
							border: '0px'
						},
						handler:function(obj)
						{
							obj.setDisabled(true);
							var descArray=new Array();
							var desTxtValue=Ext.getCmp('descriptorTxtField'+obj.measureTabCount).getValue();
							descArray=desTxtValue.split(",");
							Ext.create('Ext.window.Window',{
								title:'Descriptors',
								width:240,
								id:'builderSubWindow',
								border:false,
								frame:false,
								modal: true,
								ghost: false,
								ui:'newPopupWindow newplainHeader_border',
								height:305,
								closable:true,
								padding:'10 10 10 10',
//								header:
//								{
//									height:34,
//									style:{'padding-bottom':'4px !important'},
//								},
								//padding:'0 10 5 10',
								listeners: 
								{
									show: function (win) {
										if (this.modal)
										{
											var el ;
											var dom = Ext.dom.Query.select('.x-mask');
											for (var y = 0; y < dom.length; y++) {
												 el = Ext.fly(dom[y]);

											}
										 el.addCls('windowModal');
										}
									},
									hide: function (win) {
										var dom = Ext.dom.Query.select('.x-mask');
										if (this.modal) {

											var el = Ext.fly(dom[0]);
											el.removeCls('windowModal');
										}
									},
									afterrender: function () {
										Ext.EventManager.onWindowResize(function () {
											var me = this;
											me.center();
										}, this);
									}
								},
								doClose: function() 
								{
									var me = this;
									obj.setDisabled(false);
									// Being called as callback after going through the hide call below
									if (me.hidden) {
										me.fireEvent('close', me);
										if (me.closeAction == 'destroy') {
											this.destroy();
										}
									} else {
										// close after hiding
										me.hide(me.animateTarget, me.doClose, me);
									}
								},
								//buttonAlign:'center',
								items:[
								{
									xtype: 'container',
									width:220,
									layout:{
										type:'vbox',
										align:'stretch',
									},
									//margin:'0 10 10 10',
									
									items: [
									{
										xype: 'container',
										cls: 'multisearchlist',
										style:{'top':'0px'},
										items: [{
											xtype: 'customtrigger',
											id: 'compSerch',
											listeners:{
												change:function()
												{
													Ext.widget("erutils").filterComboStore(this,Ext.getCmp('componentsClone'),Ext.getCmp('tabContainer'+obj.measureTabCount).descriptorCombo);
												}
											}
										}]
									},
									{
										xtype: 'multiselect',
										width:'220',
										layout: 'fit',
										border :false,
										autoScroll:true,
										scroll:false,
										labelAlign:'left',
										height:190,
										//baseCls: 'egmultiselect',
										multiSelect: true,
										id: 'componentsClone',
										name: 'componentsClone',
										store: new Ext.data.Store({
											fields: ['displayField', 'valueField'],
											data: []
										}),
										value: [],
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										listeners:{
											afterrender: function () {
												this.getStore().loadRawData(Ext.getCmp('tabContainer'+obj.measureTabCount).descriptorCombo);
												this.setValue(descArray);
											}
										}
									}]
								}],
								dockedItems: [
								{
									xtype: 'toolbar',
									//height:30,
									padding:'10 5 0 5',
									dock: 'bottom',
									items: [
									'->',
										{
											xtype: 'button',
											text:'SELECT',
											id: 'expand',
											ui:'newButtonSmall',
											name: 'expand',
											handler: function()
											{
												if ( Ext.getCmp('componentsClone').getValue() != '')
												{
													Ext.getCmp('descriptorTxtField'+obj.measureTabCount).setValue(Ext.getCmp('componentsClone').getValue());
													obj.setDisabled(false);
													this.up('window').destroy();
												}
												else
												{
													Ext.MessageBox.show({
														title: 'Alert',
														msg: 'Please Choose a Descriptors',
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return;
												}
											}
										},
										'->'
									]
								}]
							}).show();
						}
					}]
					
				},			
				{
					xtype: 'menuseparator',
					margin:'10 10 10 10',
					cls:'winSeparator',
					columnWidth:1.0
				},
				{
					xtype:'label',
					text:'Misc Options',
					id:'miscLblId'+measureTabCount,
					margin:'0 0 5 10',
					cls:'font_bold12',
					columnWidth:1.0
				},
				{
					xtype: 'fieldcontainer',
					layout:'column',
					fieldLabel: '',
					margin:'0 0 0 0',
					id:'miscOptionsContainer'+measureTabCount,
					columnWidth:1.0,
					defaults:
					{
						vertical: true,
						labelSeparator:'',
						labelAlign:'top',
						measureTabCount:measureTabCount
					},
					items:[
					{
						xtype:'textfield',
						cls: 'textbox',
						margin:'0 10 0 10',
						id:'descriptorTxtFieldId'+measureTabCount,
						value:'Descriptors',
						fieldLabel:'Descriptor Header',
						columnWidth:.33,
						hidden:true
					},					
					{
						xtype: 'checkbox',
						boxLabel  : 'Enable Descriptor Filter',
						inputValue: 'yes',
						cls:'checkbt',
						margin : '20 0 0 0',
						checked   : false,
						id        : 'descFilterEnable'+measureTabCount,
						name      : 'descFilterEnable'+measureTabCount,
						columnWidth:.25,
						hidden:true
					},
					{
						xtype: 'radiogroup',
						margin:'0 10 0 10',
						fieldLabel:'Enable Top N',
						id:'er_enableTopN'+measureTabCount,
						name:'er_enableTopN'+measureTabCount,
						columnWidth:0.2,
						defaults:{
							cls:'radiobt',
							noWrap:true,
							padding:0,
							margin:'0 0 4 1',
							width:60,
							columns:2,
							vertical: true,
						},
						hidden:curChartType != undefined && curChartType=='heatMap'?true:false,
						items: [
							{ boxLabel: 'Yes',id: 'Yes'+measureTabCount,	name: 'enableTopN'+measureTabCount, inputValue: 'yes'},
							{ boxLabel: 'No', id: 'No'+measureTabCount, name: 'enableTopN'+measureTabCount, inputValue: 'no', checked: true}
						],
						listeners:
						{
							change:function(obj)
							{
								var value=obj.getValue()['enableTopN'+obj.measureTabCount];
								if(value=='yes')
									Ext.getCmp('er_top'+obj.measureTabCount).show();
								else
									Ext.getCmp('er_top'+obj.measureTabCount).hide();
							}
						}
					},					
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						margin:'20 0 0 10',
						editable: false,
						fieldLabel: 'Show',
						name: 'er_top'+measureTabCount,
						id: 'er_top'+measureTabCount,
						columnWidth:0.21,
						labelWidth:30,
						labelAlign:'left',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: [	]
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						hidden:true
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						//margin:'20 0 0 10',
						margin:'0 10 0 10',
						editable: false,
						fieldLabel: 'Measure Condition',
						name: 'er_measurCondition'+measureTabCount, // for heat map
						id: 'er_measurCondition'+measureTabCount,
						//columnWidth:0.26,
						columnWidth:0.2,
						//labelWidth:30,
						labelAlign:'top',						
						store: new Ext.data.Store({
							fields: ["displayField", "valueField"],
							data: [{"displayField":"Greater than","valueField":"gt"},{"displayField":"Lesser than","valueField":"lt"}]
						}),
						value:'gt',
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						hidden:curChartType != undefined && curChartType=='heatMap'?false:true,
					},
					{
						xtype:'fieldcontainer',
						layout:'column',
						//margin:'0 20 0 0',
						margin:'0 10 0 10',
						fieldLabel:'Measure Condition Range',
						id:'MeasureConditionRange'+measureTabCount,
						labelSeparator:'',
						labelAlign:'top',
						columnWidth:0.8,
						hidden:curChartType != undefined && curChartType=='heatMap'?false:true,
						items:[
							{
								//fieldLabel:'High',
								fieldLabel:' ',
								xtype:'numberfield',
								allowNegative:false,
								labelAlign:'right',
								minValue:0,
								labelSeparator:'',
								labelAlign:'right',
								hideTrigger: true,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								margin: '0 20 0 0',
								labelWidth:30,
								cls: 'textboxHigh',
								id: 'measureCritical'+measureTabCount,
								name: 'measureCritical'+measureTabCount,
								value:50,
								width: 90
							},
							{
								//fieldLabel: 'Medium',
								fieldLabel: ' ',
								xtype: 'numberfield',
								allowNegative: false,
								margin: '0 20 0 0',
								minValue: 0,
								labelSeparator:'',
								labelAlign:'right',
								hideTrigger: true,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								id: 'measureMajor'+measureTabCount,
								name: 'measureMajor'+measureTabCount,
								labelWidth: 30,
								cls: 'textboxMedium',
								value:40,
								width: 90
							},
							{
								//fieldLabel: 'Low',
								fieldLabel: ' ',
								xtype: 'numberfield',
								allowNegative: false,
								labelWidth: 30,
								minValue: 0,
								labelSeparator:'',
								labelAlign:'right',
								hideTrigger: true,
								keyNavEnabled: false,
								mouseWheelEnabled: false,
								id: 'measureMinor'+measureTabCount,
								name:'measureMinor'+measureTabCount,
								margin: '0 20 0 0',
								cls: 'textboxLow', // size
								value:30,
								width: 90
							}
						]					
					}
					]
				}
				]
			}],
			getData:function()
			{
				
			}
		});
		reportertemplatetab.doComponentLayout();	
		me.setCommonVisibility(measureTabCount);
		//..
		if((measureTabCount>0 && curChartType != undefined && curChartType=='distribution'))
		{
			Ext.getCmp('primGroupByBoxId'+activeTabNo).setDisabled(true);
			Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(false);
		}
		//..
		if(!isfullyloaded)
		{
			measureTabCount = measureTabCount+1;
			return;
		}
		var activeTab=me.getReportertemplatetabpane().getActiveTab();
		var totalTab = 1;
		if(activeTab!=null && activeTab!=undefined)
		{
			//var activeTabIndex = me.getReportertemplatetabpane().items.findIndex('id', activeTab.id); // find active index
			totalTab = me.getReportertemplatetabpane().items.length;
			if(isfullyloaded)
				reportertemplatetab.setActiveTab(totalTab-1);
			if(totalTab > 1)
				measureTypeId.setDisabled(true);
			else
				measureTypeId.setDisabled(false);
		}	
		else
		{
			measureTypeId.setDisabled(false);
			reportertemplatetab.setActiveTab(0)			
		}
		
		if(totalTab==1 && isfullyloaded)
		{
			// very first time incase of fresh template...call init method
			var url='/final/reporter/ReporterTemplateController.jsp';
			var param;
			app.method='init';
			param='method='+app.method+'&er_option=Component'+"&chartType="+curChartType;
			me.callAjax(url,param);
		}
		else if(isfullyloaded)
		{
			//var perviousTabId = me.getReportertemplatetabpane().items.items[totalTab-2].id; // last tab
			var perviousTabId = me.getReportertemplatetabpane().items.items[0].id; // first tab
			var perviousTabPerfix = perviousTabId.replace('tabContainer','');
			var perviousTabData = Ext.getCmp('er_compType'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_compType'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_compType'+activeTabNo).setValue(Ext.getCmp('er_compType'+perviousTabPerfix).getValue());
			
			var val=measureTypeId.getValue().measureType;
			var er_testTypeVal = '';
			if(val=="DDMeasure")
			{
				if(curChartType!='table' && curChartType!='digital' && curChartType!='multiDigi')
				{
					Ext.getCmp("ddGroupInfoId"+activeTabNo).show();
					Ext.getCmp("disp_MeasureName"+activeTabNo).hide();
				}
				Ext.getCmp("er_ddColumn"+activeTabNo).show();
				Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).setValue('');
				Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).fieldValues='';
				//Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("DD Columns");
				er_testTypeVal = 'Details';
			}
			else if(val=='normalMeasure')
			{	
				Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("Measure");
				Ext.getCmp("ddGroupInfoId"+activeTabNo).hide();
				Ext.getCmp("disp_MeasureName"+activeTabNo).show();
				Ext.getCmp("er_ddColumn"+activeTabNo).hide();
				Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).setValue('');
				Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).fieldValues='';
				er_testTypeVal = 'Measures';
			}
		
			perviousTabData = Ext.getCmp('er_test'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_test'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_test'+activeTabNo).setValue(Ext.getCmp('er_test'+perviousTabPerfix).getValue());
		
			perviousTabData = Ext.getCmp('er_measure'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_measure'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_measure'+activeTabNo).setValue(Ext.getCmp('er_measure'+perviousTabPerfix).getValue());

			perviousTabData = Ext.getCmp('er_ddColumn'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_ddColumn'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_ddColumn'+activeTabNo).setValue(Ext.getCmp('er_ddColumn'+perviousTabPerfix).getValue());
			
			Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData = Ext.getCmp('tabContainer'+perviousTabPerfix).ddGroupInfoData
			Ext.getCmp('tabContainer'+activeTabNo).descriptorCombo = Ext.getCmp('tabContainer'+perviousTabPerfix).descriptorCombo
		
			perviousTabData = Ext.getCmp('er_function'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_function'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_function'+activeTabNo).setValue(Ext.getCmp('er_function'+perviousTabPerfix).getValue());
			
			var component = Ext.ComponentManager.get('disp_MeasureName'+activeTabNo);
			var displyName = Ext.getCmp('disp_MeasureName'+perviousTabPerfix).getValue();
			component.setValue(displyName);
			
			
			var compChkBtn = Ext.getCmp('primgroupbyComp'+perviousTabPerfix);
			Ext.getCmp('primgroupbyComp'+activeTabNo).setValue(compChkBtn.checked);
			var desChkBtn = Ext.getCmp('primgroupbyDesc'+perviousTabPerfix);
			Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(desChkBtn.checked);
			var dateChkBtn = Ext.getCmp('primgroupbyDateChk'+perviousTabPerfix);
			Ext.getCmp('primgroupbyDateChk'+activeTabNo).setValue(dateChkBtn.checked);
			var grpInfo = '';
			if(dateChkBtn.checked)
			{
				grpInfo=Ext.getCmp('primGroupByDateId'+perviousTabPerfix).getValue()['primgroupbybox'+perviousTabPerfix];
				//Ext.getCmp('primGroupByDateId'+activeTabNo).setValue({["primgroupbybox"+activeTabNo]:[grpInfo]});
				if(grpInfo=='date')
				{
					Ext.getCmp('dateRadioBtn'+activeTabNo).setValue(true);
				}
				else if(grpInfo=='week')
				{
					Ext.getCmp('weekRadioBtn'+activeTabNo).setValue(true);
				}
				else
				{
					Ext.getCmp('monthRadioBtn'+activeTabNo).setValue(true);
				}
				
			}
			Ext.getCmp('yAxisLabel'+activeTabNo).setValue(Ext.getCmp('yAxisLabel'+perviousTabPerfix).getValue());
			Ext.getCmp('primGroupByBoxId'+activeTabNo).setDisabled(true);
			if(curChartType!='heatMap')
				Ext.getCmp('miscOptionsContainer'+activeTabNo).setDisabled(true);
			
			perviousTabData = Ext.getCmp('er_measureFilter'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_measureFilter'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_measureFilter'+activeTabNo).setValue(Ext.getCmp('er_measureFilter'+perviousTabPerfix).getValue());
			
			perviousTabData = Ext.getCmp('glduration'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('glduration'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('glduration'+activeTabNo).setValue(perviousTabData[0].valueField);
			Ext.getCmp('er_durationContainer'+activeTabNo).hide();
			
			perviousTabData = Ext.getCmp('er_descFilter'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_descFilter'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_descFilter'+activeTabNo).setValue(perviousTabData[0].valueField);
			Ext.getCmp('descIncluderId'+activeTabNo).hide();
			
			Ext.getCmp('descriptorTxtFieldId'+activeTabNo).setValue(Ext.getCmp('descriptorTxtFieldId'+perviousTabPerfix).getValue());
			
			perviousTabData = Ext.getCmp('er_top'+perviousTabPerfix).getStore().proxy.reader.rawData;
			Ext.getCmp('er_top'+activeTabNo).getStore().loadRawData(perviousTabData);
			Ext.getCmp('er_top'+activeTabNo).setValue(Ext.getCmp('er_top'+perviousTabPerfix).getValue());
			//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:[Ext.getCmp('er_enableTopN'+perviousTabPerfix).getValue()['enableTopN'+perviousTabPerfix]]});	
			if(Ext.getCmp('er_enableTopN'+perviousTabPerfix).getValue()['enableTopN'+perviousTabPerfix]=='yes')
			{
				Ext.getCmp('Yes'+activeTabNo).setValue(true);
			}
			else
			{
				Ext.getCmp('No'+activeTabNo).setValue(true);
			}
		/* 	if (!Ext.isEmpty(Ext.getCmp('er_top'+activeTabNo)))
			{
				if(curChartType!='topn')
				{['enableTopN'+obj.measureTabCount]
					Ext.getCmp('er_enableTopN'+activeTabNo).setValue({"enableTopN":['no']});
					Ext.getCmp('er_top'+activeTabNo).hide();
				}
				else
				{
					Ext.getCmp('er_enableTopN'+activeTabNo).setValue({"enableTopN":['yes']});
					Ext.getCmp('er_top'+activeTabNo).show();
				}
			} */
			var descriptorTxtField=Ext.getCmp('descriptorTxtField'+activeTabNo);
			descriptorTxtField.setValue('');		
		
			
			/* var url='/final/reporter/ReporterTemplateController.jsp';
			app.method='comptypechange';
			var param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType'+activeTabNo).getValue()+"&er_testType="+er_testTypeVal+"&chartType="+curChartType; */
			//me.callAjax(url,param);
		}
		measureTabCount = measureTabCount+1;
	},
	setCommonVisibility:function(currentTab)
	{
		if(curChartType=='pie' || curChartType=='distribution' || curChartType=='distributedPie')
		{
			/* if(app.isCustomLayout=='yes')
				Ext.getCmp('primgroupbyComp').hide();
			else
				Ext.getCmp('primgroupbyComp').setValue(true); */
			Ext.getCmp('primgroupbyComp'+currentTab).hide();
			Ext.getCmp('primgroupbyDateChk'+currentTab).hide();
			Ext.getCmp('digitalSparkIconFont'+currentTab).hide();
		}
		else if(curChartType!='digital' && curChartType!='multiDigi')
		{
			Ext.getCmp('primgroupbyComp'+currentTab).setValue(true);
			Ext.getCmp('yAxisLabel'+currentTab).setValue('Component');	
			Ext.getCmp('digitalSparkIconFont'+currentTab).hide();
			if(curChartType=='table')
			{
				Ext.getCmp('miscLblId'+currentTab).hide();
				Ext.getCmp('miscOptionsContainer'+currentTab).hide();
			}
		}
		else
		{
			//Ext.getCmp('primGroupByBoxId'+currentTab).setDisabled(true);
			Ext.getCmp('primGroupByBoxId'+currentTab).hide();//.. No need this in digital chart
			Ext.getCmp('yAxisJustLabel'+currentTab).hide();
			//Ext.getCmp('er_enableTopN'+currentTab).setDisabled(true);
			Ext.getCmp('miscLblId'+currentTab).hide();
			if(curChartType!='heatMap')
				Ext.getCmp('miscOptionsContainer'+currentTab).hide();
		}
		if(curChartType=='area')
		{
			Ext.getCmp('er_stackedArea').show();
		}
		else
		{
			Ext.getCmp('er_stackedArea').hide();
		}
		if(curChartType=='timeline' || curChartType=='area')
		{
			Ext.getCmp('er_showLegendTable').show();
		}
		else
		{
			Ext.getCmp('er_showLegendTable').hide();
		}
		if(curChartType=='bar' || curChartType=='vertbar')
		{
			Ext.getCmp('multiColor').show();
		}
		else
		{
			Ext.getCmp('multiColor').hide();
		}
		if(curChartType=='digital' || curChartType=='distributedPie' || curChartType=='topn' || curChartType=='healthWidget')
		{
			Ext.get('addMoreMes').hide();
		}
		else
		{
			Ext.get('addMoreMes').show();
		}
	},
	setTabdata:function(tabIndex,tabData)
	{
		if(tabData==undefined || tabData.selectedFields == undefined)
			return;
		if(tabIndex==0) 
		{
			Ext.getCmp('WidgetNametextField').setValue(app.currentWidget.title);
			needWidgetSourecReq = false;
			if(tabData.selectedFields.selectedTestCombo.indexOf('DDD')>-1)
				Ext.getCmp('measureTypeId').setValue({"measureType":['DDMeasure']});
			else
				Ext.getCmp('measureTypeId').setValue({"measureType":['normalMeasure']});
			Ext.getCmp('er_stackedArea').setValue(app.currentWidget.widgetConfig.er_stackedArea);
			Ext.getCmp('er_showLegendTable').setValue(app.currentWidget.widgetConfig.er_showLegendTable);
			Ext.getCmp('multiColor').setValue(app.currentWidget.widgetConfig.multiColor);
			if(Ext.getCmp('previewColor') != undefined)
				Ext.getCmp('previewColor').selectedGraphPalette=app.currentWidget.widgetConfig.selectedPaletteColor;
		}
		else if(tabIndex == 1)
		{
			Ext.getCmp('measureTypeId').setDisabled(true);
		}
		if(tabIndex!=0)
		{
			Ext.getCmp('primGroupByBoxId'+tabIndex).setDisabled(true);
			if(curChartType!='heatMap')
				Ext.getCmp('miscOptionsContainer'+tabIndex).setDisabled(true);
		} 
		if(tabData.selectedFields.selectedTestCombo.indexOf('DDD')>-1)
		{
			if(curChartType!='table' && curChartType!='digital' && curChartType!='multiDigi')
			{
				Ext.getCmp("ddGroupInfoId"+tabIndex).show();
				Ext.getCmp("disp_MeasureName"+tabIndex).hide();
			}
			Ext.getCmp("er_ddColumn"+tabIndex).show();
			//Ext.getCmp("er_measure"+tabIndex).setFieldLabel("DD Columns");
			if(curChartType=='distributedPie' && tabData.selectedFields.ddGroupInfoTxtValue.length>0)
			{
				Ext.getCmp('primGroupByBoxId'+activeTabNo).setDisabled(true);
				Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(false);
			}
		}
		this.loadComboField('er_compType'+tabIndex,'componentTypeCombo',null,'selectedComponentTypeCombo',tabData,false,null,false);
		this.loadComboField('er_test'+tabIndex,'testCombo',null,'selectedTestCombo',tabData,false,null,false);
		this.loadComboField('er_measure'+tabIndex,'measureCombo',null,'selectedMeasureCombo',tabData,false,null,false);
		this.loadComboField('er_ddColumn'+tabIndex,'ddColumnCombo',null,'selectedDDcolumnCombo',tabData,false,null,false);
		Ext.getCmp('tabContainer'+tabIndex).ddGroupInfoData = tabData.combo.ddColumnCombo
		this.loadComboField('er_function'+tabIndex,'functionCombo',null,'selectedFunctionCombo',tabData,false,null,false);
		Ext.getCmp('ddGroupInfoTxtField'+tabIndex).setValue(tabData.selectedFields.ddGroupInfoTxtValue);
		Ext.getCmp('ddGroupInfoTxtField'+tabIndex).fieldValues = tabData.selectedFields.ddGroupInfoTxtFieldValues;
		Ext.getCmp('disp_MeasureName'+tabIndex).setValue(tabData.selectedFields.selectedDispMeasureCombo);		
		if(curChartType=='digital' || curChartType=='multiDigi')
		{
			var digitalSparkFontType=Ext.getCmp('digitalSparkFontType'+tabIndex);
			var digitalSparkChartType=Ext.getCmp('digitalSparkChartType'+tabIndex);
			var digitalSparkColorPicker=Ext.getCmp('digitalSparkColorPicker'+tabIndex);
			var iconClass=Ext.getCmp('iconClass'+tabIndex);
			if(tabData.selectedFields.sparkFont != undefined)
			{
				Ext.getCmp(tabData.selectedFields.sparkFont+tabIndex).setValue(tabData.selectedFields.sparkFont);
				//digitalSparkChartType.setValue({["fonttype"+tabIndex]:[tabData.selectedFields.sparkFont]});
			}
			if(tabData.selectedFields.sparkType != undefined)
			{
				Ext.getCmp(tabData.selectedFields.sparkType+tabIndex).setValue(tabData.selectedFields.sparkType);
				//digitalSparkChartType.setValue({["chattype"+tabIndex]:[tabData.selectedFields.sparkType]});
			}
			if(tabData.selectedFields.sparkColor != undefined)
			{
				Ext.getCmp(tabData.selectedFields.sparkColor+tabIndex).setValue(tabData.selectedFields.sparkColor);
				//digitalSparkColorPicker.setValue({["ColorPickerOpt"+tabIndex]:[tabData.selectedFields.sparkColor]});
			}
			if(tabData.selectedFields.digitalIcon != undefined && tabData.selectedFields.digitalIcon != 'Not Applicable')
			{
				iconClass.setValue(tabData.selectedFields.digitalIcon);
				Ext.getCmp('iconChartTypeChoose'+tabIndex).addCls('x-btn-pressedIcon');
			}
			else
				Ext.getCmp('iconNoImageChartType'+tabIndex).addCls('x-btn-pressedIcon');
			
		}
		Ext.getCmp('primgroupbyDateChk'+tabIndex).setValue(false);
		Ext.getCmp('primgroupbyComp'+tabIndex).setValue(false);
		Ext.getCmp('primgroupbyDesc'+tabIndex).setValue(false);
		Ext.getCmp('yAxisLabel'+tabIndex).setValue('');
		
		for(var i=0;i<tabData.combo.groupByCombo.length;i++)
		{
			var val=tabData.combo.groupByCombo[i];
			if(val=="date" || val=="week" || val=="month")
			{
				Ext.getCmp('primgroupbyDateChk'+tabIndex).setValue(true);
				//Ext.getCmp('primGroupByDateId'+tabIndex).setValue({["primgroupbybox"+tabIndex]:[val]});
				if(val=='date')
				{
					Ext.getCmp('dateRadioBtn'+tabIndex).setValue(true);
				}
				else if(val=='week')
				{
					Ext.getCmp('weekRadioBtn'+tabIndex).setValue(true);
				}
				else
				{
					Ext.getCmp('monthRadioBtn'+tabIndex).setValue(true);
				}
			}
			else if(val=="descriptors" )
			{
				Ext.getCmp('primgroupbyDesc'+tabIndex).setValue(true);
			}
			else if(val=="component" )
			{
				Ext.getCmp('primgroupbyComp'+tabIndex).setValue(true);
			}
		}
		Ext.getCmp('yAxisLabel'+tabIndex).setValue(tabData.selectedFields.selectedYaxis);
		
		this.loadComboField('er_measureFilter'+tabIndex,'measureFilterCombo',null,'selectedMeasureFilterCombo',tabData,false,null,false);
		this.loadComboField('glduration'+tabIndex,'gldurationCombo',null,'selectedglduration',tabData,false,null,false);
		if(curChartType=='heatMap')
		{
			Ext.getCmp('er_measurCondition'+tabIndex).setValue(tabData.selectedFields.selectedMeasureCondtion);
			Ext.getCmp('measureCritical'+tabIndex).setValue(tabData.selectedFields.selectedMeasureCritical);
			Ext.getCmp('measureMajor'+tabIndex).setValue(tabData.selectedFields.selectedMeasureMajor);
			Ext.getCmp('measureMinor'+tabIndex).setValue(tabData.selectedFields.selectedMeasureMinor);
		}
		Ext.getCmp('er_duration'+tabIndex).setValue(tabData.selectedFields.selectedDuration);
		Ext.getCmp('er_dynamic'+tabIndex).setValue(tabData.selectedFields.selectedDynamic);
		this.loadComboField('er_descFilter'+tabIndex,'descFilterCombo',null,'',tabData,false,null,false);
		//Ext.getCmp('actionOnDes'+tabIndex).setValue({["actionOnDesBox"+tabIndex]:[tabData.selectedFields.selectedActionOnDes]});
		if(tabData.selectedFields.selectedActionOnDes=='include')
		{
			Ext.getCmp('includeRadioBtn'+tabIndex).setValue(true);
		}
		else
		{
			Ext.getCmp('excludeRadioBtn'+tabIndex).setValue(true);
		}
		Ext.getCmp('descriptorTxtField'+tabIndex).setValue(tabData.selectedFields.selecteddescriptorTxt);
		if(Ext.getCmp('primgroupbyDesc'+tabIndex).checked)
		{
			Ext.getCmp('descriptorTxtFieldId'+tabIndex).setValue(tabData.selectedFields.selectedDescriptorTxtField);
			Ext.getCmp('descFilterEnable'+tabIndex).setValue(tabData.selectedFields.selectedDescFilterEnable);
		}
		//Ext.getCmp('er_enableTopN'+tabIndex).setValue({["enableTopN"+tabIndex]:[tabData.selectedFields.selectedEnableTopN]});
		if(tabData.selectedFields.selectedEnableTopN=='yes')
		{
			Ext.getCmp('Yes'+tabIndex).setValue(true);
		}
		else
		{
			Ext.getCmp('No'+tabIndex).setValue(true);
		}
		this.loadComboField('er_top'+tabIndex,'topNCombo',null,'selectedTopN',tabData,false,null,false);
		if(curChartType=='healthWidget')
		{
			Ext.getCmp('er_test'+tabIndex).hide();
			Ext.getCmp('er_measure'+tabIndex).hide();
			Ext.getCmp('er_ddColumn'+tabIndex).hide();
			Ext.getCmp('er_function'+tabIndex).hide();
			Ext.getCmp('disp_MeasureName'+tabIndex).hide();
			Ext.getCmp('primGroupByBoxId'+tabIndex).hide();
			Ext.getCmp('measureTypeId').hide();
		}
	},
	removeMesure:function(id)
	{
		if(this.getReportertemplatetabpane().items.length==1)
		{
			return;
		}
		else if(this.getReportertemplatetabpane().items.length==2)
		{
			Ext.getCmp('measureTypeId').setDisabled(false);
		}
		else
		{
			Ext.getCmp('measureTypeId').setDisabled(true);
		}
		
		var removableTabIndex = this.getReportertemplatetabpane().items.findIndex('id', id); // find active index
		this.getReportertemplatetabpane().remove(id, true);
		this.getReportertemplatetabpane().doComponentLayout();
		if(removableTabIndex==0)
		{
			var firstTab = this.getReportertemplatetabpane().items.items[0];
			var firstTabIndex = firstTab.measureTabCount;
			Ext.getCmp('primGroupByBoxId'+firstTabIndex).setDisabled(false);
			Ext.getCmp('miscOptionsContainer'+firstTabIndex).setDisabled(false);
		}		
		if(this.getReportertemplatetabpane().items.length<5)
		{
				Ext.get('addMoreMes').setStyle({"visibility":"visible"});
		}
//		if($(".x-box-scroller-left")){
//			$('#addMoreMes').show();
//		}
		var firstTab = this.getReportertemplatetabpane().items.items[0];
		var firstTabIndex = firstTab.measureTabCount;
		if(curChartType != undefined && curChartType=='distribution')//..
		{
			Ext.getCmp('primGroupByBoxId'+firstTabIndex).setDisabled(false);
			Ext.getCmp('primgroupbyDesc'+firstTabIndex).setValue(false);
		}
	},
	mesTabBeforeChange:function(tabPanel, newCard, oldCard, eOpts)
	{
		
	},
	mesTabChange:function(panel, newTab, oldTab)
	{
		if(oldTab!=null)
		{
			tabPosition = Ext.getCmp(oldTab.id).measureTabCount;
			var headerTitle = Ext.getCmp('disp_MeasureName'+tabPosition).getValue();
			var toolTipInfo = 'data-qclass=yellowTip data-qtip="'+headerTitle+'"';
			Ext.getCmp(oldTab.id).headerTitleDisp=headerTitle;
			if (headerTitle.length>16)
			{
				headerTitle = headerTitle.substring(0,15)+'...';
			}
			Ext.getCmp(oldTab.id).headerTitle=headerTitle;
			Ext.getCmp(oldTab.id).setTitle('<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_normal11" align="right" '+toolTipInfo+' style="white-space:nowrap;height:20px">'+headerTitle+'</td></tr></table>');
		}
		if(newTab!=null)
		{
			var toolTipInfo = 'data-qclass=yellowTip data-qtip="'+Ext.getCmp(newTab.id).headerTitleDisp+'"';
			if(curChartType == undefined || curChartType != 'healthWidget')
				Ext.getCmp(newTab.id).setTitle('<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_normal11" align="right" '+toolTipInfo+'  style="white-space:nowrap;height:20px;padding-right:5px">'+Ext.getCmp(newTab.id).headerTitle+'</td><td style="float:left;" class="iconDeleteReportTemplate" onclick=\'javascript:removeMesure(tabContainer'+Ext.getCmp(newTab.id).measureTabCount+');event.stopPropagation();\'></td></tr></table>');
		}
			
		activeTabNo = newTab.measureTabCount;
		//console.log("newTab.isfullyloaded "+newTab.isfullyloaded)
		var firstTab = this.getReportertemplatetabpane().items.items[0];
		var firstTabIndex = firstTab.measureTabCount;
		if(firstTabIndex!=activeTabNo)
		{
			var compChkBtn = Ext.getCmp('primgroupbyComp'+firstTabIndex);
			Ext.getCmp('primgroupbyComp'+activeTabNo).setValue(compChkBtn.checked);
			var desChkBtn = Ext.getCmp('primgroupbyDesc'+firstTabIndex);
			Ext.getCmp('primgroupbyDesc'+activeTabNo).setValue(desChkBtn.checked);
			var dateChkBtn = Ext.getCmp('primgroupbyDateChk'+firstTabIndex);
			Ext.getCmp('primgroupbyDateChk'+activeTabNo).setValue(dateChkBtn.checked);
			var grpInfo = '';
			if(dateChkBtn.checked)
			{
				grpInfo=Ext.getCmp('primGroupByDateId'+firstTabIndex).getValue()['primgroupbybox'+firstTabIndex];
				//Ext.getCmp('primGroupByDateId'+activeTabNo).setValue({["primgroupbybox"+activeTabNo]:[grpInfo]});
				if(grpInfo=='date')
				{
					Ext.getCmp('dateRadioBtn'+activeTabNo).setValue(true);
				}
				else if(grpInfo=='week')
				{
					Ext.getCmp('weekRadioBtn'+activeTabNo).setValue(true);
				}
				else
				{
					Ext.getCmp('monthRadioBtn'+activeTabNo).setValue(true);
				}
			}
			Ext.getCmp('yAxisLabel'+activeTabNo).setValue(Ext.getCmp('yAxisLabel'+firstTabIndex).getValue());
			Ext.getCmp('descriptorTxtFieldId'+activeTabNo).setValue(Ext.getCmp('descriptorTxtFieldId'+firstTabIndex).getValue());
			var old_er_enableTopN=Ext.getCmp('er_enableTopN'+firstTabIndex).getValue()['enableTopN'+firstTabIndex];
			var old_er_top= Ext.getCmp('er_top'+firstTabIndex).getValue();
			//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:[old_er_enableTopN]});
			if(old_er_enableTopN == 'yes')
			{
				Ext.getCmp('Yes'+activeTabNo).setValue(true);
			}
			else
			{
				Ext.getCmp('No'+activeTabNo).setValue(true);
			}
			Ext.getCmp('er_top'+activeTabNo).setValue(old_er_top);
		}
		
		if(newTab.isfullyloaded)
			return;
		else
		{
			// load tab info while edit by back end hit
			var old_er_compType = Ext.getCmp('er_compType'+activeTabNo).getValue();
			var old_er_test= Ext.getCmp('er_test'+activeTabNo).getValue();
			var old_er_measure= Ext.getCmp('er_measure'+activeTabNo).getValue();
			var old_er_measureFilter= Ext.getCmp('er_measureFilter'+activeTabNo).getValue();
			var old_er_ddColumn= Ext.getCmp('er_ddColumn'+activeTabNo).getValue();
			var old_ddGroupInfoTxtField = Ext.getCmp('ddGroupInfoTxtField'+activeTabNo).getValue();
			var old_ddGroupInfoTxtFieldValue = Ext.getCmp('ddGroupInfoTxtField'+activeTabNo).fieldValues;
			var old_er_function= Ext.getCmp('er_function'+activeTabNo).getValue();
			var old_glduration= Ext.getCmp('glduration'+activeTabNo).getValue();
			var old_er_top= Ext.getCmp('er_top'+activeTabNo).getValue();
			var old_disp_MeasureName= Ext.getCmp('disp_MeasureName'+activeTabNo).getValue();
			var old_er_descFilter= Ext.getCmp('er_descFilter'+activeTabNo).getValue();
			var old_descriptorTxtField= Ext.getCmp('descriptorTxtField'+activeTabNo).getValue();
			var old_yAxisLabel= Ext.getCmp('yAxisLabel'+activeTabNo).getValue();
			var old_er_enableTopN=Ext.getCmp('er_enableTopN'+activeTabNo).getValue()['enableTopN'+activeTabNo];
			var old_er_testType = 'Measures';
			var val=Ext.getCmp('measureTypeId').getValue().measureType;
			if(val=="DDMeasure")
				old_er_testType = 'Details';
			newTab.isfullyloaded = true;
			if(old_glduration != undefined && old_glduration.indexOf('#@#') != -1)
			{
				old_er_measureFilter=old_glduration.substring(0,old_glduration.indexOf('#@#'));
				old_glduration=old_glduration.substring(old_glduration.indexOf('#@#')+3);
			}
			var url='/final/reporter/ReporterTemplateController.jsp';
			var param;
			app.method='init';
			param='method='+app.method+'&er_option=Component&chartType='+curChartType+'&er_compType='+old_er_compType;
			param+='&er_testType='+old_er_testType+'&er_test='+old_er_test+'&er_measure='+old_er_measure+'&er_ddColumn='+Ext.widget("erutils").specialCharEncode(old_er_ddColumn)+'&er_functio='+Ext.widget("erutils").specialCharEncode(old_er_function);
			param+='&er_top='+old_er_top+'&glduration='+old_glduration+'&er_measureFilter='+old_er_measureFilter;
			this.callAjax(url,param);
			Ext.getCmp('disp_MeasureName'+activeTabNo).setValue(old_disp_MeasureName);
			Ext.getCmp('yAxisLabel'+activeTabNo).setValue(old_yAxisLabel);
			//Ext.getCmp('er_enableTopN'+activeTabNo).setValue({["enableTopN"+activeTabNo]:[old_er_enableTopN]});
			if(old_er_enableTopN == 'yes')
			{
				Ext.getCmp('Yes'+activeTabNo).setValue(true);
			}
			else
			{
				Ext.getCmp('No'+activeTabNo).setValue(true);
			}
			if(old_er_testType == 'Details')
			{
				if(curChartType!='table' && curChartType!='digital' && curChartType!='multiDigi')
				{
					Ext.getCmp("ddGroupInfoId"+activeTabNo).show();
					Ext.getCmp("disp_MeasureName"+activeTabNo).hide();
				}
				Ext.getCmp("er_ddColumn"+activeTabNo).show();
				//Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("DD Columns");
				var ddGroupInfoDataArray=Ext.getCmp('tabContainer'+activeTabNo).ddGroupInfoData;
				var allDDGroupCol=old_ddGroupInfoTxtField.split(',');
				var old_ddGroupInfoTxtFieldTemp='';
				for(var eachGp in allDDGroupCol)
				{
					var eachGroup=allDDGroupCol[eachGp];
					for(var eachDD in ddGroupInfoDataArray)
					{
						var eachDDStr=ddGroupInfoDataArray[eachDD];
						if(eachGroup==eachDDStr.valueField)
						{
							old_ddGroupInfoTxtFieldTemp+=eachDDStr.displayField+',';
							break;
						}
					}
				}
				if(old_ddGroupInfoTxtFieldTemp.length>0)
					old_ddGroupInfoTxtField=old_ddGroupInfoTxtFieldTemp.substring(0,old_ddGroupInfoTxtFieldTemp.lastIndexOf(','));
				Ext.getCmp('ddGroupInfoTxtField'+activeTabNo).setValue(old_ddGroupInfoTxtField);
				Ext.getCmp('ddGroupInfoTxtField'+activeTabNo).fieldValues = old_ddGroupInfoTxtFieldValue;
			}
			if(old_er_descFilter != 'all')
			{
				Ext.getCmp('er_descFilter'+activeTabNo).setValue(old_er_descFilter);
				this.onSelectDescFilter(Ext.getCmp('er_descFilter'+activeTabNo));
				Ext.getCmp('descriptorTxtField'+activeTabNo).setValue(old_descriptorTxtField);
			}			
		}
	},
	measureChange:function(btn)
	{
		if(!needWidgetSourecReq)
		{
			needWidgetSourecReq = true;
			return;
		}	
		var val=btn.getValue().measureType;
		var er_testTypeVal = '';
		if(val=="DDMeasure")
		{
			if(curChartType!='table' && curChartType!='digital' && curChartType!='multiDigi')
			{
				Ext.getCmp("ddGroupInfoId"+activeTabNo).show();				
				Ext.getCmp("disp_MeasureName"+activeTabNo).hide();
			}
			Ext.getCmp("er_ddColumn"+activeTabNo).show();
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).setValue('');
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).fieldValues='';
			//Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("DD Columns");
			er_testTypeVal = 'Details';
		}
		else if(val=='normalMeasure')
		{	
			Ext.getCmp("er_measure"+activeTabNo).setFieldLabel("Measure");
			Ext.getCmp("ddGroupInfoId"+activeTabNo).hide();
			Ext.getCmp("disp_MeasureName"+activeTabNo).show();
			Ext.getCmp("er_ddColumn"+activeTabNo).hide();
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).setValue('');
			Ext.getCmp("ddGroupInfoTxtField"+activeTabNo).fieldValues='';
			er_testTypeVal = 'Measures';
		}
		var url='/final/reporter/ReporterTemplateController.jsp';
		app.method='comptypechange';
		var param='method='+app.method+'&er_compType='+Ext.getCmp('er_compType'+activeTabNo).getValue()+"&er_testType="+er_testTypeVal+"&chartType="+curChartType;
		this.callAjax(url,param);
	},
	onDurationChange:function(obj)
	{
		var val="None";
		if(obj != undefined)
			val=obj.getValue();
	
		if(val=="None" || val=="none")
		{
			Ext.getCmp('er_durationContainer'+obj.measureTabCount).hide();
		}
		else
		{
			Ext.getCmp('er_durationContainer'+obj.measureTabCount).show();
		}
	},
	processOnGroupLabel:function(actionIndex)
	{
		var compChkBtn = Ext.getCmp('primgroupbyComp'+actionIndex);
		var dateChkBtn = Ext.getCmp('primgroupbyDateChk'+actionIndex);
		var desChkBtn = Ext.getCmp('primgroupbyDesc'+actionIndex);
		var labelVal = '';
		if(compChkBtn.checked)
		{
			labelVal='Component';
		}
		if(desChkBtn.checked)
		{
			if(labelVal.length==0)
				labelVal = 'Descriptor';
			else
				labelVal+='/Descriptor';
		}
		if(dateChkBtn.checked)
		{
			var grpInfo = Ext.getCmp('primGroupByDateId'+actionIndex).getValue()['primgroupbybox'+actionIndex];
			if(labelVal.length==0)
				labelVal = grpInfo;
			else
				labelVal+='/'+grpInfo;
		}
		Ext.getCmp('yAxisLabel'+actionIndex).setValue(labelVal);
	},
	onSelectDescFilter:function(obj)
	{
		if (!Ext.isEmpty(obj))
		{
			if (obj.getValue()!='all')
			{
				this.ajaxQueryMaker(obj);
			}
		}
	},
	onChangeDescFilter:function(obj)
	{
		if (!Ext.isEmpty(obj))
		{
			if (obj.getValue()=='all')
			{
				Ext.getCmp('descIncluderId'+obj.measureTabCount).hide();
				Ext.getCmp('descriptorTxtField'+obj.measureTabCount).hide();
			}
			else
			{
				Ext.getCmp('descIncluderId'+obj.measureTabCount).show();
				Ext.getCmp('descriptorTxtField'+obj.measureTabCount).show();
			}
		}
	},
	processDescpFilter:function(obj)
	{
		if (obj.checked)
		{
			//Ext.getCmp('descriptorTxtFieldId'+obj.measureTabCount).show();//.. No need beacuase x axis label text taken from
			//Ext.getCmp('descFilterEnable'+obj.measureTabCount).show();
		}
		else
		{
			Ext.getCmp('descriptorTxtFieldId'+obj.measureTabCount).hide();
			Ext.getCmp('descFilterEnable'+obj.measureTabCount).hide();
		}
		this.processOnGroupLabel(obj.measureTabCount);
	},
	onClickTempCreate:function(obj)
	{
		app.isCustomLayout=='yes'
		var url='/final/reporter/ReporterTemplateController.jsp';
		var iniParams=this.getIniParams();
		if(iniParams!=undefined && iniParams!='undefined')
		{
			this.callAjax(url,iniParams);
		}
	},
	getIniParams:function()
	{
		app.method='setini';
		var iniParams=app.infoParams;
		if (app.isCustomLayout=='yes')
		{
			if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
			{
				var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
				var gridstackdata222 = Ext.getCmp('reportergridstackpanel')._serializationStr();
				var gridster_items = GridStackUI.Utils.sort(gridstackdata,1);
				
				gridster_items.sort(function(a, b)
				{
					//parseFloat(value)
					var a_x = a.dataX;
					var a_y = a.dataY;
					var b_x = b.dataX;
					var b_y = b.dataY;
					var a_posStr = a_y+'.'+a_x;;
					if(a_x<10)
					{
						a_posStr = a_y+'.0'+a_x;
					}
					var b_posStr = b_posStr = b_y+'.'+b_x;;
					if(b_x<10)
					{
						b_posStr = b_y+'.0'+b_x;
					}
					var retVal = -1;
					var u =  parseFloat(a_posStr);
					var v =  parseFloat(b_posStr);
					if(u==v)
					{
					  retVal= 0;
					}
					else if(u>v)
					{
					  retVal= 1;
					}
					return retVal;
				});
				var widgetList=new Array();
				if (gridster_items.length>0)
				{
					for (var item in gridster_items)
					{
						var ddRawConfigString=new Array();
						var gridster_obj=gridster_items[item];
						var eachPanel=Ext.getCmp(gridster_obj.id);
						if(!Ext.isEmpty(eachPanel) && !Ext.isEmpty(eachPanel.widgetConfig))
						{
							var chartConfigArray=eachPanel.widgetConfig.chartConfigArray;
							//console.log('chartConfigArray	',chartConfigArray);
							if (!Ext.isEmpty(chartConfigArray))
							{
								var ddGrpByMes=new Object();
								for (var key in chartConfigArray)
								{
									var record=chartConfigArray[key];

									var ddconfigStrByMes=new Array();
									var gridTestName=record.testValue;
									var ddconfigString=record.ddconfigString;
									if(gridTestName.indexOf("_DDD")>-1 && (ddconfigString!=''))
									{
										if(ddconfigString.indexOf('*')!=-1)
										{
											var ddconfigStringAry=ddconfigString.split('*');
											for(var ii=0;ii<ddconfigStringAry.length;ii++)
											{
												var ddconfigStringStr=ddconfigStringAry[ii].replace('comptypeid','');
												ddconfigStrByMes.push(ddconfigStringStr.replace("%","EGPERCENTEG"));
												iniParams+='&widgetInfo'+item+'$'+ddconfigStringAry[ii].replace("%","EGPERCENTEG");
											}
										}
										else
										{
											var ddconfigStringStr=record.ddconfigString.replace('comptypeid','');
											ddconfigStrByMes.push(ddconfigStringStr.replace("%","EGPERCENTEG"));
											var ddconfigString=record.ddconfigString;
											iniParams+='&widgetInfo'+item+'$'+ddconfigString.replace("%","EGPERCENTEG");
										}
										var dispName=record.displayName;
										dispName=dispName.replace("%","EGPERCENTEG");
										ddGrpByMes[dispName]=ddconfigStrByMes;
									}


									if (record['function']!='Raw' || record['function']!='None')
									{
										//iniParams+='&widgetInfo'+item+'~'+record.configString;
										var configString=record.configString;
										iniParams+='&widgetInfo'+item+'$'+configString.replace("%","EGPERCENTEG");
									}
									else
										ddRawConfigString.push(record.configString);
								}

								var widgetInfo=new Object();
								widgetInfo.headerDescription=Ext.get(eachPanel.header.id+'_hd-textEl').dom.innerHTML;
								var hdDescription=widgetInfo.headerDescription;
								widgetInfo.headerDescription=hdDescription.replace("%","EGPERCENTEG");

								if(eachPanel.widgetConfig.descDisplayName!=undefined && eachPanel.widgetConfig.descDisplayName!='undefined')
									widgetInfo.descDisplayName=eachPanel.widgetConfig.descDisplayName;
																
								if(eachPanel.widgetConfig.enableMetrics!=undefined && eachPanel.widgetConfig.enableMetrics!='undefined')
								{
									widgetInfo.enableMetrics=eachPanel.widgetConfig.enableMetrics;
								}
								if(eachPanel.widgetConfig.enableComp!=undefined && eachPanel.widgetConfig.enableComp!='undefined')
								{
									widgetInfo.enableComp=eachPanel.widgetConfig.enableComp;
								}
								if(eachPanel.widgetConfig.enableDesc!=undefined && eachPanel.widgetConfig.enableDesc!='undefined')
								{
									widgetInfo.enableDesc=eachPanel.widgetConfig.enableDesc;
								}
								if(eachPanel.widgetConfig.enableDispName!=undefined && eachPanel.widgetConfig.enableDispName!='undefined')
								{
									widgetInfo.enableDispName=eachPanel.widgetConfig.enableDispName;
								}
								widgetInfo.yAxisLabel = eachPanel.widgetConfig.yAxisLabel;
								if(eachPanel.selectedGraphPalette==null||eachPanel.selectedGraphPalette=='null'||eachPanel.selectedGraphPalette==undefined||eachPanel.selectedGraphPalette=='undefined')
								{
									widgetInfo.selectedPaletteColor='';
									if(eachPanel.widgetConfig.selectedPaletteColor != undefined)
										widgetInfo.selectedPaletteColor=eachPanel.widgetConfig.selectedPaletteColor;
								}
								else
									widgetInfo.selectedPaletteColor=eachPanel.selectedGraphPalette;
								if(!Ext.isEmpty(eachPanel.getDockedItems()[1]))
								{
									textareafield=eachPanel.getDockedItems()[1].down('textareafield');
									if (!Ext.isEmpty(textareafield))
									{
										widgetInfo.footerDescription=textareafield.getValue();
									}
								}
								if(eachPanel.widgetConfig.chartType=="bar")
								{
									widgetInfo.barAlignment="Horizontal";
								}
								else if(eachPanel.widgetConfig.chartType=="vertbar")
								{
									widgetInfo.barAlignment="Vertical";
								}
								widgetInfo.chartType=eachPanel.widgetConfig.chartType;
								widgetInfo.x=gridster_obj.dataY+1;
								widgetInfo.y=gridster_obj.dataX+1;
								widgetInfo.size_x=gridster_obj.dataWidth;
								widgetInfo.size_y=gridster_obj.dataHeight;
								//widgetInfo.width=parseInt(widget_baseWidth)*gridster_obj.size_x;
								widgetInfo.width=Ext.util.Format.round((1000/12)*gridster_obj.dataWidth,0);
								widgetInfo.height=parseInt(widget_baseHeight)*gridster_obj.dataHeight;
								//widgetInfo.supportableComponentTypes=eachPanel.supportableComponentTypes;
								widgetInfo.groupBy=eachPanel.widgetConfig.groupBy;
								var ddGroupByArry=eachPanel.widgetConfig.ddGroupBy;
								var newDDGpArry=new Array();
								for(var d=0;d<ddGroupByArry.length;d++)
								{
									var eachGp=ddGroupByArry[d];
									if(eachGp != undefined && eachGp.indexOf("%") != -1)
									{
										eachGp=eachGp.replace("%","EGPERCENTEG");
									}
									newDDGpArry.push(eachGp);

								}
								widgetInfo.ddGroupBy=newDDGpArry;
								widgetInfo.enableTopN=eachPanel.widgetConfig.enableTopN;
								widgetInfo.showMultipleCharts=eachPanel.widgetConfig.showMultipleCharts;
								widgetInfo.er_stackedArea=eachPanel.widgetConfig.er_stackedArea;
								widgetInfo.er_showLegendTable=eachPanel.widgetConfig.er_showLegendTable;
								widgetInfo.multiColor=eachPanel.widgetConfig.multiColor;

								//console.log(widgetInfo)
								//console.log("===eachPanel.widgetConfig===bb>>>"+Ext.encode(eachPanel.widgetConfig));
								//console.log("===eachPanel.widgetConfig===top>>>"+eachPanel.widgetConfig.enableTopN);

								//alert(item)
								if (eachPanel.widgetConfig.enableTopN=='yes')
								{
									widgetInfo.basedOnTestMeasure=eachPanel.widgetConfig.basedOnTestMeasure;
									//alert("========11=sdf====="+Ext.getCmp('er_basedOnMeasure').getValue() );
									//alert("========11======"+eachPanel.widgetConfig.basedOnTestMeasure );									
									//widgetInfo.basedOnTestMeasure=Ext.encode(eachPanel.widgetConfig.basedOnTestMeasure);									
									widgetInfo.top=eachPanel.widgetConfig.top;
								}
								if(curChartType=="table")
								{
									widgetInfo.sortByValue=Ext.encode(eachPanel.widgetConfig.sortByValue)
								}

								widgetInfo.ddGroupByMeasure=ddGrpByMes;
								var wid='widgetInfo'+item;
								widgetList.push(wid);
								iniParams+='&'+wid+'='+Ext.encode(widgetInfo);
								iniParams+='&'+wid+'_ddRaw='+Ext.encode(ddRawConfigString);
							}
							else
							{
								this.getMessageBox('eG Custom Reports','Please configure all widgets');
								return;
							}
						}
						else
						{
							this.getMessageBox('eG Custom Reports','Please configure all widget(s)');
							return;
						}
					}
					iniParams+='&widgetList='+Ext.encode(widgetList);
				}
				else
				{
					this.getCallbackMessageBox('eG Custom Reports','Please add widgets to the template','showConfigWindow');
					return;
				}
			}
			else
			{
				this.getCallbackMessageBox('eG Custom Reports','Please add widget(s) to configure','showConfigWindow');
				return;
			}
			//console.log("===iniParams==from==method==>>>"+JSON.stringify(iniParams));
		}
		
		iniParams+='&isDescFilter=no';
		
		iniParams+='&isCustomLayout='+app.isCustomLayout;
		iniParams+='&method='+app.method;
		var multiMeasureSupport='no';
		if(!Ext.isEmpty(Ext.getCmp("multiMeasure")))
		{
			if (Ext.getCmp('multiMeasure').getValue()==true)
			{
				multiMeasureSupport='yes';
			}
		}
		else
		{
			multiMeasureSupport='yes';
		}
		iniParams+='&multiMeasureSupport='+multiMeasureSupport;
		iniParams+='&isEditTemplate='+isEditTemplate;
		//console.log('iniParams>>>>>>>>>> ',iniParams)
		return iniParams;
	},
	loadAllUser:function()
	{
		var url="ReporterTemplateController.jsp";
		app.method='getUsers';
		var param;
		param='method='+app.method;
		Ext.Ajax.request({
			url:url,
			params:param,
			//async:isAsync,
			success : function(response){
				app.builderJson=Ext.decode(response.responseText);
				var component = Ext.ComponentManager.get('user_list');
				var rawData = app.builderJson;
				if(component!=undefined&&component!='undefined')
				{
					component.getStore().removeAll();
					app.userCombo = rawData['userArray'];
					component.getStore().loadRawData(app.userCombo);
				}
				if(isEditTemplate && app.isCustomLayout=='yes')
				{
					var templateNameField= Ext.getCmp("templateName")
					templateNameField.readOnly=true;
					var entireArray = (app.infoParams).split('&');
					var templateName = entireArray[0].replace('templateName=','');
					var templateDescription = entireArray[1].replace('templateDescription=','');
					var sharing = entireArray[2].replace('sharing=','');
					var userList = entireArray[3].replace('userList=','');
					var user_List = userList.split(',');
					var templateNameDisp = templateName;
					if(templateNameDisp.indexOf('.')>-1)
					{
						templateNameDisp = templateNameDisp.substring(templateNameDisp.lastIndexOf('.')+1);
					}
					templateNameField.fieldValue = templateName;
					templateNameDisp = app.erUtils.specialCharDecode(templateNameDisp);
					templateNameField.setValue(templateNameDisp);
					templateDescription = app.erUtils.specialCharDecode(templateDescription);
					Ext.getCmp("templateDescription").setValue(templateDescription);
					Ext.getCmp("templateDescription").focus(false, 200);

					if(sharing=='Private')
					{
						Ext.getCmp('privateId2').toggle(true);
					}
					if(sharing=='Public')
					{
						Ext.getCmp('PublicId2').toggle(true);
					}
					if(sharing=='Share')
					{
						Ext.getCmp('shareId2').toggle(true);
						Ext.getCmp('sharedUsersObj2').el.setStyle('visibility','visible');
						for(var usrs in user_List)
						{
							var record1 = component.getStore().findRecord("valueField", user_List[usrs]);
							component.getSelectionModel().select(record1,true);
						}
					}
				}
				else if(!isEditTemplate)
				{
					Ext.getCmp("templateName").setValue('');
				}
			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});
	},	
	expandCheckBxAction:function(StoreId)
	{
		Ext.create('Ext.window.Window',{
			width:722,
			border:false,
			frame:false,
			modal: true,
			ghost: false,
			header:false,
			id:'expandWindow',
			ui:'newPopupWindow withBorderShadow',
			listeners: {
				show: function (win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							var el = Ext.fly(dom[y]);
						}
					el.addCls('windowModalNoBg');
					}
				},
				hide: function (win) {
					var dom = Ext.dom.Query.select('.x-mask');
					if (this.modal) {

						var el = Ext.fly(dom[0]);
						el.removeCls('windowModalNoBg');
					}
				},
				afterrender: function () {
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			doClose: function() {
				var me = this;
				if (me.hidden) {
					me.fireEvent('close', me);
					if (me.closeAction == 'destroy') {
						this.destroy();
					}
				} else {
					me.hide(me.animateTarget, me.doClose, me);
				}
			},
			buttonAlign:'center',
			items:[
			{
				xtype:'expandcheckbxview',
				dataStoreId:StoreId,
				cmpLabel:'Share to - Available User',
				windowId:'expandWindow',
			}],
		}).show();
	},
	registerDeleteRecordEvent:function(grid)
	{
		var removeIconId;
		 var me=this;
		 var msgInfo='Do you want to remove selected templates?';
		 var gridId=grid.getId();
		 if (gridId=='configdataid')
		 {
			removeIconId='#removeALL';
			msgInfo='Do you want to remove selected measures?';
		 }
		 else if (gridId=='reportbuildergridid')
			 removeIconId='#removeAllIni';
		 else
			 return;

		grid.mon(Ext.select(removeIconId), 'click', function() {
			var selectionArray = grid.getSelectionModel().getSelection();
			var totalData=grid.getStore().getCount();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				Ext.Msg.show({
					title : 'eG custom report',
					msg : msgInfo,
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							if(removeIconId=='#removeALL')
							{
								var er_basedOnMeasureStore=Ext.getCmp('er_basedOnMeasure').getStore();
								var er_sortByComboeStore=Ext.getCmp('er_sortByCombo').getStore();
								var er_basedOnMeasure = Ext.getCmp('er_basedOnMeasure');
								var count=er_basedOnMeasureStore.getCount();
								if(totalData==selectionArrayLen)
								{
									for (var i=0;i<selectionArrayLen;i++)
									{
										var row = grid.getSelectionModel().getSelection()[i];


										for (var j=0;j<count;j++)
										{
											var rec=er_basedOnMeasureStore.getAt(j);
											var sortrec=er_sortByComboeStore.getAt(j);
											if (rec.data.displayField==row.data.displayName)
											{
												er_basedOnMeasureStore.remove(rec);
												er_sortByComboeStore.remove(sortrec);

												if (row.data.displayName==er_basedOnMeasure.getRawValue())
												{
													er_basedOnMeasure.setValue('-1');
													er_sortByCombo.setValue('-1');
												}
												break;
											}
										}

										if(row.data!=undefined && !Ext.isEmpty(Ext.getCmp(row.data.displayName+'-group')))
												Ext.getCmp(row.data.displayName+'-group').destroy();
									}
									grid.getSelectionModel().deselectAll();
									grid.getStore().removeAll();
									selectionArray=[];
								}
								else
								{
									for (var i=0;i<selectionArrayLen;i++)
									{
										var row = selectionArray[i];


										for (var j=0;j<count;j++)
										{
											var rec=er_basedOnMeasureStore.getAt(j);
											var sortrec=er_sortByComboeStore.getAt(j);
											if (rec.data.displayField==row.data.displayName)
											{
												er_basedOnMeasureStore.remove(rec);
												er_sortByComboeStore.remove(sortrec);

												if (row.data.displayName==er_basedOnMeasure.getRawValue())
												{
													er_basedOnMeasure.setValue('-1');
													er_sortByCombo.setValue('-1');
												}
												break;
											}
										}


										grid.getStore().remove(row);
										if(row!=undefined && row.data!=undefined && !Ext.isEmpty(Ext.getCmp(row.data.displayName+'-group')))
												Ext.getCmp(row.data.displayName+'-group').destroy();
									}
								}
							}
							else
							{
								var gridStore=grid.getStore();
								app.method='deleteAndGetIni';
								var paramsObject=new Object();
								var url='/final/reporter/ReporterTemplateController.jsp';
								paramsObject.method=app.method;
								paramsObject.builderType=app.builderType;
								if(totalData==selectionArrayLen)
								{
									grid.getSelectionModel().deselectAll();

								}
								for (var i = 0; i < selectionArrayLen; i++)
								{
									var record = new Object();
									record.templateName=selectionArray[i].data.templateName;
									paramsObject.recordInfo=Ext.encode(record);
									me.callAjax(url,paramsObject);
								}
							}
						}
					}
				});
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to delete');
			}
		});
		//..
		//for up move
		grid.mon(Ext.select('#upMovement'), 'click', function() {
			var paramsObject=new Object();
			var url='/final/reporter/ReporterTemplateController.jsp';
		//	this.callAjax(url,paramsObject);
			var selectionArray = grid.getSelectionModel().getSelection();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				var gridStore=grid.getStore();
				for (i = 0; i < selectionArrayLen; i++) {
					var index = gridStore.indexOf(selectionArray[i]);
					if(index != 0){
						gridStore.remove(selectionArray[i]);
						gridStore.insert(index-1, selectionArray[i]);
					}
				}
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to move up');
			}
		});
		//for down move
		grid.mon(Ext.select('#downMovement'), 'click', function() {
			var selectionArray = grid.getSelectionModel().getSelection();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				var gridStore=grid.getStore();
				for (i = 0; i < selectionArrayLen; i++) {
					var index = gridStore.indexOf(selectionArray[i]);
					var totRow = gridStore.getCount();
					if(index != totRow-1){
						gridStore.remove(selectionArray[i]);
						gridStore.insert(index+1, selectionArray[i]);
					}
				}
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to move down');
			}
		});
	},
	cancelCreation:function(obj)
	{
		var me=this;
		var url="ReporterTemplateController.jsp";
		Ext.Ajax.request({
			url:url,
			params:'method=getIniForHelpPage',
			//async:isAsync,
			success : function(response){
				if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
				{
					Ext.getCmp('reportergridstackpanel')._removeAllWidget();
					Ext.getCmp('gridsterstackpanel').hide();
				}
				app.isfreshTemplate='no';
				Ext.getCmp('reportbuildertop').show();
				Ext.getCmp('listViewBtnId').show();
				Ext.getCmp('gridViewBtnId').show();
				if(defaultView=='boxView')
				{
					Ext.getCmp('reportBuilderBoxViewPage').show();
					Ext.getCmp('reportbuildergridid').hide();
				}
				else
				{
					Ext.getCmp('reportBuilderBoxViewPage').hide();
					Ext.getCmp('reportbuildergridid').show();
				}
				var thisMain= Ext.getCmp('reportTemplateMain');
				Ext.getCmp('mainWindowHeader').update('<div class="newFont_bold14">eG Custom Reports</div>');
				thisMain.setAutoScroll(false);
				thisMain.doLayout();
				thisMain.doComponentLayout();
			},
			failure:function(err){
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});
	},
	editTemplateDecs:function(obj)
	{
		isEditTemplate = true;
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle("Create New Template");
		this.getCustomwindow().add({xtype:'reportdescriptionalias'});
		this.getCustomwindow().show();
		Ext.getCmp("create").hide();
		Ext.getCmp("templateName").setReadOnly(true);
		Ext.getCmp("saveEdit").show();

	},
	saveEditInfo:function()
	{
		var templateName=Ext.getCmp('templateName').fieldValue;
		var templateDescription=Ext.getCmp('templateDescription').getValue();
		var sharing='';
		var userList;
		var user_List=[];
		if(Ext.getCmp('privateId2').pressed)
			sharing="Private";
		else if(Ext.getCmp('PublicId2').pressed)
			sharing="Public";
		else if(Ext.getCmp('shareId2').pressed)
		{
			sharing="Share";

			userList=Ext.getCmp('user_list');
			var selectedUser=userList.getSelectionModel().getSelection();
		}


		if(sharing=="Share")
		{
			if(selectedUser=="" || selectedUser.length==0)
			{
				this.getMessageBox('eG Custom Reports','Please Select User list');
				return;
			}
			else
			{
				for (var i=0;i<selectedUser.length;i++)
				{
					var row = userList.getSelectionModel().getSelection()[i];
					user_List.push(row.data.valueField)
				}
			}
		}

		if (!Ext.isEmpty(this.getCustomwindow()))
		{
			this.getCustomwindow().doClose();
		}

		app.infoParams='templateName='+templateName+'&templateDescription='+Ext.widget("erutils").specialCharEncode(templateDescription)+'&sharing='+sharing+'&userList='+user_List;
	},
	setSelectAllTemplates:function(isChecked)
	{
		var renderCheckBox = Ext.query('div.addCheckBox');
		if(isChecked)
		{
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				var isshared = chkBoxObj.SharedData;
				if(isshared == false)
				{
					chkBoxObj.setValue(true);
					chkBoxObj.show();
				}
			}
		}
		else
		{
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				chkBoxObj.setValue(false);
				chkBoxObj.hide();
			}
		}
	},
	deletSelectedTemplateByListView:function()
	{
		app.method='deleteAndGetIni';
		var me=this;
		var renderCheckBox = Ext.query('div.addCheckBox');
		if (renderCheckBox.length>0)
		{
			var paramsObject=new Object();
			var isTemplateChecked=false;
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var ccc = Ext.getCmp('cc_'+i);
				if(ccc.checked)
				{
					isTemplateChecked=true;
					var record = new Object();
					record.templateName=ccc.data;
					paramsObject['recordInfo'+i]=Ext.encode(record);
				}
			}
			if(isTemplateChecked)
			{
				Ext.Msg.show({
					title : 'eG custom report',
					msg : 'Do you want to delete selected template(s)?',
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							var url='/final/reporter/ReporterTemplateController.jsp';
							paramsObject.method=app.method;
							paramsObject.builderType=app.builderType;
							//console.log(paramsObject);
							me.callAjax(url,paramsObject);
						}
					}
				});
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a template(s) to delete');
			}
		}
		else
		{
			me.getMessageBox('eG Custom Reports','No template(s) to delete');
		}
	},
	deleteRecordsFromIni:function(grid,record)
	{
		app.method='deleteAndGetIni';
		var paramsObject=new Object();
		if(record=='All')
		{
			var store = grid.getStore();
			store.each(function(rec,idx){
				paramsObject['recordInfo'+idx]=Ext.encode(rec.data);
			});
			store=null;delete store;
		}
		else
		{
			paramsObject.recordInfo=Ext.encode(record.data);
		}
		var url='/final/reporter/ReporterTemplateController.jsp';
		paramsObject.method=app.method;
		paramsObject.builderType=app.builderType;
		this.callAjax(url,paramsObject);
	},
	deleteRecordsFromIniByList:function(templateName)
	{
		var me=this;
		Ext.Msg.show({
			title : 'eG custom report',
			cls:'egMsgBox',
			msg : 'Do you want to remove the template?',
			buttons : Ext.Msg.YESNO,
			icon : Ext.Msg.QUESTION,
			fn : function(buttonVal)
			{
				if (buttonVal == "yes")
				{
					app.method='deleteAndGetIni';
					var paramsObject=new Object();
					var record = new Object();
					record.templateName=templateName;
					if(record=='All')
					{
						/* var store = grid.getStore();
						store.each(function(rec,idx){
							paramsObject['recordInfo'+idx]=Ext.encode(rec.data);
						});
						store=null;delete store; */
					}
					else
					{
						//paramsObject['recordInfo'+0]=Ext.encode(record);
						paramsObject.recordInfo=Ext.encode(record);
					}
					var url='/final/reporter/ReporterTemplateController.jsp';
					paramsObject.method=app.method;
					paramsObject.builderType=app.builderType;
					me.callAjax(url,paramsObject);
				}
			}
		});
	},
	generateFromListView:function(templateName)
	{
		var record = new Object();
		record.templateName=templateName;//window.location.href='/final/reporter/ReportBuilder.jsp?fromReportBuilder=false&method=init&recordInfo='+Ext.encode(record);
		
		sessionStorage.setItem("expanedPane", "function");
		sessionStorage.setItem("nodeId", "/final/reporter/ReportTemplate.jsp?builderType=createMylink_4|1");
		sessionStorage.setItem("isLeafNode", true);
		sessionStorage.setItem("nodeMode", "expand");
		sessionStorage.setItem("borderCollapse", true);

		/* sessionStorage.setItem("nodeId", null);
		sessionStorage.setItem("isLeafNode", null);
		sessionStorage.setItem("nodeMode", null); */

		var param = 'URL=/final/reporter/ReportBuilder.jsp';
		param+='&fromReportBuilder=false&method=init&recordInfo='+Ext.encode(record);
		//window.location.href = '/final/monitor/EgReporter.jsp?'; 
		 Ext.Ajax.request({
			//url:'/final/reporter/ErSetLastAcessedUrl.jsp?'+param,
			url:'/final/reporter/ErSetLastAcessedUrl.jsp?',
			params:param,
			scope:this,
			async:false,
			success : function(response){
				var finalResponse = Ext.decode(response.responseText);
				window.location.href = '/final/monitor/EgReporter.jsp?'; 
			},
			faliure:function(err){
				Ext.MessageBox.alert('Error occured in ErSetLastAcessedUrl.jsp page');
			}
		}); 
	},
	loadListOfWidget:function()
	{
		Ext.getCmp('widgetListGridId').getStore().load();
		if (!Ext.isEmpty(Ext.getCmp('reportergridstackpanel')))
		{
			var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
			var gridster_items = GridStackUI.Utils.sort(gridstackdata);

			var widgetList=new Array();
			if (gridster_items.length>0)
			{
				var gridDataAry = new Array();
				
				for (var item in gridster_items)
				{
					var gridster_obj=gridster_items[item];
					var eachPanel=Ext.getCmp(gridster_obj.id);
					if(!Ext.isEmpty(eachPanel) && !Ext.isEmpty(eachPanel.widgetConfig))
					{
						var gridDataObj = new Object();
						gridDataObj.widgetName = Ext.get(eachPanel.header.id+'_hd-textEl').dom.innerHTML;
						gridDataObj.widgetSource = 'Measure'
						if(eachPanel.editableObj[0].selectedFields.selectedTestCombo.indexOf('DDD')>-1)
							gridDataObj.widgetSource = 'DD'
						gridDataObj.chartType = this.getGrayChartIconOrDefaultTitle(eachPanel.widgetConfig.chartType,'title');
						gridDataObj.panelId = eachPanel.id;
						
						var childInfoHtml = '<div class="newTable" style="margin:10px 0px 10px 55px;"><table cellpadding="0px" cellspacing="0px" width="100%">';
						childInfoHtml+='<thead><tr>';
						childInfoHtml+='<th>MEASURE NAME</th>';
						childInfoHtml+='<th>COMPONENT TYPE</th>';
						childInfoHtml+='<th>TEST</th>';
						childInfoHtml+='<th>MEASURE</th>';
						childInfoHtml+='<th>DD COLUMN</th>';
						childInfoHtml+='<th>FUNCTION</th>';
						childInfoHtml+='</tr></thead>';
						childInfoHtml+='<tbody>';
						
					 	var chartConfigArray=eachPanel.widgetConfig.chartConfigArray;
						if (!Ext.isEmpty(chartConfigArray))
						{
							for (var key in chartConfigArray)
							{
								var record=chartConfigArray[key];
								childInfoHtml+='<tr>';
								childInfoHtml+='<td>'+record.displayNameDummy+'</td>';
								childInfoHtml+='<td>'+record.componentType+'</td>';
								childInfoHtml+='<td>'+record.test+'</td>';
								childInfoHtml+='<td>'+record.measure+'</td>';
								childInfoHtml+='<td>'+record.ddColumn+'</td>';
								childInfoHtml+='<td>'+record['function']+'</td>';
								childInfoHtml+='</tr>';
							}
						}
						childInfoHtml+='</tbody>';
						childInfoHtml+='</table></div>';
						
						gridDataObj.childInfo = childInfoHtml;
						gridDataAry.push(gridDataObj);
					}
				}
				var widgetListGrid = Ext.getCmp('widgetListGridId');
				var dataArray=gridDataAry;
				var datArray=widgetListGrid.dataArray;
				var dummyArray=widgetListGrid.dummyArray;
				widgetListGrid.getStore().removeAll();

				datArray.splice(0, datArray.length);
				dummyArray.splice(0, dummyArray.length);
				for(var i=0;i<dataArray.length;i++)
				{
					datArray.push(dataArray[i]);
					dummyArray.push(dataArray[i]);
				}
				var curpage=widgetListGrid.activePage;
				var totalCount=widgetListGrid.getStore().totalCount;
				var pageSize=widgetListGrid.getStore().pageSize;
				if(Math.round(totalCount/pageSize)<curpage)
				{
					widgetListGrid.activePage=Math.round(totalCount/pageSize);
				}
				if(widgetListGrid.activePage<=0)
					widgetListGrid.activePage=1;
				widgetListGrid.getStore().loadPage(widgetListGrid.activePage);
			}
		}
	},
	registerWidegtDeleteEvent:function(grid)
	{
		var removeIconId;
		 var me=this;
		 var msgInfo='';
		 var gridId=grid.getId();
		 if (gridId=='widgetListGridId')
		 {
			removeIconId='#removeAllWidget';
			msgInfo='Do you want to remove selected widget?';
		 }
		 else
			 return;

		grid.mon(Ext.select(removeIconId), 'click', function() {
			var selectionArray = grid.getSelectionModel().getSelection();
			var totalData=grid.getStore().getCount();
			var selectionArrayLen=selectionArray.length;
			if (selectionArrayLen>0)
			{
				Ext.Msg.show({
					title : 'eG custom report',
					msg : msgInfo,
					cls:'egMsgBox',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal)
					{
						if (buttonVal == "yes")
						{
							if(removeIconId=='#removeAllWidget')
							{
								if(totalData==selectionArrayLen)
								{
									grid.getSelectionModel().deselectAll();
									grid.getStore().removeAll();
									Ext.getCmp('reportergridstackpanel')._removeAllWidget();
								}
								else
								{
									for (var i=0;i<selectionArrayLen;i++)
									{
										var row = selectionArray[i];
										var panelId = row.data.panelId;
										var renderto_id = panelId;
										needWidgetCloseAlert = false;
										Ext.getCmp(panelId).panelClose = true;
										Ext.getCmp('reportergridstackpanel')._removeWidget(panelId);
										grid.getStore().remove(row);
									}
								}
							}
						}
					}
				});
			}
			else
			{
				me.getMessageBox('eG Custom Reports','Please select a row to delete');
			}
		});
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectContainerId,isSetLabel)
	{
		if(parentJsonProperty.hasOwnProperty('combo'))
		{
			var component = Ext.ComponentManager.get(comboId);
			if(component!=undefined && component!='undefined')
			{
				if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
				{
					var rawData = parentJsonProperty.combo[comboProperty];
					
					if(comboId.indexOf('er_measure')>-1)
					{
						app.relevantCompTypeByTest=parentJsonProperty.combo['relevantCompTypeByTestCombo']; // for Revalent Component
					}
					component.getStore().loadRawData(rawData);

					 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
					 else
						component.setValue(rawData[0].valueField);

					if(comboId.indexOf('er_test')>-1)
					{
						var component_type = Ext.ComponentManager.get('er_compType');
					}
					if (isSetLabel)
					{
						 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
						{
							if(!isMultiSelect)
								component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
							else
								Ext.ComponentManager.get(multiSelectContainerId).setFieldLabel(comboLabelProperty);
						}
					}
					if(!isMultiSelect)
					{
						if(component.isHidden())
						component.show();
					}
					else
					{
						var m=Ext.ComponentManager.get(multiSelectContainerId);
						if(m.isHidden())
						m.show();
					}
				}
				else
				{
					if(!isMultiSelect)
					{
						if(!component.isHidden())
						component.hide();
					}
					else
					{
						var m=Ext.ComponentManager.get(multiSelectContainerId);
						if(!m.isHidden())
						m.hide();
					}
				}
			}
		}
		else
		{
			this.getMessageBox('eG Custom Reports','No record found to load combo ...');
		}
	},
	getPreView:function()
	{
		var previewTitle = 'Preview Title';
		if(Ext.getCmp('WidgetNametextField')!=undefined)
		{
			previewTitle = Ext.getCmp('WidgetNametextField').getValue();
		}
		this.getPreViewData(previewTitle);
	},
	getPreViewData:function(previewTitle,selectedGraphPalette)
	{
		if(selectedGraphPalette==null || selectedGraphPalette=='null'||selectedGraphPalette==undefined||selectedGraphPalette=='undefined')
			selectedGraphPalette=Ext.getCmp('previewColor').selectedGraphPalette;
		var me = this;
		var statusObj = this.validateTabPaneInfo()
		if (!statusObj)
		{
			return;
		}
		var widgetConfig = this.getReportertemplatetabpane().widgetConfig;
		var iniParams=app.infoParams;
		
		var widgetList=new Array();
		var item = 0;
		var ddRawConfigString=new Array();
		var chartConfigArray=widgetConfig.chartConfigArray;
		//console.log('chartConfigArray	',chartConfigArray);
		if (!Ext.isEmpty(chartConfigArray))
		{
			var ddGrpByMes=new Object();
			for (var key in chartConfigArray)
			{
				var record=chartConfigArray[key];

				var ddconfigStrByMes=new Array();
				var gridTestName=record.testValue;
				var ddconfigString=record.ddconfigString;
				if(gridTestName.indexOf("_DDD")>-1 && (ddconfigString!=''))
				{
					if(ddconfigString.indexOf('*')!=-1)
					{
						var ddconfigStringAry=ddconfigString.split('*');
						for(var ii=0;ii<ddconfigStringAry.length;ii++)
						{
							ddconfigStrByMes.push(ddconfigStringAry[ii].replace('comptypeid',''));
							iniParams+='&widgetInfo'+item+'$'+ddconfigStringAry[ii];
						}
					}
					else
					{
						ddconfigStrByMes.push(record.ddconfigString.replace('comptypeid',''));
						iniParams+='&widgetInfo'+item+'$'+record.ddconfigString;
					}
					ddGrpByMes[record.displayName]=ddconfigStrByMes;
				}


				if (record['function']!='Raw' || record['function']!='None')
				{
					//iniParams+='&widgetInfo'+item+'~'+record.configString;
					iniParams+='&widgetInfo'+item+'$'+record.configString;
				}
				else
					ddRawConfigString.push(record.configString);
			}

			var widgetInfo=new Object();
			widgetInfo.headerDescription=previewTitle;

			if(widgetConfig.descDisplayName!=undefined && widgetConfig.descDisplayName!='undefined')
				widgetInfo.descDisplayName=widgetConfig.descDisplayName;
											
			if(widgetConfig.enableMetrics!=undefined && widgetConfig.enableMetrics!='undefined')
			{
				widgetInfo.enableMetrics=widgetConfig.enableMetrics;
			}
			if(widgetConfig.enableComp!=undefined && widgetConfig.enableComp!='undefined')
			{
				widgetInfo.enableComp=widgetConfig.enableComp;
			}
			if(widgetConfig.enableDesc!=undefined && widgetConfig.enableDesc!='undefined')
			{
				widgetInfo.enableDesc=widgetConfig.enableDesc;
			}
			if(widgetConfig.enableDispName!=undefined && widgetConfig.enableDispName!='undefined')
			{
				widgetInfo.enableDispName=widgetConfig.enableDispName;
			}
			widgetInfo.yAxisLabel = widgetConfig.yAxisLabel;
			if(selectedGraphPalette==null||selectedGraphPalette=='null')
				widgetInfo.selectedPaletteColor='';
			else
				widgetInfo.selectedPaletteColor=selectedGraphPalette;
						
			if(widgetConfig.chartType=="bar")
			{
				widgetInfo.barAlignment="Horizontal";
			}
			else if(widgetConfig.chartType=="vertbar")
			{
				widgetInfo.barAlignment="Vertical";
			}
			widgetInfo.chartType=widgetConfig.chartType;
			widgetInfo.x=1;
			widgetInfo.y=1;
			widgetInfo.size_x=6;
			widgetInfo.size_y=3;
			widgetInfo.width=Ext.util.Format.round((1000/12)*6,0);
			widgetInfo.height=parseInt(widget_baseHeight)*3;
			widgetInfo.groupBy=widgetConfig.groupBy;
			widgetInfo.ddGroupBy=widgetConfig.ddGroupBy;
			widgetInfo.enableTopN=widgetConfig.enableTopN;
			widgetInfo.showMultipleCharts=widgetConfig.showMultipleCharts;
			widgetInfo.er_stackedArea=widgetConfig.er_stackedArea;
			widgetInfo.er_showLegendTable=widgetConfig.er_showLegendTable;
			widgetInfo.multiColor=widgetConfig.multiColor;


			if (widgetConfig.enableTopN=='yes')
			{
				//widgetInfo.basedOnTestMeasure=Ext.encode(widgetConfig.basedOnTestMeasure);
				widgetInfo.basedOnTestMeasure=widgetConfig.basedOnTestMeasure;
				widgetInfo.top=widgetConfig.top;
			}
			if(curChartType=="table")
			{
				widgetInfo.sortByValue=Ext.encode(widgetConfig.sortByValue)
			}

			widgetInfo.ddGroupByMeasure=ddGrpByMes;
			var wid='widgetInfo'+item;
			widgetList.push(wid);
			iniParams+='&'+wid+'='+Ext.encode(widgetInfo);
			iniParams+='&'+wid+'_ddRaw='+Ext.encode(ddRawConfigString);
		}
		else
		{
			this.getMessageBox('eG Custom Reports','Please configure all widgets');
			return;
		}
						
		iniParams+='&widgetList='+Ext.encode(widgetList);		
		iniParams+='&isDescFilter=no';
		
		iniParams+='&isCustomLayout=yes';
		iniParams+='&method=perview';
		var multiMeasureSupport='no';
		if(!Ext.isEmpty(Ext.getCmp("multiMeasure")))
		{
			if (Ext.getCmp('multiMeasure').getValue()==true)
			{
				multiMeasureSupport='yes';
			}
		}
		else
		{
			multiMeasureSupport='yes';
		}
		iniParams+='&multiMeasureSupport='+multiMeasureSupport;
		iniParams+='&isEditTemplate='+isEditTemplate;
		//console.log('iniParams>>>>>>>>>> ',iniParams)
		
	///////////////
		var url='/final/reporter/ReporterTemplatePerview.jsp';
		if(iniParams!=undefined && iniParams!='undefined')
		{
			Ext.Ajax.request({
				url:url,
				params:iniParams,
				scope:this,
				//async:false,
				success : function(response)
				{
					var perviewPramJson = Ext.decode(response.responseText);
					if(!Ext.isEmpty(perviewPramJson))
						me.generatePreviewData(perviewPramJson);
				},
				faliure:function(err){
					Ext.MessageBox.alert('Error occured in ReporterTemplatePerview.jsp page');
				}
			});
		}
	},
	generatePreviewData:function(perviewPramJson)
	{
		var me = this;
		var comboInfo  = perviewPramJson.combo;
		var selectedFields  = perviewPramJson.selectedFields;
		var params='method=submit';
		var url='/final/reporter/ReporterTemplatePerview.jsp';
		params+='&er_option=Component'; // default
		params+='&widget=widgetInfo0';
		var obj=Ext.getCmp('er_site');
		var componentTypeCombo = comboInfo.componentTypeCombo;
		var componentTypeCombo = comboInfo.componentTypeCombo;
		if(componentTypeCombo!=undefined && componentTypeCombo.length>0)
		{
			var needCompType = true;
			for(var compType in componentTypeCombo)
			{
				if(componentTypeCombo[compType].valueField=='All')
				{
					params+='&er_compType=All';
					needCompType = false;
					break;
				}
			}
			if(needCompType)
			{
				params+='&er_compType='+selectedFields.selectedComponentTypeCombo;
			}
				
		}
		else
		{
			return;
		}
		params+='&showLegendsEnable=true';
		params+='&er_component=All';

		//params+='&er_test=null';
		
		//params+='&er_info='+Ext.getCmp(appConstants.erInfo).getValue();

		params+='&er_timeline='+selectedFields.selectedTimelineCombo;
		params+='&er_stdate='+selectedFields.selectedStartDateVal;
		params+='&startdate='+selectedFields.selectedStartDateVal;


		params+='&er_enddate='+selectedFields.selectedEndDateVal;
		params+='&enddate='+selectedFields.selectedEndDateVal;

		params+='&er_sthr='+selectedFields.selectedStartHour;
		params+='&starthr='+selectedFields.selectedStartHour;

		params+='&er_endhr='+selectedFields.selectedEndHour;
		params+='&endhr='+selectedFields.selectedEndHour;

		params+="&startmin="+selectedFields.selectedStartMin+"&endmin="+selectedFields.selectedEndMin+"&er_secs=00";

		params+="&er_stmin="+selectedFields.selectedStartMin+"&er_endmin="+selectedFields.selectedEndMin;

		params+='&timefrom='+selectedFields.selectedTimefrom;
		params+='&timeto='+selectedFields.selectedTimeto;
		params+='&minfrom='+selectedFields.selectedMinfrom;
		params+='&minto='+selectedFields.selectedMinto;
		params+='&er_reportgenration=foreground';
		params+='&er_excwe=No';// exclude week ends
		//params+='&er_timeInterval=null';
		/* if(isEnableChartTypeCombo)
			params+='&er_chartType='+Ext.getCmp('er_chartType').getValue(); */
		params+='&pct_idle=';
		//params+='&sorted_col=null';
		//params+='&aggregate_server=null';
		//params+='&infoBy=null';//for load evaluator report
		params+='&er_showBy='+selectedFields.selectedShowByCombo;
		//params+='&timeline_showBy=null';//...
		//params+='&bar_showBy=null';//...
		params+='&dynamicRangesInfo='+this.getDynamicRangesInfo(comboInfo);
		params+='&dynamicColorInfo=';

		if (app.isCustomLayout=='yes')
		{
			//params+='&er_top=null';
		}
		else
		{
			params+='&chartInfo=';
			params+='&er_top='+selectedFields.selectedTopCombo;
		}
		var recordInfo = new Object();
		recordInfo.templateName=mainWindowTitle; 
		params+='&recordInfo='+Ext.encode(recordInfo)+'&templateName='+mainWindowTitle;
		params+='&user_dispName='+mainWindowTitle;
		//params+='&fromReportBuilder=null';
		params+='&isCustomLayout='+app.isCustomLayout;
		if(!Ext.isEmpty(perviewPramJson))
		{
			if(!Ext.isEmpty(perviewPramJson.hiddenFields))
			{
				for(var key in perviewPramJson.hiddenFields)
				{
					var val=perviewPramJson.hiddenFields[key];
					params+='&'+key+"="+val;
				}
			}
		}
		Ext.Ajax.request({
			url:url,
			params:params,
			scope:this,
			//async:false,
			success : function(response)
			{
				var perviewGraphJson = Ext.decode(response.responseText);
				if(!Ext.isEmpty(perviewGraphJson))
					me.showPreViewGraph(perviewGraphJson);
			},
			faliure:function(err){
				Ext.MessageBox.alert('Error occured in ReporterTemplatePerview.jsp page');
			}
		});
	},
	showPreViewGraph:function(perviewGraphJson)
	{		
		var widgetCollection= perviewGraphJson.data.widgetCollection;
		if (!Ext.isEmpty(widgetCollection))
		{
			for (var widget in widgetCollection)
			{
				var widgetObject=widgetCollection[widget];
				var testCollection=widgetObject.testCollection;
				var haveMeasuee = false;
				var otherInfo='';
				var chartType = widgetObject.chartType;
				var widgetIdInfo = widgetObject.widgetId+'_detail';
				var chartCollection;
				for (var test in testCollection)
				{
					var testObject=testCollection[test];
					var measureCollection=testObject.measureCollection;
					if(measureCollection != undefined && measureCollection.length > 0)
					{
						for (var measure in measureCollection)
						{
							var measureObject=measureCollection[measure];
							if(measureObject.hasOwnProperty('timelineChartCollection'))
							{
								chartType='timeline';
								chartCollection = measureObject.timelineChartCollection;
							}
							else if(measureObject.hasOwnProperty('heatMapChartCollection'))
							{
								chartType='heatMap';
								chartCollection = measureObject.heatMapChartCollection;
							}
							else if(measureObject.hasOwnProperty('healthWidgetCollection'))
							{
								chartType='healthWidget';
								chartCollection = measureObject.healthWidgetCollection;
							}
							else if (measureObject.hasOwnProperty('barChartCollection'))
							{
								chartType='bar';
								chartCollection = measureObject.barChartCollection;
							}
							else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
							{
								chartType='stackedbar';
								chartCollection = measureObject.stackedBarChartCollection;
							}
							else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
							{
								chartType='distpie';
								chartCollection = measureObject.distributedPieChartCollection;
							}
							else if (measureObject.hasOwnProperty('distributionChartCollection'))
							{
								chartType='pie';
								chartCollection = measureObject.distributionChartCollection;
							}
							else if (measureObject.hasOwnProperty('gridCollection'))
							{
								chartType='table';
								chartCollection = measureObject.gridCollection;
							}
							else if (measureObject.hasOwnProperty('topnCollection'))
							{
								chartType='topn';
								chartCollection = measureObject.topnCollection;
							}
							else if (measureObject.hasOwnProperty('digitalCollection'))
							{
								chartType='digital';
								chartCollection = measureObject.digitalCollection;
							}
							if(chartCollection != undefined && chartCollection.length > 0)
							{
								chartCollectionVal = chartCollection[0];
								if(chartType=='digital')
									chartCollectionVal = chartCollection;
								this.loadLiveData(chartType);
							}
						}
					}
					else
					{
						// No preview Message
						chartCollectionVal = '';
						this.loadLiveData(curChartType);
					}
				}
			}
		}
		else
		{
			// No preview Message
			chartCollectionVal = '';
			this.loadLiveData(curChartType);
		}
	},
	getDynamicRangesInfo:function(comboInfo)
	{
		var rangeSettingArray = new Array();
		if(comboInfo.dynamicRangeField!=undefined)
		{
			for(var i=0;i<comboInfo.dynamicRangeField.length;i++)
			{
				var addedStr=comboInfo.dynamicRangeField[i]+'~'
				addedStr+=comboInfo.dynamicRangeComboValue[i]+'*';
				if(comboInfo.dynamicRangeComboValue[i]=='None')
					addedStr+='0';
				else
					addedStr+=comboInfo.dynamicRangeFieldValue[i];
				rangeSettingArray.push(addedStr);
			}
		}
			return rangeSettingArray;
	},
	getMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	 },
	getCallbackMessageBox:function(title,msg,flag)
	{
		var me = this;
		Ext.Msg.show({
			title:title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			scope:this,
			icon: Ext.MessageBox.WARNING,
			fn: function(val)
			{
				if (flag=='setini')
				{
					Ext.getCmp('reportbuildertop').show();
					if(app.isCustomLayout=='no')
					{
						me.getReportdataconfigwindow().doClose();
					}
					else
					{
						Ext.getCmp('reportergridstackpanel')._removeAllWidget();
						Ext.getCmp('gridsterstackpanel').hide();
					}
					me.onRenderReportBuilderGrid();//to load ini entries in report builder grid (Shows all templates details)
					me.viweHomePage();
				}
				else if (flag=='showConfigWindow'&& val=='ok')
				{
					if (app.isCustomLayout=='yes')
					{
						Ext.getCmp('addMoreWidget').fireEvent('click');
					}
					else
					{
						
					}
				}
				else if (flag=='showConfigTab' && val=='ok')
				{
				
				}
			}
		});
	},
	updateChartCountCircle:function(type,isAdd)
	{
		var btnInfo = Ext.getCmp(type);
		var divtag = document.getElementById("chartCountId"+type);
		if(btnInfo!=undefined && divtag!=undefined)
		{
			if(btnInfo.chartCount!='' && btnInfo.chartCount!='0')
			{
				var chartCountVal = parseInt(btnInfo.chartCount);
				if(isAdd)
					chartCountVal=chartCountVal+1;
				else
					chartCountVal=chartCountVal-1;
				if(chartCountVal==0)
				{
					divtag.style.display = 'none';
					divtag.innerHTML=''; 
				}
				else
				{
					divtag.style.display = 'block';
					divtag.innerHTML=chartCountVal; 
				}
				btnInfo.chartCount = chartCountVal;
			}
			else
			{
				divtag.style.display = 'block';
				divtag.innerHTML='1';
				btnInfo.chartCount = '1';
			}
			var gridstackdata = Ext.getCmp('reportergridstackpanel')._serialization();
			var gridster_items = GridStackUI.Utils.sort(gridstackdata);
			document.getElementById('widgetCountHighlightId').innerHTML=gridster_items.length;
		}
	},
	getGrayChartIconOrDefaultTitle:function(type,returnType)
	{
		var chartIcon='';
		var chartIconColor='';
		var title='';
				
		switch (type)
		{
			case 'bar':
				title='Horizontal Bar';
				chartIcon='widgetIconGray48_HorizontalBarChart';
				chartIconColor='widgetIcon48_HorizontalBarChart';
				break;
			case 'vertbar':
				title='Vertical Bar';
				chartIcon='widgetIconGray48_VerticalBarChart';
				chartIconColor='widgetIcon48_VerticalBarChart';
				break;
			case 'area':
				title='Area Chart';
				chartIcon='widgetIconGray48_AreaChart';
				chartIconColor='widgetIcon48_AreaChart';
				break;
			case 'distribution':
				title='Pie Chart';
				chartIcon='widgetIconGray48_PieChart';
				chartIconColor='widgetIcon48_PieChart';
				break;
			case 'timeline':
				title='Timeline';
				chartIcon='widgetIconGray48_TimelineChart';
				chartIconColor='widgetIcon48_TimelineChart';
				break;
			case 'distributedPie':
				title='Distributed Pie';
				chartIcon='widgetIconGray48_DistributedPieChart';
				chartIconColor='widgetIcon48_DistributedPieChart';
				break;
			case 'stackedbar':
				title='Horizontal Stacked Bar';
				chartIcon='widgetIcon48_HorizontalStackedBarChart';
				chartIconColor='widgetIcon48_StackedBarChart';
				break;
			case 'table':
				title='Grid';
				chartIcon='widgetIconGray48_Table';
				chartIconColor='widgetIcon48_Table';
				break;
			case 'topn':
				title='Top N';
				chartIcon='widgetIconGray48_TopNChart';
				chartIconColor='widgetIcon48_TopNChart';
				break;
			case 'digital':
				title='Digital Chart';
				chartIcon='widgetIconGray48_DigitalChart';
				chartIconColor='widgetIcon48_DigitalChart';
				break;
			case 'multiDigi':
				title='Multi Digital';
				chartIcon='widgetIconGray48_MultiDigitalChart';
				chartIconColor='widgetIcon48_MultiDigitalChart';
				break;
			case 'heatMap':
				title='HeatMap';
				chartIcon='widgetIconGray48_Table';
				chartIconColor='widgetIcon48_Table';
				break;
			case 'healthWidget':
				title='healthWidget';
				chartIcon='widget_kpi';
				chartIconColor='widgetIcon48_Table';
				break;
			case 'verticalstackedbar':
				title='Vertical Stacked Bar';
				chartIcon='widgetIconGray48_StackedBarChart';
				chartIconColor='widgetIcon48_StackedBarChart';
		}
		if(returnType=='title')
			return title;
		else if(returnType=='gray')
			return chartIcon;
		else if(returnType=='color')
			return chartIconColor;
	},
	setPalette : function(c)
	{
		if (!Ext.isEmpty(Ext.getCmp('previewColor')))
		{
			Ext.getCmp('previewColor').selectedGraphPalette=c.imageId;
			this.getGraphpalettewindow().hide();
			this.getColorPattern();
		}
		else
		{
			//var blockId=this.getGraphpalettewindow().blockId;
			var configPanl=Ext.getCmp(c.blockId);
			configPanl.selectedGraphPalette=c.imageId;
			this.getGraphpalettewindow().hide();
		}
	},
	showPreviewPaletteWindow : function(fWin)
	{
		var get_X = Ext.get(fWin.getEl().id).getX()-100;
		//var get_X = Ext.get(fWin.getEl().id).getX()-166
		var get_Y = Ext.get(fWin.getEl().id).getY()+20;

		//var graphpalettewindow=this.getGraphpalettewindow();
		//if (Ext.isEmpty(graphpalettewindow))
		//{
			//var graphpalettewindow = Ext.create('ReporterTemplate.view.GraphPaletteWindow');
			var graphpalettewindow = Ext.widget('graphpalettewindow');
		//}
		graphpalettewindow.blockId=fWin.blockId;
		graphpalettewindow.selectedGraphPalette=fWin.selectedGraphPalette;
		graphpalettewindow.showAt([get_X,get_Y]);
		graphpalettewindow=null;
		delete graphpalettewindow;
	},
	showPaletteWindow : function(fWin)
	{
		var get_X = Ext.get(fWin.getEl().id).getX()-100;
		//var get_X = Ext.get(fWin.getEl().id).getX()-166
		var get_Y = Ext.get(fWin.getEl().id).getY()+20;

		//var graphpalettewindow=this.getGraphpalettewindow();
		//if (Ext.isEmpty(graphpalettewindow))
		//{
			//var graphpalettewindow = Ext.create('ReporterTemplate.view.GraphPaletteWindow');
			var graphpalettewindow = Ext.widget('graphpalettewindow');
		//}
		graphpalettewindow.blockId=fWin.blockId;
		graphpalettewindow.selectedGraphPalette=fWin.selectedGraphPalette;
		graphpalettewindow.showAt([get_X,get_Y]);
		graphpalettewindow=null;
		delete graphpalettewindow;
	}
});