Ext.define('ReporterTemplate.view.ReportDataConfiguration',{
	extend:'Ext.form.Panel',
 	alias:'widget.reportdataconfiguration',
 	id:'reportdataconfigurationid',
	margin:'0 10 0 14',
	border:false,
	frame:false,
	width:990,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	buttonAlign :'center',
	items:[
			{
				xtype:'fieldcontainer',
				flex:1,
				margin:'10 5 0 12',
				layout:{
					type:'column',
					align:'stretch',
				},
				defaults:{
					labelAlign:'left',
					labelSeparator:''
				},
				items:[
				{
					xtype: 'radiogroup',
					columns:2,
					columnWidth:0.31,
					margin:'2 0 4 10',
					labelSeparator:'',
					id:'measureTypeId',
					width:300,
					labelWidth:80,
					labelStyle:{'white-space':'nowrap'},
					fieldLabel:'Widget Source',
					hidden:(curChartType!=undefined && curChartType=='healthWidget')?true:false,
					defaults:{
						cls:'radiobt',
						noWrap:true,
						padding:0,
						margin:'-2 5 0 0',
						width:70,
						labelStyle:{'white-space':'nowrap'},
					},
					items: [
						{ boxLabel: 'Measure', name: 'measureType', inputValue: 'normalMeasure',id: 'normalMeasure'},
						{ boxLabel: 'Detailed Diagnosis', name: 'measureType', inputValue: 'DDMeasure',id: 'DDMeasure',width:140}
					]
				},
				{
					xtype:'textfield',
					cls: 'textbox',
					fieldLabel:'WIDGET NAME',
					id:'WidgetNametextField',
					columnWidth:0.305,
					labelWidth:86,
					//value:'vengat',
					margin:'2 0 4 10',
				},
				{
					xtype:'checkbox',
					cls: 'checkbt',
					boxLabel: 'Stacked',
					inputValue: 'true',
					margin:'2 0 4 10',
					id:'er_stackedArea',
					name:'er_stackedArea',
					columnWidth:0.085,
					checked:true,
					hidden:true,
				},
				{
					xtype:'checkbox',
					cls: 'checkbt',
					boxLabel: 'Show Legend Along with MIN/MAX/AVG',
					//boxLabel: 'Show Legend ',
					inputValue: 'true',
					margin:'2 0 4 10',
					id:'er_showLegendTable',
					name:'er_showLegendTable',
					columnWidth:0.255,
					checked:true,
					hidden:true,
				},
				{
					xtype:'checkbox',
					cls: 'checkbt',
					boxLabel: 'MultiColor',
					inputValue: 'true',
					margin:'2 0 4 10',
					id:'multiColor',
					name:'multiColor',
					columnWidth:0.305,
					checked:true,
					hidden:true,
				}
				]
			},
			{
				xtype:'fieldcontainer',
				flex:1,
				margin:'5 10 10 10',
				id:'tabpaneContainerId',
				layout:{
					type:'column',
					align:'stretch',
				},
				defaults:{
					labelAlign:'top',
					labelSeparator:''
				},
				items:[
				{
					xtype:'reportertemplatetabpane',
					columnWidth:.67
				},
				{
					xtype:'panel',
					margin:'0 0 0 10',
					height:330,
					ui:'newGraphPanel',
					header:
					{
						style:
						{
							'padding':'0 0 0 5 !important',
						}
					},
					id:'previewGraphPanelId',
					selectedGraphPalette:'',
					columnWidth:.33,
					tools:[
					{
						xtype:'toolbar',
						hidden:false,
						border:false,
						items:[
						{
							xtype : 'button',
							cls:'colorTool ',
							selectedGraphPalette:null,
							id:'previewColor',
							height:16,
							width:16,
							margin:'3 5 0 0',
							style:{'border':'0px'},
							tooltip : 'Change color palette',
							blockId:'',
							handler : function()
							{
								app.appObj.getController(app.appController).showPreviewPaletteWindow(this);
							}
						}]
					}],
					dockedItems:[
					{
						xtype:'toolbar',
						dock:'bottom',
						//cls:'reporterTemplateWidgetToolbar',
						//height:60,
						layout:'fit',
						items:[
						{
							xtype:'container',
							buttonAlign:'center',
							layout:
							{
								type:'hbox',
								align:'stretch',
								pack:'center'
							},
							items:[
							{
								xtype:'button',
								text:'Preview',
								ui:'newButtonMediumGray',
								iconCls: 'iconPreview',
								id: 'previewId',
								scale:'medium',
								iconAlign:'left',
								name:'previewId',
								margin:'10 5 10 5',
							},
							{
								xtype:'button',
								text:'List of widgets',
								iconCls:'iconWidgetList',
								ui:'newButtonMediumGray',
								id: 'widgetListId',
								scale:'medium',
								iconAlign:'left',
								name:'widgetListId',
								margin:'10 0 10 5',
							},{
								xtype:'container',
								padding:0,
								margin:0,
								id:'widgetCountHighlight',
								html:'<div id="widgetCountHighlightId" class="widgetCountHighlightDiv">0</div>',
							}]
						}]
					}]
				}],
			}
		],
	});