Ext.define('TemplateReportApp.view.KpiZoneResult',{
	extend:'Ext.container.Container',
	alias:'widget.kpizoneresult',
	layout:'column',
	columnWidth:1.0,
	id:'kpizoneresult_id',
	margin: '10 0 2 0',
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var me = this;
		try
		{
			if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
			{
				var datas = resultJson.RESULTS;
				var gridCol = datas.gridCol;
				var gridColCount = datas.gridColCount;
				var gridDataList = datas.gridDataList;
				var widthVal = (100-30)/(gridColCount-2);
				var content = '<table border="0" id="tierWiseTable" class="tableBorderHtml" align="center" width="100%" height="100%">';
				content +='<thead>';
				content +='<tr>';
				for(var key in gridCol)
				{
					if(key=='VM_NAME'||key=='cType')
					{
						content += '<th width="15%" align="center" class="theadBorderHtml" style="padding-left: 15px">'+gridCol[key]+'</th>';
					}
					else
					{
						//content += '<th width="'+widthVal+'%" align="center" class="theadBorderHtml" style="padding-left: 15px;text-align:center">'+gridCol[key]+'</th>';
					}
				}
				content += '<th colspan="'+(gridColCount-2)+'" align="center" class="theadBorderHtml" style="padding-left: 15px;text-align:center">KPI Layers</th>';
				content +='</tr>';
				content +='</thead>';
				content +='<tbody>';
				var allCompType = false;
				for(var ind in gridDataList)
				{
					var gridData = gridDataList[ind];
					content +='<tr>';
					var firstIndexData = gridData[0];
					var ii=2;
					var innerWidth = 100/(gridData.length-2);
					if(firstIndexData.indexOf('~')>-1)
					{
						allCompType = true;
						var firstIndexDataAry = firstIndexData.split('~');
						firstIndexData = firstIndexDataAry[0];
						var rowspan = firstIndexDataAry[1];
						var URLs = '';
						if(firstIndexDataAry.length>2)
						{
							URLs = firstIndexDataAry[2];
							content +='<td rowspan="'+rowspan+'" align="left" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+URLs+'\')">'+firstIndexData+'</a></td>';
						}
						else
						{
							content +='<td rowspan="'+rowspan+'" align="left" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml">'+firstIndexData+'</td>';
						}
					}
					if(allCompType)
					{
						var secondIndex = gridData[1];
						var secondIndexAry = secondIndex.split('~');
						secondIndex = secondIndexAry[0];	
						console.log('secondIndexAry  ',secondIndexAry);
						if(secondIndexAry.length>1)
						{
							var URLs = secondIndexAry[1];
							content +='<td align="left" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+URLs+'\')">'+secondIndex+'</a></td>';
						}
						else
						{
							content +='<td align="left" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml">'+secondIndex+'</td>';
						}
						content +='<td class="tdBorderHtml" colspan="'+(gridColCount-2)+'">';
					}
					else
					{
						ii=1;
						innerWidth = 100/(gridData.length-1);
						content +='<td align="left" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml">'+firstIndexData+'</td>';
						content +='<td class="tdBorderHtml" colspan="'+(gridColCount-1)+'">';
					}
					content += '<table border="0" width="100%" height="100%" style="padding:0.2px">';
					content += '<tr>';
					for (var i=ii;i<gridData.length;i++ )
					{
						var layerDataMp = gridData[i];
						if(allCompType)
						{
							content += '<td width="'+innerWidth+'%" class="kpiTableTdBorderWithRowspan" style="background-color:'+layerDataMp.bgcolor+';color:#000000;text-align:center;valign:middle;" align="center">';
						}
						else
						{
							content += '<td id="'+layerDataMp.URL+'" width="'+innerWidth+'%" class="kpiTableTdBorderWithRowspan handSymbol" style="background-color:'+layerDataMp.bgcolor+';color:#000000;text-align:center;valign:middle;" align="center">';
						}
						if(layerDataMp.bgcolor=="#dd3939")
						{
							content += '<div style="padding: 6px;line-height: 1em;color:#ffffff" class="">';
							content += '<span class="font_bold11">',
							content += layerDataMp.health;
							content += '</span>',
							content += '<br/>';
							content += layerDataMp.displayName;
							content += '</div>';
						}
						else
						{
							content += '<div style="padding: 6px;" class="">';
							content += '<span class="font_bold11">',
							content += layerDataMp.health;
							content += '</span>',
							content += '<br/>';
							content += layerDataMp.displayName;
							content += '</div>';
						}
						content += '</td>';
					}
					content +='</tr>';
					content +='</table>';
					content +='</td>';
					content +='</tr>';
				}
				content +='</tbody>';
				content +='</table>';
				this.add({
					xtype:'panel',
					id: 'tableCont',
					columnWidth:1.0,
					ui:'newGraphPanel',
					bodyPadding:'0 10 0 10',
					title:'Zone Utilization',
					id: 'cont',
					layout:'hbox',
					scroll:true,
					items:
					[{
						xtype:'container',
						html:content,
						margin:'0 0 10 0',
						flex:1,
						listeners: 
						{
							'afterRender': function()
							{
								if (Ext.get('tierWiseTable')!=null)
								{
									me.getTROddEvenBG('tierWiseTable');
								}
								var el = Ext.get('cont');
								el.on('click', function(event, target, options)
								{
									if(target.id!=undefined && target.id!='undefined' && target.id.length>0)
									{
										me.loadGraph(target.id);
									}
								},
								this,
								{
									delegate: 'td'
								});
							}
						 }
					}],
					tools:[
					{
						xtype:'toolbar',
						dock: 'right',
						id:'statusTool',
						items: [{
							 xtype:'label',
							 id:'lblTool',
							 html:'<table><tbody><tr><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#dd3939"></div></td><td class="newFont_bold13" style="padding-right: 20px;">Critical</td><td></td><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#fa9d1c"></div></td><td class="newFont_bold13" style="padding-right: 20px;">Major</td><td></td><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#ccc100"></div></td><td class="newFont_bold13" style="padding-right: 20px;">Minor</td><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#a2be68"></div></td><td class="newFont_bold13" style="padding-right: 20px;">Good</td></tr></tbody></table>'
						}]
					}]
				});
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	
	loadGraph:function(URL)
	{
		
		var title = URL.substring(URL.indexOf('&title=')+7);
		if(title.indexOf('&')>-1)
		{
			title = title.substring(0,title.indexOf('&'));
		}
		Ext.create('Ext.window.Window',{
			title:appConstants.erUtils.specialCharDecode(title),
			width:800,
			height:450,
			ui:'newPopupWindow withBorderShadow newplainHeader_border',
			padding:'0 10 5 10',
			padding:0,
			header:{
				style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
			},
			autoScroll:false,
			scroll:false,
			frame:true,
			modal: true,
			ghost: false,
			frame:false,
			border:true,
			closable:true,
			draggable:false,
			resizable:false,
			closeAction: 'destroy',
			listeners: {
				show: function (win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							var el = Ext.fly(dom[y]);
						}
					el.addCls('windowModalNoBg');
					}
				},
				hide: function (win) {
					var dom = Ext.dom.Query.select('.x-mask');
					if (this.modal) {
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModalNoBg');
					}
				},
				afterrender: function () {
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			doClose: function() {
				var me = this;
				if (me.hidden) {
					me.fireEvent('close', me);
					if (me.closeAction == 'destroy') {
						this.destroy();
					}
				} else {
					me.hide(me.animateTarget, me.doClose, me);
				}
			},
			items:[
			{
				xtype:'container',
				id:'predict_GraphPanel',
				height:357,
				html:'<div id="predict" style="height:357px"></div>',
				listeners:
				{
					boxready:function()
					{
						var params = URL.substring(URL.indexOf('?')+1);
						URL = URL.substring(0,URL.indexOf('?'));
						appConstants.initLdgMask.show();
						Ext.Ajax.request(
						{
							url :URL,
							params :params,
							method :'POST',
							scope:this,
							async :true,
							success: function(response)
							{
								var grapMp = Ext.decode(response.responseText);
								var lineChart = {};
								lineChart = jQuery.extend(true, {}, getHighChartsInstance('predict',"230","200"), lineChart);
								lineChart.setData(grapMp,appConstants.currentDateFormat,'');
								lineChart.drawChart();
								appConstants.initLdgMask.hide();
							}
						});
					}
				}
			},
			{
				xtype:'container',
				id:'predict_legendPanel',
				height:53,
				style: 
				{
					'overflow': 'hidden',
					'padding-right':'10px'
				}
			}]
		}).show();
	},
	getTROddEvenBG:function(tableId)
	{
		$(document).ready(function(){
			$("#"+tableId+" tr:even").addClass('tableTrBgEven');
			$("#"+tableId+" tr:odd").addClass('tableTrBgOdd');
			$(".tableTrBgEven_myalternate:odd").addClass("tableTrBgEvenReport");
			$(".tableTrBgEven_myalternate:even").addClass("tableTrBgAddReport");
		});
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'panel',
			columnWidth:1.0,
			height:height,
			margin:'0 2 0 0',
			ui:"newGraphPanel",
			flex:1,
			html:'<div class="egFlexCenterByColumnWise" style="padding-bottom:15px;height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'</div> </div>'
		}
	}
});


