Ext.define('TemplateReportApp.view.LongRunningQueries',{
	extend:'Ext.container.Container',
	alias:'widget.longrunningqueries',
	columnWidth:1.0,
	id:'longRunningQueries_id',
	margin: '10 0 2 0',
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		try
		{
			var panelObj = resultJson.RESULTS.panelObj;
			var noData = resultJson.RESULTS.noData;
			var gridTitle = resultJson.RESULTS.gridTitle;
			if(panelObj != undefined)
			{
				var gridDataNew = panelObj.gridDataNew;
				var gridColumnAry = resultJson.RESULTS.gridColumnAry;
				if(gridDataNew != undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					for (var key in gridColumnAry)
					{
						var align = 'center';
						var width=135;
						var headerCol = gridColumnAry[key];
						if(key == 2)
						{
							width=180;
							headerCol = headerCol +  "<br>"+"(AVG)";
						}
						if(key == 0)
						{
							width = 500;
							align = 'left';
						}
						fieldsToStore.push(key);
						mainColArray.push({
							header: headerCol,
							sortable: true,
							resizable :true,
							align:align,
							width:width,
							dataIndex: key,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								var displayVal = value;
								var indexId = this.columns[col].headerId+'_'+row;
								if(col == 0 && displayVal.length > 300)
								{
									displayVal = displayVal.substring(0,300)+'...&nbsp;<span style="text-decoration-line:underline;cursor:pointer;" onclick="javascript:expandMore(\''+appConstants.erUtils.specialCharEncode(displayVal)+'\',\''+indexId+'\',\'more\',\'gridId\')">more</span>';
								}
								if(col == 1)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								if(col==0)
									value = '<div id="'+indexId+'" style="white-space: normal;word-wrap:break-word">'+displayVal+'</div>';
								else
									value = '<div style="white-space: normal;">'+displayVal+'</div>';
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : gridDataNew,
						},
						sorters: { property: fieldsToStore[3], direction : 'DESC' },
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:gridTitle,
						margin:'0 0 10 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel',
							border:true,
							id:'gridId',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
						}]
					});
				}
				var observationAry = resultJson.RESULTS.observationAry;
				if(observationAry != undefined)
				{
					var observationHtml = '';
					if (observationAry != undefined && observationAry.length > 0) 
					{
						observationHtml = '<div style="padding:11px 0px 10px 0px" class="font_bold15">' + ObservationTitle + '</div><div style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table  style="width: 100%;margin-bottom:10px; "><tbody>';
						for (var index = 0; index < observationAry.length; index ++) 
						{
							var observationAryObj = observationAry[index];
							observationHtml += '<tr style="padding-bottom:10px;">';
							if (observationAryObj != undefined) 
							{
								observationHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:6px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:1px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj + '</td></tr></table></td>';
							}
							observationHtml += '</tr>';
						}
						observationHtml += '</tbody></table></div></td>';
					}
					this.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						padding:'0 0 0 0',
						columnWidth:1,
						layout:'column',
						margin:'10 2 0 0',
						items:[
						{
							xtype: 'container',
							padding: '0 10 0 10',
							margin: '10 10 10 10',
							cls: 'jvmObservPanelBox',
							columnWidth: 1.0,
							items: [
							{
								xtype: 'container',
								ui: 'newGraphPanel noShadow ',
								margin: '0 0 0 0',
								bodyPadding: '10px 0px 0px 10px',
								layout: 'column',
								items: [
								{
									xtype: 'container',
									columnWidth: 1.0,
									html:observationHtml
								}]
							}
							]
						}]
					});
				}
			}
			else
			{
				if(noData)
				{
					this.add(this.getNoMeasure(400,'iconInformation','There were no long running queries detected'));
				}
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'panel',
			columnWidth:1.0,
			height:height,
			margin:'0 2 0 0',
			ui:"newGraphPanel",
			flex:1,
			html:'<div class="egFlexCenterByColumnWise" style="padding-bottom:15px;height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'</div> </div>'
		}
	}
});