Ext.define('UserGraphPopupApp.controller.Main', {
    extend: 'Ext.app.Controller',
    //views: ['Main'],
    refs: [{
            selector: 'timeline',
            ref: 'timeline'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{
            selector: 'usergraphpopupmainform',
            ref: 'usergraphpopupmainform'
        }
    ],
    init: function () {
        this.control({
            'main': {
                'afterrender': this.defaultLoad
            },
			'usergraphpopupmainform button[id="submit"]':
			{
					"click":this.formSubmit
			},
            'main newUtilities': {
                'afterrender': this.hideTools
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveFile
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #printTool > button': {
                'click': this.print
            },
            'newUtilities > #dataTool > button': {
                'click': this.showData
            },
			'newUtilities > #diagnosisTool > button': {
				'click': this.showDD
			}
        });
    },
	showDD: function () 
	{ 
		var w =window.open(ddPageDrillDownPageUrl,"DDWindow","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable");
		if (appConstants.er_RmDispName==undefined)
		{
			  w.document.title = 'SESSION REPORTS - USER'; 
		} 
		else 
		{
			  w.document.title = appConstants.er_RmDispName; 
		}
		w.focus(); 
	},
    showData: function () {
		var windowPrintFile = Ext.widget('popupprint',{
		header:false,
		frame:false,
	});
		windowPrintFile.show();
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var s_qryString = dataDrillDownPageUrl;
		s_qryString = s_qryString.replace("option=graph", "option=data");
		s_qryString = s_qryString.replace("option=print", "option=data");
		s_qryString+= '&er_RmDispName=SESSION REPORTS - USER';

		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
},
	 print: function () {
		var windowPrintFile = Ext.widget('popupprint');
		windowPrintFile.setTitle("SESSION REPORTS - USER");
		windowPrintFile.show();
		var measurePopupForm = this.getUsergraphpopupmainform().getForm();
		var s_qryString = printPageUrl+"&print=Yes";
		var printContentDiv = Ext.get('popupPrintContentDiv');
		printContentDiv.set({
			src: s_qryString
		});
	},
	sendMail: function () {
	drillDownParams = '&keyPrefix=enlarged&DrillDown=yes';
	var windowMail = Ext.widget('sendmail');
	windowMail.show();
},
	saveFile: function () {
	var measurePopupForm = this.getUsergraphpopupmainform().getForm();
	var qryString = pdfDrillDownPageUrl;
	var controller = qryString.substring(qryString.indexOf("servlet/com.eg."), qryString.indexOf("?"));
	qryString = qryString.replace(controller, "reporter/ErHtmlToSavePdf.jsp");
	var s_qryString = qryString + "&sample=yes&drillSes=yes&print=Yes&";
	s_qryString += '&er_RmDispName=Thin_client_user';
	var erUtils = Ext.widget('erutils');
	erUtils.savePDF(s_qryString);
},
	hideTools: function () {
	this.getNewUtilities().loadIcon(
		true, //save
	true, //print
	true, //mail
	true, //data
	false, //cvs
	false, // fav
	false, // schedule
	true, //daignosis
	false, //togglebutton
	false //close
	);

    Ext.getCmp("saveTool").setDisabled(false);
    Ext.getCmp("printTool").setDisabled(false);
    Ext.getCmp("mailTool").setDisabled(false);
    Ext.getCmp("dataTool").setDisabled(false);
    Ext.getCmp("diagnosisTool").setDisabled(false);
   

},
	validateForm: function () {
	var measurePopupForm = this.getUsergraphpopupmainform().getForm();
	var stDate = measurePopupForm.findField('er_stdate').getValue();
	var enDate = measurePopupForm.findField('er_enddate').getValue();
	stDate.setHours(measurePopupForm.findField('er_sthr').getValue());
	enDate.setHours(measurePopupForm.findField('er_endhr').getValue());
	var er_timeline = measurePopupForm.findField('er_timeline').getValue();
	if (Ext.isEmpty(er_timeline)) {
	er_timeline = '1 day';
	}
	if (er_timeline != null && er_timeline == "Any") {
		if (!checkDateTime(stDate, enDate)) {
			return;
		}
	}
	var getMaxDaysInMonth = publicJsonData['hiddenParams']['getMaxDaysInMonth'];
	var maxDaysInMonth = "";
	if (!Ext.isEmpty(getMaxDaysInMonth)) {
		maxDaysInMonth = getMaxDaysInMonth;
	}
	var er_usertimeline = "";
	var er_usertimelineObj = publicJsonData['hiddenParams']['er_usertimeline'];
	if (!Ext.isEmpty(er_usertimelineObj)) {
		er_usertimeline = er_usertimelineObj;
	}
	if (er_usertimeline != null && er_usertimeline != "-1") {
		if (!isUserTimelineLimitExceeded(er_usertimeline, maxDaysInMonth, stDate, enDate)) {
			return false;
		}
	}
	return true;
	},
	formSubmit : function()
	{
		/*if (!this.validateForm())
			return;*/

    var measurePopupForm = this.getUsergraphpopupmainform().getForm();

    var timeLineComboObj = measurePopupForm.findField('er_timeline');
    var graphModeObj = measurePopupForm.findField('er_mode');
	var startdateObj = Ext.getCmp("er_stdate").dataArray;
	var enddateObj   = Ext.getCmp("er_enddate").dataArray;
	var startHourObj = Ext.getCmp("er_sthr").dataArray;
	var endHourObj   = Ext.getCmp("er_endhr").dataArray;
	var startMinsObj = Ext.getCmp("startMins").dataArray;
	var endMinsObj = Ext.getCmp("endMins").dataArray;

	//var selectedStDate = Ext.Date.dateFormat(startdateObj.getValue(), mgrDateFormat);
   // var selectedEndDate = Ext.Date.dateFormat(enddateObj.getValue(), mgrDateFormat);

	//var selStartHr = startHourObj.getValue();
	//var selEndHr = endHourObj.getValue();
    var er_timeline = timeLineComboObj.getValue();
    var graphMode = "2D";
	if(!Ext.isEmpty(graphModeObj))
		graphMode = graphModeObj.getValue();
	
	var hiddenFieldQStr = publicJsonData['hiddenQStr'];
	var userID = publicJsonData['userID'];

   // var paramsForSubmit = 'er_timeline=' + er_timeline +'&er_enddate='+selectedStDate+'&er_stdate='+selectedEndDate+'&startdate=' + selectedStDate + '&userStartDate='+selectedStDate+'&userEndDate='+selectedEndDate+'&enddate=' + selectedEndDate + '&er_sthr='+selStartHr+'&starthr=' + selStartHr + '&er_endhr='+selEndHr+'&endhr=' + selEndHr + hiddenFieldQStr + '&er_mode=' + graphMode+"&userID="+userID;
	var paramsForSubmit = 'er_timeline=' + er_timeline +'&enddate='+enddateObj+'&startdate='+startdateObj + '&starthr='+startHourObj + '&endhr='+endHourObj+ hiddenFieldQStr + '&er_mode=' + graphMode+"&userID="+userID+"&startmin="+startMinsObj+"&endmin="+endMinsObj;
    loadmask.show();

		var url = '/final/servlet/com.eg.ErRepoLiteC';
		 paramsForSubmit += '&screenWidth=' + Ext.getBody().getViewSize().width;
		paramsForSubmit+= '&er_RmDispName='+appConstants.er_RmDispName;

		Ext.Ajax.request(
		{
			url : url,
			params : paramsForSubmit,
			scope: this,
			success: function (response) {
			var jsonText = response.responseText;
			var jsonData = Ext.decode(jsonText);
			var blockTitle = jsonData.pageParams['imgTitle'];

			var imgrurl = jsonData.pageParams['imgUrl'];

			var submittedData = Ext.getCmp("submittedData");
			submittedData.removeAll();
			submittedData.show();

			printPageUrl = jsonData.pageParams['printPageUrl'];
			dataDrillDownPageUrl = jsonData.pageParams['dataPageUrl'];
			ddPageDrillDownPageUrl = jsonData.pageParams['ddPageUrl'];
			pdfDrillDownPageUrl = jsonData.pageParams['pdfUrl'];
			if (ddPageDrillDownPageUrl != null && ddPageDrillDownPageUrl == '-')
			{
				Ext.getCmp("diagnosisTool").setDisabled(true);
			} 
			else 
			{
				Ext.getCmp("diagnosisTool").setDisabled(false);
			}
			//var htmlStr = '<div><img align="center" src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			var chartType = publicJsonData['chartType'];
			var imageHeight = parseInt(publicJsonData.pageParams['imgHeight']);
			var htmlStr = '';
			if(chartType!=null && chartType == "highchart")
			{
				htmlStr = '<div id="highChart_0" style="margin:0px 30px 0px 30px; width:'+publicJsonData.pageParams['imgWidth']+'&drillDown=yes'+'px;height:'+(imageHeight+20)+'px">';
			}
			else
			{
				htmlStr = '<div><img src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			}
			var addSubmittedReports = submittedData.add({
				xtype: 'container',
				id: 'noMeasMsgPanel',
				ui:'newGraphPanel',
				title: blockTitle,
				//cls: 'dataPanel',
				//layout: 'vbox',
				//width: '100%',
				html: htmlStr,
				listeners:
				{
					'boxready':function(){
						if(Ext.get("noMeasMsgPanel-body")){Ext.get("noMeasMsgPanel-body").dom.style = "top :0px";}
					}
				}
			});
			if(chartType == "highchart"){
				imgrurl=imgrurl+"&chartType=highchart";
					reportHighStockChart(imgrurl,'highChart_0',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
			}
			else
				loadmask.hide();
		}
	});
},
	defaultLoad: function () {
		var mainForm = this.getUsergraphpopupmainform();
		var measurePopupForm = mainForm.getForm();
    	if(!Ext.isEmpty(measurePopupForm))
		{
			var selectionDetailsObj=Ext.getCmp('details');
			var selectionDetailsjson = publicJsonData.selectionDetails;
			var fieldContainerArray=new Array();
			for (var labelName in selectionDetailsjson){
				var htmlstr=selectionDetailsjson[labelName];
				/*var fieldAdd = {xtype:'container', margin:'0 20 5 0',layout:'column',frame: false,border:false,items:[{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'<b>'+labelName+'</b>'},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'</b>:</b>'},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:htmlstr}]};
				fieldContainerArray.push(fieldAdd);*/
				var fieldAdd = {
					xtype:'container',
					margin:'0 20 5 10',
					layout:'column',
					frame:false,
					border:false,
					items:[
					{
						xtype:'container',
						margin:'0 5 5 0',
						frame:false,
						border:false,
						html:'<span class="formSelectionName">'+labelName+'</span> - <span class="formSelectionValue">'+htmlstr+'</span>'
					}]
					
				};
				fieldContainerArray.push(fieldAdd);
			}
			selectionDetailsObj.removeAll();
			selectionDetailsObj.add(fieldContainerArray);
			selectionDetailsObj.show();


			var timelineJSONArray = publicJsonData['timelineJSONArray'];
            var timelineSelectBox = measurePopupForm.findField('er_timeline');
            timelineSelectBox.getStore().loadRawData(timelineJSONArray);
            timelineSelectBox.setFieldLabel(timelineMapping);

            var er_timeline = publicJsonData.pageParams['er_timeline'];

            if (!Ext.isEmpty(er_timeline)) {
                timelineSelectBox.setValue(er_timeline);
            }

            var startdateObj = measurePopupForm.findField('er_stdate');
            startdateObj.setFieldLabel(fromLabelMapping);
			var selectedStDate = publicJsonData.pageParams['startdate'];
			var selectedStDate1 = publicJsonData.pageParams['startDateForDisplay'];
			if (!Ext.isEmpty(selectedStDate1)) {
				startdateObj.setValue(selectedStDate1);
            }
			startdateObj.dataArray = selectedStDate;

			var selectedStarthour = publicJsonData.pageParams['startHourForDisplay'];
			var selectedStarthour1 = publicJsonData.pageParams['starthr'];
			var startHourObj = measurePopupForm.findField('er_sthr');
			startHourObj.setValue(selectedStarthour);
			startHourObj.dataArray = selectedStarthour1;
			startHourObj.setFieldLabel(hrLblMapping);
			var startMinObj = measurePopupForm.findField('startMins');
			startMinObj.setFieldLabel(minLblMapping);
			var selectedStartMins = publicJsonData.pageParams['startMinForDisplay'];
			var selectedStartMins1 = publicJsonData.pageParams['startmin'];
            if (!Ext.isEmpty(selectedStartMins)) {
				startMinObj.setValue(selectedStartMins);
            }
			startMinObj.dataArray = selectedStartMins1;

            var enddateObj = measurePopupForm.findField('er_enddate');
            enddateObj.setFieldLabel(toLblMapping);
			var selectedEndDate = publicJsonData.pageParams['endDateForDisplay'];
			var selectedEndDate1 = publicJsonData.pageParams['enddate'];
            if (!Ext.isEmpty(selectedEndDate)) {
                enddateObj.setValue(selectedEndDate);
            }
			enddateObj.dataArray = selectedEndDate1;

			var selectedEndhour = publicJsonData.pageParams['endHourForDisplay'];
			var selectedEndhour1 = publicJsonData.pageParams['endhr'];

            var endHourObj = measurePopupForm.findField('er_endhr');
            endHourObj.setValue(selectedEndhour);
			endHourObj.dataArray = selectedEndhour1;
            endHourObj.setFieldLabel(hrLblMapping);
			var endMinObj = measurePopupForm.findField('endMins');
			endMinObj.setFieldLabel(minLblMapping);
			var selectedEndMins = publicJsonData.pageParams['endMinForDisplay'];
			var selectedEndMins1 = publicJsonData.pageParams['endmin'];
			if (!Ext.isEmpty(selectedEndMins)) {
				endMinObj.setValue(selectedEndMins);
			}
			endMinObj.dataArray = selectedEndMins1;
			var showMinutes = publicJsonData.pageParams['showMinutes'];
			var startMinsObj = Ext.getCmp("startMins");
			var endMinsObj = Ext.getCmp("endMins");
			if (timelineSelectBox.getValue() == 'Any')
			{
				startdateObj.setDisabled(false);
				enddateObj.setDisabled(false);
				startHourObj.setDisabled(false);
				endHourObj.setDisabled(false);
				startMinsObj.setDisabled(false);
				endMinsObj.setDisabled(false);
			}
			else
			{
				startdateObj.setDisabled(true);
				enddateObj.setDisabled(true);
				startHourObj.setDisabled(true);
				endHourObj.setDisabled(true);
				startMinsObj.setDisabled(true);
				endMinsObj.setDisabled(true);
			}
			            var graphModeOptions = publicJsonData['graphModeOptions'];
            var graphModeObj = measurePopupForm.findField('er_mode');
            //var graphModeLbl = Ext.getCmp('graphModeLbl');
            //graphModeObj.getStore().loadRawData(graphModeOptions);
            //var selectedGraphMode = publicJsonData.pageParams['selectedGraphMode'];
            //graphModeObj.setValue(selectedGraphMode);
			//graphModeObj.setFieldLabel(graphLblMapping);
            //graphModeLbl.setText(graphLblMapping);
		  var blockTitle = publicJsonData.pageParams['imgTitle'];

			var imgrurl = publicJsonData.pageParams['imgUrl'];

			var submittedData = Ext.getCmp("submittedData");
			submittedData.removeAll();
			submittedData.show();

			printPageUrl = publicJsonData.pageParams['printPageUrl'];
			dataDrillDownPageUrl = publicJsonData.pageParams['dataPageUrl'];
			ddPageDrillDownPageUrl = publicJsonData.pageParams['ddPageUrl'];
			if (ddPageDrillDownPageUrl != null && ddPageDrillDownPageUrl == '-')
			{
				Ext.getCmp("diagnosisTool").setDisabled(true);
			} 
			else 
			{
				Ext.getCmp("diagnosisTool").setDisabled(false);
			}
			pdfDrillDownPageUrl = publicJsonData.pageParams['pdfUrl'];
			var chartType = publicJsonData['chartType'];
			var imageHeight = parseInt(publicJsonData.pageParams['imgHeight']);
			var htmlStr = ''
			chartType='highchart';
			if(chartType!=null && chartType == "highchart"){
				
				htmlStr = '<div id="highChart_0" style="margin:0px 30px 0px 30px; width:'+publicJsonData.pageParams['imgWidth']+'&drillDown=yes'+'px;height:'+(imageHeight+20)+'px">';
			}else
			{
				htmlStr = '<div><img src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			}
			//var htmlStr = '<div><img align="center" src="' + imgrurl + '" width="' + publicJsonData.pageParams['imgWidth'] + '"  height="' + publicJsonData.pageParams['imgHeight'] + '" border="0" /><br><br>'
			var addSubmittedReports = submittedData.add({
				xtype: 'panel',
				id: 'noMeasMsgPanel',
				ui:'newGraphPanel',
				title: blockTitle,
				html: htmlStr,
				listeners:
				{
					'boxready':function(){
						if(Ext.get("noMeasMsgPanel-body")){Ext.get("noMeasMsgPanel-body").dom.style = "top :0px";}
					}
				}
			});
			//var submitButtonObj = Ext.getCmp("submit");
			//submitButtonObj.setText(submitLbl);
			if(chartType == "highchart"){
				imgrurl=imgrurl+"&chartType=highchart";
					//reportHighStockChart(imgrurl,'highChart_0',publicJsonData.pageParams['imgWidth'],imageHeight-15,null);
			}
		}
			loadmask = Ext.get('loadmask');
			loadmask.hide();
			this.formSubmit();
	}
});