Ext.define('TopNByMultipleTests.controller.TopNReports',{
	extend:'TopNByMultipleTests.controller.CommonController',
	refs:[
		{selector:'main',ref:'main'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'ReporterSettings', ref:'ReporterSettings'},
		{selector:'defineconfiguration',ref:'defineconfiguration'},
		{selector:'demo_1',ref:'demo_1'}
	],
	init:function(){
		this.control({		
			'main':{
				'boxready':this.afterMainRender
			},
			'topnreportsform':{
				'afterrender':this.loadForm
			}, 			
			'topnreportssettings':{
				'afterrender':this.loadSettings
			}, 
			'timeline combo[name="er_mode"]': {   //topntimeline
			  //'select': this.changeEr_mode
			}, 			
			'topnreportsform combo[name="er_dataFrom"]':{
				'select': this.compareOnChange
			},		
			'topnreportsform combo[name="er_service"]':{
				'select': this.groupOnChange
			},
			'topnreportsform combo[name="er_dataZone"]':{
				'select': this.groupOnChange
			},
			'topnreportsform combo[name="er_templateEnable"]':{
				'select': this.criteriaChange
			},
			'topnreportsform combo[name="er_test"]':{
				'select': this.testOnChange
			},
			'topnreportsform combo[name="er_template"]':{
				'select': this.metricOnChange
			},
			'topnreportsform combo[name="er_reportType"]':{
				'select': this.reportTypeOnChange
			},
			'topnreportssettings combo[name="er_groupby"]':{
				'select': this.showDescriptorsOnChange
			},
			/* 'topnreportssettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},*/
			'topnreportssettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'topnreportssettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndUpdateSettings
			},
			'topnreportssettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'topnreportssettings combo[name="er_trenddata"]':{
				'select': this.trendOnChange
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			 'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'demo_1':
			{
				'afterrender':this.renderPopUp
			},
			'main button[id="defineconfiguration"]':
			{
				'click':this.defineConfigurationPOPUP
			},
			'demo_1  button[id="addtogrid"]':
			{
				'click':this.addToGrid
			},
			'demo_1 combo[id="test"]':
			{
				'select': this.changeTest
			},
			'demo_1 combo[id="metric"]':
			{
				'select': this.changeMetric
			},
			'demo_1 combo[id="criteria"]':
			{
				'select': this.changeCriteria
			},
			/*'demo_1 multiselectfield[id="er_info_list"]':
			{
				'change': this.changeCriteria1
			},*/
			'configdatas':
			{
				afterrender: function(cmp)
				{
					var me = this;
					Ext.getBody().on('click',function(){ // call dom ref 
						me.defineConfigurationPOPUP();
					},null,{ delegate:'b#linkId'});
				}
			},'graphpopup': {
					 'render': this.drilldownResize
			},
			  'graphpopup combo[name="timeLineDrillDown"]': {
					'select': this.drillDownTimeOnchange
			},'graphpopup button[name="DrillDownsubmit"]': {
						 'click': this.submitDrillDown
			},'drilldowntools > #saveToolDrill > button': {
					'click': this.drillDownSave
			},'drilldowntools button[id="print"]': {
					  'click': this.drillDownPrint
			},'drilldowntools button[id="mail"]': {
				'click': this.drillDownMail
			}
		});
	},
	renderPopUp:function(popupPanle)
	{
		Ext.EventManager.onWindowResize(function()
		{
			popupPanle.doComponentLayout();
			popupPanle.setWidth(Ext.getBody().getViewSize().width-80);
		});	
	},
	defineConfigurationPOPUP:function(panel){


		/*if (Ext.get('linkId')) {
			Ext.get('linkId').hide();
		}*/
		//var buttonConObj= Ext.getCmp('defineconfiguration');
		//buttonConObj.setDisabled(true);
		var selectionDetails=Ext.getCmp("selectionDetails");
		if (!Ext.isEmpty(selectionDetails) && !selectionDetails.isHidden()) {
			this.toggleForm(selectionDetails);
		}
		Ext.getCmp('popup').show();

	},drilldownResize: function (panel) {
				 Ext.EventManager.onWindowResize(function () {
				panel.doComponentLayout();
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		var configdatas = Ext.getCmp('topN_mainContainer');
		if (ornt.isHidden())
		{
			ornt.show();
			configdatas.show();
			Ext.getCmp('selectionDetails').hide();
			Ext.getCmp('configdatas_container').hide()
			Ext.getCmp('temp_button').toggle(true);
			
		}
		else
		{
			ornt.hide();
			configdatas.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},	
	getUrl:function(isFormSubmitted,istrendChange)
	{
		var url;
		if (isFormSubmitted)
		{
			var reportGeneration = appConstants.publicjsonData.selectedFields['reportGeneration'];
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				reportGeneration = Ext.getCmp('reportGeneration').getValue();
			}
			if (reportGeneration == 'foreground') {
				 url='../servlet/com.eg.ErTopNMultipleTestC';
				 appConstants.queryString+= '&option=data&isSubmit=true&responseType=json';
			} else{
				url='../servlet/com.eg.ErStartBackGroundReportC';
				var bg_reportname=Ext.getCmp('bgReportName').getValue();
					bg_reportname=checkFileName(bg_reportname);
				appConstants.queryString+= '&bg_reportname='+bg_reportname+'&isSubmit=true&responseType=json';
			}
		}
		else
		{
			if (istrendChange)
			{
				var er_timelineVal=Ext.getCmp('er_timeline').getValue();
				var er_trenddata=Ext.getCmp('er_trenddata').getValue();
				var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param1,
					scope : this,
					async : true,
					success : function(response) { 
						var jsonData = Ext.decode(response.responseText);
						var comboVal=jsonData.combo;
						var timelineCombo = Ext.getCmp('er_timeline');
						timelineCombo.getStore().loadRawData(jsonData.combo);
						var flag=false;
						for(var i = 0; i < comboVal.length; i++)
						{
						  if(comboVal[i].valueField == er_timelineVal)
						  {
							flag=true;
						  }
						}
						if(flag)
							timelineCombo.setValue(er_timelineVal);
						else
							timelineCombo.setValue("1 day");
						appConstants.initLdgMask.hide();
					}
				});
				var inidate=appConstants.publicjsonData.hiddenFields.inidate;
				url= '/final/servlet/com.eg.ErRemoteScriptingServlet';
				er_timelineVal=Ext.getCmp('er_timeline').getValue();
				var er_stdateVal= Ext.getCmp('er_stdate').dataArray;
				var er_enddateVal= Ext.getCmp('er_enddate').dataArray;
				var er_sthr= Ext.getCmp('er_sthr').dataArray;
				var er_endhr= Ext.getCmp('er_endhr').dataArray;
				if (er_trenddata == "No") 
				{
					isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js
					appConstants.queryString = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidate + "]";
				} 
				else 
				{
					isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
					if(er_timelineVal=='Any')
					{
						appConstants.queryString = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + inidate+ "]";
					}
					else
					{
						appConstants.queryString = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidate+ "]";
					}
				}
			}
			else
			{
				url= '/final/reporter/ErTopNReportsJson.jsp';
			}
		}
			return url;
	},	
		ajaxHit:function()
	{		
	//	var url= this.getUrl(isFormSubmitted,istrendChange);
		var url='../servlet/com.eg.ErRepoLiteC';
		appConstants.initLdgMask.show();
		Ext.Ajax.request(
				{
					url : url,
					params:appConstants.queryString,
					scope:this,
					async: true,
					success: function(response, opts){
						
						if(isFormSubmitted) 
						{
						//	appConstants.publicjsonData=Ext.decode(response.responseText);
							return Ext.decode(response.responseText);
						}
						else 
						{
							if(istrendChange)
							{
								 //this.timelineUpdate(); 
								var jsonObject = Ext.decode(response.responseText);
								var values = jsonObject.timeline;
								Ext.getCmp('er_stdate').dataArray=values[0];
								Ext.getCmp('er_enddate').dataArray=values[1];
								Ext.getCmp('er_sthr').dataArray=values[2];
								Ext.getCmp('er_endhr').dataArray=values[3]; 
								mgr_stmin = values[4];
								mgr_enmin = values[5];

								Ext.getCmp('er_stdate').setValue(values[6]);
								Ext.getCmp('er_enddate').setValue(values[7]); 
								Ext.getCmp('er_sthr').setValue(values[8]);
								Ext.getCmp('er_endhr').setValue(values[9]); 
								stmin =values[10];
								enmin = values[11];
							}
							else
							{
							   appConstants.publicjsonData=Ext.decode(response.responseText);
								//this.showConfigDropdown();
							   this.loadFormFields(); 
							   if (isSettingsEnabled)
							   {
									this.showDescriptorsOnChange(Ext.getCmp('er_groupby'));
									this.reportTypeOnChange(Ext.getCmp('er_reportType')); 
							   }
							}
						}
						appConstants.initLdgMask.hide();
					},
					failure: function(response, opts) {
						appConstants.initLdgMask.hide();
						  console.log('server-side failure with status code ' + response.status);
					}
				});
	},
	updateAjaxFormData:function(isFormSubmitted,istrendChange)
	{		
		var url= this.getUrl(isFormSubmitted,istrendChange);

		//this.loadReportData(); 
		/*if(isFormSubmitted) 
			url='../servlet/com.eg.ErTopNMultipleTestC';*/
		/*var erTestMeasureCombination='';
		for (var i = 0; testArray.length > i; i++) {
			erTestMeasureCombination+=testArray[i]+'##'+measureArray[i]+'##'+descriptorArray[i]+',';
		}*/
		//
			/*for(var k=0;descriptorArray.length>k;k++)
			{
				appConstants.queryString+="&er_info_list="+descriptorArray[k];
			}*/
		//
	var reportGeneration = appConstants.publicjsonData.selectedFields['reportGeneration'];
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
						if(isFormSubmitted) 
						{
						if (reportGeneration == 'foreground') 
							appConstants.queryString+='&submitType=submit'
						}
		appConstants.initLdgMask.show();
		Ext.Ajax.request(
				{
					url : url,
			//		params:appConstants.queryString+'&erTestMeasureCombination='+erTestMeasureCombination+'&submitType=submit',
					params:appConstants.queryString,
					scope:this,
					async: true,
					method: 'POST',
					success: function(response, opts){
						
						if(isFormSubmitted) 
						{
							if (reportGeneration == 'foreground') {
								appConstants.standardSubmitData=Ext.decode(response.responseText);
							}
							else
							{
								appConstants.publicjsonData=Ext.decode(response.responseText);
							}
							this.loadReportData(); 
						}
						else 
						{
							if(istrendChange)
							{
								 //this.timelineUpdate(); 
								var jsonObject = Ext.decode(response.responseText);
								var values = jsonObject.timeline;
								Ext.getCmp('er_stdate').dataArray=values[0];
								Ext.getCmp('er_enddate').dataArray=values[1];
								Ext.getCmp('er_sthr').dataArray=values[2];
								Ext.getCmp('er_endhr').dataArray=values[3]; 
								mgr_stmin = values[4];
								mgr_enmin = values[5];

								Ext.getCmp('er_stdate').setValue(values[6]);
								Ext.getCmp('er_enddate').setValue(values[7]); 
								Ext.getCmp('er_sthr').setValue(values[8]);
								Ext.getCmp('er_endhr').setValue(values[9]); 
								stmin =values[10];
								enmin = values[11];
							}
							else
							{
								appConstants.publicjsonData=Ext.decode(response.responseText);
								//this.showConfigDropdown();
								// this.loadFormFields(); 
								this.loadFormFieldsForReportChange();
								if (isSettingsEnabled)
								{
									this.showDescriptorsOnChange(Ext.getCmp('er_groupby'));
									this.reportTypeOnChange(Ext.getCmp('er_reportType')); 
								}
							}
						}
						appConstants.initLdgMask.hide();
					},
					failure: function(response, opts) {
						appConstants.initLdgMask.hide();
						  console.log('server-side failure with status code ' + response.status);
					}
				});
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		Ext.widget('configform');
		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndUpdateSettings();
	});
	}, 
	changeEr_mode: function (combo) {
	var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
	var favorite_id = appConstants.publicjsonData.hiddenFields["favorite_id"];
	if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schedule == null || from_schedule == 'null'))
	{
		return;
	}
		this.showResult();
	},
	getMessageBox:function(title,msg)
	{
		 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
			
		return false;
	},
	validateMainForm:function(flag){
		var MaxDaysInMonth = appConstants.publicjsonData.hiddenFields['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicjsonData.hiddenFields['userTimeline'];
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicjsonData.selectedFields['reportGeneration'];
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var dataFrom=Ext.getCmp('er_dataFrom').getValue();
		//var metricCombo = Ext.getCmp('er_templateEnable').getValue();	
		var metricCombo='no';
		var component = Ext.getCmp('er_component');
		if ( dataFrom != 'Component'){
			var group=Ext.getCmp("er_service");
			if(group.getValue() == '-1'){
				this.getMessageBox('Operation Reports',group.getStore().getAt(0).get('displayField'));
				return false ;
			}
		}
		if(metricCombo == 'no'){
			/*var test = Ext.getCmp('er_test');
			var measure = Ext.getCmp('er_measure');
			
			if(test.getValue() == '-1'){
				this.getMessageBox('Operation Reports',test.getStore().getAt(0).get('displayField'));
				return false;
			}
			if(measure.getValue() == '-1'){
				this.getMessageBox('Operation Reports',measure.getStore().getAt(0).get('displayField'));
				return false;
			}*/
		}
		else{
			var metric =  Ext.getCmp('er_template');
			
			if(metric.getValue() == '-1'){
				this.getMessageBox('Operation Reports',metric.getStore().getAt(0).get('displayField'));
				return false;
			}
		} 		
		if( component.getValue() == '-1'){
				this.getMessageBox('Operation Reports',component.getStore().getAt(0).get('displayField'));
				return false;
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = appConstants.publicjsonData.hiddenFields['limitforbg'];
				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			return false;
		}
		return true;
	},
	hidePanels:function()
	{
		Ext.getCmp('resultContainer').hide();
		this.getNomeasurepanel().hide();	
		Ext.getCmp('backGroundPanel').hide();
	},
	reportTypeOnChange:function(obj){ 	
		if(obj.getValue() == 'data'){
			if(isSettingsEnabled)
				Ext.getCmp('er_sortby').show();
			//Ext.getCmp('er_mode').hide();
		}
		else{
			if(isSettingsEnabled)
				Ext.getCmp('er_sortby').show();
			//Ext.getCmp('er_mode').show();
		} 				
	},	
	compOnChange:function(obj, newValue, oldValue, eOpts){
		this.hidePanels();
		var me=this;
		if(!Ext.isEmpty(newValue))
		{
			this.updateQueryString();
			appConstants.initLdgMask.show();
			Ext.Ajax.request({
				url : '/final/reporter/ErTopNReportsJson.jsp',
				params :appConstants.queryString ,
				async :true,
				success: function(response){
					appConstants.publicjsonData=Ext.decode(response.responseText);
					/*var er_showinfo = appConstants.publicjsonData.selectedFields['selectedDescriptor'];
					if(er_showinfo == 'Yes' && isSettingsEnabled){
						 me.loadComboField('er_info_list','infoCombo','reporter.common.Descriptor','selectedInfo',appConstants.publicjsonData,true,null,null,false);
					}
					else if (isSettingsEnabled){
						Ext.getCmp('er_info_list').hide();
					}*/
					appConstants.initLdgMask.hide();
				}
			});
		}
	},
	showResult:function(){
		
	   var compVal = Ext.getCmp('er_component');
	   if(compVal!=undefined){
		  compVal= compVal.getValue().toString();
	   if(compVal== null || (compVal!= null && compVal!= 'undefined' && (compVal.trim() == '' ||compVal.indexOf('Not App')>-1))){
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Not Applicable !!!',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
	}
	if(compVal.indexOf("all") > -1 && compVal.indexOf(",") > -1)
	{
		Ext.MessageBox.show({
		title: 'Alert',
		msg: 'Individual and aggregate Components cannot be selected simultaneously',
		buttons: Ext.MessageBox.OK,
		icon: Ext.MessageBox.WARNING
		});
		return false;
	}
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var result = checkDateTime(stDateTime, enDateTime);
		if (!result) {
			return;
		}
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.doUpdate(true,false);
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndUpdateSettings())
		{
			this.showResult();
		}
	},
	validateAndUpdateSettings : function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && reportgen == 'background' ){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			this.doUpdate(true,false);
		}
		else{
			this.getReporterSettings().down('button').fireHandler();
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},	
	reportGenChange:function(){
		Ext.getCmp('resultContainer').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},	
	trendOnChange:function(obj) {
		this.doUpdate(false,true);
	},
	/* weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonData.displayFields['MappedExcludeDays']);
		}
		else
			excludeDaysObj.hide();
	},*/
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("excelTool").setDisabled(true);
	},
	updateQueryString:function(){
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var datafrom =Ext.getCmp('er_dataFrom').getValue();
		//var isMetricCombo = Ext.getCmp('er_templateEnable').getValue();
		var isMetricCombo='no';
		var compArray=new Array();
		var comp_combination='';
		var er_combination ='';
		compArray=Ext.getCmp("er_component").getValue();
		if(appConstants.publicjsonData.hasOwnProperty('combination')){
			comp_combination=appConstants.publicjsonData.combination;
		}
		//var showInfo = appConstants.publicjsonData.selectedFields['selectedDescriptor'];
		var groupInfo = appConstants.publicjsonData.selectedFields['selectedGroupBy'];
		var er_sortby = appConstants.publicjsonData.selectedFields['selectedSortBy'];
		var er_trenddata = appConstants.publicjsonData.selectedFields['selectedShowData'];
		var er_priority = appConstants.publicjsonData.selectedFields['selectedPriority'];
		var er_excwe = appConstants.publicjsonData.selectedFields['excludeWeek'];
		var reportGeneration = appConstants.publicjsonData.selectedFields['reportGeneration'];
		var timefrom = appConstants.publicjsonData.selectedFields['selectedTimeFrom'];
		var minfrom = appConstants.publicjsonData.selectedFields['selectedMinsFrom'];
		var timeto = appConstants.publicjsonData.selectedFields['selectedTimeTo'];
		var minto = appConstants.publicjsonData.selectedFields['selectedMinsTo'];
		if (isSettingsEnabled)
		{
			//showInfo = Ext.getCmp('er_showinfo').getValue();
			groupInfo = Ext.getCmp('er_groupby').getValue();
			er_sortby = Ext.getCmp('er_sortby').getValue();
			er_trenddata = Ext.getCmp('er_trenddata').getValue();
			er_priority = Ext.getCmp('er_priority').getValue();
			er_excwe = Ext.getCmp('er_excwe').getValue();
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
			timefrom = Ext.getCmp('timefrom').getValue();
			minfrom = Ext.getCmp('minfrom').getValue();
			timeto = Ext.getCmp('timeto').getValue();
			minto = Ext.getCmp('minto').getValue();
		}
		mainFormParams="er_dataFrom="+datafrom+"&er_reportType="+Ext.getCmp('er_reportType').getValue()+"&er_sortby="+er_sortby;
		if(datafrom!= '' && datafrom !='Component')
		{
			if(datafrom == 'Zone'){
				mainFormParams+="&er_dataZone="+Ext.getCmp('er_dataZone').getValue();
			}
			mainFormParams+="&er_service="+Ext.getCmp('er_service').getValue();
		}
		var isForceSub =appConstants.publicjsonData.hiddenFields['isForceSubmit'];
		if (isForceSub!=null && isForceSub=="true" && (appConstants.callFromReport ==null || appConstants.callFromReport==false || appConstants.callFromReport=='false')){

			var rm_compArr = new Array();
			// var rm_comp =appConstants.publicjsonData.hiddenFields['rmComponent'];
			var rm_comp =Ext.getCmp("er_component").getValue();
			rm_comp=rm_comp.toString();
			 if(rm_comp!=null && rm_comp!='undefined' && rm_comp.indexOf(','))
				rm_compArr = rm_comp.split(',');
			 if(rm_compArr!=null && rm_compArr!='undefined'){
				for(var k=0;rm_compArr.length>k;k++){
					mainFormParams+="&er_component="+rm_compArr[k];
					er_combination+=comp_combination[rm_compArr[k]]+"##";
				}
			}
		}else {
				if(compArray!=undefined)
				{
					for(var k=0;compArray.length>k;k++)
					{
						mainFormParams+="&er_component="+compArray[k];
						er_combination+=comp_combination[compArray[k]]+"##";
					}
				}
		}
		er_combination=encodeURIComponent(er_combination);
		mainFormParams+="&er_combination="+er_combination+'&callFromReport='+appConstants.callFromReport;
		//settingsFormParams="&er_showinfo="+showInfo+"&er_excwe="+er_excwe+"&er_priority="+er_priority+"&er_trenddata="+er_trenddata+"&er_mode="+Ext.getCmp('er_mode').getValue()+"&er_reportgenration="+reportGeneration;
		settingsFormParams="&er_groupby="+groupInfo+"&er_excwe="+er_excwe+"&er_priority="+er_priority+"&er_trenddata="+er_trenddata+"&er_mode="+Ext.getCmp('er_mode').getValue()+"&er_reportgenration="+reportGeneration;
		//if(showInfo!=null && showInfo == 'Yes')
		if(groupInfo!=null && groupInfo == 'Component_Descriptor')
		{
			var sh_timeinuse = appConstants.publicjsonData.selectedFields['weightedAvg'];
			if (isSettingsEnabled)
			{
				sh_timeinuse = Ext.getCmp('sh_timeinuse').getValue();
			}
			settingsFormParams+="&sh_timeinuse="+sh_timeinuse;
		}
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue()+"&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
		
		if(appConstants.publicjsonData.hasOwnProperty('hiddenFields')){
			var hiddenFields = appConstants.publicjsonData.hiddenFields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		appConstants.queryString=mainFormParams+settingsFormParams+timelineParams+appConstants.defaultParams+hiddenfieldQString+timperiodParams;
		appConstants.queryString+="&er_RmDispName="+appConstants.er_RmDispName;

		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils =Ext.widget("erutils");
		}

		testArray = new Array();
		measureArray = new Array();
		descriptorArray = new Array();
		var gridObj = Ext.getCmp('configdatas');
		var gridStore = gridObj.getStore();
		for ( var k = 0; k < Ext.getCmp('configdatas').getStore().getCount(); k++ )
		{
			var test = gridStore.getAt(k).get('testNameS');
			var measure = gridStore.getAt(k).get('measureNameS');
			var fullDesc = gridStore.getAt(k).get('fullDesc');
			testArray.push(test);
			measureArray.push(measure);
			descriptorArray.push(fullDesc);
			if(k==0)
			{
				appConstants.t1=test;
				appConstants.t2=measure;
				appConstants.t3=fullDesc;
			}
		}
		var erTestMeasureCombination='';
		for (var i = 0; testArray.length > i; i++) {
			erTestMeasureCombination+=testArray[i]+'##'+measureArray[i]+'##'+descriptorArray[i]+',';
		}
		appConstants.queryString+="&erTestMeasureCombination="+appConstants.erUtils.specialCharEncode(erTestMeasureCombination);

		var configForm = this.getDemo_1().getForm();
		if(configForm!=undefined)
		{
			var criteriaObj = configForm.findField('criteria');
			appConstants.queryString+='&er_template='+criteriaObj.getValue();
		}
	},
	doUpdate:function(isSubmitted,istrendChange)
	{
		this.hidePanels();
		this.disableTools();
		this.updateQueryString();
		if (appConstants.isForceSubmit=='true'){
			appConstants.queryString += '&isForceSubmit=true&er_RmDispName='+appConstants.er_RmDispName;
		}
		this.updateAjaxFormData(isSubmitted,istrendChange);
	},
	compareOnChange:function(){
		this.doUpdate(false,false);
		var compObj = Ext.getCmp('er_component');
		if ( !Ext.isEmpty( compObj ) )
		{
			compObj.getStore().removeAll();
			compObj.getStore().insert(0,{
				displayField: 'Not Applicable',
				valueField: '-1'
			});
			compObj.setValue('-1');
		}
		Ext.getCmp('er_service').setValue('-1');
		var datafrom =Ext.getCmp('er_dataFrom').getValue();
		if(datafrom!=undefined && datafrom =='Component')
		{
			this.getDataFromSelectionSource();
		}
	},
	groupOnChange:function(){
		this.getDataFromSelectionSource();
	},
	getDataFromSelectionSource:function(){

		var datafrom =Ext.getCmp('er_dataFrom').getValue();
		var erService='';
		var datazone='';
		if(datafrom!= '' && datafrom !='Component')
		{
			if(datafrom == 'Zone'){
				datazone=Ext.getCmp('er_dataZone').getValue();
			}
			erService=Ext.getCmp('er_service').getValue();
		}
			
			var getTestVal='';
			for (var i = 0; testArray.length > i; i++) {
				getTestVal+=testArray[i];
				if(i!=testArray.length-1)
					getTestVal+=',';
				}
				var methodName = 'getComponentsForMultipleTest';
				var no_params='';
				if ( datafrom == 'Zone' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=['+datazone+']&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Segment' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=[no]&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Service' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=[no]&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Component' )
				{
					methodName = 'getComponentsForMultipleTest1';
					no_params = '&P0=['+encodeURIComponent(getTestVal)+']';
				}
				var param = 'F='+methodName+'&C=jsrs1'+ no_params+'&U=1360217653961521&fromajax=true&fromTopNReport=yes';
				var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
				appConstants.initLdgMask.show();
					Ext.Ajax.request({
						url: remoteURL,
						params: param,
						async: true,
						method: 'POST',
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								var jsonData = Ext.decode( jsonText );
								if ( !Ext.isEmpty( jsonData ) )
								{
									var compData = jsonData['combo']; 
									var compObj = Ext.getCmp('er_component');
									var valueData=new Array();
									for(var i=0;i<compData.length;i++)
									{
										valueData.push(compData[i].valueField);
									}
									if ( !Ext.isEmpty( compData ) )
									{
										appConstants.rawDataForComponents = compData;
										compObj.suspendEvents(true);
										compObj.getStore().loadRawData(compData);
										var selectData=new Array();
										if(valueData[0] == "all")
										{
											selectData.push(valueData[0]);
											compObj.setValue(selectData);
										}
										else
										{
											compObj.setValue(valueData);
										}
										compObj.resumeEvents();
									}
								}
							}
							 appConstants.initLdgMask.hide();
						},
						failure: function()
						{
							  appConstants.initLdgMask.hide();
						}
					});
	},
	testOnChange:function(){
		if (!isSettingsEnabled)
		{
			this.showConfigDropdown();
		}
		this.doUpdate(false,false);
	},
	metricOnChange:function(){
		this.doUpdate(false,false);
	},
	criteriaChange:function(){
		this.doUpdate(false,false);
	},
	afterMainRender:function(){
		//registerAjaxEvents();	//this method is included in ErTracker.jsp
		var thisController = this;
		if(!hideBackButton){
			Ext.getCmp('topnreportsform').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonData['ID']
			}
		);
	}
		this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		if (appConstants.isForceSubmit!=null && appConstants.isForceSubmit=="true") {
			this.refreshReportData();
			appConstants.callFromReport = true;
		}else {
			var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = appConstants.publicjsonData.hiddenFields["fromFavoriteModify"];
			if (from_schedule != undefined && from_schedule == "No")
				this.refreshReportData();
			else if (fromFavoriteModify != undefined && fromFavoriteModify == "No")
				this.refreshReportData();
			else if (from_schedule != undefined && from_schedule == "Yes")
				this.schFavModifyLoad();
			else if (fromFavoriteModify != undefined && fromFavoriteModify == "Yes")
				this.schFavModifyLoad();
			else
				this.refreshReportData();
		}
	},
	setVal:function(id,displayProperty,valueProperty,parentJsonProperty,isCombo)
	{
		var component = Ext.ComponentManager.get(id); 
		if (!isCombo) //for datefield
		{
			component.setValue(parentJsonProperty.selectedFields[displayProperty]);
			component.dataArray =  parentJsonProperty.selectedFields[valueProperty];
		}
		else //for combofield
		  component.setValue(parentJsonProperty.selectedFields[valueProperty]);
	},
	loadSettings:function(){
	Ext.getCmp('moreOptionCloseId').show();
	var favorite_id = appConstants.publicjsonData.hiddenFields["favorite_id"];
	if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
	 //						  1			 2				3				  4						  5				   6			   7		   		   8				 9
	//this.loadComboField(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
		//this.loadComboField('er_showinfo','showDescriptorCombo','reporter.comparison.Show Descriptor','selectedDescriptor',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_groupby','showGroupbyCombo','reporter.comparison.Aggregate by','selectedGroupBy',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('sh_timeinuse','weightedAvgCombo','reporter.comparison.Weighted Average','weightedAvg',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_info_list','infoCombo','reporter.common.Descriptor','selectedInfo',appConstants.publicjsonData,true,null,null,false);
		var disableInfoCombo = appConstants.publicjsonData['disableInfoCombo'];
		var infoTextFieldValue = appConstants.publicjsonData['infoTextFieldValue'];
		if(disableInfoCombo!=undefined && disableInfoCombo=='yes')
		{
			Ext.getCmp('dummyContainer').hide();
			Ext.getCmp('info_list_container').hide();
			Ext.getCmp('er_info_list_TxtField').show();
			Ext.getCmp('er_info_list_TxtField').setValue(infoTextFieldValue);
		}
		else
		{
			Ext.getCmp('dummyContainer').show();
			Ext.getCmp('info_list_container').show();
			Ext.getCmp('er_info_list_TxtField').hide();
		}
		this.loadComboField('er_sortby','sortByCombo','reporter.comparison.Sort by','selectedSortBy',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_trenddata','showDataCombo','reporter.comparison.Show Data','selectedShowData',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_priority','priorityCombo','reporter.comparison.Show','selectedPriority',appConstants.publicjsonData,true,null,null,false);
		this.loadComboField('er_excwe','excludeWeekCombo','reporter.common.Exclude weekends','excludeWeek',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('reportGeneration','reportGenerationCombo','reporter.consolidated.Report Generation','reportGeneration',appConstants.publicjsonData,false,null,null,false);
		this.setVal('timefrom',null,'selectedTimeFrom',appConstants.publicjsonData,true);
		this.setVal('minfrom',null,'selectedMinsFrom',appConstants.publicjsonData,true);
		this.setVal('timeto',null,'selectedTimeTo',appConstants.publicjsonData,true);
		this.setVal('minto',null,'selectedMinsTo',appConstants.publicjsonData,true); 		
		this.showDescriptorsOnChange(Ext.getCmp('er_groupby'));	
		this.reportTypeOnChange(Ext.getCmp('er_reportType')); 
		var trendenablee=appConstants.publicjsonData["computeTrend"];
		if(trendenablee == 'false')
		{
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);  
		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 { 
			var rawData = parentJsonProperty.combo[comboProperty]; 
			component.getStore().clearFilter(true); 
			component.getStore().loadRawData(rawData);
			if(comboId!=null && comboId=='er_component')
			{
				var isForceSub =parentJsonProperty.hiddenFields['isForceSubmit'];
				if (isForceSub!=null && isForceSub=="true" && (appConstants.callFromReport ==null || appConstants.callFromReport==false || appConstants.callFromReport=='false')){
					var rm_compArr = new Array();
					 var rm_comp =appConstants.publicjsonData.hiddenFields['rmComponent'];
					if(rm_comp!=null && rm_comp!='undefined'){
						rm_compArr = rm_comp.split(',');
						for(var k=0;rm_compArr.length>k;k++){
							component.setValue(rm_compArr);
						}
					}
				}else{
					 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
						 component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
					 else
						component.setValue(rawData[0].valueField);
				}
			}
			else
			{
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
					component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
				else
					component.setValue(rawData[0].valueField);
			}
			if (isSetLabel)
			{
				if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
				{
					if(!isMultiSelect)
						component.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
					else
						Ext.ComponentManager.get(multiSelectLabelId).setText(comboLabelProperty);
				}
			 }
			if(component.isHidden())
				component.show();
		 }
		 else
		 {
			if(!isMultiSelect)
			{  
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectContainerId);
				if(m!=undefined && !m.isHidden())
				m.hide();
			}
		 }
	},
	timelineUpdate:function()
	{
		var er_trenddata = appConstants.publicjsonData.selectedFields['selectedShowData'];
		this.setVal('er_stdate','startDateForDisplay','startDate',appConstants.publicjsonData,false);
		this.setVal('er_sthr','startHourForDisplay','startHour',appConstants.publicjsonData,false);
		this.setVal('er_enddate','endDateForDisplay','endDate',appConstants.publicjsonData,false);
		this.setVal('er_endhr','endHourForDisplay','endHour',appConstants.publicjsonData,false);
		this.loadComboField('er_timeline','timelineCombo','reporter.common.Timeline','selectedTimeline',appConstants.publicjsonData,false,null,null,false);
	},
	showDescriptorsOnChange:function(obj)
	{
		if(obj.getValue() == 'Component_Descriptor'){
			Ext.getCmp('sh_timeinuse').show();
		}
		else{
			Ext.getCmp('sh_timeinuse').hide();
		}
	},
	loadFormFields:function()
	{
		this.loadComboField('er_dataFrom','reportForCombo','reporter.operation.Report for','selectedreportFor',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_service','seg-ser-zoneCombo','reporter.common.seg-ser-zone','selectedSeg-Ser-Zone',appConstants.publicjsonData,false,null,null,true);
		this.loadComboField('er_dataZone','subZoneCombo','reporter.comparison.Include SubZones','selectedsubZone',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_reportType','reportTypeCombo','reporter.comparison.Report Type','selectedreportType',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('test','testCombo','reporter.comparison.Test','selectedTest',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('measure','measureCombo','reporter.comparison.Measure','selectedMeasure',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('metric','metricsCombo','reporter.comparison.Metric','selectedMetrics',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('criteria','criteriaCombo','reporter.comparison.Select by Criteria','selectedCriteria',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_info_list','infoCombo','reporter.common.Descriptor','selectedInfo',appConstants.publicjsonData,true,null,null,false);		
		this.loadComboField('er_component','componentsCombo','reporter.common.Component','selectedComps',appConstants.publicjsonData,true,null,null,false);		
		var disableInfoCombo = appConstants.publicjsonData['disableInfoCombo'];
		var infoTextFieldValue = appConstants.publicjsonData['infoTextFieldValue'];
		if(disableInfoCombo!=undefined && disableInfoCombo=='yes')
		{
			Ext.getCmp('dummyContainer').hide();
			Ext.getCmp('info_list_container').hide();
			Ext.getCmp('er_info_list_TxtField').show();
			Ext.getCmp('er_info_list_TxtField').setValue(infoTextFieldValue);
		}
		else
		{
			Ext.getCmp('dummyContainer').show();
			Ext.getCmp('info_list_container').show();
			Ext.getCmp('er_info_list_TxtField').hide();
		}
	},
	loadFormFieldsForReportChange:function()
	{
		this.loadComboField('er_dataFrom','reportForCombo','reporter.operation.Report for','selectedreportFor',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_service','seg-ser-zoneCombo','reporter.common.seg-ser-zone','selectedSeg-Ser-Zone',appConstants.publicjsonData,false,null,null,true);
		this.loadComboField('er_dataZone','subZoneCombo','reporter.comparison.Include SubZones','selectedsubZone',appConstants.publicjsonData,false,null,null,false);
		this.loadComboField('er_reportType','reportTypeCombo','reporter.comparison.Report Type','selectedreportType',appConstants.publicjsonData,false,null,null,false);
	},

	addToGridViaFavSch:function()
	{
		testArray = new Array();
		measureArray = new Array();
		descriptorArray = new Array();
		var gridObj = Ext.getCmp('configdatas');
		var gridStore = gridObj.getStore();
		var strtok =appConstants.erTestMeasureCombination.split(',');
		for( var i=0;i<strtok.length;i++)
		{
			var testMeasure = strtok[i];
			if(testMeasure.length==0)
				break;

			var testMeasureTok =testMeasure.split('##');
			var s_test = "";
			var s_meas = "";
			var descrips = "";
			for( var k=0;k<testMeasureTok.length;k++)
			{
				if(k==0)
					s_test=testMeasureTok[k];
				
				else if(k==1)
					s_meas=testMeasureTok[k];

				else if(k==2)
					descrips=testMeasureTok[k];
			}
			var descTok =descrips.split('|');
			var decriptor='';
			var orgdecriptor='';
			for( var j=0;j<descTok.length;j++)
			{
				var tokens = descTok[j];
				var orgTokens = descTok[j];
				if(tokens != undefined)
				tokens = ( tokens == '-1' || tokens == '' )?'-':tokens;
				if ( tokens == '-' )
				{
					tokens='-';
				}
				if(tokens != undefined && tokens.trim() == 'all_descriptor')
					tokens='-';
				decriptor+=tokens;
				orgdecriptor+=orgTokens;
				if(j!=descTok.length-1)
				{
					decriptor+=',';
					orgdecriptor+='|';
				}
			}
			testArray.push(s_test);
			measureArray.push(s_meas);
			descriptorArray.push(orgdecriptor);
			var dispTestName=s_test;
			var dispMeasureName=s_meas;

			var url = '/final/servlet/com.eg.ErTopNMultipleTestC';
			appConstants.initLdgMask.show();
			Ext.Ajax.request({
				url: url,
				params:'submitType=getMeasureDesc&test='+s_test+'&measure='+s_meas,
				async: true,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						if ( !Ext.isEmpty( jsonData ) )
						{
							dispTestName = jsonData['testDescription'];
							dispMeasureName = jsonData['measureDescription'];
						}
					}
					appConstants.initLdgMask.hide();
				}
			});
			if(appConstants.er_template!=undefined && appConstants.er_template=='yes')//Metric
			{
				dispTestName='-';
			}
			gridStore.add(
			[
				{
				'Test': dispTestName,
				'Measure': dispMeasureName,
				'Descriptor': decriptor,
				'testNameS': s_test,
				'measureNameS': s_meas,
				'fullDesc': orgdecriptor
				}
			]);
		}
	},
	addToGrid:function(c)
	{
		appConstants.viaSchFav=false;
		testArray = new Array();
		measureArray = new Array();
		descriptorArray = new Array();

		var configForm = this.getDemo_1().getForm();
		var gridObj = Ext.getCmp('configdatas');
		var gridStore = gridObj.getStore();
		var testStore = configForm.findField('test').getStore();
		var testObj = configForm.findField('test');
		var measureObj = configForm.findField('measure');
		var metricObj = configForm.findField('metric');
		var descObj = configForm.findField('er_info_list');
		var compName = '';
		var compType = '';
		var testName = '';
		var measureName = '';
		var descName = descObj.getValue();
		if(Ext.getCmp('info_list_container').isHidden())
		{
			var descNameStr = configForm.findField('er_info_list_TxtField').getValue();
			descName = descNameStr.split(',');
		}

		var testNameS = '';
		var measureNameS = '';

		var getCriteria = Ext.getCmp('criteria').getValue();
		var compIntlVal = '';
		var compTypeIntlVal = '';
		var descIntlVal = '';

		if ( getCriteria == 'Test' || getCriteria == 'no')
		{
			if ( testObj.getValue() == '-1' )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: testObj.getRawValue(),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			else if ( measureObj.getValue() == '-1' )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: measureObj.getRawValue(),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		else
		{
			if ( metricObj.getValue() == '-1' )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: metricObj.getRawValue(),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		var getValueFieldVal='-';
		if ( getCriteria == 'yes' )
		{
			testName = '-';
			measureName = metricObj.getRawValue();
			testNameS=metricTestName;
			measureNameS=metricMeasureName;
		}
		else
		{
			testName = testObj.getRawValue();
			measureName = measureObj.getRawValue();
			testNameS=testObj.getValue();
			measureNameS=measureObj.getValue();
		}
		if(!multiSelectAllvalidation(descName,"all_descriptor")||(descName.length>1 && descName.indexOf('*')>-1))
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Individual and aggregate Descriptors cannot be selected simultaneously',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var descriptor='';
		var fullDesc='';
		for ( var j = 0 ; j < descName.length; j++ )
		{
			var desc = '';
			var showdescdesc = '';
			var descriptor_1 = ( descName[j] == '-1' || descName[j] == '' )?'-':descName[j];
			if ( descriptor_1 == '-' )
			{
				desc = '';
				showdescdesc='-';
			}
			else
			{
				if(descriptor_1=='*')
				{
					descriptor_1 = 'all_descriptor';
				}
				desc = descriptor_1;
				showdescdesc=desc;
			}
			if(showdescdesc != undefined && showdescdesc.trim() == 'all_descriptor')
				showdescdesc='-';
			descriptor+=showdescdesc;
			if(j!=descName.length-1)
			descriptor+=',';

			fullDesc+=desc
			if(j!=descName.length-1)
			fullDesc+='|';
		}
		var replicateVal = new Array();
		var repIdx = 0;
		for ( var k = 0; k < gridStore.getCount(); k++ )
		{
			var getTestName = gridStore.getAt(k).get('Test');
			var getMeasureName = gridStore.getAt(k).get('Measure');
			var getDescName = gridStore.getAt(k).get('Descriptor');
			if (  getTestName == testName && getMeasureName == measureName && getDescName == descriptor )
			{
				replicateVal[repIdx] = getTestName+'|'+getMeasureName+'|'+getDescName;
				repIdx++;
			}
		}
		var testIntlVal = '';
		var measureIntlVal = measureObj.getValue();
		var genHiddens = '';
		if ( getCriteria == 'Test' || getCriteria == 'no')
		{
			testIntlVal = testObj.getValue();
			genHiddens = getValueFieldVal+'| |'+testIntlVal+'|'+measureIntlVal+'|'+descIntlVal;
		}
		else
		{
			testIntlVal = testObj.getValue();
			genHiddens = getValueFieldVal+'| |'+testIntlVal+'|'+appConstants.measureVal+'|'+descIntlVal;
		}
		
		if(testName.trim() == 'Not Applicable'){
			Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Not Applicable',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
		}

		if ( replicateVal.length == 0 )
		{
			gridStore.add(
			[
				{
					'Test': testName,
					'Measure': measureName,
					'Descriptor': descriptor,
					'Hiddens': genHiddens,
					'testVal': testIntlVal,
					'testNameS': testNameS,
					'measureNameS': measureNameS,
					'fullDesc': fullDesc
				}
			]);
			
		}
		else
		{
			for ( var l = 0; l < replicateVal.length; l++ )
			{
				var genNewVal = testName+'|'+measureName+'|'+descriptor;
				if ( replicateVal[l] == genNewVal )
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Your current selection has already been added',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				}
				else
				{
					gridStore.add(
					[
						{
							'Test': testName,
							'Measure': measureName,
							'Descriptor': descriptor,
							'Hiddens': genHiddens,
							'testVal': testIntlVal,
							'testNameS': testNameS,
							'measureNameS': measureNameS,
							'fullDesc': fullDesc
						}
					]);
				}
			}
		}

		appConstants.hasMultipleTests = false;
		for ( var k = 0; k < Ext.getCmp('configdatas').getStore().getCount(); k++ )
		{
			var getFirstTestVal = gridStore.getAt(0).get('testVal');
			var getTmpTestVal = gridStore.getAt(k).get('testVal');
			var test = gridStore.getAt(k).get('testNameS');
			var measure = gridStore.getAt(k).get('measureNameS');
			var fullDesc = gridStore.getAt(k).get('fullDesc');
			testArray.push(test);
			measureArray.push(measure);
			descriptorArray.push(fullDesc);
			if ( getFirstTestVal != getTmpTestVal )
			{
				appConstants.hasMultipleTests = true;
			}
			
		}
		gridObj.getSelectionModel().selectAll();
		gridObj.doLayout();
		Ext.getCmp('submit').show();
	},
	loadForm:function(){
		this.timelineUpdate();

		stmin = appConstants.publicjsonData.selectedFields.startMinForDisplay;
		enmin = appConstants.publicjsonData.selectedFields.endMinForDisplay;
		mgr_stmin = appConstants.publicjsonData.selectedFields.startmin;
		mgr_enmin = appConstants.publicjsonData.selectedFields.endmin;

		this.loadComboField('er_timeline','timelineCombo','reporter.common.Timeline','selectedTimeline',appConstants.publicjsonData,false,null,null,false);
		this.loadFormFields();

		var from_schedule = appConstants.publicjsonData.hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = appConstants.publicjsonData.hiddenFields["fromFavoriteModify"];
		var fromScheduleModify = appConstants.publicjsonData.hiddenFields["fromScheduleModify"]
		var fromFavoriteModify =appConstants.publicjsonData.hiddenFields["fromFavoriteModify"];
		var schedule_id =appConstants.publicjsonData.hiddenFields["schedule_id"]; 
		var favorite_id =appConstants.publicjsonData.hiddenFields["favorite_id"];
		if ((fromScheduleModify != null && fromScheduleModify == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			appConstants.fromScheduleModify=fromScheduleModify;
			appConstants.fromFavoriteModify=fromFavoriteModify;
			appConstants.schedule_id=schedule_id;
			appConstants.favorite_id=favorite_id;
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
	},
	refreshReportData:function(){
	if (appConstants.isForceSubmit!=null && appConstants.isForceSubmit=="true"){
		//this.addToGrid();
		this.addToGridViaFavSch();
		var mainform = Ext.getCmp('mainform');
		mainform.show();
		Ext.getCmp('temp_button').setDisabled(false);
		//Ext.getCmp('temp_button').setTooltip("TEST");
		Ext.getCmp('topnreportsform_right').setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);

		this.loadComponetsViaForceSubmit();
		this.updateQueryString();
		this.updateAjaxFormData(true,false);	
	}else {
			if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
			{
				appConstants.viaSchFav=true;
				this.addToGridViaFavSch();
				var mainform = Ext.getCmp('mainform');
				mainform.show();
				Ext.getCmp('temp_button').setDisabled(false);
				//Ext.getCmp('temp_button').setTooltip("TEST");
				Ext.getCmp('topnreportsform_right').setDisabled(false);
				Ext.getCmp("favoriteTool").setDisabled(false);
				Ext.getCmp("scheduleTool").setDisabled(false);

				this.loadComponentsFromSchFav();
				this.updateQueryString();
				this.updateAjaxFormData(true,false);
			}
		}
	},
	loadComponentsFromSchFav:function(){
			var selectedComp=appConstants.publicjsonData.selectedFields.selectedComps;
			var datafrom =Ext.getCmp('er_dataFrom').getValue();
				var erService='';
				var datazone='';
		if(datafrom!= '' && datafrom !='Component')
		{
			if(datafrom == 'Zone'){
				 datazone=Ext.getCmp('er_dataZone').getValue();
			}
			 erService=Ext.getCmp('er_service').getValue();
		}
			
			var getTestVal='';
			for (var i = 0; testArray.length > i; i++) {
				getTestVal+=testArray[i];
				if(i!=testArray.length-1)
					getTestVal+=',';
				}
				var methodName = 'getComponentsForMultipleTest';
				var no_params='';
				if ( datafrom == 'Zone' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=['+datazone+']&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Segment' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=[no]&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Service' )
				{
					no_params = '&P0=['+datafrom+']&P1=['+erService+']'+'&P2=[no]&P3=['+encodeURIComponent(getTestVal)+']';
				}
				else if ( datafrom == 'Component' )
				{
					methodName = 'getComponentsForMultipleTest1';
					no_params = '&P0=['+encodeURIComponent(getTestVal)+']';
				}
				var param = 'F='+methodName+'&C=jsrs1'+ no_params+'&U=1360217653961521&fromajax=true&fromTopNReport=yes';
				var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
				appConstants.initLdgMask.show();
					Ext.Ajax.request({
						url: remoteURL,
						params: param,
						async: true,
						method: 'POST',
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								var jsonData = Ext.decode( jsonText );
								if ( !Ext.isEmpty( jsonData ) )
								{
									//var compData = jsonData['combo']; 
									var compData = appConstants.publicjsonData.combo.componentsCombo;
									var compObj = Ext.getCmp('er_component');
									if (!Ext.isEmpty(compData))
									{
										appConstants.rawDataForComponents = compData;
										compObj.suspendEvents(true);
										compObj.getStore().loadRawData(compData);
										compObj.setValue(selectedComp);
										compObj.resumeEvents();
									}
								}
							}
							appConstants.initLdgMask.hide();
						},
						failure: function()
						{
							appConstants.initLdgMask.hide();
						}
					});
				var configForm = this.getDemo_1().getForm();
				if(appConstants.er_template!=undefined && appConstants.er_template=='yes')//Metric
				{
					var criteriaCombo = Ext.getCmp('criteria');
					if(criteriaCombo!=undefined)
					{
						criteriaCombo.setValue("yes");
						var testObj = configForm.findField('test');
						var measureObj = configForm.findField('measure');
						var metricObj = configForm.findField('metric');
						metricObj.show();
						testObj.hide();
						measureObj.hide();
						this.changeMetric();
					}
				}
				else
				{
					var criteriaCombo = Ext.getCmp('criteria');
					if(criteriaCombo!=undefined)
					{
						criteriaCombo.setValue("no");
						var testObj = configForm.findField('test');
						var measureObj = configForm.findField('measure');
						testObj.show();
						measureObj.show();
						var metricObj = configForm.findField('metric');
						metricObj.hide();
					}
				}
	},
	loadComponetsViaForceSubmit:function()
	{
		var selectedComp=appConstants.publicjsonData.selectedFields.selectedComps;
		if (!Ext.isEmpty(appConstants.publicjsonData.combo.componentsCombo))
		{
			var compData = appConstants.publicjsonData.combo['componentsCombo']; 
			var compObj = Ext.getCmp('er_component');
			if(!Ext.isEmpty(compData))
			{
				appConstants.rawDataForComponents = compData;
				compObj.suspendEvents(true);
				compObj.getStore().loadRawData(compData);
				compObj.setValue(selectedComp); 
				compObj.resumeEvents();
			}
		}
	},
	schFavModifyLoad:function(){
		this.addToGridViaFavSch();
		var mainform = Ext.getCmp('mainform');
		mainform.show();
		Ext.getCmp('temp_button').setDisabled(false);
		//Ext.getCmp('temp_button').setTooltip("TEST");
		Ext.getCmp('topnreportsform_right').setDisabled(false);
		Ext.getCmp('configdatas_container').show();
		this.loadComponentsFromSchFav();
	},
	loadReportData:function(){
		var resultContainerObj=Ext.getCmp('resultContainer');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
		var backgroundresultsObj=Ext.getCmp('backGroundPanel');
		var reportGeneration=appConstants.publicjsonData.selectedFields.reportGeneration; 		
		if (isSettingsEnabled)
		{
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
		this.hidePanels();	
		if(reportGeneration == 'foreground'){
			resultContainerObj.removeAll();
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("upbutton").setDisabled(false);
				Ext.getCmp('panelinsidetoggle').setDisabled(false);
				if(Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				}
				var reportData=appConstants.publicjsonData.reportData;
				var onceInt=0;
					resultContainerObj.add({xtype:'panel'});
					var resultPanelObj=resultContainerObj.down('panel');
					resultContainerObj.show();
					var noOfCharts;
					var hideSelection=false;
					
					var itemsArray = new Array();
					var doms = new Array();
					var itmArry=new Array();
					var qryArry=new Array();
					var content='';
					noOfCharts=0;
					var chartInfoArr=appConstants.standardSubmitData.chartInfo;
					var reportType=appConstants.standardSubmitData.reportType;
					for (var i = 0; chartInfoArr.length > i; i++) {
						var charid = "myChartId" + i;
						var containerId = doms[i];
							noOfCharts+=1;
							itmArry.push(i);
					var chartObj=chartInfoArr[i];
					qryArry.push(chartObj.chartUrl);	
					}
					if(reportType!=undefined && reportType=='graph')
					{
						Ext.getCmp('excelTool').setDisabled(true);
						if(noOfCharts==1)
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><tr>';
						}
						else
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';
						}
						var col=0;

					for(var key in itmArry) 
					{
						var chartObj=chartInfoArr[key];
						var evenLastTd=false;
						var j=itmArry[key];
						if (col==2)
						{
							col=0;
							content+='</tr>';
							content+='<tr>';
						}
						if(key == 0){
							if (itmArry.length>2)
							{
								content+='<td style="padding:10px 0px 5px 0px">';
							}
							else if(itmArry.length==2)
							{
								content+='<td style="padding:10px 0px 10px 0px">';
							}
							else
							{
								content+='<td style="padding:10px 2px 10px 0px">';
							}
						}
						else if(key == 1){
							if (itmArry.length>2)
							{
								content+='<td style="padding:10px 2px 5px 10px">';
							}
							else
							{
								content+='<td style="padding:10px 2px 10px 10px">';
							}
						}
						else if((key%2) == 0){
							if (key==itmArry.length-1)
							{
								evenLastTd=true;
								content+='<td style="padding:5px 0px 10px 0px">';
							}
							else if (key==itmArry.length-2)
							{
								content+='<td style="padding:5px 0px 10px 0px">';
							}
							else{
								content+='<td style="padding:5px 0px 5px 0px">';
							}
						}
						else if((key%2) != 0){
							if (key==itmArry.length-1)
							{
								content+='<td style="padding:5px 2px 10px 10px">';
							}
							else
							{
								content+='<td style="padding:5px 2px 5px 10px">';
							}
						}
						content+='<div width="100%" class="graphMainDiv">';

						content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
						content+=chartObj.chartTitle;
						content+='</div>';
						content+='<div style="float:right;margin:3px 0px 4px 5px;">';
						content+='<div style="float:right;cursor:pointer;margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+chartObj.chartUrl+'\',\''+appConstants.erUtils.specialCharEncode(chartObj.chartTitle)+'\',\''+chartObj.chartIndex+'\');"></div>';
						content+='</div></div>';

						var dom="img_" + key;
						doms.push(dom);

						content+='<div id="'+dom+'" style="height:330px;width:100%;overflow:auto;" class="htmlGraphTableBody">';
						content+='</div>';
						content+='</div></td>';
						if (evenLastTd)
						{
							content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
						}
						col++;
					}
					if (col==2)
					{
						content+='</tr>';
					}
					content+='</table></div>';

					resultPanelObj.removeAll();

						resultPanelObj.add({
							columnWidth:1,
							html:content,
							//ui:'multiGraphPanel', // Graph panel
							//margin:'10 0 10 0',
							id:'html_content'
						});

				for(var i=0;i<itmArry.length;i++) {
					var j=itmArry[i];
					var url='../servlet/com.eg.ErRepoLiteC';
					var qryString=qryArry[i]
					
				var chartObj=chartInfoArr[i];
				var cIndex=chartObj.chartIndex;
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
						url : url,
						params:qryString+"&chartIndex="+cIndex,
						scope:this,
						async:true,
						method: 'POST',
						success: function(response, opts){
						var rootJson=Ext.decode(response.responseText);
						appConstants.publicjsonData=rootJson;
						var chartIndex=cIndex;
						if(rootJson.hasOwnProperty('chartIndex'))
							 chartIndex=rootJson.chartIndex;
						if(rootJson.hasOwnProperty('reportData'))
						{
							reportData=rootJson.reportData;
							var containerId = doms[chartIndex];
							var chartObj = reportData;
							var charid = "myChartId" + chartIndex;
							var xmlcode = chartObj.XMLData;
							if (xmlcode != '-') {
								this.getNomeasurepanel().hide();
								if(appConstants.chartType=='fusionchart')
								{
									if (FusionCharts(charid))
										FusionCharts(charid).dispose();
									var myChart = new FusionCharts(chartObj.swfpath, charid, "98%", "98%", "0", "1");
									myChart.setXMLData(xmlcode);
									myChart.setTransparent(true);
									myChart.render(doms[chartIndex]);
								}
								else
								{
									var highChart = {};
									var chartWidth;
									if (noOfCharts == 1)
										chartWidth=chartObj.chartWidth+300;
									else
										chartWidth=chartObj.chartWidth;

									highChart = jQuery.extend(true, {}, getHighChartsBarInstance(containerId,chartObj.chartHeight-20,450), highChart);
									highChart.setData(chartObj,'<%=currentDateFormat%>','');
									highChart.drawChart();
								}
							} else {
								if(Ext.get(doms[chartIndex])!=null)
									//Ext.get(doms[chartIndex]).update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
								Ext.get(doms[chartIndex]).update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
							}
						}
						else
						{
							if(Ext.get(doms[chartIndex])!=null)
							//Ext.get(doms[chartIndex]).update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
							Ext.get(doms[chartIndex]).update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
						}
						if (isFormSubmitted && onceInt==0 && appConstants.publicjsonData.selectionDetails!=undefined)
						{
							Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicjsonData.selectionDetails);
							onceInt++;
						}
						appConstants.initLdgMask.hide();
					}
					});
				}
			}
			else
			{
				Ext.getCmp('excelTool').setDisabled(false);
				var colWidth = 0.5;
				var gridHeight = 340;
				if(noOfCharts<=2)
				{
					gridHeight = '';
				}
				if(noOfCharts==1)
				{
					colWidth = 1.0;
				}
				var gridArray = new Array();
				var marginVal = '';
				resultPanelObj.removeAll();
				for(var key in itmArry) 
				{
					var chartObj=chartInfoArr[key];
					var csvUrl = '/final/servlet/com.eg.ErTopNMultipleTestC?keyTitle='+chartObj.chartIndex+'&isCsvRequest=true';
					if(key == 0)
					{
						if (itmArry.length>2)
						{
							marginVal = '10 5 10 0';
						}
						else if(itmArry.length==2)
						{
							marginVal = '10 5 10 0';
						}
						else
						{
							marginVal = '10 0 10 0';
						}
					}
					else if(key == 1)
					{
						if (itmArry.length>2)
						{
							marginVal = '10 0 10 5';
						}
						else
						{
							marginVal = '10 0 10 5';
						}
					}
					else if((key%2) == 0)
					{
						if (key==itmArry.length-1)
						{
							marginVal = '0 5 10 0';
						}
						else if (key==itmArry.length-2)
						{
							marginVal = '0 5 10 0';
						}
						else
						{
							marginVal = '0 5 10 0';
						}
					}
					else if((key%2) != 0)
					{
						if (key==itmArry.length-1)
						{
							marginVal = '0 0 10 5';
						}
						else
						{
							marginVal = '0 0 10 5';
						}
					}

					var dom="img_" + key;
					doms.push(dom);					
					gridArray.push({
						xtype:'panel',
						id:'img_' + key,
						columnWidth:colWidth,
						ui:'newGraphPanel',
						height:gridHeight,
						border:true,
						margin:marginVal,
						title:chartObj.chartTitle,
						tools:[
						{
							xtype: 'tbseparator',
							padding:0,
							height:26,
							width:2,
							margin:'0 0 0 0',
						},
						{
							xtype: 'button',
							width:16,
							height:16,
							margin:'0 3 0 3',
							style:{'border':'0px'},
							cls: 'iconCsv',
							csvUrl:csvUrl,
							handler:function()
							{
								window.location=this.csvUrl;
							}
						}]
					});
				}
				resultPanelObj.add({
					xtype:'panel',
					columnWidth:1,
					layout:'column',
					id:'html_data_content',
					items:gridArray
				});
				
				for(var i=0;i<itmArry.length;i++) 
				{
					var url='../servlet/com.eg.ErRepoLiteC';
					var qryString=qryArry[i]
					var chartObj=chartInfoArr[i];
					var cIndex=chartObj.chartIndex;
					appConstants.initLdgMask.show();
					Ext.Ajax.request({
						url : url,
						params:qryString+"&chartIndex="+cIndex,
						scope:this,
						async:true,
						method: 'POST',
						success: function(response, opts){
						var rootJson=Ext.decode(response.responseText);
						appConstants.publicjsonData=rootJson;
						var chartIndex=cIndex;
						if(rootJson.hasOwnProperty('chartIndex'))
							 chartIndex=rootJson.chartIndex;
						reportData=rootJson.reportData;
					var containerId = doms[chartIndex];
					if(reportData!=undefined)
					{
						var columnNames=reportData.columnNames;
						if(columnNames!=undefined)
						{
							var columnCount=columnNames.length;
							var dataArray=reportData.dataArray;
							var mainColArray=new Array();
							var fieldsToStore=new Array();
							for (var key in columnNames)
							{
								var align = 'center';
								var mainColumn = columnNames[key];
								if(key == 0)
									align = 'left';
								fieldsToStore.push(mainColumn);
								mainColArray.push({
									header: mainColumn,
									sortable: true,
									resizable :true,
									flex:1,
									align:align,
									dataIndex: mainColumn,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;

														v2= isNaN(v2) ? 0 : v2;
													}
												}
												else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else
												{
													v1=v1.toLowerCase();
													v2=v2.toLowerCase();
												}
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
								});
							}
							var isPagingHidden=false;
							//var gridPageSize=10;
							 if (dataArray!=undefined && dataArray.length<gridPageSize)
								isPagingHidden=true;
							else
								isPagingHidden=false;

							var sortIndex = 1;
							var er_sortbyVal = 'Avg';
							if(appConstants.publicjsonData.selectedFields!=undefined)
							{
								er_sortbyVal = appConstants.publicjsonData.selectedFields['selectedSortBy'];
							}
							if(Ext.getCmp('er_sortby')!=undefined)
							{
								er_sortbyVal = Ext.getCmp('er_sortby').getValue();
							}
							if(er_sortbyVal==undefined)
							{
								er_sortbyVal = 'Avg';
							}
							if(er_sortbyVal=='Min')
							{
								sortIndex = 1;
							}
							else if(er_sortbyVal=='Max')
							{
								sortIndex = 2;
							}
							else if(er_sortbyVal=='Avg')
							{
								sortIndex = 3;
							}
							var storeObj=Ext.create('Ext.data.Store', {
								fields:fieldsToStore,
								proxy: {
									type: 'pagingmemory',
									reader: {
										type: 'array', root : 'data', totalProperty : 'total'
									},
									data : dataArray,
								},
								sorters: { property: fieldsToStore[sortIndex], direction : 'DESC' },
								pageSize:gridPageSize,
								remoteSort:true,
								autoLoad : true
							});
							var activePage=1;
							var gridpanel = Ext.widget('customgrid',{
								store:storeObj,
								header:false,
								//forceFit:true,
								columnWidth:1.0,
								sortableColumns:true,
								ui:'newGridPanel',
								border:false,
								margin:'0 10 10 10',
								border:true,
								columns:mainColArray,
								style:
								{
									'box-shadow':'none !important',
								},
								scroll:false,
								autoScroll:true,
								dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}
									}
								}],
								listeners:
								{
									render:function(obj)
									{
										Ext.defer(function() 
										{
											if(!Ext.isEmpty(obj.columns[sortIndex]))
											{
												obj.columns[sortIndex].doSort('DESC');
											}
										},100);
									}
								}
							});
							
							Ext.getCmp(containerId).add(gridpanel)
							this.getNomeasurepanel().hide();
						}
						else
						{
							if(Ext.getCmp(containerId)!=undefined)
							{
								var noMesHei = 150;
								if(Ext.getCmp(containerId).getHeight()>150)
									noMesHei = Ext.getCmp(containerId).getHeight();
								Ext.getCmp(containerId).add({
									xtype:'container',
									height:noMesHei,
									html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
								});
							}
						}
					}
					else
					{
						if(Ext.getCmp(containerId)!=undefined)
						{
							var noMesHei = 150;
							if(Ext.getCmp(containerId).getHeight()>150)
								noMesHei = Ext.getCmp(containerId).getHeight();
							Ext.getCmp(containerId).add({
								xtype:'container',
								height:noMesHei,
								html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
							});
						}
					}
					if (isFormSubmitted && onceInt==0 && appConstants.publicjsonData.selectionDetails!=undefined)
					{
						Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicjsonData.selectionDetails);
						onceInt++;
					}
					appConstants.initLdgMask.hide();
				}
					});
				}
			}
		}
		else if(reportGeneration == 'background')
		{
			var backgroundReportStatus=appConstants.publicjsonData.displayFields.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicjsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicjsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicjsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor;

				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicjsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicjsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicjsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
				
			}
			else
			{
				var bgroundResponseTxt=appConstants.publicjsonData.displayFields.bgroundResponseTxt;
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'</div></td></tr></table></td></tr></table>');
			}
			backgroundresultsObj.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
	},
	changeTest: function( obj )
	{
		var me = this;
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var getTestVal = Ext.getCmp('test').getValue();
		var categoryVal = '';
		var isSubZone = 'no';
		
		var no_params = '';
		var funcName = '';
		var methodName='';
		if ( getTestVal != '-1' && !Ext.isEmpty( obj ) )
		{
			var param = 'F=getMeasuresForTest1&C=jsrs1&P0=['+getTestVal+']&U=1360067356100817&fromajax=true';
			if ( !Ext.isEmpty( obj ) )
			{
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
					url: remoteURL,
					params: param,
					async: true,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var measureData = jsonData['combo'];
								var measureObj = Ext.getCmp('measure');
								if ( !Ext.isEmpty( measureData ) )
								{
									measureObj.suspendEvents(true);
									measureObj.getStore().loadRawData(measureData);
									measureObj.getStore().insert(0,{
										displayField: appConstants.mapping_measure,
										valueField: '-1'
									});
									measureObj.setValue('-1');
									measureObj.resumeEvents();
								}
								else
								{
									me.insertNotApplicable(measureObj);
								}
							}
						}
						appConstants.initLdgMask.hide();
					}
				});
				//@desc load
				var url = '/final/servlet/com.eg.ErTopNMultipleTestC';
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
					url: url,
					params:'test='+getTestVal+'&submitType=descriptorlookup',
					async: true,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var infoCombo = jsonData['infoCombo'];
								var disableInfoCombo = jsonData['disableInfoCombo'];
								var infoTextFieldValue = jsonData['infoTextFieldValue'];
								//
								appConstants.publicjsonData.combo.infoCombo=infoCombo;
								//
								var descriptorObj = Ext.getCmp('er_info_list');
								if ( !Ext.isEmpty( descriptorObj ) )
								{
									descriptorObj.suspendEvents(true);
									descriptorObj.getStore().loadRawData(infoCombo);
									descriptorObj.setValue(infoCombo[0].valueField);
									descriptorObj.resumeEvents();
									if(disableInfoCombo!=undefined && disableInfoCombo=='yes')
									{
										Ext.getCmp('dummyContainer').hide();
										Ext.getCmp('info_list_container').hide();
										Ext.getCmp('er_info_list_TxtField').show();
										Ext.getCmp('er_info_list_TxtField').setValue(infoTextFieldValue);
									}
									else
									{
										Ext.getCmp('dummyContainer').show();
										Ext.getCmp('info_list_container').show();
										Ext.getCmp('er_info_list_TxtField').hide();
									}
								}
								else
								{
									me.insertNotApplicable(descriptorObj);
								}
							}
						}
						appConstants.initLdgMask.hide();
					}
				});
			}
		}
		else
		{
			var compObj = Ext.getCmp('component');
			var DescriptorObj = Ext.getCmp('Descriptor');
			var measureObj = Ext.getCmp('measure');
			me.insertNotApplicable(compObj);
			me.insertNotApplicable(measureObj);
		}
	},
	changeMetric:function( obj )
	{
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var getMetricVal = Ext.getCmp('metric').getValue();
		var no_params = '';
		var param = '';
		no_params = '&P0=['+getMetricVal+']';
		param = 'F=getTestForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		var testName;
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
				url: remoteURL,
				params: param,
				method: 'POST',
				async: true,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonData ) )
						{
							testName=jsonData.values[0];
						}
					}
					appConstants.initLdgMask.hide();
				}
			});
		param = 'F=getMeasuresForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		var meausreName;
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
				url: remoteURL,
				params: param,
				method: 'POST',
				async: true,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonData ) )
						{
							meausreName=jsonData.values[0];
						}
					}
					appConstants.initLdgMask.hide();
				}
			});
				var tName;
				if(testName!=undefined)
						tName = testName.split(':');

				if(tName!=undefined&&tName.length>0)
					tName=tName[0];

				var mName;
				if(meausreName!=undefined)
						mName = meausreName.split(':');

				if(mName!=undefined&&mName.length>0)
					mName=mName[0];

				 testArray = new Array();
				 measureArray = new Array();
				 testArray.push(tName);
				 measureArray.push(mName);

				metricTestName=tName;
				metricMeasureName=mName;

				//@desc load
				var url = '/final/servlet/com.eg.ErTopNMultipleTestC';
				appConstants.initLdgMask.show();
				Ext.Ajax.request({
					url: url,
					params:'test='+tName+'&submitType=descriptorlookup',
					async: true,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var infoCombo = jsonData['infoCombo'];
								var disableInfoCombo = jsonData['disableInfoCombo'];
								var infoTextFieldValue = jsonData['infoTextFieldValue'];
								appConstants.publicjsonData.combo.infoCombo=infoCombo;
								var descriptorObj = Ext.getCmp('er_info_list');
								if ( !Ext.isEmpty( descriptorObj ) )
								{
									descriptorObj.suspendEvents(true);
									descriptorObj.getStore().loadRawData(infoCombo);
									descriptorObj.setValue(infoCombo[0].valueField);
									descriptorObj.resumeEvents();
									if(disableInfoCombo!=undefined && disableInfoCombo=='yes')
									{
										Ext.getCmp('dummyContainer').hide();
										Ext.getCmp('info_list_container').hide();
										Ext.getCmp('er_info_list_TxtField').show();
										Ext.getCmp('er_info_list_TxtField').setValue(infoTextFieldValue);
									}
									else
									{
										Ext.getCmp('dummyContainer').show();
										Ext.getCmp('info_list_container').show();
										Ext.getCmp('er_info_list_TxtField').hide();
									}
								}
								else
								{
									me.insertNotApplicable(descriptorObj);
								}
							}
						}
						appConstants.initLdgMask.hide();
					}
				});
	},
	changeCriteria: function( obj )
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		if(resultContainerObj!=undefined)
			resultContainerObj.removeAll();
		var compObj = Ext.getCmp('er_component');
			if ( !Ext.isEmpty( compObj ) )
			{
				var compVal=compObj.getValue();
				if(compVal!=undefined){
					compObj.getStore().removeAll();
					compObj.getStore().insert(0,{
					displayField: 'Not Applicable',
					valueField: '-1'
					});
					compObj.setValue('-1');
				  }
			}
		Ext.getCmp('configdatas').getStore().removeAll();
		var configForm = this.getDemo_1().getForm();
		var criteriaObj = configForm.findField('criteria');
		var descObj = configForm.findField('Descriptor');
		var loadTestMetric = true;
		if ( !Ext.isEmpty( criteriaObj ) )
		{ 
			var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
			var no_params = '';
			no_params = '&P0=[Component]&P1=[Component]&P2=[no]';
			if ( loadTestMetric )
			{
				if ( criteriaObj.getValue() == 'no' )//Test
				{
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					testObj.show();
					measureObj.show();
					var metricObj = configForm.findField('metric');
					metricObj.hide();
					var param = 'F=getTestsForSite&C=jsrs1'+no_params+'&U=1360067356100817&fromajax=true';
					appConstants.initLdgMask.show();
					Ext.Ajax.request({
						url: remoteURL,
						params:param,
						async :true,
						scope:this,
						success:function(response)
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty(jsonData))
							{
								var testComboData = jsonData['combo'];
								var testObj = configForm.findField('test');
								testObj.suspendEvents(true);
								testObj.getStore().clearFilter(true); 
								testObj.getStore().loadRawData(testComboData);
								var tmpStore = testObj.getStore();
								tmpStore.insert(0, {
									displayField: appConstants.mapping_test,
									valueField: '-1'
								});
								testObj.setValue('-1');
								testObj.resumeEvents();
							}
							appConstants.initLdgMask.hide();
						}
					});
					var measureObj = configForm.findField('measure');
					this.insertNotApplicable(measureObj);
				}
				else
				{
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					var metricObj = configForm.findField('metric');
					var param = 'F=getTemplateForSite&C=jsrs1'+no_params+'&U=1360127833994872&fromajax=true';
					appConstants.initLdgMask.show();
					 Ext.Ajax.request({
						url: remoteURL,
						params:param,
						async :true,
						scope:this,
						success:function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonData ) )
							{
								var metricObj = configForm.findField('metric');
								metricObj.suspendEvents(true);
								var metricComboData = jsonData['combo'];
								metricObj.getStore().clearFilter(true); 
								metricObj.getStore().loadRawData(metricComboData);
								metricObj.getStore().insert(0,{
									displayField: appConstants.mapping_metric,
									valueField: '-1'
								});
								metricObj.setValue('-1');
								metricObj.resumeEvents();
							}
							appConstants.initLdgMask.hide();
						}
					});
					metricObj.show();
					testObj.hide();
					measureObj.hide();
				}
			}
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			var descriptorObj = configForm.findField('er_info_list');
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);
			this.insertNotApplicable(descriptorObj);
		}
	},
	criteriaSetForFavAndSc: function( obj )
	{
		var configForm = this.getDemo_1().getForm();
		var criteriaObj = configForm.findField('criteria');
		var descObj = configForm.findField('Descriptor');
		var loadTestMetric = true;
		if ( !Ext.isEmpty( criteriaObj ) )
		{ 
			var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
			var no_params = '';
			no_params = '&P0=[Component]&P1=[Component]&P2=[no]';
			if ( loadTestMetric )
			{
				if ( criteriaObj.getValue() == 'no' )//Test
				{
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					testObj.show();
					measureObj.show();
					var metricObj = configForm.findField('metric');
					metricObj.hide();
					var param = 'F=getTestsForSite&C=jsrs1'+no_params+'&U=1360067356100817&fromajax=true';
					appConstants.initLdgMask.show();
					Ext.Ajax.request({
						url: remoteURL,
						params:param,
						scope:this,
						async :true,
						success:function(response)
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty(jsonData))
							{
								var testComboData = jsonData['combo'];
								var testObj = configForm.findField('test');
								testObj.suspendEvents(true);
								testObj.getStore().clearFilter(true); 
								testObj.getStore().loadRawData(testComboData);
								var tmpStore = testObj.getStore();
								tmpStore.insert(0, {
									displayField: appConstants.mapping_test,
									valueField: '-1'
								});
								testObj.setValue('-1');
								testObj.resumeEvents();
							}
							appConstants.initLdgMask.hide();
						}
					});
					var measureObj = configForm.findField('measure');
					this.insertNotApplicable(measureObj);
				}
				else
				{
					// metric
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					var metricObj = configForm.findField('metric');
					var param = 'F=getTemplateForSite&C=jsrs1'+no_params+'&U=1360127833994872&fromajax=true';
					appConstants.initLdgMask.show();
					 Ext.Ajax.request({
						url: remoteURL,
						params:param,
						scope:this,
						async :true,
						success:function(response){
							
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonData ) )
							{
								var metricObj = configForm.findField('metric');
								metricObj.suspendEvents(true);
								var metricComboData = jsonData['combo'];
								metricObj.getStore().clearFilter(true); 
								metricObj.getStore().loadRawData(metricComboData);
								metricObj.getStore().insert(0,{
									displayField: appConstants.mapping_metric,
									valueField: '-1'
								});
								metricObj.resumeEvents();
							}
							appConstants.initLdgMask.hide();
						}
					});
					metricObj.show();
					testObj.hide();
					measureObj.hide();
				}
			}
			var descriptorObj = configForm.findField('er_info_list');
			this.insertNotApplicable(descriptorObj);
		}
	},
	insertNotApplicable: function(comboObj)
	{
		if ( !Ext.isEmpty( comboObj ) )
		{
			var tmpStore = comboObj.getStore();
			var naArray=[];
			naArray.push({
				displayField: appConstants.notApplicabletxt,
				valueField: '-1'
			});
			tmpStore.loadRawData(naArray);
			comboObj.setValue('-1');
			if(comboObj.getId()=='Descriptor')
			{
				appConstants.rawDataForDescriptor=naArray;
			}
			else if(comboObj.getId()=='component')
			{
				appConstants.rawDataForComponents=naArray;
			}
		}
	},
	showDrillDown: function(QueryString, chartTitle,chartIndex) {
		var htmlstr1 = '<div id="drilldownChartDiv" style="overflow:auto;height:400px;padding:10px;align:center;valign:middle"></div>';
		var drillDownURL = '../servlet/com.eg.ErRepoLiteC';
			QueryString+='&isFromDrillDown=y';
			appConstants.DrillDownQueryStringGlobal = QueryString+'&isFromDrillDown=y';
			appConstants.chartTitle = chartTitle;
			var isAnySelected = true;
			if (Ext.getCmp('er_timeline').getValue() == 'Any') {
				isAnySelected = false;
			}
			var rootJson;
			var graphpopup = Ext.widget('graphpopup');
			graphpopup.add({
				xtype: 'outerPanel',
				cls: 'outerpanel',
				margin: 0,
				frame: false,
				title: chartTitle, //appConstants.DrillDownPublicJsonData.reportTitle,
				hidden: false,
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				tools: [{
					xtype: 'drilldowntools'
				}],
				items: [{
					xtype: 'form',
					layout: 'column',
					cls: 'formOuter',
					bodyPadding: 10,
					defaults: {
						margin: '0 20 10 0',
						labelAlign: 'top'
					},
					items: [{
						fieldLabel: timelineLbl,
						xtype: 'scrollcombo',
						id: 'timeLineDrillDown',
						name: 'timeLineDrillDown',
						displayField: 'displayField',
						valueField: 'valueField',
						labelSeparator: '',
						queryMode: 'local',
						store: Ext.getCmp('er_timeline').getStore(),
						value: Ext.getCmp('er_timeline').getValue(),
						width: 90,
						cls: 'dropdown'
					}, {
						xtype: 'datepicker',
						id: 'startdateDrillDown',
						name: 'startdateDrillDown',
						format: mgrDateFormat,
						fieldLabel: fromLbl,
						cls: 'datepicker',
						value: Ext.getCmp('er_stdate').getValue(),
						width: 100,
						labelSeparator: '',
						disabled: isAnySelected
					}, {
						xtype: 'scrollcombo',
						width: 45,
						id: 'startHourDrillDown',
						name: 'startHourDrillDown',
						store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
						value: Ext.getCmp('er_sthr').getValue(),
						queryMode: 'local',
						fieldLabel: hrLbl,
						cls: 'dropdown',
						labelSeparator: '',
						disabled: isAnySelected

					}, {
						xtype: 'datepicker',
						id: 'enddateDrillDown',
						name: 'enddateDrillDown',
						format: mgrDateFormat,
						fieldLabel: Tolbl,
						cls: 'datepicker',
						width: 100,
						labelSeparator: '',
						disabled: isAnySelected,
						value: Ext.getCmp('er_enddate').getValue()
					}, {
						xtype: 'scrollcombo',
						width: 45,

						fieldLabel: hrLbl,
						cls: 'dropdown',
						id: 'endHourDrillDown',
						name: 'endHourDrillDown',
						labelSeparator: '',
						store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
						value: Ext.getCmp('er_endhr').getValue(),
						queryMode: 'local',
						labelSeparator: '',
						disabled: isAnySelected
					}, {
						xtype: 'scrollcombo',
						width: 60,
						id: 'graphmodeDrillDown',
						name: 'graphmodeDrillDown',
						fieldLabel: 'Graph',
						value: Ext.getCmp('er_mode').getValue(),
						cls: 'dropdown',
						labelSeparator: '',
						store: ['2D', '3D'],
						hidden: true
					}, {
						xtype: 'button',
						text: 'submit',
						ui:'newButtonSmall',
						name: 'DrillDownsubmit',
						margin: '16 0 0 0'
					}]
				}, {
					xtype: 'container',
					bodyPadding: '0 0 0 0',
					cls: 'containerShadow',
					id: "drillDownResultPanel",
					margin: 10,
					layout: 'fit',
					html: htmlstr1
				}]
			});
			graphpopup.show();
			appConstants.initLdgMask.show();
			Ext.Ajax.request({
				url: drillDownURL,
				params: QueryString,
				scope: this,
				method: 'POST',
				async: true,
				success: function(response, opts) {
					rootJson = Ext.decode(response.responseText);
					var chartIndex = 0;
					if (rootJson.hasOwnProperty('chartIndex'))
						chartIndex = rootJson.chartIndex;
					if (rootJson.hasOwnProperty('reportData')) {
						reportData = rootJson.reportData;
						var chartObj = reportData;
						var charid = "myChartId" + chartIndex;
						var xmlcode = chartObj.XMLData;
						if (xmlcode != '-') {
							this.getNomeasurepanel().hide();
							if (appConstants.chartType == 'fusionchart') {
								if (FusionCharts(charid))
									FusionCharts(charid).dispose();
								var myChart = new FusionCharts(chartObj.swfpath, charid, "98%", "98%", "0", "1");
								myChart.setXMLData(xmlcode);
								myChart.setTransparent(true);
								myChart.render(doms[chartIndex]);
							} else {
								var highChart = {};
								var chartWidth;
								chartWidth = chartObj.chartWidth + 300;
								highChart = jQuery.extend(true, {}, getHighChartsBarInstance("drilldownChartDiv", chartObj.chartHeight - 20, 450), highChart);
								highChart.setData(chartObj, '<%=currentDateFormat%>', '');
								highChart.drawChart();
							}
						} else {
							//Ext.get("drilldownChartDiv").update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
							Ext.get("drilldownChartDiv").update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
						}
					} else {
						//Ext.get("drilldownChartDiv").update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
						Ext.get("drilldownChartDiv").update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
					}
					appConstants.initLdgMask.hide();
				}
			});

	},

	submitDrillDown: function() {

	var timelineDrill = Ext.getCmp('timeLineDrillDown').getValue();
	var stDateTime = Ext.getCmp('startdateDrillDown').getValue();
	var tmpStartHour = Ext.getCmp('startHourDrillDown').getValue();
	var enDateTime = Ext.getCmp('enddateDrillDown').getValue();
	var tmpEndHour = Ext.getCmp('endHourDrillDown').getValue();
	if (timelineDrill == 'Any')
	{
		stDateTime.setHours(tmpStartHour);
		enDateTime.setHours(tmpEndHour);
		if (stDateTime > enDateTime) {
			Ext.MessageBox.show({
				title: 'TopNByMultipleTests',
				msg: 'dateValidateError',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
	}
	var QueryString = appConstants.DrillDownQueryStringGlobal;

	 QueryString=QueryString.replace(/(er_timeline=)[^\&]+/, '$1' +timelineDrill);
	 QueryString=QueryString.replace(/(startdate=)[^\&]+/, '$1' +Ext.Date.dateFormat(stDateTime, mgrDateFormat));
	 QueryString=QueryString.replace(/(enddate=)[^\&]+/, '$1' +Ext.Date.dateFormat(enDateTime, mgrDateFormat));
	 QueryString=QueryString.replace(/(starthr=)[^\&]+/, '$1' +tmpStartHour);
	 QueryString=QueryString.replace(/(endhr=)[^\&]+/, '$1' +tmpEndHour);

	var drillDownURL = '../servlet/com.eg.ErRepoLiteC';
	appConstants.initLdgMask.show();
	Ext.Ajax.request({
		url: drillDownURL,
		params: QueryString,
		scope: this,
		method: 'POST',
		async :true,
		success: function(response, opts) {
			var rootJson = Ext.decode(response.responseText);
			var chartIndex = 0;
			if (rootJson.hasOwnProperty('chartIndex'))
				chartIndex = rootJson.chartIndex;
			if (rootJson.hasOwnProperty('reportData')) {
				reportData = rootJson.reportData;
				var chartObj = reportData;
				var charid = "myChartId" + chartIndex;
				var xmlcode = chartObj.XMLData;
				if (xmlcode != '-') {

					this.getNomeasurepanel().hide();
					if (appConstants.chartType == 'fusionchart') {
						if (FusionCharts(charid))
							FusionCharts(charid).dispose();
						var myChart = new FusionCharts(chartObj.swfpath, charid, "98%", "98%", "0", "1");
						myChart.setXMLData(xmlcode);
						myChart.setTransparent(true);
						myChart.render(doms[chartIndex]);
					} else {
						var highChart = {};
						var chartWidth;
						chartWidth = chartObj.chartWidth + 300;

						highChart = jQuery.extend(true, {}, getHighChartsBarInstance("drilldownChartDiv", chartObj.chartHeight - 20, 450), highChart);
						highChart.setData(chartObj, '<%=currentDateFormat%>', '');
						highChart.drawChart();
					}
				} else {
					  // Ext.get("drilldownChartDiv").update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
					  Ext.get("drilldownChartDiv").update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
				}
			} else {
					  // Ext.get("drilldownChartDiv").update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/Light/nomeasures_custom.png"></img></div>');
					  Ext.get("drilldownChartDiv").update('<div class="egFlexCenterByColumnWise" style="height:95%"> <div class="iconInformation"></div> <div class="commonErrorMsgText">No Measures Available!</div> </div>');
			}
			appConstants.initLdgMask.hide();
		}
	});
	},drillDownTimeOnchange: function () {
		//Ext.getCmp('drillDownResultPanel').hide();
		var startDateObj = Ext.getCmp('startdateDrillDown');
		var startHrObj = Ext.getCmp('startHourDrillDown');
		var endDateObj = Ext.getCmp('enddateDrillDown');
		var endHrObj = Ext.getCmp('endHourDrillDown');
		var timelineVal = Ext.getCmp('timeLineDrillDown').getValue();
		//var priorityVal=Ext.getCmp('priorityDrillDown').getValue();

		if (timelineVal == 'Any') {
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}else{
			startDateObj.setDisabled(true);//er_timeline=4
			startHrObj.setDisabled(true);
			endDateObj.setDisabled(true);
			endHrObj.setDisabled(true);

			var timelineDrill = timelineVal;
			var stDateTime	  = startDateObj.getValue();
			var tmpStartHour  = startHrObj.getValue();
			var enDateTime    = endDateObj.getValue();
			var tmpEndHour    = endHrObj.getValue();
			var urlTmp = appConstants.DrillDownQueryStringGlobal;
			
			urlTmp=urlTmp.replace(/(er_timeline=)[^\&]+/, '$1' +timelineVal);
			appConstants.initLdgMask.show();
			Ext.Ajax.request({
				url: '/final/reporter/ErTopNReportsJson.jsp',
				params: urlTmp,
				method: 'POST',
				scope: this,
				async :true,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.DrillDownPublicJsonData = jsonData;
					var start_hour = jsonData.selectedFields.startHour;
					var end_hour   = jsonData.selectedFields.endHour;
					var start_date = jsonData.selectedFields.startDate;
					var end_date   = jsonData.selectedFields.endDate;
					
					startDateObj.setDisabled(true);
					startHrObj.setDisabled(true);
					endDateObj.setDisabled(true);
					endHrObj.setDisabled(true);
					startDateObj.setValue(start_date);
					startHrObj.setValue(start_hour+'');
					endDateObj.setValue(end_date);
					endHrObj.setValue(end_hour+'');
					appConstants.initLdgMask.hide();
				}
			});
		}
	},
	drillDownPrint: function () {
		var timelineDrill	= Ext.getCmp('timeLineDrillDown').getValue();
		var stDateTime		= Ext.getCmp('startdateDrillDown').getValue();
		var tmpStartHour	= Ext.getCmp('startHourDrillDown').getValue();
		var enDateTime		= Ext.getCmp('enddateDrillDown').getValue();
		var tmpEndHour		= Ext.getCmp('endHourDrillDown').getValue();
		var timefrom		= appConstants.publicjsonData.selectedFields['selectedTimeFrom'];
		var minfrom			= appConstants.publicjsonData.selectedFields['selectedMinsFrom'];
		var timeto			= appConstants.publicjsonData.selectedFields['selectedTimeTo'];
		var minto			= appConstants.publicjsonData.selectedFields['selectedMinsTo'];
		
		var s_qryString		= "/final/reporter/ErTopNReportsDrillDownPrint.jsp?chartTitle="+appConstants.chartTitle;
		var maptimeline		= new Ext.util.HashMap();
		maptimeline.add('er_timeline', timelineDrill);
		maptimeline.add('startdate', Ext.Date.dateFormat(stDateTime, mgrDateFormat));
		maptimeline.add('enddate', Ext.Date.dateFormat(enDateTime, mgrDateFormat));
		maptimeline.add('starthr', tmpStartHour);
		maptimeline.add('endhr', tmpEndHour);
		maptimeline.add('timefrom', timefrom);
		maptimeline.add('minfrom', minfrom);
		maptimeline.add('timeto', timeto);
		maptimeline.add('minto', minto);
		maptimeline.add('endmin', mgr_enmin);
		maptimeline.add('startmin', mgr_stmin);
	// Adding here to Updated values
		var createdURL = '';
		var count = 0;
	 maptimeline.each(function(key, value, length) {
		createdURL += key + '=' + value;
		count++
		if (count != length)
			createdURL += '&';
	});
				 
	   parent.printWindowFn(s_qryString+'&'+createdURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},

	drillDownSave:function(){
		
		var timelineDrill	= Ext.getCmp('timeLineDrillDown').getValue();
		var stDateTime		= Ext.getCmp('startdateDrillDown').getValue();
		var tmpStartHour	= Ext.getCmp('startHourDrillDown').getValue();
		var enDateTime		= Ext.getCmp('enddateDrillDown').getValue();
		var tmpEndHour		= Ext.getCmp('endHourDrillDown').getValue();
		var timefrom		= appConstants.publicjsonData.selectedFields['selectedTimeFrom'];
		var minfrom			= appConstants.publicjsonData.selectedFields['selectedMinsFrom'];
		var timeto			= appConstants.publicjsonData.selectedFields['selectedTimeTo'];
		var minto			= appConstants.publicjsonData.selectedFields['selectedMinsTo'];

		var tmpUrl = appConstants.publicjsonData.urlFields.saveQString;

		 tmpUrl=tmpUrl.replace(/(er_timeline=)[^\&]+/, '$1' +timelineDrill);
		 tmpUrl=tmpUrl.replace(/(startdate=)[^\&]+/, '$1' +encodeURIComponent(Ext.Date.dateFormat(stDateTime, mgrDateFormat)));
		 tmpUrl=tmpUrl.replace(/(enddate=)[^\&]+/, '$1' +encodeURIComponent(Ext.Date.dateFormat(enDateTime, mgrDateFormat)));
		 tmpUrl=tmpUrl.replace(/(starthr=)[^\&]+/, '$1' +tmpStartHour);
		 tmpUrl=tmpUrl.replace(/(endhr=)[^\&]+/, '$1' +tmpEndHour);
		 tmpUrl=tmpUrl.replace(/(timefrom=)[^\&]+/, '$1' +timefrom);
		 tmpUrl=tmpUrl.replace(/(minfrom=)[^\&]+/, '$1' +minfrom);
		 tmpUrl=tmpUrl.replace(/(timeto=)[^\&]+/, '$1' +timeto);
		 tmpUrl=tmpUrl.replace(/(minto=)[^\&]+/, '$1' +minto);
		 tmpUrl=tmpUrl.replace(/(er_RmDispName=)[^\&]+/, '$1' +encodeURIComponent('Top-N Analysis'));
		 tmpUrl=tmpUrl+'&chartTitle='+encodeURIComponent(appConstants.chartTitle);
	//         tmpUrl=tmpUrl+'&chartTitle=dd'+encodeURIComponent('ii ii ii') ;er_RmDispName=Top-N Analysis
		  

		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+tmpUrl+'&drillSes=yes';
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},drillDownMail: function () {
		var timelineDrill	= Ext.getCmp('timeLineDrillDown').getValue();
		var stDateTime		= Ext.getCmp('startdateDrillDown').getValue();
		var tmpStartHour	= Ext.getCmp('startHourDrillDown').getValue();
		var enDateTime		= Ext.getCmp('enddateDrillDown').getValue();
		var tmpEndHour		= Ext.getCmp('endHourDrillDown').getValue();
		var timefrom		= appConstants.publicjsonData.selectedFields['selectedTimeFrom'];
		var minfrom			= appConstants.publicjsonData.selectedFields['selectedMinsFrom'];
		var timeto			= appConstants.publicjsonData.selectedFields['selectedTimeTo'];
		var minto			= appConstants.publicjsonData.selectedFields['selectedMinsTo'];
		
		//var s_qryString		= "/final/reporter/ErTopNReportsDrillDownPrint.jsp?chartTitle="+appConstants.chartTitle;
		var maptimeline		= new Ext.util.HashMap();
		

		maptimeline.add('er_timeline', timelineDrill);
		maptimeline.add('startdate', Ext.Date.dateFormat(stDateTime, mgrDateFormat));
		maptimeline.add('enddate', Ext.Date.dateFormat(enDateTime, mgrDateFormat));
		maptimeline.add('starthr', tmpStartHour);
		maptimeline.add('endhr', tmpEndHour);
		maptimeline.add('timefrom', timefrom);
		maptimeline.add('minfrom', minfrom);
		maptimeline.add('timeto', timeto);
		maptimeline.add('minto', minto);
		maptimeline.add('endmin', mgr_enmin);
		maptimeline.add('startmin', mgr_stmin);
	// Adding here to Updated values
		var createdURL = '';
		var count = 0;
		maptimeline.each(function(key, value, length) {
		createdURL += key + '=' + value;
		count++
		if (count != length)
			createdURL += '&';
	});
		drillDownParams = createdURL+'&keyPrefix=enlarged&DrillDown=yes&chartTitle='+appConstants.chartTitle;
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
	});