
	Ext.define('virtualizationmanagerreports.controller.VirtualizationManagerReports',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'VirtualizationManagerSettings', ref:'VirtualizationManagerSettings'},
		{selector:'virtualizationmanagerform', ref:'virtualizationmanagerform'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector:'ReporterSettings', ref:'ReporterSettings'}
	],
	init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'virtualizationmanagersettings':{
				'afterrender':this.loadSettings
			},
			'virtualizationmanagerform':{
				'afterrender':this.loadMainForm
				},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button' : {
				 'click' : this.add
			},
			'newUtilities > #scheduleTool > button' : {
				'click' : this.add
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'timeline combo[name="er_mode"]':
			{
			  'select': this.changeEr_mode
			 },

			'virtualizationmanagerform combo[name="er_type"]':{
				'select': this.reportTypeOnChange
			},
			'virtualizationmanagerform combo[name="select_sort"]':{
				'select': this.showstatusOnChange
			},

			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'virtualizationmanagerform combo[name="er_comptype"]':{
				'select': this.compTypeOnChange
			},
			'virtualizationmanagerform combo[name="select_group"]':{
				'select': this.selectGroupOnChange
					},
			/*'virtualizationmanagersettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},*/
			'virtualizationmanagersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'virtualizationmanagersettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'virtualizationmanagersettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'virtualizationmanagersettings combo[name="er_sortby"]':{
				'select': this.trendOnChange
			},
			'mainform button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
				'click': this.add
			},

			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			}
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		 obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp('components'),appConstants.rawDataForComponents);
	},
	changeEr_mode: function (combo) {
		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		var from_schModify = hiddenFields['fromScheduleModify'];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if(Ext.get('configMod')!=null){
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.showResult();
	 },
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),'Components',btn);
	},

	loadSettings : function(thisObj)
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

	   var settingsObj = Ext.getCmp('settings');

	   settingsObj.loadScreenLabels(defaultJSON['screenlabels']);
	   settingsObj.loadDefaultData(defaultJSON['timeline']);
	   var trendenablee = defaultJSON['hiddenFields'].trendenable;
	   if(trendenablee == 'false'){
			Ext.getCmp('er_sortby').hide();
		}
		else
		{
			Ext.getCmp('er_sortby').show();
	   }

	},
	showConfigDropdown : function(){
		isSettingsEnabled = true;
		var me = this;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'virtualizationmanagersettings',
					parent:this
				}
			],
			renderTo:'virtualizationmanager-body',
			listeners:{
				render: function(){
					Ext.EventManager.onWindowResize(function(){
						Ext.get('configMod').setStyle('left', '');
					});
					Ext.get('closeSettings').on('click',function(){
						me.validateAndCloseSettings();
				 });
				}
			}
		});
	},

	validateAndCloseSettings : function()
	{
		var isSettingsOk = this.validateSettings();
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				isSettingsOk = false ;
			}
		}
		if(isSettingsOk)
		{
			Ext.get('configMod').animate({duration: 200,to: {y: -500}});
			return true;
		}
		return false;
	},

	closeAndSubmitSettings:function()
	{
	   if(this.validateAndCloseSettings())
		{
		   this.showResult();
		}
	},

	loadMainForm :function(){
		var virtualForm = Ext.getCmp('virtualizationmanagerform');
		virtualForm.loadDefaultData(defaultJSON);
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		if(!hideBackButton){
			Ext.getCmp('virtualizationmanagerform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: defaultJSON['ID']
				}
			);
		}
		if(appConstants.issubmit!=null && appConstants.issubmit=='true')
		{
			// this.enableDefaultSelection();
			this.showResult();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
		{
			this.showResult();
			appConstants.isForceSubmit='false';
		}
		}
	   var otherFiltersForm =null;
	if(isSettingsEnabled)
		otherFiltersForm = Ext.getCmp('settings').getForm();
	   	var er_trenddata =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);
	   if(er_trenddata=='Yes')
		{
		   isTrend=true;
		}
	},

	saveReportAsPDF:function(){
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();
		var time = mainForm.findField('er_timeline').getValue();

		var select_groupName = ''

		if(select_group == 'Zone'){
			select_groupName=mainForm.findField('zones').getValue();
	}
	else if(select_group == 'Segment'){
		select_groupName=mainForm.findField('segments').getValue();
	}
	else if(select_group == 'Service'){
		select_groupName=mainForm.findField('services').getValue();
	}

		var otherFiltersForm =null;
	if(isSettingsEnabled)
		otherFiltersForm = Ext.getCmp('settings').getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();

		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");

		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;

		//var startmin = hiddenFields['startmin'];
	   // var endmin = hiddenFields['endmin'];

		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();


		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);
		var s_qryString="../reporter/ErHtmlToSavePdf.jsp?selectedCompType="+er_comptype+"&select_groupName="+select_groupName+"&selectedGroup="+select_group+"&stdate="+startdate+"&endate="+enddate+"&er_excwe="+execweekend+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_type="+er_type+"&ermeasuretest="+er_measure+"&er_timeline="+er_timeline+"&ervm_type=vc&select_sort="+select_sort+"&pageWidthProces="+appConstants.pageWidth;
		//var s_qryString="../reporter/ErHtmlToSavePdf.jsp?selectedCompType="+er_comptype+"&select_groupName="+select_groupName+"&selectedGroup="+select_group+"&stdate="+starttime+"&endate="+endtime+"&er_excwe="+execweekend+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_type="+er_type+"&ermeasuretest="+er_measure+"&er_timeline="+er_timeline+"&ervm_type=vc&select_sort="+select_sort+"&pageWidthProces="+appConstants.pageWidth;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();
		var time = mainForm.findField('er_timeline').getValue();
		var select_groupName = ''
		if(select_group == 'Zone'){
			select_groupName=mainForm.findField('zones').getValue();
	}
	else if(select_group == 'Segment'){
		select_groupName=mainForm.findField('segments').getValue();
	}
	else if(select_group == 'Service'){
		select_groupName=mainForm.findField('services').getValue();
	}
		var otherFiltersForm =null;
	if(isSettingsEnabled)
		otherFiltersForm = Ext.getCmp('settings').getForm();
		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		//var startmin = hiddenFields['startmin'];
	   // var endmin = hiddenFields['endmin'];
		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();
		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);
		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);
		var s_qryString="selectedCompType="+er_comptype+"&select_groupName="+select_groupName+"&selectedGroup="+select_group+"&stdate="+startdate+"&endate="+enddate+"&er_excwe="+execweekend+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_type="+er_type+"&ermeasuretest="+er_measure+"&er_timeline="+er_timeline+"&ervm_type=vc&select_sort="+select_sort+"&pageWidthProces="+appConstants.pageWidth;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		 var mainForm = this.getVirtualizationmanagerform().getForm();


		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();
		var time = mainForm.findField('er_timeline').getValue();

		var select_groupName = ''

		if(select_group == 'Zone'){
			select_groupName=mainForm.findField('zones').getValue();
		}
		else if(select_group == 'Segment'){
			select_groupName=mainForm.findField('segments').getValue();
		}
		else if(select_group == 'Service'){
			select_groupName=mainForm.findField('services').getValue();
		}



			var otherFiltersForm =null;
		if(isSettingsEnabled)
			otherFiltersForm = Ext.getCmp('settings').getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();



		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			bookletquery += hiddenField + "=" + val;
			bookletquery += "&";
		}
		 bookletquery+='select_group='+select_group+'&includeSubZone='+includezones;

		if(er_type!=null && er_type=='No')
		{
			var checkboxobj = mainForm.findField('checkboxgroup')

			 if(checkboxobj.getComponent(1).getValue())
			 {
				bookletquery += '&select_sort=Virtual_Center';
			 }
			 if(checkboxobj.getComponent(0).getValue())
			 {
				 bookletquery += '&select_sort=Virtual_Center_Cluster';
			 }
			 if(checkboxobj.getComponent(2).getValue())
			 {
				bookletquery += '&select_sort=Virtual_Center_Host';
			 }
		}
		else
		{
			bookletquery+='&select_sort='+select_sort;
		}



		bookletquery+='&er_measure='+er_measure+'&er_type='+er_type+'&er_comptype='+er_comptype;

		if(select_group=='Component')
		{
			for (var j = 0; j < components.length; j++) {
				bookletquery += "&select_groupName=" + components[j];
			}
		}
		else
		{
			bookletquery +='&select_groupName='+select_groupName;
		}
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);
		bookletquery += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();

		bookletquery +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate+'&inszone='+includezones+'&select_farm='+select_groupName;

		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);


		bookletquery +='&er_excwe='+execweekend;
		bookletquery += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto+'&er_trenddata='+showData+'&er_mode='+er_mode;


	bookletquery+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID;//+'&eruserid='+appConstants.userID;

	 var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);

		bookletquery+='&er_reportgenration='+er_reportgenration+"&pageWidthProces="+appConstants.pageWidth;


		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){

		var mainForm = this.getVirtualizationmanagerform().getForm();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();
		var time = mainForm.findField('er_timeline').getValue();

		var select_groupName = ''

		if(select_group == 'Zone'){
		select_groupName=mainForm.findField('zones').getValue();
	}
	else if(select_group == 'Segment'){
		select_groupName=mainForm.findField('segments').getValue();
	}
	else if(select_group == 'Service'){
		select_groupName=mainForm.findField('services').getValue();
	}
		var otherFiltersForm =null;
	if(isSettingsEnabled)
		otherFiltersForm = Ext.getCmp('settings').getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();

		var starttime = startdate;
		var endtime = enddate;

		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;

		//var startmin = hiddenFields['startmin'];
		//var endmin = hiddenFields['endmin'];


		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");


	var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
	var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);

	var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
	var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
	var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
	var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);
	var s_qryString="/final/reporter/ErVMPrintData.jsp?selectedCompType="+er_comptype+"&select_groupName="+select_groupName+"&selectedGroup="+select_group+"&startdate="+starttime+"&endate="+endtime+"&er_excwe="+execweekend+"&Hourfrom="+timefrom+"&Minfrom="+minfrom+"&Hourto="+timeto+"&Minto="+minto+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_type="+er_type+"&ermeasuretest="+er_measure+"&er_timeline="+er_timeline+"&ervm_type=vc&pdfPrint=yes&select_sort="+select_sort;
	parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var isValid = this.validateMainForm();
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		var target='';
		if(isValid){
		this.updateQueryString();
		target="/final/reporter/ErSaveSchedule.jsp?"+queryString+"&option=data";
		var erUtils =  Ext.widget('erutils');
		erUtils.saveSchedule(target);
		parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
						//
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		//
		}
			return
	},
	saveFavorite:function(){
		var isValid = this.validateMainForm();
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		var target='';
		if(isValid){
		this.updateQueryString();
		document.location="../servlet/com.eg.ErFavoriteC?"+queryString+"&er_view=GRAPH&cmd=client";
		 target="../servlet/com.eg.ErFavoriteC?"+queryString+"&er_view=GRAPH&cmd=client";
		 parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			{
						//
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			//
				return;
			}
	},
	validateMainForm:function(){
		var mainForm = this.getVirtualizationmanagerform().getForm();

		var dataFrom=mainForm.findField('er_dataFrom').getValue();
		var metricCombo = mainForm.findField('er_templateEnable').getValue();
		var component = mainForm.findField('er_component');
		if ( dataFrom != 'Component'){
			var group=Ext.getCmp("er_service");

			if(group.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client Zone',
				msg: group.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		if(metricCombo == 'no'){
			var test = mainForm.findField('er_test');
			var measure = mainForm.findField('er_measure');

			if(test.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client Zone',
				msg: test.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(measure.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client Zone',
				msg: measure.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		else{
			var metric =  mainForm.findField('er_template');

			if(metric.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client Zone',
				msg: metric.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if( component.getValue() == '-1'){
			Ext.MessageBox.show({
			title: 'Thin Client Zone',
			msg: component.getStore().getAt(0).get('displayField'),
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		return true;
	},
	reportTypeOnChange:function(thisObj){
		Ext.getCmp('resultContainer').hide();
		var er_type= Ext.getCmp("er_type").getValue();

			Ext.Ajax.request({
			  url:'/final/servlet/com.eg.ErVirtualCenterDispacher?from=init&er_type='+er_type,
			  params:appConstants.qryString,
			  scope:this,
			  success:function(response){
				var jsontext = response.responseText;
				var jsonObject = Ext.decode(jsontext);
				appConstants.repoGene = jsonObject;
				if(isSettingsEnabled)
				{
					var reportgenCombo = Ext.getCmp("reportGeneration");
					var repogenload = jsonObject.reportgenCombo;
					var setRepoGen = jsonObject.reportgenCombo_value
					reportgenCombo.getStore().loadRawData(repogenload);
					reportgenCombo.setValue(setRepoGen);
					var reportNameObj = Ext.getCmp('bgReportName');
					if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
					{
						reportNameObj.hide();
					}
					else
					{
						reportNameObj.show();
					}
				}
	}
	});
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var val = thisObj.getValue();
		
		var select_sort = mainForm.findField('select_sort').getValue();
		var gytpe = mainForm.findField('select_group').getValue();
		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();

		var aparam = 'select_group='+gytpe+'&er_comptype='+er_comptype+'&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;

		if (er_type == 'Yes')
		{
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',aparam+'&toFilter=selectsortFilter','select_sort',mainForm);
		} else
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',aparam+'&toFilter=checkboxgroup','checkboxgroup',mainForm);

		
		if(val == 'No'){
			mainForm.findField('checkboxgroup').show();
			mainForm.findField('select_sort').hide();
			mainForm.findField('er_measure').hide();
			//mainForm.findField('er_mode').hide();
		}
		else{
			mainForm.findField('checkboxgroup').hide();
			mainForm.findField('select_sort').show();
			mainForm.findField('er_measure').show();
			//mainForm.findField('er_mode').show();
		}
},
	compTypeOnChange : function(thisObj){

		var val = thisObj.getValue();
		var thisForm = thisObj.up('.form').getForm();
		var er_type = thisForm.findField('er_type').getValue();
		var select_sort = thisForm.findField('select_sort').getValue();
		var gytpe = thisForm.findField('select_group').getValue();
		var er_type = thisForm.findField('er_type').getValue();
		var param = 'select_group='+gytpe+'&er_comptype='+val+'&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;

		this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param+'&toFilter=componentfilter','components',thisForm);
		this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param+'&toFilter=measureFilter','er_measure',thisForm);

		if (er_type == 'yes' || er_type == 'Yes')
		{
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param+'&toFilter=selectsortFilter','select_sort',thisForm);
		} else
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param+'&toFilter=checkboxgroup','checkboxgroup',thisForm);
	},
	selectGroupOnChange : function(thisObj){

		 var val = thisObj.getValue();
		 var thisForm = thisObj.up('.form').getForm();
		 var select_sort = thisForm.findField('select_sort').getValue();
		 var cytpe = thisForm.findField('er_comptype').getValue();
		 var er_type = thisForm.findField('er_type').getValue();
		 if(val=='Zone')
		 {
			thisForm.findField('zones').show();
			thisForm.findField('includezones').show();
			Ext.getCmp('compMultiselect').hide();
			thisForm.findField('services').hide();
			thisForm.findField('segments').hide();
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=zonefilter&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'zones',thisForm);
		 }
		 else if(val=='Service')
		 {
			thisForm.findField('zones').hide();
			thisForm.findField('segments').hide();
			thisForm.findField('includezones').hide();
			Ext.getCmp('compMultiselect').hide();
			thisForm.findField('services').show();
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=servicefilter&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'services',thisForm);
		 }
		 else if(val=='Segment')
		 {
			thisForm.findField('zones').hide();
			thisForm.findField('services').hide();
			thisForm.findField('includezones').hide();
			Ext.getCmp('compMultiselect').hide();
			thisForm.findField('segments').show();
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=servicefilter&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'segments',thisForm);
		 }
		 else
		 {
			Ext.getCmp('compMultiselect').show();
			thisForm.findField('zones').hide();
			thisForm.findField('includezones').hide();
			thisForm.findField('services').hide();
			thisForm.findField('segments').hide();
			if(er_type=="Yes")
			{
				thisForm.findField('select_sort').show();
				thisForm.findField('er_measure').show();
			}
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=componentfilter&sessionID='+appConstants.sessionID+'&select_sort='+select_sort+'&er_type='+er_type;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'components',thisForm);
		 }
	},
	showstatusOnChange : function(thisObj)
	{
		var val = thisObj.getValue();

		var thisForm = thisObj.up('.form').getForm();
		var select_group =  thisForm.findField('select_group').getValue();
		 var cytpe = thisForm.findField('er_comptype').getValue();
		 var er_type = thisForm.findField('er_type').getValue();
		 if(select_group=='Zone')
		 {
			thisForm.findField('zones').show();
			thisForm.findField('includezones').show();
			Ext.getCmp('compMultiselect').hide();
			thisForm.findField('services').hide();
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=measureFilter&select_sort='+val+'&er_type='+er_type+'&sessionID='+appConstants.sessionID;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'er_measure',thisForm);
		 }
		 else if(select_group=='Service')
		 {
			thisForm.findField('zones').hide();
			thisForm.findField('includezones').hide();
			Ext.getCmp('compMultiselect').hide();
			thisForm.findField('services').show();
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=measureFilter&select_sort='+val+'&er_type='+er_type+'&sessionID='+appConstants.sessionID;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'er_measure',thisForm);
		 }
		 else
		 {

			Ext.getCmp('compMultiselect').show();
			thisForm.findField('zones').hide();
			thisForm.findField('includezones').hide();
			thisForm.findField('services').hide();
			if(er_type=="Yes")
			{
				thisForm.findField('select_sort').show();
				thisForm.findField('er_measure').show();
			}
			var param = 'select_group='+val+'&er_comptype='+cytpe+'&toFilter=measureFilter&select_sort='+val+'&er_type='+er_type+'&sessionID='+appConstants.sessionID;
			this.filterComponent('/final/servlet/com.eg.ErVirtualCenterDispacher',param,'er_measure',thisForm);
		 }
	},
	filterComponent : function(url,param,field,form)
	{
		var er_comptype = form.findField('er_comptype').getValue();
		   Ext.Ajax.request({
			  url:url,
			  params:param,
			  scope:this,
			  success:function(response){
				  var jsontext = response.responseText;
				  var jsonObject = Ext.decode(jsontext);

				  if(field=='zones')
				  {
					var subz = form.findField('includezones');
					subz.getStore().loadRawData(jsonObject['subzone']);
					subz.setValue(subz.getStore().getAt(1));

					var fieldObj = form.findField(field);
					fieldObj.getStore().clearFilter(true); 
					fieldObj.getStore().loadRawData(jsonObject['zone']);
					fieldObj.setValue(fieldObj.getStore().getAt(0));
				  }
				  else if(field=='services')
				  {
					var fieldObj = form.findField(field);
					fieldObj.getStore().clearFilter(true); 
					fieldObj.getStore().loadRawData(jsonObject['services']);
					fieldObj.setValue(fieldObj.getStore().getAt(0));
				  }
				  else if(field=='segments')
				  {
					var fieldObj = form.findField(field);
					fieldObj.getStore().clearFilter(true); 
					fieldObj.getStore().loadRawData(jsonObject['services']);
					fieldObj.setValue(fieldObj.getStore().getAt(0));
				  }
				  else if(field=='er_measure')
				  {

					var fieldObj = form.findField(field);
					fieldObj.getStore().clearFilter(true); 
					fieldObj.getStore().loadRawData(jsonObject['measuresCombo']);
					fieldObj.setValue(fieldObj.getStore().getAt(0));
				  } else if(field=='select_sort')
				  {

					var fieldObj = form.findField(field);
					fieldObj.getStore().loadRawData(jsonObject['showstatusCombo']);
					fieldObj.setValue(fieldObj.getStore().getAt(0));
				  } else if(field=='checkboxgroup')
				  {
					var checkboxobj =  form.findField('checkboxgroup');
					var checkboxjson = jsonObject.checkboxdata;

					var vcentercheckedvalue = jsonObject.vcentercheckedvalue;
					var vclustercheckedvalue = jsonObject.vclustercheckedvalue;
					var physervercheckedvalue = jsonObject.physervercheckedvalue;
					if (er_comptype == 'Redhat_linux_mgr')
					{
						form.findField('vcenter').getEl().down('label.x-form-cb-label').update('RHEV Manager');
						form.findField('vmcluster').getEl().down('label.x-form-cb-label').update('RHEV Clusters');
						form.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
						Ext.getCmp('vcenter').hide();
						Ext.getCmp('physerver').hide();
					}
					else if(er_comptype == 'Nutanix_Cluster' || er_comptype == 'Nutanix_Prism_Center')
					{
						form.findField('vcenter').getEl().down('label.x-form-cb-label').update('Prism Server');
						form.findField('vmcluster').getEl().down('label.x-form-cb-label').update('Prism Cluster');
						form.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
						Ext.getCmp('vcenter').hide();
						Ext.getCmp('physerver').hide();
					}
					else 
					{
						form.findField('vcenter').getEl().down('label.x-form-cb-label').update('vCenters');
						form.findField('vmcluster').getEl().down('label.x-form-cb-label').update('VM Clusters');
						form.findField('physerver').getEl().down('label.x-form-cb-label').update('Hypervisors');
						Ext.getCmp('vcenter').show();
						Ext.getCmp('physerver').show();
					}
					if(checkboxjson[0]==vcentercheckedvalue)
						checkboxobj.getComponent(1).setValue(true);

					if(checkboxjson[1]==vclustercheckedvalue)
						checkboxobj.getComponent(0).setValue(true);

					if(checkboxjson[2]==physervercheckedvalue)
					   checkboxobj.getComponent(2).setValue(true);
					checkboxobj.doLayout();
				  }
				  else
				  {
					 var components = Ext.getCmp('components');
					 appConstants.rawDataForComponents = jsonObject.components;
					 components.getStore().loadRawData(jsonObject.components);

					 var values = [];

					 components.getStore().each( function( re ) {
						  values.push ( re.get('valueField') );
					  }, this);
					 components.setValue(values);
				  }
			  }
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	compOnChange:function(obj, newValue, oldValue, eOpts){
		Ext.getCmp('resultContainer').hide();
		var me=this;
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var showInfo =mainForm.findField('er_showinfo').getValue();
		var isMetricCombo = mainForm.findField('er_templateEnable').getValue();
		var timeline = mainForm.findField('er_timeline');
		if(oldValue!=undefined)
		{
			this.updateQueryString();
			Ext.Ajax.request({
				url : '/final/reporter/ErTopNReportsJson.jsp',
				params :queryString ,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicjsonData=jsonData;
					if(showInfo == 'Yes'){
						me.loadInfos();
					}
					else{
						Ext.getCmp('er_info_list').hide();
					}
				}
			});
		}
	},
	showResult:function(thisObj){
		 var mainForm;
		if(thisObj!=undefined)
		{
			mainForm = thisObj.up('.form').getForm();
		}
		else
		{
			mainForm = Ext.getCmp('virtualizationmanagerform').getForm();
		}


		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		//var zones = mainForm.findField('zones').getValue();
		//var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();

		var er_measure = mainForm.findField('er_measure').getValue();
		var select_groupName = '';

		if(select_group == 'Zone'){
			select_groupName=mainForm.findField('zones').getValue();
		}
		else if(select_group == 'Segment'){
			select_groupName=mainForm.findField('segments').getValue();
		}
		else if(select_group == 'Service'){
			select_groupName=mainForm.findField('services').getValue();
		}

	   if(select_groupName!=null & select_groupName == '-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}

		if(er_type!=null && er_type=='Yes' && er_measure!=null && er_measure=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'please choose the measure',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}

		if(select_sort!=null && select_sort=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}

		if(components!=null && components=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}
	   var otherFiltersForm =null;
	if(isSettingsEnabled)
		otherFiltersForm = Ext.getCmp('settings').getForm();


		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();
		var time = mainForm.findField('er_timeline').getValue();



		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");

		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);

		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";

		}
		 param+='select_group='+select_group+'&includeSubZone='+includezones;

		if(er_type!=null && er_type=='No')
		{
			var checkboxobj = mainForm.findField('checkboxgroup')

			 var isSelected=false;
			 if(checkboxobj.getComponent(1).getValue())
			 {
				param += '&select_sort=Virtual_Center';
				isSelected = true;
			 }
			 if(checkboxobj.getComponent(0).getValue())
			 {
				 param += '&select_sort=Virtual_Center_Cluster';
				 isSelected = true;
			 }
			 if(checkboxobj.getComponent(2).getValue())
			 {
				param += '&select_sort=Virtual_Center_Host';
				isSelected = true;
			 }

			 if(!isSelected)
			 {
				param += '&select_sort=Virtual_Center_Cluster';
				checkboxobj.getComponent(0).setValue(true);
			 }
		}
		else
		{
			if(select_sort!=null && select_sort!='undefined')
				param+='&select_sort='+select_sort;
			else
				param += '&select_sort=Virtual_Center_Cluster';
		}
		param+='&er_measure='+er_measure+'&er_type='+er_type+'&er_comptype='+er_comptype;

		if(select_group=='Component')
		{
			for (var j = 0; j < components.length; j++) {
				param += "&select_groupName=" + components[j];
			}
		}
		else
		{
			param +='&select_groupName='+select_groupName;
		}
		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");

		param +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate+'&timelineval='+er_timeline+'&inszone='+includezones+'&select_farm='+select_groupName;


		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);

		param +='&er_excwe='+execweekend;
		param += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto+'&er_trenddata='+showData+'&er_mode='+er_mode;


		param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID; 

		var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var bool = checkDateTime(stDateTime, enDateTime);

		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);
		var bgenabled = hiddenFields['bgenabled'];

		if (bool) {
			if (bgenabled == 'Yes' || bgenabled == 'yes') {

				var limitforbg = hiddenFields['limitforbg'];

				var bgtime = getTimeValues(limitforbg, msxdays,startdate, enddate,inidate);
				var getimeline = getTimeValues(er_timeline, msxdays,startdate, enddate,inidate);
				var selectbackground = er_reportgenration;
				var bgprocess = true;

				if (getimeline >bgtime && selectbackground == 'foreground') {
					if (appConstants.confirmationValidation != null&& (appConstants.confirmationValidation == "True" || appConstants.confirmationValidation == "Yes")) {
					//bgprocess = window.confirm("Foreground report generation will take some time. Do you want to proceed?");
					 Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn)
					{
						 if(btn=='no'){
							this.getReporterSettings().down('button').fireHandler();
							if(isSettingsEnabled)
								otherFiltersForm = Ext.getCmp('settings').getForm();
								otherFiltersForm.findField("bgReportName").show();
								otherFiltersForm.findField('reportGeneration').setValue('background');
								otherFiltersForm.findField("bgReportName").focus(false, 1000);
								Ext.getCmp('submitViaSetting').show();
								Ext.getCmp('moreOptionCloseId').hide();
								bgprocess=false;
							 }else{
							 var timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= "../servlet/com.eg.ErVirtualCenterDispacher?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
							   }
							 }
						},this);
				}
			}
				else if(selectbackground == 'background')
				{
					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								bg_reportname=checkFileName(bg_reportname);
								param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground;
								var url= '/final/servlet/com.eg.ErStartBackGroundReportC';
								this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
					}
				}
				else if(selectbackground == 'background-csv')
				{
					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								bg_reportname=checkFileName(bg_reportname);
								param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground;
								var url= "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
								this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
					}
				} else if(bgprocess){

						var old_width = 0;
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= "../servlet/com.eg.ErVirtualCenterDispacher?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
						} else
							return;
				}
			} else {

					var val = false;
					var timeVal = true;
					timeVal = getTimeForcurrentuser(mainForm,startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
					if (timeVal) {
						param += '&er_reportgenration='+selectbackground;
							var url=  "../servlet/com.eg.ErVirtualCenterDispacher?isSubmit=true";
							this.submitReport(url,param,er_type,er_reportgenration);
					} else
						return;
			}
		} else {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;

		var otherFiltersForm = Ext.getCmp('settings').getForm();
		var reportgen=otherFiltersForm.findField('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background'||reportgen == 'background') ){
			var reportName = otherFiltersForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	submitReport:function(url,param,er_type,er_reportgenration){
		param+="&er_RmDispName="+appConstants.er_RmDispName;

		var myMask=null;
		myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
			var me = this;
			var tmpGridWidth=0;
			Ext.Ajax.request(
			{
				url : url,
				params : param,
				success: function(response){
					var jsonText = response.responseText;

					var jsonData=Ext.decode(jsonText);
					myMask.hide();
					if(!Ext.isEmpty(jsonData))
					{
						var resultObj = Ext.getCmp('resultContainer');
						resultObj.removeAll();

						if(er_reportgenration!=null && er_reportgenration=='background' )
						{
							var grpahQueryString = jsonData.grpahQueryString;
							var status = grpahQueryString.status;
							if(status!=undefined && status =='success'){
							//htm = '<center><div  style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1+ '</b>.</br>' + '<a class="backgroundMsgLink" href='+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2+ '</a> </div></div></center>';
									
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
									}
							else{
							//htm = '<center><div  style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1+ '</b>.</br>' + '<a class="backgroundMsgLink" href='+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2+ '</a> </div></div></center>';
							
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
							}
							me.getBackGroundPanel().update(htm);
							me.getBackGroundPanel().show();
							resultObj.hide();
							return;
						}
						if(er_reportgenration!=null && er_reportgenration=='background-csv')
						{
							var grpahQueryString = jsonData.grpahQueryString;
							var status = grpahQueryString.status;
							if(status!=undefined && status =='success'){
							/*htm = '<center><div  style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1
									+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
									+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2
									+ '</a> </div></div></center>';*/
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
						}
							else{
							/*htm = '<center><div  style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1
									+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
									+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2
									+ '</a> </div></div></center>';*/
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
							}
							me.getBackGroundPanel().update(htm);
							me.getBackGroundPanel().show();
							resultObj.hide();
							return;
						}
						if(er_type!=null && er_type=='Yes')
						{
							var jsonObject = jsonData['graphData'];
							var distGraph = jsonObject['distributionJSON'];
							var topGraph = jsonObject['topGraphJSON'];

							var isGraphExists = true;
							if(!Ext.isEmpty(distGraph) && !Ext.isEmpty(topGraph))
							{
								if(distGraph['nomeasuresfordistribution']!=undefined && distGraph['nomeasuresfordistribution']=='yes')
								{
									if(topGraph['nomeasuresfortopGraph']!=undefined && topGraph['nomeasuresfortopGraph']=='yes')
									{
											isGraphExists=false;
									}
								}
							}
							if(!isGraphExists || isGraphExists=='false')
							{
								me.getNomeasurepanel().show();
							}
							else
							{
								me.enableTools(); 
								resultObj.add({
									xtype:'panel',
									title:distGraph.combinationfordistribution,
									//cls:'datapanel',
									margin:'10 10 10 10',
									ui:'multiGraphPanel',
									layout:{type:'column',align:'stretch'},
									items:[
											{
												xtype:'distributiongraph',
												data:distGraph,
												title:distGraph.titlefordistribution,
												height:350,
											},
											{
												xtype:'topgraph',
												data:topGraph,
												title:topGraph.titlefortopGraph,
												height:350,
											}
											
									]
								});
								resultObj.show();
								Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
							}
							Ext.getCmp("csvTool").setDisabled(true);
						}
						else
						{
							if (jsonData.hasOwnProperty("pageWidth"))
							{
								appConstants.pageWidth=jsonData.pageWidth;
							}
							else
							{
								appConstants.pageWidth=1024;
							}
							
							var gridObject = jsonData['gridData'];
							
							var jsonobj = gridObject[0];
							
							var nomeasures = jsonobj['nomeasures'];
							if (!Ext.isEmpty(nomeasures)) {
								me.getNomeasurepanel().show();
								return;
							} else {
								Ext.getCmp("csvTool").setDisabled(false);
								me.enableTools();
							}

					var itemsArray = new Array();
					for (var i in gridObject) 
					{
						var gridDataObj = gridObject[i];
						var columns = gridDataObj.mainColumns;
						var data = gridDataObj.data;
						var units = gridDataObj.unit;
						var fieldstoStore = new Array();
						var mainColumnArray = new Array();
						var k = 0;
						var count = 0;
						var index;
						for (var mcol in columns) {
							var isLocked = false;
							if(k==0)
								isLocked = true;
							var measureColumnArray = new Array();
							var subarray = new Array();
							subarray = columns[mcol];
							var subColumnArray = new Array();
							if (!Ext.isEmpty(subarray) && (subarray instanceof Array) && k != 0) {
								for (var j = 0; j < subarray.length; j++) {
									index = "col_" + i + '_' + count;
									subColumnArray.push({
										header: subarray[j] + units[k],
										sortable: true,
										width: 150,
										align: 'center',
										dataIndex: index,
										renderer: function(value,metaData, record,row, col, store,gridView) {
											var href = value['href'];
											if (href != undefined) {
												var val = value['value'];
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
												return '<a class="anchorLinkDefault" href=' + href + '>' + val + '</a>'
											} else {
												metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
												value = Ext.getCmp('gridId'+i).getDecimalAlignFormat(value);
												return value;
											}
										},
										doSort: function(state) {

											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2) {
													if (v1.index == 0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1 = isNaN(v1) ? 0 : v1;
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2 = isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
									});
									fieldstoStore.push(index);
									count++;
								}
							}
							if (k == 0 || ((gridDataObj['report'] == 'Virtual_Cluster') && k == 1) || (gridDataObj['report'] == 'notCluster' && (k == 1 || mcol == 'Health')) || (gridDataObj['report'] == "Default" && mcol == 'Health')) 
							{
								index = "col_" + i + '_' + count;
								
								var image = " ../reporter/images/" + columns[mcol];

								image = '<div class="' + columns[mcol] + '" ></div>';
								var align = 'left';
								if ((gridDataObj['report'] == 'Virtual_Cluster') && k == 1) {
									image = mcol;
									align = 'left';
								} else if (gridDataObj['report'] == "Default" && mcol == 'Health') {
									image = mcol;
									align = 'center';
								} else if (gridDataObj['report'] == 'notCluster' && k == 1) {
									image = mcol;
								} else if (gridDataObj['report'] == 'notCluster' && mcol == 'Health') {
									image = mcol;
									align = 'center';
								}
								mainColumnArray.push({
									header: image,
									//width: 150,
									align: align,
									locked:isLocked,
									dataIndex: index,
									renderer: function(value,metaData, record,row, col, store,gridView) {
										var href = value['href'];
										if (href != undefined) {
											var val = value['value'];
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
											return '<a class="anchorLinkDefault" href=' + href + '>' + val + '</a>'
										} else {
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
											value= Ext.getCmp('gridId'+i).getDecimalAlignFormat(value);
											return value;
										}
									},
									doSort: function(state) {
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2) {
												if (v1.index == 0)
													return;
												v1 = v1.get(field);
												v2 = v2.get(field);
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v1 = isNaN(v1) ? 0 : v1;
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												v2 = isNaN(v2) ? 0 : v2;
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									}
								});
								fieldstoStore.push(index);
								count++;

							} 
							else 
							{
								mainColumnArray.push({
									header: mcol,
									width: 150,
									locked:false,
									columns: subColumnArray,
									renderer: function(value,metaData, record,row, col, store,gridView) {
										var href = value['href'];
										if (href != undefined) {
											var val = value['value'];
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';	
											return '<a class="anchorLinkDefault" href=' + href + '>' + val + '</a>'
										} else {
											metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
											value = Ext.getCmp('gridId'+i).getDecimalAlignFormat(value);
											return value;
										}
									}
								});
							}
							k++;
						}
						var storeObj = Ext.create('Ext.data.ArrayStore', {
								fields: fieldstoStore,
								data: data,
								remoteSort : true,
								autoLoad : true,
								pageSize:gridPageSize,
								sorters: { property: fieldstoStore[1], direction : 'ASC' },// vengat
						});
						var marginVal = '0 10 10 10';
						if(i==0)
							marginVal = '10 10 10 10';
						var gridpanel = Ext.widget('customgrid', {
								store: storeObj,
								id:'gridId'+i,
								columns: mainColumnArray,
								needtoFixColumn: true,
								//cls: 'gridSkin horizontal-scroll',
								ui:'newGridPanel withHeader withShade',
								//bodyPadding: '0 0 0 0',
								padding:10,
								margin: marginVal,
								border:true,
								title: gridDataObj['title'],
								listeners: {
									render: function(obj) {
										Ext.defer(function() {
														//obj.columns[0].setSortState("ASC",true,true);
											});
										}
									}
								});
								itemsArray.push(gridpanel);
					}
					resultObj.add(itemsArray); resultObj.show(); 
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
			}
		},
		failure : function(response){
			alert(response);
		}
	});
	},
	reportGenChange:function(){
		Ext.getCmp('resultContainer').hide();
		this.disableTools();
		var otherFiltersForm = Ext.getCmp('settings').getForm();
		var reportGenType=otherFiltersForm.findField('reportGeneration').getValue();
		Ext.getCmp('moreOptionCloseId').hide();
		Ext.getCmp('submitViaSetting').show();
		if(reportGenType== 'background'){
			otherFiltersForm.findField('bgReportName').setValue("");
			otherFiltersForm.findField('bgReportName').show();
		}
		else if(reportGenType== 'background-csv'){
			otherFiltersForm.findField('bgReportName').setValue("");
			otherFiltersForm.findField('bgReportName').show();
		}
		else{
			otherFiltersForm.findField('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	timeLineOnChange:function(combo) {
		  var form = this.getVirtualizationmanagerform().getForm();
		//var form = combo.up('form').getForm();
		if (combo.getValue() == 'Any') {
			form.findField('er_enddate').setDisabled(false);
			form.findField('er_endhr').setDisabled(false);
			form.findField('er_sthr').setDisabled(false);
			form.findField('er_stdate').setDisabled(false);
		} else {
			form.findField('er_enddate').setDisabled(true);
			form.findField('er_endhr').setDisabled(true);
			form.findField('er_sthr').setDisabled(true);
			form.findField('er_stdate').setDisabled(true);

			var timeline = form.findField("er_timeline").getValue();
			var strthour = form.findField("er_sthr").getValue();
			var endhr = form.findField("er_endhr").getValue();

			var strtdt = form.findField("er_stdate").getValue();
			var enddt = form.findField("er_enddate").getValue();

			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);

			var no_params = "&P0=[" + timeline + "]&P1=["
							+ strtdt + "]&P2=[" + enddt
							+ "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=["
							+ appConstants.currdtFormat + "]";

			var param = "F=getTime&C=id" + no_params;

			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param,
						scope : this,
						method : 'POST',
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData)) {

								var timedata = jsonData.timeline;
								var startDate = "";
								var endDate = "";
								var starthr = "";
								var endhr = "";
								var startmin = "";
								var endmin = "";
								for (var ctr = 0; ctr < timedata.length; ctr = ctr+ 5) {
									startDate = timedata[0];
									endDate = timedata[1];
									starthr = timedata[2];
									endhr = timedata[3];

									startmin = timedata[4];
									endmin = timedata[5];

								}

							   formated_sdate = Ext.Date.dateFormat(startDate, mgrDateFormat);
							   formated_edate = Ext.Date.dateFormat(endDate, mgrDateFormat);

							   form.findField("er_stdate").setValue(startDate);
							   form.findField("er_enddate").setValue(endDate);
							   form.findField("er_sthr").setValue(starthr);
							   form.findField("er_endhr").setValue(endhr);
							}
						}
					});


			var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
			var msxdays = hiddenFields['getMaxDaysInMonth'];
			var inidate = hiddenFields['inidate'];
			var usertimeline = hiddenFields['er_usertimeline'];

			var bgenabled = hiddenFields['bgenabled'];

			 if (bgenabled == 'Yes' || bgenabled == 'yes') {
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			if(isSettingsEnabled)
					otherFiltersForm = Ext.getCmp('settings').getForm();
			var er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
					var limitforbg = hiddenFields['limitforbg'];

					var bgtime = getTimeValues(limitforbg, msxdays,strtdt, enddt,inidate);
					var getimeline = getTimeValues(timeline, msxdays,strtdt, enddt,inidate);
					var selectbackground = er_reportgenration;
					var bgprocess = false;

					if (getimeline >= bgtime && selectbackground == 'foreground') {

						 form.findField("bgReportName").show();
						 form.findField('reportGeneration').setValue('background');
					}
					else
					{
						form.findField("bgReportName").hide();
						 form.findField('reportGeneration').setValue('foreground');
					}
				}
		}

	},
	/* weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			// excludeDaysObj.update('Excludes '+defaultJSON.screenlabels['MappedExcludeDays']);
			/** by karthikeyan  **/
			//excludeDaysObj.update('Excludes '+defaultJSON['excludeWeekends_value']);
			/** **/
		/*}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	showDescriptor:function(){
		var val=Ext.getCmp('er_showinfo').getValue();
		if(val == 'No'){
			Ext.getCmp('sh_timeinuse').hide();
			Ext.getCmp('info_multiselect').hide();
		}
		else{
			Ext.getCmp('sh_timeinuse').show();
			Ext.getCmp('info_multiselect').show();
		}

	},
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
		this.disableTools();
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools : function(){
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(false);
	},
	updateQueryString:function(){
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var datafrom =mainForm.findField('er_dataFrom').getValue();
		var time = mainForm.findField('er_timeline').getValue();
		var isMetricCombo = mainForm.findField('er_templateEnable').getValue();
		var compArray=new Array();
		var comp_combination='';
		var er_combination ='';
		compArray=Ext.getCmp("er_component").getValue();
		var showInfo=mainForm.findField("er_showinfo").getValue();
		if(publicjsonData.hasOwnProperty('combination')){
			comp_combination=publicjsonData.combination;
		}

		mainFormParams="er_dataFrom="+datafrom
						+"&er_templateEnable="+isMetricCombo
						+"&er_reportType="+mainForm.findField('er_reportType').getValue();

		if(datafrom!= '' && datafrom !='Component')
		{
			if(datafrom == 'Zone'){
				mainFormParams+="&er_dataZone="+mainForm.findField('er_dataZone').getValue();
			}
			mainFormParams+="&er_service="+mainForm.findField('er_service').getValue();
		}
		if(isMetricCombo == 'no')
		{
			mainFormParams+="&er_test="+mainForm.findField('er_test').getValue()+"&er_measure="+mainForm.findField('er_measure').getValue();
		}
		else
		{
			var s_template = mainForm.findField('er_template').getValue();
			if(s_template!=null && s_template != 'null'){
				mainFormParams+="&er_template="+s_template;
				if(s_template != '-1'){
					if(s_template.indexOf(":")>-1)
					var testmeas=s_template.split(":");
					mainFormParams+="&er_test="+testmeas[0];
					mainFormParams+="&er_measure="+testmeas[1];
				}
			}
		}
		for(var k=0;compArray.length>k;k++)
		{
			mainFormParams+="&er_component="+compArray[k];
			er_combination+=comp_combination[compArray[k]]+"##";
		}
		er_combination=encodeURIComponent(er_combination);
		mainFormParams+="&er_combination="+er_combination;

			var otherFiltersForm =null;
		if(isSettingsEnabled)
			otherFiltersForm = Ext.getCmp('settings').getForm();
		var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);

		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);

		settingsFormParams="&er_showinfo="+showInfo
							+"&er_excwe="+execweekend
							+"&er_priority="+Ext.getCmp('er_priority').getValue()
							+"&er_trenddata="+showData
							+"&er_mode="+mainForm.findField('er_mode').getValue()
							+"&er_reportgenration="+er_reportgenration
							+"&er_sortby="+showData;

		if(showInfo!=null && showInfo == 'Yes')
		{
			var infoArray = new Array();
			infoArray = Ext.getCmp('er_info_list').getValue();
			for(var k=0;infoArray.length>k;k++)
			{
				settingsFormParams+="&er_info_list="+infoArray[k];
			}
			settingsFormParams+="&sh_timeinuse="+mainForm.findField('sh_timeinuse').getValue();
		}

		var startDateConverted=mainForm.findField('er_stdate').dataArray;
		var endDateConverted=mainForm.findField('er_enddate').dataArray;

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);
		var timelineParams="&er_timeline="+mainForm.findField("er_timeline").getValue()+"&startdate="+startDateConverted+"&enddate="+endDateConverted+"&starthr="+mainForm.findField('er_sthr').dataArray+"&endhr="+mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

		if(publicjsonData.hasOwnProperty('hiddenfields')){
			var hiddenFields = publicjsonData.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}	
		queryString=mainFormParams+settingsFormParams+timelineParams+defaultParams+hiddenfieldQString+timperiodParams;
	},
	loadComponents:function(){
		var comboObject=Ext.getCmp('er_component');
		comboObject.suspendEvents(true);
		var comboRawData=publicjsonData.componentsCombo;
		var selectedComboOption=publicjsonData.selectedComps;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.resumeEvents();
	},
	loadTests:function(){
		comboObject=Ext.getCmp('er_test');
		comboObject.suspendEvents(true);
		comboRawData=publicjsonData.testCombo;
		selectedComboOption=publicjsonData.selectedTest;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
		comboObject.resumeEvents();
	},

	loadMeasures:function(){
		comboObject=Ext.getCmp('er_measure');
		comboObject.suspendEvents(true);
		comboRawData=publicjsonData.measureCombo;
		selectedComboOption=publicjsonData.selectedMeasure;
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
		comboObject.resumeEvents();
	},
	loadInfos:function(){
		comboObject=Ext.getCmp('er_info_list');
		comboRawData=publicjsonData.infoCombo;
		selectedComboOption=publicjsonData.selectedInfo;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
	},
	loadMetrics:function(){
		comboObject=Ext.getCmp('er_template');
		comboObject.suspendEvents(true);
		comboRawData=publicjsonData.metricsCombo;
		selectedComboOption=publicjsonData.selectedMetrics;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
		comboObject.resumeEvents();
	},
	loadGroups:function()
	{
		comboObject=Ext.getCmp('er_service');
		comboObject.suspendEvents(true);
		comboRawData=publicjsonData.elementsCombo;
		selectedComboOption=publicjsonData.selectedElement;
		comboObject.setFieldLabel(publicjsonData.screenLabels['reporter.common.'+publicjsonData.selectedreportFor]);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
		comboObject.resumeEvents();
	},
	loadSubZone:function(){
		comboObject=Ext.getCmp('er_dataZone');
		comboObject.suspendEvents(true);
		comboRawData=publicjsonData.subZoneCombo;
		selectedComboOption=publicjsonData.selectedsubZone;
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) )
		{
			comboObject.setValue(selectedComboOption);
		}
		else
		{
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboObject.show();
		comboObject.resumeEvents();

	},
	compareOnChange:function(){
		Ext.getCmp('resultContainer').hide();
		var me=this;
		this.disableTools();
		var mainForm = this.getVirtualizationmanagerform().getForm();
		var datafrom =mainForm.findField('er_dataFrom').getValue();
		var showInfo =mainForm.findField('er_showinfo').getValue();
		var isMetricCombo = mainForm.findField('er_templateEnable').getValue();
		var parameters=defaultParams+"&er_dataFrom="+datafrom+"&er_timeline="+mainForm.findField('er_timeline').getValue()+"&er_templateEnable="+isMetricCombo;

		Ext.Ajax.request({
			url : '/final/reporter/ErTopNReportsJson.jsp',
			params :parameters ,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				publicjsonData=jsonData;

				if(datafrom!= '' && datafrom !='Component'){
					mainForm.findField('er_dataZone').hide();
					if(datafrom == 'Zone'){
						me.loadSubZone();
					}
					me.loadGroups();
				}
				else{
					mainForm.findField('er_dataZone').hide();
					mainForm.findField('er_service').hide();
				}

				if(isMetricCombo == 'yes'){
					mainForm.findField('er_test').hide();
					mainForm.findField('er_measure').hide();
					me.loadMetrics();
				}
				else{
					mainForm.findField('er_template').hide();
					me.loadTests();
					me.loadMeasures();
				}
					me.loadComponents();

				if(showInfo == 'Yes'){
					me.loadInfos();
				}
				else{
					mainForm.findField('er_info_list').hide();
				}
			}
		});
	},
	groupOnChange:function(){
		Ext.getCmp('resultContainer').hide();
		var me=this;
	  var mainForm = this.getVirtualizationmanagerform().getForm();
		var showInfo =mainForm.findField('er_showinfo').getValue();
		var isMetricCombo = mainForm.findField('er_templateEnable').getValue();

		this.updateQueryString();
		Ext.Ajax.request({
			url : '/final/reporter/ErTopNReportsJson.jsp',
			params :queryString ,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				publicjsonData=jsonData;
				if(isMetricCombo == 'yes'){
					mainForm.findField('er_test').hide();
					mainForm.findField('er_measure').hide();
					me.loadMetrics();
				}
				else{
					mainForm.findField('er_template').hide();
					me.loadTests();
					me.loadMeasures();
				}
					me.loadComponents();

				if(showInfo == 'Yes'){
					me.loadInfos();
				}
				else{
					mainForm.findField('er_info_list').hide();
				}
			}
		});
	},
	testOnChange:function(){
		Ext.getCmp('resultContainer').hide();
		var me=this;
		var showInfo =Ext.getCmp('er_showinfo').getValue();

		this.updateQueryString();
		Ext.Ajax.request({
			url : '/final/reporter/ErTopNReportsJson.jsp',
			params :queryString ,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				publicjsonData=jsonData;
				me.loadMeasures();
				me.loadComponents();
				if(showInfo == 'Yes'){
					me.loadInfos();
				}
				else{
					Ext.getCmp('er_info_list').hide();
				}
			}
		});
	},
	metricOnChange:function(){
		Ext.getCmp('resultContainer').hide();
		var me=this;
		var showInfo =Ext.getCmp('er_showinfo').getValue();
		this.updateQueryString();
		Ext.Ajax.request({
			url : '/final/reporter/ErTopNReportsJson.jsp',
			params :queryString,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				publicjsonData=jsonData;
				me.loadComponents();
				if(showInfo == 'Yes'){
					me.loadInfos();
				}
				else{
					Ext.getCmp('er_info_list').hide();
				}
			}
		});
	},
	criteriaChange:function(){
		Ext.getCmp('resultContainer').hide();
		var me=this;
	  var mainForm = this.getVirtualizationmanagerform().getForm();
		var showInfo =mainForm.findField('er_showinfo').getValue();
		var isMetricCombo = mainForm.findField('er_templateEnable').getValue();
		this.updateQueryString();
		Ext.Ajax.request({
			url : '/final/reporter/ErTopNReportsJson.jsp',
			params :queryString ,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				publicjsonData=jsonData;
				if(isMetricCombo == 'yes'){
					mainForm.findField('er_test').hide();
					mainForm.findField('er_measure').hide();
					me.loadMetrics();
				}
				else{
					mainForm.findField('er_template').hide();
					me.loadTests();
					me.loadMeasures();
				}
				me.loadComponents();
				if(showInfo == 'Yes'){
					me.loadInfos();
				}
				else{
					mainForm.findField('er_info_list').hide();
				}
			}
		});
	},
	loadHiddenFields: function( data ){
		var mainForm = Ext.getCmp('topnreportsform');
		for ( var key in data ){
			if ( Ext.getCmp(key) == undefined ){
				mainForm.add(
					{
						xtype: 'hidden',
						id: key,
						name: key,
						value: data[key]
					}
				);
			}
			else{
				Ext.getCmp(key).setValue(data[key]);
			}
		}
	},
	trendOnChange : function(combo){

		  var mainForm = this.getVirtualizationmanagerform().getForm();
		var er_trenddata=Ext.getCmp("er_sortby").getValue();
	
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = this.getVirtualizationmanagerform().hiddenFields.inidate;

			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	wrapText : function(value){

		if(value.indexOf(" ")>-1)
		{
			var tmp = value.split(" ");
			var append='';
			for (var i in tmp)
			{
				append += tmp[i];
				if(i<1)
				 append += '<br>';
			}

			return append ;
		}
		else
		{
			return (value+'<br><br>');
		}


	},
	add : function(button) {

		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
						title : 'Virtualization Reports',
						msg : 'Chosen timeline not allowed',
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				return;
		}
		 var mainForm = this.getVirtualizationmanagerform().getForm();


		var er_type = mainForm.findField('er_type').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var select_group = mainForm.findField('select_group').getValue();
		var includezones = mainForm.findField('includezones').getValue();
		var zones = mainForm.findField('zones').getValue();
		var services = mainForm.findField('services').getValue();
		var components = Ext.getCmp('components').getValue();
		var select_sort = mainForm.findField('select_sort').getValue();
		var er_measure = mainForm.findField('er_measure').getValue();
		var time = mainForm.findField('er_timeline').getValue();

		var select_groupName = ''

		if(select_group == 'Zone'){
			select_groupName=mainForm.findField('zones').getValue();
		}
		else if(select_group == 'Segment'){
			select_groupName=mainForm.findField('segments').getValue();
		}
		else if(select_group == 'Service'){
			select_groupName=mainForm.findField('services').getValue();
		}

		if(er_measure!=null && er_measure=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'please choose the measure',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}

		if(select_sort!=null && select_sort=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}

		if(components!=null && components=='-1')
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Please choose a required parameters',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
					   });
			return;
		}


			var otherFiltersForm =null;
		if(isSettingsEnabled)
			otherFiltersForm = Ext.getCmp('settings').getForm();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var er_mode = mainForm.findField('er_mode').getValue();

		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");


		var hiddenFields = this.getVirtualizationmanagerform().hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
		}
		 param+='select_group='+select_group+'&includeSubZone='+includezones;

		if(er_type!=null && er_type=='No')
		{
			var checkboxobj = mainForm.findField('checkboxgroup')

			 if(checkboxobj.getComponent(1).getValue())
			 {
				param += '&select_sort=Virtual_Center';
			 }
			 if(checkboxobj.getComponent(0).getValue())
			 {
				 param += '&select_sort=Virtual_Center_Cluster';
			 }
			 if(checkboxobj.getComponent(2).getValue())
			 {
				param += '&select_sort=Virtual_Center_Host';
			 }
		}
		else
		{
			//param+='&select_sort=Virtual_Center_Cluster';
			param+='&select_sort='+select_sort;
		}



		param+='&er_measure='+er_measure+'&er_type='+er_type+'&er_comptype='+er_comptype;

		if(select_group=='Component')
		{
			for (var j = 0; j < components.length; j++) {
				param += "&select_groupName=" + components[j];
			}
		}
		else
		{
			param +='&select_groupName='+select_groupName;
		}
		var showData =this.getSettingsFieldValue(otherFiltersForm,'er_sortby',isSettingsEnabled,'showDataComboArray_value',false);
		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var beanstartdate = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var beanenddate = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"dd-MM-yyyy");
		var er_mode = mainForm.findField('er_mode').getValue();

		param +='&beanstartdate='+beanstartdate+'&beanenddate='+beanenddate+'&inszone='+includezones+'&select_farm='+select_groupName;

		var execweekend = this.getSettingsFieldValue(otherFiltersForm,'er_excwe',isSettingsEnabled,'excludeWeekends_value',false);

		var timefrom =this.getSettingsFieldValue(otherFiltersForm,'timefrom',isSettingsEnabled,'Hourfrom',true);
		var timeto =this.getSettingsFieldValue(otherFiltersForm,'timeto',isSettingsEnabled,'Minfrom',true);
		var minfrom =this.getSettingsFieldValue(otherFiltersForm,'minfrom',isSettingsEnabled,'Hourto',true);
		var minto =this.getSettingsFieldValue(otherFiltersForm,'minto',isSettingsEnabled,'Minto',true);


		param +='&er_excwe='+execweekend;
		param += '&timefrom=' + timefrom
				+ '&timeto=' + timeto + '&minfrom=' + minfrom + '&minto='
				+ minto+'&er_trenddata='+showData+'&er_mode='+er_mode;


	param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID;//+'&eruserid='+appConstants.userID;

	 var er_reportgenration =this.getSettingsFieldValue(otherFiltersForm,'reportGeneration',isSettingsEnabled,'reportgenCombo_value',false);

		param+='&er_reportgenration='+er_reportgenration+"&pageWidthProces="+appConstants.pageWidth;


	    var url = "";
  		var from_schedule = hiddenFields['fromScheduleModify'];
	
	
        if (button.getId() == "scheduleImg" || button.getItemId() == "save" && (from_schedule != null && from_schedule == "Yes"))
		{
			url = "/final/reporter/ErSaveSchedule.jsp?" + param+"&com.eg.CSRF_NONCE="+csrfToken;
			if (button.getItemId() == "save")
			{
				document.location=url+'&showSchWindow=no';
			} else
				parent.scheduleWindowFn(url);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		}
		else
		{
			var favorite_id = hiddenFields["favorite_id"];
			url = "../servlet/com.eg.ErFavoriteC?&er_view=GRAPH&cmd=client&" + param+"&er_RmDispName="+appConstants.er_RmDispName+'&com.eg.CSRF_NONCE='+csrfToken;
			//var  target="../servlet/com.eg.ErFavoriteC?"+"&er_view=GRAPH&cmd=client";
			if (button.getItemId() == "save")
			{
				document.location=url+'&showSchWindow=no'+'&FavoriteId='+favorite_id;
			} else
				parent.favouriteWindowFn(url);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}       
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam,isTimePeriod)
	{
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(isTimePeriod)
				value = defaultJSON.timeline.timePeriod[jsonParam];
			else
				value = defaultJSON.timeline[jsonParam];
		}

		return value;
	}
	});

