var runner = new Ext.util.TaskRunner();
var task = runner.newTask({
	run: function()
	{
		Ext.getCmp('resendCode').show();
		task.stop();
	},
	interval: 20000 // run for every 20 secs
});

// for IE support startsWith and endsWith function overrides
if (!String.prototype.startsWith) 
{
	String.prototype.startsWith = function (searchString, position) {
		position = position || 0;
		 return this.substr(position, searchString.length) === searchString;
	};
}

if (!String.prototype.endsWith)
{
	String.prototype.endsWith = function(search, this_len) {
		if (this_len === undefined || this_len > this.length) {
			this_len = this.length;
		}
		return this.substring(this_len - search.length, this_len) === search;
	};
}
Ext.define('login.controller.Login', {
	extend:'Ext.app.Controller',

	view:[
		'login.view.TwoFALoginPage',
		'login.view.GoogleAuthLoginPage'
	],

	refs:[
		{selector:'main',ref:'main'},
		{selector:'loginform',ref:'loginform'},
		{selector:'commonpopup',ref:'commonpopup'},
		{selector:'rolepopup',ref:'rolepopup'},
		{selector:'scrollcombo',ref:'scrollcombo'},
		{selector:'twofaloginpage',ref:'twofaloginpage'},
		{selector:'googleauthloginpage',ref:'googleauthloginpage'}
	],
	screenLabels:null,
	viewName : 'login',
	init:function(){
		thisCtrl = this;
		this.control({
				'loginform ':{
				 afterrender:this.submitForm,
				 fieldvaliditychange:this.onFormFieldValidityChange,
				 fielderrorchang:this.onFormFieldErrorChange
				},
				'loginform button[action=submit]':{
					'click':this.valform
				},
				'loginform' : {
					'afterrender':this.OnKeyupvalform
				},
				'loginform > #forgotpass':{
					'click':this.loadForgotpassword
				},
				'loginform > #loginpage':{
					'click':this.loadLoginPage
				},
				'loginform button[action=getpassword]':{
					'click':this.getPassword
				},
				'loginform textfield[id=username]':{
					'blur':this.changeDomain
				},
				'loginform combo[id=domainCombo]':{
					'select':this.doDomainChangeEvents
				},
				'loginform combo[id=loginTypeCombo]':{
					'select':this.loginTypeChangeEvents
				},
				'main' : {
					'resize' : this.showUserTips
				},
				'main' : {
					'afterrender':this.navigateToMFAUI
				}
			});
	},
	loginTypeChangeEvents :  function(obj)
	{
		var thisForm = this.getLoginform().getForm();
		//		thisForm.findField('domainCombo').setValue("eG Enterprise");
		var loginType = obj.getValue();
		if (!Ext.isEmpty(loginType) && loginType == 'SAML')
		{
			thisForm.findField('username').hide();
			thisForm.findField('password').hide();
			thisForm.findField('domainCombo').hide();
			Ext.get('f_pass').hide();

			Ext.getCmp('errorState').hide();

			Ext.get('idpCombo').show();
			thisForm.findField('idpCombo').focus();

			thisForm.findField('idpCombo').getStore().loadRawData(publicJson.configuredIdp);
			if (!Ext.isEmpty(strDefaultLoginIdp))
			{
				thisForm.findField("idpCombo").setValue(strDefaultLoginIdp);
			}
			else
			{
				if (!Ext.isEmpty(publicJson.idpCombobox_value))
				{
					thisForm.findField("idpCombo").setValue(publicJson.idpCombobox_value);
				}
				else
				{
					thisForm.findField("idpCombo").setValue(thisForm.findField("idpCombo").getStore().getAt(0));
				}
			}
			Ext.getCmp('submit').setText('Sign in');
			Ext.get('f_pass').hide();

			var  errorCmp = Ext.getCmp('errorState');

			//if (!Ext.isEmpty(idpResponse) && idpResponse == "succeed")
			//{
				//var errorText = 'The username does not exist in the manager database';

				//var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';
				//errorCmp.setErrors(htm1);
				//errorCmp.show();
			//}
			//else
			{
				if (!Ext.isEmpty(errorCmp) && errorCmp.isVisible())
				{
					errorCmp.hide();
				}
			}
			Ext.getCmp('loginform').doLayout();
		}
		else if (!Ext.isEmpty(loginType) && loginType == 'Domain')
		{
			thisForm.findField('username').show();
			thisForm.findField('username').setValue('');
			thisForm.findField('password').show();
			thisForm.findField('password').setValue('');
			thisForm.findField('domainCombo').show();

			if (hasDefaultDomain)
			{
				if (!Ext.isEmpty(defaultDomain))
				{
					thisForm.findField("domainCombo").setValue(defaultDomain);
				}
				else
				{
					thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
				}
			}
			else
			{
				thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
			}

			Ext.get('f_pass').hide();

			Ext.getCmp('errorState').hide();

			Ext.get('idpCombo').hide();
			Ext.getCmp('loginform').doLayout();

		}
		else
		{

			thisForm.findField('username').show();
			thisForm.findField('username').setValue('');

			thisForm.findField('password').show();
			thisForm.findField('password').setValue('');
			thisForm.findField('domainCombo').hide();
			Ext.get('f_pass').show();

			Ext.getCmp('errorState').hide();

			Ext.get('idpCombo').hide();

			Ext.getCmp('loginform').doLayout();
		}
	},
	doDomainChangeEvents : function(obj)
	{
		if(obj.getValue()=="eG Enterprise")
		{
			Ext.get('f_pass').show();
		}
		else
		{
			Ext.get('f_pass').hide();
		}
	},
	changeDomain : function(obj)
	{
		if (domainsConfigured != null && domainsConfigured == true)
		{
			var thisForm = this.getLoginform().getForm();
			var value = obj.getValue().toLowerCase();
			if (publicJson.hasLocalAuthentication)
			{
				if(value == "admin" || value == "supermonitor" || value == "egsm" || value == 'egenterprise')
				{
					thisForm.findField('domainCombo').setValue("eG Enterprise");
					thisForm.findField('domainCombo').hide();
					thisForm.findField('loginTypeCombo').setValue("eG Enterprise");
				}
				var getDomainValueStr = thisForm.findField("loginTypeCombo").getValue();
				if (getDomainValueStr == "eG Enterprise")
				{
					Ext.get('f_pass').show();
				}
				else
				{
					Ext.get('f_pass').hide();
				}
			}
		}
	},
	onFormFieldValidityChange : function(){
		 this.updateErrorState();
	},
	onFormFieldErrorChanges : function (){
		 this.updateErrorState();
	},
	 updateErrorState: function() {
        var me = this.getLoginform(),
        errorCmp, fields, errors;

        if (me.hasBeenDirty || me.getForm().isDirty()) { //prevents showing global error when form first loads
			errorCmp = me.down('formErrorState');
            fields = me.getForm().getFields();
            errors = [];

            fields.each(function(field) {

                Ext.Array.forEach(field.getErrors(), function(error) {
                    errors.push({name: field.getFieldLabel(), error: error});
                });
            });

            me.hasBeenDirty = true;
        }
    },
	submitForm : function(from)
	{
		if (strFBLgoin)
		{
			var thisForm = this.getLoginform().getForm();

			if (!Ext.isEmpty(thisForm.findField("loginTypeCombo")) && thisForm.findField("loginTypeCombo").isVisible())
			{
				thisForm.findField("loginTypeCombo").hide();
			}
			if (!Ext.isEmpty(thisForm.findField("domainCombo")) && thisForm.findField("domainCombo").isVisible())
			{
				thisForm.findField("domainCombo").hide();
			}
			if (!Ext.isEmpty(thisForm.findField("idpCombo")) && thisForm.findField("idpCombo").isVisible())
			{
				thisForm.findField("idpCombo").hide();
			}

			if(nonDomainUser==null || nonDomainUser=="" || nonDomainUser=="null")
			{
				if(usrName!=null && usrName!="null" && usrName!="" && usrName.indexOf("/Grp/") == -1 && usrName.indexOf("/") == -1)
				{
					nonDomainUser=usrName;
				}
			}
			thisForm.findField('username').setValue(nonDomainUser);

			var sessTimeOut = localStorage.getItem('fromST');
			if (!Ext.isEmpty(sessTimeOut) && sessTimeOut=='login')
			{
				localStorage.setItem('fromST','complete');
				if (key != 'null' && !Ext.isEmpty(key))
				{
					thisForm.findField('password').setValue(key);
					thisCtrl.valform();
				}
				else
				{
					thisForm.findField('password').focus();
				}
			}
			else
			{
				var errorCmp = Ext.getCmp('errorState');
				if (!Ext.isEmpty(errorCmp) && errorCmp.isVisible())
				{
					errorCmp.hide();
				}

				if(!Ext.isEmpty(errText) && errText!='none')
				{
					var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';

					if (errText.indexOf("You have been logged out") != -1)
					{
						htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconInformation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';
					}
					errorCmp.setErrors(htm1);
					errorCmp.show();
				}
			}
		}
		else
		{
			var isLoggingFrom = 'eG Enterprise';
			//if (!Ext.isEmpty(loggedInIdp))
			//{
				//isLoggingFrom = "SSO";
			//}
			//else if (!Ext.isEmpty(loggedInDomain) && loggedInDomain != "eG Enterprise")
			//{
				//isLoggingFrom = "Domain";
			//}

			if (!Ext.isEmpty(strDefaultAuthType))
			{
				isLoggingFrom = strDefaultAuthType;
			}
			else
			{
				if (!Ext.isEmpty(loggedInIdp))
				{
					isLoggingFrom = "SAML";
				}
				else if (!Ext.isEmpty(loggedInDomain) && loggedInDomain != "eG Enterprise")
				{
					isLoggingFrom = "Domain";
				}
			}

			if (!Ext.isEmpty(from) && from == 'forgotpass')
			{
				isLoggingFrom = 'eG Enterprise';
			}

			Ext.Ajax.request({
				url:'/final/scripts/LoginApp/data/EgLoginService.jsp',
				scope:this,
				method: 'POST',
				params:
				{
					"loggedInDomain":filterEncode(loggedInDomain),
					"loggedInIdp":filterEncode(loggedInIdp),
					"isLoggingFrom":filterEncode(isLoggingFrom),
					"idpResponse":filterEncode(idpResponse),
				},
				timeout: 300000,
				standardSubmit: false,
				async:false,
				success: function(response){
					var jsonText = response.responseText;
					var jsondata = Ext.decode(jsonText);

					publicJson = jsondata;
					var screenLabels = jsondata.screenlabels;
					this.screenLabels = screenLabels;
					var domain = jsondata.configuredDomains;
					var loginTypes = jsondata.loginTypesArr;
					var selectedAuthType = jsondata.isLoggingFrom;
					var hasMultiLoginTypes = jsondata.hasMultiLoginTypes;
					var loggedInDomain = jsondata.loggedInDomain;

					var thisForm = this.getLoginform().getForm();
					var me = this;
					if (hasMultiLoginTypes)
					{
						thisForm.findField("loginTypeCombo").getStore().loadRawData(loginTypes);
						thisForm.findField("domainCombo").getStore().loadRawData(domain);
						var  errorCmp = Ext.getCmp('errorState');

						if (!Ext.isEmpty(selectedAuthType))
						{
							thisForm.findField("loginTypeCombo").setValue(selectedAuthType);
							thisForm.findField("loginTypeCombo").fireEvent('select',thisForm.findField("loginTypeCombo"));
						}
						else
						{
							thisForm.findField("loginTypeCombo").setValue(thisForm.findField("loginTypeCombo").getStore().getAt(0));
						}

						if (!Ext.isEmpty(idpResponse) && idpResponse == "succeed")
						{
							var errorText = 'The username does not exist in the manager database';

							var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';
							errorCmp.setErrors(htm1);
							errorCmp.show();
						}
						else
						{
							if (!Ext.isEmpty(errorCmp) && errorCmp.isVisible())
							{
								errorCmp.hide();
							}
						}
						thisForm.findField('username').labelEl.dom.innerHTML = screenLabels['username'];
						thisForm.findField('username').focus();
						thisForm.findField('password').labelEl.dom.innerHTML = screenLabels['password'];
						thisForm.findField('domainCombo').hide();
						if (!Ext.isEmpty(selectedAuthType) && selectedAuthType == 'Domain')
						{
							if (hasDefaultDomain)
							{
								if (!Ext.isEmpty(defaultDomain))
								{
									thisForm.findField("domainCombo").setValue(defaultDomain);
									thisForm.findField('username').setValue('');
								}
								else
								{
									if (loggedInDomain != null && !Ext.isEmpty(loggedInDomain))
									{
										if (selectedAuthType.toLowerCase() != isLoggingFrom.toLowerCase())
										{
											thisForm.findField('username').setValue('');
										}
										else
										{
											thisForm.findField('username').setValue(nonDomainUser);
										}
										thisForm.findField("domainCombo").setValue(loggedInDomain);

									}
									else
									{
										if(nonDomainUser==null || (nonDomainUser=="" || nonDomainUser=="null"))
										{
											if(usrName!=null && usrName!="null" && usrName!="")
											{
												nonDomainUser = usrName;
											}
										}
										if (selectedAuthType.toLowerCase() != isLoggingFrom.toLowerCase())
										{
											thisForm.findField('username').setValue('');
										}
										else
										{
											thisForm.findField('username').setValue(nonDomainUser);
										}
										thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
									}
								}
							}
							else
							{
								if (loggedInDomain != null && !Ext.isEmpty(loggedInDomain))
								{
									if (selectedAuthType.toLowerCase() != isLoggingFrom.toLowerCase())
									{
										thisForm.findField('username').setValue('');
									}
									else
									{
										thisForm.findField('username').setValue(nonDomainUser);
									}
									thisForm.findField("domainCombo").setValue(loggedInDomain);
								}
								else
								{
									if(nonDomainUser==null || (nonDomainUser=="" || nonDomainUser=="null"))
									{
										if(usrName!=null && usrName!="null" && usrName!="")
										{
											nonDomainUser = usrName;
										}
									}
									if (selectedAuthType.toLowerCase() != isLoggingFrom.toLowerCase())
									{
										thisForm.findField('username').setValue('');
									}
									else
									{
										thisForm.findField('username').setValue(nonDomainUser);
									}
									thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
								}
							}
							if (thisForm.findField("domainCombo").isHidden())
							{
								thisForm.findField("domainCombo").show();
							}

						}
						else if (!Ext.isEmpty(selectedAuthType) && selectedAuthType == 'eG Enterprise')
						{
							if(nonDomainUser==null || (nonDomainUser=="" || nonDomainUser=="null"))
							{
								if(usrName!=null && usrName!="null" && usrName!="")
								{
									nonDomainUser = usrName;
								}
							}

							if (!Ext.isEmpty(from) && from == 'forgotpass')
							{
								thisForm.findField('username').setValue('');
							}
							else
							{
								if (selectedAuthType.toLowerCase() != isLoggingFrom.toLowerCase())
								{
									thisForm.findField('username').setValue('');
								}
								else
								{
									thisForm.findField('username').setValue(nonDomainUser);
								}
							}
						}

						if(enableFTL && !isUserLoggingFirstTime)
						{
							var htm='<div id="f_pass" style="cursor:pointer;text-decoration:underline;font-size:11px;line-height:1.2em"> '+screenLabels['ForgotPassword']+'?</div>';
							Ext.getCmp("forgotpass").update(htm);
							Ext.get("f_pass").on('click',function(){
										me.loadForgotpassword();
									}
								);
						}
						else
						{
							var htm='<div style="cursor:pointer;text-decoration:underline;font-size:11px;line-height:1.2em" id="f_pass" >'+screenLabels['ForgotPassword']+'?</div>';
							Ext.getCmp("forgotpass").update(htm);
							Ext.get("f_pass").on('click',function(){
								me.loadForgotpassword();
								}
							);
						}

						var getAuthTypeValue = thisForm.findField("loginTypeCombo").getValue();
						if (getAuthTypeValue == "eG Enterprise")
						{
							Ext.get('f_pass').show();
						}
						else
						{
							Ext.get('f_pass').hide();
						}

						if(!Ext.isEmpty(errText) && errText!='none')
						{
							var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';

							if (errText.indexOf("You have been logged out") != -1)
							{
								htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconInformation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';
							}
							Ext.getCmp('errorState').setErrors(htm1);
							Ext.getCmp('errorState').show();
						}

						if (!Ext.isEmpty(eGMgrModel) && eGMgrModel.toLowerCase() == 'msp')
						{
							if (!Ext.isEmpty(thisForm.findField("loginTypeCombo")) && thisForm.findField("loginTypeCombo").isVisible())
							{
								thisForm.findField("loginTypeCombo").hide();
							}
							if (!Ext.isEmpty(thisForm.findField("domainCombo")) && thisForm.findField("domainCombo").isVisible())
							{
								thisForm.findField("domainCombo").hide();
							}
							if (!Ext.isEmpty(thisForm.findField("idpCombo")) && thisForm.findField("idpCombo").isVisible())
							{
								thisForm.findField("idpCombo").hide();
							}
						}
					}
					else
					{

						thisForm.findField('username').labelEl.dom.innerHTML = screenLabels['username'];
						thisForm.findField('username').focus();
						thisForm.findField('password').labelEl.dom.innerHTML = screenLabels['password'];

						if (!Ext.isEmpty(thisForm.findField("loginTypeCombo")) && thisForm.findField("loginTypeCombo").isVisible())
						{
							thisForm.findField("loginTypeCombo").hide();
						}
						if (!Ext.isEmpty(thisForm.findField("domainCombo")) && thisForm.findField("domainCombo").isVisible())
						{
							thisForm.findField("domainCombo").hide();
						}
						if (!Ext.isEmpty(thisForm.findField("idpCombo")) && thisForm.findField("idpCombo").isVisible())
						{
							thisForm.findField("idpCombo").hide();
						}

						//thisForm.findField("domainCombo").getStore().loadRawData(domain);
						//if (loggedInDomain != null && !Ext.isEmpty(loggedInDomain))
						//{
							//thisForm.findField('username').setValue(loggedOutUser);
							//if (loggedInDomain != "eG Enterprise")
							//{
								//thisForm.findField("domainCombo").setValue(loggedInDomain);
							//}
							//else
							//{
								//thisForm.findField('username').setValue(nonDomainUser);
								//thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
							//}
						//}
						//else
						//{
							if(nonDomainUser==null || (nonDomainUser=="" || nonDomainUser=="null"))
							{
								if(usrName!=null && usrName!="null" && usrName!="")
								{
									nonDomainUser=usrName;
								}
							}
							thisForm.findField('username').setValue(nonDomainUser);
							//if (hasDefaultDomain !=null && hasDefaultDomain==true)
							//{
								//thisForm.findField("domainCombo").setValue(defaultDomain);
							//}
							//else
							//{
								//thisForm.findField("domainCombo").setValue(thisForm.findField("domainCombo").getStore().getAt(0));
							//}
						//}

					var me = this;
						if(enableFTL && !isUserLoggingFirstTime)
						{
							var htm='<div id="f_pass" style="cursor:pointer;text-decoration:underline;font-size:11px;line-height:1.2em"> '+screenLabels['ForgotPassword']+'?</div>';
							Ext.getCmp("forgotpass").update(htm);
							Ext.get("f_pass").on('click',function(){
										me.loadForgotpassword();
									}
								);
						}
						else
						{
							//Ext.getCmp("forgotpass").setText(+"?");
							var htm='<div style="cursor:pointer;text-decoration:underline;font-size:11px;line-height:1.2em" id="f_pass" >'+screenLabels['ForgotPassword']+'?</div>';
							Ext.getCmp("forgotpass").update(htm);
							Ext.get("f_pass").on('click',function(){
								me.loadForgotpassword();
								}
							);
						}
						
						Ext.get('f_pass').show();
						if(!Ext.isEmpty(errText) && errText!='none')
						{
							var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';

							if (errText.indexOf("You have been logged out") != -1)
							{
								htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconInformation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errText+'</td></tr></table>';
							}
							Ext.getCmp('errorState').setErrors(htm1);
							Ext.getCmp('errorState').show();
						}
					}
				}
			});
			var userNameStr = this.getLoginform().getForm().findField('username').getValue();
			if (!Ext.isEmpty(userNameStr))
			{
				if (key != 'null' && !Ext.isEmpty(key))
				{
					if (domainsConfigured == true)
					{
						if (authenTypeStr != 'null' && !Ext.isEmpty(authenTypeStr) && authenTypeStr == 'Domain')
						{
							this.getLoginform().getForm().findField('loginTypeCombo').setValue(authenTypeStr);
							this.getLoginform().getForm().findField('password').setValue(key);
							if (!Ext.isEmpty(domainComboStr))
							{
								this.getLoginform().getForm().findField('domainCombo').setValue(domainComboStr);
							}
							else if (!Ext.isEmpty(idpComboStr))
							{
								this.getLoginform().getForm().findField('idpCombo').setValue(idpComboStr);
							}
						}
						else
						{
							this.getLoginform().getForm().findField('password').setValue(key);
						}
					}
					else
					{
						this.getLoginform().getForm().findField('password').setValue(key);
					}
					thisCtrl.valform();
				}
				else
				{
					this.getLoginform().getForm().findField('password').focus();
				}
			}
		}
	},
	valIdp : function()
	{
		var thisForm = this.getLoginform().getForm();
		var idpStr=thisForm.findField("idpCombo").getValue();
		window.location ="/final/arq?idp="+idpStr;
	},

	valform : function()
	{
		var thisForm = this.getLoginform().getForm();
		var authenType = thisForm.findField("loginTypeCombo").getValue();
		var username=thisForm.findField("username").getValue();
		var password=thisForm.findField("password").getValue();
		var eKey = password;
		if (hasAuthenTypeCombo)
		{
			if (!Ext.isEmpty(authenType) && authenType == 'SAML')
			{
				this.valIdp();
				return false;
			}
		}

		if(username!=null && username=='')
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				msg: emptyUserNameAlert+'.',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
			// else if(!checkSpecialChars(username,"=\""))
		else if(!checkSpecialChars(username,'="/'))
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				msg:_checkspecial+'.',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			thisForm.findField("username").focus();
			return false;
		}
		else if (username.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				msg:_checkdots+'.',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(trim(username) == "")
		{
			thisForm.findField("username").focus();
		}
		else if (username.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				msg:_checkSpaces+'.',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!checkblank(password))// && (username.indexOf("/") == -1 && username.indexOf("\\") == -1))
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				 msg:emptyPasswordAlert+'.',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			thisForm.findField("password").focus();
			return false;
		}
		else  if(password!=null && password=='')
		{
			Ext.Msg.show({
				title:loginAlertTitle,
				 msg: emptyPasswordAlert,
				buttons: Ext.Msg.OK+'.',
				icon: 'iconExclamation'
			 });
			thisForm.findField("password").focus();
			return false;
		}
		else
		{
			if (fromST == 'null' || Ext.isEmpty(fromST))
			{
				password = filterEncode(password);
			}
			Ext.Ajax.request({
				url:'/final/scripts/LoginApp/data/encval.jsp',
				method: 'POST',
				params:
				{
					"key":password,
					"fromST":fromST
				},
				standardSubmit: false,
				timeout: 300000,
				async: false,
				success: function(response)
				{
					if(response.status == 200)
					{
						var publicJSON = Ext.decode(response.responseText);
						eKey = publicJSON['eKey'];
						
						if (hasAuthenTypeCombo)
						{
							if (!Ext.isEmpty(authenType) && authenType == 'Domain')
							{
								if (thisForm.findField("domainCombo") != null && thisForm.findField("domainCombo") != "undefined" && !thisForm.findField("domainCombo").isDisabled())
								{
									var userLogging=thisForm.findField("domainCombo").getValue();
									if (userLogging != null && userLogging != "eG Enterprise")
									{
										username = userLogging +"/"+username;
									}
								}
							}
						}
						else
						{
							if (thisForm.findField("domainCombo") != null && thisForm.findField("domainCombo") != "undefined" && !thisForm.findField("domainCombo").isDisabled())
							{
								var userLogging=thisForm.findField("domainCombo").getValue();
								if (userLogging != null && userLogging != "eG Enterprise")
								{
									username = userLogging +"/"+username;
								}
							}
						}
						
						if(thisCtrl.validateForm(thisForm))
						{
							thisCtrl.verifyingForm(username+"~!~"+eKey);
						}
					}
				},
				failure: function(response)
				{
					if(response.status == 403)
					{
						var domainCombo = thisForm.findField("domainCombo").getValue();
						var idpCombo = thisForm.findField("idpCombo").getValue();
						var url = "/final/eglgn?userName="+username+"&pass="+password+"&fromST=login";

						var pathname = window.location.pathname;
						if (pathname.endsWith("fblgn"))
						{
							localStorage.setItem('fromST','login');
							url = "/final/fblgn?userName="+username+"&pass="+password+"&fromST=login"
							postCustomFormSubmit(url);
						}
						else
						{
							if (!Ext.isEmpty(authenType) && authenType.toLowerCase() == 'domain')
							{
								url += "&authenType="+authenType+"&domainCombo="+domainCombo+"&idpCombo="+idpCombo;
							}
							postCustomFormSubmit(url);
						}
					}
				}
			});
		}
	},
	validateForm:function(form){
		// validation Scripts need to go here
		return true;
	},
	OnKeyupvalform: function(view, options){
        Ext.EventManager.on(view.getEl(), 'keyup', function(evt, t, o) {
            if (evt.keyCode === Ext.EventObject.ENTER) {
				if(this.viewName!=null && this.viewName=="login")
				{
					if(this.valform()==true)
					{
						 var thisForm = this.getLoginform().getForm();
						var authenType=thisForm.findField("loginTypeCombo").getValue();
						var username=thisForm.findField("username").getValue();
						var password=thisForm.findField("password").getValue();
						if (hasAuthenTypeCombo)
						{
							if (!Ext.isEmpty(authenType) && authenType == 'Domain')
							{
								if (thisForm.findField("domainCombo") != null && thisForm.findField("domainCombo") != "undefined" && !thisForm.findField("domainCombo").isDisabled())
								{
									var userLogging=thisForm.findField("domainCombo").getValue();
									if (userLogging != null && userLogging != "eG Enterprise")
									{
										username = userLogging +"/"+username;
									}
								}
							}
						}
						else
						{
							if (thisForm.findField("domainCombo") != null && thisForm.findField("domainCombo") != "undefined" && !thisForm.findField("domainCombo").isDisabled())
							{
								var userLogging=thisForm.findField("domainCombo").getValue();
								if (userLogging != null && userLogging != "eG Enterprise")
								{
									username = userLogging +"/"+username;
								}
							}
						}

						var validEmail = 'true';
						var eKey = password;
						password = filterEncode(password);
						Ext.Ajax.request({
							url:'/final/scripts/LoginApp/data/EgValidateJson.jsp',
							method: 'POST',
							params:{"uname":username,
									"key":password},
							standardSubmit: false,
							timeout: 300000,
							async: false,
							success: function(response)
							{
								if(response.status == 200)
								{
									var publicJSON = Ext.decode(response.responseText);
									eKey = publicJSON['eKey'];
									if (publicJSON['validEmal'] == 'false')
									{
										validEmail = publicJSON['validEmal'];
									}
								}
							}
						});
						if (validEmail == 'false')
						{
							Ext.Msg.show({
								title:loginAlertTitle,
								 msg: 'You are not authorized to sign in!',
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							 });
							thisForm.findField("username").focus();
							return false;
						}
						this.verifyingForm(username+"~!~"+eKey);
					}
				}
				else if(this.viewName!=null && this.viewName=="forgotPassword")
				{
						this.getPassword();
				}

			} else if (evt.keyCode === Ext.EventObject.DOWN){
				//console.log('down key pressed');
			}
		}, this);
		if(!Ext.isEmpty(logoMessage))
		{
			var msgLblContainer = Ext.getCmp("custom_msg_container");
			if(!Ext.isEmpty(msgLblContainer))
			{
				var msgLbl = Ext.get("custom_msg_div");
				msgLbl.update(logoMessage);
				msgLblContainer.show();
			}
		}
    },
    verifyingForm : function (v)
	{
    	if(v!=null && !Ext.isEmpty(v))
		{
			var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
            if(!Ext.isEmpty(Ext.getCmp('errorState')))
			{
				Ext.getCmp('errorState').setErrors('');
				Ext.getCmp('errorState').show();
			}
    		var myarr = v.split("~!~");
			var tempUsrName = myarr[0];
			var tempUsrPwd = myarr[1];
    		var  loadmask = new Ext.LoadMask(Ext.getCmp("errorState"), {
				msg : "Signing in..."
			});
			loadmask.show();
			var meThis=this;
    		Ext.Ajax.request({
    		 	url:'/final/servlet/com.egurkha.LoginServlet',
    		 	params:'uname='+encodeURIComponent(myarr[0])+'&upass='+encodeURIComponent(myarr[1])+'&userTimeZoneDate='+filterEncode(encodeURIComponent(userTZDate)),
    		 	scope:this,
				timeout: 120000,
    		 	success:function(response)
				{
					loadmask.hide();
					var v = response.responseText;
					var myarr = v.split(":");
					var resultPg = v.split("~$~");
					if(myarr[0]=="Error")
					{
						var pathname = window.location.pathname;
						if (pathname.endsWith("eglgn"))
						{
							var stateObj_admin = { foo: 1000 + Math.random()*1001 };
							history.pushState(stateObj_admin, "....", "/final/#!");
						}

						var thisForm = this.getLoginform().getForm();
						var  errorCmp = Ext.getCmp('errorState');
						var errorText = myarr[1];
						if (errorText != null && ((errorText.indexOf("The password is incorrect") != -1) || (errorText.indexOf("password may be incorrect") != -1)))
						{
							var password=thisForm.findField("password").getValue();

						}
						var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';

						errorCmp.setErrors(htm1);
						errorCmp.show();
					}
					else if (v == "/final/admin/egGroupUserEntry.jsp" || 
						v == "/final/admin/egGroupUserEntry.jsp?loginThruParent=true" ||
						v == "/final/admin/egGroupUserEntry.jsp?isTrustDomainGrpAvail=true")
					{
						var pathname = window.location.pathname;
						if (pathname.endsWith("eglgn"))
						{
							var stateObj_admin = { foo: 1000 + Math.random()*1001 };
							history.pushState(stateObj_admin, "....", "/final/#!");
						}
						this.loadGropulistUsers(v);
					}
					else if (v == "/admin/MoreUserRoles.jsp")
					{
						var pathname = window.location.pathname;
						if (pathname.endsWith("eglgn"))
						{
							var stateObj_admin = { foo: 1000 + Math.random()*1001 };
							history.pushState(stateObj_admin, "....", "/final/#!");
						}
						v = '/final'+v;
						this.loadMoreUserRole(v);
					}
					// 2FA code starts here
					else if (v.startsWith('fwdToGoogleAuthLoginPage'))
					{
						var pathname = window.location.pathname;
						if (pathname.endsWith("eglgn") || pathname.endsWith("fblgn"))
						{
							var stateObj_admin = { foo: 1000 + Math.random()*1001 };
							history.pushState(stateObj_admin, "....", "/final/#!");
							//window.history.pushState({stateObj_admin, "....", "/final");
						}

						Ext.suspendLayouts();
						Ext.getCmp('loginFormCnt').removeAll();
						Ext.getCmp('loginFormCnt').add({xtype : 'googleauthloginpage'});
//sessionStorage.setItem('baseForm', true);
						localStorage.setItem('cancelClicked', false);
						localStorage.setItem('loginUsr',tempUsrName);
						localStorage.setItem('loginPwd', tempUsrPwd);

						if (pathname.endsWith('/fblgn'))
						{
							localStorage.setItem('initiatedPath', pathname);
						}
						else
						{
							localStorage.setItem('initiatedPath', '/final');
						}
						Ext.getCmp('googleAuthOTP').on('keydown',function(textbox,e,opts){
							if(e.getKey() == 13) // Enter Key
							{
								if (!Ext.isEmpty(resultPg[1]))
								{
									localStorage.setItem('mailAddr',resultPg[1]);
									thisCtrl.authenticate(resultPg[1] ,tempUsrPwd, tempUsrName);
								}
								else
								{
									thisCtrl.authenticate(tempUsrName,tempUsrPwd);
								}
							}
						}, thisCtrl);

						Ext.getCmp('googleAuth_submit').on('click',function(){
							if (!Ext.isEmpty(resultPg[1]))
							{
								thisCtrl.authenticate(resultPg[1] ,tempUsrPwd, tempUsrName);
							}
							else
							{
								thisCtrl.authenticate(tempUsrName,tempUsrPwd);
							}
						});
						Ext.getCmp('googleauthloginpage').on('afterrender',function(){
							if (!Ext.isEmpty(resultPg[2]))
							{
								var splitName = resultPg[2];
								if (!Ext.isEmpty(splitName) && splitName.length > 40)
								{
									splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
								}
								Ext.getCmp('userIdLblCont').fullname = resultPg[2];
								Ext.get('userIdLbl').update(splitName);	
							}
							else
							{
								var splitName = tempUsrName;
								if (!Ext.isEmpty(splitName) && splitName.length > 40)
								{
									splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
								}
								Ext.getCmp('userIdLblCont').fullname = tempUsrName;
								Ext.get('userIdLbl').update(splitName);	
							}
						});
						Ext.resumeLayouts(true);
					}
					//else if (v == "forwardTo2faLoginPg")
					else if (!Ext.isEmpty(resultPg) && resultPg[0] == "forwardTo2faLoginPg")
					{
						var pathname = window.location.pathname;
						if (pathname.endsWith("eglgn"))
						{
							var stateObj_admin = { foo: 1000 + Math.random()*1001 };
							history.pushState(stateObj_admin, "....", "/final/#!");
							//window.history.pushState({stateObj_admin, "....", "/final");
						}
						if (pathname.endsWith('/fblgn'))
						{
							localStorage.setItem('initiatedPath', pathname);
						}
						else
						{
							localStorage.setItem('initiatedPath', '/final');
						}

						Ext.suspendLayouts();
						Ext.getCmp('loginFormCnt').removeAll();
						Ext.getCmp('loginFormCnt').add({xtype : 'twofaloginpage'});
//sessionStorage.setItem('baseForm', true);
						localStorage.setItem('cancelClicked', false);
						localStorage.setItem('loginUsr',tempUsrName);
						localStorage.setItem('loginPwd', tempUsrPwd);
						Ext.getCmp('twofa_submit').on('click',function(){
							if (!Ext.isEmpty(resultPg[2]))
							{
								thisCtrl.proceedLogin(resultPg[2] ,tempUsrPwd, tempUsrName);
							}
							else
							{
								thisCtrl.proceedLogin(tempUsrName,tempUsrPwd);
							}
						});
						Ext.getCmp('otp').on('keydown',function(textbox,e,opts){
							if(e.getKey() == 13) // Enter Key
							{
								if (!Ext.isEmpty(resultPg[2]))
								{
									thisCtrl.proceedLogin(resultPg[2] ,tempUsrPwd, tempUsrName);
								}
								else
								{
									thisCtrl.proceedLogin(tempUsrName,tempUsrPwd);
								}
							}
						}, thisCtrl);

						Ext.getCmp('twofaloginpage').on('afterrender',function(){
							if (!Ext.isEmpty(resultPg[2]))
							{
								var splitName = resultPg[2];
								if (!Ext.isEmpty(splitName) && splitName.length > 40)
								{
									splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
								}
								Ext.getCmp('userIdLblCont').fullname = resultPg[2];
								Ext.get('userIdLbl').update(splitName);	
							}
							else
							{
								var splitName = tempUsrName;
								if (!Ext.isEmpty(splitName) && splitName.length > 40)
								{
									splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
								}
								Ext.getCmp('userIdLblCont').fullname = tempUsrName;
								Ext.get('userIdLbl').update(splitName);	
							}
							if (!Ext.isEmpty(resultPg[1]))
							{
								localStorage.setItem('mailAddr',resultPg[1]);
								Ext.getCmp('mailIdLabel').update("<span style='font-size:12px;font-weight:bold;color:#787878'>Enter a verification code</span><br><br>A mail with a verification code was just sent to "+resultPg[1]);
							}
							Ext.getCmp('resendCode').getEl().on('click',function()
							{
								if (!Ext.isEmpty(resultPg[2]))
								{
									localStorage.setItem('loggedInUser',resultPg[2]);
									thisCtrl.resendOTP(resultPg[2] ,tempUsrPwd, tempUsrName);
								}
								else
								{
									thisCtrl.resendOTP(tempUsrName,tempUsrPwd);
								}
							});
						});

						maxResendCount = thisCtrl.getMaxResendCount();
						localStorage.setItem('maxResendCount',maxResendCount);
						localStorage.setItem('resendCount',resendCount);

						if (localStorage.resendCount < maxResendCount)
						{
							task.start();
						}
						//this.sendOTP(usrPwd);
						Ext.resumeLayouts(true);
					}
					// 2FA code ends here
					else
					{
						meThis.clearLocalStorage();
						var pathname = window.location.pathname;
						localStorage.setItem('initiatedPath', pathname);
						window.location.href ="/final"+v;
					}
				},
				failure : function(response, options)
				{
					meThis.clearLocalStorage();
					loadmask.hide();
					Ext.Msg.alert('Failed!','Sorry! Problem occured while logging in');
				}
			});
    	}
    },

	// for 2fa starts here - for google authenticator verification

	authenticate: function(uname, usrPwd, loggedInUsr)
	{
		var meThis=this;
		var cancelClicked = localStorage.cancelClicked;
		if (!Ext.isEmpty(cancelClicked) && cancelClicked.toLowerCase() == 'true')
		{
			window.location.href = "/final";
			return;
		}

		var otp = Ext.getCmp('googleAuthOTP').getValue();
		if (Ext.isEmpty(otp))
		{
			Ext.Msg.show(
			{
				title : 'Info',
				msg : 'Please enter the verification code.',
				buttons : Ext.Msg.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		else
		{
			if (!Ext.isEmpty(uname))
			{
				//var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s Z');
				var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
				var parameters = 'uname='+encodeURIComponent(uname)+'&upass='+encodeURIComponent(usrPwd)+'&requestFrom=check2faotp&otp='+encodeURIComponent(otp)+'&userTimeZoneDate='+filterEncode(encodeURIComponent(userTZDate));
				if (!Ext.isEmpty(loggedInUsr))
				{
					parameters += '&loggedInUserFor2FA='+loggedInUsr;
				}

				Ext.Ajax.request({
					url:'/final/servlet/com.egurkha.LoginServlet',
					params: parameters,
					scope:this,
					timeout: 120000,
					success:function(response)
					{
						var v = response.responseText;
						var myarr = v.split(":");
						if(myarr[0]=="Error")
						{
							if (myarr[1].startsWith('MFA_WRONG_OTP'))
							{
								meThis.clearLocalStorage();
								window.location.href ="/final/logout";
							}
							else
							{
								var pathname = window.location.pathname;
								if (pathname.endsWith("eglgn") || pathname.endsWith("fblgn"))
								{
									var stateObj_admin = { foo: 1000 + Math.random()*1001 };
									history.pushState(stateObj_admin, "....", "/final/#!");
								}

								var errorCmp = Ext.getCmp('errorState');
								var errorText = myarr[1];
								var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';

								errorCmp.setErrors(htm1);
								errorCmp.show();
							}
						}
						else if (v == "/final/admin/egGroupUserEntry.jsp")
						{
							var pathname = window.location.pathname;
							if (pathname.endsWith("eglgn"))
							{
								var stateObj_admin = { foo: 1000 + Math.random()*1001 };
								history.pushState(stateObj_admin, "....", "/final/#!");
							}

							//this.loadGropulistUsers(v, uname, usrPwd);
							this.loadGropulistUsers(v);
						}
						else if (v == "/admin/MoreUserRoles.jsp")
						{
							var pathname = window.location.pathname;
							if (pathname.endsWith("eglgn"))
							{
								var stateObj_admin = { foo: 1000 + Math.random()*1001 };
								history.pushState(stateObj_admin, "....", "/final/#!");
							}

							v = '/final'+v;
							this.loadMoreUserRole(v);
						}
						else
						{
							var initiatedPath = localStorage.getItem('initiatedPath');
							meThis.clearLocalStorage();
							var pathname = window.location.pathname;
							if (initiatedPath != null)
							{
								pathname = initiatedPath;
							}

							if (pathname.endsWith('/fblgn'))
							{
								localStorage.setItem('initiatedPath', pathname);
							}
							else
							{
								localStorage.setItem('initiatedPath', '/final');
							}
							window.location.href ="/final"+v;
						}
						//loadmask.hide();
					},
					failure : function(response)
					{
						meThis.clearLocalStorage();
						//loadmask.hide();
						Ext.Msg.alert('Failed!','Sorry! Problem occured while logging in.');
					}
				});
			}
		}
	},

	getMaxResendCount: function()
	{
		var count = 0;
		Ext.Ajax.request({
			url:'/final/scripts/LoginApp/data/twoFactorAuthentication.jsp',
			params:'requestFrom=getMaxResendCount',
			scope:this,
			timeout: 120000,
			async: false,
			success:function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = Ext.decode(response.responseText);
					count = jsonText.maxResendCount;
				}
			}
		});
		return count;
	},

	resendOTPFromCache: function(uname, usrPwd, loggedInUsr)
	{
		var meThis=this;
		var cacheResndCnt = localStorage.resendCount;
		if (!Ext.isEmpty(cacheResndCnt) && cacheResndCnt >= localStorage.maxResendCount)
		{
			Ext.getCmp('resendCode').hide();
			return;
		}

		Ext.getCmp('errorState').hide();
		var parameters = 'uname='+encodeURIComponent(uname)+'&upass='+encodeURIComponent(usrPwd)+'&requestFrom=resendOTP';
		if (!Ext.isEmpty(loggedInUsr))
		{
			parameters += '&loggedInUserFor2FA='+loggedInUsr;
		}
		Ext.Ajax.request({
			url:'/final/scripts/LoginApp/data/twoFactorAuthentication.jsp',
			params: parameters,
			scope:this,
			timeout: 120000,
			async: false,
			success:function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					resendCount++;
					var cacheResndCnt = localStorage.resendCount;
					if (!Ext.isEmpty(cacheResndCnt))
					{
						var count = parseInt(cacheResndCnt);
						count++;
						localStorage.setItem('resendCount',count);
					}
					else
					{
						localStorage.setItem('resendCount',resendCount);
					}
					var jsonText = Ext.decode(response.responseText);
					var errorLink = jsonText.ErrorLink;
					if (!Ext.isEmpty(errorLink))
					{
						meThis.clearLocalStorage();
						window.location.href = errorLink;
					}
					else
					{
						var mailStatus = jsonText.mailStatus;
						var sentMailAddress = jsonText.sentMailAddress;

						if (!Ext.isEmpty(sentMailAddress))
						{
							Ext.getCmp('mailIdLabel').update('<span style="font-size:12px;font-weight:bold;color:#787878">Enter a verification code</span><br><br>A mail with a verification code was just sent to '+sentMailAddress);
						}

						if (!Ext.isEmpty(mailStatus) && (parseInt(mailStatus) == 1 || parseInt(mailStatus) == 2 || parseInt(mailStatus) == 3 || parseInt(mailStatus) == 4))
						{
							Ext.Msg.show({
								title:'Info',
								msg: 'Problem occured while sending verification code to your registered mail address. Please sign in after sometime.',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.ERROR,
								fn: function(btn)
								{
									if (btn === 'ok' || btn === 'cancel')
									{
										var cnt = {
											xtype : 'container',
											//id: 'loginFormCnt',
											width : 310,
											border : true,
											frame : false,
											bodyPadding :0,
											cls : 'loginpanel',
											items : [
												{
													xtype:'container',
													align:'center',
													margin:'13px 10px 12px 15px',
													html:'<div id="loginHeader"><div class="loginArrow"></div><div class="loginText">Sign in</div></div><div style="margin:10px 10px 10px 0px;float:left;cursor:pointer;display:none;" class="iconTooltipHelp" id="loginHelpTip"></div>'
												},
												{
													xtype : 'loginform',
													align : 'center',
													cls:'loginpanelInner',
													autoHeight : true
												}
											]
										};
										Ext.suspendLayouts();
										Ext.getCmp('loginFormCnt').removeAll();
										//Ext.getCmp('loginFormCnt').add({xtype : 'loginform'});
										Ext.getCmp('loginFormCnt').add(cnt);
										Ext.resumeLayouts(true);
									}
								}
							});
						}
					}
				}
			},
			failure : function(response, options){
				meThis.clearLocalStorage();
				window.location.href = "/final";
			}
		});
		Ext.getCmp('resendCode').hide();

		var cacheMaxCnt = localStorage.maxResendCount;
		var cacheResndCnt = localStorage.resendCount;
		if (Ext.isEmpty(localStorage.maxResendCount))
		{
			cacheMaxCnt = 3;
		}
		cacheMaxCnt = parseInt(cacheMaxCnt);

		if (Ext.isEmpty(localStorage.resendCount))
		{
			cacheResndCnt = 0;
		}
		cacheResndCnt = parseInt(cacheResndCnt);

		if (cacheResndCnt < cacheMaxCnt)
		{
			task.start();
		}
	},

	resendOTP: function(uname, usrPwd, loggedInUsr)
	{
		var meThis=this;
		var cacheResndCnt = localStorage.resendCount;
		if (!Ext.isEmpty(cacheResndCnt) && cacheResndCnt >= localStorage.maxResendCount)
		{
			Ext.getCmp('resendCode').hide();
			return;
		}

		Ext.getCmp('errorState').hide();
		var parameters = 'uname='+encodeURIComponent(uname)+'&upass='+encodeURIComponent(usrPwd)+'&requestFrom=resendOTP';
		if (!Ext.isEmpty(loggedInUsr))
		{
			parameters += '&loggedInUserFor2FA='+loggedInUsr;
		}
		Ext.Ajax.request({
			url:'/final/scripts/LoginApp/data/twoFactorAuthentication.jsp',
			params: parameters,
			scope:this,
			timeout: 120000,
			async: false,
			success:function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					resendCount++;
					var cacheResndCnt = localStorage.resendCount;
					if (!Ext.isEmpty(cacheResndCnt))
					{
						var count = parseInt(cacheResndCnt);
						count++;
						localStorage.setItem('resendCount',count);
					}
					else
					{
						localStorage.setItem('resendCount',resendCount);
					}
					var jsonText = Ext.decode(response.responseText);
					var errorLink = jsonText.ErrorLink;
					if (!Ext.isEmpty(errorLink))
					{
						meThis.clearLocalStorage();
						window.location.href = errorLink;
					}
					else
					{
						var mailStatus = jsonText.mailStatus;
						var sentMailAddress = jsonText.sentMailAddress;

						if (!Ext.isEmpty(sentMailAddress))
						{
							Ext.getCmp('mailIdLabel').update('<span style="font-size:12px;font-weight:bold;color:#787878">Enter a verification code</span><br><br>A mail with a verification code was just sent to '+sentMailAddress);
						}

						if (!Ext.isEmpty(mailStatus) && (parseInt(mailStatus) == 1 || parseInt(mailStatus) == 2 || parseInt(mailStatus) == 3 || parseInt(mailStatus) == 4))
						{
							Ext.Msg.show({
								title:'Info',
								msg: 'Problem occured while sending verification code to your registered mail address. Please sign in after sometime.',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.ERROR,
								fn: function(btn)
								{
									if (btn === 'ok' || btn === 'cancel')
									{
										var cnt = {
											xtype : 'container',
											//id: 'loginFormCnt',
											width : 310,
											border : true,
											frame : false,
											bodyPadding :0,
											cls : 'loginpanel',
											items : [
												{
													xtype:'container',
													align:'center',
													margin:'13px 10px 12px 15px',
													html:'<div id="loginHeader"><div class="loginArrow"></div><div class="loginText">Sign in</div></div><div style="margin:10px 10px 10px 0px;float:left;cursor:pointer;display:none;" class="iconTooltipHelp" id="loginHelpTip"></div>'
												},
												{
													xtype : 'loginform',
													align : 'center',
													cls:'loginpanelInner',
													autoHeight : true
												}
											]
										};
										Ext.suspendLayouts();
										Ext.getCmp('loginFormCnt').removeAll();
										//Ext.getCmp('loginFormCnt').add({xtype : 'loginform'});
										Ext.getCmp('loginFormCnt').add(cnt);
										Ext.resumeLayouts(true);
									}
								}
							});
						}
					}
				}
			},
			failure : function(response, options){
				meThis.clearLocalStorage();
				window.location.href = "/final";
			}
		});
		Ext.getCmp('resendCode').hide();
		if (!Ext.isEmpty(localStorage.maxResendCount))
		{
			var cacheMaxCnt = localStorage.maxResendCount;
			cacheMaxCnt = parseInt(cacheMaxCnt);

			var cacheResndCnt = localStorage.resendCount;
			if (Ext.isEmpty(localStorage.resendCount))
			{
				cacheResndCnt = 0;
			}
			cacheResndCnt = parseInt(cacheResndCnt);
			if (cacheResndCnt < cacheMaxCnt)
			{
				task.start();
			}
		}
		else
		{
			if (resendCount < maxResendCount)
			{
				task.start();
			}
		}
	},

	navigateToMFAUI: function()
	{
		if (!Ext.isEmpty(isComeFrom2faUI))
		{
			Ext.suspendLayouts();
			Ext.getCmp('loginFormCnt').removeAll();

			var initiatedPath = localStorage.getItem('initiatedPath');
			var pathname = window.location.pathname;
			if (initiatedPath != null)
			{
				if (pathname.toLowerCase() != initiatedPath.toLowerCase())
				{
					var stateObj_admin = { foo: 1000 + Math.random()*1001 };
					if (initiatedPath.endsWith("final"))
					{
						initiatedPath = initiatedPath + "#!";
					}
					history.pushState(stateObj_admin, "....", initiatedPath);
				}
				pathname = initiatedPath;
				
			}

			if (pathname.endsWith('/fblgn'))
			{
				localStorage.setItem('initiatedPath', pathname);
			}
			else
			{
				localStorage.setItem('initiatedPath', '/final');
			}
			
			if (pathname.endsWith("eglgn"))
			{
				var stateObj_admin = { foo: 1000 + Math.random()*1001 };
				history.pushState(stateObj_admin, "....", "/final/#!");
			}
			if (isComeFrom2faUI == 'fwdToGoogleAuthLoginPage')
			{
				Ext.getCmp('loginFormCnt').add({xtype : 'googleauthloginpage'});

				Ext.getCmp('googleAuthOTP').on('keydown',function(textbox,e,opts){
					if(e.getKey() == 13) // Enter Key
					{
						if (!Ext.isEmpty(localStorage.mailAddr))
						{
							thisCtrl.authenticate(localStorage.mailAddr ,localStorage.loginPwd, localStorage.loginUsr);
						}
						else
						{
							thisCtrl.authenticate(localStorage.loginUsr,localStorage.loginPwd);
						}
					}
				}, thisCtrl);

				Ext.getCmp('googleAuth_submit').on('click',function(){
					if (!Ext.isEmpty(localStorage.mailAddr))
					{
						thisCtrl.authenticate(localStorage.mailAddr ,localStorage.loginPwd, localStorage.loginUsr);
					}
					else
					{
						thisCtrl.authenticate(localStorage.loginUsr,localStorage.loginPwd);
					}
				});
				Ext.getCmp('googleauthloginpage').on('afterrender',function(){
						var splitName = localStorage.loginUsr;
						if (!Ext.isEmpty(splitName) && splitName.length > 40)
						{
							splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
						}
						Ext.getCmp('userIdLblCont').fullname = localStorage.loginUsr;
						Ext.get('userIdLbl').update(splitName);	
				});
				Ext.resumeLayouts(true);
			}
			else
			{
				Ext.getCmp('loginFormCnt').add({xtype : 'twofaloginpage'});
				
				Ext.getCmp('twofa_submit').on('click',function(){
					if (!Ext.isEmpty(localStorage.loggedInUser))
					{
						thisCtrl.proceedLogin(localStorage.loggedInUser ,localStorage.loginPwd, localStorage.loginUsr);
					}
					else
					{
						thisCtrl.proceedLogin(localStorage.loginUsr,localStorage.loginPwd);
					}
				});
				Ext.getCmp('otp').on('keydown',function(textbox,e,opts){
					if(e.getKey() == 13) // Enter Key
					{
						if (!Ext.isEmpty(localStorage.loggedInUser))
						{
							thisCtrl.proceedLogin(localStorage.loggedInUser ,localStorage.loginPwd, localStorage.loginUsr);
						}
						else
						{
							thisCtrl.proceedLogin(localStorage.loginUsr,localStorage.loginPwd);
						}
					}
				}, thisCtrl);

				Ext.getCmp('twofaloginpage').on('afterrender',function(){
						var splitName = localStorage.loginUsr;
						if (!Ext.isEmpty(splitName) && splitName.length > 40)
						{
							splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
						}
						Ext.getCmp('userIdLblCont').fullname = localStorage.loginUsr;
						Ext.get('userIdLbl').update(splitName);	

					if (!Ext.isEmpty(localStorage.mailAddr))
					{
						Ext.getCmp('mailIdLabel').update("<span style='font-size:12px;font-weight:bold;color:#787878'>Enter a verification code</span><br><br>A mail with a verification code was just sent to "+localStorage.mailAddr);
					}
					Ext.getCmp('resendCode').getEl().on('click',function()
					{
						if (!Ext.isEmpty(localStorage.loggedInUser))
						{
							thisCtrl.resendOTPFromCache(localStorage.loggedInUser ,localStorage.loginPwd, localStorage.loginUsr);
						}
						else
						{
							thisCtrl.resendOTPFromCache(localStorage.loginUsr,localStorage.loginPwd);
						}
					});
				});
				var cacheMaxCnt = localStorage.maxResendCount;
				var cacheResndCnt = localStorage.resendCount;
				if (Ext.isEmpty(localStorage.maxResendCount))
				{
					cacheMaxCnt = 3;
				}
				cacheMaxCnt = parseInt(cacheMaxCnt);

				if (Ext.isEmpty(localStorage.resendCount))
				{
					cacheResndCnt = 0;
				}
				cacheResndCnt = parseInt(cacheResndCnt);
				if (cacheResndCnt < cacheMaxCnt)
				{
					task.start();
				}
			}
			Ext.resumeLayouts(true);
		}
	},
	proceedLogin: function(uname, usrPwd, loggedInUsr)
	{
		var meThis=this;
		var cancelClicked = localStorage.cancelClicked;
		if (!Ext.isEmpty(cancelClicked) && cancelClicked.toLowerCase() == 'true')
		{
			window.location.href = "/final";
			return;
		}

		var otp = Ext.getCmp('otp').getValue();
		if (Ext.isEmpty(otp))
		{
			Ext.Msg.show(
			{
				title : 'Info',
				msg : 'Please enter the verification code.',
				buttons : Ext.Msg.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		else
		{
			if (!Ext.isEmpty(uname))
			{
				//var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s Z');
				var userTZDate = Ext.Date.format(new Date(),'m/d/Y H:i:s O');
				var parameters = 'uname='+encodeURIComponent(uname)+'&upass='+encodeURIComponent(usrPwd)+'&requestFrom=check2faotp&otp='+encodeURIComponent(otp)+'&userTimeZoneDate='+filterEncode(encodeURIComponent(userTZDate));
				if (!Ext.isEmpty(loggedInUsr))
				{
					parameters += '&loggedInUserFor2FA='+loggedInUsr;
				}
				Ext.Ajax.request({
					url:'/final/servlet/com.egurkha.LoginServlet',
					params: parameters,
					scope:this,
					timeout: 120000,
					success:function(response)
					{
						var v = response.responseText;
						var myarr = v.split(":");
						if(myarr[0]=="Error")
						{
							if (myarr[1].startsWith('MFA_WRONG_OTP'))
							{
								meThis.clearLocalStorage();
								window.location.href ="/final/logout";
							}
							else
							{
								var errorText = myarr[1];
								if (errorText.toLowerCase() == "your verification code has expired.")
								{
									meThis.clearLocalStorage();
									window.location.href ="/final/logout";
								}
								else
								{
									var pathname = window.location.pathname;
									if (pathname.endsWith("eglgn"))
									{
										var stateObj_admin = { foo: 1000 + Math.random()*1001 };
										history.pushState(stateObj_admin, "....", "/final/#!");
									}

									var errorCmp = Ext.getCmp('errorState');
									var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';

									errorCmp.setErrors(htm1);
									errorCmp.show();	
								}
							}
						}
						else if (v == "/final/admin/egGroupUserEntry.jsp")
						{
							var pathname = window.location.pathname;
							if (pathname.endsWith("eglgn"))
							{
								var stateObj_admin = { foo: 1000 + Math.random()*1001 };
								history.pushState(stateObj_admin, "....", "/final/#!");
							}

							//this.loadGropulistUsers(v, uname, usrPwd);
							this.loadGropulistUsers(v);
						}
						else if (v == "/admin/MoreUserRoles.jsp")
						{
							var pathname = window.location.pathname;
							if (pathname.endsWith("eglgn"))
							{
								var stateObj_admin = { foo: 1000 + Math.random()*1001 };
								history.pushState(stateObj_admin, "....", "/final/#!");
							}

							v = '/final'+v;
							this.loadMoreUserRole(v);
						}
						else
						{
							var initiatedPath = localStorage.getItem('initiatedPath');
							meThis.clearLocalStorage();
							var pathname = window.location.pathname;
							if (initiatedPath != null)
							{
								pathname = initiatedPath;
							}

							if (pathname.endsWith('/fblgn'))
							{
								localStorage.setItem('initiatedPath', pathname);
							}
							else
							{
								localStorage.setItem('initiatedPath', '/final');
							}

							window.location.href ="/final"+v;
						}
						//loadmask.hide();
					},
					failure : function(response)
					{
						//loadmask.hide();
						Ext.Msg.alert('Failed!','Sorry! Problem occured while logging in.');
					}
				});
			}
		}
	},
	// for 2fa ends here

    validateStateChangeresponse : function(response){
		var meThis=this;
    	var v = response.responseText;

		var myarr = v.split(":");

		if(myarr[0]=="Error")
		{
			var thisForm = this.getLoginform().getForm();
			var  errorCmp = Ext.getCmp('errorState');
			var errorText = myarr[1];
			if (errorText != null && ((errorText.indexOf("The password is incorrect") != -1) || (errorText.indexOf("password may be incorrect") != -1)))
			{
				var password=thisForm.findField("password").getValue();

			}
			var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';

			errorCmp.setErrors(htm1);
		}
		else if (v == "/final/admin/egGroupUserEntry.jsp" || 
			v == "/final/admin/egGroupUserEntry.jsp?loginThruParent=true" ||
			v == "/final/admin/egGroupUserEntry.jsp?isTrustDomainGrpAvail=true")
		{
			this.loadGropulistUsers(v);
		}
		else if (v == "/admin/MoreUserRoles.jsp")
		{
			v = "/final"+v;
			this.loadMoreUserRole(v);
		}
		else
		{
			meThis.clearLocalStorage();
			window.location.href ="/final"+v;
		}


    },
	setLoginHeader : function(from)
	{
		var loginHeader = Ext.get('loginHeader');
		if(!Ext.isEmpty(loginHeader))
		{
			this.viewName = from;
			if(from!=null && from=='login')
			{
				loginHeader.update('<div class="loginArrow"></div><div class="loginText">Sign in</div>');
			}
			else if(from!=null && from=='forgotPassword')
			{
				loginHeader.update('<div><img src="/final/images/'+loginSkin+'/forgot_password.png" align="left"></div><div class="loginText">Forgot Password</div>');
			}
			else if(from!=null && from=='groupUsers')
			{
				loginHeader.update('<div><img src="/final/images/'+loginSkin+'/user_group.png" align="left"></div><div class="loginText">User Group</div>');
			}
		}
	},
    loadForgotpassword : function(){
		var me=this;
		me.setLoginHeader('forgotPassword');
		var fset = {xtype:'fieldset',
					border:false,
					style:{'box-shadow':'0px 0px 0px 0px', '-webkit-box-shadow':'0px 0px 0px 0px', '-moz-box-shadow':'0px 0px 0px 0px'},
					margin:0,
					defaults: {
		                labelAlign: 'top',
		                msgTarget: 'none',
						anchor:'100%'
		                //invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
	           		 },
					items:[
						/*{
						xtype : 'container',
						align : 'center',
						html : '<center><img src="'+imgname+'"></center>',
						margin:'10px 10px 20px 10px',
						bodyPadding:'0px',
						anchor : '100%'
					},*/
					{
						xtype:'container',
						id:'custom_msg_container',
						html:'<div id="custom_msg_div" class="font_bold11"></div>',
						margin:'0px 0px 20px 0px',
						hidden:true
					},
					//{
                    //xtype: 'container',
                    //anchor: '100%',
					////bodyPadding:8,
					//html:'<div style="float:left;">Please confirm your identity</div>',
					//bodyPadding:'0px',
					//margin:'10px 0px 30px 0px',
					//id:'pleaseConfirm',
					//disabled:false
					//},
					{
						xtype : 'textfield',
						anchor : '100%',
						name : 'fusername',
						id : 'fusername',
						cls: 'textboxLoginUserName',
						fieldLabel :'Please confirm your identity',
						value : '',
						labelSeparator :'',
						margin:'10px 0px 30px 0px',
						allowBlank : false,
						minLength : 2,
						bodyPadding:'0px'
					},
					{
						xtype : 'formErrorState',
						id : 'errorState',
						anchor : '100%',
						margin:'0px 0px 30px 0px',
						bodyPadding:'0px'
					},{
						xtype:'container',
						id:'loginTextId',
						margin:'0px',
						style:{'border':'0px solid red'},
						layout:'hbox',
						items:[{
							xtype : 'container',
							id : 'loginpage',
							flex:1,
							name:'loginpage',
							anchor : '100%',
							margin:'14px 0px 0px 0px',
							bodyPadding:'0px',
							html:'<div id="logindiv" style="cursor:pointer;text-decoration:underline;font-size:11px;">Sign in</div>',
							listeners:{
								click:function(e,opts){
									me.loadLoginPage('forgotpass');
									me.submitForm();
								}
							}
						}]

					}

				]};
			var   butonObj = {
						xtype : 'button',
						action : 'getpassword',
						buttonAlign:'right',
						cls: 'buttonBig',
						margin:'0px 0px 0px 0px',
						bodyPadding:'0px',
						id : 'fpass',
						disabled : false,
						text : 'Get Password'
					};


		var loginform = Ext.getCmp("loginform");
		var buttonObj = Ext.getCmp("submit");
		if(buttonObj!=null && buttonObj!='undefined')
    		buttonObj.destroy();
		loginform.removeAll();

		if (enableFTL.toLowerCase() == "true" && isUserLoggingFirstTime.toLowerCase() == "true")
		{
			Ext.get('loginHelpTip').hide();
		}

    	loginform.add(fset);
    	Ext.getCmp('loginTextId').add(butonObj);
		loginform.doLayout();

		Ext.get("logindiv").on('click',function(){
					me.loadLoginPage('forgotpass');
			}
		);

		if(!Ext.isEmpty(logoMessage))
		{
			var msgLblContainer = Ext.getCmp("custom_msg_container");
			if(!Ext.isEmpty(msgLblContainer))
			{
				var msgLbl = Ext.get("custom_msg_div");
				msgLbl.update(logoMessage);
				msgLblContainer.show();
			}
		}

	},
	getPassword : function(){
		var loginform = Ext.getCmp("loginform").getForm();
		var userTogetpass = loginform.findField("fusername").getValue();
		if(validating(loginform))
			this.getpassword(userTogetpass);
	},
	getpassword : function(user){
		var  loadmask = new Ext.LoadMask(Ext.getCmp("errorState"), {
							msg : "Loading..."

						});
			 loadmask.show();
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.LoginHelperServlet',
			params:'user='+encodeURIComponent(user),
			scope:this,
			timeout:120000,
			success:function(response){
				 loadmask.hide();
				var jsontext = response.responseText;
				var loginform = Ext.getCmp("errorState");
				var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+jsontext+'.</td></tr></table>';
				loginform.setErrors(htm1);
			},
			failure: function(response){
				loadmask.hide();
				var loginform = Ext.getCmp("errorState");
				var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconError"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">Problem occured while login.</td></tr></table>';
				loginform.setErrors(htm1);
			}
		});
	},
	loadLoginPage : function(from){
		key = "";
		var me = this;
		me.setLoginHeader('login');
		var fset ={xtype:'fieldset',
					border:false,
					style:{'box-shadow':'0px 0px 0px 0px', '-webkit-box-shadow':'0px 0px 0px 0px', '-moz-box-shadow':'0px 0px 0px 0px'},
					margin:0,
					defaults: {
						labelAlign: 'top',
						msgTarget: 'none',
						anchor:'100%',
						invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
					},
					items:[
				/*{
					xtype:'container',
					align:'center',
					html:'<center><img src="'+imgname+'"></center>',
					margin:'10px 10px 20px 10px',
					bodyPadding:'0px',
					anchor:'100%'
				},*/
				{
					xtype:'container',
					id:'custom_msg_container',
					html:'<div id="custom_msg_div" class="font_bold11"></div>',
					margin:'0px 0px 20px 0px',
					hidden:true
				},
				{
					xtype:'scrollcombo',
					id:'loginTypeCombo',
					name:'loginTypeCombo',
					cls:'dropdown24 authentication_combo',
					hidden:hasMultiLoginTypes,
					displayField: 'displayField',
					valueField: 'valueField',
					bodyPadding:'0px',
					margin:'0px 0px 30px 0px',
					queryMode: 'local',
					anchor:'100%',
					editable : false,
					store:new Ext.data.Store({
							fields:['displayField','valueField'],
							data:[]
					})
				},
				{
					xtype:(isFromSuperManager)?'multiselectSi':'scrollcombo',
					id:'domainCombo',
					name:'domainCombo',
					cls: (isFromSuperManager)?'multiselect':'dropdown24 domain_combo',
					hidden:isDomainConfigured,
					displayField: 'displayField',
					valueField: 'valueField',
					margin:'0px 0px 30px 0px',
					bodyPadding:'0px',
					queryMode: 'local',
					anchor:'100%',
					height: (isFromSuperManager)?100:0,
					editable : false,
					store:new Ext.data.Store({
							fields:['displayField','valueField'],
							data:[]
					})
				},
				{
					xtype: 'textfield',
					anchor: '100%',
					name: 'username',
					id:'username',
					cls: 'textboxLoginUserName',
					//fieldLabel: 'Username',
				   // value:loggedOutUser,
					allowBlank: false,
					minLength: 2,
					margin:'10px 0px 30px 0px',
					bodyPadding:'0px'
				},
				{
					xtype: 'textfield',
					anchor: '100%',
					cls: 'textboxLoginPassword',
					inputType: 'password',
					name: 'password',
					id:'password',
					// fieldLabel: 'Password',
					allowBlank: false,
					margin:'0px 0px 30px 0px',
					bodyPadding:'0px'
				},
				{
					xtype:'scrollcombo',
					id:'idpCombo',
					name:'idpCombo',
					cls: 'dropdown24 domain_combo',
					//hidden:true,
					displayField: 'displayField',
					valueField: 'valueField',
					bodyPadding:'0px',
					margin:'0px 0px 30px 0px',
					queryMode: 'local',
					anchor:'100%',
					editable : false,
					store:new Ext.data.Store({
							fields:['displayField','valueField'],
							data:[]
					})
				},
				{
					xtype: 'formErrorState',
					id:'errorState',
					anchor:'100%',
					margin:'0px 0px 30px 0px',
					bodyPadding:'0px'
				},
				//{
					//xtype:'label',
					//align:'center',
					//id:'help',
					//hidden:false,
					//text:'',
					//margin:'0px 10px 5px 10px',
					//bodyPadding:'0px'
				//}
				]};
				var butobj = {
						xtype:'container',
						id:'loginTextId',
						margin:'0px 10px 10px 10px',
						layout:'hbox',
						items:[{
							xtype:'text',
							id:'forgotpass',
							cls:(isFromSuperManager || hideForgetPass)?'x-hidden':"",
							anchor:'100%',
							flex:1,
							margin:'14px 0px 0px 0px',
							bodyPadding:'0px',
							html:'<div id="f_pass" style="cursor:pointer;text-decoration:underline;font-size:11px;line-height:1.2em">Forgot Password </div>',
							listeners:{
								click:function(e,opts){
									me.loadForgotpassword();
								}
							}
						},
						{
						xtype: 'button',
						action: 'submit',
						buttonAlign:'right',
						cls: 'buttonBig',
						margin:'0px 0px 0px 0px',
						bodyPadding:'0px',
						id:'submit',
						disabled: false,
						text: 'Sign In'
				}]

				};

		var loginform = Ext.getCmp("loginform");
		var buttonObj  = Ext.getCmp("submit");
		if(buttonObj!=null && buttonObj!='undefined')
			buttonObj.destroy();

		loginform.removeAll();

		var loginItemsArr = new Array();
		loginItemsArr.push(fset);
		loginItemsArr.push(butobj);

		loginform.add(loginItemsArr);

		if (enableFTL.toLowerCase() == "true" && isUserLoggingFirstTime.toLowerCase() == "true")
		{
			Ext.get('loginHelpTip').show();
		}

	// 	loginform.add(butobj);
		loginform.doLayout();

		if(!Ext.isEmpty(logoMessage))
		{
			var msgLblContainer = Ext.getCmp("custom_msg_container");
			if(!Ext.isEmpty(msgLblContainer))
			{
				var msgLbl = Ext.get("custom_msg_div");
				msgLbl.update(logoMessage);
				msgLblContainer.show();
			}
		}
		me.submitForm(from);
	},
	loadGropulistUsers : function(v){

		Ext.Ajax.request({
			url:v,
			scope:this,
			success: function(response){
				var jsontext = response.responseText;
				var jsonObj = Ext.decode(jsontext);
				if(!Ext.isEmpty(jsonObj))
				{
					this.forgotpasswin(jsonObj);
				}
			}
		});
	},
	loadMoreUserRole : function(v){
		Ext.Ajax.request({
			url:v,
			scope:this,
			success: function(response){
				var jsontext = response.responseText;
				var jsonObj = Ext.decode(jsontext);
				if(!Ext.isEmpty(jsonObj)){
					this.morerolewin(jsonObj);
				}
			}
		});
	},
	forgotpasswin : function(jsonObj)
	{
		var me=this;
		me.setLoginHeader('groupUsers');
		var screenLabels = jsonObj.screenLabels;
		var title = jsonObj.titleStr;
		var uname = jsonObj.uname;
		var parentDomName = jsonObj.parentDomName;
		var trustDomainGrps = jsonObj.trustDomainGrps;
		var listgroupusers = jsonObj.listgroupusers;
		var listgroupusers_value = jsonObj.listgroupusers_value;
		var loginform = Ext.getCmp("loginform");
		loginform.removeAll();
	//	var popup = Ext.widget('commonpopup', {

		loginform.add([
			{
				xtype : 'container',
				margin : 0,
				flex:1,
				bodyPadding : '0px 0px 10px 0px',
				items : [
					{
						xtype:'container',
						margin :0,
						bodyPadding :'0px',
						flex:1,
					//	flex: 3,
						items: [
							{
								xtype : 'container',
								margin : 10,
								bodyPadding:'0px',
								id:'grouptitle',
								html : ''
							}, 
							{
								xtype : 'scrollcombo',
								fieldLabel : 'Group',
								labelAlign : 'top',
								id:'uid',
								name:'uid',
								labelSeperator:'',
								cls : 'dropdown24',
								margin :'10px 10px 30px 10px',
								bodyPadding:'0px',
								queryMode: 'local',
								anchor:'100%',
								width:268,
								flex:1,
								groupField: 'groupField',
								displayField: 'displayField',
								valueField: 'valueField',
								store:new Ext.data.Store({
									fields:['displayField','valueField','groupField'],
									data:[]
								}),
								listConfig: {
									tpl: Ext.create("Ext.XTemplate", 
										'<ul><tpl for=".">', 
											'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">', 
												'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>', 
											"</tpl>", 
											'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>', 
											"</tpl>" + 
										"</ul>", 
										{
											getGroupLabel: function(a) {
												return a.groupField;
											}
										}
									)
								},
								listeners:{
									select:function(e,opts){
										var  errorCmp = Ext.getCmp('errorState');
										if (!Ext.isEmpty(errorCmp) && errorCmp.isVisible())
										{
											errorCmp.hide();
										}
									}
								}
							},
							{
								xtype: 'formErrorState',
								id:'errorState',
								anchor:'100%',
								margin:'0px 10px 30px 10px',
								bodyPadding:'0px',
								hidden: true
							}
						]
					},
					{
						xtype:'container',
						layout:'hbox',
						margin:'10px',
						items: [
							{
								xtype : 'container',
								id : 'loginpage',
								flex:1,
								name:'loginpage',
								anchor : '100%',
								margin:'13px 0px -2px 0px',
								bodyPadding:'0px',
								html:'<div id="logindiv2" style="cursor:pointer;text-decoration:underline;font-size:11px;"> Sign in </div>',
								listeners:{
									click:function(e,opts){
										me.loadLoginPage();
										me.submitForm();
									}
								}
							},
							{
								xtype : 'button',
								buttonAlign:'right',
								cls: 'button20',
								margin:'8px 0px -2px 0px',
								bodyPadding:'0px',
								id : 'gobutton',
								name:'gobutton',
								flex :.2,
								disabled : false,
								text : 'Go',
								listeners: {
									click :function(e,opts)
									{
										var uidcombo1 = Ext.getCmp("uid");
										var param = 'uname='+encodeURIComponent(uname)+'&requestFrom=groupentry';
										var grpName = uidcombo1.getValue();
										if (!Ext.isEmpty(trustDomainGrps))
										{
											var selectedTrustDomGrp = trustDomainGrps[grpName];
											if (!Ext.isEmpty(selectedTrustDomGrp))
											{
												param +='&selectTrust=true&uid='+encodeURI(grpName)+'&trusteduid='+selectedTrustDomGrp;
											}
											else
											{
												param +='&uid='+encodeURI(grpName)+"&parentDomName="+encodeURIComponent(parentDomName);
											}
										}
										else
										{
											param +='&uid='+encodeURI(grpName)+"&parentDomName="+encodeURIComponent(parentDomName);
										}
										Ext.Ajax.request({
											url:'/final/servlet/com.egurkha.LoginServlet',
											params:param,
											method:'POST',
											scope:this,
											success:function(response)
											{
												var v = response.responseText;
												var resultPg = v.split("~$~");

												var myarr = v.split(":");
												var tempUsrName = '';
												var tempUsrPwd = '';

												if (v.startsWith('fwdToGoogleAuthLoginPage') || resultPg[0] == "forwardTo2faLoginPg")
												{
													var pathname = window.location.pathname;
													if (pathname.endsWith("eglgn"))
													{
														var stateObj_admin = { foo: 1000 + Math.random()*1001 };
														history.pushState(stateObj_admin, "....", "/final/#!");
													}
													if (pathname.endsWith('/fblgn'))
													{
														localStorage.setItem('initiatedPath', pathname);
													}
													else
													{
														localStorage.setItem('initiatedPath', '/final');
													}

													Ext.Ajax.request({
														url:'/final/scripts/LoginApp/data/twoFactorAuthentication.jsp',
														params:'requestFrom=getRealGroupName&grpName='+encodeURI(uidcombo1.getValue())+'&userName='+uname,
														method:'POST',
														scope:this,
														async: false,
														success:function(response)
														{
															if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
															{
																var resultJsonData = Ext.decode(response.responseText);
																var realGrpName = resultJsonData.realGrpName;
																tempUsrName = realGrpName;
															}
														}
													});
												}

												if(myarr[0]=="Error")
												{
													var pathname = window.location.pathname;
													if (pathname.endsWith("eglgn"))
													{
														var stateObj_admin = { foo: 1000 + Math.random()*1001 };
														history.pushState(stateObj_admin, "....", "/final/#!");
													}

													var  errorCmp = Ext.getCmp('errorState');
													var errorText = myarr[1];
													var htm1 = '<table width="100%" cellpadding="0px" cellspacing="0" class="loginErrorMsg"><tr><td style="padding:10px 10px 10px 20px;valign:middle"><div class="iconExclamation"></div></td><td align="left" valign="middle" style="padding:10px 10px 10px 0px;font-size:11px;">'+errorText+'</td></tr></table>';

													errorCmp.setErrors(htm1);
													errorCmp.show();

												}

												// for 2fa - starts here
												else if (v.startsWith('fwdToGoogleAuthLoginPage'))
												{
													Ext.suspendLayouts();
													Ext.getCmp('loginFormCnt').removeAll();
													Ext.getCmp('loginFormCnt').add({xtype : 'googleauthloginpage'});
													//sessionStorage.setItem('baseForm', true);
													var realLoggedInUser = uname;
													localStorage.setItem('cancelClicked', false);
													localStorage.setItem('loginUsr',realLoggedInUser);
													localStorage.setItem('loginPwd', tempUsrPwd);
													if (!Ext.isEmpty(resultPg[1]))
													{
														localStorage.setItem('mailAddr',resultPg[1]);
													}
													Ext.getCmp('googleAuthOTP').on('keydown',function(textbox,e,opts){
														if(e.getKey() == 13) // Enter Key
														{
															if (!Ext.isEmpty(resultPg[1]))
															{
																thisCtrl.authenticate(resultPg[1] ,tempUsrPwd, realLoggedInUser);
															}
															else
															{
																thisCtrl.authenticate(tempUsrName,tempUsrPwd);
															}
														}
													}, thisCtrl);

													Ext.getCmp('googleAuth_submit').on('click',function(){
														if (!Ext.isEmpty(resultPg[1]))
														{
															thisCtrl.authenticate(resultPg[1] ,tempUsrPwd, realLoggedInUser);
														}
														else
														{
															thisCtrl.authenticate(tempUsrName,tempUsrPwd);
														}
													});
													Ext.getCmp('googleauthloginpage').on('afterrender',function(){
														if (!Ext.isEmpty(realLoggedInUser))
														{
															var splitName = realLoggedInUser;
															if (!Ext.isEmpty(splitName) && splitName.length > 40)
															{
																splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
															}
															Ext.getCmp('userIdLblCont').fullname = realLoggedInUser;
															Ext.get('userIdLbl').update(splitName);		
														}
													});

													Ext.resumeLayouts(true);
												}
												//else if (v == "forwardTo2faLoginPg")
												else if (!Ext.isEmpty(resultPg) && resultPg[0] == "forwardTo2faLoginPg")
												{
													Ext.suspendLayouts();
													var realLoggedInUser = uname;
													Ext.getCmp('loginFormCnt').removeAll();
													//sessionStorage.setItem('baseForm', true);
													localStorage.setItem('cancelClicked', false);
													Ext.getCmp('loginFormCnt').add({xtype : 'twofaloginpage'});
													localStorage.setItem('loginUsr',realLoggedInUser);
													localStorage.setItem('loginPwd', tempUsrPwd);
													localStorage.setItem('loggedInUser',tempUsrName);

													Ext.getCmp('twofa_submit').on('click',function(){
														
														thisCtrl.proceedLogin(tempUsrName,tempUsrPwd,realLoggedInUser);
													});
													Ext.getCmp('otp').on('keydown',function(textbox,e,opts){
														if(e.getKey() == 13) // Enter Key
														{
															thisCtrl.proceedLogin(tempUsrName,tempUsrPwd,realLoggedInUser);
														}
													}, thisCtrl);

													Ext.getCmp('twofaloginpage').on('afterrender',function(){
														if (!Ext.isEmpty(realLoggedInUser))
														{
															var splitName = realLoggedInUser;
															if (!Ext.isEmpty(splitName) && splitName.length > 40)
															{
																splitName = splitName.substring(0,13) + '...' + splitName.substring(splitName.length-15);
															}
															Ext.getCmp('userIdLblCont').fullname = realLoggedInUser;
															Ext.get('userIdLbl').update(splitName);		
														}
														if (!Ext.isEmpty(resultPg[1]))
														{
															localStorage.setItem('mailAddr',resultPg[1]);
															Ext.getCmp('mailIdLabel').update('<span style="font-size:12px;font-weight:bold;color:#787878">Enter a verification code</span><br><br>A mail with a verification code was just sent to '+resultPg[1]);
														}

														Ext.getCmp('resendCode').getEl().on('click',function()
														{
															thisCtrl.resendOTP(tempUsrName,tempUsrPwd,realLoggedInUser);
														});
													});

													maxResendCount = thisCtrl.getMaxResendCount();
													localStorage.setItem('maxResendCount',maxResendCount);
													var cacheResndCnt = localStorage.resendCount;
													if (Ext.isEmpty(cacheResndCnt))
													{
														localStorage.setItem('resendCount',resendCount);
													}
													if (localStorage.resendCount < maxResendCount)
													{
														task.start();
													}

													//this.sendOTP(usrPwd);
													Ext.resumeLayouts(true);
												}
												// for 2fa - ends here
												else
												{
													me.clearLocalStorage();
													var pathname = window.location.pathname;
													localStorage.setItem('initiatedPath', pathname);
													window.location.href = "/final" + response.responseText;
												}
											}
										});
									}
								}
							}
						]
					}
				]
			}
		]);

	//	});

		loginform.doLayout();
		var grouptitle = Ext.getCmp("grouptitle");
		grouptitle.update(title);


		var uidcombo = Ext.getCmp("uid");
		uidcombo.setFieldLabel( screenLabels["admin.user.Choose a group"] );
		uidcombo.getStore().loadRawData(listgroupusers);
		uidcombo.setValue(listgroupusers_value);

		var gobutton = Ext.getCmp("gobutton");
		gobutton.setText(screenLabels["admin.user.GO"]);

		Ext.get("logindiv2").on('click',function(){
			me.loadLoginPage();
		});

	//	popup.show();
	},
	clearLocalStorage : function()
	{
		var tmpLocalStArr={};
		for (var i = 0; i < localStorage.length; i++)
		{
			// do something with localStorage.getItem(localStorage.key(i));
			var locStKey=localStorage.key(i);
			if(locStKey!=null && (locStKey.startsWith("ext-") && (locStKey.indexOf("grid_data_")>-1 || locStKey.indexOf("dd_grid_data_")>-1 || locStKey.indexOf("dataview_")>-1 || locStKey.indexOf("ddgrid_")>-1 || locStKey.indexOf("chart_grid_data_")>-1 || locStKey.indexOf("vmAlarmDetails_data_")>-1 || locStKey.indexOf("~!")>-1)))
			{
				tmpLocalStArr[locStKey]=localStorage.getItem(locStKey);
			}
		}
		localStorage.clear();
		if(!Ext.isEmpty(tmpLocalStArr))
		{
			for(var v in tmpLocalStArr)
			{
				localStorage.setItem(v,tmpLocalStArr[v]);
			}
		}
	},
	morerolewin : function(jsonObj)
	{
		var screenLabels = jsonObj.screenLabels;
		var title = jsonObj.titleStr;
		var uname = jsonObj.uname;
		var listRoleusers = jsonObj.listRoleusers;
		var listRoleusers_value = jsonObj.listRoleusers_value;
		var loginform = Ext.getCmp("loginform");
		loginform.removeAll();
		var meThis=this;
	//	var popup = Ext.widget('rolepopup', {

		loginform.add([
			{
				xtype : 'panel',
				margin : 0,
				bodyPadding : '10px 10px 10px 10px',
				items : [
					{
						xtype : 'container',
						html : '<div style="float:right;cursor:hand;" id="close1"><div class="iconClose" ></div></div>',
						listeners : {
						render : function() {
							Ext.get('close1').on('click', function() {
								Ext.get('closePopup1').hide();
								Ext.get('closePopup1').remove();
								});
							}
						}
					},
					{
						xtype:'container',
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						border:false,
						margin :0,
						bodyPadding :'0px',
						items: [
							{
								xtype:'container',
								margin :'0px 0px 20px 0px',
								align: 'stretch',
								bodyPadding :'0px',
								items:[
									{
										xtype : 'container',
										margin : 10,
										bodyPadding:'0px',
										id:'RoleTitle',
										html : ''
									}, 
									{
										xtype : 'scrollcombo',
										fieldLabel : 'role',
										labelAlign : 'top',
										id:'uid1',
										labelSeperator:'',
										name:'uid1',
										cls : 'dropdown',
										margin:'5px 10px 10px 10px',
										anchor:'100%',
										bodyPadding:'0px',
										flex:1,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										store:Ext.data.Store({
													fields:['displayField','valueField'],
													data:[]
											})
									}
								]
							}
						]
					}
				],
				buttons : [
					{
						xtype : 'button',
						action : '',
						cls: 'buttonBig',
						margin:'0px 10px 10px 0px',
						bodyPadding:'0px',
						id : 'gobutton1',
						name:'gobutton1',
						buttonAlign : 'right',
						disabled : false,
						text : 'Go',
						listeners: {
							click :function(e,opts) {
								var uidcombo1 = Ext.getCmp("uid1");
								var param = 'uname='+encodeURIComponent(uname)+'&requestFrom=MoreUserRoles&uid='+encodeURI(uidcombo1.getValue());
								if (uidcombo1.getValue() == "-1")
								{
									Ext.Msg.alert("please select a role");
								}
								else
								{
									Ext.Ajax.request({
										url:'/final/servlet/com.egurkha.LoginServlet',
										params:param,
										method:'POST',
										scope:this,
										success:function(response)
										{
											meThis.clearLocalStorage();
											window.location.href = "/final" + response.responseText;
										}
									});
								}
							}
						}
					}
				]
			}
		]);

		loginform.doLayout();
		var roleTitle = Ext.getCmp("RoleTitle");
		roleTitle.update(title);
		var uidcombo = Ext.getCmp("uid1");
		uidcombo.setFieldLabel( screenLabels["admin.user.Choose a Role"] );
		uidcombo.getStore().loadRawData(listRoleusers);
		uidcombo.setValue(listRoleusers_value);
		uidcombo.setValue(uidcombo.getStore().getAt(0));
		var gobutton = Ext.getCmp("gobutton1");
		gobutton.setText(screenLabels["admin.user.GO"]);

	//	popup.show();
	},
	showUserTips : function()
	{
		var loginHelpUIObj = Ext.getCmp('loginHelpUI');
		if (loginHelpUIObj != null && loginHelpUIObj != undefined && !loginHelpUIObj.isHidden())
		{

			var xPos=Ext.getCmp('username').getBox().x;
			var yPos=Ext.getCmp('username').getBox().y;
			loginHelpUIObj.showAt([(xPos+200),(yPos-115)]);
		}
	}
});

function postCustomFormSubmit(QString)
{
	var url = '';
	var params = '';
	var len = QString.indexOf('?');
	if (len > -1)
	{
		url = QString.substring(0,len);
		params = QString.substring(len+1);
	}

	var strArr = params.split('&');

	var form = document.createElement('form');
	form.setAttribute('method', 'post');
	form.setAttribute('action', url);

	for (var i=0; i<strArr.length; i++) 
	{
		var name = '';
		var value = '';
		var paramValue = strArr[i];
		var paramLen = paramValue.indexOf('=');
		if (paramLen > -1)
		{
			name = paramValue.substring(0,paramLen);
			value = paramValue.substring(paramLen+1);
		}
		if (strArr.hasOwnProperty(i)) 
		{
			var hiddenField = document.createElement('input');
			hiddenField.setAttribute('type', 'hidden');
			hiddenField.setAttribute('name', name);
			hiddenField.setAttribute('value', value);

			form.appendChild(hiddenField);
		}
	}

	document.body.appendChild(form);
	form.submit();
}