
Ext.define('utilities.CheckCombobox', {
	extend: 'Ext.form.field.ComboBox',
	alias: 'widget.checkcombobox',
	multiSelect: true,
	allSelector: false,
	noData: false,
	noDataText: 'No combo data',
	addAllSelector: false,
	allSelectorHidden: false,
	disableSearch: true,
	enableKeyEvents: true,
	afterExpandCheck: false,
	editable: false,
	allText: 'All',
	lastQuery: null,
	oldValue: '',

	createPicker: function () {
		var me = this,
			picker,
			menuCls = Ext.baseCSSPrefix + 'menu',
			opts = Ext.apply({
				pickerField: me,
				selModel: {
					mode: me.multiSelect ? 'SIMPLE' : 'SINGLE'
				},
				floating: true,
				hidden: true,
				ownerCt: me.ownerCt,
				cls: me.el.up('.' + menuCls) ? menuCls : '',
				store: me.store,
				displayField: me.displayField,
				
				listeners: {
					
					itemclick: function (picker, record, item, index, e, eOpts) {
						if(!Ext.isEmpty(Ext.getCmp('searchCom-' + me.id + ''))){
							Ext.getCmp('searchCom-' + me.id + '').setValue('');
							Ext.getCmp('searchCom-' + me.id + '').focus(10);
							me.store.clearFilter();	
						}
																				
					},
				},
				focusOnToFront: false,
				pageSize: me.pageSize,
				tpl: [
					'<ul><tpl for=".">',
					'<tpl if="stateField">',
					'<li role="option" style="white-space: nowrap" class="' + Ext.baseCSSPrefix + 'boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{stateField}"><span class="x-combo-checker">&nbsp;</span> {' + me.displayField + '}</li>',
					'<tpl else>',
					'<li role="option" style="white-space: nowrap" class="' + Ext.baseCSSPrefix + 'boundlist-item"><span class="x-combo-checker">&nbsp;</span> {' + me.displayField + '}</li>',
					'</tpl>',
					'</tpl>',
					'</ul>'
				]
			}, me.listConfig, me.defaultListConfig);
		picker = me.picker = Ext.create('Ext.view.BoundList', opts);
		if (me.pageSize) {
			picker.pagingToolbar.on('beforechange', me.onPageChange, me);
		}
		me.mon(picker, {
			itemclick: me.onItemClick,
			refresh: me.onListRefresh,
			scope: me
		});
		me.mon(picker.getSelectionModel(), {
			'beforeselect': me.onBeforeSelect,
			'beforedeselect': me.onBeforeDeselect,
			'selectionchange': me.onListSelectionChange,
			scope: me
		}, me);
		me.tempValues = me.getValue().split(',');

		me.store.each(function (record, index) {
			if (Ext.isEmpty(record.data.select)) {
				if (me.tempValues[index] == record.data[me.valueField]) {
					record.set('select', true);
				}
			}
		});
		
		me.store.on('load', function (store) {
			if (store.getTotalCount() == 0) {
				me.allSelectorHidden = true;
				if (me.allSelector != false) me.allSelector.setStyle('display', 'none');
				//  if(me.noData != false) me.noData.setStyle('display', 'block');
			} else {
				me.allSelectorHidden = false;
				if (me.allSelector != false) me.allSelector.setStyle('display', 'block');
				// if(me.noData != false) me.noData.setStyle('display', 'none');
			}
		});


		return picker;
	},
	reset: function () {
		var me = this;
		me.setValue('');
	},
	
	setValue: function (value) {
		this.value = value;
		if (!value) {
			if (this.allSelector != false) this.allSelector.removeCls('x-boundlist-selected');
			return this.callParent(arguments);
		}

		if (typeof value == 'string') {
			var me = this,
				records = [],
				vals = value.split(',');
			if (value == '') {
				if (me.allSelector != false) me.allSelector.removeCls('x-boundlist-selected');
			} else {
				if (vals.length == me.store.getCount() && vals.length != 0) {
					if (me.allSelector != false) me.allSelector.addCls('x-boundlist-selected');
					else me.afterExpandCheck = true;
				}
			}

			Ext.each(vals, function (val) {
				//var record = me.store.getById(parseInt(val));
				var record = me.store.findRecord(me.valueField, val, 0, false, true, true);
				if (record) {
					records.push(record);
					record.set('select', true);
				}
			});
			
			return me.setValue(records);
		} else return this.callParent(arguments);
	},
	getValue: function () {
		if (typeof this.value == 'object') return this.value.join(',');
		else return this.value;
	},
	getSubmitValue: function () {
		return this.getValue();
	},
	disableAllSelector: false,
	isLastRecord: Ext.emptyFn,
	onCollapse: function () {
		var me = this;
		//me.typing = false;
		if (!Ext.isEmpty(Ext.getCmp('searchCom-' + me.id + ''))) {
			Ext.getCmp('searchCom-' + me.id + '').destroy();
			me.collectionItems.removeAll(me.collectionItems.items);
			me.store.clearFilter(true);
			me.store.filterBy(function (record) {
				return true;
			});
		}
	},
	filterGrid: function (property, value) {

		var grid = this;
		if (grid.store.filters) {
			grid.store.filters.each(function (item) {
				if (item.property === property) {
					grid.store.clearFilter(true);
				}
			})
		};
		var matcher = new RegExp(Ext.String.escapeRegex(value), "i");
		if (matcher) {
			grid.store.filter({
				filterFn: function (record) {
					return matcher.test(record.get(property));
				}
			});

			if (!Ext.isEmpty(grid.store.filters.getAt(grid.store.filters.length - 1))) {
				grid.store.filters.getAt(grid.store.filters.length - 1).property = property;
			}
		} else {
			grid.store.clearFilter(true);
		}
	},
	typeAhead: true,
	isLocalMode: false,
	doQuery: function(queryString, forceAll, rawQuery) {
        queryString = queryString || '';

        // store in object and pass by reference in 'beforequery'
        // so that client code can modify values.
        var me = this,
            qe = {
                query: queryString,
                forceAll: forceAll,
                combo: me,
                cancel: false
            },
            store = me.store,
            isLocalMode = me.queryMode === 'local',
            needsRefresh;

        if (me.fireEvent('beforequery', qe) === false || qe.cancel) {
            return false;
        }

        // get back out possibly modified values
        queryString = qe.query;
        forceAll = qe.forceAll;

        // query permitted to run
        if (forceAll || (queryString.length >= me.minChars)) {
            // expand before starting query so LoadMask can position itself correctly
            me.expand();

            // make sure they aren't querying the same thing
            if (!me.queryCaching || me.lastQuery !== queryString) {
                me.lastQuery = queryString;

                if (isLocalMode) {
                    // forceAll means no filtering - show whole dataset.
                    store.suspendEvents();
                    needsRefresh = me.clearFilter();
                    if (queryString || !forceAll) {
                        me.activeFilter = new Ext.util.Filter({
                            root: 'data',
                            property: me.displayField,
                            value: queryString
                        });
                        store.filter(me.activeFilter);
                        needsRefresh = true;
                    } else {
                        delete me.activeFilter;
                    }
                    store.resumeEvents();
                    if (me.rendered && needsRefresh) {
                        me.getPicker().refresh();
                    }
                } else {
                    // Set flag for onLoad handling to know how the Store was loaded
                    me.rawQuery = rawQuery;

                    // In queryMode: 'remote', we assume Store filters are added by the developer as remote filters,
                    // and these are automatically passed as params with every load call, so we do *not* call clearFilter.
                    if (me.pageSize) {
                        // if we're paging, we've changed the query so start at page 1.
                        me.loadPage(1);
                    } else {
                        store.load({
                            params: me.getParams(queryString)
                        });
                    }
                }
            }

            // Clear current selection if it does not match the current value in the field
            if (me.getRawValue() !== me.getDisplayValue()) {
                me.ignoreSelection++;
                me.picker.getSelectionModel().deselectAll();
                me.ignoreSelection--;
            }

            if (isLocalMode) {
                me.doAutoSelect();
            }
            if (me.typeAhead) {
                me.doTypeAhead();
            }
        }
		if(!Ext.isEmpty(Ext.getCmp('searchCom-' + me.id + ''))){
			Ext.getCmp('searchCom-' + me.id + '').focus(10);
		}
        return true;
    },
	expand: function () {
		var me = this,
			bodyEl, picker, collapseIf;
			me.store.clearFilter(true);

		if (me.rendered && !me.isExpanded && !me.isDestroyed) {
			me.collectionItems.removeAll(me.collectionItems.items);
			me.tempValues = me.getValue();
			bodyEl = me.bodyEl;
			picker = me.getPicker();
			collapseIf = me.collapseIf;
			// show the picker and set isExpanded flag
			picker.show();
			me.isExpanded = true;
			me.alignPicker();
			bodyEl.addCls(me.openCls);
			// if(me.noData == false) me.noData = picker.getEl().down('.x-boundlist-list-ct').insertHtml('beforeBegin', '<div class="x-boundlist-item" role="option">'+me.noDataText+'</div>', true);
			//me.typing = false;
			var task = new Ext.util.DelayedTask(function(){
				//console.log(Ext.getCmp('searchCom-' + me.id + '').getValue());
				me.picker.getSelectionModel().suspendEvents();
				var queryValue = Ext.getCmp('searchCom-' + me.id + '').getValue();
				me.doQuery(queryValue,false,false);
				me.picker.getSelectionModel().resumeEvents();
			});
			if (me.disableSearch) {
				picker.getEl().down('.x-boundlist-list-ct').insertHtml('beforeBegin', '<div id="search-' + me.id + '"></div>', true);
				Ext.defer(function () {
					me.searchField = Ext.create('Ext.form.field.Text', {
						id: 'searchCom-' + me.id + '',
						width: picker.getWidth() - 2,
						emptyText: "Search",
						renderTo: 'search-' + me.id + '',
						enableKeyEvents: true,
						listeners: {
							keyup: function (field, e) {
								
								if (field.getValue() === '') {
									me.store.clearFilter();
								} else {
									//me.typing = true;
									me.store.clearFilter(true);
									
									//me.filterGrid(me.displayField, field.getValue());
									//me.doQuery(field.getValue(),false,false)
									task.delay(500);
									
									
								}
							}
						}
					});
					me.searchField.focus(100, true);
				}, 10);
			}



			if (me.addAllSelector == true && me.allSelector == false) {
				if (me.disableAllSelector) {
					me.allSelector = picker.getEl().down('.x-boundlist-list-ct').insertHtml('beforeBegin', '<div class="x-boundlist-item disable" role="option" style="display:none;"><span class="x-combo-checker">&nbsp;</span> ' + me.allText + '</div>', true);
				} else {
					me.allSelector = picker.getEl().down('.x-boundlist-list-ct').insertHtml('beforeBegin', '<div class="x-boundlist-item" role="option" style="display:none;"><span class="x-combo-checker">&nbsp;</span> ' + me.allText + '</div>', true);
				}

				me.allSelector.on('click', function (e) {

					if (me.disableAllSelector) return;
					me.store.clearFilter();
					if (me.allSelector.hasCls('x-boundlist-selected')) {
						
						var records = [],
						allRecords = me.store.snapshot || me.store.data;
						allRecords.each(function (record) {
							record.set('select', false);
							records.push(record);
						});
						me.allSelector.removeCls('x-boundlist-selected');
						Ext.defer(function(){
							me.select('');
							//console.log('me.allSelector records', records)
							me.fireEvent('select', me, records);
						},100);
						

					} else {
						var records = [],
						allRecords = me.store.snapshot || me.store.data;
						allRecords.each(function (record) {
							//console.log('SelectAll', record);
							record.set('select', true);
							records.push(record);
						});
						me.allSelector.addCls('x-boundlist-selected');

						//TODO
						Ext.defer(function(){
							me.select(records);
							me.fireEvent('select', me, records);
						},100);
						
					}
				});
				// FIX checking the value if all select , split method to make as array.
				var selectedRecords = me.getValue().split(',');
				if (selectedRecords.length == me.store.getTotalCount()) {
					me.allSelector.addCls('x-boundlist-selected');
				} else {
					me.allSelector.removeCls('x-boundlist-selected');
				}

				if (me.allSelectorHidden == true) me.allSelector.hide();
				else me.allSelector.show();
				if (me.afterExpandCheck == true) {
					me.allSelector.addCls('x-boundlist-selected');
					me.afterExpandCheck = false;
				}
			}
			// monitor clicking and mousewheel
			me.mon(Ext.getDoc(), {
				mousewheel: collapseIf,
				mousedown: collapseIf,
				scope: me
			});
			Ext.EventManager.onWindowResize(me.alignPicker, me);
			me.fireEvent('expand', me);
			me.onExpand();
		} else {
			me.fireEvent('expand', me);
			me.onExpand();
		}
	},
	
	alignPicker: function () {
		var me = this,
			picker = me.getPicker();
		me.callParent();
		if (me.addAllSelector == true) {
			var height = picker.getHeight();
			height = parseInt(height) + 20;
			//picker.setHeight(height);
			//picker.getEl().setStyle('height', height + 'px');
		}
	},
	collectionItems: new Ext.util.MixedCollection(),
	onSelectionChangeFilter_: function (allRecordsx) {
		var me = this,
			allRecords = me.store.snapshot || me.store.data,
			collectionItems = me.collectionItems;
		if (!Ext.isEmpty(allRecordsx)) {
			collectionItems.addAll(allRecordsx.items);
			me.Filter = new Ext.util.Filter({
				filterFn: function (item) {
					return item.data.select;
				}
			});

			return collectionItems.filter(me.Filter);
		} else {
			return [];
		}

	},
	onListSelectionChange: function(list, selectedRecords) {
			
		var me = this,
			isMulti = me.multiSelect,
			hasRecords = selectedRecords.length > 0;
		// Only react to selection if it is not called from setValue, and if our list is
		// expanded (ignores changes to the selection model triggered elsewhere)
		if (!me.ignoreSelection && me.isExpanded) {
			if (!isMulti) {
				Ext.defer(me.collapse, 1, me);
			}
			/*
			 * Only set the value here if we're in multi selection mode or we have
			 * a selection. Otherwise setValue will be called with an empty value
			 * which will cause the change event to fire twice.
			 */
			if (isMulti || hasRecords) {
				me.setValue(selectedRecords, false);
			}
			//if (hasRecords) {
				me.fireEvent('select', me, selectedRecords);
			//}
			me.inputEl.focus();
			if(selectedRecords.length == 0){
				me.isLastRecord();
			}
			if (me.addAllSelector == true && me.allSelector != false) {
				if (selectedRecords.length == me.store.getTotalCount()){
					me.allSelector.addCls('x-boundlist-selected');
				}
				else{
					me.allSelector.removeCls('x-boundlist-selected');
				}
			}
		}
	}
});