/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgAPMInfo {
    public static final String apmTestsSection = new String("APM_TESTS");
    public static final String apmTypesSection = "APM_TEST_TYPE";
    public static final String apmTestTablesSection = "ALL_TEST_TABLES";
    public static final String relatedExternalTables = "RELATED_EXTERNAL_TABLES";
    public static final String apmTestColumnMappingSection = "TABLE_COLUMN_MAPPING";
    public static final String apmPointCutSection = "POINTCUT_NAMES";
    public static final String apmPointCutImageSection = "POINTCUT_IMAGENAMES";
    public static final String apmChildPointcutTimeChangeSection = "CHILDPOINTCUT_TIME_MAPPING";
    public static final String apmChildPointcutCountChangeSection = "CHILDPOINTCUT_COUNT_MAPPING";
    public static final String USERNAME_TRACKING = "USERNAME_TRACKING";
    public static final String USERNAME_TRACKING_CONFIG = "USERNAME_TRACKING_CONFIG";
    private static final String ICON_MAPPING = "ICON_MAPPING";
    private static final String MISC_OPTIONS = "MISC_OPTIONS";
    private static final String DATA_HASHING = "DATA_HASHING";
    private static final String APM_CONFIGS = "APM_CONFIGS";
    private static IniFile apmFilePtr;
    private static File apmFile;
    private static String apmFileName;
    private static long lastModifiedTime;
    private static long lastSize;
    private static Vector apmTests;
    private static HashMap apmTestHash;
    private static boolean apmType;

    public static void main(String[] stringArray) {
        EgAPMInfo egAPMInfo = new EgAPMInfo("manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgAPMInfo(String string) {
        if (apmFileName == null) {
            String string2 = apmTestsSection;
            synchronized (string2) {
                if (apmFileName == null) {
                    apmFileName = string.equals("agent") ? EgConfigInfo.egAgentConfigDir + "eg_apm.ini" : EgConfigInfo.egMgrConfigDir + "eg_apm.ini";
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    apmFilePtr = new IniFile(apmFileName, false);
                    this.apmTests();
                    apmTestHash.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = apmTestsSection;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l != lastModifiedTime || l2 != lastSize) {
                lastModifiedTime = l;
                lastSize = l2;
                apmFilePtr = new IniFile(apmFileName, false);
                this.apmTests();
                apmTestHash.clear();
                return true;
            }
        }
        return false;
    }

    private Vector apmTests() {
        apmTests.clear();
        String[] stringArray = apmFilePtr.getVariables(apmTestsSection);
        if (stringArray == null) {
            return apmTests;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            apmTests.add(stringArray[i]);
        }
        return apmTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAPMTest(String string) {
        this.checkForUpdate();
        Boolean bl = (Boolean)apmTestHash.get(string);
        if (bl != null) {
            return bl;
        }
        if (apmTests == null) {
            return false;
        }
        String string2 = apmTestsSection;
        synchronized (string2) {
            if (apmTests.contains(string)) {
                apmTestHash.put(string, new Boolean(true));
                return true;
            }
            apmTestHash.put(string, new Boolean(false));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAPMType(String string) {
        String string2 = "";
        String string3 = apmTestsSection;
        synchronized (string3) {
            string2 = apmFilePtr.getValue(apmTypesSection, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPointCutInIni(String string, String string2) {
        boolean bl = false;
        String string3 = "";
        Object object = apmTestsSection;
        synchronized (object) {
            string3 = apmFilePtr.getValue(apmPointCutSection, string);
        }
        object = new StringTokenizer(string3, ",");
        StringBuffer stringBuffer = new StringBuffer();
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string4 = ((StringTokenizer)object).nextToken();
            if (!string4.equalsIgnoreCase(string2)) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String changeChildPointcutCount(String string) {
        String string2 = "";
        if (string != null) {
            string = string.toUpperCase();
            String string3 = apmTestsSection;
            synchronized (string3) {
                string2 = apmFilePtr.getValue(apmChildPointcutCountChangeSection, string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String changeChildPointcutTime(String string) {
        String string2 = "";
        if (string != null) {
            string = string.toUpperCase();
            String string3 = apmTestsSection;
            synchronized (string3) {
                string2 = apmFilePtr.getValue(apmChildPointcutTimeChangeSection, string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPointCutImageName(String string) {
        String string2 = "";
        if (string != null) {
            string = string.toUpperCase();
            String string3 = apmTestsSection;
            synchronized (string3) {
                string2 = apmFilePtr.getValue(apmPointCutImageSection, string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIcon(String string) {
        String string2 = "";
        if (string != null) {
            String string3 = apmTestsSection;
            synchronized (string3) {
                string2 = apmFilePtr.getValue(ICON_MAPPING, string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxLength() {
        int n = 32;
        String string = null;
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(MISC_OPTIONS, "MAX_LENGTH");
        }
        if (string != null && string.length() > 0) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                n = 32;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAPMTestTables() {
        String string = "";
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(apmTestTablesSection, "TABLES");
        }
        return string;
    }

    public boolean isAPMTypeJava(String string) {
        String string2 = this.getAPMType(string);
        if (string2.equalsIgnoreCase("Java")) {
            apmType = true;
        }
        return apmType;
    }

    public long lastModified() {
        return IniFile.getLastModified(apmFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(apmFileName);
    }

    private ArrayList myTokenizer(String string, char c) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            arrayList.add(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        string2 = string.substring(n);
        arrayList.add(string2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRelatedExternalTables(String string) {
        ArrayList arrayList = null;
        String string2 = "";
        String string3 = apmTestsSection;
        synchronized (string3) {
            string2 = apmFilePtr.getValue(relatedExternalTables, string);
        }
        if (string2 != null && string2.length() > 0) {
            arrayList = this.myTokenizer(string2, ',');
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllApmTests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        String string = apmTestsSection;
        synchronized (string) {
            stringArray = apmFilePtr.getVariables(apmTestsSection);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnNameForTest(String string) {
        String string2 = "";
        if (string != null) {
            string = string.toUpperCase();
            String string3 = apmTestsSection;
            synchronized (string3) {
                string2 = apmFilePtr.getValue(apmTestColumnMappingSection, string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistsUnderUserNameTracking(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null) {
            String string3 = "";
            String string4 = apmTestsSection;
            synchronized (string4) {
                string3 = apmFilePtr.getValue(USERNAME_TRACKING, string);
            }
            if (string2.equals(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSessionDetailsCleanupPeriod() {
        String string = null;
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(USERNAME_TRACKING_CONFIG, "CleanupInterval");
        }
        long l = 30L;
        return this.getTimeInMillis(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSessionDetailsWriteFrequency() {
        String string = null;
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(USERNAME_TRACKING_CONFIG, "WriteInterval");
        }
        long l = 6L;
        return this.getTimeInMillis(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getThreadSleepPeriod() {
        String string = null;
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(USERNAME_TRACKING_CONFIG, "CheckInterval");
        }
        long l = 3L;
        return this.getTimeInMillis(string, l);
    }

    private long getTimeInMillis(String string, long l) {
        long l2;
        if (string != null && string.trim().length() > 0) {
            try {
                l2 = Long.parseLong(string);
                if (l2 > 0L) {
                    l = l2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        l2 = l * 60L * 1000L;
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String string, String string2) {
        String string3 = "";
        String string4 = apmTestsSection;
        synchronized (string4) {
            string3 = apmFilePtr.getValue(string, string2);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHashingBoundaryLimit() {
        long l = -1L;
        String string = "";
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(DATA_HASHING, "HashingBoundaryLimit");
        }
        if (string != null && string.trim().length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l < 1L) {
            l = 50000L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHashingUpdateInterval() {
        long l = -1L;
        String string = "";
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(DATA_HASHING, "HashingUpdateInterval");
        }
        if (string != null && string.trim().length() > 0) {
            try {
                long l2 = Long.parseLong(string);
                if (l2 > 0L && l2 <= 24L) {
                    l = l2 * 60L * 60L * 1000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l <= 0L) {
            l = 43200000L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApmConfigSendToCleanupPeriod() {
        String string = null;
        String string2 = apmTestsSection;
        synchronized (string2) {
            string = apmFilePtr.getValue(APM_CONFIGS, "CleanupInterval");
        }
        long l = 15L;
        return this.getTimeInMillis(string, l);
    }

    static {
        apmFile = null;
        apmFileName = null;
        apmTests = new Vector();
        apmTestHash = new HashMap();
        apmType = false;
    }
}

