/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class EgCheckSm {
    private String urlString = "";
    private boolean isSsl = false;
    private String managerIP = null;
    private String managerPort = null;
    private String sep = System.getProperty("file.separator");
    private String installDir = EgInstallInfo.getInstallDir();
    private boolean isRunning = false;
    private boolean restart = false;
    private static EgConfigInfo configInfo = new EgConfigInfo("manager");
    private boolean isSslRestart = false;
    private IniFile iniFile = null;

    public EgCheckSm() {
        if (!this.installDir.endsWith(this.sep)) {
            this.installDir = this.installDir + this.sep;
        }
        boolean bl = this.collectManagerDetails();
        this.urlString = this.isSsl ? "https://" : "http://";
        if (bl) {
            this.urlString = this.urlString + this.managerIP + ":" + this.managerPort + "/final/servlet/com.eg.StartSM";
            this.isRunning = this.checkManager();
            if (!this.isRunning) {
                this.restart = this.restartManager();
                if (this.restart) {
                    EgCheckSm.logToErrorFile("INFO ", " eG SuperManager was not running .", "So restarted the eG SuperManager.");
                } else {
                    EgCheckSm.logToErrorFile("ERROR ", " ", "Could not restart the eG SuperManager.");
                }
            }
        } else {
            System.out.println("ERROR : Super Manager Could not collect the manager details.");
        }
    }

    private boolean collectManagerDetails() {
        File file = new File(this.installDir + "manager" + this.sep + "config" + this.sep + "eg_setup.ini");
        File file2 = new File(this.installDir + "manager" + this.sep + "config" + this.sep + "eg_supermanager.ini");
        this.iniFile = new IniFile(file.toString());
        this.managerIP = this.iniFile.getValue("SETTINGS", "EG_SERVER");
        this.managerPort = this.iniFile.getValue("SETTINGS", "EG_PORT");
        String string = this.iniFile.getValue("SETTINGS", "SSL");
        this.iniFile = new IniFile(file2.toString());
        String string2 = this.iniFile.getValue("MANAGER_RESTART", "SSL_RESTART");
        this.isSsl = "true".equalsIgnoreCase(string);
        boolean bl = this.isSslRestart = "true".equalsIgnoreCase(string2);
        return this.managerPort != null && this.managerIP != null && this.managerPort.length() > 0 && this.managerIP.length() > 0 && (!this.isSsl || this.isSslRestart);
    }

    private boolean checkManager() {
        try {
            URL uRL = new URL(this.urlString);
            HttpURLConnection httpURLConnection = null;
            if (this.isSsl) {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.connect();
                    int n = httpURLConnection.getResponseCode();
                    httpURLConnection.disconnect();
                    if (n == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        return false;
    }

    private boolean restartManager() {
        BufferedReader bufferedReader = null;
        String string = this.installDir + "\\lib\\start_sm.bat";
        bufferedReader = EgCheckSm.executeProgram(string);
        if (bufferedReader != null) {
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return true;
            }
            catch (Exception exception) {
                System.out.println("EgCheckSm: " + exception.toString());
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return false;
            }
        }
        System.out.println("EgCheckSm: executeProgram returned null");
        return false;
    }

    private static BufferedReader executeProgram(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(string);
            if (process == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        File file = new File(EgConfigInfo.egMgrErrorFile);
        if (file.length() >= 5000000L) {
            EgInstallInfo.fileRename(EgConfigInfo.egMgrErrorFile, EgConfigInfo.egMgrErrorFile + ".1");
        }
        file = null;
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egMgrErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + " " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        EgCheckSm egCheckSm = new EgCheckSm();
    }
}

