/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;

public class EgDatabaseCreation
extends EgConfigInfo {
    String domain = null;
    public static String entity = "setup_manager";
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    public File file;
    public Connection conn = null;
    public Statement stmt = null;
    public static String host;
    public static String sid;
    public static String port;
    public String url;
    public String user;
    public String password;
    public String pathDir;
    public String dbName;
    public String ssl;
    public String ntlmV2;
    public String database;
    public String errorMsg = " ";
    public static IniFile iniFile;
    public static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;
    public String instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = null;
        try {
            System.setProperty("jsse.enableCBCProtection", "false");
            printStream = new PrintStream(new FileOutputStream(egMgrErrorFile, true));
            System.setOut(printStream);
            System.setErr(printStream);
            System.out.println("==============EgDatabaseCreation starts==============");
            String string = "";
            if (stringArray.length < 15) {
                System.out.println("Usage:- java EgDatabaseCreation -host <hostname>  -port <portNo> -dbauser <DbUser>  -dbapassword <UserPasswd> -database <database name> -instance <instance name> -ssl <ssl> -ntlmv2 <true / false>");
                return;
            }
            if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-dbauser") && stringArray[6].equals("-dbapassword") && stringArray[8].equals("-database") && stringArray[10].equals("-instance") && stringArray[12].equals("-ssl") && stringArray[14].equals("-ntlmv2"))) {
                System.out.println("Usage:- java EgDatabaseCreation -host <hostname>  -port <portNo> -dbauser <DbUser>  -dbapassword <UserPasswd> -database <database name> -instance <instance name> -ssl <ssl> -ntlmv2 <true / false>");
                return;
            }
            EgDatabaseCreation egDatabaseCreation = new EgDatabaseCreation(stringArray);
            int n = egDatabaseCreation.createDatabase();
            string = n == 1 ? "1" : (n == 2 ? "2" : (n == 3 ? "3" : (n == 4 ? "4" : "0")));
            System.out.println("result " + string);
            iniFile.setValue("DATABASE CREATION", "CREATED", string);
            iniFile.saveFile();
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
        finally {
            if (printStream != null) {
                System.out.println("==============EgDatabaseCreation ends==============");
                printStream.close();
            }
        }
    }

    public EgDatabaseCreation(String[] stringArray) {
        host = stringArray[1];
        port = stringArray[3];
        this.user = stringArray[5];
        int n = this.user.indexOf("\\");
        if (n < 0) {
            n = this.user.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.user.substring(0, n);
            this.user = this.user.substring(n + 1);
        }
        this.password = stringArray[7];
        this.database = stringArray[9];
        this.instance = stringArray[11];
        this.ssl = "";
        if (stringArray.length > 13) {
            this.ssl = stringArray[13];
            if (this.ssl != null && this.ssl.equalsIgnoreCase("NO")) {
                this.ssl = "";
            }
        }
        if (stringArray.length > 15) {
            this.ntlmV2 = stringArray[15];
        }
        this.createSetupFile();
    }

    public void createSetupFile() {
        System.out.println("getSetupFile() " + this.getSetupFile());
        iniFile = new IniFile(this.getSetupFile(), true);
        iniDBFile = new IniFile(this.configInfo.getDbFile(), true);
    }

    public int createDatabase() {
        String string = "";
        boolean bl = false;
        if (!this.connect()) {
            return 3;
        }
        try {
            this.stmt = this.conn.createStatement();
            String string2 = new String("create database \"" + this.database + "\" collate SQL_Latin1_General_CP1_CI_AS");
            this.stmt.executeUpdate(string2);
            string = "ALTER DATABASE \"" + this.database + "\" SET RECOVERY SIMPLE";
            this.stmt.executeUpdate(string);
        }
        catch (Exception exception) {
            System.out.println("ERROR" + exception);
            String string3 = exception.getMessage();
            if (string3.indexOf("already exists.,") >= 0) {
                return 2;
            }
            if (string3.indexOf("near the keyword") >= 0) {
                return 4;
            }
            return 1;
        }
        this.closeConnection();
        return 0;
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error when close the database connection ..";
            return;
        }
    }

    public void getInfo() {
        try {
            this.dbDriver = iniDBFile.getValue("DB_PROPERTIES", "sql.driver");
            this.dbUrl = this.instance.equalsIgnoreCase("none") || this.instance.equalsIgnoreCase("null") ? "jdbc:jtds:sqlserver://" + host + ":" + port + "/master;charset=utf8" : "jdbc:jtds:sqlserver://" + host + "/master;INSTANCE=" + this.instance + ";charset=utf8";
            if (this.ssl.length() > 0) {
                this.dbUrl = this.dbUrl + this.ssl;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
    }

    boolean connect() {
        try {
            this.getInfo();
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            if (this.domain == null || this.domain.equals("none")) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            System.out.println("Exceptione " + exception);
            exception.printStackTrace();
            this.errorMsg = "Database connection failed ...";
            return false;
        }
        return true;
    }
}

