/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.SSHThread;
import com.eg.SSHThreadUsingJSCH;
import java.util.ArrayList;

public class EgJavaSSH {
    String hostName = "";
    String userName = "";
    String pass = "";
    String cmd = "";
    int port = 22;
    public long timeOut = EgConfigInfo.msecPerMin * 1L;

    public EgJavaSSH(String string, int n, String string2, String string3) {
        this.hostName = string;
        this.port = n;
        this.userName = string2;
        this.pass = string3;
    }

    public EgJavaSSH(String string, int n, String string2, String string3, long l) {
        this.hostName = string;
        this.port = n;
        this.userName = string2;
        this.pass = string3;
        this.timeOut = l * 1000L;
    }

    public EgJavaSSH(String string, String string2, String string3, String string4, long l) {
        this.hostName = string;
        int n = 22;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = n;
        this.userName = string3;
        this.pass = string4;
        this.timeOut = l * 1000L;
    }

    public ArrayList executeCommand(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        SSHThread sSHThread = new SSHThread(this.hostName, this.userName, this.pass, this.port);
        sSHThread.setTimeOut(this.timeOut);
        sSHThread.executeCommand(string);
        boolean bl = this.checkForTimeout(sSHThread);
        ArrayList arrayList = null;
        if (bl) {
            arrayList = sSHThread.data;
        }
        if (arrayList == null || arrayList.size() < 2) {
            sSHThread.closeConnection();
            return null;
        }
        sSHThread.closeConnection();
        return arrayList;
    }

    public ArrayList executeCommandWithHighSecure(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        SSHThreadUsingJSCH sSHThreadUsingJSCH = new SSHThreadUsingJSCH(this.hostName, this.userName, this.pass, this.port);
        sSHThreadUsingJSCH.setTimeOut(this.timeOut);
        sSHThreadUsingJSCH.executeCommand(string);
        boolean bl = this.checkForTimeout2(sSHThreadUsingJSCH);
        ArrayList arrayList = null;
        if (bl) {
            arrayList = sSHThreadUsingJSCH.data;
        }
        if (arrayList == null || arrayList.size() < 2) {
            return null;
        }
        return arrayList;
    }

    private boolean checkForTimeout2(SSHThreadUsingJSCH sSHThreadUsingJSCH) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            this.suspendForPeriod(l3);
            if (sSHThreadUsingJSCH.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeOut) {
                sSHThreadUsingJSCH.interrupt();
                Thread.currentThread();
                Thread.yield();
                sSHThreadUsingJSCH.stop();
                return false;
            }
            l = l3;
            if (this.timeOut - l2 >= l) continue;
            l = this.timeOut - l2;
        } while ((l3 = l) > 0L);
        sSHThreadUsingJSCH.interrupt();
        Thread.currentThread();
        Thread.yield();
        sSHThreadUsingJSCH.stop();
        return false;
    }

    private boolean checkForTimeout(SSHThread sSHThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            this.suspendForPeriod(l3);
            if (sSHThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeOut) {
                sSHThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                sSHThread.stop();
                return false;
            }
            l = l3;
            if (this.timeOut - l2 >= l) continue;
            l = this.timeOut - l2;
        } while ((l3 = l) > 0L);
        sSHThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        sSHThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java EgJavaSSH <ip> <port> <user> <pass>");
            System.exit(-1);
        }
        EgJavaSSH egJavaSSH = new EgJavaSSH(stringArray[0], stringArray[1], stringArray[2], stringArray[3], 5L);
        String string = "hostname";
        ArrayList arrayList = egJavaSSH.executeCommand(string);
        System.out.println(arrayList);
    }
}

