/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.MultiThreadDDConfigTask;
import com.eg.MultiThreadDDLogger;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class EgThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final ReentrantLock lockObj = new ReentrantLock();
    private static EgThreadPoolExecutor executor = null;
    private static final String[] configKeys = new String[]{"Default", "Above500", "Above750", "Above1000"};
    private static final HashMap<String, int[]> configMap = new HashMap();
    private static String currentConfig = configKeys[0];
    private int counter;

    private EgThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    public static EgThreadPoolExecutor getExecutor(boolean bl) {
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EgThreadPoolExecutor getExecutor(int n, int n2, int n3, long l) {
        if (executor != null) return executor;
        boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
        Class<EgThreadPoolExecutor> clazz = EgThreadPoolExecutor.class;
        synchronized (EgThreadPoolExecutor.class) {
            if (executor != null) return executor;
            ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(n3);
            executor = new EgThreadPoolExecutor(n, n2, l, TimeUnit.MILLISECONDS, arrayBlockingQueue);
            if (bl) {
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "**********************************************************************************************************************************************");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "                                       EgThreadPoolExecutor is created with the following properties                                           ");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "**********************************************************************************************************************************************");
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "CorePool Size :" + n + " Max.Pool Size : " + n2 + " KeepAlive Time :" + l + " ms & Queue Size :" + arrayBlockingQueue.remainingCapacity());
                MultiThreadDDLogger.logToErrorFile("INFO", "EgThreadPoolExecutor", "***********************************************************************************************************************************************");
            }
            executor.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("DD-DataInsertThread");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    System.err.println("EgThreadPoolExecutor : DDDataPacket got rejected");
                    boolean bl = MultiThreadDDConfigTask.isMultiThreadDDLogEnabled();
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("ERROR", "EgThreadPoolExecutor", "DDDataPacket got rejected");
                    }
                    int n = threadPoolExecutor.getActiveCount();
                    int n2 = threadPoolExecutor.getQueue().remainingCapacity();
                    boolean bl2 = threadPoolExecutor.isShutdown();
                    if (bl) {
                        MultiThreadDDLogger.logToErrorFile("ERROR", "EgThreadPoolExecutor", "ActiveCount  :" + n + " remainCapacity :" + n2 + " isShutdown " + bl2);
                    }
                }
            });
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        if (lockObj.isLocked()) {
            return;
        }
        boolean bl = false;
        ++this.counter;
        if (this.counter > 50) {
            this.counter = 0;
            try {
                boolean bl2 = lockObj.tryLock();
                if (bl2) {
                    int n = executor.getQueue().size();
                    if (n > 1000) {
                        if (currentConfig != configKeys[3]) {
                            currentConfig = configKeys[3];
                            int[] nArray = configMap.get(currentConfig);
                            executor.setCorePoolSize(nArray[0]);
                            executor.setMaximumPoolSize(nArray[1]);
                            bl = true;
                        }
                    } else if (n > 750) {
                        if (currentConfig != configKeys[2]) {
                            currentConfig = configKeys[2];
                            int[] nArray = configMap.get(currentConfig);
                            executor.setCorePoolSize(nArray[0]);
                            executor.setMaximumPoolSize(nArray[1]);
                            bl = true;
                        }
                    } else if (n > 500) {
                        if (currentConfig != configKeys[1]) {
                            currentConfig = configKeys[1];
                            int[] nArray = configMap.get(currentConfig);
                            executor.setCorePoolSize(nArray[0]);
                            executor.setMaximumPoolSize(nArray[1]);
                            bl = true;
                        }
                    } else if (currentConfig != configKeys[0]) {
                        currentConfig = configKeys[0];
                        int[] nArray = configMap.get(currentConfig);
                        executor.setCorePoolSize(nArray[0]);
                        executor.setMaximumPoolSize(nArray[1]);
                        System.out.println("SET_SET");
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bl) {
                    try {
                        Thread.sleep(5000L);
                        executor.setMaximumPoolSize(128);
                    }
                    catch (Exception exception) {}
                }
                if (lockObj.isHeldByCurrentThread()) {
                    lockObj.unlock();
                }
            }
        }
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable != null) {
            // empty if block
        }
    }

    public void shutDown() {
    }

    static {
        configMap.put(configKeys[0], new int[]{10, 128});
        configMap.put(configKeys[1], new int[]{22, 24});
        configMap.put(configKeys[2], new int[]{46, 48});
        configMap.put(configKeys[3], new int[]{62, 64});
    }
}

