/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.MultiThreadDDConfigTask;
import java.util.Timer;
import java.util.TimerTask;

public class MultiThreadDDConfigTracker {
    static Timer fileTrackerTimer = null;
    private static final String egServiceIni = "servicesIni";
    private static final String egServiceIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini";
    private static final String multithreadDDSubject = "MULTITHREAD_DD_INSERT_SETTINGS";
    private static long logbackDelay = -1L;
    private static final long initialDelayPeriod = 30000L;
    private static MultiThreadDDConfigTask egServicesIniTaskObject = null;

    MultiThreadDDConfigTracker() {
    }

    public static void scheduleTracking() {
        long l = MultiThreadDDConfigTracker.getIniWatcherDelay();
        egServicesIniTaskObject = new MultiThreadDDConfigTask(egServiceIni);
        if (fileTrackerTimer != null) {
            MultiThreadDDConfigTracker.stop();
        }
        fileTrackerTimer = new Timer("MultiThreadedDDConfigTracker", true);
        fileTrackerTimer.schedule((TimerTask)egServicesIniTaskObject, 30000L, l);
        egServicesIniTaskObject.setMultiThreadDDLogEnabled();
    }

    public static void stop() {
        try {
            fileTrackerTimer.cancel();
            fileTrackerTimer.purge();
            fileTrackerTimer = null;
            egServicesIniTaskObject.cancel();
            egServicesIniTaskObject = null;
            System.out.println("EgServicesIniFileTracker is stopped successfully");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void updateTrackingPeriod() {
        long l = MultiThreadDDConfigTracker.getIniWatcherDelay();
        if (logbackDelay != l) {
            logbackDelay = l;
            MultiThreadDDConfigTracker.reschedule(l, egServiceIni);
        }
    }

    private static void reschedule(long l, String string) {
        MultiThreadDDConfigTracker.stop();
        try {
            egServicesIniTaskObject = new MultiThreadDDConfigTask(string);
            fileTrackerTimer = new Timer("MultiThreadedDDConfigTracker", true);
            fileTrackerTimer.schedule((TimerTask)egServicesIniTaskObject, 30000L, l);
            System.out.println("Rescheduled " + string + " files being tracked every " + l + " milliseconds.");
        }
        catch (Exception exception) {
            System.out.println("Error during rescheduling " + string + " files with track period " + l + " milliseconds.");
            exception.printStackTrace();
        }
    }

    private static long stringToLong(String string, long l) {
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string.trim());
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    private static long getIniWatcherDelay() {
        long l = 180L;
        try {
            IniFile iniFile = new IniFile(egServiceIniFilePath);
            l = MultiThreadDDConfigTracker.stringToLong(iniFile.getValue(multithreadDDSubject, "IniWatcherDelay"), 180L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l * 1000L;
    }

    public static String getEgserviceini() {
        return egServiceIni;
    }

    public static String getEgserviceinifilepath() {
        return egServiceIniFilePath;
    }

    public static String getMultithreadddsubject() {
        return multithreadDDSubject;
    }

    public static void main(String[] stringArray) {
        MultiThreadDDConfigTracker.scheduleTracking();
    }
}

