/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgInstallInfo;
import com.eg.EgServicesInfo;
import com.eg.snmp;
import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.NameValue;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpTrap;
import com.ireasoning.protocol.snmp.SnmpTrapSender;
import com.ireasoning.protocol.snmp.SnmpV1Trap;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.SnmpVarBindList;
import com.ireasoning.util.ParseArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;

public class snmptrap
extends snmp {
    byte[] _engineID;
    long _sysUpTime = 0L;
    String _snmpTrapOID = ".1.3";
    String _enterprise = ".1.3";
    int _generic = 0;
    int _specific = 0;
    int _trapVersion = 1;
    String fromWho = null;
    String trapLine = "";
    String logMsg = "";
    String hostIP = "";
    PrintWriter logWriter = null;
    private boolean b_debugAppend = true;
    private boolean logEnabled = false;
    private boolean isTTSnmpTrapLogEnabled = false;
    EgServicesInfo serviceInfo = null;
    SnmpVarBindList _vblist = new SnmpVarBindList();

    public snmptrap(String[] stringArray) {
        this.parseOptions(stringArray, "snmptrap");
        this.serviceInfo = new EgServicesInfo("manager");
    }

    public static void main(String[] stringArray) {
        snmptrap snmptrap2 = new snmptrap(stringArray);
        snmptrap2.sendTrap("192.168.10.57");
    }

    public void sendTrap(String string) {
        this.fromWho = string;
        this.sendTrap();
    }

    public void sendTrap() {
        try {
            if (this._isSnmpV3) {
                this._trapVersion = 2;
            }
            if (this._trapVersion == 1) {
                SnmpV1Trap snmpV1Trap = new SnmpV1Trap(this._enterprise);
                snmpV1Trap.setTimestamp(this._sysUpTime);
                snmpV1Trap.setGeneric(this._generic);
                snmpV1Trap.setSpecific(this._specific);
                if (this.fromWho != null) {
                    snmpV1Trap.setIpAddress(this.fromWho);
                }
                snmpV1Trap.addVarBinds(this._vblist);
                boolean bl = this.serviceInfo.isSnmpTrapLogEnabled();
                if (bl || this.isTTSnmpTrapLogEnabled) {
                    Date date = new Date();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    long l = date.getTime();
                    long l2 = snmpV1Trap.getTimestamp();
                    date.setTime(l -= l2);
                    int n = gregorianCalendar.get(1);
                    int n2 = gregorianCalendar.get(2) + 1;
                    int n3 = gregorianCalendar.get(5);
                    int n4 = gregorianCalendar.get(11);
                    int n5 = gregorianCalendar.get(12);
                    int n6 = gregorianCalendar.get(13);
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    SnmpTrap snmpTrap = snmpV1Trap.toV2Trap();
                    string5 = snmpTrap.getSnmpTrapOID().toString();
                    this.trapLine = this.LogFileWritter(snmpV1Trap.getVarBinds());
                    string = "Sender~[" + snmpV1Trap.getIpAddress() + "]|";
                    string2 = "Trap_sent_Time~" + n + "-" + n2 + "-" + n3 + "-" + n4 + "-" + n5 + "-" + n6 + "|";
                    string3 = "Trap_oid~" + string5 + "|";
                    string4 = "Variables~";
                    this.logMsg = string + "" + string2 + "" + string3 + "" + string4 + "" + this.trapLine;
                    this.hostIP = this._host;
                    this.logToTempFile(this.logMsg, this.hostIP);
                }
                SnmpTrapSender.sendTrap((SnmpV1Trap)snmpV1Trap, (String)this._host, (int)this._port, (String)this._community);
            } else {
                if (this._isSnmpV3) {
                    SnmpTrapSender.addV3Params((String)this._user, (String)this._authProtocol, (String)this._authPassword, (int)this._privProtocol, (String)this._privPassword, (byte[])this._engineID, (String)this._host, (int)this._port);
                }
                SnmpTrap snmpTrap = new SnmpTrap(this._sysUpTime, new SnmpOID(this._snmpTrapOID));
                if (this.fromWho != null) {
                    snmpTrap.setIpAddress(this.fromWho);
                }
                snmpTrap.addVarBinds(this._vblist);
                boolean bl = this.serviceInfo.isSnmpTrapLogEnabled();
                if (bl || this.isTTSnmpTrapLogEnabled) {
                    Date date = new Date();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    long l = date.getTime();
                    long l3 = snmpTrap.getSysUpTime();
                    date.setTime(l -= l3);
                    int n = gregorianCalendar.get(1);
                    int n7 = gregorianCalendar.get(2) + 1;
                    int n8 = gregorianCalendar.get(5);
                    int n9 = gregorianCalendar.get(11);
                    int n10 = gregorianCalendar.get(12);
                    int n11 = gregorianCalendar.get(13);
                    int n12 = snmpTrap.getVersion();
                    String string = "" + (n12 == 1 ? ++n12 : n12);
                    String string6 = "";
                    string6 = snmpTrap.getSnmpTrapOID().toString();
                    String string7 = MibUtil.translateOID((String)("" + snmpTrap.getSnmpTrapOID()), (boolean)false);
                    if (string7 == null) {
                        string7 = "" + snmpTrap.getSnmpTrapOID();
                    }
                    this.trapLine = this.LogFileWritter(snmpTrap.getObjects());
                    String string8 = "";
                    String string9 = "";
                    String string10 = "";
                    String string11 = "";
                    string8 = "Sender~[" + snmpTrap.getIpAddress() + "]|";
                    string9 = "Trap_sent_Time~" + n + "-" + n7 + "-" + n8 + "-" + n9 + "-" + n10 + "-" + n11 + "|";
                    string10 = "Trap_oid~" + string6 + "|";
                    string11 = "Variables~";
                    this.logMsg = string8 + "" + string9 + "" + string10 + "" + string11 + "" + this.trapLine;
                    this.hostIP = this._host;
                    this.logToTempFile(this.logMsg, this.hostIP);
                }
                SnmpTrapSender.sendTrap((String)this._host, (int)this._port, (SnmpTrap)snmpTrap, (boolean)true, (String)this._community);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
        }
        catch (SnmpEncodingException snmpEncodingException) {
            System.out.println((Object)snmpEncodingException);
            snmpEncodingException.printStackTrace();
        }
    }

    @Override
    protected void parseArgs() {
        String[] stringArray = this._parseArgs.getArguments();
        if (stringArray.length > 0) {
            this._host = stringArray[0];
        }
        for (int i = 1; i < stringArray.length; i += 3) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            String string3 = stringArray[i + 2];
            SnmpDataType snmpDataType = snmptrap.translate(string2, string3);
            SnmpVarBind snmpVarBind = new SnmpVarBind(string, snmpDataType);
            this._vblist.add(snmpVarBind);
        }
    }

    @Override
    protected void usage(String string, boolean bl) {
        System.out.println("Usage: java " + string + " [options...] <hostname> [<OID> <type> <value> ...]\n");
        System.out.println("<OID>\tobject identifier");
        System.out.println("<type>\tdata type of the value, one of i, u, t, a, o, s. i: INTEGER, u: unsigned INTEGER, t: TIMETICKS, a: IPADDRESS, o: OID, s: STRING");
        System.out.println("<value>\tvalue of this object identifier");
    }

    @Override
    protected void moreOptions() {
        System.out.println("-e <e>\ttrap sender's engine ID");
        System.out.println("-t <1|2>\ttrap version, possible values are 1 or 2");
        System.out.println("-s <s>\tsysUpTime or timestamp");
        System.out.println("-q <o>\tsnmpTrapOID");
        System.out.println("-n <n>\tenterprise OID");
        System.out.println("-g <g>\tSNMPv1 generic code");
        System.out.println("-i <g>\tSNMPv1 enterprise specific code");
    }

    @Override
    protected void printExample(String string) {
        System.out.println("java " + string + " -s 10333 -n .1.3.6.1.2.1.2.2.1.1 -g 2 localhost");
        System.out.println("java " + string + " -s 10333 -n .1.3.6.1.2.1.2.2.1.1 -g 6 -i 20 localhost");
        System.out.println("java " + string + " -t 2 -s 10333 -q .1.3.6.1.2.1.2.2.1.1 localhost");
        System.out.println("java " + string + " -t 2 -s 10333 -q .1.3.6.1.2.1.2.2.1.7 localhost 1.3.6.1.2.1.2.2.1.7.3 i 1");
        System.out.println("java " + string + " -v 3 -u newUser -A abc12345 -X abc12345 -e 12345  -s 10333 -q .1.3.6.1.2.1.2.2.1.1 localhost");
    }

    @Override
    protected void parseOptions(String[] stringArray, String string) {
        super.parseOptions(stringArray, string);
        String string2 = this._parseArgs.getOptionValue('e');
        if (string2 != null) {
            this._engineID = snmp.getHexString(string2);
        }
        this._trapVersion = Integer.parseInt(this._parseArgs.getOptionValue('t', "1"));
        this._snmpTrapOID = this._parseArgs.getOptionValue('q');
        this._enterprise = this._parseArgs.getOptionValue('n');
        this._generic = Integer.parseInt(this._parseArgs.getOptionValue('g', "0"));
        this._specific = Integer.parseInt(this._parseArgs.getOptionValue('i', "0"));
        this._sysUpTime = Long.parseLong(this._parseArgs.getOptionValue('s', "0"));
        this._port = Integer.parseInt(this._parseArgs.getOptionValue('p', "162"));
    }

    @Override
    protected void printMoreOptions() {
        System.out.println("engine ID =\t\t" + this._parseArgs.getOptionValue('e'));
        System.out.println("trap version =\t\t" + this._trapVersion);
        System.out.println("sysUpTime =\t\t" + this._sysUpTime);
        System.out.println("snmpTrapOID =\t\t" + this._snmpTrapOID);
        System.out.println("enterpriseOID = \t" + this._enterprise);
        System.out.println("SNMPv1 generic =\t\t" + this._generic);
        System.out.println("SNMPv1 specific =\t\t" + this._specific);
    }

    @Override
    protected ParseArguments newParseArgumentsInstance(String[] stringArray) {
        return new ParseArguments(stringArray, "?ho", "uvaAXxcpmetsqngi");
    }

    private String LogFileWritter(SnmpVarBind[] snmpVarBindArray) {
        String string = "";
        String string2 = "";
        try {
            for (int i = 0; i < snmpVarBindArray.length; ++i) {
                SnmpVarBind snmpVarBind = snmpVarBindArray[i];
                NameValue nameValue = MibUtil.translate((SnmpOID)snmpVarBind.getName(), (String)snmpVarBind.getValue().toString(), (boolean)false);
                string = nameValue != null ? nameValue.getName() + " " + nameValue.getValue() : snmpVarBind.getName() + " " + snmpVarBind.getValue();
                if (i >= string.length() - 1) continue;
                string2 = string2.length() > 0 ? string2 + "^" + string : string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.print("\n");
        }
        return string2;
    }

    public void logToTempFile(String string, String string2) {
        String string3 = EgInstallInfo.getInstallDir() + "/manager/logs/" + string2 + "_snmptrap_log";
        if (this.isTTSnmpTrapLogEnabled) {
            string3 = EgInstallInfo.getInstallDir() + "/manager/logs/" + string2 + "_TTSNMPTrap_log";
        }
        try {
            this.checkRollLog(string2);
            this.logWriter = new PrintWriter(new FileWriter(string3, true));
        }
        catch (Exception exception) {
            System.out.println("Cannot open SnmpTrap log file ");
            return;
        }
        String string4 = new String(string);
        this.logWriter.println(string4);
        this.logWriter.close();
    }

    public void checkRollLog(String string) {
        String string2 = "10";
        int n = 100000;
        String string3 = "";
        String string4 = "snmptrap_log";
        if (this.isTTSnmpTrapLogEnabled) {
            string3 = this.serviceInfo.getSnmpTrapLogMaxRollSize();
            string4 = "TTSNMPTrap_log";
        } else {
            string4 = "snmptrap_log";
            string3 = this.serviceInfo.getSnmpTrapLogMaxRollSize();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "2";
        }
        double d = 2097152.0;
        try {
            d = Double.parseDouble(string3);
            d = d * 1024.0 * 1024.0;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid SnmpTrapLogMaxRollSize entry in service file. continue with maximum size 2 MB  ");
            d = 2097152.0;
        }
        File file = new File(EgInstallInfo.getInstallDir() + "/manager/logs/" + string + "_" + string4);
        if (file.exists() && (double)file.length() >= d) {
            int n2 = 0;
            string2 = "";
            string2 = this.isTTSnmpTrapLogEnabled ? this.serviceInfo.getSnmpTrapLogMaxFiles() : this.serviceInfo.getSnmpTrapLogMaxFiles();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "0";
            }
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid entry in services file SNMPTRAP_LOG_MAX_FILES Entry ... Continuing with Max file entry to 10");
                n2 = 0;
            }
            if (n2 == 0) {
                return;
            }
            int n3 = n2;
            int n4 = this.findLastFileNumber();
            n3 = n4 < n2 ? n4 : n2 - 1;
            int n5 = 0;
            for (n5 = n3; n5 > 0; --n5) {
                EgInstallInfo.fileRename(EgInstallInfo.getInstallDir() + "/manager/logs/" + string + "_" + string4 + "." + n5, EgInstallInfo.getInstallDir() + "/manager/logs/" + string + "_" + string4 + "." + (n5 + 1));
            }
            if (n5 == 0) {
                EgInstallInfo.fileRename(EgInstallInfo.getInstallDir() + "/manager/logs/" + string + "_" + string4, EgInstallInfo.getInstallDir() + "/manager/logs/" + string + "_" + string4 + ".1");
            }
            if (file.exists()) {
                file.delete();
            }
        }
        file = null;
    }

    private void init(String string) {
        try {
            if (this.logWriter == null) {
                this.logWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(EgInstallInfo.getInstallDir() + "/manager/logs/log/" + string + "_snmptrap_log", true), "UTF-8"), true);
            }
            this.logEnabled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initStop() {
        try {
            this.logEnabled = false;
            if (this.logWriter != null) {
                this.logWriter.flush();
            }
            this.logWriter.close();
            this.logWriter = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int findLastFileNumber() {
        int n = 0;
        int n2 = 0;
        String string = "snmptrap_log";
        string = this.isTTSnmpTrapLogEnabled ? "TTSNMPTrap_log" : "snmptrap_log";
        try {
            File file = new File(EgInstallInfo.getInstallDir() + "/manager/logs/");
            if (file == null || !file.exists()) {
                return 0;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length <= 0) {
                return 0;
            }
            int n3 = fileArray.length;
            for (int i = 0; i < n3; ++i) {
                String string2;
                if (fileArray[i].isDirectory() || (string2 = fileArray[i].getName()).indexOf(string) == -1 || string2.lastIndexOf(".") < 0) continue;
                string2 = string2.substring(string2.lastIndexOf(".") + 1);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    fileArray[i] = null;
                    continue;
                }
                if (n < n2) {
                    n = n2;
                }
                fileArray[i] = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public void setTTSnmpTrapLogEnabled(boolean bl) {
        this.isTTSnmpTrapLogEnabled = this.serviceInfo.isSnmpTrapLogEnabled();
    }
}

