Ext.Msg.cls='adminAlert';
Ext.Msg.layout = {
	type: 'anchor',
	pack:'center',
	align: 'center'
};

Ext.define('DefaultTestConfiguration.controller.Main',{
	extend: 'Ext.app.Controller',

	views:['Ext.ux.form.MultiSelectSI'],

	refs:[
		{selector:'testconfiguration', ref:'testconfiguration'},
		{selector:'viewpolicy', ref:'viewpolicy'},
		{selector:'egpolicycreation', ref:'egpolicycreation'},
		{selector:'egvcconfig', ref:'egvcconfig'},
		{selector:'egnutconfig', ref:'egnutconfig'},
		{selector:'eghmcconfig', ref:'eghmcconfig'},
		{selector:'egrhevconfig', ref:'egrhevconfig'},
		{selector:'vmgusers', ref:'vmgusers'},
		{selector:'egconfigureurlandcredentials', ref:'egconfigureurlandcredentials'},
		{selector:'egconfigurenamepattern', ref:'egconfigurenamepattern'},
		{selector:'egconfigurewinsharedfolders', ref:'egconfigurewinsharedfolders'},
		{selector:'egconfigurewsdlurlandcredentials', ref:'egconfigurewsdlurlandcredentials'},
		{selector:'egruntimepattern', ref:'egruntimepattern'},
		{selector:'egconfigurepublishedresources', ref:'egconfigurepublishedresources'},
		{selector:'egconfigurerulenames', ref:'egconfigurerulenames'},
		{selector:'egxmsconfig', ref:'egxmsconfig'},
		{selector:'minmaxvalues', ref:'minmaxvalues'}

	],
	init:function(){
		me = this,
		testViews = this;
		this.control({
			'testconfiguration': {
				'boxready': this.afterMainRender
			},
			'testconfiguration scrollcombo[id="componentType"]': {
				'select': this.compTypeChangeEvent
			},
			'testconfiguration scrollcombo[id="testName"]': {
				'select': this.testNameChangeEvent
			},
			'testconfiguration scrollcombo[id="testType"]': {
				'select': this.testTypeChangeEvent
			},
			'testconfiguration button[id="updateBtn"]': {
				'click': this.populate
			},
			'testconfiguration button[id="enableDisableBtn"]': {
				'click': this.goToEnableDisableTestpage
			},
			'testconfiguration combo[id="filter_combo"]': {
				'refresh': this.refreshFilterCombo
			},
			'viewpolicy button[id="addPolicy"]': {
				'click': this.policyCreationMainPage
			},
			'viewpolicy trigger[id="searchTrigger"]':
			{
				'change': this.policyMainSearch
			},
			'egpolicycreation button[id="updatePolicy"]': {
				'click': this.policyMainValidate
			},
			'egpolicycreation button[id="viewsource"]': {
				'click': this.openMainWindow
			},
			'egpolicycreation button[id="viewid"]': {
				'click': this.openMainWindow
			},
			'egpolicycreation button[id="viewdesc"]': {
				'click': this.openMainWindow
			},
			'egvcconfig combo[id="SslVc"]': {
				'select': this.combosslVc
			},
			'egvcconfig button[id="ClearBTN"]': {
				'click': this.clearVc
			},
			'egvcconfig button[id="UpdateBTN"]': {
				'click': this.updateVc
			},
			'egvcconfig' : {
				'beforeclose': this.callVcDestroy
			},
			'businesstransactionnaming button[id="addNewRulebtn"]': {
				'click': this.resultPanelCreateRuleForm
			},
			'businesstransactionnaming button[id="createRule"]': {
				'click': this.saveOrUpdateRule
			},
			'businesstransactionnaming': {
				'beforeclose': this.callRulesDestroy
			},
			'businesstransactionrulegrid button[id="updateSpecificConfig"]': {
				'click': this.getRuleNamesFromIni
			},
			'egxmsconfig' : {
				'beforeclose': this.callXMSDestroy
			},
			'egnutconfig button[id="ClearBTN"]': {
				'click': this.clearNut
			},
			'egnutconfig button[id="UpdateBTN"]': {
				'click': this.updateNut
			},
			'egnutconfig' : {
				'beforeclose': this.callNutDestroy
			},
			'eghmcconfig button[id="ClearBTN"]': {
				'click': this.clearHmc
			},
			'eghmcconfig button[id="UpdateBTN"]': {
				'click': this.updateHmc
			},
			'eghmcconfig' : {
				'beforeclose': this.callHmcDestroy
			},
			'egrhevconfig scrollcombo[id="SslRhev"]': {
				'select': this.combosslrhev
			},
			'egrhevconfig button[id="ClearBTN"]': {
				'click': this.clearRhev
			},
			'egrhevconfig button[id="UpdateBTN"]': {
				'click': this.updateRhev
			},
			'egrhevconfig' : {
				'beforeclose': this.callRhevDestroy
			},
			'vmgusers button[id="addVmgUsrbtn"]': {
				'click': this.addVmgUsr
			},
			'vmgusers button[id="clearConfUsr"]': {
				'click': this.ClearConfigUsrs
			},
			'vmgusers button[id="updateConfUsr"]': {
				'click': this.UpdateConfigUsrs
			},
			'egconfiguremultipleusers button[id="addMultiUsrbtn"]': {
				'click': this.addMultiUsr
			},
			'egconfiguremultipleusers button[id="clearMultiConfUsr"]': {
				'click': this.ClearMultiConfigUsrs
			},
			'egconfiguremultipleusers button[id="updateMultiConfUsr"]': {
				'click': this.UpdateMultiConfigUsrs
			},
			'egconfigureurlandcredentials button[id="addCredUrlbtn"]': {
				'click': this.addCredUrls
			},
			'egconfigureurlandcredentials button[id="clearCredUrl"]': {
				'click': this.clearCredUrls
			},
			'egconfigureurlandcredentials button[id="updateCredUrl"]': {
				'click': this.updateCredUrls
			},
			'egconfigurenamepattern button[id="addUrlNamebtn"]': {
				'click': this.addUrlNames
			},
			'egconfigurenamepattern button[id="clearUrlPattern"]': {
				'click': this.clearUrlNames
			},
			'egconfigurenamepattern button[id="updateUrlPattern"]': {
				'click': this.updateUrlNames
			},
			'egconfigurewinsharedfolders button[id="addwinsharedbtn"]': {
				'click': this.addWinShared
			},
			'egconfigurewinsharedfolders button[id="clearWinShared"]': {
				'click': this.clearWinShareds
			},
			'egconfigurewinsharedfolders button[id="updateWinShared"]': {
				'click': this.updateWinShareds
			},
			'egconfigurewsdlurlandcredentials button[id="addWsdlUrlbtn"]': {
				'click': this.addWsdlUrl
			},
			'egconfigurewsdlurlandcredentials button[id="clearWsdlUrl"]': {
				'click': this.clearWsdlUrls
			},
			'egconfigurewsdlurlandcredentials button[id="updateWsdlUrl"]': {
				'click': this.updateWsdlUrls
			},
			'egruntimepattern button[id="updateRuntimePattern"]': {
				'click': this.updateRuntimePatt
			},
			'egconfigurepublishedresources button[id="addMultiSrcbtn"]': {
				'click': this.addMultiSource
			},
			'egconfigurepublishedresources button[id="clearMultiConfSrc"]': {
				'click': this.ClearMultiConfigSource
			},
			'egconfigurepublishedresources button[id="updateMultiConfSrc"]': {
				'click': this.UpdateMultiConfigSource
			},
			'minmaxvalues button[id="updateMinMaxValues"]': {
				'click': this.updateService_pr
			}
		});
	},
	policyDel: function(server,test,policy,log,show,q,logtype,flag,requestFrom) //check
	{
		var currentLogType = Ext.getCmp("logType").getValue();
		var confirmMsg;
		if(flag == "no")
		{
			confirmMsg = alertMsg11+" '"+policy+"' "+alertMsg12+'. '+alertMsg13+"?";
		}
		else
		{
			confirmMsg = alertMsg14+" '"+policy+"' ?";
		}

		Ext.Msg.show({
            title: pageName,
            msg: confirmMsg,
            buttons: Ext.Msg.YESNO,
			icon: 'iconExclamation',
            fn: function(response) {
				if(response == 'yes')
				{
					if (Ext.isEmpty(deletedRecords) || deletedRecords == '')
					{
						deletedRecords = policy;
					}
					else
					{
						deletedRecords += ','+policy;
					}
					urlVal = "DefaultTestConfiguration/data/ViewPolicyJson.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&delpolicy=yes&log_type="+log+"&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom+"&currentLogType="+currentLogType;
					Ext.Ajax.request({
						url:urlVal,
						method:'post',
						scope:this,
						success:function(response)
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = response.responseText;
								var policyJsonObj = Ext.decode(jsonText);
								Ext.getCmp('EventsViewGrid').getStore().removeAll();
								Ext.getCmp('EventsViewGrid').getStore().loadRawData(policyJsonObj['gridDataArr']);
							}
						}
					});
				}
			}
		});

		//if(con)
		//{
			//window.location.href = "ViewPolicy.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&delpolicy=yes&log_type="+log+"&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom;
		//}
		//else
		//{
			//window.location.href = "ViewPolicy.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&log_type="+log+"&delpolicy=no&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom;
		//}
	},
	checkURLAndCredentials: function (paramValue)
	{
		var v_url='';
		var urlObj =Ext.getCmp('url');
		var wsdlUrlObj =Ext.getCmp('WSDL_URL');
		if(!Ext.isEmpty(urlObj) && urlObj != undefined)
		{
			v_url = urlObj.getValue();
		}
		else if(!Ext.isEmpty(wsdlUrlObj) && wsdlUrlObj != undefined)
		{
			v_url = wsdlUrlObj.getValue();
		}
		var v_cred = publicJson['hiddenObj']['credentials'];
		var arrURL = v_url.split(",");
		var arrCred = v_cred.split(",");
		if (arrURL.length != arrCred.length && plusButtonClicked == "false")
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg7+' '+alertMsg69,
				icon:'iconExclamation',
				buttons: Ext.Msg.OK,
				fn: function(){
					if(!Ext.isEmpty(urlObj) && urlObj != undefined)
					{
						urlObj.setValue = paramValue;
						urlObj.focus(true);
					}
					else if(!Ext.isEmpty(wsdlUrlObj) && wsdlUrlObj != undefined)
					{
						wsdlUrlObj.setValue = paramValue;
						wsdlUrlObj.focus(true);
					}
				}
			});
			return false;
		}
	},
	getUserValue: function(paramName) 
	{
		if (paramName.toLowerCase() == "domain")
		{
			newDomainValue = Ext.getCmp('domain').getValue();
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			newAdminUserValue = Ext.getCmp('admin_user').getValue();
		}
		else if (paramName.toLowerCase() == "user")
		{
			newUserValue = Ext.getCmp('user').getValue();
		}
	},
	getUserChangedValue: function(paramName) {
		if (paramName.toLowerCase() == "domain")
		{
			changedDomainValue = Ext.getCmp('domain').getValue();
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			changedAdminUserValue =  Ext.getCmp('admin_user').getValue();
		}
		else if (paramName.toLowerCase() == "user")
		{
			changedUserValue = Ext.getCmp('user').getValue();
		}
	},
	checkMultipleUser: function(paramName,paramValue) {
		var paramValue = publicJson['multiUserOrNameParamValue'+paramName];
		var multiUser = "false";
		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = Ext.getCmp('domain').getValue();
			if (domainValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue =  Ext.getCmp('admin_user').getValue();
			if (adminUserValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue =  Ext.getCmp('user').getValue();
			if (userValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}

		if (multiUser == "true")
		{
			var orginalDomainValue = "";
			var orginalUserValue = "";
			if (plusButtonClicked == "true")
			{
				if (paramName.toLowerCase() == "domain")
				{
					var domainValue = Ext.getCmp('domain').getValue();
					if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
					{
						orginalDomainValue = newDomainValue;
					}
				}
				else if (paramName.toLowerCase() == "admin_user")
				{
					var adminUserValue = Ext.getCmp('admin_user').getValue();
					if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
					{
						orginalUserValue = newAdminUserValue;
					}
				}
				else if (paramName.toLowerCase() == "user")
				{
					var userValue =  Ext.getCmp('user').getValue();
					if (userValue != newUserValue && userValue.indexOf(",") > -1)
					{
						orginalUserValue = newUserValue;
					}
				}
			}
			else
			{
				if (paramName.toLowerCase() == "domain")
				{
					var domainValue = Ext.getCmp('domain').getValue();
					if (domainValue != paramValue && domainValue.indexOf(",") > -1)
					{
						orginalDomainValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "admin_user")
				{
					var adminUserValue =  Ext.getCmp('admin_user').getValue();
					if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
					{
						orginalUserValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "user")
				{
					var userValue = Ext.getCmp('user').getValue();
					if (userValue != paramValue && userValue.indexOf(",") > -1)
					{
						orginalUserValue = paramValue;
					}
				}
			}

			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = Ext.getCmp('domain').getValue();
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testName) && testName != undefined)
					{
						if (testName == "CtxAuthTest" || 
							testName == "WinAuthTest" || 
							testName == "TermAuthTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg8,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
									Ext.getCmp('domain').focus(true);
								}
							});
						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg9,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
									Ext.getCmp('domain').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg8,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
								Ext.getCmp('domain').focus(true);
							}
						});
					}
					return false;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = Ext.getCmp('admin_user').getValue();
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg:alertMsg7+' '+alertMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('admin_user').setValue(changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(",")));
							Ext.getCmp('admin_user').focus(true);
						}
					});
					return false;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue =  Ext.getCmp('user').getValue();
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg:alertMsg7+' '+alertMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('user').setValue(changedUserValue.substring(0,changedUserValue.indexOf(",")));
							Ext.getCmp('user').focus(true);
						}
					});
					return false;
				}
			}
		}
	},
	checkMultipleNamePattern: function (paramName,paramValue) {
		var paramValue = publicJson['multiUserOrNameParamValue'+paramName];
		var multiName = "false";

		if (paramName.toLowerCase() == "name")
		{
			var nameValue = Ext.getCmp('name').getValue();
			if (nameValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			var patternValue = Ext.getCmp('pattern').getValue();
			if (patternValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			var thresholdValue = Ext.getCmp('threshold_value').getValue();
			if (thresholdValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}

		if (multiName == "true")
		{
			var orginalPatternValue = "";
			var orginalNameValue = "";
			var orginalThresholdValue = "";
			if (plusButtonClicked == "true")
			{
				if (paramName.toLowerCase() == "pattern")
				{
					var patternValue = Ext.getCmp('pattern').getValue();
					if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
					{
						orginalPatternValue = newPatternValue;
					}
				}
				else if (paramName.toLowerCase() == "name")
				{
					var nameValue = Ext.getCmp('name').getValue();
					if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
					{
						orginalNameValue = newNameValue;
					}
				}
				else if (paramName.toLowerCase() == "threshold_value")
				{
					var thresholdValue = Ext.getCmp('threshold_value').getValue();
					if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
					{
						orginalThresholdValue = newThresholdValue;
					}
				}
			}
			else
			{
				if (paramName.toLowerCase() == "pattern")
				{
					var patternValue = Ext.getCmp('pattern').getValue();
					if (patternValue != paramValue && patternValue.indexOf(",") > -1)
					{
						orginalPatternValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "threshold_value")
				{
					var thresholdValue = Ext.getCmp('threshold_value').getValue();
					if (thresholdValue != paramValue && thresholdValue.indexOf(",") > -1)
					{
						orginalthresholdValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "name")
				{
					var nameValue = Ext.getCmp('name').getValue();
					if (nameValue != paramValue && nameValue.indexOf(",") > -1)
					{
						orginalNameValue = nameValue;
					}
				}
			}

			if (paramName.toLowerCase() == "name")
			{
				var nameValue = Ext.getCmp('name').getValue();
				var testname = publicJson['testName'];
				if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testname == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('name').setValue(changedNameValue.substring(0,changedNameValue.indexOf(",")));
									Ext.getCmp('name').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('name').setValue(changedNameValue.substring(0,changedNameValue.indexOf(",")));
								Ext.getCmp('name').focus(true);
							}
						});
					}
					return false;
				}
			}
			else if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = Ext.getCmp('pattern').getValue();
				var testname = publicJson['testName'];

				if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testname == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('pattern').setValue(changedPatternValue.substring(0,changedPatternValue.indexOf(",")));
									Ext.getCmp('pattern').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('pattern').setValue(changedPatternValue.substring(0,changedPatternValue.indexOf(",")));
								Ext.getCmp('pattern').focus(true);
							}
						});
					}
					return false;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = Ext.getCmp('threshold_value').getValue();
				var testname = publicJson['testName'];

				if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testName == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('threshold_value').setValue(changedThresholdValue.substring(0,changedThresholdValue.indexOf(",")));
									Ext.getCmp('threshold_value').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('threshold_value').focus(true);
								Ext.getCmp('threshold_value').setValue(changedThresholdValue.substring(0,changedThresholdValue.indexOf(",")));
							}
						});
					}
					return false;
				}
			}
		}
	},
	getNamePatternValue: function (paramName) 
	{
		if (paramName.toLowerCase() == "name")
		{
			newNameValue = Ext.getCmp('name').getValue();
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			newPatternValue = Ext.getCmp('pattern').getValue();
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			newThresholdValue = Ext.getCmp('threshold_value').getValue();
		}
	},
	getNamePatternChangedValue: function (paramName) 
	{
		if (paramName.toLowerCase() == "name")
		{
			changedNameValue = Ext.getCmp('name').getValue();
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			changedPatternValue =  Ext.getCmp('pattern').getValue();
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			changedThresholdValue =  Ext.getCmp('threshold_value').getValue();
		}
	},
	getHiddenFields : function(hiddenObj) {
		var hiddenFields = publicJson[hiddenObj];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	goToEnableDisableTestpage: function() {
		var urlLink = publicJson['enableDisableTestPageLink'];
		window.location.href = urlLink;
	},
	isManagedByChange: function(obj)
	{
		var isManagedByVal = obj.getValue();
		var fromIniManagedBy = publicJson['selectedIsManagedBy'];
		if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'hmc')
		{
			Ext.getCmp('management_server_text').setDisabled(true);
			Ext.getCmp('management_server_text').hide();

			Ext.getCmp('management_server').setDisabled(false);
			Ext.getCmp('management_server').reset();
			Ext.getCmp('management_server').show();

			var mgmtServer = 'None';
			var mgmtUser = 'none';
			var mgmtPwd = 'none';
			if (!Ext.isEmpty(fromIniManagedBy) && fromIniManagedBy != undefined && fromIniManagedBy == 'hmc')
			{
				mgmtUser = publicJson['tempUser'];
				mgmtPwd = publicJson['tempPassValue'];
				mgmtServer = publicJson['selectedHMC'];
				if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
				{
					mgmtServer = 'None';
				}
				if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
				{
					mgmtUser = 'none';
				}
				if (Ext.isEmpty(mgmtPwd) || mgmtPwd == undefined)
				{
					mgmtPwd = 'none';
				}
			}

			var mgmtUserObj = '';
			var mgmtPwdObj = '';
			var mgmtConfPwdObj = '';
			if (!Ext.isEmpty(Ext.getCmp('management_user')) && Ext.getCmp('management_user') != undefined)
			{
				mgmtUserObj = Ext.getCmp('management_user');
			}
			else
			{
				mgmtUserObj = Ext.getCmp('Management_user');
			}
			if (!Ext.isEmpty(Ext.getCmp('management_password')) && Ext.getCmp('management_password') != undefined)
			{
				mgmtPwdObj = Ext.getCmp('management_password');
				mgmtConfPwdObj = Ext.getCmp('management_passwordconfirmpassword');
			}
			else
			{
				mgmtPwdObj = Ext.getCmp('Management_password');
				mgmtConfPwdObj = Ext.getCmp('Management_passwordconfirmpassword');
			}

			mgmtUserObj.setValue(mgmtUser);
			mgmtPwdObj.setValue(mgmtPwd);
			mgmtConfPwdObj.setValue(mgmtPwd);
		}
		else if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'ivm')
		{
			Ext.getCmp('management_server').setDisabled(true);
			Ext.getCmp('management_server').hide();

			Ext.getCmp('management_server_text').setDisabled(false);
			Ext.getCmp('management_server_text').show();
			
			
			var mgmtServer = '$unconfigured';
			var mgmtUser = '$unconfigured';
			var mgmtPwd = '$unconfigured';
			if (!Ext.isEmpty(fromIniManagedBy) && fromIniManagedBy != undefined && fromIniManagedBy == 'ivm')
			{
				mgmtUser = publicJson['tempUser'];
				mgmtPwd = publicJson['tempPassValue'];
				mgmtServer = publicJson['mgmtTextValue'];

				if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
				{
					mgmtServer = '$unconfigured';
				}
				if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
				{
					mgmtUser = '$unconfigured';
				}
				if (Ext.isEmpty(mgmtPwd) || mgmtPwd == undefined)
				{
					mgmtPwd = '$unconfigured';
				}
			}

			var mgmtUserObj = '';
			var mgmtPwdObj = '';
			var mgmtConfPwdObj = '';
			if (!Ext.isEmpty(Ext.getCmp('management_user')) && Ext.getCmp('management_user') != undefined)
			{
				mgmtUserObj = Ext.getCmp('management_user');
			}
			else
			{
				mgmtUserObj = Ext.getCmp('Management_user');
			}
			if (!Ext.isEmpty(Ext.getCmp('management_password')) && Ext.getCmp('management_password') != undefined)
			{
				mgmtPwdObj = Ext.getCmp('management_password');
				mgmtConfPwdObj = Ext.getCmp('management_passwordconfirmpassword');
			}
			else
			{
				mgmtPwdObj = Ext.getCmp('Management_password');
				mgmtConfPwdObj = Ext.getCmp('Management_passwordconfirmpassword');
			}

			Ext.getCmp('management_server_text').setValue(mgmtServer);
			mgmtUserObj.setValue(mgmtUser);
			mgmtPwdObj.setValue(mgmtPwd);
			mgmtConfPwdObj.setValue(mgmtPwd);
		}

		var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'management_user');
		if (!Ext.isEmpty(disabledPwdParam))
		{
			Ext.getCmp(disabledPwdParam.trim()).setValue('none');
			me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
		}
	},
		changeTotalDesc: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'report_with_destination')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('report_by_total_radioGrp').setDisabled(false);
				Ext.getCmp('report_by_total_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('report_by_total_radioGrp').setDisabled(false);
				Ext.getCmp('report_by_total_radioGrp').reset();
				Ext.getCmp('report_by_total_radioGrp').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	InsideViewChange: function(value) {
		insideView = value;
		var domainValue = "";
		var domainObj = Ext.getCmp('domain');
		var adminUserObj = Ext.getCmp('admin_user');
		var adminPwdObj = Ext.getCmp('admin_password');
		var adminConPwdObj = Ext.getCmp('admin_passwordconfirmpassword');
		if (!Ext.isEmpty(domainObj) && domainObj != undefined)
		{
			domainValue = Ext.getCmp('domain').getValue();
		}

		if (value == "tcp" || value == "wmi")
		{
			if (!Ext.isEmpty(domainObj) && domainObj != undefined && 
				domainObj.getValue() == "$unconfigured")
			{
				domainObj.setValue("none");
			}

			if (!Ext.isEmpty(adminUserObj) && adminUserObj != undefined && 
				adminUserObj.getValue() == "$unconfigured")
			{
				adminUserObj.setValue("none");
			}

			if (!Ext.isEmpty(adminPwdObj) && adminPwdObj != undefined && 
				adminPwdObj.getValue() == "$unconfigured")
			{
				adminPwdObj.setValue("none");
			}

			if (!Ext.isEmpty(adminConPwdObj) && adminConPwdObj != undefined && 
				adminConPwdObj.getValue() == "$unconfigured")
			{
				adminConPwdObj.setValue("none");
			}
		}
		else
		{
			if (!Ext.isEmpty(domainObj) && domainObj != undefined && 
				domainObj.getValue() == "none")
			{
				domainObj.setValue("$unconfigured");
			}
			if (!Ext.isEmpty(adminUserObj) && adminUserObj != undefined && 
				adminUserObj.getValue() == "none")
			{
				adminUserObj.setValue("$unconfigured");
			}

			if (!Ext.isEmpty(adminPwdObj) && adminPwdObj != undefined && 
				adminPwdObj.getValue() == "none")
			{
				adminPwdObj.setValue("$unconfigured");
			}
			
			if (!Ext.isEmpty(adminConPwdObj) && adminConPwdObj != undefined && 
				adminConPwdObj.getValue() == "none")
			{
				adminConPwdObj.setValue("$unconfigured");
			}
		}
	},
	applyPwdProfile: function(obj) 
	{
		var id = obj.id;
		var totalPwdParams = publicJson[id+'_totalPwdParams'];
		var paramsArray = publicJson[id+'_paramsArray'];
		var pwdProfileIniVal = publicJson.pwdProfileIniVal;
		var selectedProfile = obj.value;
		var dependParams = publicJson.pwdParamSetList[id];

		if (!Ext.isEmpty(selectedProfile) && selectedProfile != 'none')
		{
			//var arrObj = ['virtual_center','xms_ip','Prism_IP','management_server','Rhel_mgr_host','inside_view_using'];
			//setNoneForDependsParams(arrObj);
			switch(dependParams)
			{
				case 'Esx_user,Esx_password': 
					console.log('case fired..');
					Ext.getCmp('virtual_center').setValue('None');
					break;
				case 'management_user,management_password' :
					Ext.getCmp('management_server').setValue('None');
					break;
				case 'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain':
					Ext.getCmp('Rhel_mgr_host').setValue('None');
					break;
				case 'Prism_user,Prism_password':
					Ext.getCmp('Prism_IP').setValue('None');
					break;
				case 'XtremIO_user,XtremIO_password':
					Ext.getCmp('xms_ip').setValue('None');
					break;
			}

			var params = pwdProfileIniVal[selectedProfile];
			var paramsValArr = params.split("~Hash~");

			for (var a=0;a<totalPwdParams ;a++ )
			{
				var paramName = paramsArray[a]['profileParams'+a];
				var paramValue = '';//paramsValArr[a];
				if (!Ext.isEmpty(Ext.getCmp(paramName)))
				{
					Ext.getCmp(paramName).setReadOnly(true);
					if (checkParamIsUserField(paramName))
					{
						paramValue = paramsValArr[0];
					}
					else if (checkParamIsPasswordField(paramName))
					{
						paramValue = paramsValArr[1];
					}
					else if (checkParamIsDomainField(paramName))
					{
						paramValue = paramsValArr[2];
					}
					Ext.getCmp(paramName).setValue(paramValue);

					if (paramName.toLowerCase().indexOf("password") != -1 || 
						paramName.toLowerCase().indexOf("authpass") != -1 || 
						paramName.toLowerCase().indexOf("oracle_vm_mgr_pass") != -1 || 
						paramName.toLowerCase().indexOf("vcloud_director_pass") != -1 || 
						paramName.toLowerCase().indexOf("docker_pass") != -1)
					{
						if (!Ext.isEmpty(Ext.getCmp(paramName+"confirmpassword")))
						{
							Ext.getCmp(paramName+"confirmpassword").setReadOnly(true);
							Ext.getCmp(paramName+"confirmpassword").setValue(paramValue);
							Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							Ext.getCmp(paramName+"confirmpassword").show();
						}
					}
				}
			}
		}
		else
		{
			for (var a=0;a<totalPwdParams ;a++ )
			{
				var paramName = paramsArray[a]['profileParams'+a];
				//var paramValue = paramsValArr[a];
				if (!Ext.isEmpty(Ext.getCmp(paramName)))
				{
					Ext.getCmp(paramName).setReadOnly(false);
					Ext.getCmp(paramName).setValue('none');
					if (paramName.toLowerCase().indexOf("password") != -1)
					{
						if (!Ext.isEmpty(Ext.getCmp(paramName+"confirmpassword")))
						{
							Ext.getCmp(paramName+"confirmpassword").setReadOnly(false);
							Ext.getCmp(paramName+"confirmpassword").setValue('none');
							Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							Ext.getCmp(paramName+"confirmpassword").show();
						}
					}
				}
			}
		}
	},
	enablePwdProfile: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'usepwdprofile')
		{
			var value = obj.getBox().y+100;
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('pwdprofile').setDisabled(true);
				Ext.getCmp('pwdprofile').hide();
				Ext.getCmp('pwdprofile').setValue('-1');
			}
			else
			{
				Ext.getCmp('pwdprofile').setDisabled(false);
				Ext.getCmp('pwdprofile').show();
			}

			me.applyPwdProfile('-1');
			//var totalPwdParams = publicJson.totalPwdParams;
			//var paramsArray = publicJson.paramsArray;

			//for (var a=0;a<totalPwdParams ;a++ )
			//{
				//var paramName = paramsArray[a]['profileParams'+a];
				////var paramValue = paramsValArr[a];
				//if (!Ext.isEmpty(Ext.getCmp(paramName)))
				//{
					//Ext.getCmp(paramName).setReadOnly(false);
					//Ext.getCmp(paramName).setValue('none');

					//if (paramName.indexOf("password") != -1)
					//{
						//Ext.getCmp(paramName+"confirmpassword").setReadOnly(true);
						//Ext.getCmp(paramName+"confirmpassword").setValue('none');
					//}
				//}
			//}

			Ext.getCmp('testConfigForm').body.scrollTo('top',value);
		}
	},
	changeEncFlagValue: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'encryptflag')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('encrypttype').setDisabled(true);
				Ext.getCmp('encryptpassword').setDisabled(true);
				Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
				Ext.getCmp('encrypttype').hide();
				Ext.getCmp('encryptpassword').hide();
				Ext.getCmp('encryptpasswordconfirmpassword').hide();
			}
			else
			{
				var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
				var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
				Ext.getCmp('encrypttype').setDisabled(false);
				Ext.getCmp('encryptpassword').setDisabled(false);
				Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
				Ext.getCmp('encrypttype').show();
				if (!Ext.isEmpty(selectedSnmpEncType))
				{
					Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
				}
				else
				{
					Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
				}
				Ext.getCmp('encryptpassword').show();
				Ext.getCmp('encryptpasswordconfirmpassword').show();
			}
		}
	},
	snmpV3ParamDisabeld: function() {
		if (!Ext.isEmpty(Ext.getCmp('context')) && Ext.getCmp('context') != undefined)
		{
			Ext.getCmp('context').setDisabled(true);
			Ext.getCmp('context').hide();
		}
		if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
		{
			Ext.getCmp('username').setDisabled(true);
			Ext.getCmp('username').hide();
		}
		if (!Ext.isEmpty(Ext.getCmp('authpass')) && Ext.getCmp('authpass') != undefined)
		{
			Ext.getCmp('authpass').setDisabled(true);
			Ext.getCmp('authpass').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('authpassconfirmpassword')) && Ext.getCmp('authpassconfirmpassword') != undefined)
		{
			Ext.getCmp('authpassconfirmpassword').setDisabled(true);
			Ext.getCmp('authpassconfirmpassword').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('authtype')) && Ext.getCmp('authtype') != undefined)
		{
			Ext.getCmp('authtype').setDisabled(true);
			Ext.getCmp('authtype').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptflag_radioGrp')) && Ext.getCmp('encryptflag_radioGrp') != undefined)
		{
			Ext.getCmp('encryptflag_radioGrp').setDisabled(true);
			Ext.getCmp('encryptflag_radioGrp').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encrypttype')) && Ext.getCmp('encrypttype') != undefined)
		{
			Ext.getCmp('encrypttype').setDisabled(true);
			Ext.getCmp('encrypttype').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptpassword')) && Ext.getCmp('encryptpassword') != undefined)
		{
			Ext.getCmp('encryptpassword').setDisabled(true);
			Ext.getCmp('encryptpassword').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptpasswordconfirmpassword')) && Ext.getCmp('encryptpasswordconfirmpassword') != undefined)
		{
			Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
			Ext.getCmp('encryptpasswordconfirmpassword').hide();
		}
	},
	changeEnableMode: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'is_privilege_mode_enabled')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('enable_password').setDisabled(true);
				Ext.getCmp('enable_password').hide();
			}
			else
			{
				Ext.getCmp('enable_password').setDisabled(false);
				Ext.getCmp('enable_password').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeAccessType: function(obj) 
	{
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}

		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		var roleCtrlChecked = Ext.getCmp(radioGroupId+'1').getValue();
		if (roleCtrlChecked)
		{
			Ext.getCmp('AWS_access_key').setDisabled(true);
			Ext.getCmp('AWS_access_key').hide();
			Ext.getCmp('AWS_access_keyconfirmpassword').setDisabled(true);
			Ext.getCmp('AWS_access_keyconfirmpassword').hide();

			Ext.getCmp('AWS_secret_key').setDisabled(true);
			Ext.getCmp('AWS_secret_key').hide();
			Ext.getCmp('AWS_secret_keyconfirmpassword').setDisabled(true);
			Ext.getCmp('AWS_secret_keyconfirmpassword').hide();

			Ext.getCmp('AWS_Role_Name').setDisabled(false);
			Ext.getCmp('AWS_Role_Name').show();

			Ext.getCmp('AWS_Account_ID_To_Monitor').setDisabled(false);
			Ext.getCmp('AWS_Account_ID_To_Monitor').show();

			showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);		
		}
		else
		{
			Ext.getCmp('AWS_access_key').setDisabled(false);
			Ext.getCmp('AWS_access_key').show();
			Ext.getCmp('AWS_access_keyconfirmpassword').setDisabled(false);
			Ext.getCmp('AWS_access_keyconfirmpassword').show();

			Ext.getCmp('AWS_secret_key').setDisabled(false);
			Ext.getCmp('AWS_secret_key').show();
			Ext.getCmp('AWS_secret_keyconfirmpassword').setDisabled(false);
			Ext.getCmp('AWS_secret_keyconfirmpassword').show();

			Ext.getCmp('AWS_Role_Name').setDisabled(true);
			Ext.getCmp('AWS_Role_Name').hide();

			Ext.getCmp('AWS_Account_ID_To_Monitor').setDisabled(true);
			Ext.getCmp('AWS_Account_ID_To_Monitor').hide();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}

		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeValue: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'usealias')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('show_alias_and_interface_name_radioGrp').setDisabled(false);
				Ext.getCmp('show_alias_and_interface_name_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('show_alias_and_interface_name_radioGrp').setDisabled(false);
				Ext.getCmp('show_alias_and_interface_name_radioGrp').reset();
				Ext.getCmp('show_alias_and_interface_name_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'showallevents')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('showAllOnly_radioGrp').setDisabled(true);
				Ext.getCmp('showAllOnly_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('showAllOnly_radioGrp').setDisabled(false);
				Ext.getCmp('showAllOnly_radioGrp').reset();
				Ext.getCmp('showAllOnly_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'report_total')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('Report_only_total_radioGrp').setDisabled(true);
				Ext.getCmp('Report_only_total_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('Report_only_total_radioGrp').setDisabled(false);
				Ext.getCmp('Report_only_total_radioGrp').reset();
				Ext.getCmp('Report_only_total_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'snmpversion')
		{
			var snmpVersion = '';
			if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
			{
				snmpVersion = Ext.getCmp('snmpversion').getValue();
			}
			else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
			{
				snmpVersion = Ext.getCmp('snmpVersion').getValue();
			}

			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];

			if (!Ext.isEmpty(snmpVersion) && snmpVersion != undefined && snmpVersion == "v3"  )
			{
				var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
				var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
				var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
				var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').hide();
				}
				else
				{
					Ext.getCmp('snmpCommunity').hide();
				}
				
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(true);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(true);
				}
				
				if (!Ext.isEmpty(Ext.getCmp('context')) && Ext.getCmp('context') != undefined)
				{
					Ext.getCmp('context').setDisabled(false);
					Ext.getCmp('context').setValue(snmpUserContextValues);
					Ext.getCmp('context').show();
				}
				if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
				{
					Ext.getCmp('username').setDisabled(false);
					Ext.getCmp('username').setValue(snmpUserTextValues);
					Ext.getCmp('username').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authpass')) && Ext.getCmp('authpass') != undefined)
				{
					Ext.getCmp('authpass').setDisabled(false);
					Ext.getCmp('authpass').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authpassconfirmpassword')) && Ext.getCmp('authpassconfirmpassword') != undefined)
				{
					Ext.getCmp('authpassconfirmpassword').setDisabled(false);
					Ext.getCmp('authpassconfirmpassword').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authtype')) && Ext.getCmp('authtype') != undefined)
				{
					Ext.getCmp('authtype').setDisabled(false);
					if (!Ext.isEmpty(selectedSnmpAuthType))
					{
						Ext.getCmp('authtype').setValue(selectedSnmpAuthType);
					}
					else
					{
						Ext.getCmp('authtype').setValue(snmpAuthTypeArr[0].valueField);
					}
					Ext.getCmp('authtype').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptflag_radioGrp')) && Ext.getCmp('encryptflag_radioGrp') != undefined)
				{
					Ext.getCmp('encryptflag_radioGrp').setDisabled(false);
					Ext.getCmp('encryptflag_radioGrp').show();
					var enabled = publicJson['enabledEncryptFlag'];
					var disabled = publicJson['disabledEncryptFlag'];
					Ext.getCmp('encryptflag1').setValue(enabled);
					Ext.getCmp('encryptflag2').setValue(disabled);
				}

				if (!Ext.isEmpty(Ext.getCmp('encrypttype')) && Ext.getCmp('encrypttype') != undefined)
				{
					Ext.getCmp('encrypttype').setDisabled(false);
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptpassword')) && Ext.getCmp('encryptpassword') != undefined)
				{
					Ext.getCmp('encryptpassword').setDisabled(false);
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptpasswordconfirmpassword')) && Ext.getCmp('encryptpasswordconfirmpassword') != undefined)
				{
					Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
				}

				if (disabled)
				{

					Ext.getCmp('encrypttype').hide();

					if (!Ext.isEmpty(selectedSnmpEncType))
					{
						Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
					}
					else
					{
						Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
					}
					Ext.getCmp('encryptpassword').hide();
					Ext.getCmp('encryptpasswordconfirmpassword').hide();
				}
				else
				{
					Ext.getCmp('encrypttype').show();

					if (!Ext.isEmpty(selectedSnmpEncType))
					{
						Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
					}
					else
					{
						Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
					}
					Ext.getCmp('encryptpassword').show();
					Ext.getCmp('encryptpasswordconfirmpassword').show();
				}
				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);
			}
			else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
			{
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(false);
					Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(false);
					Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
				}
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').show();
				}
				else
				{
					Ext.getCmp('snmpCommunity').show();
				}

				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,false);
				this.snmpV3ParamDisabeld();
			}
		}
		else if (radioGroupId.toLowerCase() == 'policyfilter')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var isPolicyFilterValue = publicJson['isPolicyFilterValue'];
			var policyFilterValue = publicJson['policyFilterValue'];
			//var filterArr = publicJson['filterArr'];
			var selectedPolicyFilter = publicJson['selectedPolicyFilter'];
			var filterArr = Ext.getCmp('filter_combo').getStore();
			if (noChecked)
			{
				var policyFilterFalse = publicJson['isPolicyFilterFalse'];
				Ext.getCmp('filter_combo').setDisabled(true);
				Ext.getCmp('filterComboContainer').hide();
				//Ext.getCmp('linkContainer').hide();
				Ext.getCmp('filter_fieldContainer').show();
				if (Ext.getCmp('filter').isDisabled())
				{
					Ext.getCmp('filter').setDisabled(false);
				}
				Ext.getCmp('filter').setValue(policyFilterFalse);
				var temp = {
					xtype: 'hiddenfield',
					name: 'selectedFilterType',
					id: 'selectedFilterType',
					value: 'fieldContainer',
				};
				Ext.getCmp('testConfigForm').add(temp);
			}
			else
			{
				//var externalPageLabel = publicJson['externalPageLabel'];
				//Ext.getCmp('displayMsgLink').update(externalPageLabel);
				//Ext.getCmp('linkContainer').show();

				var temp = {
					xtype: 'hiddenfield',
					name: 'selectedFilterType',
					id: 'selectedFilterType',
					value: 'combo',
				};
				Ext.getCmp('testConfigForm').add(temp);

				Ext.getCmp('filter').setDisabled(true);
				Ext.getCmp('filter_fieldContainer').hide();

				if (Ext.getCmp('filter_combo').isDisabled())
				{
					Ext.getCmp('filter_combo').setDisabled(false);
				}
				var policyFilterTrue = publicJson['isPolicyFilterTrue'];
				var tmpPolDatas = availPolicies.toString();
				if (!Ext.isEmpty(tmpPolDatas) && tmpPolDatas.length > 0 && (policyFilterTrue != tmpPolDatas))
				{
					policyFilterTrue = availPolicies.toString();
				}

				var aListPolArray = new Array();
				var selectPolicy = '';
				var tempStore = new Ext.data.Store({
					fields: ['displayField','valueField'],
					data: []
				});

				if (!Ext.isEmpty(policyFilterValue) && policyFilterValue.indexOf(':') > -1) 
				{
					if(policyFilterValue.indexOf(";") > -1)
					{
						var tempArr = policyFilterValue.split(";");
						for (var i = 0;i< tempArr.length ;i++)
						{
							var tempPolicy = tempArr[i];
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolArray[i] = tempPolicy;
						}
					}
					else
					{
						tempPolicy = (policyFilterValue.substring(0,policyFilterValue.indexOf(":")));
						aListPolArray[0] = tempPolicy;
					}
				}
				else if ((!Ext.isEmpty(policyFilterValue) && policyFilterValue.indexOf(';') > -1) )
				{
					var tempArr = policyFilterValue.split(";");
					for (var i = 0;i< tempArr.length ;i++)
					{
						var tempPolicy = tempArr[i];
						aListPolArray[i] = tempPolicy;
					}
				}
				else
				{
					aListPolArray[0] = policyFilterValue;
				}

				if (!Ext.isEmpty(policyFilterTrue) && policyFilterTrue.length > 0)
				{
					var tmpPolArr = policyFilterTrue.split(',');
					for (var i = 0 ; i < tmpPolArr.length ; i++ )
					{
						var tmpPol = tmpPolArr[i];
						tempStore.add({
							'displayField': tmpPol,
							'valueField': tmpPol
						});
					}
					for (var i = 0 ; i < aListPolArray.length ; i++ )
					{
						var aListPol = aListPolArray[i];
						for (var j = 0 ; j < tmpPolArr.length ; j++ )
						{
							var tmpPol = tmpPolArr[j];
							if ( !Ext.isEmpty(tmpPol) && !Ext.isEmpty(aListPol) && aListPol == tmpPol )
							{
								selectPolicy +=','+tmpPol; 
							}
						}
					}

					if (!Ext.isEmpty(selectPolicy))
					{
						selectPolicy = selectPolicy.substring(1);
					}
				}

				if (isFirstFilterCombo)
				{
					Ext.getCmp('filter_combo').getStore().removeAll();  
					for ( var i = 0; i < tempStore.getCount() ; i++ )
					{
						var getRecord = tempStore.getAt(i);
						if (getRecord.get('displayField') == 'all')
						{
							continue;
						}
						Ext.getCmp('filter_combo').getStore().add(getRecord);
					}
					
					Ext.getCmp('filter_combo').getStore().sort('displayField', 'ASC');
					Ext.getCmp('filter_combo').getStore().insert(0,{displayField:'all', valueField:'all'});
					Ext.getCmp('filter_combo').setValue(selectPolicy);
				}
				Ext.getCmp('filterComboContainer').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'measure_mode')
		{
			var measureModeLog = Ext.getCmp('measure_mode1').getValue();
			var measureModeJmx = Ext.getCmp('measure_mode2').getValue();

			var jmxRemotePortObj = Ext.getCmp('Jmx_Remote_Port'); 
			var jndiNameObj = Ext.getCmp('Jndi_Name');
			var userParamNameObj = Ext.getCmp('Jmx_user');
			var JMXregistrySslParamNameObj = Ext.getCmp('Jmx_registry_ssl_radioGrp');
			var pwdParamNameObj = Ext.getCmp('Jmx_password');
			var pwdConfirmParamNameObj = Ext.getCmp('Jmx_passwordconfirmpassword');
			var providerParamNameObj = Ext.getCmp('Provider');
			var serviceURLPathNameObj = Ext.getCmp('service_URL_path');
			if (userParamNameObj == undefined)
			{
				userParamNameObj =  Ext.getCmp('user');
			}
			if (pwdParamNameObj == undefined)
			{
				pwdParamNameObj =  Ext.getCmp('password');
			}
			if (pwdConfirmParamNameObj == undefined)
			{
				pwdConfirmParamNameObj =  Ext.getCmp('passwordconfirmpassword');
			}
			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];
			if (measureModeLog)
			{
				JMXParamDisable(jmxRemotePortObj);
				JMXParamDisable(jndiNameObj);
				JMXParamDisable(userParamNameObj);
				JMXParamDisable(JMXregistrySslParamNameObj);
				JMXParamDisable(pwdParamNameObj);
				JMXParamDisable(pwdConfirmParamNameObj);
				JMXParamDisable(providerParamNameObj);
				JMXParamDisable(serviceURLPathNameObj);

				Ext.getCmp('JREHome').setDisabled(false);
				Ext.getCmp('JREHome').reset();
				Ext.getCmp('JREHome').show();
				Ext.getCmp('LogFileName').setDisabled(false);
				Ext.getCmp('LogFileName').reset();
				Ext.getCmp('LogFileName').show();
				
				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);
			}
			else if (measureModeJmx)
			{
				Ext.getCmp('LogFileName').setDisabled(true);
				Ext.getCmp('LogFileName').hide();
				Ext.getCmp('JREHome').setDisabled(true);
				Ext.getCmp('JREHome').hide();

				JMXParamEnable(jmxRemotePortObj);
				JMXParamEnable(jndiNameObj);
				JMXParamEnable(userParamNameObj);
				JMXParamEnable(JMXregistrySslParamNameObj);				
				JMXParamEnable(pwdParamNameObj);
				JMXParamEnable(pwdConfirmParamNameObj);
				JMXParamEnable(providerParamNameObj);
				JMXParamEnable(serviceURLPathNameObj);

				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}
		}
		else if (radioGroupId.toLowerCase() == 'measurement_mode')
		{
			var measurementModeWar = Ext.getCmp('measurement_mode1').getValue();
			var measurementModeJmx = Ext.getCmp('measurement_mode2').getValue();
			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];
			if (measurementModeWar)
			{
				Ext.getCmp('Jmx_Remote_Port').setDisabled(true);
				Ext.getCmp('Jmx_Remote_Port').hide();
				Ext.getCmp('Jndi_Name').setDisabled(true);
				Ext.getCmp('Jndi_Name').hide();
				Ext.getCmp('Jmx_user').setDisabled(true);
				Ext.getCmp('Jmx_user').hide();
				Ext.getCmp('Jmx_password').setDisabled(true);
				Ext.getCmp('Jmx_password').hide();
				Ext.getCmp('Jmx_passwordconfirmpassword').setDisabled(true);
				Ext.getCmp('Jmx_passwordconfirmpassword').hide();
				Ext.getCmp('Provider').setDisabled(true);
				Ext.getCmp('Provider').hide();
			
				Ext.getCmp('ssl_radioGrp').setDisabled(false);
				Ext.getCmp('ssl_radioGrp').show();
				Ext.getCmp('url').setDisabled(false);
				Ext.getCmp('url').reset();
				Ext.getCmp('url').show();
				Ext.getCmp('username').setDisabled(false);
				Ext.getCmp('username').reset();
				Ext.getCmp('username').show();
				Ext.getCmp('password').setDisabled(false);
				Ext.getCmp('password').reset();
				Ext.getCmp('password').show();
				Ext.getCmp('passwordconfirmpassword').setDisabled(false);
				Ext.getCmp('passwordconfirmpassword').reset();
				Ext.getCmp('passwordconfirmpassword').show();
				Ext.getCmp('encryptPass_radioGrp').setDisabled(false);
				Ext.getCmp('encryptPass_radioGrp').show();
				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);

			}
			else if (measurementModeJmx)
			{
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('url').setDisabled(true);
				Ext.getCmp('url').hide();
				Ext.getCmp('username').setDisabled(true);
				Ext.getCmp('username').hide();
				Ext.getCmp('password').setDisabled(true);
				Ext.getCmp('password').hide();
				Ext.getCmp('passwordconfirmpassword').setDisabled(true);
				Ext.getCmp('passwordconfirmpassword').hide();
				Ext.getCmp('encryptPass_radioGrp').setDisabled(true);
				Ext.getCmp('encryptPass_radioGrp').hide();
				
				Ext.getCmp('Jmx_Remote_Port').setDisabled(false);
				Ext.getCmp('Jmx_Remote_Port').reset();
				Ext.getCmp('Jmx_Remote_Port').show();
				Ext.getCmp('Jndi_Name').setDisabled(false);
				Ext.getCmp('Jndi_Name').reset();
				Ext.getCmp('Jndi_Name').show();
				Ext.getCmp('Jmx_user').setDisabled(false);
				Ext.getCmp('Jmx_user').reset();
				Ext.getCmp('Jmx_user').show();
				Ext.getCmp('Jmx_password').setDisabled(false);
				Ext.getCmp('Jmx_password').reset();
				Ext.getCmp('Jmx_password').show();
				Ext.getCmp('Jmx_passwordconfirmpassword').setDisabled(false);
				Ext.getCmp('Jmx_passwordconfirmpassword').reset();
				Ext.getCmp('Jmx_passwordconfirmpassword').show();
				Ext.getCmp('Provider').setDisabled(false);
				Ext.getCmp('Provider').reset();
				Ext.getCmp('Provider').show();
				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}
		}
		else if (radioGroupId.toLowerCase() == 'adapter_device_selection')
		{
			var isAdapterAuto = Ext.getCmp('adapter_device_selection1').getValue();
			var isAdapterManual = Ext.getCmp('adapter_device_selection2').getValue();
			if (isAdapterManual)
			{
				Ext.getCmp('device_name').setDisabled(false);
				Ext.getCmp('device_name').show();
				Ext.getCmp('device_id').setDisabled(false);
				Ext.getCmp('device_id').show();
			}
			else if (isAdapterAuto)
			{
				Ext.getCmp('device_name').setDisabled(true);
				Ext.getCmp('device_name').hide();
				Ext.getCmp('device_id').setDisabled(true);
				Ext.getCmp('device_id').hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'correct')
		{
			var isCorrectYes = Ext.getCmp('correct1').getValue();
			var isCorrectNo = Ext.getCmp('correct2').getValue();
			if (isCorrectYes)
			{
				//alarmtype
				//userparams
				//correctivescript
				Ext.getCmp('alarmtype').setDisabled(false);
				Ext.getCmp('alarmtype').show();
				Ext.getCmp('userparams').setDisabled(false);
				Ext.getCmp('userparams').show();
				Ext.getCmp('correctivescript').setDisabled(false);
				Ext.getCmp('correctivescript').show();
			}
			else if (isCorrectNo)
			{
				//alarmtype
				//userparams
				//correctivescript
				Ext.getCmp('alarmtype').setDisabled(true);
				Ext.getCmp('alarmtype').hide();
				Ext.getCmp('userparams').setDisabled(true);
				Ext.getCmp('userparams').hide();
				Ext.getCmp('correctivescript').setDisabled(true);
				Ext.getCmp('correctivescript').hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'is_trail')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var reqPerDayObj = Ext.getCmp('Requests_Per_Day');
			if (noChecked)
			{
				reqPerDayObj.setDisabled(true);
				reqPerDayObj.hide();
			}
			else
			{
				reqPerDayObj.setDisabled(false);
				reqPerDayObj.show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'use_sudo')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var userNameObj = Ext.getCmp('Target_Process_User_Name');
			if (noChecked)
			{
				userNameObj.setDisabled(true);
				userNameObj.hide();
			}
			else
			{
				userNameObj.setDisabled(false);
				userNameObj.show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'advanced_settings')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var pojoMtdTrcLmtObj = Ext.getCmp('Pojo_Method_Tracing_Limit');
			var pojoMtdTrcCutTimeObj = Ext.getCmp('Pojo_Method_Tracing_Cutoff_Time');
			var recrsvMtdTrcLmtObj = Ext.getCmp('Recursive_Method_Tracing_Limit');
			var nonPojoMtdTrcLmtObj = Ext.getCmp('Non-Pojo_Method_Tracing_Limit');
			var expStLnsObj = Ext.getCmp('Exception_Stacktrace_Lines');
			var includExpObj = Ext.getCmp('Included_Exceptions');
			var ignoreExpObj = Ext.getCmp('Ignored_Exceptions');
			var ignoreCharObj = Ext.getCmp('Ignored_Characters');
			var maxgrpUrlperMsrPrdObj = Ext.getCmp('Max_Grouped_Urls_Per_Measure_Period');
			var kmaxgrpUrlperMsrPrdObj = Ext.getCmp('Key_Max_Grouped_Urls_Per_Measure_Period');
			var maxQryPerTrnsObj = Ext.getCmp('Max_Sql_Queries_Per_Transaction');
			var maxMongoDbQryLntObj = Ext.getCmp('Max_Mongodb_Query_Length')
			var maxExceptionLntObj = Ext.getCmp('Max_Exception_Trace_Limit');
			var maxExecStackLntObj = Ext.getCmp('Exception_With_StackTrace_Capture_Limit');
			var maxExecFqenLntObj = Ext.getCmp('Exception_FQEN_Capture_Limit');
			var maxSqlErrQueryLntObj = Ext.getCmp('Max_Sql_Error_Queries_Per_Transaction');
			var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
			var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");;
			var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
			var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");

			if (noChecked)
			{
				pojoMtdTrcLmtObj.setDisabled(true);
				pojoMtdTrcLmtObj.hide();
				pojoMtdTrcCutTimeObj.setDisabled(true);
				pojoMtdTrcCutTimeObj.hide();
				recrsvMtdTrcLmtObj.setDisabled(true);
				recrsvMtdTrcLmtObj.hide();
				nonPojoMtdTrcLmtObj.setDisabled(true);
				nonPojoMtdTrcLmtObj.hide();
				expStLnsObj.setDisabled(true);
				expStLnsObj.hide();
				includExpObj.setDisabled(true);
				includExpObj.hide();
				ignoreExpObj.setDisabled(true);
				ignoreExpObj.hide();
				ignoreCharObj.setDisabled(true);
				ignoreCharObj.hide();
				maxMongoDbQryLntObj.setDisabled(true);
				maxMongoDbQryLntObj.hide();
				if (!Ext.isEmpty(maxgrpUrlperMsrPrdObj) && maxgrpUrlperMsrPrdObj != undefined){
					maxgrpUrlperMsrPrdObj.setDisabled(true);
					maxgrpUrlperMsrPrdObj.hide();
				}
				else{
					kmaxgrpUrlperMsrPrdObj.setDisabled(true);
					kmaxgrpUrlperMsrPrdObj.hide();
				}
				maxQryPerTrnsObj.setDisabled(true);
				maxQryPerTrnsObj.hide();
				maxExceptionLntObj.setDisabled(true);
				maxExceptionLntObj.hide();
				maxExecStackLntObj.setDisabled(true);
				maxExecStackLntObj.hide();
				maxExecFqenLntObj.setDisabled(true);
				maxExecFqenLntObj.hide();
				maxSqlErrQueryLntObj.setDisabled(true);
				maxSqlErrQueryLntObj.hide();
				maskSQLObj.setDisabled(true);
				maskSQLObj.hide();
				maskPublicIPObj.setDisabled(true);
				maskPublicIPObj.hide();
				maskPrivateIPObj.setDisabled(true);
				maskPrivateIPObj.hide();
				maskUrlParamsObj.setDisabled(true);
				maskUrlParamsObj.hide();
			}
			else
			{
				pojoMtdTrcLmtObj.setDisabled(false);
				pojoMtdTrcLmtObj.show();
				pojoMtdTrcCutTimeObj.setDisabled(false);
				pojoMtdTrcCutTimeObj.show();
				recrsvMtdTrcLmtObj.setDisabled(false);
				recrsvMtdTrcLmtObj.show();
				nonPojoMtdTrcLmtObj.setDisabled(false);
				nonPojoMtdTrcLmtObj.show();
				expStLnsObj.setDisabled(false);
				expStLnsObj.show();
				includExpObj.setDisabled(false);
				includExpObj.show();
				ignoreExpObj.setDisabled(false);
				ignoreExpObj.show();
				ignoreCharObj.setDisabled(false);
				ignoreCharObj.show();
				maxMongoDbQryLntObj.setDisabled(false);
				maxMongoDbQryLntObj.show();
				if (!Ext.isEmpty(maxgrpUrlperMsrPrdObj) && maxgrpUrlperMsrPrdObj != undefined){
					maxgrpUrlperMsrPrdObj.setDisabled(false);
					maxgrpUrlperMsrPrdObj.show();
				}
				else{
					kmaxgrpUrlperMsrPrdObj.setDisabled(false);
					kmaxgrpUrlperMsrPrdObj.show();
				}
				maxQryPerTrnsObj.setDisabled(false);
				maxQryPerTrnsObj.show();
				maxExceptionLntObj.setDisabled(false);
				maxExceptionLntObj.show();
				maxExecStackLntObj.setDisabled(false);
				maxExecStackLntObj.show();
				maxExecFqenLntObj.setDisabled(false);
				maxExecFqenLntObj.show();
				maxSqlErrQueryLntObj.setDisabled(false);
				maxSqlErrQueryLntObj.show();
				maskSQLObj.setDisabled(false);
				maskSQLObj.show();
				maskPublicIPObj.setDisabled(false);
				maskPublicIPObj.show();
				maskPrivateIPObj.setDisabled(false);
				maskPrivateIPObj.show();
				maskUrlParamsObj.setDisabled(false);
				maskUrlParamsObj.show();
			}
		}
	},
	exectimeChangeEvt: function(obj)
	{
		var execOption = obj.getValue();

		var testPeriod = "86400";
		if (!Ext.isEmpty(execOption) && execOption == 'hourly')
		{
			testPeriod = "3600";
			Ext.getCmp('hours').hide();
			Ext.getCmp('hours').setDisabled(true);
			Ext.getCmp('minutes').setDisabled(true);
			Ext.getCmp('minutes').hide();
		}
		else if (!Ext.isEmpty(execOption) && execOption == 'daily')
		{
			testPeriod = "86400";
			Ext.getCmp('hours').show();
			Ext.getCmp('minutes').show();
			Ext.getCmp('hours').setDisabled(false);
			Ext.getCmp('minutes').setDisabled(false);

		}

		Ext.getCmp('testPeriod').setValue(testPeriod);
	},
	//changeMonitorLevel: function(obj)
	//{
		//var radioGroupId = '';
		//value = obj.getBox().y;
		//if (!Ext.isEmpty(obj))
		//{
			//radioGroupId = obj.id;
		//}
		//if (radioGroupId.toLowerCase() == 'monitoring_level')
		//{
			//var monLevel = Ext.getCmp('Monitoring_Level').getValue();
			//if (!Ext.isEmpty(monLevel) && (monLevel == '1' || monLevel == '2'))
			//{
				//Ext.getCmp('max_grouped_urls').setDisabled(true);
				//Ext.getCmp('max_grouped_urls').hide();
				//Ext.getCmp('max_slow_dd_count').setDisabled(true);
				//Ext.getCmp('max_slow_dd_count').hide();
				//Ext.getCmp('max_error_dd_count').setDisabled(true);
				//Ext.getCmp('max_error_dd_count').hide();
			//}
			//else if (!Ext.isEmpty(monLevel) && monLevel == '3')
			//{
				//Ext.getCmp('max_grouped_urls').setDisabled(true);
				//Ext.getCmp('max_grouped_urls').hide();
				//Ext.getCmp('max_slow_dd_count').setDisabled(false);
				//Ext.getCmp('max_slow_dd_count').show();
				//Ext.getCmp('max_error_dd_count').setDisabled(false);
				//Ext.getCmp('max_error_dd_count').show();
			//}
			//else if (!Ext.isEmpty(monLevel) && monLevel == '4')
			//{
				//Ext.getCmp('max_grouped_urls').setDisabled(false);
				//Ext.getCmp('max_grouped_urls').show();
				//Ext.getCmp('max_slow_dd_count').setDisabled(false);
				//Ext.getCmp('max_slow_dd_count').show();
				//Ext.getCmp('max_error_dd_count').setDisabled(false);
				//Ext.getCmp('max_error_dd_count').show();
			//}
		//}
		//Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	//},
	changeJmxOptionValue: function(obj){
		var radioGroupId = '';
		value = obj.getBox().y;
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		var jmxOptionShow = Ext.getCmp('metric_collection_type1').getValue();
		var jmxOptionHide = Ext.getCmp('metric_collection_type2').getValue();
		var modeTempObj = Ext.getCmp('mode_radioGrp');
		var measureTempObj = Ext.getCmp('measure_mode_radioGrp');
		var jmxRemotePortObj = Ext.getCmp('Jmx_Remote_Port'); 
		var jndiNameObj = Ext.getCmp('Jndi_Name');
		var userParamNameObj = Ext.getCmp('Jmx_user');
		var JMXregistrySslParamNameObj = Ext.getCmp('Jmx_registry_ssl_radioGrp');		
		var pwdParamNameObj = Ext.getCmp('Jmx_password');
		var pwdConfirmParamNameObj = Ext.getCmp('Jmx_passwordconfirmpassword');
		var providerParamNameObj = Ext.getCmp('Provider');
		var serviceURLPathNameObj = Ext.getCmp('service_URL_path');
		var isLocalModeParamExist = publicJson['isLocalModeParamExist'];
		if (userParamNameObj == undefined)
		{
			userParamNameObj =  Ext.getCmp('user');
		}
		if (pwdParamNameObj == undefined)
		{
			pwdParamNameObj =  Ext.getCmp('password');
		}
		if (pwdConfirmParamNameObj == undefined)
		{
			pwdConfirmParamNameObj =  Ext.getCmp('passwordconfirmpassword');
		}
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];
		if (jmxOptionHide)
		{
			if (!(Ext.isEmpty(modeTempObj)))
			{
				modeTempObj.hide();
				Ext.getCmp('snmpPort').setDisabled(true);
				Ext.getCmp('snmpPort').hide();

				var snmpVerObject = '';
				if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
				{
					snmpVerObject = Ext.getCmp('snmpversion');
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
				{
					snmpVerObject = Ext.getCmp('snmpVersion');
				}
				snmpVerObject.setDisabled(true);
				snmpVerObject.hide();

				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').hide();
				}
				else
				{
					Ext.getCmp('snmpCommunity').hide();
				}
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(true);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(true);
				}
				this.snmpV3ParamDisabeld();
			}
			if (!(Ext.isEmpty(measureTempObj)))
			{
				measureTempObj.hide();

				Ext.getCmp('LogFileName').setDisabled(true);
				Ext.getCmp('LogFileName').hide();
				Ext.getCmp('JREHome').setDisabled(true);
				Ext.getCmp('JREHome').hide();

				//showToPwdProfile(pwdProfileShowList,false);
				//showToPwdProfile(pwdProfileHideList,true);
			}
			JMXParamDisable(jmxRemotePortObj);
			JMXParamDisable(jndiNameObj);
			JMXParamDisable(userParamNameObj);
			JMXParamDisable(JMXregistrySslParamNameObj);
			JMXParamDisable(pwdParamNameObj);
			JMXParamDisable(pwdConfirmParamNameObj);
			JMXParamDisable(providerParamNameObj);
			JMXParamDisable(serviceURLPathNameObj);
			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,false);
		}
		else if (jmxOptionShow)
		{
			if (testName.toLowerCase() == 'jvmmempoolgctest')
			{
				JMXParamEnable(measureTempObj);
				var measureModeLog = Ext.getCmp('measure_mode1').getValue();
				var measureModeJmx = Ext.getCmp('measure_mode2').getValue();
				//me.changeValue(measureTempObj);
				if (measureModeLog)
				{
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(JMXregistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);
			
					Ext.getCmp('JREHome').setDisabled(false);
					Ext.getCmp('JREHome').reset();
					Ext.getCmp('JREHome').show();
					Ext.getCmp('LogFileName').setDisabled(false);
					Ext.getCmp('LogFileName').reset();
					Ext.getCmp('LogFileName').show();
					
					showToPwdProfile(pwdProfileShowList,true);
					showToPwdProfile(pwdProfileHideList,false);

				}
				else if (measureModeJmx)
				{
					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(JMXregistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);
		
					Ext.getCmp('LogFileName').setDisabled(true);
					Ext.getCmp('LogFileName').hide();
					Ext.getCmp('JREHome').setDisabled(true);
					Ext.getCmp('JREHome').hide();

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}
			}
			else if (testName.toLowerCase() != 'jvmfiledescriptortest' && testName.toLowerCase() != 'jmxconnectortest' && testName.toLowerCase() != 'jvmsummarytest')
			{
				JMXParamEnable(modeTempObj);
				//me.changeModeValue(modeTempObj);
				var modeSNMP = Ext.getCmp('mode1').getValue();
				var modeJMX = Ext.getCmp('mode2').getValue();
				if (modeSNMP)
				{
					if(isLocalModeParamExist){
						JMXParamDisable(jmxRemotePortObj);
						JMXParamDisable(jndiNameObj);
						JMXParamDisable(userParamNameObj);
						JMXParamDisable(JMXregistrySslParamNameObj);
						JMXParamDisable(pwdParamNameObj);
						JMXParamDisable(pwdConfirmParamNameObj);
						JMXParamDisable(providerParamNameObj);
						JMXParamDisable(serviceURLPathNameObj);
					}
					else{
						JMXParamDisable(jmxRemotePortObj);
						JMXParamDisable(jndiNameObj);
						JMXParamDisable(userParamNameObj);
						JMXParamDisable(JMXregistrySslParamNameObj);
						JMXParamDisable(pwdParamNameObj);
						JMXParamDisable(pwdConfirmParamNameObj);
						JMXParamDisable(providerParamNameObj);
						JMXParamDisable(serviceURLPathNameObj);

						var snmpVerObject = '';
						var snmpVersion = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
							snmpVersion = snmpVerObject.getValue();
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
							snmpVersion = snmpVerObject.getValue();
						}

						Ext.getCmp('snmpPort').setDisabled(false);
						Ext.getCmp('snmpPort').reset();
						Ext.getCmp('snmpPort').setValue(snmpPortextValues);

						Ext.getCmp('snmpPort').show();
						snmpVerObject.setDisabled(false);
						//Ext.getCmp('snmpPort').reset();
						snmpVerObject.show();
						if (!Ext.isEmpty(snmpVersion) && snmpVersion == "v3"  )
						{
							var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
							var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
							var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
							var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
							{
								Ext.getCmp('snmpcommunity').hide();
							}
							else
							{
								Ext.getCmp('snmpCommunity').hide();
							}

							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
							{
								Ext.getCmp('snmpcommunity').setDisabled(true);
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
							{
								Ext.getCmp('snmpCommunity').setDisabled(true);
							}
							Ext.getCmp('context').setDisabled(false);
							Ext.getCmp('username').setDisabled(false);
							Ext.getCmp('authpass').setDisabled(false);
							Ext.getCmp('authpassconfirmpassword').setDisabled(false);
							Ext.getCmp('authtype').setDisabled(false);
							Ext.getCmp('encryptflag_radioGrp').setDisabled(false);
							Ext.getCmp('encrypttype').setDisabled(false);
							Ext.getCmp('encryptpassword').setDisabled(false);
							Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
							Ext.getCmp('context').setValue(snmpUserContextValues);
							Ext.getCmp('context').show();
							Ext.getCmp('username').setValue(snmpUserTextValues);
							Ext.getCmp('username').show();

							Ext.getCmp('authpass').show();
							Ext.getCmp('authpassconfirmpassword').show();
							if (!Ext.isEmpty(selectedSnmpAuthType))
							{
								Ext.getCmp('authtype').setValue(selectedSnmpAuthType);
							}
							else
							{
								Ext.getCmp('authtype').setValue(snmpAuthTypeArr[0].valueField);
							}
							Ext.getCmp('authtype').show();
							Ext.getCmp('encryptflag_radioGrp').show();
							var enabled = publicJson['enabledEncryptFlag'];
							var disabled = publicJson['disabledEncryptFlag'];
							Ext.getCmp('encryptflag1').setValue(enabled);
							Ext.getCmp('encryptflag2').setValue(disabled);
							if (disabled)
							{

								Ext.getCmp('encrypttype').hide();

								if (!Ext.isEmpty(selectedSnmpEncType))
								{
									Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
								}
								else
								{
									Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
								}
								Ext.getCmp('encryptpassword').hide();
								Ext.getCmp('encryptpasswordconfirmpassword').hide();
							}
							else
							{
								Ext.getCmp('encrypttype').show();

								if (!Ext.isEmpty(selectedSnmpEncType))
								{
									Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
								}
								else
								{
									Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
								}
								Ext.getCmp('encryptpassword').show();
								Ext.getCmp('encryptpasswordconfirmpassword').show();
							}
							showToPwdProfile(pwdProfileShowList,true);
							showToPwdProfile(pwdProfileHideList,false);
						}
						else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
						{
							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
							{
								Ext.getCmp('snmpcommunity').setDisabled(false);
								Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
							{
								Ext.getCmp('snmpCommunity').setDisabled(false);
								Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
							}
							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
							{
								Ext.getCmp('snmpcommunity').show();
							}
							else
							{
								Ext.getCmp('snmpCommunity').show();
							}
							showToPwdProfile(pwdProfileShowList,false);
							showToPwdProfile(pwdProfileHideList,false);
							this.snmpV3ParamDisabeld();
						}
					}
				}
				else if (modeJMX)
				{
					if(isLocalModeParamExist){
						JMXParamEnable(jmxRemotePortObj);
						JMXParamEnable(jndiNameObj);
						JMXParamEnable(userParamNameObj);
						JMXParamEnable(JMXregistrySslParamNameObj);
						JMXParamEnable(pwdParamNameObj);
						JMXParamEnable(pwdConfirmParamNameObj);
						JMXParamEnable(providerParamNameObj);
						JMXParamEnable(serviceURLPathNameObj);

						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,true);
					}else{
					
						Ext.getCmp('snmpPort').setDisabled(true);
						Ext.getCmp('snmpPort').hide();

						var snmpVerObject = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
						}
						snmpVerObject.setDisabled(true);
						snmpVerObject.hide();

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').hide();
						}
						else
						{
							Ext.getCmp('snmpCommunity').hide();
						}
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(true);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(true);
						}
						this.snmpV3ParamDisabeld();

						JMXParamEnable(jmxRemotePortObj);
						JMXParamEnable(jndiNameObj);
						JMXParamEnable(userParamNameObj);
						JMXParamEnable(JMXregistrySslParamNameObj);
						JMXParamEnable(pwdParamNameObj);
						JMXParamEnable(pwdConfirmParamNameObj);
						JMXParamEnable(providerParamNameObj);
						JMXParamEnable(serviceURLPathNameObj);

						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,true);
					}
				}
			}
			else
			{
				JMXParamEnable(jmxRemotePortObj);
				JMXParamEnable(jndiNameObj);
				JMXParamEnable(userParamNameObj);
				JMXParamEnable(JMXregistrySslParamNameObj);
				JMXParamEnable(pwdParamNameObj);
				JMXParamEnable(pwdConfirmParamNameObj);
				JMXParamEnable(providerParamNameObj);
				JMXParamEnable(serviceURLPathNameObj);
			}
		}
	},
	changeModeValue: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'mode')
		{
			var modeSNMP = Ext.getCmp('mode1').getValue();
			var modeJMX = Ext.getCmp('mode2').getValue();
			
			var jmxRemotePortObj = Ext.getCmp('Jmx_Remote_Port'); 
			var jndiNameObj = Ext.getCmp('Jndi_Name');
			var userParamNameObj = Ext.getCmp('Jmx_user');
			var JMXregistrySslParamNameObj =Ext.getCmp('Jmx_registry_ssl_radioGrp');
			var pwdParamNameObj = Ext.getCmp('Jmx_password');
			var pwdConfirmParamNameObj = Ext.getCmp('Jmx_passwordconfirmpassword');
			var providerParamNameObj = Ext.getCmp('Provider');
			var serviceURLPathNameObj = Ext.getCmp('service_URL_path');
			var isLocalModeParamExist = publicJson['isLocalModeParamExist'];
			if (userParamNameObj == undefined)
			{
				userParamNameObj =  Ext.getCmp('user');
			}
			if (pwdParamNameObj == undefined)
			{
				pwdParamNameObj =  Ext.getCmp('password');
			}
			if (pwdConfirmParamNameObj == undefined)
			{
				pwdConfirmParamNameObj =  Ext.getCmp('passwordconfirmpassword');
			}
			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];

			if (modeSNMP)
			{
				if(isLocalModeParamExist){
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(JMXregistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,false);
				}
				else{
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(JMXregistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);

					var snmpVerObject = '';
					var snmpVersion = '';
					if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpversion');
						snmpVersion = snmpVerObject.getValue();
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpVersion');
						snmpVersion = snmpVerObject.getValue();
					}

					Ext.getCmp('snmpPort').setDisabled(false);
					Ext.getCmp('snmpPort').reset();
					Ext.getCmp('snmpPort').setValue(snmpPortextValues);

					Ext.getCmp('snmpPort').show();
					snmpVerObject.setDisabled(false);
					//Ext.getCmp('snmpPort').reset();
					snmpVerObject.show();
					if (!Ext.isEmpty(snmpVersion) && snmpVersion == "v3"  )
					{
						var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
						var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
						var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
						var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').hide();
						}
						else
						{
							Ext.getCmp('snmpCommunity').hide();
						}

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(true);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(true);
						}
						Ext.getCmp('context').setDisabled(false);
						Ext.getCmp('username').setDisabled(false);
						Ext.getCmp('authpass').setDisabled(false);
						Ext.getCmp('authpassconfirmpassword').setDisabled(false);
						Ext.getCmp('authtype').setDisabled(false);
						Ext.getCmp('encryptflag_radioGrp').setDisabled(false);
						Ext.getCmp('encrypttype').setDisabled(false);
						Ext.getCmp('encryptpassword').setDisabled(false);
						Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
						Ext.getCmp('context').setValue(snmpUserContextValues);
						Ext.getCmp('context').show();
						Ext.getCmp('username').setValue(snmpUserTextValues);
						Ext.getCmp('username').show();

						Ext.getCmp('authpass').show();
						Ext.getCmp('authpassconfirmpassword').show();
						if (!Ext.isEmpty(selectedSnmpAuthType))
						{
							Ext.getCmp('authtype').setValue(selectedSnmpAuthType);
						}
						else
						{
							Ext.getCmp('authtype').setValue(snmpAuthTypeArr[0].valueField);
						}
						Ext.getCmp('authtype').show();
						Ext.getCmp('encryptflag_radioGrp').show();
						var enabled = publicJson['enabledEncryptFlag'];
						var disabled = publicJson['disabledEncryptFlag'];
						Ext.getCmp('encryptflag1').setValue(enabled);
						Ext.getCmp('encryptflag2').setValue(disabled);
						if (disabled)
						{

							Ext.getCmp('encrypttype').hide();

							if (!Ext.isEmpty(selectedSnmpEncType))
							{
								Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
							}
							else
							{
								Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
							}
							Ext.getCmp('encryptpassword').hide();
							Ext.getCmp('encryptpasswordconfirmpassword').hide();
						}
						else
						{
							Ext.getCmp('encrypttype').show();

							if (!Ext.isEmpty(selectedSnmpEncType))
							{
								Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
							}
							else
							{
								Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
							}
							Ext.getCmp('encryptpassword').show();
							Ext.getCmp('encryptpasswordconfirmpassword').show();
						}
						showToPwdProfile(pwdProfileShowList,true);
						showToPwdProfile(pwdProfileHideList,false);
					}
					else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
					{
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(false);
							Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(false);
							Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
						}
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').show();
						}
						else
						{
							Ext.getCmp('snmpCommunity').show();
						}
						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,false);
						this.snmpV3ParamDisabeld();
					}
				}
			}
			else if (modeJMX)
			{
				if(isLocalModeParamExist){
					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(JMXregistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}else{
					Ext.getCmp('snmpPort').setDisabled(true);
					Ext.getCmp('snmpPort').hide();

					var snmpVerObject = '';
					if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpversion');
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpVersion');
					}
					snmpVerObject.setDisabled(true);
					snmpVerObject.hide();

					if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
					{
						Ext.getCmp('snmpcommunity').hide();
					}
					else
					{
						Ext.getCmp('snmpCommunity').hide();
					}
					if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
					{
						Ext.getCmp('snmpcommunity').setDisabled(true);
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
					{
						Ext.getCmp('snmpCommunity').setDisabled(true);
					}
					this.snmpV3ParamDisabeld();

					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(JMXregistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}
			}

			//var heapYes = Ext.getCmp('Heap_Analysis1').getValue();
			//var heapNo = Ext.getCmp('Heap_Analysis2').getValue();

			//if (heapYes)
			//{
				//if (paramName == 'Java_Home')
				//{
					//Ext.getCmp('Java_Home').setDisabled(false);
					//Ext.getCmp('JAVA_HOME').show();
				//}
				//else if (paramName == 'Include_Packages')
				//{
					//Ext.getCmp('Include_Packages').setDisabled(false);
					//Ext.getCmp('INCLUDE_PACKAGES').show();
				//}
				//else if (paramName == 'Exclude_Packages')
				//{
					//Ext.getCmp('Exclude_Packages').setDisabled(false);
					//Ext.getCmp('EXCLUDE_PACKAGES').show();
				//}
			//}
			//else if (heapNo)
			//{
				//if (paramName == 'Java_Home')
				//{
					//Ext.getCmp('Java_Home').setDisabled(false);
					//Ext.getCmp('JAVA_HOME').show();
				//}
				//else if (paramName == 'Include_Packages')
				//{
					//Ext.getCmp('Include_Packages').setDisabled(false);
					//Ext.getCmp('INCLUDE_PACKAGES').show();
				//}
				//else if (paramName == 'Exclude_Packages')
				//{
					//Ext.getCmp('Exclude_Packages').setDisabled(false);
					//Ext.getCmp('EXCLUDE_PACKAGES').show();
				//}
			//}
		}
		else if (radioGroupId.toLowerCase() == 'heap_analysis')
		{
			var heapYes = Ext.getCmp('Heap_Analysis1').getValue();
			var heapNo = Ext.getCmp('Heap_Analysis2').getValue();
			if (heapYes)
			{
				Ext.getCmp('Java_Home').setDisabled(false);
				Ext.getCmp('Java_Home').show();
				Ext.getCmp('Include_Packages').setDisabled(false);
				Ext.getCmp('Include_Packages').show();
				Ext.getCmp('Exclude_Packages').setDisabled(false);
				Ext.getCmp('Exclude_Packages').show();
				Ext.getCmp('Heap_Dump_Location').setDisabled(false);
				Ext.getCmp('Heap_Dump_Location').show();
			}
			else if (heapNo)
			{
				Ext.getCmp('Java_Home').setDisabled(true);
				Ext.getCmp('Java_Home').hide();
				Ext.getCmp('Include_Packages').setDisabled(true);
				Ext.getCmp('Include_Packages').hide();
				Ext.getCmp('Exclude_Packages').setDisabled(true);
				Ext.getCmp('Exclude_Packages').hide();
				Ext.getCmp('Heap_Dump_Location').setDisabled(true);
				Ext.getCmp('Heap_Dump_Location').hide();
			}
		}
	},
	changeSAPControl: function() 
	{
		var useSAPControlYes = Ext.getCmp('use_sapcontrol1').getValue();
		var useSAPControlNo = Ext.getCmp('use_sapcontrol2').getValue();
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];
    
		if (useSAPControlNo)
		{
			Ext.getCmp('ssl_radioGrp').setDisabled(true);
			Ext.getCmp('ssl_radioGrp').hide();
			Ext.getCmp('os_username').setDisabled(true);
			Ext.getCmp('os_username').hide();
			Ext.getCmp('os_password').setDisabled(true);
			Ext.getCmp('os_password').hide();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('os_passwordconfirmpassword').hide();
			Ext.getCmp('wsdl_port').setDisabled(true);
			Ext.getCmp('wsdl_port').hide();

			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}
		else if (useSAPControlYes)
		{
			Ext.getCmp('timeout').setDisabled(true);
			Ext.getCmp('timeout').hide();
			Ext.getCmp('sapuser').setDisabled(true);
			Ext.getCmp('sapuser').hide();
			Ext.getCmp('password').setDisabled(true);
			Ext.getCmp('password').hide();
			Ext.getCmp('passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('passwordconfirmpassword').hide();
			Ext.getCmp('sysno').setDisabled(true);
			Ext.getCmp('sysno').hide();
			Ext.getCmp('clientname').setDisabled(true);
			Ext.getCmp('clientname').hide();
			Ext.getCmp('router').setDisabled(true);
			Ext.getCmp('router').hide();
			Ext.getCmp('Jco_version').setDisabled(true);
			Ext.getCmp('Jco_version').hide();
			Ext.getCmp('instancename').setDisabled(true);
			Ext.getCmp('instancename').hide();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();
	
  		showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);

		}
	},
	changeSAPControlSelect: function(obj) 
	{
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		var useSAPControl = Ext.getCmp('use_sapcontrol').getValue();
		if (useSAPControl.toLowerCase() == 'no' || useSAPControl.toLowerCase() == 'false')
		{
			Ext.getCmp('ssl_radioGrp').setDisabled(true);
			Ext.getCmp('ssl_radioGrp').hide();
			Ext.getCmp('os_username').setDisabled(true);
			Ext.getCmp('os_username').hide();
			Ext.getCmp('os_password').setDisabled(true);
			Ext.getCmp('os_password').hide();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('os_passwordconfirmpassword').hide();
			Ext.getCmp('wsdl_port').setDisabled(true);
			Ext.getCmp('wsdl_port').hide();

			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}
		else if (useSAPControl.toLowerCase() == 'yes' || useSAPControl.toLowerCase() == 'true')
		{
			Ext.getCmp('timeout').setDisabled(true);
			Ext.getCmp('timeout').hide();
			Ext.getCmp('sapuser').setDisabled(true);
			Ext.getCmp('sapuser').hide();
			Ext.getCmp('password').setDisabled(true);
			Ext.getCmp('password').hide();
			Ext.getCmp('passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('passwordconfirmpassword').hide();
			Ext.getCmp('sysno').setDisabled(true);
			Ext.getCmp('sysno').hide();
			Ext.getCmp('clientname').setDisabled(true);
			Ext.getCmp('clientname').hide();
			Ext.getCmp('router').setDisabled(true);
			Ext.getCmp('router').hide();
			Ext.getCmp('Jco_version').setDisabled(true);
			Ext.getCmp('Jco_version').hide();
			Ext.getCmp('instancename').setDisabled(true);
			Ext.getCmp('instancename').hide();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();

			showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);
		}
		else 
		{
			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();
		}
	},
	continueParamMethod: function(testCase,name) {
		if (!Ext.isEmpty(testCase))
		{
			var testCaseArray = testCase.split(",");
			for (var key = 0;key < testCaseArray.length ;key++ )
			{
				if (name.toLowerCase() == testCaseArray[key].toLowerCase())
				{
					return true;
				}
			}
			return false;
		}
	},
	clearHiddenFields: function() {
		var formObj = this.getTestconfiguration().getForm();
		var fieldsArr = formObj.getFields().items;
		for (var i in fieldsArr)
		{
			if (fieldsArr[i].xtype == 'hiddenfield')
			{
				Ext.getCmp(fieldsArr[i].id).setValue("");
			}
			//console.log('xtype  : '+fieldsArr[i].xtype+'\n fieldsArr[i].id : '+fieldsArr[i].id);
		}
		var selectFilterObj = Ext.getCmp('selectedFilterType');
		if (!Ext.getCmp(selectFilterObj) && selectFilterObj != undefined)
		{
			Ext.getCmp('selectedFilterType').setValue("");
		}
	},
	populate: function(btn) {
		var formObj = Ext.getCmp('testConfigForm').getForm();
		var testName = publicJson['testName'];
		var multiUserMode = publicJson['multiUserMode'];
		var allowHostName = publicJson['allowHostName'];

		var allowToUpdate = populate(testName,'defaultConfiguration',multiUserMode,allowHostName,formObj);
		if (allowToUpdate)
		{
			var filterMSObj = Ext.getCmp('filter_combo');
			if (!Ext.isEmpty(filterMSObj))
			{
				var filterMSCount = Ext.getCmp('filter_combo').getStore().getCount();
				if (filterMSCount == 0)
				{
					Ext.getCmp('filter_combo').setDisabled(true);
				}
			}

			existingParams = formObj.getValues(true);
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var tmpURL = 'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJsonp.jsp?';

			var frmMain = this.getTestconfiguration().getForm();
			if (frmMain.isValid())
			{
				this.getTestconfiguration().submit({
					url: tmpURL,
					method: 'POST',
					params: me.encodeFieldParams(frmMain),
					//standardSubmit: true,
					success: function(form, action){
						var jsonText = Ext.decode(action.response.responseText);
						if(jsonText.successUpdate == 'true')
						{
							myMask.hide();
							Ext.Msg.show({
								title:pageName,
								msg: alertMsg78,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
									me.clearHiddenFields();
									me.afterMainRender();
								}
							});
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						var jsonText = Ext.decode(action.response.responseText);
						if(jsonText.successUpdate == 'true')
						{
							myMask.hide();
							me.afterMainRender();
							me.clearHiddenFields();
						}
						else
						{
							myMask.hide();
							me.afterMainRender();
							me.clearHiddenFields();
						}
					}
				});
			}
		}
	},
	gotoBuildContainer:  function() {
		//var hiddenContainer = Ext.getCmp("paramsContainer");
		var aResultant = new Array();
		var targetDiskIORateLabel = publicJson['targetDiskIORateLabel'];
		var targetDiskIORateValue = publicJson['targetDiskIORateValue'];
		var tmpResultant = publicJson['aResultant'];
		var testName = publicJson['testName'];
		var previousTestName = publicJson['previousTestName'];
		var isSnmp = publicJson['isSnmp'];
		var componentType = publicJson['componentType'];
		var configuredTestTitle = publicJson['configuredTestTitle'];
		var isModeParamExist = publicJson['isModeParamExist'];
		var isMeasureModeParamExist = publicJson['isMeasureModeParamExist'];
		var isCorrectParamExist = publicJson['isCorrectParamExist'];
		var isUrlParamExist = publicJson['isUrlParamExist'];
		var isWsdlUrlExist = publicJson['isWsdlUrlExist'];
		var isPolicyParamExists = publicJson['isPolicyParamExists'];
		var isCredentialParamExist = publicJson['isCredentialParamExist'];
		var isCorrectiveScriptEnabled = publicJson['isCorrectiveScriptEnabled'];
		var viewAccessOnly = publicJson['viewAccessOnly'];
		var hasMultipleUsers = false;
		var hasMultipleNames = false;
		var hasShowAliasParam = publicJson['hasShowAliasParam'];
		var hasShowAllOnlyParam = publicJson['hasShowAllOnlyParam'];
		var hasReportOnlyTotalParam = publicJson['hasReportOnlyTotalParam'];
		var testPeriodArr = publicJson['testPeriodArr'];
		var setReadOnlyMode = publicJson['setReadOnlyMode'];
		var testPeriodLabel = publicJson['testPeriodLabel'];
		var selectedTimePeriod = publicJson['selectedTimePeriod'];
		var multiUserMode = publicJson['multiUserMode'];
		var multiNamePatternMode = publicJson['multiNamePatternMode'];
		var strDelimiterMask = publicJson['hiddenObj']['delimiterMask'];
		var testInfoDelimiter = publicJson['testInfoDelimiter'];
		var isPortRelevantForTest = publicJson['isPortRelevantForTest'];
		var paramToContinue = publicJson['paramToContinue'];
		var snmpV1V2ParamToContinue = publicJson['snmpV1V2ParamToContinue'];
		var snmpV3ParamToContinue = publicJson['snmpV3ParamToContinue'];
		var multiUserReadOnlyParam = publicJson['multiUserReadOnlyParam'];
		var multiNameReadOnlyParam = publicJson['multiNameReadOnlyParam'];
		var modeTrueToContinue = publicJson['modeTrueToContinue'];
		var modeFalseToContinue = publicJson['modeFalseToContinue'];
		var targetDiskIORateLabel = publicJson['targetDiskIORateLabel'];
		var targetDiskIORateValue = publicJson['targetDiskIORateValue'];
		var isCompTypeOracleClusterService = publicJson['isCompTypeOracleClusterService'];
		var isExecutionTimeParam = publicJson['isExecutionTimeParam'];
		var isSystemPropertyParamTests = publicJson['isSystemPropertyParamTests'];
		var isLocalModeParamExist = publicJson['isLocalModeParamExist'];

		if (!Ext.isEmpty(tmpResultant))
		{
			if (!Ext.isEmpty(isExecutionTimeParam) && isExecutionTimeParam)
			{
				var selectedExec = publicJson['selectedExecTime'];
				if (selectedExec == 'hourly' && selectedTimePeriod != '3600')
				{
					selectedTimePeriod = "3600";
				}
				else if (selectedExec == 'daily' && selectedTimePeriod != '86400')
				{
					selectedTimePeriod = "86400";
				}
			}

			var paramsFieldSetContainer = Ext.getCmp('paramsContainer');
			paramsFieldSetContainer.removeAll();
			paramsFieldSetContainer.setTitle ( configuredTestTitle );
			var hiddenComponent = {
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id: 'testPeriod',
					name: 'testPeriod',
					fieldLabel: testPeriodLabel,
					queryMode: 'local',
					//multiSelect: true,
					displayField: 'displayField',
					valueField: 'valueField',
					value: selectedTimePeriod,
					editable: false,
					parent: this,
					store: new Ext.data.Store(
						{
							fields: ['displayField','valueField'],
							data: testPeriodArr
						}
					)
				}
			paramsFieldSetContainer.add(hiddenComponent);
			if (setReadOnlyMode)
			{
				Ext.getCmp('testPeriod').setReadOnly(true);
				Ext.getCmp('testPeriod').removeCls( 'dropdown' );
				Ext.getCmp('testPeriod').addCls( 'textbox' );
			}
			else
			{
				Ext.getCmp('testPeriod').setReadOnly(false);
				Ext.getCmp('testPeriod').addCls( 'dropdown' );
			}

			aResultant = tmpResultant.split('^&^');
			for (var i = 0;i < aResultant.length ;i = i+3 )
			{
				var paramName = aResultant[i];
				paramName = paramName.substring(1).trim();
				var strDelimiterMask = publicJson['hiddenObj']['delimiterMask'];
				var paramValue = aResultant[i+1];
				var displayControl = aResultant[i+2];
				displayControl = displayControl.trim();
				if (!displayControl == "password")
				{
					paramValue = paramValue.trim();

					if (paramValue.indexOf('"') == 0 && paramValue.lastIndexOf('"') == paramValue.length - 1)
					{
						paramValue = paramValue.substring(1,paramValue.length-1);
					}
				}
				/*if(componentType == "Virtual_center" && paramName.toLowerCase() == "hosted_vm_type")
				{
					continue;
				}*/
				
				if(componentType.toLowerCase() == "client_desktop" && (testName == "ClientServiceTest" || testName == "ClientTcpTest"))
				{
					if(paramName.toLowerCase() == "adapter_device_selection" || paramName.toLowerCase() =="device_name" || paramName.toLowerCase() == "device_id")
					{
						continue;
					}
				}
				
				if(testName == "DiskSpaceTest" || testName == "WVDDiskSpaceTest")
				{
					if( (paramName.toLowerCase() =="autmtd_actn_enbld_dskspc" || paramName.toLowerCase() =="autmtd_actn_enbld_wvd_dskspc") || (paramName.toLowerCase() =="automation_configuration_rules") || (paramName.toLowerCase() =="drive_name") || (paramName.toLowerCase() =="drive_utilization_percentage") ||   (paramName.toLowerCase() =="files_and_folders_to_be_cleaned") )
					{
						continue;
					}
				}

				var elementIdx = this.continueParamMethod(paramToContinue,paramName);
				if (elementIdx) continue;
				if (paramValue.toLowerCase() == "noteditable") continue;

				if (!isCompTypeOracleClusterService && paramName.toLowerCase() == "info")
				{
					continue;
				}

				if (paramName.toLowerCase() == 'monitoring_level')
				{
					continue;
				}

				var readOnlyParamIdx = this.continueParamMethod(multiUserReadOnlyParam,paramName);
				if(!readOnlyParamIdx)
				{
					readOnlyParamIdx = this.continueParamMethod(multiNameReadOnlyParam,paramName);
				}

				if (readOnlyParamIdx)
				{
					if (paramName.toLowerCase() == "domain" || 
						paramName.toLowerCase() == "user" || 
						paramName.toLowerCase() == "admin_user")
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleUsers = true;
						}
					}
					else if (paramName.toLowerCase() == "name" || 
						paramName.toLowerCase() == "pattern" || 
						paramName.toLowerCase() == "threshold_value")
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleNames = true;
						}
					}
				}

				var readOnly = "";
				var descriptorButton = "";
				var isButtonDescription = publicJson['isButtonDescription'];
				if (isButtonDescription)
				{
					descriptorButton = publicJson['descriptorButton'];
					readOnly = "readOnly";
				}

				if (paramName.toLowerCase() == "credentials")
				{
					continue;
				}

				if (paramName.toLowerCase() == "content")
				{
					continue;
				}

				if (paramName.toLowerCase() == "encoding")
				{
					continue;
				}

				if (paramName.toLowerCase() == "method")
				{
					continue;
				}
				
				if (paramName.toLowerCase() == "privatekey")
				{
					continue;
				}

				if (paramName.toLowerCase() == "systempropertykey" || paramName.toLowerCase() == "systempropertyvalue")
				{
					continue;
				}

				if ((testName == "WindowshareTest"  || testName == "UNCCheckTest" ) && (paramName.toLowerCase() == "domainname" || paramName.toLowerCase() == "shareusername" || paramName.toLowerCase() == "password"))
				{
					continue;
				}
			
				if (displayControl.toLowerCase() == "radio")
				{
					//Dependent Parameter - Having relationship with other parameters
					//For e.g., correct which has relations with alarmtype,userparams,correctivescript
					//Independent Parameter - Does not have relationship with other parameters
					//For e.g., isPassive
					//ProcessTest=wide(Yes:true#No:false) - Independent param
					//parameter value definition = (Yes:true#No:false)
					//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt 
					//need to define parameter value definition.
					//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
					//This will be handled in else block
					var isIndependentParam = publicJson['isIndependentParam'+paramName];

					if (isIndependentParam)
					{
						//block fires when the user put corresponding value to the isolated
						//radio parameter.
						var tempName1 = publicJson['independentParamName'+paramName+'1'];
						var tempValue1 = publicJson['independentParamValue'+paramName+'1'];
						var tempName2 = publicJson['independentParamName'+paramName+'2'];
						var tempValue2 = publicJson['independentParamValue'+paramName+'2'];
						
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var enabled = publicJson['enabled'+paramName];
						var disabled = publicJson['disabled'+paramName];

						if (paramName.toLowerCase() == "aggregate_user_sessions" &&
							viewAccessOnly && disabled)
						{
							var aggUserSessionRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled, disabled:true },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled, disabled:true}
								]
							};
							paramsFieldSetContainer.add(aggUserSessionRadioComponent);
						}
						else if (paramName.toLowerCase() == "is_trail")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isTrailRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isTrailRadioComponent);
						}
						else if (paramName.toLowerCase() == "use_sudo")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isUseSudoRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isUseSudoRadioComponent);
						}
						else if (paramName.toLowerCase() == "advanced_settings")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isAdvancedSettingsRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isAdvancedSettingsRadioComponent);
						}
						else if (paramName.toLowerCase() == "access_type")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isAccessType = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeAccessType(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isAccessType);
						}
						else
						{
							var indepRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								]
							};
							paramsFieldSetContainer.add(indepRadioComponent);
						}
					}
					else
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						if (paramName.toLowerCase() == "encryptflag" && isSnmp)
						{
							var enabled = publicJson['enabledEncryptFlag'];
							var disabled = publicJson['disabledEncryptFlag'];
							var encryptFlagComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								hidden: true,
								listeners: {
									change:
									{
										fn: function() {
											 me.changeEncFlagValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(encryptFlagComponent);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}

							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
									{
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
								{
									Ext.getCmp(paramName+'_radioGrp').show();
								}
							}
						}
						else if (paramName.toLowerCase() == "policyfilter" && isPolicyParamExists)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							if (!enabled)
							{
								isFirstFilterCombo = true;
							}
							var policyFilterComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(policyFilterComponent)
						}
						else if (paramName.toLowerCase() == "correct" && isCorrectParamExist)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							//var fieldContainerComponent = this.createRadioButton(paramName);

							var correctParamComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change: {
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(correctParamComponent);
						}
						else if(paramName.toLowerCase() == "mode" && isLocalModeParamExist)
						{
							var enabled = publicJson['modeEnabled'];
							var disabled = publicJson['modeDisabled'];

							var modeParamComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'LOCAL', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeModeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(modeParamComponent);
						}
						else if(paramName.toLowerCase() == "mode" && isModeParamExist)
						{
							var enabled = publicJson['modeEnabled'];
							var disabled = publicJson['modeDisabled'];

							var modeParamComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'SNMP', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(modeParamComponent);
						}
						else if(paramName.toLowerCase() == "metric_collection_type")
						{
							var enabled = publicJson['jmxOptionsShow'];
							var disabled = publicJson['jmxOptionsHide'];
							var displayNameTrue = publicJson['metric_collection_type#true'];
							var displayNameFalse = publicJson['metric_collection_type#false'];

							var jmxOptionsRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: displayNameTrue, name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: displayNameFalse, name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											me.changeJmxOptionValue(this)
										}
									},
									afterrender: function(){
										me.changeJmxOptionValue(this)
									}
								}
							};
							paramsFieldSetContainer.add(jmxOptionsRadioComponent)
						}
						else if(paramName.toLowerCase() == "heap_analysis" && isModeParamExist)
						{
							var enabled = publicJson['enabledHeapAnalysis'];
							var disabled = publicJson['disabledHeapAnalysis'];

							var heapAnalysisComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(heapAnalysisComponent);
						}
						else if(paramName.toLowerCase() == "usealias" && hasShowAliasParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							var useAliasComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								fieldLabel: tempParamName,
								id: paramName+'_radioGrp',
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(useAliasComponent);
						}
						else if (paramName.toLowerCase() == "showallevents" && hasShowAllOnlyParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var showAllComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								name: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(showAllComponent);
						}
						else if (paramName.toLowerCase() == "report_total" && hasReportOnlyTotalParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(reportTotalComponent);
						}
						else if (paramName.toLowerCase() == "use_sapcontrol")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var useSAPControlRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeSAPControl(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(useSAPControlRadioComponent);
						}
						else if (paramName.toLowerCase() == "report_with_destination")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportDestRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'yes',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'no', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeTotalDesc(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(reportDestRadioComponent);
						}
						else if (paramName.toLowerCase() == "is_privilege_mode_enabled")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var enableModeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'yes',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'no', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeEnableMode(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(enableModeRadioComponent);
						}
						else
						{
							//handling independent parameter for radio - starts
							//handled yes,no,true,false,y and n only
							//block fires when the user forgets to put corresponding value
							//to the isolated radio parameter.Parameter are handled to their
							//default values.
							
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							var value1 = publicJson['value1'+paramName];
							var value2 = publicJson['value2'+paramName];

							if (paramName.toLowerCase() =="report_by_user" && 
								viewAccessOnly && enabled)
							{
								var reportByUserRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									name: paramName+'_radioGrp',
									fieldLabel: tempParamName,
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1,checked: enabled, disabled:true },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled, disabled:true}
									]
								};
								paramsFieldSetContainer.add(reportByUserRadioComponent);
							}
							else if (paramName.toLowerCase() == "reportbyclientname" && 
								viewAccessOnly && disabled)
							{
								var reportByClientRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									vertical: false,
									fieldLabel: tempParamName,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1,checked: enabled, disabled:true },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled, disabled:true}
									]
								};
								paramsFieldSetContainer.add(reportByClientRadioComponent);
							}
							else if(paramName.toLowerCase() == "measure_mode" && isMeasureModeParamExist && testName.toLowerCase() == "jvmmempoolgctest" || testName.toLowerCase() == "jvmgctest")
							{
								var enabled = publicJson['enabled'+paramName];
								var disabled = publicJson['disabled'+paramName];

								var measureModeRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									fieldLabel: tempParamName,
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Log File', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
										{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
									],
									listeners: {
										change:
										{
											fn: function() {
												 me.changeValue(this)
											}
										},
										afterrender: function(){
											me.changeValue(this)
										}
									}
								};
								paramsFieldSetContainer.add(measureModeRadioComponent);
							}
							else
							{
								var lastRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									name: paramName+'_radioGrp',
									vertical: false,
									fieldLabel: tempParamName,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1, checked: enabled },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled }
									]
								};
								paramsFieldSetContainer.add(lastRadioComponent);
							}
							if (hasShowAliasParam) 	//Report_only_total
							{
								if (paramName == 'show_alias_and_interface_name')
								{
									var isShowAllEventsYes = Ext.getCmp('useAlias1').getValue();
									var isShowAllEventsNo = Ext.getCmp('useAlias2').getValue();
									if (isShowAllEventsYes)
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else if (isShowAllEventsNo)
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
								
							}
							if (hasReportOnlyTotalParam)	//Report_only_total
							{
								var isShowAllEventsYes = Ext.getCmp('Report_total1').getValue();
								var isShowAllEventsNo = Ext.getCmp('Report_total2').getValue();
								if (isShowAllEventsYes)
								{
									if (paramName == 'Report_only_total')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
								else if (isShowAllEventsNo)
								{
									if (paramName == 'Report_only_total')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
							}
							if (hasShowAllOnlyParam)
							{
								var showAllEvtObject = Ext.getCmp('showAllEvents_radioGrp');

								if (!Ext.isEmpty(showAllEvtObject) && showAllEvtObject != undefined)
								{
									var isShowAllEventsYes = Ext.getCmp('showAllEvents1').getValue();
									var isShowAllEventsNo = Ext.getCmp('showAllEvents2').getValue();
									if (isShowAllEventsYes)
									{
										if (paramName == 'showAllOnly')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
									else if (isShowAllEventsNo)
									{
										if (paramName == 'showAllOnly')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
									}
								}
							}
							if (paramName == 'ssl')
							{
								if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf')
								{
									var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
									var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
									if (!Ext.isEmpty(useSAPControlObj))
									{
										var useSAPControlNo = useSAPControlObj.getValue();
										if (useSAPControlNo)
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
										else 
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
									if (!Ext.isEmpty(useSAPControlObjAuto))
									{
										var useSAPControlNo = useSAPControlObjAuto.getValue();
										if (useSAPControlNo=='false')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
										else 
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
								}
							}
							//handling independent parameter for radio - ends
						}
					}
				}
				else if (displayControl.toLowerCase() == "select")
				{
					//Dependent Parameter - Having relationship with other parameters
					//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
					//Independent Parameter - Does not have relationship with other parameters
					//For e.g., alarmtype
					var isIndependentParam = publicJson['isIndependentParam'+paramName];
					if (isIndependentParam)
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var independentParamArr = publicJson['independentParamArr'+paramName];
						var selectedIndParamValue = publicJson['selectedIndParamValue'+paramName];
						if (Ext.isEmpty(selectedIndParamValue) || selectedIndParamValue == undefined)
						{
							selectedIndParamValue = independentParamArr[0].valueField;
						}
					
						//if (paramName == 'Monitoring_Level')
						//{
							//var monLevelComponent = {
								//xtype: 'scrollcombo',
								//cls: 'dropdown',
								//id: paramName,
								//name: paramName,
								//fieldLabel: tempParamName,
								//value: selectedIndParamValue,
								//queryMode: 'local',
								//displayField: 'displayField',
								//valueField: 'valueField',
								//editable: false,
								//parent:this,
								//store:new Ext.data.Store({
									//fields: ['displayField','valueField'],
									//data: independentParamArr
								//}),
								//listeners: {
									//select:
									//{
										//fn: function() {
											 //me.changeMonitorLevel(this)
										//}
									//}
								//}
							//};
							//paramsFieldSetContainer.add(monLevelComponent);
						//}else
						if(paramName.toLowerCase() == "pagetypestobeincludedindashboard" )
						{
							var fieldlabelParamValue = publicJson['fieldLabel'+paramName];
							var pageTypesCombo = {
								xtype: 'multiselectSi',
								cls: 'multiselect',
								fieldLabel: fieldlabelParamValue,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								height: 90,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								value: selectedIndParamValue,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								})
							};
							paramsFieldSetContainer.add(pageTypesCombo);

						}
						else if (paramName.toLowerCase() == "use_sapcontrol")
						{
							var useSAPControlComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedIndParamValue,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.changeSAPControlSelect(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(useSAPControlComponent);
						}
						else
						{
							var independentComboComponent = this.createComboBox(paramName);
							paramsFieldSetContainer.add(independentComboComponent);
							
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(independentParamArr) && independentParamArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(independentParamArr);
								Ext.getCmp(paramName).setValue(selectedIndParamValue);
							}
						}
						if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf')
						{
							var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
							var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
							
							if (!Ext.isEmpty(useSAPControlObj))
							{
								var useSAPControlNo = useSAPControlObj.getValue();
								if (useSAPControlNo || paramName=='use_sapcontrol')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
								else 
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
							}
							if (!Ext.isEmpty(useSAPControlObjAuto))
							{
								var useSAPControlNo = useSAPControlObjAuto.getValue();
								if (useSAPControlNo=='false')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
								else if(useSAPControlNo=='true' && paramName.toLowerCase()!='use_sapcontrol')
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
								else
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							
						}
						if (paramName.toLowerCase() == 'alarmtype')
						{
							Ext.getCmp(paramName).setDisabled(true);
							Ext.getCmp(paramName).hide();

							if (isCorrectParamExist)
							{
								var isCorrectYes = Ext.getCmp('correct1').getValue();
								var isCorrectNo = Ext.getCmp('correct2').getValue();
								if (isCorrectNo)
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
								else if (isCorrectYes)
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
						}
						if(isAPMTest && paramName.toLowerCase() == "monitoring_mode")
						{
							Ext.getCmp(paramName).setDisabled(true);
							Ext.getCmp(paramName).hide();
						}
					}
					else
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						if (paramName.toLowerCase() == "snmpversion" && isSnmp)
						{
							var snmpVersionArr = publicJson['snmpVersionArr'];
							var selectedSnmpVersion = publicJson['selectedSnmpVersion'];
							//var fieldContainerComponent = this.createComboBox(paramName);
							if (Ext.isEmpty(selectedSnmpVersion) || selectedSnmpVersion == '$unconfigured' )
							{
								selectedSnmpVersion = 'v1';
							}
							if (isModeParamExist)
							{
								var snmpVersionComboComponent = {
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: selectedSnmpVersion,
									queryMode: 'local',
									displayField: 'displayField',
									valueField: 'valueField',
									editable: false,
									parent:this,
									hidden: true,
									disabled: true,
									store:new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: snmpVersionArr
									}),
									listeners: {
										select:
										{
											fn: function() {
												 me.changeValue(this)
											}
										}
									}
								};
								paramsFieldSetContainer.add(snmpVersionComboComponent);
								var modeSnmp = Ext.getCmp('mode1').getValue();
								var snmpVerObject = '';
								if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpversion');
								}
								else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpVersion');
								}
								if (modeSnmp)
								{
									snmpVerObject.setDisabled(false);
									snmpVerObject.show();
								}
								
								if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
								{
									snmpDefaultVal = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpDefaultVal) && snmpDefaultVal != undefined && (snmpDefaultVal == 'v1' || snmpDefaultVal == 'v2'))
									{
										if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined &&  Ext.getCmp('snmpcommunity').isHidden())
										{
											Ext.getCmp('snmpcommunity').setDisabled(false);
											Ext.getCmp('snmpcommunity').show();
										}
										else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined && Ext.getCmp('snmpCommunity').isHidden() )
										{
											Ext.getCmp('snmpCommunity').setDisabled(false);
											Ext.getCmp('snmpCommunity').show();
										}
									}
									
								}
							}
							else
							{
								var snmpVersionComboComponent = {
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: selectedSnmpVersion,
									queryMode: 'local',
									displayField: 'displayField',
									valueField: 'valueField',
									editable: false,
									parent:this,
									store:new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: snmpVersionArr
									}),
									listeners: {
										select:
										{
											fn: function() {
												 me.changeValue(this)
											}
										}
									}
								};
								paramsFieldSetContainer.add(snmpVersionComboComponent);
								var snmpVerObject = '';
								if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpversion');
								}
								else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpVersion');
								}

								if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
								{
									snmpDefaultVal = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpDefaultVal) && snmpDefaultVal != undefined && (snmpDefaultVal == 'v1' || snmpDefaultVal == 'v2'))
									{
										if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined &&  Ext.getCmp('snmpcommunity').isHidden())
										{
											Ext.getCmp('snmpcommunity').setDisabled(false);
											Ext.getCmp('snmpcommunity').show();
										}
										else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined && Ext.getCmp('snmpCommunity').isHidden() )
										{
											Ext.getCmp('snmpCommunity').setDisabled(false);
											Ext.getCmp('snmpCommunity').show();
										}
									}
									
								}
							}
						}
						else if (paramName.toLowerCase() == "authtype" && isSnmp)
						{
							var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
							var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];
							var authTypeComponent = this.createComboBox(paramName);

							paramsFieldSetContainer.add(authTypeComponent);
							Ext.getCmp(paramName).setFieldLabel(paramName.toUpperCase());
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(snmpAuthTypeArr) && snmpAuthTypeArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(snmpAuthTypeArr);
								Ext.getCmp(paramName).setValue(selectedSnmpAuthType);
							}
							Ext.getCmp(paramName).hide();
							Ext.getCmp(paramName).setDisabled(true);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}
							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
									{
										Ext.getCmp('authtype').show();
										Ext.getCmp(paramName).setDisabled(false);
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
								{
									Ext.getCmp('authtype').show();
									Ext.getCmp(paramName).setDisabled(false);
								}
							}
						}
						else if (paramName.toLowerCase() == "encrypttype" && isSnmp)
						{
							var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
							var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
							var encryptTypeComponent = this.createComboBox(paramName);
							paramsFieldSetContainer.add(encryptTypeComponent);
							Ext.getCmp(paramName).setFieldLabel(paramName.toUpperCase());
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(snmpEncTypeArr) && snmpEncTypeArr.length > 0)
							{
								Ext.getCmp('encrypttype').getStore().loadRawData(snmpEncTypeArr);
								Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
							}
							Ext.getCmp(paramName).hide();
							Ext.getCmp(paramName).setDisabled(true);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}

							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									var encFlagYes = Ext.getCmp('encryptflag1').getValue();

									if (!Ext.isEmpty(snmpVer)  && snmpVer != undefined && snmpVer == 'v3' && encFlagYes )
									{
										Ext.getCmp('encrypttype').show();
										Ext.getCmp(paramName).setDisabled(false);
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								var encFlagYes = Ext.getCmp('encryptflag1').getValue();
								if (!Ext.isEmpty(snmpVer)  && snmpVer != undefined && snmpVer == 'v3' && encFlagYes )
								{
									Ext.getCmp('encrypttype').show();
									Ext.getCmp(paramName).setDisabled(false);
								}
							}
						}
						else if(paramName.toLowerCase() == "filter" && isPolicyParamExists)
						{
							var policyFilterValue = publicJson['policyFilterValue'];
							var isPolicyFilterValue = publicJson['isPolicyFilterValue'];
							//var btnLabel = publicJson['btnLabel'];
							var filterArr = publicJson['filterArr'];
							var selectedPolicyFilter = publicJson['selectedPolicyFilter'];
							
							var xtypeValue = 'multiselectSi';
							var clsName = 'multiselect';
							var heightValue = 90;
							if (testName == 'GrpAppHealthTest')
							{
								xtypeValue = 'scrollcombo';
								clsName = 'dropdown';	
								heightValue	= 0;							
							}
							
							var filterCombo = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								id: 'filterComboContainer',
								name: 'filterComboContainer',
								labelSeparator: ' ',
								hidden: true,
								layout: 'column',
								items: [
									{
										xtype: xtypeValue,
										cls: clsName,
										id: paramName+'_combo',
										name: paramName+'_combo',
										height: heightValue,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										editable: false,
										parent:this,
										columnWidth: 0.93,
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype : 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										style : {
											background : 'none',
											border : '0px'
										},
										tooltip: label21,
										listeners: {
											click: function()
											{
												var currentLogType = Ext.getCmp('logType').getValue();
												if (!Ext.isEmpty(currentLogType))
												{
													if (currentLogType.toLowerCase() == '$unconfigured' || 
													currentLogType.toLowerCase() == '$logType')
													{
														Ext.Msg.show({
															title: pageName,
															msg: "Please enter a valid logtype",
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function(response) {
																Ext.getCmp('logType').focus(true);
															}
														});
														return;
													}

													if (!checkAlphabet(currentLogType.replace(/ /g,'')))
													{
														Ext.Msg.show({
															title: pageName,
															msg: _checkspecial,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function() {
																Ext.getCmp('logType').focus(true);
															}
														});
														return;
													}
												}

												testViews.configViewMainPolicy();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(filterCombo);

							var tempParanFilterNme = paramName;
							var filterTextArea = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								id : paramName+'_fieldContainer',
								labelSeparator: ' ',
								hidden: true,
								layout: 'column',
								items: [
									{
										xtype: 'textarea',
										cls: 'text-area',
										//resizable: true,
										//target: 'textarea',
										//grow: true,
										id: paramName,
										name: paramName,
										value: policyFilterValue,
										rows: 5,
										columnWidth: 1
									}
								]
							};
							paramsFieldSetContainer.add(filterTextArea);

							if (!Ext.isEmpty(isPolicyFilterValue))
							{
								if (isPolicyFilterValue == 'combo')
								{
									var temp = {
										xtype: 'hiddenfield',
										name: 'selectedFilterType',
										id: 'selectedFilterType',
										value: isPolicyFilterValue,
									};
									Ext.getCmp('testConfigForm').add(temp);

									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName+'_fieldContainer').hide();

									Ext.getCmp(paramName+'_combo').getStore().removeAll();
									Ext.getCmp(paramName+'_combo').getStore().loadRawData(filterArr);
									Ext.getCmp(paramName+'_combo').setValue(selectedPolicyFilter);
									Ext.getCmp('filterComboContainer').show();
								}
								else if (isPolicyFilterValue == 'fieldContainer')
								{
									var temp = {
										xtype: 'hiddenfield',
										name: 'selectedFilterType',
										id: 'selectedFilterType',
										value: isPolicyFilterValue,
									};
									Ext.getCmp('testConfigForm').add(temp);

									Ext.getCmp(paramName+'_combo').setDisabled(true);
									Ext.getCmp('filterComboContainer').hide();

									Ext.getCmp(paramName+'_fieldContainer').show();
								}
							}
						}
						else if (paramName.toLowerCase() == "virtual_center")
						{
							var virtualCenterArr = publicJson['virtualCenterArr'];
							var selectedVirtualCenter = publicJson['selectedVirtualCenter'];
							var virtualComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedVirtualCenter,
								editable: false,
								forceSelection: false,
								parent:this,
								columnWidth: 1,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: virtualCenterArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Esx_user,Esx_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Esx_user,Esx_password'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Esx_user,Esx_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egvcconfig(this.id);
										}
										else
										{
											testViews.egvcconfig(this.id);
										}
									}
								}
							};
							paramsFieldSetContainer.add(virtualComboComponent);
						}
						else if (paramName.toLowerCase() == "xms_ip")
						{
							var xmsIPArr = publicJson['xmsIPArr'];
							var selectedXMSIP = publicJson['selectedXMSIP'];
							var xmsIPComboComponent =  {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedXMSIP,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: xmsIPArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}
										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egxmsconfig(this.id);
										}
										else
										{
											testViews.egxmsconfig(this.id);
										}
									}
								}

							};
							paramsFieldSetContainer.add(xmsIPComboComponent);
						}
						else if (paramName.toLowerCase() == "prism_ip")
						{
							var prismArr = publicJson['prismArr'];
							var selectedPrism = publicJson['selectedPrism'];
							var prismComboComponent =  {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedPrism,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: prismArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Prism_user,Prism_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Prism_user,Prism_password'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Prism_user,Prism_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egnutconfig(this.id);
										}
										else
										{
											testViews.egnutconfig(this.id);
										}
									}
								}

							};
							paramsFieldSetContainer.add(prismComboComponent);
						}
						/////////////////////// RHEV Code Starts
						else if (paramName.toLowerCase() == "rhel_mgr_host")
						{
							var rhelMgrHostArr = publicJson['rhelMgrHostArr'];
							var selectedRhelMgrHost = publicJson['selectedRhelMgrHost'];
							var rhevComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								fieldLabel: tempParamName,
								columnWidth: 1,
								value: selectedRhelMgrHost,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: rhelMgrHostArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egrhevconfig(this.id);
										}
										else
										{
											testViews.egrhevconfig(this.id);
										}
									}
								}
							};
							paramsFieldSetContainer.add(rhevComboComponent);
						}
						//////////////// RHEV code ends
						else if (paramName.toLowerCase() == "management_server")
						{
							var showTextBox = publicJson['showTextBox'+paramName];
							
							var mgmtTextValue = publicJson['mgmtTextValue'];
							if (Ext.isEmpty(mgmtTextValue) || mgmtTextValue == undefined)
							{
								mgmtTextValue = '$unconfigured';
							}
							var mgmtTextBoxComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName+'_text',
								name: paramName+'_text',
								fieldLabel: tempParamName,
								value: mgmtTextValue,
								hidden: true,
								disabled: true
							};
							paramsFieldSetContainer.add(mgmtTextBoxComponent);
							
							var mgmtServerArr = publicJson['mgmtServerArr'];
							var selectedHMC = publicJson['selectedHMC'];
							if (Ext.isEmpty(selectedHMC) || selectedHMC == undefined)
							{
								selectedHMC = mgmtServerArr[0].valueField;
							}

							var mgmtComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedHMC,
								editable: false,
								forceSelection: false,
								fieldLabel: tempParamName,
								columnWidth: 1,
								parent:this,
								hidden: true,
								disabled: true,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: mgmtServerArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'management_user,management_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'management_user,management_password'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'management_user,management_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.eghmcconfig(this.id);
										}
										else
										{
											testViews.eghmcconfig(this.id);
										}
									}
								}
							};

							paramsFieldSetContainer.add(mgmtComboComponent);

							var isManagedByObj = Ext.getCmp('is_managed_by');
							var isManagedByVal = '';
							if (!Ext.isEmpty(isManagedByObj) && isManagedByObj != undefined)
							{
								isManagedByVal = isManagedByObj.getValue();
								if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'HMC')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();

									var mgmtServer = 'none';
									mgmtServer = publicJson['selectedHMC'];
									if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
									{
										mgmtServer = 'none';
									}
									Ext.getCmp('management_server').setValue(mgmtServer);
								}
								else if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'IVM')
								{
									Ext.getCmp(paramName+'_text').setDisabled(false);
									Ext.getCmp(paramName+'_text').show();

									var mgmtServer = '$unconfigured';
									mgmtServer = publicJson['mgmtTextValue'];
									if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
									{
										mgmtServer = '$unconfigured';
									}
									Ext.getCmp('management_server_text').setValue(mgmtServer);
								}
							}
						}
						else if (paramName.toLowerCase() == "executiontime")
						{
							var execTimeArr = publicJson['execTimeArr'];
							var selectedExecTime = publicJson['selectedExecTime'];
							var isTimeComboHide = publicJson['isTimeComboHide'];

							if (true) //dailySelected.toLowerCase() == "selected")
							{
								var execTimeHrsArr = publicJson['execTimeHrsArr'];
								var execTimeMinsArr = publicJson['execTimeMinsArr'];
								var selectedHrs = publicJson['selectedHrs'];
								var selectedMins = publicJson['selectedMins'];

								var executionTimeComboComponent = {
									xtype: 'fieldcontainer',
									fieldLabel: tempParamName,
									//id : paramName,
									labelSeparator: ' ',
									layout: 'column',
									items: [
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: paramName,
											name: paramName,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											value: selectedExecTime,
											editable: false,
											parent:this,
											columnWidth: 0.3,
											//margin: '0 5 0 0',
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeArr
												}
											),
											listeners: {
												select: function(){
													testViews.exectimeChangeEvt(this);
												}
											}
										},
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: 'hours',
											name: 'hours',
											value: selectedHrs,
											fieldLabel: 'Hrs',
											labelWidth: 25,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											editable: false,
											parent:this,
											columnWidth: 0.35,
											margin: '0 0 0 10',
											hidden: isTimeComboHide,
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeHrsArr
												}
											)
										},
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: 'minutes',
											name: 'minutes',
											fieldLabel: 'Mins',
											labelWidth: 30,
											value: selectedMins,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											editable: false,
											columnWidth: 0.35,
											margin: '0 0 0 5',
											parent:this,
											hidden: isTimeComboHide,
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeMinsArr
												}
											)
										}
									]
								};
								paramsFieldSetContainer.add(executionTimeComboComponent);
							}

							if (!Ext.isEmpty(isTimeComboHide) && isTimeComboHide)
							{
								Ext.getCmp('hours').setDisabled(true);
								Ext.getCmp('hours').hide();
								Ext.getCmp('minutes').setDisabled(true);
								Ext.getCmp('minutes').hide();
							}
							else if (!Ext.isEmpty(isTimeComboHide) && !isTimeComboHide)
							{
								Ext.getCmp('hours').setDisabled(false);
								Ext.getCmp('hours').show();
								Ext.getCmp('minutes').setDisabled(false);
								Ext.getCmp('minutes').show();
							}

							//else
							//{
								//var executionTimeComponent = {
									//xtype: 'scrollcombo',
									//cls: 'dropdown',
									//id: paramName,
									//name: paramName,
									//queryMode: 'local',
									//displayField: 'displayField',
									//valueField: 'valueField',
									//value: selectedExecTime,
									//editable: false,
									//parent:this,
									//columnWidth:1,
									//store:new Ext.data.Store(
										//{
											//fields: ['displayField','valueField'],
											//data: execTimeArr
										//}
									//)
								//};
								//paramsFieldSetContainer.add(executionTimeComponent);
							//}
						}
						else if (paramName.toLowerCase() == "inside_view_using")
						{
							var insideViewUsingArr = publicJson['insideViewUsingArr'];
							var selectedInsideViewUsing = publicJson['selectedInsideViewUsing'];
							var insideViewComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedInsideViewUsing,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								columnWidth: 1,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: insideViewUsingArr
									}
								),
								listeners: {
									select: {
										fn: function() {
											
											if (!isPasswordProfileEnabled(publicJson.pwdParamSetList,"domain,admin_user,admin_password"))
											{
												me.InsideViewChange(this.value);
											}
											else
											{
												var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,"domain,admin_user,admin_password");
												if (!Ext.isEmpty(disabledPwdParam))
												{
													Ext.getCmp(disabledPwdParam.trim()).setValue('none');
													me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
												}
												me.InsideViewChange(this.value);
											}
										}
									}
								}
							};
							paramsFieldSetContainer.add(insideViewComboComponent);
						}
						else if (paramName.toLowerCase() == "is_managed_by")
						{
							var managedByArr = publicJson['managedByArr'];
							var selectedIsManagedBy = publicJson['selectedIsManagedBy'];
							var isManagedComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedIsManagedBy,
								editable: false,
								forceSelection: false,
								fieldLabel: tempParamName,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: managedByArr
									}
								),
								listeners: {
									select:
									{
										fn: function() {
											 me.isManagedByChange(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isManagedComboComponent);
						}
						else if (paramName.toLowerCase().startsWith("password_profile") && publicJson.isEnablePwdProfile)
						{
							var pwdProfileArr = publicJson['pwdProfileArr'];
							var selectedProfile = publicJson['selectedProfile'+paramName];

							var pwdProfileComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: 'PASSWORD PROFILE',
								value: selectedProfile,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: pwdProfileArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.applyPwdProfile(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(pwdProfileComponent);

							// Password profile params need to be hide for Special cases(VC,Nutanix) starts

							var pwdParamList = publicJson.pwdParamSetList;
							var passwordProKey = '';
							var profileObj = "";
							var profileSelect = false;

							if(!Ext.isEmpty(pwdParamList))
							{
								for (var key in pwdParamList)
								{
									var profileVal = pwdParamList[key]; 
									if (Ext.isEmpty(profileVal))
									{
										continue;
									}
									if(profileVal == 'Esx_user,Esx_password')
									{
										profileObj = Ext.getCmp('virtual_center');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'management_user,management_password')
									{
										profileObj = Ext.getCmp('management_server');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain')
									{
										profileObj = Ext.getCmp('Rhel_mgr_host');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'Prism_user,Prism_password')
									{
										profileObj = Ext.getCmp('Prism_IP');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'XtremIO_user,XtremIO_password')
									{
										profileObj = Ext.getCmp('xms_ip');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
								}
							}

							if(profileSelect)
							{
								if(!Ext.isEmpty(profileObj) && (profileObj.getValue().toLowerCase() != 'none'))
								{
									Ext.getCmp(passwordProKey).hide();
								}
								else
								{
									Ext.getCmp(passwordProKey).show();
								}
							}

							// Password profile params need to be hide for Special cases(VC,Nutanix) ends

							if (!Ext.isEmpty(publicJson.pwdProfileProperties))
							{
								var pwdProfileProperties = publicJson.pwdProfileProperties;
								var strShowPwdProfile = paramName+'_isShow';
								var isShowPwdProfile = pwdProfileProperties[strShowPwdProfile];

								if (!Ext.isEmpty(isShowPwdProfile))
								{
									if (!isShowPwdProfile)
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									}
									else
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
									}
								}
							}

							if (!Ext.isEmpty(publicJson.isMultiUserParamExists) && publicJson.isMultiUserParamExists)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
							}

						}
						else
						{
							var lastComboArr = publicJson['lastComboArr'];
							var selectedLastCombo = publicJson['selectedLastCombo'];
							var lastComboComponent = this.createComboBox(paramName);

							paramsFieldSetContainer.add(lastComboComponent);
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(lastComboArr) && lastComboArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(lastComboArr);
								Ext.getCmp(paramName).setValue(selectedLastCombo);
							}
						}
					}
				}
				else if (displayControl.toLowerCase() == "password")
				{
					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					var isEditable = publicJson['isEditable'+paramName];
					paramValue = publicJson['password'+paramName];
					if (multiUserMode)
					{
						var passwordComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							columnWidth: 1,
							readOnly: isEditable,
							backupValue: paramValue,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(passwordComponent);

						if ((testName == 'CtxXcXALogonSimTest' || 
							testName == 'HrznLogonSimTest' || 
							testName == 'AWSLogonSimTest' || 
							testName == 'HrznWLogonSimTest') && 
							(paramName == 'Two_factor_auth_password' || 
							paramName == 'Registration_code'))
						{
							isEditable = true;
						}

						if (!isEditable)
						{
							var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
							if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
							{
								tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
							}
							var confirmPwdComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName+"confirmpassword",
								name: paramName+"confirmpassword",
								fieldLabel: tmpConfirmParamName,
								inputType: 'password',
								//value: paramValue,
								columnWidth: 1,
								backupValue: paramValue,
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function() {
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							};
							paramsFieldSetContainer.add(confirmPwdComponent);
						}
						
						if ((testName == 'CtxXcXALogonSimTest' || 
							testName == 'HrznLogonSimTest' || 
							testName == 'AWSLogonSimTest' ||
							testName == 'AwsAppStrmSimTest' ||
							testName == 'HrznWLogonSimTest') && 
							(paramName == 'Password' || 
							paramName == 'Registration_code' ||
							paramName == 'Two_factor_auth_password'))
						{
							Ext.getCmp(paramName).hide();
							if (!isEditable)
							{
								Ext.getCmp(paramName+"confirmpassword").hide();
							}
						}
					}
					else if (paramName == 'Email_password')
					{
						var EMailPwdTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							readOnly: isEditable,
							hidden: true,
							backupValue: paramValue,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(EMailPwdTextComponent);
					}
					else if (paramName == 'enable_password')
					{
						var enablePwdComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							readOnly: isEditable,
							hidden: true,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function(){
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(enablePwdComponent);


						var enableModeObj = Ext.getCmp('is_privilege_mode_enabled1');

						if (!Ext.isEmpty(enableModeObj))
						{
							var useSAPControlYes = enableModeObj.getValue();
							//console.log('useSAPControlYes ',useSAPControlYes);
							if (useSAPControlYes)
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
							}
							else 
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
							}
						}
					}
					else
					{
						if ((isSnmp || isModeParamExist ) && (paramName.toLowerCase() == 'jmx_password' || paramName == 'encryptpassword' || paramName == 'authpass' || paramName == 'password'))
						{
							var passwordComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								inputType: 'password',
								//value: paramValue,
								hidden: true,
								columnWidth: 1,
								disabled: true,
								backupValue: paramValue,
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function() {
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							};
							paramsFieldSetContainer.add(passwordComponent);

							if (!isEditable)
							{
								var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
								if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
								{
									tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
								}
								var confirmPwdComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName+"confirmpassword",
									name: paramName+"confirmpassword",
									fieldLabel: tmpConfirmParamName,
									inputType: 'password',
									//value: paramValue,
									columnWidth: 1,
									hidden: true,
									disabled: true,
									backupValue: paramValue,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								};
								paramsFieldSetContainer.add(confirmPwdComponent);
							}
						}
						else
						{
							if (!isEditable)
							{
								var passwordComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									inputType: 'password',
									//value: paramValue,
									columnWidth: 1,
									backupValue: paramValue,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								};
								paramsFieldSetContainer.add(passwordComponent);
								var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
								if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
								{
									tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
								}
								var confirmPwdComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName+'confirmpassword',
									name: paramName+'confirmpassword',
									fieldLabel: tmpConfirmParamName,
									inputType: 'password',
									//value: paramValue,
									backupValue: paramValue,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
									//columnWidth: 1,
								};
								paramsFieldSetContainer.add(confirmPwdComponent);
							}
							else
							{
								var lastPwdComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									inputType: 'password',
									//value: paramValue,
									columnWidth: 1,
									backupValue: paramValue,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								};
								paramsFieldSetContainer.add(lastPwdComponent);
							}
						}

						if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_access_key' || paramName == 'AWS_secret_key'))
						{
							var isAccessTypeObj = Ext.getCmp('Access_Type1');
							var isAccessTypeRoleChkd = isAccessTypeObj.getValue();
							if (isAccessTypeRoleChkd)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
								Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
								Ext.getCmp(paramName+'confirmpassword').hide();
							}
							else 
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
								Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
								Ext.getCmp(paramName+'confirmpassword').show();
							}
						}

						if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf')
						{
							var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
							var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
							if (!Ext.isEmpty(useSAPControlObj))
							{
								var useSAPControlNo = useSAPControlObj.getValue();
								if (useSAPControlNo)
								{
									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
									
								}
								else 
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}

									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
							}
							if (!Ext.isEmpty(useSAPControlObjAuto))
							{
								var useSAPControlNo = useSAPControlObjAuto.getValue();
								if (useSAPControlNo.toLowerCase()=='false')
								{
									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
								else if (useSAPControlNo.toLowerCase()=='true')
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}

									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
								else 
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
									Ext.getCmp(paramName+'confirmpassword').show();
								}
							}
						}

						var snmpVerObject = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
						}

						if (isModeParamExist)
						{
							var modeSNMP = Ext.getCmp('mode1').getValue();
							var modeJMX = Ext.getCmp('mode2').getValue();
							if (modeSNMP)
							{
								if ( isSnmp && !Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined) 
								{
									var snmpVer = snmpVerObject.getValue();
									if (snmpVer == 'v3' )
									{
										if (paramName == 'encryptpassword')
										{
											var encFlagYes = Ext.getCmp('encryptflag1').getValue();
											if (!Ext.isEmpty(encFlagYes) && encFlagYes != undefined && encFlagYes)
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);

												Ext.getCmp(paramName+"confirmpassword").show();
												Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
											}
										}
										else if (paramName == 'authpass')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);

											Ext.getCmp(paramName+"confirmpassword").show();
											Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
										}
									}
								}
							}
							else if (modeJMX)
							{
								if (paramName == 'Jmx_password' || paramName == 'password')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
									Ext.getCmp(paramName+'confirmpassword').show();
								}
							}
						}
						else if( isSnmp && !Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
						{
							var snmpVer = snmpVerObject.getValue();
							if (snmpVer == 'v3' )
							{
								if (paramName == 'encryptpassword')
								{
									var encFlagYes = Ext.getCmp('encryptflag1').getValue();
									if (!Ext.isEmpty(encFlagYes) && encFlagYes != undefined && encFlagYes)
									{
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName).setDisabled(false);

										Ext.getCmp(paramName+"confirmpassword").show();
										Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
									}
								}
								else
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);

									Ext.getCmp(paramName+"confirmpassword").show();
									Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
								}
							}
							if (paramName == 'Jmx_password' || paramName == 'password')
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
								Ext.getCmp(paramName+"confirmpassword").show();
								Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							}
						}
					}
				}
				else if (displayControl.toLowerCase() == "textarea")
				{
					var strVal = "";
					if (testName == previousTestName)
					{
						strVal = Ext.getCmp(paramName).getValue();
					}

					if (!Ext.isEmpty(strVal))
					{
						paramValue = strVal;
					}

					if (paramValue.indexOf('|') > -1)
					{
						paramValue = publicJson['pipeParamValue'];
					}

					var textAreaParamVal = publicJson['textArea'+paramName];
					if (!Ext.isEmpty(textAreaParamVal) && textAreaParamVal != undefined)
					{
						paramValue = textAreaParamVal;
					}

					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					
					if((paramName.toLowerCase() == "servicename" || paramName.toLowerCase() == "process") && paramValue.trim() == "(EG_RUNTIME)" )
					{
						var tempParaNme = paramName;
						var textAreaComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: paramValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 5 0 0'
								},
								{
									xtype: 'button',
									name: 'os_pattern',
									id: 'os_pattern',
									columnWidth: 0.07,
									tooltip: label18,
									iconCls : 'iconConfigure',
									//iconCls : 'iconConfig',
									//iconCls : 'iconSettings',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners : {
										click : function()
										{
											testViews.configRunTimePattern(tempParaNme);
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(textAreaComponent);
					}
					else if (paramName.toLowerCase() == "custom_bt_naming") 
					{
						if (paramValue.indexOf(testInfoDelimiter) > -1) {
							paramValue = publicJson['testInfoDelimParamValue'];
						}
						var viewLabel = publicJson['viewLabel'];
						var processTextAreaComponent = {
							xtype: 'fieldcontainer',
							//fieldLabel: tempParamName,
							fieldLabel: btnRules,
							layout: 'column',
							labelSeparator: ' ',
							items: [{
									xtype: 'textarea',
									cls: 'text-area',
									readOnly:true,
									id: paramName,
									name: paramName,
									value: 'None',
									rows: 5,
//									columnWidth: 0.93,
									width: 265,
									margin: '0 8 0 0',
								}, {
									xtype: 'button',
									id: 'viewUrl',
									//columnWidth: 0.07,
									tooltip: viewLabel,
									iconCls: 'iconConfigure',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										click: function () {
											testViews.btNamingConfig();
										}
									}
								}
							]
						};

						me.getRuleNamesFromIni(false);
						paramsFieldSetContainer.add(processTextAreaComponent);
					} 
					else if (paramName.toLowerCase() == "min_max_values") 
					{
						var tmpParamValue = paramValue;
						if(paramValue.indexOf(testInfoDelimiter) > -1)
						{
							tmpParamValue = publicJson['testInfoDelimParamValue'];
						}
						if (strDelimiterMask.length > 0 && paramValue.indexOf(strDelimiterMask) != -1)
						{
							tmpParamValue = publicJson['strDelimiterMaskParamValue'];
						}
						var viewLabel = publicJson['viewLabel'];
						var minmaxBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: minMaxLabel,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: viewLabel,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.winServiceConfig_pr();
										}
									}
								},
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: tmpParamValue,
									hidden: true
								}
							]
						};
						paramsFieldSetContainer.add(minmaxBtnComponent);
					}
					else
					{
						var textAreaComponent = {
							xtype: 'textarea',
							cls: 'text-area',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: paramValue,
							rows: 5
						};
						paramsFieldSetContainer.add(textAreaComponent);
					}
				}
				else //text
				{
					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					if (isSnmp || isPolicyParamExists || isCorrectParamExist || isUrlParamExist || isWsdlUrlExist || paramName.toLowerCase() == "real_servername")
					{
						var temp = paramValue;
						var strVal = "";
						if (testName == previousTestName )
						{
							strVal = Ext.getCmp(paramName).getValue();
						}
						if (!Ext.isEmpty(strVal))
						{
							paramValue = strVal;
						}
						else
						{
							paramValue = temp;
						}
					}
					if(paramName.toLowerCase() == "correctivescript")
					{
						var correctiveScriptText = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: paramValue,
							hidden: true,
							disabled: true,
							columnWidth: 1
						};
						paramsFieldSetContainer.add(correctiveScriptText);
						if (isCorrectParamExist)
						{
							var isCorrectYes = Ext.getCmp('correct1').getValue();
							var isCorrectNo = Ext.getCmp('correct2').getValue();
							if (isCorrectNo)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
							}
							else if (isCorrectYes)
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
							}
						}
					}
					else if(paramName.toLowerCase() == "url")
					{
						if (isCredentialParamExist)
						{
							urlParamValue = publicJson['urlParamValue'];
							imageTitle = publicJson['imageTitle'];
							var urlTextComponent = {
								xtype: 'fieldcontainer',
								id: tempParamName,
								name: tempParamName,
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										columnWidth: 0.93,
										margin: '0 5 0 0',
										value: urlParamValue,
										readOnly: true,
										listeners: {
											blur: function()
											{
												me.checkURLAndCredentials(this.id);
											}
										}
									},
									//{
										//xtype: 'component',
										//columnWidth: 0.07,
										//html:'<center><img src="/final/admin/eg_images/plus.gif" style="cursor:pointer;" border="0" width="15" height="10" onclick="javascript:loadDomainGroupWindow()" title='+imageTitle+'></center>'
									//}
									{
										xtype : 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										tooltip: label19,
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function()
											{
												testViews.configCerdentialurl();
											}
										}
									}
									
								]
							};
							paramsFieldSetContainer.add(urlTextComponent);
						}
						else
						{
							urlParamValue = publicJson['urlParamValue'];
							var urlTextAreaComponent = {
								xtype: 'textarea',
								cls: 'text-area',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: urlParamValue,
								rows: 5
							};
							paramsFieldSetContainer.add(urlTextAreaComponent);
						}
					}
					else if(paramName.toLowerCase() == "wsdl_url")
					{
						if (isCredentialParamExist)
						{
							wsdlUrlParamValue = publicJson['wsdlUrlParamValue'];
							wsdlUrlImgTitle = publicJson['wsdlUrlImgTitle'];
							var wsdlUrlText = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										//columnWidth: 0.93,
										columnWidth: 1,
										value: wsdlUrlParamValue,
										//margin: '0 5 0 0',
										listeners: {
											blur: function()
											{
												me.checkURLAndCredentials(this.id);
											}
										}
									}
									//,{
										//xtype : 'button',
										//iconCls : 'iconAdd',
										//tooltip: label19,
										//columnWidth: 0.07,
										//style : {
											//background : 'none',
											//border : '0px'
										//},
										//listeners: {
											//click: function()
											//{
												//testViews.configureWsdlUrl();
											//}
										//}
									//}
									//{
										//xtype: 'component',
										//columnWidth: 0.1,
										//html:'<center><img src="/final/admin/eg_images/plus.gif" style="cursor:pointer;" border="0" width="15" height="10" onclick="javascript:loadDomainGroupWindow()" title='+wsdlUrlImgTitle+'></center>'
									//}
								]
							};
							paramsFieldSetContainer.add(wsdlUrlText);
						}
						else
						{
							wsdlUrlParamValue = publicJson['wsdlUrlParamValue'];
							//if(!Ext.isEmpty(paramForDisplayingValidateButton) && paramForDisplayingValidateButton.toLowerCase() == paramName)
							{
								var wsdlUrlText = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: wsdlUrlParamValue,
									//hidden: true,
									//disabled: true,
									columnWidth: 1
								};
								paramsFieldSetContainer.add(wsdlUrlText);
							}
						}
					}
					else if (paramName.toLowerCase() == "rule_name")
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var ruleNameBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: ruleNameToolTip,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.createRulesForSyslog(paramNamePopUp);
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue  
								}
							]
						};
						paramsFieldSetContainer.add(ruleNameBtnComponent);
					}
					else if (paramName.toLowerCase() == "management_user")
					{
						var strIsManagedByChanged = publicJson['isManagedByChanged'];
						if (Ext.isEmpty(strIsManagedByChanged ))
						{
							var tempUser = publicJson['tempUser'];
							if (tempUser != null)
							{
								paramValue = tempUser;
							}
							var hiddenComponent = this.createTextBox(paramName);
							paramsFieldSetContainer.add(hiddenComponent);
							Ext.getCmp(paramName).setValue(paramValue);
						}
						else
						{
							var tempUser = publicJson['tempUser'];
							
							var hiddenComponent = this.createTextBox(paramName);
							paramsFieldSetContainer.add(hiddenComponent);
							Ext.getCmp(paramName).setValue(paramValue);
						}
						var fromUsrIniManagedBy = publicJson['selectedIsManagedBy'];
						if (!Ext.isEmpty(fromUsrIniManagedBy) && fromUsrIniManagedBy != undefined && fromUsrIniManagedBy == 'HMC')
						{
							var mgmtUser = 'none';
							mgmtUser = publicJson['tempUser'];
							if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
							{
								mgmtUser = 'none';
							}
							Ext.getCmp(paramName).setValue(mgmtUser);
						}
						else
						{
							var mgmtUser = '$unconfigured';
							mgmtUser = publicJson['tempUser'];
							if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
							{
								mgmtUser = '$unconfigured';
							}
							Ext.getCmp(paramName).setValue(mgmtUser);
						}
					}
					else if(paramName.toLowerCase() == "target_diskio_rate")
					{
						diskIOParamValue = publicJson['targetDiskIOParamValue'];
						targetDiskIORateLabelArr = publicJson['targetDiskIORateLabelArr'];
						targetDiskIORateSelect = publicJson['targetDiskIORateSelect'];
						if (Ext.isEmpty(targetDiskIORateSelect) || targetDiskIORateSelect == undefined)
						{
							targetDiskIORateSelect = targetDiskIORateLabelArr[0].valueField;
						}

						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var taskIORateComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: 'TargetDiskIORate_select',
									name: 'TargetDiskIORate_select',
									displayField: 'displayField',
									valueField: 'valueField',
									value: targetDiskIORateSelect,
									queryMode: 'local',
									editable: false,
									columnWidth: 0.55,
									store: new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: targetDiskIORateLabelArr
									}),
									margin: '0 5 0 0'
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									columnWidth: 0.45,
									value: diskIOParamValue
								}
							]
						};
						paramsFieldSetContainer.add(taskIORateComponent);
					}
					else if ((testName.toLowerCase() == "windowsharetest" || testName.toLowerCase() == "uncchecktest") && 
						paramName.toLowerCase() == "sharename")
					{
						//if (paramValue.indexOf("|") > -1)
						{
							shareNameParamValue = publicJson['shareNameParamValue'];
						}
						var imageTitle = publicJson['btnLabel'+paramName];
						var compNameWithoutNull = publicJson['compNameWithoutNull'];
						var shareNameComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: paramName.toUpperCase(),
							labelSeparator: ' ',
							layout:'column',
							items: [
								{
									xtype: 'button',
									iconCls: 'iconConfigure',
									columnWidth: 1,
									fieldLabel: paramName.toUpperCase(),
									tooltip: label20,
									style : {
										//align: 'left',
										background : 'none',
										border : '0px'
									},

									listeners: {
										click: function() {
											testViews.configWindowShared();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(shareNameComponent);
					}
					else if (isSystemPropertyParamTests &&
						(paramName.toLowerCase() == "system_property_key" || paramName.toLowerCase() == "system_property_value"))
					{
						if ( paramName.toLowerCase() == "system_property_key")
						{
							var sysPropKey = publicJson['sysPropKey'];
							var keyBtnComponent = {
								xtype: 'fieldcontainer',
								fieldLabel: sysPropLbl.toUpperCase(),
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'button',
										columnWidth: 1,
										tooltip: tootipProperty,
										iconCls : 'iconConfigure',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function() {
												testViews.configSystemProperties();
											}
										}
									},
									{
										xtype: 'hiddenfield',
										name: paramName,
										id: paramName,
										value: sysPropKey
									}
								]
							};
							paramsFieldSetContainer.add(keyBtnComponent);
						}
						else if (paramName.toLowerCase() == "system_property_value")
						{
							continue;
						}
					}
					else if (paramName.toLowerCase() == "email_id")
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var emailIdBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: 'Configure Email and Password',
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.configEMailCredential();
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue
								}
							]
						};
						paramsFieldSetContainer.add(emailIdBtnComponent);
					}
					else
					{
						var multiUserOrNameParamValue = publicJson['multiUserOrNameParamValue'+paramName];
						var isEditable = publicJson['readOnly'+paramName];
						if (multiUserMode || multiNamePatternMode)
						{
							if (readOnlyParamIdx)
							{
								var plusButton = publicJson['plusButton'+paramName];
								var onBlurStr  = publicJson['onBlurStr'+paramName];
								var onFocusStr = publicJson['onFocusStr'+paramName];
								var onChangeStr = publicJson['onChangeStr'+paramName];
								
								if (!Ext.isEmpty(plusButton) && plusButton != undefined)
								{
									var toolTipMsg = '';
									if (multiUserMode)
									{
										toolTipMsg = label16;
										if (paramName == 'Connection_server_name')
										{
											tooltipMsg = serverNameToolTip
										}
									}
									else
									{
										toolTipMsg = label17;
									}
									var paramNamePopUp = paramName;
									var plusBtnTextBoxComponent = {
										xtype: 'fieldcontainer',
										fieldLabel: tempParamName,
										labelSeparator: ' ',
										layout: 'column',
										items: [
											{
												xtype: 'textfield',
												cls: 'textbox',
												id: paramName,
												name: paramName,
												columnWidth: 0.93,
												value: multiUserOrNameParamValue,
												readOnly: isEditable,
												margin: '0 5 0 0',
												listeners: {
													change: function()
													{
														if (multiUserMode)
														{
															me.getUserChangedValue(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.getNamePatternChangedValue(this.id);
														}
													},
													focus: function()
													{
														if (multiUserMode)
														{
															me.getUserValue(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.getNamePatternValue(this.id);
														}
													},
													blur: function()
													{
														if (multiUserMode)
														{
															me.checkMultipleUser(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.checkMultipleNamePattern(this.id);
														}
													}
												}
											},
											{
												xtype : 'button',
												iconCls : 'iconAdd',
												columnWidth: 0.07,
												tooltip: toolTipMsg,
												style : {
													background : 'none',
													border : '0px'
												},
												listeners: {
													click: function()
													{
														testViews.getPopUpView(paramNamePopUp);
														//testViews.configMultiUser();
													}
												}
											}
										]
									};
									paramsFieldSetContainer.add(plusBtnTextBoxComponent);
								}
								else if ((testName.toLowerCase() == "ctxxcxalogonsimtest" ||
									testName.toLowerCase() == "hrznlogonsimtest" || 
									testName.toLowerCase() == "hrznwlogonsimtest" || 
									testName.toLowerCase() == "awslogonsimtest" || 
									testName.toLowerCase() == "awsappstrmsimtest") && 
									paramName.toLowerCase() == "published_resources")
								{
									var paramNamePopUp = paramName;

									var pubResrcBtnComponent = {
										xtype: 'fieldcontainer',
										fieldLabel: tempParamName,
										labelSeparator: ' ',
										layout: 'column',
										items: [
											{
												xtype: 'button',
												columnWidth: 1,
												tooltip: pubResourceToolTip,
												iconCls : 'iconConfigure',
												style : {
													background : 'none',
													border : '0px'
												},
												listeners: {
													click: function() {
														if (testName.toLowerCase() == "hrznwlogonsimtest")
														{
															testViews.configHorizonWSResourceSet();
														}
														else if (testName.toLowerCase() == "awslogonsimtest")
														{
															testViews.configAmazonWSResourceSet();
														}
														else if (testName.toLowerCase() == "awsappstrmsimtest")
														{
															testViews.configAwsAppStreamResourceSet();
														}
														else
														{
															testViews.getPopUpView(paramNamePopUp);
														}
													}
												}
											},
											{
												xtype: 'hiddenfield',
												name: paramName,
												id: paramName,
												value: multiUserOrNameParamValue
											}
										]
									};
									paramsFieldSetContainer.add(pubResrcBtnComponent);
								}
								else
								{
									var elserReadOnlyPlusBtnTextComponent = {
												xtype: 'textfield',
												cls: 'textbox',
												fieldLabel: tempParamName,
												id: paramName,
												name: paramName,
												value: multiUserOrNameParamValue,
												readOnly: isEditable
									};
									paramsFieldSetContainer.add(elserReadOnlyPlusBtnTextComponent);

									if ((testName == 'CtxXcXALogonSimTest' ||
										testName == 'AWSLogonSimTest' ||
										testName == 'HrznLogonSimTest' ||
										testName == 'AwsAppStrmSimTest') &&
										paramName == 'Domain')
									{
										Ext.getCmp(paramName).hide();
									}
								}
							}
							else if (paramName.toLowerCase() == 'user_id')
							{
								var fieldContainerComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: paramValue,
								};
								paramsFieldSetContainer.add(fieldContainerComponent);

								if (testName == 'HrznWLogonSimTest')
								{
									Ext.getCmp(paramName).hide();
								}
							}
							else
							{
								if (multiUserOrNameParamValue.length > 20 && readOnly.toLowerCase() == "")
								{
									var multiTextAreaComponent = {
										xtype: 'textarea',
										cls: 'text-area',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: multiUserOrNameParamValue,
										readOnly: isEditable,
										rows: 5
									};
									paramsFieldSetContainer.add(multiTextAreaComponent);
								}
								else
								{
									var multiTextComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: multiUserOrNameParamValue,
										readOnly: isEditable
									};
									paramsFieldSetContainer.add(multiTextComponent);
								}

								if ((testName == 'CtxXcXALogonSimTest' || 
									testName == 'HrznLogonSimTest' || 
									testName == 'AWSLogonSimTest' ||
									testName == 'HrznWLogonSimTest' ||
									testName == 'AwsAppStrmSimTest') && 
									(paramName == 'Username' || 
									paramName == 'Disclaimer'))
								{
									Ext.getCmp(paramName).hide();
								}
							}
						}
						else
						{
							paramValue = publicJson['remainParamValue'+paramName];
							if ((isSnmp || isModeParamExist || isCorrectParamExist)  && (paramName == 'snmpPort' || paramName == 'username' || paramName == 'context' || paramName == 'snmpCommunity' || paramName == 'snmpcommunity' || paramName == 'Jmx_Remote_Port' || paramName == 'Jndi_Name' || paramName == 'user' || paramName == 'JREHome' || paramName == 'LogFileName' || paramName == 'Jmx_user' || paramName == 'Java_Home' || paramName == 'Include_Packages' || paramName == 'Exclude_Packages' || paramName == 'Heap_Dump_Location' || paramName == 'userparams' || paramName == 'Provider'))
							{
								var fieldContainerComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: paramValue,
									fieldLabel: paramName.toUpperCase(),
									disabled: true,
									hidden: true,
									columnWith: 1
								};
								paramsFieldSetContainer.add(fieldContainerComponent);
								if (isCorrectParamExist)
								{
									if (paramName == 'userparams')
									{
										var isCorrectYes = Ext.getCmp('correct1').getValue();
										if (isCorrectYes)
										{
											Ext.getCmp(paramName).setDisabled(false);
											Ext.getCmp(paramName).show();
										}
									}
									else if (paramName == 'user')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
									}
								}
								if (isSnmp)
								{
									if (paramName == 'snmpPort' )
									{
										snmpPortextValues = paramValue;
									}
									else if (paramName == 'context' )
									{
										snmpUserContextValues = paramValue;
									}
									else if (paramName == 'username' )
									{
										snmpUserTextValues = paramValue;
									}
									else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
									{
										snmpCommunityTextValues = paramValue;
									}

									if (isModeParamExist)
									{
										var modeSNMP = Ext.getCmp('mode1').getValue();
										var modeJMX = Ext.getCmp('mode2').getValue();
										if (modeSNMP)
										{
											if (paramName == 'snmpPort')
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);
											}
											var snmpVerObject = '';
											if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
											{
												snmpVerObject = Ext.getCmp('snmpversion');
											}
											else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
											{
												snmpVerObject = Ext.getCmp('snmpVersion');
											}

											if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
											{
												var snmpVer = snmpVerObject.getValue();
												if (paramName == 'username' && snmpVer == 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else if (paramName == 'context' && snmpVer == 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else if ((paramName == 'snmpCommunity' || paramName == 'snmpcommunity' ) && snmpVer != 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
										}
										else if (modeJMX)
										{
											if (paramName == 'Jmx_Remote_Port')
											{
												Ext.getCmp('Jmx_Remote_Port').setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName == 'Jndi_Name')
											{
												Ext.getCmp('Jndi_Name').setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName == 'Provider')
											{
												Ext.getCmp('Provider').setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName == 'Jmx_user' || paramName == 'user')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
										var heapAnalysisObject = Ext.getCmp('Heap_Analysis1');
										if (!Ext.isEmpty(heapAnalysisObject) && heapAnalysisObject != undefined)
										{
											var heapYes = Ext.getCmp('Heap_Analysis1').getValue();
											if (heapYes)
											{
												if (paramName == 'Java_Home')
												{
													Ext.getCmp('Java_Home').setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName == 'Include_Packages')
												{
													Ext.getCmp('Include_Packages').setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName == 'Exclude_Packages')
												{
													Ext.getCmp('Exclude_Packages').setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName == 'Heap_Dump_Location')
												{
													Ext.getCmp('Heap_Dump_Location').setDisabled(false);
													Ext.getCmp(paramName).show();
												}
											}
										}
									}
									else
									{
										var snmpVerObject = '';
										if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
										{
											snmpVerObject = Ext.getCmp('snmpversion');
										}
										else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
										{
											snmpVerObject = Ext.getCmp('snmpVersion');
										}
										if (paramName == 'username' )
										{
											snmpUserTextValues = paramValue;
										}
										else if (paramName == 'context' )
										{
											snmpUserContextValues = paramValue;
										}
										else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
										{
											snmpCommunityTextValues = paramValue;
										}

										if (paramName == 'snmpPort')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);
										}
										else
										{
											if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
											{
												var snmpVer = snmpVerObject.getValue();
												if (paramName == 'username' && snmpVer == 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else if (paramName == 'context' && snmpVer == 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else if ((paramName == 'snmpCommunity' || paramName == 'snmpcommunity' ) && snmpVer != 'v3')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
										}
										if (isSnmp)
										{
											if (paramName == 'Jmx_user' || paramName == 'user')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
									}
								}
							}
							else
							{
								if (paramName.toLowerCase()=='monitor_url_post_data')
								{
									paramValue = publicJson['paramValue'+paramName];
									if (!Ext.isString(paramValue))//.toLowerCase() != 'none' )
									{
										paramValue = JSON.stringify(paramValue);
									}
								}

								var tempParamName = publicJson['paramNameObj'][paramName];
								if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
								{
									tempParamName = tempParamName.substring(0,tempParamName.length - 1);
								}

								var isEditable = publicJson['readOnly'];
								var descriptorButton = publicJson['descriptorButton'];
								if (!Ext.isEmpty(descriptorButton) && descriptorButton != undefined)
								{
									var lastTextDescBtn = {
										xtype: 'fieldcontainer',
										fieldLabel: tempParamName,
										labelSeparator: ' ',
										layouut: 'column',
										items: [
											{
												xtype: 'textfield',
												cls: 'textbox',
												id: paramName,
												name: paramName,
												value: paramValue,
												//maxWidth: 195,
												columnWidth: 0.9,
												readOnly: isEditable
											},
											{
												xtype: 'component',
												columnWidth: 0.1,
												html:'<center>'+descriptorButton+'</center>'
											}
										]
									};
									paramsFieldSetContainer.add(lastTextDescBtn);
								}
								else if (paramValue.length > 30 && !isEditable)
								{
									if ((testName == 'EgSyslogFilterTest' ||
										testName == 'EgSyslogFilterSvrTest' ||
										testName == 'DeviceSyslogMsgs') && (paramName == 'facility' || 
										paramName == 'filter_host' || paramName == 'level' ||
										paramName == 'filter_logic' || paramName == 'exclude_Patterns' ))
									{
										var lastTextBoxRefuseTxtAreaComponent =  {
											xtype: 'textfield',
											cls: 'textbox',
											id: paramName,
											name: paramName,
											value: paramValue,
											fieldLabel: tempParamName,
											hidden: true,
											readOnly: isEditable
										};
										paramsFieldSetContainer.add(lastTextBoxRefuseTxtAreaComponent);
									}
									else
									{
										var lastTextBoxEditable = {
											xtype: 'textarea',
											cls: 'text-area',
											id: paramName,
											name: paramName,
											value: paramValue,
											readOnly: isEditable,
											fieldLabel: tempParamName,
											rows: 5
										};
										paramsFieldSetContainer.add(lastTextBoxEditable);
									}

									//AWS_Account_ID_To_Monitor, AWS_Role_Name
									if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_Role_Name' || 
										paramName == 'AWS_Account_ID_To_Monitor'))
									{
										var accessTypeObj = Ext.getCmp('Access_Type1');
										if (!Ext.isEmpty(accessTypeObj))
										{
											var isAccessTypeRoleChkd = accessTypeObj.getValue();

											if (isAccessTypeRoleChkd)
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);
											}
											else
											{
												Ext.getCmp(paramName).hide();
												Ext.getCmp(paramName).setDisabled(true);
											}
										}
									}
								}
								else
								{
									var lastTextBoxComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: paramValue,
										readOnly: isEditable
										//columnWidth: 1
									};
									paramsFieldSetContainer.add(lastTextBoxComponent);

									//AWS_Account_ID_To_Monitor, AWS_Role_Name
									if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_Role_Name' || 
										paramName == 'AWS_Account_ID_To_Monitor'))
									{
										var accessTypeObj = Ext.getCmp('Access_Type1');
										if (!Ext.isEmpty(accessTypeObj))
										{
											var isAccessTypeRoleChkd = accessTypeObj.getValue();

											if (isAccessTypeRoleChkd)
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);
											}
											else
											{
												Ext.getCmp(paramName).hide();
												Ext.getCmp(paramName).setDisabled(true);
											}
										}
									}

									//EgSyslogFilterTest
									if ((testName == 'EgSyslogFilterTest' ||
										testName == 'EgSyslogFilterSvrTest' ||
										testName == 'DeviceSyslogMsgs') && (paramName == 'facility' || 
										paramName == 'filter_host' || paramName == 'level' ||
										paramName == 'filter_logic' || paramName == 'exclude_Patterns' ))
									{
										Ext.getCmp(paramName).hide();
									}

									if ((testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf') && (paramName == 'timeout' || 
											paramName == 'sapuser' || paramName == 'sysno' ||
											paramName == 'clientname' || paramName == 'router' || 
											paramName == 'instancename' || paramName == 'os_username' ||
											paramName == 'wsdl_port'))
										{
											var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
											var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
											if (!Ext.isEmpty(useSAPControlObj))
											{
												var useSAPControlNo = useSAPControlObj.getValue();

												if (useSAPControlNo)
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
												else 
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
												}
											}
											if (!Ext.isEmpty(useSAPControlObjAuto))
											{
												var useSAPControlNo = useSAPControlObjAuto.getValue();
												if (useSAPControlNo.toLowerCase()=='false')
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
												else if (useSAPControlNo.toLowerCase()=='true')
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
												}
												else 
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
											}
										}

									if (paramName == 'Show_Exat_limit')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									}
									if (paramName == 'Requests_Per_Day')
									{
										var isTrailObj = Ext.getCmp('Is_Trail1');
										if (!Ext.isEmpty(isTrailObj))
										{
											var isTrailYes = isTrailObj.getValue();
											if (isTrailYes)
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else
											{
												Ext.getCmp(paramName).setDisabled(true);
												Ext.getCmp(paramName).hide();
											}
										}
									}

									if (testName.indexOf('JvmMemoryDetailsTest') > -1  && 
										paramName == 'Target_Process_User_Name')
									{
										var isUseSudoObj = Ext.getCmp('Use_Sudo1');
										if (!Ext.isEmpty(isUseSudoObj))
										{
											var isTrailYes = isUseSudoObj.getValue();
											if (isTrailYes)
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else
											{
												Ext.getCmp(paramName).setDisabled(true);
												Ext.getCmp(paramName).hide();
											}
										}
									}

									if (paramName == 'Pojo_Method_Tracing_Limit' || 
										paramName == 'Pojo_Method_Tracing_Cutoff_Time' || 
										paramName == 'Recursive_Method_Tracing_Limit' || 
										paramName == 'Non-Pojo_Method_Tracing_Limit' || 
										paramName == 'Exception_Stacktrace_Lines' || 
										paramName == 'Included_Exceptions' || 
										paramName == 'Ignored_Exceptions' || 
										paramName == 'Ignored_Characters' || 
										paramName == 'Max_Grouped_Urls_Per_Measure_Period' || 
										paramName == 'Key_Max_Grouped_Urls_Per_Measure_Period' || 
										paramName == 'Max_Sql_Queries_Per_Transaction' ||
										paramName == 'Max_Mongodb_Query_Length' || 
										paramName == 'Exception_With_StackTrace_Capture_Limit' || 
										paramName == 'Exception_FQEN_Capture_Limit' || 
										paramName == 'Max_Sql_Error_Queries_Per_Transaction' || 
										paramName == 'Max_Exception_Trace_Limit' ||
										paramName == 'Mask_SQL' || 
										paramName == 'Mask_Public_IP' || 
										paramName == 'Mask_Private_IP' ||
										paramName == 'Mask_URL_Params')
										
									{
										var isTrailObj = Ext.getCmp('Advanced_Settings1');
										if (!Ext.isEmpty(isTrailObj))
										{
											var isTrailYes = isTrailObj.getValue();
											if (isTrailYes)
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else
											{
												Ext.getCmp(paramName).setDisabled(true);
												Ext.getCmp(paramName).hide();
											}
										}
									}
									if (paramName == 'max_grouped_urls')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									} 

									if (paramName == 'Maximum_Allowed_Grouped_Url_Per_Component')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									}

									if (isAPMTest && (paramName == 'Slow_URL_Threshold' || paramName == 'Stalled_URL_Threshold'))
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									}

									//if (paramName == 'max_grouped_urls' || paramName == 'max_slow_dd_count' || paramName == 'max_error_dd_count')
									//{
										//var monLevel = '';
										//if (!Ext.isEmpty(Ext.getCmp('Monitoring_Level')) && Ext.getCmp('Monitoring_Level') != undefined )
										//{
											//monLevel = Ext.getCmp('Monitoring_Level').getValue();
										//}
										//else if (!Ext.isEmpty(Ext.getCmp('monitoring_level')) && Ext.getCmp('monitoring_level') != undefined )
										//{
											//monLevel = Ext.getCmp('monitoring_level').getValue();
										//}
									
										//if (!Ext.isEmpty(monLevel) && monLevel != undefined && monLevel == '1' || monLevel == '2')
										//{
											//Ext.getCmp(paramName).setDisabled(true);
											//Ext.getCmp(paramName).hide();
										//}
										//else if (!Ext.isEmpty(monLevel) && monLevel != undefined && monLevel == '3')
										//{
											//if (paramName == 'max_grouped_urls')
											//{
												//Ext.getCmp(paramName).setDisabled(true);
												//Ext.getCmp(paramName).hide();
											//}
										//}
									//}
								}
							}
						}
					}
				}
			}

			var allowDetailedDiagnosis = publicJson['allowDetailedDiagnosis'];
			if (allowDetailedDiagnosis)
			{
				var DDLabel = publicJson['DDLabel'];
				var isTestDetailedDiagnosisDisabledGlobally = publicJson['isTestDetailedDiagnosisDisabledGlobally'];
				if (isTestDetailedDiagnosisDisabledGlobally)
				{
					var isDisabledGlobalValue = publicJson['isDisabledGlobalValue'];

					var ddLabelComponent = {
						xtype: 'label',
						id: 'detaileddiagnosisLabel',
						name: 'detaileddiagnosisLabel',
						fieldLabel: DDLabel,
						value: isDisabledGlobalValue
					};
					paramsFieldSetContainer.add(ddLabelComponent);
				}
				else
				{
					var enabled = publicJson['DDEnabled'];
					var disabled = publicJson['DDDisabled'];

					var ddRadioGroupComponent = {
						xtype: 'radiogroup',
						cls: 'radiobt',
						fieldLabel: DDLabel,
						vertical: false,
						columns: 2,
						items: [
							{ boxLabel: 'On', name: 'detaileddiagnosis', id: 'detaileddiagnosis1',  inputValue: 'On', checked: enabled },
							{ boxLabel: 'Off', name: 'detaileddiagnosis', id: 'detaileddiagnosis2',  inputValue: 'Off', checked: disabled }
						]
					};
					paramsFieldSetContainer.add(ddRadioGroupComponent);
				}
			}

			var hiddenFieldsContainer = {
				xtype: 'container',
				id: 'hiddenFieldContainer',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items: []
			};
			var hiddenObj = publicJson['hiddenObj'];
			if (!Ext.isEmpty(hiddenObj))
			{
				var hiddenArray = new Array();
				Ext.getCmp('testConfigForm').add(hiddenFieldsContainer);
				for (key in hiddenObj)
				{
					var temp = {
						xtype: 'hiddenfield',
						name: key,
						id: key,
						value: hiddenObj[key],
					};
					hiddenArray.push(temp);
				}
				Ext.getCmp('hiddenFieldContainer').add(hiddenArray);
			}
			
			var isTrailObj = Ext.getCmp('Advanced_Settings1');
			if (!Ext.isEmpty(isTrailObj) && isTrailObj != undefined)
			{
				var isTrailYes = isTrailObj.getValue();
				if (isTrailYes)
				{
					var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
					maskSQLObj.setDisabled(false);
					maskSQLObj.show();

					var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");
					maskPublicIPObj.setDisabled(false);
					maskPublicIPObj.show();

					var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
					maskPrivateIPObj.setDisabled(false);
					maskPrivateIPObj.show();
					
					var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");
					maskUrlParamsObj.setDisabled(false);
					maskUrlParamsObj.show();
				}
				else
				{
					var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
					maskSQLObj.setDisabled(true);
					maskSQLObj.hide();

					var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");
					maskPublicIPObj.setDisabled(true);
					maskPublicIPObj.hide();

					var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
					maskPrivateIPObj.setDisabled(true);
					maskPrivateIPObj.hide();
					
					var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");
					maskUrlParamsObj.setDisabled(true);
					maskUrlParamsObj.hide();
				}
			}
			
			paramsFieldSetContainer.show();
			Ext.getCmp('bottomToolBar').show();
			Ext.getCmp('updateBtn').setDisabled(false);
			//var objDiv = document.getElementById('testConfigForm-body');
			//objDiv.scrollTop = objDiv.scrollHeight;
		}
	},
	btNamingConfig: function () { //Business Transaction Naming Config starts
		//this.getController('DefaultTestConfiguration.controller.Main').getRulesFromIni();
		//this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').btNamingConfigs();

		Ext.create('DefaultTestConfiguration.view.BusinessTransactionNaming').show();
		me.getRulesData();
	},
	//getRulesFromIni: function () {
		//////console.log("inside getRulesFromIni");
		//Ext.widget('businesstransactionnaming').show();
		//me.getRulesData();
	//},
	getRulesData: function () {
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		Ext.Ajax.request({
			url: "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&data=",
			method: "POST",
			async: false,
			success: function (a) {
				if (a.status == 200 && !Ext.isEmpty(a.responseText)) {
					var b = a.responseText;
					publicJSON = Ext.decode(b);
					////console.log(publicJSON);


					for (var indx in publicJSON['BTValues']) {
						var urlPatternData = publicJSON['BTValues'][indx]['Matching_URL_Pattern'];
						var uriSpec = '';
						if (urlPatternData.startsWith("*") && urlPatternData.endsWith("*")) {
							uriSpec = 'CONTAINS'
						} else if (urlPatternData.startsWith("*")) {
							uriSpec = 'ENDS WITH'
						} else if (urlPatternData.endsWith("*")) {
							uriSpec = 'STARTS WITH'
						} else {
							uriSpec = 'EQUALS'
						}
						////console.log(urlPatternData);
						////console.log(urlPatternData.split('*').join(''));
						publicJSON['BTValues'][indx]['Matching_URL_Pattern'] = uriSpec + ' : ' + urlPatternData.split('*').join('');
						////console.log(publicJSON['BTValues'][indx]['Rule_Details'].split("~|~"));
						var splitRuleDetails = publicJSON['BTValues'][indx]['Rule_Details'].split('~|~');
						var newStr = '/';

						for (var index in splitRuleDetails) {
							////console.log(splitRuleDetails[index]);
							if (splitRuleDetails[index].startsWith('US')) {
								splitRuleDetails[index] = splitRuleDetails[index].replace('=', '');
								splitRuleDetails[index] = splitRuleDetails[index].replace('US', "URL_SEGMENT #");
							} else if (splitRuleDetails[index].startsWith('HP')) {
								var requestParamKey = splitRuleDetails[index].split('=')[1];
								var regex = splitRuleDetails[index].split('=')[0];
								var justRegex = regex.replace('HP_','');
								////console.log(requestParamKey);
								splitRuleDetails[index] = "REQUEST_PARAM_VALUE_FOR : " + requestParamKey;
								if (justRegex != undefined && justRegex.length>0) {
									splitRuleDetails[index] += ", WITH_REGEX : " + justRegex;
								}
							}
							newStr += splitRuleDetails[index] + "/"
						}
						////console.log(newStr);
						publicJSON['BTValues'][indx]['Rule_Details'] = newStr.substring(0, newStr.length - 1);
					}
					var innerCardObj = Ext.getCmp('resultPanel');
					var gridpanelObj = Ext.create('DefaultTestConfiguration.view.BusinessTransactionRuleGrid');

					innerCardObj.removeAll();
					innerCardObj.add(gridpanelObj);

					Ext.getCmp("btRulesGrid").getStore().loadRawData(publicJSON["BTValues"]);
					if (Ext.isEmpty(publicJSON["BTValues"]))
					{
						Ext.getCmp('updateSpecificConfig').hide();
						Ext.getCmp('updateSpecificConfigContainer').hide();
					}
					else
					{
						Ext.getCmp('updateSpecificConfig').show();
						Ext.getCmp('updateSpecificConfigContainer').show();
					}
				}
			}
		});
		me.btNamingConfigs(); // for help UI process
	},
	btNamingConfigs: function() { 
		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=businesstransactionnaming',
			method: 'POST',
			async: false
		});
	},
	resultPanelCreateRuleForm: function () {
		////console.log("Inside add New RuleDetails");

		var innerCardObj = Ext.getCmp('resultPanel');
		var rulepanelObj = Ext.create('DefaultTestConfiguration.view.BusinessTransactionRule');

		innerCardObj.removeAll();
		innerCardObj.add(rulepanelObj);
		Ext.getCmp('createRule').setText('Create Rule');
		//Ext.getCmp('updateSpecificConfig').hide();
	},
	saveOrUpdateRule: function () {
		if (Ext.getCmp('createRule').getText() == 'Create Rule') {
			me.createRule();
		} else {
			me.updateRule();
		}
	},
	verifyCreateOrUpdateRule: function(name, urlPattern, idArray){
		if (Ext.isEmpty(name)) {
			me.displayAlert('name',_checkempty);
			return false;
		}
		if (Ext.isEmpty(urlPattern)) {
			me.displayAlert('nameURL1',_checkempty);
			return false;
		}
		for (var curId in idArray) {
			var uriSegmentType = Ext.getCmp('urlsegment_1_' + idArray[curId]).getValue();
			var uptosegmentNo = Ext.getCmp('urlsegmentNo_1_' + idArray[curId]).getValue();
			var segmentNo = Ext.getCmp('urlspecificsegmentNo_1_' + idArray[curId]).getValue();
			var segmentKey = Ext.getCmp('urlParam_1_' + idArray[curId]).getValue();
			if (uriSegmentType == 'param' ) {
				if( Ext.isEmpty(segmentKey)){
					me.displayAlert('urlParam_1_' + idArray[curId],_checkempty);
					return false;
				}
			} else if ((uriSegmentType == '1stFew' || uriSegmentType == 'specific')) {
				if(uptosegmentNo < 1){
					me.displayAlert('urlsegmentNo_1_' + idArray[curId], onlypositive);
					return false;
				}else if (segmentNo < 1){
					me.displayAlert('urlspecificsegmentNo_1_' + idArray[curId], onlypositive);
					return false;
				}else if(isNaN(uptosegmentNo)){
					me.displayAlert('urlsegmentNo_1_' + idArray[curId], onlyNumber);
					return false;
				}else if(isNaN(segmentNo)){
					me.displayAlert('urlspecificsegmentNo_1_' + idArray[curId], onlyNumber);
					return false;
				}				
			}			
		}
		return true;
	},
	createRule: function (grid, rowIndex, colIndex) {
		////console.log("Inside CreateRule ");
		
		var compList = Ext.ComponentQuery.query('#urlPropsfieldset1  fieldcontainer');
		var name = Ext.getCmp('name').getValue();
		var urlPattern = Ext.getCmp('nameURL1').getValue();

		////console.log(uptosegmentNo);
		var idArray = [];
		for (var i in compList) {
			var currentId = compList[i].id.split('_1_')[1];
			if (!idArray.includes(currentId)) {
				idArray.push(currentId);
			}
			////console.log(idArray);
		}

		if(!me.verifyCreateOrUpdateRule(name, urlPattern, idArray)) return false;
		
		var cpcData = me.prepareCpcData(idArray);
		var testName = publicJson['testName'];
		var compType = publicJson['selectedCompType'];
		var compName = publicJson['selectedCompName'];
		//Ext.getCmp('updateSpecificConfig').show();
		if (cpcData != "") {
			Ext.Ajax.request({
				url: "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=create&data=" + encodeURIComponent(cpcData),
				method: 'POST',
				async: false,
				success: function (response) {
					if (Ext.decode(response.responseText)['ruleCreated']) {
						var innerCardObj = Ext.getCmp('resultPanel');
						////console.log(Ext.decode(response.responseText)['ruleCreated']);
						me.getRulesData();
					}
				}
			});
		} else {
			//console.log("No data");
		}

	},
	displayAlert: function (Id, msg) {
		Ext.Msg.show({
			title: businessTransNamingTitle,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation',
			fn: function () {
				Ext.getCmp(Id).focus(true,true)
			}
		});
	},
  
	prepareCpcData: function (idArray) {

		////console.log('prepareCpcData block ');
		var urlPropsfieldset = Ext.getCmp('urlPropsfieldset1');
		////console.log(urlPropsfieldset);
		var urlPropsfieldsetLength = urlPropsfieldset.items.getCount();
		var finalPatternData = '';

		if (!Ext.isEmpty(urlPropsfieldset) && urlPropsfieldset != undefined) {
			var url = Ext.getCmp('nameURL1').getValue();
			var desc = Ext.getCmp('name').getValue();
			////console.log(' ------- url ' + url);
			////console.log(' ------- desc' + desc);

			if (Ext.getCmp('uri_1').value == 'SW') {
				url = url + "*";
			} else if (Ext.getCmp('uri_1').value == 'EW') {
				url = "*" + url;
			} else if (Ext.getCmp('uri_1').value == 'CON') {
				url = "*" + url + "*";
			} else if (Ext.getCmp('uri_1').value == 'LIST') {
				url = '*' + url;
				url = url.replace(/,/g, '*,*');
				url = url + '*';
			}
			if (url != null && url != undefined && url.length > 0) {
				var patternData = url + '~#~' + desc;
				////console.log(' patternData :- ' +patternData);
				var propsData = this.preparePropsData('1', idArray);
				if (propsData.length > 0) {
					propsData = '~!~' + propsData;
					finalPatternData = finalPatternData + patternData + propsData + ',';
				} else {
					finalPatternData = finalPatternData + patternData + ',';
				}
			}

		}
		////console.log(' -------');
		// return finalPatternData;
		////console.log('prepareCpcData block :-  end');

		if (finalPatternData.length > 0) {
			var endsWith1 = finalPatternData.endsWith(",");
			if (endsWith1) {
				var index1 = finalPatternData.lastIndexOf(",");
				finalPatternData = finalPatternData.substring(0, index1);
			}
			////console.log(finalPatternData);
			return finalPatternData;
		} else {
			return 'none';
		}
	},
	preparePropsData: function (id, idArray) {

		////console.log('preparePropsData block');
		////console.log(idArray);

		var propsLength = Ext.getCmp('urlPropsfieldset1').items.getCount();
		////console.log('propsLength :- ' + propsLength);
		if (propsLength == undefined) {
			return;
		}
		var runMe2 = true;
		var count2 = 0;
		var elementIdNo = 1;
		var propsData = '';
		var credInputs = BTNamingSegmentCount + 1;

		////console.log('---------------------------> credInputs : ' + credInputs);

		for (var idNum in idArray) {
			var idNo = idArray[idNum];
			var innerPropsContainer = Ext.getCmp('urlProperty_1_' + idNo);
			////console.log('gettting data for  :- ' + 'urlProperty_1_' + idNo);

			if (!Ext.isEmpty(innerPropsContainer) && innerPropsContainer != undefined) {
				// TODO: validate all the things
				var inputSrc = Ext.getCmp('urlsegment_1_' + idNo).getValue();
				////console.log('inputSrc :- ' + inputSrc);
				var str = '';
				if (inputSrc != 'param') {
					var segment;
					////console.log("urlsegmentNo_1_"+idNo+"= "+segment);
					if (inputSrc == '1stFew') {
						segment = Ext.getCmp('urlsegmentNo_1_' + idNo).getValue();
						var segmentCount;
						var segmentStr = '';
						for (segmentCount = 1; segmentCount <= segment; segmentCount++) {
							segmentStr += 'US=' + segmentCount + '~|~';
						}
						str = str + segmentStr;
					} else {
						segment = Ext.getCmp('urlspecificsegmentNo_1_' + idNo).getValue();
						str = str + 'US=' + segment + '~|~';
					}
				} else if (inputSrc == 'param') {
					var param = Ext.getCmp('urlParam_1_' + idNo).getValue();
					var regx = Ext.getCmp('urlRegEx_1_' + idNo).getValue();
					//console.log(regx);
					if (regx != undefined && (regx == 'none' || regx.length == 0)) {
						str = str + 'HP_=' + param + '~|~';
					} else if (regx != undefined && regx.length > 0) {
						str = str + 'HP_' + regx + '=' + param + '~|~';
					}
				}

				propsData = propsData + str;

				count2++;

				// if(count2<propsLength)
				// {
				// propsData = propsData +'~|~';
				// }

			} else {
				continue;
			}

		}
		////console.log('preparePropsData block while end');
		var endsWith = propsData.endsWith("~|~");
		if (endsWith) {
			var index = propsData.lastIndexOf("~");
			propsData = propsData.substring(0, index - 2);
		}
		////console.log('--------------------- propsData :--- '+propsData);
		return propsData;
	},
	updateRule: function () {

		var name = Ext.getCmp('name').getValue();
		var urlPattern = Ext.getCmp('nameURL1').getValue();
		var variable = Ext.getCmp('cpcVariable').getValue();
		
		var uriCriteria = Ext.getCmp('uri_1').getValue();

		if (uriCriteria == 'EQ') {
			urlPattern = urlPattern;
		} else if (uriCriteria == 'SW') {
			urlPattern = urlPattern + '*';
		} else if (uriCriteria == 'EW') {
			urlPattern = '*' + urlPattern;
		} else if (uriCriteria == 'CON') {
			urlPattern = '*' + urlPattern + '*';
		}
		cpcValue = urlPattern + '~#~' + name + '~!~';
		var compList = Ext.ComponentQuery.query('#urlPropsfieldset1  fieldcontainer');
		var idArray = [];
		for (var i in compList) {
			var currentId = compList[i].id.split('_1_')[1];
			if (!idArray.includes(currentId)) {
				idArray.push(currentId);
			}
		}

		for (var id in idArray) {
			////console.log('urlsegment_1_'+idArray[id] + '    -----    ' + Ext.getCmp('urlsegment_1_'+idArray[id]).getValue());
			if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == '1stFew') {
				var usCount = Ext.getCmp('urlsegmentNo_1_' + idArray[id]).getValue();
				var usCounter = '';
				for (usCounter = 1; usCounter <= usCount; usCounter++) {
					cpcValue += 'US=' + usCounter + '~|~';
				}
			} else if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == 'specific') {
				cpcValue += 'US=' + Ext.getCmp('urlspecificsegmentNo_1_' + idArray[id]).getValue() + '~|~';
			} else if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == 'param') {
				cpcValue += 'HP_' + Ext.getCmp('urlRegEx_1_' + idArray[id]).getValue();
				var regex = Ext.getCmp('urlParam_1_' + idArray[id]).getValue();
				//console.log('cpcValue = '+cpcValue)
				//console.log('regex = ' +regex)
				if (regex != undefined && !(regex.length < 1)) {
					////console.log(regex.length);
					cpcValue += '=' + regex;
				}
				cpcValue += '~|~';
			}
		}
		cpcValue = cpcValue.substring(0, (cpcValue.length) - 3);
		if(!me.verifyCreateOrUpdateRule(name, urlPattern, idArray)) return false;
		var testName = publicJson['testName'];
		var compType = publicJson['selectedCompType'];
		var compName = publicJson['selectedCompName'];
		var resultUrl = "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=update&variable=" + encodeURIComponent(variable) + "&data=" + encodeURIComponent(cpcValue);
		Ext.Ajax.request({
			url: resultUrl,
			method: 'POST',
			async: false,
			success: function (response) {
				me.getRulesData()
			}
		});

	},

	handleDeleteIconClick: function (grid, rowIndex, colIndex) {
		////console.log(Ext.getCmp('btRulesGrid').getStore().getAt(rowIndex).data['variable']);
		Ext.Msg.show({
			title: businessTransNamingTitle,
			msg: confirmDeleteRule,
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function (buttonText) {
				if (buttonText == "yes") {
					var testName = publicJson['testName'];
					var compType = publicJson['selectedCompType'];
					var compName = publicJson['selectedCompName'];
					var resultUrl = "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=delete&variable=" + encodeURIComponent(Ext.getCmp('btRulesGrid').getStore().getAt(rowIndex).data['variable']);
					//var resultUrl = "DefaultTestConfiguration/data/EGBTNamingJson.jsp?deleteRule="+encodeURIComponent(variableName)+"&mode=delete";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async: false,
						success: function (response) {
							me.getRulesData()
						}
					});
				}
			}
		});
	},
	callRulesDestroy: function () {},
	//Business Transaction Naming Config Starts
	//Win Service Starts

	createRadioButton: function (paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}

		var fieldContainerComponent = {
			xtype: 'radiogroup',
			cls: 'radiobt',
			id: paramName+'_radioGrp',
			fieldLabel: tempParamName,
			vertical: false,
			columns: 2,
			items: [
				{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true'},
				{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false'}
			],
		};
		return fieldContainerComponent;
	},
	createComboBox: function(paramName)
	{
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var tempCombo = {
			xtype: 'scrollcombo',
			cls: 'dropdown',
			id: paramName,
			name: paramName,
			fieldLabel: tempParamName,
			value: '',
			queryMode: 'local',
			displayField: 'displayField',
			valueField: 'valueField',
			editable: false,
			parent:this,
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			})
		};
		return tempCombo;
	},
	createTextBox: function(paramName)
	{
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var hiddenComponent = {
			xtype: 'textfield',
			cls: 'textbox',
			id: paramName,
			name: paramName,
			fieldLabel: tempParamName,
			value: '',
			columnWidth: 1
		};
		return hiddenComponent;
	},
	getRuleNamesFromIni: function (destroy) {
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		if (destroy) {
			var innerCardObj = Ext.getCmp('businesstransactionnaming');
			innerCardObj.destroy();
		}

		Ext.Ajax.request({
			url: "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&data=",
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var serverResponse = Ext.decode(response.responseText);
					var ruleNames = '';
					for (var k in serverResponse['BTValues']) {
						ruleNames += serverResponse['BTValues'][k]['Rule_Name'] + ' , ';
					}
					ruleNames = ruleNames.substring(0, ruleNames.length - 2);
					Ext.getCmp('custom_bt_naming').setValue((ruleNames.length < 1) ? 'None' : ruleNames);
				}
			}
		});
	},
	createFieldContainerTextBox: function (paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var tempTextBox = {
			xtype: 'fieldcontainer',
			id: tempParamName,
			name: tempParamName,
			fieldLabel: tempParamName,
			labelSeparator: ' ',
			layout: 'column',
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					id: paramName,
					name: paramName,
					columnWidth: 1,
					value: ''
				}
			]
		};
		return tempTextBox;
	},
	configAwsAppStreamResourceSet: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configAwsAppStreamResourceSet();
	},
	configAmazonWSResourceSet: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configAmazonWSResourceSet();
	},
	configSystemProperties: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configSystemProperties();
	},
	configHorizonWSResourceSet: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configHorizonWSResourceSet();
	},
	configMultiHLSFieldSet: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configMultiHLSFieldSet();
	},
	configEMailCredential: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').configEMailCredential();
	},
	createRulesForSyslog: function(btn) {
		this.getController('DefaultTestConfiguration.controller.FunctionController').createRulesForSyslog();
	},
	egxmsconfig: function(vchost){ // XMS IP starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').egxmsIPsconfig(vchost);
		Ext.getCmp('testConfigForm').body.scrollTo('top',250);
	},
	clearXMSIP: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearXMSIPs();
	},
	updateXMSIP: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateXMSIPs();
	},
	callXMSDestroy: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').callXMSIPsDestroy();
	},//XMS IP ends
	egvcconfig: function(vchost){//Vc starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').egvcsconfig(vchost);
	},
	combosslVc: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').combosslVcs();
	},
	clearVc: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearVcs();
	},
	updateVc: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateVcs();
	},
	callVcDestroy: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').callVcsDestroy();
	},//Vc ends

	egnutconfig: function(vchost){ // nutanix starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').egnutconfiginter(vchost);
		Ext.getCmp('testConfigForm').body.scrollTo('top',250);
	},
	clearNut: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearNutInter();
	},
	updateNut: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateNutInter();
	},
	callNutDestroy: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').callNutInterDestroy();
	},//nutanix ends

	eghmcconfig: function(hmchost) {//Hmc 
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').eghmcsconfig(hmchost);
	},
	clearHmc: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearHmcs();
	},
	updateHmc: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateHmcs();
	},
	callHmcDestroy: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').callHmcsDestroy();
	},//Hmc ends

	egrhevconfig: function(rhevhost){ //Rhev starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').egrhevsconfig(rhevhost);
	},
	combosslrhev: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').combosslrhevs();
	},
	clearRhev: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearRhevs();
	},
	updateRhev: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateRhevs();
	},
	callRhevDestroy: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').callRhevsDestroy();
	}, //Rhev ends

	getPopUpView: function(paramName){
  	
		if (isPasswordProfileEnabled(publicJson.pwdParamSetList,paramName))
		{
			var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,paramName);
			if (!Ext.isEmpty(disabledPwdParam))
			{
				//Ext.getCmp(disabledPwdParam.trim()).setValue('none');
				me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
			}
		}
    
		if (paramName == 'user')
		{
			testViews.configMultiUsers();
		}
		else if (paramName == 'Connection_server_name')
		{
			testViews.configHorizonMultiUsers();
		}
		else if (paramName == 'name')
		{
			testViews.configurlnamepattern();
		}
		else if (paramName == 'admin_user')
		{
			testViews.vmgusers();
		}
		else if (paramName == 'Published_resources')
		{
			if (!Ext.isEmpty(testName) && testName.toLowerCase() == 'ctxxcxalogonsimtest')
			{
				testViews.configMultiSource();
			}
			else if (!Ext.isEmpty(testName) && testName.toLowerCase() == 'hrznlogonsimtest')
			{
				testViews.configMultiHLSFieldSet();
			}
		}

	},

	vmgusers: function() { //Vmg Users starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').vmgusers();
	},
	addVmgUsr: function() {
		addContact();
	},
	ClearConfigUsrs: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').ClearConfigUsr();
	},
	UpdateConfigUsrs:  function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').UpdateConfigUsr();
	}, //Vmg ends

	configMultiUsers: function(btn) { //MultipleUser Starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configMultiUser();
	},
	configHorizonMultiUsers: function(btn) { //MultipleUser Starts
		this.getController('DefaultTestConfiguration.controller.FunctionController').configHorizonMultiUsers();
	},
	addMultiUsr: function(btn) {
		addMultiUsrContact();
	},
	ClearMultiConfigUsrs: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').ClearMultiConfigUsr();
	},
	UpdateMultiConfigUsrs: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').UpdateMultiConfigUsr();
	}, //Multiple User ends
	configMultiSource: function(btn) { //Published resources starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').interConfigMultiSource();
	},
	addMultiSource: function(btn) {
		addMultiSourceContact();
	},
	ClearMultiConfigSource: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').interMultiSourceClr();
	},
	UpdateMultiConfigSource: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').interMultiSourceUpdate();
	}, //Published resources ends

	configCerdentialurl: function(btn){ // Credentials Url
		plusButtonClicked = 'true';
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configCerdentialurls();
	},
	addCredUrls: function(btn) {
		addCredUrlContact();
	},
	clearCredUrls: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearCredUrl(); 
	},
	updateCredUrls: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateCredUrl(); 
	},// credentials ends

	configurlnamepattern: function(btn) { //url name 
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configurlnamepatterns(); 
	},
	addUrlNames: function(btn) {
		addUrlNameContact(); 
	},
	clearUrlNames: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearUrlName(); 
	},
	updateUrlNames: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateUrlName(); 
	},//url name ends

	configWindowShared: function(btn) { //Window shared folders
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configWindowShareds(); 
	},
	addWinShared: function(btn) {
		addWinSharedContact();
	},
	clearWinShareds: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearWinShared(); 
	},
	updateWinShareds: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateWinShared(); 
	},//window shared ends

	configureWsdlUrl: function() {  //configure wsdl
		plusButtonClicked = 'true';
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configureWsdlUrls(); 
	},
	addWsdlUrl: function(btn) {
		addWsdlUrlContact();
	},
	clearWsdlUrls: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').clearWsdlUrl(); 
	},
	updateWsdlUrls: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateWsdlUrl(); 
	},//configure wsdl ends

	//dataform: function(paramName) { //Dataform starts
		//this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').dataform(paramName); 
	//},
	//applydata: function(){
		//this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').applydataa(); 
	//}, //Dataform ends

	configRunTimePattern: function(tempParaNme) { //Runtime starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configRunTimePatrn(tempParaNme); 
	},
	updateRuntimePatt: function() { 
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateRuntimePatern(); 
	}, //Runtime ends

	policyCreationMainPage: function() { //View Policy Starts
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').policyCreationPage(); 
	},
	configViewMainPolicy: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').configViewPolicy(); 
	},
	policyMainSearch: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').policySearch(); 
	},
	policyMainValidate: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').policyValidate(); 
	},
	openMainWindow: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').openWindow();  
	}, 
	windowCloseMainEvent: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').windowCloseEvent();  
	},
	check: function(fromComp) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').checkInter(fromComp); 
	},
	handleDeleteSelected: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').handleDeleteSelectedInter();  
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').handleEditIconClickInter(view, rowIndex, colIndex, column, e);  
	},
	handleViewIconClick: function(view, rowIndex, colIndex) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').handleViewIconClickInter(view, rowIndex, colIndex);  
	}, // View Policy Ends

	afterMainRender: function()
	{
		var urlVal = 'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?';
		if (!Ext.isEmpty(compType))
		{
			urlVal +='componentType='+encodeURIComponent(compType)+"&previousComponentType="+encodeURIComponent(compType);
		}

		if (!Ext.isEmpty(testName))
		{
			urlVal +='&testName='+encodeURIComponent(testName);
		}

		if (!Ext.isEmpty(testType))
		{
			urlVal +='&testType='+encodeURIComponent(testType)+"&previousTestType="+encodeURIComponent(testType);
		}
	
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('bottomToolBar').hide();
		}
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var isConfigSupported = publicJson['isConfigSupported'];
					var selectedCompType = publicJson['selectedCompType'];
					var selectedTestType = publicJson['selectedTestType'];

					if (isConfigSupported)
					{
						Ext.getCmp('testType').show();
						if (!Ext.isEmpty(selectedTestType))
						{
							Ext.getCmp('testType').setValue(selectedTestType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}
					else
					{
						Ext.getCmp('testType').hide();
					}
					Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
					Ext.getCmp('componentType').getStore().clearFilter(true);
					Ext.getCmp('componentType').getStore().loadRawData(publicJson['compTypeArr']);
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					if ( !Ext.isEmpty( selectedCompType ) )
					{
						Ext.getCmp('componentType').setValue(selectedCompType);
						Ext.getCmp('componentType').fireEvent('select', Ext.getCmp('componentType'));
					}
					else
					{
						Ext.getCmp('componentType').setValue(publicJson['compTypeArr'][0].valueField);
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}
				}
			}
		});
	},
	compTypeChangeEvent: function()
	{
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('bottomToolBar').hide();
		}

		availPolicies = "";

		//Ext.getCmp('linkContainer').hide();
		var isConfigSupported = publicJson['isConfigSupported'];
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testTypeVal = '';
		if (isConfigSupported)
		{
			testTypeVal = Ext.getCmp('testType').getValue();
		}
		if(Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal))
		{
			var previousTestType = '';
			if (!Ext.isEmpty(testType))
			{
				testTypeVal = testType;
				previousTestType = testType;
			}
			else 
			{
				previousTestType = publicJson['hiddenObj']['previousTestType'];
			}

			if (!Ext.isEmpty(compType) && !Ext.isEmpty(compTypeVal))
			{
				if (compType != compTypeVal)
				{
					previousTestType = '';
					testName = '';
				}
			}

			compType = compTypeVal;
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&testType='+encodeURIComponent(testTypeVal)+'&previousTestType='+encodeURIComponent(previousTestType),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
					Ext.getCmp('testName').getStore().removeAll();
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					var selectedTestName = publicJson['selectedTestName'];
					var selectedTestType = publicJson['selectedTestType'];
					var isConfigSupported = publicJson['isConfigSupported'];
					if ( !Ext.isEmpty( testName ) )
					{
						Ext.getCmp('testName').setValue(testName);
						Ext.getCmp('testName').fireEvent('select', Ext.getCmp('testName'));
					}
					else
					{
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}
					
					if (isConfigSupported)
					{
						if (!Ext.isEmpty(selectedTestType))
						{
							Ext.getCmp('testType').setValue(selectedTestType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}
				}
			});
		}
	},
	testNameChangeEvent: function()
	{
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('bottomToolBar').hide();
		}
		//Ext.getCmp('linkContainer').hide();
		var isConfigSupported = publicJson['isConfigSupported'];
		var previousComponentType = publicJson['hiddenObj']['previousComponentType'];
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testNameVal = Ext.getCmp('testName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		availPolicies = "";

		var urlValue  = 'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?';
		if(Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal) && Ext.isEmpty(testNameVal))
		{
			//if (isConfigSupported)
			//{
				//if (!Ext.isEmpty(testTypeVal) && Ext.isEmpty(testNameVal))
				//{
					//this.compTypeChangeEvent();
				//}
			//}
			//else
			//{
				//if (Ext.isEmpty(testNameVal))
				//{
					this.compTypeChangeEvent();
				//}
			//}
		}
		else
		{
			if (isConfigSupported)
			{
				var previousTestType = '';
				if (!Ext.isEmpty(testType))
				{
					testTypeVal = testType;
					previousTestType = testType;
				}
				else 
				{
					previousTestType = publicJson['hiddenObj']['previousTestType'];
				}
				urlValue += 'cType_HelpPage='+compTypeVal+'&componentType='+encodeURIComponent(compTypeVal)+'&testName='+encodeURIComponent(testNameVal)+'&testType='+encodeURIComponent(testTypeVal)+"&tName_HelpPage="+encodeURIComponent(testNameVal)+'&previousComponentType='+encodeURIComponent(previousComponentType)+'&previousTestType='+encodeURIComponent(previousTestType);
			}
			else
			{
				urlValue  += 'cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&testName='+encodeURIComponent(testNameVal)+"&tName_HelpPage="+encodeURIComponent(testNameVal)+'&previousComponentType='+encodeURIComponent(previousComponentType);
			}
			testName = testNameVal;
			Ext.Ajax.request({
				url:urlValue,
				method:'POST',
				scope:this,
				async:false,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var isConfigSupported = publicJson['isConfigSupported'];
					var isParameterModify = publicJson['isParameterModify'];
					var configuredTestTitle = publicJson['configuredTestTitle'];

					//if (isConfigSupported)
					//{
						//var selectedTestType = publicJson['selectedTestType'];
						//if ( !Ext.isEmpty( selectedTestType ) )
						//{
							//Ext.getCmp('testType').setValue(selectedTestType);
							//Ext.getCmp('testType').fireEvent('select', Ext.getCmp('testType'));
						//}
						//else
						//{
							//Ext.getCmp('testType').setValue('PerformanceTest');
						//}
						//Ext.getCmp('testType').show();
					//}
					//var viewExternalLink = publicJson['viewExternalLink'];
					//var externalPageLabel = publicJson['externalPageLabel'];
					
					//if (viewExternalLink)
					//{
						//Ext.getCmp('linkContainer').show();
						//Ext.getCmp('displayMsgLink').update(externalPageLabel);
					//}

					if ( !Ext.isEmpty( isParameterModify )  && !isParameterModify)
					{
						var msgContainer = {xtype:"container",id:"donwloadAgentMsg",html:'<div class="egFlexCenterByColumnWise" style="height:98%"><div class="iconInformation"></div><div class="commonErrorMsgText">The parameters of this test cannot be configured.</div></div>'};
						var paramsFieldSetContainer = Ext.getCmp('paramsContainer');
						paramsFieldSetContainer.removeAll();
						paramsFieldSetContainer.setTitle(configuredTestTitle);
						paramsFieldSetContainer.add(msgContainer);
						paramsFieldSetContainer.show();
					}
					else
					{
						me.gotoBuildContainer();
					}
				}
			});
		}
	},
	testTypeChangeEvent: function()
	{
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('bottomToolBar').hide();
		}
		//Ext.getCmp('linkContainer').hide();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testNameVal = Ext.getCmp('testName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		availPolicies = "";

		if(Ext.isEmpty(compTypeVal) && Ext.isEmpty(testNameVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal)  && Ext.isEmpty(testNameVal))
		{
			this.compTypeChangeEvent();
		}
		else
		{
			testType = testTypeVal;
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&testName='+encodeURIComponent(testNameVal)+'&testType='+encodeURIComponent(testTypeVal)+"&tName_HelpPage="+encodeURIComponent(testNameVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
					Ext.getCmp('testName').getStore().removeAll();
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					var selectedTestName = publicJson['selectedTestName'];
					var isConfigSupported = publicJson['isConfigSupported'];
					if ( !Ext.isEmpty( selectedTestName ) )
					{
						Ext.getCmp('testName').setValue(selectedTestName);
						Ext.getCmp('testName').fireEvent('select', Ext.getCmp('testName'));
					}
					else
					{
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}
				}
			});
		}
	},
	winServiceConfig_pr: function() {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').winServiceConfigs_pr();
	},
	updateService_pr: function(btn) {
		this.getController('DefaultTestConfiguration.controller.IntermediateDefaultController').updateServices_pr();
	},
	encodeFieldParams: function(thisForm){
		var encodeParams = "";
		var fieldsArr = thisForm.getFields().items;
		var encodeParamList = publicJson['encodeParamList'];
		for(var i in fieldsArr)
		{
			var fieldParamName = fieldsArr[i].name;
			var fieldParamValue = fieldsArr[i].value;
			if(Ext.isEmpty(fieldParamName) || fieldsArr[i].disabled || !me.isExistsParam(encodeParamList,fieldParamName))
			{
				continue;
			}
			Ext.getCmp(fieldsArr[i].id).submitValue = false;
			encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(fieldParamValue));
		}
		return encodeParams.startsWith('&')?encodeParams.substring(1):encodeParams;
	},
	isExistsParam: function(array, item) {
		var i, ln;
		for (i = 0, ln = array.length; i < ln; i++) {
			if (array[i] === item) {
				return true;
			}
		}
		return false;
	}
});


function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

function JMXParamDisable(obj){
	if (obj != null && obj != undefined)
	{
		obj.setDisabled(true);
		obj.hide();
	}
}

function JMXParamEnable(obj){
	if (obj != null && obj != undefined)
	{
		obj.setDisabled(false);
		//obj.reset();
		obj.show();
	}
}
function passwordParamEnabled (pwdParamSetList,checkParamSet,obj)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return false;
	}

	var result = false;
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				obj.reset();
				result = true;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				obj.reset();
				result = true;
				break;
			}
		}
	}
	return result;
}

function isPasswordProfileEnabled (pwdParamSetList,checkParamSet)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return false;
	}

	var result = false;
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = true;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = true;
				break;
			}
		}
	}
	return result;
}

function getPwdProfileParamName (pwdParamSetList,checkParamSet)
{
	var pwdProfile = '';
	if (!Ext.isEmpty(pwdParamSetList))
	{
		for (var strParamName in pwdParamSetList)
		{
			var strParamSetKey =  pwdParamSetList[strParamName];
			if (Ext.isEmpty(strParamSetKey))
			{
				continue;
			}

			if(strParamSetKey == checkParamSet)
			{
				pwdProfile = strParamName;
				break;
			}
		}
	}
	return pwdProfile;
}

function passwordParamDisabled (pwdParamSetList,checkParamSet)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return ;
	}

	var result = '';
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = strParamName;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = strParamName;
				break;
			}
		}
	}
	return result;
}

function setNoneForDependsParams(arrObj)
{
	if (!Ext.isEmpty(arrObj))
	{
		for (var a=0;a<arrObj.length;a++ )
		{
			var strParams = arrObj[a];
			var paramsObj = Ext.getCmp(strParams);
			if (!Ext.isEmpty(paramsObj))
			{
				if (strParams.toLowerCase() == 'inside_view_using')
				{
					continue;
				}
				else
				{
					paramsObj.setValue('None');
				}
			}
		}
	}
}

function showToPwdProfile(pwdProfileList,isShow) 
{
	if (!Ext.isEmpty(pwdProfileList))
	{

		for (var s=0;s<pwdProfileList.length;s++ )
		{
			var strshowParam = pwdProfileList[s];
			if (!Ext.isEmpty(strshowParam))
			{
				if (isShow)
				{
					Ext.getCmp(strshowParam).show();
					Ext.getCmp(strshowParam).setDisabled(false);
				}
				else
				{
					Ext.getCmp(strshowParam).setDisabled(true);
					Ext.getCmp(strshowParam).hide();
				}
			}
		}
	}
}

function isMultiUserParamExists (multiUserReadOnlyParam,searchParam)
{
	var isParamExists = false;
	if (!Ext.isEmpty(multiUserReadOnlyParam))
	{
		var multiUserParamsArray = multiUserReadOnlyParam.split(',');
		for (var mul=0;mul<multiUserParamsArray.length ;mul++ )
		{
			var strMultiUserParam = multiUserParamsArray[mul];
			if (strMultiUserParam.toLowerCase() == searchParam.toLowerCase())
			{
				isParamExists = true;
				break;
			}
		}
	}
	return isParamExists;
}

function checkParamIsUserField(paramName)
{
	var isUserNameParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isUserNameParamExists;
	}

	if (paramName.toLowerCase() == 'user' ||  
		paramName.toLowerCase() == 'username' ||
		paramName.toLowerCase() == 'user_name' ||
		paramName.toLowerCase() == 'user' ||
		paramName.toLowerCase() == 'username' ||
		paramName.toLowerCase() == 'user_name' ||
		paramName.toLowerCase() == 'exchange_sender' ||
		paramName.toLowerCase() == 'sender' ||
		paramName.toLowerCase() == 'o365_sender' ||
		paramName.toLowerCase() == 'exchange_receiver' ||
		paramName.toLowerCase() == 'o365_receiver' ||
		paramName.toLowerCase() == 'receiver' ||
		paramName.toLowerCase().indexOf('emailid') != -1 ||
		paramName.toLowerCase().indexOf('user') != -1)
	{
		isUserNameParamExists = true;
	}
	return isUserNameParamExists;
}

function checkParamIsDomainField(paramName)
{
	var isDomainParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isDomainParamExists;
	}

	if (paramName.toLowerCase() == 'domain' ||  
		paramName.toLowerCase() == 'domainname' ||
		paramName.toLowerCase() == 'domain_name' ||
		paramName.toLowerCase().endsWith('domain') ||
		paramName.toLowerCase().endsWith('domain_name') ||
		paramName.toLowerCase().endsWith('domainname'))
	{
		isDomainParamExists = true;
	}
	return isDomainParamExists;
}

function checkParamIsPasswordField(paramName)
{
	var isPasswordParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isPasswordParamExists;
	}

	if (paramName.toLowerCase() == 'password' ||  
		paramName.toLowerCase().endsWith('password') ||
		paramName.toLowerCase().indexOf('pass') != -1 ||
		paramName.toLowerCase().indexOf('password') != -1)
	{
		isPasswordParamExists = true;
	}
	return isPasswordParamExists;
}



