<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the eG REST API list data for REST CLient node in Manager Settings tree.
*	ini File : eg_api.ini;
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	IniFile apiIniObj = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_api.ini");
	String managerUrl = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String baseUrl=managerUrl+"/api/eg/";
	String apiDescriptor="";
	
	JSONObject rootJson = new JSONObject();
	JSONArray apiTypeArr=new JSONArray();
	JSONArray apiNamesArr=new JSONArray();
	rootJson.put("success","true");

	String selectedApiType=request.getParameter("selectedApiType");
	String bulkOperation=request.getParameter("bulkOperation");
	String selectedApiName=request.getParameter("selectedApi");	

	if(bulkOperation!=null && bulkOperation.trim().length()>0 && bulkOperation.equalsIgnoreCase("yes"))
	{
		bulkOperation="yes";
	}

	String apiType= apiIniObj.getValue("API_PATH","restApiPath");
	StringTokenizer stkApiType = new StringTokenizer(apiType,",");
	while(stkApiType.hasMoreTokens())
	{
		String strApiType=stkApiType.nextToken().trim();
		JSONObject apiTypeJson = new JSONObject();
		String boxlabel=strApiType;
		if(strApiType.equalsIgnoreCase("miscservice"))
		{
			boxlabel="Miscellaneous";
		}
		boxlabel=boxlabel.substring(0, 1).toUpperCase()+boxlabel.substring(1);

		if(strApiType.equalsIgnoreCase(selectedApiType))
		{
			apiTypeJson.put("checked",true);			
		}
		apiTypeJson.put("boxLabel",boxlabel);
		apiTypeJson.put("inputValue",strApiType);
		apiTypeJson.put("name","apiType");
		apiTypeArr.add(apiTypeJson);
	}
	baseUrl+=selectedApiType;
	
	if(bulkOperation!=null && bulkOperation.trim().length()>0 && bulkOperation.equalsIgnoreCase("yes"))
	{
		apiDescriptor=selectedApiType+"_bulk_API_description";
		selectedApiType+="/bulk";
	}
	else
	{
		apiDescriptor=selectedApiType+"_API_description";
	}
	apiNamesArr=getApiListForApiType(selectedApiType,baseUrl,apiDescriptor);
	rootJson.put("selectedApiType",selectedApiType);
	if(selectedApiName==null || selectedApiName.trim().length()==0)
	{		
		rootJson.put("apiList",apiNamesArr);
		rootJson.put("apiType",apiTypeArr);
	}
	else
	{
		rootJson = getParamsListForApi(selectedApiType,selectedApiName);
		String showPW = "no";
		registry = UserRegistry.getInstance();
		session = request.getSession(true);
		User user = null;
		if(session != null)
		{
			user = registry.getUser(session.getId());
			String userName = user.getLoginID();
			if(userName.startsWith("samlsso/"))
			{
				showPW = "no";
			}
			else if(userName.indexOf("/") != -1)
			{
				showPW = "yes";
			}
		}
		rootJson.put("showPW",showPW);
	}

	out.println(rootJson);
%>
<%!
	private JSONArray getApiListForApiType(String selectedApiType, String apiBaseUrl,String apiDescriptionSub)
	{
		IniFile apiIniObj = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_api.ini");
		JSONArray apiJsonArr=new JSONArray();
		
		// to get api's name  list and endpoint url
		String apiEndpointUrl="";		
		String apiNames= apiIniObj.getValue("ENDPOINTS",selectedApiType);
		StringTokenizer stkApiNames = new StringTokenizer(apiNames,",");
		JSONObject tempObj=new JSONObject();
		tempObj.put("displayField","Select API Name");
		tempObj.put("valueField","-1");
		tempObj.put("description","API Description");
		apiJsonArr.add(tempObj);
		while(stkApiNames.hasMoreTokens())
		{
			
			String strApiName=stkApiNames.nextToken().trim();
			apiEndpointUrl=apiBaseUrl+"/"+strApiName;	
			String apiDescription= apiIniObj.getValue(apiDescriptionSub,strApiName);

			String strApiDisplayName=strApiName;
			if(strApiDisplayName.contains("/"))
			{
				strApiDisplayName=strApiDisplayName.replace("/","By");
			}
			
			JSONObject apiNameJson=new JSONObject();
			apiNameJson.put("displayField",strApiDisplayName);
			apiNameJson.put("valueField",strApiName);
			apiNameJson.put("endpointUrl",apiEndpointUrl);
			apiNameJson.put("description",apiDescription);
			apiJsonArr.add(apiNameJson);
		}
		return apiJsonArr;
	}
	private JSONObject getParamsListForApi(String selectedApiType,String selectedApiName)
	{
		IniFile apiIniObj = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_api.ini");
		JSONObject apiParamsJson=new JSONObject();
		JSONArray paramsJsonArr = new JSONArray();
		if(selectedApiName!=null && selectedApiName.trim().length()>0)
		{			
			String paramsRequired="yes";
			JSONObject paramsJson = new JSONObject();
			JSONObject tempObj=new JSONObject();
			tempObj.put("displayField","Select Parameter");
			tempObj.put("valueField","-1");
			
			Object[] keys= apiIniObj.getVariables(selectedApiName);
			if(keys.length>0)
			{
				paramsJsonArr.add(tempObj);
				for (int i=0; i<keys.length; i++)
				{
					String paramValueType="textfield";
					String key = (String)keys[i];

					if(selectedApiType.equalsIgnoreCase("analytics"))
					{
						if(key.equalsIgnoreCase("componentName") && selectedApiName.equalsIgnoreCase("getLiveMeasure"))
						{
							paramValueType="multiselect_combo";
						}
						else if(key.equalsIgnoreCase("filterValues") && selectedApiName.equalsIgnoreCase("getAlerts"))
						{
							paramValueType="multiselect_combo";
						}
						else if(key.equalsIgnoreCase("componentList"))
						{
							paramValueType="multiselect_combo";
						}
						else if((key.equalsIgnoreCase("test") || key.equalsIgnoreCase("info") ||  key.equalsIgnoreCase("measure")) && (selectedApiName.equalsIgnoreCase("getTestData")  || selectedApiName.equalsIgnoreCase("getTrendData") || selectedApiName.equalsIgnoreCase("getThresholdData")))
						{
							paramValueType="textfield";
						}
						else if(key.equalsIgnoreCase("componentType") || key.equalsIgnoreCase("componentName")  || key.equalsIgnoreCase("measure") || key.equalsIgnoreCase("test") || key.equalsIgnoreCase("info") || key.equalsIgnoreCase("zone") || key.equalsIgnoreCase("service") || key.equalsIgnoreCase("segment") || key.equalsIgnoreCase("filterValues") || key.equalsIgnoreCase("vmName"))
						{
							paramValueType="single_combo";
						}
						else if(key.equalsIgnoreCase("timeline"))
						{
							paramValueType="timeline";
						}
						
					}
					paramsJson=new JSONObject();
					String defaultParam = apiIniObj.getValue("DefaultParamValues",selectedApiName+":"+key);
					if(defaultParam!=null && defaultParam.trim().length()>0)
					{
						paramValueType="single_combo";
						paramsJson.put("defaultValue","yes");
						String include = apiIniObj.getValue("DefaultParamValues",selectedApiName+":"+key+":include");
						if(include!=null && include.trim().length()>0 && include.equalsIgnoreCase("yes"))
						{
							include="yes";
						}
						else
						{
							include="no";
						}
						
						paramsJson.put("include",include);
						JSONArray paramValueJsonArr=new JSONArray();
						StringTokenizer stkParamValues = new StringTokenizer(defaultParam,",");
						while(stkParamValues.hasMoreTokens())
						{
							String strParamValue=stkParamValues.nextToken().trim();
							String strDispField=strParamValue;
							JSONObject paramValueJson=new JSONObject();
							
							if(strParamValue.equalsIgnoreCase("asc") && (selectedApiName.equalsIgnoreCase("getTestData") || selectedApiName.equalsIgnoreCase("getTrendData") || selectedApiName.equalsIgnoreCase("getThresholdData")))
							{
								strDispField="Ascending";								
							}
							else if(strParamValue.equalsIgnoreCase("desc") && (selectedApiName.equalsIgnoreCase("getTestData") || selectedApiName.equalsIgnoreCase("getTrendData") || selectedApiName.equalsIgnoreCase("getThresholdData")))
							{
								strDispField="Descending";
							}
							paramValueJson.put("displayField",strDispField);
							paramValueJson.put("valueField",strParamValue);
							paramValueJsonArr.add(paramValueJson);
						}
						paramsJson.put("paramValueList",paramValueJsonArr);
					}
					else
					{
						paramsJson.put("defaultValue","no");
					}
					
					paramsJson.put("paramValueType",paramValueType);
					paramsJson.put("displayField",key);
					paramsJson.put("valueField",key);
					paramsJsonArr.add(paramsJson);
				}
			}
			else
			{
				paramsRequired="no";
			}
			apiParamsJson.put("paramsRequired",paramsRequired);
			apiParamsJson.put("apiParamsList",paramsJsonArr);			
		}
		return apiParamsJson;
	}
%>