Ext.define('Ext.grid.plugin.CellEditing', {
    extend: 'Ext.grid.plugin.CellEditing',
    
    constructor: function() {
        this.callParent(arguments);
        this.toReselectAfterEdit = [];
    },
   
    showEditor: function(ed, context, value) {
        var me = this,
            record = context.record,
            columnHeader = context.column,
            sm = me.grid.getSelectionModel(),
            selection = sm.getCurrentPosition();

        if (sm.isSelected(context.record)) this.toReselectAfterEdit.push(context.record);
        me.context = context;
        me.setActiveEditor(ed);
        me.setActiveRecord(record);
        me.setActiveColumn(columnHeader);
        ed.startEdit(me.getCell(record, columnHeader), value);
        me.editing = true;
        me.scroll = me.view.el.getScroll();
    },
    onEditComplete: function() {
        this.callParent(arguments);
        this.reselectRowsThatShouldNeverHaveBeenDeselected();
    },
    
    reselectRowsThatShouldNeverHaveBeenDeselected: function() {
        if (this.toReselectAfterEdit) {
            var record;
            while (record = this.toReselectAfterEdit.pop()) {
                this.grid.getSelectionModel().deselect(record);
                this.grid.getSelectionModel().select(record, true);
            }
        }
    }
});

Ext.define('LimitedAdminHome.view.EgMSAzureSubscriptionView', {
	extend:'Ext.form.Panel',
	alias: 'widget.EgMSAzureSubscriptionView',
	id: 'EgMSAzureSubscriptionView',
	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
		'utilities.innerScrollContainer'
	],
	layout : {
		type: 'vbox',
		align : 'stretch',
		pack : 'start'
	},
	flex: 1,
	items: [
		{
			xtype: 'container',
			id: 'pageMsgRecommendation',
			html: '<div class="aPanelRegularText" style="margin:15px 10px 3px 10px;">Subscription IDs associated with this tenant.</div>'
		},
		{
			xtype: 'customgrid',
			title: msAzureDesc10,
			ui: 'aGridPanel withHeader',
			border:true,
			id: 'azureScriptionGrid',
			margin: 10,
			ptype: 'cellediting',
			flex: 1,
			autoScroll:true,
			queryMode: 'local',
			viewConfig: {
				deferEmptyText: false
			},
			emptyText: '<table width="100%"><tr><td align="center" valign="middle"><div class="gen-info size32 color-info" style="margin:12% auto 0% auto"></div>'+msAzureDesc8+'</td></tr></table>',
			selModel: {
				checkOnly: 'true',
				allowDeselect: true,
				mode: 'SIMPLE',
				selType: 'checkboxmodel',
				toggleOnClick: true
			},
			plugins: [
				Ext.create('Ext.grid.plugin.CellEditing', {
					clicksToEdit: 1,
					pluginId: 'subscriptionNickNames',
					id: 'cellEditingPlugin'
				})
			],
			store: new Ext.data.Store({
				fields : ['subscription', 'nickname'],
				data : []
			}),
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: msAzrBtnLabel2,
						dataIndex: 'subscription',
						flex: 1,
						id: 'subscription'
					},
					{
						xtype: 'gridcolumn',
						text: msAzrBtnLabel3,
						dataIndex: 'nickname',
						flex: 1,
						id: 'nickname',
						editor: {
							xtype: 'textfield',
							listeners:{
								afterrender:function(textfield)
								{
									var ed = Ext.getCmp('azureScriptionGrid').getPlugin('subscriptionNickNames').getActiveEditor();
									if (ed) {
										textfield.el.on('mouseout',function(){
											if (ed.field) {
												if (ed.field.triggerBlur) {
													ed.field.triggerBlur();
												} else {
													ed.field.blur();
												}
											}
										})
										textfield.el.on('mouseover',function(){
											if (ed.field) {
												ed.realign();
											}
										})
									}
								}
							},
							minValue: 1,
							cls: 'aTextbox',
							maxWidth: 300,
							width: 300,
							margin: '3px 10px 0px 5px',
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowBlank: false,
							maxLength: 32,
							enforceMaxLength: true
						}
					}
				]
			},
			listeners: {
				beforeselect: function(selModel, record, index) 
				{
					if (record.get('isDisabled') == 'true') {
						return false;
					}
				},
				rowclick: function(in_this, rowIndex, e) 
				{
					var record = in_this.getStore().getAt(rowIndex);
					if (record.get('isDisabled') == 'true') {
						in_this.getSelectionModel().deselectRow(rowIndex);
					}
				},
				boxready:function() 
				{
					var monitors = Ext.getCmp('card-0').monitors;
					fromAction = "monitors_"+monitors;
					appCnt.loadMonitorsData();
				},
				select: function(obj, record, index, eOpts)
				{
					if (!isElementExistsInArray(selectedAzrSubscrptRecordArr, record))
					{
						selectedAzrSubscrptRecordArr.push(record);
					}
				},
				deselect: function(obj, record, index, eOpts)
				{
					selectedAzrSubscrptRecordArr = selectedAzrSubscrptRecordArr.filter(function(value, index, arr) {
						if (value.data.subscription != record.data.subscription) 
						{
							return true;
						} 
						else 
						{
							return false;
						}
					});
				}
			},
			tools: [
				{
					xtype: 'trigger',
					cls:'aSearch',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					id: 'subscriptionViewGridSearch',
					name: 'subscriptionViewGridSearch',
					emptyText: compTypeSearchLabel,
					margin: '0 10 0 10',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appCnt.gotoSubscriptionViewGridSearch();
					},
					listeners : {
						change : function()
						{
							appCnt.gotoSubscriptionViewGridSearch();
						}
					}
				}
			]
		}
	],
	dockedItems:[
		{
			xtype: 'toolbar',
			dock: 'bottom',
			padding: 10,
			id : 'msAzureDockId',
			ui:'plain',
			layout:{pack:'center'},
			items: [
				{
					xtype: 'button',
					ui:'aButtonSmall',
					text: msAzrBtnLabel5,
					id: 'updateBtn',
					listeners: {
						click: function()
						{
							appCnt.addMSAzureComponents();
						}
					}
				}
			]
		}
	]
});



