<%
/*******************************************************************************
*   Name						:getAnalysisDataJson.jsp
*   Purpose						:To collect maintenance Data for Analysis
*   Version						:4.3
*   Created						:15.09.2008
*   Author						:Antony & Team
*   Design Changes				:Jaiwin
*   update						:27.12.2014
*******************************************************************************/
%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "java.util.*" %>
<%@	page import="com.eg.*"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%@	page import="com.egurkha.User"%>

<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String  option=request.getParameter("option");
	String element=request.getParameter("element");
	element=StringUtils.decodeSecurityChar(element);
	String testElement=request.getParameter("testElement");
	String descElement=request.getParameter("descElement");
	descElement=StringUtils.decodeSecurityChar(descElement);
	String day=request.getParameter("day");
	String dateOfMonth=request.getParameter("dateOfMonth");
	String startDate=request.getParameter("startDate");
	String startHr=request.getParameter("startHr");
	String endDate=request.getParameter("endDate");
	String endHr=request.getParameter("endHr");
	String timePeriod=request.getParameter("timePeriod");
	String compName="";	
	if(session.getAttribute("paramForAnalysis")!=null) 
	{
		session.removeAttribute("paramForAnalysis");
	}
	EgDateInfo date = new EgDateInfo();
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/MaintenanceAnalysis/data/egPrintMaintenanceAnalysisData.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage";
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDtFormat = _user.getUserDateFormat();
	if(userDtFormat != null && userDtFormat.length() > 0)
	{
		if(userDtFormat.equalsIgnoreCase("default"))
			userDtFormat = currentDateFormat;
	}
	EgMaintenanceUtility egM=new EgMaintenanceUtility(sessionID,u_rs);
	egM.setUserDateFormat(userDtFormat);
	session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Maintenance_policy");
	//session.setAttribute("paramForAnalysis",tmp);
	session.setAttribute("paramforTab",request.getQueryString());
	String query="option="+option+"&element="+element+"&testElement="+testElement;
	Hashtable  hostsUnderMaintenance=new Hashtable();
	Hashtable policyTimeline = new Hashtable();
	Hashtable  componentsUnderMaintenance=new Hashtable();
	Hashtable  testsUnderMaintenance=new Hashtable();
	Hashtable  hostTestsUnderMaintenance=new Hashtable();
	Hashtable  componentTestsUnderMaintenance=new Hashtable();
	//*******for Descriptor and descriptors for component*********
	Hashtable descriptorUnderMaintenance=new Hashtable();
	Hashtable componentDescriptorUnderMaintenance=new Hashtable();
	Hashtable wildcardUnderMaintenance=new Hashtable();
	//************************************************************
	Hashtable  analysisData=new Hashtable();
	Hashtable tmp_analysisData = new Hashtable();
	String dispTitle="";
	String columnName="";
	Vector data=null;
	boolean isData=false;
	int dataSize=0;
	session.removeAttribute("list");
	List csvList = new LinkedList();
	ArrayList pdfHostName = new ArrayList();
	List serverkeys = new ArrayList();
	EgTable egTable = new EgTable();
	ArrayList aListPdfData = new ArrayList();
	EgPdfData pdfData = new EgPdfData();
	ArrayList aListColumnNames = new ArrayList();
	ArrayList userColumnNames = new ArrayList();
	ArrayList aListFieldWidth = new ArrayList();
	EgTableAttributes egTableAttributes = new EgTableAttributes();
	EgReportAttributes reportAttributes = new EgReportAttributes();
	reportAttributes.setMainTitle("Maintenance Analysis Report");
	String txt_Active=_mapping.getTextDescription("admin.mpolicy.Active");
	String txt_Deactive=_mapping.getTextDescription("admin.mpolicy.Inactive");

	
	String userID = _user.getLoginID();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,userID);
	boolean isLimitedAdmin = !roleInfo.hasAllComponentAccess();
	String elementDisplay = element; // Limited admin
	elementDisplay = egM.getPolicyDisplayName(elementDisplay,!roleInfo.hasAllComponentAccess());
	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyleDblSingl="";
	JSONObject rootJson=new JSONObject();
	//JSONObject screenLabels=new JSONObject();
	JSONArray mainsummary1=new JSONArray();
	
	if ( dbInfo.doubleByteEnabled )
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}
	if(option!=null && option.equals("All")) 
	{
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenance("All Hosts");
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenance("All Components");
		testsUnderMaintenance=egM.getAllTestsUnderMaintenance("All Tests");
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenance("All Tests");
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenance("All Tests");
		/*****************************************/
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenance("All Descriptors");
		componentDescriptorUnderMaintenance=egM.getAllComponentDescriptorsUnderMaintenance("All Descriptor Comp");
		wildcardUnderMaintenance=egM.getWildCardUnderMaintenance();
		/*****************************************/

		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		/*******************************************/
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
		data.add(wildcardUnderMaintenance);
		/*******************************************/
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0 || wildcardUnderMaintenance.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Component")) 
	{
		analysisData=egM.getAllComponentsUnderMaintenance(element);		
		dispTitle="Components Under Maintenance";
		columnName="Component Name";
	}
	else if(option!=null && option.equals("Host")) 
	{
		analysisData=egM.getAllHostsUnderMaintenance(element);		
		dispTitle="Hosts Under Maintenance";
		columnName="Host Name";
	}
	else if(option!=null && option.equals("Test")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllTestsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllTestsUnderMaintenance("#"+element);
		}
		dispTitle="Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test For Host")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllHostTestsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllHostTestsUnderMaintenance(testElement+"#"+element);
			//analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Host Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test For Component")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllComponentTestsUnderMaintenance(element);
		}
		else
		{
			if(testElement!=null && testElement.indexOf(":")==-1)
			{
				testElement=testElement+":NULL";
			}
			analysisData=egM.getAllComponentTestsUnderMaintenance(testElement+"#"+element);
			//analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Component Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Policy")) 
	{		
		policyTimeline = (Hashtable)egM.getPolicyTimelines(element);
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenanceForPolicy(element);
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenanceForPolicy(element);
		testsUnderMaintenance=egM.getAllTestsUnderMaintenanceForPolicy(element);
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenanceForPolicy(element);
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenanceForPolicy(element);
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenanceForPolicy(element);
		componentDescriptorUnderMaintenance=egM.getAllDescriptorForComponentUnderMaintenanceForPolicy(element);
		wildcardUnderMaintenance=egM.getAllWildCardUnderMaintenanceForPolicy(element);
		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
		data.add(wildcardUnderMaintenance);
			
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0 || wildcardUnderMaintenance.size()>0)
			isData=true;
	}
	else    if(option!=null && option.equals("Time Constraints")) 
	{
		data=new Vector();
		if(element!=null&& element.equals("FDM")) 
		{
			data=egM.getMaintenanceDetailsForFDM();			
		}
		else if(element!=null&& element.equals("LDM")) 
		{
			data=egM.getMaintenanceDetailsForLDM();
		}
		else if(element!=null&& element.equals("*")) 
		{
			data=egM.getMaintenanceDetailsForDaily();			
		}
		else if(element!=null&& element.equals("Day of Week")) 
		{
			data=egM.getMaintenanceDetailsForDay(day);
		} 
		else if(element!=null&& element.equals("Date of Month")) 
		{
			data=egM.getMaintenanceDetailsForDateOfMonth(dateOfMonth);
		}
		else if(element!=null&& element.equals("Date")) 
		{
			data=egM.getMaintenanceDetailsForTimePeriod(startDate,startHr,endDate,endHr);
		}
		if(data!=null && data.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Descriptor"))
	{
		if(element!=null && element.equals("All Descriptors"))
		{
			analysisData=egM.getAllDescriptorsUnderMaintenance(element);
		}
		else
		{
			analysisData=egM.getAllDescriptorsUnderMaintenance("#"+element);
		}
		dispTitle="Descriptors Under Maintenance";
		columnName="Descriptors";
	}
	else if(option!=null && option.equals("Descriptor For Component"))
	{
		if(element!=null && element.equals("All Descriptor Comp"))
		{
			analysisData=egM.getAllComponentDescriptorsUnderMaintenance(element);
		}
		else
		{	
			EgSpecsInfo specs = new EgSpecsInfo("manager");
			String testName = descElement.substring(0,descElement.indexOf(":"));
			boolean isPortRelevantForTest=specs.isPortRelevantForTest(testName);
			String Discomp=element;
			if(!isPortRelevantForTest && (Discomp!=null && !Discomp.equals("")))
			{			
				Discomp = Discomp.substring(0,Discomp.lastIndexOf(":"))+":NULL";
			}
			analysisData=egM.getAllComponentDescriptorsUnderMaintenance(Discomp+"#"+descElement);
			//analysisData=egM.getMaintenanceInfoForElementDesc(element,descElement);
		}
		dispTitle="Descriptor For Component Under Maintenance";
		columnName="Descriptors";
	}
	else if(option!=null && option.equals("Wild Card"))
	{
		if(element!=null && element.equalsIgnoreCase("All Pattern"))
		{
			analysisData=egM.getWildCardUnderMaintenance();
		}
		else
		{
			analysisData=egM.getAllWildCardUnderMaintenance(element);		
		}
		dispTitle="Server/VM/Desktop";
		columnName="Server/VM/Desktop";
	}

	Hashtable HostData=new Hashtable();
	Hashtable CompData=new Hashtable();
	Hashtable TestData=new Hashtable();
	Hashtable HostTestData=new Hashtable();
	Hashtable CompTestData=new Hashtable();
	/**************************************/
	Hashtable descriptorData=new Hashtable();
	Hashtable compDescData=new Hashtable();
	Hashtable wildcardData=new Hashtable();
	/**************************************/
	int noOfElemenstAssociated=0;
	String sumelement="";
	if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("fdm"))
	{
		sumelement="First Day of the Month";
	}
	else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("ldm"))
	{
		sumelement="Last Day of the Month";
	}
	else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("*"))
	{
		sumelement="Daily";
	}
	else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
	{
		startDate=StringUtils.replace(startDate,',',' ');
		endDate=StringUtils.replace(endDate,',',' ');
		sumelement="From " +startDate+" To "+ endDate;
	}
	else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("day of week"))
	{
		sumelement=egM.DayForDescription(day);
	}
	else
	{
		sumelement=elementDisplay;
	}
	String elementForTitle=sumelement;
	if(data!=null && data.size()>0) 
	{
		HostData=(Hashtable)data.get(0);
		CompData=(Hashtable)data.get(1);
		TestData=(Hashtable)data.get(2);
		HostTestData=(Hashtable)data.get(3);
		CompTestData=(Hashtable)data.get(4);
		/********************************/
		descriptorData=(Hashtable)data.get(5);
		compDescData=(Hashtable)data.get(6);
		wildcardData=(Hashtable)data.get(7);
		/********************************/
		if(option!=null && option.equals("Policy")) 
		{
			ArrayList HostList = (ArrayList)HostData.get(element);
			if(HostList!=null && HostList.size()>0)
				noOfElemenstAssociated++;
			ArrayList compList = (ArrayList)CompData.get(element);
			if(compList!=null && compList.size()>0)
				noOfElemenstAssociated++;
			ArrayList testList = (ArrayList)TestData.get(element);
			if(testList!=null && testList.size()>0)
				noOfElemenstAssociated++;
			ArrayList HostTestList = (ArrayList)HostTestData.get(element);
			if(HostTestList!=null && HostTestList.size()>0)
				noOfElemenstAssociated++;
			ArrayList compTestList = (ArrayList)CompTestData.get(element);
			if(compTestList!=null && compTestList.size()>0)
				noOfElemenstAssociated++;
			ArrayList descList = (ArrayList)descriptorData.get(element);
			if(descList!=null && descList.size()>0)
				noOfElemenstAssociated++;
			ArrayList compDescList = (ArrayList)compDescData.get(element);
			if(compDescList!=null && compDescList.size()>0)
				noOfElemenstAssociated++;
			ArrayList wildCardList = (ArrayList)wildcardData.get(element);
			if(wildCardList!=null && wildCardList.size()>0)
				noOfElemenstAssociated++;
		}
		else
		{
			if(HostData!=null && HostData.size()>0)
				noOfElemenstAssociated++;

			if(CompData!=null && CompData.size()>0)
				noOfElemenstAssociated++;

			if(TestData!=null && TestData.size()>0)
				noOfElemenstAssociated++;

			if(HostTestData!=null && HostTestData.size()>0)
				noOfElemenstAssociated++;

			if(CompTestData!=null && CompTestData.size()>0)
				noOfElemenstAssociated++;
			/*************************************************/
			if(descriptorData!=null && descriptorData.size()>0)
				noOfElemenstAssociated++;

			if(compDescData!=null && compDescData.size()>0)
				noOfElemenstAssociated++;

			if(wildcardData!=null && wildcardData.size()>0)
				noOfElemenstAssociated++;
			/*************************************************/
		}
	}
	else if(analysisData==null &&  analysisData.size()>0)
	{
		if(option!=null && option.equalsIgnoreCase("Host"))
		{
			HostData=analysisData;
		}
		else if(option!=null && option.equalsIgnoreCase("Component"))
		{
			CompData=analysisData;
		}
		else if(option!=null && option.equalsIgnoreCase("Test"))
		{
			TestData=analysisData;
			elementForTitle=_mapping.getTestDescription(element);
		}
		else if(option!=null && option.equalsIgnoreCase("Test For Host"))
		{
			HostTestData=analysisData;
			elementForTitle=_mapping.getTestDescription(element);
		}
		else if(option!=null && option.equalsIgnoreCase("Test For Component"))
		{
			CompTestData=analysisData;
			elementForTitle=_mapping.getTestDescription(element);
		}
		else if(option!=null && option.equalsIgnoreCase("Descriptor"))
		{
			descriptorData=analysisData;
			elementForTitle=_mapping.getTestDescription(element);
		}
		else if(option!=null && option.equalsIgnoreCase("Descriptor For Component"))
		{
			compDescData=analysisData;
			elementForTitle=_mapping.getTestDescription(element);
		}
		else if(option!=null && option.equalsIgnoreCase("Wild Card"))
		{
			wildcardData=analysisData;
			//elementForTitle=_mapping.getTestDescription(element);
		}
	}

	//For CSV code Starts here
	Vector csvTitle = new Vector();
	csvList.add(_mapping.getTextDescription("admin.mpolicy.Maintenance Analysis Report"));
	if(option!=null && !option.equals("All") && !option.equals("Time Constraints") && !option.equals("Policy")) 
	{
		Vector tmpHost = new Vector();
		String reportSubTitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Details for ");
		String dispStr = "";
		String columName="";
		//String tmpData="";
		ArrayList aListSummaryNames = new ArrayList();
		aListSummaryNames.add("C1");
		aListSummaryNames.add("C2");
		userColumnNames = new ArrayList();
		aListFieldWidth = new ArrayList();
		aListFieldWidth.add("200");
		aListFieldWidth.add("300");

		EgTable summaryTable = new EgTable();
		ArrayList summaryColumnNames = new ArrayList();
		summaryColumnNames.add(_mapping.getTextDescription("admin.mpolicy.Elements Under Maintenance"));
		summaryColumnNames.add(_mapping.getTextDescription("admin.mpolicy.Count"));
		EgTableAttributes tableAttributes = new EgTableAttributes();
		tableAttributes.setStartX(0);
		if((element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors")  || element.equals("All Patterns"))))
		{
			tableAttributes.setColumnNames(summaryColumnNames);
			tableAttributes.setFieldWidths(aListFieldWidth);
		}
		elementForTitle=element;
		String summaryTableTitle = "";
		if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
		{
			summaryTableTitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary ");
		}
		else
		{
			summaryTableTitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary for ");
		}
		if(elementForTitle==null)
		{
			summaryTableTitle += " "+_mapping.getTextDescription("admin.mpolicy.All Elements");
		}
		else
		{
			if(option.equalsIgnoreCase("Test") || option.equals("Test For Host") || option.equals("Test For Component"))
			{
				elementForTitle=_mapping.getTestDescription(elementForTitle);
			}

			summaryTableTitle += " "+elementForTitle;
		}
		if(option.equals("Component") || option.equals("Test") || option.equals("Host") || option.equals("Descriptor") || option.equals("Descriptor For Component") || option.equals("Wild Card"))
		{
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");

			columName = option + " Name";
			if(element.equals("All Components") || element.equals("All Hosts") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp") || element.equals("All Patterns"))
			{
				if(element.equals("All Tests"))
				{
					reportSubTitle=reportSubTitle+" "+option+" - "+_mapping.getTestDescription(element);
				}
				else
				{
					reportSubTitle=reportSubTitle+" "+option+" - "+element;
				}
				if(element!=null && element.equals("All Descriptor Comp") || element.equals("All Descriptors"))
				{
					columName = "Descriptors";
				}
			}
			else
			{
				String dispelem=element;				
				if(dispelem.endsWith(":NULL"))
				{
					dispelem= dispelem.substring(0,dispelem.indexOf(":NULL"));
				}
				String displayName=dispelem;
				if(option!=null && option.equals("Test"))
				{
					displayName=_mapping.getTestDescription(element);
				}
				if(option!=null && option.equals("Descriptor"))
				{
					displayName=dispelem.substring(dispelem.indexOf(":")+1);
				}
				if(option!=null && option.equals("Host"))
				{
					displayName=_mapping.getTestDescription(element);
				}
				if(option!=null && option.equals("Component"))
				{
					displayName=_mapping.getTestDescription(dispelem);
				}
				reportSubTitle=reportSubTitle+" "+option+" - "+displayName;
				if(option!=null && option.equals("Descriptor"))
				{
					columName = "Descriptors";
				}
				if(option!=null && option.equals("Descriptor For Component") && !element.equals("All Descriptor Comp"))
				{
					columName="Descriptor For Component";
				}
				if(option!=null && option.equals("Host") && !element.equals("All Hosts"))
				{
					columName="Host";
				}
				if(option!=null && option.equals("Test") && !element.equals("All Tests"))
				{
					columName="Test";
				}
				if(option!=null && option.equals("Test For Component") && !element.equals("All Tests"))
				{
					columName="Test For Component";
				}
				if(option!=null && option.equals("Wild Card") && !element.equals("All Patterns"))
				{
					columName="Server/VM/Desktop";
				}
			}
			if(element!=null && !element.startsWith("All"))
				userColumnNames.add(_mapping.getTextDescription("admin.mpolicy."+columName));
			dispStr = option;

			Vector csvSummaryTitle = new Vector();
			if((element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp") || element.equals("All Patterns"))))
			{
				csvSummaryTitle.add(summaryTableTitle);
			}
			String summaryColTitle = "";
			summaryColTitle = _mapping.getTextDescription("admin.mpolicy.Elements Under Maintenance")+","+_mapping.getTextDescription("admin.mpolicy.Count");
			csvList.add(reportSubTitle);
			csvList.add("");
			if((element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptor Comp")|| element.equals("All Descriptors") || element.equals("All Patterns"))))
			{
				csvList.add(csvSummaryTitle);
				csvList.add(summaryColTitle);
			}
			
			ArrayList summaryData = new ArrayList();
			if((analysisData!=null && analysisData.size()>0) && (element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors")|| element.equals("All Descriptor Comp") || element.equals("All Patterns"))))
			{
				if(option!=null && option.equalsIgnoreCase("Host"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Host"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Host")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Component"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Component"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Component")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Test"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Test"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Test")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Descriptor"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Descriptors"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Descriptors")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Test For Host"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Host/Test"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Host/Test")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Test For Component"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Component/Test"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Component/Test")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Descriptor For Component"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Descriptor For Component"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Descriptor For Component")+","+analysisData.keySet().size());
				}
				else if(option!=null && option.equalsIgnoreCase("Wild Card"))
				{
					summaryData.add(_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern"));
					summaryData.add(""+analysisData.size());
					csvList.add(_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern")+","+analysisData.keySet().size());
				}

				dataSize=summaryData.size();
				if((element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Patterns"))))
				{
					tableAttributes.setTitle(summaryTableTitle);
					EgTableModel SummaryTableModel = new EgTableModel(summaryData,aListSummaryNames);
					summaryTable.setModel(SummaryTableModel);
					summaryTable.setAttributes(tableAttributes);
					aListPdfData.add(summaryTable);
				}
			}			
		}
	}
	else 
	{
		Vector csvSubTitle = new Vector();
		String pdfsubTitle = "";
		Vector subTitle = new Vector();
		if(option!=null && option.equals("Time Constraints")) 
		{
			if(element!=null&& element.equals("FDM")) 
			{
				pdfsubTitle = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance on first day of the month");
			}
			else if(element!=null&& element.equals("LDM"))
			{
				pdfsubTitle = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance on last day of the month");
			}
			else if(element!=null&& element.equals("*")) 
			{
				pdfsubTitle = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance on daily");
			}
			else if(element!=null&& element.equals("Day of Week")) 
			{
				pdfsubTitle = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance on ")+egM.DayForDescription(day);
			}
			reportAttributes.setSubTitle(pdfsubTitle);
			if(element!=null&& element.equals("Date"))
			{
				String dateForpdf ="";
				if(startHr!=null && startHr.equals("0") && endHr.equals("0") && endHr!=null ) 
				{
					dateForpdf = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance From ") +startDate+" To "+ endDate;
				}
				else
				{
					dateForpdf = _mapping.getTextDescription("admin.mpolicy.All elements under maintenance From " )+startDate+" "+startHr+":00 To "+ endDate+" "+endHr+":00";
				}
				reportAttributes.setSubTitle(dateForpdf);
			}
		}
		if((option!=null) && (option.equals("All") || option.equals("Policy"))) 
		{
			pdfsubTitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Details for All Elements");
			reportAttributes.setSubTitle(pdfsubTitle);
		}
		subTitle.add(pdfsubTitle);
		csvList.add(subTitle);

		if(HostData.keySet().size()>0 || CompData.keySet().size()>0 || TestData.keySet().size()>0 || HostTestData.keySet().size()>0 || CompTestData.keySet().size()>0 || descriptorData.keySet().size()>0 || compDescData.keySet().size()>0 || wildcardData.keySet().size()>0)
		{
			pdfHostName = new ArrayList();
			EgTable egSummaryTable = new EgTable();
			aListFieldWidth = new ArrayList();
			aListFieldWidth.add("200");
			aListFieldWidth.add("200");
			aListColumnNames = new ArrayList();
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			userColumnNames = new ArrayList();
			userColumnNames.add(_mapping.getTextDescription("admin.mpolicy.Elements Under Maintenance"));
			userColumnNames.add(_mapping.getTextDescription("admin.mpolicy.Count"));
			egTableAttributes = new EgTableAttributes();
			//egTableAttributes.setStartX(0);
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setFieldWidths(aListFieldWidth);
			sumelement="";
			if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("fdm"))
			{
				sumelement=_mapping.getTextDescription("admin.mpolicy.First Day of the Month");
			}
			else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("ldm"))
			{
				sumelement=_mapping.getTextDescription("admin.mpolicy.Last Day of the Month");
			}
			else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("*"))
			{
				sumelement=_mapping.getTextDescription("admin.mpolicy.Daily");
			}
			else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
			{
				startDate=StringUtils.replace(startDate,',',' ');
				endDate=StringUtils.replace(endDate,',',' ');
				sumelement=_mapping.getTextDescription("admin.mpolicy.From ") +startDate+_mapping.getTextDescription("admin.mpolicy.To ")+ endDate;
			}
			else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("Day of Week"))
			{
				sumelement=egM.DayForDescription(day);
			}
			else
			{
				sumelement=element;
			}

			elementForTitle=sumelement;
			String title ="";
			if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
			{
				title = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary ");
			}
			else
			{
				title = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary for ");
			}
			if(elementForTitle==null)
			{
				title += " "+_mapping.getTextDescription("admin.mpolicy.All Elements");
			}
			else
			{
				if(option.equalsIgnoreCase("Test") || option.equals("Test For Host") || option.equals("Test For Component"))
				{
					elementForTitle=_mapping.getTestDescription(elementForTitle);
				}
				String displayKey = elementForTitle; // Limited admin
				displayKey = egM.getPolicyDisplayName(displayKey,!roleInfo.hasAllComponentAccess());
				title += " "+displayKey;
			}
			egTableAttributes.setTitle(title);


			csvSubTitle = new Vector();
			csvSubTitle.add(title);

			String columnHeading = _mapping.getTextDescription("admin.mpolicy.Elements Under Maintenance")+","+_mapping.getTextDescription("admin.mpolicy.Count");
			csvList.add(title);
			csvList.add("");
			csvList.add(columnHeading);

			if(HostData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostList = (ArrayList)HostData.get(element);
					if(HostList!=null && !HostList.isEmpty() && HostList.size()>0)
					{
						pdfHostName.add("Host");
						pdfHostName.add(""+HostList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Host")+","+HostList.size());
					}
				}
				else
				{
					pdfHostName.add("Host");
					pdfHostName.add(""+HostData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Host")+","+HostData.keySet().size());
				}
			}
			if(CompData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compList = (ArrayList)CompData.get(element);
					if(compList!=null && !compList.isEmpty() && compList.size()>0)
					{
						pdfHostName.add("Component");
						pdfHostName.add(""+compList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Component")+","+compList.size());
					}
				}
				else
				{
					pdfHostName.add("Component");
					pdfHostName.add(""+CompData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Component")+","+CompData.keySet().size());
				}
			}
			if(TestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList testList = (ArrayList)TestData.get(element);
					if(testList!=null && !testList.isEmpty() && testList.size()>0)
					{
						pdfHostName.add("Test");
						pdfHostName.add(""+testList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Test")+","+testList.size());
					}
				}
				else
				{
					pdfHostName.add("Test");
					pdfHostName.add(""+TestData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Test")+","+TestData.keySet().size());
				}
			}
			if(HostTestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostTestList = (ArrayList)HostTestData.get(element);
					if(HostTestList!=null && !HostTestList.isEmpty() && HostTestList.size()>0)
					{
						pdfHostName.add("Host/Test");
						pdfHostName.add(""+HostTestList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Host/Test")+","+HostTestList.size());
					}
				}
				else
				{
					pdfHostName.add("Host/Test");
					pdfHostName.add(""+HostTestData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Host/Test")+","+HostTestData.keySet().size());
				}
			}
			if(CompTestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compTestList = (ArrayList)CompTestData.get(element);
					if(compTestList!=null && !compTestList.isEmpty() && compTestList.size()>0)
					{
						pdfHostName.add("Component/Test");
						pdfHostName.add(""+compTestList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Component/Test")+","+compTestList.size());
					}
				}
				else
				{
					pdfHostName.add("Component/Test");
					pdfHostName.add(""+CompTestData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Component/Test")+","+CompTestData.keySet().size());
				}
			}
			if(descriptorData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList descList = (ArrayList)descriptorData.get(element);
					if(descList!=null && !descList.isEmpty() && descList.size()>0)
					{
						pdfHostName.add("Descriptor");
						pdfHostName.add(""+descList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Descriptors")+","+descList.size());
					}
				}
				else
				{
					pdfHostName.add("Descriptor");
					pdfHostName.add(""+descriptorData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Descriptors")+","+descriptorData.keySet().size());
				}
			}
			if(compDescData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compDescList = (ArrayList)compDescData.get(element);
					if(compDescList!=null && !compDescList.isEmpty() && compDescList.size()>0)
					{
						pdfHostName.add("Descriptor For Component");
						pdfHostName.add(""+compDescList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Descriptor For Component")+","+compDescList.size());
					}
				}
				else
				{
					pdfHostName.add("Descriptor For Component");
					pdfHostName.add(""+compDescData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Descriptor For Component")+","+compDescData.keySet().size());
				}
			}
			if(wildcardData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList wildList = (ArrayList)wildcardData.get(element);
					if(wildList!=null && !wildList.isEmpty() && wildList.size()>0)
					{
						pdfHostName.add("Server/VM/Desktop - Pattern");
						pdfHostName.add(""+wildList.size());
						csvList.add( _mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern")+","+wildList.size());
					}
				}
				else
				{
					pdfHostName.add("Server/VM/Desktop - Pattern");
					pdfHostName.add(""+wildcardData.keySet().size());
					csvList.add( _mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern")+","+wildcardData.keySet().size());
				}
			}
			dataSize=pdfHostName.size();
			EgTableModel egSummaryTableModel = new EgTableModel(pdfHostName,aListColumnNames);
			egSummaryTable.setModel(egSummaryTableModel);
			egSummaryTable.setAttributes(egTableAttributes);
			aListPdfData.add(egSummaryTable);
		}
	}
	//CSV code Ends here

	if(HostData.keySet().size()>0 || CompData.keySet().size()>0 || TestData.keySet().size()>0 || HostTestData.keySet().size()>0 || CompTestData.keySet().size()>0 || descriptorData.keySet().size()>0 || compDescData.keySet().size()>0 || wildcardData.keySet().size()>0)
	{
		String sumtitle ="";
		if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
		{
			sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary");
		}
		else
		{
			sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary for ");
		}
		if(option!=null && option.equals("All"))
		{
			elementForTitle="All";
		}
		if((option!=null && (option.equals("All") || option.equals("Policy") || option.equals("Time Constraints") || option.equals("Wild Card"))) || (element!=null && (element.equals("All Elements") || element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp") || element.equals("All Pattern")))) 
		{
			JSONArray MaintenanceSummary=new JSONArray();
			JSONObject MaintenanceSummaryObj=new JSONObject();
			if( isLimitedAdmin && option.equals("Policy") && elementDisplay != null){
				MaintenanceSummaryObj.put("Element",elementForTitle==null?" All Elements":" "+elementDisplay);	
			} else {
				MaintenanceSummaryObj.put("Element",elementForTitle==null?" All Elements":" "+elementForTitle);	
			}
			
			if(HostData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostList = (ArrayList)HostData.get(element);
					if(HostList!=null && !HostList.isEmpty() && HostList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Host"));
						MaintenanceSummaryObj.put("valueField",HostList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Host"));
					MaintenanceSummaryObj.put("Type","Host");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",HostData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",HostData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}				
			}
			if(CompData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compList = (ArrayList)CompData.get(element);
					if(compList!=null && !compList.isEmpty() && compList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Components"));
						MaintenanceSummaryObj.put("Type","Component");
						MaintenanceSummaryObj.put("valueField",compList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Components"));
					MaintenanceSummaryObj.put("Type","Component");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",CompData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",CompData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}				
			}
			if(TestData.keySet().size()>0)
			{
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList testList = (ArrayList)TestData.get(element);
					if(testList!=null && !testList.isEmpty() && testList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Test"));
						MaintenanceSummaryObj.put("Type","Test");
						MaintenanceSummaryObj.put("valueField",testList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Test"));
					MaintenanceSummaryObj.put("Type","Test");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",TestData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",TestData.keySet().size());

					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}
				
			}
			if(HostTestData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList HostTestList = (ArrayList)HostTestData.get(element);
					if(HostTestList!=null && !HostTestList.isEmpty() && HostTestList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Host/Test"));
						MaintenanceSummaryObj.put("Type","Test For Host");
						MaintenanceSummaryObj.put("valueField",HostTestList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Host/Test"));
					MaintenanceSummaryObj.put("Type","Test For Host");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",HostTestData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",HostTestData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}				
			}
			if(CompTestData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compTestList = (ArrayList)CompTestData.get(element);
					if(compTestList!=null && !compTestList.isEmpty() && compTestList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Component/Test"));
						MaintenanceSummaryObj.put("Type","Test For Component");
						MaintenanceSummaryObj.put("valueField",compTestList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Component/Test"));
					MaintenanceSummaryObj.put("Type","Test For Component");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",CompTestData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",CompTestData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}				
			}
			if(descriptorData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList descList = (ArrayList)descriptorData.get(element);
					if(descList!=null && !descList.isEmpty() && descList.size()>0)
					{
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Descriptors"));
						MaintenanceSummaryObj.put("Type","Descriptor");
						MaintenanceSummaryObj.put("valueField",descList.size());
						MaintenanceSummary.add(MaintenanceSummaryObj);
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Descriptors"));
					MaintenanceSummaryObj.put("Type","Descriptor");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",descriptorData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",descriptorData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);
				}				
			}
			if(compDescData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList compDescList = (ArrayList)compDescData.get(element);
					if(compDescList!=null && !compDescList.isEmpty() && compDescList.size()>0)
					{
						MaintenanceSummaryObj.put("valueField",compDescList.size());
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Descriptors for Components"));
						MaintenanceSummaryObj.put("Type","Descriptor For Component");
						MaintenanceSummary.add(MaintenanceSummaryObj);		
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Descriptors for Components"));
					MaintenanceSummaryObj.put("Type","Descriptor For Component");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",compDescData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",compDescData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);		
				}
			}
			if(wildcardData.keySet().size()>0)
			{				
				if(option!=null && option.equals("Policy")) 
				{
					ArrayList wildList = (ArrayList)wildcardData.get(element);
					if(wildList!=null && !wildList.isEmpty() && wildList.size()>0)
					{
						MaintenanceSummaryObj.put("valueField",wildList.size());
						MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern"));
						MaintenanceSummaryObj.put("Type","Wild Card");
						MaintenanceSummary.add(MaintenanceSummaryObj);		
					}
				}
				else
				{
					MaintenanceSummaryObj.put("text",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern"));
					MaintenanceSummaryObj.put("Type","Wild Card");
					if(noOfElemenstAssociated>1)
					{
						MaintenanceSummaryObj.put("valueField",wildcardData.keySet().size());
					}
					else
					{
						MaintenanceSummaryObj.put("valueField",wildcardData.keySet().size());
					}
					MaintenanceSummary.add(MaintenanceSummaryObj);		
				}
			}
			rootJson.put("dashboardSummary",MaintenanceSummary);
		}
		else if(element!=null && !element.equals("All Hosts") && !element.equals("All Components") && !element.equals("All Tests") && !element.equals("All Patterns"))
		{			
			boolean isActive=false;
			if(option!=null && option.equals("Test For Component")  ||  option.equals("Test For Host") || option.equals("Descriptor For Component"))
			{
				if(option.equals("Descriptor For Component"))
				{
					isActive=egM.isServerElementInUnderMintenance("Test For Host",element,descElement);
				}
				else
				{
					isActive=egM.isServerElementInUnderMintenance("Test For Host",testElement,element);
				}
			}
			else if(option!=null && (option.equals("Test") || option.equals("Descriptor")))
			{
				isActive=egM.isServerElementInUnderMintenance("Test",element);
			}
			else
			{
				isActive=egM.isServerElementInUnderMintenance("Host",element);
			}
			String mstatustitle="";
			String melement=element;
			if(melement.endsWith(":NULL"))
			{
				melement = melement.substring(0,melement.indexOf(":NULL"));
			}
			if(option!=null && option.equals("Host"))
			{
				mstatustitle="Quick Maintenance Details For Host";
			}
			else if(option!=null && option.equals("Component"))
			{
				mstatustitle="Quick Maintenance Details For Component";
			}
			else if(option!=null && option.equals("Test"))
			{
				mstatustitle="Quick Maintenance Details For Test";
				melement=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equals("Test For Host"))
			{
				mstatustitle="Quick Maintenance Details For Host Test";
				melement=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equals("Test For Component"))
			{
				mstatustitle="Quick Maintenance Details For Component Test";
				melement=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equals("Descriptor"))
			{
				mstatustitle="Quick Maintenance Details For Descriptor";
				String elem="";
				if(element!=null && element.indexOf(":")>0)
				{
					elem=element.substring(element.indexOf(":")+1);
				}
				melement=elem;
			}
			else if(option!=null && option.equals("Descriptor For Component"))
			{
				mstatustitle="Quick Maintenance Details For Descriptor For Component";
				String descElem="";
				if(element!=null && element.indexOf(":")>0)
				{
					descElem=descElement.substring(descElement.indexOf(":")+1);
				}
				melement=descElem;
			}
			else if(option!=null && option.equals("Wild Card"))
			{
				mstatustitle="Quick Maintenance Details For Server/VM/Desktop - Pattern";
			}
			String DisplayTitlesess=mstatustitle.toString();
			String columnNamesess=melement.toString();
			String Statussess1="";							
			if(isActive) 
			{
				Statussess1="Active";										
			} 
			else 
			{
				Statussess1="Inactive";
			}
			session.setAttribute("DisplayTitlesess",DisplayTitlesess+"-"+columnNamesess);
			session.setAttribute("columnNamesess",columnNamesess);
			session.setAttribute("Statussess",Statussess1);
		}
	}
	//For Analysis Report starts
	Date locdate = new Date(date.egetUTCDate(false));			
	SimpleDateFormat mdyFormat = new SimpleDateFormat("MM/dd/yyyy");
	String stDate = mdyFormat.format(locdate);	
	if(option!=null && !option.equals("All") &&  !option.equals("Time Constraints") && !option.equals("Policy"))
	{
		JSONArray result=new JSONArray();
		JSONObject mainsummary=new JSONObject();	
		if(analysisData!=null && analysisData.size()>0) 
		{
			JSONObject screenLabels=new JSONObject();
			csvList.add("");
			Vector csvdispTitle = new Vector();
			csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy."+dispTitle));
			csvList.add(csvdispTitle);
			String tableColumn = "";
			
			if(option!=null)
			{  
				if(option.equals("Test For Host"))
				{
					tableColumn = _mapping.getTextDescription("admin.mpolicy.Test")+","+_mapping.getTextDescription("admin.mpolicy.Host");
				}
				else if(option.equals("Test For Component"))
				{
					tableColumn = _mapping.getTextDescription("admin.mpolicy.Test")+","+_mapping.getTextDescription("admin.mpolicy.Component");
				}
				else if(option.equalsIgnoreCase("Descriptor For Component"))
				{
					tableColumn = _mapping.getTextDescription("admin.mpolicy.Descriptor")+","+_mapping.getTextDescription("admin.mpolicy.Component");
				}
				else
				{
					tableColumn = option;
				}
			}
			
			tableColumn += ","+_mapping.getTextDescription("admin.mpolicy.Policy")+","+_mapping.getTextDescription("admin.mpolicy.Status")+","+_mapping.getTextDescription("admin.mpolicy.Timeline");
			csvList.add(tableColumn);
			csvList.add("");
			
			String patterList = "";
			String category="";
			if(option.equals("Host"))
			{
				category="Hosts Under Maintenance";
			}
			else if(option.equals("Component"))
			{						
				category="Components Under Maintenance";
			}
			else if(option.equals("Test"))
			{
				category="Tests Under Maintenance";
			}
			else if(option.equals("Test For Host"))
			{
				category="Host Tests Under Maintenance";
			}
			else if(option.equals("Test For Component"))
			{					
				category="Component Tests Maintenance";							
			}
			else if(option.equals("Descriptor"))
			{
				category="Descriptors Under Maintenance";
			}
			else if(option.equalsIgnoreCase("Descriptor For Component"))
			{
				category="Descriptor For Component Under Maintenance";
			}
			else if(option.equalsIgnoreCase("Wild Card"))
			{
				category="Server/VM/Desktop - Pattern";
				if(element!=null && element.equalsIgnoreCase("all pattern"))
				{
					HashSet wildcard=egM.getAllAssociatedWildcardForUnplannedPolicy();
					Iterator wildcardItr=wildcard.iterator();
					String wildcardStr1 = "";
					if(wildcardItr.hasNext()) 
					{
						while(wildcardItr.hasNext())
						{
							String pattern=(String)wildcardItr.next();
							patterList += pattern+",";
						}
						if(patterList!=null && patterList.lastIndexOf(",")>0)
						{
							patterList = patterList.substring(0,patterList.lastIndexOf(","));
						}
					}
				}
				else
				{
					patterList = element;
				}			
			}
			Iterator mappitr=analysisData.keySet().iterator();
			if(element!=null && (!element.equalsIgnoreCase("All Components") || !element.equalsIgnoreCase("All Hosts") || !element.equalsIgnoreCase("All Tests") || !element.equalsIgnoreCase("All Descriptors") || !element.equalsIgnoreCase("All Descriptor Comp") || !element.equalsIgnoreCase("All Patterns")))
			{				
				String elementTitle = element;
				if(element!=null && element.endsWith(":NULL"))
				{
					elementTitle = element.substring(0,element.indexOf(":NULL"));
				}
				if(option!=null && (option.equalsIgnoreCase("Test") || option.equalsIgnoreCase("Test For Host") || option.equalsIgnoreCase("Test For Component")))
				{
					elementTitle = _mapping.getTestDescription(element);
				}
				if(option!=null && option.equalsIgnoreCase("Descriptor") && !element.equalsIgnoreCase("All Descriptors"))
				{
					elementTitle = element.substring(0,element.indexOf(":"));
					elementTitle = _mapping.getTestDescription(elementTitle);
				}
				if(elementTitle!=null && !elementTitle.equals(""))
				{
					dispTitle +=" - "+elementTitle;
				}
			}
			JSONArray columnNameArr=new JSONArray();					
			if(timePeriod!=null && timePeriod.equals("true")) 
			{			
				JSONObject columnNameObj=new JSONObject();
				columnNameObj.put("columnName",columnName);
			}
			else
			{
				while(mappitr.hasNext()) 
				{
					String CSVData = "";
					JSONObject columnNameObj=new JSONObject();
					columnNameObj.put("Analysisoption",category);
					 if(option.equalsIgnoreCase("Wild Card"))
					{
						columnNameObj.put("AnalysisoptionTitle",_mapping.getTextDescription("admin.mpolicy."+category)+" ("+patterList+")");
					}
					else
					{
						columnNameObj.put("AnalysisoptionTitle",_mapping.getTextDescription("admin.mpolicy."+category));
					}
					String mapkey=(String)mappitr.next();
					Hashtable policyDetailsTable = (Hashtable)analysisData.get(mapkey);

					String disp = mapkey;
					String orgHstName = "";							
					if(disp.endsWith(":NULL"))
					{									
						disp= disp.substring(0,disp.indexOf(":NULL"));
					}
					if(option!=null && option.equals("Test"))
					{
						disp = _mapping.getTestDescription(disp);
					}
					if(disp!=null && disp.indexOf("#")>0)
					{
						String columName = disp.substring(0,disp.indexOf("#"));
						if(option!=null && (option.equals("Test For Host") || option.equals("Test For Component")))
						{
							columName = _mapping.getTestDescription(columName);
						}
						//******--Repalcing--Hash--Starts--*****---//
						if(columName!=null&& columName.indexOf("|HASH|")>0)
						{
							columName = StringUtils.replace(columName,"|HASH|","#");
						}
						//******--Repalcing--Hash--Ends--*****---//			
						columnNameObj.put("columnName",columName);
						columnNameObj.put("hostName",disp.substring(disp.indexOf("#")+1));
						CSVData = columName+","+disp.substring(disp.indexOf("#")+1);
					}
					else
					{
						//******--Repalcing--Hash--Starts--*****---//
						if(disp!=null&& disp.indexOf("|HASH|")>0)
						{
							disp = StringUtils.replace(disp,"|HASH|","#");
						}
						//******--Repalcing--Hash--Ends--*****---//			
						CSVData = disp;
						columnNameObj.put("columnName",disp);
					}					
					orgHstName = disp;	
					
					Iterator policyDetailsitr = policyDetailsTable.keySet().iterator();
					JSONArray PolicyDetailsArr = new JSONArray();
					//csvList.add(CSVData);
					
					while(policyDetailsitr.hasNext()) 
					{
						String CSVPolicyData = ""; 
						JSONObject policyColumnObj = new JSONObject();
						String policyNameWithStatus=(String)policyDetailsitr.next();
						Hashtable timelineTable = (Hashtable)policyDetailsTable.get(policyNameWithStatus);	

						String policyName= policyNameWithStatus.substring(0,policyNameWithStatus.lastIndexOf("|"));
						String status = policyNameWithStatus.substring(policyNameWithStatus.lastIndexOf("|")+1);
						if(status!=null && status.equals("true"))
						{
							status = _mapping.getTextDescription("admin.mpolicy.Active");
						}
						else
						{
							status = _mapping.getTextDescription("admin.mpolicy.Inactive");
						}
						if(policyName!=null && !policyName.equals(""))
						{
							String policyGroup = "";
							String tmpDisplay = egM.getPolicyDisplayName(policyName,!roleInfo.hasAllComponentAccess(), true);
							
							policyColumnObj.put("policyName",tmpDisplay);
							if(option.equals("Test For Host") || option.equals("Test For Component") || option.equalsIgnoreCase("Descriptor For Component"))
							{
								policyGroup = tmpDisplay;
							}
							else
							{								
								policyGroup =tmpDisplay;
							}
							
							String groupList = (String)timelineTable.get("groups");
							if(groupList!=null && !groupList.equals(""))
							{	
								policyColumnObj.put("GroupName",groupList);
								groupList = groupList.replace(",","  ");
								policyGroup +="\t $ Groups:"+groupList; 
							}
							CSVData +=","+policyGroup +",";
						}
						CSVData +=status+",";
						policyColumnObj.put("Status",status);

						JSONArray TimeLineArr=new JSONArray();		
						
						Hashtable htDate = new Hashtable();
						Iterator timeItr=timelineTable.keySet().iterator();
						while(timeItr.hasNext()) 
						{							
							String colName = (String)timeItr.next();
							if(colName!=null && !colName.equals("groups"))
							{
								JSONObject datevalue=new JSONObject();
								JSONArray minarray=new JSONArray();
								String dispCol="";	
								if(colName.equals("FDM"))
								{
									dispCol="First Day Of Month";
								}
								else if(colName.equals("LDM")) 
								{
									dispCol="Last Day Of Month";
								}
								else if(colName.equals("*")) 
								{
									dispCol="Daily";
								}
								else if(colName.startsWith("Every"))
								{
									String suffix = "th";
									if(colName.endsWith("1") || colName.endsWith("21") || colName.endsWith("31"))
									{
										suffix = "st";
									}
									else if(colName.endsWith("2") || colName.endsWith("22"))
									{
										suffix = "nd";
									}
									else if(colName.endsWith("3") || colName.endsWith("23"))
									{
										suffix = "rd";
									}
									dispCol = com.egurkha.util.StringUtils.replace(colName,"_"," ")+suffix+" day of the month";
									//dispCol = mappingInfo.getTextDescription("monitor.testDetails."+dispCol+" day of the month");
								}
								else if(colName.startsWith("Sun") || colName.startsWith("Mon") || colName.startsWith("Tue") || colName.startsWith("Wed") || colName.startsWith("Thu") || colName.startsWith("Fri") || colName.startsWith("Sat")) 
								{
									if(colName!=null && colName.indexOf("$")>0 && colName.indexOf("_")>0)
									{
										String dayVal = colName.substring(0,colName.indexOf("$"));
										String week = colName.substring(colName.indexOf("$")+1);
										if(week.equalsIgnoreCase("week_1"))
										{
											week = "First";
										}
										else if(week.equalsIgnoreCase("week_2"))
										{
											week = "Second";
										}
										else if(week.equalsIgnoreCase("week_3"))
										{
											week = "Third";
										}
										else if(week.equalsIgnoreCase("week_4"))
										{
											week = "Fourth";
										}
										else if(week.equalsIgnoreCase("week_5"))
										{
											week = "Fifth";
										}

										dispCol=egM.DayForDescription(dayVal);
										//dispCol = dispCol+ " ("+week+")";
										dispCol = week+" "+dispCol.toLowerCase()+" of the month";
									}
									else
									{
										dispCol=egM.DayForDescription(colName);
									}
								}
								else 
								{
									dispCol=colName.replace('|','-');
								}
								String strDate = "";
								endDate = "";
								Vector timelineVec = (Vector)timelineTable.get(colName);
								Vector val = new Vector();
								if(dispCol.indexOf("-")>0)
								{
									strDate = dispCol.substring(0,dispCol.indexOf("-"));
									endDate = dispCol.substring(dispCol.indexOf("-")+1);
									
									for(int i=0;i<timelineVec.size();i++)
									{
										String time = (String)timelineVec.get(i);
										String startTime=time.substring(0,time.indexOf("-"));
										String endTime=time.substring(time.indexOf("-")+1,time.length());
										String timeMsg= "";
										
										String strHr = startTime.substring(0,startTime.indexOf(":"));
										String strMin = startTime.substring(startTime.indexOf(":")+1);
										endHr = endTime.substring(0,endTime.indexOf(":"));
										String endMin = endTime.substring(endTime.indexOf(":")+1);
										
										String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
										EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
										String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
										EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
										String start_Date = (String) converterStart.getDate(false);
										String end_Date = (String) converterEnd.getDate(false);

										start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
										end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
										dispCol = start_Date+"-"+end_Date;
										strHr = converterStart.getHour();
										endHr = converterEnd.getHour();
										strMin = converterStart.getMinute();
										endMin = converterEnd.getMinute();
										timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

										if(htDate!=null && htDate.containsKey(dispCol))
										{
											Vector existVector = (Vector)htDate.get(dispCol);
											existVector.add(timeMsg);
											htDate.put(dispCol, existVector);
										}
										else
										{
											val = new Vector();
											val.add(timeMsg);
											htDate.put(dispCol, val);
										}
									}
								}
								else
								{											
									for(int i=0;i<timelineVec.size();i++)
									{
										String time = (String)timelineVec.get(i);
										String startTime=time.substring(0,time.indexOf("-"));
										String endTime=time.substring(time.indexOf("-")+1,time.length());
										String timeMsg= "";
										if(strDate.equals("") && endDate.equals(""))
										{
											strDate = stDate;
											endDate = stDate;
										}
										if(!strDate.equals("") && !endDate.equals(""))
										{
											String strHr = startTime.substring(0,startTime.indexOf(":"));
											String strMin = startTime.substring(startTime.indexOf(":")+1);

											endHr = endTime.substring(0,endTime.indexOf(":"));
											String endMin = endTime.substring(endTime.indexOf(":")+1);

											String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
											EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
											String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
											EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
											
											strHr = converterStart.getHour();
											endHr = converterEnd.getHour();
											strMin = converterStart.getMinute();
											endMin = converterEnd.getMinute();
											timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
										}
										dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
										if(htDate!=null && htDate.containsKey(dispCol))
										{
											Vector existVector = (Vector)htDate.get(dispCol);
											existVector.add(timeMsg);
											htDate.put(dispCol, existVector);
										}
										else
										{
											val = new Vector();
											val.add(timeMsg);
											htDate.put(dispCol, val);
										}
									}
								}
							}
						}						
						if(htDate!=null)
						{
							Set timeKeyset=htDate.keySet();
							Iterator timeKeysetItr=timeKeyset.iterator();
							while(timeKeysetItr.hasNext())
							{
								JSONObject datevalue=new JSONObject();
								JSONArray minarray=new JSONArray();
								String key=(String)timeKeysetItr.next();
								Vector timeVec = (Vector)htDate.get(key);
								CSVData +=key+",";
								datevalue.put("Date",key);
								for(int i =0;i<timeVec.size();i++)
								{
									String time = (String)timeVec.get(i);
									CSVData +=time+",";
									JSONObject minobject=new JSONObject();
									minobject.put("Timeperiods",time);
									minarray.add(minobject);
								}
								datevalue.put("Time",minarray);
								TimeLineArr.add(datevalue);	
							}
						}
						policyColumnObj.put("TimeFrequency",TimeLineArr);

						//For next schedule date
						/*Hashtable dates=new Hashtable();
						if(option.equals("Test") || option.equals("Descriptor"))
						{
							dates=egM.getNextScheduleTimeForTest(mapkey);
							if(dates!=null && dates.size()==0)
							{	
								dates=egM.getUnplannedNextScheduleTimeForTest(mapkey);
							}
						}
						else if(option.equals("Host") || option.equals("Components") || option.equals("Component"))
						{
								dates=egM.getNextScheduleTimeForHost(mapkey);
								if(dates!=null && dates.size()==0)
								{
									dates=egM.getUnplannedNextScheduleTimeForHost(mapkey);
								}
						}
						if(dates!=null && dates.size()>0)  
						{
							SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
							Date startDate1=(Date)dates.keySet().iterator().next();
							Date endDate1=(Date)dates.get(startDate1);
							if(endDate1.before(new Date()) || endDate1.equals(new Date()))
							{
								policyColumnObj.put("NextScheduleDate","Completed");
							}
							else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
							{
								SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
								policyColumnObj.put("NextScheduleDate",simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
							}
							else
							{
								policyColumnObj.put("NextScheduleDate",simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
							}
						}*/
						PolicyDetailsArr.add(policyColumnObj);
						if(CSVData!=null && CSVData.lastIndexOf(",")>0)
						{
							CSVData = CSVData.substring(0,CSVData.lastIndexOf(","));
						}
						csvList.add(CSVData);
					}
					columnNameObj.put("policyDetails",PolicyDetailsArr);
					columnNameArr.add(columnNameObj);
				}									
			} 			
			mainsummary.put(_mapping.getTextDescription("admin.mpolicy."+category),columnNameArr);
			rootJson.put("mainsummary", mainsummary);	
		} 
		else 
		{
			rootJson.put("Nodata",_mapping.getTextDescription("admin.common.No data available"));
		}		
	}
	else if(option!=null && (option.equals("All") || option.equals("Time Constraints")))
	{
		if(isData)
		{
			if(data!=null && data.size()>0)
			{
				JSONArray result=new JSONArray();
				JSONObject mainsummary=new JSONObject();	
				for(int k=0;k<data.size();k++) 
				{
					String patterList = "";
					JSONObject screenLabels=new JSONObject();
					csvList.add("");
					Vector csvdispTitle = new Vector();
					
					String tableColumn = "";
					Hashtable mappedkeys=(Hashtable)data.get(k);	
					
					if(mappedkeys!=null && mappedkeys.size()>0) 
					{
																
						String category ="";
						if(k==0) 
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Host");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Hosts Under Maintenance"));
							category="Hosts Under Maintenance";
						}
						else if(k==1)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Component");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Components Under Maintenance"));							
							category="Components Under Maintenance";
						}
						else if(k==2)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Test");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Tests Under Maintenance"));
							category="Tests Under Maintenance";
						}
						else if(k==3)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Test")+","+_mapping.getTextDescription("admin.mpolicy.Host");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Host Tests Under Maintenance"));
							category="Host Tests Under Maintenance";
						}
						else if(k==4)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Test")+","+_mapping.getTextDescription("admin.mpolicy.Component");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Component Tests Under Maintenance"));							
							category="Component Tests Maintenance";							
						}
						else if(k==5)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Descriptor");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Descriptors Under Maintenance"));
							category="Descriptors Under Maintenance";
						}
						else if(k==6)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Descriptor")+","+_mapping.getTextDescription("admin.mpolicy.Component");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Descriptor For Component Under Maintenance"));
							category="Descriptor For Component Under Maintenance";
						}							
						else if(k==7)
						{
							tableColumn = _mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern");
							csvdispTitle.add(_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop - Pattern"));
							category="Server/VM/Desktop - Pattern";

							HashSet wildcard=egM.getAllAssociatedWildcardForUnplannedPolicy();
							Iterator wildcardItr=wildcard.iterator();
							String wildcardStr1 = "";
							if(wildcardItr.hasNext()) 
							{
								while(wildcardItr.hasNext())
								{
									String pattern=(String)wildcardItr.next();
									patterList += pattern+",";
								}
								if(patterList!=null && patterList.lastIndexOf(",")>0)
								{
									patterList = patterList.substring(0,patterList.lastIndexOf(","));
								}
							}
						}							
						csvList.add(csvdispTitle);
						tableColumn += ","+_mapping.getTextDescription("admin.mpolicy.Policy")+","+_mapping.getTextDescription("admin.mpolicy.Status")+","+_mapping.getTextDescription("admin.mpolicy.Timeline");
						csvList.add(tableColumn);
						csvList.add("");						

						Iterator mappitr=mappedkeys.keySet().iterator();	
							
						JSONArray columnNameArr=new JSONArray();
						if(timePeriod!=null && timePeriod.equals("true")) 
						{	
							JSONObject columnNameObj=new JSONObject();
							columnNameObj.put("columnName",columnName);
						}
						else
						{
							while(mappitr.hasNext()) 
							{
								String CSVData = "";
								JSONObject columnNameObj=new JSONObject();	
								columnNameObj.put("Analysisoption",category);
								if(k==7)
								{
									columnNameObj.put("AnalysisoptionTitle",_mapping.getTextDescription("admin.mpolicy."+category)+" ("+patterList+")");
								}
								else
								{
									columnNameObj.put("AnalysisoptionTitle",_mapping.getTextDescription("admin.mpolicy."+category));
								}
								String mapkey=(String)mappitr.next();
								Hashtable policyDetailsTable = (Hashtable)mappedkeys.get(mapkey);
								String disp = mapkey;
								String orgHstName = "";	
								if(disp.endsWith(":NULL"))
								{									
									disp= disp.substring(0,disp.indexOf(":NULL"));
								}
								if(k==2)
								{
									disp = _mapping.getTestDescription(disp);
								}
								if(disp!=null && disp.indexOf("#")>0)
								{
									String tmpDisp = disp.substring(0,disp.indexOf("#"));
									if(k==3 || k==4)
									{
										tmpDisp = _mapping.getTestDescription(tmpDisp);
									}	
									
									//******--Repalcing--Hash--Starts--*****---//
									if(tmpDisp!=null&& tmpDisp.indexOf("|HASH|")>0)
									{
										tmpDisp = StringUtils.replace(tmpDisp,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//							

									columnNameObj.put("columnName",tmpDisp);
									columnNameObj.put("hostName",disp.substring(disp.indexOf("#")+1));
										
									CSVData = tmpDisp +","+disp.substring(disp.indexOf("#")+1);
									//******--Repalcing--Hash--Starts--*****---//
									if(CSVData!=null&& CSVData.indexOf("|HASH|")>0)
									{
										CSVData = StringUtils.replace(CSVData,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//	
								}
								else
								{
									//******--Repalcing--Hash--Starts--*****---//
									if(disp!=null&& disp.indexOf("|HASH|")>0)
									{
										disp = StringUtils.replace(disp,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//	
									CSVData = disp;
									columnNameObj.put("columnName",disp);
								}
								
								orgHstName = disp;	
								//csvList.add(CSVData);

								String groupList = "";
								boolean isGrupAvail = false;
								Iterator policyDetailsitr = policyDetailsTable.keySet().iterator();
								JSONArray PolicyDetailsArr = new JSONArray();
								while(policyDetailsitr.hasNext()) 
								{
									String CSVPolicyData = ""; 
									JSONObject policyColumnObj = new JSONObject();
									String policyNameWithStatus=(String)policyDetailsitr.next();
									Hashtable timelineTable = (Hashtable)policyDetailsTable.get(policyNameWithStatus);
									String policyName= policyNameWithStatus.substring(0,policyNameWithStatus.lastIndexOf("|"));
									String status = policyNameWithStatus.substring(policyNameWithStatus.lastIndexOf("|")+1);
									if(status!=null && status.equals("true"))
									{
										status = _mapping.getTextDescription("admin.mpolicy.Active");
									}
									else
									{
										status = _mapping.getTextDescription("admin.mpolicy.Inactive");
									}
									if(policyName!=null && !policyName.equals(""))
									{
										String policyGroup = "";
										String tmpDisplay = egM.getPolicyDisplayName(policyName,!roleInfo.hasAllComponentAccess(), true);
										policyColumnObj.put("policyName",tmpDisplay);
										if(k==3 || k==4 || k==6)
										{
											policyGroup = tmpDisplay;
										}
										else
										{								
											policyGroup =tmpDisplay;
										}
										groupList = (String)timelineTable.get("groups");
										if(groupList!=null && !groupList.equals(""))
										{	
											policyColumnObj.put("GroupName",groupList);
											groupList = groupList.replace(",","  ");
											policyGroup +="\t $ Groups:"+groupList; 
										}
										CSVData +=","+policyGroup +",";
									}
									CSVData +=status+",";
									policyColumnObj.put("Status",status);
									
									JSONArray TimeLineArr=new JSONArray();		
									
									Hashtable htDate = new Hashtable();									
									Iterator timeItr=timelineTable.keySet().iterator();
									while(timeItr.hasNext()) 
									{
										String colName = (String)timeItr.next();
										if(colName!=null && colName.equals("groups"))
										{
											isGrupAvail = true;
											groupList = (String)timelineTable.get(colName);
											if(groupList!=null && !groupList.equals(""))
											{												
												policyColumnObj.put("GroupName",groupList);
											}
										}
										else
										{											
											String dispCol="";	
											if(colName.equals("FDM"))
											{
												dispCol="First Day Of Month";
											}
											else if(colName.equals("LDM")) 
											{
												dispCol="Last Day Of Month";
											}
											else if(colName.equals("*")) 
											{
												dispCol="Daily";
											}
											else if(colName.startsWith("Every"))
											{
												String suffix = "th";
												if(colName.endsWith("1") || colName.endsWith("21") || colName.endsWith("31"))
												{
													suffix = "st";
												}
												else if(colName.endsWith("2") || colName.endsWith("22"))
												{
													suffix = "nd";
												}
												else if(colName.endsWith("3") || colName.endsWith("23"))
												{
													suffix = "rd";
												}
												dispCol = com.egurkha.util.StringUtils.replace(colName,"_"," ")+suffix+" day of the month";
												//dispCol = mappingInfo.getTextDescription("monitor.testDetails."+dispCol+" day of the month");
											}
											else if(colName.startsWith("Sun") || colName.startsWith("Mon") || colName.startsWith("Tue") || colName.startsWith("Wed") || colName.startsWith("Thu") || colName.startsWith("Fri") || colName.startsWith("Sat")) 
											{
												if(colName!=null && colName.indexOf("$")>0 && colName.indexOf("_")>0)
												{
													String dayVal = colName.substring(0,colName.indexOf("$"));
													String week = colName.substring(colName.indexOf("$")+1);
													if(week.equalsIgnoreCase("week_1"))
													{
														week = "First";
													}
													else if(week.equalsIgnoreCase("week_2"))
													{
														week = "Second";
													}
													else if(week.equalsIgnoreCase("week_3"))
													{
														week = "Third";
													}
													else if(week.equalsIgnoreCase("week_4"))
													{
														week = "Fourth";
													}
													else if(week.equalsIgnoreCase("week_5"))
													{
														week = "Fifth";
													}

													dispCol=egM.DayForDescription(dayVal);
													dispCol = week+" "+dispCol.toLowerCase()+" of the month";
												}
												else
												{
													dispCol=egM.DayForDescription(colName);
												}
											} 
											else 
											{
												dispCol=colName.replace('|','-');
											}
											String strDate = "";
											endDate = "";
											Vector timelineVec = (Vector)timelineTable.get(colName);
											Vector val = new Vector();
											if(dispCol.indexOf("-")>0)
											{
												strDate = dispCol.substring(0,dispCol.indexOf("-"));
												endDate = dispCol.substring(dispCol.indexOf("-")+1);
												
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													
													String strHr = startTime.substring(0,startTime.indexOf(":"));
													String strMin = startTime.substring(startTime.indexOf(":")+1);
													endHr = endTime.substring(0,endTime.indexOf(":"));
													String endMin = endTime.substring(endTime.indexOf(":")+1);
													
													String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
													String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
													EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
													String start_Date = (String) converterStart.getDate(false);
													String end_Date = (String) converterEnd.getDate(false);

													start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
													end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
													dispCol = start_Date+"-"+end_Date;
													strHr = converterStart.getHour();
													endHr = converterEnd.getHour();
													strMin = converterStart.getMinute();
													endMin = converterEnd.getMinute();
													timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}
											else
											{											
												for(int i=0;i<timelineVec.size();i++)
												{
													String time = (String)timelineVec.get(i);
													String startTime=time.substring(0,time.indexOf("-"));
													String endTime=time.substring(time.indexOf("-")+1,time.length());
													String timeMsg= "";
													if(strDate.equals("") && endDate.equals(""))
													{
														strDate = stDate;
														endDate = stDate;
													}
													if(!strDate.equals("") && !endDate.equals(""))
													{
														String strHr = startTime.substring(0,startTime.indexOf(":"));
														String strMin = startTime.substring(startTime.indexOf(":")+1);

														endHr = endTime.substring(0,endTime.indexOf(":"));
														String endMin = endTime.substring(endTime.indexOf(":")+1);

														String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
														String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
														EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
														
														strHr = converterStart.getHour();
														endHr = converterEnd.getHour();
														strMin = converterStart.getMinute();
														endMin = converterEnd.getMinute();
														timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
													}
													dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
													if(htDate!=null && htDate.containsKey(dispCol))
													{
														Vector existVector = (Vector)htDate.get(dispCol);
														existVector.add(timeMsg);
														htDate.put(dispCol, existVector);
													}
													else
													{
														val = new Vector();
														val.add(timeMsg);
														htDate.put(dispCol, val);
													}
												}
											}											
										}
									}									
									if(htDate!=null)
									{
										Set timeKeyset=htDate.keySet();
										Iterator timeKeysetItr=timeKeyset.iterator();
										while(timeKeysetItr.hasNext())
										{
											JSONObject datevalue=new JSONObject();
											JSONArray minarray=new JSONArray();
											String key=(String)timeKeysetItr.next();
											Vector timeVec = (Vector)htDate.get(key);
											CSVData +=key+",";
											datevalue.put("Date",key);
											for(int i =0;i<timeVec.size();i++)
											{
												String time = (String)timeVec.get(i);
												CSVData +=time+",";
												JSONObject minobject=new JSONObject();
												minobject.put("Timeperiods",time);
												minarray.add(minobject);
											}
											datevalue.put("Time",minarray);
											TimeLineArr.add(datevalue);	
										}
									}
									if(TimeLineArr!=null && !TimeLineArr.isEmpty())
									{
										policyColumnObj.put("TimeFrequency",TimeLineArr);
									}

									//For next schedule date
									/*Hashtable dates=new Hashtable();
									if(option.equals("Test") || option.equals("Descriptor"))
									{
										dates=egM.getNextScheduleTimeForTest(mapkey);
										if(dates!=null && dates.size()==0)
										{	
											dates=egM.getUnplannedNextScheduleTimeForTest(mapkey);
										}
									}
									else if(option.equals("Host") || option.equals("Components") || option.equals("Component"))
									{
											dates=egM.getNextScheduleTimeForHost(mapkey);
											if(dates!=null && dates.size()==0)
											{
												dates=egM.getUnplannedNextScheduleTimeForHost(mapkey);
											}
									}
									if(dates!=null && dates.size()>0)  
									{
										SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
										Date startDate1=(Date)dates.keySet().iterator().next();
										Date endDate1=(Date)dates.get(startDate1);
										if(endDate1.before(new Date()) || endDate1.equals(new Date()))
										{
											policyColumnObj.put("NextScheduleDate","Completed");
										}
										else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
										{
											SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
											policyColumnObj.put("NextScheduleDate",simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
										}
										else
										{
											policyColumnObj.put("NextScheduleDate",simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
										}
									}*/
									PolicyDetailsArr.add(policyColumnObj);	
								}
								if(CSVData!=null && CSVData.lastIndexOf(",")>0)
								{
									CSVData = CSVData.substring(0,CSVData.lastIndexOf(","));
								}
								csvList.add(CSVData);
								columnNameObj.put("policyDetails",PolicyDetailsArr);
								columnNameArr.add(columnNameObj);
							}					
						}
						mainsummary.put(category,columnNameArr);
						//result.add(mainsummary);	
					}
				}
				rootJson.put("mainsummary", mainsummary);
			}
		}
		else 
		{
			rootJson.put("Nodata",_mapping.getTextDescription("admin.common.No data available"));
		}
	}
	else if(option!=null && option.equals("Policy"))
	{
		JSONObject screenLabels=new JSONObject();
		csvList.add("");
		JSONArray polictDetailsArr = new JSONArray();
		Hashtable policyDetails = (Hashtable)policyTimeline.get(element);
		Iterator detailsItr=policyDetails.keySet().iterator();
		JSONArray TimeLineArr = new JSONArray();
		JSONObject policyColumnObj = new JSONObject();
		boolean isGrupAvail = false;
		
		Hashtable htDate = new Hashtable();
		String CSVPolicyData = ""; 
		while(detailsItr.hasNext()) 
		{
			JSONObject datevalue = new JSONObject();
			String mapkey1=(String)detailsItr.next();
			if(mapkey1!=null && mapkey1.equals("groups"))
			{
				isGrupAvail = true;
				ArrayList groupList = (ArrayList)policyDetails.get(mapkey1); 
				policyColumnObj.put("GroupName",groupList);
				String groups = "";
				for(int i=0;i<groupList.size();i++)
				{
					groups += (String)groupList.get(i)+",";
				}
				groups = groups.replace(",","  ");
				CSVPolicyData +=groups +",";
			}
			if(mapkey1!=null && mapkey1.equals("Status")) 
			{
				String status = (String)policyDetails.get(mapkey1); 
				if(status!=null && status.equals("true"))
				{
					status = "Active";
				}
				else
				{
					status = "Inactive";
				}
				CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy."+status)+",";
				policyColumnObj.put("status",status);
			}
			if(mapkey1!=null && mapkey1.equals("TimeFreq"))
			{			
				Hashtable policyDetailsTable = (Hashtable)policyDetails.get(mapkey1);
				Iterator policyDetailsTableItr=policyDetailsTable.keySet().iterator();
				while(policyDetailsTableItr.hasNext()) 
				{
					String mapkey=(String)policyDetailsTableItr.next();
					Vector timelineVec = (Vector)policyDetailsTable.get(mapkey);
					String dispCol="";	
					if(mapkey.equals("FDM"))
					{
						dispCol="First Day Of Month";
					}
					else if(mapkey.equals("LDM")) 
					{
						dispCol="Last Day Of Month";
					}
					else if(mapkey.equals("*")) 
					{
						dispCol="Daily";
					}
					else if(mapkey.startsWith("Every"))
					{
						String suffix = "th";
						if(mapkey.endsWith("1") || mapkey.endsWith("21") || mapkey.endsWith("31"))
						{
							suffix = "st";
						}
						else if(mapkey.endsWith("2") || mapkey.endsWith("22"))
						{
							suffix = "nd";
						}
						else if(mapkey.endsWith("3") || mapkey.endsWith("23"))
						{
							suffix = "rd";
						}
						dispCol = com.egurkha.util.StringUtils.replace(mapkey,"_"," ")+suffix+" day of the month";
					}
					else if(mapkey.startsWith("Sun") || mapkey.startsWith("Mon") || mapkey.startsWith("Tue") || mapkey.startsWith("Wed") || mapkey.startsWith("Thu") || mapkey.startsWith("Fri") || mapkey.startsWith("Sat")) 
					{
						if(mapkey!=null && mapkey.indexOf("$")>0 && mapkey.indexOf("_")>0)
						{
							String dayVal = mapkey.substring(0,mapkey.indexOf("$"));
							String week = mapkey.substring(mapkey.indexOf("$")+1);
							if(week.equalsIgnoreCase("week_1"))
							{
								week = "First";
							}
							else if(week.equalsIgnoreCase("week_2"))
							{
								week = "Second";
							}
							else if(week.equalsIgnoreCase("week_3"))
							{
								week = "Third";
							}
							else if(week.equalsIgnoreCase("week_4"))
							{
								week = "Fourth";
							}
							else if(week.equalsIgnoreCase("week_5"))
							{
								week = "Fifth";
							}
							dispCol=egM.DayForDescription(dayVal);
							dispCol = week+" "+dispCol.toLowerCase()+" of the month";
						}
						else
						{
							dispCol=egM.DayForDescription(mapkey);
						}
					}
					else 
					{
						dispCol=mapkey.replace('|','-');
					}
					String strDate = "";
					endDate = "";
					Vector val = new Vector();
					if(dispCol.indexOf("-")>0)
					{
						strDate = dispCol.substring(0,dispCol.indexOf("-"));
						endDate = dispCol.substring(dispCol.indexOf("-")+1);
						
						for(int i=0;i<timelineVec.size();i++)
						{
							String time = (String)timelineVec.get(i);
							String startTime=time.substring(0,time.indexOf("-"));
							String endTime=time.substring(time.indexOf("-")+1,time.length());
							String timeMsg= "";
							
							String strHr = startTime.substring(0,startTime.indexOf(":"));
							String strMin = startTime.substring(startTime.indexOf(":")+1);
							endHr = endTime.substring(0,endTime.indexOf(":"));
							String endMin = endTime.substring(endTime.indexOf(":")+1);
							
							String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
							String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);	
							String start_Date = (String) converterStart.getDate(false);
							String end_Date = (String) converterEnd.getDate(false);

							start_Date = DateUtil.changeDateFormat(start_Date, "MM/dd/yyyy", userDtFormat);
							end_Date = DateUtil.changeDateFormat(end_Date, "MM/dd/yyyy", userDtFormat);
							dispCol = start_Date+"-"+end_Date;
							strHr = converterStart.getHour();
							endHr = converterEnd.getHour();
							strMin = converterStart.getMinute();
							endMin = converterEnd.getMinute();
							timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;

							if(htDate!=null && htDate.containsKey(dispCol))
							{
								Vector existVector = (Vector)htDate.get(dispCol);
								existVector.add(timeMsg);
								htDate.put(dispCol, existVector);
							}
							else
							{
								val = new Vector();
								val.add(timeMsg);
								htDate.put(dispCol, val);
							}
						}
					}
					else
					{											
						for(int i=0;i<timelineVec.size();i++)
						{
							String time = (String)timelineVec.get(i);
							String startTime=time.substring(0,time.indexOf("-"));
							String endTime=time.substring(time.indexOf("-")+1,time.length());
							String timeMsg= "";
							if(strDate.equals("") && endDate.equals(""))
							{
								strDate = stDate;
								endDate = stDate;
							}
							if(!strDate.equals("") && !endDate.equals(""))
							{
								String strHr = startTime.substring(0,startTime.indexOf(":"));
								String strMin = startTime.substring(startTime.indexOf(":")+1);

								endHr = endTime.substring(0,endTime.indexOf(":"));
								String endMin = endTime.substring(endTime.indexOf(":")+1);

								String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
								EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
								String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
								EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);
								
								strHr = converterStart.getHour();
								endHr = converterEnd.getHour();
								strMin = converterStart.getMinute();
								endMin = converterEnd.getMinute();
								timeMsg=strHr+":"+strMin+"-"+endHr+":"+endMin;
							}
							dispCol = _mapping.getTextDescription("admin.mpolicy."+dispCol);
							if(htDate!=null && htDate.containsKey(dispCol))
							{
								Vector existVector = (Vector)htDate.get(dispCol);
								existVector.add(timeMsg);
								htDate.put(dispCol, existVector);
							}
							else
							{
								val = new Vector();
								val.add(timeMsg);
								htDate.put(dispCol, val);
							}
						}
					}
				}
			}
		}				
		if(htDate!=null)
		{
			Set timeKeyset=htDate.keySet();
			Iterator timeKeysetItr=timeKeyset.iterator();
			while(timeKeysetItr.hasNext())
			{
				JSONObject datevalue=new JSONObject();
				JSONArray minarray=new JSONArray();
				String key=(String)timeKeysetItr.next();
				Vector timeVec = (Vector)htDate.get(key);
				CSVPolicyData +=key+",";
				datevalue.put("Date",key);
				for(int i =0;i<timeVec.size();i++)
				{
					String time = (String)timeVec.get(i);
					CSVPolicyData +=time+",";
					JSONObject minobject=new JSONObject();
					minobject.put("Timeperiods",time);
					minarray.add(minobject);
				}
				datevalue.put("Time",minarray);
				TimeLineArr.add(datevalue);	
			}
		}
		policyColumnObj.put("TimeFrequency",TimeLineArr);
		String tableColumn = "";
		if(isGrupAvail)
		{
			tableColumn = "Groups,Status,Timeline,,Associated Elements";
		}
		else
		{
			//tableColumn = "Status,Timeline,,Associated Elements";
			tableColumn = _mapping.getTextDescription("admin.mpolicy.Status")+","+_mapping.getTextDescription("admin.mpolicy.Timeline")+","+_mapping.getTextDescription("admin.mpolicy.Associated Elements");
		}
		CSVPolicyData +="\n";
		csvList.add(tableColumn);
		csvList.add("");
		if(isData)
		{
			JSONArray AssociatedElements=new JSONArray();
			JSONArray assoForCompHostDesc=new JSONArray();
			if(data!=null && data.size()>0)
			{
				for(int k=0;k<data.size();k++) 
				{	
					String CSVData = "";
					Vector csvdispTitle = new Vector();
					Hashtable mappedkeys=(Hashtable)data.get(k);
					if(mappedkeys!=null && mappedkeys.size()>0) 
					{
						JSONObject mainsummary=new JSONObject();
						Iterator mappitr=mappedkeys.keySet().iterator();
						JSONObject columnNameObj=new JSONObject();
						JSONObject assoForCompHostDescObj=new JSONObject();
						String tmpElemnts ="";
						
						JSONArray AssociateTitleArr = new JSONArray();
						while(mappitr.hasNext()) 
						{
							String assElements = "";
							JSONObject AssociateTitleobj = new JSONObject();
							String mapkey=(String)mappitr.next();
							ArrayList associatedElements = (ArrayList)mappedkeys.get(mapkey);
							
							if(k==3)
							{
								if(associatedElements!=null && associatedElements.size()>0)
								{
									assElements +="Test,Host\n";
								}
							}
							else if(k==4)
							{
								if(associatedElements!=null && associatedElements.size()>0)
								{
									assElements +="Test,Component\n";
								}
							}
							else if(k==6)
							{
								if(associatedElements!=null && associatedElements.size()>0)
								{
									assElements +="Descriptor,Component\n";
								}
							}
							ArrayList elemList = new ArrayList();
							for(int i=0;i<associatedElements.size();i++)
							{
								String assValue = "";
								String elemnts = (String)associatedElements.get(i);								
								if(elemnts!=null && elemnts.indexOf("#")>0)
								{
									String columname = elemnts.substring(0,elemnts.indexOf("#"));
									String hostName = elemnts.substring(elemnts.indexOf("#")+1);
									if(elemList!=null && !elemList.contains(columname))
										elemList.add(columname);
									if(k==3 || k==4)
									{
										columname = _mapping.getTestDescription(columname);
									}
									//******--Repalcing--Hash--Starts--*****---//
									if(columname!=null&& columname.indexOf("|HASH|")>0)
									{
										columname = StringUtils.replace(columname,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//	
									AssociateTitleobj.put("AssciatedName",columname);
									AssociateTitleobj.put("AssciatedValue",hostName);
									AssociateTitleArr.add(AssociateTitleobj);
									assValue +=""+columname+","+hostName+"\n";
									assElements +=assValue;
								}
								else
								{
									if(k==2)
									{
										elemnts = _mapping.getTestDescription(elemnts);
									}
									//******--Repalcing--Hash--Starts--*****---//
									if(elemnts!=null&& elemnts.indexOf("|HASH|")>0)
									{
										elemnts = StringUtils.replace(elemnts,"|HASH|","#");
									}
									//******--Repalcing--Hash--Ends--*****---//	
									tmpElemnts +=elemnts+", ";	
								}
							}	
							if(k==0) 
							{
								columnNameObj.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Host"));
								if(tmpElemnts!=null && !tmpElemnts.equals(""))
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Host")+":";
								}
							}
							else if(k==1)
							{
								columnNameObj.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Component"));
								if(tmpElemnts!=null && !tmpElemnts.equals(""))
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Component")+":";
								}
							}
							else if(k==2)
							{
								columnNameObj.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Test"));
								if(tmpElemnts!=null && !tmpElemnts.equals(""))
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Test")+":";
								}
							}
							else if(k==3)
							{
								if(AssociateTitleArr!=null && !AssociateTitleArr.isEmpty())
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Test For Host")+":";
									assoForCompHostDescObj.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Test For Host"));
									assoForCompHostDescObj.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Test"));
									assoForCompHostDescObj.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Host"));
								}
							}
							else if(k==4)
							{
								if(AssociateTitleArr!=null && !AssociateTitleArr.isEmpty())
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Test For Component")+":";
									assoForCompHostDescObj.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Test For Component"));
									assoForCompHostDescObj.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Test"));
									assoForCompHostDescObj.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Component"));
								}
							}
							else if(k==5)
							{
								if(tmpElemnts!=null && !tmpElemnts.equals(""))
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Descriptor")+":";
								}
								columnNameObj.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Descriptor"));
							}
							else if(k==6)
							{
								if(AssociateTitleArr!=null && !AssociateTitleArr.isEmpty())
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Descriptor For Component")+":";
									assoForCompHostDescObj.put("AssociatedTitle",_mapping.getTextDescription("admin.mpolicy.Descriptor For Component"));
									assoForCompHostDescObj.put("AssciatedName1",_mapping.getTextDescription("admin.mpolicy.Descriptor"));
									assoForCompHostDescObj.put("AssciatedName2",_mapping.getTextDescription("admin.mpolicy.Component"));
								}
							}
							else if(k==7)
							{
								columnNameObj.put("AssciatedName",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop"));
								if(tmpElemnts!=null && !tmpElemnts.equals(""))
								{
									CSVPolicyData +=_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop")+":";
								}
							}
							
							if(tmpElemnts!=null && tmpElemnts.lastIndexOf(",")>0)
							{
								tmpElemnts = tmpElemnts.substring(0,tmpElemnts.lastIndexOf(","));
							}	
							if(k==0 || k==1 || k==2 || k==5 || k==7) 
							{								
								columnNameObj.put("AssciatedValue",tmpElemnts);
								AssociatedElements.add(columnNameObj);
								//tmpElemnts = tmpElemnts.replace(",","   ");
								assElements +=tmpElemnts;
							}
							else
							{
								assoForCompHostDescObj.put("AssociateTitleobj",AssociateTitleArr);
								assoForCompHostDesc.add(assoForCompHostDescObj);
							}
							assElements +="\n";
							CSVPolicyData +=assElements;
						}
					}
				}
			}
			policyColumnObj.put("AssociatedElements", AssociatedElements);	 
			policyColumnObj.put("AssociatedElementsForCompTestDesc", assoForCompHostDesc);	 
		}		
		csvList.add(CSVPolicyData);
		if(isGrupAvail)
		{
			screenLabels.put("GroupsLbl",_mapping.getTextDescription("admin.mpolicy.Groups"));
		}
		
		screenLabels.put("StatusLbl",_mapping.getTextDescription("admin.mpolicy.Status"));
		screenLabels.put("TimelineLbl",_mapping.getTextDescription("admin.mpolicy.Timeline"));
		screenLabels.put("AssoElements",_mapping.getTextDescription("admin.mpolicy.Associated Elements"));
		
		policyColumnObj.put("screenLabels", screenLabels);	 
		polictDetailsArr.add(policyColumnObj);
		rootJson.put("mainsummary",policyColumnObj);
	}	
	reportAttributes.setReportName("Maintenancepolicy");
	reportAttributes.setModule("MaintenancePolicy");
	reportAttributes.setPortrait(true);
	pdfData.setAttributes(reportAttributes);
	pdfData.setData(aListPdfData);
	session.setAttribute("pdfData",pdfData);
	session.setAttribute("list",csvList);
	session.setAttribute("isAuditlogCSV","true");


	response.getWriter().write(rootJson.toString());
}
catch(Throwable e)
{	
	e.printStackTrace();
}
%>
<%!
	public String getTimeLineForCsv(Hashtable timeVal,String displayName,EgMaintenanceUtility egM,String currentDateFormat,User _user)
	{
		String userDtFormat = _user.getUserDateFormat();
		if(userDtFormat != null && userDtFormat.length() > 0)
		{
			if(userDtFormat.equalsIgnoreCase("default"))
				userDtFormat = currentDateFormat;
		}
		StringBuffer timeString=new StringBuffer();
		Iterator itr2=null;
		Object timeDur=(Object)timeVal.get(displayName);
		Hashtable timeDur1=null;
		if(timeDur instanceof Hashtable)
		{
			timeDur1=(Hashtable)timeDur;
		}
		else if(timeDur instanceof Vector)
		{
			Vector tmp=(Vector)timeDur;
			timeDur1=(Hashtable)tmp.get(1);
		}
		if(timeDur1!=null)
		{
			itr2=timeDur1.keySet().iterator();
			Vector timeColumn1=new Vector();
			String timeKey1="";
			while(itr2.hasNext())
			{
				timeKey1=(String)itr2.next();
				timeColumn1.add(timeKey1);
			}
			String dispCol1="";
			for(int m=0;m<timeColumn1.size();m++)
			{
				String colName1=(String)timeColumn1.get(m);
				if(colName1.equals("FDM"))
				{
					dispCol1="First Day Of Month";
				}
				else if(colName1.equals("LDM"))
				{
					dispCol1="Last Day Of Month";
				}
				else if(colName1.equals("*"))
				{
					dispCol1="Daily";
				}
				else if(colName1.equals("Sun") || colName1.equals("Mon") || colName1.equals("Tue") || colName1.equals("Wed") || colName1.equals("Thu") || colName1.equals("Fri") || colName1.equals("Sat"))
				{
					dispCol1=egM.DayForDescription(colName1);
				}
				else
				{
					dispCol1=colName1.replace('|','-');
				}				

				//timeString.append(dispCol1);
				String strDate = "";
				String endDate = "";
				if(dispCol1.indexOf("-")>0)
				{
					strDate = dispCol1.substring(0,dispCol1.indexOf("-"));
					endDate = dispCol1.substring(dispCol1.indexOf("-")+1);
					String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
					EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" 00:00",_user);
					String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
					EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" 00:00",_user);
					strDate = (String) converterStart.getDate(false);
					endDate = (String) converterEnd.getDate(false);
					dispCol1 = strDate+"-"+endDate;
				}
				timeString.append(dispCol1);
				Vector  timeVal1=(Vector)timeDur1.get(colName1);
				if(timeVal1!=null && timeVal1.size()>0)
				{
					for(int n=0;n<timeVal1.size();n++)
					{
						String time1=(String)   timeVal1.get(n);
						String startTime1=time1.substring(0,time1.indexOf("-"));
						String endTime1=time1.substring(time1.indexOf("-")+1,time1.length());
						String timeMsg1="";
						if(!strDate.equals("") && !endDate.equals(""))
						{
							String strHr = startTime1.substring(0,startTime1.indexOf(":"));
							String strMin = startTime1.substring(startTime1.indexOf(":")+1);

							String endHr = endTime1.substring(0,endTime1.indexOf(":"));
							String endMin = endTime1.substring(endTime1.indexOf(":")+1);

							String dispStartDate = DateUtil.changeDateFormat(strDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr+":"+strMin,_user);
							String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
							EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr+":"+endMin,_user);							
							strHr = converterStart.getHour();
							endHr = converterEnd.getHour();
							strMin = converterStart.getMinute();
							endMin = converterEnd.getMinute();	

							
							timeMsg1=strHr+":"+strMin+"-"+endHr+":"+endMin;
						}
						else
						{
							timeMsg1=startTime1+"-"+endTime1;
						}
						timeString.append(" ");
						timeString.append(timeMsg1);
					}
				}
				if(timeColumn1.size()>1)
					timeString.append(",");
			}
		}
		return timeString.toString();
	}
	public String getNextScheduleDateForCsv(String option,Hashtable temp,String allkey,String dispallkey,EgMaintenanceUtility egM,String currentDateFormat)
	{
		StringBuffer nextTimeStr=new StringBuffer();
		Hashtable dates=new Hashtable();
		if(option !=null && option.equals("Test For Host") || option.equals("Test For Component") || option.equals("Descriptor For Component"))
		{
			Vector elementNames=new Vector();
			Vector elementnames=new Vector();
			Vector hashValue1=new Vector();
			elementnames=egM.getAssociatedHostsOrComponentsForTests(allkey);
			dates=egM.getNextScheduleTimeForHosttestOrComponenttest(allkey,elementnames);
			if(dates!=null && dates.size()==0)
			{
				hashValue1=(Vector)temp.get(dispallkey);
				Vector  comps1 = null;
				if ( hashValue1 != null && !hashValue1.isEmpty() )
				{
					comps1 = (Vector)hashValue1.get(0);
				}
				if(comps1!=null && comps1.size()>0)
				{
					if(comps1.size()==1)
					{
						String host1=(String)comps1.get(0);
						elementNames.add(host1);
						dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
					}
					else
					{
						for(int c1=0;c1<comps1.size();c1++)
						{
							String host1=(String)comps1.get(c1);
							elementNames.add(host1);
							dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
						}
					}
				}
			}
		}
		else if(option!=null && option.equals("Host") || option.equals("Component") || option.equals("Test") || option.equals("Descriptor"))
		{
			if(option.equals("Test"))
			{
				dates=egM.getNextScheduleTimeForTest(allkey);
				if(dates!=null && dates.size()==0)
					dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
				
			}
			else
			{
				dates=egM.getNextScheduleTimeForHost(allkey);
				if(dates!=null && dates.size()==0)
				{
					if(option.equals("Descriptor"))
					{
						
						String modKey="#"+allkey;
						dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
					}
					else
					{
						dates=egM.getUnplannedNextScheduleTimeForHost(allkey);
					}
					if(dates.size()==0)  
						dates=egM.getNextScheduleTimeForHost(allkey);
				}
			}
		}
		if(dates!=null && dates.size()>0)  
		{
			SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
			Date startDate1=(Date)dates.keySet().iterator().next();
			Date endDate1=(Date)dates.get(startDate1);
			if(endDate1.before(new Date()) || endDate1.equals(new Date()))
			{
				nextTimeStr.append("Completed");
			}
			else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
			{
				SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
			}
			else
			{
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
			}
		}
		return nextTimeStr.toString();
	}
%>


