<%
/**
 *	Processing page for EgNewServer.jsp
 *
 *	@author		Sridevi.T
 *	@created	7/09/2000
 *	@modified	26/03/2003	Sandhya		NICKNAMES
 *				23/04/2003	Arun		Disallow nickname change if already used in a topology
 *				24/04/2003	Arun		Sandhya made me revert to singleserver checks because the results page
 *										was not shown properly.
 *				25/04/2003	Arun		Nickname changes are saved in all relevant INIs and DB tables
 *				26/04/2003	Saravanan	Srinivas made me revert to single server checks!
 *				05/09/2003	Arun		Update UserRegistry when a new segment is added
 *				26/05/2004	Arun		Updates Internal_agent_mapping in eg_external.ini when
 *										different nicknames are managed by the same agent.
 *				09/07/2004	Arun		Updated eg_external.ini if client emulation is set for the component.
 *				15/07/2004	Arun		Changes made to Remote/External agents should be reflected in the DB.
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "java.sql.*" %>

<%@ page import = "com.egurkha.admin.ComponentAdd"%>
<%@ page import = "com.egurkha.admin.UpdateNicknames" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.UserAssociateComponent"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgTopoInfo"%> 
<%@ page import = "com.egurkha.admin.EgUserDataAdmin"%>
<%@ page import = "egurkha.EgUIUtils"%>
<%@ page import = "egurkha.EgDBConnectUI"%>
<%@ page import = "egurkha.TestConfigSpecsBean"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "egurkha.ServerBean"%>
<%@ page import = "egurkha.LayerBean"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "java.util.UUID"%>
<%@ page import = "java.util.Map.Entry"%>
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />

<%!
	/*****************************************************************
	* below method is copied from EgSpecsInfo.java
	* public String findTest ()
	* 	find a the right test in the test mapping section
	*	e.g., ProcessTest:: or ProcessTest:Web_server:...
	******************************************************************/
	public String findTest(String test, String server,String vars[])
	{
		int c = vars.length;
		StringBuffer sb = new StringBuffer(128);
		synchronized (sb)
		{
			sb.append(test);
			sb.append(":");
			sb.append(server);
			sb.append(":");
		}
		String s = sb.toString();
		for (int i = 0; i < c; i++)
		{
			if (vars[i].startsWith(s))
				return (vars[i]);
		}
		StringBuffer sb2 = new StringBuffer(128);
		synchronized (sb2)
		{
			sb2.append(test);
			sb2.append("::");
		}
		s = sb2.toString();
		for (int i = 0; i < c; i++)
		{
			if (vars[i].startsWith(s))
				return (vars[i]);
		}
		return (null);
	}

	private ArrayList getCertCheckTypes()
	{
		ArrayList tmpList = EgInstallInfo.getCertCheckList();
		ArrayList res = new ArrayList();
		if (tmpList != null)
		{
			int size = tmpList.size();
			for (int t=0; t<size; t++)
			{
				String compType = (String)tmpList.get(t);
				compType = EgCrypt.decrypt(compType);
				res.add(compType);
			}
		}
		return res;
	}
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	String selectedServerGroup = request.getParameter("selectedServerGroup");
	if (selectedServerGroup == null)
	{
		selectedServerGroup = "-1";
	}
	String stype = request.getParameter("stype");
	if (stype!=null && stype.indexOf(",") != -1)
	{
		rootJSON.put("requestStatus","failed");
		JSONObject objTmp = new JSONObject();
		rootJSON.put("Error_Title",_mapping.getTextDescription("admin.error.Add Component"));
		objTmp.put("Error_Msg_1",_mapping.getTextDescription("admin.error.An invalid component type has been detected")+".");
		objTmp.put("Error_Msg_2",_mapping.getTextDescription("admin.error.Please try again")+".");		
		rootJSON.put("Error_Info",objTmp);
		out.println(rootJSON);
		return;
	}
	String treeViewSrc = request.getParameter("treeViewSrc");
	String fromResultPage = request.getParameter("fromResultPage");
	String dispCompName = request.getParameter("dispCompName");
	String mserver = request.getParameter("modifyserver");
	String oldhostname=request.getParameter("oldhostname");
	rootJSON.put("selectedServerGroup",selectedServerGroup);
	rootJSON.put("selectedServer",stype);
		
	boolean isAggregateLink = stype != null && stype.startsWith("Agg_");
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isNamedUsersCert = EgInstallInfo.isnamedUserLicense;

	egurkha.ConfigTopology EgConfigTopo = new egurkha.ConfigTopology();
	egurkha.ServiceBean servicer = new egurkha.ServiceBean();
	egurkha.UserBean user = new egurkha.UserBean();
	egurkha.TestConfigSpecsBean testlist = new egurkha.TestConfigSpecsBean();

%>


<%!
	private String removeSpaces(List l)
	{
		StringBuffer strBuffer = new StringBuffer();
		for(int i=0;i<l.size();i++)
		{
			strBuffer.append(((String)l.get(i)).trim());
			strBuffer.append(",");
		}
		String tempStr = strBuffer.toString().trim();
		return tempStr.substring(0,tempStr.length()-1);
	}
	//skm
%>

<%
	EgConfigTopo.createFile("eg_services.ini");
	int compSize = Integer.parseInt(EgConfigTopo.getValues("MISC_ARGS","MaxManagedComponentsForDisc"));
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	String[] sTypes = egRoleInfo.getServerTypes();
	boolean hasLimitExceeded=false;
	Vector managedAllComps = egDiscInfo.getAllManagedComponents();
	if (managedAllComps != null && (managedAllComps.size() > compSize))
	{
		hasLimitExceeded = true;
	}
	/* for user-comp mapping - START*/
	int usrLicStatus = 0;
	//String userExtAgent = "";
	String user_id = _user.getLoginID();
	EgCertUsage egCertUsage = new EgCertUsage();
	ArrayList usersList = egCertUsage.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList != null && usersList.contains(user_id));
	boolean isMspModel = EgUuidInfo.isMspModel();
	String userCompMap = EgConfigInfo.egMgrConfigDir + "eg_usercompmapping.ini";
	UserAssociateComponent uacObj = new UserAssociateComponent(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId());
	EgUuidInfo uuidInfo = new EgUuidInfo();
	/* for user-comp mapping - END*/

	HashSet autoConfigHVCompsForAuditLog = new HashSet();

	/*int cnt=0;
	if (sTypes != null && sTypes.length > 0)
	{
		for (int st=0;st<sTypes.length;st++)
		{
			String[] strComps = egRoleInfo.getAllServersOfType(sTypes[st]);
			if (strComps.length > 0)
			{
				cnt = cnt + strComps.length;
				if (cnt > compSize)
				{
					hasLimitExceeded = true;
					break;
				}
			}
		}
	}*/
	String junk = "";
	String var = "";
	String new_var = "";
	String new_var_name = "";
	String hsid = "";
	String prevSid = null;
	String strCombine = "";
	boolean needSave = false;
	//String stype = request.getParameter("stype");
	String hostip = request.getParameter("hostip");
	String hostname = "";
	String sportno = request.getParameter("sportno");
	String previousportnumber=request.getParameter("previousportnumber");
	String hportno = request.getParameter("hportno");
	if(mserver == null || !mserver.equals("true"))
	{
		hportno = sportno;
	}
	String mtscheck = request.getParameter("mts");
	String strPass = request.getParameter("strPass");
	String action = request.getParameter("action");

	//Issue :Add comp1. Then add comp2 to same server by clickhere option in comp1 Result page. comp1 get removed.
	if(!StringUtils.isNull(fromResultPage) && fromResultPage.equals("true"))
	{
		oldhostname = "";
	}
	String remoteAgent = "";
	//String remoteAgent = request.getParameter("remoteAgent");
	//String rumRemAgent = request.getParameter("rumRemAgent");
	String rumUrl = "";
	String rumService = "";
	String remoteUser = request.getParameter("aluser");
	String remotepwd = request.getParameter("alpwd");
	String remotemode = request.getParameter("almode");
	String remotealos = request.getParameter("alos");
	String sshPort = request.getParameter("sshPort");
	String remoteType = request.getParameter("enableRemoteAgent");
	String remoteEncrypt = request.getParameter("alencrypt");
	String remoteKeyFile = request.getParameter("alkeyfile");
	/*....... For Auto Topology .... (Start)*/
	String frmTopology = request.getParameter("frmTopology");
	String frmPage = request.getParameter("frmPage");
	String topoSegName = request.getParameter("topoSegName");
	String initPort = request.getParameter("initPort");
	/*....... For Auto Topology .... (End)*/
	String hostNameToCertCheck = oldhostname;
	String server_type = request.getParameter("servertype");
	String server_name = request.getParameter("servername");
	boolean addHostAsAgent = false;
	IniFile extObj = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
	Vector nickAloneServerList = extObj.getVariables("NickName_Alone_Servers",true);

	String[] compAgentGenVars = extObj.getVariables("Auto_Agent_Creation");
	ArrayList compAgentGenVarsList = new ArrayList();
	if(compAgentGenVars != null && compAgentGenVars.length > 0)
	{
		compAgentGenVarsList = new ArrayList(Arrays.asList(compAgentGenVars));
	}
	if(stype != null && stype != "")
	{
		if(stype.equals("Real_user_monitor"))
		{
			String isJavaSelected = request.getParameter("isJavaSelected");
			String isDotNetSelected = request.getParameter("isDotNetSelected");
			String isOthersSelected = request.getParameter("isOthersSelected");
			StringBuffer sbf = new StringBuffer();
			if(isJavaSelected.equals("true"))
				sbf.append("Java").append(",");
			if(isDotNetSelected.equals("true"))
				sbf.append("Dotnet").append(",");
			if(isOthersSelected.equals("true"))
				sbf.append("Others").append(",");;
			String selectedLanguages = sbf.toString();
			if(selectedLanguages != null && selectedLanguages.length() > 0)
				selectedLanguages = selectedLanguages.substring(0,selectedLanguages.lastIndexOf(","));
			remoteAgent = request.getParameter("rumRemAgent");
			rumUrl = request.getParameter("rumUrl");
			rumService = request.getParameter("rumService");
			hostname= request.getParameter("rumNickName");
			server_name = hostname + server_name;
			remoteType = "true";
			remotemode = "Perfmon";
			sportno = "NULL";
			if(rumUrl != null && rumUrl != "")
			{
				IniFile testsIniwr = 	EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
				
				if(mserver!=null &&  mserver.equals("true"))
				{
					if(dispCompName!=null && !dispCompName.trim().equals(hostname))
					{
						testsIniwr.deleteValue("Real_user_monitor_URL_Mapping",dispCompName);
						testsIniwr.setValue("Real_user_monitor_URL_Mapping",hostname,rumUrl);
						String old_siteName=testsIniwr.getValue("Real_user_Website_Mapping",dispCompName);
						if(old_siteName!=null && old_siteName.equals(""))
						{
							testsIniwr.deleteValue("Real_user_Website_Mapping",dispCompName);
							testsIniwr.setValue("Real_user_Website_Mapping",hostname,old_siteName);
						}
					}
					else
					{
						testsIniwr.setValue("Real_user_monitor_URL_Mapping",hostname,rumUrl);
						testsIniwr.setValue("RUM_Language_Mapping",hostname,selectedLanguages);
					}
				}
				else
				{
					testsIniwr.setValue("Real_user_monitor_URL_Mapping",hostname,rumUrl);
					testsIniwr.setValue("RUM_Language_Mapping",hostname,selectedLanguages);
				}
				testsIniwr.saveFile();
				EgConfigFilesSync.releaseInstance(testsIniwr);
			}
		}
		else
		{
			remoteAgent = request.getParameter("remoteAgent");
			hostname = request.getParameter("hostname");
			
			if(stype.equalsIgnoreCase("NodeJS"))
			{
				Hashtable nickIpMap= egDiscInfo.getNickIpMap();
				String agentHostIP="localhost";
				if(remoteAgent!=null && remoteAgent.length()>0){
					agentHostIP =(String)nickIpMap.get(remoteAgent);
				}
				
				ArrayList attNodeList=new ArrayList();
				rootJSON.put("hostName",hostname);
				rootJSON.put("portNo",sportno);
				rootJSON.put("agentHostIP",agentHostIP);
			}
		}
		if(compAgentGenVarsList != null && compAgentGenVarsList.contains(stype))//For remote Agent Add
		{
			addHostAsAgent = true;
		}
	}

	//Nickname formation with suffix for special comp types
	IniFile mgrmiscIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String splComponents[] = mgrmiscIni.getVariables("Microsoft_Components");
	ArrayList splCompList = new ArrayList(Arrays.asList(splComponents));
	if (stype != null && splCompList.contains(stype))
	{
		String hostnameSuffix = request.getParameter("hostnameSuffix");
		String hostSuffix = (hostname.length()>4) ? hostname.substring(hostname.length()-4) : "";
		if (hostnameSuffix != null && hostnameSuffix.length()>0 && (!hostSuffix.equalsIgnoreCase(hostnameSuffix)))
		{
			hostname += hostnameSuffix;
		}
	}

	String[] nickAloneTypes = extObj.getVariables("NickName_Alone_Servers");
	List nickAloneTypesList = new ArrayList();
	boolean hideHostIPField = false;
	if (nickAloneTypes != null)
	{
		nickAloneTypesList = Arrays.asList(nickAloneTypes);
	}
	if (nickAloneTypesList.contains(stype))
	{
		hideHostIPField = true; 
	}
	if (hideHostIPField && (hostip == null || hostip.trim().equals("")))
	{
		hostip = hostname;
	}

	rootJSON.put("host_IP",hostip);
	rootJSON.put("host_Name",hostname);
	String host_ip = request.getParameter("hostIp");
	if (hostNameToCertCheck!= null && hostNameToCertCheck.trim().length() < 1)
	{
		hostNameToCertCheck = hostname;
	}
	IniFile serIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String servers[] = serIni.getVariables("AGENTLESS_SERVERS");
	ArrayList agentlessServers = null; // contains the list of agentless servers
	if (servers != null)
	{
		agentlessServers = new ArrayList(Arrays.asList(servers));
	}
	if (remoteType == null && agentlessServers != null && agentlessServers.contains(stype))
	{
		remoteType = "true";
	}

	String addCompForDiscovery = serIni.getValue("MISC_ARGS","AddComponentForDiscovery");
	
	//String remote_vmware = request.getParameter("remote_vmware");
	String vmwarehostentry = request.getParameter("vmwarehostentry");
	String siteSupport = request.getParameter("siteflag");				//.....For AggregateSite

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	
	/* code for auditlog starts */
	String auditNos = "01~~";
	String isAggType = request.getParameter("isAggregateType");
	boolean isAggregateType = (isAggType != null && isAggType.equals("true")?true:false);
	//String mserver = request.getParameter("modifyserver");
	boolean modifying = (mserver != null && mserver.equals("true"));
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	if(frmTopology !=null && frmTopology.equals("yes"))
	{
		if(frmPage!= null && frmPage.equalsIgnoreCase("configSeg"))
		{
			auditLogThread.setValue("Module","Configured Segments");
		}
		else if(frmPage!= null && frmPage.equalsIgnoreCase("DiscSeg")) 
		{
			auditLogThread.setValue("Module","Discovered Segments");
		}
	}
	else
	{
		auditLogThread.setValue("Module","Add/Modify Components");
	}

	if(isAggregateType)
	{
		remoteType = "true";
		remotemode = "Aggregate";
	}
	if(modifying)
	{		
		if(stype.endsWith("_ex"))
			auditLogThread.setValue("Description","Component "+hostname + " of type " +stype + " has been modified");
		else
			auditLogThread.setValue("Description","Component "+hostname + " of type " +"$ctype$:"+stype + " has been modified");
		auditLogThread.setValue("Activity","Modify Component");
	}
	else
	{
		if(stype.endsWith("_ex"))
		{
			auditLogThread.setValue("Description","Component "+hostname + " of type " +stype + " has been created");
		}
		else
		{
			if(!addHostAsAgent)
			{
				auditLogThread.setValue("Description","Component "+hostname + " of type " +"$ctype$:"+stype + " has been created");
			}
		}
		auditLogThread.setValue("Activity","Add Component");
	}
	/* code for auditlog ends */

	//for esx server
	String underVmware =request.getParameter("underVmware");
	String esxServer = request.getParameter("esxServer");
	//karthika for cloud
	String underCloud =request.getParameter("underCloud");
	String cloudServer = request.getParameter("cloudServer");

	if (underCloud != null && underCloud.equals("on")) // New ExtUI change 
	{
		underCloud = "true";
	}
	else
	{
		underCloud = "false";
	}
	

	if (underVmware != null && underVmware.equals("on")) // New ExtUI change 
	{
		underVmware = "true";
	}
	else
	{
		underVmware = "false";
	}
	
	String isPassive = request.getParameter("isPassive");
	if(isPassive == null)
		isPassive = "false";
	else
		isPassive = isPassive.toLowerCase();
		
	if (isPassive.equalsIgnoreCase("yes") || isPassive.equalsIgnoreCase("true"))
		isPassive = "true";
	else
		isPassive = "false";

	String intAgentMode = "";
	String currAgents = "";

	StringTokenizer st;
	String serverType = null;
	String oldAlias = null;
	String oldPort = null;
	String sid = request.getParameter("sid");
	String currAgent = request.getParameter("currAgents");
	intAgentMode = request.getParameter("intAgentMode");
	String s_nicks = "";
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	String prevRemAgent = externalInfo.getRemoteAgentForHost(hostname);
	if (oldhostname != null && oldhostname.length()>0)
	{
		prevRemAgent = externalInfo.getRemoteAgentForHost(oldhostname);
	}
	
	if (StringUtils.isNull(intAgentMode))
	{
		intAgentMode = "auto";
	}
	int index = strPass.indexOf(":");
	if (index > -1)
	{
		st = new StringTokenizer(strPass, ":");
		serverType = st.nextToken();
		oldAlias = st.nextToken();
		oldPort = st.nextToken();
		if (serverType.equals("Oracle_server"))
		{
			oldPort += ":"+sid;
		}
	}

	boolean remainTypeCheck = false;


	String[] allNicks = null;
	boolean allServers = (action != null && action.equals("allservers"));

	EgDiscInfo egdiscInfo = new EgDiscInfo("manager");
	ArrayList allNickNoCase = egdiscInfo.getAllNicks();
	boolean newNickAdded = !allNickNoCase.contains(hostname.toLowerCase());
	String[] oracleServers = egdiscInfo.getAllServersOfType("Oracle_server");
	
	String modify = request.getParameter("modify");
	modify = (modify != null && modify.equalsIgnoreCase("yes"))?"yes":"no";

	if (allServers)
	{
		Hashtable ht = new EgDiscInfo2("manager").getIpNickMap();
		s_nicks = (String)ht.get(hostip);
		if (s_nicks != null)
		{
			String[] tokens = StringUtils.getTokens(s_nicks, ":");
			if(modify.equals("yes"))
			{
				s_nicks = oldhostname;
				allNicks = new String[1];
				allNicks[0] = s_nicks;
			}
			else
			{
				allNicks = new String[tokens.length];
				System.arraycopy(tokens, 0, allNicks, 0, tokens.length);
			}
		}
	}
	else
	{
		allNicks = new String[1];
		allNicks[0] = oldhostname;
	}
	Hashtable agentsForOldHosts = externalInfo.getAgentsForHosts(allNicks);
	if (serverType == null)
	{
		serverType = stype;
		oldPort = sportno;
	}
	//strPass is the original value
	String variableName = strPass;

	Vector sess_vec = new Vector();
	if(isAggregateLink)
	{
		sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify Aggregate Components"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc);
		}
		else
		{
			sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype);
		}
		sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify Aggregate Components"));
	}
	else
	{
		sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify components"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
		}
		else
		{
			sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype+"&selectedServerGroup="+selectedServerGroup);
		}
		sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify components"));
	}
	if(action != null && !action.equals("null") && !action.equals(""))
	//if(!allServers)
	{
		sess_vec.add(_mapping.getTextDescription("admin.server.Parameters configured for")+" "+_mapping.getComponentTypeDescription(stype));
		if(isAggregateLink)
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.Aggregate component type")+" : "+_mapping.getComponentTypeDescription(stype));
		}
		else
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.Component type")+" : "+_mapping.getComponentTypeDescription(stype));
		}
		if(hostip != null && !hostip.equals("0.0.0.0"))
		{
			if(isAllowHostName)
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Host IP/Name")+"     : "+hostip);
			}
			else
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Host IP")+"     : "+hostip);
			}
		}
		sess_vec.add(_mapping.getTextDescription("admin.server.Nick name")+"   : "+removeNull(hostname)); 
		/* code for auditlog starts */
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		ArrayList siteServers = discInfo.getSiteServers();
		if(session.getAttribute("type").toString().equals("new"))
		{
			if(stype.endsWith("_ex"))
				auditLogThread.setCurrentValue(auditNos+"Component Type",stype);
			else
			{
				if(isAggregateLink)
				{
					auditLogThread.setCurrentValue(auditNos+"Aggregate component Type","$ctype$:"+stype);
				}
				else
				{
					auditLogThread.setCurrentValue(auditNos+"Component Type","$ctype$:"+stype);
				}
			}
			if (!isAggregateType && !hideHostIPField)	
			{
				auditNos = "02~~";
				if (isAllowHostName)
				{
					auditLogThread.setCurrentValue(auditNos+"Host IP/Name",hostip);
				}
				else
				{
					auditLogThread.setCurrentValue(auditNos+"Host IP",hostip);
				}
			}
			auditNos = (auditNos.equals("02~~")) ? "03~~" : "02~~" ;
			auditLogThread.setCurrentValue(auditNos+"Nick Name",hostname);
			if(isAggregateType)
			{
				if(siteServers.contains(stype))
				{
					String auditSiteValue = siteSupport.equals("true")?"Yes":"No";
					auditLogThread.setCurrentValue("Site Support",auditSiteValue);
				}
			}
		}
		else
		{
			auditNos = (auditNos.equals("02~~")) ? "03~~" : "02~~" ;
			String temp = request.getParameter("olderhostname");
			String oldSiteSupport = request.getParameter("oldsitesupport");
			if(temp == null || temp.equalsIgnoreCase("null"))
				temp = request.getParameter("oldhostname");
			auditLogThread.setPreviousValue(auditNos+"Nick Name",temp);
			if(isAggregateType)
			{
				if(siteServers.contains(stype))
				{
					String auditSiteValue = oldSiteSupport.equals("true")?"Yes":"No";
					auditLogThread.setPreviousValue("Site Support",auditSiteValue);
						auditSiteValue = siteSupport.equals("true")?"Yes":"No";
					auditLogThread.setCurrentValue("Site Support",auditSiteValue);
				}
			}
			auditLogThread.setCurrentValue(auditNos+"Nick Name",hostname);
			
			/* ------- THIS COMMENTED BLOCK IS HANDLED @ [UpdateNickNames.java] ------ */
			/* code starts */
			/* do not remove */
			/* when a component nick name is changed, it has to be reflected in Aggregate components */ 
			/*if(temp != null && !temp.equals(hostname))
			{
				ArrayList aggServerTypes = new ArrayList();
				ArrayList aggIniEntries = new ArrayList();
				IniFile aggWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
				String[] aggreagetComponents = aggWr.getVariables("AGGREGATE_COMPONENTS");
				if(aggreagetComponents !=null && aggreagetComponents.length>0)
				{
					for(int i=0;i<aggreagetComponents.length;i++)
					{
						String key = aggreagetComponents[i];
						String searchString = ":"+temp+":";								
						if(key.indexOf(searchString)!=-1)
						{
							String firstPart = key.substring(0,key.indexOf("#")+1);
							String secondPart = key.substring(key.indexOf("#")+1);
							secondPart = secondPart.substring(secondPart.indexOf(":")+1);
							String secondaryKey = ":" + firstPart + secondPart + ":";
							String keyValue = aggWr.getValue("AGGREGATE_COMPONENTS",aggreagetComponents[i]);
							//aggregateInfo.deleteValue("AGGREGATE_COMPONENTS",aggreagetComponents[i]);
							aggIniEntries.add(new IniHelper(IniHelper.DELETE,"AGGREGATE_COMPONENTS",aggreagetComponents[i],""));
							String replaceWith = ":"+hostname+":";
							key = StringUtils.replace(key,searchString,replaceWith);
							//aggregateInfo.setValue("AGGREGATE_COMPONENTS",key,keyValue);
							aggIniEntries.add(new IniHelper(IniHelper.SET,"AGGREGATE_COMPONENTS",key,keyValue));
							//aggregateInfo.saveFile();
							String[] aggregateTestInfosExclude = aggWr.getVariables("AGGREGATE_TEST_INFOS_EXCLUDED");
							if(aggregateTestInfosExclude != null && aggregateTestInfosExclude.length>0)
							{
								for(int idx=0;idx<aggregateTestInfosExclude.length;idx++)
								{
									String key1 = aggregateTestInfosExclude[idx];
									if(key1.indexOf(secondaryKey)>0)
									{
										String keyValue1 = aggWr.getValue("AGGREGATE_TEST_INFOS_EXCLUDED",key1);
										//aggregateInfo.deleteValue("AGGREGATE_TEST_INFOS_EXCLUDED",key1);
										aggIniEntries.add(new IniHelper(IniHelper.DELETE,"AGGREGATE_TEST_INFOS_EXCLUDED",key1,""));
										String searchString1 = "#" + temp + ":";
										String replaceWith1 = "#" + hostname + ":";
										String key12 = StringUtils.replace(key1,searchString1,replaceWith1);
										//aggregateInfo.setValue("AGGREGATE_TEST_INFOS_EXCLUDED",key12,keyValue1);
										//aggregateInfo.saveFile();
										aggIniEntries.add(new IniHelper(IniHelper.SET,"AGGREGATE_TEST_INFOS_EXCLUDED",key12,keyValue1));
									}
								}
							}
						}
					}
				}
				if (aggIniEntries.size() > 0)
				{
					//IniFile aggWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
					for (int agg=0;agg < aggIniEntries.size(); agg++)
					{
						IniHelper iniHelper= (IniHelper)aggIniEntries.get(agg);
						String iniAction = iniHelper.getAction();
						String sub = iniHelper.getSubject();
						String key = iniHelper.getVariable();
						String val = iniHelper.getValue();
						if (iniAction != null)
						{
							if (iniAction.equals(IniHelper.SET))
							{
								aggWr.setValue(sub,key,val);
							}
							else if (iniAction.equals(IniHelper.DELETE))
							{
								aggWr.deleteValue(sub,key);
							}
						}
					}
					aggWr.saveFile();
					//EgConfigFilesSync.releaseInstance(aggWr);
				}
				EgConfigFilesSync.releaseInstance(aggWr);
			}*/
			/* end of code */
		}
		/* code for auditlog ends */
	}

	//flag is a hidden parameter used to check for servers with no port
	//don't add sportno to sess_vec when PORT NO field is not displayed
	String flag = request.getParameter("flag");
	if(action != null && !action.equals("null") && !action.equals(""))
	//if (!allServers)
	{
		if(flag != null && flag.length()>0)
		{
			if(flag.equals("true"))
			{
				sportno = "NULL";
				hportno = "NULL";
			}
			else
			{
				auditNos = (auditNos.equals("03~~")) ? "04~~" : "03~~" ;
				sess_vec.add(_mapping.getTextDescription("admin.server.Port number")+" : "+sportno);
				/* code for auditlog starts */
				auditLogThread.setCurrentValue(auditNos+"Port Number",sportno);
				if(modifying)
				{
					String previousPortNumber = request.getParameter("previousportnumber");
					if(previousPortNumber !=null)
						auditLogThread.setPreviousValue(auditNos+"Port Number",previousPortNumber);
				}
				
				/* code for auditlog ends */
			}
		}
	}
	//For Virtual Server Host
		
	//egExtIni.createFile("eg_external.ini","save");
	IniFile extIniWr = null;
	extIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
	Vector virtualServers =externalInfo.getVirtualServers();
	if (virtualServers!=null && virtualServers.size()>0 && virtualServers.contains(stype))
	{
		extIniWr.setValue("Virtual_Hosts",stype+":"+hostname+":"+sportno,hostip);
	}
	//Added by karthika for Cloud servers
	Vector cloudServers = externalInfo.getCloudServers();
	if (cloudServers!=null && cloudServers.size()>0 && cloudServers.contains(stype))
	{
		extIniWr.setValue("Cloud_Hosts",stype+":"+hostname+":"+sportno,hostip);
	}
	extIniWr.saveFile();
	EgConfigFilesSync.releaseInstance(extIniWr);

	//end
	if(stype.equals("Oracle_server"))
	{
		auditNos = (auditNos.equals("04~~")) ? "05~~" : "04~~" ;
		sid = request.getParameter("sid");		//New SID
		hsid = request.getParameter("hsid");	//Old SID
		if (action != null && !action.equals("null") && !action.equals(""))
		//if (!allServers)
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.Sid")+" : "+sid);
		}
		if(variableName != null && !variableName.equals(""))
			variableName = variableName.substring(0,variableName.lastIndexOf(":"));
		/* code for auditlog starts */
		auditLogThread.setCurrentValue(auditNos+"SID",sid);
		if(modifying)
		{
			String previousSID = request.getParameter("previoussid");
			if(previousSID !=null && !previousSID.equals("null"))
				auditLogThread.setPreviousValue(auditNos+"SID",previousSID);
		}
		/* code for auditlog starts */
	}
	//When a server is deleted,it gets added in eg_disable.ini
	//A deleted server can only be manually added.
	//To manually add a deleted server,delete the corresponding server from
	//eg_disable.ini.This has to be done only when a new server is added.
	//New code
	String type =(String)session.getAttribute("type");
	if(type.equals("new") || modifying)
	{
		//EgConfigTopo.createFile("eg_disable.ini","save");
		IniFile disableIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
		if(!stype.equals("Oracle_server"))
		{
			var = stype + ":" + hostname + ":" + sportno;
			new_var_name = hostname.substring(hostname.indexOf(":")+1);
			new_var = hostname+":"+sportno+"#"+stype+"#"+new_var_name;
			//EgConfigTopo.deleteSpecValue("Deleted_Servers",var);
			disableIniWr.deleteValue("Deleted_Servers",var);
			/* [FORBIDDEN_SERVERS] entry are removed form eg_disable.ini,when you manage (Or) add the components-->S.Andrews	 */
			//EgConfigTopo.deleteSpecValue("FORBIDDEN_SERVERS",new_var);
		}
		else if(sid.indexOf(",")>=0)
		{
			st = new StringTokenizer(sid,",");
			int count = st.countTokens();
			for(int j=0; j<count; j++)
			{
				String tok = st.nextToken().trim();
				var  = stype +":" + hostname + ":" + sportno + ":" + tok;
				//EgConfigTopo.deleteSpecValue("Deleted_Servers",var);
				disableIniWr.deleteValue("Deleted_Servers",var);
				new_var_name = hostname.substring(hostname.indexOf(":")+1);
				new_var = hostname+":"+sportno+":"+tok+"#"+stype+"#"+new_var_name;
				//EgConfigTopo.deleteSpecValue("FORBIDDEN_SERVERS",new_var);
			}
		}
		else
		{
			var  = stype +":" + hostname + ":" + sportno + ":" + sid;
			//EgConfigTopo.deleteSpecValue("Deleted_Servers",var);
			disableIniWr.deleteValue("Deleted_Servers",var);
			new_var_name = hostname.substring(hostname.indexOf(":")+1);
			new_var = hostname+":"+sportno+":"+sid+"#"+stype+"#"+new_var_name;
			//EgConfigTopo.deleteSpecValue("FORBIDDEN_SERVERS",new_var);
		}

		disableIniWr.saveFile();
		EgConfigFilesSync.releaseInstance(disableIniWr);
	}
	if (stype.equals("IIS_web_server") || stype.equals("IIS_ssl_server"))
	{
		if(action != null && !action.equals("null") && !action.equals(""))
		//if (!allServers)
		{
			//get null when MTS Enabled options is disabled
			if(modifying && mtscheck == null)
			{
				if(request.getParameter("isMTSEnabled") != null && request.getParameter("isMTSEnabled").equals("Yes"))
				{
					mtscheck = "Yes";
				}
			}//end
				
			if (mtscheck==null||mtscheck.equalsIgnoreCase("null")||mtscheck.length()<=0)
				mtscheck="NONE";
			sess_vec.add(_mapping.getTextDescription("admin.server.MTS Enabled")+" : "+mtscheck);
			if(!modifying)
				auditLogThread.setCurrentValue("MTS Enabled",mtscheck);
		}
	}
	//Initialising the service bean and stopping discovery
	//To ensure integrity
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	servicer.stopDiscovery();
	//EgConfigTopo.createFile("eg_discover.ini","save");
	strPass = stype+":"+hostname+":"+sportno;

	if (sportno != null && !sportno.equals("null") && !sportno.equals(""))
	{
		if(!StringUtils.isNull(oldhostname))
		{
			strCombine = stype+":"+oldhostname +":"+hportno;
		}
		else
		{
			strCombine = stype+":"+hostname +":"+hportno;
		}
	}
	else
	{
		if(!StringUtils.isNull(oldhostname))
		{
			strCombine = stype+":"+oldhostname +":NULL";
		}
		else
		{
			strCombine = stype+":"+hostname +":NULL";
		}
	}

	//set properties to eg_agent component test for auto manage
	/*if(action != null && !action.equals("null") && !action.equals(""))
	{
		if(stype != null && stype.equals("eG_Agent") && type.equals("new") )
		{
			String jvm_port = "-Jmx_Remote_Port local";
			String alert_logFile = "-alertFile error_log";
			String searchPart = "-searchpattern "+"Warnings:*WARN*|Errors:*ERROR*";
			String processPart = "-process eGAgent:*java*EgMain*";
			String line = jvm_port+" "+alert_logFile+" "+searchPart+" "+processPart;
		//	System.out.println(" EgNewServerpJson line : "+line);
		//	System.out.println(" EgNewServerpJson strPass : "+strPass);
			//String var_line = stype+":"+hostname+":"+sportno;
			String discParamCompMap = EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini";
			IniFile discParamWrite = EgConfigFilesSync.getInstance(discParamCompMap);
			discParamWrite.setValue(stype,strPass,line);
			discParamWrite.saveFile();
			EgConfigFilesSync.releaseInstance(discParamWrite);
			//System.out.println(" EgNewServerpJson release eg_discoveryParams instances..");
		}
	}*/

	//added - checking SID whn modify the nick name to existing name.
	String SIDCheckForSameNick = null;
	//end
	Vector userCompIniDelList = new Vector();
	IniFile discWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discover.ini");
	/*IniFile userCompIniWrite = EgConfigFilesSync.getInstance(userCompMap);*/
	if(action != null && !action.equals("null") && !action.equals(""))
	//if (!allServers)
	{
		//EgConfigTopo.deleteSpecValue(stype,strCombine);
		if(stype.equals("Oracle_server"))
		{
			if(!StringUtils.isNull(hsid))
			{
				String[] oldSidTokens = StringUtils.getTokens(hsid, ",");
				for (int a=0; a<oldSidTokens.length; a++)
				{
					String temp =strCombine +":"+ oldSidTokens[a].trim();
					discWrite.deleteValue(stype,temp);
					if (isLimitedAdmin)
						userCompIniDelList.add(temp);
						/*userCompIniWrite.deleteValue(user_id,temp);*/
				}
			}
			else
			{
				discWrite.deleteValue(stype,strCombine);
				if (isLimitedAdmin)
					userCompIniDelList.add(strCombine);
					/*userCompIniWrite.deleteValue(user_id,strCombine);*/
			}
		}
		else
		{
			discWrite.deleteValue(stype,strCombine);
			if (isLimitedAdmin)
				userCompIniDelList.add(strCombine);
				/*userCompIniWrite.deleteValue(user_id,strCombine);*/
		}

		//Delete the existing value
		String strVar[] = EgConfigTopo.getVariables(stype);
		if (strVar!=null)
		for(int i_ctr = 0 ;i_ctr < strVar.length ; i_ctr++)
		{
			if(stype.equals("Oracle_server"))
			{
				if(variableName != null && !variableName.equals(""))
				{
					if(strVar[i_ctr].startsWith(strCombine) || strVar[i_ctr].startsWith(variableName))
					{
						/*
						 * Before deleting the spec value, get the SID of the resulting nickname, so that
						 * if such SIDs exist, they are not lost
						 */
						String temp = EgConfigTopo.getValues(stype, strVar[i_ctr]);
						if (temp != null && !temp.trim().equals(""))
						{
							String anSid = temp.substring(temp.lastIndexOf(",")+1);
							if (prevSid == null)
							{
								prevSid = anSid;
							}
							else
							{
								List list = Arrays.asList(StringUtils.getTokens(prevSid, ","));
								if (list.indexOf(anSid) == -1)
								{
									prevSid = prevSid +","+ anSid;
								}
							}
							//added - checking SID whn modify the nick name to existing name.
							List currSIDList = Arrays.asList(StringUtils.getTokens(sid, ","));
							if (currSIDList.indexOf(anSid) == -1)
							{
								if(SIDCheckForSameNick == null)
									SIDCheckForSameNick = anSid+",";
								else
									SIDCheckForSameNick += anSid + ",";
							}
							//end
						}


						//EgConfigTopo.deleteSpecValue(stype,strVar[i_ctr]);
						discWrite.deleteValue(stype,strVar[i_ctr]);
						if (isLimitedAdmin)
							userCompIniDelList.add(strVar[i_ctr]);
							/*userCompIniWrite.deleteValue(user_id,strVar[i_ctr]);*/
					}
				}
			}
			else
			{
				if(strVar[i_ctr].equals(variableName))
				{
					//EgConfigTopo.deleteSpecValue(stype,strVar[i_ctr]);
					discWrite.deleteValue(stype,strVar[i_ctr]);
					if (isLimitedAdmin)
						userCompIniDelList.add(strVar[i_ctr]);
						/*userCompIniWrite.deleteValue(user_id,strVar[i_ctr]);*/
					if(mtscheck != null)
					{
						String hname = variableName.substring(variableName.indexOf(":")+1, variableName.lastIndexOf(":"));
						String ss[] = EgConfigTopo.getVariables("MTS_server");
						for(int a=0; a<ss.length; a++)
						{
							if(ss[a].startsWith("Format:"))
								continue;
							st = new StringTokenizer(ss[a],":");
							st.nextToken();
							if((st.nextToken()).equalsIgnoreCase(hname))
							{
								//EgConfigTopo.deleteSpecValue("MTS_server",ss[a]);
								discWrite.deleteValue("MTS_server",ss[a]);
								if (isLimitedAdmin)
									userCompIniDelList.add(ss[a]);
									/*userCompIniWrite.deleteValue(user_id,ss[a]);*/
							}
						}
					}
				}
			}
		}
	}
	/*
	 *	Write the new value
	 */
	if(action != null && !action.equals("null") && !action.equals(""))
	//if (!allServers)
	{
		/*
		 *	Set values only for a specific server
		 */
		if(!stype.equals("Oracle_server"))
		{
			if(nickAloneServerList.contains(stype))
			{
				hostip = hostname;
			}

			if(stype.equals("Real_user_monitor"))
				strCombine = stype+","+"0.0.0.0"+","+hostname+","+sportno;
			else
				strCombine = stype+","+hostip+","+hostname+","+sportno;
			
			if(mtscheck != null)
			{
				//delete and setvalues(IIS servers)
				//EgConfigTopo.deleteSpecValue(stype,"#Unmanage|"+strPass);
				//EgConfigTopo.deleteSpecValue(stype,"#New|"+strPass);
				//EgConfigTopo.setValues(stype,strPass,strCombine+","+isPassive);

				discWrite.deleteValue(stype,"#Unmanage|"+strPass);
				discWrite.deleteValue(stype,"#New|"+strPass);
				discWrite.setValue(stype,strPass,strCombine+","+isPassive);
				updateUuidIni(uuidInfo,hostname);
				if (isLimitedAdmin)
				{
					userCompIniDelList.add("#Unmanage|"+strPass);
					userCompIniDelList.add("#New|"+strPass);
					/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+strPass);
					userCompIniWrite.deleteValue(user_id,"#New|"+strPass);*/
					//userCompIniWrite.setValue(user_id,strPass,strCombine+","+isPassive);
				}
				if(mtscheck.equalsIgnoreCase("Yes"))
				{

					//delete and setvalues(MTS_server)
					strCombine = "MTS_server"+","+hostip+","+hostname+","+"NULL";
					strPass = "MTS_server"+":"+hostname+":"+"NULL";
					//EgConfigTopo.deleteSpecValue("MTS_server","#Unmanage|"+strPass);
					//EgConfigTopo.deleteSpecValue("MTS_server","#New|"+strPass);
					//EgConfigTopo.setValues("MTS_server",strPass,strCombine+","+isPassive);

					discWrite.deleteValue("MTS_server","#Unmanage|"+strPass);
					discWrite.deleteValue("MTS_server","#New|"+strPass);
					discWrite.setValue("MTS_server",strPass,strCombine+","+isPassive);
					updateUuidIni(uuidInfo,hostname);
					if (isLimitedAdmin)
					{
						userCompIniDelList.add("#Unmanage|"+strPass);
						userCompIniDelList.add("#New|"+strPass);
						/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+strPass);
						userCompIniWrite.deleteValue(user_id,"#New|"+strPass);*/
						//userCompIniWrite.setValue(user_id,strPass,strCombine+","+isPassive);
					}
				}
			}
			else
			{
				//EgConfigTopo.deleteSpecValue(stype,"#Unmanage|"+strPass);
				//EgConfigTopo.deleteSpecValue(stype,"#New|"+strPass);
				//EgConfigTopo.setValues(stype,strPass,strCombine+","+isPassive); //set the new values into discover.ini

				discWrite.deleteValue(stype,"#Unmanage|"+strPass);
				discWrite.deleteValue(stype,"#New|"+strPass);
				if (isLimitedAdmin)
				{
					userCompIniDelList.add("#Unmanage|"+strPass);
					userCompIniDelList.add("#New|"+strPass);
					/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+strPass);
					userCompIniWrite.deleteValue(user_id,"#New|"+strPass);*/
				}
				if(stype.equals("Real_user_monitor") && mserver!=null)
				{
					if(mserver.equals("true"))
					{
						StringTokenizer s_tokenizer = new StringTokenizer(strPass,":");
						s_tokenizer.nextToken();
						String c_comp=s_tokenizer.nextToken();
						if(dispCompName!=null && !dispCompName.trim().equals(c_comp))
						{
							discWrite.deleteValue(stype,"Real_user_monitor:"+dispCompName+":NULL");
							discWrite.setValue(stype,strPass,strCombine+","+isPassive);
							if (isLimitedAdmin)
							{
								//userCompIniDelList.add("Real_user_monitor:"+dispCompName+":NULL");
								/*userCompIniWrite.deleteValue(user_id,"Real_user_monitor:"+dispCompName+":NULL");*/
								//userCompIniWrite.setValue(user_id,strPass,strCombine+","+isPassive);
							}
						}
						else
						{
							discWrite.setValue(stype,strPass,strCombine+","+isPassive);
							//if (isLimitedAdmin)
								//userCompIniWrite.setValue(user_id,strPass,strCombine+","+isPassive);
						}
					}
					
					 //set the new values into discover.ini
				}
				else
				{
					discWrite.setValue(stype,strPass,strCombine+","+isPassive); //set the new values into discover.ini
					updateUuidIni(uuidInfo,hostname);
					//if (isLimitedAdmin)
						//userCompIniWrite.setValue(user_id,strPass,strCombine+","+isPassive);
					
					if(addHostAsAgent)
					{
						RemoteAgent remAgent = new RemoteAgent();
						String addAsAgentDesc = "";
						String remStatus = "";
						for(int k=0; k<compAgentGenVars.length; k++)
						{
							String cType = compAgentGenVars[k];
							if(cType.equals(stype))
							{
								String compAgentVal = extObj.getValue("Auto_Agent_Creation",cType);
								if(compAgentVal.equalsIgnoreCase("remote"))
								{
									remStatus = remAgent.add(hostip,hostname);
								}
								if(remStatus.equals("0#eG_CLI_0024"))
								{
									addAsAgentDesc = "A "+"$ctype$:"+stype +" component and a remote agent with nickname "+hostname+" has been created";
								}
								else
								{
									if(modifying)
									{
										addAsAgentDesc = "Component "+hostname + " of type " +"$ctype$:"+stype + " has been modified";
									}
									else
									{
										addAsAgentDesc = "Component "+hostname + " of type " +"$ctype$:"+stype + " has been created";
									}
								}
								auditLogThread.setValue("Description",addAsAgentDesc);
							}
						}
					}
				}
				
			}
		}
		else //for Oracle_server types
		{
			if (prevSid == null && sid != null)
			{
				/*
				 * When a server is added for the first time, the prevSid value will be null
				 * sid contains the name of the SID being used.
				 */
				prevSid = sid;
				hsid = sid;
			}
			String[] sidTokens = StringUtils.getTokens(prevSid, ",");
			for (int a=0; a<sidTokens.length; a++)
			{
				String temp = strPass +":"+ sidTokens[a].trim();
				//strCombine = stype+","+hostip+","+hostname+","+sportno+","+isPassive+","+sidTokens[a];
				//EgConfigTopo.deleteSpecValue(stype,"#Unmanage|"+temp);
				//EgConfigTopo.deleteSpecValue(stype,"#New|"+temp);
				
				discWrite.deleteValue(stype,"#Unmanage|"+temp);
				discWrite.deleteValue(stype,"#New|"+temp);
				if (isLimitedAdmin)
				{
					userCompIniDelList.add("#Unmanage|"+temp);
					userCompIniDelList.add("#New|"+temp);
					/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+temp);
					userCompIniWrite.deleteValue(user_id,"#New|"+temp);*/
				}
				
				//EgConfigTopo.setValues(stype, temp, strCombine);
			}

			//added - checking SID whn modify the nick name to existing name.
			if(SIDCheckForSameNick != null)
			{
				sid = SIDCheckForSameNick + sid;
			}
			//end

			sidTokens = StringUtils.getTokens(sid, ",");
			//EgConfigTopo.deleteSpecValue(stype,"#Unmanage|"+strPass);
			//EgConfigTopo.deleteSpecValue(stype,"#New|"+strPass);
			discWrite.deleteValue(stype,"#Unmanage|"+strPass);
			discWrite.deleteValue(stype,"#New|"+strPass);
			if (isLimitedAdmin)
			{
				userCompIniDelList.add("#Unmanage|"+strPass);
				userCompIniDelList.add("#New|"+strPass);
				/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+strPass);
				userCompIniWrite.deleteValue(user_id,"#New|"+strPass);*/
			}
			for (int a=0; a<sidTokens.length; a++)
			{
				String temp = strPass +":"+ sidTokens[a].trim();
				strCombine = stype+","+hostip+","+hostname+","+sportno+","+isPassive+","+sidTokens[a];
				//EgConfigTopo.deleteSpecValue(stype,"#Unmanage|"+temp);
				//EgConfigTopo.deleteSpecValue(stype,"#New|"+temp);
				//EgConfigTopo.setValues(stype, temp, strCombine);
				discWrite.deleteValue(stype,"#Unmanage|"+temp);
				discWrite.deleteValue(stype,"#New|"+temp);
				discWrite.setValue(stype, temp, strCombine);
				if (isLimitedAdmin)
				{
					userCompIniDelList.add("#Unmanage|"+temp);
					userCompIniDelList.add("#New|"+temp);
					/*userCompIniWrite.deleteValue(user_id,"#Unmanage|"+temp);
					userCompIniWrite.deleteValue(user_id,"#New|"+temp);*/
					//userCompIniWrite.setValue(user_id,temp,strCombine);
				}
			}
			updateUuidIni(uuidInfo,hostname);
		}	
		String currentIspassive = request.getParameter("isPassive");
		String previousIsPassive = request.getParameter("previousispassive");

		if (previousIsPassive == null)
		{
			previousIsPassive = "No";
		}
		if (currentIspassive == null)
		{
			currentIspassive = "No";
		}
		if(!previousIsPassive.equals(""))
		{
			auditLogThread.setCurrentValue("Is Passive",currentIspassive);
			if(modifying)
			{				
				if(previousIsPassive != null && !previousIsPassive.equals("null"))
					auditLogThread.setPreviousValue("Is Passive",previousIsPassive);
			}
		}			
	}
	boolean callErrorPage = true;
	boolean callBasicErrorPage = false;
	boolean update = false;
	Vector err_msg = new Vector();
	ArrayList al = new ArrayList();
	int status = 0;

	err_msg.clear();

	/**** REMOTE AGENT CODE********/
	boolean isCTypeExternal = true;
	EgSpecsInfo specs = new EgSpecsInfo("manager");
	String[] testsForType = specs.getTestsForServer(stype);
	if (testsForType != null)
	{
		for (int a=0; a<testsForType.length; a++)
		{
			if (!specs.isTestExternal(testsForType[a],stype))
			{
				isCTypeExternal = false;
				break;
			}
		}
	}

	boolean needCertCheck = true;
	ArrayList userVdiTypes = usersInfo.getAllUserBasedCompTypes();
	if (usersInfo.isUserBasedLicense() && modifying && userVdiTypes.contains(stype))
	{ //No need for license check,If you are going to modify a vdi(User based) comp in an user based license setup.
		needCertCheck = false;
	}
	if (EgInstallInfo.isEUCEndPointsLicense)
	{
		EgEndPointsInfo endPointUsersObj = new EgEndPointsInfo();
		ArrayList endPointTypes = endPointUsersObj.getEUCEndPointTypes();
		if (modifying && endPointTypes.contains(stype))
		{
			needCertCheck = false;
		}
	}
	if (EgInstallInfo.isO365UsersLicense)
	{
		EgMsUsersInfo msUsersInfo = new EgMsUsersInfo();
		ArrayList msTypes = msUsersInfo.getMsTypes();
		if (modifying && msTypes.contains(stype))
		{
			needCertCheck = false;
		}
	}


	if (needCertCheck && isLimitedAdmin)
	{
		String licenseChkAction = (modifying) ? "modifying" : "adding";
		String component = stype+":"+hostNameToCertCheck+":"+hportno;//strPass;
		List orgList = uuidInfo.getOrgNames(user_id);
		int orgListLen = (orgList != null) ? orgList.size() : 0;
		for (int y=0; y<orgListLen; y++)
		{
			String org_id = orgList.get(y).toString().trim();
			GroupCertValidator grpCert = new GroupCertValidator(org_id);
			usrLicStatus = grpCert.checkMonitor (stype,org_id,component);
			grpCert.setLicenseCheckAction(licenseChkAction);
			if (usrLicStatus != 1)
			{
				grpCert.errorLogWrite(org_id,component,licenseChkAction);
				break;
			}
		}
	}

	if (remoteType != null && remoteType.equalsIgnoreCase("true"))
	{
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
		// get manager IP
		String managerHost = specsInfo.getEGServer();
		specsInfo = null;
		EgExternalAgent e =new  EgExternalAgent(discInfo, managerHost, true);
		e.buildExternalFile();
		e = null;
		int alCertCheck = 1;
		if (needCertCheck)
		{
			alCertCheck = user.checkAlServers (hostNameToCertCheck,stype,"AddModifyPage");
		}
		if (alCertCheck == 1)
		{
			if(remotemode != null)
			{
				if(remotemode.equalsIgnoreCase("SNMP"))
				{
					remoteUser="NotApplicable";
					remotepwd="NotApplicable";
				}
				//if(isLimitedAdmin && !userExtAgent.equals(""))
				//{
					//remoteAgent = userExtAgent;
				//}
				extIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
				extIniWr.deleteValue("Remote_Agent_Mapping_Section",hostname);
				extIniWr.deleteValue("Agentless_Infos_Section",hostname);
				extIniWr.setValue("Remote_Agent_Mapping_Section",hostname,remoteAgent);
				extIniWr.saveFile();
				//EgConfigFilesSync.releaseInstance(extIniWr);
				
				//egExtIni.createFile("eg_external.ini","save");
				//egExtIni.deleteSpecValue("Remote_Agent_Mapping_Section",hostname);
				//egExtIni.deleteSpecValue("Agentless_Infos_Section",hostname);

				//egExtIni.setValues("Remote_Agent_Mapping_Section",hostname,remoteAgent);
				

				if (remoteUser == null || remoteUser.equals("") || remoteUser.equalsIgnoreCase("null"))
				{
					remoteUser = "None";
				}

				if (remotepwd == null || remotepwd.equals("") || remotepwd.equalsIgnoreCase("null"))
				{
					remotepwd = "None";
				}
				if (remoteEncrypt == null || remoteEncrypt.equals("") || remoteEncrypt.equalsIgnoreCase("null"))
				{
					remoteEncrypt = "None";
				}
				if (remoteKeyFile == null || remoteKeyFile.equals("") || remoteKeyFile.equalsIgnoreCase("null"))
				{
					remoteKeyFile = "None";
				}

				StringBuffer value = new StringBuffer(32);
				value.append(remoteUser);
				value.append(EgConstants.COMMA);

				if (remotepwd != null) // && !remotepwd.equalsIgnoreCase("null"))
				{
					remotepwd = EgUIUtils.decodeSecurityChar(remotepwd);
				//	remotepwd = EgCrypt.decrypt(remotepwd);
					remotepwd = EgCrypt.encrypt(remotepwd);
				}

				value.append(remotepwd);
				value.append(EgConstants.COMMA);
				value.append(remotemode);
				value.append(EgConstants.COMMA);
				value.append(remotealos);
				value.append(EgConstants.COMMA);
			
				if(!isAggregateType)
				{
					if(modifying)
					{
						//String oldenableRemoteAgent = request.getParameter("oldenableRemoteAgent");
						//if(oldenableRemoteAgent !=null && !oldenableRemoteAgent.equalsIgnoreCase("null") && oldenableRemoteAgent.trim().length()>0)
						//{
						//	if(oldenableRemoteAgent.trim().equalsIgnoreCase("true") || oldenableRemoteAgent.trim().equalsIgnoreCase("yes"))
						//		oldenableRemoteAgent ="Yes";
						//	else if(oldenableRemoteAgent.trim().equalsIgnoreCase("false") || oldenableRemoteAgent.trim().equalsIgnoreCase("no"))
						//		oldenableRemoteAgent ="No";
						//	auditLogThread.setPreviousValue("Agentless",oldenableRemoteAgent);
						//}
						if (prevRemAgent != null && prevRemAgent.trim().equals(""))
						{							
							auditLogThread.setPreviousValue("Agentless","No");
						}
						else
						{
							auditLogThread.setPreviousValue("Agentless","Yes");
						}
					}
					if(request.getParameter("enableRemoteAgent") != null && request.getParameter("enableRemoteAgent").equals("true"))
					{
						auditLogThread.setCurrentValue("Agentless","Yes");
					}
				}

				Hashtable operatingSystems = new Hashtable();
				//IniFile externalIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
				String variables[] = extIniWr.getVariables("Default_Operating_Systems");
				Vector values = extIniWr.getAllValues("Default_Operating_Systems");
				if(variables != null && variables.length>0)
				{
					for(int ind=0;ind<variables.length;ind++)
						operatingSystems.put(variables[ind],values.get(ind));
				}
				Vector valuesSpecific = extIniWr.getAllValues("Specific_Operating_Systems");
				if(valuesSpecific != null && valuesSpecific.size()>0)
				{
					for(int ind=0;ind<valuesSpecific.size();ind++)
					{
						String valueStr = (String) valuesSpecific.get(ind);
						operatingSystems.put(valueStr.substring(0,valueStr.indexOf(":")),valueStr.substring(valueStr.indexOf(":")+1));			
					}
				}
				operatingSystems.put("other","Other");

				if(!isAggregateType && !stype.equals("Real_user_monitor"))
				{
					if(modifying)
					{
						String olderOSName = request.getParameter("olderosname");
						olderOSName = (String)operatingSystems.get(olderOSName.trim().toLowerCase());
						if(olderOSName !=null && !olderOSName.equalsIgnoreCase("null") && olderOSName.trim().length()>0)
						{
							auditLogThread.setPreviousValue("OS",olderOSName);
							remainTypeCheck = true;
						}
						else
						{
							auditLogThread.setPreviousValue("OS","None");
						}
					}
					String remoteOS = remotealos;
					if (operatingSystems.containsKey(remotealos))
					{
						remoteOS = operatingSystems.get(remotealos).toString();
					}
					auditLogThread.setCurrentValue("OS",remoteOS);
				}

				if(!isAggregateType)
				{
					if(modifying)
					{
						String olderModeName = request.getParameter("oldermodename");
						if(olderModeName !=null && !olderModeName.equalsIgnoreCase("null") && olderModeName.trim().length()>0)
						{
							auditLogThread.setPreviousValue("Mode",olderModeName.trim());
							remainTypeCheck = true;
						}
					}
					auditLogThread.setCurrentValue("Mode",remotemode);
				}
				if(modifying)
				{
					String olderRemoteAgentName = prevRemAgent;
					if(olderRemoteAgentName !=null && !olderRemoteAgentName.equalsIgnoreCase("null") && olderRemoteAgentName.trim().length()>0)
					{
						auditLogThread.setPreviousValue("Remote Agent",olderRemoteAgentName.trim());
						remainTypeCheck = true;
					}
					else
					{
						auditLogThread.setPreviousValue("Remote Agent","-");
					}
				}
				auditLogThread.setCurrentValue("Remote Agent",remoteAgent);

				if(!remotemode.equalsIgnoreCase("SNMP") && !remotemode.equalsIgnoreCase("Perfmon") && !remotemode.equalsIgnoreCase("other"))
				{
					if(!remoteUser.equals("NotApplicable"))
					{
						if(!isAggregateType)
						{
							auditLogThread.setCurrentValue("User",remoteUser);
							if(modifying)
							{
								String preUser = request.getParameter("$_aluser");
								if(preUser !=null && !preUser.equalsIgnoreCase("null") && preUser.trim().length()>0)
								{
									auditLogThread.setPreviousValue("User",preUser.trim());
									remainTypeCheck = true;
								}
							}
						}
					}
								
					if(!remotepwd.equals("NotApplicable"))
					{
						/*
						auditLogThread.setCurrentValue("Password","******");
						String newPassword = EgCrypt.decrypt(remotepwd);
						String oldPassword = EgCrypt.decrypt(request.getParameter("$_alpwd"));

						if(modifying)
						{			
							if(newPassword.equals(oldPassword))
								auditLogThread.setPreviousValue("Password","******");
							else
								auditLogThread.setPreviousValue("Password","*****");
						}
						*/
					}
				}
				if (StringUtils.isNull(sshPort) || sshPort.equalsIgnoreCase(EgConstants.NULL_STRING))
				{
					/*
					 * Set the default SSH port if "null" or empty
					 */
					value.append("22");
				}
				else
				{
					value.append(sshPort);
					/* code for auditlog starts*/
					if(modifying)
					{
						auditLogThread.setPreviousValue("Remote Port",request.getParameter("$_sshPort"));
						remainTypeCheck = true;
					}
					auditLogThread.setCurrentValue("Remote Port",sshPort);
					/* code for auditlog ends*/
				}
				value.append(EgConstants.COMMA);
				value.append(remoteEncrypt);
				value.append(EgConstants.COMMA);
				value.append(remoteKeyFile);

				//extIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
				extIniWr.setValue("Agentless_Infos_Section", hostname, value.toString());
				extIniWr.saveFile();
				EgConfigFilesSync.releaseInstance(extIniWr);
			}
			else
			{
				//deleteSpecValue(String subject,String variable)
				//Delete the entry from eg_external.ini
				//egExtIni.createFile("eg_external.ini","save");
				//egExtIni.deleteSpecValue("Remote_Agent_Mapping_Section",hostname);
				//egExtIni.deleteSpecValue("Agentless_Infos_Section",hostname);
			}

			//e = new EgExternalAgent(discInfo, managerHost, true);
			//ArrayList a = new ArrayList();
			//a.add(hostname);
			//e.buildExternalFile(a);
			//discInfo = null;
			//e = null;

			//Vmware Vcenter eg_services.ini entries
			if (addCompForDiscovery != null && (addCompForDiscovery.trim().equalsIgnoreCase("yes") || addCompForDiscovery.trim().equalsIgnoreCase("true")))
			{
				//IniFile serviceWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
				IniFile servReadModeIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
				IniFile agtLessReadModeIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_agentlessdisc.ini");
				ArrayList discCompList = new ArrayList();
				ArrayList discAgentCompList = new ArrayList();

				String discoverHyperThru = mgrmiscIni.getValue("MISC_ARGS", "DiscoverHypervisorsThru");
				if (StringUtils.isNull(discoverHyperThru))
				{
					String eGMgrModel = servReadModeIni.getValue("MISC_ARGS","eGMgrModel");
					if (eGMgrModel != null && eGMgrModel.equalsIgnoreCase("msp"))
					{
						discoverHyperThru = "Agent";
					}
					else
					{
						discoverHyperThru = "Manager";
					}
				}

				String agentForSubject = remoteAgent;
				if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("Virtual_center"))
				{
					if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
					{
						String vCs[] =  servReadModeIni.getVariables("VIRTUAL_CENTER");
						List vCList = new ArrayList();
						if (vCs != null)
						{
							for (int v=0; v<vCs.length; v++)
							{
								vCList.add(vCs[v].toLowerCase());
							}
						}
						String vCenterValue =  "True#$unconfigured#$unconfigured#No#443";
						if (!vCList.contains(hostip.toLowerCase()))
						{
							discCompList.add(new IniHelper("VIRTUAL_CENTER",hostip,vCenterValue));
						}
					}
					else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
					{
						if (!StringUtils.isNull(agentForSubject))
						{
							String vCs[] =  agtLessReadModeIni.getVariables(agentForSubject);
							List vCList = new ArrayList();
							if (vCs != null)
							{
								for (int v=0; v<vCs.length; v++)
								{
									vCList.add(vCs[v].toLowerCase());
								}
							}

							if (!vCList.contains("vcenter#"+hostip.toLowerCase()))
							{
								String vCenterValue = "no~#~$unconfigured~#~$unconfigured~#~443~#~true";
								discAgentCompList.add(new IniHelper(agentForSubject, "vcenter#" +hostip,vCenterValue));
							}

						}
					}
				}
				else if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("Redhat_linux_mgr"))
				{
					if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
					{
						String rhevs[] =  servReadModeIni.getVariables("RHEV");
						List rhevList = new ArrayList();
						if (rhevs != null)
						{
							for (int v=0; v<rhevs.length; v++)
							{
								rhevList.add(rhevs[v].toLowerCase());
							}
						}
						String rhevValue =  "True#$unconfigured#$unconfigured#No#443#internal";
						if (!rhevList.contains(hostip.toLowerCase()))
						{
							discCompList.add(new IniHelper("RHEV",hostip,rhevValue));
						}
					}
					else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
					{
						if (!StringUtils.isNull(agentForSubject))
						{
							String rhevs[] =  agtLessReadModeIni.getVariables(agentForSubject);
							List rhevList = new ArrayList();
							if (rhevs != null)
							{
								for (int v=0; v<rhevs.length; v++)
								{
									rhevList.add(rhevs[v].toLowerCase());
								}
							}

							if (!rhevList.contains("rhev#"+hostip.toLowerCase()))
							{
								String rhevValue = "no~#~$unconfigured~#~$unconfigured~#~443~#~No~#~internal";
								discAgentCompList.add(new IniHelper(agentForSubject, "rhev#" +hostip,rhevValue));
							}
						}
					}
				}
				else if (!com.egurkha.util.StringUtils.isNull(stype) && 
					(stype.equals("Nutanix_Cluster") || stype.equals("Nutanix_Prism_Center")))
				{
					if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
					{
						String nutIPs[] =  servReadModeIni.getVariables("NUTANIX");
						List nutIPList = new ArrayList();
						if (nutIPs != null)
						{
							for (int v=0; v<nutIPs.length; v++)
							{
								nutIPList.add(nutIPs[v].toLowerCase());
							}
						}
						String nutIPValue = "True#$unconfigured#$unconfigured#No#9440#false";
						if (stype.equals("Nutanix_Prism_Center"))
						{
							nutIPValue = "True#$unconfigured#$unconfigured#No#9440#true";
						}
						if (!nutIPList.contains(hostip.toLowerCase()))
						{
							discCompList.add(new IniHelper("NUTANIX",hostip,nutIPValue));
						}
					}
					else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
					{
						if (!StringUtils.isNull(agentForSubject))
						{
							String nutIPs[] =  agtLessReadModeIni.getVariables(agentForSubject);
							List nutIPList = new ArrayList();
							if (nutIPs != null)
							{
								for (int v=0; v<nutIPs.length; v++)
								{
									nutIPList.add(nutIPs[v].toLowerCase());
								}
							}

							if (!nutIPList.contains("nutanix#"+hostip.toLowerCase()))
							{
								String nutIPValue = "no~#~$unconfigured~#~$unconfigured~#~9440~#~true~#~false";
								if (stype.equals("Nutanix_Prism_Center"))
								{
									nutIPValue = "no~#~$unconfigured~#~$unconfigured~#~9440~#~true~#~true";
								}

								discAgentCompList.add(new IniHelper(agentForSubject, "nutanix#" +hostip,nutIPValue));
							}
						}
					}
				}
				else if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("hmc_server"))
				{
					if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
					{
						String hmcs[] =  servReadModeIni.getVariables("HMC");
						List hmcList = new ArrayList();
						if (hmcs != null)
						{
							for (int v=0; v<hmcs.length; v++)
							{
								hmcList.add(hmcs[v].toLowerCase());
							}
						}

						if (!hmcList.contains(hostip.toLowerCase()))
						{
							String pseriesValue =  "True#"+remoteUser+"#"+remotepwd+"#No#"+hostname;
							discCompList.add(new IniHelper("HMC",hostip,pseriesValue));
						}
					}
					else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
					{
						if (!StringUtils.isNull(agentForSubject))
						{
							String hmcs[] =  agtLessReadModeIni.getVariables(agentForSubject);
							List hmcList = new ArrayList();
							if (hmcs != null)
							{
								for (int v=0; v<hmcs.length; v++)
								{
									hmcList.add(hmcs[v].toLowerCase());
								}
							}

							if (!hmcList.contains("hmc#"+hostip.toLowerCase()))
							{
								String pseriesValue =  "no~#~"+remoteUser+"~#~"+remotepwd+"~#~No~#~"+hostip;
								discAgentCompList.add(new IniHelper(agentForSubject, "hmc#" +hostip,pseriesValue));
							}
						}
					}
				}
				//EgConfigFilesSync.releaseInstance(serviceWrite);
				if (discCompList.size()>0)
				{
					IniFile serviceWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
					for (int s=0;s<discCompList.size() ;s++ )
					{
						IniHelper iniHelper = (IniHelper)discCompList.get(s);
						String sub = iniHelper.getSubject();
						String key = iniHelper.getVariable();
						String val = iniHelper.getValue();
						serviceWrite.setValue(sub, key, val);
					}
					serviceWrite.saveFile();
					EgConfigFilesSync.releaseInstance(serviceWrite);
				}

				if (discAgentCompList.size()>0)
				{
					IniFile agtLssDiscWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_agentlessdisc.ini");
					for (int s=0;s<discAgentCompList.size() ;s++ )
					{
						IniHelper iniHelper = (IniHelper)discAgentCompList.get(s);
						String sub = iniHelper.getSubject();
						String key = iniHelper.getVariable();
						String val = iniHelper.getValue();
						agtLssDiscWrite.setValue(sub, key, val);
					}
					agtLssDiscWrite.saveFile();
					EgConfigFilesSync.releaseInstance(agtLssDiscWrite);
				}
			}

		}
		else
		{
			if (discWrite != null)
				EgConfigFilesSync.releaseInstance(discWrite);
			discInfo = null;
			e = null;
			callBasicErrorPage = true;
			rootJSON.put("requestStatus","failed");
			JSONObject obj = new JSONObject();
			obj.put("Error_Title",_mapping.getTextDescription("admin.error.Add new component"));
			if(!StringUtils.isNull(treeViewSrc))
			{
				obj.put("Error_URL","EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);	
			}
			else
			{
				obj.put("Error_URL","EgDispServer.jsp?qctr=1&server="+stype+"&selectedServerGroup="+selectedServerGroup);
			}
			String msg = _mapping.getTextDescription("admin.error.You are exceeding the total/premium monitors permitted by your license")+"!";
			if (usersInfo.isUserBasedLicense() && alCertCheck == 2)
			{
				msg += " "+_mapping.getTextDescription("admin.error.or")+" ";
				if (isNamedUsersCert)
				{
					msg = _mapping.getTextDescription("admin.error.You are exceeding the total number of named users/machines permitted by your license")+"!";
				}
				else
				{
					msg = _mapping.getTextDescription("admin.error.You are exceeding the total number of concurrent users/machines permitted by your license")+"!";
				}
			}
			else if (EgInstallInfo.isEUCEndPointsLicense &&  alCertCheck == 3)
			{
				msg = _mapping.getTextDescription("admin.error.You are exceeding the total number of IGEL endpoints permitted by your license")+"!";
			}
			else if (EgInstallInfo.isO365UsersLicense &&  alCertCheck == 4)
			{
				msg = _mapping.getTextDescription("admin.error.You are exceeding the total number of O365 users permitted by your license")+"!";
			}
			obj.put("Error_Msg_Count","2");
			obj.put("Error_Msg_1",msg);
			msg = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional components")+", ";
			msg += _mapping.getTextDescription("admin.error.please contact") +" <b>license@eginnovations.com</b>";
			obj.put("Error_Msg_2",msg);
			if(frmTopology !=null && frmTopology.equals("yes"))
			{
				//err_msg.add("frmTopology");
			}
			//session.setAttribute("vec_Errors",err_msg);
			//response.sendRedirect("EgErrors.jsp");
			/* code for auditlog starts */
			if (alCertCheck == 0)
			{
				auditLogThread.setValue("Description","You are exceeding the total/premium monitors permitted by your license");
			}
			else if (usersInfo.isUserBasedLicense() && alCertCheck == 2)
			{
				if (isNamedUsersCert)
				{
					auditLogThread.setValue("Description","You are exceeding the named users/machines permitted by your license");
				}
				else
				{
					auditLogThread.setValue("Description","You are exceeding either the concurrent users/machines permitted by your license");
				}
			}
			else if (EgInstallInfo.isEUCEndPointsLicense &&  alCertCheck == 3)
			{
				auditLogThread.setValue("Description","You are exceeding the IGEL endpoints permitted by your license");
			}
			else if (EgInstallInfo.isO365UsersLicense &&  alCertCheck == 4)
			{
				auditLogThread.setValue("Description","You are exceeding the O365 users permitted by your license");
			}
			
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
			rootJSON.put("Error_Info",obj);
		}
	}
	else if (!isCTypeExternal)
	{
		/*
		 * the user has shifted from agentless to agentbased.
		 * so delete the entries from the eg_external.ini file
		 */
		//egExtIni.createFile("eg_external.ini","save");
		//egExtIni.deleteSpecValue("Remote_Agent_Mapping_Section",hostname);
		//egExtIni.deleteSpecValue("Agentless_Infos_Section",hostname);
		//egExtIni.saveFile();
		extIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
		extIniWr.deleteValue("Remote_Agent_Mapping_Section",hostname);
		extIniWr.deleteValue("Agentless_Infos_Section",hostname);
		extIniWr.saveFile();
		EgConfigFilesSync.releaseInstance(extIniWr);
		
		/* code for auditlog starts */
		//if(intAgentMode !=null && intAgentMode.equalsIgnoreCase("manual"))
		{
			String tempIntAgentMode = request.getParameter("intAgentMode");
			if(tempIntAgentMode != null && !StringUtils.isNull(tempIntAgentMode))
				auditLogThread.setCurrentValue("Internal Agent Assignment",intAgentMode);
			String previousIntAgentMode = request.getParameter("previousintagentmode");
			
			if(modifying)
			{
				//String previousIntAgentMode = request.getParameter("previousintagentmode");
				if(previousIntAgentMode !=null && previousIntAgentMode.length()>0)
					auditLogThread.setPreviousValue("Internal Agent Assignment",previousIntAgentMode);
			}
		}
		/* code for auditlog ends */

		/* code for auditlog starts */

			if (!isAggregateType)	
			{
				//if(modifying && request.getParameter("enableRemoteAgent") != null && request.getParameter("enableRemoteAgent").equals("false"))
				//{
				//	String oldenableRemoteAgent = request.getParameter("oldenableRemoteAgent");
				//	if(oldenableRemoteAgent.trim().equalsIgnoreCase("true") || oldenableRemoteAgent.trim().equalsIgnoreCase("yes"))
				//		oldenableRemoteAgent ="Yes";
				//	else if(oldenableRemoteAgent.trim().equalsIgnoreCase("false") || oldenableRemoteAgent.trim().equalsIgnoreCase("no"))
				//		oldenableRemoteAgent ="No";
				//	auditLogThread.setPreviousValue("Agentless",oldenableRemoteAgent);
				//}
				if (modifying)
				{
					if (prevRemAgent != null && prevRemAgent.trim().equals(""))
					{
						auditLogThread.setPreviousValue("Agentless","No");
					}
					else
					{
						auditLogThread.setPreviousValue("Agentless","Yes");
					}
				}
				String enableRmtAgent = request.getParameter("enableRemoteAgent");
				if(enableRmtAgent == null || enableRmtAgent.equals("false"))
				{
					auditLogThread.setCurrentValue("Agentless","No");
				}
			}
		/* code for auditlog ends */
	}

	/**** REMOTE AGENT CODE********/

	if(!callBasicErrorPage)
	{
		rootJSON.put("requestStatus","failed");
		JSONObject obj = new JSONObject();
		obj.put("Error_Title",_mapping.getTextDescription("admin.error.Add new component"));
		//err_msg.add(_mapping.getTextDescription("admin.error.Add new component"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			obj.put("Error_URL","EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
			//err_msg.add("EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
		}
		else
		{
			obj.put("Error_URL","EgDispServer.jsp?qctr=1&server="+stype+"&selectedServerGroup="+selectedServerGroup);
			//err_msg.add("EgDispServer.jsp?qctr=1&server="+stype+"&selectedServerGroup="+selectedServerGroup);
		}

		//err_msg.add(_mapping.getTextDescription("admin.error.Add new component"));

		//Pass an empty vector to the method below
		Vector v = new Vector();
		if (needCertCheck)
		{
			if (intAgentMode.equalsIgnoreCase("auto"))
				status = user.checkBasicAgentCount(stype,v,0,hostip,hostNameToCertCheck,hportno,sid); // check with Sara
			else {
				status = user.checkBasicAgentCount(stype,v,-1,hostip,hostNameToCertCheck+'#'+currAgent,hportno,sid); // check with Sara -- this is a manual addition
			}
		}else
		{
			status = 1;
		}
		//status = 2;
		if(status == 1)
		{
			update = true;
		}
		else if(status > 1)//== 2 || status == 3 || status == 4 || status == 5 || status == 6 || status == 7)
		{
			callBasicErrorPage = true;
		}

		if (isLimitedAdmin && !callBasicErrorPage)
		{
			if (usrLicStatus == 1) 
			{
				update = true;
			}
			else if(usrLicStatus > 1)// == 2 || usrLicStatus == 3 || usrLicStatus == 4  || usrLicStatus == 5)
			{
				update = false;
				callBasicErrorPage = true;
			}
		}

		if(!callBasicErrorPage)
		{
			boolean needToCheckMonTrgts = true;
			boolean intAgentCheck = servicesInfo.isInternalAgentCertEnabled();
			ArrayList noCheckList = getCertCheckTypes();
			if((usersInfo.isUserBasedLicense() && userVdiTypes.contains(stype)) || noCheckList.contains(stype))
			{
				update = true;
				needToCheckMonTrgts= false;
			}
			else if(intAgentCheck && usersInfo.isUserBasedLicense() && !userVdiTypes.contains(stype) && !modifying)
			{
				ArrayList userBasedNicks = egdiscInfo.getAllHostsOfTypes(userVdiTypes);
				if (userBasedNicks.contains(hostname) || userBasedNicks.contains(currAgent) || noCheckList.contains(stype))
				{
					update = true;
					needToCheckMonTrgts= false;
				}
				else
				{
					needToCheckMonTrgts= true;
				}
			}
			if(needToCheckMonTrgts)
			{
				if(user.checkManagedIpCount())
				{
					update = true;
				}
				else
				{
					al.clear();
					al = user.getManagedIp(0);

					if(al != null && al.size() > 0)
					{
						for(int i=0; i<al.size(); i++)
						{
							var = (String)al.get(i);
							var = var.substring(0,var.indexOf(":"));
							if(var.equals(hostname))
							{
								callErrorPage = false;
								break;
							}
						}
					}
					if (intAgentCheck && modifying && usersInfo.isUserBasedLicense() && !userVdiTypes.contains(stype))
					{
						String prevIntAgentMode = request.getParameter("previousintagentmode");
						String currIntAgentMode = request.getParameter("intAgentMode");
						if (prevIntAgentMode != null && prevIntAgentMode.length() > 0 && currIntAgentMode != null && currIntAgentMode.length()>0)
						{
							if (prevIntAgentMode.equalsIgnoreCase("manual"))// && currIntAgentMode.equalsIgnoreCase("auto"))
							{
								String prevAgent = request.getParameter("previousIntAgent");
								if(prevAgent != null && prevAgent.length()>0)
								{
									ArrayList userBasedNicks = egdiscInfo.getAllHostsOfTypes(userVdiTypes);
									if (userBasedNicks.contains(prevAgent))
									{
									// Following comment lines needed?
									//	int allowedTargets = EgMemInfo.targets;
									//	int usedTargets = user.getManagedIpCount();
									//	if (usedTargets >= allowedTargets)
									//	{
											callErrorPage = true;
									//	}
									}
								}
							}
						}
					}
					if(callErrorPage)
					{
						if (discWrite != null)
							EgConfigFilesSync.releaseInstance(discWrite);
						/*if (userCompIniWrite != null)
							EgConfigFilesSync.releaseInstance(userCompIniWrite);*/

						update = false;
						if (remoteType != null && remoteType.equalsIgnoreCase("true"))
						{
							EgDiscInfo discInfo = new EgDiscInfo("manager");
							EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
							// get manager IP
							String managerHost = specsInfo.getEGServer();
							specsInfo = null;
							EgExternalAgent e =new  EgExternalAgent(discInfo, managerHost, true);
							e.buildExternalFile();
							discInfo = null;
							e = null;
						}
						obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You have exceeded the number of monitored targets allowed by your license!"));
						obj.put("Error_Msg_2"," "+_mapping.getTextDescription("admin.error.To monitor additional targets")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
						//err_msg.add(_mapping.getTextDescription("admin.error.You have exceeded the number of monitored targets allowed by your license!"));
						//err_msg.add(" "+_mapping.getTextDescription("admin.error.To monitor additional targets")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
						if(frmTopology !=null && frmTopology.equals("yes"))
						{
							//err_msg.add("frmTopology");
						}
						rootJSON.put("Error_Info",obj);
						//session.setAttribute("vec_Errors",err_msg);
						//response.sendRedirect("EgErrors.jsp");
						/* code for auditlog starts */
						auditLogThread.setValue("Description","You have exceeded the number of monitored targets allowed by your license");
						auditLogThread.sendItToDB();
						/* code for auditlog ends */
					}
					else
					{
						update = true;
					}
				}
			}
		}
		else
		{
			if (remoteType != null && remoteType.equalsIgnoreCase("true"))
			{
				EgDiscInfo discInfo = new EgDiscInfo("manager");
				EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
				// get manager IP
				String managerHost = specsInfo.getEGServer();
				specsInfo = null;
				EgExternalAgent e =new  EgExternalAgent(discInfo, managerHost, true);
				e.buildExternalFile();
				discInfo = null;
				e = null;
			}
			if (discWrite != null)
				EgConfigFilesSync.releaseInstance(discWrite);
			/*if (userCompIniWrite != null)
				EgConfigFilesSync.releaseInstance(userCompIniWrite);*/
			
			if(status == 2 || usrLicStatus == 3)
			{
				//err_msg.add(_mapping.getTextDescription("admin.error.You are exceeding the number of premium agents allowed by your license!"));
				//err_msg.add(" "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional premium agents")+", ");
				//err_msg.add(_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
				obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the number of premium monitors allowed by your license")+"!");
				String msg = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional premium monitors")+", ";
				msg+=_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_2",msg);
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				//session.setAttribute("vec_Errors",err_msg);
				//response.sendRedirect("EgErrors.jsp");
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You are exceeding the number of premium monitors allowed by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
				rootJSON.put("Error_Info",obj);
			}
			else if(status == 3)
			{
				//err_msg.add(_mapping.getTextDescription("admin.error.You are exceeding the total number of agents permitted by your license!"));
				//err_msg.add(" "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional agents")+", ");
				//err_msg.add(_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
				String msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional monitors")+", ";
				msg += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of monitors permitted by your license or the license is invalid")+". ");
				obj.put("Error_Msg_2",msg);
				rootJSON.put("Error_Info",obj);
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				//session.setAttribute("vec_Errors",err_msg);
				//response.sendRedirect("EgErrors.jsp");
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You are exceeding the total number of monitors permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			else if(status == 4)
			{
				//err_msg.add(_mapping.getTextDescription("admin.error.You are exceeding the total number of applications permitted by your license!"));
				//err_msg.add(" "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional applications")+", ");
				//err_msg.add(_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
				String msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional applications")+", ";
				msg += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of applications permitted by your license")+"!");
				obj.put("Error_Msg_2",msg);
				rootJSON.put("Error_Info",obj);
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				//session.setAttribute("vec_Errors",err_msg);
				//response.sendRedirect("EgErrors.jsp");
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You are exceeding the total number of applications permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */				
			}
			else if(status == 5 || usrLicStatus == 4)
			{
				//err_msg.add(_mapping.getTextDescription("admin.error.You are exceeding the total number of network devices permitted by your license!"));
				//err_msg.add(" "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional network devices")+", ");
				//err_msg.add(_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
				String msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional network devices")+", ";
				msg += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of network devices permitted by your license")+"!");
				obj.put("Error_Msg_2",msg);
				rootJSON.put("Error_Info",obj);
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				//session.setAttribute("vec_Errors",err_msg);
				//response.sendRedirect("EgErrors.jsp");
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You are exceeding the total number of network devices permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */				
			}
			else if(status == 6 || usrLicStatus == 5)
			{
				//err_msg.add(_mapping.getTextDescription("admin.error.You are exceeding the total number of named users permitted by your license!"));
				//err_msg.add(" "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional named users")+", ");
				//err_msg.add(_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
				String msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional named users/machines")+", ";
				if (!isNamedUsersCert)
				{
					msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional concurrent users/machines")+", ";
				}
				msg += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				if(isNamedUsersCert)
				{
					obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of named users/machines permitted by your license")+"!");
				}
				else
				{
					obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of concurrent users/machines permitted by your license")+"!");
				}
				obj.put("Error_Msg_2",msg);
				rootJSON.put("Error_Info",obj);
				
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				session.setAttribute("vec_Errors",err_msg);
				
				/* code for auditlog starts */
				if(isNamedUsersCert)
				{
					auditLogThread.setValue("Description","You are exceeding the total number of named users/machines permitted by your license");
				}
				else
				{
					auditLogThread.setValue("Description","You are exceeding the total number of concurrent users/machines permitted by your license");
				}
				auditLogThread.sendItToDB();
				/* code for auditlog ends */			
			}
			else if(status == 7|| usrLicStatus == 6)
			{
				String msg1 = _mapping.getTextDescription("admin.error.You have exceeded the total number of EUC endpoints permitted by your license")+". ";
				String msg2  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional EUC endpoints")+", ";
				msg2 += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",msg1);
				obj.put("Error_Msg_2",msg2);
				rootJSON.put("Error_Info",obj);
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You have exceeded the total number of EUC endpoints permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			else if(status == 8 || usrLicStatus == 7)
			{
				String msg1 = _mapping.getTextDescription("admin.error.You have exceeded the total number of O365 users permitted by your license")+". ";
				String msg2  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional O365 users")+", ";
				msg2 += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",msg1);
				obj.put("Error_Msg_2",msg2);
				rootJSON.put("Error_Info",obj);
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You have exceeded the total number of O365 users permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			if(usrLicStatus == 2)
			{
				String msg  = " "+_mapping.getTextDescription("admin.error.To upgrade your license to support additional total/basic monitors")+", ";
				msg += _mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
				obj.put("Error_Msg_1",_mapping.getTextDescription("admin.error.You are exceeding the total number of total/basic monitors permitted by your license")+"!");
				obj.put("Error_Msg_2",msg);
				rootJSON.put("Error_Info",obj);
				if(frmTopology !=null && frmTopology.equals("yes"))
				{
					err_msg.add("frmTopology");
				}
				/* code for auditlog starts */
				auditLogThread.setValue("Description","You are exceeding the total number of total/basic monitors permitted by your license");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
		}
	}

	String fromHomePopup = request.getParameter("fromHomePopup");
	if ((fromHomePopup != null && fromHomePopup.length() > 0 && fromHomePopup.equalsIgnoreCase("yes")) || (frmTopology != null && frmTopology.length() > 0 && frmTopology.equalsIgnoreCase("yes")))
	{
		if (!oldhostname.equals(hostname))
		{
			String port = request.getParameter("portnumber");
			if (port == null || port.equalsIgnoreCase("null"))
			{
				port = "NULL";
			}
			String tmpVar = "#New|"+stype+":"+oldhostname+":"+port;
			//EgConfigTopo.deleteSpecValue(stype,tmpVar);
			discWrite.deleteValue(stype,tmpVar);
			userCompIniDelList.add(tmpVar);
		}

		// Change the Nick / Port in eg_autotopology.ini, if Nick / Port is changed
		if(frmTopology!=null && frmTopology.equalsIgnoreCase("yes"))
		{
			if(initPort!=null && !initPort.equals(sportno) || 
				hostname!=null && !hostname.equals(oldhostname))
			{
				EgTopoInfo.newHostName = hostname;
				EgTopoInfo.newPortValue = sportno;
				changeNickInAutoTopology(stype ,hostname, oldhostname, initPort, sportno, topoSegName);
			}
		}
	}

	//---Delete from DB-----
	UpdateAndTransmitTopoInfo delFromDB = new UpdateAndTransmitTopoInfo();
	removeOldEntries(newNickAdded, hostname, delFromDB);

	/*
	String prevExtAgents = request.getParameter("prevExtAgents");
	String selExtAgents = request.getParameter("extAgents");
	String[] prevAgentTokens = StringUtils.getTokens(prevExtAgents, EgConstants.COMMA);
	String[] selAgentTokens = StringUtils.getTokens(selExtAgents, EgConstants.COMMA);
	if (selExtAgents != null)
	{
		selExtAgents = StringUtils.getUniqueArrayAsString(selAgentTokens);
	}

	List agentsToBeRemoved = new LinkedList();
	agentsToBeRemoved.addAll(Arrays.asList(prevAgentTokens));
	agentsToBeRemoved.removeAll(Arrays.asList(selAgentTokens));
	*/

	List agentsToBeRemoved = new LinkedList();
	String prevExtAgents = request.getParameter("prevExtAgents");
	if(!StringUtils.isNull(prevExtAgents))
		agentsToBeRemoved.addAll(Arrays.asList(StringUtils.getTokens(prevExtAgents, EgConstants.COMMA)));

	String selExtAgents = request.getParameter("extAgents");
	if(!StringUtils.isNull(selExtAgents))
		agentsToBeRemoved.removeAll(Arrays.asList(StringUtils.getTokens(selExtAgents, EgConstants.COMMA)));

	/*
	 * Add remote agent to the list of agents to be removed if changed
	 */
	//String prevRemAgent = request.getParameter("prevRemAgent");
	if (!StringUtils.isNull(remoteAgent)
		&& !remoteAgent.equalsIgnoreCase("null")
		&& !prevRemAgent.equals(remoteAgent))
	{
		agentsToBeRemoved.add(prevRemAgent);
	}

	if (update)
	{
		if (addCompForDiscovery != null && (addCompForDiscovery.trim().equalsIgnoreCase("yes") || addCompForDiscovery.trim().equalsIgnoreCase("true")))
		{
			//Vmware Vcenter eg_services.ini entries
			//IniFile serviceWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
			IniFile servReadModeIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
			IniFile agtLessReadModeIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_agentlessdisc.ini");
			ArrayList discCompList = new ArrayList();
			ArrayList discAgentCompList = new ArrayList();
			String agentForSubject = remoteAgent;

			String discoverHyperThru = mgrmiscIni.getValue("MISC_ARGS", "DiscoverHypervisorsThru");
			if (StringUtils.isNull(discoverHyperThru))
			{
				String eGMgrModel = servReadModeIni.getValue("MISC_ARGS","eGMgrModel");
				if (eGMgrModel != null && eGMgrModel.equalsIgnoreCase("msp"))
				{
					discoverHyperThru = "Agent";
				}
				else
				{
					discoverHyperThru = "Manager";
				}
			}

			if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("Virtual_center"))
			{
				if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
				{
					String[] vCs =  servReadModeIni.getVariables("VIRTUAL_CENTER");
					List vCList = new ArrayList();
					if (vCs != null)
					{
						for (int v=0; v<vCs.length; v++)
						{
							vCList.add(vCs[v].toLowerCase());
						}
					}
					String vCenterValue =  "True#$unconfigured#$unconfigured#No#443";
					if(!vCList.contains(hostip.toLowerCase()))
					{
						discCompList.add(new IniHelper("VIRTUAL_CENTER",hostip,vCenterValue));
					}
				}
				else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
				{
					if (!StringUtils.isNull(agentForSubject))
					{
						String vCs[] =  agtLessReadModeIni.getVariables(agentForSubject);
						List vCList = new ArrayList();
						if (vCs != null)
						{
							for (int v=0; v<vCs.length; v++)
							{
								vCList.add(vCs[v].toLowerCase());
							}
						}

						if (!vCList.contains("vcenter#"+hostip.toLowerCase()))
						{
							String vCenterValue = "no~#~$unconfigured~#~$unconfigured~#~443~#~true";
							discAgentCompList.add(new IniHelper(agentForSubject, "vcenter#" +hostip,vCenterValue));
						}

					}
				}
			}
			else if (!com.egurkha.util.StringUtils.isNull(stype) && 
				(stype.equals("Nutanix_Cluster") || stype.equals("Nutanix_Prism_Center")))
			{
				if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
				{
					String[] vCs =  servReadModeIni.getVariables("NUTANIX");
					List vCList = new ArrayList();
					if (vCs != null)
					{
						for (int v=0; v<vCs.length; v++)
						{
							vCList.add(vCs[v].toLowerCase());
						}
					}

					String vCenterValue =  "True#$unconfigured#$unconfigured#No#9440#false";
					if (stype.equals("Nutanix_Prism_Center"))
					{
						vCenterValue =  "True#$unconfigured#$unconfigured#No#9440#true";
					}

					if(!vCList.contains(hostip.toLowerCase()))
					{
						discCompList.add(new IniHelper("NUTANIX",hostip,vCenterValue));
					}
				}
				else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
				{
					if (!StringUtils.isNull(agentForSubject))
					{
						String vCs[] =  agtLessReadModeIni.getVariables(agentForSubject);
						List vCList = new ArrayList();
						if (vCs != null)
						{
							for (int v=0; v<vCs.length; v++)
							{
								vCList.add(vCs[v].toLowerCase());
							}
						}

						if (!vCList.contains("nutanix#"+hostip.toLowerCase()))
						{
							String vCenterValue = "no~#~$unconfigured~#~$unconfigured~#~9440~#~true~#~false";
							if (stype.equals("Nutanix_Prism_Center"))
							{
								vCenterValue = "no~#~$unconfigured~#~$unconfigured~#~9440~#~true~#~true";
							}
							discAgentCompList.add(new IniHelper(agentForSubject, "vcenter#" +hostip,vCenterValue));
						}

					}
				}
			}
			else if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("Redhat_linux_mgr"))
			{
				if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
				{
					String[] rhevs = servReadModeIni.getVariables("RHEV");
					List rhevList = new ArrayList();
					if (rhevs != null)
					{
						for (int v=0; v<rhevs.length; v++)
						{
							rhevList.add(rhevs[v].toLowerCase());
						}
					}
					String rhevValue =  "True#$unconfigured#$unconfigured#No#443#internal";
					if (!rhevList.contains(hostip.toLowerCase()))
					{
						discCompList.add(new IniHelper("RHEV",hostip,rhevValue));
					}
				}
				else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
				{
					if (!StringUtils.isNull(agentForSubject))
					{
						String rhevs[] =  agtLessReadModeIni.getVariables(agentForSubject);
						List rhevList = new ArrayList();
						if (rhevs != null)
						{
							for (int v=0; v<rhevs.length; v++)
							{
								rhevList.add(rhevs[v].toLowerCase());
							}
						}

						if (!rhevList.contains("rhev#"+hostip.toLowerCase()))
						{
							String rhevValue = "no~#~$unconfigured~#~$unconfigured~#~443~#~No~#~internal";
							discAgentCompList.add(new IniHelper(agentForSubject, "rhev#" +hostip,rhevValue));
						}
					}
				}
			}
			else if (!com.egurkha.util.StringUtils.isNull(stype) && stype.equals("hmc_server"))
			{
				if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("manager"))
				{
					String hmcs[] =  servReadModeIni.getVariables("HMC");
					List hmcList = new ArrayList();
					if (hmcs != null)
					{
						for (int v=0; v<hmcs.length; v++)
						{
							hmcList.add(hmcs[v].toLowerCase());
						}
					}
					String pseriesValue =  "True#$unconfigured#$unconfigured#No#"+hostname;
					if (!hmcList.contains(hostip.toLowerCase()))
					{
						pseriesValue =  "True#"+remoteUser+"#"+remotepwd+"#No#"+hostname;
						discCompList.add(new IniHelper("HMC",hostip,pseriesValue));
					}
					else
					{
						String pass = remotepwd;
						if (pass != null)
						{
							pass = EgUIUtils.decodeSecurityChar(remotepwd);
							pass = EgCrypt.decrypt(pass);
						}

						if (modifying && !remoteUser.equalsIgnoreCase("none") && !pass.equalsIgnoreCase("none"))
						{
							boolean isAnyOneChanged = false;
							String hmcPattern =  servReadModeIni.getValue("HMC", hostip);
							if (hmcPattern != null)
							{
								StringTokenizer sst = new StringTokenizer(hmcPattern,"#");
								if(sst.hasMoreTokens())
								{
									String ssl = sst.nextToken();
									String existUname = sst.nextToken();
									String existUpass = sst.nextToken();
									existUpass = EgCrypt.decrypt(existUpass);
									String isDiscovery = sst.nextToken();
									String hostName = sst.nextToken();
									if (!((existUname.equals(remoteUser)) && (existUpass.equals(pass))))
									{
										isAnyOneChanged = true;
									}

									if (!existUname.equals(remoteUser))
									{
										existUname = remoteUser;
									}

									if (!existUpass.equals(pass))
									{
										existUpass = EgCrypt.encrypt(pass);
									}
									pseriesValue =  ssl+"#"+existUname+"#"+existUpass+"#"+isDiscovery+"#"+hostip;
								}
							}

							if (isAnyOneChanged)
							{
								Hashtable listOfComponentsmap = new Hashtable();
								HashMap valsToChange2 = new HashMap();
								valsToChange2.put("management_user",remoteUser);
								valsToChange2.put("management_password",remotepwd);
								ArrayList valsToChange = new ArrayList();
								valsToChange.add(valsToChange2);

								ArrayList esx_vdi_componentsList = new ArrayList();
								esx_vdi_componentsList.add("pSeries_server");
								for(int h=0;h<esx_vdi_componentsList.size();h++)
								{
									String thisType = (String) esx_vdi_componentsList.get(h);
									ArrayList listOfComponents = new ArrayList(Arrays.asList(egRoleInfo.getAllServersOfType(thisType)));
									listOfComponentsmap.put(thisType,listOfComponents);
								}

								discCompList.add(new IniHelper("HMC",hostip,pseriesValue));
								Set resultHVs = updateChanges("hmc", "management_server", hostip, valsToChange, listOfComponentsmap, remoteAgent);
								if (resultHVs != null && !resultHVs.isEmpty())
								{
									autoConfigHVCompsForAuditLog.addAll(resultHVs);
								}
							}
						}
					}
				}
				else if (!StringUtils.isNull(discoverHyperThru) && discoverHyperThru.equalsIgnoreCase("agent"))
				{
					if (!StringUtils.isNull(agentForSubject))
					{
						String hmcs[] =  agtLessReadModeIni.getVariables(agentForSubject);
						List hmcList = new ArrayList();
						if (hmcs != null)
						{
							for (int v=0; v<hmcs.length; v++)
							{
								hmcList.add(hmcs[v].toLowerCase());
							}
						}

						if (!hmcList.contains("hmc#"+hostip.toLowerCase()))
						{
							String pseriesValue = "no~#~"+remoteUser+"~#~"+remotepwd+"~#~No~#~"+hostip;
							discAgentCompList.add(new IniHelper(agentForSubject, "hmc#" +hostip,pseriesValue));
						}
						else
						{
							String pass = remotepwd;
							if (pass != null)
							{
								pass = EgUIUtils.decodeSecurityChar(remotepwd);
								pass = EgCrypt.decrypt(pass);
							}

							if (modifying && !remoteUser.equalsIgnoreCase("none") && !pass.equalsIgnoreCase("none"))
							{
								boolean isAnyOneChanged = false;
								String hmcPattern =  agtLessReadModeIni.getValue(agentForSubject, "hmc#" +hostip);
								if (hmcPattern != null)
								{
									StringTokenizer sst = new StringTokenizer(hmcPattern,"~#~");
									if(sst.hasMoreTokens())
									{
										String ssl = sst.nextToken();
										String existUname = sst.nextToken();
										String existUpass = sst.nextToken();
										existUpass = EgCrypt.decrypt(existUpass);
										String isDiscovery = sst.nextToken();
										String hostName = sst.nextToken();
										if (!((existUname.equals(remoteUser)) && (existUpass.equals(pass))))
										{
											isAnyOneChanged = true;
										}

										if (!existUname.equals(remoteUser))
										{
											existUname = remoteUser;
										}

										if (!existUpass.equals(pass))
										{
											existUpass = EgCrypt.encrypt(pass);
										}
										String pseriesValue =  ssl+"~#~"+existUname+"~#~"+existUpass+"~#~"+isDiscovery+"~#~"+hostip;
										discAgentCompList.add(new IniHelper(agentForSubject, "hmc#" +hostip,pseriesValue));
									}
								}

								if (isAnyOneChanged)
								{
									Hashtable listOfComponentsmap = new Hashtable();
									HashMap valsToChange2 = new HashMap();
									valsToChange2.put("management_user",remoteUser);
									valsToChange2.put("management_password",remotepwd);
									ArrayList valsToChange = new ArrayList();
									valsToChange.add(valsToChange2);

									ArrayList esx_vdi_componentsList = new ArrayList();
									esx_vdi_componentsList.add("pSeries_server");
									for(int h=0;h<esx_vdi_componentsList.size();h++)
									{
										String thisType = (String) esx_vdi_componentsList.get(h);
										ArrayList listOfComponents = new ArrayList(Arrays.asList(egRoleInfo.getAllServersOfType(thisType)));
										listOfComponentsmap.put(thisType,listOfComponents);
									}

									Set resultHVs = updateChanges("hmc", "management_server", hostip, valsToChange, listOfComponentsmap, remoteAgent);
									if (resultHVs != null && !resultHVs.isEmpty())
									{
										autoConfigHVCompsForAuditLog.addAll(resultHVs);
									}
								}
							}
						}
					}
				}
			}
			//EgConfigFilesSync.releaseInstance(serviceWrite);
			if (discCompList.size()>0)
			{
				IniFile serviceWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
				for (int s=0;s<discCompList.size() ;s++ )
				{
					IniHelper iniHelper = (IniHelper)discCompList.get(s);
					String sub = iniHelper.getSubject();
					String key = iniHelper.getVariable();
					String val = iniHelper.getValue();
					serviceWrite.setValue(sub, key, val);
				}
				serviceWrite.saveFile();
				EgConfigFilesSync.releaseInstance(serviceWrite);
			}

			if (discAgentCompList.size()>0)
			{
				IniFile agtLssDiscWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_agentlessdisc.ini");
				for (int s=0;s<discAgentCompList.size() ;s++ )
				{
					IniHelper iniHelper = (IniHelper)discAgentCompList.get(s);
					String sub = iniHelper.getSubject();
					String key = iniHelper.getVariable();
					String val = iniHelper.getValue();
					agtLssDiscWrite.setValue(sub, key, val);
				}
				agtLssDiscWrite.saveFile();
				EgConfigFilesSync.releaseInstance(agtLssDiscWrite);
			}
		}

		if (agentsToBeRemoved.size() > 0)
		{
			UpdateAndTransmitTrendInfo trendInfo = new UpdateAndTransmitTrendInfo();
			Vector param = new Vector();
			param.add("Egnewserverp");
			param.add(agentsToBeRemoved);
			param.add(hostname);
			trendInfo.removeAgentForTarget(param);
		}

		//EgConfigTopo.saveFile();
		discWrite.saveFile();		
		EgConfigFilesSync.releaseInstance(discWrite);
		/*userCompIniWrite.saveFile();		
		EgConfigFilesSync.releaseInstance(userCompIniWrite);*/

		if (isLimitedAdmin)
		{
			//If autoCreateZoneForUser is set to true, then assign the component(s) to the user's zone.
			boolean autoCreateZoneForUser = EgUuidInfo.autoCreateZone();

			Hashtable argsMap = new Hashtable();
			Hashtable resultMap = new Hashtable();
			String resultStr = "";
			String compName = hostname + ":" + sportno;

			if(stype.equals("Oracle_server"))
			{
				ArrayList currSidList = (sid != null) ? StringUtils.egTokenizer(sid,",",false,true,true) : new ArrayList();
				if(modifying)
				{
					String previousSID = request.getParameter("previoussid");
					ArrayList prevSidList =  (previousSID != null) ? StringUtils.egTokenizer(previousSID,",",false,true,true) : new ArrayList();
					currSidList.removeAll(prevSidList);
				}
				String[] sidTokens = (String[])currSidList.toArray(new String[currSidList.size()]);
				for (int a=0; a<sidTokens.length; a++)
				{
					compName = hostname + ":" + sportno + ":" + sidTokens[a];
					argsMap = new Hashtable();
					argsMap.put("userid",user_id);
					argsMap.put("componenttype",stype);
					argsMap.put("components",compName);
					argsMap.put("autoassociatetype","no");
					resultStr = uacObj.AssociateComponent(argsMap);
					if (autoCreateZoneForUser && resultStr.length()>0 && resultStr.equalsIgnoreCase("eG_CLI_Res_0286"))
					{
						argsMap = new Hashtable();
						argsMap.put("userid",user_id);
						argsMap.put("stype",stype);
						argsMap.put("compname",compName);
						resultMap = uacObj.AutoAssociateComponentToZone(argsMap);
					}
				}
			}
			else if (!modifying)
			{
				argsMap = new Hashtable();
				argsMap.put("userid",user_id);
				argsMap.put("componenttype",stype);
				argsMap.put("components",compName);
				argsMap.put("autoassociatetype","no");
				resultStr = uacObj.AssociateComponent(argsMap);
				if (autoCreateZoneForUser && resultStr.length()>0 && resultStr.equalsIgnoreCase("eG_CLI_Res_0286"))
				{
					argsMap = new Hashtable();
					argsMap.put("userid",user_id);
					argsMap.put("stype",stype);
					argsMap.put("compname",compName);
					resultMap = uacObj.AutoAssociateComponentToZone(argsMap);
				}
			}

			//for zone audit log
			if (autoCreateZoneForUser && resultStr.length()>0 && resultStr.equalsIgnoreCase("eG_CLI_Res_0286") && resultMap != null && !resultMap.isEmpty())
			{
				IniFile mgrMiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
				String associatedUsers = "";
				String associaedZones = "", disAssociatedZones = "";
				Enumeration enMapKeys = resultMap.keys();
				while (enMapKeys.hasMoreElements())
				{
					String userName = (String)enMapKeys.nextElement();
					String zoneName = mgrMiscIni.getValue("Auto_Created_Zone_User_Map",userName);
					if (zoneName == null || zoneName.trim().length() == 0)
					{
						zoneName = userName;
					}
					String resultStr2 = (String)resultMap.get(userName);
					if (!resultStr2.startsWith("eG_CLI_Err"))
					{
						associaedZones += zoneName + ",";
						associatedUsers += userName + ",";
					}
					else
					{
						disAssociatedZones += zoneName + ",";
					}
				}
				String descMsg = "";
				AuditLogThread auditLogThread2 = new AuditLogThread();
				auditLogThread2.setValue("Category","Admin");
				auditLogThread2.setValue("User_id",_user.getLoginID());
				auditLogThread2.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditLogThread2.setValue("Session_id",session.getId());
				auditLogThread2.setValue("Module","Zones");
				auditLogThread2.setValue("Activity","Auto Zone Configuration");
				if (associaedZones != null && associaedZones.length()>0)
				{
					associaedZones = associaedZones.substring(0,associaedZones.length()-1);
					associatedUsers = associatedUsers.substring(0,associatedUsers.length()-1);
					if (associaedZones.indexOf(",") > -1)
					{
						descMsg = "Zones "+ associaedZones +" have been added/modified and associated to the users "+associatedUsers+" successfully";
					}
					else
					{
						descMsg = "Zone "+ associaedZones +" has been added/modified and associated to the user "+associatedUsers+" successfully";
					}
				}
				if (disAssociatedZones != null && disAssociatedZones.length()>0)
				{
					disAssociatedZones = disAssociatedZones.substring(0,disAssociatedZones.length()-1);
					if (disAssociatedZones.indexOf(",") > -1)
					{
						descMsg += "Zones "+ disAssociatedZones +" have not been added/modified";
					}
					else
					{
						descMsg += "Zone "+ disAssociatedZones +" has not been added/modified";
					}
				}
				auditLogThread2.setValue("Description", descMsg);
				auditLogThread2.sendItToDB();
			}
		}
		else //only for admin with AllComponentAccess and Rmt/Ext-agent Managemtent permission
		{
			String AlreadyAsoociatedUserList1 = request.getParameter("AlreadyAsoociatedUserList");
			if(AlreadyAsoociatedUserList1!=null && AlreadyAsoociatedUserList1!= "")
			{
				StringTokenizer AlreadyAsoociatedUserList = new StringTokenizer(AlreadyAsoociatedUserList1,",");
				String compName = hostname + ":" + sportno;
				String resultStr = "";
				if(AlreadyAsoociatedUserList.countTokens() > 0)
				{
					Hashtable argsMap = new Hashtable();
				//	Iterator it = AlreadyAsoociatedUserList.iterator();
					while(AlreadyAsoociatedUserList.hasMoreTokens())
					{
						String UnAme=AlreadyAsoociatedUserList.nextToken().toString();
						argsMap = new Hashtable();
						argsMap.put("userid",UnAme);
						argsMap.put("componenttype",stype);
						argsMap.put("components",compName);
						argsMap.put("autoassociatetype","no");
						resultStr = uacObj.AssociateComponent(argsMap);
					}
				}
			}
		}
		//Admin Check ends -here

		EgDiscInfo discInfos = new EgDiscInfo("manager");
		EgSpecsInfo specsInfos = new EgSpecsInfo("manager");
		// get manager IP
		String managerHosts = specsInfos.getEGServer();
		specsInfos = null;
		EgExternalAgent ex = new  EgExternalAgent(discInfos, managerHosts, true);
		ex = new EgExternalAgent(discInfos, managerHosts, true);
		ArrayList aList = new ArrayList();
		aList.add(hostname);
		ex.buildExternalFile(aList);
		discInfos = null;
		ex = null;
		//Nickname change
		Vector v_types = new Vector();
		if (allServers)
		{
			sess_vec = new Vector();
			sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify components"));
			if(!StringUtils.isNull(treeViewSrc))
			{
				sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
			}
			else
			{
				sess_vec.add("EgDispServer.jsp?qctr=1&server="+stype+"&selectedServerGroup="+selectedServerGroup);
			}

			sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify components"));
	
			EgDiscInfo2 discInfo = new EgDiscInfo2("manager",true);
			if (modify.equals("yes"))
			{
				v_types = discInfo.updateAllServers(hostip,hostname,oldhostname);
			}
			else
			{
				v_types = discInfo.updateAllServers(hostip,hostname);
			}
			discInfo = null;

			if(v_types.size() > 0)
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.The components have been updated with")+" '" + removeNull(hostname) + "' "+_mapping.getTextDescription("admin.server.as host/nick name in the following component types.")+" ");
				String compTypes ="";
				for(int i=0; i<v_types.size(); i++)
				{
					String tmpCompType = _mapping.getComponentTypeDescription((String)v_types.get(i));	
					compTypes = compTypes+tmpCompType+",";  
				}
				compTypes = compTypes.substring(0,compTypes.length()-1);	
				sess_vec.add(compTypes.trim());
			}
			else
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Parameters configured for")+" "+_mapping.getComponentTypeDescription(stype));
				sess_vec.add("<br>"+_mapping.getTextDescription("admin.server.Component type")+"	: "+_mapping.getComponentTypeDescription(stype));
				if(!hostip.equals("0.0.0.0"))
				{
					if(isAllowHostName)
					{
						sess_vec.add("<br>"+_mapping.getTextDescription("admin.server.Host IP/Name")+"			: "+hostip);	
					}
					else
					{
						sess_vec.add("<br>"+_mapping.getTextDescription("admin.server.Host IP")+"			: "+hostip);
					}
				}
				sess_vec.add("<br>"+_mapping.getTextDescription("admin.server.Nick name")+"			: "+removeNull(hostname));
			}
		}
		//End of Nickname change
		/*
		 * Modify files here one by one
		 */

		ArrayList aListOracleServers = null;
		if(oracleServers != null && oracleServers.length > 0)
		{
			if (allNicks != null && allNicks.length > 0)
			{
				for(int c=0;c<oracleServers.length;c++)
				{
					String oracleNick = oracleServers[c].trim();
					for(int a=0;a<allNicks.length;a++)
					{
						if(oracleNick.endsWith(":"+allNicks[a]))
						{
							if(aListOracleServers == null)
								aListOracleServers = new ArrayList();
							aListOracleServers.add(oracleNick.substring(oracleNick.indexOf(":")+1));
							break;
						}
					}
				}
			}
		}
		oracleServers = null;
		
								


		UpdateNicknames  updateNicknames = new UpdateNicknames ();
		
		//Updating eg_apmGuid.ini 
		String[] valuesForGuid = new String[6];
		valuesForGuid[0] = serverType;
		valuesForGuid[1] = hostip;
		valuesForGuid[2] = hostname;
		valuesForGuid[3] = oldAlias;
		valuesForGuid[4] = sportno;
		valuesForGuid[5] = oldPort;
		updateNicknames.updateApmGuidIni(modify.equals("yes"),allServers,valuesForGuid,uuidInfo,user_id);

		String compName = hostname + ":" + sportno;
		IniFile egApmGuidIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_apmGuid.ini");					
		String nickWithPort = compName.replaceAll(":","^");
		String guidVariable = server_type+"^"+hostip+"^"+nickWithPort;
		String compGUID=egApmGuidIni.getValue("APM_GUID_MAPPING_WITH_NICK",guidVariable);
		rootJSON.put("nodeGUID",compGUID);
		
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile egUISave = new IniFile(s_iniFile_dir + uiFile);
		String showUsers=egUISave.getValue("ALARM_HISTORY","Show_Users");
		String updateUsersHash = egUISave.getValue("ALARM_HISTORY","UserCompsMapping");
		String curr_date=null;

		if(hostname != null && oldAlias != null && !hostname.equalsIgnoreCase(oldAlias))
		{
			//Citrix Dashboard View Update starts
			try
			{
				if((showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes"))) || (updateUsersHash!=null && (updateUsersHash.equalsIgnoreCase("true") || updateUsersHash.equalsIgnoreCase("yes"))))
				{
					curr_date=String.valueOf(new java.util.Date());
					if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
					{
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
					else
					{
						ecumb.hashLastComponentUserUpdated=new Hashtable();
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
				}

				List users = new ArrayList();
				List removeUsers = new ArrayList();
				Hashtable userComponentMap = new Hashtable();
				userComponentMap = ecumb.getUserNamesForComponentMap();
				if(!userComponentMap.isEmpty())
				{
					Iterator it = userComponentMap.entrySet().iterator();

					while(it.hasNext())
					{
						Entry en = (Entry)it.next();
						String comp_type_name = (String)en.getKey();
						Object obj = (Object)en.getValue();
			
						if(obj instanceof Hashtable)
						{
							Hashtable user_role_map = (Hashtable)obj;
							Iterator it1 = user_role_map.entrySet().iterator();
							while(it1.hasNext())
							{
								Entry en1 = (Entry)it1.next();
								String user_map_val = (String)en1.getKey();
								String user_map_role = (String)en1.getValue();
								//if(user_map_role.equalsIgnoreCase("Admin") || user_map_role.equalsIgnoreCase("Supermonitor"))
								//if(user_map_role.equalsIgnoreCase("Admin"))
								if(user_map_role.equalsIgnoreCase("Admin") || user_map_role.equalsIgnoreCase("ServerAdmin") || user_map_role.equalsIgnoreCase("SupermonitorNoConfig") || user_map_role.equalsIgnoreCase("Supermonitor"))
								{
									if(!user_map_val.equalsIgnoreCase("egenterprise"))
										users.add(user_map_val);
								}else if(user_map_role.equalsIgnoreCase("AlarmViewer")){
									removeUsers.add(user_map_val);
								}
							}

						}

						if(obj instanceof Vector)
						{
							Vector user_valuee = (Vector)obj;
							if(comp_type_name.indexOf(serverType+":"+oldAlias+":") > -1)
								users.addAll(user_valuee);						
						}
					}
				}
				users.removeAll(removeUsers);
				int userSize = users.size();
				if(users != null && userSize > 0)
				{
					Set set = new HashSet(users);
					//set.addAll(users);
					users.clear();
					users.addAll(set);
					userSize = users.size();
					Hashtable deleteHash = new Hashtable();
					Hashtable addHash = new Hashtable();
					IniFile citrixIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_citrixdashboard.ini");
					//IniFile citrixSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_citrixdashboard.ini");
					boolean saveFile = false;
					for(int b = 0;b<userSize;b++)
					{
						String userName = (String)users.get(b);
						String dashBoardSet = citrixIni.getValue("Dashboard_List","Dashboard_Names");
						ArrayList dashBoardList = com.egurkha.util.StringUtils.egTokenizer(dashBoardSet,",",false,true,true);
						int dashBoardListSize = dashBoardList.size();
						String dashboardType = "";
						for(int c=0;c<dashBoardListSize;c++)
						{
							dashboardType = (String)dashBoardList.get(c);
							String subject = userName+":"+dashboardType+":Mapping";
							Vector vars = citrixIni.getVariables(subject,true);
							Vector vals = citrixIni.getAllValues(subject);
							if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
							{
								int valSize = vals.size();
								for(int ic=0;ic<valSize;ic++)
								{
									String varsString = vars.get(ic).toString();
									String valsString = vals.get(ic).toString();
									if(valsString.startsWith("Components:") && valsString.indexOf(oldAlias+":") > -1)
									{
										Vector varr = (Vector) deleteHash.get(subject);
										if (varr == null)
											varr = new Vector();
											
										varr.add(varsString);
										deleteHash.put(subject,varr);
										//citrixSync.deleteValue(subject,varsString);
										valsString = valsString.replace(oldAlias+":",hostname+":");
										//citrixSync.setValue(subject,varsString,valsString);
										Vector valVar = (Vector) addHash.get(subject);														
										if(valVar != null)
										{
											Vector _vars  = (Vector)valVar.get(0);
											Vector _vals  = (Vector)valVar.get(1);
											_vars.add(varsString);
											_vals.add(valsString);

											//addHash.put(subject,valVar);
										}
										else
										{
											Vector varss = new Vector();
											Vector valss = new Vector();
											varss.add(varsString);
											valss.add(valsString);

											valVar = new Vector();
											valVar.add(varss);
											valVar.add(valss);
											addHash.put(subject,valVar);
										}
									}
								}
							}
						}
					}

					if(!deleteHash.isEmpty() && !addHash.isEmpty())
					{
						IniFile citrixSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_citrixdashboard.ini");

						try
						{
							if (deleteHash.size() > 0)
							{
								Enumeration ee = deleteHash.keys();
								while (ee.hasMoreElements())
								{
									String key = (String) ee.nextElement();
									Vector vars = (Vector)deleteHash.get(key);
									if (vars != null && vars.size() > 0)
									{
										citrixSync.deleteValues(key, vars);									
										saveFile = true;
									}
								}
							}

							Iterator it = addHash.entrySet().iterator();
							while(it.hasNext())
							{
								Entry entry = (Entry)it.next();
								String subject = (String)entry.getKey();
								Vector varVals = (Vector)entry.getValue();
								Vector _vars  = (Vector)varVals.get(0);
								Vector _vals  = (Vector)varVals.get(1);
								citrixSync.setValues(subject, _vars, _vals,false);
								saveFile = true;
							}									
						}
						catch(Exception exc)
						{
							//ex.printStackTrace();
						}

						if(saveFile)
							citrixSync.saveFile();

						EgConfigFilesSync.releaseInstance(citrixSync);
					}
				}
			}
			catch(Exception e)
			{
			}
			//Citrix Dashboard View Update ends
		}

		if (variableName != null && variableName.indexOf(":") != -1)
		{
			String[] values;
			if (allServers)
			{
				String nicks = s_nicks;
				values = new String[7];
				values[0] = serverType;
				values[1] = hostname;
				values[2] = oldAlias;
				if (serverType.equals("Oracle_server") && (sportno.indexOf(":")==-1))
				{
					values[3] = sportno+":"+hsid;
				}else
				values[3] = sportno;
				values[4] = oldPort;
				values[5] = nicks;
				values[6] = null;
			}
			else
			{
				values = new String[6];
				values[0] = serverType;
				values[1] = hostname;
				values[2] = oldAlias;
				if (serverType.equals("Oracle_server") && (sportno.indexOf(":")==-1))
				{
					values[3] = sportno+":"+hsid;
				}else
				values[3] = sportno;
				values[4] = oldPort;
				values[5] = null;
			}

			int iniLoc = values.length-1;
			String[] iniFiles = {
						"eg_disable.ini", "true"
						,"eg_discover.ini","true"
						,"eg_thresholds.ini", "true"
						,"eg_topology.ini", "true"
						,"js_topology.ini","true"
						,"eg_group.ini", "true"
						,"eg_external.ini", "true"
						,"eg_infogroup.ini","true"
						,"eg_maintenance.ini","true"
						,"eg_testinfo.ini","true"
						,"eg_mailalert.ini","true"
						,"eg_TroubleTicketFilter.ini","true"
						,"eg_report.ini","true"
						,"eg_hmcmapping.ini","true"
						,"eg_vcmapping.ini","true"
						,"eg_rhevmapping.ini","true"
						,"eg_autotopology.ini","true"
						,"eg_pwdprofile.ini","true"
						//,"eg_usercompmapping.ini","true"
						,"eg_aggregate.ini","true"
						,"eg_customdashboard.ini","true"
						,"eg_autodelete.ini","true"
						,"eg_mgrmisc.ini","true"
						,"eg_msdashboard.ini","true"
						,"eg_wvd.ini","true"
								};
			
//-----------------Stalin 21/06/07-------------------------------
			if(hostname != null && oldhostname != null)
			//Delete Variables from eg_topology.ini, DB, eg_disable.ini 
			{
				//IniFile topoInfoIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_topology.ini", true);
				IniFile topoInfoIni = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
				String[] topoIniVariables =  topoInfoIni.getVariables("TEST_GROUPS");
				needSave = false;
				for(int i=0; i < topoIniVariables.length; i++)
				{
				
					String tempVar= topoIniVariables[i];
					String tempTopoHost1 = (tempVar.substring(tempVar.indexOf("::")+2,tempVar.indexOf("#")));
					String tempTopoHost2 = tempTopoHost1.substring(0,tempTopoHost1.indexOf(":")); 
					if(tempTopoHost2.equals(oldhostname))
					{
						topoInfoIni.deleteValue("TEST_GROUPS", tempVar);
						needSave = true;
					}
				}
				if (needSave)
					topoInfoIni.saveFile();
				EgConfigFilesSync.releaseInstance(topoInfoIni);

				String infos = null;
				String[] arr_tList = testlist.getTestList(stype);//all tests of given server
				List list = Arrays.asList(arr_tList);
				//IniFile specsIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_specs.ini", true);
				IniFile specsIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_specs.ini");
				Vector specsIniVariables = specsIni.getAllValues ("CONFIG_FGENERIC_TESTS");
				Enumeration enm = specsIniVariables.elements();
				while(enm.hasMoreElements())
				{
					String tempSpecsVar = (String)enm.nextElement();
					StringTokenizer tokens = new StringTokenizer(tempSpecsVar,",");
					String specsTestToken = null;
					while(tokens.hasMoreTokens())
					{
						specsTestToken = tokens.nextToken();
						if(list.contains(specsTestToken))
						{
							infos = specsTestToken+"_INFOS";
							String delQuery = "delete from "+infos+" where trgt_host ='"+oldhostname+"'";
							delFromDB.deleteFromDb(delQuery);
						}
					}

				}
				//---Delete from eg_disable.ini------
				//IniFile disIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_disable.ini", true);
				//IniFile disIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
				IniFile disIni = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
				String[] disIniVariables =  disIni.getVariables("Disabled_servers");
				ArrayList entriesToDelete = new ArrayList();
				for(int i=0; i < disIniVariables.length; i++)
				{
					String tempVar= disIniVariables[i];
				//	String tempDist = (tempVar.substring(tempVar.indexOf("::")+2,tempVar.lastIndexOf(":")));
					String xx = tempVar.substring(tempVar.indexOf("::")+2);
					int ind = xx.lastIndexOf(":");
					String tempDist = null;
					if (ind >=0)
						tempDist = xx.substring(0,ind);
					else
						tempDist = xx;
					if(tempDist.equals(oldhostname))
					{
						entriesToDelete.add(new IniHelper("Disabled_servers",tempVar));
						//disIni.deleteValue("Disabled_servers", tempVar);
					}
				}
				//disIni.saveFile();
				if (entriesToDelete.size() > 0)
				{
					//IniFile disableIni = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
					for (int n=0; n <entriesToDelete.size(); n++)
					{
						IniHelper iniHelper = (IniHelper)entriesToDelete.get(n);
						String sub = iniHelper.getSubject();
						String key = iniHelper.getVariable();
						disIni.deleteValue(sub, key);
					}
					disIni.saveFile();
					//EgConfigFilesSync.releaseInstance(disIni);
				}
				EgConfigFilesSync.releaseInstance(disIni);
			}
//-----------------------------------------------		
			updateNicknames.setOracleServers_NickAsSID(aListOracleServers);
			for (int a=0; a<iniFiles.length; a+=2)
			{
				values[iniLoc] = iniFiles[a];
				Boolean modifyValue = Boolean.valueOf(iniFiles[a+1]);
				if (allServers)
				{
					updateNicknames.modifyIniForAllServers(null, values, modifyValue.booleanValue());
				}
				else
				{
					boolean useType = true;
					//if you have a component name withoiut port, update the inifile details over here! - pandian
					if (a == 2 || 
						a==4 || 
						a==12 || 
						a==14)
						useType = false;
					updateNicknames.modifyIni(null, values, modifyValue.booleanValue(),useType);
				}			
			}
			values[iniLoc] = "eg_agents.ini";
			List agentsForOldHost = (List)agentsForOldHosts.get(values[2]);
			updateNicknames.modifyAgentsIni(agentsForOldHost,values);
			/*
			 * Now modify the database. If all servers are chosen, then those comp_name rows must be retrieved
			 */
			updateNicknames.modifyDb(values);
			updateNicknames.modifyTopoDb(values);
		}
		else if (allServers && variableName != null && !(variableName.indexOf(":") != -1))
		{
			String[] values;
			String nicks = s_nicks;
			String[] iniFiles = {
						"eg_disable.ini", "true"
						,"eg_discover.ini","true"
						,"eg_thresholds.ini", "true"
						,"eg_topology.ini", "true"
						,"js_topology.ini","true"
						,"eg_group.ini", "true"
						,"eg_external.ini", "true"
						,"eg_infogroup.ini","true"
						,"eg_maintenance.ini","true"
						,"eg_testinfo.ini","true"
						,"eg_mailalert.ini","true"
						,"eg_TroubleTicketFilter.ini","true"
						,"eg_report.ini","true"
						,"eg_hmcmapping.ini","true"
						,"eg_vcmapping.ini","true"
						,"eg_rhevmapping.ini","true"
						,"eg_autotopology.ini","true"
						,"eg_pwdprofile.ini","true"
						//,"eg_usercompmapping.ini","true"
						,"eg_aggregate.ini","true"
						,"eg_customdashboard.ini","true"
						,"eg_autodelete.ini","true"
						,"eg_mgrmisc.ini","true"
						,"eg_msdashboard.ini","true"
						,"eg_wvd.ini","true"
								};
			values = new String[7];
			values[0] = serverType;
			values[1] = hostname;
			values[2] = oldAlias;
			values[3] = sportno;
			values[4] = oldPort;
			values[5] = nicks;

			for (int a=0; a<iniFiles.length; a+=2)
			{
				values[6] = iniFiles[a];
				Boolean modifyValue = Boolean.valueOf(iniFiles[a+1]);
				updateNicknames.setOracleServers_NickAsSID(aListOracleServers);
				updateNicknames.modifyIniForAllServers(null, values, modifyValue.booleanValue());
			}
			updateNicknames.modifyDb(values);
			updateNicknames.modifyTopoDb(values);

			List agentsForOldHost = null;
			values[values.length-1] = "eg_agents.ini";
			if (allNicks != null && allNicks.length > 0)
			{
				for(int b=0;b<allNicks.length;b++)
				{
					values[2] = allNicks[b];
					agentsForOldHost = (List)agentsForOldHosts.get(allNicks[b]);
					updateNicknames.modifyAgentsIni(agentsForOldHost,values);
				}
			}
			agentsForOldHost = null;
		}
		agentsForOldHosts = null;
		updateNicknames = null;
		boolean allExternalTests = true;
		EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

		String aggType = request.getParameter("isAggregateType"); //skm

		if (aggType.equalsIgnoreCase("true"))	
		{
			//egExtIni.createFile("eg_external.ini","save");
			extIniWr = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
			// Add the user specified external agent(s)
			String[] extAgent = request.getParameterValues("extAgents");
			if (extAgent != null && extAgent.length > 0)
			{
				extIniWr.setValue("Test_Mapping_Section", hostname, StringUtils.getUniqueArrayAsString(extAgent));
			}

			//vmwarehosts starts here
			if (stype.equals("VMware_guest"))
			{
				if (vmwarehostentry!=null && !vmwarehostentry.equals("-1"))
				{
					extIniWr.setValue("VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno, vmwarehostentry);
				}else if (vmwarehostentry!=null && vmwarehostentry.equals("-1"))
				{
					extIniWr.deleteValue("VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno);
				}
			}
			//vmwarehosts ends here

			extIniWr.saveFile();
			EgConfigFilesSync.releaseInstance(extIniWr);

			String old_hostname = request.getParameter("oldhostname");

			String associated_comps = request.getParameter("fassociate");
			/* code for auditlog starts */
			StringTokenizer tokens = new StringTokenizer(associated_comps,",");
			Set serverSet = new TreeSet();
			while(tokens.hasMoreTokens())
			{
				String serverTypes = tokens.nextToken().toString();
				auditLogThread.setCurrentValue("Associated Components","$ctype$:"+serverTypes);//new
				serverTypes = serverTypes.substring(0,serverTypes.indexOf(":"));
				if(!serverSet.contains(serverTypes))
				{
					auditLogThread.setCurrentValue("Component Types","$ctype$:"+serverTypes);
					serverSet.add(serverTypes);
				}
			}
			//auditLogThread.setCurrentValue("Associated Components",associated_comps);
			if(modifying)
			{
				String exAssociatedComponents = request.getParameter("$_associated");
				serverSet = new TreeSet();
				if(exAssociatedComponents != null && exAssociatedComponents.trim().length()>0)
				{
					///auditLogThread.setPreviousValue("Associated Components",exAssociatedComponents);
					tokens = new StringTokenizer(exAssociatedComponents,",");
					while(tokens.hasMoreTokens())
					{
						String serverTypes = tokens.nextToken().toString();
						auditLogThread.setPreviousValue("Associated Components","$ctype$:"+serverTypes);
						serverTypes = serverTypes.substring(0,serverTypes.indexOf(":"));
						if(!serverSet.contains(serverTypes))
						{
							auditLogThread.setPreviousValue("Component Types","$ctype$:"+serverTypes);
							serverSet.add(serverTypes);
						}
					}
				}
			}
			/* code for auditlog ends */
			StringTokenizer associated_tokens = new StringTokenizer(associated_comps,",");

			IniFile aggWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
			String comptype_hostname = stype + ":" + old_hostname + ":" + sportno + "#";
			String[] agg_comps = aggWrite.getVariables("AGGREGATE_COMPONENTS");
			ArrayList aggEntries = new ArrayList();
			if ((agg_comps != null) && (agg_comps.length > 0))
			{
				for(int i=0;i<agg_comps.length;i++)
				{
					if (agg_comps[i].startsWith(comptype_hostname))
					{
						aggEntries.add(new IniHelper(IniHelper.DELETE,"AGGREGATE_COMPONENTS",agg_comps[i],""));
					}
				}
			}

			comptype_hostname = stype + ":" + hostname + ":" + sportno + "#";
			while (associated_tokens.hasMoreTokens())
			{
				aggEntries.add(new IniHelper(IniHelper.SET,"AGGREGATE_COMPONENTS", comptype_hostname+associated_tokens.nextToken(), "associated"));
			}
			String[] associations = aggWrite.getVariables("COMPONENT_ASSOCIATION");
			if ((associations != null) && (associations.length > 0))
			{
				for(int i=0;i<associations.length;i++)
				{
					if (associations[i].startsWith(stype + ":" + old_hostname + ":" + sportno))
					{
						aggEntries.add(new IniHelper(IniHelper.DELETE,"COMPONENT_ASSOCIATION", associations[i], ""));
					}
				}
			}

			if(stype.startsWith("Agg_"))
			{
				String elementType = request.getParameter("elementType");
				String elementName = request.getParameter("elementName");
				String memberComponent = request.getParameter("memberComponent");
				if(memberComponent != null && (memberComponent=memberComponent.trim()).length()>0 && 
					!memberComponent.equalsIgnoreCase("null"))
				{
					//EgGroupInfo groupInfo = new EgGroupInfo();
					IniFile groupInfo = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_group.ini");
					String key = stype+":"+hostname+":"+sportno+"#"+elementName;
					if(memberComponent.equalsIgnoreCase("yes"))
					{
						groupInfo.setValue("ZONE_DETAILS",key,elementName);
					}
					else if(memberComponent.equalsIgnoreCase("no"))
					{
						groupInfo.deleteValue("ZONE_DETAILS",key);
					}
					groupInfo.saveFile();
					EgConfigFilesSync.releaseInstance(groupInfo);
				}
				if(!StringUtils.isNull(elementType) && !elementType.equals("-1") && !StringUtils.isNull(elementName) && !elementName.equals("-1"))
				{
					aggEntries.add(new IniHelper(IniHelper.SET,"COMPONENT_ASSOCIATION",stype + ":" + hostname + ":" + sportno+"#"+elementType+"#"+elementName,elementType+"#"+elementName));
					/* deleting anchor component from [ANCHOR_COMPONENT] if components were added for this element name */
					String anchorComp = request.getParameter("anchorComp");
					if(!StringUtils.isNull(anchorComp))
					{
						String anchor_variables[] = aggWrite.getVariables("ANCHOR_COMPONENT");
						if(anchor_variables != null && anchor_variables.length > 0)
						{
							for(int i=0;i<anchor_variables.length;i++)
							{
								String anchor_variable = anchor_variables[i];
								if (anchor_variable.startsWith(stype+":") && anchor_variable.endsWith("#"+elementType+"#"+elementName))
								{
									aggEntries.add(new IniHelper(IniHelper.DELETE,"ANCHOR_COMPONENT",anchor_variable,""));
								}
							}
						}
						if(anchorComp.equals("yes"))
						{
							aggEntries.add(new IniHelper(IniHelper.SET,"ANCHOR_COMPONENT",stype + ":" + hostname + ":" + sportno+"#"+elementType+"#"+elementName,elementType+"#"+elementName));
						}
					}
					//deleting anchor component block ends
				}
			}
			String fromTree = request.getParameter("fromTree");
			if(!StringUtils.isNull(fromTree) && fromTree.equals("No") && stype.startsWith("Agg_"))
			{
				agg_comps = aggWrite.getVariables("UI_COMPONENT_ASSOCIATION");
				if ((agg_comps != null) && (agg_comps.length > 0))
				{
					for(int i=0;i<agg_comps.length;i++)
					{
						if (agg_comps[i].startsWith(comptype_hostname))
						{
							aggEntries.add(new IniHelper(IniHelper.DELETE,"UI_COMPONENT_ASSOCIATION",agg_comps[i],""));
						}
					}
				}
				String type_name = request.getParameter("type_name");
				String type_members = request.getParameter("type_members");
				if(!StringUtils.isNull(type_name) && !type_name.equals("-1") && !StringUtils.isNull(type_members) && !type_members.equals("-1"))
				{
					aggEntries.add(new IniHelper(IniHelper.SET,"UI_COMPONENT_ASSOCIATION",stype + ":" + hostname + ":" + sportno+"#"+type_name+"#"+type_members,type_name+"#"+type_members));
				}
			}
			if (aggEntries.size() > 0)
			{
				//IniFile aggWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
				for (int agg=0; agg < aggEntries.size(); agg++)
				{
					IniHelper iniHelper = (IniHelper)aggEntries.get(agg);
					String iniAction = iniHelper.getAction();
					String sub = iniHelper.getSubject();
					String key = iniHelper.getVariable();
					String val = iniHelper.getValue();

					if (iniAction != null)
					{
						if (iniAction.equals(IniHelper.SET))
						{
							aggWrite.setValue(sub,key,val);
						}
						else if (iniAction.equals(IniHelper.DELETE))
						{
							aggWrite.deleteValue(sub,key);
						}
					}
				}			
				aggWrite.saveFile();
				//EgConfigFilesSync.releaseInstance(aggWrite);
			}
			EgConfigFilesSync.releaseInstance(aggWrite);

		} //skm
		else
		{
			String[] testsForServer = specsInfo.getTestsForServer(stype);
			if (testsForServer != null)
			{
				for (int a=0; a<testsForServer.length; a++)
				{
					if (!specsInfo.isTestExternal(testsForServer[a],stype))
					{
						allExternalTests = false;
						break;
					}
				}
			}
		}

		String oldIntAgent = (String)session.getAttribute("int_agent");
		session.removeAttribute("int_agent");

		if(!StringUtils.isNull(oldIntAgent) || !StringUtils.isNull(currAgent)) 
		{
			if(currAgent == null)
				currAgent = hostname;
			else if(oldIntAgent == null)
				oldIntAgent = hostname;

			/* code for auditlog starts */
			String prevAgents = request.getParameter("previousIntAgent");
			if(prevAgents != null && prevAgents.length()>0)
				auditLogThread.setPreviousValue("Internal Agent",prevAgents);
			auditLogThread.setCurrentValue("Internal Agent",currAgent);
			/* code for auditlog ends */
			//IniFile testinfoptrR = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_testinfo.ini");
			IniFile testinfoptrW =EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testinfo.ini");
			String [] vars = testinfoptrW.getVariables(oldIntAgent);
			if(vars != null && vars.length > 0)
			{
				//IniFile testinfoptrW =EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testinfo.ini");
				needSave = false;
				for(int g=0;g<vars.length;g++)
				{
					if(vars[g].indexOf(":"+hostname+":") > -1 || vars[g].indexOf("::"+hostname+"#") > -1)
					{
						testinfoptrW.deleteValue(oldIntAgent, vars[g]);
						testinfoptrW.setValue(currAgent, vars[g], "disabled");
						needSave = true;
					}
				}
				if (needSave)
					testinfoptrW.saveFile();
				//EgConfigFilesSync.releaseInstance(testinfoptrW);		
			}
			EgConfigFilesSync.releaseInstance(testinfoptrW);
		}
		ArrayList extIniEntries = new ArrayList();
		if(!allExternalTests)
		{
			//egExtIni.createFile("eg_external.ini","save");
			if (intAgentMode.equalsIgnoreCase("manual"))
			{
			/*
			 *	New code : The user explicitly chooses a current agent to map to.
			 *	The mapped-to current agent is specified in eg_external.ini
			 */
				currAgents = currAgent;
				//egExtIni.deleteSpecValue("Internal_Agent_Mapping", oldAlias);
				//egExtIni.setValues("Internal_Agent_Mapping", hostname, currAgent);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Internal_Agent_Mapping", oldAlias,""));
				extIniEntries.add(new IniHelper(IniHelper.SET,"Internal_Agent_Mapping", hostname, currAgent));
			}
			else //if (intAgentMode.equalsIgnoreCase("auto"))
			{
			/*
			 *	New code : If an internal agent is going to be assigned automatically,
			 *	remove the entry of this agent if present in the Internal_Agent_Mapping
			 *	section in eg_external.ini
			 */
				//egExtIni.deleteSpecValue("Internal_Agent_Mapping", hostname);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Internal_Agent_Mapping", hostname,""));
			}
		}

		/*
		 * Add the user specified external agent
		 */
		boolean isMSPModel = EgUuidInfo.isMspModel();
		//boolean isTypeHasExternalTests = specsInfo.isTypeHasExternalTests(stype);
		String externalAgent = "";
		String[] extAgent = request.getParameterValues("extAgents");
		String extAgentStr = request.getParameter("extAgents");
		if (extAgent != null && extAgent.length > 0)
		{
			externalAgent = StringUtils.getUniqueArrayAsString(extAgent);
			try
			{
		//		if (isTypeHasExternalTests)
		//		{
		//			externalAgent = StringUtils.getUniqueArrayAsString(extAgent);
		//		}
		//		else
		//		{
		//			if (isMSPModel)
		//			{
		//				EgUserElementsInfo usrElmntsInfo = new EgUserElementsInfo();
		//				ArrayList extAgnts = usrElmntsInfo.getExternalAgentsForUser(user_id);
		//				if (extAgnts == null || extAgnts.size() == 0)
		//				{
		//					externalAgent = managerHosts;
		//				}
		//				else
		//				{
		//					externalAgent = (String)extAgnts.get(0);
		//				}
		//			}
		//			else // Enterprise model
		//			{
		//				externalAgent = managerHosts;
		//			}
		//		}
				//egExtIni.setValues("Test_Mapping_Section", hostname, StringUtils.getUniqueArrayAsString(extAgent));
				//if (isLimitedAdmin && !userExtAgent.equals(""))
				//{
					//externalAgent = userExtAgent;
				//}
				extIniEntries.add(new IniHelper(IniHelper.SET,"Test_Mapping_Section", hostname, externalAgent));

				/* code for auditlog starts */
				if(modifying)
				{
					auditLogThread.setPreviousValue("External Agents",prevExtAgents);

					if(!autoConfigHVCompsForAuditLog.isEmpty())
					{
						Iterator itr = autoConfigHVCompsForAuditLog.iterator();
						while (itr.hasNext())
						{
							String server = (String) itr.next();
							String servType = server.substring(0,server.indexOf(":"));
							String servName = server.substring(server.indexOf(":")+1);
							if (servName.indexOf(":NULL") > -1)
							{
								servName = servName.substring(0,servName.indexOf(":"));
							}

							server = servName + " ("+_mapping.getComponentTypeDescription(servType)+")";
							auditLogThread.setCurrentValue("OTHER AUTO CONFIGURED COMPONENTS", server);
						}
					}
				}
				auditLogThread.setCurrentValue("External Agents",externalAgent);	
				/* code for auditlog ends */
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		//vmwarehosts starts here
		if (stype.equals("VMware_guest"))
		{
			if (vmwarehostentry!=null && !vmwarehostentry.equals("-1"))
			{
				//egExtIni.setValues("VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno, vmwarehostentry);
				extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno, vmwarehostentry));
			}else if (vmwarehostentry!=null && vmwarehostentry.equals("-1"))
			{
				//egExtIni.deleteSpecValue("VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_MAPPING", stype+":"+hostname+":"+sportno,""));
			}
		}
		//vmwarehosts ends here

		//vmware EsxServer hosts starts here
		
		//for vmware esx server
		if(underVmware!=null && underVmware.equalsIgnoreCase("true"))
		{
			if(esxServer !=null && !esxServer.equals("-1"))
			{
				if(sid!=null && sid.length()>0)
				{
					//egExtIni.setValues("Virtual_Components", stype+":"+hostname+":"+sportno+":"+sid, esxServer);
					extIniEntries.add(new IniHelper(IniHelper.SET,"Virtual_Components", stype+":"+hostname+":"+sportno+":"+sid, esxServer));
				}
				else
				{
					//egExtIni.setValues("Virtual_Components", stype+":"+hostname+":"+sportno, esxServer);
					extIniEntries.add(new IniHelper(IniHelper.SET,"Virtual_Components", stype+":"+hostname+":"+sportno, esxServer));
				}
				/* code for auditlog starts */
				if(modifying)
				{
					String previousVirtualServer = request.getParameter("previousvirtualserver");
					if(previousVirtualServer !=null && !previousVirtualServer.equalsIgnoreCase("null") && previousVirtualServer.trim().length()>0)
						auditLogThread.setPreviousValue("Virtual Servers",previousVirtualServer);
				}
				auditLogThread.setCurrentValue("Virtual Servers",esxServer);
				/* code for auditlog ends */
			}
		}
		//karthika for cloud
		if(underCloud!=null && underCloud.equalsIgnoreCase("true"))
		{
			if(cloudServer !=null && !cloudServer.equals("-1"))
			{
				if(sid!=null && sid.length()>0)
				{
					//egExtIni.setValues("Cloud_Components", stype+":"+hostname+":"+sportno+":"+sid, cloudServer);
					extIniEntries.add(new IniHelper(IniHelper.SET,"Cloud_Components", stype+":"+hostname+":"+sportno+":"+sid, cloudServer));
				}
				else
				{
					//egExtIni.setValues("Cloud_Components", stype+":"+hostname+":"+sportno, cloudServer);
					extIniEntries.add(new IniHelper(IniHelper.SET,"Cloud_Components", stype+":"+hostname+":"+sportno, cloudServer));
				}
				/* code for auditlog starts */
				if(modifying)
				{
					String previousCloudServer = request.getParameter("previouscloudserver");
					if(previousCloudServer !=null && !previousCloudServer.equalsIgnoreCase("null") && previousCloudServer.trim().length()>0)
					{
						int idx = previousCloudServer.indexOf(":");
						if (idx > -1)
						{
							String tmpPrvCloud = previousCloudServer.substring(0,idx);
							tmpPrvCloud = _mapping.getComponentTypeDescription(tmpPrvCloud)+":"+previousCloudServer.substring(idx+1);
							if (tmpPrvCloud.toLowerCase().endsWith(":null"))
								tmpPrvCloud = tmpPrvCloud.substring(0,tmpPrvCloud.lastIndexOf(":"));
							auditLogThread.setPreviousValue("Cloud Servers",tmpPrvCloud);
						}
						else
						{
							auditLogThread.setPreviousValue("Cloud Servers","-");
						}
					}
				}
				int idx = cloudServer.indexOf(":");
				if(idx > -1)
				{
					String tmpCloudServer = cloudServer.substring(0,idx);
					tmpCloudServer = _mapping.getComponentTypeDescription(tmpCloudServer)+":"+cloudServer.substring(idx+1);
					if (tmpCloudServer.toLowerCase().endsWith(":null"))
						tmpCloudServer = tmpCloudServer.substring(0,tmpCloudServer.lastIndexOf(":"));
					auditLogThread.setCurrentValue("Cloud Servers",tmpCloudServer);
				}
				else
				{
					auditLogThread.setCurrentValue("Cloud Servers","-");
				}
				
				/* code for auditlog ends */
			}
		}
		if(!type.equals("new") && underCloud!=null && underCloud.equalsIgnoreCase("false"))
		{
			String variable = null;
			if(sid!=null && sid.length()>0)
			{
				variable = stype+":"+hostname+":"+sportno+":"+sid;
				//egExtIni.deleteSpecValue("Cloud_Components",variable);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Cloud_Components",variable,""));
			}
			else
			{
				variable = stype+":"+hostname+":"+sportno;
				//egExtIni.deleteSpecValue("Cloud_Components",variable);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Cloud_Components",variable,""));
			}
			variable = null;
		}
		
		/* code for auditlog starts */
		if(underCloud!=null && !underCloud.equalsIgnoreCase("null") && underCloud.trim().length()>0 && !underCloud.equalsIgnoreCase("false"))
		{				
			if(modifying)
			{
				String previousCloudEvn = request.getParameter("previouscloudenvironment");
				if(previousCloudEvn !=null && !previousCloudEvn.equalsIgnoreCase("null"))
					auditLogThread.setPreviousValue("Cloud Environment",changeTrueToYesAndFalseToNo(previousCloudEvn));
			}
			auditLogThread.setCurrentValue("Cloud Environment",changeTrueToYesAndFalseToNo(underCloud));
		}
		//auditLogThread.sendItToDB();
		/* code for auditlog ends */
		// cloud ends here
		if(!type.equals("new") && underVmware!=null && underVmware.equalsIgnoreCase("false"))
		{
			String variable = null;
			if(sid!=null && sid.length()>0)
			{
				variable = stype+":"+hostname+":"+sportno+":"+sid;
				//egExtIni.deleteSpecValue("Virtual_Components",variable);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Virtual_Components",variable,""));
			}
			else
			{
				variable = stype+":"+hostname+":"+sportno;
				//egExtIni.deleteSpecValue("Virtual_Components",variable);
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"Virtual_Components",variable,""));
			}
			variable = null;
		}
		
		/* code for auditlog starts */
		if(underVmware!=null && !underVmware.equalsIgnoreCase("null") && underVmware.trim().length()>0 && !underVmware.equalsIgnoreCase("false"))
		{				
			if(modifying)
			{
				String previousVirtualEvn = request.getParameter("previousvirtualenvironment");
				if(previousVirtualEvn !=null && !previousVirtualEvn.equalsIgnoreCase("null"))
					auditLogThread.setPreviousValue("Virtual Environment",changeTrueToYesAndFalseToNo(previousVirtualEvn));
			}
			auditLogThread.setCurrentValue("Virtual Environment",changeTrueToYesAndFalseToNo(underVmware));
		}	
		//auditLogThread.sendItToDB();
		/* code for auditlog ends */
		if (extIniEntries.size() > 0)
		{
			IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
			IniFile virCompWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_virtualcomponents.ini");
			for (int n=0; n<extIniEntries.size(); n++)
			{
				IniHelper iniHelper = (IniHelper)extIniEntries.get(n);
				String iniAction = iniHelper.getAction();
				String subject = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String value = iniHelper.getValue();
				if(iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						if(subject != null && subject.equalsIgnoreCase("Virtual_Components"))
							virCompWrite.setValue(subject,key,value);
						else
							externalWrite.setValue(subject,key,value);

					}
					else if (iniAction.equals(IniHelper.DELETE))
					{
						if(subject != null && subject.equalsIgnoreCase("Virtual_Components"))
							virCompWrite.deleteValue(subject,key);
						else
							externalWrite.deleteValue(subject,key);
					}
				}
			}
			externalWrite.saveFile();
			EgConfigFilesSync.releaseInstance(externalWrite);
			virCompWrite.saveFile();
			EgConfigFilesSync.releaseInstance(virCompWrite);
		}
		if(frmTopology !=null && frmTopology.equals("yes"))
		{
			sess_vec.add("frmTopology"+"::"+topoSegName);
		}
		//session.setAttribute("compType",server_type);
		//session.setAttribute("compName",server_name);
		//session.setAttribute("hostIp",host_ip);
		//session.setAttribute("vec_Results",sess_vec);
		rootJSON.put("compType",server_type);
		rootJSON.put("compName",server_name);
		if(stype != null && stype != "")
		{
			if(stype.equals("Real_user_monitor"))
			{
				rootJSON.put("hostIp", "0.0.0.0");
			}
			else
			{
				rootJSON.put("hostIp",host_ip);
			}
		}


	//	UpdateVcConfig updateVcConfig = new UpdateVcConfig();
		if (modifying) // If modify component
		{
			// IsPassive Fix starts here
			String preIsPassive = request.getParameter("previousispassive");
			//IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			IniFile agentsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			if (preIsPassive != null && !preIsPassive.equalsIgnoreCase("null"))
			{
				preIsPassive = (preIsPassive.equalsIgnoreCase("true") || preIsPassive.equalsIgnoreCase("yes"))?"true":"false";
				if (!preIsPassive.equalsIgnoreCase(isPassive)) // If isPassive value has changed
				{
					
					List agentsList = new ArrayList();
					String agent = externalInfo.getAgentFor(hostname);
					if (StringUtils.isNull(agent)) // For Internal Agent check
					{
						agent = externalInfo.getRemoteAgentForHost(hostname);
					}
					if (StringUtils.isNull(agent)) // For Remote Agent check
					{
						agent = hostname;
					}
					agentsList.add(agent);
					String[] extAgents = externalInfo.getExternalAgentsForHost(hostname);
					if (extAgents != null && extAgents.length > 0)
					{
						agentsList.addAll(Arrays.asList(extAgents)); 
					}
					String[] tests = specsInfo.getTestsForServer(stype);
					List testsList = new ArrayList(Arrays.asList(tests));
					ArrayList iniEntries = new ArrayList();
					for (int j=0; j<agentsList.size(); j++) //relevant subjects from eg_agents.ini
					{
						String agentSub = (String)agentsList.get(j);
						String[] vars = agentsIni.getVariables(agentSub);
						for (int k=0; k < vars.length; k++)
						{
							String variable = vars[k];
							String tmpTestName = variable.substring(0,variable.indexOf(":"));
							if (testsList.contains(tmpTestName)) //relevant tests 
							{
								if(variable.endsWith(":"+hostname+":"+sportno) || variable.endsWith(":"+hostname) || variable.indexOf(":"+hostname+":"+sportno+":") > 0) // nick name check
								{
									String value = agentsIni.getValue(agentSub,variable);
									if (value.startsWith("-manual") && value.toLowerCase().indexOf("-ispassive") > 0)
									{
										int passiveIndex = value.toLowerCase().indexOf("-ispassive");
										String tmpStr1 = value.substring(0,passiveIndex+10).trim();
										String tmpStr2 = value.substring(passiveIndex+10).trim();
										tmpStr2 = tmpStr2.substring(tmpStr2.indexOf(" ")+1);
										value = tmpStr1+" "+isPassive+" "+tmpStr2;
										//agentsIni.setValue(agentSub,variable,value);
										iniEntries.add(new IniHelper(agentSub,variable,value));
									}
								}
							}
						}
					}
					if (iniEntries.size() > 0)// Have entries to update agents.ini?
					{
						//IniFile agentsFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
						for (int n=0;n<iniEntries.size(); n++)
						{
							IniHelper iniHelper = (IniHelper)iniEntries.get(n);
							String sub = iniHelper.getSubject();
							String key = iniHelper.getVariable();
							String val = iniHelper.getValue();
							agentsIni.setValue(sub,key,val);
						}
						agentsIni.saveFile();
						//EgConfigFilesSync.releaseInstance(agentsIni);
					}					
				}
			}
		//  Comment reason: Nick name change should not affect -virtual_center param in agents.ini, since the value is Host IP/Name(from services.ini) 
		//	if (stype.equals("Virtual_center"))
		//	{
		//		updateVcConfig.changeVcConfig(hostname,oldhostname);
		//	}
			//IniFile testInfoToRead = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
			IniFile testInfoToWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
			//If we change Remote agent / External agent(s) for a component, then need to retain disabled descriptors information to the newly associated agents.
			//External agent related fix
			if (prevExtAgents != null && extAgent != null)
			{
				//List currExtList = new ArrayList(Arrays.asList(extAgent));
				List currExtList = new ArrayList(StringUtils.egTokenizer(extAgentStr,","));
				List prevExtList = new ArrayList();
				List varsToHandle = new ArrayList();
				StringTokenizer strTzr = new StringTokenizer(prevExtAgents,",");
				while(strTzr.hasMoreTokens())
				{
					prevExtList.add(strTzr.nextToken());
				}
				if (prevExtList.size() > 0)
				{
					String agentName = (String)prevExtList.get(0);
					String[] vars = testInfoToWrite.getVariables(agentName);
					for (int j=0; j < vars.length; j++)
					{
						var = vars[j];
						String testName = var.substring(0,var.indexOf(":"));
						if (!specsInfo.isExternalTest(testName,stype))
						{
							continue;
						}
						if (var.indexOf(":"+hostname+"#") > -1 || var.indexOf(":"+hostname+":") > -1)
						{
							String val = testInfoToWrite.getValue(agentName,var);
							varsToHandle.add(var+"="+val);
						}
					}
				}
				for (int i=currExtList.size()-1;i >= 0; i--)
				{
					String currExt = (String)currExtList.get(i);
					if (prevExtList.contains(currExt))
					{
						currExtList.remove(currExt); 
						prevExtList.remove(currExt);
					}
				}
				if (currExtList.size() > 0)//List of subjects, where the relevant entries have to be saved
				{
					//testInfoToWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
					for (int n=0; n<currExtList.size(); n++)
					{
						String agentName = (String)currExtList.get(n);
						for (int m=0; m < varsToHandle.size(); m++)
						{
							String strTmp = (String)varsToHandle.get(m);
							String tmpVar = strTmp.substring(0,strTmp.indexOf("="));
							String tmpVal = strTmp.substring(strTmp.indexOf("=")+1);
							testInfoToWrite.setValue(agentName,tmpVar,tmpVal);
						}						
					}
					testInfoToWrite.saveFile();
					//EgConfigFilesSync.releaseInstance(testInfoToWrite);
					
				}
				if (prevExtList.size() > 0) //List of subjects, where the relevant entries have to be removed
				{
					//testInfoToWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
					for (int n=0; n<prevExtList.size(); n++)
					{
						String agentName = (String)prevExtList.get(n);
						String[] vars = testInfoToWrite.getVariables(agentName);
						for (int j=0; j < vars.length; j++)
						{
							var = vars[j];
							String testName = var.substring(0,var.indexOf(":"));
							if (!specsInfo.isExternalTest(testName,stype))
							{
								continue;
							}
							if (var.indexOf(":"+hostname+"#") > -1 || var.indexOf(":"+hostname+":") > -1)
							{
								testInfoToWrite.deleteValue(agentName,var);
							}
						}
					}
					testInfoToWrite.saveFile();
					//EgConfigFilesSync.releaseInstance(testInfoToWrite);
				}
			}
			ArrayList iniEntriesList = new ArrayList();
			//Remote agent related fix			
			String oldAgentName = request.getParameter("olderRmtAgtForTestInfo");
			if (oldAgentName == null)
				oldAgentName ="";
			if (StringUtils.isNull(remoteType))
				remoteType ="false";

			if (oldAgentName.equals("") && remoteAgent!=null && remoteType!=null && remoteType.equals("true")) // AgentBased --> Agentless
			{
				String varArr[] = testInfoToWrite.getVariables(hostname);
				if (varArr != null)
				{
					List tmpList = new ArrayList();
					//testInfoToWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
						
					for (int i=0; i < varArr.length; i++)
					{
						var = varArr[i];
						String testName = var.substring(0,var.indexOf(":"));
						if (specsInfo.isExternalTest(testName,stype))
						{
							continue;
						}
						String val = testInfoToWrite.getValue(hostname,var);
						testInfoToWrite.setValue(remoteAgent,var,val);
						testInfoToWrite.deleteValue(hostname,var);
					}
					testInfoToWrite.saveFile();
					//EgConfigFilesSync.releaseInstance(testInfoToWrite);

					//To retain Test Configurations - The below block has been commented, since agentless params not added in test config
				//	String[] vars = agentsIni.getVariables(hostname);
				//	Vector vals = agentsIni.getAllValues(hostname);
				//	for (int i=0; i < vars.length; i++)
				//	{
				//		String variable = vars[i];
				//		String testName = variable.substring(0,variable.indexOf(":"));
				//		if (specs.isTestInternal(testName,stype))
				//		{
				//			String value = (String)vals.get(i);
				//			if (value.startsWith("-manual"))
				//			{
				//				iniEntriesList.add(new IniHelper(remoteAgent,variable,value));							
				//			}
				//		}
				//	}	
				}
			}
			else
			{
				String newAgentName = "";
				if (oldAgentName != null && remoteAgent == null && remoteType!=null && remoteType.equals("false")) // Agentless --> AgentBased
				{
					 newAgentName = hostname;
					//To retain Test Configurations - The below block has been commented, since agentless params not removed in test config
				//	String[] vars = agentsIni.getVariables(oldAgentName);
				//	Vector vals = agentsIni.getAllValues(oldAgentName);
				//	for (int i=0; i < vars.length; i++)
				//	{
				//		String variable = vars[i];
				//		String testName = variable.substring(0,variable.indexOf(":"));
				//		if (specs.isTestInternal(testName,stype))
				//		{
				//			if (variable.indexOf(":"+hostname+":") > -1 || variable.endsWith(":"+hostname)) // nick name check
				//			{
				//				String value = (String)vals.get(i);
				//				if (value.startsWith("-manual"))
				//				{
				//					iniEntriesList.add(new IniHelper(hostname,variable,value));							
				//				}
				//			}
				//		}
				//	}					 
				}
				else if (oldAgentName != null && oldAgentName.length() > 0 && remoteAgent!=null && remoteType.equals("true")) // Agentless --> Agentless
				{
					newAgentName = remoteAgent;
				}
				boolean isRemoteUpdated = true;
				if (oldAgentName.equals(newAgentName))
				{
					isRemoteUpdated = false;
				}
				if (isRemoteUpdated)
				{
					String varArr[] = testInfoToWrite.getVariables(oldAgentName);
					if (varArr != null)
					{
						List tmpList = new ArrayList();
						for (int i=0; i < varArr.length; i++)
						{
							var = varArr[i];
							String testName = var.substring(0,var.indexOf(":"));
							if (specsInfo.isExternalTest(testName,stype))
							{
								continue;
							}
							if (var.indexOf(":"+hostname+"#") > -1 || var.indexOf(":"+hostname+":") > -1)
							{
								String val = testInfoToWrite.getValue(oldAgentName,var);
								tmpList.add(var+"="+val);
							}
						}
						//testInfoToWrite = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini");
						for (int j=0;j<tmpList.size();j++)
						{
							String keyValue = (String)tmpList.get(j);
							String key = keyValue.substring(0,keyValue.indexOf("="));
							String value = keyValue.substring(keyValue.indexOf("=")+1);
							testInfoToWrite.setValue(newAgentName,key,value);
							testInfoToWrite.deleteValue(oldAgentName,key);
						}
						testInfoToWrite.saveFile();
						//EgConfigFilesSync.releaseInstance(testInfoToWrite);
					}
				}
			}
			EgConfigFilesSync.releaseInstance(testInfoToWrite);
			//Fix ends to retain disabled discriptor information

			// Fix starts to retain the test configuration details while changing the Remote/External/Internal agent
			// Remote agent
			String oldRemoteAgent = request.getParameter("olderremoteagentname");
			String newRemoteAgent = remoteAgent;
			
			boolean isRmtAgentChanged = false;
			if (oldRemoteAgent!=null && newRemoteAgent!=null && !oldRemoteAgent.equals(newRemoteAgent))// If remote agent changed
			{
				isRmtAgentChanged = true;
				String[] vars = agentsIni.getVariables(oldRemoteAgent);
				for (int i=0; i < vars.length; i++)
				{
					String variable = vars[i];
					if (variable.indexOf(":"+hostname+":") > -1 || variable.endsWith(":"+hostname)) // nick name check
					{
						String value = agentsIni.getValue(oldRemoteAgent,variable);
						if (value.startsWith("-manual"))
						{
							iniEntriesList.add(new IniHelper(newRemoteAgent,variable,value));							
						}
					}					
				}					
			}			
			// External agents
			if(extAgent != null && extAgent.length>0)
			{
				String currExtAgents = StringUtils.getUniqueArrayAsString(extAgent);
				if (prevExtAgents != null && !prevExtAgents.equals(currExtAgents))
				{
					ArrayList prevAgentsList = StringUtils.egTokenizer(prevExtAgents,",");
					ArrayList currAgentsList = StringUtils.egTokenizer(currExtAgents,",");
					String anyOnePrevAgent = (String)prevAgentsList.get(0);
					String[] vars = agentsIni.getVariables(anyOnePrevAgent);	
					for (int j=0;j<currAgentsList.size();j++)
					{
						String currIntAgent = (String)currAgentsList.get(j);
						if (prevAgentsList.contains(currIntAgent))// This agent is not new assigned one
						{
							continue; 
						}
												
						for (int i=0; i < vars.length; i++)
						{
							String variable = vars[i];
							if (variable.indexOf(":"+hostname+":") > -1 || variable.endsWith(":"+hostname))// nick name check
							{
								String value = agentsIni.getValue(anyOnePrevAgent,variable);
								if (value.startsWith("-manual"))
								{
									iniEntriesList.add(new IniHelper(currIntAgent,variable,value));							
								}
							}
						}
					}
				}
			}
			//Internal agent
			String preIntAgent = request.getParameter("prevAgents");
			if(intAgentMode.equals("auto"))
			{
				preIntAgent = request.getParameter("previousIntAgent");
				currAgent = oldhostname;
			}
			if (preIntAgent == null)
				preIntAgent = "";
			if (!preIntAgent.equals(currAgent))
			{
				String[] vars = agentsIni.getVariables(preIntAgent);
				for (int i=0; i < vars.length; i++)
				{
					String variable = vars[i];
					if (variable.indexOf(":"+hostname+":") > -1 || variable.endsWith(":"+hostname)) // nick name check
					{
						String value = agentsIni.getValue(preIntAgent,variable);
						if (value.startsWith("-manual"))
						{
							iniEntriesList.add(new IniHelper(currAgent,variable,value));							
						}
					}					
				}				
			}
				
			if (iniEntriesList.size() > 0)
			{
				//IniFile agentsFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
				for (int j=0; j<iniEntriesList.size(); j++)
				{
					IniHelper iniHlpr = (IniHelper)iniEntriesList.get(j);
					String sub = iniHlpr.getSubject();
					String key = iniHlpr.getVariable();
					String val = iniHlpr.getValue();
					agentsIni.setValue(sub,key,val);
				}
				agentsIni.saveFile();
				//EgConfigFilesSync.releaseInstance(agentsIni);
			}
			EgConfigFilesSync.releaseInstance(agentsIni);
			
			boolean isHostNameChanged = false;
			if (!hostname.equals(oldAlias))
			{
				isHostNameChanged = true;
			}
			
			if (serverType != null && serverType.equals("MS_Azure_Cloud"))
			{
				String fromPage = request.getParameter("fromPage");
				ArrayList modifyNickList = new ArrayList();
				if (!StringUtils.isNull(fromPage) && fromPage.equals("newAdminWizard"))
				{
					String remoteAgentStr = request.getParameter("remoteAgent");
					String tenantName = request.getParameter("tenantName");
					tenantName = EgUIUtils.decodeSecurityChar(tenantName);
					String tenantId = request.getParameter("tenantId");
					tenantId = EgUIUtils.decodeSecurityChar(tenantId);
					String subscriptionId = request.getParameter("subscriptionId");
					subscriptionId = EgUIUtils.decodeSecurityChar(subscriptionId);
					
					modifyNickList.add(remoteAgentStr);
					modifyNickList.add(tenantId);
					modifyNickList.add(tenantName);
					modifyNickList.add(subscriptionId);
				}
				else
				{
					if (isHostNameChanged || isRmtAgentChanged)
					{	
						String tempRemoteAgent =  remoteAgent;
						if (isRmtAgentChanged)
						{
							tempRemoteAgent = oldRemoteAgent;
						}
						
						IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
						String[] tenantIdArr = msAzureConfig.getVariables(tempRemoteAgent);
						if (tenantIdArr != null && tenantIdArr.length > 0)
						{
							int tntIdLen = tenantIdArr.length;
							for (int b=0; b<tntIdLen; b++)
							{
								String tenantId = tenantIdArr[b];
								String tenantNameStr = msAzureConfig.getValue(tempRemoteAgent,tenantId);
								if (!StringUtils.isNull(tenantNameStr))
								{
									ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNameStr,"^#^")));
									for (int c=0; c<tenantNameList.size(); c++)
									{
										String tenantName = (String) tenantNameList.get(c);
										
										String[] subscriptionWithNickArr =msAzureConfig.getVariables(tempRemoteAgent+"^#^"+tenantId+"^#^"+tenantName);
										if (subscriptionWithNickArr != null && subscriptionWithNickArr.length > 0)
										{
											int tmpLen = subscriptionWithNickArr.length;
											for (int d=0; d<tmpLen; d++)
											{
												String subscriptionWithNick = subscriptionWithNickArr[d];
												String subscriptionId = subscriptionWithNick.substring(0, subscriptionWithNick.indexOf("^#^"));
												String nickNameStr = subscriptionWithNick.substring(subscriptionWithNick.indexOf("^#^")+3);
												if (nickNameStr.equals(oldAlias))
												{
													modifyNickList.add(tempRemoteAgent);
													modifyNickList.add(tenantId);
													modifyNickList.add(tenantName);
													modifyNickList.add(subscriptionId);
												}
											}
										}
									}
								}
							}
						}
					}
				}
				
				if (modifyNickList != null && modifyNickList.size() > 0)
				{
					String remoteAgentStr = (String)modifyNickList.get(0);
					String tenantId = (String)modifyNickList.get(1);
					String tenantName = (String)modifyNickList.get(2);
					String subscriptionId = (String)modifyNickList.get(3);
					
					IniFile msAzureConfigWrt = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_msazureconfig.ini");
					if (isRmtAgentChanged)
					{
						String tenantNameStr = msAzureConfigWrt.getValue(remoteAgent,tenantId);
						if (!StringUtils.isNull(tenantNameStr))
						{
							ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNameStr,"^#^")));
							if (!tenantNameList.contains(tenantName))
							{
								tenantNameStr += "^#^"+tenantName;
							}
						}
						else
						{
							tenantNameStr = tenantName;
						}
						
						String subscriptionDetails = msAzureConfigWrt.getValue(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName, subscriptionId+"^#^"+oldAlias);
						if (!StringUtils.isNull(subscriptionDetails))
						{
							msAzureConfigWrt.setValue(remoteAgent, tenantId, tenantNameStr);
							msAzureConfigWrt.setValue(remoteAgent+"^#^"+tenantId+"^#^"+tenantName, subscriptionId+"^#^"+hostname,subscriptionDetails);
						}
						
						String[] subscriptionArr =  msAzureConfigWrt.getVariables(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName);
						
						if (subscriptionArr != null && subscriptionArr.length > 0)
						{
							int subscriptionLen = subscriptionArr.length;
							msAzureConfigWrt.deleteValue(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName,subscriptionId+"^#^"+oldAlias);
							if (subscriptionLen == 1)
							{
								String tenantNames = msAzureConfigWrt.getValue(remoteAgentStr,tenantId);
								if (tenantNames != null && tenantNames.length() > 0)
								{
									ArrayList tenantNamesList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNames,"^#^")));
									int tenantSize = tenantNamesList.size();
									if (tenantSize == 1)
									{
										msAzureConfigWrt.deleteValue(remoteAgentStr, tenantId);
									}
									else
									{
										String remTenantName = "";
										for (int j=0; j<tenantSize; j++)
										{
											String tempTenantName = (String) tenantNamesList.get(j);
											if (!tempTenantName.equals(tenantName))
											{
												remTenantName += "^#^"+tempTenantName;
											}
										}
										
										if (!StringUtils.isNull(remTenantName))
										{
											remTenantName = remTenantName.substring(remTenantName.indexOf("^#^")+3);
										}
										msAzureConfigWrt.setValue(remoteAgentStr, tenantId, remTenantName);
									}
								}
							}
						}
					}
					else
					{
						String oldNickDetails = msAzureConfigWrt.getValue(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName,subscriptionId+"^#^"+oldAlias);
						if (!StringUtils.isNull(oldNickDetails))
						{
							msAzureConfigWrt.setValue(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName,subscriptionId+"^#^"+hostname,oldNickDetails);
							msAzureConfigWrt.deleteValue(remoteAgentStr+"^#^"+tenantId+"^#^"+tenantName,subscriptionId+"^#^"+oldAlias);
						}
					}
					msAzureConfigWrt.saveFile();
					EgConfigFilesSync.releaseInstance(msAzureConfigWrt);
					
					IniFile discoverParamWrt = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
					String oldNickParams = discoverParamWrt.getValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+oldAlias+":NULL");
					if (!StringUtils.isNull(oldNickParams))
					{
						discoverParamWrt.deleteValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+oldAlias+":NULL");
						discoverParamWrt.setValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+hostname+":NULL",oldNickParams);
					}
					discoverParamWrt.saveFile();
					EgConfigFilesSync.releaseInstance(discoverParamWrt);
				}
			}
		}
		// Fix ends to retain the test configuration details while changing the remote/External/Internal agent
		// IsPassive Fix ends here

		Vector addModify = new Vector();
		addModify.add(hostip);
		addModify.add(hostname);
		addModify.add(intAgentMode);
		addModify.add(currAgents);
		addModify.add(remoteAgent);
		session.setAttribute("addModify",addModify);
		if (hasLimitExceeded)
		{
			servicer.startDiscovery("1");
		}
		else
		{
			servicer.startDiscovery("1",true);
		}
		registry.updateAllUserMaps();

		//............................. Code Starts for Aggregate Site Servers (Begin).......................
		if(isAggregateType)
		{
			//IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini",true);
			IniFile aggIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");

			if(siteSupport != null && siteSupport.equals("true"))
			{
				boolean result = aggIni.setValue("SITE_SUPPORT",stype+":"+hostname+":NULL","yes");
				if(oldhostname!=null && !oldhostname.equals(hostname))
					aggIni.deleteValue("SITE_SUPPORT",stype+":"+oldhostname+":NULL");
			}
			else
			{
				aggIni.deleteValue("SITE_SUPPORT",stype+":"+hostname+":NULL");
			}
			aggIni.saveFile();
			EgConfigFilesSync.releaseInstance(aggIni);
		}
		//............................. Code Starts for Aggregate Site Servers (End).......................
		//String fwdPage = (remote_vmware!=null && remote_vmware.equals("Yes"))? "Egnewremoteagentsp.jsp?mode=add&ip="+hostip+"&nick="+hostname+"&from=compadd":(isAggregateLink?"EgResults.jsp?location=AggregatesAddAll":"EgResults.jsp");
		String fwdPage = isAggregateLink?"EgResults.jsp?location=AggregatesAddAll":"EgResults.jsp";
		if(!StringUtils.isNull(treeViewSrc))
		{
			if(fwdPage.indexOf("EgResults.jsp?")!=-1)
			{
				fwdPage+="&from=ManUnMan";
			}
			else
				fwdPage+="?from=ManUnMan";
		}
		rootJSON.put("requestStatus","success");
		if(modifying)
		{
			rootJSON.put("Result_info",_mapping.getTextDescription("admin.server.Component has been modified successfully")+".");
			if(remoteAgent != null)
			{
				session.setAttribute("prevSelectedRemAgents",remoteAgent);
			}
			if(selExtAgents != null)
			{
				session.setAttribute("prevSelectedExtAgents",selExtAgents);
			}
			if(esxServer != null)
			{
				session.setAttribute("prevSelectedVirtualHost",esxServer);
			}
			if(cloudServer != null)
			{
				session.setAttribute("prevSelectedCloudServ",cloudServer);
			}
		}
		else
		{
			rootJSON.put("Result_info",_mapping.getTextDescription("admin.server.Component has been added successfully")+".");
			if(remoteAgent != null)
			{
				session.setAttribute("prevSelectedRemAgents",remoteAgent);
			}
			if(selExtAgents != null)
			{
				session.setAttribute("prevSelectedExtAgents",selExtAgents);
			}
			if(esxServer != null)
			{
				session.setAttribute("prevSelectedVirtualHost",esxServer);
			}
			if(cloudServer != null)
			{
				session.setAttribute("prevSelectedCloudServ",cloudServer);
			}
		}

		UnmanagedAgentsInfo uai = new UnmanagedAgentsInfo();
		uai.updateAgentDetail(hostip, hostname);
		boolean storeUnmanCompsInfo = servicesInfo.needToUpdateComponentHistory();
		if(storeUnmanCompsInfo)
		{
			EgUserDataAdmin usradmin = new EgUserDataAdmin();
			String server_type1 = request.getParameter("server_type");
			Hashtable dataMp = new Hashtable();
			String comp = hostname+":"+sportno;
			String temp = server_type1+":"+comp;
			
			String tmp = "add";
			
			dataMp.put("UID",temp.toUpperCase());
			if((oldhostname!=null && oldhostname.length() > 0 && !(oldhostname.equals(hostname)))  ||
				(previousportnumber!=null && previousportnumber.length() >0 && !previousportnumber.equals(sportno)))
			{	
				dataMp.put("OLD_UID",server_type1.toUpperCase()+":"+oldhostname.toUpperCase()+":"+previousportnumber);
				dataMp.put("COMP_STATUS","Update"); 
				tmp = "modify";
			}
			else
			{
				dataMp.put("COMP_STATUS","Managed");
			}
			dataMp.put("COMP_TYPE",server_type1);
			dataMp.put("COMP_NAME",comp);
			dataMp.put("USER_NAME",user_id);			
			
			String currTime=usradmin.getDateByFormat("yyyy-MM-dd HH:mm:ss");
			dataMp.put("MSMT_TIME",currTime); 
			Vector entireDataList = new Vector();
			entireDataList.add(dataMp);
			EgAutoScaleInfo autoscale = new EgAutoScaleInfo();
			if( tmp.equals("add"))
			{
				autoscale.log("[Add/Modify UI - Add ] : Params : "+entireDataList);
			}else{
					autoscale.log("[Add/Modify UI - Modify ] : Params : "+entireDataList);
			}
			com.eg.EgAutoScallingThread limitbg =  com.eg.EgAutoScallingThread.getInstance();
			limitbg.addAllThread(entireDataList);
			limitbg.startThread();
			usradmin.updateUnmanagedMetaTest(server_type1,comp,"manage");
		}
	}
	EgConfigFilesSync.releaseInstance(infraIni);
	if (discWrite != null)
		EgConfigFilesSync.releaseInstance(discWrite);

	//For usercompmapping ini deletion - starts
	if (isLimitedAdmin && userCompIniDelList != null)
	{
		List orgList = uuidInfo.getOrgNames(user_id);
		int orgListLen = (orgList != null) ? orgList.size() : 0;
		IniFile userCompIniWrite = EgConfigFilesSync.getInstance(userCompMap);
		for (int y=0; y<orgListLen; y++)
		{
			String org_id = orgList.get(y).toString().trim();
			userCompIniWrite.deleteValues(org_id,userCompIniDelList);
		}
		userCompIniWrite.saveFile();
		EgConfigFilesSync.releaseInstance(userCompIniWrite);
	}
	//For usercompmapping ini deletion - ends

	/* code for auditlog ends */
	auditLogThread.sendItToDB();
	/* code for auditlog ends */

	//Microsoft Office 365, Microsoft Sharepoint Online & Microsoft Exchange Online - after modification alert
	String msExcludeComps[] = mgrmiscIni.getVariables("Microsoft_Exclude_Types");
	List excludeMsCompList = new ArrayList();
	if(msExcludeComps != null)
	{
		excludeMsCompList =	Arrays.asList(msExcludeComps);
	}
	if (stype != null && splCompList.contains(stype) && !excludeMsCompList.contains(stype))
	{
		ArrayList allCompsUnderSplTypes = egDiscInfo.getAllHostsOfTypes(splCompList);
		int pos = (modifying) ? oldhostname.lastIndexOf("_") : hostname.lastIndexOf("_");
		if (pos > -1)
		{
			String remainingComps = "";
			String strWithoutSuffix = (modifying) ? oldhostname.substring(0,pos) : hostname.substring(0,pos);
			Vector microsoftSuffixNameValues = mgrmiscIni.getAllValues("Microsoft_Components");
		//	ArrayList threeHostList = new ArrayList();
			String domainComps[] = mgrmiscIni.getVariables("Microsoft_Domain_Types");
			List domainCompList = new ArrayList();
			if(domainComps != null)
			{
				domainCompList =	Arrays.asList(domainComps);
			}
			
			int suffixNamesize = microsoftSuffixNameValues.size();
		//	for(int i=0;i<suffixNamesize;i++)
		//	{
		//		String microsoftSuffixVal = (String)microsoftSuffixNameValues.get(i);
		//		String threeHostListNames = strWithoutSuffix+microsoftSuffixVal;
		//		threeHostList.add(threeHostListNames);
		//	}
		//	String _suffixStr = hostname.substring(pos+1);
		
			if (modifying)
			{
				if(domainCompList.contains(server_type))
				{
					for(int i=0;i<domainCompList.size();i++)
					{
						String compp = domainCompList.get(i).toString();
						if(!server_type.equalsIgnoreCase(compp))
						{
							remainingComps += compp + ",";
						}
					}					
				}
				else
				{
					//System.out.println(" server_type :2222 modify"+server_type);
					
					for(int i=0;i<suffixNamesize;i++)
					{
						String microsoftSuffixVal = (String)microsoftSuffixNameValues.get(i);
						String splcmpVal = splComponents[i];
						
						if(!domainCompList.contains(splcmpVal) && !excludeMsCompList.contains(splcmpVal))
						{	
							if (!stype.equalsIgnoreCase(splcmpVal) && allCompsUnderSplTypes.contains(strWithoutSuffix+microsoftSuffixVal) && remainTypeCheck)
							{
								remainingComps += splcmpVal + ",";
							}
						}
					} 
				}				
			}
			else
			{
				if(domainCompList.contains(server_type))
				{
					for(int i=0;i<domainCompList.size();i++)
					{
						String compp = domainCompList.get(i).toString();
						if(!server_type.equalsIgnoreCase(compp))
						{
							remainingComps += compp + ",";
						}
					}
				}
				else
				{					
					for(int i=0;i<suffixNamesize;i++)
					{
						String microsoftSuffixVal = (String)microsoftSuffixNameValues.get(i);
						String splcmpVal = splComponents[i];
						if(!domainCompList.contains(splcmpVal) && !excludeMsCompList.contains(splcmpVal))
						{
							if (!stype.equalsIgnoreCase(splcmpVal) && (!allCompsUnderSplTypes.contains(strWithoutSuffix+microsoftSuffixVal) || remainTypeCheck))
							{
								remainingComps += splcmpVal + ",";
							}
						}
					} 
				}
			}
			if (!remainingComps.equals(""))
			{
				remainingComps = remainingComps.substring(0,remainingComps.length()-1);
			}
			rootJSON.put("remainingTypes",remainingComps);
		}
	}

	/*
	 * Update the settings for all user IDs.
	 */
	//UserRegistry registry = UserRegistry.getInstance();
	registry.updateAllUserMaps();
	out.println(rootJSON);
%>

<%!
	public String changeTrueToYesAndFalseToNo(String value)
	{
		if(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))
			value = "Yes";
		else if(value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))
			value = "No";
		return value;
	}
	public void removeOldEntries(boolean newNickAdded, String s_host_name, UpdateAndTransmitTopoInfo topoinfo)
	{
		if (newNickAdded)
		{
			ArrayList queryList = new ArrayList();
			queryList.add("delete from measure_last where trgt_host='"+s_host_name+"'");
			queryList.add("delete from metatest where comp_name like '"+s_host_name+":%'");
			for (int j=0; j<queryList.size(); j++)
			{
				String thisQry = (String) queryList.get(j);
				topoinfo.deleteFromDb(thisQry);
			}
		}
	}

	public String removeNull(String server)
	{
		server = (server != null)?server:"";
		if (server.endsWith(":NULL"))
			server = server.substring(0,server.indexOf(":NULL"));
		return server; 
	}

	public void changeNickInAutoTopology (String serverType, String newHostname , String oldHostName,										  String oldPort , String newPort, String topoSegmentName)
	{
		String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni = EgConfigFilesSync.getInstance(iniFileName,true);
		try
		{
			String[] allLines = autoTopoIni.getLinesUnderSubject(topoSegmentName);
			if(allLines!=null && allLines.length > 0)
			{
				int len = allLines.length;
				if(oldPort == null)
					oldPort = newPort;
				String searchString = serverType+":"+oldHostName+":"+oldPort;
				String modifiedString = serverType+":"+newHostname+":"+newPort;
				for(int k =0;k<len;k++)
				{
					String line = allLines[k];
					int index = line.indexOf(searchString);
					int searchLen  = searchString.length();
					if(index > -1)
					{
						if(index == 0)
						{
							String rhs = line.substring(line.indexOf("=")+1);
							autoTopoIni.setValue(topoSegmentName,modifiedString,rhs);
							autoTopoIni.deleteValue(topoSegmentName,searchString);
						}
						else
						{
							StringBuffer resultBuffer = new StringBuffer();
							String beforeString = line.substring(0,index);
							String afterString = line.substring(index + searchLen);
							resultBuffer.append(beforeString);
							resultBuffer.append(modifiedString);
							resultBuffer.append(afterString);
							String lhs = resultBuffer.substring(0,resultBuffer.indexOf("="));
							String rhs = resultBuffer.substring(resultBuffer.indexOf("=")+1);
							autoTopoIni.setValue(topoSegmentName,lhs,rhs);
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			//System.out.println("Exception Occured in changeNickInAutoTopology Method ");
			e.printStackTrace();
		}
		finally
		{
			autoTopoIni.saveFile();
			EgConfigFilesSync.releaseInstance(autoTopoIni);
		}
	}

	//Deleting agent nick at eg_uuid.ini when component nick matches with agent nick during component add/modify.
	public void updateUuidIni(EgUuidInfo uuidInfo, String hostname)
	{
		if (hostname != null && hostname.length()>0)
		{
			int pos = hostname.indexOf(":");
			hostname = (pos > -1) ? hostname.substring(0,pos) : hostname;
			uuidInfo.removeAgentNick(hostname);
		}
	}

	private List getAgents(String componentType,String componentName)
	{
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompType = new String(componentType);
		String tempCompName = new String(componentName);
		String agentNickName = "";
		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			if (tempCompType.equals("Oracle_server"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			else
			{
				tempCompName = tempCompName.substring(0,tempCompName.lastIndexOf(":"));
			}
		}
		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}
		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	private String getResultantPattern(String componentType, String compName, String testName, String[] testVariables)
	{
		String tempResultantPattern = null;
		String specificPattern_A = testName + ":" + componentType + ":" + compName;
		String specificPattern_B = testName + ":" + componentType + ":" + compName.substring(0,compName.indexOf(":"));
		String defaultPattern_A = testName + "::" + compName;
		String defaultPattern_B = testName + "::" + compName.substring(0,compName.indexOf(":"));
		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}

	public Set updateChanges(String baseType, String subTypeParam, String ipAddr, ArrayList valsToChange, Hashtable listOfComponentsmap, String initAgent)
	{
		Set compListForAuditlog = new HashSet();
		if (ipAddr == null)
		{
			return compListForAuditlog;
		}

		IniFile discIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_discover.ini");
		IniFile agIniFile = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_agents.ini");
		EgExternalInfo externalInfo = new EgExternalInfo("manager");
		HashMap esxValsToChange = (HashMap)valsToChange.get(0);
		ArrayList iniHelperArray = new ArrayList();
		Set discParamsSubCompModify = new HashSet();
		Set agentListForHyperVisorsChange = new HashSet();
		IniHelper inihelper = new IniHelper();

		ArrayList testEnabled = new ArrayList();
		ArrayList listOfComponents =new ArrayList();
		Iterator iit = listOfComponentsmap.keySet().iterator();

		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		while(iit.hasNext())
		{
			Hashtable nickAgentMap = new Hashtable();
			String thisType = (String) iit.next();
			listOfComponents = (ArrayList)listOfComponentsmap.get(thisType);

			if(listOfComponents != null && listOfComponents.size()>0)
			{
				for(int j=0;j<listOfComponents.size();j++)
				{
					String nickName = (String)listOfComponents.get(j);
					nickName = nickName.substring(nickName.indexOf(":")+1);
					List agentList =  getAgents(thisType, nickName);
					if(agentList != null && agentList.size() >0)
					{
						agentListForHyperVisorsChange.addAll(agentList);
						for(int k=0;k<agentList.size();k++)
						{
							ArrayList agentNameList = new ArrayList();
							agentNameList.add(nickName);
							String thisSubject = (String) agentList.get(k);
							if(nickAgentMap.containsKey(thisSubject))
							{
								ArrayList lst = (ArrayList) nickAgentMap.get(thisSubject);
								if(!lst.contains(nickName))
									lst.add(nickName);
								nickAgentMap.put(thisSubject, lst);
							}
							else
							{
								nickAgentMap.put(thisSubject, agentNameList);
							}
						}
					}
				}
			}
			String[] strTests = egSpecs.getTestsForServer(thisType);
			if (strTests != null && strTests.length > 0)
			{
				testEnabled = new ArrayList(Arrays.asList(strTests));
			}

			ArrayList availPatterns = new ArrayList();
			Enumeration ee = nickAgentMap.keys();
			while(ee.hasMoreElements())
			{
				String thisElement = (String) ee.nextElement();
				String [] variables = agIniFile.getVariables(thisElement);
				ArrayList nickList = (ArrayList) nickAgentMap.get(thisElement);
				for(int j=0;nickList != null && j<nickList.size();j++)
				{
					String thisNick = (String) nickList.get(j);
					for (int k=0;k<testEnabled.size();k++)
					{
						String thisTest = (String) testEnabled.get(k);
						String thisPattern = getResultantPattern(thisType,thisNick,thisTest,variables);
						if(thisPattern != null && !thisPattern.equals("null") && thisPattern.length() > 0)
						{
							String value = agIniFile.getValue(thisElement,thisPattern);
							int serverIndex = value.toLowerCase().indexOf("-"+subTypeParam);
							if (serverIndex > -1)
							{
								String tmpStr1 = value.substring(0,serverIndex + subTypeParam.length()).trim();
								String tmpStr2 = value.substring(serverIndex + subTypeParam.length() +1).trim();
								String serverIp = tmpStr2.substring(0,tmpStr2.indexOf(" ")).trim();

								if (serverIp.equals(ipAddr))
								{
									Iterator it = esxValsToChange.keySet().iterator();
									while (it.hasNext())
									{
										String param = (String)it.next();
										String paramVal = (String)esxValsToChange.get(param);
										int paramIdx = value.toLowerCase().indexOf("-"+param.toLowerCase());
										int paramLen = param.length()+1;
										if (paramIdx > -1)
										{
											String strTmp1 = value.substring(0,paramIdx+paramLen).trim();
											String strTmp2 = value.substring(paramIdx+paramLen).trim();
											int idx = strTmp2.indexOf(" ");
											if(idx !=-1)
											{ 
												strTmp2 = strTmp2.substring(idx).trim();
											}
											else
											{
												strTmp2="";
											}
											value = strTmp1 + " " + paramVal + " " + strTmp2;
										}
									}
									iniHelperArray.add(new IniHelper(thisElement,thisPattern,value));
									discParamsSubCompModify.add(thisType+":"+thisNick);
								}
							}
							
						}
					}
				}
			}
		}
		
		IniFile agIniFilewrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir+"eg_agents.ini",true);
		for (int i=0 ;i < iniHelperArray.size() ; i++ )
		{
			inihelper  = (IniHelper)iniHelperArray.get(i);
			agIniFilewrite.setValue(inihelper.getSubject(),inihelper.getVariable(),inihelper.getValue());
		}
		agIniFilewrite.saveFile();
		EgConfigFilesSync.releaseInstance(agIniFilewrite);

		IniFile discParamIni = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir+"eg_discoveryParams.ini",true);

		//TO Modify the discovery component param in eg_discoveryParams.ini
		if(discParamsSubCompModify!=null && discParamsSubCompModify.size() >0)
		{
			compListForAuditlog.addAll(discParamsSubCompModify);
			Iterator itt = discParamsSubCompModify.iterator();
			while(itt.hasNext())
			{
				String Compo =(String) itt.next();
				String compoType = Compo.substring(0,Compo.indexOf(":"));
				String value = discParamIni.getValue(compoType,Compo);
				if(value.length() > 0)
				{
					Iterator it = esxValsToChange.keySet().iterator();
					while (it.hasNext())
					{
						String param = (String)it.next();
						String paramVal = (String)esxValsToChange.get(param);
						int paramIdx = value.toLowerCase().indexOf("-"+param.toLowerCase());
						int paramLen = param.length()+1;
						if (paramIdx > -1)
						{
							String strTmp1 = value.substring(0,paramIdx+paramLen).trim();
							String strTmp2 = " ";
							strTmp2 = value.substring(paramIdx+paramLen).trim();
							int idx = strTmp2.indexOf(" ");
							if(idx !=-1)
							{ 
								strTmp2 = strTmp2.substring(idx).trim();
							}
							else
							{
								strTmp2="";
							}
							value = strTmp1 + " " + paramVal + " " + strTmp2;
						}
					}
						discParamIni.setValue(compoType,Compo,value);
				}
			}
		}
		discParamIni.saveFile();
		EgConfigFilesSync.releaseInstance(discParamIni);


		if (!agentListForHyperVisorsChange.isEmpty())
		{
			IniFile aglessIniFilewrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir+"eg_agentlessdisc.ini",true);
			String UName = "";
			String UPass = "";
			String ssl = "";
			String webPort = "";
			String from = "";
			String domain = "";
			Iterator itr = esxValsToChange.keySet().iterator();
			while (itr.hasNext())
			{
				String paramName = (String)itr.next();
				String paramValue = (String)esxValsToChange.get(paramName);
				if (paramName.equalsIgnoreCase("ssl"))
				{
					ssl = paramValue;
				}

				if (paramName.equalsIgnoreCase("webport") || paramName.equalsIgnoreCase("rhel_mgr_port"))
				{
					webPort = paramValue;
				}

				if (paramName.equalsIgnoreCase("rhel_mgr_domain"))
				{
					domain = paramValue;
				}

				if (paramName.equalsIgnoreCase("esx_user") || 
					paramName.equalsIgnoreCase("prism_user") || 
					paramName.equalsIgnoreCase("rhel_mgr_user") || 
					paramName.equalsIgnoreCase("management_user"))
				{
					UName = paramValue;
				}

				if (paramName.equalsIgnoreCase("esx_password") || 
					paramName.equalsIgnoreCase("prism_password") ||
					paramName.equalsIgnoreCase("rhel_mgr_password") ||
					paramName.equalsIgnoreCase("management_password"))
				{
					UPass = paramValue;
				}
			}

			if (baseType.equals("hmc"))
			{
				from = baseType;
			}

			ArrayList hvConfigAgtLst = new ArrayList(agentListForHyperVisorsChange);
			int size = hvConfigAgtLst.size();
			for (int ag=0; ag<size;ag++)
			{
				String agtName = (String) hvConfigAgtLst.get(ag);
				if (initAgent.equalsIgnoreCase(agtName))
				{
					continue;
				}
				String existValue = aglessIniFilewrite.getValue(agtName, from +"#" +ipAddr);
				if (!StringUtils.isNull(existValue))
				{
					String isDis = existValue.substring(0,existValue.indexOf("~#~"));
					String strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+webPort+"~#~"+ssl.toLowerCase(); //vc & nutanix same format
					if (baseType.equals("hmc"))
					{
						strPattern = isDis+"~#~"+UName+"~#~"+UPass+"~#~"+ssl+"~#~"+ipAddr;
					}
					aglessIniFilewrite.setValue(agtName,from +"#" +ipAddr,strPattern);
				}
			}
			aglessIniFilewrite.saveFile();
			EgConfigFilesSync.releaseInstance(aglessIniFilewrite);
		}
		return compListForAuditlog;
	}

%>

