<%
/*******************************************************************************
*   Name						 :   getAssociatedDisassociatedPolicyGrpData.jsp
*   Purpose					 : to associate and disassociate policy groups with servers
*   Version					 : 4.2.1
*   CreationDate			 :   09/29/2008
*   Author						 :   Rajesh
*   Design Changes  :	Jaiwin
*******************************************************************************/
%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ include file= "../../EgTrackerAJSON.jsp"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.eg.EgAgentInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.TimelineServlet"%>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import ="com.eg.EgTopoInfo" %>
<%@ page import ="com.eg.EgGroupInfo" %>
<%@ page import ="com.eg.EgURLEncoder" %>
<%@ page import ="com.eg.EgURLDecoder" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.ListUtils"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import ="com.egurkha.admin.QuickMaintenancePolicy" %>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import = "net.sf.json.*" %>
<%@	page import="com.egurkha.User"%>
<%@	page import="java.util.Date"%>
<%@	page import="egurkha.TestConfigSpecsBean"%>

<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader ("Expires", -1);

try
{
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String param=request.getParameter("from");
	String defaultSelection = "Host";	
	// For Limited admin -Start
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),_user.getLoginID());
	boolean isLimitedAdmin = !roleInfo.hasAllComponentAccess();
	IniFile maintenanceIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_maintenance.ini",true);
	String showHostForLimitedAdmin = maintenanceIni.getValue("MISC_ARGS", "showHostForLimitedAdmin");
	boolean isHostEnableForLimitedAdmin = false;
	
	if(showHostForLimitedAdmin != null && showHostForLimitedAdmin.equalsIgnoreCase("yes")){
		isHostEnableForLimitedAdmin = true;
	}
	String[] combinations = {"Host","Component","Test","Descriptor","Descriptor For Component","Test For Host","Test For Component","Wild Card"}; 
	if (isLimitedAdmin) 
	{
		if(isHostEnableForLimitedAdmin){
			combinations = new String[]{"Host","Component","Test For Host","Test For Component","Descriptor For Component","Wild Card"};
			defaultSelection = "Host";
		} else {
			combinations = new String[]{"Component","Test For Component","Descriptor For Component","Wild Card"};
			defaultSelection = "Component";
		}
	}
	JSONObject rootJson = new JSONObject();
	if(param!=null && param.equalsIgnoreCase("defaultLoad"))
	{
%>
<jsp:useBean id="policyIni" class="egurkha.EgTestParamBean" scope="page" />
<%
		IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
		String cDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String uiFile = "eg_ui.ini";		
		User usr = UserRegistry.getInstance().getUser(session.getId());
		String userDtFormat = usr.getUserDateFormat();
		if(userDtFormat != null && userDtFormat.length() > 0)
		{
			if(userDtFormat.equalsIgnoreCase("default"))
				userDtFormat = cDateFormat;
		}
		String currentDateFormat_script=cDateFormat;
		String policyName=request.getParameter("policyToView");
		String operation = request.getParameter("operation");

		JSONObject screenLabels= new JSONObject();
		screenLabels.put("admin.mpolicy.Policy name",_mapping.getTextDescription("admin.mpolicy.Policy name"));
		screenLabels.put("admin.mpolicy.Description",_mapping.getTextDescription("admin.mpolicy.Description"));
		screenLabels.put("admin.mpolicy.Time frequency",_mapping.getTextDescription("admin.mpolicy.Time frequency"));
		screenLabels.put("admin.mpolicy.Add frequency",_mapping.getTextDescription("admin.mpolicy.Add frequency"));
		screenLabels.put("admin.mpolicy.Day of the Week",_mapping.getTextDescription("admin.mpolicy.Day of the Week"));
		screenLabels.put("admin.mpolicy.Repeat",_mapping.getTextDescription("admin.mpolicy.Repeat"));
		screenLabels.put("admin.mpolicy.Date of the Month",_mapping.getTextDescription("admin.mpolicy.Date of the Month"));
		screenLabels.put("admin.mpolicy.Time line",_mapping.getTextDescription("admin.mpolicy.Time line"));
		screenLabels.put("admin.mpolicy.Associate Elements",_mapping.getTextDescription("admin.mpolicy.Associate Elements"));
		screenLabels.put("admin.mpolicy.Associate policy for",_mapping.getTextDescription("admin.mpolicy.Associate policy for"));
		screenLabels.put("admin.mpolicy.DisAssociate Elements",_mapping.getTextDescription("admin.mpolicy.DisAssociate Elements"));
		screenLabels.put("admin.mpolicy.Search",_mapping.getTextDescription("admin.mpolicy.Search"));
		screenLabels.put("admin.mpolicy.Frequency",_mapping.getTextDescription("admin.mpolicy.Frequency"));

		rootJson.put("screenLabels",screenLabels);

		JSONArray timeFreqOptions = new JSONArray();
		JSONObject timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Choose a time frequency"));
		timeFreOpt.put("valueField","-1");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.First day of month"));
		timeFreOpt.put("valueField","FDM");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Last day of month"));
		timeFreOpt.put("valueField","LDM");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Daily"));
		timeFreOpt.put("valueField","*");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Day of the Week"));
		timeFreOpt.put("valueField","dow");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Date of the Month"));
		timeFreOpt.put("valueField","dom");
		timeFreqOptions.add(timeFreOpt);
		timeFreOpt =  new JSONObject();
		timeFreOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Date"));
		timeFreOpt.put("valueField","date");
		timeFreqOptions.add(timeFreOpt);

		rootJson.put("TimeFreqOptions",timeFreqOptions);

		JSONArray dayOftheWeekOptions = new JSONArray();
		JSONObject dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please choose a day"));
		dayOpt.put("valueField","-1");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Sunday"));
		dayOpt.put("valueField","Sun");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Monday"));
		dayOpt.put("valueField","Mon");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Tuesday"));
		dayOpt.put("valueField","Tue");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Wednesday"));
		dayOpt.put("valueField","Wed");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Thursday"));
		dayOpt.put("valueField","Thu");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Friday"));
		dayOpt.put("valueField","Fri");
		dayOftheWeekOptions.add(dayOpt);
		dayOpt =  new JSONObject();
		dayOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Saturday"));
		dayOpt.put("valueField","Sat");
		dayOftheWeekOptions.add(dayOpt);

		rootJson.put("dayOftheWeekOptions",dayOftheWeekOptions);

		JSONArray dateOftheMonthOptions = new JSONArray();
		JSONObject dateOpt =  new JSONObject();
		dateOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please choose a date"));
		dateOpt.put("valueField","-1");
		dateOftheMonthOptions.add(dateOpt);
		for(int i=1;i<=31;i++)
		{
			String suffix = "th";
			if(i==1 || i==21 || i==31)
			{
				suffix = "st";
			}
			else if(i==2 || i==22)
			{
				suffix = "nd";
			}
			else if(i==3 || i==23)
			{
				suffix = "rd";
			}
			dateOpt.put("displayField",i+suffix);
			dateOpt.put("valueField","Every_"+i);
			dateOftheMonthOptions.add(dateOpt);
		}
		rootJson.put("dateOftheMonthOptions",dateOftheMonthOptions);

		JSONArray repeatOptions = new JSONArray();
		JSONObject repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Choose a Week"));
		repeatOpt.put("valueField","-1");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Every"));
		repeatOpt.put("valueField","Every");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.First"));
		repeatOpt.put("valueField","week_1");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Second"));
		repeatOpt.put("valueField","week_2");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Third"));
		repeatOpt.put("valueField","week_3");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Fourth"));
		repeatOpt.put("valueField","week_4");
		repeatOptions.add(repeatOpt);
		repeatOpt =  new JSONObject();
		repeatOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Fifth"));
		repeatOpt.put("valueField","week_5");
		repeatOptions.add(repeatOpt);
		rootJson.put("repeatOptions",repeatOptions);
		JSONArray AssociatePolicyOptions = new JSONArray();	
		JSONObject assPolicyOpt =  new JSONObject();		
		if (isLimitedAdmin) 
		{
			assPolicyOpt =  new JSONObject();
				
			if(isHostEnableForLimitedAdmin){
				assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Host"));
				assPolicyOpt.put("valueField","Host");
				AssociatePolicyOptions.add(assPolicyOpt);
			}
			

			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Component"));
			assPolicyOpt.put("valueField","Component");
			AssociatePolicyOptions.add(assPolicyOpt);			
			
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Descriptor for Component"));
			assPolicyOpt.put("valueField","Descriptor for Component");
			AssociatePolicyOptions.add(assPolicyOpt);

			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Test For Host"));
			assPolicyOpt.put("valueField","Test For Host");
			AssociatePolicyOptions.add(assPolicyOpt);
			
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Test For Component"));
			assPolicyOpt.put("valueField","Test For Component");
			AssociatePolicyOptions.add(assPolicyOpt);

			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop (Wild Card)"));
			assPolicyOpt.put("valueField","Wild Card");
			AssociatePolicyOptions.add(assPolicyOpt);
		}
		else
		{
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Host"));
			assPolicyOpt.put("valueField","Host");
			AssociatePolicyOptions.add(assPolicyOpt);
			
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Component"));
			assPolicyOpt.put("valueField","Component");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Test"));
			assPolicyOpt.put("valueField","Test");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Descriptor"));
			assPolicyOpt.put("valueField","Descriptor");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Descriptor for Component"));
			assPolicyOpt.put("valueField","Descriptor for Component");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Test For Host"));
			assPolicyOpt.put("valueField","Test For Host");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Test For Component"));
			assPolicyOpt.put("valueField","Test For Component");
			AssociatePolicyOptions.add(assPolicyOpt);
			assPolicyOpt =  new JSONObject();
			assPolicyOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Server/VM/Desktop (Wild Card)"));
			assPolicyOpt.put("valueField","Wild Card");
			AssociatePolicyOptions.add(assPolicyOpt);
		}

		rootJson.put("AssociatePolicyOptions",AssociatePolicyOptions);
		rootJson.put("selectedAssociateOption",defaultSelection);
		EgDateInfo date = new EgDateInfo();
		String dateeee = date.egetDate().substring(0,10);
		String timeNow = date.egetDate().substring(11);
		TimelineServlet ahb = new TimelineServlet(request);
		String comFormat_new="";
		if(DateUtil.isDate(ahb.getEndDate(),"MM/dd/yyyy"))
		{
			comFormat_new = "MM/dd/yyyy";
		}
		else
		{
			comFormat_new = cDateFormat;
		}
		String dispDate = DateUtil.changeDateFormat(ahb.getEndDate(),comFormat_new,cDateFormat);
		com.egurkha.EgTimeZoneConverter egt = new com.egurkha.EgTimeZoneConverter(dispDate+" "+timeNow,_user);
		rootJson.put("startDate",egt.getDate(false));
		rootJson.put("startHr",egt.getHour());
		rootJson.put("startMin",egt.getMinute());
		if(DateUtil.isDate(ahb.getEndDate(),"MM/dd/yyyy"))
		{
			comFormat_new = "MM/dd/yyyy";
		}
		else
		{
			comFormat_new = cDateFormat;
		}
		long value=Long.parseLong("24");
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
		value = (24 * 3600);
		Date today = new Date();
		Date start = new Date();
		start.setTime(today.getTime() + (value * 1000));
		dispDate = sdf.format(start);
		dispDate = DateUtil.changeDateFormat(dispDate,comFormat_new,cDateFormat);

		egt = new com.egurkha.EgTimeZoneConverter(dispDate+" "+timeNow,_user);
		rootJson.put("endDate",egt.getDate(false));
		rootJson.put("endHr",egt.getHour());
		rootJson.put("endMin",egt.getMinute());
		if (operation == null)
		{
			operation = "create";
		}
		if(operation.equalsIgnoreCase("modify"))
		{
			Hashtable htRepeatWeek = new Hashtable();
			htRepeatWeek.put("1","First");
			htRepeatWeek.put("2","Second");
			htRepeatWeek.put("3","Third");
			htRepeatWeek.put("4","Fourth");
			htRepeatWeek.put("5","Fifth");
			Date locdate = new Date(date.egetUTCDate(false));			
			SimpleDateFormat mdyFormat = new SimpleDateFormat("MM/dd/yyyy");
			String stDate = mdyFormat.format(locdate);			

			policyIni.createFile("eg_maintenance.ini");
			String s_policyViewed = request.getParameter("policyToView");			
			String s_strValue = policyIni.getStrValue("UNPLANNED_POLICIES_DISPLAY", s_policyViewed);
			if(StringUtils.isNull(s_strValue))
				s_strValue = policyIni.getStrValue("UNPLANNED_POLICIES", s_policyViewed);
			if(request.getParameter("policyVal") != null)
			{
				String policyArray = request.getParameter("policyVal");
				StringTokenizer st33=new StringTokenizer(policyArray,"*",false);
				while(st33.hasMoreTokens())
				{
					String s_temp=st33.nextToken();
					//out.println("<option name='"+s_temp+"' value='"+s_temp+"' selected>"+s_temp+"</option>");
				}
			}//ends
			else
			{				
				StringTokenizer st1 = new StringTokenizer(s_strValue, ",");
				String s_temp = "";
				String s_temp_text = "";
				String policydisplayvalue="";
				String policydisplaytext="";
				
				while(st1.hasMoreTokens())
				{
					s_temp = st1.nextToken();					
					if(s_temp.indexOf("#*") > -1)
					{
						s_temp = s_temp.substring(0,s_temp.indexOf("#")+1) + "Daily";
						s_temp_text = s_temp.substring(0,s_temp.indexOf("#")+1) + _mapping.getTextDescription("admin.mpolicy.Daily");
					}
					else if(s_temp.indexOf("#FDM") > -1)
					{
						s_temp = s_temp.substring(0,s_temp.indexOf("#")+1) + "First day of month";
						s_temp_text = s_temp.substring(0,s_temp.indexOf("#")+1) + _mapping.getTextDescription("admin.mpolicy.First day of   month");
					}
					else if(s_temp.indexOf("#LDM") > -1)
					{
						s_temp = s_temp.substring(0,s_temp.indexOf("#")+1) + "Last day of month";
						s_temp_text = s_temp.substring(0,s_temp.indexOf("#")+1) + _mapping.getTextDescription("admin.mpolicy.Last   day of month");
					}
					else if(s_temp.indexOf("#Every") > -1)
					{			
						String suffix = "th";
						if(s_temp.endsWith("1") || s_temp.endsWith("21") || s_temp.endsWith("31"))
						{
							suffix = "st";
						}
						else if(s_temp.endsWith("2") || s_temp.endsWith("22"))
						{
							suffix = "nd";
						}
						else if(s_temp.endsWith("3") || s_temp.endsWith("23"))
						{
							suffix = "rd";
						}
						s_temp = com.egurkha.util.StringUtils.replace(s_temp,"_"," ")+suffix+" "+ _mapping.getTextDescription("admin.mpolicy.day of the month");
						s_temp_text = s_temp;
					}
					else if(s_temp.indexOf("/") == -1)
					{
						if(!(s_temp.indexOf("day") > -1))
						{							
							if(s_temp.indexOf("#Sun") > -1)
							{								
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.sunday of the month");
								}
								else
								{
									s_temp = s_temp + "day";
								}
							}
							else if(s_temp.indexOf("#Mon") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.monday of the month");
								}
								else
								{
									s_temp = s_temp + "day";
								}
							}
							else if(s_temp.indexOf("#Tue") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.tuesday of the month");
								}
								else
								{
									s_temp = s_temp + "sday";
								}
							}
							else if(s_temp.indexOf("#Wed") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.wednesday of the month");
								}
								else
								{
									s_temp = s_temp + "nesday";
								}
							}
							else if(s_temp.indexOf("#Thu") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.thursday of the month");
								}
								else
								{
									s_temp = s_temp + "rsday";
								}
							}
							else if(s_temp.indexOf("#Fri") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									//s_temp = day + "day" +" ("+htRepeatWeek.get(week.trim()).toString()+")";
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.friday of the month");
								}
								else
								{
									s_temp = s_temp + "day";
								}
							}
							else if(s_temp.indexOf("#Sat") > -1)
							{
								if(s_temp.indexOf("$") > -1 && s_temp.indexOf("_") > -1)
								{
									String day = s_temp.substring(0,s_temp.indexOf("$"));
									String week = s_temp.substring(s_temp.indexOf("$")+1);
									week = week.substring(week.indexOf("_")+1);
									day = day.substring(0,day.indexOf("#"));
									s_temp = day+"#"+htRepeatWeek.get(week.trim()).toString()+" "+_mapping.getTextDescription("admin.mpolicy.saturday of the month");
								}
								else
								{
									s_temp = s_temp + "urday";
								}
							}
							String s1 = s_temp.substring(0,s_temp.indexOf("#"));
							String s2 = s_temp.substring(s_temp.indexOf("#")+1);
							s_temp_text = s1 + "#" + _mapping.getTextDescription("admin.common."+s2);
						}
						else
						{							
							if(s_temp.indexOf("#Sun") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Mon") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Tue") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Wed") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Thu") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Fri") > -1)
							s_temp = s_temp + "";
							else if(s_temp.indexOf("#Sat") > -1)
							s_temp = s_temp + "";
						}
					}
					else
					{
						s_temp_text=s_temp.substring(0,s_temp.indexOf("#")+1)+DateUtil.changeDateFormat(s_temp.substring(s_temp.indexOf("#")+1,s_temp.length()),"MM/dd/yyyy",cDateFormat);
					}
					if(s_temp != "")
					{
						if(policydisplayvalue!=null && policydisplayvalue.equals("") && policydisplaytext!=null && policydisplaytext.equals(""))
						{
							policydisplayvalue=s_temp;
							policydisplaytext=s_temp_text;
						}
						else
						{
							policydisplayvalue=policydisplayvalue+","+s_temp;
							policydisplaytext=policydisplaytext+","+s_temp_text;
						}		
					}
				}
				/*StringTokenizer strToken = new StringTokenizer(policydisplayvalue,",");
				String policyDispValue = "";
				while(strToken.hasMoreTokens())
				{
					String nextTokens = strToken.nextToken();
					if(nextTokens!=null && nextTokens.indexOf("|")>0)
					{
						String strHr = nextTokens.substring(0,nextTokens.indexOf("-"));
						String endHr = nextTokens.substring(nextTokens.indexOf("-")+1,nextTokens.indexOf("#"));
						String strDate = nextTokens.substring(nextTokens.indexOf("#")+1,nextTokens.indexOf("|"));
						String endDate = nextTokens.substring(nextTokens.indexOf("|")+1);
						String dispStartDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",userDtFormat);
						EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr,_user);
						String dispEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",userDtFormat);
						EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr,_user);
						strDate = (String) converterStart.getDate(false);
						endDate = (String) converterEnd.getDate(false);
						strHr = converterStart.getHour();
						endHr = converterEnd.getHour();
						String strMin = converterStart.getMinute();
						String endMin = converterEnd.getMinute();	
						policyDispValue += strHr+":"+strMin+"-"+endHr+":"+endMin+"#"+strDate+"|"+endDate;
						policyDispValue +=",";
					}	
					else
					{
						policyDispValue += nextTokens+",";
					}
				}
				policyDispValue = policyDispValue.substring(0,policyDispValue.lastIndexOf(","));
				//rootJson.put("existingPlolicyEntries",policyDispValue);*/
				rootJson.put("existingPlolicyEntries",s_strValue);				
				JSONArray qGridData = new JSONArray();	
				StringTokenizer str = new StringTokenizer(policydisplayvalue,",");
				while(str.hasMoreTokens())
				{
					JSONObject rowJSON = new JSONObject();
					String individualPolicy = str.nextToken();
					StringTokenizer str1 = new StringTokenizer(individualPolicy,"#");
					if (str1.hasMoreTokens())
					{
						String timelineVal = str1.nextToken();
						String timeFreqVal = str1.nextToken();
						
						String timeVal1=timeFreqVal;
						String startDate = "";
						String endDate = "";
						String strHr = "";
						String endHr = "";
						if (timeFreqVal.indexOf('|')>0)
						{
							Date startDateFrmReq=new Date();
							Date endDateFrmReq=new Date();
							startDate = timeFreqVal.substring(0,timeFreqVal.indexOf('|'));
							endDate = timeFreqVal.substring(timeFreqVal.indexOf('|')+1);
							//startDate=DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",userDtFormat);
							//endDate=DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",userDtFormat);
							//timeFreqVal = startDate+" - "+endDate;
						}
						if (timelineVal.indexOf("-")>0)
						{
							strHr = timelineVal.substring(0,timelineVal.indexOf("-"));
							endHr = timelineVal.substring(timelineVal.indexOf("-")+1);

							if(startDate.equals("") && endDate.equals(""))
							{
								startDate = stDate;
								endDate = stDate;
							}
							if(!startDate.equals("") && !endDate.equals(""))
							{
								String dispStartDate = DateUtil.changeDateFormat(startDate, "MM/dd/yyyy", userDtFormat);
								dispStartDate = dispStartDate.trim();
								EgTimeZoneConverter converterStart = new EgTimeZoneConverter(dispStartDate+" "+strHr,_user);
								String dispEndDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
								dispEndDate = dispEndDate.trim();
								EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(dispEndDate+" "+endHr,_user);
								startDate = (String)converterStart.getDate(false);
								endDate = (String)converterEnd.getDate(false);
								strHr = converterStart.getHour()+":"+converterStart.getMinute();
								endHr = converterEnd.getHour()+":"+converterEnd.getMinute();
								if (timeFreqVal.indexOf('|')>0)
								{
									timeVal1 = DateUtil.changeDateFormat(startDate,userDtFormat,"MM/dd/yyyy")+"|"+DateUtil.changeDateFormat(endDate,userDtFormat,"MM/dd/yyyy"); // grid valuefield for date
									//startDate = DateUtil.changeDateFormat(startDate, "MM/dd/yyyy", userDtFormat);
									//endDate = DateUtil.changeDateFormat(endDate, "MM/dd/yyyy", userDtFormat);
									timeFreqVal = startDate+" - "+endDate;								
								}
							}
							String timelineDisp = "From  "+strHr+" Hrs To  "+endHr+" Hrs";
							rowJSON.put("timeline",timelineDisp);
						}
						
						if(timeVal1.startsWith("Every"))
						{							
							String date1 = timeVal1.substring(6,timeVal1.indexOf(" day"));
							if(date1!=null && (date1.endsWith("th") || date1.endsWith("st") || date1.endsWith("nd") || date1.endsWith("rd")))
							{
								date1 = date1.substring(0,date1.length()-2);
							}
							timeVal1 = "Every_"+date1.trim();
						}
						else if((timeVal1.indexOf("day") > -1) && timeVal1.indexOf("of the month")>-1)
						{
							String repeatWeek = "";
							if(timeVal1.indexOf("First")>-1)
							{
								repeatWeek = "1";
							}
							else if(timeVal1.indexOf("Second")>-1)
							{
								repeatWeek = "2";
							}
							else if(timeVal1.indexOf("Third")>-1)
							{
								repeatWeek = "3";
							}
							else if(timeVal1.indexOf("Fourth")>-1)
							{
								repeatWeek = "4";
							}
							else if(timeVal1.indexOf("Fifth")>-1)
							{
								repeatWeek = "5";
							}

							String day = "";
							if(timeVal1.indexOf("sunday")>0)
							{
								day = "Sun";
							}
							else if(timeVal1.indexOf("monday")>0)
							{
								day = "Mon";
							}
							else if(timeVal1.indexOf("tuesday")>0)
							{
								day = "Tue";
							}
							else if(timeVal1.indexOf("wednesday")>0)
							{
								day = "Wed";
							}
							else if(timeVal1.indexOf("thursday")>0)
							{
								day = "Thu";
							}
							else if(timeVal1.indexOf("friday")>0)
							{
								day = "Fri";
							}
							else if(timeVal1.indexOf("saturday")>0)
							{
								day = "Sat";
							}
							timeVal1 = day.trim()+"$"+"week_"+repeatWeek.trim();
						}
						 
						if(timeVal1!=null && timeVal1.indexOf("|")>0)
						{
							rowJSON.put("timeFrequency",timeFreqVal);
						}
						else
						{
							rowJSON.put("timeFrequency",_mapping.getTextDescription("admin.mpolicy."+timeFreqVal));
						}
						rowJSON.put("valueField",strHr+"-"+endHr+"#"+timeVal1);
					}
					qGridData.add(rowJSON);
				}
				rootJson.put("qGridData",qGridData);
			}//end of else part
		}
		rootJson.put("policyToView",policyName);
		rootJson.put("operation",operation);
	}
	else
	{
		QuickMaintenancePolicy quickMainPolicyObj = new QuickMaintenancePolicy(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId()) ;
		EgMaintenanceUtility egm=new EgMaintenanceUtility();
		EgMappingInfo mapping=new EgMappingInfo(trackerLanguage);
	
		// For Limited admin -End
		String policyType = request.getParameter("type");
		String policyName = request.getParameter("policyName");
		String componentType=request.getParameter("comptype");
		componentType=StringUtils.decodeSecurityChar(componentType);
		String comp=request.getParameter("comp");
		comp=StringUtils.decodeSecurityChar(comp);
		String associatePolicyTo = request.getParameter("combination");
		String managedList = request.getParameter("fassociate");
		managedList=StringUtils.decodeSecurityChar(managedList);
		String unmanagedList = request.getParameter("fdissociate");
		unmanagedList=StringUtils.decodeSecurityChar(unmanagedList);
		String policydet=request.getParameter("policyEntries");
		String existingComponents = request.getParameter("existingComponents");
		existingComponents=StringUtils.decodeSecurityChar(existingComponents);
		String testName = request.getParameter("test");
		testName=StringUtils.decodeSecurityChar(testName);
		String infraTypeName=request.getParameter("infratypename");
		infraTypeName=StringUtils.decodeSecurityChar(infraTypeName);
		String infraElementName=request.getParameter("serverType");
		infraElementName=StringUtils.decodeSecurityChar(infraElementName);
		String operation=request.getParameter("operation");
		rootJson.put("operation",operation);
		String testComp=request.getParameter("testcomp");
		testComp=StringUtils.decodeSecurityChar(testComp);
		String infolist=(String)request.getParameter("infolist");
		String isTestType=request.getParameter("isTest");
		String patternVal=request.getParameter("patternVal");
		patternVal=StringUtils.decodeSecurityChar(patternVal);

		String allinfoTest="";
		String allinfosAssociate="";
		String search=request.getParameter("search");
		search=(search!=null && search.length()>0)?search:"";
		testName = (testName != null && testName.length()>0)?testName:"";
		session.setAttribute("optVal",associatePolicyTo);
		associatePolicyTo = (associatePolicyTo !=null && associatePolicyTo.length()>0)?associatePolicyTo:defaultSelection;

		if (isLimitedAdmin && policyName != null && policyName.indexOf("|$|") == -1) // Limited admin --To maintain selections whilst policy creation
		{
			policyName += "|$|"+_user.getLoginID();		
		}
		String userLanguage = _user.getLanguage();
		Vector compTypeTests=new Vector();
		Vector compTests=new Vector();
		Vector associatedElement = new Vector();
		ArrayList testList = new ArrayList();
		ArrayList currentTests = null;


		IniUI iniUI = IniUI.getInstance();
		if (userLanguage == null)
		{
			userLanguage = iniUI.getDefaultLanguage();
		}
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		
		boolean isTestChange = false;
		boolean isTest = associatePolicyTo.equalsIgnoreCase("Test");
		boolean isHostBasedOnTest = associatePolicyTo.equalsIgnoreCase("Test For Host");
		boolean isDescriptorBasedOnTest = associatePolicyTo.equalsIgnoreCase("Descriptor");
		boolean isCompBasedOnTest = associatePolicyTo.equalsIgnoreCase("Test For Component");
		boolean isCompTypeBasedOnTest = associatePolicyTo.equalsIgnoreCase("Test For Component Type");
		boolean isDescriptorBasedOnComponent = associatePolicyTo.equalsIgnoreCase("Descriptor For Component");
		
		if (existingComponents == null || existingComponents.equalsIgnoreCase("null") || existingComponents.trim().length()<0)
		{
			existingComponents = "";
		}
		String paramtoPolicyassociate="";
		if(associatePolicyTo.equalsIgnoreCase("Test") && (isTestType!=null && isTestType.equalsIgnoreCase("no")))
		{
			paramtoPolicyassociate="Test For Component Type";
		}
		else
		{
			paramtoPolicyassociate=associatePolicyTo;
		}
		quickMainPolicyObj.initAuditLog();
		quickMainPolicyObj.setParams(
			policyType,
			policyName,
			paramtoPolicyassociate,
			componentType,
			comp,
			managedList,
			unmanagedList,
			policydet,
			existingComponents,
			testName,
			infraTypeName,
			infraElementName,
			operation,
			patternVal
		);

		currentTests = quickMainPolicyObj.getTestByPolicyAssociatedFor();	
		compTests = quickMainPolicyObj.getCompTests();
		compTypeTests = quickMainPolicyObj.getCompTypeTests() ;

		Vector v_fin = new Vector();
		Vector v_serve = quickMainPolicyObj.getDiscoveredElements(currentTests);
		v_fin = quickMainPolicyObj.getUnManagedComponent(v_serve);

		Hashtable testInfos=new Hashtable();
		Hashtable host_testInfos=new Hashtable();
		if(comp!=null && !comp.equals(""))
		{		
			testInfos=egm.getInfoBasedTestsForComponent(comp);
			String host_comp = comp;
			if( host_comp.indexOf(":")>0 && host_comp.lastIndexOf(":")>0)
			{
				host_comp = host_comp.substring(host_comp.indexOf(":")+1);
				host_comp = host_comp.substring(0,host_comp.indexOf(":"));
				host_comp = "Host_system:"+host_comp +":NULL";
				host_testInfos=egm.getInfoBasedTestsForComponent(host_comp);
			}
			if( host_testInfos!=null && !host_testInfos.isEmpty())
			{
				testInfos.putAll(host_testInfos);
			}
		}
		ArrayList allTest=new ArrayList();
		HashSet compNames=null;
		if(infolist!=null)
		{
			compNames=(HashSet)egm.getReleventComponentForInfos(infolist);
			compNames.remove(comp);
			
		}
		Hashtable infotest=null;
		if((param!=null && param.equals("test") &&  associatePolicyTo.equalsIgnoreCase("Descriptor")) || (param!=null && param.equalsIgnoreCase("selectboxes") && associatePolicyTo.equalsIgnoreCase("Descriptor")))
		{
			 infotest=egm.getInfoBasedTests();
		}
		if(policyType != null && policyType.equals("showPolicies"))
		{
			associatedElement = quickMainPolicyObj.getAssociatedElements();
		}
		if(param!=null && param.equals("type"))
		{
	%>
	<table cellspacing="0" cellpadding="2"  border="0"><col width="120"><col width="200"><!-- <col width="150"><col width="200"> -->
		<tr>
			<td style="width:120px" nowrap> <egui:intnl text="admin.mpolicy.Associate policy for"/>&nbsp;</td>
			<td style="width:200px">
				<select id="combination" name="combination" onChange="callback('type')" style='width:200px;'>
	<%
					if(associatePolicyTo=="Test For Component Type")
						associatePolicyTo="Test";

					String selected = "";
					for (int i=0;i<combinations.length;i++)
					{
						selected = (combinations[i].equals(associatePolicyTo))?"selected":"";
	%>
					<option value="<%=combinations[i]%>" <%=selected%>><%=combinations[i]%></option>
	<%
					}
	%>
				</select>
			</td>
		</tr>
	</table>
	<%
		}
		else if(param!=null && param.equals("componenttype"))
		{	
			ErUtils erutils=new ErUtils();
			List allServers=_user.getAllServerType();
			Vector servers=new Vector();
			Vector dispservers=new Vector();
			servers.addAll(allServers);
			ArrayList serverList  = new ArrayList();
			if(servers!=null && servers.size()>0)
			{
				Collections.sort(servers,String.CASE_INSENSITIVE_ORDER);
				serverList = sorter.getSortedCompTypeList(servers);
			}
			JSONArray compTypeOptions = new JSONArray();
			JSONObject compTypeOpt = new JSONObject();
			compTypeOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.ALL"));
			compTypeOpt.put("valueField","all");
			compTypeOptions.add(compTypeOpt);
			rootJson.put("selectedComboOption","all");
			//< egui : intnl text="admin.mpolicy.Filter By" / >		
			for(int i=0; i<serverList.size(); i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String tmpVal = nameObj.getActualName();	
				if(tmpVal!=null && tmpVal.equalsIgnoreCase("Host_system"))
					continue;
				String tmpDis = nameObj.getLocalName();
				compTypeOpt = new JSONObject();
				compTypeOpt.put("displayField",tmpDis);
				compTypeOpt.put("valueField",tmpVal);
				compTypeOptions.add(compTypeOpt);
				if(tmpVal.equals(componentType))
				{
					rootJson.put("selectedComboOption",tmpVal);
				}
			}
			rootJson.put("ComboOptions",compTypeOptions);
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter By"));
		}
		else if(param!=null && param.equalsIgnoreCase("component"))
		{				
			// < egui : intnl text="admin.mpolicy.Component" / >
			JSONArray compOptions = new JSONArray();
			JSONObject compOpt = new JSONObject();
			Vector compWithTypes= new Vector();
			HashMap map= new HashMap();

			compOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please select component"));
			compOpt.put("valueField","");
			compOptions.add(compOpt);
			rootJson.put("selectedComboOption","");

			Vector compWithTypes_temp = quickMainPolicyObj.getDescriptorBaseComponent();		
			
			if ( (compWithTypes_temp!= null) && (!compWithTypes_temp.isEmpty()) ){
				Iterator itr=compWithTypes_temp.iterator();
				while ( itr.hasNext() ){
					String type= (String)itr.next();
					String compType= type.substring(0, type.indexOf(":")); 
					String compName= type.substring(type.indexOf(":") + 1 );

					String compTypeDispVal = mapping.getComponentTypeDescription(compType); 
					String dispVal = compTypeDispVal + ":" + compName;

					compWithTypes.add(dispVal);
					map.put(dispVal, type);
				}
			}

			if (compWithTypes!= null && !compWithTypes.isEmpty())
			{
				Collections.sort(compWithTypes,String.CASE_INSENSITIVE_ORDER);

				String co_temp = "";
				String selected = "";
				String defltVal = "";
				for (int r = 0; r < compWithTypes.size(); r++)
				{
					String compAndType = (String)compWithTypes.elementAt(r);
					String comptype = "";

					if (!StringUtils.isNull(compAndType) && compAndType.indexOf(":") > -1){
						comptype = compAndType.substring(0, compAndType.indexOf(":"));
					}
					co_temp = compAndType.substring(compAndType.indexOf(":") + 1 );
					String disVal = comptype + ":" + co_temp;
					if ( (map!= null) && !map.isEmpty()){
						defltVal = (String)map.get(compAndType);
					}

					if ( disVal.endsWith(":NULL") ){
						disVal = disVal.substring(0, disVal.indexOf(":NULL"));
					}
					compOpt = new JSONObject();
					compOpt.put("displayField", disVal);
					compOpt.put("valueField", defltVal);
					compOptions.add(compOpt);

					if(compAndType.equals(comp))
					{
						rootJson.put("selectedComboOption", comp);
					}
				}
			}
			rootJson.put("ComboOptions",compOptions);
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by Component"));
		}
		else if(param!=null && param.equalsIgnoreCase("test") && (associatePolicyTo.equals("Test For Host") || associatePolicyTo.equals("Test For Component")))
		{
			 //<egui : intnl text="admin.mpolicy.Test" / >
			JSONArray testOptions = new JSONArray();
			JSONObject testOpt = new JSONObject();
			testOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please select a test"));
			testOpt.put("valueField","");
			testOptions.add(testOpt);
			rootJson.put("selectedComboOption","-1");
			String tmpDis="";
			testList = sorter.getSortedTestList(currentTests);
			for (int i=0;i<testList.size();i++)
			{
				EgName nameObj = (EgName)testList.get(i);
				String tmpVal = nameObj.getActualName();
				tmpDis = nameObj.getLocalName();
				testOpt = new JSONObject();
				testOpt.put("displayField",tmpDis);
				testOpt.put("valueField",tmpVal);
				testOptions.add(testOpt);
				if(tmpVal.equals(testName))
				{
					rootJson.put("selectedComboOption",testName);
				}
			}
			rootJson.put("ComboOptions",testOptions);
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by Test"));
		}
		else if(param!=null && param.equalsIgnoreCase("test") &&  associatePolicyTo.equals("Descriptor"))
		{
			 //<egui : intnl text="admin.mpolicy.Test" / >
			JSONArray testOptions = new JSONArray();
			JSONObject testOpt = new JSONObject();
			testOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please select a test"));
			testOpt.put("valueField","-1");
			testOptions.add(testOpt);
			rootJson.put("selectedComboOption","-1");
			Vector test_list=new Vector();
			ArrayList applyTest=new ArrayList();
			String tmpDis="";
	/*		while(itr.hasNext())
			{
				String test=(String)itr.next();
				test_list.add(test);
			}*/

			if(infotest!=null && !infotest.isEmpty())
			{
				test_list.addAll(infotest.keySet());
				applyTest = sorter.getSortedTestList(test_list);
			}

			if( applyTest !=null && !applyTest.isEmpty() )
			{
				for (int i=0;i<applyTest.size();i++)
				{
					EgName nameObj = (EgName)applyTest.get(i);
					String tmpVal = nameObj.getActualName();
					tmpDis = nameObj.getLocalName();
					testOpt = new JSONObject();
					testOpt.put("displayField",tmpDis);
					testOpt.put("valueField",tmpVal);
					testOptions.add(testOpt);
					if(tmpVal.equals(testName))
					{
						rootJson.put("selectedComboOption",testName);
					}
				}
			}
			rootJson.put("ComboOptions",testOptions);
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by Test"));
		}
		else if(param!=null && param.equalsIgnoreCase("testComponent"))
		{
			 //<egui : intnl text="admin.mpolicy.Test" / >
			JSONArray testOptions = new JSONArray();
			JSONObject testOpt = new JSONObject();
			testOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please select a test"));
			testOpt.put("valueField","-1");
			testOptions.add(testOpt);
			rootJson.put("selectedComboOption","-1");
			Iterator itr=testInfos.keySet().iterator();
			Vector test_list=new Vector();
			ArrayList applyTest=new ArrayList();
			String selected="";
			String tmpDis="";
			while(itr.hasNext())
			{
				String test=(String)itr.next();
				test_list.add(test);
			}
			applyTest = sorter.getSortedTestList(test_list);

			for (int i=0;i<applyTest.size();i++)
			{
				EgName nameObj = (EgName)applyTest.get(i);
				String tmpVal = nameObj.getActualName();
				tmpDis = nameObj.getLocalName();
				testOpt = new JSONObject();
				testOpt.put("displayField",tmpDis);
				testOpt.put("valueField",tmpVal);
				testOptions.add(testOpt);
				if(tmpVal.equals(testComp))
				{
					rootJson.put("selectedComboOption",testComp);
				}
			}
			rootJson.put("ComboOptions",testOptions);
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by Test"));
		}
		else if(param!=null && param.equalsIgnoreCase("infratypes"))
		{
			//Select components by
			if(associatePolicyTo!=null && (associatePolicyTo.equalsIgnoreCase("Test For Host") || associatePolicyTo.equalsIgnoreCase("Test For Component")))
			{
				JSONArray testOptions = new JSONArray();
				JSONObject testOpt = new JSONObject();
				testOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy.Please select a test"));
				testOpt.put("valueField","-1");
				testOptions.add(testOpt);
				rootJson.put("selectedComboOption","-1");
				String selected = "";
				String tmpDis="";
				if (isLimitedAdmin && associatePolicyTo.equalsIgnoreCase("Test For Host")) // Limited admin
				{
					ArrayList userTests = new ArrayList();
					List hostTestsList=null;
					String[] hostTests = specsInfo.getDefaultTestsForServer("Host_system");
					if (hostTests != null)
					{
						hostTestsList = new ArrayList(Arrays.asList(hostTests));
					}				
				
					HashMap userTestList=(HashMap)_user.getTests();
					List userAssociatedTests=new ArrayList();
					if(userTestList!=null && !userTestList.isEmpty())
					{
						userAssociatedTests.addAll(userTestList.keySet());
						int testsLength=userAssociatedTests.size();
						for(int t=0;t<testsLength;t++)
						{
							String tmpTest=(String)userAssociatedTests.get(t);
							if (!EgInstallInfo.isConfigTest(tmpTest) &&  hostTestsList.contains(tmpTest)) 
							{
								userTests.add(tmpTest);
							}
						}
					}
					currentTests.retainAll(userTests);	
				}
				testList = sorter.getSortedTestList(currentTests);
				for (int i=0;i<testList.size();i++)
				{
					EgName nameObj = (EgName)testList.get(i);
					String tmpVal = nameObj.getActualName();
					tmpDis = nameObj.getLocalName();
					testOpt = new JSONObject();
					testOpt.put("displayField",tmpDis);
					testOpt.put("valueField",tmpVal);
					testOptions.add(testOpt);
					if(tmpVal.equals(infraTypeName))
					{
						rootJson.put("selectedComboOption",infraTypeName);
					}
				}
				rootJson.put("ComboOptions",testOptions);
				rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by Test"));
			}
			else
			{
				JSONArray infraTypeOptions = new JSONArray();
				JSONObject infraTypeOpt = null;
				String infratypenames[]={"Zone","Segment","Service","Component Type"};
				String selected = "";
				rootJson.put("selectedComboOption","Zone");
				for(int i=0;i<infratypenames.length;i++)
				{
					infraTypeOpt = new JSONObject();
					infraTypeOpt.put("displayField",_mapping.getTextDescription("admin.mpolicy."+infratypenames[i]));
					infraTypeOpt.put("valueField",infratypenames[i]);
					infraTypeOptions.add(infraTypeOpt);
					if(infratypenames[i].equals(infraTypeName))
					{
						rootJson.put("selectedComboOption",infraTypeName);
					}
				}
				rootJson.put("ComboOptions",infraTypeOptions);
				rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by components"));
			}			
		}
		else if(param!=null && param.equalsIgnoreCase("infraelement"))
		{
			String infratypetitle="",infratitle="";
			ErUtils erutils=new ErUtils();
			if(infraTypeName.equals("") || infraTypeName.equals("-1"))
			{
				if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Host"))
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Choose a component type");
					infratitle="admin.mpolicy.Filter by type";
				}
				else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Component"))
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Search");
					infratitle="admin.mpolicy.Search";
				}
				else
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.infra element");
					infratitle="admin.mpolicy.Please select a element";
				}
			}
			else
			{
				if(infraTypeName!=null && infraTypeName.equals("Component Type"))
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Choose a component type");
					infratitle="admin.mpolicy.Component Type";
					
				}
				else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Host"))
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Choose a component type");
					infratitle="admin.mpolicy.Filter by type";
				}
				else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Component"))
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Search");
					infratitle="admin.mpolicy.Search";
				}
				else
				{
					infratypetitle=_mapping.getTextDescription("admin.mpolicy.Choose a "+infraTypeName.toLowerCase());
					infratitle="admin.mpolicy."+infraTypeName;
				}
			}
			rootJson.put("ComboLabel",_mapping.getTextDescription("admin.mpolicy.Filter by "+infratitle));
			// infratitle

			if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Host"))
			{
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");
				infraElementOptions.add(infraElementOpt);
				rootJson.put("selectedComboOption","-1");

				Map compTypeWithTest=(HashMap)quickMainPolicyObj.getComponentTypeTests();
				Iterator itr=compTypeWithTest.keySet().iterator();
				Vector componentTypeList=new Vector();
				while(itr.hasNext())
				{
					 String key=(String)itr.next();
					 List values=new ArrayList();
					values.addAll((ArrayList)compTypeWithTest.get(key));
					 if(values!=null && values.contains(infraTypeName))
					{
						componentTypeList.add(key);
					}
				}
				componentTypeList.remove("Host_system");
				if(componentTypeList!=null && componentTypeList.size()>0)
				{
					Collections.sort(componentTypeList,String.CASE_INSENSITIVE_ORDER);
				}
				ArrayList serverList  = new ArrayList();
				serverList = sorter.getSortedCompTypeList(componentTypeList);
				for(int i=0; i<serverList.size(); i++)
				{
					EgName nameObj = (EgName)serverList.get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();	
					infraElementOpt = new JSONObject();
					infraElementOpt.put("displayField",tmpDis);
					infraElementOpt.put("valueField",tmpVal);
					infraElementOptions.add(infraElementOpt);
					if(tmpVal.equals(infraElementName))
					{
						rootJson.put("selectedComboOption",infraElementName);
					}
				}
				rootJson.put("ComboOptions",infraElementOptions);
			}
			else if(infraTypeName!=null && infraTypeName.equals("Zone"))
			{
				//infratypetitle
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");
				infraElementOptions.add(infraElementOpt);
				rootJson.put("selectedComboOption","-1");
				List allZones=_user.getZones();/*Gives all zones added to Zone*/
				Vector zones=new Vector();
				zones.addAll(allZones);
				if(zones!=null && zones.size()>0)
				{
					Collections.sort(zones,String.CASE_INSENSITIVE_ORDER);
				}
				for(int i=0; i<zones.size(); i++)
				{
					String zoneName = (String)zones.get(i);
					infraElementOpt = new JSONObject();
					infraElementOpt.put("displayField",zoneName);
					infraElementOpt.put("valueField",zoneName);
					infraElementOptions.add(infraElementOpt);
					if(zoneName.equals(infraElementName))
					{
						rootJson.put("selectedComboOption",infraElementName);
					}
				}
				rootJson.put("ComboOptions",infraElementOptions);
			}
			else if(infraTypeName!=null && infraTypeName.equals("Segment"))
			{
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");
				infraElementOptions.add(infraElementOpt);
				rootJson.put("selectedComboOption","-1");
				List allSegments=_user.getSegments();
				Vector segments=new Vector();
				segments.addAll(allSegments);
				if(segments!=null && segments.size()>0)
				{
					Collections.sort(segments,String.CASE_INSENSITIVE_ORDER);
				}
				for(int i=0; i<segments.size(); i++)
				{
					String segmentName = (String)segments.get(i);
					infraElementOpt = new JSONObject();
					infraElementOpt.put("displayField",segmentName);
					infraElementOpt.put("valueField",segmentName);
					infraElementOptions.add(infraElementOpt);
					if(segmentName.equals(infraElementName))
					{
						rootJson.put("selectedComboOption",infraElementName);
					}
				}
				rootJson.put("ComboOptions",infraElementOptions);
			}
			else if(infraTypeName!=null && infraTypeName.equals("Service"))
			{
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");
				infraElementOptions.add(infraElementOpt);
				rootJson.put("selectedComboOption","-1");
				List allServices=_user.getServices();
				List allSites=_user.getSites();
				Vector services=new Vector();
				services.addAll(allServices);
				services.removeAll(allSites);
				services.addAll(allSites);
				if(services!=null && services.size()>0)
				{
					Collections.sort(services,String.CASE_INSENSITIVE_ORDER);
				}
				for(int i=0; i<services.size(); i++)
				{
					String serviceName = (String)services.get(i);
					infraElementOpt = new JSONObject();
					infraElementOpt.put("displayField",serviceName);
					infraElementOpt.put("valueField",serviceName);
					infraElementOptions.add(infraElementOpt);
					if(serviceName.equals(infraElementName))
					{
						rootJson.put("selectedComboOption",infraElementName);
					}
				}
				rootJson.put("ComboOptions",infraElementOptions);
			}
			else if(infraTypeName!=null && infraTypeName.equals("Component Type"))
			{
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");				
				rootJson.put("selectedComboOption","-1");
				infraElementOptions.add(infraElementOpt);
				List allServers=_user.getAllServerType();
				Vector servers=new Vector();
				Vector dispservers=new Vector();
				servers.addAll(allServers);
				servers.remove("Host_system");
				if(servers!=null && servers.size()>0)
				{
					Collections.sort(servers,String.CASE_INSENSITIVE_ORDER);
				}
				ArrayList serverList  = new ArrayList();
				serverList = sorter.getSortedCompTypeList(servers);
				for(int i=0; i<serverList.size(); i++)
				{
					EgName nameObj = (EgName)serverList.get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();
					infraElementOpt = new JSONObject();
					infraElementOpt.put("displayField",tmpDis);
					infraElementOpt.put("valueField",tmpVal);
					infraElementOptions.add(infraElementOpt);
					if(tmpVal.equals(infraElementName))
					{
						rootJson.put("selectedComboOption",infraElementName);
					}
				}
				rootJson.put("ComboOptions",infraElementOptions);
			}
			else
			{
				JSONArray infraElementOptions = new JSONArray();
				JSONObject infraElementOpt = new JSONObject();
				infraElementOpt.put("displayField",infratypetitle);
				infraElementOpt.put("valueField","-1");
				infraElementOptions.add(infraElementOpt);
				rootJson.put("selectedComboOption","-1");
				rootJson.put("ComboOptions",infraElementOptions);
			}
		}
		else if(param!=null && param.equalsIgnoreCase("selectboxes"))
		{
			Vector v_final = new Vector();
			Vector v_servers = quickMainPolicyObj.getDiscoveredElements(currentTests);
			v_final = quickMainPolicyObj.getUnManagedComponent(v_servers);
			if((v_final!=null && v_final.size()>0) && (search!=null && !search.equals("")))
			{
				Vector tmp=new Vector();
				for(int i=0;i<v_final.size();i++)
				{
					String elem=(String)v_final.get(i);
					if(elem.toUpperCase().indexOf(search.toUpperCase())!=-1)
					{
						tmp.add(elem);
					}
				}
				v_final.clear();
				v_final.addAll(tmp);
			}			
			JSONArray associatedElements = new JSONArray();
			JSONArray availableElements = new JSONArray();
			//admin.mpolicy.Elements associated
			if (isTest)
			{
				testList = sorter.getSortedTestList(associatedElement);
				for (int j=0; j<testList.size();j++)
				{
					EgName nameObj = (EgName)testList.get(j);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					associatedElements.add(tmpVal);
					existingComponents+=tmpVal+",";
				}
			} 
			else if(!associatePolicyTo.equalsIgnoreCase("Component") && !associatePolicyTo.equalsIgnoreCase("Test For Component Type") && 
				!associatePolicyTo.equalsIgnoreCase("Descriptor For Component") && !associatePolicyTo.equalsIgnoreCase("Descriptor")  && !associatePolicyTo.equalsIgnoreCase("Test For Host"))
			{
				boolean displayContents=true;
				if(isCompBasedOnTest && testName.equals(""))
				{
					displayContents=false;
				}
				if(displayContents)
				{
					Vector selectBoxvalues=new Vector();
					if(associatePolicyTo.equalsIgnoreCase("Host"))
					{
						selectBoxvalues = quickMainPolicyObj.getAllComponentsUnderComponentBy();
						if(selectBoxvalues!=null && selectBoxvalues.size()>0)
						{
							Vector tempBoxValues=new Vector();
							for(int m=0;m<selectBoxvalues.size();m++)
							{
								String value=(String)selectBoxvalues.get(m);
								if(value.indexOf(":")>-1)
									value=value.substring(0,value.indexOf(":"));
								tempBoxValues.add(value);
							}
							selectBoxvalues.clear();
							selectBoxvalues.addAll(tempBoxValues);
						}
						Collections.sort(selectBoxvalues,String.CASE_INSENSITIVE_ORDER);
					}
					Collections.sort(associatedElement,String.CASE_INSENSITIVE_ORDER);
					for(int r=0;r<associatedElement.size();r++)
					{
						String dispVal = (String)associatedElement.elementAt(r);
						if (dispVal.endsWith(":NULL"))
						{
							dispVal = dispVal.substring(0,dispVal.indexOf(":NULL"));
						}
						if(associatePolicyTo.equalsIgnoreCase("Host"))
						{
							if(selectBoxvalues.contains(dispVal))
							{	
								associatedElements.add(associatedElement.elementAt(r));
							}
						}
						else
						{
							associatedElements.add(associatedElement.elementAt(r));
						}
						existingComponents += associatedElement.elementAt(r) +",";
					}
				}
			}
			else if((associatePolicyTo.equalsIgnoreCase("Component") || associatePolicyTo.equalsIgnoreCase("Test For Host"))  && infraElementName!=null && !infraElementName.equals("") && !infraElementName.equals("-1"))
			{
				Vector selectBoxvalues=new Vector();
				selectBoxvalues = quickMainPolicyObj.getAllComponentsUnderComponentBy();
				if(associatePolicyTo.equalsIgnoreCase("Test For Host"))
				{
					if(selectBoxvalues!=null && selectBoxvalues.size()>0)
					{
						Vector tempBoxValues=new Vector();
						for(int m=0;m<selectBoxvalues.size();m++)
						{
							String value=(String)selectBoxvalues.get(m);
							if(value.indexOf(":")>-1)
								value=value.substring(0,value.indexOf(":"));
							tempBoxValues.add(value);
						}
						selectBoxvalues.clear();
						selectBoxvalues.addAll(tempBoxValues);
					}
				}
				Collections.sort(selectBoxvalues,String.CASE_INSENSITIVE_ORDER);
				Collections.sort(associatedElement,String.CASE_INSENSITIVE_ORDER);
				for(int r=0;r<associatedElement.size();r++)
				{
					String dispVal = (String)associatedElement.elementAt(r);
					if(selectBoxvalues.contains(dispVal))
					{	
						if (dispVal.endsWith(":NULL"))
							dispVal = dispVal.substring(0,dispVal.indexOf(":NULL"));

						associatedElements.add(associatedElement.elementAt(r));
					}
					existingComponents += associatedElement.elementAt(r) +",";
				}
			}
			else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Test For Component Type"))
			{
				if(compTests!=null && compTests.size()>0)
				{
					Collections.sort(associatedElement,String.CASE_INSENSITIVE_ORDER);
					for (int i=0;i<associatedElement.size();i++)
					{
						String testnam=(String)associatedElement.get(i);
						if(compTests.contains(testnam))
						{
							if(testnam!=null && !testnam.endsWith("_cf"))
							{
								existingComponents +=testnam+",";
								associatedElements.add(testnam);
							}
						}
					}
				}
			}
			else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Descriptor For Component"))
			{
				Collections.sort(associatedElement,String.CASE_INSENSITIVE_ORDER);
				if(!comp.equals("")||!testComp.equals(""))
				{
					String tmpComp = comp;
					String compType = "";
					if(comp.indexOf(":")>0)
					{
						compType = comp.substring(0,comp.indexOf(":"));
					}
					for (int i=0;i<associatedElement.size();i++)
					{
						String tessc=(String)associatedElement.get(i);
						int testColIdx=-1;
						int testHashIdx=-1;
						if(!StringUtils.isNull(tessc))
						{
							testColIdx=tessc.lastIndexOf(":");
							testHashIdx=tessc.indexOf("#");
						}

						if(tessc!=null && (testColIdx==-1 || testHashIdx==-1 || testColIdx<testHashIdx))
							continue;
						String assTestNameWithDesc = tessc.substring(tessc.indexOf("#")+1);
						String assTestName = assTestNameWithDesc.substring(0,assTestNameWithDesc.indexOf(":"));
						
						/*boolean isPortRelevantForTest=specsInfo.isPortRelevantForTest(assTestName);
						if(!isPortRelevantForTest && (tmpComp!=null && !tmpComp.equals("")) && tmpComp.lastIndexOf(":")>0)
						{			
							tmpComp = tmpComp.substring(0,tmpComp.lastIndexOf(":"))+":NULL";
						}*/

						String test=compType+":"+tessc.substring(0,tessc.indexOf("#"));						
						if(test.equals(tmpComp))
						{
							String infowithoutcomp=tessc.substring(tessc.indexOf("#")+1,tessc.length());
							if(i<associatedElement.size()-1)
								allinfosAssociate=infowithoutcomp+",";
							if(infowithoutcomp!=null && infowithoutcomp.indexOf(":")==-1)
								continue;
							String tName=infowithoutcomp.substring(0,infowithoutcomp.indexOf(":"));
							if(tName.equals(testComp))
							{
								String infos=infowithoutcomp.substring(infowithoutcomp.indexOf(":")+1,infowithoutcomp.length());
								associatedElements.add(infowithoutcomp);
								existingComponents +=infowithoutcomp+",";
							}
							
						}
					}
					compNames=(HashSet)egm.getReleventComponentForInfos(allinfosAssociate);
					compNames.remove(comp);
					int size=compNames.size();
					rootJson.put("allinfosAssociate",size);
				}
			}
			else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Descriptor"))
			{
				Collections.sort(associatedElement,String.CASE_INSENSITIVE_ORDER);
				if(!testName.equals(""))
				{
					for (int i=0;i<associatedElement.size();i++)
					{
						String testdesc=(String)associatedElement.get(i);
						if(testdesc!=null && (testdesc.indexOf(":")==-1 && testdesc.indexOf("#")==-1))
							continue;
						if(testdesc!=null && testdesc.indexOf(":")>0)
						{
							String testWithoutdes=testdesc.substring(0,testdesc.indexOf(":"));
							String infowithouttest=testdesc.substring(testdesc.indexOf(":")+1,testdesc.length());
							if(testWithoutdes.equals(testName))
							{
								associatedElements.add(infowithouttest);
								existingComponents +=infowithouttest+",";
							}
						}
					}
				}
			}
			String s_temp = "";
			if(associatePolicyTo.equalsIgnoreCase("Test"))
				associatePolicyTo="Test For Component Type";
		
			if (isTest && (isTestType!=null && isTestType.equalsIgnoreCase("yes")))
			{
			//	v_final.removeAll(associatedElement);
				testList = sorter.getSortedTestList(v_final);
				for (int j=0; j<testList.size();j++)
				{
					EgName nameObj = (EgName)testList.get(j);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					JSONObject availableOpt=new JSONObject();
					availableOpt.put("displayField",tmpDis);
					availableOpt.put("valueField",tmpVal);
					availableElements.add(availableOpt);
								
				}
			}
			else if(!associatePolicyTo.equalsIgnoreCase("Component") && !associatePolicyTo.equalsIgnoreCase("Test For Component Type") && !associatePolicyTo.equalsIgnoreCase("Descriptor") && !associatePolicyTo.equalsIgnoreCase("Descriptor For Component") && !associatePolicyTo.equalsIgnoreCase("Test For Host"))
			{
				boolean displayContents=true;
				//v_final.removeAll(associatedElement);
				
				Collections.sort(v_final,String.CASE_INSENSITIVE_ORDER);
				if(isCompBasedOnTest && testName.equals(""))
				{
					displayContents=false;
				}
				if(displayContents)
				{
					Vector selectBoxvalues=new Vector();
					//Both Associated & DisAssociated Elements
					if(associatePolicyTo.equalsIgnoreCase("Host"))
					{
						selectBoxvalues = quickMainPolicyObj.getAllComponentsUnderComponentBy();
						if(selectBoxvalues!=null && selectBoxvalues.size()>0)
						{
							Vector tempBoxValues=new Vector();
							for(int m=0;m<selectBoxvalues.size();m++)
							{
								String value=(String)selectBoxvalues.get(m);
								if(value.indexOf(":")>-1)
									value=value.substring(0,value.indexOf(":"));
								tempBoxValues.add(value);
							}
							selectBoxvalues.clear();
							selectBoxvalues.addAll(tempBoxValues);
						}
						selectBoxvalues = ListUtils.removeDuplicates( selectBoxvalues, true ) ;
						Collections.sort(selectBoxvalues,String.CASE_INSENSITIVE_ORDER);
						for(int i=0;i<selectBoxvalues.size();i++)
						{
							s_temp = (String)selectBoxvalues.elementAt(i);
							String disValue = s_temp;
							if (s_temp.endsWith(":NULL"))
								disValue = s_temp.substring(0,s_temp.indexOf(":NULL"));

							JSONObject availableOpt=new JSONObject();
							availableOpt.put("displayField",disValue);
							availableOpt.put("valueField",s_temp);
							availableElements.add(availableOpt);
						}
					}
					else
					{
						for(int r=0;r<v_final.size();r++)
						{
							s_temp = (String)v_final.elementAt(r);
							String disValue = s_temp;
							if (s_temp.endsWith(":NULL"))
								disValue = s_temp.substring(0,s_temp.indexOf(":NULL"));

							JSONObject availableOpt=new JSONObject();
							availableOpt.put("displayField",disValue);
							availableOpt.put("valueField",s_temp);
							availableElements.add(availableOpt);
						}
					}
				}
			}
			else if(!associatePolicyTo.equalsIgnoreCase("Component") && !associatePolicyTo.equalsIgnoreCase("Test For Component Type") && associatePolicyTo.equalsIgnoreCase("Descriptor")&& 
				!associatePolicyTo.equalsIgnoreCase("Descriptor For Component")) 
			{
			/*	Vector assoelement=new Vector();
				if(!associatedElement.equals(""))
				{
					for(int j=0;j<associatedElement.size();j++)
					{
						String inf=(String)associatedElement.get(j);
						String in=inf.substring(inf.indexOf(":")+1,inf.length());
						assoelement.add(in);
					}
				}*/
				if(isDescriptorBasedOnTest && !testName.equals(""))
				{
					HashSet infoHashSet = (HashSet)infotest.get(testName);
					String descAssociated = existingComponents;
					if(descAssociated!=null && descAssociated.indexOf(",")!=-1)
					{
						descAssociated = descAssociated.substring(0,descAssociated.lastIndexOf(","));
					}
					StringTokenizer stToken = new StringTokenizer(descAssociated,",");
					while(stToken.hasMoreTokens())
					{
						String nextDesc = stToken.nextToken();
						if(infoHashSet!=null && !infoHashSet.contains(nextDesc)) // Included configured infos which is not available in meta test
						{
							infoHashSet.add(nextDesc);
						}
					}
					if( infoHashSet!=null && !infoHashSet.isEmpty() )
					{
						ArrayList infoList = new ArrayList(infoHashSet);
						//if(assoelement!=null && !assoelement.isEmpty())
						//	infoList.removeAll(assoelement);

						if(infoList.size()>1)
							Collections.sort(infoList,String.CASE_INSENSITIVE_ORDER);
						
						for(int i=0;i<infoList.size();i++)
						{
							String descriptorObj=(String)infoList.get(i);
							JSONObject availableOpt=new JSONObject();	
							if(descriptorObj!=null && (descriptorObj.trim().equals("+") || descriptorObj.trim().equalsIgnoreCase("null") || descriptorObj.trim().equalsIgnoreCase("+null")))
							{
								continue;
							}
							availableOpt.put("displayField",descriptorObj);
							availableOpt.put("valueField",descriptorObj);
							availableElements.add(availableOpt);
						}
					}
				}
			}
			else if(associatePolicyTo!=null   && (associatePolicyTo.equalsIgnoreCase("Component") || associatePolicyTo.equalsIgnoreCase("Test For Host")) && infraTypeName!=null && !infraTypeName.equals("") && !infraTypeName.equals("-1") && infraElementName!=null && !infraElementName.equals("") && !infraElementName.equals("-1") && 
				!associatePolicyTo.equalsIgnoreCase("Descriptor For Component"))
			{
				Vector selectBoxvalues=new Vector();
				//Both Associated & DisAssociated Elements
				selectBoxvalues = quickMainPolicyObj.getAllComponentsUnderComponentBy();
				s_temp="";
				//DisAssociated Elements
				
				if(associatePolicyTo.equalsIgnoreCase("Test For Host"))
				{
					if(selectBoxvalues!=null && selectBoxvalues.size()>0)
					{
						Vector tempBoxValues=new Vector();
						for(int m=0;m<selectBoxvalues.size();m++)
						{
							String value=(String)selectBoxvalues.get(m);
							if(value.indexOf(":")>-1)
								value=value.substring(0,value.indexOf(":"));
							tempBoxValues.add(value);
						}
						selectBoxvalues.clear();
						selectBoxvalues.addAll(tempBoxValues);
					}
				}
				//selectBoxvalues.removeAll(associatedElement);
				selectBoxvalues = ListUtils.removeDuplicates( selectBoxvalues, true ) ;
				Collections.sort(selectBoxvalues,String.CASE_INSENSITIVE_ORDER);
				for(int i=0;i<selectBoxvalues.size();i++)
				{
					s_temp = (String)selectBoxvalues.elementAt(i);
					String disValue = s_temp;
					if (s_temp.endsWith(":NULL"))
						disValue = s_temp.substring(0,s_temp.indexOf(":NULL"));

					JSONObject availableOpt=new JSONObject();
					availableOpt.put("displayField",disValue);
					availableOpt.put("valueField",s_temp);
					availableElements.add(availableOpt);
				}
			}
			else if(associatePolicyTo!=null   && associatePolicyTo.equalsIgnoreCase("Test For Component Type"))
			{				
				if(componentType!=null && componentType.equalsIgnoreCase("All"))
				{					
					//v_final.removeAll(associatedElement);
					testList = sorter.getSortedTestList(v_final);
					for (int j=0; j<testList.size();j++)
					{
						EgName nameObj = (EgName)testList.get(j);
						String tmpVal = nameObj.getActualName();
						String tmpDis = nameObj.getLocalName();

						JSONObject availableOpt=new JSONObject();
						availableOpt.put("displayField",tmpDis);
						availableOpt.put("valueField",tmpVal);
						availableElements.add(availableOpt);
					}
				}
				else if(compTypeTests!=null && compTypeTests.size()>0)
				{
					//compTypeTests.removeAll(associatedElement);
					Collections.sort(compTypeTests,String.CASE_INSENSITIVE_ORDER);
					for (int i=0;i<compTypeTests.size();i++)
					{
						String testnam=(String)compTypeTests.get(i);
						if(testnam!=null && !testnam.endsWith("_cf"))
						{
							JSONObject availableOpt=new JSONObject();
							availableOpt.put("displayField",_mapping.getTestDescription(testnam));
							availableOpt.put("valueField",testnam);
							availableElements.add(availableOpt);
						}
					}
				}
			}
			else if(associatePolicyTo!=null && associatePolicyTo.equalsIgnoreCase("Descriptor For Component"))
			{				
				/*Vector assoelem=new Vector();
				if(!associatedElement.equals(""))
				{
					for(int j=0;j<associatedElement.size();j++)
					{
						String inf=(String)associatedElement.get(j);
						String host="";
						String in="";
						String info="";
						if(inf.indexOf("#")>0)
						{
							 host=inf.substring(0,inf.indexOf("#"));
							 in=inf.substring(inf.indexOf("#")+1,inf.length());
							 info=in.substring(in.indexOf(":")+1);
						}
						if(host.equals(comp))
							assoelem.add(info);
					}
				}*/
				if(!testComp.equals("") && !testComp.equals("-1"))
				{				
					HashSet infoHashSet=(HashSet) testInfos.get(testComp);	
					String descAssociated = existingComponents;
					if(descAssociated!=null && descAssociated.indexOf(",")!=-1)
					{
						descAssociated = descAssociated.substring(0,descAssociated.lastIndexOf(","));
					}
					StringTokenizer stToken = new StringTokenizer(descAssociated,",");
					while(stToken.hasMoreTokens())
					{
						String nextDesc = stToken.nextToken();
						if(nextDesc!=null && nextDesc.indexOf(":")>0)
						{
							nextDesc = nextDesc.substring(nextDesc.indexOf(":")+1);
						}
						if(infoHashSet!=null && !infoHashSet.contains(nextDesc)) // Included configured infos which is not available in meta test
						{
							infoHashSet.add(nextDesc);
						}
					}
					if( infoHashSet!=null && !infoHashSet.isEmpty() )
					{
						ArrayList infoList = new ArrayList(infoHashSet);
						if(infoList!=null)
						{
							//if( assoelem !=null && !assoelem.isEmpty() )
							//	infoList.removeAll(assoelem);

							if(infoList.size()>1)
								Collections.sort(infoList,String.CASE_INSENSITIVE_ORDER);

							for(int i=0;i<infoList.size();i++)
							{
								String compinfo=(String)infoList.get(i);
								if(compinfo!=null && (compinfo.trim().equals("+") || compinfo.trim().equalsIgnoreCase("null") || compinfo.trim().equalsIgnoreCase("+null")))
								{
									continue;
								}
								String testWithInfo=testComp+":"+compinfo;
								if(i<infoList.size()-1)
									allinfoTest=testWithInfo+",";
								JSONObject availableOpt=new JSONObject();
								availableOpt.put("displayField",compinfo);
								availableOpt.put("valueField",testWithInfo);
								availableElements.add(availableOpt);
							}
						}			
						compNames=(HashSet)egm.getReleventComponentForInfos(allinfoTest);
						compNames.remove(comp);
						int size=compNames.size();
						rootJson.put("releventComp",size);
					}
				}
			}
			JSONArray disAssociatedElements=new JSONArray();
			if(availableElements!=null && !availableElements.isEmpty())
			{
				HashSet assElmsSet=new HashSet(associatedElements);
				Iterator itrAvailabelElms=availableElements.iterator();
				while(itrAvailabelElms.hasNext())
				{
					JSONObject cOpt=(JSONObject)itrAvailabelElms.next();
					String elm=(String)cOpt.get("valueField");
					if(assElmsSet!=null && !assElmsSet.contains(elm))
					{
						disAssociatedElements.add(elm);
					}
				}
			}
			rootJson.put("disAssociatedElements",disAssociatedElements);
			rootJson.put("availableElements",availableElements);
		}
		else if(param!=null && param.equals("wildcard"))
		{
			HashSet wildcard=egm.getAssociatedWildcardForUnplannedPolicy(policyName);
			Iterator wildcardItr=wildcard.iterator();
			String wildcardStr1 = "";
			if(wildcardItr.hasNext()) 
			{
				while(wildcardItr.hasNext())
				{
					String wildcardName=(String)wildcardItr.next();
					wildcardStr1+=wildcardName;

					if(wildcardItr.hasNext()) 
					{
						wildcardStr1+=",";
					}
				}
			}
			existingComponents = wildcardStr1+",";
			rootJson.put("availableElements",wildcardStr1);
		}
		else if(param!=null && param.equals("submit"))
		{
			quickMainPolicyObj.updateIni();
			rootJson.put("update","success");
		}
		if(existingComponents!=null && existingComponents.indexOf(",")!=-1)
		{
			existingComponents = existingComponents.substring(0,existingComponents.lastIndexOf(","));
			rootJson.put("existingComponents",existingComponents);
		}
	}
	out.println(rootJson.toString());
}
catch(Exception e)
{
e.printStackTrace();
}
%>