Ext.Msg.cls='adminAlert';
Ext.Msg.layout = {
		type: 'anchor',
		pack:'center',
		align: 'center'
};

encodeParamListFromBackup = '';

if (!Array.isArray) {
  Array.isArray = function(arg) {
    return Object.prototype.toString.call(arg) === '[object Array]';
  };
}

Ext.define('SpecificTestConfiguration.controller.Main',{
	extend: 'Ext.app.Controller',
	views: [
		'SpecificTestConfiguration.view.ApplyToOtherComponents',
		'SpecificTestConfiguration.view.ExcludeComponents',
		'SpecificTestConfiguration.view.IncludeComponents'
	],

	refs:[
		{selector:'testconfiguration', ref:'testconfiguration'},
		{selector:'excludecomponents', ref:'excludecomponents'},
		{selector:'includecomponents', ref:'includecomponents'},
		{selector:'applytoothercomponents', ref:'applytoothercomponents'},
		{selector:'egvcconfig', ref:'egvcconfig'},
		{selector:'egnutconfig', ref:'egnutconfig'},
		{selector:'eghmcconfig', ref:'eghmcconfig'},
		{selector:'egconfigureurlandcredentials', ref:'egconfigureurlandcredentials'},
		{selector:'EgConfigureTargetsAndSysProps', ref:'EgConfigureTargetsAndSysProps'},
		{selector:'egconfigurewsdlurlandcredentials', ref:'egconfigurewsdlurlandcredentials'},
		{selector:'egconfigurewinsharedfolders', ref:'egconfigurewinsharedfolders'},
		{selector:'egconfiguremultipleusers', ref:'egconfiguremultipleusers'},
		{selector:'egconfigurepublishedresources', ref:'egconfigurepublishedresources'},
		{selector:'egconfigurenamepattern', ref:'egconfigurenamepattern'},
		{selector:'EgOidsValue', ref:'EgOidsValue'},
		{selector:'vmgusers', ref:'vmgusers'},
		{selector:'egconfigejb', ref:'egconfigejb'},
		{selector:'egconfigejbscreation', ref:'egconfigejbscreation'},
		{selector:'egconfiginfos', ref:'egconfiginfos'},
		{selector:'egconfiginfoscreation', ref:'egconfiginfoscreation'},
		{selector:'viewpolicy', ref:'viewpolicy'},
		{selector:'processconfiguration', ref:'processconfiguration'},
		{selector:'processconciseconfiguration', ref:'processconciseconfiguration'},
		{selector:'winservicesconfiguration', ref:'winservicesconfiguration'},
		{selector:'servicedetailedconfiguration', ref:'servicedetailedconfiguration'},
		{selector:'egwebserviceconfiguration', ref:'egwebserviceconfiguration'},
		{selector:'egdbusercreation', ref:'egdbusercreation'},
		{selector:'egconfigaggregate', ref:'egconfigaggregate'},
		{selector:'egconfigcomposite', ref:'egconfigcomposite'},
		{selector:'egpolicycreation', ref:'egpolicycreation'},
		{selector:'egvmlogdisplay', ref:'egvmlogdisplay'},
		{selector:'egdetailstest', ref:'egdetailstest'},
		{selector:'minmaxvalues', ref:'minmaxvalues'},
		{selector:'egconfigurerulenames', ref:'egconfigurerulenames'},
		{selector:'egxmsconfig', ref:'egxmsconfig'},
		{selector:'siteurlconfiguration', ref:'siteurlconfiguration'},
		{selector:'siteurldetailedconfiguration', ref:'siteurldetailedconfiguration'},
		{selector:'sitedetailedconfiguration', ref:'sitedetailedconfiguration'}

	],
	init:function() {
		me = this,
		appDesc = this,
		testViews = this;
		this.control({
			'testconfiguration': {
				'afterrender': this.afterMainRender
			},
			'testconfiguration checkbox[id="unconfiguredCompType"]':
			{
				'change':this.showUnconfigCompTypes
			},
			'testconfiguration scrollcombo[id="componentType"]': {
				'select': this.compTypeChangeEvent
			},
			'testconfiguration scrollcombo[id="componentName"]': {
				'select': this.compNameChangeEvent
			},
			'testconfiguration scrollcombo[id="testType"]': {
				'select': this.testTypeChangeEvent
			},
			'testconfiguration button[id="snmpUtil"]': {
				'click': this.snmpUtilityShow
			},
			'testconfiguration button[id="configurebutton"]': {
				'click': this.configureUnconfiguredTest
			},
			'testconfiguration button[id="unconfigexcludebutton"]': {
				'click': this.unconfigTestToExclude
			},
			'testconfiguration button[id="reconfigurebutton"]': {
				'click': this.configureReconfiguredTest
			},
			'testconfiguration button[id="configureexcludebutton"]': {
				'click': this.configTestToExclude
			},
			'testconfiguration button[id="includebutton"]': {
				'click': this.includeToUnconfigTest
			},
			'testconfiguration button[id="updateBtn"]': {
				'click': this.populate
			},
			'testconfiguration button[id="applyToOtherBtn"]': {
				'click': this.populate
			},
			'testconfiguration button[id="validateBtn"]': {
				'click': this.validate
			},
			'testconfiguration button[id="enableDisableBtn"]': {
				'click': this.goToEnableDisableTestpage
			},
			'testconfiguration button[id="backbutton"]': {
				'click': this.goToUnconfigTestsSummaryPage
			},
			'applytoothercomponents': {
				'afterrender': this.applyAllMainRender
			},
			'applytoothercomponents scrollcombo[id="ea_criteria"]': {
				'select': this.selectViewByCombo
			},
			'applytoothercomponents scrollcombo[id="ea_userOption"]': {
				'select': this.selectUserOptionCombo
			},
			'applytoothercomponents button[id="applyBtn"]': {
				'click': this.apply
			},
			'applytoothercomponents button[id="applyBackBtn"]': {
				'click': this.applyBackBtnEvent
			},
			'excludecomponents': {
				'afterrender': this.afterExcludeComponentsMainRender
			},
			'excludecomponents button[id="excludeApplyBtn"]': {
				'click': this.applyExcludeComponents
			},
			'excludecomponents button[id="excludeBackBtn"]': {
				'click': this.backToTestConfiguration
			},
			'includecomponents': {
				'afterrender': this.afterIncludeComponentsMainRender
			},
			'includecomponents button[id="includeApplyBtn"]': {
				'click': this.applyIncludeComponents
			},
			'includecomponents button[id="includeBackBtn"]': {
				'click': this.backToTestConfiguration
			},
			'egrhevconfig scrollcombo[id="SslRhev"]': {
				'select': this.combosslrhev
			},
			'egrhevconfig button[id="ClearBTN"]': {
				'click': this.clearRhev
			},
			'egrhevconfig button[id="UpdateBTN"]': {
				'click': this.updateRhev
			},
			'egrhevconfig' : {
				'beforeclose': this.callRhevDestroy
			},
			'egvcconfig scrollcombo[id="SslVc"]': {
				'select': this.combosslVc
			},
			'egvcconfig button[id="ClearBTN"]': {
				'click': this.clearVc
			},
			'egvcconfig button[id="UpdateBTN"]': {
				'click': this.updateVc
			},
			'egvcconfig' : {
				'beforeclose': this.callVcDestroy
			},
			'egxmsconfig' : {
				'beforeclose': this.callXMSDestroy
			},
			'egnutconfig button[id="ClearBTN"]': {
				'click': this.clearNut
			},
			'egnutconfig button[id="UpdateBTN"]': {
				'click': this.updateNut
			},
			'egnutconfig' : {
				'beforeclose': this.callNutDestroy
			},
			'eghmcconfig button[id="ClearBTN"]': {
				'click': this.clearHmc
			},
			'eghmcconfig button[id="UpdateBTN"]': {
				'click': this.updateHmc
			},
			'eghmcconfig': {
				'beforeclose': this.callHmcDestroy
			},
			'egconfigureurlandcredentials button[id="addCredUrlbtn"]': {
				'click': this.addCredUrls
			},
			'egconfigureurlandcredentials button[id="clearCredUrl"]': {
				'click': this.clearCredUrls
			},
			'egconfigureurlandcredentials button[id="updateCredUrl"]': {
				'click': this.updateCredUrls
			},
					//Targets starts
			'EgConfigureTargetsAndSysProps button[id="addTgtUrlbtn"]': {
				'click': this.addTrgtUrls
			},
			'EgConfigureTargetsAndSysProps button[id="clearTgtUrl"]': {
				'click': this.clearTrgtUrls
			},
			'EgConfigureTargetsAndSysProps button[id="updateTgtUrl"]': {
				'click': this.updateTrgtUrls
			},
					//Targets ends
			'egconfigurewinsharedfolders button[id="addwinsharedbtn"]': {
				'click': this.addWinShared
			},
			'egconfigurewinsharedfolders button[id="clearWinShared"]': {
				'click': this.clearWinShareds
			},
			'egconfigurewinsharedfolders button[id="updateWinShared"]': {
				'click': this.updateWinShareds
			},
			'egconfiguremultipleusers button[id="addMultiUsrbtn"]': {
				'click': this.addMultiUsr
			},
			'egconfiguremultipleusers button[id="clearMultiConfUsr"]': {
				'click': this.ClearMultiConfigUsrs
			},
			'egconfiguremultipleusers button[id="updateMultiConfUsr"]': {
				'click': this.UpdateMultiConfigUsrs
			},
			'egconfigurepublishedresources button[id="addMultiSrcbtn"]': {
				'click': this.addMultiSource
			},
			'egconfigurepublishedresources button[id="clearMultiConfSrc"]': {
				'click': this.ClearMultiConfigSource
			},
			'egconfigurepublishedresources button[id="updateMultiConfSrc"]': {
				'click': this.UpdateMultiConfigSource
			},
			'egconfigurenamepattern button[id="addUrlNamebtn"]': {
				'click': this.addUrlNames
			},
			'egconfigurenamepattern button[id="clearUrlPattern"]': {
				'click': this.clearUrlNames
			},
			'egconfigurenamepattern button[id="updateUrlPattern"]': {
				'click': this.updateUrlNames
			},
			'vmgusers button[id="addVmgUsrbtn"]': {
				'click': this.addVmgUsr
			},
			'vmgusers button[id="clearConfUsr"]': {
				'click': this.ClearConfigUsrs
			},
			'vmgusers button[id="updateConfUsr"]': {
				'click': this.UpdateConfigUsrs
			},
			'EgOidsValue button[id="addOidbtn"]': {
				'click': this.addOid
			},
			'EgOidsValue button[id="clearOid"]': {
				'click': this.ClearOid
			},
			'EgOidsValue button[id="updateOid"]': {
				'click': this.UpdateOid
			},
			'egconfigurewsdlurlandcredentials button[id="addWsdlUrlbtn"]': {
				'click': this.addWsdlUrl
			},
			'egconfigurewsdlurlandcredentials button[id="clearWsdlUrl"]': {
				'click': this.clearWsdlUrls
			},
			'egconfigurewsdlurlandcredentials button[id="updateWsdlUrl"]': {
				'click': this.updateWsdlUrls
			},
			'processconfiguration trigger[id="processSearchTrigger"]': {
				'change': this.processSearch
			},
			'processconfiguration button[id="addProcessConfbtn"]': {
				'click': this.addProcess
			},
			'processconfiguration button[id="updateProcessPatt"]': {
				'click': this.updateProcessPattern
			},
			'processconfiguration button[id="clearProcessPatt"]': {
				'click': this.clearProcessPattern
			},
			'processconfiguration button[id="getProcess"]': {
				'click': this.getProcessPattern
			},
			'processconfiguration' : {
				'beforeclose': this.callProcessDestroy
			},
			'businesstransactionnaming button[id="addNewRulebtn"]': {
				'click': this.resultPanelCreateRuleForm
			},
			'businesstransactionnaming button[id="createRule"]': {
				'click': this.saveOrUpdateRule
			},
			'businesstransactionnaming': {
				'beforeclose': this.callRulesDestroy
			},
			'businesstransactionrulegrid button[id="updateSpecificConfig"]': {
				'click': this.getRuleNamesFromIni
			},
			'BusinessTransactionContext button[id="addNewRulebtn"]': {
				'click': this.resultPanelCreateContextRuleForm
			},
			'BusinessTransactionContext button[id="createContextRule"]': {
				'click': this.saveOrUpdateContextRule
			},
			'BusinessTransactionContext': {
				'beforeclose': this.callRulesDestroy
			},
			'BusinessTransactionContextRuleGrid button[id="updateSpecificConfig"]': {
				'click': this.getContextRuleNamesFromIni
			},
			//			'businesstransactionnaming combo[id="urlsegment_1_1"]': {
			//'change': this.changeUrlSegments
			//},


			'processconciseconfiguration button[id="processConcisebtn"]': {
				'click': this.getDetailedPattern
			},
			'processconciseconfiguration button[id="processDetailedbtn"]': {
				'click': this.getConcisePattern
			},
			'processconciseconfiguration button[id="submitProcessConc"]': {
				'click': this.submitProcess
			},
			'winservicesconfiguration' : {
				'beforeclose': this.callServiceDestroy
			},
			'winservicesconfiguration button[id="addServiceConfbtn"]': {
				'click': this.addService
			},
			'winservicesconfiguration button[id="getService"]': {
				'click': this.getService
			},
			'winservicesconfiguration button[id="updateService"]': {
				'click': this.updateService
			},
			'winservicesconfiguration trigger[id="winServiceSearchTrigger"]': {
				'change': this.winServiceSearch
			},
			'servicedetailedconfiguration button[id="submitServiceDet"]': {
				'click': this.submitservice
			},
			'minmaxvalues button[id="updateMinMaxValues"]': {
				'click': this.updateService_pr
			},
			'egdbusercreation combo[id="dbversion"]': {
				'select': this.comboVersion
			},
			'egdbusercreation button[id="ClearBTN"]': {
				'click': this.clearDb
			},
			'egdbusercreation button[id="AddBTN"]': {
				'click': this.AddNewDb
			},
			'egdbusercreation button[id="ApplyBTN"]': {
				'click': this.ApplyNewDb
			},
			'egconfigaggregate button[id="UpdateBTN"]': {
				'click': this.updateAggregate
			},
			'egconfigcomposite button[id="UpdateBTN"]': {
				'click': this.updateComposite
			},
//			'servicedetailedconfiguration button[id="submitServiceDet"]': {
//				'click': this.submitservice
//			},
			'egconfiginfos button[id="addConfigInfos"]': {
				'click': this.addconfigureConfigInfos
			},
			'egconfiginfoscreation button[id="updateInfosGroups"]': {
				'click': this.updateConfigInfoss
			},
			'egconfiginfoscreation checkbox[id="applyAllCheck"]': {
				'change': this.applyAllCheckMainEvent
			},
			'egconfigejb button[id="addConfigEjbs"]': {
				'click': this.mainAddNewConfigEjbs
			},
			'egconfigejbscreation button[id="updateEjbsGroups"]': {
				'click': this.updateConfigEjbss
			},
			'egwebserviceconfiguration combo[id="wsdlUrl"]': {
				'select': this.selectUrlValue
			},
			'egwebserviceconfiguration scrollcombo[id="wsdlService"]': {
				'select': this.selectServices
			},
			//'egwebserviceconfiguration multiselect[id="wsdlOperation"]': {
				//'change': this.changeElement
			//},
			//'egwebserviceconfiguration multiselect[id="add"]': {
				//'click': this.changeElement
			//},
			'egwebserviceconfiguration button[id="ConfigureBTN"]': {
				'click': this.configoperations
			},
			//'egwebserviceconfiguration radio[id="xmlview"]': {
				//'change': this.radXmlHtml
			//},
			'egwebserviceconfiguration tabpanel[id="xmlandhtmlview"]':
			{
				'tabchange': this.radXmlHtmlMain
			},
			'egwebserviceconfiguration button[id="save"]': {
				'click': this.saveWebConfigure
			},
			'egwebserviceconfiguration button[id="sendReq"]': {
				'click': this.sendRequestWebConfigure
			},
			'viewpolicy trigger[id="searchTrigger"]': {
				'change': this.policyMainSearch
			},
			'viewpolicy button[id="addPolicy"]': {
				'click': this.policyCreationMainPage
			},
			'egpolicycreation button[id="updatePolicy"]': {
				'click': this.policyMainValidate
			},
			'egpolicycreation button[id="viewsource"]': {
				'click': this.openMainWindow
			},
			'egpolicycreation button[id="viewid"]': {
				'click': this.openMainWindow
			},
			'egpolicycreation button[id="viewdesc"]': {
				'click': this.openMainWindow
			},
			'egdetailstest button[id="updateDescriptor"]': {
				'click': this.updateDescriptor
			},
			'egdetailstest' : {
				'beforeclose': this.callDescDestroy
			},
			'sitedetailedconfiguration button[id="sitename_update"]': {
				'click': this.getPopupSitename
			},
			'processconciseconfiguration trigger[id="processViewSearchTrigger"]':{
				'change': this.processViewSearch
			},
			'servicedetailedconfiguration trigger[id="winServiceViewSearchTrigger"]':{
				'change': this.winServiceViewSearch
			}
		});
	},
	snmpUtilityShow: function() {
		this.getController('SpecificTestConfiguration.controller.FunctionController').snmpUtilityShow();
	},
	showUnconfigCompTypes: function() {
		availPolicies = "";
		var isShowUnconfigEventFirstCall = Ext.getCmp('unconfiguredCompType').dataArray;
		if (!isShowUnconfigEventFirstCall)
		{
			Ext.getCmp('unconfiguredCompType').dataArray = false;
			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var cType = Ext.getCmp('componentType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

			var urlVal = 'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?showUnconfigCompType='+showUnconfigCompType;
			var gridVisible = Ext.getCmp('agentDetailsGrid');
			var unconfigTestsStore = Ext.getCmp('unconfigTests').getStore();
			var configTestsStore = Ext.getCmp('configTests').getStore();
			var excludeTestsStore = Ext.getCmp('excludeTests').getStore();
			if (gridVisible.isVisible())
			{
				gridVisible.hide();
			}
			if (unconfigTestsStore.getCount() > 0)
			{
				Ext.getCmp('unconfigTests').getStore().removeAll();
			}
			if (configTestsStore.getCount() > 0)
			{
				Ext.getCmp('configTests').getStore().removeAll();
			}
			if (excludeTestsStore.getCount() > 0)
			{
				Ext.getCmp('excludeTests').getStore().removeAll();
			}
			if (Ext.getCmp('noAgentMsgContainer').isVisible())
			{
				Ext.getCmp('noAgentMsgContainer').hide();
			}
			if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
			{
				Ext.getCmp('paramsContainer').removeAll();
				Ext.getCmp('paramsContainer').hide();
				Ext.getCmp('updateBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').hide();
				Ext.getCmp('validateBtn').setDisabled(true);
				Ext.getCmp('validateBtn').hide();
				Ext.getCmp('snmpUtil').setDisabled(true);
				Ext.getCmp('snmpUtil').hide();
				Ext.getCmp('bottomToolBar').hide();
			}

			compType = '';
			compName = '';
			testType = 'PerformanceTest';
			testName = '';
			clickedFrom = '';
			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				scope:this,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						hide_process_service_button=publicJson['isContainerApp'];
						var allCompAccess = publicJson['allCompAccess'];
						if (!allCompAccess)
						{
							Ext.getCmp('enableDisableBtn').hide();

						}
						else
						{
							Ext.getCmp('enableDisableBtn').show();
							Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
						}

						Ext.getCmp('componentType').getStore().removeAll();
						Ext.getCmp('componentType').getStore().loadRawData(publicJson['compTypeArr']);
						Ext.getCmp('componentType').setValue(publicJson['compTypeArr'][0].valueField);
						Ext.getCmp('componentName').getStore().removeAll();
						Ext.getCmp('componentName').getStore().loadRawData(publicJson['compNameArr']);
						Ext.getCmp('componentName').setValue(publicJson['compNameArr'][0].valueField);

						if (!Ext.isEmpty(testType))
						{
							Ext.getCmp('testType').setValue(testType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}
				}
			});
		}
	},
	policyDel: function(server,test,policy,log,show,q,logtype,flag,requestFrom)
	{
		var currentLogType = Ext.getCmp("logType").getValue();
		var confirmMsg;
		if(flag == "no")
		{
			confirmMsg = alertMsg11+" '"+policy+"' "+alertMsg12+'. '+alertMsg13+"?";
		}
		else
		{
			confirmMsg = alertMsg14+" '"+policy+"' ?";
		}

		Ext.Msg.show({
			title: pageName,
			msg: confirmMsg,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					if (Ext.isEmpty(deletedRecords) || deletedRecords == '')
					{
						deletedRecords = policy;
					}
					else
					{
						deletedRecords += ','+policy;
					}
					urlVal = "SpecificTestConfiguration/data/ViewPolicyJson.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&delpolicy=yes&log_type="+log+"&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom+"&currentLogType="+currentLogType;
					Ext.Ajax.request({
						url:urlVal,
						method:'post',
						scope:this,
						success:function(response)
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = response.responseText;
								var policyJsonObj = Ext.decode(jsonText);
								Ext.getCmp('EventsViewGrid').getStore().removeAll();
								Ext.getCmp('EventsViewGrid').getStore().loadRawData(policyJsonObj['gridDataArr']);
							}
						}
					});
				}
			}
		});

		//if(con)
		//{
			//window.location.href = "ViewPolicy.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&delpolicy=yes&log_type="+log+"&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom;
		//}
		//else
		//{
			//window.location.href = "ViewPolicy.jsp?server="+server+"&test="+test+"&policy="+encodeURI(policy)+"&log_type="+log+"&delpolicy=no&showAll="+show+"&q="+q+"&logtype="+logtype+"&requestFrom="+requestFrom;
		//}
	},
	handleEjbDeleteIconClick: function(gridView, row, col){
		var task = Ext.getCmp('EjbsViewGrid').getStore().getAt(row);
		this.getController('SpecificTestConfiguration.controller.IntermediateController').deleteEjbWindow(task);
	},
	handleInfoDeleteIconClick: function(gridView, row, col){
		var task = Ext.getCmp('InfosViewGrid').getStore().getAt(row);
		this.getController('SpecificTestConfiguration.controller.IntermediateController').deleteInfoWindow(task);
	},

	handleInfoEditIconClick: function(view, rowIndex, colIndex, column, e) {
		var task = Ext.getCmp('InfosViewGrid').getStore().getAt(rowIndex);
		this.getController('SpecificTestConfiguration.controller.IntermediateController').showEditInfoWindow(task);
    },
	handleEjbEditIconClick: function(view, rowIndex, colIndex, column, e) {
		var task = Ext.getCmp('EjbsViewGrid').getStore().getAt(rowIndex);
		this.getController('SpecificTestConfiguration.controller.IntermediateController').showEditEjbWindow(task);
    },
	checkURLAndCredentials: function (paramValue) {
		var v_url='';
		var urlObj =Ext.getCmp('url');
		var wsdlUrlName = publicJson.originalParamNameObj['WSDL_URL'];
		var wsdlUrlObj =Ext.getCmp(wsdlUrlName);
		if(!Ext.isEmpty(urlObj) && urlObj != undefined)
		{
			v_url = urlObj.getValue();
		}
		else if(!Ext.isEmpty(wsdlUrlObj) && wsdlUrlObj != undefined)
		{
			v_url = wsdlUrlObj.getValue();
		}
		var v_cred = publicJson['hiddenObj']['credentials'];
		var arrURL = v_url.split(",");
		var arrCred = v_cred.split(",");
		if (arrURL.length != arrCred.length && plusButtonClicked == "false")
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg7+' '+alertMsg69,
				icon:'iconExclamation',
				buttons: Ext.Msg.OK,
				fn: function(){
					if(!Ext.isEmpty(urlObj) && urlObj != undefined)
					{
						urlObj.setValue(paramValue);
						urlObj.focus(true);
					}
					else if(!Ext.isEmpty(wsdlUrlObj) && wsdlUrlObj != undefined)
					{
						wsdlUrlObj.setValue(paramValue);
						wsdlUrlObj.focus(true);
					}
				}
			});
			return false;
		}
	},
	checkMultipleNamePattern: function (paramName,paramValue) {
		var paramValue = publicJson['multiUserOrNameParamValue'+paramName];
		var multiName = "false";

		if (paramName.toLowerCase() == "name")
		{
			var nameValue = Ext.getCmp('name').getValue();
			if (nameValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			var patternValue = Ext.getCmp('pattern').getValue();
			if (patternValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			var thresholdValue = Ext.getCmp('threshold_value').getValue();
			if (thresholdValue.indexOf(",") > -1)
			{
				multiName = "true";
			}
		}

		if (multiName == "true")
		{
			var orginalPatternValue = "";
			var orginalNameValue = "";
			var orginalThresholdValue = "";
			if (plusButtonClicked == "true")
			{
				if (paramName.toLowerCase() == "pattern")
				{
					var patternValue = Ext.getCmp('pattern').getValue();
					if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
					{
						orginalPatternValue = newPatternValue;
					}
				}
				else if (paramName.toLowerCase() == "name")
				{
					var nameValue = Ext.getCmp('name').getValue();
					if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
					{
						orginalNameValue = newNameValue;
					}
				}
				else if (paramName.toLowerCase() == "threshold_value")
				{
					var thresholdValue = Ext.getCmp('threshold_value').getValue();
					if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
					{
						orginalThresholdValue = newThresholdValue;
					}
				}
			}
			else
			{
				if (paramName.toLowerCase() == "pattern")
				{
					var patternValue = Ext.getCmp('pattern').getValue();
					if (patternValue != paramValue && patternValue.indexOf(",") > -1)
					{
						orginalPatternValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "threshold_value")
				{
					var thresholdValue = Ext.getCmp('threshold_value').getValue();
					if (thresholdValue != paramValue && thresholdValue.indexOf(",") > -1)
					{
						orginalthresholdValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "name")
				{
					var nameValue = Ext.getCmp('name').getValue();
					if (nameValue != paramValue && nameValue.indexOf(",") > -1)
					{
						orginalNameValue = nameValue;
					}
				}
			}

			if (paramName.toLowerCase() == "name")
			{
				var nameValue = Ext.getCmp('name').getValue();
				var testname = publicJson['testName'];
				if (nameValue != newNameValue && nameValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testname == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('name').setValue(changedNameValue.substring(0,changedNameValue.indexOf(",")));
									Ext.getCmp('name').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('name').setValue(changedNameValue.substring(0,changedNameValue.indexOf(",")));
								Ext.getCmp('name').focus(true);
							}
						});
					}
					//tempField = thisForm.name;
					//setTimeout("tempField.focus()",0);
					return false;
				}
			}
			else if (paramName.toLowerCase() == "pattern")
			{
				var patternValue = Ext.getCmp('pattern').getValue();
				var testname = publicJson['testName'];

				if (patternValue != newPatternValue && patternValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testname == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('pattern').setValue(changedPatternValue.substring(0,changedPatternValue.indexOf(",")));
									Ext.getCmp('pattern').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('pattern').setValue(changedPatternValue.substring(0,changedPatternValue.indexOf(",")));
								Ext.getCmp('pattern').focus(true);
							}
						});
					}
					//tempField = thisForm.pattern;
					//setTimeout("tempField.focus()",0);
					return false;
				}
			}
			else if (paramName.toLowerCase() == "threshold_value")
			{
				var thresholdValue = Ext.getCmp('threshold_value').getValue();
				var testname = publicJson['testName'];

				if (thresholdValue != newThresholdValue && thresholdValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testname) != null && testname != undefined)
					{
						if (testName == "SlowTransTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg10,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('threshold_value').setValue(changedThresholdValue.substring(0,changedThresholdValue.indexOf(",")));
									Ext.getCmp('threshold_value').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg10,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('threshold_value').focus(true);
								Ext.getCmp('threshold_value').setValue(changedThresholdValue.substring(0,changedThresholdValue.indexOf(",")));
							}
						});
					}
					//tempField = thisForm.threshold_value;
					//setTimeout("tempField.focus()",0);
					return false;
				}
			}
		}
	},
	getNamePatternValue: function (paramName) {
		if (paramName.toLowerCase() == "name")
		{
			newNameValue = Ext.getCmp('name').getValue();
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			newPatternValue = Ext.getCmp('pattern').getValue();
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			newThresholdValue = Ext.getCmp('threshold_value').getValue();
		}
	},
	getNamePatternChangedValue: function (paramName) {
		if (paramName.toLowerCase() == "name")
		{
			changedNameValue = Ext.getCmp('name').getValue();
		}
		else if (paramName.toLowerCase() == "pattern")
		{
			changedPatternValue =  Ext.getCmp('pattern').getValue();
		}
		else if (paramName.toLowerCase() == "threshold_value")
		{
			changedThresholdValue =  Ext.getCmp('threshold_value').getValue();
		}
	},
	getUserValue: function(paramName) {
		if (paramName.toLowerCase() == "domain")
		{
			newDomainValue = Ext.getCmp('domain').getValue();
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			newAdminUserValue = Ext.getCmp('admin_user').getValue();
		}
		else if (paramName.toLowerCase() == "user")
		{
			newUserValue = Ext.getCmp('user').getValue();
		}
	},
	getUserChangedValue: function(paramName) {
		if (paramName.toLowerCase() == "domain")
		{
			changedDomainValue = Ext.getCmp('domain').getValue();
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			changedAdminUserValue =  Ext.getCmp('admin_user').getValue();
		}
		else if (paramName.toLowerCase() == "user")
		{
			changedUserValue = Ext.getCmp('user').getValue();
		}
	},
	checkMultipleUser: function(paramName,paramValue) {
		var paramValue = publicJson['multiUserOrNameParamValue'+paramName];
		var multiUser = "false";
		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = Ext.getCmp('domain').getValue();
			if (domainValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue =  Ext.getCmp('admin_user').getValue();
			if (adminUserValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue =  Ext.getCmp('user').getValue();
			if (userValue.indexOf(",") > -1)
			{
				multiUser = "true";
			}
		}

		if (multiUser == "true")
		{
			var orginalDomainValue = "";
			var orginalUserValue = "";
			if (plusButtonClicked == "true")
			{
				if (paramName.toLowerCase() == "domain")
				{
					var domainValue = Ext.getCmp('domain').getValue();
					if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
					{
						orginalDomainValue = newDomainValue;
					}
				}
				else if (paramName.toLowerCase() == "admin_user")
				{
					var adminUserValue = Ext.getCmp('admin_user').getValue();
					if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
					{
						orginalUserValue = newAdminUserValue;
					}
				}
				else if (paramName.toLowerCase() == "user")
				{
					var userValue =  Ext.getCmp('user').getValue();
					if (userValue != newUserValue && userValue.indexOf(",") > -1)
					{
						orginalUserValue = newUserValue;
					}
				}
			}
			else
			{
				if (paramName.toLowerCase() == "domain")
				{
					var domainValue = Ext.getCmp('domain').getValue();
					if (domainValue != paramValue && domainValue.indexOf(",") > -1)
					{
						orginalDomainValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "admin_user")
				{
					var adminUserValue =  Ext.getCmp('admin_user').getValue();
					if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
					{
						orginalUserValue = paramValue;
					}
				}
				else if (paramName.toLowerCase() == "user")
				{
					var userValue = Ext.getCmp('user').getValue();
					if (userValue != paramValue && userValue.indexOf(",") > -1)
					{
						orginalUserValue = paramValue;
					}
				}
			}

			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = Ext.getCmp('domain').getValue();
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					if (!Ext.isEmpty(testName) && testName != undefined)
					{
						if (testName == "CtxAuthTest" ||
							testName == "WinAuthTest" ||
							testName == "TermAuthTest")
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg9,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
									Ext.getCmp('domain').focus(true);
								}
							});
						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg:alertMsg7+' '+alertMsg9,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function(){
									Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
									Ext.getCmp('domain').focus(true);
								}
							});
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg:alertMsg7+' '+alertMsg9,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function(){
								Ext.getCmp('domain').setValue(changedDomainValue.substring(0,changedDomainValue.indexOf(",")));
								Ext.getCmp('domain').focus(true);
							}
						});
					}
					return false;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = Ext.getCmp('admin_user').getValue();
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg:alertMsg7+' '+alertMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('admin_user').setValue(changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(",")));
							Ext.getCmp('admin_user').focus(true);
						}
					});
					return false;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue =  Ext.getCmp('user').getValue();
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg:alertMsg7+' '+alertMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('user').setValue(changedUserValue.substring(0,changedUserValue.indexOf(",")));
							Ext.getCmp('user').focus(true);
						}
					});
					return false;
				}
			}
		}
	},
	clickToExternalPage: function() 
	{
		var urlLink = publicJson['externalPageLink'];
		var isAggregateTest = publicJson['isAggregateTest'];
		var isCompositeTest = publicJson['isCompositeTest'];
		var isViewPolicy = publicJson['viewPolicy'];
		var isOracleDatabaseCompType = publicJson['isOracleDatabaseCompType'];
		var destinationPage = publicJson['destinationPage'];
		var vmgUsersPage = publicJson['vmgUsersPage'];
		var configurenamePattern = publicJson['configurenamePattern'];
		var configurlcredentials = publicJson['configurlcredentials'];
		var isEjbGroup = publicJson['isEjbGroup'];
		var vCTasks = publicJson['VcTasks'];
		var vCEvents = publicJson['VcEvents'];

		if ((publicJson['testName'] == 'OraEjbTest') || (isEjbGroup == "EgConfigEjb.jsp"))
		{
			testViews.configEjb();
		}
		else if (isAggregateTest)
		{
			testViews.configAggregate();
		}
		else if (isCompositeTest)
		{
			testViews.configComposite();
		}
		else if (isViewPolicy == 'true')
		{
			testViews.configViewPolicy();
		}
		else if (isOracleDatabaseCompType == 'true')
		{
			testViews.configDbCreation();
		}
		else if (vmgUsersPage == 'true')
		{
			testViews.vmgusers();
		}
		else if (destinationPage == 'EgConfigureMultipleUsers.jsp')
		{
			testViews.configMultiUsers();
		}
		else if (destinationPage == 'VmgUsers.jsp')
		{
			testViews.vmgusers();
		}
		else if (destinationPage == 'EgConfigureNamePattern.jsp')
		{
			testViews.configurlnamepattern();
		}
		else if (configurenamePattern == "true")
		{
			testViews.configurlnamepattern();
		}
		else if (configurlcredentials == "true")
		{
			testViews.configCerdentialurl();
		}
		else if (isEjbGroup == "EgConfigInfos.jsp")
		{
			testViews.configInfos();
		}
		else if (vCTasks == "true")
		{
			testViews.configVcTasks();
		}
		else if (vCEvents == "true")
		{
			testViews.configVcEvents();
		}
	},
	clickToEnableCorrectiveScripts: function()
	{
		var displayTestName = publicJson['displayTestName'];
		var specificTestArr = publicJson['specificTestArr'];
		var ctype = publicJson['componentType'];
		var tname = publicJson['testName'];
		var alertMsg = alertMsgEnableCs +' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs3+' '+alertMsgCs4; 
		if (specificTestArr !=null && specificTestArr !=undefined && specificTestArr.length > 0)
		{
			for (var x=0; x<specificTestArr.length; x++)
			{
				var specificTest = specificTestArr[x];
				if (specificTest == tname)
				{
					alertMsg = alertMsgEnableCs+' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs4;
				}
			}
		}
		Ext.Msg.show(
			{
				title: enableCsTitle,
				msg: alertMsg,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(btn) 
				{
					if (btn == 'yes')
					{
						var paramsContainerPage = Ext.getCmp('paramsContainer');
						var myMask = new Ext.LoadMask(paramsContainerPage, {msg:'Loading...'});
						myMask.show();

						Ext.Ajax.request({
							url:'SpecificTestConfiguration/data/EgEnableCorrectiveScriptspJson.jsp?componentType='+encodeURIComponent(ctype)+'&testName='+encodeURIComponent(tname)+'&reqFrom=enableCsLink',
							method:'POST',
							timeout: 900000,
							success:function(response)
							{
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									publicJson = Ext.decode(jsonText);
									var requestStatus = publicJson['requestStatus'];
									if (!Ext.isEmpty(requestStatus) && requestStatus != undefined)
									{
										
										myMask.hide();
										Ext.Msg.show({
											title: enableCsTitle,
											msg: alertMsgCsSuccess1,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function()
											{
												if (!Ext.isEmpty(enableCsClickedFrom) && enableCsClickedFrom == 'configurebutton')
												{
													me.configureUnconfiguredTest();
												}
												if (!Ext.isEmpty(enableCsClickedFrom) && enableCsClickedFrom == 'reconfigurebutton')
												{
													me.configureReconfiguredTest();
												}
											}
										});
									}
								}
							}
						});
					}
				}
			}
		);
	},

	clickToDisableCorrectiveScripts: function()
	{
		var displayTestName = publicJson['displayTestName'];
		var specificTestArr = publicJson['specificTestArr'];
		var ctype = publicJson['componentType'];
		var tname = publicJson['testName'];
		var alertMsg = alertMsgDisableCs +' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs3+' '+alertMsgCs4; 
		if (specificTestArr !=null && specificTestArr !=undefined && specificTestArr.length > 0)
		{
			for (var x=0; x<specificTestArr.length; x++)
			{
				var specificTest = specificTestArr[x];
				if (specificTest == tname)
				{
					alertMsg = alertMsgDisableCs+' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs4;
				}
			}
		}
		Ext.Msg.show(
			{
				title: disableCsTitle,
				msg: alertMsg,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(btn) 
				{
					if (btn == 'yes')
					{
						
						var paramsContainerPage = Ext.getCmp('paramsContainer');
						var myMask = new Ext.LoadMask(paramsContainerPage, {msg:'Loading...'});
						myMask.show();

						Ext.Ajax.request({
							url:'SpecificTestConfiguration/data/EgEnableCorrectiveScriptspJson.jsp?componentType='+encodeURIComponent(ctype)+'&testName='+encodeURIComponent(tname)+'&reqFrom=disableCsLink',
							method:'POST',
							timeout: 900000,
							success:function(response)
							{
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									publicJson = Ext.decode(jsonText);
									var requestStatus = publicJson['requestStatus'];
									if (!Ext.isEmpty(requestStatus) && requestStatus != undefined)
									{
										myMask.hide();
										Ext.Msg.show({
											title: disableCsTitle,
											msg: alertMsgCsSuccess2,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function()
											{
												if (!Ext.isEmpty(enableCsClickedFrom) && enableCsClickedFrom == 'configurebutton')
												{
													me.configureUnconfiguredTest();
												}
												if (!Ext.isEmpty(enableCsClickedFrom) && enableCsClickedFrom == 'reconfigurebutton')
												{
													me.configureReconfiguredTest();
												}
											}
										});
									}
								}
							}
						});
					}
				}
			}
		);
	},
	clickToVmLogDisplay: function() {
		var viewVmLink = publicJson['viewVmLink'];
		if (!Ext.isEmpty(viewVmLink) && viewVmLink != undefined)
		{
			testViews.vmLogDisplay();
		}
	},
	backToTestConfiguration: function() {
		var homepage = Ext.getCmp('specificTestConfigViewPort');
		myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'testconfiguration' });
		myMask.hide();
	},
	applyBackBtnEvent: function() {
		fromApplyBck = "true";
		var homepage = Ext.getCmp('specificTestConfigViewPort');
		myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'testconfiguration' });
		myMask.hide();
	},
	applyIncludeComponents: function() {
		var excludeItemSelectObj = Ext.getCmp('includeItemSelector');
		var managedComponentLen = excludeItemSelectObj.fromField.store.getCount();

		var alertMsg = alertMsg74;
		if (!Ext.isEmpty(excludeItemSelectObj) && excludeItemSelectObj != undefined && managedComponentLen > 1)
		{
			alertMsg = alertMsg75;
		}
		if (managedComponentLen==0)
		{
			Ext.Msg.show({
				title: pageName,
				msg:alertMsg6,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return false;
		}

		var selectedComponents = "";
		for (var i=0; i<managedComponentLen; i++)
		{
			var compVal = excludeItemSelectObj.fromField.store.getAt(i).get('valueField');
			if (selectedComponents!="")
			{
				selectedComponents = selectedComponents + ",";
			}
			selectedComponents = selectedComponents + compVal;
		}

		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}

		var includeFormObj = this.getIncludecomponents().getForm();
		if (includeFormObj.isValid())
		{
			var hiddenFieldsQStr = this.getHiddenFields('hiddenObjIncludePage');
			var params = hiddenFieldsQStr;
			var urlForInclude = "SpecificTestConfiguration/data/EgIncludeComponentTestsJson.jsp?"+params;

			Ext.getCmp('componentName').setValue(selectedComponents);
			//Ext.getCmp('TestsForInclusion').setValue(selectedComponents);

			this.getIncludecomponents().submit({
				url: urlForInclude,
				method: 'POST',
				timeout: 9000,
				success: function(form, action)
				{
					var jsonText = Ext.decode(action.response.responseText);
					if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) && jsonText.success)
					{
						mask.hide();
						Ext.Msg.show({
							title:pageName,
							msg: alertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('componentName').setValue('');
								unconfigCompChecked = '';
								reqFrom = '';
								var homepage = Ext.getCmp('specificTestConfigViewPort');
								var backBtnFrom = Ext.getCmp('includeViewForm').isBackButton;

								if (!Ext.isEmpty(backBtnFrom))
								{
									reqFrom = backBtnFrom;
								}
								else
								{
									reqFrom = '';
								}
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'testconfiguration' });
								myMask.hide();
							}
						});
					}
				},
				failure: function(form, action)
				{
					var jsonText = Ext.decode(action.response.responseText);
					Ext.getCmp('componentName').setValue('');
					mask.hide();
					if(jsonText.success)
					{
						unconfigCompChecked = '';
						reqFrom = '';
						var homepage = Ext.getCmp('specificTestConfigViewPort');
						myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
						homepage.removeAll();
						myMask.show();
						homepage.add({ xtype : 'testconfiguration' });
						myMask.hide();
					}
				}
			});
		}
	},
	afterIncludeComponentsMainRender: function() {
		Ext.Ajax.request({
			url: includeTestsURL,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText))
				{
					publicJson = Ext.decode(jsonText);
					var selectedTestsArr = publicJson['selectedTestsArr'];
					var excludeComponentsArr = publicJson['excludeComponentsArr'];
					var includeComponentsArr = publicJson['includeComponentsArr'];
					var fieldSetTitle = publicJson['fieldTitleComponentType'];
					unconfigCompChecked = publicJson['showUnconfigCompType'];

					if (!Ext.isEmpty(selectedTestsArr) && selectedTestsArr != undefined)
					{
						Ext.getCmp('selectedIncludeTestGrid').getStore().loadRawData(selectedTestsArr);
					}

					if (!Ext.isEmpty(fieldSetTitle))
					{
						Ext.getCmp('includeCompFieldSet').setTitle(fieldSetTitle);
					}
					var includeItemSelectorObj = Ext.getCmp('includeItemSelector');
					if (includeItemSelectorObj.fromField.store.getCount() >= 1)
					{
						includeItemSelectorObj.fromField.store.removeAll();
					}
					if (includeItemSelectorObj.toField.store.getCount() >= 1)
					{
						includeItemSelectorObj.toField.store.removeAll();
					}
					//serversItemSelectorsObj.fromField.store.add(publicJSON['ManagedHostByThisAgent']);
					if (!Ext.isEmpty(excludeComponentsArr) && excludeComponentsArr != undefined)
					{
						includeItemSelectorObj.toField.store.add(excludeComponentsArr);
					}
					if (!Ext.isEmpty(includeComponentsArr) && includeComponentsArr != undefined)
					{
						includeItemSelectorObj.fromField.store.add(includeComponentsArr);
					}
				}
			}
		});
	},
	getHiddenFields : function(hiddenObj) {
		var hiddenFields = publicJson[hiddenObj];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	applyExcludeComponents: function() {
		var excludeItemSelectObj = Ext.getCmp('excludeItemSelector');
		var managedComponentLen = excludeItemSelectObj.fromField.store.getCount();
		var enableConfTestSize = publicJson['hiddenObjExcludePage']['enableConfTestSize'];
		var testsForExclusion = publicJson['hiddenObjExcludePage']['TestsForExclusion'];
		var alertMsg = alertMsg76;
		if (!Ext.isEmpty(testsForExclusion) && testsForExclusion != undefined )
		{
			var testsCount = testsForExclusion.split(',');
			if (!Ext.isEmpty(testsCount) && testsCount != undefined && testsCount.length > 1)
			{
				alertMsg = alertMsg77;
			}
		}
		if (managedComponentLen==0)
		{
			Ext.Msg.show({
				title: pageName,
				msg:alertMsg6,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return false;
		}

		var selectedComponents = "";
		for (var i=0; i<managedComponentLen; i++)
		{
			var compVal = excludeItemSelectObj.fromField.store.getAt(i).get('valueField');
			if (selectedComponents!="")
			{
				selectedComponents = selectedComponents + ",";
			}
			selectedComponents = selectedComponents + compVal;
		}

		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
		var excludeFormObj = this.getExcludecomponents().getForm();
		if (excludeFormObj.isValid())
		{
			var hiddenFieldsQStr = this.getHiddenFields('hiddenObjExcludePage');
			var params = hiddenFieldsQStr+'enableConfTestSize='+enableConfTestSize;
			var urlForExclude = "SpecificTestConfiguration/data/EgExcludeComponentTestsJson.jsp?"+params;

			Ext.getCmp('componentName').setValue(selectedComponents);
			this.getExcludecomponents().submit({
				url: urlForExclude,
				method: 'POST',
				timeout: 9000,
				success: function(form, action)
				{
					var jsonText = Ext.decode(action.response.responseText);
					if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) && jsonText.success)
					{
						mask.hide();
						Ext.Msg.show({
							title:pageName,
							msg: alertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('componentName').setValue('');
								unconfigCompChecked = '';
								reqFrom = '';
								var homepage = Ext.getCmp('specificTestConfigViewPort');
								var backBtnFrom = Ext.getCmp('excludeViewForm').isBackButton;
								if (!Ext.isEmpty(backBtnFrom))
								{
									reqFrom = backBtnFrom;
								}
								else
								{
									reqFrom = '';
								}
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'testconfiguration' });
								myMask.hide();
							}
						});
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					var jsonText = Ext.decode(action.response.responseText);
					Ext.getCmp('componentName').setValue('');
					mask.hide();
					if(jsonText.success)
					{
						unconfigCompChecked = '';
						reqFrom = '';
						var homepage = Ext.getCmp('specificTestConfigViewPort');
						myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
						homepage.removeAll();
						myMask.show();
						homepage.add({ xtype : 'testconfiguration' });
						myMask.hide();
					}
				}
			});
		}
	},
	afterExcludeComponentsMainRender: function() {
		Ext.Ajax.request({
			url:excludeTestsURL,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText))
				{
					publicJson = Ext.decode(jsonText);
					var selectedTestsArr = publicJson['selectedTestsArr'];
					var excludeComponentsArr = publicJson['excludeComponentsArr'];
					var includeComponentsArr = publicJson['includeComponentsArr'];
					var fieldSetTitle = publicJson['fieldTitleComponentType'];
					unconfigCompChecked = publicJson['showUnconfigCompType'];

					if (!Ext.isEmpty(selectedTestsArr) && selectedTestsArr != undefined)
					{
						Ext.getCmp('selectedExcludedTestGrid').getStore().loadRawData(selectedTestsArr);
					}

					if (!Ext.isEmpty(fieldSetTitle))
					{
						Ext.getCmp('excludeCompFieldSet').setTitle('<span class="font_bold">'+fieldSetTitle+'</span>');
					}
					var excludeItemSelectorObj = Ext.getCmp('excludeItemSelector');
					if (excludeItemSelectorObj.fromField.store.getCount() >= 1)
					{
						excludeItemSelectorObj.fromField.store.removeAll();
					}
					if (excludeItemSelectorObj.toField.store.getCount() >= 1)
					{
						excludeItemSelectorObj.toField.store.removeAll();
					}
					//serversItemSelectorsObj.fromField.store.add(publicJSON['ManagedHostByThisAgent']);
					if (!Ext.isEmpty(excludeComponentsArr) && excludeComponentsArr != undefined)
					{
						excludeItemSelectorObj.fromField.store.add(excludeComponentsArr);
					}
					if (!Ext.isEmpty(includeComponentsArr) && includeComponentsArr != undefined)
					{
						excludeItemSelectorObj.toField.store.add(includeComponentsArr);
					}
				}
			}
		});
	},
	configureCorrectiveScript: function() {
		var urlLink = publicJson['configureCorrecriveScriptURL'];
		window.location.href = urlLink;
	},
	configureCorrectiveScriptFile: function()
	{
		var componentType = publicJson['componentType'];
		var componentName = publicJson['componentName'];
		var testName = publicJson['testName'];
		var existCorrectScriptVal = publicJson['correctiveScriptParamValue'];
		var agentOSName = publicJson['hiddenObj']['agentOS'];
		var url = 'SpecificTestConfiguration/data/EgRemoteUploadJson.jsp?compType='+componentType+'&testName='+testName+'&agentOS='+agentOSName;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 900000,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var strScriptFile ='';
					publicJsonData = jsonData;
					var osNameArr = publicJsonData['agentOSArr'];
					var componentTypeArr = publicJsonData['compTypeJsonArr'];
					var tNameArr = publicJsonData['testNameArr'];
					var measureNameArr = publicJsonData['measureNameArr'];

					Ext.widget('window', {
						title: 'Upload New Corrective Script',
						width: 550,
						id: 'file',
						name: 'file',
						resizable: 'false',
						modal:true,
						listeners: {
							close: function()
							{
							}
						},
						dockedItems: [
								{
									dock: 'bottom',
									layout:{
										type:'hbox',
										align:'stretch',
										pack:'center'
									},
									border:false,
									padding : '10 10 5 10',
									items: [
										{
											xtype: 'button',
											text: 'Upload',
											cls: 'quickMenuWhiteButton',
											id: 'upload',
											name: 'upload',
											action: 'upload',
											width: 80,
											handler: function (button, e)
											{
												var sub = true;
												var fileName = Ext.getCmp('uploadform1').getForm().findField('correctFile').getValue();
												var strOSName = Ext.getCmp('uploadform1').getForm().findField('correctAgentOS').getValue();
												var strCompType = Ext.getCmp('uploadform1').getForm().findField('correctCompType').getValue();
												var strMesureName = Ext.getCmp('uploadform1').getForm().findField('measureName').getValue();
												var strTestName = Ext.getCmp('uploadform1').getForm().findField('correctTestName').getValue();
												strScriptFile = '';

												if (Ext.isEmpty(strOSName) || strOSName == '-1')
												{
													Ext.Msg.show({
														title: pageName,
														msg: alertMsg1,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('correctAgentOS').focus();
														}
													});
													sub = false;
													return;
												}

												if (Ext.isEmpty(strCompType) || strCompType == '-1')
												{
													Ext.Msg.show({
														title: pageName,
														msg: alertMsg2,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('correctCompType').focus();
														}
													});
													sub = false;
													return;
												}

												if (Ext.isEmpty(strTestName) || strTestName == '-1')
												{
													Ext.Msg.show({
														title: pageName,
														msg: alertMsg3,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('correctTestName').focus();
														}
													});
													sub = false;
													return;
												}

												if (Ext.isEmpty(strMesureName) || strMesureName == '-1')
												{
													Ext.Msg.show({
														title: pageName,
														msg: 'Please choose the measure name',
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('measureName').focus();
														}
													});
													sub = false;
													return;
												}

												if(!validateSingleByte(fileName))
												{
													Ext.Msg.show({
														title: pageName,
														msg: dblName,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('correctFile').focus();
														}
													});
													sub = false;
													return;
												}

												if(fileName=="")
												{
													Ext.Msg.show({
														title: pageName,
														msg: nofileselect,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('correctFile').focus();
														}
													});
													sub = false;
													return;
												}
												else
													sub = true;

												//var fileNameNoExtension="";
												//if(fileName.indexOf("\\")> -1)
													//filename = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
												//else if(fileName.indexOf("/")> -1)
													//filename = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
												//else
													//filename = fileName;

												var agentOS = strOSName.toUpperCase();
												var check = true;
												var exten_str="";
												var exten_idx = fileName.lastIndexOf(".");
												if(exten_idx > 0)
													exten_str = fileName.substring(exten_idx);
												exten_str = exten_str.toLowerCase();
												var exten_List = new Array(".exe",".bat",".com",".cmd",".vbs",".ps1");
												if((agentOS.indexOf("WINDOWS") == -1))
													exten_List =  new Array(".sh",".ksh",".perl",".pl");
												for(i=0;i<exten_List.length;i++)
												{
													if(exten_List[i] == exten_str)
													{
														check = false;
														break;
													}
												}

												if(check)
												{
													sub = false;
													if((agentOS.indexOf("WINDOWS") != -1))
													{
														Ext.Msg.show({
															title: pageName,
															msg: alert_upload1,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function() {
																Ext.getCmp('correctFile').focus();
															}
														});
													}
													else
													{
														Ext.Msg.show({
															title: pageName,
															msg: alert_upload2,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function() {
																Ext.getCmp('correctFile').focus();
															}
														});
													}
												}

												if(sub)
												{
													var indexVal = fileName.lastIndexOf('.');
													var fileLen = fileName.length;
													var subStr = fileName.substring(indexVal, fileLen);
													var strUploadFile = strMesureName+''+subStr;
													var allOsRelatedFiles = publicJsonData['allOsRelatedFiles'][strOSName];
													for (var i=0; i<allOsRelatedFiles.length; i++)
													{
														var osRelatedFileName = allOsRelatedFiles[i];
														var indexValue = osRelatedFileName.lastIndexOf('.');
														var fileSubStr = osRelatedFileName.substring(0, indexValue);
														if (strMesureName === fileSubStr)
														{
															strScriptFile = osRelatedFileName;
														}
													}
													var scriptFileValue = strMesureName + exten_str;
													if (!Ext.isEmpty(strScriptFile))
													{
														var temp = "";
														if (strScriptFile.indexOf("_") == -1)
														{
															temp = uploadFileMsg + '. ' +uploadFileMsg2;
														}
														else 
														{
															temp = uploadFileMsg1 + '. ' +uploadFileMsg2;
														}

														Ext.Msg.show(
														{
															title: pageName,
															msg: temp,
															buttons: Ext.MessageBox.YESNO,
															icon: 'iconConfirmation',
															fn: function(btn) 
															{
																if (btn == 'yes')
																{
																	var formObj = Ext.getCmp('uploadform1');
																	formObj.add({
																		xtype: 'hidden',
																		name: 'scriptFileToDelete',
																		value: strScriptFile
																	});
																	var uploadform = Ext.getCmp('uploadform1').getForm();
																	if (uploadform.isValid())
																	{
																		uploadform.submit({
																			success: function (form, action) {
																				var jsonText = action.response.responseText;
																				publicUploadJson = Ext.decode(jsonText);
																				if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																				{
																					button.up('.window').close();
																					Ext.Msg.show({
																						title: pageName,
																						msg: alertMsg,
																						buttons: Ext.Msg.OK,
																						icon: 'iconInformation',
																						fn: function() 
																						{
																							var url = 'SpecificTestConfiguration/data/EgRemoteUploadJson.jsp?agentOS='+strOSName+'&measureName='+strMesureName+'&existScriptName='+strScriptFile+'&newScriptName='+fileName+'&existCorrectScriptVal='+existCorrectScriptVal;
																							Ext.Ajax.request({
																								url: url,
																								method: 'POST',
																								timeout: 900000,
																								scope: this,
																								success: function (response) {
																									if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
																									{
																										var jsonText = response.responseText;
																										var privateJsonData = Ext.decode(jsonText);
																										var scriptValue = privateJsonData['scriptFile'];
																										var addRecord = privateJsonData['addRecordArr'];
																										var newRecord = privateJsonData['newRecordArr'];
																										var myStore = Ext.getCmp('correctivescript').getStore();
																										var flag = true;
																										var recordIdx = '';
																										myStore.each(function(record) {
																											var storeIdx = myStore.indexOf(record);
																											var recordName = record.get('valueField');
																											if (recordName == 'none')
																											{
																												recordIdx = storeIdx;
																											}
																											var rec_idx = recordName.indexOf('.');
																											var recordNameStr = recordName.substring(0, rec_idx);
																											var idx = scriptValue.indexOf('.');
																											var scriptFileStr = scriptValue.substring(0, idx);
																											if (recordNameStr == scriptFileStr)
																											{
																												flag = false;
																												if (scriptValue != recordName)
																												{
																													if (addRecord.length > 0)
																													{
																														myStore.removeAt(storeIdx);
																														myStore.add(addRecord);
																														var prev_val = Ext.getCmp('correctivescript').getValue();
																														var val = prev_val.toString().split(",");
																														var cur_val = "";
																														for(var i=0;i<val.length;i++)
																														{
																															if(val[i] == scriptValue)
																															{
																																continue;
																															}
																															cur_val = cur_val + val[i] + ',';
																														}
																														Ext.getCmp('correctivescript').setValue(cur_val+scriptFileValue);
																													}
																													else
																													{
																														myStore.removeAt(storeIdx);
																														myStore.add(newRecord);
																														if (myStore.getCount() == 1)
																														{
																															Ext.getCmp('correctivescript').setValue(scriptValue);
																														}
																													}
																												}
																											}
																										});
																										if (flag)
																										{
																											myStore.removeAt(recordIdx);
																											myStore.add(newRecord);
																											var valueext = Ext.getCmp('correctivescript').getValue();
																											if (Ext.getCmp('correctivescript').getValue() == "" || Ext.getCmp('correctivescript').getValue() == "none")
																											{
																												Ext.getCmp('correctivescript').setValue(scriptValue);
																											}
																											var storeVal = myStore.getAt(0).getValue();
																										}
																										Ext.getCmp('correctivescript').getStore().sort('displayField', 'ASC');
																									}
																								}
																							});
																						}
																					});
																				}
																			},
																			failure: function (form, action) {
																				Ext.Msg.show({
																					title: pageName,
																					msg: 'FAILURE',
																					buttons: Ext.Msg.OK,
																					icon: 'iconExclamation'
																				});
																			}
																		});
																	}
																}
															}
														});
													}
													else 
													{
														var uploadform = Ext.getCmp('uploadform1').getForm();
														if (uploadform.isValid())
														{
															uploadform.submit({
																success: function (form, action) {
																	var jsonText = action.response.responseText;
																	publicUploadJson = Ext.decode(jsonText);
																	if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																	{
																		
																		button.up('.window').close();
																		Ext.Msg.show({
																			title: pageName,
																			msg: alertMsg,
																			buttons: Ext.Msg.OK,
																			icon: 'iconInformation',
																			fn: function() 
																			{
																				var url = 'SpecificTestConfiguration/data/EgRemoteUploadJson.jsp?agentOS='+strOSName+'&measureName='+strMesureName+'&newScriptName='+fileName;
																				Ext.Ajax.request({
																					url: url,
																					method: 'POST',
																					timeout: 900000,
																					scope: this,
																					success: function (response) {
																						if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
																						{
																							var jsonText = response.responseText;
																							var privateJsonData = Ext.decode(jsonText);
																							var scriptValue = privateJsonData['scriptFile'];
																							var addRecord = privateJsonData['addRecordArr'];
																							var newRecord = privateJsonData['newRecordArr'];
																							var myStore = Ext.getCmp('correctivescript').getStore();
																							var flag = true;
																							var recordIdx = '';
																							myStore.each(function(record) {
																								var storeIdx = myStore.indexOf(record);
																								var recordName = record.get('valueField');
																								if (recordName == 'none')
																								{
																									recordIdx = storeIdx;
																								}
																								var rec_idx = recordName.indexOf('.');
																								var recordNameStr = recordName.substring(0, rec_idx);
																								var idx = scriptValue.indexOf('.');
																								var scriptFileStr = scriptValue.substring(0, idx);
																								if (recordNameStr == scriptFileStr)
																								{
																									flag = false;
																									if (scriptValue != recordName)
																									{
																										if (addRecord.length > 0)
																										{
																											myStore.removeAt(storeIdx);
																											myStore.add(addRecord);
																											var prev_val = Ext.getCmp('correctivescript').getValue();
																											var val = prev_val.toString().split(",");
																											var cur_val = '';
																											for(var i=0;i<val.length;i++)
																											{
																												if(val[i] == scriptValue)
																												{
																													continue;
																												}
																												cur_val = cur_val + val[i] + ',';
																											}
																											Ext.getCmp('correctivescript').setValue(cur_val+scriptValue);
																										}
																										else
																										{
																											myStore.removeAt(storeIdx);
																											myStore.add(newRecord);
																											if (myStore.getCount() == 1)
																											{
																												Ext.getCmp('correctivescript').setValue(scriptValue);
																											}
																										}
																									}
																								}
																							});

																							if (flag)
																							{
																								myStore.removeAt(recordIdx);
																								myStore.add(newRecord);
																								if (Ext.getCmp('correctivescript').getValue() == "" || Ext.getCmp('correctivescript').getValue() == "none")
																								{
																									Ext.getCmp('correctivescript').setValue(scriptValue);
																								}
																							}
																							Ext.getCmp('correctivescript').getStore().sort('displayField', 'ASC');
																						}
																					}
																				});
																			}
																		});
																	}
																},
																failure: function (form, action) {
																	Ext.Msg.show({
																		title: pageName,
																		msg: 'FAILURE',
																		buttons: Ext.Msg.OK,
																		icon: 'iconExclamation'
																	});
																}
															});
														}
													}
												}
											}
										}
									]
								}
							],
						items: [
							{
								xtype: 'form',
								id: 'uploadform1',
								name: 'uploadform1',
								border: false,
								url: '../servlet/com.eg.EgUploadServlet',
								params: {
									isCorrectiveActionsExt: 'upload',
									scriptFileToDelete: strScriptFile
								},
								height: 165,
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									width: 470,
									labelWidth: 200
								},
								items: [
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'correctAgentOS',
										name: 'correctAgentOS',
										fieldLabel: cslabel4,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										margin: '10 5 5 5'
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'correctCompType',
										name: 'correctCompType',
										fieldLabel: cslabel5,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'correctTestName',
										name: 'correctTestName',
										fieldLabel: cslabel6,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: 'Test1',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'measureName',
										name: 'measureName',
										fieldLabel: cslabel7,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										id: 'correctFile',
										name: 'correctFile',
										labelSeparator: '',
										emptyText: emptyMsg,
										fieldLabel: label_Load,
										buttonText: 'Browse',
										margin: '5 5 10 5'
									}
								],
								listeners: {
									afterrender: function () {
										testViews.uploadWindow('upload');
									}
								}
							}
						],
						listeners: {
							afterrender: function() {
							}
						}
					}).show();

					var compTypeObj = Ext.getCmp('correctCompType');
					var testNameObj = Ext.getCmp('correctTestName');
					var OSNameObj = Ext.getCmp('correctAgentOS');
					var measNameObj = Ext.getCmp('measureName');
					OSNameObj.getStore().loadRawData(osNameArr);
					if (!Ext.isEmpty(osNameArr))
					{
						OSNameObj.setReadOnly(true);
						OSNameObj.setValue(osNameArr[0].valueField);
					}
					compTypeObj.getStore().loadRawData(componentTypeArr);
					if (!Ext.isEmpty(componentTypeArr))
					{
						compTypeObj.setReadOnly(true);
						compTypeObj.setValue(componentTypeArr[0].valueField);
					}
					testNameObj.getStore().loadRawData(tNameArr);
					if (!Ext.isEmpty(tNameArr))
					{
						testNameObj.setReadOnly(true);
						testNameObj.setValue(tNameArr[0].valueField);
					}
					measNameObj.getStore().loadRawData(measureNameArr);
					if (!Ext.isEmpty(measureNameArr))
					{
						measNameObj.setValue(measureNameArr[0].valueField);
					}
				}
			}
		});
	},
	uploadWindow: function(from)
	{
		var me = Ext.getCmp('uploadform1');
		var a = me.getForm();
		var prevFileNameObj = me.down("#existMeasure");

		if (!Ext.isEmpty(from))
		{
			me.add({
				xtype: 'hidden',
				name: 'isCorrectiveActionsExt',
				value: from
			});
		}
		
		if (!Ext.isEmpty(from))
		{
			me.add({
				xtype: 'hidden',
				name: 'existMeasure',
				value: prevFileNameObj
			});
		}
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'").setValue(hiddenParams[hiddenParam]);
			}
		}
	},

	goToEnableDisableTestpage: function() {
		if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'UnconfigTests')
		{
			clickedFrom = '';
			reqFrom = '';
		}
		var urlLink = publicJson['enableDisableTestPageLink'];
		var btnFrom = Ext.getCmp('backbutton').btnFrom;
		if (!Ext.isEmpty(btnFrom))
		{
			urlLink+="&btnFrom="+btnFrom;
		}
		if (!Ext.isEmpty(fromWizard))
		{
			urlLink+="&fromWizard="+fromWizard;
		}

		window.location.href = urlLink;
	},
	goToUnconfigTestsSummaryPage: function()
	{
		var backBtnFrom = Ext.getCmp('backbutton').btnFrom;
		var unconfigCompType = Ext.getCmp('componentType').getValue();
		var componentName = Ext.getCmp('componentName').getValue();

		if (backBtnFrom == 'UnconfigTests')
		{
			var unconfigTestType = showTestType;
			showTestType = '';
			clickedFrom = '';
			reqFrom = '';
			window.location.href='/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType='+encodeURIComponent(unconfigCompType)+'&showTestType='+unconfigTestType+'&scrollPosition_back=0';
		}
		else if (backBtnFrom == 'LayerModel')
		{
			var queryStr = '';
			var wholeViewport = document.getElementsByTagName("body")[0];
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();

			Ext.Ajax.request({
				url : "/final/admin/SpecificTestConfiguration/data/MonitorURL.jsp?",
				method : 'POST',
				params: {
					hitFrom: 'admin'
				},
				async : false,
				scope:this,
				success : function(response){
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = Ext.decode(response.responseText);
						mask.hide();

						queryStr = jsonText.monitorURL+"&backToMeasrues=true";
					}
				},
				failure : function(){}
			});
			/*do	{
					queryStr = queryStr.replace("=","|eq|");
				}while(queryStr.indexOf("=")>-1)*/
			
					do{
						queryStr=queryStr.replace("?","|qs|");
					  }
				while(queryStr.indexOf("?")>-1)
			window.parent.goToTestConfiguration(indexTabURL.monitorTabURL+"&monLayerUrl="+encodeURIComponent(window.parent.filterEncode(queryStr)));
		}
		else if (backBtnFrom == 'compModify')
		{
			clickedFrom = '';
			reqFrom = '';
			window.location.href='/final/admin/EgDispServer.jsp?comptype='+encodeURIComponent(unconfigCompType)+'&fromWizard='+fromWizard;
		}
	},
	apply: function() {
		var serversItemSelectorsObj = Ext.getCmp('serversItemSelectors');
		var fromTriggerObj = serversItemSelectorsObj.fromField.down('trigger');
		var toTriggerObj = serversItemSelectorsObj.toField.down('trigger');
		
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}		
		
		var selectedView = Ext.getCmp('ea_criteria').getValue();
		var selectedUserOption = Ext.getCmp('ea_userOption').getValue();
		var previousView = publicJson['applyAllHiddenObj']['ea_criteriaPrevious'];
		var managedComponentLen = serversItemSelectorsObj.fromField.store.getCount();

		var parametersSelected = false;
		var allowToSubmit = true;
		var selectedComponents = "";
		tickedParams = "";
		var dataRecord = Ext.getCmp('paramsGrid').getStore().getCount();
		var selectedParameters = "";
		var count = 0;
		for (var i = 0;i < dataRecord ;i++ )
		{
			var record = Ext.getCmp('paramsGrid').getStore().getAt(i);
			isChecked = Ext.getCmp('paramsGrid').getSelectionModel().isSelected(record);

			if (isChecked)
			{
				parametersSelected = true;
				var str = '-'+ record.get('uniqueId');
				tickedParams += str;

				if (selectedParameters != "")
				{
					selectedParameters = selectedParameters + ",";
				}
				if (tickedParams != "")
				{
					tickedParams += ',';
				}
				count += 1;
				selectedParameters = selectedParameters + str.substring(0,str.indexOf("_eachParam"));
			}
		}
		if (selectedParameters.indexOf("-correct") > -1)
		{
			selectedParameters = selectedParameters+ ",-alarmtype,-userparams,-correctivescript";
		}
		if (managedComponentLen  >= 1 && !parametersSelected)
		{
			Ext.Msg.show({
				title: applyAllPageName,
				msg:alertMsg4,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			allowToSubmit = false;
		}
		else if (managedComponentLen==0 && parametersSelected)
		{
			Ext.Msg.show({
				title: applyAllPageName,
				msg:alertMsg5,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			allowToSubmit = false;
		}
		else if (managedComponentLen == 0 && !parametersSelected)
		{
			Ext.Msg.show({
				title: applyAllPageName,
				msg: confirmMsg1,
				buttons: Ext.Msg.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if (response == "yes")
					{
						allowToSubmit = true;
					}
					else
					{
						allowToSubmit = false;
					}
				}
			});
		}
		if (allowToSubmit)
		{
			clickedFrom = '';
			testName = '';
			unconfigCompChecked = '';
			var encodeParamList = encodeParamListFromBackup;
			params = 'requestFrom=EgApplyToOtherComponents.jsp';
			for (var i=0; i<managedComponentLen; i++)
			{
				var compVal = serversItemSelectorsObj.fromField.store.getAt(i).get('valueField');
				if (selectedComponents!="")
				{
					selectedComponents = selectedComponents + ",";
				}
				selectedComponents = selectedComponents + compVal;
			}
			//params += '&selectedComponents='+selectedComponents+'&selectedParameters='+selectedParameters;

			var isDiskSpaceTest = false;
			if (!Ext.isEmpty(aggHiddenValues))
			{
				var hiddenValues = aggHiddenValues;
				aggHiddenValues = '';
				hiddenValues.split("&").forEach(
					function(part) {
						var item = part.split("=");
						if(item[0] == "testName" && (item[1] == "DiskSpaceTest" || item[1] == "WVDDiskSpaceTest"))
						{
							isDiskSpaceTest = true;
						}
						if (!Ext.isEmpty(item[0]) && item[0] != 'hiddenSiteURL' && item[0] != 'hiddenURLs' && item[0] != 'hiddenPublishedResource')
						{
							if(!me.isExistsParam(encodeParamList,item[0]))
							{
								aggHiddenValues += item[0]+'='+item[1]+'&';
							}
							else
							{
								aggHiddenValues += item[0]+'='+encodeURIComponent(filterEncode(item[1]))+'&';
							}
						}
					}
				);
				params +='&'+aggHiddenValues;
			}
			var tmpURL = 'SpecificTestConfiguration/data/EgConfigureComponentTestsp.jsp?'+params;
			var formObj = this.getApplytoothercomponents().getForm();
			if (formObj.isValid())
			{
				var myApplyMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myApplyMask.show();

				Ext.getCmp('selectedParameters').setValue(filterEncode(selectedParameters));
				Ext.getCmp('selectedComponents').setValue(selectedComponents);
				this.getApplytoothercomponents().submit({
					url: tmpURL,
					method: 'POST',
					timeout: 9000,
					success: function(form, action)
					{
						myApplyMask.hide();

						if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) )
						{
							var jsonText = Ext.decode(action.response.responseText);
							if(jsonText.successUpdate) {
								Ext.Msg.show({
									title:pageName,
									msg: ((isDiskSpaceTest) ? (dskSpcTstAtmtnPrmsSkippd) : (alertMsg78)),
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										Ext.getCmp('selectedParameters').setValue('');
										Ext.getCmp('selectedComponents').setValue('');
										var backBtnFrom = Ext.getCmp('applyToOtherViewForm').isBackButton;

										if (!Ext.isEmpty(backBtnFrom))
										{
											reqFrom = backBtnFrom;
										}
										else
										{
											reqFrom = '';
										}

										var homepage = Ext.getCmp('specificTestConfigViewPort');
										myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
										homepage.removeAll();
										myMask.show();
										homepage.add({ xtype : 'testconfiguration' });
										myMask.hide();
									}
								});
							}
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myApplyMask.hide();

						var jsonText = Ext.decode(action.response.responseText);
						Ext.getCmp('selectedParameters').setValue('');
						Ext.getCmp('selectedComponents').setValue('');
						if(jsonText.successUpdate)
						{
							var backBtnFrom = Ext.getCmp('applyToOtherViewForm').isBackButton;

							if (!Ext.isEmpty(backBtnFrom))
							{
								reqFrom = backBtnFrom;
							}
							else
							{
								reqFrom = '';
							}
							var homepage = Ext.getCmp('specificTestConfigViewPort');
							myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
							homepage.removeAll();
							myMask.show();
							homepage.add({ xtype : 'testconfiguration' });
							myMask.hide();
						}
					}
				});
			}
			//Ext.Ajax.request({
				//url: tmpURL,
				//method: 'POST',
				//async:false,
				//success:function( response ){
					//if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					//{
						//Ext.Msg.show({
							//title:pageName,
							//msg: alertMsg78,
							//buttons: Ext.Msg.OK,
							//icon: 'iconInformation',
							//fn: function() {
								////me.afterMainRender();
								//reqFrom = '';
								//var homepage = Ext.getCmp('specificTestConfigViewPort');
								//myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
								//homepage.removeAll();
								//myMask.show();
								//homepage.add({ xtype : 'testconfiguration' });
								//myMask.hide();
							//}
						//});
					//}
				//}
			//});
		}
	},
	selectUserOptionCombo: function() {
		params = 'requestFrom=EgApplyToOtherComponents.jsp';
		var selectedView = Ext.getCmp('ea_criteria').getValue();
		var selectedUserOption = Ext.getCmp('ea_userOption').getValue();
		var previousView = publicJson['applyAllHiddenObj']['ea_criteriaPrevious'];
		var applyShowUnconfigCompType = publicJson['applyAllHiddenObj']['applyShowUnconfigCompType'];
		if (!Ext.isEmpty(selectedUserOption) && selectedUserOption != undefined )
		{
			tickedParams = "";
			var dataRecord = Ext.getCmp('paramsGrid').getStore().getCount();
			var selectedParameters = "";
			var count = 0;
			for (var i = 0;i < dataRecord ;i++ )
			{
				var record = Ext.getCmp('paramsGrid').getStore().getAt(i);
				isChecked = Ext.getCmp('paramsGrid').getSelectionModel().isSelected(record);

				if (isChecked)
				{
					var str = '-'+ record.get('uniqueId');
					tickedParams += str;

					if (selectedParameters != "")
					{
						selectedParameters = selectedParameters + ",";
					}
					if (tickedParams != "")
					{
						tickedParams += ',';
					}
					count += 1;
					selectedParameters = selectedParameters + str.substring(0,str.indexOf("_eachParam"));
				}
			}
			if (!Ext.isEmpty(tickedParams))
			{
				tickedParams = tickedParams.substring(0,tickedParams.lastIndexOf(','));
			}

			if (count == dataRecord)
			{
				tickedParams = 'checkedAllParams';
			}
			params += '&'+ existingParams;
			params += '&selectedParameters='+selectedParameters+'&ea_criteria='+selectedView+'&ea_userOption='+selectedUserOption+'&ea_criteriaPrevious='+previousView+"&showUnconfigCompType="+applyShowUnconfigCompType;
			
			params = me.encodeFieldParamsForQryString(params);

			var allParamsAndValues = Ext.Object.fromQueryString(params,true);
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgApplyToOtherComponentsJson.jsp?',
				method:'POST',
				params: allParamsAndValues,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						publicJson = Ext.decode(jsonText);
						//var temppublicJson = Ext.decode(jsonText);
						var paramsGridArr = publicJson['paramsGridArr'];
						var allParamsChecked = publicJson['allParamsChecked'];
						var unmanServersArr = publicJson['unmanServersArr'];
						var paramsGridObj = Ext.getCmp('paramsGrid');
						var serversItemSelectorsObj = Ext.getCmp('serversItemSelectors');

						var gridTitle = publicJson['gridTitle'];
						if (!Ext.isEmpty(gridTitle))
						{
							paramsGridObj.setTitle(gridTitle);
						}
						if (!Ext.isEmpty(paramsGridArr) && paramsGridArr != undefined)
						{
							paramsGridObj.getStore().loadRawData(paramsGridArr);
							if (!Ext.isEmpty(tickedParams) && tickedParams == 'checkedAllParams')
							{
								paramsGridObj.getSelectionModel().selectAll(true);
							}
							else
							{
								var selectedParams = tickedParams.split(',');
								var storeCount = paramsGridObj.getStore().getCount();
								for (var i=0;i<storeCount ;i++ )
								{
									var recordName = '-'+paramsGridObj.getStore().getAt(i).get('uniqueId');
									var record = paramsGridObj.getStore().getAt(i);
									for (var j=0;j<selectedParams.length ;j++ )
									{
										var tempValue = selectedParams[j];
										if (!Ext.isEmpty(tempValue) && tempValue == recordName)
										{
											Ext.getCmp('paramsGrid').getSelectionModel().select(record,true,true);
											break;
										}
									}
								}
							}
						}

						if (serversItemSelectorsObj.fromField.store.getCount() >= 1)
						{
							serversItemSelectorsObj.fromField.store.removeAll();
						}
						if (serversItemSelectorsObj.toField.store.getCount() >= 1)
						{
							serversItemSelectorsObj.toField.store.removeAll();
						}
						//serversItemSelectorsObj.fromField.store.add(publicJSON['ManagedHostByThisAgent']);
						if (!Ext.isEmpty(unmanServersArr) && unmanServersArr != undefined)
						{
							serversItemSelectorsObj.toField.store.add(unmanServersArr);
						}
					}
				}
			});
		}
		else
		{
			Ext.getCmp('ea_userOption').hide();
		}
	},
	selectViewByCombo: function() {
		params = 'requestFrom=EgApplyToOtherComponents.jsp';
		var selectedView = Ext.getCmp('ea_criteria').getValue();
		var previousView = publicJson['applyAllHiddenObj']['ea_criteriaPrevious'];
		var applyShowUnconfigCompType = publicJson['applyAllHiddenObj']['applyShowUnconfigCompType'];
		tickedParams = '';
		if (!Ext.isEmpty(selectedView) && selectedView != undefined )
		{
			if (selectedView == 'Component')
			{
				Ext.getCmp('ea_userOption').hide();
			}
			var dataRecord = Ext.getCmp('paramsGrid').getStore().getCount();
			var selectedParameters = "";
			var count = 0;
			for (var i = 0;i < dataRecord ;i++ )
			{
				var record = Ext.getCmp('paramsGrid').getStore().getAt(i);
				isChecked = Ext.getCmp('paramsGrid').getSelectionModel().isSelected(record);

				if (isChecked)
				{
					var str = '-'+ record.get('uniqueId');
					tickedParams += str;
					count += 1;
					if (selectedParameters != "")
					{
						selectedParameters = selectedParameters + ",";
					}
					if (tickedParams != "")
					{
						tickedParams += ',';
					}
					selectedParameters = selectedParameters + str.substring(0,str.indexOf("_eachParam"));
				}
			}
			if (!Ext.isEmpty(tickedParams))
			{
				tickedParams = tickedParams.substring(0,tickedParams.lastIndexOf(','));
			}
			if (count == dataRecord)
			{
				tickedParams = 'checkedAllParams';
			}
			params += '&'+existingParams;
			params += '&selectedParameters='+selectedParameters+'&ea_criteria='+selectedView+'&ea_criteriaPrevious='+previousView+"&showUnconfigCompType="+applyShowUnconfigCompType;
			
			params = me.encodeFieldParamsForQryString(params);

			var allParamsAndValues = Ext.Object.fromQueryString(params,true);
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgApplyToOtherComponentsJson.jsp?',
				method:'POST',
				params:allParamsAndValues,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						publicJson = Ext.decode(jsonText);
						var paramsGridArr = publicJson['paramsGridArr'];
						var vecUserOptionsArr = publicJson['vecUserOptionsArr'];
						var selectedUserOption = publicJson['selectedUserOption'];
						var isEnableUserOptionCombo = publicJson['isEnableUserOptionCombo'];
						var allParamsChecked = publicJson['allParamsChecked'];
						var unmanServersArr = publicJson['unmanServersArr'];
						var paramsGridObj = Ext.getCmp('paramsGrid');
						var userOptionObj = Ext.getCmp('ea_userOption');
						var serversItemSelectorsObj = Ext.getCmp('serversItemSelectors');
						var gridTitle = publicJson['gridTitle'];
						if (!Ext.isEmpty(gridTitle))
						{
							paramsGridObj.setTitle(gridTitle);
						}
						if (!Ext.isEmpty(paramsGridArr) && paramsGridArr != undefined)
						{
							paramsGridObj.getStore().loadRawData(paramsGridArr);
							if (!Ext.isEmpty(tickedParams) && tickedParams == 'checkedAllParams')
							{
								paramsGridObj.getSelectionModel().selectAll(true);
								var paramsStore = paramsGridObj.getStore();
								paramsStore.filterBy(
									function(record, id)
									{
										var paramName = record.get('ParamName');
										var paramValue = record.get('ParamValue');
										if (paramName == 'ALARMTYPE' || paramName == 'CORRECTIVESCRIPT' || paramName == 'USERPARAMS')
										{
											return false;
										}
										return true;
									}, 
								this);
							}
							else
							{
								var selectedParams = tickedParams.split(',');
								var storeCount = paramsGridObj.getStore().getCount();
								for (var i=0;i<storeCount ;i++ )
								{
									var recordName = '-'+paramsGridObj.getStore().getAt(i).get('uniqueId');
									var record = paramsGridObj.getStore().getAt(i);
									for (var j=0;j<selectedParams.length ;j++ )
									{
										var tempValue = selectedParams[j];
										if (!Ext.isEmpty(tempValue) && tempValue == recordName)
										{
											Ext.getCmp('paramsGrid').getSelectionModel().select(record,true,true);
											break;
										}
									}
								}
							}
						}
						if (isEnableUserOptionCombo)
						{
							Ext.getCmp('ea_userOption').setFieldLabel(selectedView);
							userOptionObj.show();
							userOptionObj.getStore().loadRawData(vecUserOptionsArr);
							if (selectedUserOption != null && selectedUserOption != 'undefined')
							{
								userOptionObj.setValue(selectedUserOption);
								userOptionObj.fireEvent('select', userOptionObj);
							}
							else
							{
								userOptionObj.setValue(vecUserOptionsArr[0].valueField);
							}
						}
						if (serversItemSelectorsObj.fromField.store.getCount() >= 1)
						{
							serversItemSelectorsObj.fromField.store.removeAll();
						}
						if (serversItemSelectorsObj.toField.store.getCount() >= 1)
						{
							serversItemSelectorsObj.toField.store.removeAll();
						}
						//serversItemSelectorsObj.fromField.store.add(publicJSON['ManagedHostByThisAgent']);
						if (!Ext.isEmpty(unmanServersArr) && unmanServersArr != undefined)
						{
							serversItemSelectorsObj.toField.store.add(unmanServersArr);
						}
					}
				}
			});
		}
	},
	applyAllMainRender: function() {
		params = 'requestFrom=EgConfigureComponentTests.jsp';
		var applyCompType = publicJson['componentType'];
		var applyCompName = publicJson['componentName'];
		var applytestName = publicJson['testName'];
		var applytestType = publicJson['selectedTestType'];
		var applyShowUnconfigCompType = publicJson['showUnconfigCompType'];
		//var clickedFrom = publicJson['clickedFrom'];
		var applyDetailedDiagnosis = publicJson['detaileddiagnosis'];
		var applyTestPeriod = publicJson['selectedTimePeriod'];
		if (applyCompType != null && applyCompType != 'undefined' && applyCompType.length > 0)
		{
			qStr = 'componentType='+encodeURIComponent(applyCompType);
		}
		if (applyCompName != null && applyCompName != 'undefined' && applyCompName.length > 0)
		{
			qStr += '&componentName='+encodeURIComponent(applyCompName);
		}
		if (applytestName != null && applytestName != 'undefined' && applytestName.length > 0)
		{
			qStr += '&testName='+encodeURIComponent(applytestName);
		}
		if (applytestType != null && applytestType != 'undefined' && applytestType.length > 0)
		{
			qStr += '&testType='+applytestType;
		}
//		if (clickedFrom != null && clickedFrom != 'undefined' && clickedFrom.length > 0)
//		{
//			qStr += '&clickedFrom='+clickedFrom;
//		}
		if (applyDetailedDiagnosis != null && applyDetailedDiagnosis != 'undefined' && applyDetailedDiagnosis.length > 0)
		{
			qStr += '&detaileddiagnosis='+applyDetailedDiagnosis;
		}
		//if (applyTestPeriod != null && applyTestPeriod != 'undefined' && applyTestPeriod.length > 0)
		//{
			//qStr += '&testPeriod='+applyTestPeriod;
		//}
		if (applyShowUnconfigCompType != null && applyShowUnconfigCompType != 'undefined' && applyShowUnconfigCompType.length > 0)
		{
			qStr += '&showUnconfigCompType='+applyShowUnconfigCompType;
		}
		
		aggHiddenValues = '';
		if (!Ext.isEmpty(publicJson['hiddenObj']) && publicJson['hiddenObj'] != undefined)
		{
			var hiddenObjValues = this.getHiddenFields('hiddenObj');
			aggHiddenValues = hiddenObjValues;
		}
		unconfigCompChecked = applyShowUnconfigCompType;
		if (qStr != null && qStr.length > 0)
		{
			params = qStr;
		}
		params += "&"+existingParams;
		params = me.encodeFieldParamsForQryString(params);
		var allParamsAndValues = Ext.Object.fromQueryString(params,true);
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgApplyToOtherComponentsJson.jsp?',
			method:'POST',
			params: allParamsAndValues,
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (response.status == 200 && !Ext.isEmpty(jsonText))
				{
					publicJson = Ext.decode(jsonText);
					var paramsGridArr = publicJson['paramsGridArr'];
					var viewByArr = publicJson['viewByArr'];
					var selectedViewBy = publicJson['selectedViewBy'];
					var vecUserOptionsArr = publicJson['vecUserOptionsArr'];
					var selectedUserOption = publicJson['selectedUserOption'];
					var dispTestName = publicJson['dispTestName'];
					var displayComponentName = publicJson['displayComponentName'];
					var isEnableUserOptionCombo = publicJson['isEnableUserOptionCombo'];
					var allParamsChecked = publicJson['allParamsChecked'];
					var unmanServersArr = publicJson['unmanServersArr'];
					var paramsGridObj = Ext.getCmp('paramsGrid');
					var viewByObj = Ext.getCmp('ea_criteria');
					var userOptionObj = Ext.getCmp('ea_userOption');
					var serversItemSelectorsObj = Ext.getCmp('serversItemSelectors');
					var gridTitle = publicJson['gridTitle'];
					if (!Ext.isEmpty(gridTitle))
					{
						paramsGridObj.setTitle(gridTitle);
					}
					if (!Ext.isEmpty(paramsGridArr) && paramsGridArr != undefined)
					{
						paramsGridObj.getStore().loadRawData(paramsGridArr);
						paramsGridObj.getSelectionModel().selectAll(true);
					}

					viewByObj.getStore().loadRawData(viewByArr);
					if (selectedViewBy != null && selectedViewBy != 'undefined')
					{
						viewByObj.setValue(selectedViewBy);
						viewByObj.fireEvent('select', viewByObj);
					}
					else
					{
						viewByObj.setValue(viewByArr[0].valueField);
					}
					if (isEnableUserOptionCombo)
					{
						userOptionObj.show();
						userOptionObj.getStore().loadRawData(vecUserOptionsArr);
						if (selectedUserOption != null && selectedUserOption != 'undefined')
						{
							userOptionObj.setValue(selectedUserOption);
							userOptionObj.fireEvent('select', userOptionObj);
						}
						else
						{
							userOptionObj.setValue(vecUserOptionsArr[0].valueField);
						}
					}
					if (serversItemSelectorsObj.fromField.store.getCount() >= 1)
					{
						serversItemSelectorsObj.fromField.store.removeAll();
					}
					if (serversItemSelectorsObj.toField.store.getCount() >= 1)
					{
						serversItemSelectorsObj.toField.store.removeAll();
					}
					//serversItemSelectorsObj.fromField.store.add(publicJSON['ManagedHostByThisAgent']);
					if (!Ext.isEmpty(unmanServersArr) && unmanServersArr != undefined)
					{
						serversItemSelectorsObj.toField.store.add(unmanServersArr);
					}
				}
			}
		});
	},
	isManagedByChange: function(obj) {
		var isManagedByVal = obj.getValue();
		var fromIniManagedBy = publicJson['selectedIsManagedBy'];
		if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'HMC')
		{
			Ext.getCmp('management_server_text').setDisabled(true);
			Ext.getCmp('management_server_text').hide();

			Ext.getCmp('management_server').setDisabled(false);
			Ext.getCmp('management_server').reset();
			Ext.getCmp('management_server').show();

			var mgmtServer = 'None';
			var mgmtUser = 'none';
			var mgmtPwd = 'none';
			if (!Ext.isEmpty(fromIniManagedBy) && fromIniManagedBy != undefined && fromIniManagedBy.toLowerCase() == 'hmc')
			{
				mgmtUser = publicJson['tempUser'];
				mgmtPwd = publicJson['tempPassValue'];
				mgmtServer = publicJson['selectedHMC'];
				if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
				{
					mgmtServer = 'None';
				}
				if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
				{
					mgmtUser = 'none';
				}
				if (Ext.isEmpty(mgmtPwd) || mgmtPwd == undefined)
				{
					mgmtPwd = 'none';
				}
			}

			var mgmtUserObj = '';
			var mgmtPwdObj = '';
			var mgmtConfPwdObj = '';
			if (!Ext.isEmpty(Ext.getCmp('management_user')) && Ext.getCmp('management_user') != undefined)
			{
				mgmtUserObj = Ext.getCmp('management_user');
			}
			else
			{
				mgmtUserObj = Ext.getCmp('Management_user');
			}
			if (!Ext.isEmpty(Ext.getCmp('management_password')) && Ext.getCmp('management_password') != undefined)
			{
				mgmtPwdObj = Ext.getCmp('management_password');
				mgmtConfPwdObj = Ext.getCmp('management_passwordconfirmpassword');
			}
			else
			{
				mgmtPwdObj = Ext.getCmp('Management_password');
				mgmtConfPwdObj = Ext.getCmp('Management_passwordconfirmpassword');
			}

			mgmtUserObj.setValue(mgmtUser);
			mgmtPwdObj.setValue(mgmtPwd);
			mgmtConfPwdObj.setValue(mgmtPwd);
		}
		else if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'IVM')
		{
			Ext.getCmp('management_server').setDisabled(true);
			Ext.getCmp('management_server').hide();

			Ext.getCmp('management_server_text').setDisabled(false);
			Ext.getCmp('management_server_text').show();


			var mgmtServer = '$unconfigured';
			var mgmtUser = '$unconfigured';
			var mgmtPwd = '$unconfigured';
			if (!Ext.isEmpty(fromIniManagedBy) && fromIniManagedBy != undefined && fromIniManagedBy.toLowerCase() == 'ivm')
			{
				mgmtUser = publicJson['tempUser'];
				mgmtPwd = publicJson['tempPassValue'];
				mgmtServer = publicJson['mgmtTextValue'];

				if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
				{
					mgmtServer = '$unconfigured';
				}
				if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
				{
					mgmtUser = '$unconfigured';
				}
				if (Ext.isEmpty(mgmtPwd) || mgmtPwd == undefined)
				{
					mgmtPwd = '$unconfigured';
				}
			}

			var mgmtUserObj = '';
			var mgmtPwdObj = '';
			var mgmtConfPwdObj = '';
			if (!Ext.isEmpty(Ext.getCmp('management_user')) && Ext.getCmp('management_user') != undefined)
			{
				mgmtUserObj = Ext.getCmp('management_user');
			}
			else
			{
				mgmtUserObj = Ext.getCmp('Management_user');
			}
			if (!Ext.isEmpty(Ext.getCmp('management_password')) && Ext.getCmp('management_password') != undefined)
			{
				mgmtPwdObj = Ext.getCmp('management_password');
				mgmtConfPwdObj = Ext.getCmp('management_passwordconfirmpassword');
			}
			else
			{
				mgmtPwdObj = Ext.getCmp('Management_password');
				mgmtConfPwdObj = Ext.getCmp('Management_passwordconfirmpassword');
			}

			Ext.getCmp('management_server_text').setValue(mgmtServer);
			mgmtUserObj.setValue(mgmtUser);
			mgmtPwdObj.setValue(mgmtPwd);
			mgmtConfPwdObj.setValue(mgmtPwd);
		}

		var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'management_user');
		if (!Ext.isEmpty(disabledPwdParam))
		{
			Ext.getCmp(disabledPwdParam.trim()).setValue('none');
			me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
		}
	},
	InsideViewChange: function(value) {
		insideView = value;
		var domainValue = "";
		var domainObj = Ext.getCmp('domain');
		var adminUserObj = Ext.getCmp('admin_user');
		var adminPwdObj = Ext.getCmp('admin_password');
		var adminConPwdObj = Ext.getCmp('admin_passwordconfirmpassword');
		if (!Ext.isEmpty(domainObj) && domainObj != undefined)
		{
			domainValue = Ext.getCmp('domain').getValue();
		}

		if (value == "tcp" || value == "wmi")
		{
			if (!Ext.isEmpty(domainObj) && domainObj != undefined &&
				domainObj.getValue() == "$unconfigured")
			{
				domainObj.setValue("none");
			}

			if (!Ext.isEmpty(adminUserObj) && adminUserObj != undefined &&
				adminUserObj.getValue() == "$unconfigured")
			{
				adminUserObj.setValue("none");
			}

			if (!Ext.isEmpty(adminPwdObj) && adminPwdObj != undefined &&
				adminPwdObj.getValue() == "$unconfigured")
			{
				adminPwdObj.setValue("none");
			}

			if (!Ext.isEmpty(adminConPwdObj) && adminConPwdObj != undefined &&
				adminConPwdObj.getValue() == "$unconfigured")
			{
				adminConPwdObj.setValue("none");
			}
		}
		else
		{
			if (!Ext.isEmpty(domainObj) && domainObj != undefined &&
				domainObj.getValue() == "none")
			{
				domainObj.setValue("$unconfigured");
			}
			if (!Ext.isEmpty(adminUserObj) && adminUserObj != undefined &&
				adminUserObj.getValue() == "none")
			{
				adminUserObj.setValue("$unconfigured");
			}

			if (!Ext.isEmpty(adminPwdObj) && adminPwdObj != undefined &&
				adminPwdObj.getValue() == "none")
			{
				adminPwdObj.setValue("$unconfigured");
			}

			if (!Ext.isEmpty(adminConPwdObj) && adminConPwdObj != undefined &&
				adminConPwdObj.getValue() == "none")
			{
				adminConPwdObj.setValue("$unconfigured");
			}
		}
	},
	applyPwdProfile: function(obj) 
	{
		var id = obj.id;
		var totalPwdParams = publicJson[id+'_totalPwdParams'];
		var paramsArray = publicJson[id+'_paramsArray'];
		var pwdProfileIniVal = publicJson.pwdProfileIniVal;
		var selectedProfile = obj.value;
		var dependParams = publicJson.pwdParamSetList[id];

		if (!Ext.isEmpty(selectedProfile) && selectedProfile != 'none')
		{
			//var arrObj = ['virtual_center','xms_ip','Prism_IP','management_server','Rhel_mgr_host','inside_view_using'];
			switch(dependParams)
			{
				case 'Esx_user,Esx_password': 
					console.log('case fired..');
					Ext.getCmp('virtual_center').setValue('None');
					break;
				case 'management_user,management_password' :
					Ext.getCmp('management_server').setValue('None');
					break;
				case 'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain':
					Ext.getCmp('Rhel_mgr_host').setValue('None');
					break;
				case 'Prism_user,Prism_password':
					Ext.getCmp('Prism_IP').setValue('None');
					break;
				case 'XtremIO_user,XtremIO_password':
					Ext.getCmp('xms_ip').setValue('None');
					break;
			}
			//setNoneForDependsParams(arrObj,paramsArray);

			//vCenterObj = Ext.getCmp('virtual_center');
			//if (!Ext.isEmpty(vCenterObj))
			//{

				//vCenterObj.setValue('None');
			//}

			var params = pwdProfileIniVal[selectedProfile];
			var paramsValArr = params.split("~Hash~");

			for (var a=0;a<totalPwdParams ;a++ )
			{
				var paramName = paramsArray[a]['profileParams'+a];
				var paramValue = '';
				if (!Ext.isEmpty(Ext.getCmp(paramName)))
				{
					Ext.getCmp(paramName).setReadOnly(true);
					if (checkParamIsUserField(paramName))
					{
						paramValue = paramsValArr[0];
					}
					else if (checkParamIsPasswordField(paramName))
					{
						paramValue = paramsValArr[1];
					}
					else if (checkParamIsDomainField(paramName))
					{
						paramValue = paramsValArr[2];
					}

					Ext.getCmp(paramName).setValue(paramValue);

					if (paramName.toLowerCase().indexOf("password") != -1 || 
						paramName.toLowerCase().indexOf("authpass") != -1 || 
						paramName.toLowerCase().indexOf("oracle_vm_mgr_pass") != -1 || 
						paramName.toLowerCase().indexOf("vcloud_director_pass") != -1 || 
						paramName.toLowerCase().indexOf("docker_pass") != -1 )
					{
						if (!Ext.isEmpty(Ext.getCmp(paramName+"confirmpassword")))
						{
							Ext.getCmp(paramName+"confirmpassword").setReadOnly(true);
							Ext.getCmp(paramName+"confirmpassword").setValue(paramValue);
							Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							Ext.getCmp(paramName+"confirmpassword").show();
						}
					}
				}
			}
		}
		else
		{
			for (var a=0;a<totalPwdParams ;a++ )
			{
				var paramName = paramsArray[a]['profileParams'+a];
				//var paramValue = paramsValArr[a];
				if (!Ext.isEmpty(Ext.getCmp(paramName)))
				{
					Ext.getCmp(paramName).setReadOnly(false);
					Ext.getCmp(paramName).setValue('none');

					if (paramName.toLowerCase().indexOf("password") != -1 ||
						paramName.toLowerCase().indexOf("authpass") != -1 || 
						paramName.toLowerCase().indexOf("oracle_vm_mgr_pass") != -1 || 
						paramName.toLowerCase().indexOf("vcloud_director_pass") != -1 || 
						paramName.toLowerCase().indexOf("docker_pass") != -1 )
					{
						if (!Ext.isEmpty(Ext.getCmp(paramName+"confirmpassword")))
						{
							Ext.getCmp(paramName+"confirmpassword").setReadOnly(false);
							Ext.getCmp(paramName+"confirmpassword").setValue('none');
							Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							Ext.getCmp(paramName+"confirmpassword").show();

						}
					}
				}
			}
		}
	},
	enablePwdProfile: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'usepwdprofile')
		{
			var value = obj.getBox().y+100;
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('pwdprofile').setDisabled(true);
				Ext.getCmp('pwdprofile').hide();
				Ext.getCmp('pwdprofile').setValue('-1');
			}
			else
			{
				Ext.getCmp('pwdprofile').setDisabled(false);
				Ext.getCmp('pwdprofile').show();
			}

			me.applyPwdProfile('-1');
			//var totalPwdParams = publicJson.totalPwdParams;
			//var paramsArray = publicJson.paramsArray;

			//for (var a=0;a<totalPwdParams ;a++ )
			//{
				//var paramName = paramsArray[a]['profileParams'+a];
				////var paramValue = paramsValArr[a];
				//if (!Ext.isEmpty(Ext.getCmp(paramName)))
				//{
					//Ext.getCmp(paramName).setReadOnly(false);
					//Ext.getCmp(paramName).setValue('none');

					//if (paramName.indexOf("password") != -1)
					//{
						//Ext.getCmp(paramName+"confirmpassword").setReadOnly(true);
						//Ext.getCmp(paramName+"confirmpassword").setValue('none');
					//}
				//}
			//}

			Ext.getCmp('testConfigForm').body.scrollTo('top',value);
		}
	},
	changeEncFlagValue: function(obj) {
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'encryptflag')
		{
			var value = obj.getBox().y;
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('encrypttype').setDisabled(true);
				Ext.getCmp('encryptpassword').setDisabled(true);
				Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
				Ext.getCmp('encrypttype').hide();
				Ext.getCmp('encryptpassword').hide();
				Ext.getCmp('encryptpasswordconfirmpassword').hide();
			}
			else
			{
				var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
				var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
				Ext.getCmp('encrypttype').setDisabled(false);
				Ext.getCmp('encryptpassword').setDisabled(false);
				Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
				Ext.getCmp('encrypttype').show();
				if (!Ext.isEmpty(selectedSnmpEncType))
				{
					Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
				}
				else
				{
					Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
				}
				Ext.getCmp('encryptpassword').show();
				Ext.getCmp('encryptpasswordconfirmpassword').show();
			}
			Ext.getCmp('testConfigForm').body.scrollTo('top',value);
		}
	},
	snmpV3ParamDisabeld: function(obj) 
	{
		var value = obj.getBox().y;
		if (!Ext.isEmpty(Ext.getCmp('context')) && Ext.getCmp('context') != undefined)
		{
			Ext.getCmp('context').setDisabled(true);
			Ext.getCmp('context').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
		{
			Ext.getCmp('username').setDisabled(true);
			Ext.getCmp('username').hide();
		}
		if (!Ext.isEmpty(Ext.getCmp('authpass')) && Ext.getCmp('authpass') != undefined)
		{
			Ext.getCmp('authpass').setDisabled(true);
			Ext.getCmp('authpass').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('authpassconfirmpassword')) && Ext.getCmp('authpassconfirmpassword') != undefined)
		{
			Ext.getCmp('authpassconfirmpassword').setDisabled(true);
			Ext.getCmp('authpassconfirmpassword').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('authtype')) && Ext.getCmp('authtype') != undefined)
		{
			Ext.getCmp('authtype').setDisabled(true);
			Ext.getCmp('authtype').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptflag_radioGrp')) && Ext.getCmp('encryptflag_radioGrp') != undefined)
		{
			Ext.getCmp('encryptflag_radioGrp').setDisabled(true);
			Ext.getCmp('encryptflag_radioGrp').hide();
		}
		if (!Ext.isEmpty(Ext.getCmp('engineid_radioGrp')) && Ext.getCmp('engineid_radioGrp') != undefined)
		{
			Ext.getCmp('engineid_radioGrp').setDisabled(true);
			Ext.getCmp('engineid_radioGrp').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encrypttype')) && Ext.getCmp('encrypttype') != undefined)
		{
			Ext.getCmp('encrypttype').setDisabled(true);
			Ext.getCmp('encrypttype').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptpassword')) && Ext.getCmp('encryptpassword') != undefined)
		{
			Ext.getCmp('encryptpassword').setDisabled(true);
			Ext.getCmp('encryptpassword').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('encryptpasswordconfirmpassword')) && Ext.getCmp('encryptpasswordconfirmpassword') != undefined)
		{
			Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(true);
			Ext.getCmp('encryptpasswordconfirmpassword').hide();
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeActionOnDescriptors : function(obj)
	{
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('include_descriptors').hide();
				Ext.getCmp('excludeDescriptor').show();
			}
			else
			{
				Ext.getCmp('include_descriptors').show();
				Ext.getCmp('excludeDescriptor').hide();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeTotalDesc: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'report_with_destination')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('report_by_total_radioGrp').setDisabled(false);
				Ext.getCmp('report_by_total_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('report_by_total_radioGrp').setDisabled(false);
				Ext.getCmp('report_by_total_radioGrp').reset();
				Ext.getCmp('report_by_total_radioGrp').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeEnableMode: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'is_privilege_mode_enabled')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('enable_password').setDisabled(true);
				Ext.getCmp('enable_password').hide();
			}
			else
			{
				Ext.getCmp('enable_password').setDisabled(false);
				Ext.getCmp('enable_password').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeAutomationForDskTst: function(obj) 
	{
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'autmtd_actn_enbld_dskspc' || radioGroupId.toLowerCase() == 'autmtd_actn_enbld_wvd_dskspc')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('multifieldContainerTextComponent').hide();
				obj.focus();
			}
			else
			{
				Ext.getCmp('multifieldContainerTextComponent').show();
				Ext.getCmp('multiUserIcon').focus();
			}
		}
	},
	changeConnType: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}

		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];
		var appServCtrlChecked = Ext.getCmp(radioGroupId+'1').getValue();
		if (appServCtrlChecked)
		{
			Ext.getCmp('Message_Server').setDisabled(true);
			Ext.getCmp('Message_Server').hide();
			Ext.getCmp('logon_group').setDisabled(true);
			Ext.getCmp('logon_group').hide();


			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('Application_server').setDisabled(false);
			Ext.getCmp('Application_server').show();
		}
		else
		{
			Ext.getCmp('sysno').setDisabled(true);
			Ext.getCmp('sysno').hide();
			Ext.getCmp('Application_server').setDisabled(true);
			Ext.getCmp('Application_server').hide();

			Ext.getCmp('logon_group').setDisabled(false);
			Ext.getCmp('logon_group').show();
			Ext.getCmp('Message_Server').setDisabled(false);
			Ext.getCmp('Message_Server').show();
		}

		showToPwdProfile(pwdProfileShowList,true);
		showToPwdProfile(pwdProfileHideList,false);

		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeDataCollectMode: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}

		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		//if (radioGroupId.toLowerCase() == 'is_privilege_mode_enabled')
		{
			var sapCtrlChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var cliChecked = Ext.getCmp(radioGroupId+'2').getValue();

			if (sapCtrlChecked)
			{
				Ext.getCmp('web_dispatcher_dir').setDisabled(true);
				Ext.getCmp('web_dispatcher_dir').hide();
				Ext.getCmp('profile_file').setDisabled(true);
				Ext.getCmp('profile_file').hide();
				Ext.getCmp('timeout(seconds)').setDisabled(true);
				Ext.getCmp('timeout(seconds)').hide();

				Ext.getCmp('wsdl_port').setDisabled(false);
				Ext.getCmp('wsdl_port').show();
				Ext.getCmp('ssl_radioGrp').setDisabled(false);
				Ext.getCmp('ssl_radioGrp').reset();
				Ext.getCmp('ssl_radioGrp').show();
				Ext.getCmp('os_username').setDisabled(false);
				Ext.getCmp('os_username').show();
				Ext.getCmp('os_password').setDisabled(false);
				Ext.getCmp('os_password').show();
				Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
				Ext.getCmp('os_passwordconfirmpassword').show();
				
				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);		
			}
			else
			{
				Ext.getCmp('wsdl_port').setDisabled(true);
				Ext.getCmp('wsdl_port').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('os_username').setDisabled(true);
				Ext.getCmp('os_username').hide();
				Ext.getCmp('os_password').setDisabled(true);
				Ext.getCmp('os_password').hide();
				Ext.getCmp('os_passwordconfirmpassword').setDisabled(true);
				Ext.getCmp('os_passwordconfirmpassword').hide();

				Ext.getCmp('web_dispatcher_dir').setDisabled(false);
				Ext.getCmp('web_dispatcher_dir').show();
				Ext.getCmp('profile_file').setDisabled(false);
				Ext.getCmp('profile_file').show();
				Ext.getCmp('timeout(seconds)').setDisabled(false);
				Ext.getCmp('timeout(seconds)').show();
	
				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}

		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeAccessType: function(obj) 
	{
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}

		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		var roleCtrlChecked = Ext.getCmp(radioGroupId+'1').getValue();
		if (roleCtrlChecked)
		{
			Ext.getCmp('AWS_access_key').setDisabled(true);
			Ext.getCmp('AWS_access_key').hide();
			Ext.getCmp('AWS_access_keyconfirmpassword').setDisabled(true);
			Ext.getCmp('AWS_access_keyconfirmpassword').hide();

			Ext.getCmp('AWS_secret_key').setDisabled(true);
			Ext.getCmp('AWS_secret_key').hide();
			Ext.getCmp('AWS_secret_keyconfirmpassword').setDisabled(true);
			Ext.getCmp('AWS_secret_keyconfirmpassword').hide();

			Ext.getCmp('AWS_Role_Name').setDisabled(false);
			Ext.getCmp('AWS_Role_Name').show();

			Ext.getCmp('AWS_Account_ID_To_Monitor').setDisabled(false);
			Ext.getCmp('AWS_Account_ID_To_Monitor').show();

			showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);		
		}
		else
		{
			Ext.getCmp('AWS_access_key').setDisabled(false);
			Ext.getCmp('AWS_access_key').show();
			Ext.getCmp('AWS_access_keyconfirmpassword').setDisabled(false);
			Ext.getCmp('AWS_access_keyconfirmpassword').show();

			Ext.getCmp('AWS_secret_key').setDisabled(false);
			Ext.getCmp('AWS_secret_key').show();
			Ext.getCmp('AWS_secret_keyconfirmpassword').setDisabled(false);
			Ext.getCmp('AWS_secret_keyconfirmpassword').show();

			Ext.getCmp('AWS_Role_Name').setDisabled(true);
			Ext.getCmp('AWS_Role_Name').hide();

			Ext.getCmp('AWS_Account_ID_To_Monitor').setDisabled(true);
			Ext.getCmp('AWS_Account_ID_To_Monitor').hide();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}

		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeHorizonAPIMode: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}

		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		//if (radioGroupId.toLowerCase() == 'is_privilege_mode_enabled')
		{
			var isAPIModeChecked = Ext.getCmp(radioGroupId+'1').getValue();

			if (isAPIModeChecked)
			{
				Ext.getCmp('databaseType').setDisabled(true);
				Ext.getCmp('databaseType').hide();
				Ext.getCmp('databaseServer').setDisabled(true);
				Ext.getCmp('databaseServer').hide();
				Ext.getCmp('EventsDatabaseName').setDisabled(true);
				Ext.getCmp('EventsDatabaseName').hide();
				Ext.getCmp('EventsTableName').setDisabled(true);
				Ext.getCmp('EventsTableName').hide();
				Ext.getCmp('instance').setDisabled(true);
				Ext.getCmp('instance').hide();
				Ext.getCmp('databasePort').setDisabled(true);
				Ext.getCmp('databasePort').hide();
				Ext.getCmp('domain').setDisabled(true);
				Ext.getCmp('domain').hide();
				Ext.getCmp('user').setDisabled(true);
				Ext.getCmp('user').hide();
				Ext.getCmp('password').setDisabled(true);
				Ext.getCmp('password').hide();
				Ext.getCmp('passwordconfirmpassword').setDisabled(true);
				Ext.getCmp('passwordconfirmpassword').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();

				Ext.getCmp('Connection_server_name').setDisabled(false);
				Ext.getCmp('Connection_server_name').show();
				Ext.getCmp('Domain_name').setDisabled(false);
				Ext.getCmp('Domain_name').show();
				Ext.getCmp('User_name').setDisabled(false);
				Ext.getCmp('User_name').show();
				Ext.getCmp('Password').setDisabled(false);
				Ext.getCmp('Password').show();
				Ext.getCmp('Passwordconfirmpassword').setDisabled(false);
				Ext.getCmp('Passwordconfirmpassword').show();

				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);
			}
			else
			{
				Ext.getCmp('databaseType').setDisabled(false);
				Ext.getCmp('databaseType').show();
				Ext.getCmp('databaseServer').setDisabled(false);
				Ext.getCmp('databaseServer').show();
				Ext.getCmp('EventsDatabaseName').setDisabled(false);
				Ext.getCmp('EventsDatabaseName').show();
				Ext.getCmp('EventsTableName').setDisabled(false);
				Ext.getCmp('EventsTableName').show();
				Ext.getCmp('instance').setDisabled(false);
				Ext.getCmp('instance').show();
				Ext.getCmp('databasePort').setDisabled(false);
				Ext.getCmp('databasePort').show();
				Ext.getCmp('domain').setDisabled(false);
				Ext.getCmp('domain').show();
				Ext.getCmp('user').setDisabled(false);
				Ext.getCmp('user').show();
				Ext.getCmp('password').setDisabled(false);
				Ext.getCmp('password').show();
				Ext.getCmp('passwordconfirmpassword').setDisabled(false);
				Ext.getCmp('passwordconfirmpassword').show();
				Ext.getCmp('ssl_radioGrp').setDisabled(false);
				Ext.getCmp('ssl_radioGrp').reset();
				Ext.getCmp('ssl_radioGrp').show();

				Ext.getCmp('Connection_server_name').setDisabled(true);
				Ext.getCmp('Connection_server_name').hide();
				Ext.getCmp('Domain_name').setDisabled(true);
				Ext.getCmp('Domain_name').hide();
				Ext.getCmp('User_name').setDisabled(true);
				Ext.getCmp('User_name').hide();
				Ext.getCmp('Password').setDisabled(true);
				Ext.getCmp('Password').hide();
				Ext.getCmp('Passwordconfirmpassword').setDisabled(true);
				Ext.getCmp('Passwordconfirmpassword').hide();
	
				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}

		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	customDB: function(obj){
		var value = obj.getBox().y;
		var dropdownId = '';
		var testname = publicJson['testName'];

		if (!Ext.isEmpty(obj))
		{
			dropdownId = obj.id;
		}
		if(dropdownId.toLowerCase() == 'database_type')
		{
			var dbType = Ext.getCmp('database_type').getValue();
			if (dbType == 'MsSql')
			{
				Ext.getCmp('database_name').show();
				Ext.getCmp('database_name').setDisabled(false);
				Ext.getCmp('instance_name').show();
				Ext.getCmp('instance_name').setDisabled(false);
				Ext.getCmp('ssl_enabled'+'_radioGrp').setDisabled(false);
				Ext.getCmp('ssl_enabled'+'_radioGrp').reset();
				Ext.getCmp('ssl_enabled'+'_radioGrp').show();
				Ext.getCmp('domain').show();
				Ext.getCmp('domain').setDisabled(false);
				Ext.getCmp('ntlmv2_enabled'+'_radioGrp').setDisabled(false);
				Ext.getCmp('ntlmv2_enabled'+'_radioGrp').reset();
				Ext.getCmp('ntlmv2_enabled'+'_radioGrp').show();
				Ext.getCmp('oracle_sid').hide();
				Ext.getCmp('oracle_sid').setDisabled(true);
				Ext.getCmp('service_name').hide();
				Ext.getCmp('service_name').setDisabled(true);
				
			}
			else if (dbType == 'Oracle')
			{
				Ext.getCmp('database_name').hide();
				Ext.getCmp('database_name').setDisabled(true);
				Ext.getCmp('instance_name').hide();
				Ext.getCmp('instance_name').setDisabled(true);
				Ext.getCmp('ssl_enabled'+'_radioGrp').hide();
				Ext.getCmp('ssl_enabled'+'_radioGrp').setDisabled(true);
				Ext.getCmp('domain').hide();
				Ext.getCmp('domain').setDisabled(true);
				Ext.getCmp('ntlmv2_enabled'+'_radioGrp').hide();
				Ext.getCmp('ntlmv2_enabled'+'_radioGrp').setDisabled(true);
				Ext.getCmp('oracle_sid').show();
				Ext.getCmp('oracle_sid').setDisabled(false);
				Ext.getCmp('service_name').show();
				Ext.getCmp('service_name').setDisabled(false);
				
			}
		}
	},
	changeValue: function(obj) {
		var value = obj.getBox().y;
		var radioGroupId = '';
		var testname = publicJson['testName'];

		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'usealias')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			if (noChecked)
			{
				Ext.getCmp('show_alias_and_interface_name_radioGrp').setDisabled(false);
				Ext.getCmp('show_alias_and_interface_name_radioGrp').hide();
			}
			else
			{
				Ext.getCmp('show_alias_and_interface_name_radioGrp').setDisabled(false);
				Ext.getCmp('show_alias_and_interface_name_radioGrp').reset();
				Ext.getCmp('show_alias_and_interface_name_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'showallevents')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var showAllOnlyParam = publicJson.originalParamNameObj['SHOWALLONLY'];
			if (noChecked)
			{
				Ext.getCmp(showAllOnlyParam+'_radioGrp').setDisabled(true);
				Ext.getCmp(showAllOnlyParam+'_radioGrp').hide();
			}
			else
			{
				Ext.getCmp(showAllOnlyParam+'_radioGrp').setDisabled(false);
				Ext.getCmp(showAllOnlyParam+'_radioGrp').reset();
				Ext.getCmp(showAllOnlyParam+'_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'report_total')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var reportOnlyParam = publicJson.originalParamNameObj['REPORT_ONLY_TOTAL'];
			if (noChecked)
			{
				Ext.getCmp(reportOnlyParam+'_radioGrp').setDisabled(true);
				Ext.getCmp(reportOnlyParam+'_radioGrp').hide();
			}
			else
			{
				Ext.getCmp(reportOnlyParam+'_radioGrp').setDisabled(false);
				Ext.getCmp(reportOnlyParam+'_radioGrp').reset();
				Ext.getCmp(reportOnlyParam+'_radioGrp').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'snmpversion')
		{
			var snmpVersion = '';
			if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
			{
				snmpVersion = Ext.getCmp('snmpversion').getValue();
			}
			else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
			{
				snmpVersion = Ext.getCmp('snmpVersion').getValue();
			}

			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];

			if (!Ext.isEmpty(snmpVersion) && snmpVersion != undefined && snmpVersion == "v3"  )
			{
				var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
				var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
				var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
				var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').hide();
				}
				else
				{
					Ext.getCmp('snmpCommunity').hide();
				}

				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(true);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(true);
				}

				if (!Ext.isEmpty(Ext.getCmp('context')) && Ext.getCmp('context') != undefined)
				{
					Ext.getCmp('context').setDisabled(false);
					Ext.getCmp('context').setValue(snmpUserContextValues);
					Ext.getCmp('context').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
				{
					Ext.getCmp('username').setDisabled(false);
					Ext.getCmp('username').setValue(snmpUserTextValues);
					Ext.getCmp('username').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authpass')) && Ext.getCmp('authpass') != undefined)
				{
					Ext.getCmp('authpass').setDisabled(false);
					Ext.getCmp('authpass').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authpassconfirmpassword')) && Ext.getCmp('authpassconfirmpassword') != undefined)
				{
					Ext.getCmp('authpassconfirmpassword').setDisabled(false);
					Ext.getCmp('authpassconfirmpassword').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('authtype')) && Ext.getCmp('authtype') != undefined)
				{
					Ext.getCmp('authtype').setDisabled(false);
					if (!Ext.isEmpty(selectedSnmpAuthType))
					{
						Ext.getCmp('authtype').setValue(selectedSnmpAuthType);
					}
					else
					{
						Ext.getCmp('authtype').setValue(snmpAuthTypeArr[0].valueField);
					}
					Ext.getCmp('authtype').show();
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptflag_radioGrp')) && Ext.getCmp('encryptflag_radioGrp') != undefined)
				{
					Ext.getCmp('encryptflag_radioGrp').setDisabled(false);
					Ext.getCmp('encryptflag_radioGrp').show();
					var enabled = publicJson['enabledEncryptFlag'];
					var disabled = publicJson['disabledEncryptFlag'];
					Ext.getCmp('encryptflag1').setValue(enabled);
					Ext.getCmp('encryptflag2').setValue(disabled);
				}
				if (!Ext.isEmpty(Ext.getCmp('engineid_radioGrp')) && Ext.getCmp('engineid_radioGrp') != undefined)
				{
					Ext.getCmp('engineid_radioGrp').setDisabled(false);
					Ext.getCmp('engineid_radioGrp').show();
					var enabled = publicJson['enabledEngineID'];
					var disabled = publicJson['disabledEngineID'];
					Ext.getCmp('engineid1').setValue(enabled);
					Ext.getCmp('engineid2').setValue(disabled);
				}

				if (!Ext.isEmpty(Ext.getCmp('encrypttype')) && Ext.getCmp('encrypttype') != undefined)
				{
					Ext.getCmp('encrypttype').setDisabled(false);
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptpassword')) && Ext.getCmp('encryptpassword') != undefined)
				{
					Ext.getCmp('encryptpassword').setDisabled(false);
				}

				if (!Ext.isEmpty(Ext.getCmp('encryptpasswordconfirmpassword')) && Ext.getCmp('encryptpasswordconfirmpassword') != undefined)
				{
					Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
				}

				if (disabled)
				{
					Ext.getCmp('encrypttype').hide();
					if (!Ext.isEmpty(selectedSnmpEncType))
					{
						Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
					}
					else
					{
						Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
					}
					Ext.getCmp('encryptpassword').hide();
					Ext.getCmp('encryptpasswordconfirmpassword').hide();
				}
				else
				{
					Ext.getCmp('encrypttype').show();
					if (!Ext.isEmpty(selectedSnmpEncType))
					{
						Ext.getCmp('encrypttype').setValue(selectedSnmpEncType);
					}
					else
					{
						Ext.getCmp('encrypttype').setValue(snmpEncTypeArr[0].valueField);
					}
					Ext.getCmp('encryptpassword').show();
					Ext.getCmp('encryptpasswordconfirmpassword').show();
				}
				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);
			}
			else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
			{
				//Ext.getCmp('snmpCommunity').setDisabled(false);
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(false);
					Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(false);
					Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
				}
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').show();
				}
				else
				{
					Ext.getCmp('snmpCommunity').show();
				}

				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,false);
				this.snmpV3ParamDisabeld(obj);
			}
		}
		else if (radioGroupId.toLowerCase() == 'policyfilter')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var isPolicyFilterValue = publicJson['isPolicyFilterValue'];
			var policyFilterValue = publicJson['policyFilterValue'];
			var filterArr = publicJson['filterArr'];
			if (noChecked)
			{
				var policyFilterFalse = publicJson['isPolicyFilterFalse'];
				Ext.getCmp('filter_combo').setDisabled(true);
				//Ext.getCmp('filter_combo').hide();
				Ext.getCmp('filterComboContainer').hide();

				Ext.getCmp('filter_fieldContainer').show();
				if (Ext.getCmp('filter').isDisabled())
				{
					Ext.getCmp('filter').setDisabled(false);
				}
				Ext.getCmp('filter').setValue(policyFilterFalse);
				var selectedFilterObj = Ext.getCmp('selectedFilterType');
				if (!Ext.isEmpty(selectedFilterObj) && selectedFilterObj != undefined)
				{
					selectedFilterObj.setValue('fieldContainer');
				}
				else
				{
					var temp = {
						xtype: 'hiddenfield',
						name: 'selectedFilterType',
						id: 'selectedFilterType',
						value: 'fieldContainer'
					};
					Ext.getCmp('testConfigForm').add(temp);
				}
			}
			else
			{
				var selectedFilterObj = Ext.getCmp('selectedFilterType');
				if (!Ext.isEmpty(selectedFilterObj) && selectedFilterObj != undefined)
				{
					selectedFilterObj.setValue('combo');
				}
				else
				{
					var temp = {
						xtype: 'hiddenfield',
						name: 'selectedFilterType',
						id: 'selectedFilterType',
						value: 'combo'
					};
					Ext.getCmp('testConfigForm').add(temp);
				}

				Ext.getCmp('filter').setDisabled(true);
				Ext.getCmp('filter_fieldContainer').hide();

				if (Ext.getCmp('filter_combo').isDisabled())
				{
					Ext.getCmp('filter_combo').setDisabled(false);
				}

				var policyFilterTrue = publicJson['isPolicyFilterTrue'];
				var tmpPolDatas = availPolicies.toString();
				if (!Ext.isEmpty(tmpPolDatas) && tmpPolDatas.length > 0 && (policyFilterTrue != tmpPolDatas))
				{
					policyFilterTrue = availPolicies.toString();
				}

				var aListPolArray = new Array();
				var selectPolicy = '';
				var tempStore = new Ext.data.Store({
					fields: ['displayField','valueField'],
					data: []
				});

				if (!Ext.isEmpty(policyFilterValue) && policyFilterValue.indexOf(':') > -1)
				{
					if(policyFilterValue.indexOf(";") > -1)
					{
						var tempArr = policyFilterValue.split(";");
						for (var i = 0;i< tempArr.length ;i++)
						{
							var tempPolicy = tempArr[i];
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolArray[i] = tempPolicy;
						}
					}
					else
					{
						tempPolicy = (policyFilterValue.substring(0,policyFilterValue.indexOf(":")));
						aListPolArray[0] = tempPolicy;
					}
				}
				else if ((!Ext.isEmpty(policyFilterValue) && policyFilterValue.indexOf(';') > -1) )
				{
					var tempArr = policyFilterValue.split(";");
					for (var i = 0;i< tempArr.length ;i++)
					{
						var tempPolicy = tempArr[i];
						aListPolArray[i] = tempPolicy;
					}
				}
				else
				{
					aListPolArray[0] = policyFilterValue;
				}

				if (!Ext.isEmpty(policyFilterTrue) && policyFilterTrue.length > 0)
				{
					var tmpPolArr = policyFilterTrue.split(',');
					for (var i = 0 ; i < tmpPolArr.length ; i++ )
					{
						var tmpPol = tmpPolArr[i];
						tempStore.add({
							'displayField': tmpPol,
							'valueField': tmpPol
						});
					}
					for (var i = 0 ; i < aListPolArray.length ; i++ )
					{
						var aListPol = aListPolArray[i];
						for (var j = 0 ; j < tmpPolArr.length ; j++ )
						{
							var tmpPol = tmpPolArr[j];
							if ( !Ext.isEmpty(tmpPol) && !Ext.isEmpty(aListPol) && aListPol == tmpPol )
							{
								selectPolicy +=','+tmpPol;
							}
						}
					}

					if (!Ext.isEmpty(selectPolicy))
					{
						selectPolicy = selectPolicy.substring(1);
					}
				}

				Ext.getCmp('filter_combo').getStore().removeAll();
				//Ext.getCmp('filter_combo').getStore().loadRawData(tempStore);
				for ( var i = 0; i < tempStore.getCount() ; i++ )
				{
					var getRecord = tempStore.getAt(i);
					if (getRecord.get('displayField') == 'all')
					{
						continue;
					}
					Ext.getCmp('filter_combo').getStore().add(getRecord);
				}
				Ext.getCmp('filter_combo').getStore().sort('displayField', 'ASC');
				Ext.getCmp('filter_combo').getStore().insert(0,{displayField:'all', valueField:'all'});
				Ext.getCmp('filter_combo').setValue(selectPolicy);
				Ext.getCmp('filterComboContainer').show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'measure_mode')
		{
			var measureModeLog = Ext.getCmp('measure_mode1').getValue();
			var measureModeJmx = Ext.getCmp('measure_mode2').getValue();

			var jmxRemotePort = publicJson.originalParamNameObj['JMX_REMOTE_PORT'];
			var jndiName = publicJson.originalParamNameObj['JNDI_NAME'];
			var userParamName = publicJson.originalParamNameObj['JMX_USER'];
			var jmxRegistrySslParamName = publicJson.originalParamNameObj['JMX_REGISTRY_SSL'];
			jmxRegistrySslParamName = jmxRegistrySslParamName+'_radioGrp';
			var pwdParamName = publicJson.originalParamNameObj['JMX_PASSWORD'];
			var pwdConfirmParamName = publicJson.originalParamNameObj['JMX_PASSWORDCONFIRMPASSWORD'];
			var providerParamName = publicJson.originalParamNameObj['PROVIDER'];
			var jreHomeParamName = publicJson.originalParamNameObj['JREHOME'];
			var logFileParamName = publicJson.originalParamNameObj['LOGFILENAME'];
			var serviceURLPathName = publicJson.originalParamNameObj['SERVICE_URL_PATH'];
			var jmxRemotePortObj = Ext.getCmp(jmxRemotePort);
			var jndiNameObj = Ext.getCmp(jndiName);
			var userParamNameObj = Ext.getCmp(userParamName);
			var jmxRegistrySslParamNameObj = Ext.getCmp(jmxRegistrySslParamName);
			var pwdParamNameObj = Ext.getCmp(pwdParamName);
			var pwdConfirmParamNameObj = Ext.getCmp(pwdConfirmParamName);
			if (userParamNameObj == undefined)
			{
				var userParam = publicJson.originalParamNameObj['USER'];
				userParamNameObj =  Ext.getCmp(userParam);
			}
			if (pwdParamNameObj == undefined)
			{
				var passwordParam = publicJson.originalParamNameObj['PASSWORD'];
				pwdParamNameObj =  Ext.getCmp(passwordParam);
			}
			if (pwdConfirmParamNameObj == undefined)
			{
				var passwordConParam = publicJson.originalParamNameObj['PASSWORDCONFIRMPASSWORD'];
				pwdConfirmParamNameObj =  Ext.getCmp(passwordConParam);
			}
			var providerParamNameObj = Ext.getCmp(providerParamName);
			var serviceURLPathNameObj = Ext.getCmp(serviceURLPathName);
			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];
      
			if (measureModeLog)
			{
				JMXParamDisable(jmxRemotePortObj);
				JMXParamDisable(jndiNameObj);
				JMXParamDisable(userParamNameObj);
				JMXParamDisable(jmxRegistrySslParamNameObj);
				JMXParamDisable(pwdParamNameObj);
				JMXParamDisable(pwdConfirmParamNameObj);
				JMXParamDisable(providerParamNameObj);
				JMXParamDisable(serviceURLPathNameObj);
		
				Ext.getCmp(jreHomeParamName).setDisabled(false);
				Ext.getCmp(jreHomeParamName).reset();
				Ext.getCmp(jreHomeParamName).show();
				Ext.getCmp(logFileParamName).setDisabled(false);
				Ext.getCmp(logFileParamName).reset();
				Ext.getCmp(logFileParamName).show();

				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);

			}
			else if (measureModeJmx)
			{
				Ext.getCmp(logFileParamName).setDisabled(true);
				Ext.getCmp(logFileParamName).hide();
				Ext.getCmp(jreHomeParamName).setDisabled(true);
				Ext.getCmp(jreHomeParamName).hide();

				JMXParamEnable(jmxRemotePortObj);
				JMXParamEnable(jndiNameObj);
				JMXParamEnable(userParamNameObj);
				JMXParamEnable(jmxRegistrySslParamNameObj);
				JMXParamEnable(pwdParamNameObj);
				JMXParamEnable(pwdConfirmParamNameObj);
				JMXParamEnable(providerParamNameObj);
				JMXParamEnable(serviceURLPathNameObj);

				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}
		}
		else if (radioGroupId.toLowerCase() == 'measurement_mode')
		{
			var measurementModeWar = Ext.getCmp('measurement_mode1').getValue();
			var measurementModeJmx = Ext.getCmp('measurement_mode2').getValue();

			var jmxRemotePort = publicJson.originalParamNameObj['JMX_REMOTE_PORT'];
			var jndiName = publicJson.originalParamNameObj['JNDI_NAME'];
			var jmxUserParamName = publicJson.originalParamNameObj['JMX_USER'];
			var jmxPwdParamName = publicJson.originalParamNameObj['JMX_PASSWORD'];
			//var jmxRegistSslParamName = publicJson.originalParamNameObj['JMX_REGISTRY_SSL'];
			//jmxRegistSslParamName = jmxRegistSslParamName+'_radioGrp';
			var jmxPwdConfirmParamName = publicJson.originalParamNameObj['JMX_PASSWORDCONFIRMPASSWORD'];
			var providerParamName = publicJson.originalParamNameObj['PROVIDER'];

			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];

			if (measurementModeWar)
			{
				Ext.getCmp(jmxRemotePort).setDisabled(true);
				Ext.getCmp(jmxRemotePort).hide();
				Ext.getCmp(jndiName).setDisabled(true);
				Ext.getCmp(jndiName).hide();
				Ext.getCmp(jmxUserParamName).setDisabled(true);
				Ext.getCmp(jmxUserParamName).hide();
				Ext.getCmp(jmxPwdParamName).setDisabled(true);
				Ext.getCmp(jmxPwdParamName).hide();
				//Ext.getCmp(jmxRegistSslParamName).hide();				
				Ext.getCmp(jmxPwdConfirmParamName).setDisabled(true);
				Ext.getCmp(jmxPwdConfirmParamName).hide();
				Ext.getCmp(providerParamName).setDisabled(true);
				Ext.getCmp(providerParamName).hide();

				Ext.getCmp('ssl_radioGrp').setDisabled(false);
				Ext.getCmp('ssl_radioGrp').show();
				Ext.getCmp('url').setDisabled(false);
				Ext.getCmp('url').reset();
				Ext.getCmp('url').show();
				if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
				{
					var encryptPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASS'];
					Ext.getCmp('username').setDisabled(false);
					Ext.getCmp('username').reset();
					Ext.getCmp('username').show();
					Ext.getCmp('password').setDisabled(false);
				//	Ext.getCmp('password').reset();
					Ext.getCmp('password').show();
					Ext.getCmp('passwordconfirmpassword').setDisabled(false);
				//	Ext.getCmp('passwordconfirmpassword').reset();
					Ext.getCmp('passwordconfirmpassword').show();
					Ext.getCmp(encryptPwdParamName+'_radioGrp').setDisabled(false);
					Ext.getCmp(encryptPwdParamName+'_radioGrp').show();
				}


				showToPwdProfile(pwdProfileShowList,true);
				showToPwdProfile(pwdProfileHideList,false);

			}
			else if (measurementModeJmx)
			{
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('url').setDisabled(true);
				Ext.getCmp('url').hide();
				if (!Ext.isEmpty(Ext.getCmp('username')) && Ext.getCmp('username') != undefined)
				{
					var encryptPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASS'];

					Ext.getCmp('username').setDisabled(true);
					Ext.getCmp('username').hide();
					Ext.getCmp('password').setDisabled(true);
					Ext.getCmp('password').hide();
					Ext.getCmp('passwordconfirmpassword').setDisabled(true);
					Ext.getCmp('passwordconfirmpassword').hide();
					Ext.getCmp(encryptPwdParamName+'_radioGrp').setDisabled(true);
					Ext.getCmp(encryptPwdParamName+'_radioGrp').hide();
				}

				Ext.getCmp(jmxRemotePort).setDisabled(false);
				Ext.getCmp(jmxRemotePort).reset();
				Ext.getCmp(jmxRemotePort).show();
				Ext.getCmp(jndiName).setDisabled(false);
				Ext.getCmp(jndiName).reset();
				Ext.getCmp(jndiName).show();
				Ext.getCmp(jmxUserParamName).setDisabled(false);
				Ext.getCmp(jmxUserParamName).reset();
				Ext.getCmp(jmxUserParamName).show();
				Ext.getCmp(jmxPwdParamName).setDisabled(false);
				//Ext.getCmp(jmxPwdParamName).reset();
				Ext.getCmp(jmxPwdParamName).show();
				//Ext.getCmp(jmxRegistSslParamName).show();
				Ext.getCmp(jmxPwdConfirmParamName).setDisabled(false);
				//Ext.getCmp(jmxPwdConfirmParamName).reset();
				Ext.getCmp(jmxPwdConfirmParamName).show();
				Ext.getCmp(providerParamName).setDisabled(false);
				Ext.getCmp(providerParamName).reset();
				Ext.getCmp(providerParamName).show();

				showToPwdProfile(pwdProfileShowList,false);
				showToPwdProfile(pwdProfileHideList,true);
			}
		}
		else if (radioGroupId.toLowerCase() == 'adapter_device_selection')
		{
			var isAdapterAuto = Ext.getCmp('adapter_device_selection1').getValue();
			var isAdapterManual = Ext.getCmp('adapter_device_selection2').getValue();
			if (isAdapterManual)
			{
				Ext.getCmp('device_name').setDisabled(false);
				Ext.getCmp('device_name_fieldContainer').show();
				Ext.getCmp('device_id').setDisabled(false);
				Ext.getCmp('device_id').show();
			}
			else if (isAdapterAuto)
			{
				Ext.getCmp('device_name').setDisabled(true);
				Ext.getCmp('device_name_fieldContainer').hide();
				Ext.getCmp('device_id').setDisabled(true);
				Ext.getCmp('device_id').hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'ssl')
		{
			var isSslFalse = Ext.getCmp('ssl1').getValue();
			var isSslTrue = Ext.getCmp('ssl2').getValue();
			var isSslFirstTime = publicJson['isSslFirstTime'];

			var CIMServerPortObj  = Ext.getCmp('CIM_Server_Port');
			var cimDisPortVal = '';
			if (!Ext.isEmpty(CIMServerPortObj) && CIMServerPortObj != undefined)
			{
				cimDisPortVal = CIMServerPortObj.getValue();
			}
			else
			{
				CIMServerPortObj  = Ext.getCmp('cim_server_port');
				cimDisPortVal = CIMServerPortObj.getValue();
			}
			if (isSslFalse)
			{
				if (isSslFirstTime == 'true' )
				{
					cimDisPortVal = '5988';
				}
				else
				{
					cimDisPortVal = publicJson['CIMServerPortParamValue'];
				}
				CIMServerPortObj.setValue(cimDisPortVal);
			}
			else if (isSslTrue)
			{
				if (isSslFirstTime == 'false')
				{
					cimDisPortVal = '5989';
				}
				else
				{
					cimDisPortVal = publicJson['CIMServerPortParamValue'];
				}

				CIMServerPortObj.setValue(cimDisPortVal);
			}
		}
		else if (radioGroupId.toLowerCase() == 'isembedded')
		{
			var isEmbeddedObj = Ext.getCmp('isEmbedded1');
			var isEmbeddedFirstTime = publicJson['isEmbeddedFirstTime'];

			var isEmbeddedFalse = '';
			if (!Ext.isEmpty(isEmbeddedObj) && isEmbeddedObj != undefined)
			{
				isEmbeddedFalse = isEmbeddedObj.getValue();
			}
			else {
				isEmbeddedFalse = Ext.getCmp('isembedded1').getValue();
			}
			var serialNumberObj  = Ext.getCmp('serialNumber');
			var serialNumberVal = '';
			if (!Ext.isEmpty(serialNumberObj) && serialNumberObj != undefined)
			{
				serialNumberVal = serialNumberObj.getValue();
			}
			else
			{
				serialNumberObj  = Ext.getCmp('serialnumber');
				serialNumberVal = serialNumberObj.getValue();
			}
			if (isEmbeddedFalse)
			{
				if (isEmbeddedFirstTime == 'true')
				{
					serialNumberVal = '$unconfigured';
				}
				else
				{
					serialNumberVal = publicJson['serialNumberParamValue'];
				}

				serialNumberObj.setValue(serialNumberVal);
				serialNumberObj.setDisabled(false);
				serialNumberObj.show();
			}
			else 
			{
				serialNumberObj.setValue('default');
				serialNumberObj.hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'url_pattern_discovery_mode')
		{
			var isAdapterAuto = '';
			var isAdapterManual = '';
			var URLPatternsObj = 'URL_Patterns';
			var MaxURLSegmentsObj = 'Max_URL_Segments';
			if (!Ext.isEmpty(Ext.getCmp('URL_Pattern_Discovery_Mode1')) && Ext.getCmp('URL_Pattern_Discovery_Mode1') != undefined )
			{
				isAdapterAuto = Ext.getCmp('URL_Pattern_Discovery_Mode1').getValue();
				isAdapterManual = Ext.getCmp('URL_Pattern_Discovery_Mode2').getValue();
			}
			else if (!Ext.isEmpty(Ext.getCmp('url_pattern_discovery_mode1')) && Ext.getCmp('url_pattern_discovery_mode1') != undefined )
			{
				isAdapterAuto = Ext.getCmp('url_pattern_discovery_mode1').getValue();
				isAdapterManual = Ext.getCmp('url_pattern_discovery_mode2').getValue();
			}

			if (!Ext.isEmpty(Ext.getCmp('max_url_segments')) && Ext.getCmp('max_url_segments') != undefined )
			{
				MaxURLSegmentsObj = 'max_url_segments';
			}
			
			if (!Ext.isEmpty(Ext.getCmp('url_patterns')) && Ext.getCmp('url_patterns') != undefined )
			{
				URLPatternsObj = 'url_patterns';
			}

			if (isAdapterAuto)
			{
				Ext.getCmp(MaxURLSegmentsObj).setDisabled(false);
				Ext.getCmp(MaxURLSegmentsObj).show();
				Ext.getCmp(URLPatternsObj).setDisabled(true);
				Ext.getCmp(URLPatternsObj).hide();
			}
			else if (isAdapterManual)
			{
				Ext.getCmp(URLPatternsObj).setDisabled(false);
				Ext.getCmp(URLPatternsObj).show();
				Ext.getCmp(MaxURLSegmentsObj).setDisabled(true);
				Ext.getCmp(MaxURLSegmentsObj).hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'correct')
		{
			var isCorrectYes = Ext.getCmp('correct1').getValue();
			var isCorrectNo = Ext.getCmp('correct2').getValue();
			if (isCorrectYes)
			{
				//alarmtype
				//userparams
				//correctivescript
				Ext.getCmp('alarmtype').setDisabled(false);
				Ext.getCmp('alarmtype').show();
				Ext.getCmp('userparams').setDisabled(false);
				Ext.getCmp('userparams').show();
				Ext.getCmp('correctivescript').setDisabled(false);
				Ext.getCmp('correctivescript'+'_fieldContainer').show();

				var isAdminLinkEnabled = publicJson['isAdminLinkEnabled'];
				var isAgentInstalledAndRunningCs = publicJson['isAgentInstalledAndRunningCs'];
				if (isAdminLinkEnabled)
				{
					if (isAgentInstalledAndRunningCs)
					{
						Ext.getCmp('correctivescript').columnWidth = 0.90;
						Ext.getCmp("configCorrectScriptBtn").setDisabled(false);
						Ext.getCmp("configCorrectScriptBtn").show();
						Ext.getCmp("configCorrectScriptBtn").columnWidth = 0.10;
					}
					else
					{
						Ext.getCmp('correctivescript').columnWidth = 1;
						Ext.getCmp("configCorrectScriptBtn").setDisabled(true);
						Ext.getCmp("configCorrectScriptBtn").hide();
					}
				}
				else 
				{
					Ext.getCmp('correctivescript').columnWidth = 1;
					Ext.getCmp("configCorrectScriptBtn").setDisabled(true);
					Ext.getCmp("configCorrectScriptBtn").hide();
				}
			}
			else if (isCorrectNo)
			{
				//alarmtype
				//userparams
				//correctivescript
				Ext.getCmp('alarmtype').setDisabled(true);
				Ext.getCmp('alarmtype').hide();
				Ext.getCmp('userparams').setDisabled(true);
				Ext.getCmp('userparams').hide();
				Ext.getCmp('correctivescript').setDisabled(true);
				Ext.getCmp('correctivescript'+'_fieldContainer').hide();
			}
		}
		else if (radioGroupId.toLowerCase() == 'dbtype')
		{
			var dbType = Ext.getCmp('dbType').getValue();
			var isSelectedParam = publicJson['selectedIndParamValue'];
			var pwdParamSetList = publicJson['pwdParamSetList'];
			if (!Ext.isEmpty(pwdParamSetList))
			{
				for (var strParamName in pwdParamSetList)
				{
					Ext.getCmp(strParamName).reset();
				}
			}

			if (!Ext.isEmpty(dbType) && !Ext.isEmpty(isSelectedParam) && (isSelectedParam == dbType))
			{
				Ext.getCmp('dbPort').setValue(publicJson['remainParamValuedbPort']);
				Ext.getCmp('user').setValue(publicJson['remainParamValueuser']);
				Ext.getCmp('password').setValue(publicJson['passwordpassword']);
				Ext.getCmp('passwordconfirmpassword').setValue(publicJson['passwordpassword']);
			}
			else
			{
				Ext.getCmp('dbPort').setValue('none');
				Ext.getCmp('user').setValue('$unconfigured');
				Ext.getCmp('password').setValue('$unconfigured');
				Ext.getCmp('passwordconfirmpassword').setValue('$unconfigured');
			}

			if (dbType == 'MsSql')
			{
				Ext.getCmp('instance').show();
				Ext.getCmp('instance').setDisabled(false);
				Ext.getCmp('oracle_sid').hide();
				Ext.getCmp('oracle_sid').setDisabled(true);
				Ext.getCmp('domain').show();
				Ext.getCmp('domain').setDisabled(false);
				Ext.getCmp('ssl_radioGrp').show();
				Ext.getCmp('ssl_radioGrp').setDisabled(false);
				Ext.getCmp('database').hide();
				Ext.getCmp('database').setDisabled(true);
				Ext.getCmp('dblocale').hide();
				Ext.getCmp('dblocale').setDisabled(true);
				Ext.getCmp('clientlocale').hide();
				Ext.getCmp('clientlocale').setDisabled(true);
				Ext.getCmp('isntlmv2_radioGrp').show();
				Ext.getCmp('isntlmv2_radioGrp').setDisabled(false);

			}
			else if (dbType == 'Oracle')
			{
				Ext.getCmp('instance').hide();
				Ext.getCmp('instance').setDisabled(true);
				Ext.getCmp('oracle_sid').show();
				Ext.getCmp('oracle_sid').setDisabled(false);
				Ext.getCmp('domain').hide();
				Ext.getCmp('domain').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('database').hide();
				Ext.getCmp('database').setDisabled(true);
				Ext.getCmp('dblocale').hide();
				Ext.getCmp('dblocale').setDisabled(true);
				Ext.getCmp('clientlocale').hide();
				Ext.getCmp('clientlocale').setDisabled(true);
				Ext.getCmp('isntlmv2_radioGrp').hide();
				Ext.getCmp('isntlmv2_radioGrp').setDisabled(true);
				
			}
			else if (dbType == 'Sybase')
			{
				Ext.getCmp('instance').hide();
				Ext.getCmp('instance').setDisabled(true);
				Ext.getCmp('oracle_sid').hide();
				Ext.getCmp('oracle_sid').setDisabled(true);
				Ext.getCmp('domain').hide();
				Ext.getCmp('domain').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('database').hide();
				Ext.getCmp('database').setDisabled(true);
				Ext.getCmp('dblocale').hide();
				Ext.getCmp('dblocale').setDisabled(true);
				Ext.getCmp('clientlocale').hide();
				Ext.getCmp('clientlocale').setDisabled(true);
				Ext.getCmp('isntlmv2_radioGrp').hide();
				Ext.getCmp('isntlmv2_radioGrp').setDisabled(true);
			}
			else if (dbType == 'DB2')
			{
				Ext.getCmp('instance').hide();
				Ext.getCmp('instance').setDisabled(true);
				Ext.getCmp('oracle_sid').hide();
				Ext.getCmp('oracle_sid').setDisabled(true);
				Ext.getCmp('domain').hide();
				Ext.getCmp('domain').setDisabled(true);
				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);
				Ext.getCmp('database').show();
				Ext.getCmp('database').setDisabled(false);
				Ext.getCmp('dblocale').hide();
				Ext.getCmp('dblocale').setDisabled(true);
				Ext.getCmp('clientlocale').hide();
				Ext.getCmp('clientlocale').setDisabled(true);
				Ext.getCmp('isntlmv2_radioGrp').hide();
				Ext.getCmp('isntlmv2_radioGrp').setDisabled(true);
			}
			else if (dbType == 'Informix')
			{
				Ext.getCmp('instance').show();
				Ext.getCmp('instance').setDisabled(false);

				Ext.getCmp('oracle_sid').hide();
				Ext.getCmp('oracle_sid').setDisabled(true);

				Ext.getCmp('domain').hide();
				Ext.getCmp('domain').setDisabled(true);

				Ext.getCmp('ssl_radioGrp').hide();
				Ext.getCmp('ssl_radioGrp').setDisabled(true);

				Ext.getCmp('database').hide();
				Ext.getCmp('database').setDisabled(true);

				Ext.getCmp('dblocale').show();
				Ext.getCmp('dblocale').setDisabled(false);

				Ext.getCmp('clientlocale').show();
				Ext.getCmp('clientlocale').setDisabled(false);

				Ext.getCmp('isntlmv2_radioGrp').hide();
				Ext.getCmp('isntlmv2_radioGrp').setDisabled(true);
			}
		}
		else if (radioGroupId.toLowerCase() == 'is_trail')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var reqPerDayObj = Ext.getCmp('Requests_Per_Day');
			if (noChecked)
			{
				reqPerDayObj.setDisabled(true);
				reqPerDayObj.hide();
			}
			else
			{
				reqPerDayObj.setDisabled(false);
				reqPerDayObj.show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'advanced_settings')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var pojoMtdTrcLmtObj = Ext.getCmp('Pojo_Method_Tracing_Limit');
			var pojoMtdTrcCutTimeObj = Ext.getCmp('Pojo_Method_Tracing_Cutoff_Time');
			var recrsvMtdTrcLmtObj = Ext.getCmp('Recursive_Method_Tracing_Limit');
			var nonPojoMtdTrcLmtObj = Ext.getCmp('Non-Pojo_Method_Tracing_Limit');
			var expStLnsObj = Ext.getCmp('Exception_Stacktrace_Lines');
			var includExpObj = Ext.getCmp('Included_Exceptions');
			var ignoreExpObj = Ext.getCmp('Ignored_Exceptions');
			var ignoreCharObj = Ext.getCmp('Ignored_Characters');
			var maxgrpUrlperMsrPrdObj = Ext.getCmp('Max_Grouped_Urls_Per_Measure_Period');
			var kmaxgrpUrlperMsrPrdObj = Ext.getCmp('Key_Max_Grouped_Urls_Per_Measure_Period');
			var maxQryPerTrnsObj = Ext.getCmp('Max_Sql_Queries_Per_Transaction');
			var maxMongoDbQryLntObj = Ext.getCmp('Max_Mongodb_Query_Length');
			var maxExceptionLntObj = Ext.getCmp('Max_Exception_Trace_Limit');
			var maxExecStackLntObj = Ext.getCmp('Exception_With_StackTrace_Capture_Limit');
			var maxExecFqenLntObj = Ext.getCmp('Exception_FQEN_Capture_Limit');
			var maxSqlErrQueryLntObj = Ext.getCmp('Max_Sql_Error_Queries_Per_Transaction');
			var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
			var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");
			var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
			var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");
			var maskAllHeaderFieldsObj = Ext.getCmp("Mask_All_Header_Fields_radioGrp");
			var excludeHeaderFieldsListObj = Ext.getCmp("Exclude_Header_Fields_From_Masking");
			var maskCookieFieldObj = Ext.getCmp("Mask_All_Cookie_Fields_radioGrp");
			var maskExceptionMessageObj = Ext.getCmp("Mask_Exception_Message_radioGrp");
			
			if (noChecked)
			{
				if(testName != "NodeTransTest" && testName != "KNodeTransTest")
				{
					pojoMtdTrcLmtObj.setDisabled(true);
					pojoMtdTrcLmtObj.hide();
					pojoMtdTrcCutTimeObj.setDisabled(true);
					pojoMtdTrcCutTimeObj.hide();
				}				
				recrsvMtdTrcLmtObj.setDisabled(true);
				recrsvMtdTrcLmtObj.hide();
				nonPojoMtdTrcLmtObj.setDisabled(true);
				nonPojoMtdTrcLmtObj.hide();
				expStLnsObj.setDisabled(true);
				expStLnsObj.hide();
				includExpObj.setDisabled(true);
				includExpObj.hide();
				ignoreExpObj.setDisabled(true);
				ignoreExpObj.hide();
				ignoreCharObj.setDisabled(true);
				ignoreCharObj.hide();
				maxMongoDbQryLntObj.setDisabled(true);
				maxMongoDbQryLntObj.hide();
				if (!Ext.isEmpty(maxgrpUrlperMsrPrdObj) && maxgrpUrlperMsrPrdObj != undefined){
					maxgrpUrlperMsrPrdObj.setDisabled(true);
					maxgrpUrlperMsrPrdObj.hide();
				}
				else{
					kmaxgrpUrlperMsrPrdObj.setDisabled(true);
					kmaxgrpUrlperMsrPrdObj.hide();
				}
				maxQryPerTrnsObj.setDisabled(true);
				maxQryPerTrnsObj.hide();
				maxExceptionLntObj.setDisabled(true);
				maxExceptionLntObj.hide();
				maxExecStackLntObj.setDisabled(true);
				maxExecStackLntObj.hide();
				maxExecFqenLntObj.setDisabled(true);
				maxExecFqenLntObj.hide();
				maxSqlErrQueryLntObj.setDisabled(true);
				maxSqlErrQueryLntObj.hide();
				maskSQLObj.setDisabled(true);
				maskSQLObj.hide();
				maskPublicIPObj.setDisabled(true);
				maskPublicIPObj.hide();
				maskPrivateIPObj.setDisabled(true);
				maskPrivateIPObj.hide();
				maskUrlParamsObj.setDisabled(true);
				maskUrlParamsObj.hide();
				maskAllHeaderFieldsObj.setDisabled(true);
				maskAllHeaderFieldsObj.hide();			
				excludeHeaderFieldsListObj.setDisabled(true);
				excludeHeaderFieldsListObj.hide();
				maskCookieFieldObj.setDisabled(true);
				maskCookieFieldObj.hide();
				maskExceptionMessageObj.setDisabled(true);
				maskExceptionMessageObj.hide();
			}
			else
			{
				if(testName != "NodeTransTest" && testName != "KNodeTransTest")
				{
					pojoMtdTrcLmtObj.setDisabled(false);
					pojoMtdTrcLmtObj.show();
					pojoMtdTrcCutTimeObj.setDisabled(false);
					pojoMtdTrcCutTimeObj.show();
				}				
				recrsvMtdTrcLmtObj.setDisabled(false);
				recrsvMtdTrcLmtObj.show();
				nonPojoMtdTrcLmtObj.setDisabled(false);
				nonPojoMtdTrcLmtObj.show();
				expStLnsObj.setDisabled(false);
				expStLnsObj.show();
				includExpObj.setDisabled(false);
				includExpObj.show();
				ignoreExpObj.setDisabled(false);
				ignoreExpObj.show();
				ignoreCharObj.setDisabled(false);
				ignoreCharObj.show();
				maxMongoDbQryLntObj.setDisabled(false);
				maxMongoDbQryLntObj.show();
				if (!Ext.isEmpty(maxgrpUrlperMsrPrdObj) && maxgrpUrlperMsrPrdObj != undefined){
					maxgrpUrlperMsrPrdObj.setDisabled(false);
					maxgrpUrlperMsrPrdObj.show();
				}
				else{
					kmaxgrpUrlperMsrPrdObj.setDisabled(false);
					kmaxgrpUrlperMsrPrdObj.show();
				}
				maxQryPerTrnsObj.setDisabled(false);
				maxQryPerTrnsObj.show();
				maxExceptionLntObj.setDisabled(false);
				maxExceptionLntObj.show();
				maxExecStackLntObj.setDisabled(false);
				maxExecStackLntObj.show();
				maxExecFqenLntObj.setDisabled(false);
				maxExecFqenLntObj.show();
				maxSqlErrQueryLntObj.setDisabled(false);
				maxSqlErrQueryLntObj.show();
				maskSQLObj.setDisabled(false);
				maskSQLObj.show();
				maskPublicIPObj.setDisabled(false);
				maskPublicIPObj.show();
				maskPrivateIPObj.setDisabled(false);
				maskPrivateIPObj.show();
				maskUrlParamsObj.setDisabled(false);
				maskUrlParamsObj.show();
				maskAllHeaderFieldsObj.setDisabled(false);
				maskAllHeaderFieldsObj.show();
				excludeHeaderFieldsListObj.setDisabled(false);
				excludeHeaderFieldsListObj.show();
				maskCookieFieldObj.setDisabled(false);
				maskCookieFieldObj.show();
				maskExceptionMessageObj.setDisabled(false);
				maskExceptionMessageObj.show();
			}
		}
		else if (radioGroupId.toLowerCase() == 'use_sudo')
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			var userNameObj = Ext.getCmp('Target_Process_User_Name');
			if (noChecked)
			{
				userNameObj.setDisabled(true);
				userNameObj.hide();
			}
			else
			{
				userNameObj.setDisabled(false);
				userNameObj.show();
			}
		}
		else if ( (testName == 'OSMemoryTest' && radioGroupId.toLowerCase() == 'autmtd_actn_enbld_mmryusg') || (testName == 'WVDOSMemoryTest' && radioGroupId.toLowerCase() == 'autmtd_actn_enbld_mmryusg') || (testName == 'VmgOSMemoryTest' && radioGroupId.toLowerCase() == 'automated_action_enabled'))
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			
			if (noChecked)
			{
				Ext.getCmp("automation_memory_limit(%)").setDisabled(true);
				Ext.getCmp("automation_memory_limit(%)").hide();				
				Ext.getCmp('empty_standby_memory_radioGrp').setDisabled(true);
				Ext.getCmp('empty_standby_memory_radioGrp').hide();
				Ext.getCmp('empty_modified_memory_radioGrp').setDisabled(true);
				Ext.getCmp('empty_modified_memory_radioGrp').hide();
				
				
				Ext.getCmp('automation_criteria_radioGrp').setDisabled(true);
				Ext.getCmp('automation_criteria_radioGrp').hide();				
				Ext.getCmp('free_memory_limit(MB)').setDisabled(true);
				Ext.getCmp('free_memory_limit(MB)').hide();
			}
			else
			{
				Ext.getCmp('empty_standby_memory_radioGrp').setDisabled(false);
				Ext.getCmp('empty_standby_memory_radioGrp').reset();
				Ext.getCmp('empty_standby_memory_radioGrp').show();
				Ext.getCmp('empty_modified_memory_radioGrp').setDisabled(false);
				Ext.getCmp('empty_modified_memory_radioGrp').reset();
				Ext.getCmp('empty_modified_memory_radioGrp').show();
				
				Ext.getCmp('automation_criteria_radioGrp').setDisabled(false);
				Ext.getCmp('automation_criteria_radioGrp').reset();
				Ext.getCmp('automation_criteria_radioGrp').show();
				
			
				
				var automatedActnEnbld = Ext.getCmp("automation_criteria"+'1').getValue();
						
				if(automatedActnEnbld)
				{
					Ext.getCmp('free_memory_limit(MB)').setDisabled(false);
					Ext.getCmp('free_memory_limit(MB)').reset();
					Ext.getCmp('free_memory_limit(MB)').show();
					
				}
				else if(!automatedActnEnbld)
				{
					Ext.getCmp("automation_memory_limit(%)").setDisabled(false);
					Ext.getCmp("automation_memory_limit(%)").reset();
					Ext.getCmp("automation_memory_limit(%)").show();					
				}
			}
		}
		else if ( (testName == 'OSMemoryTest' || testName == 'WVDOSMemoryTest' || testName == 'VmgOSMemoryTest') && radioGroupId.toLowerCase() == 'automation_criteria' )
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var autoMtActionEnbld = "";
			
			if(testName == 'OSMemoryTest' || testName == 'WVDOSMemoryTest')
			{
				autoMtActionEnbld  = Ext.getCmp("autmtd_actn_enbld_mmryusg"+'1').getValue();
			}
			else if(testName == 'VmgOSMemoryTest')
			{
				autoMtActionEnbld = Ext.getCmp("Automated_Action_Enabled"+'1').getValue();
			}
			
			if(autoMtActionEnbld)
			{
				if (yesChecked)
				{
					Ext.getCmp('free_memory_limit(MB)').setDisabled(false);
					Ext.getCmp('free_memory_limit(MB)').reset();
					Ext.getCmp('free_memory_limit(MB)').show();
					
					Ext.getCmp("automation_memory_limit(%)").setDisabled(true);
					Ext.getCmp("automation_memory_limit(%)").hide();
				}
				else
				{
					Ext.getCmp("automation_memory_limit(%)").setDisabled(false);
					Ext.getCmp("automation_memory_limit(%)").reset();
					Ext.getCmp("automation_memory_limit(%)").show();
					
					Ext.getCmp('free_memory_limit(MB)').setDisabled(true);
					Ext.getCmp('free_memory_limit(MB)').hide();
				}
			}
		}
		else if (( (testName == 'CtxXcXASessionTest') && (radioGroupId.toLowerCase() == 'autmtd_actn_enbld_ctxssn')) || ( (testName == 'WVDSessionTest') && (radioGroupId.toLowerCase() == 'autmtd_actn_enbld_avdssn')))
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			
			if (noChecked)
			{				
				Ext.getCmp('Processes_To_Ignore').setDisabled(true);
				Ext.getCmp('Processes_To_Ignore').hide();				
				Ext.getCmp('Idle_sessions_action_enabled_radioGrp').setDisabled(true);
				Ext.getCmp('Idle_sessions_action_enabled_radioGrp').hide();
				Ext.getCmp('Disconnected_sessions_action_enabled_radioGrp').setDisabled(true);
				Ext.getCmp('Disconnected_sessions_action_enabled_radioGrp').hide();
				
				Ext.getCmp("Idle_session_time_limit_in_minutes").setDisabled(true);
				Ext.getCmp("Idle_session_time_limit_in_minutes").hide();	
				Ext.getCmp('Idle_session_actions').setDisabled(true);
				Ext.getCmp('Idle_session_actions').hide();				
				Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').setDisabled(true);
				Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').hide();

				Ext.getCmp("Disconnected_session_time_limit_in_minutes").setDisabled(true);
				Ext.getCmp("Disconnected_session_time_limit_in_minutes").hide();				
				Ext.getCmp('Disconnected_session_action_radioGrp').setDisabled(true);
				Ext.getCmp('Disconnected_session_action_radioGrp').hide();
			}
			else
			{				
				Ext.getCmp('Processes_To_Ignore').setDisabled(false);
				Ext.getCmp('Processes_To_Ignore').reset();
				Ext.getCmp('Processes_To_Ignore').show();
				Ext.getCmp('Idle_sessions_action_enabled_radioGrp').setDisabled(false);
				Ext.getCmp('Idle_sessions_action_enabled_radioGrp').reset();
				Ext.getCmp('Idle_sessions_action_enabled_radioGrp').show();
				Ext.getCmp('Disconnected_sessions_action_enabled_radioGrp').setDisabled(false);
				Ext.getCmp('Disconnected_sessions_action_enabled_radioGrp').reset();
				Ext.getCmp('Disconnected_sessions_action_enabled_radioGrp').show();
				
				var isIdleSsnActnEnbld = Ext.getCmp("Idle_sessions_action_enabled"+'1').getValue();
				if(isIdleSsnActnEnbld)
				{
					Ext.getCmp("Idle_session_time_limit_in_minutes").setDisabled(false);
					Ext.getCmp("Idle_session_time_limit_in_minutes").reset();
					Ext.getCmp("Idle_session_time_limit_in_minutes").show();
					Ext.getCmp('Idle_session_actions').setDisabled(false);
					Ext.getCmp('Idle_session_actions').reset();
					Ext.getCmp('Idle_session_actions').show();
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').setDisabled(false);
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').reset();
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').show();
				}
				
				var isDiscconnSsnActnEnbld = Ext.getCmp("Disconnected_sessions_action_enabled"+'1').getValue();
				if(isDiscconnSsnActnEnbld)
				{
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").setDisabled(false);
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").reset();
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").show();
					Ext.getCmp('Disconnected_session_action_radioGrp').setDisabled(false);
					Ext.getCmp('Disconnected_session_action_radioGrp').reset();
					Ext.getCmp('Disconnected_session_action_radioGrp').show();
				}				
			}
		}
		else if ( (testName == 'CtxXcXASessionTest' || testName == 'WVDSessionTest') && (radioGroupId.toLowerCase() == 'idle_sessions_action_enabled'))
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();
			
			var autoMtActionEnbld = null;
			
			if (testName == 'CtxXcXASessionTest')
			{
				autoMtActionEnbld = Ext.getCmp("autmtd_actn_enbld_ctxssn"+'1').getValue();
			}
			else if (testName == 'WVDSessionTest')
			{
				var autoMtActionEnbld = Ext.getCmp("autmtd_actn_enbld_avdssn"+'1').getValue();		
			}
		
			if (noChecked)
			{
				Ext.getCmp("Idle_session_time_limit_in_minutes").setDisabled(true);
				Ext.getCmp("Idle_session_time_limit_in_minutes").hide();	
				Ext.getCmp('Idle_session_actions').setDisabled(true);
				Ext.getCmp('Idle_session_actions').hide();				
				Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').setDisabled(true);
				Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').hide();
			}
			else
			{
				if(autoMtActionEnbld)
				{					
					Ext.getCmp("Idle_session_time_limit_in_minutes").setDisabled(false);
					Ext.getCmp("Idle_session_time_limit_in_minutes").reset();
					Ext.getCmp("Idle_session_time_limit_in_minutes").show();
					Ext.getCmp('Idle_session_actions').setDisabled(false);
					Ext.getCmp('Idle_session_actions').reset();
					Ext.getCmp('Idle_session_actions').show();
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').setDisabled(false);
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').reset();
					Ext.getCmp('Trim-to_memory_limit_of_the_process_in_MB').show();
				}
			}
		}
		else if ( (testName == 'CtxXcXASessionTest' || testName == 'WVDSessionTest') && (radioGroupId.toLowerCase() == 'disconnected_sessions_action_enabled'))
		{
			var yesChecked = Ext.getCmp(radioGroupId+'1').getValue();
			var noChecked = Ext.getCmp(radioGroupId+'2').getValue();

			var autoMtActionEnbld = null;
			
			if (testName == 'CtxXcXASessionTest')
			{
				autoMtActionEnbld = Ext.getCmp("autmtd_actn_enbld_ctxssn"+'1').getValue();
			}
			else if (testName == 'WVDSessionTest')
			{
				var autoMtActionEnbld = Ext.getCmp("autmtd_actn_enbld_avdssn"+'1').getValue();		
			}
			
			if (noChecked)
			{
				Ext.getCmp("Disconnected_session_time_limit_in_minutes").setDisabled(true);
				Ext.getCmp("Disconnected_session_time_limit_in_minutes").hide();				
				Ext.getCmp('Disconnected_session_action_radioGrp').setDisabled(true);
				Ext.getCmp('Disconnected_session_action_radioGrp').hide();
			}
			else 
			{
				if(autoMtActionEnbld)
				{					
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").setDisabled(false);
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").reset();
					Ext.getCmp("Disconnected_session_time_limit_in_minutes").show();
					Ext.getCmp('Disconnected_session_action_radioGrp').setDisabled(false);
					Ext.getCmp('Disconnected_session_action_radioGrp').reset();
					Ext.getCmp('Disconnected_session_action_radioGrp').show();
				}
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeMonitorLevel: function(obj)
	{
		var radioGroupId = '';
		value = obj.getBox().y;
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
		}
		if (radioGroupId.toLowerCase() == 'monitoring_level')
		{
			var monLevel = Ext.getCmp('Monitoring_Level').getValue();
			if (!Ext.isEmpty(monLevel) && (monLevel == '1' || monLevel == '2'))
			{
				Ext.getCmp('max_grouped_urls').setDisabled(true);
				Ext.getCmp('max_grouped_urls').hide();
				Ext.getCmp('max_slow_dd_count').setDisabled(true);
				Ext.getCmp('max_slow_dd_count').hide();
				Ext.getCmp('max_error_dd_count').setDisabled(true);
				Ext.getCmp('max_error_dd_count').hide();
			}
			else if (!Ext.isEmpty(monLevel) && monLevel == '3')
			{
				Ext.getCmp('max_grouped_urls').setDisabled(true);
				Ext.getCmp('max_grouped_urls').hide();
				Ext.getCmp('max_slow_dd_count').setDisabled(false);
				Ext.getCmp('max_slow_dd_count').show();
				Ext.getCmp('max_error_dd_count').setDisabled(false);
				Ext.getCmp('max_error_dd_count').show();
			}
			else if (!Ext.isEmpty(monLevel) && monLevel == '4')
			{
				Ext.getCmp('max_grouped_urls').setDisabled(false);
				Ext.getCmp('max_grouped_urls').show();
				Ext.getCmp('max_slow_dd_count').setDisabled(false);
				Ext.getCmp('max_slow_dd_count').show();
				Ext.getCmp('max_error_dd_count').setDisabled(false);
				Ext.getCmp('max_error_dd_count').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	exectimeChangeEvt: function(obj)
	{
		var execOption = obj.getValue();

		var testPeriod = "86400";
		if (!Ext.isEmpty(execOption) && execOption == 'hourly')
		{
			testPeriod = "3600";
			Ext.getCmp('hours').hide();
			Ext.getCmp('hours').setDisabled(true);
			Ext.getCmp('minutes').setDisabled(true);
			Ext.getCmp('minutes').hide();
		}
		else if (!Ext.isEmpty(execOption) && execOption == 'daily')
		{
			testPeriod = "86400";
			Ext.getCmp('hours').show();
			Ext.getCmp('minutes').show();
			Ext.getCmp('hours').setDisabled(false);
			Ext.getCmp('minutes').setDisabled(false);

		}

		Ext.getCmp('testPeriod').setValue(testPeriod);
	},
	changeJmxOptionValue: function(obj){
		var radioGroupId = '';
		value = obj.getBox().y;
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		var jmxOptionShow = Ext.getCmp('metric_collection_type1').getValue();
		var jmxOptionHide = Ext.getCmp('metric_collection_type2').getValue();
		var modeTemp = publicJson.originalParamNameObj['MODE'];
		var measureTemp = publicJson.originalParamNameObj['MEASURE_MODE'];
		var modeTempObj = Ext.getCmp(modeTemp+'_radioGrp');
		var measureTempObj = Ext.getCmp(measureTemp+'_radioGrp');
		var jmxRemotePort = publicJson.originalParamNameObj['JMX_REMOTE_PORT'];
		var jndiName = publicJson.originalParamNameObj['JNDI_NAME'];
		var userParamName = publicJson.originalParamNameObj['JMX_USER'];
		var jmxRegistrySslParamName = publicJson.originalParamNameObj['JMX_REGISTRY_SSL'];
		jmxRegistrySslParamName = jmxRegistrySslParamName+'_radioGrp';
		var pwdParamName = publicJson.originalParamNameObj['JMX_PASSWORD'];
		var pwdConfirmParamName = publicJson.originalParamNameObj['JMX_PASSWORDCONFIRMPASSWORD'];
		var providerParamName = publicJson.originalParamNameObj['PROVIDER'];

		var snmpPortParamName = publicJson.originalParamNameObj['SNMPPORT'];
		var snmpUserContextParamName = publicJson.originalParamNameObj['CONTEXT'];
		var snmpUserParamName = publicJson.originalParamNameObj['USERNAME'];
		var snmpAuthPassParamName = publicJson.originalParamNameObj['AUTHPASS'];
		var snmpAuthPassConfirmParamName = publicJson.originalParamNameObj['AUTHPASSCONFIRMPASSWORD'];
		var snmpAuthTypeParamName = publicJson.originalParamNameObj['AUTHTYPE'];
		var snmpEncryptFlagParamName = publicJson.originalParamNameObj['ENCRYPTFLAG'];
		var snmpEngineIDParamName = publicJson.originalParamNameObj['ENGINEID'];
		var snmpEncryptTypeParamName = publicJson.originalParamNameObj['ENCRYPTTYPE'];
		var snmpEncryptPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORD'];
		var snmpEncryptConPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORDCONFIRMPASSWORD'];
		var serviceURLPathName = publicJson.originalParamNameObj['SERVICE_URL_PATH'];
		var jreHomeParamName = publicJson.originalParamNameObj['JREHOME'];
		var logFileParamName = publicJson.originalParamNameObj['LOGFILENAME'];
		var isLocalModeParamExist = publicJson['isLocalModeParamExist'];
		var jmxRemotePortObj = Ext.getCmp(jmxRemotePort); 
		var jndiNameObj = Ext.getCmp(jndiName);
		var userParamNameObj = Ext.getCmp(userParamName);
		var jmxRegistrySslParamNameObj = Ext.getCmp(jmxRegistrySslParamName);
		var pwdParamNameObj = Ext.getCmp(pwdParamName);
		var pwdConfirmParamNameObj = Ext.getCmp(pwdConfirmParamName);
		var providerParamNameObj = Ext.getCmp(providerParamName);
		var serviceURLPathNameObj = Ext.getCmp(serviceURLPathName);
		if (userParamNameObj == undefined)
		{
			var userParam = publicJson.originalParamNameObj['USER'];
			userParamNameObj =  Ext.getCmp(userParam);
		}
		if (pwdParamNameObj == undefined)
		{
			var passwordParam = publicJson.originalParamNameObj['PASSWORD'];
			pwdParamNameObj =  Ext.getCmp(passwordParam);
		}
		if (pwdConfirmParamNameObj == undefined)
		{
			var passwordConParam = publicJson.originalParamNameObj['PASSWORDCONFIRMPASSWORD'];
			pwdConfirmParamNameObj =  Ext.getCmp(passwordConParam);
		}
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];
		if (jmxOptionHide)
		{
			if (!(Ext.isEmpty(modeTempObj)))
			{
				modeTempObj.hide();
				Ext.getCmp(snmpPortParamName).setDisabled(true);
				Ext.getCmp(snmpPortParamName).hide();
				var snmpVerObject = '';
				if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
				{
					snmpVerObject = Ext.getCmp('snmpversion');
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
				{
					snmpVerObject = Ext.getCmp('snmpVersion');
				}
				snmpVerObject.setDisabled(true);
				snmpVerObject.hide();

				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
				{
					Ext.getCmp('snmpcommunity').hide();
				}
				else
				{
					Ext.getCmp('snmpCommunity').hide();
				}
				if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
				{
					Ext.getCmp('snmpcommunity').setDisabled(true);
				}
				else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
				{
					Ext.getCmp('snmpCommunity').setDisabled(true);
				}
				this.snmpV3ParamDisabeld(obj);
			}
			if (!(Ext.isEmpty(measureTempObj)))
			{
				measureTempObj.hide();
				Ext.getCmp(logFileParamName).setDisabled(true);
				Ext.getCmp(logFileParamName).hide();
				Ext.getCmp(jreHomeParamName).setDisabled(true);
				Ext.getCmp(jreHomeParamName).hide();
			}
			JMXParamDisable(jmxRemotePortObj);
			JMXParamDisable(jndiNameObj);
			JMXParamDisable(userParamNameObj);
			JMXParamDisable(jmxRegistrySslParamNameObj);
			JMXParamDisable(pwdParamNameObj);
			JMXParamDisable(pwdConfirmParamNameObj);
			JMXParamDisable(providerParamNameObj);
			JMXParamDisable(serviceURLPathNameObj);
			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,false);
		}
		else if (jmxOptionShow)
		{
			if (testName.toLowerCase() == 'jvmmempoolgctest')
			{
				JMXParamEnable(measureTempObj);
				var measureModeLog = Ext.getCmp('measure_mode1').getValue();
				var measureModeJmx = Ext.getCmp('measure_mode2').getValue();
				//me.changeValue(measureTempObj);
				if (measureModeLog)
				{
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(jmxRegistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);
			
					Ext.getCmp(jreHomeParamName).setDisabled(false);
					Ext.getCmp(jreHomeParamName).reset();
					Ext.getCmp(jreHomeParamName).show();
					Ext.getCmp(logFileParamName).setDisabled(false);
					Ext.getCmp(logFileParamName).reset();
					Ext.getCmp(logFileParamName).show();

					showToPwdProfile(pwdProfileShowList,true);
					showToPwdProfile(pwdProfileHideList,false);

				}
				else if (measureModeJmx)
				{
					Ext.getCmp(logFileParamName).setDisabled(true);
					Ext.getCmp(logFileParamName).hide();
					Ext.getCmp(jreHomeParamName).setDisabled(true);
					Ext.getCmp(jreHomeParamName).hide();

					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(jmxRegistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}
			}
			else if (testName.toLowerCase() != 'jvmfiledescriptortest' && testName.toLowerCase() != 'jmxconnectortest' && testName.toLowerCase() != 'jvmsummarytest')
			{
				JMXParamEnable(modeTempObj);
				//me.changeModeValue(modeTempObj);
				var modeSNMP = false;
				var modeJMX = false;
				if(Ext.getCmp('mode1') != undefined){
					modeSNMP = Ext.getCmp('mode1').getValue();
				}	
				if(Ext.getCmp('mode2') != undefined){
				 modeJMX = Ext.getCmp('mode2').getValue();
				}
				
				if (modeSNMP)
				{
					if(isLocalModeParamExist){
						JMXParamDisable(jmxRemotePortObj);
						JMXParamDisable(jndiNameObj);
						JMXParamDisable(userParamNameObj);
						JMXParamDisable(jmxRegistrySslParamNameObj);
						JMXParamDisable(pwdParamNameObj);
						JMXParamDisable(pwdConfirmParamNameObj);
						JMXParamDisable(providerParamNameObj);
						JMXParamDisable(serviceURLPathNameObj);
					}else{
						JMXParamDisable(jmxRemotePortObj);
						JMXParamDisable(jndiNameObj);
						JMXParamDisable(userParamNameObj);
						JMXParamDisable(jmxRegistrySslParamNameObj);
						JMXParamDisable(pwdParamNameObj);
						JMXParamDisable(pwdConfirmParamNameObj);
						JMXParamDisable(providerParamNameObj);
						JMXParamDisable(serviceURLPathNameObj);

						var snmpVerObject = '';
						var snmpVersion = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
							snmpVersion = snmpVerObject.getValue();
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
							snmpVersion = snmpVerObject.getValue();
						}

						Ext.getCmp(snmpPortParamName).setDisabled(false);
						Ext.getCmp(snmpPortParamName).reset();
						Ext.getCmp(snmpPortParamName).setValue(snmpPortextValues);
						Ext.getCmp(snmpPortParamName).show();
						snmpVerObject.setDisabled(false);
						snmpVerObject.show();
						if (!Ext.isEmpty(snmpVersion) && snmpVersion == "v3"  )
						{
							var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
							var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
							var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
							var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
							{
								Ext.getCmp('snmpcommunity').hide();
							}
							else
							{
								Ext.getCmp('snmpCommunity').hide();
							}

							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
							{
								Ext.getCmp('snmpcommunity').setDisabled(true);
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
							{
								Ext.getCmp('snmpCommunity').setDisabled(true);
							}

							Ext.getCmp(snmpUserContextParamName).setDisabled(false);
							Ext.getCmp(snmpUserParamName).setDisabled(false);
							Ext.getCmp(snmpAuthPassParamName).setDisabled(false);
							Ext.getCmp(snmpAuthPassConfirmParamName).setDisabled(false);
							Ext.getCmp(snmpAuthTypeParamName).setDisabled(false);
							Ext.getCmp(snmpEncryptFlagParamName+'_radioGrp').setDisabled(false);
							Ext.getCmp(snmpEngineIDParamName+'_radioGrp').setDisabled(false);
							Ext.getCmp(snmpEncryptTypeParamName).setDisabled(false);
							Ext.getCmp(snmpEncryptPwdParamName).setDisabled(false);
							Ext.getCmp(snmpEncryptConPwdParamName).setDisabled(false);
							Ext.getCmp(snmpUserContextParamName).setValue(snmpUserContextValues);
							Ext.getCmp(snmpUserContextParamName).show();
							Ext.getCmp(snmpUserParamName).setValue(snmpUserTextValues);
							Ext.getCmp(snmpUserParamName).show();

							Ext.getCmp(snmpAuthPassParamName).show();
							Ext.getCmp(snmpAuthPassConfirmParamName).show();
							if (!Ext.isEmpty(selectedSnmpAuthType))
							{
								Ext.getCmp(snmpAuthTypeParamName).setValue(selectedSnmpAuthType);
							}
							else
							{
								Ext.getCmp(snmpAuthTypeParamName).setValue(snmpAuthTypeArr[0].valueField);
							}
							Ext.getCmp(snmpAuthTypeParamName).show();
							
							Ext.getCmp(snmpEngineIDParamName+'_radioGrp').show();
							var enabled = publicJson['enabledEngineID'];
							var disabled = publicJson['disabledEngineID'];
							Ext.getCmp('engineid1').setValue(enabled);
							Ext.getCmp('engineid2').setValue(disabled);

							Ext.getCmp(snmpEncryptFlagParamName+'_radioGrp').show();
							var enabled = publicJson['enabledEncryptFlag'];
							var disabled = publicJson['disabledEncryptFlag'];
							Ext.getCmp('encryptflag1').setValue(enabled);
							Ext.getCmp('encryptflag2').setValue(disabled);
							if (disabled)
							{
								Ext.getCmp(snmpEncryptTypeParamName).hide();
								if (!Ext.isEmpty(selectedSnmpEncType))
								{
									Ext.getCmp(snmpEncryptTypeParamName).setValue(selectedSnmpEncType);
								}
								else
								{
									Ext.getCmp(snmpEncryptTypeParamName).setValue(snmpEncTypeArr[0].valueField);
								}
								Ext.getCmp(snmpEncryptPwdParamName).hide();
								Ext.getCmp(snmpEncryptConPwdParamName).hide();
							}
							else
							{
								Ext.getCmp(snmpEncryptTypeParamName).show();

								if (!Ext.isEmpty(selectedSnmpEncType))
								{
									Ext.getCmp(snmpEncryptTypeParamName).setValue(selectedSnmpEncType);
								}
								else
								{
									Ext.getCmp(snmpEncryptTypeParamName).setValue(snmpEncTypeArr[0].valueField);
								}
								Ext.getCmp(snmpEncryptPwdParamName).show();
								Ext.getCmp(snmpEncryptConPwdParamName).show();
							}
							showToPwdProfile(pwdProfileShowList,true);
							showToPwdProfile(pwdProfileHideList,false);

						}
						else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
						{
							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
							{
								Ext.getCmp('snmpcommunity').setDisabled(false);
								Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
							{
								Ext.getCmp('snmpCommunity').setDisabled(false);
								Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
							}

							if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
							{
								Ext.getCmp('snmpcommunity').show();
							}
							else
							{
								Ext.getCmp('snmpCommunity').show();
							}
							showToPwdProfile(pwdProfileShowList,false);
							showToPwdProfile(pwdProfileHideList,false);
							this.snmpV3ParamDisabeld(obj);
						}
					}
				}
				else if (modeJMX)
				{
					if(isLocalModeParamExist){
						JMXParamEnable(jmxRemotePortObj);
						JMXParamEnable(jndiNameObj);
						JMXParamEnable(userParamNameObj);
						JMXParamEnable(jmxRegistrySslParamNameObj);
						JMXParamEnable(pwdParamNameObj);
						JMXParamEnable(pwdConfirmParamNameObj);
						JMXParamEnable(providerParamNameObj);
						JMXParamEnable(serviceURLPathNameObj);

						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,true);
					}else{
						Ext.getCmp(snmpPortParamName).setDisabled(true);
						Ext.getCmp(snmpPortParamName).hide();
						var snmpVerObject = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
						}
						snmpVerObject.setDisabled(true);
						snmpVerObject.hide();

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').hide();
						}
						else
						{
							Ext.getCmp('snmpCommunity').hide();
						}
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(true);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(true);
						}
						this.snmpV3ParamDisabeld(obj);

						JMXParamEnable(jmxRemotePortObj);
						JMXParamEnable(jndiNameObj);
						JMXParamEnable(userParamNameObj);
						JMXParamEnable(jmxRegistrySslParamNameObj);
						JMXParamEnable(pwdParamNameObj);
						JMXParamEnable(pwdConfirmParamNameObj);
						JMXParamEnable(providerParamNameObj);
						JMXParamEnable(serviceURLPathNameObj);

						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,true);
					}
				}
			}
			else
			{
				JMXParamEnable(jmxRemotePortObj);
				JMXParamEnable(jndiNameObj);
				JMXParamEnable(userParamNameObj);
				JMXParamEnable(jmxRegistrySslParamNameObj);
				JMXParamEnable(pwdParamNameObj);
				JMXParamEnable(pwdConfirmParamNameObj);
				JMXParamEnable(providerParamNameObj);
				JMXParamEnable(serviceURLPathNameObj);
			}
		}
	},

	changeModeValue: function(obj) {
		var radioGroupId = '';
		value = obj.getBox().y;
		if (!Ext.isEmpty(obj))
		{
			radioGroupId = obj.id;
			if (radioGroupId.lastIndexOf('_') > -1)
			{
				radioGroupId = radioGroupId.substring(0,radioGroupId.lastIndexOf('_'));
			}
		}
		if (radioGroupId.toLowerCase() == 'mode')
		{
			var modeSNMP = Ext.getCmp('mode1').getValue();
			var modeJMX = Ext.getCmp('mode2').getValue();

			var jmxRemotePort = publicJson.originalParamNameObj['JMX_REMOTE_PORT'];
			var jndiName = publicJson.originalParamNameObj['JNDI_NAME'];
			var userParamName = publicJson.originalParamNameObj['JMX_USER'];
			var jmxRegistrySslParamName = publicJson.originalParamNameObj['JMX_REGISTRY_SSL'];
			jmxRegistrySslParamName = jmxRegistrySslParamName+'_radioGrp';
			var pwdParamName = publicJson.originalParamNameObj['JMX_PASSWORD'];
			var pwdConfirmParamName = publicJson.originalParamNameObj['JMX_PASSWORDCONFIRMPASSWORD'];
			var providerParamName = publicJson.originalParamNameObj['PROVIDER'];

			var snmpPortParamName = publicJson.originalParamNameObj['SNMPPORT'];
			var snmpUserContextParamName = publicJson.originalParamNameObj['CONTEXT'];
			var snmpUserParamName = publicJson.originalParamNameObj['USERNAME'];
			var snmpAuthPassParamName = publicJson.originalParamNameObj['AUTHPASS'];
			var snmpAuthPassConfirmParamName = publicJson.originalParamNameObj['AUTHPASSCONFIRMPASSWORD'];
			var snmpAuthTypeParamName = publicJson.originalParamNameObj['AUTHTYPE'];
			var snmpEncryptFlagParamName = publicJson.originalParamNameObj['ENCRYPTFLAG'];
			var snmpEngineIDParamName = publicJson.originalParamNameObj['ENGINEID'];
			var snmpEncryptTypeParamName = publicJson.originalParamNameObj['ENCRYPTTYPE'];
			var snmpEncryptPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORD'];
			var snmpEncryptConPwdParamName = publicJson.originalParamNameObj['ENCRYPTPASSWORDCONFIRMPASSWORD'];
			var serviceURLPathName = publicJson.originalParamNameObj['SERVICE_URL_PATH'];
			var jmxRemotePortObj = Ext.getCmp(jmxRemotePort); 
			var jndiNameObj = Ext.getCmp(jndiName);
			var userParamNameObj = Ext.getCmp(userParamName);
			var jmxRegistrySslParamNameObj = Ext.getCmp(jmxRegistrySslParamName);
			var pwdParamNameObj = Ext.getCmp(pwdParamName);
			var pwdConfirmParamNameObj = Ext.getCmp(pwdConfirmParamName);
			var providerParamNameObj = Ext.getCmp(providerParamName);
			var serviceURLPathNameObj = Ext.getCmp(serviceURLPathName);
			var isLocalModeParamExist = publicJson['isLocalModeParamExist'];
			if (userParamNameObj == undefined)
			{
				var userParam = publicJson.originalParamNameObj['USER'];
				userParamNameObj =  Ext.getCmp(userParam);
			}
			if (pwdParamNameObj == undefined)
			{
				var passwordParam = publicJson.originalParamNameObj['PASSWORD'];
				pwdParamNameObj =  Ext.getCmp(passwordParam);
			}
			if (pwdConfirmParamNameObj == undefined)
			{
				var passwordConParam = publicJson.originalParamNameObj['PASSWORDCONFIRMPASSWORD'];
				pwdConfirmParamNameObj =  Ext.getCmp(passwordConParam);
			}

			var pwdProfileShowList = publicJson['showPwdParams'];
			var pwdProfileHideList = publicJson['hidePwdParams'];

			if (modeSNMP)
			{
				if(isLocalModeParamExist)
				{
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(jmxRegistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,false);

				}
				else{
					JMXParamDisable(jmxRemotePortObj);
					JMXParamDisable(jndiNameObj);
					JMXParamDisable(userParamNameObj);
					JMXParamDisable(jmxRegistrySslParamNameObj);
					JMXParamDisable(pwdParamNameObj);
					JMXParamDisable(pwdConfirmParamNameObj);
					JMXParamDisable(providerParamNameObj);
					JMXParamDisable(serviceURLPathNameObj);

					//Ext.getCmp('Jmx_Remote_Port').setDisabled(true);
					//Ext.getCmp('Jmx_Remote_Port').hide();
					//Ext.getCmp('Jndi_Name').setDisabled(true);
					//Ext.getCmp('Jndi_Name').hide();
					//Ext.getCmp('user').setDisabled(true);
					//Ext.getCmp('user').hide();
					//Ext.getCmp('password').setDisabled(true);
					//Ext.getCmp('password').hide();
					//Ext.getCmp('passwordconfirmpassword').setDisabled(true);
					//Ext.getCmp('passwordconfirmpassword').hide();

					var snmpVerObject = '';
					var snmpVersion = '';
					if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpversion');
						snmpVersion = snmpVerObject.getValue();
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpVersion');
						snmpVersion = snmpVerObject.getValue();
					}

					Ext.getCmp(snmpPortParamName).setDisabled(false);
					Ext.getCmp(snmpPortParamName).reset();
					Ext.getCmp(snmpPortParamName).setValue(snmpPortextValues);
					Ext.getCmp(snmpPortParamName).show();

					//Ext.getCmp('snmpPort').setDisabled(false);
					//Ext.getCmp('snmpPort').reset();
					//Ext.getCmp('snmpPort').setValue(snmpPortextValues);
					//Ext.getCmp('snmpPort').show();
					snmpVerObject.setDisabled(false);
					snmpVerObject.show();
					if (!Ext.isEmpty(snmpVersion) && snmpVersion == "v3"  )
					{
						var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
						var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
						var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
						var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').hide();
						}
						else
						{
							Ext.getCmp('snmpCommunity').hide();
						}

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(true);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(true);
						}

						Ext.getCmp(snmpUserContextParamName).setDisabled(false);
						Ext.getCmp(snmpUserParamName).setDisabled(false);
						Ext.getCmp(snmpAuthPassParamName).setDisabled(false);
						Ext.getCmp(snmpAuthPassConfirmParamName).setDisabled(false);
						Ext.getCmp(snmpAuthTypeParamName).setDisabled(false);
						Ext.getCmp(snmpEncryptFlagParamName+'_radioGrp').setDisabled(false);
						Ext.getCmp(snmpEngineIDParamName+'_radioGrp').setDisabled(false);
						Ext.getCmp(snmpEncryptTypeParamName).setDisabled(false);
						Ext.getCmp(snmpEncryptPwdParamName).setDisabled(false);
						Ext.getCmp(snmpEncryptConPwdParamName).setDisabled(false);
						Ext.getCmp(snmpUserContextParamName).setValue(snmpUserContextValues);
						Ext.getCmp(snmpUserContextParamName).show();
						Ext.getCmp(snmpUserParamName).setValue(snmpUserTextValues);
						Ext.getCmp(snmpUserParamName).show();

						Ext.getCmp(snmpAuthPassParamName).show();
						Ext.getCmp(snmpAuthPassConfirmParamName).show();

						//Ext.getCmp('username').setDisabled(false);
						//Ext.getCmp('authpass').setDisabled(false);
						//Ext.getCmp('authpassconfirmpassword').setDisabled(false);
						//Ext.getCmp('authtype').setDisabled(false);
						//Ext.getCmp('encryptflag_radioGrp').setDisabled(false);
						//Ext.getCmp('encrypttype').setDisabled(false);
						//Ext.getCmp('encryptpassword').setDisabled(false);
						//Ext.getCmp('encryptpasswordconfirmpassword').setDisabled(false);
						//Ext.getCmp('username').setValue(snmpUserTextValues);
						//Ext.getCmp('username').show();

						//Ext.getCmp('authpass').show();
						//Ext.getCmp('authpassconfirmpassword').show();
						if (!Ext.isEmpty(selectedSnmpAuthType))
						{
							Ext.getCmp(snmpAuthTypeParamName).setValue(selectedSnmpAuthType);
						}
						else
						{
							Ext.getCmp(snmpAuthTypeParamName).setValue(snmpAuthTypeArr[0].valueField);
						}
						Ext.getCmp(snmpAuthTypeParamName).show();
						
						Ext.getCmp(snmpEngineIDParamName+'_radioGrp').show();
						var enabled = publicJson['enabledEngineID'];
						var disabled = publicJson['disabledEngineID'];
						Ext.getCmp('engineid1').setValue(enabled);
						Ext.getCmp('engineid2').setValue(disabled);

						Ext.getCmp(snmpEncryptFlagParamName+'_radioGrp').show();
						var enabled = publicJson['enabledEncryptFlag'];
						var disabled = publicJson['disabledEncryptFlag'];
						Ext.getCmp('encryptflag1').setValue(enabled);
						Ext.getCmp('encryptflag2').setValue(disabled);
						if (disabled)
						{
							Ext.getCmp(snmpEncryptTypeParamName).hide();
							if (!Ext.isEmpty(selectedSnmpEncType))
							{
								Ext.getCmp(snmpEncryptTypeParamName).setValue(selectedSnmpEncType);
							}
							else
							{
								Ext.getCmp(snmpEncryptTypeParamName).setValue(snmpEncTypeArr[0].valueField);
							}
							Ext.getCmp(snmpEncryptPwdParamName).hide();
							Ext.getCmp(snmpEncryptConPwdParamName).hide();
						}
						else
						{
							Ext.getCmp(snmpEncryptTypeParamName).show();

							if (!Ext.isEmpty(selectedSnmpEncType))
							{
								Ext.getCmp(snmpEncryptTypeParamName).setValue(selectedSnmpEncType);
							}
							else
							{
								Ext.getCmp(snmpEncryptTypeParamName).setValue(snmpEncTypeArr[0].valueField);
							}
							Ext.getCmp(snmpEncryptPwdParamName).show();
							Ext.getCmp(snmpEncryptConPwdParamName).show();
						}
						showToPwdProfile(pwdProfileShowList,true);
						showToPwdProfile(pwdProfileHideList,false);

					}
					else if (!Ext.isEmpty(snmpVersion) && (snmpVersion == "v1" || snmpVersion =="v2")  )
					{
						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
						{
							Ext.getCmp('snmpcommunity').setDisabled(false);
							Ext.getCmp('snmpcommunity').setValue(snmpCommunityTextValues);
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
						{
							Ext.getCmp('snmpCommunity').setDisabled(false);
							Ext.getCmp('snmpCommunity').setValue(snmpCommunityTextValues);
						}

						if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
						{
							Ext.getCmp('snmpcommunity').show();
						}
						else
						{
							Ext.getCmp('snmpCommunity').show();
						}
						showToPwdProfile(pwdProfileShowList,false);
						showToPwdProfile(pwdProfileHideList,false);
						this.snmpV3ParamDisabeld(obj);
					}
				}
			}
			else if (modeJMX)
			{
				if(isLocalModeParamExist){
					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(jmxRegistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}else{
					Ext.getCmp(snmpPortParamName).setDisabled(true);
					Ext.getCmp(snmpPortParamName).hide();
					var snmpVerObject = '';
					if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpversion');
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
					{
						snmpVerObject = Ext.getCmp('snmpVersion');
					}
					snmpVerObject.setDisabled(true);
					snmpVerObject.hide();

					if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined)
					{
						Ext.getCmp('snmpcommunity').hide();
					}
					else
					{
						Ext.getCmp('snmpCommunity').hide();
					}
					if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined )
					{
						Ext.getCmp('snmpcommunity').setDisabled(true);
					}
					else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined )
					{
						Ext.getCmp('snmpCommunity').setDisabled(true);
					}
					this.snmpV3ParamDisabeld(obj);

					JMXParamEnable(jmxRemotePortObj);
					JMXParamEnable(jndiNameObj);
					JMXParamEnable(userParamNameObj);
					JMXParamEnable(jmxRegistrySslParamNameObj);
					JMXParamEnable(pwdParamNameObj);
					JMXParamEnable(pwdConfirmParamNameObj);
					JMXParamEnable(providerParamNameObj);
					JMXParamEnable(serviceURLPathNameObj);

					showToPwdProfile(pwdProfileShowList,false);
					showToPwdProfile(pwdProfileHideList,true);
				}

			}
			//var heapYes = Ext.getCmp('Heap_Analysis1').getValue();
			//var heapNo = Ext.getCmp('Heap_Analysis2').getValue();

			//if (heapYes)
			//{
				//if (paramName == 'Java_Home')
				//{
					//Ext.getCmp('Java_Home').setDisabled(false);
					//Ext.getCmp('JAVA_HOME').show();
				//}
				//else if (paramName == 'Include_Packages')
				//{
					//Ext.getCmp('Include_Packages').setDisabled(false);
					//Ext.getCmp('INCLUDE_PACKAGES').show();
				//}
				//else if (paramName == 'Exclude_Packages')
				//{
					//Ext.getCmp('Exclude_Packages').setDisabled(false);
					//Ext.getCmp('EXCLUDE_PACKAGES').show();
				//}
			//}
			//else if (heapNo)
			//{
				//if (paramName == 'Java_Home')
				//{
					//Ext.getCmp('Java_Home').setDisabled(false);
					//Ext.getCmp('JAVA_HOME').show();
				//}
				//else if (paramName == 'Include_Packages')
				//{
					//Ext.getCmp('Include_Packages').setDisabled(false);
					//Ext.getCmp('INCLUDE_PACKAGES').show();
				//}
				//else if (paramName == 'Exclude_Packages')
				//{
					//Ext.getCmp('Exclude_Packages').setDisabled(false);
					//Ext.getCmp('EXCLUDE_PACKAGES').show();
				//}
			//}
		}
		else if (radioGroupId.toLowerCase() == 'heap_analysis')
		{
			var heapAnalysisParamName = publicJson.originalParamNameObj['HEAP_ANALYSIS'];
			var javaHomeParamName = publicJson.originalParamNameObj['JAVA_HOME'];
			var includePackParamName = publicJson.originalParamNameObj['INCLUDE_PACKAGES'];
			var excludePackParamName = publicJson.originalParamNameObj['EXCLUDE_PACKAGES'];
			var excludeHeapDumpLocation = publicJson.originalParamNameObj['HEAP_DUMP_LOCATION'];

			var heapYes = Ext.getCmp(heapAnalysisParamName+'1').getValue();
			var heapNo = Ext.getCmp(heapAnalysisParamName+'2').getValue();
			if (heapYes)
			{
				Ext.getCmp(javaHomeParamName).setDisabled(false);
				Ext.getCmp(javaHomeParamName).show();
				Ext.getCmp(includePackParamName).setDisabled(false);
				Ext.getCmp(includePackParamName).show();
				Ext.getCmp(excludePackParamName).setDisabled(false);
				Ext.getCmp(excludePackParamName).show();
				Ext.getCmp(excludeHeapDumpLocation).setDisabled(false);
				Ext.getCmp(excludeHeapDumpLocation).show();
			}
			else if (heapNo)
			{
				Ext.getCmp(javaHomeParamName).setDisabled(true);
				Ext.getCmp(javaHomeParamName).hide();
				Ext.getCmp(includePackParamName).setDisabled(true);
				Ext.getCmp(includePackParamName).hide();
				Ext.getCmp(excludePackParamName).setDisabled(true);
				Ext.getCmp(excludePackParamName).hide();
				Ext.getCmp(excludeHeapDumpLocation).setDisabled(true);
				Ext.getCmp(excludeHeapDumpLocation).hide();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',value);
	},
	changeSAPControl: function(obj) 
	{
		var useSAPControlYes = Ext.getCmp('use_sapcontrol1').getValue();
		var useSAPControlNo = Ext.getCmp('use_sapcontrol2').getValue();
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];
    
		if (useSAPControlNo)
		{
			Ext.getCmp('ssl_radioGrp').setDisabled(true);
			Ext.getCmp('ssl_radioGrp').hide();
			Ext.getCmp('os_username').setDisabled(true);
			Ext.getCmp('os_username').hide();
			Ext.getCmp('os_password').setDisabled(true);
			Ext.getCmp('os_password').hide();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('os_passwordconfirmpassword').hide();
			Ext.getCmp('wsdl_port').setDisabled(true);
			Ext.getCmp('wsdl_port').hide();

			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}
		else if (useSAPControlYes)
		{
			Ext.getCmp('timeout').setDisabled(true);
			Ext.getCmp('timeout').hide();
			Ext.getCmp('sapuser').setDisabled(true);
			Ext.getCmp('sapuser').hide();
			Ext.getCmp('password').setDisabled(true);
			Ext.getCmp('password').hide();
			Ext.getCmp('passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('passwordconfirmpassword').hide();
			Ext.getCmp('sysno').setDisabled(true);
			Ext.getCmp('sysno').hide();
			Ext.getCmp('clientname').setDisabled(true);
			Ext.getCmp('clientname').hide();
			Ext.getCmp('router').setDisabled(true);
			Ext.getCmp('router').hide();
			Ext.getCmp('Jco_version').setDisabled(true);
			Ext.getCmp('Jco_version').hide();
			Ext.getCmp('instancename').setDisabled(true);
			Ext.getCmp('instancename').hide();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();
	
			showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);
		}
	},
	changeSAPControlSelect: function(obj) 
	{
		var pwdProfileShowList = publicJson['showPwdParams'];
		var pwdProfileHideList = publicJson['hidePwdParams'];

		var useSAPControl = Ext.getCmp('use_sapcontrol').getValue();
		if (useSAPControl.toLowerCase() == 'no' || useSAPControl.toLowerCase() == 'false')
		{
			Ext.getCmp('ssl_radioGrp').setDisabled(true);
			Ext.getCmp('ssl_radioGrp').hide();
			Ext.getCmp('os_username').setDisabled(true);
			Ext.getCmp('os_username').hide();
			Ext.getCmp('os_password').setDisabled(true);
			Ext.getCmp('os_password').hide();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('os_passwordconfirmpassword').hide();
			Ext.getCmp('wsdl_port').setDisabled(true);
			Ext.getCmp('wsdl_port').hide();

			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			showToPwdProfile(pwdProfileShowList,false);
			showToPwdProfile(pwdProfileHideList,true);
		}
		else if (useSAPControl.toLowerCase() == 'yes' || useSAPControl.toLowerCase() == 'true')
		{
			Ext.getCmp('timeout').setDisabled(true);
			Ext.getCmp('timeout').hide();
			Ext.getCmp('sapuser').setDisabled(true);
			Ext.getCmp('sapuser').hide();
			Ext.getCmp('password').setDisabled(true);
			Ext.getCmp('password').hide();
			Ext.getCmp('passwordconfirmpassword').setDisabled(true);
			Ext.getCmp('passwordconfirmpassword').hide();
			Ext.getCmp('sysno').setDisabled(true);
			Ext.getCmp('sysno').hide();
			Ext.getCmp('clientname').setDisabled(true);
			Ext.getCmp('clientname').hide();
			Ext.getCmp('router').setDisabled(true);
			Ext.getCmp('router').hide();
			Ext.getCmp('Jco_version').setDisabled(true);
			Ext.getCmp('Jco_version').hide();
			Ext.getCmp('instancename').setDisabled(true);
			Ext.getCmp('instancename').hide();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();

			showToPwdProfile(pwdProfileShowList,true);
			showToPwdProfile(pwdProfileHideList,false);
		}
		else 
		{
			Ext.getCmp('timeout').setDisabled(false);
			Ext.getCmp('timeout').show();
			Ext.getCmp('sapuser').setDisabled(false);
			Ext.getCmp('sapuser').show();
			Ext.getCmp('password').setDisabled(false);
			Ext.getCmp('password').show();
			Ext.getCmp('passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('passwordconfirmpassword').show();
			Ext.getCmp('sysno').setDisabled(false);
			Ext.getCmp('sysno').show();
			Ext.getCmp('clientname').setDisabled(false);
			Ext.getCmp('clientname').show();
			Ext.getCmp('router').setDisabled(false);
			Ext.getCmp('router').show();
			Ext.getCmp('Jco_version').setDisabled(false);
			Ext.getCmp('Jco_version').show();
			Ext.getCmp('instancename').setDisabled(false);
			Ext.getCmp('instancename').show();

			Ext.getCmp('ssl_radioGrp').setDisabled(false);
			Ext.getCmp('ssl_radioGrp').show();
			Ext.getCmp('os_username').setDisabled(false);
			Ext.getCmp('os_username').show();
			Ext.getCmp('os_password').setDisabled(false);
			Ext.getCmp('os_password').show();
			Ext.getCmp('os_passwordconfirmpassword').setDisabled(false);
			Ext.getCmp('os_passwordconfirmpassword').show();
			Ext.getCmp('wsdl_port').setDisabled(false);
			Ext.getCmp('wsdl_port').show();
		}
	},
	continueParamMethod: function(testCase,name) {
		if (!Ext.isEmpty(testCase))
		{
			var testCaseArray = testCase.split(",");
			for (var key = 0;key < testCaseArray.length ;key++ )
			{
				if (name.toLowerCase() == testCaseArray[key].toLowerCase())
				{
					return true;
				}
			}
			return false;
		}
	},
	clearHiddenFields: function() {
		var formObj = this.getTestconfiguration().getForm();
		var fieldsArr = formObj.getFields().items;
		for (var i in fieldsArr)
		{
			if (fieldsArr[i].xtype == 'hiddenfield')
			{
				Ext.getCmp(fieldsArr[i].id).setValue("");
			}
		}
		var selectFilterObj = Ext.getCmp('selectedFilterType');
		if (!Ext.getCmp(selectFilterObj) && selectFilterObj != undefined)
		{
			Ext.getCmp('selectedFilterType').setValue("");
		}
	},
	populate: function(btn) {
		var formObj = Ext.getCmp('testConfigForm').getForm();
		var testName = publicJson['testName'];
		var multiUserMode = publicJson['multiUserMode'];
		var allowHostName = publicJson['isAllowHostName'];
		var unConfigTestsCount = Ext.getCmp('unconfigTests').getStore().getCount();
		var configTestsCount = Ext.getCmp('configTests').getStore().getCount();
		var excludeTestsCount = Ext.getCmp('excludeTests').getStore().getCount();
		var allowToUpdate = populate(testName,'specificConfiguration',multiUserMode,allowHostName,formObj);
		var btnId = btn.id;
		
		if(testName == 'DiskSpaceTest' || testName == 'WVDDiskSpaceTest')
		{
			if(Ext.getCmp('drive_name') != null)
			{
			var driveNms = Ext.getCmp('drive_name').getValue();
			var automtActionEnbld = "";

			if(testName == 'DiskSpaceTest')
			{
				automtActionEnbld = Ext.getCmp("autmtd_actn_enbld_dskspc"+'1').getValue();
			}
			else if(testName == 'WVDDiskSpaceTest')
			{
				automtActionEnbld = Ext.getCmp("autmtd_actn_enbld_wvd_dskspc"+'1').getValue();
			}

			if(automtActionEnbld)
			{
				if(driveNms == null || driveNms.trim() == '' || driveNms.trim() == 'none')
				{
					Ext.MessageBox.show({
						title : specificTestTitle,
						msg : errMsgDiskSpcCnfgrRule,
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
			}			
		}
		}
		
		if (btnId == 'applyToOtherBtn' && clickedFrom == '')
		{
			if (fromApply == 'reconfig')
			{
				clickedFrom = "reconfigurebutton";
			}
			else
			{
				clickedFrom = "configurebutton";
			}
		}
		else if (!Ext.isEmpty(btnId) && btnId != undefined && btnId == 'updateBtn')
		{
			Ext.getCmp('unconfiguredCompType').dataArray = true;
			unconfigCompChecked = '';
			clickedFrom = '';
			testName = '';
			var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

			if (!Ext.isEmpty(backBtnFrom))
			{
				reqFrom = backBtnFrom;
			}
			else
			{
				reqFrom = '';
			}
		}

		if (allowToUpdate)
		{
			var isApplyAll = false;
			var btnId = btn.id;
			if (!Ext.isEmpty(btnId) && btnId != undefined && btnId == 'applyToOtherBtn')
			{
				isApplyAll = true; //(!Ext.isEmpty(applyAll) && applyAll != undefined && applyAll);
			}
			var filterMSObj = Ext.getCmp('filter_combo');
			if (!Ext.isEmpty(filterMSObj))
			{
				var filterMSCount = Ext.getCmp('filter_combo').getStore().getCount();
				if (filterMSCount == 0)
				{
					Ext.getCmp('filter_combo').setDisabled(true);
				}
			}

			if (unConfigTestsCount == 0)
			{
				Ext.getCmp('unconfigTests').setDisabled(true);
			}
			if (configTestsCount == 0)
			{
				Ext.getCmp('configTests').setDisabled(true);
			}
			if (excludeTestsCount == 0)
			{
				Ext.getCmp('excludeTests').setDisabled(true);
			}
			existingParams = formObj.getValues(true);
			if (isApplyAll)
			{
				encodeParamListFromBackup = publicJson['encodeParamList'];
				// for url params hiddenURLs append to apply to other components starts here...
				var hiddenURLObj = Ext.getCmp('hiddenURLs');
				var hiddenURLs = '';
				if (!Ext.isEmpty(hiddenURLObj))
				{
					hiddenURLs = hiddenURLObj.getValue();
				}

				var hiddenFieldsContainer = {
					xtype: 'container',
					id: 'hiddenFieldContainer',
					layout: {
						type: 'vbox',
						align: 'center',
						pack: 'center'
					},
					items: []
				};
				// for url params hiddenURLs append to apply to other components ends here...
				

				// for url params hiddenPublishedResource append to apply to other components starts here...
				var hiddenPubReSrcObj = Ext.getCmp('hiddenPublishedResource');
				var hiddenPubReSrcs = '';
				if (!Ext.isEmpty(hiddenPubReSrcObj))
				{
					hiddenPubReSrcs = hiddenPubReSrcObj.getValue();
				}
				// for url params hiddenPublishedResource append to apply to other components ends here...


				// for url params hiddenSiteURL append to apply to other components starts here...
				var hiddenSiteURLObj = Ext.getCmp('site_URL(S)');
				var hiddenSiteURL = '';
				if (!Ext.isEmpty(hiddenSiteURLObj))
				{
					hiddenSiteURL = hiddenSiteURLObj.backupValue;
				}
				// for url params hiddenSiteURL append to apply to other components ends here...

				var newCheckGridSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
					selType: 'checkboxmodel',
					mode: 'MULTI',
					checkOnly: true,
					deselectAll: function() {
						var rowIndex=0;
						while(typeof(Ext.getCmp('paramsGrid').getStore().getAt(rowIndex))!='undefined') {
							var record = Ext.getCmp('paramsGrid').getStore().getAt(rowIndex);
							Ext.getCmp('paramsGrid').getSelectionModel().deselect(rowIndex, true);
							rowIndex++;
						}
						var view = Ext.getCmp('paramsGrid').getView();
						var headerCt = view.headerCt;
						var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
						if (checkHd)
						{
							//checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
						}
					}
				});
				var homepage = Ext.getCmp('specificTestConfigViewPort');
				var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

				myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
				me.clearHiddenFields();
				if (Ext.getCmp('unconfigTests').isDisabled())
				{
					Ext.getCmp('unconfigTests').setDisabled(false);
				}
				if (Ext.getCmp('configTests').isDisabled())
				{
					Ext.getCmp('configTests').setDisabled(false);
				}
				if (Ext.getCmp('excludeTests').isDisabled())
				{
					Ext.getCmp('excludeTests').setDisabled(false);
				}
				homepage.removeAll();
				myMask.show();
				homepage.add({ xtype : 'applytoothercomponents' });
				if (!Ext.isEmpty(backBtnFrom))
				{
					Ext.getCmp('applyToOtherViewForm').isBackButton = backBtnFrom;
				}
				else
				{
					Ext.getCmp('applyToOtherViewForm').isBackButton = '';
				}

				// for url params hiddenURLs append to apply to other components starts here...
				if (!Ext.isEmpty(hiddenURLs))
				{
					var hiddenArray = new Array();
					Ext.getCmp('applyToOtherViewForm').add(hiddenFieldsContainer);
					Ext.getCmp('hiddenFieldContainer').add({
						xtype: 'hiddenfield',
						name: 'hiddenURLs',
						id: 'hiddenURLs',
						value: hiddenURLs,
					});
				}
				// for url params hiddenURLs append to apply to other components ends here...


				//for siteurl(s) 
				//for url params hiddenSiteURL append to apply to other components starts here...
				if (!Ext.isEmpty(hiddenSiteURL))
				{
					var hiddenArray = new Array();
					Ext.getCmp('applyToOtherViewForm').add(hiddenFieldsContainer);
					Ext.getCmp('hiddenFieldContainer').add({
						xtype: 'hiddenfield',
						name: 'hiddenSiteURL',
						id: 'hiddenSiteURL',
						value: hiddenSiteURL,
					});
				}
				// for url params hiddenSiteURL append to apply to other components ends here...



				// for published resources params hidden value append to apply to other components starts here...
				if (!Ext.isEmpty(hiddenPubReSrcs))
				{
					var hiddenArray = new Array();
					var hiddenContObj = Ext.getCmp('hiddenFieldContainer');
					if (Ext.isEmpty(hiddenContObj))
					{
						Ext.getCmp('applyToOtherViewForm').add(hiddenFieldsContainer);
					}
					//Ext.getCmp('applyToOtherViewForm').add(hiddenFieldsContainer);
					Ext.getCmp('hiddenFieldContainer').add({
						xtype: 'hiddenfield',
						name: 'hiddenPublishedResource',
						id: 'hiddenPublishedResource',
						value: hiddenPubReSrcs,
					});
				}

				// forpublished resources params hidden value append to apply to other components ends here...

				var tmpGrid = {
					xtype: 'grid',
					ui:'newGridPanel whiteHeader',
					id: 'paramsGrid',
					name: 'paramsGrid',
					store: new Ext.data.Store({
						fields: ['ParamName','ParamValue','uniqueId'],
						data: []
					}),
					title: 'Parameters of Testname | Component : windows3 (Windows)',
					autoScroll: true,
					selModel: newCheckGridSelectionModel,
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false,
							isCheckerHd: true
						},
						items: [
							{
								text: paramName,
								dataIndex: 'ParamName',
								id: 'pNameId',
								checked: true,
								width: 250,
							},
							{
								text: paramValue,
								dataIndex: 'ParamValue',
								id: 'pValueId',
								flex:1,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									if (!Ext.isString(value))//.toLowerCase() != 'none' )
									{
										value = JSON.stringify(value);
									}
									return value;
								}

							}
						]
					},
					margin: '15 20 15 20',
					height: 150
				}
				var tmpObj = Ext.getCmp('tmpApplyToOther');
				Ext.suspendLayouts();
				tmpObj.removeAll();
				tmpObj.add(tmpGrid);
				Ext.resumeLayouts(true);
				myMask.hide();
			}
			else
			{
				//var me = this;
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();
				var tmpURL = 'SpecificTestConfiguration/data/EgConfigureComponentTestsp.jsp?';

				var frmMain = this.getTestconfiguration().getForm();
				if (frmMain.isValid())
				{
					// site_URL code
					var siteURLObj = Ext.getCmp('site_URL(S)');

					if (!Ext.isEmpty(siteURLObj))
					{
					var backupValue = siteURLObj.backupValue;

						Ext.getCmp('hiddenFieldContainer').add({
							xtype: 'hiddenfield',
							name: 'hiddenSiteURL',
							id: 'hiddenSiteURL',
						value: backupValue,
						});
					}

					this.getTestconfiguration().submit({
						url: tmpURL,
						method: 'POST',
						params: me.encodeFieldParams(frmMain),
						timeout: 60000,
						//standardSubmit: true,
						success: function(form, action){
							myMask.hide();
							Ext.Msg.show({
								title:pageName,
								msg: alertMsg78,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
									me.clearHiddenFields();
									if (Ext.getCmp('unconfigTests').isDisabled())
									{
										Ext.getCmp('unconfigTests').setDisabled(false);
									}
									if (Ext.getCmp('configTests').isDisabled())
									{
										Ext.getCmp('configTests').setDisabled(false);
									}
									if (Ext.getCmp('excludeTests').isDisabled())
									{
										Ext.getCmp('excludeTests').setDisabled(false);
									}
									me.afterMainRender();
								}
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							reqFrom = '';
							var jsonText = Ext.decode(action.response.responseText);
							if(jsonText.successUpdate == 'true')
							{
								myMask.hide();
								if (Ext.getCmp('unconfigTests').isDisabled())
								{
									Ext.getCmp('unconfigTests').setDisabled(false);
								}
								if (Ext.getCmp('configTests').isDisabled())
								{
									Ext.getCmp('configTests').setDisabled(false);
								}
								if (Ext.getCmp('excludeTests').isDisabled())
								{
									Ext.getCmp('excludeTests').setDisabled(false);
								}
								me.afterMainRender();
								me.clearHiddenFields();
							}
							else
							{
								myMask.hide();
								if (Ext.getCmp('unconfigTests').isDisabled())
								{
									Ext.getCmp('unconfigTests').setDisabled(false);
								}
								if (Ext.getCmp('configTests').isDisabled())
								{
									Ext.getCmp('configTests').setDisabled(false);
								}
								if (Ext.getCmp('excludeTests').isDisabled())
								{
									Ext.getCmp('excludeTests').setDisabled(false);
								}
								me.afterMainRender();
								me.clearHiddenFields();
							}
						}
					});
				}
			}
		}
	},
	validate : function() {
		var me = this;
		var validationLoadingMsg2 = "<table border='0' style='height:170px;width:700px;'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top class='commonErrorMsgText'>"+alertValidate+"</td></tr></table>";
		var validationLoadingMgrMsg2 = "<table border='0' style='height:170px;width:700px;'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top class='commonErrorMsgText'>"+alertMgrValidate+"</td></tr></table>";
		var formObj = Ext.getCmp('testConfigForm').getForm();
		var paramsToSend = publicJson['paramsForValidationURL'];
		var componentType = publicJson['componentType'];
		var componName = publicJson['componentName'];
		var testName = publicJson['testName'];
		var multiUserMode = publicJson['multiUserMode'];
		var allowHostName = publicJson['isAllowHostName'];
		var requiredParamNames = publicJson['requiredParamNames'];
		var fromPage = "testConfig";
		var from = "pickAgentToValidate";

		var wsdlObj = Ext.getCmp("WSDL_URL");
		if (Ext.isEmpty(wsdlObj) || wsdlObj == undefined)
		{
			wsdlObj = Ext.getCmp("wsdl_url");
		}

		if (componName.indexOf(":NULL") > -1)
		{
			componName = componName.substring(0,componName.indexOf(":NULL"));
		}
		var validationURL = "";
		var credentialValue = "";
		var isXDMGetDevicesInfo = publicJson['isXDMGetDevicesInfo'];

		var xenValidation = Ext.getCmp("username");
		var xenname = "";
		var xenpassword = "";
		var xenValidationURL = "";

		if (isXDMGetDevicesInfo && !Ext.isEmpty(xenValidation) && xenValidation != "undefined" )
		{
			if (wsdlObj != null && wsdlObj != '')
			{
				var urlValue = wsdlObj.getValue();
				if ((Ext.isEmpty(urlValue) || urlValue == undefined))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: enterValidWsdl,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
					});
					return false;
				}
				else if (urlValue.toLowerCase() != 'none' && (urlValue.indexOf("http") < 0 && urlValue.indexOf("https") < 0 ) )
				{
					Ext.Msg.show ({
						title: pageName,
						msg: enterValidWsdl,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
					});
					return false;
				}

			}
			xenname = Ext.getCmp("username").getValue();
			xenpassword = Ext.getCmp("password").getValue();
			xenValidationURL = xenValidationURL+"&xenMobileUserName="+xenname+"&xenMobilePassword="+xenpassword;
		}
		
		var paramWithValue = validateAppServerCredentailsValue('specificConfiguration','SpecificTestConfiguration/data/validateApplicationServerCredentials.jsp?',paramsToSend,from,componentType,testName,multiUserMode,allowHostName,requiredParamNames,formObj);
		var isvalidUpdate = paramWithValue.substring(0,paramWithValue.indexOf("*"));
		var paramsWithValue = paramWithValue.substring(paramWithValue.indexOf("*")+1);

		if (wsdlObj != null && wsdlObj != '')
		{
			var urlValue = wsdlObj.getValue();
			if(!isXDMGetDevicesInfo)
			{
				paramsWithValue = paramsWithValue+"&wsdlUrl="+encodeURIComponent(urlValue);
				validationURL="SpecificTestConfiguration/data/validateWebServiceURL.jsp?action=pickAgentToValidate&taskName=WebServiceValidity&componentType="+publicJson['componentType']+"&compName="+publicJson['componentName']+"&test="+testName+"&valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&configurationType=specificConfiguration"+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&selectedAgent="+"&wsdlUrl="+urlValue;
				//credentialValue = paramWithValue.substring(paramWithValue.lastIndexOf("*")+1);
				if (Ext.getCmp('credentialUserCount') != undefined && Ext.getCmp('credentialUserCount') != "" && Ext.getCmp('credentialUserCount') != null)
				{
					var credentialUserCount = Ext.getCmp('credentialUserCount').getValue();

					for (var i=0;i<credentialUserCount;i++)
					{
						var userParam = "user" + "#" + i;
						var passwordParam = "pass" + "#" + i;
						credentialValue += ",";
						credentialValue += Ext.getCmp(userParam+"").getValue() + ":" + Ext.getCmp(passwordParam+"").getValue();
					}
				}
				else
				{
					if(Ext.getCmp('credentials') != null && Ext.getCmp('credentials') != undefined)
					{
						credentialValue = Ext.getCmp('credentials').getValue();
					}
				}
			}
			if (isXDMGetDevicesInfo && xenValidationURL != null && xenValidationURL != "")
			{
				var xenMobileUserName = Ext.getCmp("username").getValue();
				var xenMobilePassword = Ext.getCmp("password").getValue();
				var trgtHost = Ext.getCmp("host").getValue();
				var port = Ext.getCmp("port").getValue();
				var sslYes = Ext.getCmp("ssl1").getValue();
				var ssl = 'false';
				if (!Ext.isEmpty(sslYes) && sslYes)
				{
					ssl = 'true';
				}
				paramsWithValue = paramsWithValue;
				validationURL="SpecificTestConfiguration/data/validateMDMURL.jsp?action=pickAgentToValidate&taskName=WebServiceValidity&componentType="+publicJson['componentType']+"&compName="+publicJson['componentName']+"&test="+testName+"&valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&configurationType=specificConfiguration"+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&wsdlUrl="+urlValue+"&tempWsdlUrl="+urlValue+"&xenMobileUserName="+xenMobileUserName+"&xenMobilePassword="+xenMobilePassword+"&ssl="+ssl+"&trgtHost="+trgtHost+"&port="+port;
			}
		}
		else
		{
			validationURL="SpecificTestConfiguration/data/validateApplicationServerCredentials.jsp?action=pickAgentToValidate&taskName="+publicJson['componentType']+"&componentType="+publicJson['componentType']+"&compName="+publicJson['componentName']+"&test="+testName+"&valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&configurationType=specificConfiguration"+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&selectedAgent=";
		}

		if (isvalidUpdate == "true")
		{
			Ext.widget('window',{
			title : validationTitle+componName,
			listeners : {
				afterrender : function()
				{
					if (wsdlObj != null && wsdlObj != '')
					{
						Ext.getCmp('agentList').setFieldLabel(WsdlValidatelbl);
					}
					me.validateCredentials(validationURL);
				}
			},
			closeAction: 'destroy',
			id : 'validateServer',
			layout : 'auto',
			width: 700,
			modal: true,
			floating : true,
			doClose: function() {
				this.destroy();
				Ext.Ajax.request({
					url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+componentType+'&componentType='+componentType+'&tName_HelpPage='+testName+'&testName='+testName,
					method:'POST'
				});
			},
			dockedItems: [
			{
				xtype: 'toolbar',
				dock: 'bottom',
				id: 'retryDocked',
				hidden: true,
				layout: {pack:'center'},
				items: [
					{
						xtype: 'button',
						ui:'newButtonSmall',
						text: Retry,
						width: 80,
						id: 'retryWsdl',
						name: 'retryWsdl',
						handler: function() {
							Ext.getCmp('retryDocked').hide();
							Ext.getCmp('resultContainerStr').show();
							Ext.getCmp('agentDropList').hide();
							var selectValue = Ext.getCmp('agentList').getValue();
							if (selectValue.indexOf("EgManager") != -1)
							{
								Ext.getCmp('resultContainerStr').update(validationLoadingMgrMsg2);
							}
							else
							{
								Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
							}
							var retryURL = "";
							if (isXDMGetDevicesInfo)
							{
								var trgtHost = Ext.getCmp("host").getValue();
								var port = Ext.getCmp("port").getValue();
								var sslYes = Ext.getCmp("ssl1").getValue();
								var ssl = 'false';
								if (!Ext.isEmpty(sslYes) && sslYes)
								{
									ssl = 'true';
								}

								retryURL = "SpecificTestConfiguration/data/validateMDMURL.jsp?valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&selectedAgent="+encodeURIComponent(selectValue)+paramsForURLVC+"&action=validate"+"&test="+testName+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&oidTextObjValue=&selectedValue="+selectValue+"&credentialValue="+credentialValue+"&xenMobileUserName="+xenMobileUserName+"&xenMobilePassword="+xenMobilePassword+"&ssl="+ssl+"&trgtHost="+trgtHost+"&port="+port;
							}
							else
							{
								retryURL = "SpecificTestConfiguration/data/validateWebServiceURL.jsp?valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&selectedAgent="+encodeURIComponent(selectValue)+paramsForURLVC+"&action=validate"+"&test="+testName+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&oidTextObjValue=&selectedValue="+selectValue+"&credentialValue="+credentialValue;
							}
							me.validateCredentials(retryURL);
						}
					}
				]
			}
			],
			items : [
				{
					xtype : 'container',
					id: 'resultContainerStr',
					border: false,
					style: {'text-align':'center'},
					html: ''
				},
				{
					xtype : 'container',
					layout : {
						type : 'vbox',
						align : 'center'
					},
					hidden : true,
					id : 'agentDropList',
					items : [{
						xtype : 'container',
						layout : {
							type : 'hbox',
							pack : 'center'
						},
						items : [
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: 'agentList',
								cls: 'dropdown',
								fieldLabel : validationMsg79,
								labelAlign: 'top',
								labelSeparator: '',
								width: 250,
								store: new Ext.data.Store(
								{
									fields: ['displayField','valueField','groupField'],
									data: []
								}),
								displayField: 'displayField',
								groupField: 'groupField',
								valueField: 'valueField',
								queryMode: 'local',
								editable: false,
								listConfig: {
									tpl: Ext.create('Ext.XTemplate',
										'<ul><tpl for=".">',
										'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
										'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
										'</tpl>',
										'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 1">padding-left: 12px</tpl>">{displayField}</li>',
										'</tpl>' +
										'</ul>',
										{
											getGroupLabel: function (values) {
												return values.groupField
											}
										}
									)
								},
								margin: '10 5 10 10'
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								id: 'oidText',
								fieldLabel: enterOID,
								//value: '.1.3.6.1.2.1.1.1',
								value: oidForComponentType,
								readOnly:true,
								labelAlign: 'top',
								labelSeparator: '',
								width: 250,
								margin: '10 5 10 5',
								hidden: true
							},
							{
								xtype : 'button',
								ui:'newButtonSmall',
								text : 'Go',
								margin: '31 10 10 5',
								handler : function()
								{
									var positionObj = Ext.getCmp('validateServer');
									var agentSelected = Ext.getCmp('agentList').getValue();
									if(agentSelected!=null && agentSelected == "-1")
									{
										Ext.Msg.show ({
											title: selectAgnt,
											msg: _selectAgent,
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
										return;
									}
									Ext.getCmp('resultContainerStr').show();
									Ext.getCmp('agentDropList').hide();
									if (agentSelected.indexOf("EgManager") != -1)
									{
										Ext.getCmp('resultContainerStr').update(validationLoadingMgrMsg2);
									}
									else
									{
										Ext.getCmp('resultContainerStr').update(validationLoadingMsg2);
									}
									var box = positionObj.getBox();
									positionObj.setPosition(box.x,box.y-100);
									var oidTextObjValue = "";
									var hasOidValue = "";
									if (Ext.getCmp('oidText').isVisible())
									{
										oidTextObjValue = Ext.getCmp('oidText').getValue();
										if(oidTextObjValue!=null && oidTextObjValue=="")
										{
											Ext.Msg.show({
												title : validationTitle+" "+componName,
												msg: _oidAlertMsg ,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation',
												fn: function() {
													Ext.getCmp('oidText').focus(true);
												}
											});
											return;
										}
										hasOidValue = "|#|-oid:"+oidTextObjValue;
									}
									if(wsdlObj != undefined && wsdlObj != null && wsdlObj != '')
									{
										var selectValue = Ext.getCmp('agentList').getValue();
										var uri = "";
										if (isXDMGetDevicesInfo)
										{
											var trgtHost = Ext.getCmp("host").getValue();
											var port = Ext.getCmp("port").getValue();
											var sslYes = Ext.getCmp("ssl1").getValue();
											var ssl = 'false';
											if (!Ext.isEmpty(sslYes) && sslYes)
											{
												ssl = 'true';
											}
											var tempWsdlVal = wsdlObj.getValue();
											uri = "SpecificTestConfiguration/data/validateMDMURL.jsp?valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&action=validate"+"&test="+testName+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&oidTextObjValue="+encodeURIComponent(oidTextObjValue)+"&selectedValue="+selectValue+"&credentialValue="+credentialValue+"&xenMobileUserName="+xenMobileUserName+"&xenMobilePassword="+xenMobilePassword+"&ssl="+ssl+"&trgtHost="+trgtHost+"&port="+port+"&tempWsdlUrl="+tempWsdlVal;

										}
										else
										{
											uri = "SpecificTestConfiguration/data/validateWebServiceURL.jsp?valForValidation="+encodeURIComponent(filterEncode(paramsWithValue))+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&action=validate"+"&test="+testName+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&oidTextObjValue="+encodeURIComponent(oidTextObjValue)+"&selectedValue="+selectValue+"&credentialValue="+credentialValue;
										}
									}
									else
									{
										var uri = "SpecificTestConfiguration/data/validateApplicationServerCredentials.jsp?valForValidation="+encodeURIComponent(filterEncode(paramsWithValue+hasOidValue))+"&selectedAgent="+encodeURIComponent(agentSelected)+paramsForURLVC+"&action=validate"+"&test="+testName+"&allowHostName="+publicJson['isAllowHostName']+"&multiUserMode="+publicJson['multiUserMode']+"&isSNMP="+publicJson['isSnmp']+"&oidTextObjValue="+encodeURIComponent(oidTextObjValue);
									}
									me.validateCredentials(uri);
								}
							}
						]
					}]
				}
			]
		}).show();
		}
	},
	validateCredentials : function(url_string) {
		var tmpData = '';
		Ext.Ajax.request({
			url : url_string,
			method: 'POST',
			timeout : 7200000,
			success: function(response)
			{
				var tmpText = response.responseText;
				if (tmpText.indexOf("<div class") == -1 && tmpText != "")
				{
					tmpData = Ext.decode(response.responseText);
					var agentListObj = Ext.getCmp('agentList');
					var isWsdlForWebService = tmpData.isWsdlForWebService;
					if (tmpData.isAgentsAvailable == true || (!Ext.isEmpty(isWsdlForWebService) && isWsdlForWebService))
					{
						Ext.getCmp('resultContainerStr').hide();
						Ext.getCmp('resultContainerStr').update("");
						Ext.getCmp('agentDropList').show();
						agentListObj.getStore().loadRawData(tmpData.tmpListArr);
						//agentListObj.getStore().group("groupField");
						if (tmpData.selectedAgnt != "" && tmpData.selectedAgnt != undefined)
						{
							agentListObj.setValue(tmpData.selectedAgnt);
						}
						else
						{
							agentListObj.setValue(agentListObj.getStore().getAt(0).get("valueField"));
						}
						var isSNMPValidate = tmpData.isSNMPValidation;
						if (isSNMPValidate)
						{
							Ext.getCmp('oidText').show();
						}
						else
						{
							Ext.getCmp('oidText').hide();
						}
						paramsForURLVC = tmpData.paramsForURL;
						Ext.getCmp('retryDocked').hide();
					}
					else
					{
						var tmpMessage = validationMsg80;
						if (tmpData.validationMessage != null && tmpData.validationMessage != 'undefined')
						{
							tmpMessage = tmpData.validationMessage;
						}
						Ext.getCmp('resultContainerStr').show();
						Ext.getCmp('agentDropList').hide();
						agentListObj.hide();
						var html = "<table width='670' border='0' height='170px'><tr><td align=center valign='center'><div class ='iconInformation'></div><div>"+tmpMessage+".</div></td></tr></table>";
						Ext.getCmp('resultContainerStr').update(html);
						Ext.getCmp('retryDocked').hide();
					}
				}
				else
				{
					Ext.getCmp('resultContainerStr').show();
					Ext.getCmp('resultContainerStr').update(tmpText);
					if (tmpText.indexOf("<div id") != -1 && tmpText != "")
					{
						Ext.getCmp('retryDocked').show();
					}
				}
				Ext.getCmp('resultContainerStr').doLayout();
				Ext.getCmp('validateServer').doLayout();
			},
			failure: function(response)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: 'failure',
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
				});
			}
		});
	},
	gotoBuildContainer: function() {
		var aResultant = new Array();
		var paramToContinue = publicJson['paramToContinue'];
		var processParamremoteContinue = publicJson['processParamremoteContinue'];
		var snmpV1V2ParamToContinue = publicJson['snmpV1V2ParamToContinue'];
		var snmpV3ParamToContinue = publicJson['snmpV3ParamToContinue'];
		var multiUserReadOnlyParam = publicJson['multiUserReadOnlyParam'];
		var multiNameReadOnlyParam = publicJson['multiNameReadOnlyParam'];
		var multiOidsReadOnlyParam = publicJson['multiOidsReadOnlyParam'];
		var modeTrueToContinue = publicJson['modeTrueToContinue'];
		var modeFalseToContinue = publicJson['modeFalseToContinue'];
		var measureModeTrueToContinue = publicJson['measureModeTrueToContinue'];
		var measureModeFalseToContinue = publicJson['measureModeFalseToContinue'];
		var measurementModeTrueToContinue = publicJson['measurementModeTrueToContinue'];
		var measurementModeFalseToContinue = publicJson['measurementModeFalseToContinue'];
		var targetDiskIORateLabel = publicJson['targetDiskIORateLabel'];
		var paramsNeededToDoValidation = publicJson['paramsNeededToDoValidation'];
		var targetDiskIORateValue = publicJson['targetDiskIORateValue'];
		var tmpResultant = publicJson['aResultant'];
		var testName = publicJson['testName'];
		var previousTestName = publicJson['previousTestName'];
		var isSnmp = publicJson['isSnmp'];
		var componentType = publicJson['componentType'];
		var isModeParamExist = publicJson['isModeParamExist'];
		var isLocalModeParamExist = publicJson['isLocalModeParamExist'];
		var isMeasureModeParamExist = publicJson['isMeasureModeParamExist'];
		var isMeasurementModeParamExist = publicJson['isMeasurementModeParamExist'];
		var isCorrectParamExist = publicJson['isCorrectParamExist'];
		var isUrlParamExist = publicJson['isUrlParamExist'];
		var isWsdlUrlExist = publicJson['isWsdlUrlExist'];
		var isXDMGetDevicesInfo = publicJson['isXDMGetDevicesInfo'];
		var isPolicyParamExists = publicJson['isPolicyParamExists'];
		var isCredentialParamExist = publicJson['isCredentialParamExist'];
		var isCorrectiveScriptEnabled = publicJson['isCorrectiveScriptEnabled'];
		var viewAccessOnly = publicJson['viewAccessOnly'];
		var isRemote = publicJson['isRemote'];
		var hasMultipleUsers = false;
		var hasMultipleNames = false;
		var hasMultipleOid = false;
		var hasShowAliasParam = publicJson['hasShowAliasParam'];
		var isAggregateTest = publicJson['isAggregateTest'];
		var isCompositeTest = publicJson['isCompositeTest'];
		var hasShowAllOnlyParam = publicJson['hasShowAllOnlyParam'];
		var hasReportOnlyTotalParam = publicJson['hasReportOnlyTotalParam'];
		var componentNickName = publicJson['componentNickName'];
		var testPeriodArr = publicJson['testPeriodArr'];
		var setReadOnlyMode = publicJson['setReadOnlyMode'];
		var testPeriodLabel = publicJson['testPeriodLabel'];
		var selectedTimePeriod = publicJson['selectedTimePeriod'];
		var paramForDisplayingValidateButton = publicJson['paramForDisplayingValidateButton'];
		var multiUserMode = publicJson['multiUserMode'];
		var multiOidsMode = publicJson['multiOidsMode'];
		var multiNamePatternMode = publicJson['multiNamePatternMode'];
		var strDelimiterMask = publicJson['hiddenObj']['delimiterMask'];
		var testInfoDelimiter = publicJson['testInfoDelimiter'];
		var showAllEventsValue = publicJson['showAllEventsValue'];
		var reportTotalValue = publicJson['reportTotalValue'];
		var isPortRelevantForTest = publicJson['isPortRelevantForTest'];
		var configuredTestTitle = publicJson['configuredTestTitle'];
		var isValidateBtn = publicJson['isValidateBtn'];
		var isExecutionTimeParam = publicJson['isExecutionTimeParam'];
		var isSystemPropertyParamTests = publicJson['isSystemPropertyParamTests'];
		var reportName = '';
		//targets st with sysproperty values
		var isTargetWthSysProps= publicJson['isTargetWthSysProps'];
		var isDskSpcTstAtmnDrvRprtd = (publicJson['dskSpcTstReportedDrives'] != undefined && publicJson['dskSpcTstReportedDrives'] != null && publicJson['dskSpcTstReportedDrives'].length > 0) ? (true) : (false);
		
		var isWindows = ( (publicJson['OSMemoryTestAtmtnOsNm'] != undefined) && (publicJson['OSMemoryTestAtmtnOsNm'] != null) && (publicJson['OSMemoryTestAtmtnOsNm'].toLowerCase().indexOf("windows") > -1) ) ? (true) : (false);
		
		if (!Ext.isEmpty(tmpResultant))
		{
			if (!Ext.isEmpty(isExecutionTimeParam) && isExecutionTimeParam)
			{
				var selectedExec = publicJson['selectedExecTime'];
				if (selectedExec == 'hourly' && selectedTimePeriod != '3600')
				{
					selectedTimePeriod = "3600";
				}
				else if (selectedExec == 'daily' && selectedTimePeriod != '86400')
				{
					selectedTimePeriod = "86400";
				}
			}

			var paramsFieldSetContainer = Ext.getCmp('paramsContainer');
			Ext.suspendLayouts();
			paramsFieldSetContainer.removeAll();
			paramsFieldSetContainer.setTitle (configuredTestTitle );
			var hiddenComponent = {
				xtype: 'scrollcombo',
				cls: 'dropdown',
				id: 'testPeriod',
				name: 'testPeriod',
				fieldLabel: testPeriodLabel,
				queryMode: 'local',
				displayField: 'displayField',
				valueField: 'valueField',
				value: selectedTimePeriod,
				editable: false,
				parent: this,
				store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: testPeriodArr
					}
				)
			};
			paramsFieldSetContainer.add(hiddenComponent);
			if (setReadOnlyMode)
			{
				Ext.getCmp('testPeriod').setReadOnly(true);
				Ext.getCmp('testPeriod').removeCls( 'dropdown' );
				Ext.getCmp('testPeriod').addCls( 'textbox' );
			}
			else
			{
				Ext.getCmp('testPeriod').setReadOnly(false);
				Ext.getCmp('testPeriod').addCls( 'dropdown' );
			}

			aResultant = tmpResultant.split('^&^');
			for (var i = 0;i < aResultant.length ;i = i+3 )
			{
				var paramName = aResultant[i];
				paramName = paramName.substring(1).trim();
				var strDelimiterMask = publicJson['hiddenObj']['delimiterMask'];
				var paramValue = aResultant[i+1];
				var displayControl = aResultant[i+2];
				displayControl = displayControl.trim();
				
				if (testName == 'OSMemoryTest' && !isWindows && (paramName.toLowerCase() == 'autmtd_actn_enbld_mmryusg' || paramName.toLowerCase() == 'automation_criteria' || paramName.toLowerCase() == 'automation_memory_limit(%)' || paramName.toLowerCase() == 'free_memory_limit(mb)'
				|| paramName.toLowerCase() == 'empty_modified_memory' || paramName.toLowerCase() == 'empty_standby_memory'))
				{
					continue;
				}
				if( (testName == 'DiskSpaceTest') && (!isDskSpcTstAtmnDrvRprtd) && ( (paramName.toLowerCase() == 'autmtd_actn_enbld_dskspc') || (paramName.toLowerCase() == 'automation_configuration_rules') || (paramName.toLowerCase() == 'drive_name') || (paramName.toLowerCase() == 'drive_utilization_percentage') || (paramName.toLowerCase() == 'files_and_folders_to_be_cleaned') ) )
				{
					continue;
				}

				if( (testName == 'WVDDiskSpaceTest') && (!isDskSpcTstAtmnDrvRprtd) && ( (paramName.toLowerCase() == 'autmtd_actn_enbld_wvd_dskspc') || (paramName.toLowerCase() == 'automation_configuration_rules') || (paramName.toLowerCase() == 'drive_name') || (paramName.toLowerCase() == 'drive_utilization_percentage') || (paramName.toLowerCase() == 'files_and_folders_to_be_cleaned') ) )
				{
					continue;
				}
				
				if (displayControl != "password")
				{
					paramValue = paramValue.trim();

					if (paramValue.indexOf('"') == 0 && paramValue.lastIndexOf('"') == paramValue.length - 1)
					{
						paramValue = paramValue.substring(1,paramValue.length-1);
					}
				}
				
				if (!Ext.isEmpty(paramName) && paramName.toLowerCase() == 'rptname')
				{
					reportName = paramValue;
				}

				var elementIdx = this.continueParamMethod(paramToContinue,paramName);
				if (elementIdx) continue;
				if (testName == "SecurityLogTest")
				{
					if (paramName.toLowerCase() == "users" || paramName.toLowerCase() == "eventids")
					{
						continue;
					}
				}

				/*if(componentType == "Virtual_center" && paramName.toLowerCase() == "hosted_vm_type")
				{
					continue;
				}*/

				if (isSnmp)
				{
					//In snmpV3 hiding encrypt type and encrypt password when its value is false.
					var snmpV3ParamIdx = this.continueParamMethod(snmpV3ParamToContinue,paramName);
					var encryptFlag = publicJson['encryptFlag'];
					var encryptValue = publicJson['encryptValue'];
					if (isModeParamExist)
					{
						var heapAnalysisIdx = publicJson['heapAnalysisIdx'];
					}
				}

				//for remote based monitoring continuing the process parameters
				var remProcessParamIdx = this.continueParamMethod(processParamremoteContinue,paramName);
				if(remProcessParamIdx && isRemote) continue;

				//parameter value comes only for component type called "web" for the parameter "site"
				if (paramValue.toLowerCase() == "noteditable") continue;
				//if (paramName.toLowerCase() == "process") continue;

				//hide the parameter info
				if (componentType != "Oracle_cluster_service" && paramName.toLowerCase() == "info")
				{
					continue;
				}
				else if ((componentType != "KVM_vdi_server" || componentType != "KVM_server") && paramName.toLowerCase() == "kvm")
				{
					continue;
				}
				else if (componentType != "QVD_server" && paramName.toLowerCase() == "isqvd")
				{
					continue;
				}

				var readOnlyParamIdx = this.continueParamMethod(multiUserReadOnlyParam,paramName);
				if(!readOnlyParamIdx)
				{
					readOnlyParamIdx = this.continueParamMethod(multiNameReadOnlyParam,paramName);
				}
				if(!readOnlyParamIdx)
				{
					readOnlyParamIdx = this.continueParamMethod(multiOidsReadOnlyParam,paramName);
				}

				if (readOnlyParamIdx)
				{
					if (paramName.toLowerCase() == "domain" ||
						paramName.toLowerCase() == "user" ||
						paramName.toLowerCase() == "admin_user")
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleUsers = true;
						}
					}
					else if (paramName.toLowerCase() == "name" ||
						paramName.toLowerCase() == "pattern" ||
						paramName.toLowerCase() == "threshold_value")
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleNames = true;
						}
					}
					else if (paramName.toLowerCase() ==  "measure_oid")
					{
						if (paramValue.indexOf("|") > -1)
						{
							hasMultipleOid = true;
						}
					}
				}
				if (isAggregateTest || (isCompositeTest && componentType.indexOf("Agg_")==0) || componentType == "Real_user_monitor" || componentType == "MobileRUM")
				{
					if (paramName.toLowerCase() == "host" ||
						paramName.toLowerCase() == "port")
					{
						continue;
					}
				}

				if (paramName.toLowerCase() == 'monitoring_level')
				{
					continue;
				}

				var readOnly = "";
				var descriptorButton = "";
				var isButtonDescription = publicJson['isButtonDescription'];
				if (isButtonDescription)
				{
					descriptorButton = publicJson['descriptorButton'];
					readOnly = "readOnly";
				}

				hostEditableMode = publicJson['hostEditableMode'];
				portEditableMode = publicJson['portEditableMode'];

				if (paramName.toLowerCase() == "credentials")
				{
					continue;
				}

				if (paramName.toLowerCase() == "method")
				{
					continue;
				}

				if (paramName.toLowerCase() == "content")
				{
					continue;
				}

				if (paramName.toLowerCase() == "encoding")
				{
					continue;
				}

				if (paramName.toLowerCase() == "privatekey")
				{
					continue;
				}
				
				if (paramName.toLowerCase() == "systempropertykey" || paramName.toLowerCase() == "systempropertyvalue")
				{
					continue;
				}
				//targets start
				if (paramName.toLowerCase() == "systempropskey" || paramName.toLowerCase() == "systempropsvalue")
				{
					continue;
				}
				if ((testName == "WindowshareTest" || testName == "UNCCheckTest") && (paramName.toLowerCase() == "domainname" || paramName.toLowerCase() == "shareusername" || paramName.toLowerCase() == "password"))
				{
					continue;
				}

				var isSelectedPwdProfile = publicJson[paramName+'isPwdProfile'];
				if (displayControl.toLowerCase() == "radio")
				{
					//Dependent Parameter - Having relationship with other parameters
					//For e.g., correct which has relations with alarmtype,userparams,correctivescript
					//Independent Parameter - Does not have relationship with other parameters
					//For e.g., isPassive
					//ProcessTest=wide(Yes:true#No:false) - Independent param
					//parameter value definition = (Yes:true#No:false)
					//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt
					//need to define parameter value definition.
					//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
					//This will be handled in else block
					var isIndependentParam = publicJson['isIndependentParam'+paramName];
					if (isIndependentParam)
					{
						//block fires when the user put corresponding value to the isolated
						//radio parameter.
						var tempName1 = publicJson['independentParamName'+paramName+'1'];
						var tempValue1 = publicJson['independentParamValue'+paramName+'1'];
						var tempName2 = publicJson['independentParamName'+paramName+'2'];
						var tempValue2 = publicJson['independentParamValue'+paramName+'2'];

						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var enabled = publicJson['enabled'+paramName];
						var disabled = publicJson['disabled'+paramName];

						if (paramName.toLowerCase() == "aggregate_user_sessions" &&
							viewAccessOnly && disabled)
						{
							var independentRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled, disabled:true },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled, disabled:true}
								]
							};
							paramsFieldSetContainer.add(independentRadioComponent);
						}
						else if ( paramName.toLowerCase() == "connection_type")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isConnTypeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeConnType(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isConnTypeRadioComponent);
						}
						else if ( paramName.toLowerCase() == "isembedded")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isEmbeddedRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'False', name: paramName, id: paramName+'1',  inputValue: 'false',checked: disabled },
									{ boxLabel: 'True', name: paramName, id: paramName+'2',  inputValue: 'true', checked: enabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isEmbeddedRadioComponent);
						}
						else if (componentType.toLowerCase() == "storage_raid" && paramName.toLowerCase() == "ssl")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var sslRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'False', name: paramName, id: paramName+'1',  inputValue: 'false',checked: disabled },
									{ boxLabel: 'True', name: paramName, id: paramName+'2',  inputValue: 'true', checked: enabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(sslRadioComponent);
						}
						else if (paramName.toLowerCase() == "is_trail")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isTrailRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isTrailRadioComponent);
						}
						else if (paramName.toLowerCase() == "advanced_settings")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isAdvancedSettingsRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isAdvancedSettingsRadioComponent);
						}
						else if (paramName.toLowerCase() == "use_sudo")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isUseSudoRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isUseSudoRadioComponent);
						}
						else if (paramName.toLowerCase() == "data_collection_mode")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isDataCollMode = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeDataCollectMode(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isDataCollMode);
						}
						else if (paramName.toLowerCase() == "access_type")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var isAccessType = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeAccessType(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isAccessType);
						}
						else
						{
							var independentRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: tempName1, name: paramName, id: paramName+'1',  inputValue: tempValue1,checked: enabled },
									{ boxLabel: tempName2, name: paramName, id: paramName+'2',  inputValue: tempValue2, checked: disabled }
								]
							};
							paramsFieldSetContainer.add(independentRadioComponent);

							if (testName == 'WDispAvailTest' || 
								testName == 'WDispCacheTest' ||
								testName == 'WDispConnTest' || 
								testName == 'WDispServListTest' ||
								testName == 'WDispConfigTest' ||
								testName == 'WDispStatusTest' || 
								testName == 'WDispThreadTest')
							{
								var useDataCollTypeObj = Ext.getCmp('data_collection_mode1');
								if (!Ext.isEmpty(useDataCollTypeObj))
								{
									var useSAPControl = useDataCollTypeObj.getValue();
									if (useSAPControl)
									{
										if (paramName == 'ssl')
										{
											Ext.getCmp("ssl_radioGrp").setDisabled(false);
											Ext.getCmp("ssl_radioGrp").show();
										}
										
									}
									else 
									{
										if (paramName == 'ssl')
										{
											Ext.getCmp("ssl_radioGrp").setDisabled(true);
											Ext.getCmp("ssl_radioGrp").hide();
										}
									}
								}
							}
						}
					}
					else
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						if (paramName.toLowerCase() == "encryptflag" && isSnmp)
						{
							var enabled = publicJson['enabledEncryptFlag'];
							var disabled = publicJson['disabledEncryptFlag'];
							var encryptFlagRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								hidden: true,
								listeners: {
									change:
									{
										fn: function() {
											 me.changeEncFlagValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(encryptFlagRadioComponent);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}
							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
									{
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
								{
									Ext.getCmp(paramName+'_radioGrp').show();
								}
							}
						}
						else if (paramName.toLowerCase() == "engineid" && isSnmp)
						{
							var enabled = publicJson['enabledEngineID'];
							var disabled = publicJson['disabledEngineID'];
							var engineIDRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								hidden: true
							};
							paramsFieldSetContainer.add(engineIDRadioComponent);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}

							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
									{
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
								{
									Ext.getCmp(paramName+'_radioGrp').show();
								}
							}
						}
						else if (paramName.toLowerCase() == "action_on_descriptors")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var policyFilterRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Include', name: paramName, id: paramName+'1',  inputValue: 'include',checked: enabled },
									{ boxLabel: 'Exclude', name: paramName, id: paramName+'2',  inputValue: 'exclude', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeActionOnDescriptors(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(policyFilterRadioComponent)
						}
						else if (paramName.toLowerCase() == "policyfilter" && isPolicyParamExists)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var policyFilterRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(policyFilterRadioComponent)
						}
						else if (paramName.toLowerCase() == "correct" && !isRemote && isCorrectParamExist)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var correctRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change: {
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(correctRadioComponent)
						}
						else if(paramName.toLowerCase() == "mode" && isLocalModeParamExist)
						{
							var enabled = publicJson['modeEnabled'];
							var disabled = publicJson['modeDisabled'];

							var modeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'LOCAL', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeModeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(modeRadioComponent)
						}
						else if(paramName.toLowerCase() == "mode" && isModeParamExist)
						{
							var enabled = publicJson['modeEnabled'];
							var disabled = publicJson['modeDisabled'];

							var modeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'SNMP', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(modeRadioComponent)
						}
						else if(paramName.toLowerCase() == "metric_collection_type")
						{
							var enabled = publicJson['jmxOptionsShow'];
							var disabled = publicJson['jmxOptionsHide'];
							var displayNameTrue = publicJson['metric_collection_type#true'];
							var displayNameFalse = publicJson['metric_collection_type#false'];

							var jmxOptionsRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: displayNameTrue, name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: displayNameFalse, name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											me.changeJmxOptionValue(this)
										}
									},
									afterrender: function(){
										me.changeJmxOptionValue(this)
									}
								}
							};
							paramsFieldSetContainer.add(jmxOptionsRadioComponent)
						}
						else if(paramName.toLowerCase() == "measure_mode" && isMeasureModeParamExist)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var measureModeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Log File', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(measureModeRadioComponent);
						}
						else if(paramName.toLowerCase() == "measurement_mode" && isMeasurementModeParamExist)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var measurementModeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'War File', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'JMX', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(measurementModeRadioComponent);
						}
						else if(paramName.toLowerCase() == "heap_analysis" && isModeParamExist)
						{
							var enabled = publicJson['enabledHeapAnalysis'];
							var disabled = publicJson['disabledHeapAnalysis'];

							var heapAnalysisRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeModeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(heapAnalysisRadioComponent);
						}
						else if(paramName.toLowerCase() == "usealias" && hasShowAliasParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							var useAliasRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								fieldLabel: tempParamName,
								id: paramName+'_radioGrp',
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(useAliasRadioComponent);
						}
						else if (paramName.toLowerCase() == "showallevents" && hasShowAllOnlyParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var showAllEventRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								name: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(showAllEventRadioComponent);
						}
						else if (paramName.toLowerCase() == "report_total" && hasReportOnlyTotalParam)
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}
						else if (paramName.toLowerCase() == "adapter_device_selection")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var adapterRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Automatic', name: paramName, id: paramName+'1',  inputValue: 'automatic',checked: enabled },
									{ boxLabel: 'Manual', name: paramName, id: paramName+'2',  inputValue: 'manual', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(adapterRadioComponent);
						}
						else if (paramName.toLowerCase() == "url_pattern_discovery_mode")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var urlPattDiscRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Automatic', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'Manual', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeValue(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(urlPattDiscRadioComponent);
						}
						else if (paramName.toLowerCase() == "use_sapcontrol")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var useSAPControlRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeSAPControl(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(useSAPControlRadioComponent);
						}
						else if (paramName.toLowerCase() == "report_with_destination")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportDestRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'yes',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'no', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeTotalDesc(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(reportDestRadioComponent);
						}
						else if (paramName.toLowerCase() == "is_privilege_mode_enabled")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var enableModeRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'yes',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'no', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeEnableMode(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(enableModeRadioComponent);
						}
						else if (( (testName == 'DiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (paramName.toLowerCase() == "autmtd_actn_enbld_dskspc") ) ||
						( (testName == 'WVDDiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (paramName.toLowerCase() == "autmtd_actn_enbld_wvd_dskspc") ))
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							
							var automationRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeAutomationForDskTst(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(automationRadioComponent);
						}
						else if (paramName.toLowerCase() == "using_horizon_api")
						{
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							
							var automationRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners:
								{
									change:
									{
										fn: function() {
											me.changeHorizonAPIMode(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(automationRadioComponent);							
						}
						else if ( (testName == 'OSMemoryTest' && paramName.toLowerCase() == "autmtd_actn_enbld_mmryusg") || (testName == 'WVDOSMemoryTest' && paramName.toLowerCase() == "autmtd_actn_enbld_mmryusg") || (testName == 'VmgOSMemoryTest' && paramName.toLowerCase() == "automated_action_enabled" ))
						{									
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}
						else if ((testName == 'OSMemoryTest' || testName == 'WVDOSMemoryTest' || testName == 'VmgOSMemoryTest') && paramName.toLowerCase() == "automation_criteria" )
						{						
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Free memory', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'Memory utilization', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeValue(this)
									},
									change:
									{

										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}
						else if ( ( (testName == 'CtxXcXASessionTest') && (paramName.toLowerCase() == "autmtd_actn_enbld_ctxssn") ) || ( (testName == 'WVDSessionTest') && (paramName.toLowerCase() == "autmtd_actn_enbld_avdssn") ) )
						{									
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}
						else if ( (testName == 'CtxXcXASessionTest' || testName == 'WVDSessionTest') && (paramName.toLowerCase() == "idle_sessions_action_enabled") )
						{									
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}
						else if ( (testName == 'CtxXcXASessionTest' || testName == 'WVDSessionTest') && (paramName.toLowerCase() == "disconnected_sessions_action_enabled") )
						{									
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];

							var reportTotalRadioComponent = {
								xtype: 'radiogroup',
								cls: 'radiobt',
								id: paramName+'_radioGrp',
								fieldLabel: tempParamName,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true',checked: enabled },
									{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false', checked: disabled }
								],
								listeners: {
									afterrender: function()
									{
										me.changeValue(this)
									},
									change:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							
							paramsFieldSetContainer.add(reportTotalRadioComponent);
						}								
						else
						{
							//handling independent parameter for radio - starts
							//handled yes,no,true,false,y and n only
							//block fires when the user forgets to put corresponding value
							//to the isolated radio parameter.Parameter are handled to their
							//default values.
							var enabled = publicJson['enabled'+paramName];
							var disabled = publicJson['disabled'+paramName];
							var value1 = publicJson['value1'+paramName];
							var value2 = publicJson['value2'+paramName];

							if (paramName.toLowerCase() =="report_by_user" &&
								viewAccessOnly && enabled)
							{
								var reportByUserRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									name: paramName+'_radioGrp',
									fieldLabel: tempParamName,
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1,checked: enabled, disabled:true },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled, disabled:true}
									]
								};
								paramsFieldSetContainer.add(reportByUserRadioComponent);
							}
							else if (paramName.toLowerCase() == "reportbyclientname" &&
								viewAccessOnly && disabled)
							{
								var reportByClientRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									vertical: false,
									fieldLabel: tempParamName,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1,checked: enabled, disabled:true },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled, disabled:true}
									]
								};
								paramsFieldSetContainer.add(reportByClientRadioComponent);
							}
							else
							{
								var lastRadioComponent = {
									xtype: 'radiogroup',
									cls: 'radiobt',
									id: paramName+'_radioGrp',
									name: paramName+'_radioGrp',
									vertical: false,
									fieldLabel: tempParamName,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: value1, checked: enabled },
										{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: value2, checked: disabled }
									]
								};
								paramsFieldSetContainer.add(lastRadioComponent);
							}
							if (hasShowAliasParam) 	//Report_only_total
							{
								if (paramName == 'show_alias_and_interface_name')
								{
									var useAliasParam = publicJson.originalParamNameObj['USEALIAS'];
									var isShowAllEventsYes = Ext.getCmp(useAliasParam+'1').getValue();
									var isShowAllEventsNo = Ext.getCmp(useAliasParam+'2').getValue();
									if (isShowAllEventsYes)
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else if (isShowAllEventsNo)
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
							}
							if (hasReportOnlyTotalParam)	//Report_only_total
							{
								var reportOnlyName = publicJson.originalParamNameObj['REPORT_TOTAL'];
								var isShowAllEventsYes = Ext.getCmp(reportOnlyName+'1').getValue();
								var isShowAllEventsNo = Ext.getCmp(reportOnlyName+'2').getValue();
								if (isShowAllEventsYes)
								{
									if (paramName.toLowerCase() == 'report_only_total')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
								else if (isShowAllEventsNo)
								{
									if (paramName.toLowerCase() == 'report_only_total')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
							}
							if (hasShowAllOnlyParam)
							{
								var showAllName = publicJson.originalParamNameObj['SHOWALLEVENTS'];
								var showAllEvtObject = Ext.getCmp(showAllName+'_radioGrp');

								if (!Ext.isEmpty(showAllEvtObject) && showAllEvtObject != undefined)
								{
									var isShowAllEventsYes = Ext.getCmp(showAllName+'1').getValue();
									var isShowAllEventsNo = Ext.getCmp(showAllName+'2').getValue();
									if (isShowAllEventsYes)
									{
										if (paramName.toLowerCase() == 'showallonly')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
									else if (isShowAllEventsNo)
									{
										if (paramName.toLowerCase() == 'showallonly')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
									}
								}
							}
							if (isMeasurementModeParamExist)
							{
								var measurementModeWar = Ext.getCmp('measurement_mode1').getValue();
								var measurementModeJmx = Ext.getCmp('measurement_mode2').getValue();
								if (measurementModeJmx)
								{
									if (paramName == 'ssl')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
									else if (paramName.toLowerCase() == 'encryptpass')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
								else if (measurementModeWar)
								{
									if (paramName == 'ssl')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else if (paramName.toLowerCase() == 'encryptpass')
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
								}
							}
							
							if (paramName == 'ssl_enabled')
							{
								var dbTypeObj = Ext.getCmp('database_type');
								if (!Ext.isEmpty(dbTypeObj))
								{
									var dbtType = dbTypeObj.getValue();
									if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
							}
							
							if (paramName == 'ntlmv2_enabled')
							{
								var dbTypeObj = Ext.getCmp('database_type');
								if (!Ext.isEmpty(dbTypeObj))
								{
									var dbtType = dbTypeObj.getValue();
									if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}
							}


							if (paramName == 'ssl' || paramName == 'isntlmv2' )
							{
								var dbTypeObj = Ext.getCmp('dbType');
								if (!Ext.isEmpty(dbTypeObj))
								{
									var dbtType = dbTypeObj.getValue();
									if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
										Ext.getCmp(paramName+'_radioGrp').show();
									}
									else if (!Ext.isEmpty(dbType) && dbType != 'MsSql' )
									{
										Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
										Ext.getCmp(paramName+'_radioGrp').hide();
									}
								}

								if (testName == 'VMViewEventsTest')
								{
									var horizApiObj = Ext.getCmp('Using_Horizon_API1');
									if (!Ext.isEmpty(horizApiObj))
									{
										var isAPIMode = horizApiObj.getValue();
										if (!Ext.isEmpty(isAPIMode) && isAPIMode)
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
										else
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
								}
								

								if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf' || testName == 'AsAbapSyslgTest' ||
									testName == 'WDispAvailTest' || 
									testName == 'WDispCacheTest' ||
									testName == 'WDispConnTest' || 
									testName == 'WDispServListTest' ||
									testName == 'WDispConfigTest' ||
									testName == 'WDispStatusTest' || 
									testName == 'WDispThreadTest')
								{
									var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
									var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
									var useDataCollTypeObj = Ext.getCmp('data_collection_mode1');

									if (!Ext.isEmpty(useSAPControlObj))
									{
										var useSAPControlNo = useSAPControlObj.getValue();
										if (useSAPControlNo)
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
										else 
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}
									if (!Ext.isEmpty(useSAPControlObjAuto))
									{
										var useSAPControlNo = useSAPControlObjAuto.getValue();
										if (useSAPControlNo=='false')
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
										else 
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
									}

									if (!Ext.isEmpty(useDataCollTypeObj))
									{
										var useSAPControl = useDataCollTypeObj.getValue();
										if (useSAPControl)
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(false);
											Ext.getCmp(paramName+'_radioGrp').show();
										}
										else
										{
											Ext.getCmp(paramName+'_radioGrp').setDisabled(true);
											Ext.getCmp(paramName+'_radioGrp').hide();
										}
									}
								}
							}
							//handling independent parameter for radio - ends
						}

						if ((componentType == "VmVdi_i_server"  || componentType == "VmEsx_i_server" )  && paramName == 'ssl')
						{
							var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
							if (!Ext.isEmpty(vCenterObjVal) && (vCenterObjVal.toLowerCase() != 'none' && vCenterObjVal.toLowerCase() != 'other'))
							{
								Ext.getCmp(paramName+'_radioGrp').setReadOnly(true);
							}
						}
					}
				}
				else if (displayControl.toLowerCase() == "select")
				{
					//Dependent Parameter - Having relationship with other parameters
					//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
					//Independent Parameter - Does not have relationship with other parameters
					//For e.g., alarmtype
					var isIndependentParam = publicJson['isIndependentParam'+paramName];
					if (isIndependentParam)
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var independentParamArr = publicJson['independentParamArr'+paramName];
						var selectedIndParamValue = publicJson['selectedIndParamValue'+paramName];
						if (Ext.isEmpty(selectedIndParamValue) || selectedIndParamValue == undefined)
						{
							selectedIndParamValue = independentParamArr[0].valueField;
						}

						if (paramName == 'dbType')
						{
							var dbTypeComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedIndParamValue,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.changeValue(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(dbTypeComponent);
						}
						else if(paramName.toLowerCase() == "pagetypestobeincludedindashboard" )
						{
							var fieldlabelParamValue = publicJson['fieldLabel'+paramName];
							var pageTypesCombo = {
								xtype: 'multiselectSi',
								cls: 'multiselect',
								fieldLabel: fieldlabelParamValue,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								height: 90,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								value: selectedIndParamValue,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								})
							};
							paramsFieldSetContainer.add(pageTypesCombo);

						}
						else if((testName.toLowerCase() == "ctxxcxasessiontest" || testName.toLowerCase() == "wvdsessiontest") && paramName.toLowerCase() == "idle_session_actions")
						{							
							var fieldlabelParamValue = publicJson['fieldLabel'+paramName];
							
							var priorityMemoryCombo = {
								xtype: 'multiselectSi',
								cls: 'multiselect',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								height: 90,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								value: selectedIndParamValue,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								})
							};
							paramsFieldSetContainer.add(priorityMemoryCombo);

						}
						else if (paramName.toLowerCase() == "use_sapcontrol")
						{
							var useSAPControlComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedIndParamValue,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.changeSAPControlSelect(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(useSAPControlComponent);
						}
						else if (paramName.toLowerCase() == 'database_type')
						{
							var databaseTypeDropdown = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedIndParamValue,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: independentParamArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.customDB(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(databaseTypeDropdown);
						}
						else
						{
							var independentComboComponent = this.createComboBox(paramName);
							paramsFieldSetContainer.add(independentComboComponent);

							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(independentParamArr) && independentParamArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(independentParamArr);
								Ext.getCmp(paramName).setValue(selectedIndParamValue);
							}
						}

						if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf' || testName == 'AsAbapSyslgTest')
						{
							var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
							var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
							
							if (!Ext.isEmpty(useSAPControlObj))
							{
								var useSAPControlNo = useSAPControlObj.getValue();
								if (useSAPControlNo || paramName=='use_sapcontrol')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
								else 
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
							}
							if (!Ext.isEmpty(useSAPControlObjAuto))
							{
								var useSAPControlNo = useSAPControlObjAuto.getValue();
								if (useSAPControlNo=='false')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
								else if(useSAPControlNo=='true' && paramName.toLowerCase()!='use_sapcontrol')
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
								else
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							
						}

						if (paramName.toLowerCase() == 'alarmtype')
						{
							Ext.getCmp(paramName).setDisabled(true);
							Ext.getCmp(paramName).hide();
						}

						if (!isRemote && isCorrectParamExist)
						{
							if (paramName.toLowerCase() == 'alarmtype')
							{
								var isCorrectYes = Ext.getCmp('correct1').getValue();
								var isCorrectNo = Ext.getCmp('correct2').getValue();
								if (isCorrectNo)
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
								else if (isCorrectYes)
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
						}
						if(isAPMTest && paramName.toLowerCase() == "monitoring_mode")
						{
							Ext.getCmp(paramName).setDisabled(true);
							Ext.getCmp(paramName).hide();
						}
					}
					else
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						if (paramName.toLowerCase() == "snmpversion" && isSnmp)
						{
							var snmpVersionArr = publicJson['snmpVersionArr'];
							var selectedSnmpVersion = publicJson['selectedSnmpVersion'];
							if (Ext.isEmpty(selectedSnmpVersion) || selectedSnmpVersion == '$unconfigured' )
							{
								selectedSnmpVersion = 'v1';
							}
							if (isModeParamExist)
							{
								var snmpVersionComboComponent = {
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: selectedSnmpVersion,
									queryMode: 'local',
									displayField: 'displayField',
									valueField: 'valueField',
									editable: false,
									parent:this,
									hidden: true,
									disabled: true,
									store:new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: snmpVersionArr
									}),
									listeners: {
										select:
										{
											fn: function() {
												 me.changeValue(this)
											}
										}
									}
								};
								paramsFieldSetContainer.add(snmpVersionComboComponent);
								var modeSnmp = Ext.getCmp('mode1').getValue();
								var snmpVerObject = '';
								if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpversion');
								}
								else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpVersion');
								}
								if (modeSnmp)
								{
									snmpVerObject.setDisabled(false);
									snmpVerObject.show();
								}


								if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
								{
									snmpDefaultVal = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpDefaultVal) && snmpDefaultVal != undefined && (snmpDefaultVal == 'v1' || snmpDefaultVal == 'v2'))
									{
										if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined &&  Ext.getCmp('snmpcommunity').isHidden())
										{
											Ext.getCmp('snmpcommunity').setDisabled(false);
											Ext.getCmp('snmpcommunity').show();
										}
										else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined && Ext.getCmp('snmpCommunity').isHidden() )
										{
											Ext.getCmp('snmpCommunity').setDisabled(false);
											Ext.getCmp('snmpCommunity').show();
										}
									}

								}
							}
							else
							{
								var snmpVersionComboComponent = {
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: selectedSnmpVersion,
									queryMode: 'local',
									displayField: 'displayField',
									valueField: 'valueField',
									editable: false,
									parent:this,
									store:new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: snmpVersionArr
									}),
									listeners: {
										select:
										{
											fn: function() {
												 me.changeValue(this)
											}
										}
									}
								};
								paramsFieldSetContainer.add(snmpVersionComboComponent);
								var snmpVerObject = '';
								if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpversion');
								}
								else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
								{
									snmpVerObject = Ext.getCmp('snmpVersion');
								}

								if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
								{
									snmpDefaultVal = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpDefaultVal) && snmpDefaultVal != undefined && (snmpDefaultVal == 'v1' || snmpDefaultVal == 'v2'))
									{
										if (!Ext.isEmpty(Ext.getCmp('snmpcommunity')) && Ext.getCmp('snmpcommunity') != undefined &&  Ext.getCmp('snmpcommunity').isHidden())
										{
											Ext.getCmp('snmpcommunity').setDisabled(false);
											Ext.getCmp('snmpcommunity').show();
										}
										else if (!Ext.isEmpty(Ext.getCmp('snmpCommunity')) && Ext.getCmp('snmpCommunity') != undefined && Ext.getCmp('snmpCommunity').isHidden() )
										{
											Ext.getCmp('snmpCommunity').setDisabled(false);
											Ext.getCmp('snmpCommunity').show();
										}
									}

								}
							}
						}
						else if (paramName.toLowerCase() == "authtype" && isSnmp)
						{
							var snmpAuthTypeArr = publicJson['snmpAuthTypeArr'];
							var selectedSnmpAuthType = publicJson['selectedSnmpAuthType'];
							var authTypeComboComponent = this.createComboBox(paramName);

							paramsFieldSetContainer.add(authTypeComboComponent);
							Ext.getCmp(paramName).setFieldLabel(paramName.toUpperCase());
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(snmpAuthTypeArr) && snmpAuthTypeArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(snmpAuthTypeArr);
								Ext.getCmp(paramName).setValue(selectedSnmpAuthType);
							}
							Ext.getCmp(paramName).hide();
							Ext.getCmp(paramName).setDisabled(true);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}

							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
									{
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName).setDisabled(false);
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);
								}
							}
						}
						else if (paramName.toLowerCase() == "encrypttype" && isSnmp)
						{
							var snmpEncTypeArr = publicJson['snmpEncTypeArr'];
							var selectedSnmpEncType = publicJson['selectedSnmpEncType'];
							var encryptTypeComboComponent = this.createComboBox(paramName);
							paramsFieldSetContainer.add(encryptTypeComboComponent);
							Ext.getCmp(paramName).setFieldLabel(paramName.toUpperCase());
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(snmpEncTypeArr) && snmpEncTypeArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(snmpEncTypeArr);
								Ext.getCmp(paramName).setValue(selectedSnmpEncType);
							}
							Ext.getCmp(paramName).hide();
							Ext.getCmp(paramName).setDisabled(true);
							var snmpVerObject = '';
							if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpversion');
							}
							else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
							{
								snmpVerObject = Ext.getCmp('snmpVersion');
							}
							if (isModeParamExist)
							{
								var modeSNMP = Ext.getCmp('mode1').getValue();
								if (modeSNMP)
								{
									var snmpVer = snmpVerObject.getValue();
									if (!Ext.isEmpty(snmpVer) && snmpVer != undefined && snmpVer == 'v3')
									{
										var encFlagYes = Ext.getCmp('encryptflag1').getValue();
										if (encFlagYes)
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);
										}
									}
								}
							}
							else
							{
								var snmpVer = snmpVerObject.getValue();
								if (!Ext.isEmpty(snmpVer) && snmpVer != undefined && snmpVer == 'v3' )
								{
									var encFlagYes = Ext.getCmp('encryptflag1').getValue();
									if (encFlagYes )
									{
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName).setDisabled(false);
									}
								}
							}
						}
						else if(paramName.toLowerCase() == "filter" && isPolicyParamExists)
						{
							var policyFilterValue = publicJson['policyFilterValue'];
							var isPolicyFilterValue = publicJson['isPolicyFilterValue'];
							var btnLabel = publicJson['btnLabel'];
							var filterArr = publicJson['filterArr'];
							var selectedPolicyFilter = publicJson['selectedPolicyFilter'];
							
							var xtypeValue = 'multiselectSi';
							var clsName = 'multiselect';
							var heightValue = 90;
							if (testName == 'GrpAppHealthTest')
							{
								xtypeValue = 'scrollcombo';
								clsName = 'dropdown';	
								heightValue	= 0;							
							}
              //GrpAppHealthTest
							var filterCombo = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								id: 'filterComboContainer',
								name: 'filterComboContainer',
								labelSeparator: ' ',
								hidden: true,
								layout: 'column',
								items: [
									{
										xtype: xtypeValue,
										cls: clsName,
										id: paramName+'_combo',
										name: paramName+'_combo',
										height: heightValue,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										editable: false,
										parent:this,
										columnWidth: 0.93,
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype : 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										style : {
											background : 'none',
											border : '0px'
										},
										tooltip: label26,
										listeners: {
											click: function()
											{
												var currentLogType = Ext.getCmp('logType').getValue();
												if (!Ext.isEmpty(currentLogType))
												{
													if (currentLogType.toLowerCase() == '$unconfigured' || 
													currentLogType.toLowerCase() == '$logType')
													{
														Ext.Msg.show({
															title: pageName,
															msg: "Please enter a valid logtype",
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function(response) {
																Ext.getCmp('logType').focus(true);
															}
														});
														return;
													}

													if(!checkAlphabet(currentLogType.replace(/ /g,'')))
													{
														Ext.Msg.show({
															title: pageName,
															msg: _checkspecial,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function() {
																Ext.getCmp('logType').focus(true);
															}
														});
														return;
													}
												}
												testViews.configViewMainPolicy();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(filterCombo);

							var filterFieldContainerComponent = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								id : paramName+'_fieldContainer',
								labelSeparator: ' ',
								hidden: true,
								layout: 'column',
								items: [
									{
										xtype: 'textarea',
										cls: 'text-area',
										id: paramName,
										name: paramName,
										value: policyFilterValue,
										columnWidth: 1,
										rows: 5
									}
								]
							};
							paramsFieldSetContainer.add(filterFieldContainerComponent);

							if (!Ext.isEmpty(isPolicyFilterValue))
							{
								if (isPolicyFilterValue == 'combo')
								{
									var temp = {
										xtype: 'hiddenfield',
										name: 'selectedFilterType',
										id: 'selectedFilterType',
										value: isPolicyFilterValue,
									};
									paramsFieldSetContainer.add(temp);

									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName+'_fieldContainer').hide();

									Ext.getCmp(paramName+'_combo').getStore().removeAll();
									Ext.getCmp(paramName+'_combo').getStore().loadRawData(filterArr);
									Ext.getCmp(paramName+'_combo').setValue(selectedPolicyFilter);
									Ext.getCmp('filterComboContainer').show();
								}
								else if (isPolicyFilterValue == 'fieldContainer')
								{
									var temp = {
										xtype: 'hiddenfield',
										name: 'selectedFilterType',
										id: 'selectedFilterType',
										value: isPolicyFilterValue,
									};
									paramsFieldSetContainer.add(temp);

									Ext.getCmp(paramName+'_combo').setDisabled(true);
									Ext.getCmp('filterComboContainer').hide();

									Ext.getCmp(paramName+'_fieldContainer').show();
								}
							}
						}
						else if (paramName.toLowerCase() == "virtual_center")
						{
							var virtualCenterArr = publicJson['virtualCenterArr'];
							var selectedVirtualCenter = publicJson['selectedVirtualCenter'];
							var virtualComboComponent =  {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								groupField: 'groupField',
								listConfig: {
									tpl: Ext.create('Ext.XTemplate',
									  '<ul><tpl for=".">',
									  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									  '</tpl>',
									  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
									  '</tpl>' +
									  '</ul>',
									  {
										getGroupLabel: function (values) {
										  return values.groupField
										}
									  }
									)
								},
								value: selectedVirtualCenter,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField','groupField'],
										data: virtualCenterArr
									}
								),
								listeners: {
									select: function()
									{
										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Esx_user,Esx_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Esx_user,Esx_password'))
										{
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Esx_user,Esx_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egvcconfig(this.id);

											//Ext.Msg.show({
												//title: pageName,
												//msg: 'Please de-select the password profile, then only enable this selection',
												//buttons: Ext.Msg.OK,
												//icon: 'iconInformation',
												//fn: function()
												//{
													//return;
												//}
											//});
											//return;
										}
										else
										{
											testViews.egvcconfig(this.id);
										}
									}
								}

							};
							paramsFieldSetContainer.add(virtualComboComponent);
						}
						else if (paramName.toLowerCase() == "xms_ip")
						{
							var xmsIPArr = publicJson['xmsIPArr'];
							var selectedXMSIP = publicJson['selectedXMSIP'];
							var xmsIPComboComponent =  {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedXMSIP,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: xmsIPArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password'))
										{
											//Ext.Msg.show({
												//title: pageName,
												//msg: 'Please de-select the password profile, then only enable this selection',
												//buttons: Ext.Msg.OK,
												//icon: 'iconInformation',
												//fn: function()
												//{
													//return;
												//}
											//});
											//return;
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'XtremIO_user,XtremIO_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egxmsconfig(this.id);
										}
										else
										{
											testViews.egxmsconfig(this.id);
										}
									}
								}

							};
							paramsFieldSetContainer.add(xmsIPComboComponent);
						}
						else if (paramName.toLowerCase() == "prism_ip")
						{
							var prismArr = publicJson['prismArr'];
							var selectedPrism = publicJson['selectedPrism'];
							var prismComboComponent =  {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								groupField: 'groupField',
								listConfig: {
									tpl: Ext.create('Ext.XTemplate',
									  '<ul><tpl for=".">',
									  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									  '</tpl>',
									  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
									  '</tpl>' +
									  '</ul>',
									  {
										getGroupLabel: function (values) {
										  return values.groupField
										}
									  }
									)
								},
								value: selectedPrism,
								editable: false,
								forceSelection: false,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField', 'groupField'],
										data: prismArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Prism_user,Prism_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Prism_user,Prism_password'))
										{
											//Ext.Msg.show({
												//title: pageName,
												//msg: 'Please de-select the password profile, then only enable this selection',
												//buttons: Ext.Msg.OK,
												//icon: 'iconInformation',
												//fn: function()
												//{
													//return;
												//}
											//});
											//return;
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Prism_user,Prism_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egnutconfig(this.id);
										}
										else
										{
											testViews.egnutconfig(this.id);
										}
									}
								}

							};
							paramsFieldSetContainer.add(prismComboComponent);
						}
						/////////////////////// RHEV Code Starts
						else if (paramName.toLowerCase() == "rhel_mgr_host")
						{
							var rhelMgrHostArr = publicJson['rhelMgrHostArr'];
							var selectedRhelMgrHost = publicJson['selectedRhelMgrHost'];
							var rhelComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								groupField: 'groupField',
								listConfig: {
									tpl: Ext.create('Ext.XTemplate',
									  '<ul><tpl for=".">',
									  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									  '</tpl>',
									  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
									  '</tpl>' +
									  '</ul>',
									  {
										getGroupLabel: function (values) {
										  return values.groupField
										}
									  }
									)
								},
								value: selectedRhelMgrHost,
								editable: false,
								forceSelection: false,
								parent:this,
								columnWidth: 1,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField', 'groupField'],
										data: rhelMgrHostArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain'))
										{
											//Ext.Msg.show({
												//title: pageName,
												//msg: 'Please de-select the password profile, then only enable this selection',
												//buttons: Ext.Msg.OK,
												//icon: 'iconInformation',
												//fn: function()
												//{
													//return;
												//}
											//});
											//return;
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.egrhevconfig(this.id);
										}
										else
										{
											testViews.egrhevconfig(this.id);
										}
									}
								}
							};
							paramsFieldSetContainer.add(rhelComboComponent);
						}
						//////////////// RHEV code ends
						else if (paramName.toLowerCase() == "management_server")
						{
							var showTextBox = publicJson['showTextBox'+paramName];
							var mgmtTextValue = publicJson['mgmtTextValue'];
							if (Ext.isEmpty(mgmtTextValue) || mgmtTextValue == undefined)
							{
								mgmtTextValue = '$unconfigured';
							}
							var mgmtTextBoxComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName+'_text',
								name: paramName+'_text',
								fieldLabel: tempParamName,
								value: mgmtTextValue,
								hidden: true,
								disabled: true
							};
							paramsFieldSetContainer.add(mgmtTextBoxComponent);

							var mgmtServerArr = publicJson['mgmtServerArr'];
							var selectedHMC = publicJson['selectedHMC'];
							if (Ext.isEmpty(selectedHMC) || selectedHMC == undefined)
							{
								selectedHMC = mgmtServerArr[0].valueField;
							}
							var mgmtServerComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								groupField: 'groupField',
								listConfig: {
									tpl: Ext.create('Ext.XTemplate',
									  '<ul><tpl for=".">',
									  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									  '</tpl>',
									  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
									  '</tpl>' +
									  '</ul>',
									  {
										getGroupLabel: function (values) {
										  return values.groupField
										}
									  }
									)
								},
								value: selectedHMC,
								editable: false,
								forceSelection: false,
								parent:this,
								hidden: true,
								disabled: true,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField', 'groupField'],
										data: mgmtServerArr
									}
								),
								listeners: {
									select: function(){

										var pwdProfile = getPwdProfileParamName(publicJson.pwdParamSetList,'management_user,management_password');

										if (!Ext.isEmpty(pwdProfile))
										{
											if(!Ext.isEmpty(this.value) && (this.value.toLowerCase() != 'none'))
											{
												Ext.getCmp(pwdProfile).hide();
											}
											else
											{
												Ext.getCmp(pwdProfile).show();
											}
										}

										if (isPasswordProfileEnabled(publicJson.pwdParamSetList,'management_user,management_password'))
										{
											//Ext.Msg.show({
												//title: pageName,
												//msg: 'Please de-select the password profile, then only enable this selection',
												//buttons: Ext.Msg.OK,
												//icon: 'iconInformation',
												//fn: function()
												//{
													//return;
												//}
											//});
											//return;
											var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,'management_user,management_password');
											if (!Ext.isEmpty(disabledPwdParam))
											{
												Ext.getCmp(disabledPwdParam.trim()).setValue('none');
												me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
											}
											testViews.eghmcconfig(this.id);
										}
										else
										{
											testViews.eghmcconfig(this.id);
										}
									}
								}
							};
							paramsFieldSetContainer.add(mgmtServerComboComponent);

							var isManagedByObj = Ext.getCmp('is_managed_by');
							var isManagedByVal = '';
							if (!Ext.isEmpty(isManagedByObj) && isManagedByObj != undefined)
							{
								isManagedByVal = isManagedByObj.getValue();
								if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'HMC')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();

									var mgmtServer = 'none';
									mgmtServer = publicJson['selectedHMC'];
									if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
									{
										mgmtServer = 'none';
									}
									Ext.getCmp(paramName).setValue(mgmtServer);
								}
								else if (!Ext.isEmpty(isManagedByVal) && isManagedByVal != undefined && isManagedByVal == 'IVM')
								{
									Ext.getCmp(paramName+'_text').setDisabled(false);
									Ext.getCmp(paramName+'_text').show();

									var mgmtServer = '$unconfigured';
									mgmtServer = publicJson['mgmtTextValue'];
									if (Ext.isEmpty(mgmtServer) || mgmtServer == undefined)
									{
										mgmtServer = '$unconfigured';
									}
									Ext.getCmp(paramName+'_text').setValue(mgmtServer);
								}
							}
						}
						else if (paramName.toLowerCase() == "executiontime")
						{
							var execTimeArr = publicJson['execTimeArr'];
							var dailySelected = publicJson['dailySelected'];
							var selectedExecTime = publicJson['selectedExecTime'];
							var isTimeComboHide = publicJson['isTimeComboHide'];
							if (true)//dailySelected.toLowerCase() == "selected")
							{
								var execTimeHrsArr = publicJson['execTimeHrsArr'];
								var execTimeMinsArr = publicJson['execTimeMinsArr'];
								var selectedHrs = publicJson['selectedHrs'];
								var selectedMins = publicJson['selectedMins'];

								var executionTimeComboComponent = {
									xtype: 'fieldcontainer',
									fieldLabel: tempParamName,
									//id : paramName,
									labelSeparator: ' ',
									layout: 'column',
									items: [
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: paramName,
											name: paramName,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											value: selectedExecTime,
											editable: false,
											parent:this,
											columnWidth: 0.3,
											//margin: '0 5 0 0',
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeArr
												}
											),
											listeners: {
												select: function(){
													testViews.exectimeChangeEvt(this);
												}
											}
										},
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: 'hours',
											name: 'hours',
											value: selectedHrs,
											fieldLabel: Hrs,
											labelWidth: 25,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											editable: false,
											parent:this,
											columnWidth: 0.35,
											margin: '0 0 0 10',
											hidden: isTimeComboHide,
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeHrsArr
												}
											)
										},
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											id: 'minutes',
											name: 'minutes',
											fieldLabel: Mins,
											labelWidth: 30,
											value: selectedMins,
											queryMode: 'local',
											displayField: 'displayField',
											valueField: 'valueField',
											editable: false,
											columnWidth: 0.35,
											margin: '0 0 0 5',
											parent:this,
											hidden: isTimeComboHide,
											store:new Ext.data.Store(
												{
													fields: ['displayField','valueField'],
													data: execTimeMinsArr
												}
											)
										}
									]
								};
								paramsFieldSetContainer.add(executionTimeComboComponent);
							}

							if (!Ext.isEmpty(isTimeComboHide) && isTimeComboHide)
							{
								Ext.getCmp('hours').setDisabled(true);
								Ext.getCmp('hours').hide();
								Ext.getCmp('minutes').setDisabled(true);
								Ext.getCmp('minutes').hide();
							}
							else if (!Ext.isEmpty(isTimeComboHide) && !isTimeComboHide)
							{
								Ext.getCmp('hours').setDisabled(false);
								Ext.getCmp('hours').show();
								Ext.getCmp('minutes').setDisabled(false);
								Ext.getCmp('minutes').show();
							}
						}
						else if (paramName.toLowerCase() == "inside_view_using")
						{
							var insideViewUsingArr = publicJson['insideViewUsingArr'];
							var selectedInsideViewUsing = publicJson['selectedInsideViewUsing'];
							var insideViewComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: selectedInsideViewUsing,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								editable: false,
								parent:this,
								columnWidth: 1,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: insideViewUsingArr
									}
								),
								listeners: {
									select: {
										fn: function() {
											if (!isPasswordProfileEnabled(publicJson.pwdParamSetList,"domain,admin_user,admin_password"))
											{
												me.InsideViewChange(this.value);
											}
											else
											{
												//Ext.Msg.show({
													//title: pageName,
													//msg: 'Please de-select the password profile, then only enable this selection',
													//buttons: Ext.Msg.OK,
													//icon: 'iconInformation'
												//});
												var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,"domain,admin_user,admin_password");
												if (!Ext.isEmpty(disabledPwdParam))
												{
													Ext.getCmp(disabledPwdParam.trim()).setValue('none');
													me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
												}
												me.InsideViewChange(this.value);
											}
										}
									}
								}
							};
							paramsFieldSetContainer.add(insideViewComboComponent);
						}
						else if (paramName.toLowerCase() == "is_managed_by")
						{
							var managedByArr = publicJson['managedByArr'];
							var selectedIsManagedBy = publicJson['selectedIsManagedBy'];
							if (!Ext.isEmpty(selectedIsManagedBy))
							{
								selectedIsManagedBy = selectedIsManagedBy.toUpperCase();
							}

							var isManagedComboComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								value: selectedIsManagedBy,
								editable: false,
								forceSelection: false,
								fieldLabel: tempParamName,
								parent:this,
								store:new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: managedByArr
									}
								),
								listeners: {
									select:
									{
										fn: function() {
											 me.isManagedByChange(this);
										}
									}
								}
							};
							paramsFieldSetContainer.add(isManagedComboComponent);
						}
						else if (paramName.toLowerCase().startsWith("password_profile") && publicJson.isEnablePwdProfile)
						{
							var pwdProfileArr = publicJson['pwdProfileArr'];
							var selectedProfile = publicJson['selectedProfile'+paramName];

							var pwdProfileComponent = {
								xtype: 'scrollcombo',
								cls: 'dropdown',
								id: paramName,
								name: paramName,
								fieldLabel: 'PASSWORD PROFILE',
								value: selectedProfile,
								queryMode: 'local',
								displayField: 'displayField',
								valueField: 'valueField',
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: pwdProfileArr
								}),
								listeners: {
									select:
									{
										fn: function() {
											 me.applyPwdProfile(this)
										}
									}
								}
							};
							paramsFieldSetContainer.add(pwdProfileComponent);

							// Password profile params need to be hide for Special cases(VC,Nutanix) starts

							var pwdParamList = publicJson.pwdParamSetList;
							var passwordProKey = '';
							var profileObj = "";
							var profileSelect = false;

							if(!Ext.isEmpty(pwdParamList))
							{
								for (var key in pwdParamList)
								{
									var profileVal = pwdParamList[key]; 
									if (Ext.isEmpty(profileVal))
									{
										continue;
									}
									if(profileVal == 'Esx_user,Esx_password')
									{
										profileObj = Ext.getCmp('virtual_center');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'management_user,management_password')
									{
										profileObj = Ext.getCmp('management_server');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'Rhel_mgr_user,Rhel_mgr_password,Rhel_mgr_domain')
									{
										profileObj = Ext.getCmp('Rhel_mgr_host');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'Prism_user,Prism_password')
									{
										profileObj = Ext.getCmp('Prism_IP');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
									else if(profileVal == 'XtremIO_user,XtremIO_password')
									{
										profileObj = Ext.getCmp('xms_ip');
										profileSelect = true;
										passwordProKey = key;
										break;
									}
								}
							}

							if(profileSelect)
							{
								if(!Ext.isEmpty(profileObj) && (profileObj.getValue().toLowerCase() != 'none'))
								{
									Ext.getCmp(passwordProKey).hide();
								}
								else
								{
									Ext.getCmp(passwordProKey).show();
								}
							}

							// Password profile params need to be hide for Special cases(VC,Nutanix) ends
			
							if (!Ext.isEmpty(publicJson.pwdProfileProperties))
							{
								var pwdProfileProperties = publicJson.pwdProfileProperties;
								var strShowPwdProfile = paramName+'_isShow';
								var isShowPwdProfile = pwdProfileProperties[strShowPwdProfile];

								if (!Ext.isEmpty(isShowPwdProfile))
								{
									if (!isShowPwdProfile)
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
									}
									else
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
									}
								}
							}

							if (!Ext.isEmpty(publicJson.isMultiUserParamExists) && publicJson.isMultiUserParamExists)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
							}

						}
						else if(paramName.toLowerCase() == "device_name")
						{
							var selectedDeviceName = publicJson['selectedDeviceName'];
							var deviceNameArr = publicJson['deviceNameArr'];
							var discoverBtnLabel = publicJson['discoverBtnLabel'];
							if (Ext.isEmpty(selectedDeviceName) || selectedDeviceName == undefined)
							{
								selectedDeviceName = deviceNameArr[0].valueField;
							}
							var deviceNameComboComponent = {
								xtype: 'fieldcontainer',
								id: paramName+'_fieldContainer',
								name: paramName+'_fieldContainer',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								hidden: true,
								layout: 'column',
								items: [
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id: paramName,
										name: paramName,
										value: selectedDeviceName,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										editable: false,
										disabled: true,
										parent:this,
										columnWidth: 0.93,
										margin: '0 5 0 0',
										store:new Ext.data.Store(
											{
												fields: ['displayField','valueField'],
												data: deviceNameArr
											}
										),
										listeners: {
											select:
											{
												fn: function() {
													 me.changeDeviceId();
												}
											}
										}
									},
									{
										xtype: 'button',
										id: 'selbutton',
										columnWidth: 0.07,
										tooltip: label34,
										iconCls : 'iconDiscovery',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function()
											{
												testViews.configDiscover();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(deviceNameComboComponent);
							var isAdapterManual = Ext.getCmp('adapter_device_selection2').getValue();
							if (isAdapterManual)
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName+'_fieldContainer').show();
							}
						}
						else if (paramName.toLowerCase() == "script_name")
						{
							var selectedScriptLocation = publicJson['selectedScriptLocation'];
							var scriptLocationArr = publicJson['scriptLocationArr'];
              
							var isScriptLocation = {
								xtype: 'fieldcontainer',
								id: "script_locationId",
								name: "script_locationId",
								fieldLabel: tempParamName,
								layout: 'column',
								labelSeparator: ' ',
								items: [
									{
										xtype: 'multiselectSi',
										cls: 'multiselect',
										columnWidth: 0.92,
										id: paramName,
										name: paramName,
										height: 90,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										editable: false,
										parent:this,
										value: selectedScriptLocation,
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: scriptLocationArr
										})
									},
									{
										xtype: 'button',
										id:'scriptFileRecevierBtn',
										name:'scriptFileRecevierBtn',
										iconCls : 'iconConfigure',
										columnWidth: 0.08,
										margin: '0 0 0 5',
										style : {
											background : 'none',
											border : '0px'
										},
										tooltip: 'Apply script file',
										listeners: {
											click: function()
											{
												testViews.userScriptFileReceiver();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(isScriptLocation);

							var hideFilterBtn = publicJson['hideFilterBtn'];
							if (hideFilterBtn)
							{
								Ext.getCmp("scriptFileRecevierBtn").setDisabled(false);
								Ext.getCmp("scriptFileRecevierBtn").show();
							}
							else
							{
								Ext.getCmp(paramName).columnWidth = 1;
								Ext.getCmp("scriptFileRecevierBtn").setDisabled(true);
								Ext.getCmp("scriptFileRecevierBtn").hide();
							}
						}
						else
						{
							var lastComboArr = publicJson['lastComboArr'];
							var selectedLastCombo = publicJson['selectedLastCombo'];
							var lastComboComponent = this.createComboBox(paramName);

							paramsFieldSetContainer.add(lastComboComponent);
							Ext.getCmp(paramName).getStore().removeAll();
							if (!Ext.isEmpty(lastComboArr) && lastComboArr.length > 0)
							{
								Ext.getCmp(paramName).getStore().loadRawData(lastComboArr);
								Ext.getCmp(paramName).setValue(selectedLastCombo);
							}
						}
					}
				}
				else if (displayControl.toLowerCase() == "password")
				{
					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					var isEditable = publicJson['isEditable'+paramName];
					paramValue = publicJson['password'+paramName];
					
					if (isSelectedPwdProfile)
					{
						var pwdTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							readOnly: isSelectedPwdProfile,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(pwdTextComponent);

						var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
						if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
						{
							tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
						}

						var confirmPwdTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName+"confirmpassword",
							name: paramName+"confirmpassword",
							fieldLabel: tmpConfirmParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							//hidden: true,
							//disabled: true,
							readOnly: isSelectedPwdProfile,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function(){
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(confirmPwdTextComponent);
					}
					else if (multiUserMode)
					{
						var pwdTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							readOnly: isEditable,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function(){
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(pwdTextComponent);

						if ((testName == 'CtxXcXALogonSimTest' || 
							testName == 'HrznLogonSimTest' || 
							testName == 'AWSLogonSimTest' || 
							testName == 'WVDLogonSimTest' || 
							testName == 'HrznWLogonSimTest') && 
							(paramName == 'Registration_code' || 
							paramName == 'Resource_password' || 
							paramName == 'Two_factor_auth_password'))
						{
							isEditable = true;
						}

						if (!isEditable)
						{
							var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
							if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
							{
								tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
							}
							var confirmPwdTextComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName+"confirmpassword",
								name: paramName+"confirmpassword",
								fieldLabel: tmpConfirmParamName,
								inputType: 'password',
								backupValue: paramValue,
								//value: paramValue
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function(){
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;//Ext.getCmp(paramName+"confirmpassword");
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											this.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							};
							paramsFieldSetContainer.add(confirmPwdTextComponent);
						}

						if ((testName == 'CtxXcXALogonSimTest' || 
							testName == 'HrznLogonSimTest' ||
							testName == 'AWSLogonSimTest' ||
							testName == 'WVDLogonSimTest' ||
							testName == 'AwsAppStrmSimTest' ||
							testName == 'HrznWLogonSimTest') && 
							(paramName == 'Password' || 
							paramName == 'Registration_code' || 
							paramName == 'Resource_password' || 
							paramName == 'Two_factor_auth_password'))
						{
							Ext.getCmp(paramName).hide();
							if (!isEditable)
							{
								Ext.getCmp(paramName+"confirmpassword").hide();
							}
						}

						if ((componentType == "VmVdi_i_server"  || componentType == "VmEsx_i_server" )  && paramName == 'Esx_password')
						{
							var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
							if (!Ext.isEmpty(vCenterObjVal) && (vCenterObjVal.toLowerCase() != 'none' && vCenterObjVal.toLowerCase() != 'other'))
							{
								Ext.getCmp(paramName).setReadOnly(true);
								Ext.getCmp(paramName+'confirmpassword').setReadOnly(true);
							}
						}
					}
					else if (paramName == 'Email_password')
					{
						var EMailPwdTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							readOnly: isEditable,
							hidden: true,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function(){
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(EMailPwdTextComponent);
					}
					else if (paramName == 'enable_password')
					{
						var enablePwdComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							inputType: 'password',
							//value: paramValue,
							backupValue: paramValue,
							readOnly: isEditable,
							hidden: true,
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function(){
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						};
						paramsFieldSetContainer.add(enablePwdComponent);


						var enableModeObj = Ext.getCmp('is_privilege_mode_enabled1');

						if (!Ext.isEmpty(enableModeObj))
						{
							var useSAPControlYes = enableModeObj.getValue();
							//console.log('useSAPControlYes ',useSAPControlYes);
							if (useSAPControlYes)
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
							}
							else 
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
							}
						}
					}
					else
					{
						if ((isSnmp || isMeasurementModeParamExist || isMeasureModeParamExist || isModeParamExist ) && (paramName.toLowerCase() == 'jmx_password' || paramName == 'encryptpassword' || paramName == 'authpass' || paramName == 'password'))
						{
							var pwdTextComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								inputType: 'password',
								//value: paramValue,
								backupValue: paramValue,
								hidden: true,
								disabled: true,
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function(){
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
							}
							};
							paramsFieldSetContainer.add(pwdTextComponent);

							if (!isEditable)
							{
								var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
								if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
								{
									tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
								}
								var confirmPwdTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName+"confirmpassword",
									name: paramName+"confirmpassword",
									fieldLabel: tmpConfirmParamName,
									inputType: 'password',
									//value: paramValue,
									backupValue: paramValue,
									hidden: true,
									disabled: true,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function(){
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								};
								paramsFieldSetContainer.add(confirmPwdTextComponent);
							}
						}
						else
						{
							var pwdTextComponent = {
								xtype: 'textfield',
								cls: 'textbox',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								inputType: 'password',
								//value: paramValue
								backupValue: paramValue,
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function(){
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							};
							paramsFieldSetContainer.add(pwdTextComponent);
							if (!isEditable)
							{
								var tmpConfirmParamName = publicJson['paramNameObj'][paramName+'confirmpassword'];
								if (!Ext.isEmpty(tmpConfirmParamName) && tmpConfirmParamName.lastIndexOf('#') > -1)
								{
									tmpConfirmParamName = tmpConfirmParamName.substring(0,tmpConfirmParamName.length - 1);
								}
								var confirmPwdTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName+"confirmpassword",
									name: paramName+"confirmpassword",
									fieldLabel: tmpConfirmParamName,
									inputType: 'password',
									//value: paramValue
									backupValue: paramValue,
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function(){
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								};
								paramsFieldSetContainer.add(confirmPwdTextComponent);
							}
						}

						if (componentType.toLowerCase() == "ms_azure_cloud" &&
							paramName.toLowerCase() == "client_password")
						{
							if (paramValue.toLowerCase() != '$unconfigured')
							{
								Ext.getCmp(paramName).setReadOnly(true);
								Ext.getCmp(paramName+'confirmpassword').setReadOnly(true);
							}
							else
							{
								Ext.getCmp(paramName).setReadOnly(false);
								Ext.getCmp(paramName+'confirmpassword').setReadOnly(false);
							}
						}

						if (testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf' || testName == 'AsAbapSyslgTest' ||
							testName == 'WDispAvailTest' || 
							testName == 'WDispCacheTest' ||
							testName == 'WDispConnTest' || 
							testName == 'WDispServListTest' ||
							testName == 'WDispConfigTest' ||
							testName == 'WDispStatusTest' || 
							testName == 'WDispThreadTest')
						{
							var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
							var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
							var useDataCollTypeObj = Ext.getCmp('data_collection_mode1');
							if (!Ext.isEmpty(useSAPControlObj))
							{
								var useSAPControlNo = useSAPControlObj.getValue();
								if (useSAPControlNo)
								{
									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
									
								}
								else 
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}

									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
							}
							if (!Ext.isEmpty(useSAPControlObjAuto))
							{
								var useSAPControlNo = useSAPControlObjAuto.getValue();
								if (useSAPControlNo.toLowerCase()=='false')
								{
									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
								else if (useSAPControlNo.toLowerCase()=='true')
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}

									if (paramName == 'password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
								else 
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
									Ext.getCmp(paramName+'confirmpassword').show();
								}
							}

							if (!Ext.isEmpty(useDataCollTypeObj))
							{
								var useSAPControl = useDataCollTypeObj.getValue();
								if (useSAPControl)
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									
								}
								else 
								{
									if (paramName == 'os_password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
								}
							}
						}

						if (testName == 'VMViewEventsTest' && (paramName == 'password' || paramName == 'Password'))
						{
							var isAPIModeObj = Ext.getCmp('Using_Horizon_API1');
							if (!Ext.isEmpty(isAPIModeObj))
							{
								var isAPIModeChkd = isAPIModeObj.getValue();
								if (isAPIModeChkd)
								{
									if (paramName == 'Password')
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
									else
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
									
								}
								else 
								{
									if (paramName == 'Password')
									{
										Ext.getCmp(paramName).setDisabled(true);
										Ext.getCmp(paramName).hide();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
										Ext.getCmp(paramName+'confirmpassword').hide();
									}
									else
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
										Ext.getCmp(paramName+'confirmpassword').show();
									}
								}
							}
						}

						if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_access_key' || paramName == 'AWS_secret_key'))
						{
							var isAccessTypeObj = Ext.getCmp('Access_Type1');
							var isAccessTypeRoleChkd = isAccessTypeObj.getValue();
							if (isAccessTypeRoleChkd)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName).hide();
								Ext.getCmp(paramName+'confirmpassword').setDisabled(true);
								Ext.getCmp(paramName+'confirmpassword').hide();
							}
							else 
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
								Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
								Ext.getCmp(paramName+'confirmpassword').show();
							}
						}

						var snmpVerObject = '';
						if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpversion');
						}
						else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
						{
							snmpVerObject = Ext.getCmp('snmpVersion');
						}

						if (isModeParamExist)
						{
							var modeSNMP = Ext.getCmp('mode1').getValue();
							var modeJMX = Ext.getCmp('mode2').getValue();
							if (modeSNMP)
							{
								if ( isSnmp && !Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
								{
									var snmpVer = snmpVerObject.getValue();
									if (snmpVer == 'v3' )
									{
										if (paramName == 'encryptpassword')
										{
											var encFlagYes = Ext.getCmp('encryptflag1').getValue();
											if (!Ext.isEmpty(encFlagYes) && encFlagYes != undefined && encFlagYes)
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);

												Ext.getCmp(paramName+"confirmpassword").show();
												Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
											}
										}
										else if (paramName == 'authpass')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);

											Ext.getCmp(paramName+"confirmpassword").show();
											Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
										}
									}
								}
							}
							else if (modeJMX)
							{
								if (paramName == 'Jmx_password' || paramName == 'password')
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName+'confirmpassword').setDisabled(false);
									Ext.getCmp(paramName+'confirmpassword').show();
								}
							}
						}
						else if( isSnmp && !Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
						{
							var snmpVer = snmpVerObject.getValue();
							if (snmpVer == 'v3' )
							{
								if (paramName == 'encryptpassword')
								{
									var encFlagYes = Ext.getCmp('encryptflag1').getValue();
									if (!Ext.isEmpty(encFlagYes) && encFlagYes != undefined && encFlagYes)
									{
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName).setDisabled(false);

										Ext.getCmp(paramName+"confirmpassword").show();
										Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
									}
								}
								else
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);

									Ext.getCmp(paramName+"confirmpassword").show();
									Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
								}
							}

							if (paramName == 'Jmx_password' || paramName == 'password')
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName).show();
								Ext.getCmp(paramName+"confirmpassword").show();
								Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
							}
						}
						else if (isMeasureModeParamExist)
						{
							var measureModeLog = Ext.getCmp('measure_mode1').getValue();
							var measureModeJmx = Ext.getCmp('measure_mode2').getValue();
							if (measureModeJmx)
							{
								if (paramName == 'Jmx_password' || paramName == 'password')
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName+"confirmpassword").show();
									Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
								}
							}
						}
						else if (isMeasurementModeParamExist)
						{
							var measurementModeWar = Ext.getCmp('measurement_mode1').getValue();
							var measurementModeJmx = Ext.getCmp('measurement_mode2').getValue();
							if (measurementModeWar)
							{
								if (paramName == 'password')
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName+"confirmpassword").show();
									Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
								}
							}
							else if (measurementModeJmx)
							{
								if (paramName == 'Jmx_password')
								{
									Ext.getCmp(paramName).show();
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName+"confirmpassword").show();
									Ext.getCmp(paramName+"confirmpassword").setDisabled(false);
								}
							}
						}

						if (testName == 'EsxGPUStatsTest' && paramName == 'console_password')
						{
							var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
							if (!Ext.isEmpty(vCenterObjVal) && vCenterObjVal.toLowerCase() == 'none')
							{
								var esxPwd = Ext.getCmp('Esx_password').getValue();
								Ext.getCmp(paramName).setValue(esxPwd);
								Ext.getCmp(paramName).hide();
								Ext.getCmp(paramName+'confirmpassword').setValue(esxPwd);
								Ext.getCmp(paramName+'confirmpassword').hide();
							}
						}
						
						if ((componentType == "VmVdi_i_server"  || componentType == "VmEsx_i_server" )  && paramName == 'Esx_password')
						{
							var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
							if (!Ext.isEmpty(vCenterObjVal) && (vCenterObjVal.toLowerCase() != 'none' && vCenterObjVal.toLowerCase() != 'other'))
							{
								Ext.getCmp(paramName).setReadOnly(true);
								Ext.getCmp(paramName+'confirmpassword').setReadOnly(true);
							}
						}
					}
				}
				else if (displayControl.toLowerCase() == "textarea")
				{
					var strVal = "";
					if (testName == previousTestName)
					{
						strVal = Ext.getCmp(paramName).getValue();
					}

					if (!Ext.isEmpty(strVal))
					{
						paramValue = strVal;
					}

					if (paramValue.indexOf('|') > -1)
					{
						paramValue = publicJson['pipeParamValue'];
					}

					var isAgentInstalledAndRunning = publicJson['isAgentInstalledAndRunning'];
					var isCompAgentless = publicJson['isCompAgentless'];

					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					
					if(((paramName.toLowerCase() == "servicename") || (testName=='ScrtySrvceChecksTest' && paramName.toLowerCase() == 'services_to_be_disabled')) && !isCompAgentless && isAgentInstalledAndRunning)
					{
						var tmpParamValue = paramValue;
						if(paramValue.indexOf(testInfoDelimiter) > -1)
						{
							tmpParamValue = publicJson['testInfoDelimParamValue'];
						}
						if (strDelimiterMask.length > 0 && paramValue.indexOf(strDelimiterMask) != -1)
						{
							tmpParamValue = publicJson['strDelimiterMaskParamValue'];
						}

						var viewLabel = publicJson['viewLabel'];
						var serviceTextAreaComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: tmpParamValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 8 0 0'
								},
								{
									xtype: 'button',
									id: 'viewUrl',
									columnWidth: 0.07,
									tooltip: viewLabel,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners : {
										click : function()
										{
											testViews.winServiceConfig();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(serviceTextAreaComponent);
					}
					else if(paramName.toLowerCase() == "process" && !isCompAgentless && isAgentInstalledAndRunning)
					{
						if(paramValue.indexOf(testInfoDelimiter) > -1)
						{
							paramValue = publicJson['testInfoDelimParamValue'];
						}
						var viewLabel = publicJson['viewLabel'];
						var processTextAreaComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: paramValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 8 0 0',
								},
								{
									xtype: 'button',
									id: 'viewUrl',
									columnWidth: 0.07,
									tooltip: viewLabel,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners : {
										click : function()
										{
											testViews.processConfig();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(processTextAreaComponent);
					}
					else if (paramName.toLowerCase() == "custom_bt_naming") 
					{
						if (paramValue.indexOf(testInfoDelimiter) > -1) {
							paramValue = publicJson['testInfoDelimParamValue'];
						}
						var viewLabel = publicJson['viewLabel'];
						var processTextAreaComponent = {
							xtype: 'fieldcontainer',
							//fieldLabel: tempParamName,
							fieldLabel: btnRules,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									readOnly:true,
									id: paramName,
									name: paramName,
									value: paramValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 8 0 0',
								}, 
								{
									xtype: 'button',
									id: 'viewUrl',
									columnWidth: 0.07,
									tooltip: viewLabel,
									iconCls: 'iconConfigure',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										click: function () {
											testViews.btNamingConfig();
										}
									}
								}
							]
						};

						me.getRuleNamesFromIni(false);

						paramsFieldSetContainer.add(processTextAreaComponent);
					}
					else if (paramName.toLowerCase() == "context_bt_configuration") 
					{
						if (paramValue.indexOf(testInfoDelimiter) > -1) {
							paramValue = publicJson['testInfoDelimParamValue'];
						}
						var viewLabel = publicJson['viewLabel'];
						var processTextAreaComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: btnContextRulesLabel,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									readOnly:true,
									id: paramName,
									name: paramName,
									value: paramValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 8 0 0',
								}, 
								{
									xtype: 'button',
									id: 'viewContextUrl',
									columnWidth: 0.07,
									tooltip: viewLabel,
									iconCls: 'iconConfigure',
									style: {
										background: 'none',
										border: '0px',
									},
									listeners: {
										click: function () {
											testViews.btContextConfig();
										}
									}
								}
							]
						};

						me.getContextRuleNamesFromIni(false);

						paramsFieldSetContainer.add(processTextAreaComponent);
					}
					else if (paramName.toLowerCase() == "min_max_values") 
					{
						var tmpParamValue = paramValue;
						if(paramValue.indexOf(testInfoDelimiter) > -1)
						{
							tmpParamValue = publicJson['testInfoDelimParamValue'];
						}
						if (strDelimiterMask.length > 0 && paramValue.indexOf(strDelimiterMask) != -1)
						{
							tmpParamValue = publicJson['strDelimiterMaskParamValue'];
						}

						var viewLabel = publicJson['viewLabel'];
						var minmaxBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: minMaxLabel,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: viewLabel,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.winServiceConfig_pr();
										}
									}
								},
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: tmpParamValue,
									hidden: true
								}
							]
						};
						paramsFieldSetContainer.add(minmaxBtnComponent);
						
					}
					else if(paramName.toLowerCase() == "exclude" ||
						paramName.toLowerCase() == "servicename" ||
						paramName.toLowerCase() == "process" ||
						paramName.toLowerCase() == "searchpattern")
					{
						var tmpDataParamName = paramName;
						var tmpParamValue = paramValue;
						if(paramValue.indexOf(testInfoDelimiter) > -1)
						{
							tmpParamValue = publicJson['testDelimParamValue'];
						}
						if (strDelimiterMask.length > 0 && paramValue.indexOf(strDelimiterMask) != -1)
						{
							tmpParamValue = publicJson['strDelimiterMaskParamValue'];
						}

						var lastViewTextAreaComponent = {
							xtype: 'textarea',
							cls: 'text-area',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: tmpParamValue,
							rows: 5
						};
						paramsFieldSetContainer.add(lastViewTextAreaComponent);
					}
					else if(paramName.toLowerCase()=='dynamic_servers' || 
						paramName.toLowerCase()=='remote_servers' || 
						paramName.toLowerCase()=='target_ports')
					{
						var tmpDataParamName = paramName;
						var tmpParamValue = publicJson['paramValue'+paramName];
						var clientServiceTextAreaComponent = {
							xtype: 'textarea',
							cls: 'text-area',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: tmpParamValue,
							rows: 5
						};
						paramsFieldSetContainer.add(clientServiceTextAreaComponent);
					}
					else
					{
						var lastTextAreaComponent = {
							xtype: 'textarea',
							cls: 'text-area',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: paramValue,
							rows: 5,
							cols: 35
						};
						paramsFieldSetContainer.add(lastTextAreaComponent);
					}
				}
				else //text
				{
					var tempParamName = publicJson['paramNameObj'][paramName];
					if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
					{
						tempParamName = tempParamName.substring(0,tempParamName.length - 1);
					}
					if (isSnmp || isPolicyParamExists || isCorrectParamExist || isUrlParamExist || isWsdlUrlExist || paramName.toLowerCase() == "real_servername")
					{
						var temp = paramValue;
						var strVal = "";
						if (testName == previousTestName )
						{
							strVal = Ext.getCmp(paramName).getValue();
						}
						if (!Ext.isEmpty(strVal))
						{
							paramValue = strVal;
						}
						else
						{
							paramValue = temp;
						}
					}

					if(paramName.toLowerCase() == "correctivescript")
					{
						var correctiveScriptId = paramName;
						var correctiveScriptParamValue = publicJson['correctiveScriptParamValue'];
						var correctiveScriptArr = publicJson['correctiveScriptArr'];

						if (Ext.isEmpty(correctiveScriptParamValue)|| correctiveScriptParamValue === 'none')
						{
							var tmpValue = correctiveScriptArr[0].valueField;
							correctiveScriptParamValue = tmpValue; 
						}

						var correctiveMultiSelectComponent = {
							xtype: 'fieldcontainer',
							id: paramName+'_fieldContainer',
							name: paramName+'_fieldContainer',
							fieldLabel: tempParamName,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'multiselectSi',
									cls: 'multiselect',
									columnWidth: 0.90,
									id: paramName,
									name: paramName,
									height: 90,
									queryMode: 'local',
									displayField: 'displayField',
									valueField: 'valueField',
									editable: false,
									parent:this,
									value: correctiveScriptParamValue,
									store:new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: correctiveScriptArr
									})
								},
								{
									xtype: 'button',
									id:'configCorrectScriptBtn',
									name:'configCorrectScriptBtn',
									//iconCls : 'iconUpload',
									iconCls : 'iconConfigure',
									columnWidth: 0.10,
									margin: '0 0 0 5',
									style : {
										background : 'none',
										border : '0px'
									},
									tooltip: 'Upload corrective script',
									listeners: {
										click: function()
										{
											testViews.configureCorrectiveScriptFile();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(correctiveMultiSelectComponent);

						var isAdminLinkEnabled = publicJson['isAdminLinkEnabled'];
						var isAgentInstalledAndRunningCs = publicJson['isAgentInstalledAndRunningCs'];
						if (isAdminLinkEnabled)
						{
							if (isAgentInstalledAndRunningCs)
							{
								Ext.getCmp("configCorrectScriptBtn").setDisabled(false);
								Ext.getCmp("configCorrectScriptBtn").show();
							}
							else
							{
								Ext.getCmp(paramName).columnWidth = 1;
								Ext.getCmp("configCorrectScriptBtn").setDisabled(true);
								Ext.getCmp("configCorrectScriptBtn").hide();
							}
						}
						else 
						{
							Ext.getCmp(paramName).columnWidth = 1;
							Ext.getCmp("configCorrectScriptBtn").setDisabled(true);
							Ext.getCmp("configCorrectScriptBtn").hide();
						}

						Ext.getCmp(paramName).setDisabled(true);
						Ext.getCmp(paramName+'_fieldContainer').hide();
						if (!isRemote && isCorrectParamExist)
						{
							var isCorrectYes = Ext.getCmp('correct1').getValue();
							var isCorrectNo = Ext.getCmp('correct2').getValue();
							if (isCorrectNo)
							{
								Ext.getCmp(paramName).setDisabled(true);
								Ext.getCmp(paramName+'_fieldContainer').hide();
							}
							else if (isCorrectYes)
							{
								Ext.getCmp(paramName).setDisabled(false);
								Ext.getCmp(paramName+'_fieldContainer').show();
							}
						}
					}
					else if (paramName.toLowerCase() == "include_descriptors")
					{
						var includeValue = publicJson[paramName+'Value'];
						var includeDescParamComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							value: includeValue,
							fieldLabel: tempParamName,
							hidden: true
						};

						paramsFieldSetContainer.add(includeDescParamComponent);
						if (!Ext.isEmpty(Ext.getCmp('action_on_descriptors1')))
						{
							var actionOnDesc = Ext.getCmp('action_on_descriptors1').getValue();
							if (actionOnDesc )
							{
								Ext.getCmp(paramName).show();
							}
						}
					}
					else if (paramName.toLowerCase() == "excludedescriptor")
					{
						var excludeValue = publicJson[paramName+'Value'];
						var excludeDescParamComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							value: excludeValue,
							fieldLabel: tempParamName,
							hidden: true
						};
						paramsFieldSetContainer.add(excludeDescParamComponent);

						if (!Ext.isEmpty(Ext.getCmp('action_on_descriptors2')))
						{
							var actionOnDesc = Ext.getCmp('action_on_descriptors2').getValue();
							if (actionOnDesc)
							{
								Ext.getCmp(paramName).show();
							}
							
						}
					}
					else if (paramName.toLowerCase() == "site_url(s)")
					{

						if (paramValue.indexOf('|') > -1)
						{
							paramValue = publicJson['pipeParamValue'];
						}

						var defaultValue = paramValue;
						if(!Ext.isEmpty(defaultValue) && defaultValue.indexOf(',') != -1)
						{
							var situArray = defaultValue.split(',');
							var paramValue = '';
							for(b=0; b<situArray.length; b++)
							{
								if(situArray[b].indexOf('~#~') != -1)
								{
									siteArrOne=situArray[b].split('~#~');
									paramValue += ','+siteArrOne[0];
								}
								else{
									paramValue += ','+situArray[b];
								}
							}
							
							if (!Ext.isEmpty(paramValue))
							{
								paramValue = paramValue.substring(1);
							}

						}
						else
						{
							if(defaultValue.indexOf('~#~') != -1)
							{
								siteArrOne=defaultValue.split('~#~');
								paramValue=siteArrOne[0];
							}
							else{
								paramValue=defaultValue;
							}

							if (defaultValue.toLowerCase() == '$unconfigured')
							{
								defaultValue = '$unconfigured~#~$unconfigured';
								paramValue = '$unconfigured';
							}
						}
						var siteURLTextComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: paramValue,
									columnWidth: 0.93,
									margin: '0 5 0 0',
									backupValue:defaultValue,
								},
								{
									xtype: 'button',
									iconCls : 'iconConfigure',
									columnWidth: 0.07,
									tooltip: 'Configure Site URL(s)',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function()
										{
											testViews.siteUrlConfig();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(siteURLTextComponent);
						Ext.getCmp('site_URL(S)').setReadOnly(true);
					}
					else if (paramName.toLowerCase() == "website_name" &&  componentType.toLowerCase() != "ms_azure_app_service")
					{
						paramValue = publicJson['remainParamValue'+paramName];
						var websiteTextComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: paramValue,
									columnWidth: 0.93,
									margin: '0 5 0 0'
								},
								{
									xtype: 'button',
									iconCls : 'iconConfigure',
									columnWidth: 0.07,
									tooltip: 'Configure Website',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function()
										{
											//testViews.siteUrlConfig();
											testViews.getSite();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(websiteTextComponent);
					}
					else if (paramName.toLowerCase() == "exclude_websites" &&  componentType.toLowerCase() != "ms_azure_app_service")
					{
						paramValue = publicJson['remainParamValue'+paramName];
						var websiteTextComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: paramValue,
									columnWidth: 0.93,
									margin: '0 5 0 0'
								},
								{
									xtype: 'button',
									iconCls : 'iconConfigure',
									columnWidth: 0.07,
									tooltip: 'Configure Website',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function()
										{
											//testViews.siteUrlConfig();
											testViews.getExcludeSite();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(websiteTextComponent);
						if (paramName.toLowerCase() == "exclude_websites")
						{
							var websites = Ext.getCmp('website_name').getValue();
							if (!Ext.isEmpty(websites) && websites.toLowerCase() != 'all')
							{
								Ext.getCmp(paramName).setReadOnly(true);
							}
						}
					}
					else if(paramName.toLowerCase() == "exclude_websites" &&  componentType.toLowerCase() != "ms_azure_app_service")
					{
						paramValue = publicJson['remainParamValue'+paramName];
						var websiteVal = Ext.getCmp('website_name').getValue();
						var isEditMode = false;
						if (!Ext.isEmpty(websiteVal) && websiteVal.toLowerCase() != 'all')
						{
							isEditMode = true;
							paramValue = 'none';
						}
						var excludeWebsiteTextComp = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: paramValue,
							readOnly: isEditMode,
							columnWidth: 1
						};
						paramsFieldSetContainer.add(excludeWebsiteTextComp);
					}
					else if(paramName.toLowerCase() == "exclude_interfaces")
					{
						var excludeInfTextComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: 'Configure Interfaces',
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function()
										{
											testViews.excludeInfConfig(reportName);
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue
								}
							]
						};
						paramsFieldSetContainer.add(excludeInfTextComponent);
						Ext.getCmp('Exclude_Interfaces').setReadOnly(true);

					}
					else if (paramName.toLowerCase() == "management_user")
					{
						var strIsManagedByChanged = publicJson['isManagedByChanged'];
						if (Ext.isEmpty(strIsManagedByChanged ))
						{
							var mgmtUserTextComponent = this.createTextBox(paramName);
							paramsFieldSetContainer.add(mgmtUserTextComponent);
							Ext.getCmp(paramName).setValue(paramValue);
						}
						else
						{
							var tempUser = publicJson['tempUser'];
							if (tempUser != null)
							{
								paramValue = tempUser;
							}
							var mgmtUserTextComponent = this.createTextBox(paramName);
							paramsFieldSetContainer.add(mgmtUserTextComponent);
							Ext.getCmp(paramName).setValue(paramValue);
						}
						var fromUsrIniManagedBy = publicJson['selectedIsManagedBy'];
						if (!Ext.isEmpty(fromUsrIniManagedBy) && fromUsrIniManagedBy != undefined && fromUsrIniManagedBy.toLowerCase() == 'hmc')
						{
							var mgmtUser = 'none';
							mgmtUser = publicJson['tempUser'];
							if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
							{
								mgmtUser = 'none';
							}
							Ext.getCmp(paramName).setValue(mgmtUser);
						}
						else
						{
							var mgmtUser = '$unconfigured';
							mgmtUser = publicJson['tempUser'];
							if (Ext.isEmpty(mgmtUser) || mgmtUser == undefined)
							{
								mgmtUser = '$unconfigured';
							}
							Ext.getCmp(paramName).setValue(mgmtUser);
						}
					}
					else if(paramName.toLowerCase() == "url")
					{
						if (isCredentialParamExist)
						{
							urlParamValue = publicJson['urlParamValue'];
							imageTitle = publicJson['imageTitle'];
							var urlTextComponent =  {
								xtype: 'fieldcontainer',
								id: paramName.toUpperCase(),
								name: paramName.toUpperCase(),
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										columnWidth: 0.93,
										margin: '0 5 0 0',
										value: urlParamValue,
										readOnly: true,
										listeners: {
											blur: function()
											{
												me.checkURLAndCredentials(urlParamValue);
											}
										}
									},
									{
										xtype : 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										tooltip: label29,
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function()
											{
												plusButtonClicked = "true";
												testViews.configCerdentialurl();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(urlTextComponent);
						}
						else
						{
							//var tempDataPara = paramName;
							urlParamValue = publicJson['urlParamValue'];
							var urlTextAreaComponent = {
								xtype: 'textarea',
								cls: 'text-area',
								id: paramName,
								name: paramName,
								fieldLabel: tempParamName,
								value: urlParamValue,
								rows: 5
							};
							paramsFieldSetContainer.add(urlTextAreaComponent);
							if (!Ext.isEmpty(Ext.getCmp('measurement_mode2')) && Ext.getCmp('measurement_mode2') != undefined)
							{
								var measurementMode = Ext.getCmp('measurement_mode2').getValue();
								if (!measurementMode)
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
								else
								{
									Ext.getCmp(paramName).setDisabled(true);
									Ext.getCmp(paramName).hide();
								}
							}
						}
					}
					//Targets start
					else if(paramName.toLowerCase() == "targets" && isTargetWthSysProps)
					{	
						var tgtParamValue=publicJson['tgtParamValue'];
							var urlTextComponent =  {
								xtype: 'fieldcontainer',
								id: paramName.toUpperCase(),
								name: paramName.toUpperCase(),
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										value: tgtParamValue,
										columnWidth: 0.93,
										margin: '0 5 0 0',
									},
									{
										xtype : 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										tooltip: label29,
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function()
											{
												testViews.configTgtsSysPropties();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(urlTextComponent);
					}
					//Targets - end
					else if(paramName.toLowerCase() == "wsdl_url")
					{
						if (isCredentialParamExist)
						{
							wsdlUrlParamValue = publicJson['wsdlUrlParamValue'];
							wsdlUrlImgTitle = publicJson['wsdlUrlImgTitle'];
							var wsdlUrlTextComponent = {
								xtype: 'fieldcontainer',
								fieldLabel: tempParamName,
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										columnWidth: 0.93,
										margin: '0 5 0 0',
										listeners: {
											blur: function()
											{
												me.checkURLAndCredentials(wsdlUrlParamValue);
											}
										},
										value: wsdlUrlParamValue
									},
									{
										xtype: 'button',
										iconCls : 'iconAdd',
										columnWidth: 0.07,
										style : {
											background : 'none',
											border : '0px'
										},
										tooltip: label29,
										listeners: {
											click: function()
											{
												testViews.configureWsdlUrl();
											}
										}
									}
								]
							};
							paramsFieldSetContainer.add(wsdlUrlTextComponent);
						}
						else
						{
							wsdlUrlParamValue = publicJson['wsdlUrlParamValue'];
							if (isXDMGetDevicesInfo)
							{
								var wsdlUrlTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: wsdlUrlParamValue
									
								};
								paramsFieldSetContainer.add(wsdlUrlTextComponent);
							}
							else
							{
								if(!Ext.isEmpty(paramForDisplayingValidateButton) && paramForDisplayingValidateButton.toLowerCase() == paramName)
								{
									var wsdlUrlTextComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: wsdlUrlParamValue
										
									};
									paramsFieldSetContainer.add(wsdlUrlTextComponent);
								}
							}
						}
					}
					else if(paramName.toLowerCase() == "operations")
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var operationsTextComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textarea',
									cls: 'text-area',
									id: paramName,
									name: paramName,
									value: paramValue,
									rows: 5,
									columnWidth: 0.93,
									margin: '0 5 0 0'
								},
								{
									xtype: 'button',
									iconCls : 'iconAdd',
									columnWidth: 0.07,
									tooltip: label31,
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function()
										{
											testViews.webServiceConfigure();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(operationsTextComponent);
					}
					else if (paramName.toLowerCase() == "rule_name")
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var ruleNameBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: ruleNameToolTip,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.createRulesForSyslog(paramNamePopUp);
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue  
								}
							]
						};
						paramsFieldSetContainer.add(ruleNameBtnComponent);
					}
					else if(paramName.toLowerCase() == "target_diskio_rate")
					{
						diskIOParamValue = publicJson['targetDiskIOParamValue'];
						targetDiskIORateLabelArr = publicJson['targetDiskIORateLabelArr'];
						targetDiskIORateSelect = publicJson['targetDiskIORateSelect'];
						if (Ext.isEmpty(targetDiskIORateSelect) || targetDiskIORateSelect == undefined)
						{
							targetDiskIORateSelect = targetDiskIORateLabelArr[0].valueField;
						}

						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var taskIOComboComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id: 'TargetDiskIORate_select',
									name: 'TargetDiskIORate_select',
									displayField: 'displayField',
									valueField: 'valueField',
									value: targetDiskIORateSelect,
									queryMode: 'local',
									editable: false,
									columnWidth:0.7,
									store: new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: targetDiskIORateLabelArr
									})
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									columnWidth: 0.3,
									value: diskIOParamValue
								}
							]
						};
						paramsFieldSetContainer.add(taskIOComboComponent);
					}
					else if ((testName.toLowerCase() == "windowsharetest" || testName.toLowerCase() == "uncchecktest") &&
						paramName.toLowerCase() == "sharename")
					{
						shareNameParamValue = publicJson['shareNameParamValue'];
						var imageTitle = publicJson['btnLabel'+paramName];
						var compNameWithoutNull = publicJson['compNameWithoutNull'];
						var shareBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: paramName.toUpperCase(),
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: label30,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.configWindowShared();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(shareBtnComponent);
					}
					else if(testName == 'AudShrdFoldTest' && paramName.toLowerCase()=='shared_folders')
					{
						var tmpDataParamName = paramName;
						var tmpParamValue = publicJson['paramValue'+paramName];
						var shareFoldersComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							layout: 'column',
							labelSeparator: ' ',
							items: [
								{
									xtype: 'button',
									id: 'viewUrl',
									columnWidth: 1,
									tooltip: 'Configure shared folders',
									iconCls : 'iconPlus',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners : {
										click : function()
										{
											testViews.getShareFolders();
										}
									}
								},
								{
									xtype: 'hiddenfield',
									id: paramName,
									name: paramName,
									value: paramValue,
								},
							]
						};
						paramsFieldSetContainer.add(shareFoldersComponent);
					}
					else if (isSystemPropertyParamTests &&
						(paramName.toLowerCase() == "system_property_key" || paramName.toLowerCase() == "system_property_value"))
					{
						if ( paramName.toLowerCase() == "system_property_key")
						{
							var sysPropKey = publicJson['sysPropKey'];
							var keyBtnComponent = {
								xtype: 'fieldcontainer',
								fieldLabel: sysPropLbl.toUpperCase(),
								labelSeparator: ' ',
								layout: 'column',
								items: [
									{
										xtype: 'button',
										columnWidth: 1,
										tooltip: tootipProperty,
										iconCls : 'iconConfigure',
										style : {
											background : 'none',
											border : '0px'
										},
										listeners: {
											click: function() {
												testViews.configSystemProperties();
											}
										}
									},
									{
										xtype: 'hiddenfield',
										name: paramName,
										id: paramName,
										value: sysPropKey
									}
								]
							};
							paramsFieldSetContainer.add(keyBtnComponent);
						}
						else if (paramName.toLowerCase() == "system_property_value")
						{
							continue;
						}
					}
					else if (componentType.toLowerCase() == "oracle_server" &&
						paramName.toLowerCase() == "user")
					{
						var oraleUserText = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: paramValue,
									columnWidth: 0.93,
									margin: '0 8 0 0'
								},
								{
									xtype: 'button',
									columnWidth: 0.07,
									tooltip: label32,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.configDbCreation();
										}
									}
								}
							]
						};
						paramsFieldSetContainer.add(oraleUserText);
					}
					else if (paramName.toLowerCase() == "email_id")
					{
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}
						var emailIdBtnComponent = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'button',
									columnWidth: 1,
									tooltip: tootipExchange,
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.configEMailCredential();
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue
								}
							]
						};
						paramsFieldSetContainer.add(emailIdBtnComponent);
					}
					else if (paramName.toLowerCase() == "custom_name_for_application")
					{
						var ruleNameValue = publicJson['rulenameValue'];
						var tempParamName = publicJson['paramNameObj'][paramName];
						if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
						{
							tempParamName = tempParamName.substring(0,tempParamName.length - 1);
						}

						var customNameText = {
							xtype: 'fieldcontainer',
							fieldLabel: tempParamName,
							labelSeparator: ' ',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: 'rulename',
									name: 'rulename',
									value: ruleNameValue,
									columnWidth: 0.93,
									margin: '0 8 0 0'
								},
								{
									xtype: 'button',
									columnWidth: 0.07,
									tooltip: 'Configure an application customization',
									iconCls : 'iconConfigure',
									style : {
										background : 'none',
										border : '0px'
									},
									listeners: {
										click: function() {
											testViews.configCustomConfigurations();
										}
									}
								},
								{
									xtype: 'hiddenfield',
									name: paramName,
									id: paramName,
									value: paramValue
								}
							]
						};
						paramsFieldSetContainer.add(customNameText);
					}
					else if (paramName.toLowerCase() == "cache_time")
					{
						var cacheTextComponent = {
							xtype: 'textfield',
							cls: 'textbox',
							id: paramName,
							name: paramName,
							fieldLabel: tempParamName,
							value: paramValue,
							columnWidth: 1
						};
						paramsFieldSetContainer.add(cacheTextComponent);
					}
					else
					{
						var remProcessParamIdx = this.continueParamMethod(processParamremoteContinue,paramName);
						//for remote based monitoring continuing the process parameters
						if (remProcessParamIdx  && isRemote) continue;
						var multiUserOrNameParamValue = publicJson['multiUserOrNameParamValue'+paramName];
						var isEditable = publicJson['readOnly'+paramName];

						if (multiUserMode || multiNamePatternMode || multiOidsMode)
						{
							if (readOnlyParamIdx)
							{
								var plusButton = publicJson['plusButton'+paramName];
								var onBlurStr  = publicJson['onBlurStr'+paramName];
								var onFocusStr = publicJson['onFocusStr'+paramName];
								var onChangeStr = publicJson['onChangeStr'+paramName];
								var tmpPName = paramName;
								var tmpPValue = multiUserOrNameParamValue;

								if (!Ext.isEmpty(plusButton) && plusButton != undefined)
								{
									var tooltipMsg = '';
									var icon ='iconAdd';
									var oid_xtype='textfield';
									var oid_cls='textbox';
									if (multiUserOrNameParamValue.length > 30 && readOnly.toLowerCase() == "")
									{
										oid_xtype='textarea';
										oid_cls='text-area';
									}
									if (multiUserMode)
									{
										if (paramName == 'Connection_server_name')
										{
											tooltipMsg = serverNameToolTip
										}
										else if ( ( (testName == 'DiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (paramName == 'automation_configuration_rules') ) || 
										( (testName == 'WVDDiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (paramName == 'automation_configuration_rules') ))
										{
                                           	tooltipMsg = dskSpcTstAtmtnCnfgrClnUpRls;
										}										
										else
										{
											tooltipMsg = label27;
										}
									}
									else if(multiOidsMode)
									{
										tooltipMsg = 'Configure OIDs';
										icon='iconConfigure';
									}
									else
									{
										tooltipMsg = label28;
									}
									var paramNamePopUp = paramName;
									var multifieldContainerTextComponent = {
										xtype: 'fieldcontainer',
										id: 'multifieldContainerTextComponent',
										labelSeparator: ' ',
										fieldLabel: tempParamName,
										layout: 'column',
										items: [
											{
												xtype: 'textfield',
												cls: 'textbox',
												id: paramName,
												name: paramName,
												value: multiUserOrNameParamValue,
												readOnly: isEditable,
												columnWidth: 0.93,
												margin: '0 5 0 0',
												listeners: {
													change: function()
													{
														if (multiUserMode)
														{
															me.getUserChangedValue(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.getNamePatternChangedValue(this.id);
														}
													},
													focus: function()
													{
														if (multiUserMode)
														{
															me.getUserValue(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.getNamePatternValue(this.id);
														}
														else if (multiOidsMode)
														{
															me.getNamePatternValue(this.id);
														}
													},
													blur: function()
													{
														if (multiUserMode)
														{
															me.checkMultipleUser(this.id);
														}
														else if (multiNamePatternMode)
														{
															me.checkMultipleNamePattern(this.id);
														}
														else if (multiOidsMode)
														{
															me.checkMultipleNamePattern(this.id);
														}
													}
												}
											},
											{
												xtype : 'button',
												id : 'multiUserIcon',
												iconCls : icon,
												columnWidth: 0.07,
												style : {
													background : 'none',
													border : '0px'
												},
												tooltip: tooltipMsg,
												listeners: {
													click: function()
													{
														if(testName == 'DiskSpaceTest' || testName == 'WVDDiskSpaceTest')
														{
															testViews.getPopUpViewForTest(testName, paramNamePopUp);
														}
														else
														{
															testViews.getPopUpView(paramNamePopUp);
														}
													}
												}
											}
										]
									};
									if(( (testName == 'DiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (Ext.getCmp('autmtd_actn_enbld_dskspc2').getValue()))
										|| ( (testName == 'WVDDiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd) && (Ext.getCmp('autmtd_actn_enbld_wvd_dskspc2').getValue())))
									{
										multifieldContainerTextComponent.hidden = true;
									}
									paramsFieldSetContainer.add(multifieldContainerTextComponent);
								}
								else if ((testName.toLowerCase() == "ctxxcxalogonsimtest" || 
											testName.toLowerCase() == "hrznlogonsimtest" || 
											testName.toLowerCase() == "hrznwlogonsimtest" || 
											testName.toLowerCase() == "wvdlogonsimtest" || 
											testName.toLowerCase() == "awsappstrmsimtest" ||
											testName.toLowerCase() == "awslogonsimtest") &&
											paramName.toLowerCase() == "published_resources")
								{
									var paramNamePopUp = paramName;
									if (testName.toLowerCase() == "wvdlogonsimtest")
									{
										tempParamName = wvdPubResrcLbl;
									}
									var pubResrcBtnComponent = {
										xtype: 'fieldcontainer',
										fieldLabel: tempParamName,
										labelSeparator: ' ',
										layout: 'column',
										items: [
											{
												xtype: 'button',
												columnWidth: 1,
												tooltip: wvdPubResourceToolTip,
												iconCls : 'iconConfigure',
												style : {
													background : 'none',
													border : '0px'
												},
												listeners: {
													click: function() {
														if (testName.toLowerCase() == "hrznwlogonsimtest")
														{
															testViews.configHorizonWSResourceSet();
														}
														else if (testName.toLowerCase() == "wvdlogonsimtest")
														{
															testViews.configWVDResourceSet();
														}
														else if (testName.toLowerCase() == "awslogonsimtest")
														{
															testViews.configAmazonWSResourceSet();
														}
														else if (testName.toLowerCase() == "awsappstrmsimtest")
														{
															testViews.configAwsAppStreamResourceSet();
														}
														else
														{
															testViews.getPopUpView(paramNamePopUp);
														}
													}
												}
											},
											{
												xtype: 'hiddenfield',
												name: paramName,
												id: paramName,
												value: multiUserOrNameParamValue
											}
										]
									};
									paramsFieldSetContainer.add(pubResrcBtnComponent);
								}
								else
								{
									var multifieldContainerTextComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: multiUserOrNameParamValue,
										columnWidth: 1,
										readOnly: isEditable
									};
									paramsFieldSetContainer.add(multifieldContainerTextComponent);

									if ((testName == 'CtxXcXALogonSimTest' || 
										testName == 'HrznLogonSimTest' ||  
										testName == 'AwsAppStrmSimTest' ||  
										testName == 'AWSLogonSimTest') && 
										(paramName == 'Username' ||
										paramName == 'Domain'))
									{
										Ext.getCmp(paramName).hide();
									}
								}
							}
							else if ((testName == 'CtxXcXALogonSimTest' || 
										testName == 'WVDLogonSimTest' || 
										testName == 'AwsAppStrmSimTest' ||
										testName == 'HrznLogonSimTest') && 
										paramName == 'Site_url')
							{
								var siteURLTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: multiUserOrNameParamValue,
									columnWidth: 1,
									readOnly: isEditable
								};
								paramsFieldSetContainer.add(siteURLTextComponent);
							}
							else if ((paramName.toLowerCase() == 'snmpport'|| 
								paramName.toLowerCase() == 'username' || 
								paramName.toLowerCase() == 'context' || 
								paramName.toLowerCase() == 'snmpcommunity') && isSnmp)
							{
								var fieldContainerComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: paramValue,
									disabled: true,
									hidden: true
								};
								paramsFieldSetContainer.add(fieldContainerComponent);
								if (isSnmp)
								{
									if (paramName.toLowerCase() == 'snmpport' )
									{
										snmpPortextValues = paramValue;
									}
									else if (paramName == 'context' )
									{
										snmpUserContextValues = paramValue;
									}
									else if (paramName == 'username' )
									{
										snmpUserTextValues = paramValue;
									}
									else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
									{
										snmpCommunityTextValues = paramValue;
									}

									var snmpVerObject = '';
									if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
									{
										snmpVerObject = Ext.getCmp('snmpversion');
									}
									else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
									{
										snmpVerObject = Ext.getCmp('snmpVersion');
									}

									//if (paramName.toLowerCase() == 'username' )
									//{
										//snmpUserTextValues = paramValue;
									//}
									//else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
									//{
										//snmpCommunityTextValues = paramValue;
									//}

									if (paramName.toLowerCase() == 'snmpport')
									{
										Ext.getCmp(paramName).show();
										Ext.getCmp(paramName).setDisabled(false);
									}
									else
									{
										var snmpVer = snmpVerObject.getValue();
										if (paramName.toLowerCase() == 'username' && snmpVer == 'v3')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);
										}
										else if (paramName == 'context' && snmpVer == 'v3')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);
										}
										else if ((paramName == 'snmpCommunity' || paramName == 'snmpcommunity' ) && snmpVer != 'v3')
										{
											Ext.getCmp(paramName).show();
											Ext.getCmp(paramName).setDisabled(false);
										}
									}
								}
							}
							//else if (paramName.toLowerCase() == 'single_signon'|| 	paramName.toLowerCase() == 'user_id')
							else if (paramName.toLowerCase() == 'user_id')

							{
								var fieldContainerComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									fieldLabel: tempParamName,
									value: paramValue,
								};
								paramsFieldSetContainer.add(fieldContainerComponent);

								if (testName == 'HrznWLogonSimTest')
								{
									Ext.getCmp(paramName).hide();
								}
							}
							else
							{
								if (multiUserOrNameParamValue.length > 30 && readOnly.toLowerCase() == "")
								{
									var multiTextAreaComponent = {
										xtype: 'textarea',
										cls: 'text-area',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: multiUserOrNameParamValue,
										readOnly: isEditable,
										rows: 5
									};
									paramsFieldSetContainer.add(multiTextAreaComponent);
								}
								else
								{
									var multiTextBoxComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: multiUserOrNameParamValue,
										readOnly: isEditable,
									};
									paramsFieldSetContainer.add(multiTextBoxComponent);
								}

								if ((testName == 'CtxXcXALogonSimTest' || 
									testName == 'HrznLogonSimTest' ||
									testName == 'AWSLogonSimTest' ||
									testName == 'AwsAppStrmSimTest' ||
									testName == 'WVDLogonSimTest' ||
									testName == 'HrznWLogonSimTest') && 
									(paramName == 'Username' || 
									paramName == 'Resource_domain' || 
									paramName == 'Resource_username' || 
									paramName == 'Disclaimer'))
								{
									Ext.getCmp(paramName).hide();
								}
							}
							if( (testName == 'DiskSpaceTest' || testName == 'WVDDiskSpaceTest') && (isDskSpcTstAtmnDrvRprtd))
							{
								if(paramName == 'automation_configuration_rules')
								{
									var autoConfigRules = Ext.getCmp('automation_configuration_rules');
									if( (autoConfigRules) && (!Ext.isEmpty(autoConfigRules)) && (autoConfigRules != undefined) )
									{
										autoConfigRules.hide();
									}										
								}
								else if(paramName == 'drive_name')
								{
									var driveName = Ext.getCmp('drive_name');
									if( (driveName) && (!Ext.isEmpty(driveName)) && (driveName != undefined) )
									{
										driveName.hide();
									}										
								}
								else if(paramName == 'drive_utilization_percentage')
								{
									var driveUtilPrcnt = Ext.getCmp('drive_utilization_percentage');
									if( (driveUtilPrcnt) && (!Ext.isEmpty(driveUtilPrcnt)) && (driveUtilPrcnt != undefined) )
									{
										driveUtilPrcnt.hide();
									}										
								}
								else if(paramName == 'files_and_folders_to_be_cleaned')
								{
									var filesFldrsToBeClnd = Ext.getCmp('files_and_folders_to_be_cleaned');
									if( (filesFldrsToBeClnd) && (!Ext.isEmpty(filesFldrsToBeClnd)) && (filesFldrsToBeClnd != undefined) )
									{
										filesFldrsToBeClnd.hide();
									}										
								}								
							}

							if ((componentType == "VmVdi_i_server" || componentType == "VmEsx_i_server" ) && 
								(paramName == 'Esx_user' || paramName == 'webPort'))
							{
								var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
								if (!Ext.isEmpty(vCenterObjVal) && (vCenterObjVal.toLowerCase() != 'none' && vCenterObjVal.toLowerCase() != 'other'))
								{
									Ext.getCmp(paramName).setReadOnly(true);
								}
							}
						}
						else
						{
							if(paramName == "device_id")
							{
								var deviceIdParamValue = publicJson['deviceIdParamValue'];
								var isEditable = publicJson['readOnly'];
								var deviceTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: deviceIdParamValue,
									fieldLabel: tempParamName,
									readOnly: isEditable,
									disabled: true,
									hidden: true
								};
								paramsFieldSetContainer.add(deviceTextComponent);
								var isAdapterManual = Ext.getCmp('adapter_device_selection2').getValue();
								if (isAdapterManual)
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							else if(paramName.toLowerCase() == "url_patterns")
							{
								var urlPatternParamValue = publicJson['URLPatternsParamValue'];
								
								var urlPatternTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: urlPatternParamValue,
									fieldLabel: tempParamName,
									disabled: true,
									hidden: true
								};
								paramsFieldSetContainer.add(urlPatternTextComponent);
								
								if (testName == "JavaTransactionsTest")
								{
									var isUrlPatternDiscManualMode = '';
									if (!Ext.isEmpty(Ext.getCmp('URL_Pattern_Discovery_Mode2')) && Ext.getCmp('URL_Pattern_Discovery_Mode2') != undefined )
									{
										isUrlPatternDiscManualMode = Ext.getCmp('URL_Pattern_Discovery_Mode2').getValue();
									}
									else
									{
										isUrlPatternDiscManualMode = Ext.getCmp('url_pattern_discovery_mode2').getValue();
									}
									
									if (isUrlPatternDiscManualMode)
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
									}
								}
								else
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							else if(paramName.toLowerCase() == "max_url_segments")
							{
								var MaxURLSegmentsParamValue = publicJson['MaxURLSegmentsParamValue'];
								var MaxURLSegmentsTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: MaxURLSegmentsParamValue,
									fieldLabel: tempParamName,
									disabled: true,
									hidden: true
								};
								paramsFieldSetContainer.add(MaxURLSegmentsTextComponent);

								if (testName == "JavaTransactionsTest")
								{
									var isUrlPatternDiscAutoMode = '';
									if (!Ext.isEmpty(Ext.getCmp('URL_Pattern_Discovery_Mode1')) && Ext.getCmp('URL_Pattern_Discovery_Mode1') != undefined )
									{
										isUrlPatternDiscAutoMode = Ext.getCmp('URL_Pattern_Discovery_Mode1').getValue();
									}
									else
									{
										isUrlPatternDiscAutoMode = Ext.getCmp('url_pattern_discovery_mode1').getValue();
									}

									if (isUrlPatternDiscAutoMode)
									{
										Ext.getCmp(paramName).setDisabled(false);
										Ext.getCmp(paramName).show();
									}
								}
								else
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							else if(paramName.toLowerCase() == 'cim_server_port')
							{
								var sslFalse = Ext.getCmp("ssl1").getValue();
								var CIMServerPortParamValue = publicJson['CIMServerPortParamValue'];
								if (!sslFalse && !Ext.isEmpty(paramValue) && paramValue == '5988' )
								{
									CIMServerPortParamValue = '5989';
								}
								else if (sslFalse && !Ext.isEmpty(paramValue) && paramValue == '5989' )
								{
									CIMServerPortParamValue = '5989';
								}

								var cimServerPortTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: CIMServerPortParamValue,
									fieldLabel: tempParamName
								};
								paramsFieldSetContainer.add(cimServerPortTextComponent);
							}
							else if(paramName.toLowerCase() == 'serialnumber')
							{
								var serialNumberParamValue = publicJson['serialNumberParamValue'];
								var isEmbeddedFalse = Ext.getCmp("isEmbedded1").getValue();
								if (!isEmbeddedFalse )
								{
									serialNumberParamValue = 'default';
								}

								var serialnumberTextComponent = {
									xtype: 'textfield',
									cls: 'textbox',
									id: paramName,
									name: paramName,
									value: serialNumberParamValue,
									fieldLabel: tempParamName,
									hidden: true
								};
								paramsFieldSetContainer.add(serialnumberTextComponent);
								if (isEmbeddedFalse)
								{
									Ext.getCmp(paramName).setDisabled(false);
									Ext.getCmp(paramName).show();
								}
							}
							else
							{
								paramValue = publicJson['remainParamValue'+paramName];
								if (paramValue == '(null)')
								{
									paramValue = 'null';
								}
								if(testName == 'NodeTransTest' || testName == 'KNodeTransTest')
								{								
									var maskAllHeaderFieldsObj = Ext.getCmp("Mask_All_Header_Fields_radioGrp");
									var excludeHeaderFieldsListObj = Ext.getCmp("Exclude_Header_Fields_From_Masking");
									var maskCookieFieldObj = Ext.getCmp("Mask_All_Cookie_Fields_radioGrp");
									var maskExceptionMessageObj = Ext.getCmp("Mask_Exception_Message_radioGrp");				
									JMXParamDisable(maskAllHeaderFieldsObj);
									JMXParamDisable(excludeHeaderFieldsListObj);
									JMXParamDisable(maskCookieFieldObj);
									JMXParamDisable(maskExceptionMessageObj);									
								}
								if ((isSnmp || isMeasurementModeParamExist || isMeasureModeParamExist || isModeParamExist || isCorrectParamExist) &&
									( paramName.toLowerCase() == 'snmpport' ||
									paramName.toLowerCase() == 'context' ||
									paramName.toLowerCase() == 'username' ||
									paramName.toLowerCase() == 'snmpcommunity' ||
									paramName.toLowerCase() == 'jmx_remote_port' ||
									paramName.toLowerCase() == 'jndi_name' ||
									paramName.toLowerCase() == 'user' ||
									paramName.toLowerCase() == 'jrehome' ||
									paramName.toLowerCase() == 'logfilename' ||
									paramName.toLowerCase() == 'jmx_user' ||
									paramName.toLowerCase() == 'java_home' ||
									paramName.toLowerCase() == 'include_packages' ||
									paramName.toLowerCase() == 'exclude_packages' ||
									paramName.toLowerCase() == 'heap_dump_location' ||
									paramName.toLowerCase() == 'provider' ||
									paramName.toLowerCase() == 'userparams'))
								{
									var fieldContainerComponent = {
										xtype: 'textfield',
										cls: 'textbox',
										id: paramName,
										name: paramName,
										fieldLabel: tempParamName,
										value: paramValue,
										disabled: true,
										hidden: true
									};
									paramsFieldSetContainer.add(fieldContainerComponent);
									if (!isRemote && isCorrectParamExist)
									{
										if (paramName == 'userparams')
										{
											var isCorrectYes = Ext.getCmp('correct1').getValue();
											if (isCorrectYes)
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
										else if (paramName == 'user')
										{
											Ext.getCmp(paramName).setDisabled(false);
											Ext.getCmp(paramName).show();
										}
									}
									if (isSnmp)
									{
										if (paramName.toLowerCase() == 'snmpport' )
										{
											snmpPortextValues = paramValue;
										}
										else if (paramName == 'context' )
										{
											snmpUserContextValues = paramValue;
										}
										else if (paramName == 'username' )
										{
											snmpUserTextValues = paramValue;
										}
										else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
										{
											snmpCommunityTextValues = paramValue;
										}

										if (isModeParamExist)
										{
											var modeSNMP = Ext.getCmp('mode1').getValue();
											var modeJMX = Ext.getCmp('mode2').getValue();
											if (modeSNMP)
											{
												if (paramName.toLowerCase() == 'snmpport' )
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												var snmpVerObject = '';
												if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
												{
													snmpVerObject = Ext.getCmp('snmpversion');
												}
												else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
												{
													snmpVerObject = Ext.getCmp('snmpVersion');
												}
												if (!Ext.isEmpty(snmpVerObject) && snmpVerObject != undefined)
												{
													var snmpVer = snmpVerObject.getValue();
													if (paramName == 'context' && snmpVer == 'v3')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
													else if (paramName == 'username' && snmpVer == 'v3')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
													else if ((paramName == 'snmpCommunity' || paramName == 'snmpcommunity' ) && snmpVer != 'v3')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
												}
											}
											else if (modeJMX)
											{
												if (paramName.toLowerCase() == 'jmx_remote_port')
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName.toLowerCase() == 'jndi_name')
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName.toLowerCase() == 'provider')
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else if (paramName == 'Jmx_user' || paramName ==  'user')
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
											}

											var heapAnalysisObject = '';
											if (!Ext.getCmp(Ext.getCmp('Heap_Analysis1')) && Ext.getCmp('Heap_Analysis1') != undefined)
											{
												heapAnalysisObject = Ext.getCmp('Heap_Analysis1');
											}
											else if (!Ext.getCmp(Ext.getCmp('heap_analysis1')) && Ext.getCmp('heap_analysis1') != undefined)
											{
												heapAnalysisObject = Ext.getCmp('heap_analysis1');
											}

											if (!Ext.isEmpty(heapAnalysisObject) && heapAnalysisObject != undefined)
											{
												var heapYes = heapAnalysisObject.getValue();
												if (heapYes)
												{
													if (paramName.toLowerCase() == 'java_home')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else if (paramName.toLowerCase() == 'include_packages')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else if (paramName.toLowerCase() == 'exclude_packages')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else if (paramName.toLowerCase() == 'heap_dump_location')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
											}
										}
										else
										{
											var snmpVerObject = '';
											if (!Ext.isEmpty(Ext.getCmp('snmpversion')) && Ext.getCmp('snmpversion') != undefined )
											{
												snmpVerObject = Ext.getCmp('snmpversion');
											}
											else if (!Ext.isEmpty(Ext.getCmp('snmpVersion')) && Ext.getCmp('snmpVersion') != undefined )
											{
												snmpVerObject = Ext.getCmp('snmpVersion');
											}

											if (paramName.toLowerCase() == 'username' )
											{
												snmpUserTextValues = paramValue;
											}
											else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
											{
												snmpCommunityTextValues = paramValue;
											}
											if (paramName.toLowerCase() == 'snmpport')
											{
												Ext.getCmp(paramName).show();
												Ext.getCmp(paramName).setDisabled(false);
											}
											else
											{
												if (paramName.toLowerCase() == 'username' || paramName.toLowerCase() == 'context' )
												{
													var snmpVer = snmpVerObject.getValue();
													if (!Ext.isEmpty(snmpVer) && snmpVer == 'v3')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
												}
												else if (paramName == 'snmpCommunity' || paramName == 'snmpcommunity' )
												{
													var snmpVer = snmpVerObject.getValue();
													if (!Ext.isEmpty(snmpVer) && snmpVer != 'v3')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
												}

												if (isSnmp)
												{
													if (paramName == 'Jmx_user' || paramName == 'user')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
											}
										}
									}
									else if (isMeasureModeParamExist)
									{
										var measureModeLog = Ext.getCmp('measure_mode1').getValue();
										var measureModeJmx = Ext.getCmp('measure_mode2').getValue();
										if (measureModeLog)
										{
											if (paramName.toLowerCase() == 'jrehome')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'logfilename')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											
											var jmxRegistrySslParamName = publicJson.originalParamNameObj['JMX_REGISTRY_SSL'];
											jmxRegistrySslParamName = jmxRegistrySslParamName+'_radioGrp';
											var jmxRegistrySslParamNameObj = Ext.getCmp(jmxRegistrySslParamName);
											JMXParamDisable(jmxRegistrySslParamNameObj);
										}
										else if (measureModeJmx)
										{
											if (paramName.toLowerCase() == 'jmx_remote_port')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'jndi_name')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'provider')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'jmx_user' || paramName.toLowerCase() == 'user')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
									}
									else if (isMeasurementModeParamExist)
									{
										var measurementModeWar = Ext.getCmp('measurement_mode1').getValue();
										var measurementModeJmx = Ext.getCmp('measurement_mode2').getValue();
										if (measurementModeWar)
										{
											if (paramName.toLowerCase() == 'username')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
										else if (measurementModeJmx)
										{
											if (paramName.toLowerCase() == 'jmx_remote_port')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'jndi_name')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'provider')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
											else if (paramName.toLowerCase() == 'jmx_user')
											{
												Ext.getCmp(paramName).setDisabled(false);
												Ext.getCmp(paramName).show();
											}
										}
									}
								}
								else
								{
									var tempParamName = publicJson['paramNameObj'][paramName];
									if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
									{
										tempParamName = tempParamName.substring(0,tempParamName.length - 1);
									}
									var isEditable = publicJson['readOnly'];
									var descriptorButton = publicJson['descriptorButton'+paramName];

									if (isSelectedPwdProfile)
									{
										isEditable = isSelectedPwdProfile;
									}

									if (paramName.toLowerCase() == 'monitor_url_post_data')
									{
										paramValue = publicJson['paramValue'+paramName];
										if (!Ext.isString(paramValue))//.toLowerCase() != 'none' )
										{
											paramValue = JSON.stringify(paramValue);
										}
									}

									if (!Ext.isEmpty(descriptorButton) && descriptorButton != undefined)
									{
										tempDescParam = paramName;
										var descBtnTextBoxComponent = {
											xtype: 'fieldcontainer',
											fieldLabel: tempParamName,
											labelSeparator: ' ',
											layout: 'column',
											items: [
												{
													xtype: 'textfield',
													cls: 'textbox',
													id: paramName,
													name: paramName,
													value: paramValue,
													readOnly: isEditable,
													columnWidth: 0.93,
													margin: '0 5 0 0'
												},
												{
													xtype: 'button',
													id: 'descDetailBtn',
													name: 'descDetailBtn',
													columnWidth: 0.07,
													tooltip: label33,
													iconCls : 'iconConfigure',
													style : {
														background : 'none',
														border : '0px'
													},
													listeners : {
														click : function()
														{
															testViews.configureDescriptorDetails(tempDescParam);
														}
													}
												}
											]
										};
										paramsFieldSetContainer.add(descBtnTextBoxComponent);
									}
									else if (paramValue.length > 30 && !isEditable)
									{
										//EgSyslogFilterTest
										if ((testName == 'EgSyslogFilterTest' || 
											testName == 'EgSyslogFilterSvrTest' ||
											testName == 'DeviceSyslogMsgs') && (paramName == 'facility' || 
											paramName == 'filter_host' || paramName == 'level' ||
											paramName == 'filter_logic' || paramName == 'exclude_Patterns' ))
										{
											var lastTextBoxRefuseTxtAreaComponent =  {
												xtype: 'textfield',
												cls: 'textbox',
												id: paramName,
												name: paramName,
												value: paramValue,
												fieldLabel: tempParamName,
												hidden: true,
												readOnly: isEditable
											};
											paramsFieldSetContainer.add(lastTextBoxRefuseTxtAreaComponent);
										}
										else
										{
											var lastViewTextBoxComponent = {
												xtype: 'textarea',
												cls: 'text-area',
												id: paramName,
												name: paramName,
												fieldLabel: tempParamName,
												value: paramValue,
												rows: 5
											};
											paramsFieldSetContainer.add(lastViewTextBoxComponent);
										}
										
										//AWS_Account_ID_To_Monitor, AWS_Role_Name
										if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_Role_Name' || 
											paramName == 'AWS_Account_ID_To_Monitor'))
										{
											var accessTypeObj = Ext.getCmp('Access_Type1');
											if (!Ext.isEmpty(accessTypeObj))
											{
												var isAccessTypeRoleChkd = accessTypeObj.getValue();

												if (isAccessTypeRoleChkd)
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
											}
										}

										if (componentType.toLowerCase() == "ms_azure_cloud" &&
											(paramName.toLowerCase() == "subscription_id" ||
											paramName.toLowerCase() == "tenant_id" ||
											paramName.toLowerCase() == "client_id"))
										{
											if (paramValue.toLowerCase() != '$unconfigured')
											{
												Ext.getCmp(paramName).setReadOnly(true);
											}
											else
											{
												Ext.getCmp(paramName).setReadOnly(false);
											}
										}
										// text field convert to textarea based on the input values
										if ((testName == 'WDispAvailTest' || 
											testName == 'WDispCacheTest' ||
											testName == 'WDispConnTest' || 
											testName == 'WDispServListTest' ||
											testName == 'WDispConfigTest' ||
											testName == 'WDispStatusTest' || 
											testName == 'WDispThreadTest') && (paramName == 'timeout(seconds)' || 
											paramName == 'profile_file' || paramName == 'web_dispatcher_dir' ||
											paramName == 'os_username' ||
											paramName == 'wsdl_port'))
										{
											var isSAPCtrlChkd = Ext.getCmp('data_collection_mode1').getValue();

											if (isSAPCtrlChkd)
											{
												if (paramName == 'timeout(seconds)' || 
													paramName == 'profile_file' ||
													paramName == 'web_dispatcher_dir')
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
												else
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
											else
											{
												if (paramName == 'os_username' || paramName == 'wsdl_port')
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
												else
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
										}

										if (paramName == 'sysno' || 
											paramName == 'logon_group' || paramName == 'Message_Server' ||
											paramName == 'Application_server')
										{
											var connTypeObj = Ext.getCmp('Connection_type1');
											if (!Ext.isEmpty(connTypeObj))
											{
												var isSAPCtrlChkd = Ext.getCmp('Connection_type1').getValue();

												if (isSAPCtrlChkd)
												{
													if (paramName == 'sysno' ||
														paramName == 'Application_server')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
													else
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else
												{
													if (paramName == 'sysno' || paramName == 'Application_server')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
													else
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
												}
											}
										}
									}
									else
									{
										//By default both the fields (host,port) are expected to be read-only
										var hostOrPortEditable = false;
										if (paramName.toLowerCase() == "host" && (!Ext.isEmpty(hostEditableMode) &&  hostEditableMode.toLowerCase() == "false"))
										{
											hostOrPortEditable = true;
											isEditable = true;
										}

										if (componentType.toLowerCase() == "ms_azure_cloud" &&
											(paramName.toLowerCase() == "subscription_id" ||
											paramName.toLowerCase() == "tenant_id" ||
											paramName.toLowerCase() == "client_id") && paramValue.toLowerCase() != '$unconfigured')
										{
											isEditable = true;
										}
										//By default both the fields(host,port) are expected to be read-only

										var lastTextBoxComponent =  {
											xtype: 'textfield',
											cls: 'textbox',
											id: paramName,
											name: paramName,
											value: paramValue,
											fieldLabel: tempParamName,
											readOnly: isEditable
										};
										paramsFieldSetContainer.add(lastTextBoxComponent);

										if (paramName == 'sysno' || 
											paramName == 'logon_group' || paramName == 'Message_Server' ||
											paramName == 'Application_server')
										{
											var connTypeObj = Ext.getCmp('Connection_type1');
											if (!Ext.isEmpty(connTypeObj))
											{
												var isSAPCtrlChkd = Ext.getCmp('Connection_type1').getValue();

												if (isSAPCtrlChkd)
												{
													if (paramName == 'sysno' ||
														paramName == 'Application_server')
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
													else
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else
												{
													if (paramName == 'sysno' || paramName == 'Application_server')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
													else
													{
														Ext.getCmp(paramName).show();
														Ext.getCmp(paramName).setDisabled(false);
													}
												}
											}
										}

										//AWS_Account_ID_To_Monitor, AWS_Role_Name
										if (componentType == 'AWS_EC2_Cloud' && (paramName == 'AWS_Role_Name' || 
											paramName == 'AWS_Account_ID_To_Monitor'))
										{
											var accessTypeObj = Ext.getCmp('Access_Type1');
											if (!Ext.isEmpty(accessTypeObj))
											{
												var isAccessTypeRoleChkd = accessTypeObj.getValue();

												if (isAccessTypeRoleChkd)
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
											}
										}

										//EgSyslogFilterTest
										if ((testName == 'EgSyslogFilterTest' || 
											testName == 'EgSyslogFilterSvrTest' || 
											testName == 'DeviceSyslogMsgs') && (paramName == 'facility' || 
											paramName == 'filter_host' || paramName == 'level' ||
											paramName == 'filter_logic' || paramName == 'exclude_Patterns' ))
										{
											Ext.getCmp(paramName).hide();
										}

										if ((testName == 'AsAbapWorkTest' || testName == 'AsAbapWPCnfTest_cf' || testName == 'AsAbapSyslgTest') && (paramName == 'timeout' || 
											paramName == 'sapuser' || paramName == 'sysno' ||
											paramName == 'clientname' || paramName == 'router' || 
											paramName == 'instancename' || paramName == 'os_username' ||
											paramName == 'wsdl_port'))
										{
											var useSAPControlObj = Ext.getCmp('use_sapcontrol2');
											var useSAPControlObjAuto = Ext.getCmp('use_sapcontrol');
											if (!Ext.isEmpty(useSAPControlObj))
											{
												var useSAPControlNo = useSAPControlObj.getValue();
												if (useSAPControlNo)
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
												else 
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
												}
											}
											if (!Ext.isEmpty(useSAPControlObjAuto))
											{
												var useSAPControlNo = useSAPControlObjAuto.getValue();
												if (useSAPControlNo.toLowerCase()=='false')
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
												}
												else if (useSAPControlNo.toLowerCase()=='true')
												{
													if (paramName == 'os_username' || paramName == 'os_password' || paramName == 'wsdl_port')
													{
														Ext.getCmp(paramName).setDisabled(false);
														Ext.getCmp(paramName).show();
													}
													else
													{
														Ext.getCmp(paramName).setDisabled(true);
														Ext.getCmp(paramName).hide();
													}
												}
												else 
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
											}
										}

										if (testName == 'VMViewEventsTest' && (paramName == 'Connection_server_name' || 
											paramName == 'User_name' || paramName == 'Domain_name' ||
											paramName == 'databasePort' || paramName == 'instance' ||
											paramName == 'EventsDatabaseName' || paramName == 'EventsTableName' ||
											paramName == 'domain' || paramName == 'user' ||
											paramName == 'databaseType' ||
											paramName == 'databaseServer'))
										{
											var isAPIModeChkd = Ext.getCmp('Using_Horizon_API1').getValue();
											if (isAPIModeChkd)
											{
												if (paramName == 'Connection_server_name' || 
													paramName == 'User_name' || paramName == 'Domain_name')
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
												else
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
											}
											else
											{
												if (paramName == 'Connection_server_name' || 
													paramName == 'User_name' || paramName == 'Domain_name')
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
												else
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
										}


										if ((testName == 'WDispAvailTest' || 
											testName == 'WDispCacheTest' ||
											testName == 'WDispConnTest' || 
											testName == 'WDispServListTest' ||
											testName == 'WDispConfigTest' ||
											testName == 'WDispStatusTest' || 
											testName == 'WDispThreadTest') && (paramName == 'timeout(seconds)' || 
											paramName == 'profile_file' || paramName == 'web_dispatcher_dir' ||
											paramName == 'os_username' ||
											paramName == 'wsdl_port'))
										{
											var isSAPCtrlChkd = Ext.getCmp('data_collection_mode1').getValue();

											if (isSAPCtrlChkd)
											{
												if (paramName == 'timeout(seconds)' || 
													paramName == 'profile_file' ||
													paramName == 'web_dispatcher_dir')
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
												else
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
											else
											{
												if (paramName == 'os_username' || paramName == 'wsdl_port')
												{
													Ext.getCmp(paramName).hide();
													Ext.getCmp(paramName).setDisabled(true);
												}
												else
												{
													Ext.getCmp(paramName).show();
													Ext.getCmp(paramName).setDisabled(false);
												}
											}
										}

										if (paramName == 'console_user' && testName == 'EsxGPUStatsTest')
										{
											var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
											if (!Ext.isEmpty(vCenterObjVal) && vCenterObjVal.toLowerCase() == 'none')
											{
												var esxUser = Ext.getCmp('Esx_user').getValue();
												Ext.getCmp(paramName).setValue(esxUser);
												Ext.getCmp(paramName).hide();
											}
										}

										if ((componentType == "VmVdi_i_server" || componentType == "VmEsx_i_server" )
											&& (paramName == 'Esx_user' || paramName == 'webPort'))
										{
											var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
											if (!Ext.isEmpty(vCenterObjVal) && (vCenterObjVal.toLowerCase() != 'none' && vCenterObjVal.toLowerCase() != 'other'))
											{
												Ext.getCmp(paramName).setReadOnly(true);
											}
										}

										if (paramName == 'Maximum_Allowed_Grouped_Url_Per_Component')
										{
											Ext.getCmp(paramName).setDisabled(true);
											Ext.getCmp(paramName).hide();
										}

										if (paramName == 'max_grouped_urls')
										{
											Ext.getCmp(paramName).setDisabled(true);
											Ext.getCmp(paramName).hide();
										} 

										if (paramName == 'Monitoring_Level')
										{
											Ext.getCmp(paramName).setDisabled(true);
											Ext.getCmp(paramName).hide();
										}

										if (isAPMTest && (paramName == 'Slow_URL_Threshold' || paramName == 'Stalled_URL_Threshold'))
										{
											Ext.getCmp(paramName).setDisabled(true);
											Ext.getCmp(paramName).hide();
										}

										//if (paramName == 'max_grouped_urls' || paramName == 'max_slow_dd_count' || paramName == 'max_error_dd_count')
										//{
											//var monLevel = '';
											//if (!Ext.isEmpty(Ext.getCmp('Monitoring_Level')) && Ext.getCmp('Monitoring_Level') != undefined )
											//{
												//monLevel = Ext.getCmp('Monitoring_Level').getValue();
											//}
											//else if (!Ext.isEmpty(Ext.getCmp('monitoring_level')) && Ext.getCmp('monitoring_level') != undefined )
											//{
												//monLevel = Ext.getCmp('monitoring_level').getValue();
											//}
										
											//if (!Ext.isEmpty(monLevel) && monLevel != undefined && monLevel == '1' || monLevel == '2')
											//{
												//Ext.getCmp(paramName).setDisabled(true);
												//Ext.getCmp(paramName).hide();
											//}
											//else if (!Ext.isEmpty(monLevel) && monLevel != undefined && monLevel == '3')
											//{
												//if (paramName == 'max_grouped_urls')
												//{
													//Ext.getCmp(paramName).setDisabled(true);
													//Ext.getCmp(paramName).hide();
												//}
											//}
										//}
										if (paramName == 'Show_Exat_limit')
										{
											Ext.getCmp(paramName).setDisabled(true);
											Ext.getCmp(paramName).hide();
										}
										if (paramName == 'Requests_Per_Day')
										{
											var isTrailObj = Ext.getCmp('Is_Trail1');
											if (!Ext.isEmpty(isTrailObj))
											{
												var isTrailYes = isTrailObj.getValue();
												if (isTrailYes)
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
										if (paramName == 'Pojo_Method_Tracing_Limit' || 
											paramName == 'Pojo_Method_Tracing_Cutoff_Time' || 
											paramName == 'Recursive_Method_Tracing_Limit' || 
											paramName == 'Non-Pojo_Method_Tracing_Limit' || 
											paramName == 'Exception_Stacktrace_Lines' || 
											paramName == 'Included_Exceptions' || 
											paramName == 'Ignored_Exceptions' || 
											paramName == 'Ignored_Characters' || 
											paramName == 'Max_Grouped_Urls_Per_Measure_Period' || 
											paramName == 'Key_Max_Grouped_Urls_Per_Measure_Period' || 
											paramName == 'Max_Sql_Queries_Per_Transaction' || 
											paramName == 'Max_Mongodb_Query_Length' || 
											paramName == 'Exception_With_StackTrace_Capture_Limit' || 
											paramName == 'Exception_FQEN_Capture_Limit' || 
											paramName == 'Max_Sql_Error_Queries_Per_Transaction' || 
											paramName == 'Max_Exception_Trace_Limit' ||
											paramName == 'Mask_SQL' || 
											paramName == 'Mask_Public_IP' || 
											paramName == 'Mask_Private_IP' ||
											paramName == 'Mask_URL_Params')
										{
											var isTrailObj = Ext.getCmp('Advanced_Settings1');
											if (!Ext.isEmpty(isTrailObj))
											{
												var isTrailYes = isTrailObj.getValue();
												if (isTrailYes)
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
										if (testName.indexOf('JvmMemoryDetailsTest') > -1 && 
											paramName == 'Target_Process_User_Name')
										{
											var isUseSudoObj = Ext.getCmp('Use_Sudo1');
											if (!Ext.isEmpty(isUseSudoObj))
											{
												var isTrailYes = isUseSudoObj.getValue();
												if (isTrailYes)
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
										if (paramName == 'instance' || paramName == 'domain' || paramName == 'database' || paramName == 'clientlocale' || paramName == 'dblocale' || paramName == 'oracle_sid')
										{
											var dbTypeObj = Ext.getCmp('dbType');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (dbType == 'MsSql')
												{
													if (paramName == 'database' || paramName == 'clientlocale' || paramName == 'dblocale' || paramName == 'oracle_sid')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else if (dbType == 'Oracle')
												{
													if (paramName == 'instance' || paramName == 'domain' || paramName == 'database' || paramName == 'clientlocale' || paramName == 'dblocale')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else if (dbType == 'Sybase')
												{
													if (paramName == 'instance' || paramName == 'domain' || paramName == 'database' || paramName == 'clientlocale' || paramName == 'dblocale' || paramName == 'oracle_sid')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else if (dbType == 'DB2')
												{
													if (paramName == 'instance' || paramName == 'domain' || paramName == 'clientlocale' || paramName == 'dblocale'|| paramName == 'oracle_sid') 
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
												else if (dbType == 'Informix')
												{
													if (paramName == 'domain' || paramName == 'database' || paramName == 'oracle_sid')
													{
														Ext.getCmp(paramName).hide();
														Ext.getCmp(paramName).setDisabled(true);
													}
												}
											}
										}
										if (paramName == 'database_name')
										{
											var dbTypeObj = Ext.getCmp('database_type');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
										if (paramName == 'instance_name')
										{
											var dbTypeObj = Ext.getCmp('database_type');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
										if (paramName == 'oracle_sid')
										{
											var dbTypeObj = Ext.getCmp('database_type');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
												else
												{
													Ext.getCmp(paramName).show();
												}
											}
										}
										if (paramName == 'service_name')
										{
											var dbTypeObj = Ext.getCmp('database_type');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
											}
										}
										if (paramName == 'domain' && testName == 'EgDBCusReport')
										{
											var dbTypeObj = Ext.getCmp('database_type');
											if (!Ext.isEmpty(dbTypeObj))
											{
												var dbType = dbTypeObj.getValue();
												if (!Ext.isEmpty(dbType) && dbType == 'MsSql' )
												{
													Ext.getCmp(paramName).setDisabled(false);
													Ext.getCmp(paramName).show();
												}
												else
												{
													Ext.getCmp(paramName).setDisabled(true);
													Ext.getCmp(paramName).hide();
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}

			var allowDetailedDiagnosis = publicJson['allowDetailedDiagnosis'];
			if (allowDetailedDiagnosis)
			{
				var DDLabel = publicJson['DDLabel'];
				var isTestDetailedDiagnosisDisabledGlobally = publicJson['isTestDetailedDiagnosisDisabledGlobally'];
				if (isTestDetailedDiagnosisDisabledGlobally)
				{
					var isDisabledGlobalValue = publicJson['isDisabledGlobalValue'];

					var ddLabelComponent = {
						xtype: 'displayfield',
						id: 'detaileddiagnosisLabel',
						fieldLabel: DDLabel,
						name: 'detaileddiagnosisLabel',
						value: isDisabledGlobalValue
					};
					paramsFieldSetContainer.add(ddLabelComponent);
				}
				else
				{
					var enabled = publicJson['DDEnabled'];
					var disabled = publicJson['DDDisabled'];

					var ddRadioGroupComponent = {
						xtype: 'radiogroup',
						cls: 'radiobt',
						id: 'detaileddiagnosis_radioGrp',
						fieldLabel: DDLabel,
						vertical: false,
						columns: 2,
						items: [
							{ boxLabel: 'On', name: 'detaileddiagnosis', id: 'detaileddiagnosis1',  inputValue: 'On', checked: enabled },
							{ boxLabel: 'Off', name: 'detaileddiagnosis', id: 'detaileddiagnosis2',  inputValue: 'Off', checked: disabled }
						]
					};
					paramsFieldSetContainer.add(ddRadioGroupComponent);
				}
			}
			var isApplyAllComponents = publicJson['isApplyAllComponents'];
			if (isApplyAllComponents)
			{
				Ext.getCmp('applyToOtherBtn').setDisabled(false);
				Ext.getCmp('applyToOtherBtn').show();
			}
			//paramsFieldSetContainer.doLayout();

			var hiddenFieldsContainer = {
				xtype: 'container',
				id: 'hiddenFieldContainer',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items: []
			};
			var hiddenObj = publicJson['hiddenObj'];
			if (!Ext.isEmpty(hiddenObj))
			{
				var hiddenArray = new Array();
				Ext.getCmp('testConfigForm').add(hiddenFieldsContainer);
				for (key in hiddenObj)
				{
					var temp = {
						xtype: 'hiddenfield',
						name: key,
						id: key,
						value: hiddenObj[key],
					};
					hiddenArray.push(temp);
				}
				Ext.getCmp('hiddenFieldContainer').add(hiddenArray);
			}
			Ext.resumeLayouts(true);

			paramsFieldSetContainer.show();
			Ext.getCmp('bottomToolBar').show();
			Ext.getCmp('updateBtn').setDisabled(false);
			if (isValidateBtn)
			{
				Ext.getCmp('validateBtn').setDisabled(false);
				Ext.getCmp('validateBtn').show();
			}
			
			var isSNMPValidation = publicJson['isSNMPValidation'];
			if (isSNMPValidation)
			{
				Ext.getCmp('snmpUtil').setDisabled(false);
				Ext.getCmp('snmpUtil').show();
			}

			var isTrailObj = Ext.getCmp('Advanced_Settings1');
			if (!Ext.isEmpty(isTrailObj) && isTrailObj != undefined)
			{
				var isTrailYes = isTrailObj.getValue();
				if (isTrailYes)
				{
					var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
					maskSQLObj.setDisabled(false);
					maskSQLObj.show();

					var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");
					maskPublicIPObj.setDisabled(false);
					maskPublicIPObj.show();

					var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
					maskPrivateIPObj.setDisabled(false);
					maskPrivateIPObj.show();
					
					var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");
					maskUrlParamsObj.setDisabled(false);
					maskUrlParamsObj.show();
				}
				else
				{
					var maskSQLObj = Ext.getCmp("Mask_SQL_radioGrp");
					maskSQLObj.setDisabled(true);
					maskSQLObj.hide();

					var maskPublicIPObj = Ext.getCmp("Mask_Public_IP_radioGrp");
					maskPublicIPObj.setDisabled(true);
					maskPublicIPObj.hide();

					var maskPrivateIPObj = Ext.getCmp("Mask_Private_IP_radioGrp");
					maskPrivateIPObj.setDisabled(true);
					maskPrivateIPObj.hide();
					
					var maskUrlParamsObj = Ext.getCmp("Mask_URL_Params_radioGrp");
					maskUrlParamsObj.setDisabled(true);
					maskUrlParamsObj.hide();
					
					
				}
			}

			Ext.getCmp('testConfigForm').body.scrollTo('top',250);
		}
	},
	getRuleNamesFromIni: function (destroy) {
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		if (destroy) {
			var innerCardObj = Ext.getCmp('businesstransactionnaming');
			innerCardObj.destroy();
		}
		var compHost = Ext.getCmp('host').getValue();
		Ext.Ajax.request({
			url: "SpecificTestConfiguration/data/EGBTNamingJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&compHost="+compHost+"&data=",
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var serverResponse = Ext.decode(response.responseText);
					var ruleNames = '';
					for (var k in serverResponse['BTValues']) {
						ruleNames += serverResponse['BTValues'][k]['Rule_Name'] + ' , ';
					}
					ruleNames = ruleNames.substring(0, ruleNames.length - 2);
					Ext.getCmp('custom_bt_naming').setValue((ruleNames.length < 1) ? 'None' : ruleNames);
				}
			}
		});
	},
	getPopUpViewForTest: function (testName, paramName) 
	{
		if ( (testName == 'DiskSpaceTest' || testName == 'WVDDiskSpaceTest') && (paramName == 'automation_configuration_rules') )
		{
            testViews.configureDskSpcTstAtmtnRules();
		}		
	},
	getPopUpView: function (paramName) {

		if (isPasswordProfileEnabled(publicJson.pwdParamSetList,paramName))
		{
			//Ext.Msg.show({
				//title: pageName,
				//msg: 'Please de-select the password profile, then only enable this selection',
				//buttons: Ext.Msg.OK,
				//icon: 'iconInformation'
			//});
			//return;
			var disabledPwdParam = passwordParamDisabled(publicJson.pwdParamSetList,paramName);
			if (!Ext.isEmpty(disabledPwdParam))
			{
				//Ext.getCmp(disabledPwdParam.trim()).setValue('none');
				me.applyPwdProfile(Ext.getCmp(disabledPwdParam.trim()));
			}
		}


		if (paramName == 'user')
		{
			testViews.configMultiUsers();
		}
		else if (paramName == 'Connection_server_name')
		{
			testViews.configHorizonMultiUsers();
		}
		else if (paramName == 'Published_resources')
		{
			if (!Ext.isEmpty(testName) && testName.toLowerCase() == 'ctxxcxalogonsimtest')
			{
				testViews.configMultiSource();
			}
			else if (!Ext.isEmpty(testName) && testName.toLowerCase() == 'hrznlogonsimtest')
			{
				testViews.configMultiHLSFieldSet();
			}
		}
		else if (paramName == 'name')
		{
			testViews.configurlnamepattern();
		}
		else if (paramName == 'admin_user')
		{
			testViews.vmgusers();
		}
		else if (paramName == 'measure_oid')
		{
			testViews.EgOidsValue();
		}
	},
	createRadioButton: function(paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}

		var tempRadioComponent = {
			xtype: 'radiogroup',
			cls: 'radiobt',
			id: paramName+'_radioGrp',
			fieldLabel: tempParamName,
			vertical: false,
			columns: 2,
			items: [
				{ boxLabel: 'Yes', name: paramName, id: paramName+'1',  inputValue: 'true'},
				{ boxLabel: 'No', name: paramName, id: paramName+'2',  inputValue: 'false'}
			],
		};
		return tempRadioComponent;
	},
	createComboBox: function(paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var tempCombo = {
			xtype: 'scrollcombo',
			cls: 'dropdown',
			id: paramName,
			name: paramName,
			fieldLabel: tempParamName,
			value: '',
			queryMode: 'local',
			displayField: 'displayField',
			valueField: 'valueField',
			editable: false,
			parent:this,
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			})
		};
		return tempCombo;
	},
	createTextBox: function(paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var tempTextComponent = {
			xtype: 'textfield',
			cls: 'textbox',
			id: paramName,
			name: paramName,
			fieldLabel: tempParamName,
			value: ''
		};
		return tempTextComponent;
	},
	createFieldContainerTextBox: function(paramName) {
		var tempParamName = publicJson['paramNameObj'][paramName];
		if (!Ext.isEmpty(tempParamName) && tempParamName.lastIndexOf('#') > -1)
		{
			tempParamName = tempParamName.substring(0,tempParamName.length - 1);
		}
		var tempTextBox = {
			xtype: 'fieldcontainer',
			id: tempParamName,
			name: tempParamName,
			fieldLabel: tempParamName,
			layout: 'column',
			labelSeparator: ' ',
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					id: paramName,
					name: paramName,
					columnWidth: 1,
					value: ''
				}
			]
		};
		return tempTextBox;
	},
	configureUnconfiguredTest: function() {
		clickedFrom = 'configurebutton';
		enableCsClickedFrom = 'configurebutton';
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		var backBtnFrom = Ext.getCmp('backbutton').btnFrom;
		testType = testTypeVal;
		var unconfigTests = Ext.getCmp('unconfigTests').getValue();
		var isUnconfigTestSelected = false;
		var defTest = "";
		availPolicies = "";
		var unconfigTestsPicked = 0;
		Ext.getCmp('linkContainer').hide();
		Ext.getCmp('enableCsContainer').hide();
		Ext.getCmp('disableCsContainer').hide();

		if (!Ext.isEmpty(unconfigTests) && unconfigTests.length > 0)
		{
			for (var i = 0; i < unconfigTests.length; i++ )
			{
				var tmpTest = unconfigTests[i];
				if(!Ext.isEmpty(tmpTest) && tmpTest != null && tmpTest != 'undefined')
				{
					isUnconfigTestSelected = true;
					defTest = tmpTest;
					unconfigTestsPicked++;
				}
			}
		}
		if (!isUnconfigTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		if (unconfigTestsPicked != 1)
		{
			isUnconfigTestSelected = false;
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		var strTestName = defTest;
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}

		if (isUnconfigTestSelected && compTypeVal != "" && compNameVal != "")
		{
			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

			testName = strTestName;
			var prevTestName = '';
			var urlVal = 'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&testType='+testTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName+'&previousTestName='+prevTestName+'&clickedFrom=configurebutton&showUnconfigCompType='+showUnconfigCompType+'&reqfrom='+backBtnFrom;
			var homepage = Ext.getCmp('testConfigForm');
			var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			myMask.show();

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				scope:this,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						myMask.hide();
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						hide_process_service_button=publicJson['isContainerApp'];
						var exPageLabel = publicJson['externalPageLabel'];
						var isExternalTest = publicJson['isExternalTest'];
						var enableDisableCsLink = publicJson['enableDisableCsLink'];
						var isCompletedUserRole = publicJson['isCompletedUserRole'];
						var hasSpecificTestConfiguration = publicJson['hasSpecificTestConfiguration'];
						var isAgentBasedComponent = publicJson['isAgentBasedComponent'];
						var enableCsLabel = publicJson['enableCsLabel'];
						var disableCsLabel = publicJson['disableCsLabel'];
						var viewVmLabel = publicJson['viewVmLabel'];
						var applytestType = publicJson['selectedTestType'];
						if (!Ext.isEmpty(exPageLabel) && exPageLabel != undefined)
						{
							Ext.getCmp('linkContainer').show();
							Ext.getCmp('displayMsgLink').update(exPageLabel);
						}
						if (!isExternalTest && isAgentBasedComponent && isCompletedUserRole && enableDisableCsLink && hasSpecificTestConfiguration && (applytestType != 'ConfigurationTest'))
						{
							if (!Ext.isEmpty(enableCsLabel) && enableCsLabel != undefined)
							{
								Ext.getCmp('enableCsContainer').show();
								Ext.getCmp('displayMsgEnableCsLink').update(enableCsLabel);
							}

							if (!Ext.isEmpty(disableCsLabel) && disableCsLabel != undefined)
							{
								Ext.getCmp('disableCsContainer').show();
								Ext.getCmp('displayMsgDisableCsLink').update(disableCsLabel);
							}
						}

						//if (!Ext.isEmpty(viewVmLabel) && viewVmLabel != undefined)
						//{
							//Ext.getCmp('linkContainer').show();
							//Ext.getCmp('displayVmMsgLink').update(viewVmLabel);
						//}
						me.gotoBuildContainer();
					}
				}
			});
		}
	},
	unconfigTestToExclude: function() {
		//Ext.require( 'SpecificTestConfiguration.view.ExcludeComponents');
		clickedFrom = '';
		availPolicies = "";
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		testType = testTypeVal;
		var unconfigTests = Ext.getCmp('unconfigTests').getValue();
		var excludeTests = Ext.getCmp('excludeTests').getValue();
		var isUnconfigTestSelected = false;
		Ext.getCmp('linkContainer').hide();
		Ext.getCmp('enableCsContainer').hide();
		Ext.getCmp('disableCsContainer').hide();
		var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
		var showUnconfigCompType = 'false';
		if (isChecked)
		{
			showUnconfigCompType = 'true';
		}

		if (!Ext.isEmpty(unconfigTests) && unconfigTests.length > 0)
		{
			for (var i = 0; i < unconfigTests.length; i++ )
			{
				var tmpTest = unconfigTests[i];
				if(!Ext.isEmpty(tmpTest) && tmpTest != null && tmpTest != 'undefined')
				{
					isUnconfigTestSelected = true;
				}
			}
		}
		if (!isUnconfigTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		else
		{
			if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
			{
				Ext.getCmp('paramsContainer').removeAll();
				Ext.getCmp('paramsContainer').hide();
				Ext.getCmp('updateBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').hide();
				Ext.getCmp('validateBtn').setDisabled(true);
				Ext.getCmp('validateBtn').hide();
				Ext.getCmp('snmpUtil').setDisabled(true);
				Ext.getCmp('snmpUtil').hide();
				Ext.getCmp('bottomToolBar').hide();
			}

			var userTest = publicJson['usrBasedTests'];
			var userTestToken = new Array();
			if (!Ext.isEmpty(userTest))
			{
				userTestToken = userTest.split(",");
			}
			var namedUserTest = '';
			var webDispNameTest = '';
			var isNamedUser = false;
			var isRumParentTest = false;
			var unconfigTestsObj = Ext.getCmp('unconfigTests').getStore();
			var excludeTestsObj = Ext.getCmp('excludeTests').getStore();
			var namedUserValue = '';
			var newExcludeTestsValue = '';

			var igelLicenseBasedTests = publicJson['igelLicenseBasedTests'];
			var igelLicenseTestToken = new Array();
			if (!Ext.isEmpty(igelLicenseBasedTests))
			{
				igelLicenseTestToken = igelLicenseBasedTests.split(",");
			}
			var igelLicenseTest = '';
			var igelLicenseValue = '';
			var isIGELLicenseBasedTest = false;

			var existExcludedTests = publicJson['excludedTestList'];
			var specialCaseO365LicenseTestArr = publicJson['o365LicenseBasedStreamUserTests'];
			var o365StreamUserTestToken = new Array();
			if (!Ext.isEmpty(specialCaseO365LicenseTestArr))
			{
				o365StreamUserTestToken = specialCaseO365LicenseTestArr.split(",");
			}

			if (!Ext.isEmpty(existExcludedTests))
			{
				for (var e=0;e<existExcludedTests.length;e++)
				{
					var excTest = existExcludedTests[e];
					var whStrmsByUsrIdx = o365StreamUserTestToken.indexOf(excTest);
					if (whStrmsByUsrIdx != -1)
					{
						o365StreamUserTestToken.splice(whStrmsByUsrIdx, 1);
					}
				}
			}

			var o365LicenseBasedTests = publicJson['o365LicenseBasedTests'];
			var o365LicenseTestToken = new Array();
			if (!Ext.isEmpty(o365LicenseBasedTests))
			{
				o365LicenseTestToken = o365LicenseBasedTests.split(",");
			}
			var o365LicenseTest = '';
			var o365LicenseValue = '';
			var isO365LicenseBasedTest = false;

			var disableArr = new Ext.data.Store({
											fields : ['displayField','valueField'],
											data : []
										});

			if (o365StreamUserTestToken.length > 1)
			{
				var whStrmsByUsrIdx = o365LicenseTestToken.indexOf('MTMWHStrmsByUsrTest');
				if (whStrmsByUsrIdx != -1)
				{
					o365LicenseTestToken.splice(whStrmsByUsrIdx, 1);
				}
				var strmsByUsrIdx = o365LicenseTestToken.indexOf('MTMStrmsByUsrTest');
				if (strmsByUsrIdx != -1)
				{
					o365LicenseTestToken.splice(strmsByUsrIdx, 1);
				}
				var count = 0;
				for (var j=0;j<o365StreamUserTestToken.length ;j++)
				{
					for (var k=0;k<unconfigTests.length ;k++)
					{
						if (unconfigTests[k] == o365StreamUserTestToken[j])
						{
							count++;
							var displayIndex = unconfigTestsObj.find('valueField',o365StreamUserTestToken[j],0,false,true,true);
							var dispName = unconfigTestsObj.getAt(displayIndex).get('displayField');
							var dispValue = unconfigTestsObj.getAt(displayIndex).get('valueField');
							o365LicenseTest += ","+dispName;
							o365LicenseValue += ","+dispValue;
						}
					}
				}

				if (count == o365StreamUserTestToken.length)
				{
					isO365LicenseBasedTest = true;
				}
				if (!isO365LicenseBasedTest)
				{
					o365LicenseTest = "";
					o365LicenseValue = "";
				}
			}

			for (var j=0;j<o365LicenseTestToken.length ;j++)
			{
				for (var k=0;k<unconfigTests.length ;k++)
				{
					if (unconfigTests[k] == o365LicenseTestToken[j])
					{
						isO365LicenseBasedTest = true;
						var displayIndex = unconfigTestsObj.find('valueField',o365LicenseTestToken[j],0,false,true,true);

						var dispName = unconfigTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = unconfigTestsObj.getAt(displayIndex).get('valueField');

						o365LicenseTest += ","+dispName;
						o365LicenseValue += ","+dispValue;
					}
				}
			}

			for (var j=0;j<igelLicenseTestToken.length ;j++)
			{
				for (var k=0;k<unconfigTests.length ;k++)
				{
					if (unconfigTests[k] == igelLicenseTestToken[j])
					{
						isIGELLicenseBasedTest = true;
						var displayIndex = unconfigTestsObj.find('valueField',igelLicenseTestToken[j],0,false,true,true);

						var dispName = unconfigTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = unconfigTestsObj.getAt(displayIndex).get('valueField');

						igelLicenseTest += ","+dispName;
						igelLicenseValue += ","+dispValue;
					}
				}
			}

			for (var j=0;j<userTestToken.length ;j++)
			{
				for (var k=0;k<unconfigTests.length ;k++)
				{
					if (unconfigTests[k] == userTestToken[j])
					{
						isNamedUser = true;
						var displayIndex = unconfigTestsObj.find('valueField',userTestToken[j],0,false,true,true);

						var dispName = unconfigTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = unconfigTestsObj.getAt(displayIndex).get('valueField');

						namedUserTest += ","+dispName;
						namedUserValue += ","+dispValue;
					}
				}
			}

			if (isO365LicenseBasedTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg: publicJson['O365LicenseAlert']+' '+o365LicenseTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}

			if (!Ext.isEmpty(unconfigTests) && unconfigTests.length > 0)
			{
				for (var k=0;k<unconfigTests.length ;k++)
				{
					var displayIndex = unconfigTestsObj.find('valueField',unconfigTests[k],0,false,true,true);

					var dispName = unconfigTestsObj.getAt(displayIndex).get('displayField');
					var dispValue = unconfigTestsObj.getAt(displayIndex).get('valueField');

					if (!Ext.isEmpty(compTypeVal) && compTypeVal == 'Real_user_monitor')
					{
						if (!Ext.isEmpty(unconfigTests[k]) && unconfigTests[k] == 'RUMAppTest')
						{
							isRumParentTest = true;
							webDispName = dispName;
						}
						
						if (!Ext.isEmpty(unconfigTests[k]) && unconfigTests[k] != 'RUMAppTest')
						{
							newExcludeTestsValue += ","+dispValue;
							disableArr.add({
								'displayField': dispName,
								'valueField': dispValue
							});
						}
						else
						{
							continue;
						}
					}
					else if (namedUserValue.indexOf(dispValue) == -1 &&
						igelLicenseValue.indexOf(dispValue) == -1 && 
						o365LicenseValue.indexOf(dispValue) == -1)
					{
						newExcludeTestsValue += ","+dispValue;
						disableArr.add({
							'displayField': dispName,
							'valueField': dispValue
						});
					}
					else
					{
						continue;
					}
				}
			}
			if (!Ext.isEmpty(newExcludeTestsValue))
			{
				var newUnconfigTestsStore = new Ext.data.Store({
												fields : ['displayField','valueField'],
												data : []
											});
				for (var k=0;k<unconfigTestsObj.getCount() ;k++)
				{
					var dispName = unconfigTestsObj.getAt(k).get('displayField');
					var dispValue =  unconfigTestsObj.getAt(k).get('valueField');
					if (newExcludeTestsValue.indexOf(dispValue) == -1)
					{
						newUnconfigTestsStore.add({
							'displayField': dispName,
							'valueField': dispValue
						});
					}
					else
					{
						continue;
					}
				}

				unconfigTestsObj.removeAll();
				for ( var i = 0; i < newUnconfigTestsStore.getCount() ; i++ )
				{
					var getRecord = newUnconfigTestsStore.getAt(i);
					unconfigTestsObj.add(getRecord);
				}

				for (var i = 0; i < disableArr.getCount(); i++)
				{
					var getRecord = disableArr.getAt(i);
					excludeTestsObj.add(getRecord);
				}
			}

			if (isRumParentTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg: webDispName+' test cannot be excluded.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}
			
			if (isIGELLicenseBasedTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg: publicJson['IGELLicenseAlert']+' '+igelLicenseTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}

			if (isNamedUser)
			{
				Ext.Msg.show({
					title: pageName,
					msg: alertMsg3+' '+namedUserTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}

			newExcludeTestsValue = newExcludeTestsValue.substring(1);
			if(!Ext.isEmpty(newExcludeTestsValue))
			{
				var hasMoreComponents = publicJson['hasMoreComponents'];
				var excludeTestsArr = newExcludeTestsValue.split(',');
				var isExcludeOtherComponents = false;
				//var cnt = 0;
				//for (var i=0;i<excludeTestsArr.length ;i++ )
				//{
					//var tmpTest = excludeTestsArr[i];
					//if (!Ext.isEmpty(tmpTest) && tmpTest != undefined)
					//{
						//var isAlreadyExcludeTest = publicJson['excludeTestForAllCompObj'][tmpTest];
						//if (!Ext.isEmpty(isAlreadyExcludeTest) && isAlreadyExcludeTest != undefined && isAlreadyExcludeTest)
						//{
							//cnt++;
						//}
					//}
				//}
				//if (cnt == excludeTestsArr.length)
				//{
					//isExcludeOtherComponents = true;
				//}

				Ext.Ajax.request({
					url:"SpecificTestConfiguration/data/EgExcludeComponentsJson.jsp?componentType="+encodeURIComponent(compTypeVal)+"&componentName="+encodeURIComponent(compNameVal)+"&TestsForExclusion="+encodeURIComponent(newExcludeTestsValue)+"&testType="+encodeURIComponent(testTypeVal)+'&enableConfTestSize='+enableConfTestSize+'&excludingState=unconfiguredstate&showUnconfigCompType='+showUnconfigCompType,
					method:'POST',
					scope: this,
					timeout: 600000000,
					success: function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							var excludeJson = Ext.decode(jsonText);
							isExcludeOtherComponents = excludeJson.hasMoreThanOneCompToExcl;

							if (!hasMoreComponents || (!Ext.isEmpty(isExcludeOtherComponents) && !isExcludeOtherComponents))
							{
								var queryVal = "SpecificTestConfiguration/data/EgExcludeComponentTestsJson.jsp?componentType="+encodeURIComponent(compTypeVal)+"&componentName="+encodeURIComponent(compNameVal)+"&TestsForExclusion="+encodeURIComponent(newExcludeTestsValue)+"&testType="+encodeURIComponent(testTypeVal)+"&showUnconfigCompType="+showUnconfigCompType;
								var homepage = Ext.getCmp('testConfigForm');
								var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								myMask.show();

								Ext.Ajax.request({
									url:queryVal,
									method:'POST',
									scope: this,
									timeout: 6000000,
									success: function(response)
									{
										if(response.status == 200 && !Ext.isEmpty(response.responseText))
										{
											myMask.hide();
											var jsonText = response.responseText;
											publicJson = Ext.decode(jsonText);
											unconfigCompChecked = '';//publicJson['showUnconfigCompType'];
											var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

											if (!Ext.isEmpty(backBtnFrom))
											{
												reqFrom = backBtnFrom;
											}
											else
											{
												reqFrom = '';
											}
											me.afterMainRender();
										}
									},
									failure: function(response)
									{
										alert('failure : '+response.status);
									}
								});
							}
							else
							{
								excludeTestsURL = "SpecificTestConfiguration/data/EgExcludeComponentsJson.jsp?componentType="+encodeURIComponent(compTypeVal)+"&componentName="+encodeURIComponent(compNameVal)+"&TestsForExclusion="+encodeURIComponent(newExcludeTestsValue)+"&testType="+encodeURIComponent(testTypeVal)+'&enableConfTestSize='+enableConfTestSize+'&excludingState=unconfiguredstate&showUnconfigCompType='+showUnconfigCompType;

								var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

								var homepage = Ext.getCmp('specificTestConfigViewPort');
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'excludecomponents' });
								if (!Ext.isEmpty(backBtnFrom))
								{
									Ext.getCmp('excludeViewForm').isBackButton = backBtnFrom;
								}
								else
								{
									Ext.getCmp('excludeViewForm').isBackButton = '';
								}
								
								myMask.hide();
							}
						}
					}
				});
			}
		}
	},
	configureReconfiguredTest: function() {
		availPolicies = "";
		clickedFrom = 'reconfigurebutton';
		enableCsClickedFrom = 'reconfigurebutton';
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

		testType = testTypeVal;
		var configTests = Ext.getCmp('configTests').getValue();
		var isConfigTestSelected = false;
		var configTestsPicked = 0;
		var defTest = "";
		Ext.getCmp('linkContainer').hide();
		Ext.getCmp('enableCsContainer').hide();
		Ext.getCmp('disableCsContainer').hide();

		if (!Ext.isEmpty(configTests) && configTests.length > 0)
		{
			for (var i = 0; i < configTests.length; i++ )
			{
				var tmpTest = configTests[i];
				if(!Ext.isEmpty(tmpTest) && tmpTest != null && tmpTest != 'undefined')
				{
					isConfigTestSelected = true;
					defTest = tmpTest;
					configTestsPicked++;
				}
			}
		}

		if (!isConfigTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		if (configTestsPicked != 1)
		{
			isConfigTestSelected = false;
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg2,
				titleAlign:"left",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}

		var strTestName = defTest;
		if (isConfigTestSelected && compTypeVal != "" && compNameVal != "")
		{
			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

			testName = strTestName;
			var prevTestName = '';
			var urlVal = 'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&testType='+testTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName+'&previousTestName='+prevTestName+'&clickedFrom=reconfigurebutton&showUnconfigCompType='+showUnconfigCompType+'&reqfrom='+backBtnFrom;
			var homepage = Ext.getCmp('testConfigForm');
			var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			myMask.show();

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				//scope:this,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						myMask.hide();
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						hide_process_service_button=publicJson['isContainerApp'];
						var exPageLabel = publicJson['externalPageLabel'];
						var isExternalTest = publicJson['isExternalTest'];
						var enableDisableCsLink = publicJson['enableDisableCsLink'];
						var disableCsLink = publicJson['disableCsLink'];
						var isCompletedUserRole = publicJson['isCompletedUserRole'];
						var hasSpecificTestConfiguration = publicJson['hasSpecificTestConfiguration'];
						var isAgentBasedComponent = publicJson['isAgentBasedComponent'];
						var enableCsLabel = publicJson['enableCsLabel'];
						var disableCsLabel = publicJson['disableCsLabel'];
						var applytestType = publicJson['selectedTestType'];
						//Ext.getCmp('configTests').setValue(strTestName);
						if (!Ext.isEmpty(exPageLabel) && exPageLabel != undefined)
						{
							Ext.getCmp('linkContainer').show();
							Ext.getCmp('displayMsgLink').update(exPageLabel);
						}
						if (!isExternalTest && isAgentBasedComponent && enableDisableCsLink && isCompletedUserRole && hasSpecificTestConfiguration && (applytestType != 'ConfigurationTest'))
						{
							if (!Ext.isEmpty(enableCsLabel) && enableCsLabel != undefined)
							{
								Ext.getCmp('enableCsContainer').show();
								Ext.getCmp('displayMsgEnableCsLink').update(enableCsLabel);
							}

							if (!Ext.isEmpty(disableCsLabel) && disableCsLabel != undefined)
							{
								Ext.getCmp('disableCsContainer').show();
								Ext.getCmp('displayMsgDisableCsLink').update(disableCsLabel);
							}
						}
						me.gotoBuildContainer();
					}
				}
			});
		}
	},
	configTestToExclude: function() {
		availPolicies = "";
		clickedFrom = '';
		testName = '';
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		testType = testTypeVal;
		var configTests = Ext.getCmp('configTests').getValue();
		var excludeTests = Ext.getCmp('excludeTests').getValue();
		var isConfigTestSelected = false;
		var enableConfTestSize = publicJson['enableConfTestSize'];
		Ext.getCmp('linkContainer').hide();
		Ext.getCmp('enableCsContainer').hide();
		Ext.getCmp('disableCsContainer').hide();
		var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
		var showUnconfigCompType = 'false';
		if (isChecked)
		{
			showUnconfigCompType = 'true';
		}

		if (!Ext.isEmpty(configTests) && configTests.length > 0)
		{
			for (var i = 0; i < configTests.length; i++ )
			{
				var tmpTest = configTests[i];
				if(!Ext.isEmpty(tmpTest) && tmpTest != null && tmpTest != 'undefined')
				{
					isConfigTestSelected = true;
				}
			}
		}

		if (!isConfigTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		else
		{
			if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
			{
				//Ext.getCmp('dispFieldSet').removeAll();
				Ext.getCmp('paramsContainer').removeAll();
				Ext.getCmp('paramsContainer').hide();
				Ext.getCmp('updateBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').hide();
				Ext.getCmp('validateBtn').setDisabled(true);
				Ext.getCmp('validateBtn').hide();
				Ext.getCmp('snmpUtil').setDisabled(true);
				Ext.getCmp('snmpUtil').hide();
				Ext.getCmp('bottomToolBar').hide();
			}

			var userTest = publicJson['usrBasedTests'];
			var userTestToken = new Array();
			if (!Ext.isEmpty(userTest))
			{
				userTestToken = userTest.split(",");
			}
			var namedUserTest = '';
			var configTestsObj = Ext.getCmp('configTests').getStore();
			var excludeTestsObj = Ext.getCmp('excludeTests').getStore();
			var isNamedUser = false;
			var isRumParentTest = false;
			var webDispName = '';
			var namedUserValue = '';
			var newExcludeTestsValue = '';
			var disableArr = new Ext.data.Store({
										fields : ['displayField','valueField'],
										data : []
									});

			var existExcludedTests = publicJson['excludedTestList'];
			var specialCaseO365LicenseTestArr = publicJson['o365LicenseBasedStreamUserTests'];
			var o365StreamUserTestToken = new Array();
			if (!Ext.isEmpty(specialCaseO365LicenseTestArr))
			{
				o365StreamUserTestToken = specialCaseO365LicenseTestArr.split(",");
			}

			if (!Ext.isEmpty(existExcludedTests))
			{
				for (var e=0;e<existExcludedTests.length;e++)
				{
					var excTest = existExcludedTests[e];
					var whStrmsByUsrIdx = o365StreamUserTestToken.indexOf(excTest);
					if (whStrmsByUsrIdx != -1)
					{
						o365StreamUserTestToken.splice(whStrmsByUsrIdx, 1);
					}
				}
			}

			var o365LicenseBasedTests = publicJson['o365LicenseBasedTests'];
			var o365LicenseTestToken = new Array();
			if (!Ext.isEmpty(o365LicenseBasedTests))
			{
				o365LicenseTestToken = o365LicenseBasedTests.split(",");
			}

			var o365LicenseTest = '';
			var o365LicenseValue = '';
			var isO365LicenseBasedTest = false;

			if (o365StreamUserTestToken.length > 1)
			{
				var whStrmsByUsrIdx = o365LicenseTestToken.indexOf('MTMWHStrmsByUsrTest');
				if (whStrmsByUsrIdx != -1)
				{
					o365LicenseTestToken.splice(whStrmsByUsrIdx, 1);
				}
				var strmsByUsrIdx = o365LicenseTestToken.indexOf('MTMStrmsByUsrTest');
				if (strmsByUsrIdx != -1)
				{
					o365LicenseTestToken.splice(strmsByUsrIdx, 1);
				}
				var count = 0;
				for (var j=0;j<o365StreamUserTestToken.length ;j++)
				{
					for (var k=0;k<configTests.length ;k++)
					{
						if (configTests[k] == o365StreamUserTestToken[j])
						{
							count++;
							var displayIndex = configTestsObj.find('valueField',o365StreamUserTestToken[j],0,false,true,true);
							var dispName = configTestsObj.getAt(displayIndex).get('displayField');
							var dispValue = configTestsObj.getAt(displayIndex).get('valueField');
							o365LicenseTest += ","+dispName;
							o365LicenseValue += ","+dispValue;
						}
					}
				}

				if (count == o365StreamUserTestToken.length)
				{
					isO365LicenseBasedTest = true;
				}
				if (!isO365LicenseBasedTest)
				{
					o365LicenseTest = "";
					o365LicenseValue = "";
				}
			}

			for (var j=0;j<o365LicenseTestToken.length ;j++)
			{
				for (var k=0;k<configTests.length ;k++)
				{
					if (configTests[k] == o365LicenseTestToken[j])
					{
						isO365LicenseBasedTest = true;
						var displayIndex = configTestsObj.find('valueField',o365LicenseTestToken[j],0,false,true,true);

						var dispName = configTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = configTestsObj.getAt(displayIndex).get('valueField');

						o365LicenseTest += ","+dispName;
						o365LicenseValue += ","+dispValue;
					}
				}
			}

			if (isO365LicenseBasedTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg:  publicJson['O365LicenseAlert']+' '+o365LicenseTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
				return;
			}

			var igelLicenseBasedTests = publicJson['igelLicenseBasedTests'];
			var igelLicenseTestToken = new Array();
			if (!Ext.isEmpty(igelLicenseBasedTests))
			{
				igelLicenseTestToken = igelLicenseBasedTests.split(",");
			}

			var igelLicenseTest = '';
			var igelLicenseValue = '';
			var isIGELLicenseBasedTest = false;
			for (var j=0;j<igelLicenseTestToken.length ;j++)
			{
				for (var k=0;k<configTests.length ;k++)
				{
					if (configTests[k] == igelLicenseTestToken[j])
					{
						isIGELLicenseBasedTest = true;
						var displayIndex = configTestsObj.find('valueField',igelLicenseTestToken[j],0,false,true,true);

						var dispName = configTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = configTestsObj.getAt(displayIndex).get('valueField');

						igelLicenseTest += ","+dispName;
						igelLicenseValue += ","+dispValue;
					}
				}
			}

			for (var j=0;j<userTestToken.length ;j++)
			{
				for (var k=0;k<configTests.length ;k++)
				{
					if (configTests[k] == userTestToken[j])
					{
						isNamedUser = true;
						var displayIndex = configTestsObj.find('valueField',userTestToken[j],0,false,true,true);

						var dispName = configTestsObj.getAt(displayIndex).get('displayField');
						var dispValue = configTestsObj.getAt(displayIndex).get('valueField');

						namedUserTest += ","+dispName;
						namedUserValue += ","+dispValue;
					}
				}
			}

			for (var k=0;k<configTests.length ;k++)
			{
				var displayIndex = configTestsObj.find('valueField',configTests[k],0,false,true,true);

				var dispName = configTestsObj.getAt(displayIndex).get('displayField');
				var dispValue = configTestsObj.getAt(displayIndex).get('valueField');
				if (!Ext.isEmpty(compTypeVal) && compTypeVal == 'Real_user_monitor')
				{
					if (!Ext.isEmpty(configTests[k]) && configTests[k] == 'RUMAppTest')
					{
						isRumParentTest = true;
						webDispName = dispName;
					}
					
					if (!Ext.isEmpty(configTests[k]) && configTests[k] != 'RUMAppTest')
					{
						newExcludeTestsValue += ","+dispValue;
						disableArr.add({
							'displayField': dispName,
							'valueField': dispValue
						});
					}
					else
					{
						continue;
					}
				}
				else if (namedUserValue.indexOf(dispValue) == -1 && 
					igelLicenseValue.indexOf(dispValue) == -1 &&
					o365LicenseValue.indexOf(dispValue) == -1)
				{
					newExcludeTestsValue += ","+dispValue;
					disableArr.add({
						'displayField': dispName,
						'valueField': dispValue
					});
				}
			}

			if (!Ext.isEmpty(newExcludeTestsValue))
			{
				var newConfigTestsStore = new Ext.data.Store({
											fields : ['displayField','valueField','groupField'],
											data : []
										});
				for (var k=0;k<configTestsObj.getCount() ;k++)
				{
					var dispName = configTestsObj.getAt(k).get('displayField');
					var dispValue =  configTestsObj.getAt(k).get('valueField');
					var groupValue =  configTestsObj.getAt(k).get('groupField');
					if (newExcludeTestsValue.indexOf(dispValue) == -1)
					{
						newConfigTestsStore.add({
							'displayField': dispName,
							'valueField': dispValue,
							'groupField': groupValue
						});
					}
					else
					{
						continue;
					}
				}

				configTestsObj.removeAll();
				for ( var i = 0; i < newConfigTestsStore.getCount() ; i++ )
				{
					var getRecord = newConfigTestsStore.getAt(i);
					configTestsObj.add(getRecord);
				}

				for (var i = 0; i < disableArr.getCount(); i++)
				{
					var getRecord = disableArr.getAt(i);
					excludeTestsObj.add(getRecord);
				}
			}

			if (isRumParentTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg: webDispName+' test cannot be excluded.',
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}

			if (isIGELLicenseBasedTest)
			{
				Ext.Msg.show({
					title: pageName,
					msg:  publicJson['IGELLicenseAlert']+' '+igelLicenseTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}

			if (isNamedUser)
			{
				Ext.Msg.show({
					title: pageName,
					msg: alertMsg3+' '+namedUserTest.substring(1),
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
			}
			newExcludeTestsValue = newExcludeTestsValue.substring(1);
			if(!Ext.isEmpty(newExcludeTestsValue))
			{
				var hasMoreComponents = publicJson['hasMoreComponents'];
				var excludeTestsArr = newExcludeTestsValue.split(',');

				var isExcludeOtherComponents = false;
				Ext.Ajax.request({
					url:"SpecificTestConfiguration/data/EgExcludeComponentsJson.jsp?componentType="+encodeURIComponent(compTypeVal)+"&componentName="+encodeURIComponent(compNameVal)+"&TestsForExclusion="+encodeURIComponent(newExcludeTestsValue)+"&testType="+encodeURIComponent(testTypeVal)+'&enableConfTestSize='+enableConfTestSize+'&excludingState=unconfiguredstate&showUnconfigCompType='+showUnconfigCompType,
					method:'POST',
					scope: this,
					timeout: 600000000,
					success: function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							var excludeJson = Ext.decode(jsonText);
							isExcludeOtherComponents = excludeJson.hasMoreThanOneCompToExcl;
							//alert('isExcludeOtherComponents : '+isExcludeOtherComponents);

							if (!hasMoreComponents || (!Ext.isEmpty(isExcludeOtherComponents) && !isExcludeOtherComponents))
							{
								var queryVal = "SpecificTestConfiguration/data/EgExcludeComponentTestsJson.jsp?componentType="+encodeURIComponent(compTypeVal)+"&componentName="+encodeURIComponent(compNameVal)+"&TestsForExclusion="+encodeURIComponent(newExcludeTestsValue)+"&testType="+encodeURIComponent(testTypeVal)+"&showUnconfigCompType="+showUnconfigCompType;
								var homepage = Ext.getCmp('testConfigForm');
								var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								myMask.show();

								Ext.Ajax.request({
									url:queryVal,
									method:'POST',
									scope: this,
									timeout: 6000000,
									success: function(response)
									{
										if(response.status == 200 && !Ext.isEmpty(response.responseText))
										{
											myMask.hide();
											var jsonText = response.responseText;
											publicJson = Ext.decode(jsonText);
											var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

											if (!Ext.isEmpty(backBtnFrom))
											{
												reqFrom = backBtnFrom;
											}
											else
											{
												reqFrom = '';
											}
											me.afterMainRender();
										}
									},
									failure: function(response)
									{
										alert('failure : '+response.status);
									}
								});
							}
							else
							{
								excludeTestsURL = 'SpecificTestConfiguration/data/EgExcludeComponentsJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&TestsForExclusion='+encodeURIComponent(newExcludeTestsValue)+'&testType='+encodeURIComponent(testTypeVal)+'&enableConfTestSize='+enableConfTestSize+'&excludingState=configuredstate&showUnconfigCompType='+showUnconfigCompType;

								var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

								var homepage = Ext.getCmp('specificTestConfigViewPort');
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'excludecomponents' });
								if (!Ext.isEmpty(backBtnFrom))
								{
									Ext.getCmp('excludeViewForm').isBackButton = backBtnFrom;
								}
								else
								{
									Ext.getCmp('excludeViewForm').isBackButton = '';
								}

								myMask.hide();
							}
						}
					}
				});
			}
		}
	},
	includeToUnconfigTest: function() {
		availPolicies = "";
		clickedFrom = '';
		testName = '';
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		testType = testTypeVal;
		var unconfigTests = Ext.getCmp('unconfigTests').getValue();
		var excludeTests = Ext.getCmp('excludeTests').getValue();
		var excludeTestsObj = Ext.getCmp('excludeTests').getStore();
		var isExcludeTestSelected = false;
		var enableTestsStore = new Ext.data.Store({
									fields : ['displayField','valueField'],
									data : []
								});
		var newEnableTests = "";
		Ext.getCmp('linkContainer').hide();
		Ext.getCmp('enableCsContainer').hide();
		Ext.getCmp('disableCsContainer').hide();
		var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
		var showUnconfigCompType = 'false';
		if (isChecked)
		{
			showUnconfigCompType = 'true';
		}

		if (!Ext.isEmpty(excludeTests) && excludeTests.length > 0)
		{
			for (var i = 0; i < excludeTests.length; i++ )
			{
				var tmpTest = excludeTests[i];
				if(!Ext.isEmpty(tmpTest) && tmpTest != null && tmpTest != 'undefined')
				{
					isExcludeTestSelected = true;
					newEnableTests += ","+tmpTest;
				}
			}
		}
		if (!isExcludeTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		else
		{
			if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
			{
				//Ext.getCmp('dispFieldSet').removeAll();
				Ext.getCmp('paramsContainer').removeAll();
				Ext.getCmp('paramsContainer').hide();
				Ext.getCmp('updateBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').setDisabled(true);
				Ext.getCmp('applyToOtherBtn').hide();
				Ext.getCmp('validateBtn').setDisabled(true);
				Ext.getCmp('validateBtn').hide();
				Ext.getCmp('snmpUtil').setDisabled(true);
				Ext.getCmp('snmpUtil').hide();
				Ext.getCmp('bottomToolBar').hide();
			}

			newEnableTests = newEnableTests.substring(1);
			for (var k=0;k<excludeTestsObj.getCount() ;k++)
			{
				var dispName = excludeTestsObj.getAt(k).get('displayField');
				var dispValue = excludeTestsObj.getAt(k).get('valueField');
				if (newEnableTests.indexOf(dispValue) == -1)
				{
					enableTestsStore.add({
						'displayField': dispName,
						'valueField': dispValue
					});
				}
			}

			excludeTestsObj.removeAll();
			for ( var i = 0; i < enableTestsStore.getCount() ; i++ )
			{
				var getRecord = enableTestsStore.getAt(i);
				excludeTestsObj.add(getRecord);
			}

			if(newEnableTests!="")
			{
				var hasMoreComponents = publicJson['hasMoreComponents'];
				var includeTestsArr = newEnableTests.split(',');
				var isIncludeOtherComponents = false;
				//var cnt = 0;
				//for (var i=0;i<includeTestsArr.length ;i++ )
				//{
					//var tmpTest = includeTestsArr[i];
					//if (!Ext.isEmpty(tmpTest) && tmpTest != undefined)
					//{
						//var isAlreadyIncludeTest = publicJson['includeTestForAllCompObj'][tmpTest];
						//if (!Ext.isEmpty(isAlreadyIncludeTest) && isAlreadyIncludeTest != undefined && isAlreadyIncludeTest)
						//{
							//cnt++;
						//}
					//}
				//}
				//if (cnt == includeTestsArr.length)
				//{
					//isIncludeOtherComponents = true;
				//}

				Ext.Ajax.request({
					url:'SpecificTestConfiguration/data/EgIncludeComponentsJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&TestsForInclusion='+encodeURIComponent(newEnableTests)+'&testType='+encodeURIComponent(testTypeVal)+'&showUnconfigCompType='+showUnconfigCompType,
					method:'POST',
					scope: this,
					timeout: 600000000,
					success: function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							var includeJson = Ext.decode(jsonText);
							isIncludeOtherComponents = includeJson.hasMoreThanOneCompToIncl
							if (!hasMoreComponents || (!Ext.isEmpty(isIncludeOtherComponents) && !isIncludeOtherComponents))
							{
								var queryVal = 'SpecificTestConfiguration/data/EgIncludeComponentTestsJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&TestsForInclusion='+encodeURIComponent(newEnableTests)+'&testType='+encodeURIComponent(testTypeVal)+'&showUnconfigCompType='+showUnconfigCompType;
								var homepage = Ext.getCmp('testConfigForm');
								var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								myMask.show();

								Ext.Ajax.request({
									url:queryVal,
									method:'POST',
									scope: this,
									timeout: 6000000,
									success: function(response)
									{
										if(response.status == 200 && !Ext.isEmpty(response.responseText))
										{
											myMask.hide();
											var jsonText = response.responseText;
											publicJson = Ext.decode(jsonText);
											unconfigCompChecked = '';//publicJson['showUnconfigCompType'];

											var backBtnFrom = Ext.getCmp('backbutton').btnFrom;
											if (!Ext.isEmpty(backBtnFrom))
											{
												reqFrom = backBtnFrom;
											}
											else
											{
												reqFrom = '';
											}
											me.afterMainRender();
										}
									},
									failure: function(response)
									{
										alert('failure : '+response.status);
									}
								});
							}
							else
							{
								includeTestsURL =  'SpecificTestConfiguration/data/EgIncludeComponentsJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&TestsForInclusion='+encodeURIComponent(newEnableTests)+'&testType='+encodeURIComponent(testTypeVal)+'&showUnconfigCompType='+showUnconfigCompType;

								var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

								var homepage = Ext.getCmp('specificTestConfigViewPort');
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'includecomponents' });
								if (!Ext.isEmpty(backBtnFrom))
								{
									Ext.getCmp('includeViewForm').isBackButton = backBtnFrom;
								}
								else
								{
									Ext.getCmp('includeViewForm').isBackButton = '';
								}
								myMask.hide();
							}
						}
					}
				});
			}
		}
	},
	egxmsconfig: function(vchost){ // XMS IP starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').egxmsIPsconfig(vchost);
		Ext.getCmp('testConfigForm').body.scrollTo('top',250);
	},
	clearXMSIP: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearXMSIPs();
	},
	updateXMSIP: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateXMSIPs();
	},
	callXMSDestroy: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').callXMSIPsDestroy();
	},//XMS IP ends
	egvcconfig: function(vchost){ // vc starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').egvcsconfig(vchost);
		if (testName == 'EsxGPUStatsTest')
		{
			var vCenterObjVal = Ext.getCmp('virtual_center').getValue();
			if (!Ext.isEmpty(vCenterObjVal) && vCenterObjVal.toLowerCase() == 'none')
			{
				var esxUser = Ext.getCmp('Esx_user').getValue();
				var esxPwd = Ext.getCmp('Esx_password').getValue();
				Ext.getCmp('console_user').setValue(esxUser);
				Ext.getCmp('console_user').hide();

				Ext.getCmp('console_password').setValue(esxPwd);
				Ext.getCmp('console_password').hide();

				Ext.getCmp('console_passwordconfirmpassword').setValue(esxPwd);
				Ext.getCmp('console_passwordconfirmpassword').hide();
			}
			else 
			{
				var esxPwd = '$unconfigured';
				Ext.getCmp('console_user').setValue(esxPwd);
				Ext.getCmp('console_user').show();
				Ext.getCmp('console_password').setValue(esxPwd);
				Ext.getCmp('console_password').show();
				Ext.getCmp('console_passwordconfirmpassword').setValue(esxPwd);
				Ext.getCmp('console_passwordconfirmpassword').show();
			}
		}
		Ext.getCmp('testConfigForm').body.scrollTo('top',250);
	},
	combosslVc: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').combosslVcs();
	},
	clearVc: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearVcs();
	},
	updateVc: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateVcs();
	},
	callVcDestroy: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').callVcsDestroy();
	},//VC ends
	egnutconfig: function(vchost){ // nutanix starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').egnutconfiginter(vchost);
		Ext.getCmp('testConfigForm').body.scrollTo('top',250);
	},
	clearNut: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearNutInter();
	},
	updateNut: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateNutInter();
	},
	callNutDestroy: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').callNutInterDestroy();
	},//nutanix ends

	eghmcconfig: function(hmchost) { //Hmc
		this.getController('SpecificTestConfiguration.controller.IntermediateController').eghmcsconfig(hmchost);
	},
	clearHmc: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearHmcs();
	},
	updateHmc: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateHmcs();
	},
	callHmcDestroy: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').callHmcsDestroy();
	}, //Hmc ends

	egrhevconfig: function(rhevhost){ //Rhev starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').egrhevsconfig(rhevhost);
	},
	combosslrhev: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').combosslrhevs();
	},
	clearRhev: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearRhevs();
	},
	updateRhev: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateRhevs();
	},
	callRhevDestroy: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').callRhevsDestroy();
	}, //Rhev ends

	EgOidsValue: function() { //EgOidsValue starts 
		this.getController('SpecificTestConfiguration.controller.IntermediateController').EgOidsValue();
	},
	addOid: function() {
		addOids();
	},
	ClearOid: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').ClearOids();
	},
	UpdateOid:  function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').UpdateOids();
	},// ends OIDs 
	vmgusers: function() { //Vmg Users starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').vmgusers();
	},
	addVmgUsr: function() {
		addContact();
	},
	ClearConfigUsrs: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').ClearConfigUsr();
	},
	UpdateConfigUsrs:  function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').UpdateConfigUsr();
	}, //Vmg ends

	configMultiUsers: function(btn) { //MultipleUser Starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configMultiUser();
	},
	configHorizonMultiUsers: function(btn) { //MultipleUser Starts
		this.getController('SpecificTestConfiguration.controller.FunctionController').configHorizonMultiUsers();
	},
	addMultiUsr: function(btn) {
		addMultiUsrContact();
	},
	ClearMultiConfigUsrs: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').ClearMultiConfigUsr();
	},
	UpdateMultiConfigUsrs: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').UpdateMultiConfigUsr();
	}, //Multiple User ends

	configMultiSource: function(btn) { //Published resources starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').interConfigMultiSource();
	},
	addMultiSource: function(btn) {
		addMultiSourceContact();
	},
	ClearMultiConfigSource: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').interMultiSourceClr();
	},
	UpdateMultiConfigSource: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').interMultiSourceUpdate();
	}, //Published resources ends

	configCerdentialurl: function(btn){ // Credentials Url
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configCerdentialurls();
	},
		//Targets start
	configTgtsSysPropties: function(btn){ // host:port and System Properties
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configTgtsSysProps();
	},
	addTrgtUrls: function(btn){
		addTrgtUrlContact();
	},
	updateTrgtUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateTargetUrl();
	},
	clearTrgtUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearTargetUrl();
	},
	//Targets -end
	addCredUrls: function(btn) {
		addCredUrlContact();
	},
	clearCredUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearCredUrl();
	},
	updateCredUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateCredUrl();
	},// credentials ends

	configurlnamepattern: function(btn) { //url name
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configurlnamepatterns();
	},
	addUrlNames: function(btn) {
		addUrlNameContact();
	},
	clearUrlNames: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearUrlName();
	},
	updateUrlNames: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateUrlName();
	},//url name ends

	configWindowShared: function(btn) { //Window shared folders
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configWindowShareds();
	},
	addWinShared: function(btn) {
		addWinSharedContact();
	},
	clearWinShareds: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearWinShared();
	},
	updateWinShareds: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateWinShared();
	},//window shared ends

	configureWsdlUrl: function() {  //configure wsdl
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configureWsdlUrls();
	},
	addWsdlUrl: function(btn) {
		addWsdlUrlContact();
	},
	clearWsdlUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearWsdlUrl();
	},
	updateWsdlUrls: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateWsdlUrl();
	},//configure wsdl ends

	configEjb: function() {  //Config EJB starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configEjbss();
	},
	mainAddNewConfigEjbs: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').addNewConfigEjbs();
	},
	updateConfigEjbss: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateConfigEjbs();
	}, //Config EJB ends

	configInfos: function() { //Config Infos starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configInfoss();
	},
	updateConfigInfoss: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateConfigInfos();
	},
	addconfigureConfigInfos: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').addconfigInfoss();
	},
	applyAllCheckMainEvent: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').applyAllCheckEvent();
	},
	getShareFolders: function() {
		this.getController('SpecificTestConfiguration.controller.FunctionController').getShareFolders();
	},
	vmLogDisplay: function() { //VmLogDisplay starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configVMLogDisplay();
	},

	configVcTasks: function() { //VCTasks starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configureVcTasks();
	},
	configVcEvents: function() { //VCEvents starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configureVcEvents();
	},
	configAggregate: function() { //Aggregate starts
		var tName = publicJson['testName'];
		var cName = publicJson['componentName'];

		this.getController('SpecificTestConfiguration.controller.IntermediateController').configAggregatee(); 
		//Ext.getCmp('configdescriptions').update('<center>'+confDesc+' '+publicAggJSON['testt'] +' ('+publicAggJSON['aggregate_test']+') of '+publicAggJSON['compAggName']+'</center>');
	},
	updateAggregate: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateAggregatee();
	},
	configComposite: function() { //Composite starts
		var tName = publicJson['testName'];
		var cName = publicJson['componentName'];

		this.getController('SpecificTestConfiguration.controller.IntermediateController').configCompositee(); 
		//Ext.getCmp('configdescriptions').update('<center>'+confDesc+' '+publicAggJSON['composite_test_desc'] +' of '+publicAggJSON['dispComp']+'</center>');
	},
	updateComposite: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateCompositee();
	},

	processConfig: function() { //Process Config starts
		var formObj = Ext.getCmp('testConfigForm').getForm();
		var testName = publicJson['testName'];
		var multiUserMode = publicJson['multiUserMode'];
		var allowHostName = publicJson['isAllowHostName'];
		var processVal = Ext.getCmp('process').getValue();
		var showGrid = true;
		processVal = processVal == '$processName:$processPattern'?'$name:$pattern':processVal
		if(!Ext.isEmpty(processVal) && processVal !="$name:$pattern")
		{
			showGrid = populate(testName,'specificConfiguration',multiUserMode,allowHostName,formObj);
		}
		if(showGrid)
			this.getController('SpecificTestConfiguration.controller.IntermediateController').processConfigs();
	},
	addProcess: function() {
		//firstProcessClick = true;
		this.getController('SpecificTestConfiguration.controller.IntermediateController').addNewProcess();
	},
	processSearch: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').winProcessSearch();
	},
	processViewSearch: function(){
		this.getController('SpecificTestConfiguration.controller.IntermediateController').processesViewSearch();
	},
	clearProcessPattern: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearProcessPatterns();
	},
	getProcessPattern: function() {
		firstProcessClick = true;
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getProcessPatterns();
	},
	getDetailedPattern: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getDetailedPatterns();
	},
	getConcisePattern: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getConcisePatterns();
	},
	updateProcessPattern: function(response,fromBtn) {
		if(fromBtn == undefined || fromBtn != 'fromClose')
		{
			fromBtn = 'fromButton';
		}
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateProcessPatterns(response,fromBtn);
	},
	callProcessDestroy: function() {
		firstProcessClick = true;
		this.getController('SpecificTestConfiguration.controller.IntermediateController').processWindowClose();
	},//Process config ends

	btNamingConfig: function () { //Business Transaction Naming Config starts
		//this.getController('SpecificTestConfiguration.controller.Main').getRulesFromIni();
		//this.getController('SpecificTestConfiguration.controller.IntermediateController').btNamingConfigs();

		Ext.create('SpecificTestConfiguration.view.BusinessTransactionNaming').show();
		me.getRulesData();
	},
	btContextConfig: function () { //Username/Business Context Configuration Config starts
		Ext.create('SpecificTestConfiguration.view.BusinessTransactionContext').show();
		this.getContextRulesData("1","createPanel");
	},	
	btNamingContextConfigs: function() { 
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=BusinessTransactionContext',
			method: 'POST',
			async: false
		});
	},	
	cancelBTMUpdate: function()
	{
		var innerCardObj = Ext.getCmp('resultPanel');
		var gridPanelObj = Ext.create('SpecificTestConfiguration.view.BusinessTransactionRuleGrid');

		innerCardObj.removeAll();
		innerCardObj.add(gridPanelObj);
	},
	btNamingConfigs: function() { 
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/specifictesthelpJson.jsp?mode=businesstransactionnaming',
			method: 'POST',
			async: false
		});
	},
	getRulesFromIni: function () {
		//Ext.widget('businesstransactionnaming').show();
		Ext.create('SpecificTestConfiguration.view.BusinessTransactionNaming').show();
		me.getRulesData();
	},
	getRulesData: function () {
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		var compHost = Ext.getCmp('host').getValue();
		var url =  "SpecificTestConfiguration/data/EGBTNamingJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&compHost="+compHost+"&data="
		//console.log(url);
		Ext.Ajax.request({
			url:url,
			method: "POST",
			async: false,
			success: function (a) {
				if (a.status == 200 && !Ext.isEmpty(a.responseText)) {
					var b = a.responseText;
					publicJSON = Ext.decode(b);
					////console.log(publicJSON);


					for (var indx in publicJSON['BTValues']) {
						var urlPatternData = publicJSON['BTValues'][indx]['Matching_URL_Pattern'];
						var uriSpec = '';
						if (urlPatternData.startsWith("*") && urlPatternData.endsWith("*")) {
							uriSpec = 'CONTAINS'
						} else if (urlPatternData.startsWith("*")) {
							uriSpec = 'ENDS WITH'
						} else if (urlPatternData.endsWith("*")) {
							uriSpec = 'STARTS WITH'
						} else {
							uriSpec = 'EQUALS'
						}
						////console.log(urlPatternData);
						////console.log(urlPatternData.split('*').join(''));
						publicJSON['BTValues'][indx]['Matching_URL_Pattern'] = uriSpec + ' : ' + urlPatternData.split('*').join('');
						////console.log(publicJSON['BTValues'][indx]['Rule_Details'].split("~|~"));
						var splitRuleDetails = publicJSON['BTValues'][indx]['Rule_Details'].split('~|~');
						var newStr = '/';

						for (var index in splitRuleDetails) {
							////console.log(splitRuleDetails[index]);
							if (splitRuleDetails[index].startsWith('US')) {
								splitRuleDetails[index] = splitRuleDetails[index].replace('=', '');
								splitRuleDetails[index] = splitRuleDetails[index].replace('US', "URL_SEGMENT #");
							} else if (splitRuleDetails[index].startsWith('HP')) {
								var requestParamKey = splitRuleDetails[index].split('=')[1];
								var regex = splitRuleDetails[index].split('=')[0];
								var justRegex = regex.replace('HP_', '');
								////console.log(requestParamKey);
								splitRuleDetails[index] = "REQUEST_PARAM_VALUE_FOR : " + requestParamKey;
								if (justRegex != undefined && justRegex.length > 0) {
									splitRuleDetails[index] += ", WITH_REGEX : " + justRegex;
								}
							}
							newStr += splitRuleDetails[index] + "/"
						}
						////console.log(newStr);
						publicJSON['BTValues'][indx]['Rule_Details'] = newStr.substring(0, newStr.length - 1);
					}
					var innerCardObj = Ext.getCmp('resultPanel');

					var gridObj = Ext.create('SpecificTestConfiguration.view.BusinessTransactionRuleGrid');
					innerCardObj.removeAll();
					innerCardObj.add(gridObj);
					//Ext.getCmp('updateSpecificConfig').show();
					//Ext.getCmp('updateSpecificConfigContainer').show();
					Ext.getCmp("btRulesGrid").getStore().loadRawData(publicJSON["BTValues"]);
					if (Ext.isEmpty(publicJSON["BTValues"]))
					{
						Ext.getCmp('updateSpecificConfig').hide();
						Ext.getCmp('updateSpecificConfigContainer').hide();
					}
					else
					{
						Ext.getCmp('updateSpecificConfig').show();
						Ext.getCmp('updateSpecificConfigContainer').show();
					}
				}
			}
		});

		me.btNamingConfigs(); // for help UI process

	},
	
	getContextRulesData: function (paramFieldType,panelType) {
		
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		var compHost = Ext.getCmp('host').getValue();
		var url =  "SpecificTestConfiguration/data/EgBTContextJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&compHost="+compHost+"&fieldtype="+paramFieldType+"&data="
		Ext.Ajax.request({
			url:url,
			method: "POST",
			async: false,
			success: function (a) {
				if (a.status == 200 && !Ext.isEmpty(a.responseText)) {
					var b = a.responseText;
					publicJSON = Ext.decode(b);

					for (var indx in publicJSON['BTValues']) {
						var urlPatternData = publicJSON['BTValues'][indx]['Matching_URL_Pattern'];

						var fetchType = publicJSON['BTValues'][indx]['Fetch_Type'];
						publicJSON['BTValues'][indx]['Matching_URL_Pattern'] = urlPatternData;
						var splitRuleDetails = publicJSON['BTValues'][indx]['Rule_Details'].split('~|~');
						var newStr = '';
						var newStr1 = '';

						if(fetchType=="Method Argument or parameter"){
							newStr += "Class Name : "+ splitRuleDetails[1]
							newStr += "<br>Method Name : "+ splitRuleDetails[2]
						}else if(fetchType=="Static Method"){
							newStr += "Class Name : "+ splitRuleDetails[1]
							newStr += "<br>Method Name : "+ splitRuleDetails[2]
						}else if(fetchType=="Session Attribute"){
							newStr += "Attribute : "+ splitRuleDetails[8]
						}else if(fetchType=="Request Parameter Name"){
							newStr += "Param : "+ splitRuleDetails[8]
						}
						for (var index in splitRuleDetails) {
								if(splitRuleDetails[index]!=null && splitRuleDetails[index]!="" && splitRuleDetails[index]!="null"){
									if(index!=0)
									newStr1 += splitRuleDetails[index] + "/";
								}
							}
						publicJSON['BTValues'][indx]['Rule_Details'] = newStr;
						publicJSON['BTValues'][indx]['Rule_Details1'] = newStr1;
					}
					if(panelType!=null && panelType=="createPanel"){
						var innerCardObj = Ext.getCmp('resultPanel');
						var gridObj = Ext.create('SpecificTestConfiguration.view.BusinessTransactionContextRuleGrid');
						innerCardObj.removeAll();
						innerCardObj.add(gridObj);
						Ext.getCmp("btContextRulesGrid").getStore().removeAll();
					}else{
						Ext.getCmp("btContextRulesGrid").getStore().removeAll();
					}
					Ext.getCmp("btContextRulesGrid").getStore().loadRawData(publicJSON["BTValues"]);
					if (Ext.isEmpty(publicJSON["BTValues"]))
					{
						Ext.getCmp('updateSpecificConfig').hide();
						Ext.getCmp('updateSpecificConfigContainer').hide();
					}
					else
					{
						Ext.getCmp('updateSpecificConfig').show();
						Ext.getCmp('updateSpecificConfigContainer').show();
					}
				}
			}
		});
	},	

	resultPanelCreateRuleForm: function () 
	{
		////console.log("Inside add New RuleDetails");

		var innerCardObj = Ext.getCmp('resultPanel');
		var rulepanelObj = Ext.create('SpecificTestConfiguration.view.BusinessTransactionRule');

		innerCardObj.removeAll();
		innerCardObj.add(rulepanelObj);
		Ext.getCmp('createRule').setText('Create Rule');
		//Ext.getCmp('updateSpecificConfig').hide();
		//Ext.getCmp('updateSpecificConfigContainer').hide();
	},
	resultPanelCreateContextRuleForm: function () 
	{
		var fieldType="";
		if (Ext.getCmp("btContextRulesGrid").getStore().getCount()>0){
			fieldType = Ext.getCmp("btContextRulesGrid").getStore().getAt(0).data['Field_Type'];
		}
		var innerCardObj = Ext.getCmp('resultPanel');
		var rulepanelObj = Ext.create('SpecificTestConfiguration.view.BusinessTransactionContextRule');

		innerCardObj.removeAll();
		innerCardObj.add(rulepanelObj);
		Ext.getCmp('createContextRule').setText('Create Rule');
		Ext.getCmp('sessionAttRequestParms').hide();
		Ext.getCmp('passRequestObj').hide();
		Ext.getCmp('exeStartTrans').hide();
		Ext.getCmp('fetchOnce').hide();
		
		if(fieldType.indexOf("Business Context")!=-1){
			Ext.getCmp('businesstransactionContextRuleTab').allowAction=true;
			Ext.getCmp('businesstransactionContextRuleTab').setActiveTab(1);
		} 
	},
	saveOrUpdateRule: function ()
	{
		if (Ext.getCmp('createRule').getText() == 'Create Rule') {
			me.createRule();
		} else {
			me.updateRule();
		}
	},
	verifyCreateOrUpdateRule: function(name, urlPattern, idArray)
	{
		if (Ext.isEmpty(name)) {
			me.displayAlert('name',_checkempty);
			return false;
		}
		if (Ext.isEmpty(urlPattern)) {
			me.displayAlert('nameURL1',_checkempty);
			return false;
		}
		for (var curId in idArray) {
			var uriSegmentType = Ext.getCmp('urlsegment_1_' + idArray[curId]).getValue();
			var uptosegmentNo = Ext.getCmp('urlsegmentNo_1_' + idArray[curId]).getValue();
			var segmentNo = Ext.getCmp('urlspecificsegmentNo_1_' + idArray[curId]).getValue();
			var segmentKey = Ext.getCmp('urlParam_1_' + idArray[curId]).getValue();
			if (uriSegmentType == 'param' ) {
				if( Ext.isEmpty(segmentKey)){
					me.displayAlert('urlParam_1_' + idArray[curId],_checkempty);
					return false;
				}
			} else if ((uriSegmentType == '1stFew' || uriSegmentType == 'specific')) {
				if(uptosegmentNo < 1){
					me.displayAlert('urlsegmentNo_1_' + idArray[curId], onlypositive);
					return false;
				}else if (segmentNo < 1){
					me.displayAlert('urlspecificsegmentNo_1_' + idArray[curId], onlypositive);
					return false;
				}else if(isNaN(uptosegmentNo)){
					me.displayAlert('urlsegmentNo_1_' + idArray[curId], onlyNumber);
					return false;
				}else if(isNaN(segmentNo)){
					me.displayAlert('urlspecificsegmentNo_1_' + idArray[curId], onlyNumber);
					return false;
				}				
			}			
		}
		return true;
	},
	createRule: function (grid, rowIndex, colIndex) {
		////console.log("Inside CreateRule ");
		var compList = Ext.ComponentQuery.query('#urlPropsfieldset1  fieldcontainer');
		var name = Ext.getCmp('name').getValue();
		var urlPattern = Ext.getCmp('nameURL1').getValue();

		////console.log(uptosegmentNo);
		var idArray = [];
		for (var i in compList) {
			var currentId = compList[i].id.split('_1_')[1];
			if (!idArray.includes(currentId)) {
				idArray.push(currentId);
			}
			////console.log(idArray);
		}
		var compHost = Ext.getCmp('host').getValue();
		if(!me.verifyCreateOrUpdateRule(name, urlPattern, idArray)) return false;
		
		var cpcData = me.prepareCpcData(idArray);
		if (cpcData != "") {
			Ext.Ajax.request({
				url: "SpecificTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=create&compHost="+compHost+"&data=" + encodeURIComponent(cpcData),
				method: 'POST',
				async: false,
				success: function (response) {
					if (Ext.decode(response.responseText)['ruleCreated']) {
						var innerCardObj = Ext.getCmp('resultPanel');
						////console.log(Ext.decode(response.responseText)['ruleCreated']);
						me.getRulesData();
						//Ext.getCmp('updateSpecificConfig').show();
						//Ext.getCmp('updateSpecificConfigContainer').show();
					}
					else{
						// TODO: When Guid Doesn't exist ? 
//						var msg = ("Rule_Name","Component Unique Key Not Available, Contact Support")
						//Ext.Msg.show({
							//title: businessTransNamingTitle,
//							msg: msg,
							//buttons: Ext.MessageBox.OK,
//							icon: 'iconExclamation',
						//});
//						me.getRulesData();
					}
				}
			});
		} else {
			//console.log("No data");
		}

	},
	displayAlert: function (Id, msg) {
		Ext.Msg.show({
			title: businessTransNamingTitle,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation',
			fn: function () {
				Ext.getCmp(Id).focus(true,true)
			}
		});
	},
	getContextRuleNamesFromIni: function (destroy) {
		var selectedTestName = publicJson['testName'];
		var selectedCompType = publicJson['selectedCompType'];
		var selectedCompName = publicJson['selectedCompName'];
		if (destroy) {
			var innerCardObj = Ext.getCmp('BusinessTransactionContext');
			innerCardObj.destroy();
		}
		var compHost = Ext.getCmp('host').getValue();
		Ext.Ajax.request({
			url: "SpecificTestConfiguration/data/EgBTContextJson.jsp?compName=" + selectedCompName + "&compType=" + selectedCompType + "&testName=" + selectedTestName + "&crud=read&compHost="+compHost+"&fieldtype=all&data=",
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var serverResponse = Ext.decode(response.responseText);
					var ruleNames = '';
					for (var k in serverResponse['BTValues']) {
						ruleNames += serverResponse['BTValues'][k]['Rule_Name'] + ' , ';
					}
					ruleNames = ruleNames.substring(0, ruleNames.length - 2);
					Ext.getCmp('context_bt_configuration').setValue((ruleNames.length < 1) ? 'None' : ruleNames);
				}
			}
		});
	},
	saveOrUpdateContextRule: function ()
	{
		if (Ext.getCmp('createContextRule').getText() == 'Create Rule') {
			me.createContextRule();
		} else {
			me.updateContextRule();
		}
	},
	createContextRule: function (grid, rowIndex, colIndex) {

		if(!me.verifyCreateOrUpdateContextRule(rowIndex)) return false;
		
		var compHost = Ext.getCmp('host').getValue();
		var params = me.prepareUserBusinessContextData();
		if (params != "") {
			Ext.Ajax.request({
				url: "SpecificTestConfiguration/data/EgBTContextJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=create&compHost="+compHost+params,
				method: 'POST',
				async: false,
				success: function (response) {
					if (Ext.decode(response.responseText)['ruleCreated']) {
						var innerCardObj = Ext.getCmp('resultPanel');
						var tabValue = me.getFieldType();
						me.getContextRulesData(tabValue,"createPanel");
						Ext.getCmp('businessTransactionContextRuleGridTab').setActiveTab(tabValue-1);
					}
				}
			});
		} 
	},
	updateContextRule: function (grid, rowIndex, colIndex) {

		if(!me.verifyCreateOrUpdateContextRule(rowIndex)) return false;

		var compHost = Ext.getCmp('host').getValue();
		var variable = Ext.getCmp('icVariable').getValue();
		var params = me.prepareUserBusinessContextData();
		if (params != "") {
			Ext.Ajax.request({
				url: "SpecificTestConfiguration/data/EgBTContextJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=update&compHost="+compHost+"&variable="+encodeURIComponent(variable)+"&data=" + params,
				method: 'POST',
				async: false,
				success: function (response) {
					if (Ext.decode(response.responseText)['ruleUpdated']) {
						var innerCardObj = Ext.getCmp('resultPanel');
						var tabVal = me.getFieldType();
						me.getContextRulesData(me.getFieldType(),"createPanel");
						Ext.getCmp('businessTransactionContextRuleGridTab').setActiveTab(tabVal-1);
					}
					else{

					}
				}
			});
		} 
	},
	handleDeleteIconClickContextRuleGrid: function (grid, rowIndex, colIndex) {
		Ext.Msg.show({
			title: businessTransContextTitle,
			msg: confirmDeleteRule,
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function (buttonText) {
				if (buttonText == "yes") {
					var compHost = Ext.getCmp('host').getValue();
					var resultUrl = "SpecificTestConfiguration/data/EgBTContextJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=delete&compHost="+compHost+"&variable=" + encodeURIComponent(Ext.getCmp('btContextRulesGrid').getStore().getAt(rowIndex).data['variable']);
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async: false,
						success: function (response) {
							me.getContextRulesData(me.getFieldTypeInGrid(),"reusePanel")
						}
					});
				}
			}
		});
	},	
	prepareUserBusinessContextData: function(){
		var entryDesc = me.checkNullValue(Ext.getCmp('entryDesc').getValue());
		var fetchType = Ext.getCmp('fetchType').getValue();
		var fullyQalifiedClassName = me.checkNullValue(Ext.getCmp('fullyQalifiedClassName').getValue());
		var methodName = me.checkNullValue(Ext.getCmp('methodName').getValue());
		var methodSignature = me.checkNullValue(Ext.getCmp('methodSignature').getValue());
		var methodArgsIndex = me.checkNullValue(Ext.getCmp('methodArgsIndex').getValue());
		
		var fetchOnce = Ext.getCmp('fetchOnce').getValue().fetchOnceRadio;
		var passRequestObj = Ext.getCmp('passRequestObj').getValue().passRequestObjRadio;
		var exeStartTrans = Ext.getCmp('exeStartTrans').getValue().exeStartTransRadio;
		
		if(fetchType==1 || fetchType==4)
		{
			passRequestObj = "false";
			exeStartTrans = "false";
		}else if(fetchType==3)
		{
			passRequestObj = "false";
		}
		
		var sessionAttRequestParms = me.checkNullValue(Ext.getCmp('sessionAttRequestParms').getValue());
		var matchUrlPattern = me.checkNullValue(Ext.getCmp('matchUrlPattern').getValue());
		var selectedTab = Ext.getCmp('businesstransactionContextRuleFields').ownerCt.initialConfig.itemId;
		var fieldType=me.getFieldType();
		
		var params="";
		params = appendParams(params, "fieldType", fieldType);
		params = appendParams(params, "entryDesc", entryDesc);
		params = appendParams(params, "fetchType", fetchType);
		params = appendParams(params, "fullyQalifiedClassName", fullyQalifiedClassName);
		params = appendParams(params, "methodName", methodName);
		params = appendParams(params, "methodSignature", methodSignature);
		params = appendParams(params, "methodArgsIndex", methodArgsIndex);
		params = appendParams(params, "fetchOnce", fetchOnce);
		params = appendParams(params, "passRequestObj", passRequestObj);
		params = appendParams(params, "exeStartTrans", exeStartTrans);
		params = appendParams(params, "sessionAttRequestParms", sessionAttRequestParms);
		params = appendParams(params, "matchUrlPattern", matchUrlPattern);
		console.info("params: ",params);
		return params;
	},
	verifyCreateOrUpdateContextRule: function(rowIndex)
	{
		var entryDesc = Ext.getCmp('entryDesc').getValue();
		var fetchType = Ext.getCmp('fetchType').getValue();
		var fullyQalifiedClassName = Ext.getCmp('fullyQalifiedClassName').getValue();
		var methodName = Ext.getCmp('methodName').getValue();
		var methodSignature = Ext.getCmp('methodSignature').getValue();
		var methodArgsIndex = Ext.getCmp('methodArgsIndex').getValue();
		var sessionAttRequestParms = Ext.getCmp('sessionAttRequestParms').getValue();
		var matchUrlPattern = Ext.getCmp('matchUrlPattern').getValue();

		if (Ext.isEmpty(entryDesc)) {
			me.displayContextAlert('entryDesc',_checkempty);
			return false;
		}
		if (Ext.isEmpty(matchUrlPattern)) {
			me.displayContextAlert('matchUrlPattern',_checkempty);
			return false;
		}
		if (Ext.isEmpty(fetchType)) {
			me.displayContextAlert('fetchType',_checkempty);
			return false;
		}
		if(fetchType==1)
		{
			if (Ext.isEmpty(fullyQalifiedClassName)) {
				me.displayContextAlert('fullyQalifiedClassName',_checkempty);
				return false;
			}
			if (Ext.isEmpty(methodName)) {
				me.displayContextAlert('methodName',_checkempty);
				return false;
			}
			if (Ext.isEmpty(methodSignature)) {
				me.displayContextAlert('methodSignature',_checkempty);
				return false;
			}
			if (Ext.isEmpty(methodArgsIndex)) {
				me.displayContextAlert('methodArgsIndex',_checkempty);
				return false;
			}
		}else if(fetchType==2)
		{
			if (Ext.isEmpty(fullyQalifiedClassName)) {
				me.displayContextAlert('fullyQalifiedClassName',_checkempty);
				return false;
			}
			if (Ext.isEmpty(methodName)) {
				me.displayContextAlert('methodName',_checkempty);
				return false;
			}
		}else if(fetchType == 3 || fetchType == 4){
			if (Ext.isEmpty(sessionAttRequestParms)) {
				me.displayContextAlert('sessionAttRequestParms',_checkempty);
				return false;
			}
		}
		return true;
	},
	tabSwitchCheckFiledsContextRule: function()
	{
		var entryDesc = Ext.getCmp('entryDesc').getValue();
		var fetchType = Ext.getCmp('fetchType').getValue();
		var fullyQalifiedClassName = Ext.getCmp('fullyQalifiedClassName').getValue();
		var methodName = Ext.getCmp('methodName').getValue();
		var methodSignature = Ext.getCmp('methodSignature').getValue();
		var methodArgsIndex = Ext.getCmp('methodArgsIndex').getValue();
		var sessionAttRequestParms = Ext.getCmp('sessionAttRequestParms').getValue();
		var matchUrlPattern = Ext.getCmp('matchUrlPattern').getValue();

		if (!Ext.isEmpty(entryDesc)) {
			return false;
		}
		if (!Ext.isEmpty(matchUrlPattern)) {
			return false;
		}
		if(fetchType==1)
		{
			if (!Ext.isEmpty(fullyQalifiedClassName)) {
				return false;
			}
			if (!Ext.isEmpty(methodName)) {
				return false;
			}
			if (!Ext.isEmpty(methodSignature)) {
				return false;
			}
			if (!Ext.isEmpty(methodArgsIndex)) {
				return false;
			}
		}else if(fetchType==2)
		{
			if (!Ext.isEmpty(fullyQalifiedClassName)) {
				return false;
			}
			if (!Ext.isEmpty(methodName)) {
				return false;
			}
		}else if(fetchType == 3 || fetchType == 4){
			if (!Ext.isEmpty(sessionAttRequestParms)) {
				return false;
			}
		}
		return true;
	},
	getFieldType: function(){
		var selectedTab = Ext.getCmp('businesstransactionContextRuleFields').ownerCt.initialConfig.itemId;
		var tabValue=0;
		if(selectedTab.indexOf("tab1")!=-1){
			tabValue = 1;
		}else{
			tabValue = 2;
		}
		return tabValue;
	},	getFieldTypeInGrid: function(){
		var tabValue=1;
		var fieldType = Ext.getCmp("btContextRulesGrid").getStore().getAt(0).data['Field_Type'];
		if(fieldType.indexOf("Business Context")!=-1){
			tabValue = 2;
		}
		return tabValue;
	}
	,
	checkNullValue: function(inputValue){
		var resultValue=null;
		try{
			if(inputValue.length > 0){
				resultValue = inputValue;
			}
		}catch(err){}
		return resultValue;
	},
	displayContextAlert: function (Id, msg) {
		Ext.Msg.show({
			title: businessTransContextTitle,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: 'iconExclamation',
			fn: function () {
				Ext.getCmp(Id).focus(true,true)
			}
		});
	},showHideUserNameBusinessContextFields: function(){
		
			var fetchType = Ext.getCmp('fetchType').getValue();
			if(fetchType==1)
			{
				Ext.getCmp('fullyQalifiedClassName').show();
				Ext.getCmp('methodName').show();
				Ext.getCmp('methodSignature').show();
				Ext.getCmp('methodArgsIndex').show();
				Ext.getCmp('fetchOnce').hide();
				Ext.getCmp('sessionAttRequestParms').hide();
				Ext.getCmp('passRequestObj').hide();
				Ext.getCmp('exeStartTrans').hide();
			}else if(fetchType==2)
			{
				Ext.getCmp('fullyQalifiedClassName').show();
				Ext.getCmp('methodName').show();
				Ext.getCmp('fetchOnce').hide();
				Ext.getCmp('passRequestObj').show();
				Ext.getCmp('exeStartTrans').show();
				Ext.getCmp('methodSignature').hide();
				Ext.getCmp('methodArgsIndex').hide();
				Ext.getCmp('sessionAttRequestParms').hide();
			}else if(fetchType==3)
			{
				Ext.getCmp('fullyQalifiedClassName').hide();
				Ext.getCmp('methodName').hide();
				Ext.getCmp('methodSignature').hide();
				Ext.getCmp('methodArgsIndex').hide();
				Ext.getCmp('passRequestObj').hide();
				Ext.getCmp('fetchOnce').hide();
				Ext.getCmp('exeStartTrans').show();
				Ext.getCmp('sessionAttRequestParms').show();
			}else if(fetchType==4)
			{
				Ext.getCmp('fullyQalifiedClassName').hide();
				Ext.getCmp('methodName').hide();
				Ext.getCmp('methodSignature').hide();
				Ext.getCmp('methodArgsIndex').hide();
				Ext.getCmp('passRequestObj').hide();
				Ext.getCmp('exeStartTrans').hide();
				Ext.getCmp('sessionAttRequestParms').show();
				Ext.getCmp('fetchOnce').hide();
			}
			
			resetShowHide();
	},
	prepareCpcData: function (idArray) {

		////console.log('prepareCpcData block ');
		var urlPropsfieldset = Ext.getCmp('urlPropsfieldset1');
		////console.log(urlPropsfieldset);
		var urlPropsfieldsetLength = urlPropsfieldset.items.getCount();
		var finalPatternData = '';

		if (!Ext.isEmpty(urlPropsfieldset) && urlPropsfieldset != undefined) {
			var url = Ext.getCmp('nameURL1').getValue();
			var desc = Ext.getCmp('name').getValue();
			////console.log(' ------- url ' + url);
			////console.log(' ------- desc' + desc);

			if (Ext.getCmp('uri_1').value == 'SW') {
				url = url + "*";
			} else if (Ext.getCmp('uri_1').value == 'EW') {
				url = "*" + url;
			} else if (Ext.getCmp('uri_1').value == 'CON') {
				url = "*" + url + "*";
			} else if (Ext.getCmp('uri_1').value == 'LIST') {
				url = '*' + url;
				url = url.replace(/,/g, '*,*');
				url = url + '*';
			}
			if (url != null && url != undefined && url.length > 0) {
				var patternData = url + '~#~' + desc;
				////console.log(' patternData :- ' +patternData);
				var propsData = this.preparePropsData('1', idArray);
				if (propsData.length > 0) {
					propsData = '~!~' + propsData;
					finalPatternData = finalPatternData + patternData + propsData + ',';
				} else {
					finalPatternData = finalPatternData + patternData + ',';
				}
			}

		}
		////console.log(' -------');
		// return finalPatternData;
		////console.log('prepareCpcData block :-  end');

		if (finalPatternData.length > 0) {
			var endsWith1 = finalPatternData.endsWith(",");
			if (endsWith1) {
				var index1 = finalPatternData.lastIndexOf(",");
				finalPatternData = finalPatternData.substring(0, index1);
			}
			////console.log(finalPatternData);
			return finalPatternData;
		} else {
			return 'none';
		}
	},
	preparePropsData: function (id, idArray) {

		////console.log('preparePropsData block');
		////console.log(idArray);

		var propsLength = Ext.getCmp('urlPropsfieldset1').items.getCount();
		////console.log('propsLength :- ' + propsLength);
		if (propsLength == undefined) {
			return;
		}
		var runMe2 = true;
		var count2 = 0;
		var elementIdNo = 1;
		var propsData = '';
		
		for (var idNum in idArray) {
			var idNo = idArray[idNum];
			var innerPropsContainer = Ext.getCmp('urlProperty_1_' + idNo);
			////console.log('gettting data for  :- ' + 'urlProperty_1_' + idNo);

			if (!Ext.isEmpty(innerPropsContainer) && innerPropsContainer != undefined) {
				// TODO: validate all the things
				var inputSrc = Ext.getCmp('urlsegment_1_' + idNo).getValue();
				////console.log('inputSrc :- ' + inputSrc);
				var str = '';
				if (inputSrc != 'param') {
					var segment;
					////console.log("urlsegmentNo_1_"+idNo+"= "+segment);
					if (inputSrc == '1stFew') {
						segment = Ext.getCmp('urlsegmentNo_1_' + idNo).getValue();
						var segmentCount;
						var segmentStr = '';
						for (segmentCount = 1; segmentCount <= segment; segmentCount++) {
							segmentStr += 'US=' + segmentCount + '~|~';
						}
						str = str + segmentStr;
					} else {
						segment = Ext.getCmp('urlspecificsegmentNo_1_' + idNo).getValue();
						str = str + 'US=' + segment + '~|~';
					}
				} else if (inputSrc == 'param') {
					var param = Ext.getCmp('urlParam_1_' + idNo).getValue();
					var regx = Ext.getCmp('urlRegEx_1_' + idNo).getValue();
					//console.log(regx);
					if (regx != undefined && (regx == 'none' || regx.length == 0)) {
						str = str + 'HP_=' + param + '~|~';
					} else if (regx != undefined && regx.length > 0) {
						str = str + 'HP_' + regx + '=' + param + '~|~';
					}
				}

				propsData = propsData + str;

				count2++;

				// if(count2<propsLength)
				// {
				// propsData = propsData +'~|~';
				// }

			} else {
				continue;
			}

		}
		////console.log('preparePropsData block while end');
		var endsWith = propsData.endsWith("~|~");
		if (endsWith) {
			var index = propsData.lastIndexOf("~");
			propsData = propsData.substring(0, index - 2);
		}
		////console.log('--------------------- propsData :--- '+propsData);
		return propsData;
	},
	updateRule: function () {

		var name = Ext.getCmp('name').getValue();
		var urlPattern = Ext.getCmp('nameURL1').getValue();
		var variable = Ext.getCmp('cpcVariable').getValue();
		var uriCriteria = Ext.getCmp('uri_1').getValue();
		
		
		if (uriCriteria == 'EQ') {
			urlPattern = urlPattern;
		} else if (uriCriteria == 'SW') {
			urlPattern = urlPattern + '*';
		} else if (uriCriteria == 'EW') {
			urlPattern = '*' + urlPattern;
		} else if (uriCriteria == 'CON') {
			urlPattern = '*' + urlPattern + '*';
		}
		cpcValue = urlPattern + '~#~' + name + '~!~';
		var compList = Ext.ComponentQuery.query('#urlPropsfieldset1  fieldcontainer');
		var idArray = [];
		for (var i in compList) {
			var currentId = compList[i].id.split('_1_')[1];
			if (!idArray.includes(currentId)) {
				idArray.push(currentId);
			}
		}

		for (var id in idArray) {
			////console.log('urlsegment_1_'+idArray[id] + '    -----    ' + Ext.getCmp('urlsegment_1_'+idArray[id]).getValue());
			if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == '1stFew') {
				var usCount = Ext.getCmp('urlsegmentNo_1_' + idArray[id]).getValue();
				var usCounter = '';
				for (usCounter = 1; usCounter <= usCount; usCounter++) {
					cpcValue += 'US=' + usCounter + '~|~';
				}
			} else if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == 'specific') {
				cpcValue += 'US=' + Ext.getCmp('urlspecificsegmentNo_1_' + idArray[id]).getValue() + '~|~';
			} else if (Ext.getCmp('urlsegment_1_' + idArray[id]).getValue() == 'param') {
				cpcValue += 'HP_' + Ext.getCmp('urlRegEx_1_' + idArray[id]).getValue();
				var regex = Ext.getCmp('urlParam_1_' + idArray[id]).getValue();
				//console.log('cpcValue = '+cpcValue)
				//console.log('regex = ' +regex)
				if (regex != undefined && !(regex.length < 1)) {
					////console.log(regex.length);
					cpcValue += '=' + regex;
				}
				cpcValue += '~|~';
			}
		}
		cpcValue = cpcValue.substring(0, (cpcValue.length) - 3);
		//console.log(idArray);
		for (var curId in idArray) {
			//console.log(idArray[curId]);
			var uriSegmentType = Ext.getCmp('urlsegment_1_' + idArray[curId]).getValue();
			var uptosegmentNo = Ext.getCmp('urlsegmentNo_1_' + idArray[curId]).getValue();
			var segmentNo = Ext.getCmp('urlspecificsegmentNo_1_' + idArray[curId]).getValue();
			var segmentKey = Ext.getCmp('urlParam_1_' + idArray[curId]).getValue();
			if (uriSegmentType == 'param' && Ext.isEmpty(segmentKey)) {
				me.displayAlert('urlParam_1_' + idArray[curId], _checkempty);
				return false;
			} else if ((uriSegmentType == '1stFew' || uriSegmentType == 'specific') && (uptosegmentNo < 1 || segmentNo < 1)) {
				////console.log(Ext.getCmp('urlsegmentNo_1_1').isVisible());
				me.displayAlert('urlsegmentNo_1_' + idArray[curId], ' less than 1 ');
				return false;
			}
		}
		
		if(!me.verifyCreateOrUpdateRule(name, urlPattern, idArray)) return false;
		var compHost = Ext.getCmp('host').getValue();
		var resultUrl = "SpecificTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=update&compHost="+compHost+"&variable=" + encodeURIComponent(variable) + "&data=" + encodeURIComponent(cpcValue);
		Ext.Ajax.request({
			url: resultUrl,
			method: 'POST',
			async: false,
			success: function (response) {
				me.getRulesData();
			}
		});

	},

	handleDeleteIconClick: function (grid, rowIndex, colIndex) {
		////console.log(Ext.getCmp('btRulesGrid').getStore().getAt(rowIndex).data['variable']);
		Ext.Msg.show({
			title: businessTransNamingTitle,
			msg: confirmDeleteRule,
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function (buttonText) {
				if (buttonText == "yes") {
					var compHost = Ext.getCmp('host').getValue();
					var resultUrl = "SpecificTestConfiguration/data/EGBTNamingJson.jsp?compName=" + compName + "&compType=" + compType + "&testName=" + testName + "&crud=delete&compHost="+compHost+"&variable=" + encodeURIComponent(Ext.getCmp('btRulesGrid').getStore().getAt(rowIndex).data['variable']);
					//var resultUrl = "SpecificTestConfiguration/data/EGBTNamingJson.jsp?deleteRule="+encodeURIComponent(variableName)+"&mode=delete";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async: false,
						success: function (response) {
							me.getRulesData()
						}
					});
				}
			}
		});
	},

	//Business Transaction Naming Config Starts
	//Win Service Starts

	winServiceConfig: function () {
		var formObj = Ext.getCmp('testConfigForm').getForm();
		var testName = publicJson['testName'];
		var multiUserMode = publicJson['multiUserMode'];
		var allowHostName = publicJson['isAllowHostName'];
		var processVal = "";
		
		if(testName=='ScrtySrvceChecksTest')
		{
			processVal = Ext.getCmp('Services_to_be_disabled').getValue();
		}
		else
		{
			processVal = Ext.getCmp('serviceName').getValue();
		}
		
		
		var showGrid = true;
		if(!Ext.isEmpty(processVal) && processVal !="$unconfigured" && processVal.toLowerCase() != "$servicename")
		{
			showGrid = populate(testName,'specificConfiguration',multiUserMode,allowHostName,formObj);
		}
		if(showGrid)
			this.getController('SpecificTestConfiguration.controller.IntermediateController').winServiceConfigs();
	},
	addService: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').addNewService();
	},
	updateService: function(btn,fromBtn) {
		if(fromBtn == undefined || fromBtn != 'fromClose')
		{
			fromBtn = 'fromButton';
		}
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateServices(btn,fromBtn);
	},
	getService: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getServices();
	},
	getSite: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getSite();
	},
	getExcludeSite: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getExcludeSite();
	},
	winServiceSearch: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').winServicesSearch();
	},
	winServiceViewSearch: function(){
		this.getController('SpecificTestConfiguration.controller.IntermediateController').winServicesViewSearch();
	},
	submitservice: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').submitservices();
	},
	callServiceDestroy: function()
	{
		firstClick = true;
	},
	submitProcess: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').submitProcesses();
	},  // Win Service ends
	//site url Config starts
	siteUrlConfig: function() {  
		this.getController('SpecificTestConfiguration.controller.FunctionController').siteUrlConfigs();
	},
	// site url Config ends
	excludeInfConfig: function(reportName){
		this.getController('SpecificTestConfiguration.controller.FunctionController').excludeInfConfigs(reportName);
	},
	winServiceConfig_pr: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').winServiceConfigs_pr();
	},
	updateService_pr: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updateServices_pr();
	},
	configureDescriptorDetails: function(tempDescParam) { // EgDetailsTest.jsp
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configuredescriptors(tempDescParam);
	},
	updateDescriptor: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').updatedescriptors();
	},
	getPopupSitename: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').getPopupSitename();
	},
	callDescDestroy: function() {
		Ext.getCmp('egdetailstest').destroy();
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	}, // EgDetails ends
	disassociate : function() {
		Ext.getCmp('save').setDisabled(true);
		Ext.getCmp('sendReq').setDisabled(true);
		var wsdlOperationObj = Ext.getCmp('wsdlOperation');
		var wsdlOperationFromFieldStore = wsdlOperationObj.fromField.store;
		var wsdlOperationToFieldStore = wsdlOperationObj.toField.store;

		if (!Ext.isEmpty(Ext.getCmp('xmlandhtmlview')))
		{
			Ext.getCmp('manualOptionGrp').hide();
			Ext.getCmp('xmlTable').removeAll();
			Ext.getCmp('xmlTable').hide();
			Ext.getCmp('inputTable').removeAll();
			Ext.getCmp('htmlviewer').hide();
			Ext.getCmp('xmlandhtmlview').setDisabled(true);
			Ext.getCmp('saveAndConfigContainer').hide();
		}

		var selectedOpLen = wsdlOperationFromFieldStore.getCount();
		var compAssChoosen=0;
		var associatedOp='';
		var selectedOperationArr = new Array();
		var existArray = publicWebServJSON['monitoredOperationsArry'];

		var newAssociateData = ',';
		var isAllFromFieldDataDisAssociated = false;
		if (existArray.length > 0)
		{
			if (selectedOpLen == 0)
			{
				isAllFromFieldDataDisAssociated = true
			}
		}

		for (var i = 0; i < selectedOpLen; i++)
		{
			var value = wsdlOperationFromFieldStore.getAt(i).get('valueField');
			if (!Ext.isEmpty(value) && value != undefined)
			{
				newAssociateData += value+',';
			}
		}

		if (!isAllFromFieldDataDisAssociated)
		{
			if (!Ext.isEmpty(existArray) && existArray != undefined && existArray.length > 0)
			{
				for (var i = 0 ; i < existArray.length ; i++)
				{
					var value = existArray[i].valueField;
					selectedOperationArr[i]  = value;
					if (!Ext.isEmpty(value) && newAssociateData.indexOf(','+value+',') == -1)
					{
						associatedOp = associatedOp+","+value;
						compAssChoosen++;
					}
				}
			}
		}
		else
		{
			if (!Ext.isEmpty(existArray) && existArray != undefined && existArray.length > 0)
			{
				for (var i = 0 ; i < existArray.length ; i++)
				{
					var value = existArray[i].valueField;
					selectedOperationArr[i]  = value;
					associatedOp = associatedOp+","+value;
					compAssChoosen++;
				}
			}
		}

		if(associatedOp.indexOf(',') == 0)
		{
			associatedOp = associatedOp.substring(associatedOp.indexOf(",")+1);
		}

		var selectedUrl = Ext.getCmp('wsdlUrl').getValue();
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var configMode =  Ext.getCmp('agentListObj').getValue();
		var reqFrom = 'disassociate';
		var wsdlMain = publicWebServJSON['wsdl'];
		var mainOperation = publicWebServJSON['mainOperation'];
		var componentName = publicWebServJSON['componentName'];
		var credentialWithPattern = publicWebServJSON['credentialWithPattern'];
		if (!Ext.isEmpty(selectedOperationArr) && selectedOperationArr.length > 0)
		{
			mainOperation = '';
			var name = '';
			if (!Ext.isEmpty(selectedUrl) && selectedUrl != undefined)
			{
				name = selectedUrl.substring(0,selectedUrl.indexOf(':'));
			}
			if (!Ext.isEmpty(selectedService) && selectedService != undefined)
			{
				name += ':'+selectedService;
			}
			for (var i=0; i < selectedOperationArr.length ; i++ )
			{
				mainOperation +=name+'_'+selectedOperationArr[i]+',';
			}
			if (!Ext.isEmpty(mainOperation) && mainOperation != undefined )
			{
				mainOperation = mainOperation.substring(0,mainOperation.length - 1);
			}
		}

		var myWebConfMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Updating...'});
		myWebConfMask.show();
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
			method: "POST",
			params:'selectedUrlValue='+encodeURI(selectedUrl)+ '&selectedServiceValue='+encodeURI(selectedService)+ '&componentName='+encodeURI(componentName)+ '&wsdl='+encodeURI(wsdlMain)+ '&operation='+encodeURI(mainOperation)+'&reqFrom='+encodeURI(reqFrom)+'&associatedOp='+encodeURI(associatedOp)+'&configMode='+encodeURI(configMode)+'&credentialWithPattern='+encodeURI(credentialWithPattern),
			timout:120000,
			success: function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					myWebConfMask.hide();
					var jsonText = response.responseText;
					publicWebServJSON = Ext.decode( jsonText );
					var definedOperationsArry = publicWebServJSON['definedOperationsArry'];
					var monitoredOperationsArry = publicWebServJSON['monitoredOperationsArry'];
					var finalValue = publicWebServJSON['finalValue'];
					Ext.getCmp('Operations').setValue(finalValue);

					if (wsdlOperationToFieldStore.getCount() >= 1)
					{
						wsdlOperationToFieldStore.removeAll();
					}
					if (wsdlOperationFromFieldStore.getCount() >= 1)
					{
						wsdlOperationFromFieldStore.removeAll();
					}

					if (!Ext.isEmpty(definedOperationsArry) && definedOperationsArry != undefined)
					{
						wsdlOperationToFieldStore.add(definedOperationsArry);
					}
					if (!Ext.isEmpty(monitoredOperationsArry) && monitoredOperationsArry != undefined)
					{
						wsdlOperationFromFieldStore.add(monitoredOperationsArry);
					}

					var selectedOpLen = wsdlOperationFromFieldStore.getCount();
					if(selectedOpLen == 0)
					{
						Ext.getCmp('xmlTable').removeAll();
						Ext.getCmp('xmlTable').hide();
						Ext.getCmp('inputTable').removeAll();
						Ext.getCmp('htmlviewer').hide();
						Ext.getCmp('xmlandhtmlview').setDisabled(true);
						Ext.getCmp('saveAndConfigContainer').hide();
					}
				}
			}
		});
	},
	configAwsAppStreamResourceSet: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configAwsAppStreamResourceSet();
	},
	configWVDResourceSet: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configWVDResourceSet();
	},
	configAmazonWSResourceSet: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configAmazonWSResourceSet();
	},
	configSystemProperties: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configSystemProperties();
	},
	configHorizonWSResourceSet: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configHorizonWSResourceSet();
	},
	configMultiHLSFieldSet: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configMultiHLSFieldSet();
	},
	configCustomConfigurations: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configCustomConfigurations();
	},
	configEMailCredential: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').configEMailCredential();
	},
	createRulesForSyslog: function(btn) {
		this.getController('SpecificTestConfiguration.controller.FunctionController').createRulesForSyslog();
	},
	saveWebConfigure: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').saveWebConfig();
	},
	sendRequestWebConfigure: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').sendRequestWebConfig();
	},
	webServiceConfigure: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').webServiceConfig();
	},
	selectServices: function (value) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').selectService();
	},
	selectUrlValue: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').selectUrl();
	},
	configoperations: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configureoperations();
	},
	radXmlHtmlMain: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').radXmlHtml();
	},
	changeButtonLabel: function( record ) {
		var fromFieldData = Ext.getCmp('wsdlOperation').fromField.getSelected();
		if (!Ext.isEmpty(fromFieldData) && fromFieldData != undefined)
		{
			var groupLabel = fromFieldData[0].data.groupField;
			if(!Ext.isEmpty(groupLabel)  && groupLabel == "Configured Operation")
			{
				Ext.getCmp('ConfigureBTN').setText('Reconfigure');
			}
			else if(!Ext.isEmpty(groupLabel) && groupLabel=="UnConfigured Operation")
			{
				Ext.getCmp('ConfigureBTN').setText('Configure');
			}
		}
	},
	changeElement: function() {
		Ext.getCmp('saveAndConfigContainer').hide();
		Ext.getCmp('xmlandhtmlview').setDisabled(true);
		Ext.getCmp('xmlTable').removeAll();
		Ext.getCmp('xmlTable').hide();
		Ext.getCmp('inputTable').removeAll();
		Ext.getCmp('htmlviewer').hide();
		Ext.getCmp('manualOptionGrp').hide();

		var selectedUrl = Ext.getCmp('wsdlUrl').getValue();
		var selectedService = Ext.getCmp('wsdlService').getValue();
		var fromFieldExistArray = publicWebServJSON['monitoredOperationsArry'];

		var fromFieldLen = Ext.getCmp('wsdlOperation').fromField.store.getCount();
		var fromFieldList = Ext.getCmp('wsdlOperation').fromField.store;

		var associatedOp = '';
		var newAssociateData = ',';
		if (!Ext.isEmpty(fromFieldExistArray) && fromFieldExistArray != undefined && fromFieldExistArray.length > 0)
		{
			for (var i = 0 ; i < fromFieldExistArray.length ; i++)
			{
				var value = fromFieldExistArray[i].valueField;
				if (!Ext.isEmpty(value))
				{
					newAssociateData += value+',';
				}
			}
		}
		var strFromFieldData = '';
		for (var i = 0 ; i < fromFieldLen ; i++)
		{
			var fromFieldData = fromFieldList.getAt(i).get('valueField');
			strFromFieldData  = strFromFieldData+','+fromFieldData;
			if (!Ext.isEmpty(fromFieldData) && newAssociateData.indexOf(','+fromFieldData+',') == -1 )
			{
				associatedOp = associatedOp+","+fromFieldData;
			}
		}
		if(associatedOp.indexOf(',') == 0)
		{
			associatedOp = associatedOp.substring(associatedOp.indexOf(",")+1);
		}
		if(strFromFieldData.indexOf(',') == 0)
		{
			strFromFieldData = strFromFieldData.substring(strFromFieldData.indexOf(",")+1);
		}

		if (fromFieldExistArray.length == 0)
		{
			associatedOp = strFromFieldData;
		}

		var wsdlMain = publicWebServJSON['wsdl']
		var mainOperation = publicWebServJSON['mainOperation'];
		var componentName = publicWebServJSON['componentName'];
		var credentialWithPattern = publicWebServJSON['credentialWithPattern'];


		var confMode = Ext.getCmp('agentListObj').getValue();
		var configMode = '';
		if (confMode.indexOf('eG Manager') != -1)
		{
			configMode = 'EgManager';
		}
		else
		{
			configMode = confMode;
		}

		var myWebConfMask = new Ext.LoadMask(Ext.getCmp('egwebserviceconfiguration'), {msg: 'Updating...'});
		myWebConfMask.show();
		
		Ext.Ajax.request({
			url: 'SpecificTestConfiguration/data/EgWebServiceConfigJson.jsp',
			method: 'POST',
			params: 'selectedUrlValue='+encodeURI(selectedUrl)+"&selectedServiceValue="+encodeURI(selectedService)+"&componentName="+encodeURI(componentName)+"&wsdl="+encodeURI(wsdlMain)+"&operation="+encodeURI(mainOperation)+"&configMode="+configMode+"&reqFrom=associate&associatedOp="+encodeURI(associatedOp)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
			timeout: 6000000,
			//async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					myWebConfMask.hide();
					var jsonText = response.responseText;
					publicWebServJSON = Ext.decode( jsonText );
					var definedOperationsArry = publicWebServJSON['definedOperationsArry'];
					var monitoredOperationsArry = publicWebServJSON['monitoredOperationsArry'];
					var wsdlOperationObj = Ext.getCmp('wsdlOperation');
					var wsdlOperationFromFieldStore = wsdlOperationObj.fromField.store;
					var wsdlOperationToFieldStore = wsdlOperationObj.toField.store;
					var operations = publicWebServJSON['finalValue'];
					if(operations==null || operations=='')
					{
						Ext.getCmp('Operations').setValue(mainOperation);
					}
					else
					{
						Ext.getCmp('Operations').setValue(operations);
					}

					if (wsdlOperationToFieldStore.getCount() >= 1)
					{
						wsdlOperationToFieldStore.removeAll();
					}
					if (wsdlOperationFromFieldStore.getCount() >= 1)
					{
						wsdlOperationFromFieldStore.removeAll();
					}

					if (!Ext.isEmpty(definedOperationsArry) && definedOperationsArry != undefined)
					{
						wsdlOperationToFieldStore.add(definedOperationsArry);
					}
					if (!Ext.isEmpty(monitoredOperationsArry) && monitoredOperationsArry != undefined)
					{
						wsdlOperationFromFieldStore.add(monitoredOperationsArry);
					}
				}
			}
		});
	},
	//checkXIOAPIVersion: function ()
	//{
		//var host = Ext.getCmp('host').getValue();
		//var user = Ext.getCmp('XtremIO_user').getValue();
		//var pwd = Ext.getCmp('XtremIO_password').getValue();
		//var confirmPwd = Ext.getCmp('XtremIO_passwordconfirmpassword').getValue();

		//var ssl = false;
		//var sslEnable = Ext.getCmp('ssl2').getValue();
		//if (!Ext.isEmpty(sslEnable) && sslEnable)
		//{
			//ssl = sslEnable;
		//}
		//var isValidData = true;

		//if (Ext.isEmpty(user))
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: _checkempty,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation',
				//fn: function() {
					//Ext.getCmp('XtremIO_user').focus();
				//}
			//});
			//isValidData = false;
			//return;
		//}
		//else if (user == '$unconfigured')// && !Ext.isEmpty(pwd) && )
		//{
				//Ext.Msg.show({
					//title: pageName,
					//msg: _tcKeyword,
					//buttons: Ext.Msg.OK,
					//icon: 'iconExclamation',
					//fn: function() {
						//Ext.getCmp('XtremIO_user').focus();
					//}
				//});
				//isValidData = false;
				//return;
		//}

		//if (Ext.isEmpty(pwd))
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: _checkempty,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation',
				//fn: function() {
					//Ext.getCmp('XtremIO_password').focus();
				//}
			//});
			//isValidData = false;
			//return;
		//}
		//else if (pwd == '$unconfigured')
		//{
				//Ext.Msg.show({
					//title: pageName,
					//msg: _tcKeyword,
					//buttons: Ext.Msg.OK,
					//icon: 'iconExclamation',
					//fn: function() {
						//Ext.getCmp('XtremIO_password').focus();
					//}
				//});
				//isValidData = false;
				//return;
		//}
		//if (Ext.isEmpty(confirmPwd))
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: _checkempty,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation',
				//fn: function() {
					//Ext.getCmp('XtremIO_passwordconfirmpassword').focus();
				//}
			//});
			//isValidData = false;
			//return;
		//}
		//else if(pwd != confirmPwd)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: _isPassword,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation',
				//fn: function() {
					//Ext.getCmp('XtremIO_passwordconfirmpassword').focus(true);
				//}
			//});
			//isValidData = false;
			//return;
		//}
		
		//if (isValidData)
		//{
			//Ext.Ajax.request({
				//url:'SpecificTestConfiguration/data/EMCXIOCluster.jsp?',
				//params:{
					//host: host,
					//XtremIO_user: user,
					//XtremIO_password: pwd,
					//ssl: ssl
				//},
				//method:'POST',
				//timeout:120000,
				//success: function(response)
				//{
					//if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					//{
						//var jsonText = response.responseText;
						//publicXtremJson = Ext.decode( jsonText );
						//var restAPIVersion = publicXtremJson.restAPIVersion;
						//var clusterArr = publicXtremJson.clusterArr;
						//if (!Ext.isEmpty(restAPIVersion))
						//{
							//Ext.getCmp('XtremIO_API_Version').setValue(restAPIVersion);
						//}
						//else
						//{
							//Ext.getCmp('XtremIO_API_Version').setValue("1");
						//}

						//if (!Ext.isEmpty(clusterArr))
						//{
							//Ext.getCmp('XtremIO_Cluster').getStore().removeAll();
							//Ext.getCmp('XtremIO_Cluster').getStore().loadRawData(clusterArr);
							//Ext.getCmp('XtremIO_Cluster').setValue(clusterArr[0].valueField);
						//}
					//}
				//}
			//});
		//}
	//},
	configDbCreation: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configDbCreations();
	},
	comboVersion: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').comboVersions();
	},
	clearDb: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').clearDbs();
	},
	AddNewDb: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').AddNewDbs();
	},
	ApplyNewDb: function(btn) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').ApplyNewDbs();
	},
	policyCreationMainPage: function() { //View Policy Starts
		this.getController('SpecificTestConfiguration.controller.IntermediateController').policyCreationPage();
	},
	configViewMainPolicy: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').configViewPolicy();
	},
	policyMainSearch: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').policySearch();
	},
	policyMainValidate: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').policyValidate();
	},
	openMainWindow: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').openWindow();
	},
	windowCloseMainEvent: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').windowCloseEvent();
	},
	check: function(fromComp) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').checkInter(fromComp);
	},
	handleDeleteSelected: function() {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').handleDeleteSelectedInter();
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').handleEditIconClickInter(view, rowIndex, colIndex, column, e);
	},
	handleViewIconClick: function(view, rowIndex, colIndex) {
		this.getController('SpecificTestConfiguration.controller.IntermediateController').handleViewIconClickInter(view, rowIndex, colIndex);
	}, //View Policy Ends
	removeSecletedService: function(){
		this.getController('SpecificTestConfiguration.controller.IntermediateController').removeSecletedServices();
	},
	modifyService: function(){
		this.getController('SpecificTestConfiguration.controller.IntermediateController').modifyServices();
	},
	modifyProces: function(){
		this.getController('SpecificTestConfiguration.controller.IntermediateController').modifyProceses();
	},
	configDiscover: function(btn) {
		var componName = publicJson['componentName'];
		Ext.getCmp("device_id").setValue("Default");
		Ext.getCmp("device_name").setValue("This may take sometime...");
		var url_Param = "SpecificTestConfiguration/data/setSessionAttributeJson.jsp?action=getnetworkAdapters&componentNick="+encodeURIComponent(componName);
		Ext.Ajax.request({
			url : url_Param,
			method: 'POST',
			timeout: 7200000,
			success: function(response)
			{
				Ext.getCmp("device_id").setValue("Default");
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					jsonDiscover = Ext.decode( jsonText );

					var result = jsonDiscover['resultAdapter'];
					if (result != "" || result.length > 0)
					{
						Ext.getCmp('device_name').getStore().loadRawData(jsonDiscover['displaydeviceName']);
						Ext.getCmp('device_name').setValue(jsonDiscover['dispName']);
						Ext.getCmp('device_id').setValue(jsonDiscover['deviceVal']);
					}
					else
					{
						Ext.getCmp("device_name").setValue("Default");
					}
				}
			}
		});
	},
	changeDeviceId: function() {
		var resultArray = new Array();
		var selectedDeviceName = Ext.getCmp('device_name').getValue();
		var result = jsonDiscover['resultAdapter'];
		if (result != "" && result.length > 0)
		{
			resultArray = result.split("~#~");
			for (var m=0;m<resultArray.length;m++ )
			{
				var value1 = resultArray[m].split("~,~");
				if (value1[0] == selectedDeviceName)
				{
					Ext.getCmp('device_id').setValue(value1[1]);
				}
			}
		}
	},
	clearFunction: function(correctiveScriptId) {
		Ext.getCmp(correctiveScriptId).setValue("none");
	},
	chooseRemoteUpload: function() {
		var agentOS = publicJson['hiddenObj']['agentOS'];
		if (Ext.isEmpty(agentOS) || agentOS == undefined || agentOS == "null")
		{
			Ext.Msg.show({
				title: pageName,
				msg: agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var strTestName = publicJson['testName'];
		var userparam = Ext.getCmp('userparams').getValue();
		var url = 'SpecificTestConfiguration/data/EgRemoteUploadJson.jsp?page=EgConfigureComponentTests&agentOS='+agentOS+"&userparam="+userparam+"&testName="+testName;
		var compTypeVal = Ext.getCmp('componentType').getValue();
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: titleMsg,
						width: 600,
						id: 'file',
						name: 'file',
						resizable: 'false',
						listeners : {
							close : function()
							{
								Ext.Ajax.request({
									url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+testName+'&testName='+testName,
									method:'POST'
								});
							}
						},
						dockedItems: [
							{
								dock: 'bottom',
								layout:{
									type:'hbox',
									align:'stretch',
									pack:'center'
								},
								border:false,
								padding : '10 10 5 10',
								items: [
									{
										xtype: 'button',
										text: label_Upload,
										cls: 'quickMenuWhiteButton',
										id: 'upload',
										name: 'upload',
										action: 'upload',
										width: 80,
										handler: function (button, e)
										{
											var sub = true;
											var form = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
											if(!validateSingleByte(form))
											{
												Ext.Msg.show({
													title: pageName,
													msg: dblName,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}
											if(form=="")
											{
												Ext.Msg.show({
													title: pageName,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}
											else
												sub = true;

											var filename="";
											if(form.indexOf("\\")> -1)
												filename = form.substring(form.lastIndexOf("\\")+1,form.length);
											else if(form.indexOf("/")> -1)
												filename = form.substring(form.lastIndexOf("/")+1,form.length);
											else
												filename = form;

											agentOS = agentOS.toUpperCase();
											var check = true;
											var exten_str="";
											var exten_idx = filename.lastIndexOf(".");
											if(exten_idx > 0)
												exten_str = filename.substring(exten_idx);
											exten_str = exten_str.toLowerCase();
											var exten_List = new Array(".exe",".bat",".com",".cmd",".vbs",".ps1");
											if((agentOS.indexOf("WINDOWS") == -1))
												exten_List =  new Array(".sh",".ksh",".perl",".pl");
											for(i=0;i<exten_List.length;i++)
											{
												if(exten_List[i] == exten_str)
												{
													check = false;
													break;
												}
											}
											if(check)
											{
												sub = false;
												if((agentOS.indexOf("WINDOWS") != -1))
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload1,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
												else
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload2,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
											}
											if(sub)
											{
												var uploadform = Ext.getCmp('uploadform').getForm();
												if (uploadform.isValid())
												{
													uploadform.submit({
														success: function (form, action) {
															var jsonText = action.response.responseText;
															publicUploadJson = Ext.decode(jsonText);
															if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
															{
																var scriptValue = publicUploadJson.fileName;
																if (Ext.getCmp('correctivescript').getValue() == "" || Ext.getCmp('correctivescript').getValue() == "none")
																{
																	Ext.getCmp('correctivescript').setValue(scriptValue);
																}
																else
																{
																	var prev_val = Ext.getCmp('correctivescript').getValue();
																	var val = prev_val.split(",");
																	var cur_val = "";
																	for(var i=0;i<val.length;i++)
																	{
																		if(val[i] == scriptValue)
																			continue;
																		cur_val = cur_val + val[i] + ',';
																	}
																	Ext.getCmp('correctivescript').setValue(cur_val+scriptValue);
																}
																button.up('.window').close();
															}
														},
														failure: function (form, action) {
															Ext.Msg.show({
																title: pageName,
																msg: 'FAILURE',
																buttons: Ext.Msg.OK,
																icon: 'iconExclamation'
															});
														}
													});
												}
											}
											Ext.Ajax.request({
												url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
												method:'POST'
											});
										}
									}
								]
							}
						],
						items: [
							{
								xtype: 'form',
								id: 'uploadform',
								name: 'uploadform',
								border: false,
								url: '../servlet/com.eg.EgUploadServlet',
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: '',
									margin: 5,
									width: 450,
									labelWidth: 200
								},
								items: [
									{
										xtype: 'displayfield',
										id: 'displayTestName',
										fieldLabel: 'Test name',
										value: ''
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'measureName',
										name: 'measureName',
										fieldLabel: 'Choose corrective script for',
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										id: 'file1',
										name: 'file1',
										labelSeparator: '',
										margin: '5 5 0 5',
										emptyText: emptyMsg,
										fieldLabel: label_Load,
										buttonText: 'Browse'
									}
								],
								listeners: {
									afterrender: function () {
										me.windowupload();
									}
								}
							}
						]
					}).show()
					Ext.getCmp('displayTestName').setValue('<span class="font_bold">'+publicJson['displayTestName']+'</span>');
					Ext.getCmp('measureName').getStore().loadRawData(publicJsonData['arrObj']);
					Ext.getCmp('measureName').setValue(publicJson['testName']);
				}
			}
		});
	},
	windowupload: function () {
		var me = Ext.getCmp('uploadform');
		var a = me.getForm();
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'")
					.setValue(hiddenParams[hiddenParam]);
			}
		}
	},
	afterMainRender: function() {
		var showUnconfigCompType = 'false';
		if (!Ext.isEmpty(unconfigCompChecked) && unconfigCompChecked == 'true')
		{
			Ext.getCmp('unconfiguredCompType').setValue(true);
			showUnconfigCompType = 'true';
			Ext.getCmp('unconfiguredCompType').dataArray = false;
		}
		else
		{
			if (Ext.getCmp('unconfiguredCompType').getValue())
			{
				Ext.getCmp('unconfiguredCompType').setValue(false);
				Ext.getCmp('unconfiguredCompType').dataArray = false;
			}
			else
			{
				Ext.getCmp('unconfiguredCompType').dataArray = false;
			}
		}

		if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && (reqFrom == 'UnconfigTests' || reqFrom == 'LayerModel' || reqFrom == 'compModify'))
		{
			Ext.getCmp('backbutton').show();
			Ext.getCmp('backbutton').btnFrom = reqFrom;
		}
		else
		{
			Ext.getCmp('backbutton').hide();
			Ext.getCmp('backbutton').btnFrom = '';
			layerName = '';
		}

		var urlVal = 'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?showUnconfigCompType='+showUnconfigCompType+'&fromWizard='+fromWizard;
		if (!Ext.isEmpty(compType))
		{
			urlVal +='&componentType='+encodeURIComponent(compType);
		}
		if (Ext.getCmp('linkContainer').isVisible())
		{
			Ext.getCmp('linkContainer').hide();
		}
		if (Ext.getCmp('enableCsContainer').isVisible())
		{
			Ext.getCmp('enableCsContainer').hide();
		}
		if (Ext.getCmp('disableCsContainer').isVisible())
		{
			Ext.getCmp('disableCsContainer').hide();
		}

		if (!Ext.isEmpty(compName))
		{
			urlVal +='&componentName='+encodeURIComponent(compName);
		}

		if (!Ext.isEmpty(testType))
		{
			urlVal +='&testType='+encodeURIComponent(testType);
		}
		if (!Ext.isEmpty(testName))
		{
			urlVal +='&testName='+encodeURIComponent(testName);
		}
		if (!Ext.isEmpty(layerName))
		{
			urlVal +='&layerName='+encodeURIComponent(layerName);
		}
		if (!Ext.isEmpty(reqFrom))
		{
			urlVal +='&reqfrom='+encodeURIComponent(reqFrom);
		}

		var gridVisible = Ext.getCmp('agentDetailsGrid');
		var unconfigTestsStore = Ext.getCmp('unconfigTests').getStore();
		var configTestsStore = Ext.getCmp('configTests').getStore();
		var excludeTestsStore = Ext.getCmp('excludeTests').getStore();
		if (gridVisible.isVisible())
		{
			gridVisible.hide();
		}
		if (unconfigTestsStore.getCount() > 0)
		{
			Ext.getCmp('unconfigTests').getStore().removeAll();
		}
		if (configTestsStore.getCount() > 0)
		{
			Ext.getCmp('configTests').getStore().removeAll();
		}
		if (excludeTestsStore.getCount() > 0)
		{
			Ext.getCmp('excludeTests').getStore().removeAll();
		}
		if (Ext.getCmp('noAgentMsgContainer').isVisible())
		{
			Ext.getCmp('noAgentMsgContainer').hide();
		}
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			//Ext.getCmp('dispFieldSet').removeAll();
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}

		redirectURL = publicJson['qString'];
		if (!Ext.isEmpty(redirectURL) && redirectURL != undefined)
		{
			urlVal = redirectURL;
		}

		var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myHomeMask.show();
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			timeout: 120000,
			success:function(response)
			{
				myHomeMask.hide();

				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					hide_process_service_button=publicJson['isContainerApp'];
					isConfigSupported = publicJson['isConfigSupported'];
					var allCompAccess = publicJson['allCompAccess'];
					if (isConfigSupported)
					{
						Ext.getCmp('testType').show()
						if (!Ext.isEmpty(testType))
						{
							Ext.getCmp('testType').setValue(testType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}

					if (!allCompAccess)
					{
						Ext.getCmp('enableDisableBtn').hide();
					}
					else
					{
						Ext.getCmp('enableDisableBtn').show();
						Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
					}
					//Ext.getCmp('enableDisableBtn').setText(publicJson['enableDisableTestPageLabel']);
					Ext.getCmp('componentType').getStore().loadRawData(publicJson['compTypeArr']);
					Ext.getCmp('componentName').getStore().loadRawData(publicJson['compNameArr']);
					var selectedCompType = publicJson['selectedCompType'];
					var selectedCompName = publicJson['selectedCompName'];
					if ( !Ext.isEmpty( selectedCompName ) )
					{
						compName = selectedCompName;
					}
					layerName = publicJson.layerName;

					if ( !Ext.isEmpty( selectedCompType ) )
					{
						Ext.getCmp('componentType').setValue(selectedCompType);
						Ext.getCmp('componentType').fireEvent('select', Ext.getCmp('componentType'));
					}
					else
					{
						Ext.getCmp('componentType').setValue(publicJson['compTypeArr'][0].valueField);
						Ext.getCmp('componentName').setValue(publicJson['compNameArr'][0].valueField);
					}
				}
			},
			failure: function()
			{
				myHomeMask.hide();

			}
		});
	},
	compTypeChangeEvent: function() {
		availPolicies = "";
		last_view = "";
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			//Ext.getCmp('dispFieldSet').removeAll();
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}
		if (Ext.getCmp('linkContainer').isVisible())
		{
			Ext.getCmp('linkContainer').hide();
		}
		if (Ext.getCmp('enableCsContainer').isVisible())
		{
			Ext.getCmp('enableCsContainer').hide();
		}
		if (Ext.getCmp('disableCsContainer').isVisible())
		{
			Ext.getCmp('disableCsContainer').hide();
		}
		var gridVisible = Ext.getCmp('agentDetailsGrid');
		if (gridVisible.isVisible())
		{
			gridVisible.hide();
		}
		if (Ext.getCmp('noAgentMsgContainer').isVisible())
		{
			Ext.getCmp('noAgentMsgContainer').hide();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		if (!Ext.isEmpty(compType) && !Ext.isEmpty(compTypeVal))
		{
			if (compType != compTypeVal)
			{
				compName = '';
				clickedFrom = '';
				testName = '';
				testType = 'PerformanceTest';
			}
		}
		if(Ext.isEmpty(compTypeVal))
		{
			//clickedFrom = '';
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal))
		{
			var unconfigTestsStore = Ext.getCmp('unconfigTests').getStore();
			var configTestsStore = Ext.getCmp('configTests').getStore();
			var excludeTestsStore = Ext.getCmp('excludeTests').getStore();
			if (unconfigTestsStore.getCount() > 0)
			{
				Ext.getCmp('unconfigTests').getStore().removeAll();
			}
			if (configTestsStore.getCount() > 0)
			{
				Ext.getCmp('configTests').getStore().removeAll();
			}
			if (excludeTestsStore.getCount() > 0)
			{
				Ext.getCmp('excludeTests').getStore().removeAll();
			}

			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

			var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
			myMask.show();
			compType = compTypeVal;
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&showUnconfigCompType='+showUnconfigCompType+'&reqfrom='+backBtnFrom,
				method:'post',
				scope:this,
				//async: false,
				timeout: 120000,
				success:function(response)
				{
					myMask.hide();
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					hide_process_service_button=publicJson['isContainerApp'];
					isConfigSupported = publicJson['isConfigSupported'];
					oidForComponentType = publicJson['oidForComponentType'];
					var allCompAccess = publicJson['allCompAccess'];

					if (!allCompAccess)
					{
						Ext.getCmp('enableDisableBtn').hide();
					}
					else
					{
						Ext.getCmp('enableDisableBtn').show();
						Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
					}
					var compNameObj = Ext.getCmp('componentName');
					var selectedCompName = publicJson['selectedCompName'];
					var compNameArr = publicJson['compNameArr'];
					compNameObj.getStore().clearFilter(true);
					compNameObj.getStore().removeAll();
					compNameObj.getStore().loadRawData(compNameArr);
					var compNameCount = publicJson.isNeedEditableComboBox;
					if (true) //compNameCount )
					{
						compNameObj.setEditable(true);
					}
					else
					{
						compNameObj.setEditable(false);
					}
					if ( !Ext.isEmpty( compName ) )
					{
						compNameObj.setValue(compName);
						Ext.getCmp('componentName').fireEvent('select', Ext.getCmp('componentName'));
					}
					else
					{
						compNameObj.setValue(publicJson['compNameArr'][0].valueField);
					}
					
					if (isConfigSupported)
					{
						Ext.getCmp('testType').show()
						if (!Ext.isEmpty(testType))
						{
							Ext.getCmp('testType').setValue(testType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}
				},
				failure: function()
				{
					myMask.hide();
				}
			});
		}
	},
	compNameChangeEvent: function() {
		availPolicies = "";
		last_view = "";

		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}
		if (Ext.getCmp('linkContainer').isVisible())
		{
			Ext.getCmp('linkContainer').hide();
		}
		if (Ext.getCmp('enableCsContainer').isVisible())
		{
			Ext.getCmp('enableCsContainer').hide();
		}
		if (Ext.getCmp('disableCsContainer').isVisible())
		{
			Ext.getCmp('disableCsContainer').hide();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		var gridVisible = Ext.getCmp('agentDetailsGrid');
		var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

		if (gridVisible.isVisible())
		{
			gridVisible.hide();
		}
		if (Ext.getCmp('noAgentMsgContainer').isVisible())
		{
			Ext.getCmp('noAgentMsgContainer').hide();
		}

		if (!Ext.isEmpty(testType) && !Ext.isEmpty(testTypeVal))
		{
			if (testType != testTypeVal)
			{
				testTypeVal = testType;
			}
		}
		if (!Ext.isEmpty(compName) && !Ext.isEmpty(compNameVal))
		{
			if (compName != compNameVal)
			{
				testName = '';
				clickedFrom = '';
			}
		}
		if(Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if((!Ext.isEmpty(compTypeVal)) && (Ext.isEmpty(compNameVal)))
		{
			this.compTypeChangeEvent();
		}
		else
		{
			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();

			compName = compNameVal;
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&testType='+encodeURIComponent(testTypeVal)+'&showUnconfigCompType='+encodeURIComponent(showUnconfigCompType)+'&reqfrom='+backBtnFrom,
				method:'post',
				scope:this,
				//async:false,
				timeout: 120000,
				success:function(response)
				{
					myMask.hide();
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					hide_process_service_button=publicJson['isContainerApp'];
					var selectedTestType = publicJson['selectedTestType'];
					var noAgentMsg = publicJson['NoAgentMsg'];
					var isConfigSupported = publicJson['isConfigSupported'];
					if (isConfigSupported)
					{
						Ext.getCmp('testType').show()
						if (!Ext.isEmpty(testType))
						{
							Ext.getCmp('testType').setValue(selectedTestType);
							Ext.getCmp('testType').fireEvent('select', Ext.getCmp('testType'));
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}

					var gridVisible = Ext.getCmp('agentDetailsGrid');

					var agentDetailsArr = publicJson['agentDetailsArr'];
					if (!Ext.isEmpty(agentDetailsArr))
					{
						if (!gridVisible.isVisible())
						{
							gridVisible.show();
							//gridVisible.collapse();
						}
						Ext.getCmp('agentDetailsGrid').getStore().loadRawData(publicJson['agentDetailsArr']);
					}
					if (!Ext.isEmpty(noAgentMsg))
					{
						if (Ext.getCmp('noAgentMsgContainer').isHidden())
						{
							Ext.getCmp('noAgentMsgContainer').show();
							Ext.getCmp('noMAgentMsgLabel').update(noAgentMsg);
						}
					}
					Ext.getCmp('unconfigTests').getStore().removeAll();
					Ext.getCmp('unconfigTests').getStore().loadRawData(publicJson['unconfigTestsArr']);
					Ext.getCmp('configTests').getStore().removeAll();
					Ext.getCmp('configTests').getStore().loadRawData(publicJson['userConfigTestsArr']);
					Ext.getCmp('excludeTests').getStore().removeAll();
					Ext.getCmp('excludeTests').getStore().loadRawData(publicJson['excludeTestsArr']);

					if (!isConfigSupported)
					{
						if ( !Ext.isEmpty( clickedFrom )  && clickedFrom != undefined)
						{
							if (clickedFrom == 'reconfigurebutton')
							{
								fromApply = "reconfig";
								Ext.getCmp('configTests').setValue([testName]);
								Ext.getCmp(clickedFrom).fireEvent('click', Ext.getCmp(clickedFrom));
								clickedFrom = '';
							}
							else
							{
								fromApply = "config";
								Ext.getCmp('unconfigTests').setValue([testName]);
								Ext.getCmp(clickedFrom).fireEvent('click', Ext.getCmp(clickedFrom));
								clickedFrom = '';
							}
						}
					}
				},
				failure: function()
				{
					myMask.hide();
				}
			});
		}
	},
	testTypeChangeEvent: function() {
		if (!Ext.isEmpty(Ext.getCmp('paramsContainer')) && Ext.getCmp('paramsContainer').show())
		{
			Ext.getCmp('paramsContainer').removeAll();
			Ext.getCmp('paramsContainer').hide();
			Ext.getCmp('updateBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').setDisabled(true);
			Ext.getCmp('applyToOtherBtn').hide();
			Ext.getCmp('validateBtn').setDisabled(true);
			Ext.getCmp('validateBtn').hide();
			Ext.getCmp('snmpUtil').setDisabled(true);
			Ext.getCmp('snmpUtil').hide();
			Ext.getCmp('bottomToolBar').hide();
		}
		if (Ext.getCmp('linkContainer').isVisible())
		{
			Ext.getCmp('linkContainer').hide();
		}
		if (Ext.getCmp('enableCsContainer').isVisible())
		{
			Ext.getCmp('enableCsContainer').hide();
		}
		if (Ext.getCmp('disableCsContainer').isVisible())
		{
			Ext.getCmp('disableCsContainer').hide();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var compNameVal = Ext.getCmp('componentName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		var backBtnFrom = Ext.getCmp('backbutton').btnFrom;

		if (Ext.getCmp('noAgentMsgContainer').isVisible())
		{
			Ext.getCmp('noAgentMsgContainer').hide();
		}
		var gridVisible = Ext.getCmp('agentDetailsGrid');
		if (gridVisible.isVisible())
		{
			gridVisible.hide();
		}
		if(Ext.isEmpty(compTypeVal) && Ext.isEmpty(compNameVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal)  && Ext.isEmpty(compNameVal))
		{
			this.compTypeChangeEvent();
		}
		else
		{
			if (testType != testTypeVal)
			{
				clickedFrom = '';
				testName = '';
			}

			var isChecked = Ext.getCmp('unconfiguredCompType').getValue();
			var showUnconfigCompType = 'false';
			if (isChecked)
			{
				showUnconfigCompType = 'true';
			}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
		myMask.show();

			testType = testTypeVal;
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&componentName='+encodeURIComponent(compNameVal)+'&testType='+encodeURIComponent(testTypeVal)+'&showUnconfigCompType='+encodeURIComponent(showUnconfigCompType)+'&reqfrom='+backBtnFrom,
				method:'post',
				scope:this,
				timeout: 120000,
				success:function(response)
				{
					myMask.hide();
					var jsonText = response.responseText;
					if(response.status == 200 && !Ext.isEmpty(jsonText))
					{
						publicJson = Ext.decode(jsonText);
						hide_process_service_button=publicJson['isContainerApp'];

						var allCompAccess = publicJson['allCompAccess'];

						if (!allCompAccess)
						{
							Ext.getCmp('enableDisableBtn').hide();
						}
						else
						{
							Ext.getCmp('enableDisableBtn').show();
							Ext.getCmp('enableDisableBtn').update(publicJson['enableDisableTestPageLabel']);
						}
						var noAgentMsg = publicJson['NoAgentMsg'];
						var gridVisible = Ext.getCmp('agentDetailsGrid');

						if (!Ext.isEmpty(noAgentMsg))
						{
							if (Ext.getCmp('noAgentMsgContainer').isHidden())
							{
								Ext.getCmp('noAgentMsgContainer').show();
								Ext.getCmp('noMAgentMsgLabel').update(noAgentMsg);
							}
						}
						var agentDetailsArr = publicJson['agentDetailsArr'];
						if (!Ext.isEmpty(agentDetailsArr))
						{
							if (!gridVisible.isVisible())
							{
								gridVisible.show();
								//gridVisible.collapse();
							}
							Ext.getCmp('agentDetailsGrid').getStore().loadRawData(publicJson['agentDetailsArr']);
						}
						Ext.getCmp('unconfigTests').getStore().removeAll();
						Ext.getCmp('unconfigTests').getStore().loadRawData(publicJson['unconfigTestsArr']);
						Ext.getCmp('configTests').getStore().removeAll();
						Ext.getCmp('configTests').getStore().loadRawData(publicJson['userConfigTestsArr']);
						Ext.getCmp('excludeTests').getStore().removeAll();
						Ext.getCmp('excludeTests').getStore().loadRawData(publicJson['excludeTestsArr']);
					}

					if ( !Ext.isEmpty( clickedFrom )  && clickedFrom != undefined)
					{
						if (clickedFrom == 'reconfigurebutton')
						{
							fromApply = "reconfig";
							Ext.getCmp('configTests').setValue([testName]);
							Ext.getCmp(clickedFrom).fireEvent('click', Ext.getCmp(clickedFrom));
							clickedFrom = '';
						}
						else
						{
							fromApply = "config";
							Ext.getCmp('unconfigTests').setValue([testName]);
							Ext.getCmp(clickedFrom).fireEvent('click', Ext.getCmp(clickedFrom));
							clickedFrom = '';
						}
					}
				},
				failure: function()
				{
					myMask.hide();
				}
			});
		}
	},
	encodeFieldParamsForQryString: function(qryStringObj)
	{
		var qryStringObj = Ext.Object.fromQueryString(params,true);

		var encodeParams = "";
		for (var property in qryStringObj)
		{
			var fieldParamName = property;
			var fieldParamValue = qryStringObj[property];
			if(Ext.isEmpty(fieldParamName))
			{
				continue;
			}
			encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(encodeMultiChars(fieldParamValue)));
		}
		return encodeParams;
	},
	encodeFieldParams: function(thisForm){
		var encodeParams = "";
		var fieldsArr = thisForm.getFields().items;
		var encodeParamList = publicJson['encodeParamList'];
		for(var i in fieldsArr)
		{
			var fieldParamName = fieldsArr[i].name;
			var fieldParamValue = fieldsArr[i].value;

			if (Ext.isArray(fieldParamValue))
			{
				fieldParamValue = fieldParamValue.toString();
			}

			if(Ext.isEmpty(fieldParamName) || fieldsArr[i].disabled || !me.isExistsParam(encodeParamList,fieldParamName))
			{
				continue;
			}
			Ext.getCmp(fieldsArr[i].id).submitValue = false;
			encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(encodeMultiChars(fieldParamValue)));
		}
		return encodeParams;
	},
	isExistsParam: function(array, item) {
		var i, ln;
		for (i = 0, ln = array.length; i < ln; i++) {
			if (array[i] === item) {
				return true;
			}
		}
		return false;
	},
	userScriptFileReceiver: function()
	{
		var me = this;
		var url = 'SpecificTestConfiguration/data/ScriptFileReceiverJson.jsp';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 900000,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var userScriptFileArr = jsonData['userScriptFileArr'];
					Ext.widget('window', {
						title: 'Choose Script name',
						width: 500,
						height: 240,
						id: 'scriptfile',
						name: 'scriptfile',
						resizable: 'false',
						modal:true,
						dockedItems: [
							{
								dock: 'bottom',
								layout:{
									type:'hbox',
									align:'stretch',
									pack:'center'
								},
								border:false,
								padding : '10 10 5 10',
								items: [
									{
										xtype: 'button',
										text: 'Submit',
										cls: 'quickMenuWhiteButton',
										id: 'applyBtn',
										name: 'applyBtn',
										action: 'apply',
										width: 80,
										handler: function (button, e)
										{
											var userNameStr = Ext.getCmp('userScriptFile').getValue();
											var selScriptfiles = Ext.getCmp('Script_name').getValue();
											if (selScriptfiles[0] == 'none')
											{
												selScriptfiles.splice(0,1);
											}
											var selScriptFileStr = selScriptfiles.toString().split(",");

											for (var y=0; y<selScriptFileStr.length; y++)
											{
												var selFileName = selScriptFileStr[y];
												if (selFileName.endsWith("#^#"+userNameStr))
												{
													Ext.Array.remove(selScriptfiles,selFileName);
												}
											}

											var userScriptFileName = Ext.getCmp('userScriptFileName').getValue();
											for (var x=0; x<userScriptFileName.length; x++)
											{
												var fileName = userScriptFileName[x];
												if (!Ext.Array.contains(selScriptfiles,fileName))
												{
													selScriptfiles.push(fileName);
												}
											}

											Ext.getCmp('Script_name').setValue(selScriptfiles);

											var result = Ext.getCmp("resultId");
											result.show();
											Ext.select(".iconClosePopup").on("click", function() 
											{
												result.hide();
											}, this);
											var delayTask = new Ext.util.DelayedTask(function() 
											{
												result.hide();
											});
											delayTask.delay(2000);
										}
									}
								]
							}
						],
						items: [
							{
								xtype: 'form',
								height: 165,
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									width: 400,
									labelWidth: 75
								},
								items: [
									{
										xtype: "component",
										id: "resultId",
										margin: '10 0 5 10',
										hidden: true,
										html: '<table border="0" class="popupAlertUser" width="100%"><tr><td><div class="iconRight" style="margin:4px;float:left"></div><div style="margin:4px;float:left">Changes have been updated successfully.</div></div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'userScriptFile',
										name: 'userScriptFile',
										fieldLabel: "User Name",
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										//labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										margin: '10 0 5 10',
										listeners: {
											afterrender: function()
											{
												var userScriptFileObj = Ext.getCmp('userScriptFile');
												userScriptFileObj.getStore().loadRawData(userScriptFileArr);
												userScriptFileObj.setValue(userScriptFileArr[0].valueField);
												var userScriptFileVal = Ext.getCmp('userScriptFile').getValue();
												var url = 'SpecificTestConfiguration/data/ScriptFileReceiverJson.jsp?userScriptFile='+encodeURIComponent(filterEncode(userScriptFileVal));
												Ext.Ajax.request({
													url: url,
													method: 'POST',
													timeout: 900000,
													scope: this,
													success: function (response) 
													{
														if (response.status == 200 && !Ext.isEmpty(response.responseText))
														{
															var jsonText = response.responseText;
															var jsonData = Ext.decode(jsonText);
															var scriptFileNameArr = jsonData['scriptFileNameArr'];
															var userScriptFileNameObj = Ext.getCmp('userScriptFileName');
															var selScriptfiles = Ext.getCmp('Script_name').getValue();
															var selScriptfileArr = new Array();
															for (var y=0; y<selScriptfiles.length; y++)
															{
																var selFileName = selScriptfiles[y];
																if (selFileName.endsWith("#^#"+userScriptFileVal))
																{
																	selScriptfileArr.push(selFileName);
																}
															}
															userScriptFileNameObj.getStore().loadRawData(scriptFileNameArr);
															userScriptFileNameObj.setValue(selScriptfileArr);
														}
													}
												});
											},
											select: function()
											{
												var userScriptFileVal = Ext.getCmp('userScriptFile').getValue();
												var url = 'SpecificTestConfiguration/data/ScriptFileReceiverJson.jsp?userScriptFile='+encodeURIComponent(filterEncode(userScriptFileVal));
												Ext.Ajax.request({
													url: url,
													method: 'POST',
													timeout: 900000,
													scope: this,
													success: function (response) 
													{
														if (response.status == 200 && !Ext.isEmpty(response.responseText))
														{
															var jsonText = response.responseText;
															var jsonData = Ext.decode(jsonText);
															var scriptFileNameArr = jsonData['scriptFileNameArr'];
															var userScriptFileNameObj = Ext.getCmp('userScriptFileName');
															var selScriptfiles = Ext.getCmp('Script_name').getValue();
															var selScriptfileArr = new Array();
															for (var y=0; y<selScriptfiles.length; y++)
															{
																var selFileName = selScriptfiles[y];
																if (selFileName.endsWith("#^#"+userScriptFileVal))
																{
																	selScriptfileArr.push(selFileName);
																}
															}
															userScriptFileNameObj.getStore().loadRawData(scriptFileNameArr);
															userScriptFileNameObj.setValue(selScriptfileArr);
														}
													}
												});
											}
										}
									},
									{
										xtype: 'multiselectSi',
										cls: 'multiselect',
										id : 'userScriptFileName',
										name: 'userScriptFileName',
										fieldLabel: "Script File",
										//columnWidth: 0.90,
										height: 100,
										queryMode: 'local',
										displayField: 'displayField',
										valueField: 'valueField',
										editable: false,
										parent:this,
										value: '',
										margin: '10 0 10 10',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									}
								]
							}]
					}).show();
				}
			}
		});
	},
	configureDskSpcTstAtmtnRules: function(btn) 
	{
		this.getController('SpecificTestConfiguration.controller.FunctionController').configureDskSpcTstAtmtnRules();
	},
});

function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,6}(\.[0-9]{1,2})?$/;
	var ret = regExp.test(val);
	return ret;
}

function JMXParamDisable(obj){
	if (obj != null && obj != undefined)
	{
		obj.setDisabled(true);
		obj.hide();
	}
}

function JMXParamEnable(obj){
	if (obj != null && obj != undefined)
	{
		obj.setDisabled(false);
		//obj.reset();
		obj.show();
	}
}

function passwordParamEnabled (pwdParamSetList,checkParamSet,obj)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return false;
	}

	var result = false;
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				obj.reset();
				result = true;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				obj.reset();
				result = true;
				break;
			}
		}
	}
	return result;
}

function isPasswordProfileEnabled (pwdParamSetList,checkParamSet)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return false;
	}

	var result = false;
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = true;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = true;
				break;
			}
		}
	}
	return result;
}

function getPwdProfileParamName (pwdParamSetList,checkParamSet)
{
	var pwdProfile = '';
	if (!Ext.isEmpty(pwdParamSetList))
	{
		for (var strParamName in pwdParamSetList)
		{
			var strParamSetKey =  pwdParamSetList[strParamName];
			if (Ext.isEmpty(strParamSetKey))
			{
				continue;
			}

			if(strParamSetKey == checkParamSet)
			{
				pwdProfile = strParamName;
				break;
			}
		}
	}
	return pwdProfile;
}

function passwordParamDisabled (pwdParamSetList,checkParamSet)
{
	if (Ext.isEmpty(pwdParamSetList))
	{
		return ;
	}

	var result = '';
	for (var strParamName in pwdParamSetList)
	{
		var strParamSetKey =  pwdParamSetList[strParamName];
		if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase() == checkParamSet.toLowerCase())
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = strParamName;
				break;
			}
		}
		else if ( !Ext.isEmpty(strParamSetKey) &&
			strParamSetKey.toLowerCase().endsWith(','+checkParamSet.toLowerCase()) ||
			strParamSetKey.toLowerCase().indexOf(','+checkParamSet.toLowerCase()+',') != -1 ||
			strParamSetKey.toLowerCase().startsWith(checkParamSet.toLowerCase()+','))
		{
			var strParamValue  = Ext.getCmp(strParamName).getValue();
			if ( !Ext.isEmpty(strParamValue) && strParamValue.toLowerCase() != 'none' && strParamValue.toLowerCase() != '-1')
			{
				result = strParamName;
				break;
			}
		}
	}
	return result;
}

function setNoneForDependsParams(arrObj)
{
	if (!Ext.isEmpty(arrObj))
	{
		for (var a=0;a<arrObj.length;a++ )
		{
			var strParams = arrObj[a];
			var paramsObj = Ext.getCmp(strParams);
			if (!Ext.isEmpty(paramsObj))
			{
				if (strParams.toLowerCase() == 'inside_view_using')
				{
					continue;
				}
				else
				{
					paramsObj.setValue('None');
				}
			}
		}
	}
}

function showToPwdProfile(pwdProfileList,isShow) 
{
	if (!Ext.isEmpty(pwdProfileList))
	{

		for (var s=0;s<pwdProfileList.length;s++ )
		{
			var strshowParam = pwdProfileList[s];
			if (!Ext.isEmpty(strshowParam))
			{
				if (isShow)
				{
					Ext.getCmp(strshowParam).show();
					Ext.getCmp(strshowParam).setDisabled(false);
				}
				else
				{
					Ext.getCmp(strshowParam).setDisabled(true);
					Ext.getCmp(strshowParam).hide();
				}
			}
		}
	}
}

function isMultiUserParamExists (multiUserReadOnlyParam,searchParam)
{
	var isParamExists = false;
	if (!Ext.isEmpty(multiUserReadOnlyParam))
	{
		var multiUserParamsArray = multiUserReadOnlyParam.split(',');
		for (var mul=0;mul<multiUserParamsArray.length ;mul++ )
		{
			var strMultiUserParam = multiUserParamsArray[mul];
			if (strMultiUserParam.toLowerCase() == searchParam.toLowerCase())
			{
				isParamExists = true;
				break;
			}
		}
	}
	return isParamExists;
}

function checkParamIsUserField(paramName)
{
	var isUserNameParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isUserNameParamExists;
	}

	if (paramName.toLowerCase() == 'user' ||  
		paramName.toLowerCase() == 'username' ||
		paramName.toLowerCase() == 'user_name' ||
		paramName.toLowerCase() == 'user' ||
		paramName.toLowerCase() == 'username' ||
		paramName.toLowerCase() == 'user_name' ||
		paramName.toLowerCase() == 'exchange_sender' ||
		paramName.toLowerCase() == 'sender' ||
		paramName.toLowerCase() == 'o365_sender' ||
		paramName.toLowerCase() == 'exchange_receiver' ||
		paramName.toLowerCase() == 'o365_receiver' ||
		paramName.toLowerCase() == 'receiver' ||
		paramName.toLowerCase().indexOf('emailid') != -1 ||
		paramName.toLowerCase().indexOf('user') != -1)
	{
		isUserNameParamExists = true;
	}
	return isUserNameParamExists;
}

function checkParamIsDomainField(paramName)
{
	var isDomainParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isDomainParamExists;
	}

	if (paramName.toLowerCase() == 'domain' ||  
		paramName.toLowerCase() == 'domainname' ||
		paramName.toLowerCase() == 'domain_name' ||
		paramName.toLowerCase().endsWith('domain') ||
		paramName.toLowerCase().endsWith('domain_name') ||
		paramName.toLowerCase().endsWith('domainname'))
	{
		isDomainParamExists = true;
	}
	return isDomainParamExists;
}

function checkParamIsPasswordField(paramName)
{
	var isPasswordParamExists = false;
	if (Ext.isEmpty(paramName))
	{
		return isPasswordParamExists;
	}

	if (paramName.toLowerCase() == 'password' ||  
		paramName.toLowerCase().endsWith('password') ||
		paramName.toLowerCase().indexOf('pass') != -1 ||
		paramName.toLowerCase().indexOf('password') != -1)
	{
		isPasswordParamExists = true;
	}
	return isPasswordParamExists;
}

function resetShowHide(){
		Ext.getCmp('fullyQalifiedClassName').setValue('');
		Ext.getCmp('methodName').setValue('');
		Ext.getCmp('methodSignature').setValue('');
		Ext.getCmp('methodArgsIndex').setValue('');
		Ext.getCmp('fetchOnce').setValue(false);
		Ext.getCmp('sessionAttRequestParms').setValue('');
		Ext.getCmp('passRequestObj').setValue(false);
		Ext.getCmp('exeStartTrans').setValue(false);
}

function appendParams(params, key, value){
	params = params+"&"+key+"="+encodeURIComponent(value);
	return params;
}