Ext.define('UserProfile.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [{
        selector: 'main',
        ref: 'main'
    }, {
        selector: 'userdetails',
        ref: 'userdetails'
    }, {
        selector: 'alarmssettings',
        ref: 'alarmssettings'
    }, {
        selector: 'monitorsettings',
        ref: 'monitorsettings'
    },{
		selector:'dailyemailsettings',
		ref:'dailyemailsettings'
	},
	{
		selector:'userlogininfo',
		ref:'userlogininfo'
	}],
    init: function () {
		thisCtrl = this;
        this.control({

            'main': {
				'afterrender': this.userProfileDefaultLoad
            },
            'alarmssettings button[action=view]': {
                click: this.viewData
            },
           /*'alarmssettings button[id=high]': {
                click: this.checkAlarmType
            },
            'alarmssettings button[id=medium]': {
                click: this.checkAlarmType
            },
            'alarmssettings button[id=low]': {
                click: this.checkAlarmType
            },*/
			 'monitorsettings button[action=daily_mail]': {
                click: this.openDailyMail
            },
            'monitorsettings button[action=save]': {
                click: this.saveData
            },
            'monitorsettings button[action=mailFilter]': {
                click: this.showMailFilter
            },
            'monitorsettings combo[id=loginpage]': {
                select: this.loginLogo
            },
            'monitorsettings combo[id=monitorpage]': {
                select: this.monitorLogo
            },
            'monitorsettings combo[id=reporter]': {
                select: this.reporterLogo
            },
            'monitorsettings combo[id=configuration]': {
                select: this.configLogo
            },
            'monitorsettings button[action="loginFile"]': {
                click: this.showuploadlogin
            },
            'monitorsettings button[action="monitorFile"]': {
                click: this.showuploadmon
            },
            'monitorsettings button[action="reportFile"]': {
                click: this.showuploadreport
            },
            'monitorsettings button[action="configFile"]': {
                click: this.showuploadconfig
            },
            'monitorsettings checkbox[id="apply"]': {
                change: this.applyToModule
            },
            'alarmssettings radio[id="htmode"]': {
                change: this.setMeasureInMailMode
            },
			'userdetails textfield[id="newPwd"]':
			{
				'change': this.passStrength
            },
			'alarmssettings radio[id="isnew"]': {
                change: this.setDDInMailMode
            },
			'dailyemailsettings scrollcombo[id="applied_by"]':{
				'change':this.loadDmsDetails
			},
			'dailyemailsettings scrollcombo[id="temp_name"]':{
				'select':this.loadEmailTypes
			},
			'dailyemailsettings button[id="sm_button"]':{
				'click':this.insertDmdDeatils
			},
			'dailyemailsettings multiselectfield[id="el_component"]':{
				'change':this.loadDmsCompDetails
			},
			// 2fa
			'monitorsettings radio[id="enable2FAYesFlag"]': {
				change: this.show2FAOTPModeCnt
			},
			// 2fa
			'monitorsettings checkbox[id="defaulttimeZone"]': {
                		'change': this.setDefaulttimeZone
            		},
        });
    },
	encodeFieldParams: function(thisForm)
	{
		var encodeParams = "";
		var fieldsArr = thisForm.getFields().items;
		
		for(var i in fieldsArr)
		{
			var fieldParamName = fieldsArr[i].name;
			var fieldParamValue = fieldsArr[i].value;
			if (Ext.isArray(fieldParamValue))
			{
				fieldParamValue = fieldParamValue.toString();
			}

			if(Ext.isEmpty(fieldParamName) || fieldsArr[i].disabled)
			{
				continue;
			}
			Ext.getCmp(fieldsArr[i].id).submitValue = false;
			encodeParams += "&"+fieldParamName+"="+encodeURIComponent(filterEncode(fieldParamValue));
		}
		return encodeParams;
	},
	changePwdWindow: function()
	{
		Ext.widget('window', {
			title: 'User Profile - Change Password',
			width: '700px',
			padding:'5 10 10 10',
			modal: true,
			items: [
				{
					xtype: 'form',
					id: 'passwordform',
					layout: {
						type: 'vbox',
						align: 'center'
					},
					items: [
					{
						xtype:"container",id:"paramsContainer",title:"",layout:{type:"vbox",pack:"center",align:"center"},defaults:{labelSeparator:" ",margin:5,width:550,labelWidth:250},margin:"15 0 10 0",
						items: [
						{
							fieldLabel: 'Existing Password',
							labelClsExtra:'font_bold',
							xtype: 'textfield',
							id: 'oldPwd',
							name: 'oldPwd',
							columnWidth:.20,
							labelSeparator: '',
							cls: 'textbox', // size
							inputType: 'password'
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'New Password',
							labelClsExtra:'font_bold',
							labelSeparator: '',
							id : 'pasCont',
							layout: {
								type: 'vbox',
								pack: 'start',
								align: 'stretch'
							},
							columnWidth:.20,
							items: [
								{
									xtype: 'textfield',
									allowBlank: false,
									id: 'newPwd',
									name: 'newPwd',
									cls: 'textbox',
									inputType: 'password',
									listeners:{
										blur :function()
										{
											Ext.getCmp('passScore').hide();
										},
										focus:function()
										{
											if(publicJsonData['editMailID']){
												Ext.getCmp('passScore').show();
											}
										},
										change: function()
										{
											thisCtrl.passStrength();
										}
									}
								},
								{
									xtype:'label',
									id: 'passScore',
									name: 'passScore',
									textAlign: 'left',
									cls: 'font_normal9',
									hidden:true
								}
							]
						},
						{
							fieldLabel: 'Confirm New Password',
							labelClsExtra:'font_bold',
							xtype: 'textfield',
							id: 'confPwd',
							name: 'confPwd',
							columnWidth:.20,
							labelSeparator: '',
							cls: 'textbox', // size
							inputType: 'password'

						}
						]
					}
					],
					dockedItems:[{
						xtype:'toolbar',
						dock: 'bottom',
						padding:10,
						margin:'5 0 0 0',
						layout:{
							type: 'hbox',
							pack: 'center'
						},
						ui:'toolbarBgWithTopBorder',
						items: [
							{
								xtype: 'button',
								text: 'Update',
								itemId: 'updatePwdBtn',
								action: 'updatePwdBtn',
								ui:'newButtonSmall', 
								align: 'center',
								handler: function (button, e)
								{
									thisCtrl.updateUserPassword();
								}
							}
						]
					}]
				}
			]
		}).show();
	},
	updateUserPassword: function()
	{
		var oldPwd_Obj = Ext.getCmp('oldPwd');
		var oldPwdObj = Ext.getCmp('oldPwd').getValue();
		oldPwdObj = Ext.String.trim(oldPwdObj);
		
		var str_upass_obj = Ext.getCmp('newPwd');
		var str_upass = Ext.getCmp('newPwd').getValue();
		str_upass = Ext.String.trim(str_upass);
		
		var confPwd_Obj = Ext.getCmp('confPwd');
		var confPwdObj = Ext.getCmp('confPwd').getValue();
		confPwdObj = Ext.String.trim(confPwdObj);

        var new_pwd = true;
		var isDouble = publicJsonData['isDouble'];
        if (isDouble == "false")
            new_pwd = validateSingleByte(str_upass);
		
		var isDomainUser = publicJsonData['isDomainUser'];
		var pwdLength = publicJsonData['pwdLength'];
		var pwdComplexity = "true";
		var pwdComplexityLength = publicJsonData['pwdComplexityCount'];
		var userName = publicJsonData['userName'];
		if(isDomainUser!=null && isDomainUser=="false")
		{
			pwdComplexity = thisCtrl.pwdComplexityCheck(str_upass);
		}
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityLength)
		{
			pwdLength = pwdComplexityLength;
		}
		var domainUsr=false;
		if(isDomainUser!=null && isDomainUser=="true")
			domainUsr = true;

		if(domainUsr)
		{
			oldPwdObj='';
			str_upass='';
			confPwdObj='';
		}

		if (!domainUsr && Ext.isEmpty(oldPwdObj))
		{
            Ext.Msg.show({
                title: pageTitle,
                msg: oldpwd,
                buttons: Ext.Msg.OK,
				width: 350,
                icon: Ext.Msg.WARNING,
				fn : function(btn){
					oldPwd_Obj.focus(true,true);
				}
            });
            return;
		}
		else if (!domainUsr && Ext.isEmpty(str_upass)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: password,
                buttons: Ext.Msg.OK,
				width: 350,
                icon: Ext.Msg.WARNING,
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
            });
            return;
        }
		else if (!domainUsr && Ext.String.trim(oldPwdObj.toLowerCase()) == Ext.String.trim(str_upass.toLowerCase())) {
            Ext.Msg.show({
                title: pageTitle,
                msg: existingpassMsg,
                buttons: Ext.Msg.OK,
				width: 350,
                icon: Ext.Msg.WARNING,
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
            });
            return;
        }
		else if (!domainUsr && Ext.String.trim(userName.toLowerCase()) == Ext.String.trim(str_upass.toLowerCase()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userpassMsg,
				buttons: Ext.Msg.OK,
				width: 350,
				icon: 'iconExclamation',
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
			});
			return;
		}
		else if (!domainUsr && Ext.isEmpty(confPwdObj)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: cpwd,
                buttons: Ext.Msg.OK,
				width: 350,
                icon: Ext.Msg.WARNING,
				fn : function(btn){
					confPwd_Obj.focus(true,true);
				}
            });
            return;
        } 
		else if (!domainUsr && (!Ext.isEmpty(str_upass) && !Ext.isEmpty(confPwdObj) && str_upass != confPwdObj))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pwdmatch,
				buttons: Ext.Msg.OK,
				width: 350,
				icon: Ext.Msg.WARNING,
				fn : function(btn){
					confPwd_Obj.focus(true,true);
				}
            });
			return;
		}
		else if(!checkloginpass(str_upass))
		{
			str_upass_obj.focus();
			return;
		}
		else if (!domainUsr && (!Ext.isEmpty(str_upass) && (str_upass).length < pwdLength))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: passLabel1+" "+pwdLength+" "+passLabel2,
				buttons: Ext.Msg.OK,
				width: 350,
				icon: Ext.Msg.WARNING,
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
			});
			return;
		}
		/*
		 * Password complexity validation - STARTS
		 * by Meena.V
		 */
		else if(!domainUsr && (!Ext.isEmpty(str_upass) && pwdComplexity.indexOf("false") > -1))
		{
			var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
			Ext.Msg.show({
				title: pageTitle,
				msg: alertForPwdComplexity5+". "+passLabel1+" "+resMsg+".",
				width : 400,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING,
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
			});
			return;
		}
		/*
		 * Password complexity validation - ENDS
		 */ 
		else if (!domainUsr && !new_pwd)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pwdbyte,
				buttons: Ext.Msg.OK,
				width: 350,
				icon: Ext.Msg.WARNING,
				fn : function(btn){
					str_upass_obj.focus(true,true);
				}
			});
			return;
		}

		var formObj = Ext.getCmp('passwordform');
		myMask = new Ext.LoadMask(formObj, {msg:"Updating..."});
		if (formObj.getForm().isValid())
		{
			myMask.show();
			var frmMain = formObj.getForm();
			formObj.getForm().submit({
				url:'UserProfile/data/userCredp.jsp?',
				method:'POST',
				params: thisCtrl.encodeFieldParams(frmMain),
				//async : false,
				scope:this,
				success: function (form, action) {
					if (action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
					{
						myMask.hide();
						var jsonText = action.response.responseText;
						var publicJson = Ext.decode(jsonText);
						if (publicJson['Msg']=='User password updated successfully')
						{
							Ext.Msg.show({
								title:publicJson['Title'],
								msg:publicJson['Msg'],
								buttons: Ext.Msg.OK,
								icon: "iconInformation",
								fn: function () 
								{
									formObj.up('.window').close();
								}
							});
						}
						else
						{
							Ext.Msg.show({
								title:publicJson['Title'],
								msg:publicJson['Msg'],
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function(){
									if (publicJson['Msg']=='Existing password is incorrect')
									{
										oldPwd_Obj.focus(true,true);
									}
									else
									{
										str_upass_obj.focus(true,true);
									}
								}
							});
						}
					}
				},
				failure: function (form, action) {
					myMask.hide();
					Ext.Msg.show({
						title: 'User Profile - Change Password',
						msg: 'failure',
						width: 350,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							formObj.up('.window').close();
						}
					});
				}
			});
		}
	},
	setDefaulttimeZone:function(checkbox)
	{
		var timeZoneCombo=Ext.getCmp('timeZone');
		timeZoneCombo.getStore().loadRawData('');
		timeZoneCombo.getStore().loadRawData(publicJsonData['timeZone']);
		if(checkbox != null && checkbox != undefined && checkbox != 'undefined' && checkbox.checked )
		{
			var managerTimeZone = publicJsonData['managerTimeZone'];
			if(managerTimeZone != '' && managerTimeZone != null && managerTimeZone != undefined && managerTimeZone != 'undefined')
			{			
				timeZoneCombo.setValue(publicJsonData['managerTimeZone']);
				timeZoneCombo.setDisabled(true);
			}
		}
		else if(!checkbox.checked)
		{			
			timeZoneCombo.setValue(publicJsonData['selectedTimeZone']);
			timeZoneCombo.setDisabled(false);
		}
	},
	insertDmdDeatils:function(){

		var schedName = Ext.getCmp('schedName').getValue();
		if(schedName == null || schedName == undefined || schedName=="")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a report Name',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}else{
			if(specialCharacterCheck(schedName)){
				Ext.Msg.show({
					title : pageTitle,
					width:350,
					msg : reportNameError+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function()
					{
						Ext.getCmp('schedName').focus();
					}
				});
				return;
			}
		}
		var appliesTo = Ext.getCmp('appliesTo').getValue();
		if(appliesTo == null || appliesTo == undefined || appliesTo=="" || appliesTo=="-1")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Applies To ',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		
		if(appliesTo == 'Components')
		{
			var compObj = Ext.getCmp('el_component').getValue();
			if(compObj == null || compObj == undefined || compObj=="" || compObj.length == 0)
			{
				Ext.MessageBox.show({
					title : pageTitle,
					msg : 'Select valid '+appliesTo,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
				return;
			}
		}
		else
		{
			var applied_by = Ext.getCmp('applied_by').getValue();
			if(applied_by == null || applied_by == undefined || applied_by=="" || applied_by.indexOf("All") !=-1 || applied_by.indexOf("Select") != -1)
			{
				Ext.MessageBox.show({
					title : pageTitle,
					msg : 'Select valid '+appliesTo,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
				return;
			}
		}

		var temp_name = Ext.getCmp('temp_name').getValue();
		if(temp_name == null || temp_name == undefined || temp_name=="" || temp_name.toLowerCase().indexOf("select a template") != -1)
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Template Name',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}

		var email_type = Ext.getCmp('email_type').getValue();
		if(email_type == null || email_type == undefined || email_type=="" || email_type.toLowerCase().indexOf("select a email type") != -1)
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Email Type',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		
		var mailIdVal = Ext.getCmp('mailId').getValue();
		
		if(mailIdVal == null || mailIdVal == undefined || mailIdVal=="")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a valid Mail ID',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}

		if(!mailIdValidate(mailIdVal)){
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a valid Mail ID',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		var mail_type = Ext.getCmp('mail_type').getValue();
		
		var app_value = appliesTo+":"+applied_by;
		if(appliesTo == 'Components')
		{
			var compObj = Ext.getCmp('el_component').getValue();
			var selectedVal = '';
			for (var a in compObj )
			{
				selectedVal +=","+compObj[a];
			}
			if(selectedVal.indexOf(",")==0)
				selectedVal = selectedVal.substring(1);
			
			app_value = appliesTo+":"+selectedVal;
		}

		var timeval=Ext.getCmp('sc_hr').getValue()+":"+Ext.getCmp('sc_min').getValue();
		
		var op = 'add';
		var op_type=Ext.getCmp('sm_button').getText();
		if(op_type.indexOf("Update") != -1)
			op="edit";

		var url='/final/admin/UserProfile/data/userProfileDailyMail.jsp?insertDms=true&op='+op+'&schedName='+encodeURI(schedName)+'&temp_name='+encodeURI(temp_name)+'&app_value='+encodeURI(app_value)+'&mailIdVal='+encodeURI(mailIdVal)+'&email_type='+email_type+'&timeval='+encodeURI(timeval)+"&mail_type="+encodeURI(mail_type);
		Ext.Ajax.request({
			url: url,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(jsonData.status == 'success'){
						Ext.MessageBox.show({
							title : pageTitle,
							msg : 'Schedule Updated Successfully..',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING,
						});
						var tempGrid = Ext.getCmp('listGrid');
						var grid = jsonData.grid;
						var dbGridStore=Ext.create('Ext.data.Store',{
							fields:grid.fields,
							autoDestroy:true,
							proxy: {
								type: 'memory',
								reader: {
									type: 'json',
									root:'items'
								}
							},
							data:grid.data
						});
						tempGrid.reconfigure(dbGridStore,grid.columns);
						
						Ext.getCmp('sm_button').setText('<span class="font_bold"> Add </span>');
						Ext.getCmp('schedName').reset();
						//Ext.getCmp('dms_container_in').setDisabled(true);
						var appliesTo =  Ext.getCmp('appliesTo');
						appliesTo.reset();
						Ext.getCmp('applied_by').reset();
						Ext.getCmp('el_component').reset();
						Ext.getCmp('temp_name').reset();
						Ext.getCmp('email_type').reset();
						Ext.getCmp('sc_hr').reset();
						Ext.getCmp('sc_min').reset();
						Ext.getCmp('mailId').reset();

						Ext.getCmp('sc_hr').setValue("00");
						Ext.getCmp('sc_min').setValue("00");

						var value1 = appliesTo.getStore().getAt(1).get('valueField');
						appliesTo.setValue(value1);

					}else{
						Ext.MessageBox.show({
							title : pageTitle,
							msg : jsonData.status,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING,
						});
						return;
					}
				}
				editSuspend=false;
				if(editGridName != null && editGridName != undefined && editGridName != '' && jsonData.state != undefined && jsonData.state=='true')
				{
					deleteGridRow(editGridName);
					editGridName = undefined;
				}
			}
		});
	},
	loadEmailTypes:function(combo){
		//alert('dasad'+editValueSuspend)
		//if(editValueSuspend)
		//	return;
		var val = combo.getValue();
		if(val != undefined && val != null && val != -1){
			var value= combo.getValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			var applied_by = Ext.getCmp('applied_by').getValue();
			var addParam="&appliesTo="+appliesTo+"&applied_by="+applied_by;
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadEmailTemplateTypes=true&template='+value+addParam,
				scope:this,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData != undefined && jsonData.elements != undefined && jsonData.elements.length > 0){
							var el = jsonData.elements;
							Ext.getCmp('email_type').getStore().loadRawData(el);
							var value1 = Ext.getCmp('email_type').getStore().getAt(0).get('valueField');
							Ext.getCmp('email_type').setValue(value1);

							if(el.length == 1)
								Ext.getCmp('email_type').setDisabled(true);
							else
								Ext.getCmp('email_type').setDisabled(false);

						}
					}
				}
			});
		}
	},
	loadDmsCompDetails:function(combo){
		if(editValueSuspend)
			return;
		try
		{
			var compObj = Ext.getCmp('el_component').getValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			if(!Ext.isEmpty(compObj))
			{
				var value = compObj[0];
				var email_type = value.substring(0,value.indexOf(":"));
				Ext.getCmp('email_type').setValue(email_type);
				Ext.getCmp('email_type').setDisabled(true);
				Ext.getCmp('email_type').setVisible(false);
				Ext.getCmp('dms_container_in').updateLayout();

				var span_el = document.getElementById('view_temp_id');
			
				Ext.Ajax.request({
					url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadTemplates=true&appliesTo='+appliesTo+'&value='+value,
					scope:this,
					success: function (response) {
						if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if(jsonData != undefined && jsonData.elements != undefined){
								var elements = jsonData.elements;
								Ext.getCmp('temp_name').getStore().loadRawData(elements);
								var value1 = Ext.getCmp('temp_name').getStore().getAt(0).get('valueField');
								Ext.getCmp('temp_name').setValue(value1);
								//span_el.style.display='inline-block';
								this.loadEmailTypes(Ext.getCmp('temp_name'));
							}else{
								//span_el.style.display='none';
								Ext.getCmp('temp_name').getStore().loadRawData('');
								Ext.getCmp('temp_name').setRawValue('Select a template');
								Ext.getCmp('email_type').getStore().loadRawData('');
								Ext.getCmp('email_type').setRawValue('Select a email type');
								Ext.getCmp('email_type').setDisabled(false);
								//if(value.toLowerCase().indexOf('please') ==-1)
								//	Ext.Msg.alert('','Predefined templates are not available for this type.' );
							}
						}
					},
					failure:function(){

					}
				});
			}
		}
		catch (e)
		{
		}
		
	},
	loadDmsDetails:function(combo){
		if(editValueSuspend)
			return;
		var val = combo.getValue();
		if(val != undefined && val != null && val != -1){
			var value= combo.getValue();
			if(value=='All')
				return;
			var rawvalue= combo.getRawValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			
			if(appliesTo != null && appliesTo != undefined && appliesTo=='ComponentType')
			{
				Ext.getCmp('email_type').setValue(value);
				Ext.getCmp('email_type').setDisabled(true);
				Ext.getCmp('email_type').setVisible(false);
				Ext.getCmp('dms_container_in').updateLayout();
			}
			else
			{
				Ext.getCmp('email_type').setVisible(true);
				Ext.getCmp('dms_container_in').updateLayout();
			}


			var span_el = document.getElementById('view_temp_id');
			
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadTemplates=true&appliesTo='+appliesTo+'&value='+value,
				scope:this,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData != undefined && jsonData.elements != undefined){
							var elements = jsonData.elements;
							Ext.getCmp('temp_name').getStore().loadRawData(elements);
							var value1 = Ext.getCmp('temp_name').getStore().getAt(0).get('valueField');
							Ext.getCmp('temp_name').setValue(value1);
							//span_el.style.display='inline-block';
							this.loadEmailTypes(Ext.getCmp('temp_name'));
						}else{
							//span_el.style.display='none';
							Ext.getCmp('temp_name').getStore().loadRawData('');
							Ext.getCmp('temp_name').setRawValue('Select a template');
							Ext.getCmp('email_type').getStore().loadRawData('');
							Ext.getCmp('email_type').setRawValue('Select a email type');
							Ext.getCmp('email_type').setDisabled(false);
							//if(value.toLowerCase().indexOf('please') ==-1)
							//	Ext.Msg.alert('','Predefined templates are not available for this type.' );
						}
					}
				},
				failure:function(){

				}
			});
		}
	},
	openDailyMail:function(combo){
		var dew = Ext.getCmp('dailyEmailWin');
		if(dew == null || dew == undefined){
			try
			{
				Ext.Ajax.request({
					url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadAll=true',
					scope:this,
					success: function (response) {
						if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							Ext.create('UserProfile.view.dailyEmailWin').show();
							Ext.getCmp('applied_by').reset();
							Ext.getCmp('temp_name').reset();
							Ext.getCmp('email_type').reset();

							if(jsonData != undefined && jsonData.data != undefined){
								Ext.getCmp('dailyemailsettings').data=jsonData;
								var data =jsonData.data;
								var allInfo =jsonData.allInfo;
								if(allInfo.hr != null && allInfo.hr !=undefined)
									Ext.getCmp('sc_hr').getStore().loadRawData(allInfo.hr);
								if(allInfo.min != null && allInfo.min !=undefined)
									Ext.getCmp('sc_min').getStore().loadRawData(allInfo.min);
								
								Ext.getCmp('sc_hr').setValue('00');
								Ext.getCmp('sc_min').setValue('00');

								var combo = data['final'];
								if(combo != null && combo != undefined && combo.length > 0){
									var appliesTo = Ext.getCmp('appliesTo');
									if(appliesTo != null && appliesTo != undefined ){
										appliesTo.getStore().loadRawData(combo);
										var value1 ="";
										if(combo.length > 1)
											value1 = appliesTo.getStore().getAt(1).get('valueField');
										else
											value1 = appliesTo.getStore().getAt(0).get('valueField');
										appliesTo.setValue(value1);
									}
								}
								
								var mail_type = Ext.getCmp('mail_type');
								if(mail_type != null && appliesTo != undefined ){
									mail_type.getStore().loadRawData(jsonData.type);
									var value1 = mail_type.getStore().getAt(0).get('valueField');
									mail_type.setValue(value1);
								}

								var tempGrid = Ext.getCmp('listGrid');
								var grid = jsonData.grid;
								if(!Ext.isEmpty(grid) && !Ext.isEmpty(grid.data) && !Ext.isEmpty(grid.columns)){
									var dbGridStore=Ext.create('Ext.data.Store',{
										fields:grid.fields,
										autoDestroy:true,
										proxy: {
											type: 'memory',
											reader: {
												type: 'json',
												root:'items'
											}
										},
										data:grid.data
									});
									tempGrid.reconfigure(dbGridStore,grid.columns);
								}
							}
						}
					}
				});
			}
			catch (e)
			{
			}
		}
	},
	setDDInMailMode : function() {
		var typeVal = Ext.getCmp('isnew').getValue();
		if(typeVal == true || typeVal == 'true')
			Ext.getCmp('ddmail').setVisible(true);
		else
			Ext.getCmp('ddmail').setVisible(false);


	},
	showMailFilter : function() {
		var uName = publicJsonData['hiddenParams']['uname'];
		var userName = publicJsonData['userName'];
		var showAlert = publicJsonData['isMailConfigured'];
		var showMailFilterBtn = publicJsonData['showMailFilterBtn'];

		window.location.href =  "EgMailAlertFilter.jsp?qctr=1&dispUserName="+encodeURIComponent(filterEncode(uName))+"&showAlert="+showAlert+"&username="+encodeURIComponent(filterEncode(userName));
	},
	passStrength: function()
	{
		var pwdLength = publicJsonData.pwdLength;
		var pwdComplexityLength = publicJsonData.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityLength)
		{
			pwdLength = pwdComplexityLength;
		}
		var loginPassword = Ext.getCmp('newPwd').getValue();
		var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
		if (loginPassword.length >= pwdLength && regExp.test(loginPassword))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Strong);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp2))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Good);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp3))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Fair);
		}
		else if (loginPassword.length == 0)
		{
			Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		}
		else
		{
			Ext.getCmp('passScore').setText(passStr+': '+Weak);
		}
	},
	pwdComplexityCheck : function(loginPassword)
	{
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		var pwdComplexity = publicJsonData.pwdComplexity;
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			if(pwdComplexity.indexOf(",") > -1)
			{
				result = "false#";
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase().trim();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity1;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity2;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity3;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity4;
					}
				}
			}
			else
			{
				result = "false#";
				var temp = pwdComplexity.toString().toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result +=  alertForPwdComplexity1;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  alertForPwdComplexity2;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  alertForPwdComplexity3;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  alertForPwdComplexity4;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},
	userProfileDefaultLoad: function () {
		this.getUserdetails().loadDefaultData();
		this.getAlarmssettings().loadalrmData();
		this.getMonitorsettings().loadmonitorData();
		//this.checkAlarms();
		this.hideCustomLogo();
		this.applyToModule();
		
		var lastLoginTime = publicJsonData['lastLoginTime'];
		var lastLogoutTime = publicJsonData['lastLogoutTime'];
		var isDomainUser = publicJsonData['isDomainUser'];
		
		var lastloginObj = Ext.getCmp('lastlogin');
		var lastlogoutbj = Ext.getCmp('lastlogout');
		var lastpwdchangeObj = Ext.getCmp('lastpwdchange');
		if(isDomainUser != null && isDomainUser == "true")
		{
			lastpwdchangeObj.hide();
			
			if (!Ext.isEmpty(lastLoginTime) && lastLoginTime != '-')
			{
				lastloginObj.show();
				lastlogoutbj.show();
				lastloginObj.setValue(lastLoginTime);
				lastlogoutbj.setValue(lastLogoutTime);
			}
			else
			{
				lastloginObj.hide();
				lastlogoutbj.hide();
				Ext.getCmp('userlogininfo').hide();
			}
		}
		else
		{	
			var lastPwdChangeTime = publicJsonData['lastPwdChangeTime'];
			if (!Ext.isEmpty(lastLoginTime) && lastLoginTime == '-' &&
			!Ext.isEmpty(lastLogoutTime) && lastLogoutTime == '-' &&
			!Ext.isEmpty(lastPwdChangeTime) && lastPwdChangeTime == '-')
			{
				Ext.getCmp('userlogininfo').hide();
			}
			else
			{
	
				if (!Ext.isEmpty(lastLoginTime) && lastLoginTime != '-')
				{
					lastloginObj.show();
					lastlogoutbj.show();
					lastloginObj.setValue(lastLoginTime);
					lastlogoutbj.setValue(lastLogoutTime);
				}
				else
				{
					lastloginObj.hide();
					lastlogoutbj.hide();
				}
				
				if (!Ext.isEmpty(lastPwdChangeTime) && lastPwdChangeTime != '-')
				{
					lastpwdchangeObj.show();
					lastpwdchangeObj.setValue(lastPwdChangeTime);
				}
				else
				{
					lastpwdchangeObj.hide();
				}
			}
		}
		if (publicJsonData.showMailFilterBtn)
		{
			Ext.getCmp('mailFilterBtn').show();
		}
		else
		{
			Ext.getCmp('mailFilterBtn').hide();
		}
		
		try
		{
			var dmsData = publicJsonData.dmsSchedules;
			var compObj = Ext.getCmp('emailType');
			if(compObj != null && compObj != undefined && dmsData != null && dmsData != undefined && dmsData.length > 0){
				compObj.getStore().loadRawData(dmsData);
				compObj.setValue("-1");
			}
		}
		catch (e)
		{
		}

	},

    checkAlarmType: function (button) {

        var highstate = Ext.getCmp('high').pressed;
        var mediumstate = Ext.getCmp('medium').pressed;
        var lowstate = Ext.getCmp('low').pressed;

        if (highstate == false && mediumstate == false && lowstate == false) {
            Ext.getCmp('isnew').setValue(false);
            Ext.getCmp('iscomp').setValue(false);
            Ext.getCmp('htmode').setValue(false);
            Ext.getCmp('txtmode').setValue(false);
        }


    },

    checkAlarms: function () {

        if (Ext.getCmp('high').pressed != null && Ext.getCmp('medium').pressed != null && Ext.getCmp('low').pressed != null && Ext.getCmp('isnew').checked != null && Ext.getCmp('iscomp').checked != null) {
            if (!Ext.getCmp('high').pressed && !Ext.getCmp('medium').pressed && !Ext.getCmp('low').pressed) {
                Ext.getCmp('isnew').setValue(true);
                Ext.getCmp('htmode').setValue(true);
            }
        }
    },

    setMeasureInMailMode: function () {
        var htmodeVal = Ext.getCmp('htmode').getValue();
        var messagemodeObj = Ext.getCmp('measuremode');
        if (htmodeVal == true) {
            messagemodeObj.getStore().loadRawData(publicJsonData['reportOptionsht']);
        } else {
            messagemodeObj.getStore().loadRawData(publicJsonData['reportOptionstxt']);
            messagemodeObj.setValue("No");

        }
    },

    hideCustomLogo: function () {
        var loginLo = publicJsonData['loginChk'];
        var monLo = publicJsonData['monLo'];
        var reportLo = publicJsonData['reportLo'];
        var configLo = publicJsonData['configLo'];

        if (loginLo == "d") {
            var loginFile = Ext.getCmp('loginFile');
            loginFile.hide();
        }
        if (monLo == "d") {
            var monitorFile = Ext.getCmp('monitorFile');
            monitorFile.hide();
        }
        if (reportLo == "d") {
            var reportFile = Ext.getCmp('reportFile');
            reportFile.hide();
        }
        if (configLo == "d") {
            var configFile = Ext.getCmp('configFile');
            configFile.hide();
        }
    },
    applyToModule: function () {


        var logoCheck = Ext.getCmp('apply').checked;

        if (logoCheck == true && (publicJsonData['hasAdminTab']==true || publicJsonData['hasMonitorTab']==true)) {
            var reporter = Ext.getCmp('reporter');
            reporter.hide();
            var reportFile = Ext.getCmp('reportFile');
            reportFile.hide();
            var configuration = Ext.getCmp('configuration');
            configuration.hide();
            var configFile = Ext.getCmp('configFile');
            configFile.hide();
        } else {
			Ext.getCmp('reporter_container').show();
            if(publicJsonData['hasReporterTab']==true){
            var reporter = Ext.getCmp('reporter');
            reporter.show();
				var reportLo = publicJsonData['reportLo'];
				if (reportLo != "d") {
					Ext.getCmp('reportFile').show();
			}	
			}	
			if(publicJsonData['hasConfigTab']==true){
            var configuration = Ext.getCmp('configuration');
            configuration.show();
				var configLo = publicJsonData['configLo'];
				if (configLo != "d") {
					Ext.getCmp('configFile').show();
				}
			}
        }
    },

    loginLogo: function (perform) {

        var perform = Ext.getCmp('loginpage').getValue();
       // var loginFile = Ext.getCmp('loginFile');
        if (perform == "Default") {


            Ext.getCmp('loginFile').hide();

        } else {

            Ext.getCmp('loginFile').show();
        }
    },
    monitorLogo: function (perform) {
        var perform = Ext.getCmp('monitorpage').getValue();
        if (perform == "Default") {

  Ext.getCmp('monitorFile').hide();


        } else {
		Ext.getCmp('monitorFile').show();

        }
    },
    reporterLogo: function (perform) {
        var perform = Ext.getCmp('reporter').getValue();

        if (perform == "Default") {
  Ext.getCmp('reportFile').hide();


        } else {
		Ext.getCmp('reportFile').show();

        }
    },
    configLogo: function (perform) {
        var perform = Ext.getCmp('configuration').getValue();


        if (perform == "Default") {

             Ext.getCmp('configFile').hide();

        } else {
			Ext.getCmp('configFile').show();

        }
    },

    viewData: function () {

        var command = Ext.getCmp('Cmd').getValue();

        if (command == "") {
            Ext.Msg.show({
                title: pageTitle,
                msg: 'Command field is empty',
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });


        } else {
            var me = this;
            Ext.widget('window', {
                //title: 'Edit Command',
                closeAction: 'destroy',
                width: 400,
                height: 300,
				padding:'5 10 10 10',
                id: 'ecmd',
                name: 'ecmd',
				title:'command',
                resizable: 'false',
				buttonAlign:'center',
				modal:true,
				listeners: {
					show: function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
					},
					 hide:  function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
					},
					afterrender: function () {
						Ext.EventManager.onWindowResize(function () {
							var me = this;
							me.center();
						}, this);
					}
				},
                items: [{
                    //fieldLabel: 'Command',
                    labelSeparator: '',
                    xtype: 'textareafield',
                    width: '100%',
                    height: 234,
                    id: 'commd',
					margin:0,
                    name: 'commd',
                    labelAlign: 'top',
                    cls: 'text-area',
				}],
				buttons:[{
                    xtype: 'button',
                    text: 'Apply',
                    id: 'app',
                    name: 'app',
                    action: 'app',
                    cls:'quickMenuWhiteButton',
                    align: 'center',
					handler: function (button, e)
					{
						var customscrpt = Ext.getCmp('commd').getValue();
						var comd = Ext.getCmp('Cmd');
						comd.setValue(customscrpt);

						button.up('.window').close();
					}
                }]

            }).show()
            Ext.getCmp('commd').setValue(command);
        }
    },   
    
	showuploadlogin: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file',
			name: 'file',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) {

						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileUpload = 'yes';
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "login";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];

								for (i = 0; i <= (form.length) - 1; i++)
								{
									if (isDouble == "false") 
									{
										if (!validateSingleByte(form)) {
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') {

										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/admin/eg_images/logologin.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=login&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;
								logoPath = "manager/tomcat/webapps/final/admin/eg_images/";
								var uploadFor = "login";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload)
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request has been processed successfully",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
											//Ext.Msg.alert('Status', 'Request has been processed successfully');

											tempJsonData.hiddenParams["loginImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["loginImageUploadStatusForAudit"] = "yes";

											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request could not be processed",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () 
						{
							me.windowupload();
						},
					}
				}
			]
		}).show()
    },

	showuploadmon: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) {

						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue();
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "monitor";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];

								for (i = 0; i <= (form.length) - 1; i++)
								{
									if (isDouble == "false") 
									{
										if (!validateSingleByte(form)) {
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') {

										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/monitor/eg_images/logomonitor.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=monitor&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;
								logoPath = "manager/tomcat/webapps/final/monitor/eg_images/";
								var uploadFor = "monitor";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload)
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request has been processed successfully",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
											tempJsonData.hiddenParams["monitorImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["monitorImageUploadStatusForAudit"] = "yes";

											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request could not be processed",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () 
						{
							me.windowupload();
						},
					}
				}
			]
		}).show()
	},

	showuploadreport: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "reporter";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];
								var isDomainUser1 = publicJsonData['isDomainUser'];
								for (i = 0; i <= (form.length) - 1; i++) 
								{
									if (!isDomainUser1 && isDouble == "false") 
									{
										if (!validateSingleByte(form)) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') 
									{
										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/reporter/images/logoreporter.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=reporter&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;                                 
								logoPath = "manager/tomcat/webapps/final/reporter/images/";
								var uploadFor = "reporter";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload) 
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request has been processed successfully",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
											tempJsonData.hiddenParams["reporterImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["reporterImageUploadStatusForAudit"] = "yes";
											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request could not be processed",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () {
							me.windowupload();
						},
					}
				}
			]
			
		}).show()
	},

	showuploadconfig: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "config";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];
								var isDomainUser1 = publicJsonData['isDomainUser'];
								for (i = 0; i <= (form.length) - 1; i++) 
								{
									if (!isDomainUser1 && isDouble == "false") 
									{
										if (!validateSingleByte(form)) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') 
									{
										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/config/images/logoconfig.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=config&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;                                 
								logoPath = "manager/tomcat/webapps/final/config/images/";
								var uploadFor = "config";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload) 
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request has been processed successfully",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconInformation'
											});
											tempJsonData.hiddenParams["configMgmtImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["configMgmtImageUploadStatusForAudit"] = "yes";
											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: "Request could not be processed",
												width: 300,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation'
											});
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () {
							me.windowupload();
						},
					}
				}
			]
			
		}).show()
    },

    windowupload: function () {
        var me = Ext.getCmp('uploadform');
        //var a=me.getForm();
        var a = me.getForm();
        var hiddenParams = publicJsonData.hiddenParams;
        for (var hiddenParam in hiddenParams) {
            if (!a.findField("'" + hiddenParam + "'")) {
                me.add({
                    xtype: 'hidden',
                    name: hiddenParam,
                    value: hiddenParams[hiddenParam]
                });
            } else {
                a.findField("'" + hiddenParam + "'")
                    .setValue(hiddenParams[hiddenParam]);
            }
        }
    },

	saveData: function (button) 
	{
		var me = this;

		var tomailStr = Ext.getCmp('To').getValue();
		var ccmailStr = Ext.getCmp('CC').getValue();
		var bccmailStr = Ext.getCmp('BCC').getValue();
		var customScript = Ext.getCmp('Cmd').getValue();
		var measuremode = Ext.getCmp('measuremode').getValue();
		var chgTimeOpt = Ext.getCmp('timeOpt').getValue();
		var monhomepage = Ext.getCmp('monhomepage').getValue();
		var tomailStr_obj = Ext.getCmp('To');
		var ccmailStr_obj  = Ext.getCmp('CC');
		var bccmailStr_obj  = Ext.getCmp('BCC');
		var customScript_obj  = Ext.getCmp('Cmd');

		var timeZone = Ext.getCmp('timeZone').getValue();
		var userDateFormat = Ext.getCmp('userDateFormat').getValue();

		var eGTvModeScn =tempJsonData.hiddenParams["$_eGTVModesupportedscreens"];

		if(publicJsonData['isAlarmViewerUser']=='true') 
		{
			if(monhomepage!='Current Alarms'){
				Ext.Msg.show({
					title: pageTitle,
					msg: monhomepageAlrt,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp('monhomepage').focus();
				return;
			}
		}
		var frequency = Ext.getCmp('frequency').getValue();
		var userLanguage = Ext.get('flagID').getValue();
	   /* var userAdminSkin = Ext.getCmp('adminskin').getValue();
		var monitorsk = Ext.getCmp('monitorskin').getValue();
		var reportskin = Ext.getCmp('reportskin').getValue();
		var userConfigSkin = Ext.getCmp('configskin').getValue();*/

		var userAdminSkin = Ext.getCmp('adminskin-themeLight').getText();
		var monitorsk = Ext.getCmp('monitorskin-themeLight').getText();
		var reportskin = Ext.getCmp('reportskin-themeLight').getText();
		var userConfigSkin = Ext.getCmp('configskin-themeLight').getText();
		if (userAdminSkin == "Light") {
			userAdminSkin = "Light";
		} else {
			userAdminSkin = "Dark";
		}

		if (monitorsk == "Light") {
			monitorsk = "Light";
		} else {
			monitorsk = "Dark";
		}

		 if (reportskin == "Light") {
			reportskin = "Light";
		} else {
			reportskin = "Dark";
		}

		if (reportskin == "Light") {
			reportskin = "Light";
		} else {
			reportskin = "Dark";
		}
		if (userConfigSkin == "Light") {
			userConfigSkin = "Light";
		} else {
			userConfigSkin = "Dark";
		}

		var high = Ext.getCmp('high').pressed;

		if (high == true) {
			high = "H";
		} else {
			high = "null";
		}

		var medium = Ext.getCmp('medium').pressed;

		if (medium == true) {
			medium = "I";
		} else {
			medium = "null";
		}

		var low = Ext.getCmp('low').pressed;

		if (low == true) {
			low = "L";
		} else {
			low = "null";
		}


		var ddInMailMode = Ext.getCmp('ddmailyes').pressed;

		if (ddInMailMode == true) {
			ddInMailMode = "Yes";
		} else {
			ddInMailMode = "No";
		}


	   var checkedDeleteYes = Ext.getCmp('alarmdelyes').pressed;

		if (checkedDeleteYes == true) {
			checkedDeleteYes = "true";
		} else {
			checkedDeleteYes = "false";
		}



		var checkedAckYes = Ext.getCmp('alarmackyes').pressed;

		if (checkedAckYes == true) {
			checkedAckYes = "true";
		} else {
			checkedAckYes = "false";
		}


		var logoCheck = Ext.getCmp('apply').checked;


		if (logoCheck == true) {
			logoCheck = "yes";
		} else {
			logoCheck = null;
		}


		var notify = Ext.getCmp('isnew').checked;

		if (notify == true) {
			notify = "N";
		}
		else {
			notify = Ext.getCmp('iscomp').checked;
			if (notify == true) {
				notify = "C";
			}
		}


		var msgmode = Ext.getCmp('htmode').checked;

		if (msgmode == true) {
			msgmode = "HTML";
		} else {
			msgmode = Ext.getCmp('txtmode').checked;
			if (msgmode == true) {
				msgmode = "T";
			}
		 }

		var sub = true;
		var checkToStr = '';
		var new_pwd = true;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

	// for include [#and-] fix in email-By Dhinakar on 11-3-2014

		if (tomailStr != null && tomailStr != "undefined") {
			checkToStr = Ext.getCmp('To').getValue();
			if (checkToStr == null) {
				checkToStr = "";
			}
		}
		var checkCcStr = '';
		if (ccmailStr != null && ccmailStr != "undefined") {
			checkCcStr = Ext.getCmp('CC').getValue();
		}
		var checkBccStr = '';
		if (bccmailStr != null && bccmailStr != "undefined") {
			checkBccStr = Ext.getCmp('BCC').getValue();
		}
		if (frequency != null && frequency != "undefined") {
			checkRefFreq = Ext.getCmp('frequency').getValue();
		}
		var checkScptStr = '';
		if (customScript != null && customScript != "undefined") {
			checkScptStr = Ext.getCmp('Cmd').getValue();
		}
		//var high1 = '';
		var showPref = true;


		/*if (showPref == "true") {
			if (high1 != null && Ext.getCmp('high') != null)
				high1 = Ext.getCmp('high');
			var medium1 = Ext.getCmp('medium');
			var low1 = Ext.getCmp('low');
			var notify1=Ext.getCmp('type');
			var mesgmode=Ext.getCmp('mode');
			for(i=0; i<notify1.length; i++)
		   {
			if(notify[i].checked)
			{
				radioval=notify[i].getValue();
			}
		  }
		  for(j=0; j<msgmode.length; j++)
		  {
			if(msgmode[j].checked)
			{
				mesgmode=msgmode[j].getValue();
			}
		 }

		}*/

		var toMailResult = validateEmail(tomailStr);
		var ccMailResult = validateEmail(ccmailStr);
		var bccMailResult = validateEmail(bccmailStr);

		var toMobResult = (tomailStr).match(regExp1);
		var ccMobResult = (ccmailStr).match(regExp1);
		var bccMobResult = (bccmailStr).match(regExp1);

		var toResult = (tomailStr).match(reg3);
		var ccResult = (ccmailStr).match(reg3);
		var bccResult = (bccmailStr).match(reg3);


		if ((checkToStr != "") && (toMailResult == false && toMobResult == null) && (toResult != tomailStr)) {
			Ext.Msg.show({
				title: pageTitle,
				msg: tomailid,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			tomailStr_obj.focus();
		   // sub = false;
			return;
		}
		if (!checkspecial(customScript, "@*+=[]|;\"\'<>?`")) {
			customScript_obj.focus();
			sub = false;
			return;
		}
		if (!validateSingleByte(tomailStr)) {
			Ext.Msg.show({
				title: pageTitle,
				msg: tomailiddbl,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			tomailStr_obj.focus();
			//sub = false;
			return;
		}

		if ((checkCcStr != "") && (ccMailResult == null || ccMailResult == false) && ccMobResult == null && (ccResult != ccmailStr)) {
			Ext.Msg.show({
				title: pageTitle,
				msg: ccmailid,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			ccmailStr_obj.focus();
			//sub = false;
			return;
		}
		if ((checkCcStr != "") && !validateSingleByte(ccmailStr)) {
			Ext.Msg.show({
				title: pageTitle,
				msg: ccmailiddbl,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			ccmailStr_obj.focus();
			//sub = false;
			return;
		}
		if ((checkBccStr != "") && (bccMailResult == null || bccMailResult == false) && bccMobResult == null && bccResult != bccmailStr) {
			Ext.Msg.show({
				title: pageTitle,
				msg: bccmailid,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			bccmailStr_obj.focus();
			//sub = false;
			return;
		}
		if ((checkBccStr != "") && !validateSingleByte(bccmailStr)) {
			Ext.Msg.show({
				title: pageTitle,
				msg: bccmailiddbl,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			bccmailStr_obj.focus();
		   // sub = false;
			return;
		}



		if (!sub || checkScptStr != "") {

			if (Ext.getCmp('high').pressed == false && Ext.getCmp('medium').pressed == false && Ext.getCmp('low').pressed == false) {
				Ext.Msg.show({
					title: pageTitle,
					msg: typealarm,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				sub = false;
				return;
			} else if (Ext.getCmp('isnew').checked == false && Ext.getCmp('iscomp').checked == false) {
				Ext.Msg.show({
					title: pageTitle,
					msg: notification,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				sub = false;
				return;
			} else if (Ext.getCmp('htmode').checked == false && Ext.getCmp('txtmode').checked == false) {
				Ext.Msg.show({
					title: pageTitle,
					msg: messagemode,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				sub = false;
				return;
			}
		}
		if (checkRefFreq != null && checkRefFreq != "undefined" && Ext.getCmp('frequency').isHidden()==false) {
			if (sub && this.isAValidNumber(checkRefFreq)) {
				sub = true;
			} else {
				Ext.getCmp('frequency').focus();
				sub = false;
				return;
			}
		}

		if (sub)
		{
			if ((checkToStr == "" && checkToStr.length == 0) && (checkCcStr != "" && checkCcStr.length > 0)) {
				Ext.Msg.show({
					title: pageTitle,
					msg: tomailid,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				tomailStr_obj.focus();
				sub = false;
				return;

			}
			if ((checkToStr == "" && checkToStr.length == 0) && (checkBccStr != "" && checkBccStr.length > 0)) {
				Ext.Msg.show({
					title: pageTitle,
					msg: tomailid,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				tomailStr_obj.focus();
				sub = false;
				return;
			}
			if ((Ext.getCmp('high') != null && Ext.getCmp('high') != '' && Ext.getCmp('high').pressed) || (Ext.getCmp('medium') != null && Ext.getCmp('medium') != '' && Ext.getCmp('medium').pressed) || (Ext.getCmp('low') != null && Ext.getCmp('low') != '' && Ext.getCmp('low').pressed)) {
				var orStr = " or ";
				var sep="'";
				var msgStr = userIDValidationMsg43+sep+userIDValidationMsg44+sep+orStr+sep+userIDValidationMsg45+sep +".";
				if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
				{
					msgStr = tomailid;
				}
				if ((checkToStr == "" && checkToStr.length == 0) && (checkScptStr == "" && checkScptStr.length == 0)) {
					Ext.Msg.show({
						title: pageTitle,
						msg: msgStr,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
					tomailStr_obj.focus();
					sub = false;
					return;
				}
			}
		}

		var $_pwd = tempJsonData.hiddenParams["$_pwd"];
		var $_high = tempJsonData.hiddenParams["$_high"];
		var $_medium = tempJsonData.hiddenParams["$_medium"];
		var $_low = tempJsonData.hiddenParams["$_low"];
		var $_tomailid = tempJsonData.hiddenParams["$_tomailid"];
		var $_ccmailid = tempJsonData.hiddenParams["$_ccmailid"];
		var $_bccmailid = tempJsonData.hiddenParams["$_bccmailid"];
		var $_measure_in_mail_mode = tempJsonData.hiddenParams["$_measure_in_mail_mode"];
		var $chgTimeOptSeleted = tempJsonData.hiddenParams["$chgTimeOptSeleted"];
		var $_dd_in_mail_mode = tempJsonData.hiddenParams["$_dd_in_mail_mode"];
		var $_notify = tempJsonData.hiddenParams["$_notify"];
		var $_msgmode = tempJsonData.hiddenParams["$_msgmode"];
		var $_alarm_delete = tempJsonData.hiddenParams["$_alarm_delete"];
		var $_alarm_ack = tempJsonData.hiddenParams["$_alarm_ack"];
		var $_adminSkin = tempJsonData.hiddenParams["$_adminSkin"];
		var $_monitorSkin = tempJsonData.hiddenParams["$_monitorSkin"];
		var $_reporterSkin = tempJsonData.hiddenParams["$_reporterSkin"];
		var $_configurationSkin = tempJsonData.hiddenParams["$_configurationSkin"];
		var loginImageStatus = tempJsonData.hiddenParams["loginImageStatus"];
		var monitorImageStatus = tempJsonData.hiddenParams["monitorImageStatus"];
		var reporterImageStatus = tempJsonData.hiddenParams["reporterImageStatus"];
		var configMgmtImageStatus = tempJsonData.hiddenParams["configMgmtImageStatus"];
		var loginImageUploadStatusForAudit = tempJsonData.hiddenParams["loginImageUploadStatusForAudit"];
		var monitorImageUploadStatusForAudit = tempJsonData.hiddenParams["monitorImageUploadStatusForAudit"];
		var reporterImageUploadStatusForAudit = tempJsonData.hiddenParams["reporterImageUploadStatusForAudit"];
		var configMgmtImageUploadStatusForAudit = tempJsonData.hiddenParams["configMgmtImageUploadStatusForAudit"];
		var $_languageName = tempJsonData.hiddenParams["$_languageName"];
		var $_refreshFreq = tempJsonData.hiddenParams["$_refreshFreq"];
		var $_monitorHomePage = tempJsonData.hiddenParams["$_monitorHomePage"];
		var $_timeZone = tempJsonData["selectedTimeZone"];
		var $_userDateFormat = tempJsonData["selectedDateFormat"];

		var escmailid0 = '';
		var escmailid1 = '';
		var escmailid2 = '';
		var escmailid3 = '';
		var escmailid4 = '';
		
		if (!Ext.isEmpty(Ext.getCmp("escmailid0")))
		{
			escmailid0 = Ext.getCmp("escmailid0").getValue();
			var mailResult0 = validateEmail(escmailid0);
			var mobResult0 = (escmailid0).match(regExp1);
			var result0 = (escmailid0).match(reg3);
			if ((escmailid0 != "") && (mailResult0 == false && mobResult0 == null) && (result0 != escmailid0))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: escLevel+' 1 '+escLevel1,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp("escmailid0").focus();
				return;
			}
        }
		
		if (!Ext.isEmpty(Ext.getCmp("escmailid1")))
		{
			escmailid1 = Ext.getCmp("escmailid1").getValue();
			var mailResult1 = validateEmail(escmailid1);
			var mobResult1 = (escmailid1).match(regExp1);
			var result1 = (escmailid1).match(reg3);
			if ((escmailid1 != "") && (mailResult1 == false && mobResult1 == null) && (result1 != escmailid1))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: escLevel+' 2 '+escLevel1,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp("escmailid1").focus();
				return;
			}
		}
		
		if (!Ext.isEmpty(Ext.getCmp("escmailid2")))
		{
			escmailid2 = Ext.getCmp("escmailid2").getValue();
			var mailResult2 = validateEmail(escmailid2);
			var mobResult2 = (escmailid2).match(regExp1);
			var result2 = (escmailid2).match(reg3);
			if ((escmailid2 != "") && (mailResult2 == false && mobResult2 == null) && (result2 != escmailid2))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: escLevel+' 3 '+escLevel1,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp("escmailid2").focus();
				return;
			}
		}
		
		if (!Ext.isEmpty(Ext.getCmp("escmailid3")))
		{
			escmailid3 = Ext.getCmp("escmailid3").getValue();
			var mailResult3 = validateEmail(escmailid3);
			var mobResult3 = (escmailid3).match(regExp1);
			var result3 = (escmailid3).match(reg3);
			if ((escmailid3 != "") && (mailResult3 == false && mobResult3 == null) && (result3 != escmailid3))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: escLevel+' 4 '+escLevel1,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp("escmailid3").focus();
				return;
			}
		}
		
		if (!Ext.isEmpty(Ext.getCmp("escmailid4")))
		{
			escmailid4 = Ext.getCmp("escmailid4").getValue();
			var mailResult4 = validateEmail(escmailid4);
			var mobResult4 = (escmailid4).match(regExp1);
			var result4 = (escmailid4).match(reg3);
			if ((escmailid4 != "") && (mailResult4 == false && mobResult4 == null) && (result4 != escmailid4))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: escLevel+' 5 '+escLevel1,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				Ext.getCmp("escmailid4").focus();
				return;
			}
		}
		
		var size = inputs;
		var name = tempJsonData.hiddenParams["name"];
		var val = tempJsonData.hiddenParams["val"];
		var entry = tempJsonData.hiddenParams["entry"];

		var loginLogo1 = Ext.getCmp('loginpage').getValue();
		var monitorLogo1 = Ext.getCmp('monitorpage').getValue();
		var reporterLogo1 = Ext.getCmp('reporter').getValue()
		var configLogo1 = Ext.getCmp('configuration').getValue();

			//if user logo are changed to default , we change the hidden value during onsubmit

		if (loginLogo1 == "Default") {
			loginImageStatus = '';
			loginImageUploadStatusForAudit = 'no';
		}
		if (monitorLogo1 == "Default") {
			monitorImageStatus = '';
			monitorImageUploadStatusForAudit = 'no';
		}
		if (reporterLogo1 == "Default") {
			reporterImageStatus = '';
			reporterImageUploadStatusForAudit = 'no';
		}
		if (configLogo1 == "Default") {
			configMgmtImageStatus = '';
			configMgmtImageUploadStatusForAudit = 'no';
		}

		if (Ext.getCmp('apply').checked && (publicJsonData['hasAdminTab']==true || publicJsonData['hasMonitorTab']==true)) {
			reporterImageStatus = '';
			reporterImageUploadStatusForAudit = 'no';
			configMgmtImageStatus = '';
			configMgmtImageUploadStatusForAudit = 'no';
		}

		/**************Following code for creating query string for TV Mode to both addmore and save button ****************/
		var monitorHomeOptRadioGrpObj=Ext.getCmp('userProf_monitorHomeOpt');
		
		var monitorHomeOpt = '';
		if(!Ext.isEmpty(monitorHomeOptRadioGrpObj))
		{
			var monitorHomeOptObj = monitorHomeOptRadioGrpObj.getChecked();
			if (!Ext.isEmpty(monitorHomeOptObj))
			{
				monitorHomeOpt=monitorHomeOptObj[0].inputValue;
			}
		}

		var qryString = "$_ccmailid=Mail ID / Mobile No  Cc$" + encodeURIComponent($_ccmailid) +
			"&$_alarm_ack=Allow alarm acknowledgement$" + $_alarm_ack +
			"&$_adminSkin=Admin Skin$" + $_adminSkin +
			"&monitorImageStatus=" + monitorImageStatus +
			"&configMgmtImageStatus=" + configMgmtImageStatus +
			"&$_bccmailid=Mail ID / Mobile No  Bcc$" +encodeURIComponent($_bccmailid)  +
			"&$_alarm_delete=Allow delete alarms$" + $_alarm_delete +
			"&$_tomailid=Mail ID / Mobile No To$" + encodeURIComponent($_tomailid) +
			"&$_languageName=Language$" + $_languageName +
			"&alarm_ack=" + checkedAckYes +
			"&reporterImageUploadStatusForAudit=" + reporterImageUploadStatusForAudit +
			"&escmailid=" + encodeURIComponent(escmailid0) +"&escmailid2=" + encodeURIComponent(escmailid1) +"&escmailid3=" + encodeURIComponent(escmailid2) +"&escmailid4=" + encodeURIComponent(escmailid3) +"&escmailid5=" + encodeURIComponent(escmailid4) +
			"&msgmode=" + msgmode +
			"&$_medium=" + $_medium +
			"&alarm_delete=" + checkedDeleteYes +
			"&loginImageStatus=" + loginImageStatus +
			"&adminSkin=" + userAdminSkin +
			"&configurationSkin=" + userConfigSkin +
			"&ccmailid=" + encodeURIComponent(ccmailStr) +
			"&$_monitorHomePage=Monitor Home Page$" + $_monitorHomePage +
			"&configMgmtImageUploadStatusForAudit=" + configMgmtImageUploadStatusForAudit +
			"&languageName=" + userLanguage +
			"&size=" + encodeURIComponent(size)  +
			"&$_reporterSkin=Reporter Skin$" + $_reporterSkin +
			"&$_monitorSkin=Monitor Skin$" + $_monitorSkin +
			"&logoCheck=" + logoCheck +
			"&$_refreshFreq=Refresh Frequency$" + $_refreshFreq +
			"&$_msgmode=" + $_msgmode +
			"&$_low=" + $_low +
			"&low=" + low +
			"&$_measure_in_mail_mode=Include measure details in mail alert$" + encodeURIComponent($_measure_in_mail_mode) +
			"&monitorImageUploadStatusForAudit=" + monitorImageUploadStatusForAudit +
			"&measure_in_mail_mode=" + measuremode +
			"&$_chgTimeOpt=Maximum timeline for reports$" + encodeURIComponent($chgTimeOptSeleted) +
			"&chgTimeOpt=" + chgTimeOpt +
			"&reporterImageStatus=" + reporterImageStatus +
			"&$_high=" + $_high +
			"&monitorSkin=" + monitorsk +
			"&notify=" + notify +
			"&bccmailid=" + encodeURIComponent(bccmailStr) +
			"&reporterSkin=" + reportskin +
			"&monitorHomePage=" + monhomepage +
			"&monitorHomePageOption=" + monitorHomeOpt +
			"&medium=" + medium +
			"&$_dd_in_mail_mode=Include detailed diagnosis in mail alerts$" +encodeURIComponent($_dd_in_mail_mode)  +
			"&$_configurationSkin=Configuration Management Skin$" + $_configurationSkin +
			"&dd_in_mail_mode=" +encodeURIComponent(ddInMailMode)  +
			"&$_notify=" + $_notify +
			"&customScript=" + customScript +
			"&entry=" + entry +
			"&entry=" + entry +
			"&tomailid=" + encodeURIComponent(tomailStr) +
			"&high=" + high +
			"&refreshFreq=" + frequency +
			"&loginImageUploadStatusForAudit=" + loginImageUploadStatusForAudit +
		   /* "&TVModuleScreens=" +encodeURIComponent(TVMode)+"&tvModeTimeFrequency="+tvModeTimeFrequency+ */
		    "&timeZone=" + timeZone +"&$_timeZone=" + "Time Zone$"+$_timeZone +
			"&userDateFormat=" + userDateFormat+"&$_userDateFormat=" + "Date format$"+$_userDateFormat;

		 /************** 2fa - starts here ****************/
		var isAdminEnabled2FA = publicJsonData.isAdminEnabled2FA;

		if (!Ext.isEmpty(isAdminEnabled2FA) && (isAdminEnabled2FA.toLowerCase() == "true" || isAdminEnabled2FA.toLowerCase() == "yes"))
		{
			var is2FAEnabled = Ext.getCmp('enable2FAYesFlag').getGroupValue();

			var twoFAOTPModeVal = Ext.getCmp('mail').getGroupValue();
			var twoFAEnableFlagVal = '';

			if (!Ext.isEmpty(is2FAEnabled) && is2FAEnabled.toLowerCase() == "yes")
			{
				twoFAEnableFlagVal = "yes";
				var tomailVal = Ext.getCmp('To').getValue();
				if (Ext.isEmpty(tomailVal) || Ext.String.trim(tomailVal).length == 0)
				{
					Ext.Msg.show
					({
						title : pageTitle,
						msg : toMailIDAlertMsg+".",
						buttons : Ext.Msg.OK,
						icon : 'iconExclamation',
						fn: function(btn)
						{
							Ext.getCmp('To').focus();
						}
					});
					return;
				}
				qryString += "&tomailVal="+tomailVal;
			}
			else
			{
				twoFAEnableFlagVal = "no";
				twoFAOTPModeVal = "mail";
			}
			qryString += "&twofaEnableFlagVal=" + twoFAEnableFlagVal + "&twofaOTPModeFlagVal=" + twoFAOTPModeVal;
		}
		var reloadManager=false;
		if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
		{
			var previousSelectedOption=Ext.getCmp('monhomepage').previousSelectedOption;
		
			if(monhomepage!=null && monhomepage!=previousSelectedOption)
			{
				reloadManager=true;
			}
		}
		else 
		{
			if(monhomepage!=null && monhomepage!=$_monitorHomePage)
			{
				reloadManager=true;
			}
		}

		/************** 2fa - ends here ****************/

		var cloudModel = publicJsonData.cloudModel;
		var isSuperOrg = publicJsonData.isSuperOrg;
		var isEligibleUser = publicJsonData.isEligibleUser;

		if ((!Ext.isEmpty(cloudModel) && cloudModel.toLowerCase() == 'phoenix' && isSuperOrg) || 
			(!Ext.isEmpty(isEligibleUser) && isEligibleUser))
		{
			var useParentProxyNo = '';
			if (!Ext.isEmpty(Ext.getCmp('useParentProxyNo')))
			{
				useParentProxyNo = Ext.getCmp('useParentProxyNo').getGroupValue();
			}
			var useProxyYes = Ext.getCmp('useProxyYes').getGroupValue();
			var proxyHost = '';
			var proxyPort = '';
			var isAuthenticationYes = '';
			var proxyUsername = '';
			var proxyPassword = '';
			var proxyCnfPassword = '';
			if (!Ext.isEmpty(useProxyYes) && useProxyYes == 'yes'  && (Ext.isEmpty(useParentProxyNo) || (!Ext.isEmpty(useParentProxyNo) && useParentProxyNo == 'no')))
			{
				proxyHost = Ext.getCmp('proxyHost').getValue();
				proxyPort = Ext.getCmp('proxyPort').getValue();

				if (Ext.isEmpty(proxyHost))
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : enterProxyHostMsg,
						icon : 'gen-warning size32 color-warning',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('proxyHost').focus(true,true);
						}
					});
					return false;
				}

				var alphabets = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
				var checkCharacter = "";
				var temp = false;
				for(var m=0; m<proxyHost.length; m++)
				{
					checkCharacter = alphabets.indexOf(proxyHost.charAt(m))
					//Returns value 1 if thecharacter listed is found
					if(checkCharacter >= 0)
					{
						temp = true;
						break;
					}
				}

				if(temp)
				{
					//Hostname should not have space
					if(checkspaceExtjs(proxyHost) != '0')
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: _checkblank,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function(btn) {
								Ext.getCmp('proxyHost').focus(true,true);
							}
						});
						return false;
					}
					else if(this.isCheckEgKeywords(proxyHost))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: _tcKeyword,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function(btn) {
								Ext.getCmp('proxyHost').focus(true,true);
							}
						});
						return false;
					}
					//Checks for dots before & after hostname as well as dots in consecutive positions.
					if (!this.checkdots(proxyHost))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: _checkHost,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function(btn) {
								Ext.getCmp('proxyHost').focus(true,true);
							}
						});
						return false;
					}
					if(!checkspecialnomess(proxyHost,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function(btn) {
								Ext.getCmp('proxyHost').focus(true,true);
							}
						});
						return false;
					}
				}
				else 
				{
					var errMsg = validateIpWithMsg(proxyHost);
					if(!Ext.isEmpty(errMsg))
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: errMsg,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function(btn) {
								Ext.getCmp('proxyHost').focus(true,true);
							}
						});
						return false;
					}
				}

				if (Ext.isEmpty(proxyPort))
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : enterProxyPortMsg,
						icon : 'gen-warning size32 color-warning',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('proxyPort').focus(true,true);
						}
					});
					return false;
				}
				else if ((!checknumber("+",proxyPort) || proxyPort == 0) && (proxyPort != "none"))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: _checkproxy,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function(btn) {
							Ext.getCmp('proxyPort').focus(true,true);
						}
					});
					return false;
				}

				var errMsg = checkDecimalExtJs(proxyPort);
				if (!Ext.isEmpty(errMsg))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: errMsg,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function(btn) {
							Ext.getCmp('proxyPort').focus(true,true);
						}
					});
					return false;
				}

				isAuthenticationYes = Ext.getCmp('isAuthenticationYes').getGroupValue();
				if (!Ext.isEmpty(isAuthenticationYes) && isAuthenticationYes == 'yes')
				{
					proxyUsername = Ext.getCmp('proxyUsername').getValue();
					proxyPassword = Ext.getCmp('proxyPassword').getValue();
					proxyCnfPassword = Ext.getCmp('proxyCnfPassword').getValue();

					if (Ext.isEmpty(proxyUsername))
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : enterProxyUsernameMsg,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyUsername').focus(true,true);
							}
						});
						return false;
					}
					var splChars = "|:;\"\'<>,\/[]?";

					if(this.isCheckEgKeywords(proxyUsername))
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : _tcKeyword,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyUsername').focus(true,true);
							}
						});
						return false;
					}
					else if (checkSpecialExtjs(proxyUsername,splChars) != '0')
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : validationMsg13,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyUsername').focus(true,true);
							}
						});
						return false;
					}
					else if(proxyUsername.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : _checkdots,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyUsername').focus(true,true);
							}
						});
						return false;
					}
					else if(proxyUsername.indexOf("  ") > -1)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : _checkSpaces,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyUsername').focus(true,true);
							}
						});
						return false;
					}

					if (Ext.isEmpty(proxyPassword))
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : enterProxyPwdMsg,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyPassword').focus(true,true);
							}
						});
						return false;
					}
					else if(checkspaceExtjs(proxyPassword) != '0')
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : _checkblank,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyPassword').focus(true,true);
							}
						});
						return false;
					}
					else if(this.isCheckEgKeywords(proxyPassword))
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : _tcKeyword,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyPassword').focus(true,true);
							}
						});
						return false;
					}
					else if (Ext.isEmpty(proxyCnfPassword))
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : enterProxyCnfPwdMsg,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyCnfPassword').focus(true,true);
							}
						});
						return false;
					}
					else if (proxyPassword != proxyCnfPassword)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : pwdMatchMsg,
							icon : 'gen-warning size32 color-warning',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('proxyCnfPassword').focus(true,true);
							}
						});
						return false;
					}
				}
			}
			qryString += "&useParentProxyNo="+encodeURIComponent(useParentProxyNo)+"&useProxyYes="+encodeURIComponent(useProxyYes)+"&proxyHost="+encodeURIComponent(proxyHost)+"&proxyPort="+encodeURIComponent(proxyPort)+"&isAuthenticationYes="+encodeURIComponent(isAuthenticationYes)+"&proxyUsername="+encodeURIComponent(proxyUsername)+"&proxyPassword="+encodeURIComponent(proxyPassword);
		}

		alarmLoadMask1.show();
		Ext.Ajax.request({
			url:'/final/admin/UserProfile/data/userProfilep.jsp',
			params : qryString,
			method:'POST',
			timeout:120000,
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				if (publicJson['Msg']=='User profile settings updated successfully')
				{
					Ext.Msg.show({
						title:publicJson['Title'],
						msg:publicJson['Msg'],
						buttons: Ext.Msg.OK,
						icon: "iconInformation",
						fn: function (buttonId) 
						{
							if (buttonId == "ok") 
							{
								if (isLSPortalUser != null && isLSPortalUser == true && sendUserDataToCMS != null && sendUserDataToCMS == 'true' && oldPwdObj != str_upass)
								{
									jQuery.ajax({
										type: "POST",
										url: "https://www.eginnovations.com/solutions/product_pw_change.php",
										 data: {
											'Email': userID,
											'New_Password': str_upass
										},
										cache: false,
										success: function(result)
										{
											if((publicJsonData['selectedTimeZone']!=timeZone) || (publicJsonData['selectedDateFormat']!=userDateFormat) || (publicJsonData['userLanguage']!=userLanguage) || (publicJsonData['userAdminSkin'] != userAdminSkin) || (publicJsonData['userMonitorSkin'] != monitorsk) || (publicJsonData['userReporterSkin'] != reportskin) || (publicJsonData['userConfigSkin'] != userConfigSkin))
											{
												if(fromSm == "yes")
												{
													window.parent.location.href = smIndexPage+"&comeFrom=profile"+"&newwindow=yes";
													return;
												}
												else
												{
													if(reloadManager)
													{
														window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
														return;
													}
													else
													{
														window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
														/*if(isElementsDataSwapped) // || (TVMode[0]!== "" && TVMode.length!= 0)
														{
															window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
														}*/
														//window.parent.location.href=window.parent.location.href+"&comeFrom=profile";
														//return;
													}
												}
											}
											else
											{
												if(reloadManager)
												{
													window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
													return;
												}
												else
												{
													window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
												}
											}
										},
										error: function(error)
										{
											if(reloadManager)
											{
												window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
												return;
											}
											console.log(error);
										}
									});
								}
								else
								{
									if((publicJsonData['selectedTimeZone']!=timeZone) || (publicJsonData['selectedDateFormat']!=userDateFormat) || (publicJsonData['userLanguage']!=userLanguage) || (publicJsonData['userAdminSkin'] != userAdminSkin) || (publicJsonData['userMonitorSkin'] != monitorsk) || (publicJsonData['userReporterSkin'] != reportskin) || (publicJsonData['userConfigSkin'] != userConfigSkin))
									{
										if(fromSm == "yes")
										{
											window.parent.location.href = smIndexPage+"&comeFrom=profile"+"&newwindow=yes";
											return;
										}
										else
										{
											if(reloadManager)
											{
												window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
												return;
											}
											else
											{
												window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
												//if(isElementsDataSwapped) // || (TVMode[0]!== "" && TVMode.length!= 0)
												//{
													//window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
												//}
												//window.parent.location.href=window.parent.location.href+"&comeFrom=profile";
												//return;
											}
										}
									}
									else
									{
										if(reloadManager)
										{
											window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
											return;
										}
										else
										{
											window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
										}
									}
								}
							}
						}
					});
				}
				else
				{
					Ext.Msg.show({
						title:publicJson['Title'],
						msg:publicJson['Msg'],
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
					});
				}
				alarmLoadMask1.hide();
			}
		});
    },

	isCheckEgKeywords: function(value)
	{
		var paramval = value.toString().toLowerCase();
		var tcKey = "";
		var tcKeyWordCaught =  false;
		var tcKeywords = ['$unconfigured','$pattern','$adminport','$unconfig','$delay','$domain','$fromid','$homedir','$processname:$pattern','$processname:$processpattern','$hostname','$user','$remotefile','$rootpath','$servername','$servicename','$community','$toid','$name:$url','$url','$username','$webserverportno','$webserverport','$password','$passwd','$dbhost','$dbport','$database','$name:$pattern','(EG_RUNTIME)','$hostIp:$portNo'];
		for (var z=0;z<tcKeywords.length;z++)
		{
			tcKey = tcKeywords[z].toLowerCase();
			if (paramval == tcKey)
			{
				tcKeyWordCaught = true;
				break;
			}
			if (tcKey.indexOf(":") != -1)
			{
				var splitKey = tcKey.split(":");
				var key1 = "";
				for(var i =0 ; i < splitKey.length;i++)
				{
					key1 = splitKey[i]+"";
					if (paramval == key1)
					{
						tcKeyWordCaught = true;
					}
				}

				if(tcKeyWordCaught)
				{
					break;
				}
			}
		}
		return tcKeyWordCaught;
	},

    isAValidNumber: function (val) {
        validFigures = '0123456789';
        if (val == "") {
            Ext.Msg.show({
                title: pageTitle,
                msg: frequency,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            return false;
        }
        for (i = 0; i < val.length; i++) {
            if (validFigures.indexOf(val.charAt(i), 0) == -1) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: frequency,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                return false;
            }
        }
        if (parseInt(val) >= 30) {
            return true;
        } else {
            Ext.Msg.show({
                title: pageTitle,
                msg: frequency,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            return false;
        }
    },

	show2FAOTPModeCnt: function()
	{
		var twoFAEnableFlag = Ext.getCmp('enable2FAYesFlag').getGroupValue();
		if (!Ext.isEmpty(twoFAEnableFlag) && twoFAEnableFlag.toLowerCase() == "yes")
		{
			Ext.getCmp('twoFAOTPMode').show();
		}
		else
		{
			Ext.getCmp('twoFAOTPMode').hide();
		}
	},

	setDefaultProxyData : function()
	{
		var useProxy = publicJsonData.useProxy;
		var useParentProxy = publicJsonData.useParentProxy;
		if (!Ext.isEmpty(useProxy) && useProxy.toLowerCase() == 'y')
		{
			Ext.getCmp('useProxyYes').setValue(true);
			
			var isSuperOrg = publicJsonData.isSuperOrg;
			var isSuperUserSuperOrg = publicJsonData.isSuperUserSuperOrg;
			var isProxySet = publicJsonData.isProxySet;
			var useParentProxy = publicJsonData.useParentProxy;
			var parentproxyEnabled = publicJsonData.parentproxyEnabled;
			
			if (!isSuperOrg && (useParentProxy || (!Ext.isEmpty(parentproxyEnabled) && parentproxyEnabled == 'y')))
			{
				Ext.getCmp('useParentProxy').show();
				if (useParentProxy || !isProxySet)
				{
					Ext.getCmp('useParentProxyYes').setValue(true);
				}
				else
				{
					Ext.getCmp('useParentProxyNo').setValue(true);
				}
			}
			else
			{
				Ext.getCmp('useParentProxy').hide();
				Ext.getCmp('useParentProxyNo').setValue(true);
			}

			var isProxyAvailable = publicJsonData.isProxyAvailable;
			
			if (!Ext.isEmpty(isProxyAvailable) && isProxyAvailable)
			{
				Ext.getCmp('noProxy').hide();

				var proxyHost = publicJsonData.proxyHost;
				var proxyPort = publicJsonData.proxyPort;

				Ext.getCmp('proxyHost').setValue(proxyHost);
				Ext.getCmp('proxyPort').setValue(proxyPort);
				Ext.getCmp('proxyHost').show();
				Ext.getCmp('proxyPort').show();
				Ext.getCmp('isAuthentication').show();
				var setAuthentication = publicJsonData.setAuthentication;
				if (!Ext.isEmpty(setAuthentication) && setAuthentication.toLowerCase() == 'y')
				{
					Ext.getCmp('isAuthenticationYes').setValue(true);
					var proxyUsername = publicJsonData.proxyUsername;
					var proxyPassword = publicJsonData.proxyPassword;
					pass = proxyPassword;
					confPass = proxyPassword;
					Ext.getCmp('proxyUsername').setValue(proxyUsername);
					Ext.getCmp('proxyPassword').setValue(proxyPassword);
					Ext.getCmp('proxyCnfPassword').setValue(proxyPassword);
					Ext.getCmp('proxyUsername').show();
					Ext.getCmp('proxyPassword').show();
					Ext.getCmp('proxyCnfPassword').show();
				}
				else
				{
					Ext.getCmp('isAuthenticationNo').setValue(true);
				}
				if (useParentProxy)
				{
					Ext.getCmp('proxyHost').setDisabled(true);
					Ext.getCmp('proxyPort').setDisabled(true);
					Ext.getCmp('isAuthentication').setDisabled(true);
					if (!Ext.isEmpty(setAuthentication) && setAuthentication.toLowerCase() == 'y')
					{
						Ext.getCmp('proxyUsername').setDisabled(true);
						Ext.getCmp('proxyPassword').setDisabled(true);
						Ext.getCmp('proxyCnfPassword').setDisabled(true);
					}
				}
			}
			else
			{
				Ext.getCmp('noProxy').show();
				Ext.getCmp('proxyHost').hide();
				Ext.getCmp('proxyPort').hide();
				Ext.getCmp('isAuthenticationNo').setValue(true);
				Ext.getCmp('isAuthentication').hide();
				Ext.getCmp('proxyUsername').hide();
				Ext.getCmp('proxyPassword').hide();
				Ext.getCmp('proxyCnfPassword').hide();
			}
		}
		else
		{
			Ext.getCmp('useProxyNo').setValue(true);
		}
	},

	setDefaultProxyDataAlone : function()
	{
		var isProxyAvailable = publicJsonData.isProxyAvailable;
		if (!Ext.isEmpty(isProxyAvailable) && isProxyAvailable)
		{
			var proxyHost = publicJsonData.proxyHost;
			var proxyPort = publicJsonData.proxyPort;

			Ext.getCmp('proxyHost').setValue(proxyHost);
			Ext.getCmp('proxyPort').setValue(proxyPort);
			Ext.getCmp('proxyHost').show();
			Ext.getCmp('proxyPort').show();
			Ext.getCmp('isAuthentication').show();
			var setAuthentication = publicJsonData.setAuthentication;
			if (!Ext.isEmpty(setAuthentication) && setAuthentication.toLowerCase() == 'y')
			{
				Ext.getCmp('isAuthenticationYes').setValue(true);
				var proxyUsername = publicJsonData.proxyUsername;
				var proxyPassword = publicJsonData.proxyPassword;
				pass = proxyPassword;
				confPass = proxyPassword;
				Ext.getCmp('proxyUsername').setValue(proxyUsername);
				Ext.getCmp('proxyPassword').setValue(proxyPassword);
				Ext.getCmp('proxyCnfPassword').setValue(proxyPassword);
				Ext.getCmp('proxyUsername').show();
				Ext.getCmp('proxyPassword').show();
				Ext.getCmp('proxyCnfPassword').show();
			}
			else
			{
				Ext.getCmp('isAuthenticationNo').setValue(true);
			}
		}
	},

	setParentProxyData : function()
	{
		var isSuperOrg = publicJsonData.isSuperOrg;
		var isSuperUserSuperOrg = publicJsonData.isSuperUserSuperOrg;
		var isProxySet = publicJsonData.isProxySet;
		var parentproxyEnabled = publicJsonData.parentproxyEnabled;
		var useParentProxy = publicJsonData.useParentProxy;
		
		if (!isSuperOrg && (useParentProxy || !Ext.isEmpty(parentproxyEnabled) && parentproxyEnabled == 'y'))
		{
			Ext.getCmp('useParentProxy').show();
			if (!Ext.isEmpty(parentproxyEnabled) && parentproxyEnabled == 'y' || !isProxySet)
			{
				Ext.getCmp('useParentProxyYes').setValue(true);
			}
			else
			{
				Ext.getCmp('useParentProxyNo').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('useParentProxy').hide();
			Ext.getCmp('useParentProxyNo').setValue(true);
		}

		var parentproxyEnabled = publicJsonData.parentproxyEnabled;
		if (!Ext.isEmpty(parentproxyEnabled) && parentproxyEnabled == 'y')
		{
			Ext.getCmp('noProxy').hide();
			var parentproxyHost = publicJsonData.parentproxyHost;
			var parentproxyPort = publicJsonData.parentproxyPort;
			Ext.getCmp('proxyHost').setValue(parentproxyHost);
			Ext.getCmp('proxyPort').setValue(parentproxyPort);
			Ext.getCmp('proxyHost').show();
			Ext.getCmp('proxyPort').show();
			Ext.getCmp('proxyHost').setDisabled(true);
			Ext.getCmp('proxyPort').setDisabled(true);
			var parentsetAuthentication = publicJsonData.parentsetAuthentication;
			Ext.getCmp('isAuthentication').show();
			if (!Ext.isEmpty(parentsetAuthentication) && parentsetAuthentication == 'y')
			{
				Ext.getCmp('isAuthenticationYes').setValue(true);
				var parentproxyUsername = publicJsonData.parentproxyUsername;
				var parentproxyPassword = publicJsonData.parentproxyPassword;
				Ext.getCmp('proxyUsername').setValue(parentproxyUsername);
				Ext.getCmp('proxyPassword').setValue(parentproxyPassword);
				Ext.getCmp('proxyCnfPassword').setValue(parentproxyPassword);
				Ext.getCmp('proxyUsername').show();
				Ext.getCmp('proxyPassword').show();
				Ext.getCmp('proxyCnfPassword').show();
				Ext.getCmp('proxyUsername').setDisabled(true);
				Ext.getCmp('proxyPassword').setDisabled(true);
				Ext.getCmp('proxyCnfPassword').setDisabled(true);
			}
			else
			{
				Ext.getCmp('isAuthenticationNo').setValue(true);
				Ext.getCmp('proxyUsername').hide();
				Ext.getCmp('proxyPassword').hide();
				Ext.getCmp('proxyCnfPassword').hide();
			}
			Ext.getCmp('isAuthentication').setDisabled(true);
		}
		else
		{
			var useParentProxyYes = Ext.getCmp('useParentProxyYes').getGroupValue();
			if (!Ext.isEmpty(useParentProxyYes) && useParentProxyYes == 'yes')
			{
				Ext.getCmp('noProxy').show();
				Ext.getCmp('proxyHost').hide();
				Ext.getCmp('proxyPort').hide();
				Ext.getCmp('isAuthenticationNo').setValue(true);
				Ext.getCmp('isAuthentication').hide();
				Ext.getCmp('proxyUsername').hide();
				Ext.getCmp('proxyPassword').hide();
				Ext.getCmp('proxyCnfPassword').hide();
			}
			else
			{
				Ext.getCmp('proxyHost').show();
				Ext.getCmp('proxyPort').show();
				Ext.getCmp('isAuthentication').show();
			}
		}
	},
	
	checkdots : function(fieldvalue)
	{
		var val = fieldvalue;
		if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
		{
			return false;
		}
		else
		{
			for(var k=0;k < val.length;k++)
			{
				if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
				{
					return false;
				}
				else
				{
					continue;
				}
			}
		}
		return true;
	}
});

function validateIpWithMsg(fieldvalue)
{
	var s_val = fieldvalue;
	var dot_count = 0;

	var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	var isIpv6=false;
	var result=false;
	if(s_val.indexOf(":")>-1)
		isIpv6=true;
	
	if(isIpv6)
	{
		
		result = checkIPv6(s_val);
		return result;
	}
	else
	{

		for(var m=0; m<s_val.length; m++)
		{
			check_char = alpha.indexOf(s_val.charAt(m))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				return _checkAlpha;
			}
		}
		for(var k=0;k < s_val.length;k++)
		{
			if(s_val.charAt(k) == '.' && s_val.charAt(k + 1) == '.')
			{
				return _checkIp;
			}
			else
			{
				continue;
			}
		}
		for(var i=0;i < s_val.length;i++)
		{
			if(s_val.charAt(i) == '.')
			{
				dot_count = dot_count + 1;
			}
			else
			{
				continue;
			}
		}
		if(dot_count != 3)
		{
			return _valIp;
		}
		if(s_val.charAt(0) == '.' || s_val.charAt(s_val.length - 1) == '.')
		{
			return _validateIp;
		}
		for(var j = 0; j < s_val.length; j++)
		{
			if(s_val.charAt(j) == ' ')
			{
				return _checkSpaceIp;
			}
		}

		var splChar = "`~!@#$%^&*()-_+={}[]|\\:;\"\'<>,?\/";
		for(var k=0; k<s_val.length; k++)
		{
			check_char = splChar.indexOf(s_val.charAt(k))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char != -1)
			{
				return _checkspecial;
			}
		}

		if(s_val.indexOf('.') > -1 && dot_count > 2)
		{
			var number_bet_dots = s_val.split('.');

			for(var l=0;l < number_bet_dots.length;l++)
			{
				if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
				{
					return _checknum;
				}
			}
		}
		return '';
	}
}

function checkIPv6(s_val)
{
	/** IPv6 Validation Starts
	 * 
	 */
	
	if(!checkspecialnomess(s_val,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
	{
		return _checkspecial;
	}
	if(!checkspace(s_val))
	{
		return false;
	}
	var regD1= /[\.]{2,}/;
	var regD2= /(^(\.){1,})|((\.){1,}$)/gi;
	var regD3= /(\.\:){1,}|(\:\.){1,}/;
	if(s_val.match(regD1) != null || s_val.match(regD3) != null  )
	{
		return _checkIpv6;
	}
	
	if(s_val.match(regD2) != null)
	{
		return _validateIp;
	}
	var reg1= /[\:]{2,}/g;
	var reg1Res = s_val.match(reg1); 
	
	if( reg1Res != null &&  reg1Res != "::" )
	{
		return _doubleColon;
	}
	
	var regCntRes = s_val.split(":");
	var regColonLen = regCntRes.length;
	regColonLen--;
	var strV4, strV6;
	strV6 = s_val;
	
	if( regCntRes.length <= 7 && s_val.indexOf(".") != -1 )
	{
		var regDRes = s_val.split(".");
		var regDLength = regDRes.length;
		regDLength--;
		
		strV4 = s_val.substring((s_val.lastIndexOf(":")+1));
		strV6 = s_val.substring(0,(s_val.lastIndexOf(":")));
		
		var regIp4 = /[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}(\.){1}[0-9]{1,3}((\/){1}[0-9]{1,3})*$/gi;
		regIp4Res = s_val.match(regIp4);
			
		if(regIp4Res  == null || regIp4Res != strV4 )
		{
			return _valiIp;
		}
		if(strV6.indexOf(".") != -1)
		{
			return _checkIp;
		}
		if((regDLength > 3) || (regDLength != 3))
		{
			return _valIp;
		}
		var arr = strV4.split("/");
		strV4 = arr[0];
		var number_bet_dots = strV4.split('.');

		for(var l=0;l < number_bet_dots.length;l++)
		{
			if(number_bet_dots[l] < 0 || number_bet_dots[l] > 255)
			{
				return _checknum;
			}
		}
	}
	else if(regColonLen > 7)
	{
		return _grpIpv6;
	}
	
	var arr = strV6.split("/");
	strV6 = arr[0];
	
	var regPartRes2 = "";
	var regPart = /^(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1}((\:){1,2}[a-z0-9]{0,4}){1,})|(([a-z0-9(::)]{0,4}(\:){1,2}[a-z0-9]{0,4}){1})$/gi;
	var regPartRes1 = strV6.match(regPart);
	regPart = /^[a-f0-9]{0,4}$/gi;
	
	if(strV6.indexOf(":") == -1)
	{
		regPartRes2 = strV6.match(regPart);
	}
	if( ( (regPartRes1 == null) || (regPartRes1 != strV6) ) && (regPartRes2 != strV6) )
	{
		return _digitIpv6;
	}

	var regC = /(::){0,1}([a-f0-9(::)(\.)]*[\:]{1})+[a-f(::)(\.)0-9]*((\/){0,1}[0-9]{1,3})*/ig; // Right 1
	var regCRes = s_val.match(regC);

	if( regCRes == null ||  regCRes != s_val )
	{
		return _validateIpv6;
	}
	return '';	
}

function checkDecimalExtJs(field)
{
	var num = '';
	if(typeof(field) == 'object')
	{
		num = field.value;
	}
	else
	{
		num = field;
	}

	if(num.indexOf(".") > -1)
	{
		return _checkfordecimal;
	}
	return '';
}

function addContact()
{
	var mainForm = Ext.getCmp('alarmssettings');
	if(inputs == 5)
	{
		Ext.MessageBox.alert(pageTitle,'limited level, upto level 5');
		return;
	}
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+1;
	var conId = "con_"+inputs;
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		margin: 10,
		items : [
			{
				xtype:'textfield',
				id: 'escmailid'+inputs,
				cls: 'textbox',
				name: 'escmailid'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0'
			},
			{
				xtype : 'container',
				id: 'otherLevelBtn'+inputs,
				columnWidth: 0.03,
				margin: '22 0 5 2',
				items : [
				{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: 
					{
						afterrender: function () 
						{
							Ext.create('Ext.tip.ToolTip', 
							{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'remove level'
							});
						}
					},
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	Ext.getCmp('emptyDataId').hide();
	escMailIDsDiv.add(tmpContainer);
	mainForm.doLayout();
	inputs++;
}

function addEscLevel(fieldValue)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+1;
	var conId = "con_"+inputs;
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		margin: 10,
		items : [
			{
				xtype:'textfield',
				id: 'escmailid'+inputs,
				cls: 'textbox',
				name: 'escmailid'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0',
				value : fieldValue,
			},
			{
				xtype : 'container',
				id: 'otherLevelBtn'+inputs,
				columnWidth: 0.03,
				margin: '22 0 5 2',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', 
							{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'remove level'
							});
						}
					},
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	Ext.getCmp('emptyDataId').hide();
	escMailIDsDiv.add(tmpContainer);
	inputs++;
}

function removeContact(containerID)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	escMailIDsDiv.remove(containerID);
	inputs--;

	var conLength = escMailIDsDiv.items.length;
	if (conLength > 0)
	{
		inputs = 0;
		var tnpCount = 0;
		for (var i = 0;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp("con_"+i);
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var value = Ext.getCmp('escmailid'+i).getValue();
			escMailIDsDiv.remove(tmpID);
			addEscLevel(value);
		}
	}
	if (inputs == 0)
	{
		Ext.getCmp('emptyDataId').show();
	}
	else
	{
		Ext.getCmp('emptyDataId').hide();
	}
}
function specialCharacterCheck(text){
	var s_spl = "`~!#$%^*()+={}[]|\\:;\"\'<>,?\/&";
	try
	{
		for(count = 0; count < text.length; count++)
		{
			var check_char = s_spl.indexOf(text.charAt(count));
			if(check_char >= 0)
				return true;
		}
	}
	catch (e)
	{
	}
	return false;
}


