Ext.define('HotfixAvailability.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'ErrorContainer',
		'HotfixAvailabilityChart',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'hotfixavailabilitychart', 
			ref : 'hotfixavailabilitychart'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' : this.afterMainRender
			},
			'formitems' :{
				'boxready' : this.loadChartCt
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems combo[id="hotfixName"]' :{
				'select' : this.showOrder
			},
			'formitems combo[id="osName"]' :{
				'select' : this.getHotfixName
			},
			'formitems combo[id="countChoice"]' :{
				'select' : this.onChangeCountChoice
			},
			'formitems button[id="submit"]' :{
				'click' : this.showStatusDetails
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method	: 'POST',
			async	: false,
			success	: function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		me = this;
		if(strRequestFrom.toLowerCase() == "hotfix")
		{
			Ext.getCmp('formitems').hide();
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			me.loadChartCt();
		}
		else
		{
			var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
			var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
			var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
			var hotfixId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
			var shwId = me.getFormitems().getComponent('infoCont').getComponent('countChoice');
			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
				ec_userOption.setValue(publicJSON.selectedUserOption);
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}

			osNameId.getStore().loadRawData(publicJSON['osList']);
			//osNameId.setValue(publicJSON['osList'][0].valueField);
			osNameId.setValue(publicJSON['selectedOS']);

			hotfixId.getStore().loadRawData(publicJSON['hotfixList']);

			if(publicJSON['selectedHotfixName'] != "" && publicJSON['selectedHotfixName'] != undefined)
			{
				hotfixId.setValue(publicJSON['selectedHotfixName']);
			}
			else
			{
				hotfixId.setValue(publicJSON['hotfixList'][0].valueField);
			}

			shwId.getStore().loadRawData(publicJSON['showList']);

			if(publicJSON.selectedShowTopNRes != "" && publicJSON.selectedShowTopNRes != undefined)
			{
				shwId.setValue(publicJSON['selectedShowTopNRes']);
			}
			else
			{
				shwId.setValue(publicJSON['showList'][0].valueField);
			}
		}

		if(publicJSON.hasConfigDetails != undefined && publicJSON.hasConfigDetails != false)
		{
			thisCtrl.setToolsState(false);
		}
		else
		{
			if(publicJSON['selectedHotfixName'] != "" && publicJSON['selectedHotfixName'] != undefined)
			{
				thisCtrl.setToolsState(true,publicJSON['selectedHotfixName']);
			}
			else
			{
				thisCtrl.setToolsState(true,publicJSON['hotfixList'][0].valueField);
			}
		}

		if ((strRequestFrom != null && strRequestFrom == "saveSchedule"))
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
	},

	loadChartCt : function()
	{
		if (strRequestFrom != null && strRequestFrom != "saveSchedule")
		{
			thisCtrl.getMain().getComponent('hiddenPanel').setTitle(publicJSON.containerTitle);
			if(publicJSON.chartData !="" && publicJSON.chartData != undefined)
			{
				thisCtrl.getHotfixavailabilitychart().loadChart(publicJSON,thisCtrl);
			}
			if(publicJSON.hasConfigDetails)
			{
				Ext.getCmp('formitems').collapse();
				thisCtrl.getMain().getComponent('hiddenPanel').show();
				var HtfxAvlblUnvlblCountData = publicJSON['htfxAvlblUnvlblCount'];
						
				if (!Ext.isEmpty(HtfxAvlblUnvlblCountData))
				{
					var hotfixStore = Ext.create('Ext.data.Store', {
						fields : ['HotfixName','availableCount','unavailableCount'],
						data: HtfxAvlblUnvlblCountData,
						proxy: {
							type: "pagingmemory",
							reader: {
								type: "json"
							}
						},
						remoteFilter : true,
						remoteSort: true,
						autoLoad: true,
						pageSize : 10,
						simpleSortMode: true
					});
					
					Ext.getCmp('HotfixNameCountGrid').reconfigure(hotfixStore);
					if (!Ext.isEmpty(HtfxAvlblUnvlblCountData) && HtfxAvlblUnvlblCountData.length > 10)
					{
						Ext.getCmp('tbseparatorId').show();
						Ext.getCmp('pagingtoolbartopid').show();
						Ext.getCmp('pagingtoolbarbottomid').show();
						Ext.getCmp('pagingtoolbartopid').bindStore(hotfixStore);
						Ext.getCmp('pagingtoolbarbottomid').bindStore(hotfixStore);
					}
					else
					{
						Ext.getCmp('tbseparatorId').hide();
						Ext.getCmp('pagingtoolbartopid').hide();
						Ext.getCmp('pagingtoolbarbottomid').hide();
					}
				}
				// thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').show();
				// //thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').getStore().loadRawData(publicJSON['resultantArray']);
				// var resultsData = publicJSON['resultantArray'];
				// if (!Ext.isEmpty(resultsData))
				// {
					// var store = Ext.create('Ext.data.Store', {
						// fields : ['hotfix','system'],
						// data: resultsData,
						// proxy: {
							// type: "pagingmemory",
							// reader: {
								// type: "json"
							// }
						// },
						// groupField : 'hotfix',
						// remoteFilter : true,
						// remoteSort: true,
						// autoLoad: true,
						// pageSize : 100,
						// simpleSortMode: true
					// });
					// Ext.getCmp('mainGrid').reconfigure(store);
					// if (!Ext.isEmpty(resultsData) && resultsData.length > 100)
					// {
						// Ext.getCmp('tbseparatorId').show();
						// Ext.getCmp('pagingtoolbartopid').show();
						// Ext.getCmp('pagingtoolbarbottomid').show();
						// Ext.getCmp('pagingtoolbartopid').bindStore(store);
						// Ext.getCmp('pagingtoolbarbottomid').bindStore(store);
					// }
					// else
					// {
						// Ext.getCmp('tbseparatorId').hide();
						// Ext.getCmp('pagingtoolbartopid').hide();
						// Ext.getCmp('pagingtoolbarbottomid').hide();
					// }
				// }
			}
			else if(publicJSON.hasConfigDetails == false)
			{
				Ext.getCmp('hiddenPanel').hide();
				if(publicJSON.errorText != "" && publicJSON.errorText != null && publicJSON.errorText != undefined)
				{
					me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>');
				}
				me.getErrorcontainer().show();
			}
		}
	},


	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true, //booklet
			true //schedule
		);
	},

	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);

		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlStr = '../servlet/com.eg.EcCSVController';

		me.getFormitems().submit({
			url: urlStr,
			params: 'ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption,
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var osNameValue = Ext.getCmp('osName').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var hotfixName = Ext.getCmp('hotfixName').getValue();
		var show = Ext.getCmp('countChoice').getValue();

		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.validateForm();
				if (checkFlag == false)
				{
					return false;
				}
				window.location = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&ec_rtype=HotfixAvailability&osName="+osNameValue+"&softwareName="+encodeURIComponent(filterEncode(hotfixName))+"&viewCount="+show+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria;
			}
			else
			{
				var urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&showWindow=yes&ec_rtype=HotfixAvailability&osName="+osNameValue+"&request_from=HotfixAvailability&softwareName="+encodeURIComponent(filterEncode(hotfixName))+"&viewCount="+show+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&com.eg.CSRF_NONCE="+csrfToken;

				scheduleWindow(urlStr);
			}
		}
		else if(op == "favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(iconState,osName)
	{
		var osNameVal = Ext.getCmp('osName').getValue();
		var hotfixNameVal = Ext.getCmp('hotfixName').getValue();
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && osName != "" && osName != "-1" && osNameVal != "" && osNameVal != '-1' && osNameVal != undefined && hotfixNameVal != "" && hotfixNameVal != undefined && hotfixNameVal != "-1") {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},

	getHotfixName : function()
	{
		Ext.getCmp('hiddenPanel').hide();
		
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
		var hotfixId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
		var shwId = me.getFormitems().getComponent('infoCont').getComponent('countChoice');
		var osnameVal = osNameId.getValue();
		
		osNameId.setDisabled(true);
		hotfixId.setDisabled(true);
		//shwId.setDisabled(true);

		if(osnameVal == "-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.osError);
			return;
		}
		else
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
			}
			if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
			}

			this.getFormitems().submit({
				url : config.urls.configServletURL,
				params :"cmd=Availability&osOnly=Yes&view=Hotfix&needData=yes&request_from="+strRequestFrom+"&osName="+osnameVal+"&testName="+testName+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&id="+id+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),
				method : 'POST',
				success : function(form, action){
					myMask.hide();
					var publicJSON = Ext.decode(action.response.responseText);
					hiddenFieldsKeys = publicJSON.hiddenFields;

					hotfixId.getStore().removeAll();
					hotfixId.getStore().loadRawData(publicJSON['hotfixList']);
					if(publicJSON['selectedHotfixName'] != "" && publicJSON['selectedHotfixName'] != undefined)
					{
						hotfixId.setValue(publicJSON['selectedHotfixName']);
					}
					else
					{
						hotfixId.setValue(publicJSON['hotfixList'][0].valueField);
					}
					
					shwId.getStore().removeAll();
					shwId.getStore().loadRawData(publicJSON['showList']);
					if(publicJSON.selectedShowTopNRes != "" && publicJSON.selectedShowTopNRes != undefined)
					{
						shwId.setValue(publicJSON['selectedShowTopNRes']);
					}
					else
					{
						shwId.setValue(publicJSON['showList'][0].valueField);
					}

					delete publicJSON;
					osNameId.setDisabled(false);
					hotfixId.setDisabled(false);
					//shwId.disabled=false;

					if(publicJSON['selectedHotfixName'] != "" && publicJSON['selectedHotfixName'] != undefined)
					{
						me.setToolsState(true,publicJSON['selectedHotfixName']);
					}
					else
					{
						me.setToolsState(true,publicJSON['hotfixList'][0].valueField);
					}
				},
				failure : function(form, action)
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},

	onChangeCountChoice : function()
	{
		Ext.getCmp('hiddenPanel').hide();
	},

	getInformations : function()
	{
		Ext.getCmp('hiddenPanel').hide();
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
		var hotfixId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
		var shwId = me.getFormitems().getComponent('infoCont').getComponent('countChoice');
		var shwVal = shwId.getValue();
		var selHotfix = hotfixId.getValue();
		osNameId.setDisabled(true);
		hotfixId.setDisabled(true);
		//shwId.setDisabled(true);
		this.getFormitems().submit({
			url : config.urls.configServletURL,
			params :hiddenFields+"&cmd=Availability&osOnly=Yes&view=Hotfix&needData=yes&request_from="+strRequestFrom+"&id="+id+"&viewCount="+shwVal,
			method : 'POST',
			success : function(form, action){
				var publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				ec_criteria.getStore().loadRawData(publicJSON.viewByList);
				ec_criteria.setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					ec_userOption.setValue(publicJSON['selectedUserOption']);
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}

				osNameId.getStore().removeAll();
				osNameId.getStore().loadRawData(publicJSON['osList']);
				if(publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
				{
					osNameId.setValue(publicJSON['selectedOS']);
				}
				else
				{
					osNameId.setValue(publicJSON['osList'][0].valueField);
				}
				
				hotfixId.getStore().removeAll();
				hotfixId.getStore().loadRawData(publicJSON['hotfixList']);

				if(publicJSON['selectedHotfixName'] != "" && publicJSON['selectedHotfixName'] != undefined)
				{
					hotfixId.setValue(publicJSON['selectedHotfixName']);
				}
				else
				{
					hotfixId.setValue(publicJSON['hotfixList'][0].valueField);
				}
				
				shwId.getStore().removeAll();
				shwId.getStore().loadRawData(publicJSON['showList']);
				if(publicJSON.selectedShowTopNRes != "" && publicJSON.selectedShowTopNRes != undefined)
				{
					shwId.setValue(publicJSON['selectedShowTopNRes']);
				}
				else
				{
					shwId.setValue(publicJSON['showList'][0].valueField);
				}

				delete publicJSON;
				osNameId.setDisabled(false);
				hotfixId.setDisabled(false);
				//shwId.disabled=false;
				if(publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
				{
					me.setToolsState(true,publicJSON['selectedOS']);
				}
				else
				{
					me.setToolsState(true,publicJSON['osList'][0].valueField);
				}
			},
			failure : function(form, action)
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},



	showOrder : function()
	{
		Ext.getCmp('hiddenPanel').hide();
		var sftId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
		var sftVal = sftId.getValue();
		var shwId = me.getFormitems().getComponent('infoCont').getComponent('countChoice');

		if(sftVal != null && !sftVal == "")
		{
			if (sftVal=="All")
			{
				shwId.disabled=false; // countChoice is enabled
			}
			else
			{
				shwId.disabled=true;// countChoice is disabled
			}
		}
	},


	showStatusDetails : function()
	{
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var hotfixId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
		var hotfixName = hotfixId.getValue();
		var shwId = me.getFormitems().getComponent('infoCont').getComponent('countChoice');
		var countValue = shwId.getValue();
		var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
		var osname = osNameId.getValue();
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();

		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.validateForm();
			if (checkFlag == false)
			{
				return false;
			}
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
			}
			if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
			}
		
			Ext.Ajax.request({
				url: config.urls.servletURL,
				params : "cmd=Availability&needData=yes&view=Hotfix&requestFrom="+strRequestFrom+"&osName="+osname+"&testName="+testName+"&viewCount="+countValue+"&softwareName="+encodeURIComponent(filterEncode(hotfixName))+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),

				method: 'POST',
				success: function(response)
				{
					myMask.hide();
					var jsonData = Ext.decode(response.responseText);
					publicJSON = jsonData;
					hiddenFieldsKeys = jsonData.hiddenFields;
					var chartPlaceHolder = Ext.getCmp('chartPlaceHolder');
					
					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
						me.getErrorcontainer().show();
					}
					else
					{
						me.getErrorcontainer().hide();
						//thisCtrl.loadChartCt();

						if(jsonData.chartData !="" && jsonData.chartData != undefined)
						{
							thisCtrl.getHotfixavailabilitychart().loadChart(jsonData,thisCtrl);
						}
						thisCtrl.getMain().getComponent('hiddenPanel').show();
						
						thisCtrl.getMain().getComponent('hiddenPanel').setTitle(jsonData.containerTitle);


						var HtfxAvlblUnvlblCountData = publicJSON['htfxAvlblUnvlblCount'];
						
						if (!Ext.isEmpty(HtfxAvlblUnvlblCountData))
						{
							var hotfixStore = Ext.create('Ext.data.Store', {
								fields : ['HotfixName','availableCount','unavailableCount'],
								data: HtfxAvlblUnvlblCountData,
								proxy: {
									type: "pagingmemory",
									reader: {
										type: "json"
									}
								},
								remoteFilter : true,
								remoteSort: true,
								autoLoad: true,
								pageSize : 10,
								simpleSortMode: true
							});
							
							Ext.getCmp('HotfixNameCountGrid').reconfigure(hotfixStore);
							
							if (!Ext.isEmpty(HtfxAvlblUnvlblCountData) && HtfxAvlblUnvlblCountData.length > 10)
							{
								Ext.getCmp('tbseparatorId').show();
								Ext.getCmp('pagingtoolbartopid').show();
								Ext.getCmp('pagingtoolbarbottomid').show();
								Ext.getCmp('pagingtoolbartopid').bindStore(hotfixStore);
								Ext.getCmp('pagingtoolbarbottomid').bindStore(hotfixStore);
							}
							else
							{
								Ext.getCmp('tbseparatorId').hide();
								Ext.getCmp('pagingtoolbartopid').hide();
								Ext.getCmp('pagingtoolbarbottomid').hide();
						    }
						}
						// Ext.getCmp('mainGrid').show();
						// //Ext.getCmp('mainGrid').getStore().loadRawData(jsonData['resultantArray']);
						// var resultsData = publicJSON['resultantArray'];
						// if (!Ext.isEmpty(resultsData))
						// {
							// var store = Ext.create('Ext.data.Store', {
								// fields : ['hotfix','system'],
								// data: resultsData,
								// proxy: {
									// type: "pagingmemory",
									// reader: {
										// type: "json"
									// }
								// },
								// groupField : 'hotfix',
								// remoteFilter : true,
								// remoteSort: true,
								// autoLoad: true,
								// pageSize : 100,
								// simpleSortMode: true
							// });
							// Ext.getCmp('mainGrid').reconfigure(store);
							// if (!Ext.isEmpty(resultsData) && resultsData.length > 100)
							// {
								// Ext.getCmp('tbseparatorId').show();
								// Ext.getCmp('pagingtoolbartopid').show();
								// Ext.getCmp('pagingtoolbarbottomid').show();
								// Ext.getCmp('pagingtoolbartopid').bindStore(store);
								// Ext.getCmp('pagingtoolbarbottomid').bindStore(store);
							// }
							// else
							// {
								// Ext.getCmp('tbseparatorId').hide();
								// Ext.getCmp('pagingtoolbartopid').hide();
								// Ext.getCmp('pagingtoolbarbottomid').hide();
							// }

						// }
					}

					if(jsonData.resultantArray == "")
					{
						//me.setToolsState(true,jsonData['osList'][0].valueField);
						me.setToolsState(true,jsonData['selectedOS']);
					}
					else
					{
						Ext.getCmp('formitems').collapse();
						//me.setToolsState(false,jsonData['osList'][0].valueField);
						me.setToolsState(false,jsonData['selectedOS']);
					}
				},
				failure: function(form, action)
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},

	validateForm : function()
	{
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var tempCriteria = "";
		var tempUserOption = "";

		var hotfixId = me.getFormitems().getComponent('infoCont').getComponent('hotfixName');
		var hotfixName = hotfixId.getValue();
		var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
		var osname = osNameId.getValue();

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}
		
		if(osname == '-1')
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.osError);
			return false;
		}
		else if(hotfixName == '-1')
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.sysError);
			return false;
		}
	},


	forwardRequestedURI : function()
	{
		if ((backOperation != null && backOperation.schedule != undefined && backOperation.schedule))
		{
			var me = this;
			var ec_criteria = Ext.getCmp('ec_criteria').getValue();
			var osNameValue = Ext.getCmp('osName').getValue();
			var ec_userOption = Ext.getCmp('ec_userOption').getValue();
			var hotfixName = Ext.getCmp('hotfixName').getValue();
			var show = Ext.getCmp('countChoice').getValue();
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			window.location = "/final/config/EcSaveScheduleNew.jsp?request_from="+strRequestFrom+"&id="+id+"&"+hiddenFields+"&osName="+osNameValue+"&softwareName="+encodeURIComponent(filterEncode(hotfixName))+"&viewCount="+show+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria;
		}
		else if((backOperation != null && backOperation.historyBack != undefined && backOperation.historyBack))
		{
			window.history.back();
		}
	}
});



function loadURL(systemName)
{
	var system = Ext.String.trim(systemName);
	var criteria = Ext.getCmp('ec_criteria').getValue();
	var userOption = Ext.getCmp('ec_userOption').getValue();
	var softwareName = Ext.getCmp('hotfixName').getValue();
	var countChoice = Ext.getCmp('countChoice').getValue();
	var osName = Ext.getCmp('osName').getValue();

	var request_from = "Hotfix";

	if (strRequestFrom == "Hotfix")
	{
		request_from = "HotfixFromHomePage";
	}

	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?request_from="+request_from+"&cmd=BoxView&searchValue=&systemName=" + encodeURIComponent(system) + "&ec_criteria=" + criteria + "&ec_userOption=" + encodeURIComponent(userOption)+"&softwareName="+encodeURIComponent(filterEncode(softwareName))+"&viewCount="+countChoice+"&osName="+osName+"&testName="+testName+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken;

}


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}
