Ext.define('ComponentGroups.controller.Main',{
	extend: 'Ext.app.Controller',
	requires:['ComponentGroups.view.Main'],
	views:['Main'],
	refs:[{
		selector:'main',
		ref:'main'
	}],
	init:function(){
		this.control({
			'main':{
				render:this.renderMain
			},
			'main button[action=back]':{
       			click:this.backButtonHandler
       		},
		});
	},
	renderMain:function(){
		var urlValue='/final/monitor/EgDisplayGroupsData.jsp?'+querystring;
		var me= this;
		Ext.Ajax.request({
			url:urlValue,
			method : 'POST',
			scope:this,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if((!Ext.isEmpty(jsonData.componentNameObject)) && (!Ext.isEmpty(jsonData.componentNameObject.componentName)))
				{
					var groupTypeArray = jsonData.componentNameObject.componentName;

					var panelArray = [];
					var toolsArray = [];

					var contentGroupList = Ext.create('ComponentGroups.view.SystemComponentList',{
						jsonData:jsonData.componentNameObject,
					});
					panelArray.push(contentGroupList);
					me.getMain().add(panelArray);
					me.getMain().tools = [];

					toolsArray.push({
							xtype: 'tbseparator',
							padding:0,
						});

					for(i=0;i<jsonData.componentGroup.length;i++){
						toolsArray.push({
							xtype: 'button',
							margin:'5 0 0 0',
							padding:'0 5 0 5',
							style: {
								background: 'none',
								border: '0px'
							},
							iconCls:jsonData.componentGroup[i].iconCls,
							tooltip:jsonData.componentGroup[i].toolTip,
							urlLink:jsonData.componentGroup[i].url,
							listeners: {
								click: function(){
									document.location=this.urlLink;
								}
							}
						});

						toolsArray.push({
							xtype: 'tbseparator',
							padding:0,
						});
					}

					toolsArray.push({
						xtype:'button',
						cls:'backbutton',
						iconCls:'iconBack',
						text:backBut,
						listeners: {
							click: function(){
								//document.location="/final/monitor/segmentDashboard.jsp?selectNode="+requestParams2.segmentName+"&selectedParam="+requestParams2.segmentName+"&currentTab=topology&segment="+requestParams2.segmentName+"&aggregateTab=false&fromHomepage="+requestParams2.fromHomepage;
								if(serviceTopology != null && serviceTopology !='' && serviceTopology != 'undefiend' && serviceTopology == 'true')
								{
									var url = "/final/monitor/citrixDashboard.jsp?iniName=eg_citrixdashboard&action=loadViewData&user_name="+encodeURIComponent(requestParams2.user_name)+"&fromMenu=true&showConfig=true&fromUED=false&dashboard_name=Citrix_Dashboard&dashboard_mapping="+requestParams2.dashboard_mapping+"&view_name=Services_Topology_View&fromSerComboChange=true&fromServiceHomePage="+requestParams2.fromServiceHomePage+"&active_view=Topology&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&segmentName="+requestParams2.segmentName+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone;

									if(requestParams2.fromServiceHomePage != null && requestParams2.fromServiceHomePage !='' && requestParams2.fromServiceHomePage != 'undefiend' && requestParams2.fromServiceHomePage == 'true')
									{
										url = "/final/monitor/citrixDashboard.jsp?iniName=eg_citrixdashboard&action=loadViewData&user_name="+encodeURIComponent(requestParams2.user_name)+"&fromMenu=true&showConfig=true&fromUED=false&dashboard_name=Citrix_Dashboard&view_name=Services_Topology_View&fromSerComboChange=true&fromServiceHomePage="+requestParams2.fromServiceHomePage+"&active_view=Topology&appliesTo=Service:"+filterBy+"&filter=Service&filterBy="+filterBy+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&segmentName="+requestParams2.segmentName+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone;
									}

									if(isfromRum!= null && isfromRum !='' && isfromRum != 'undefiend' && isfromRum == 'true')
										url = "/final/monitor/rumAppFlow.jsp?iniName=eg_rumdashboard&userBased=true&fromMenu=true&user_name=admin&showConfig=true&dashboard_name=RUM_Dashboard&appliesTo="+selectedRum+"&isBackFromRUM=false&filter=Service&filterBy="+filterBy+"&view_name=topology_view"+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&segmentName="+requestParams2.segmentName+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone;
									document.location=url;
									return;
								}
								if (requestParams2.action=='service')
								{
									if(requestParams2.site!=null && requestParams2.site!=undefined && requestParams2.site!='NULL')
									{
										document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams2.site+"&topoSegment="+requestParams2.site+"&currentTab=topology&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams2.fromHomepage;
									}
									else if(requestParams2.serviceName!=null && requestParams2.serviceName!=undefined && requestParams2.serviceName!='NULL')
									{
										document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams2.serviceName+"&topoSegment="+requestParams2.serviceName+"&currentTab=topology&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams2.fromHomepage;
									}
									else
									{
										document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams2.site+"&topoSegment="+requestParams2.site+"&currentTab=topology&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams2.fromHomepage;
									}
								}
								else
								{
									var tmpSelectNode = requestParams2.segmentName;
									if(!Ext.isEmpty(tmpSelectNode) && (tmpSelectNode.indexOf('^')!= -1||tmpSelectNode.indexOf('|')!= -1))
									{
										tmpSelectNode = tmpSelectNode.replace('^','$cap$');
										tmpSelectNode = tmpSelectNode.replace('|','$pipe$');
									}
									document.location="/final/monitor/segmentDashboard.jsp?selectNode="+tmpSelectNode+"&selectedParam="+tmpSelectNode+"&currentTab=topology&segment="+tmpSelectNode+"&aggregateTab=false&fromHomepage="+requestParams2.fromHomepage;
								}
								//window.history.go(-1);
							}
						}
					});
					me.getMain().addTool(toolsArray);
				}
				else if((!Ext.isEmpty(jsonData.noMatch)))
				{
					me.getMain().removeAll(true);
					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
							xtype: 'container',
							padding: 50,
							style: {
								'text-align': 'center'
							},
							html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>'+jsonData.noMatch.NoMatchIndependent+'</div>'
						}]
					});
					me.getMain().add(emptyPanel);
				}
				else
				{
					me.getMain().removeAll(true);
					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
							xtype: 'container',
							padding: 50,
							style: {
								'text-align': 'center'
							},
							html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>'+noGroup+'</div>'
						}]
					});
					me.getMain().add(emptyPanel);
				}
			},
			failure : function(){
				//alert("failure");
			}
		});
	},
	backButtonHandler:function()
	{
		var tmpSelectNode = requestParams2.segmentName;
		if(!Ext.isEmpty(tmpSelectNode) && (tmpSelectNode.indexOf('^')!= -1||tmpSelectNode.indexOf('|')!= -1))
		{
			tmpSelectNode = tmpSelectNode.replace('^','$cap$');
			tmpSelectNode = tmpSelectNode.replace('|','$pipe$');
		}
		if(serviceTopology != null && serviceTopology !='' && serviceTopology !=undefiend && serviceTopology != 'undefiend' && serviceTopology == 'true')
		{
			var url = "/final/monitor/citrixDashboard.jsp?iniName=eg_citrixdashboard&action=loadViewData&user_name=admin&fromMenu=true&showConfig=true&fromUED=false&dashboard_name=Citrix_Dashboard&view_name=Services_Topology_View&fromSerComboChange=true&fromServiceHomePage=true&isFromZone=&iszoneName=&parentZone=&componentType=&componentNameSearch=&active_view=Topology&appliesTo=Service:"+filterBy+"&filter=Service&filterBy="+filterBy+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

			if(isfromRum!= null && isfromRum !='' && isfromRum !=undefiend && isfromRum != 'undefiend' && isfromRum == 'true')
				url = "/final/monitor/rumAppFlow.jsp?iniName=eg_rumdashboard&userBased=true&fromMenu=true&user_name=admin&showConfig=true&dashboard_name=RUM_Dashboard&appliesTo="+selectedRum+"&isBackFromRUM=false&filter=Service&filterBy="+filterBy+"&view_name=topology_view"+"&isFromZone=&iszoneName=&parentZone=&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
			document.location=url;
		}
		else
		{
			//window.history.go(-1);
			document.location="/final/monitor/segmentDashboard.jsp?selectNode="+tmpSelectNode+"&selectedParam="+tmpSelectNode+"&currentTab=topology&segment="+tmpSelectNode+"&aggregateTab=false&fromHomepage="+requestParams2.fromHomepage;
		}
	}

});