var cmd = Ext.create('RemoteControlAction.view.RemoteControlActionCmd')
Ext.define('RemoteControlAction.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'remotecontrolactionForm',ref:'remotecontrolactionForm'},
		{selector:'cmd',ref:'cmd'}
	],
	init:function(){
		me=this;
		this.control({
			'remotecontrolactionForm button[name="execute"]':{
				'click':this.showResult
			},
			'remotecontrolactionForm button[name="upload"]':{
				'click':this.fileUpload
			},
			'remotecontrolactionForm combo[id="executionMode"]':{
				'select':this.loadActionData
			},
			'remotecontrolactionForm combo[id="usernames"]':{
				'select':this.loadSessionFormData
			},
			'remotecontrolactionForm combo[id="usernames_multiple"]':{
				'select':this.loadSessionFormData
			},
			'remotecontrolactionForm combo[id="delivery_grp_name"]':{
				'select':this.changeDeliveryGroup
			},
			'remotecontrolactionForm combo[id="delivery_grp_name_multi_select"]':{
				'select':this.changeDeliveryGroup
			},
			'remotecontrolactionForm combo[id="machine_name"]':{
				'select':this.changeDnsName
			},
			'remotecontrolactionForm combo[id="rmt_cmds"]':{
				'select':this.loadActionData
			},
			'remotecontrolactionForm combo[id="logonModes"]':{
				'select':this.changelogonModes
			},
			'remotecontrolactionForm combo[id="user_session_id"]':{
				'select':this.changeSessionId
			},
			'remotecontrolactionForm combo[id="user_session_id_multiple"]':{
				'select':this.changeSessionId
			},
			'remotecontrolactionForm scrollcombo[id="user_process_name"]':{
				'select':this.changeProcessName
			},
			'remotecontrolactionForm combo[id="pid_multi_select"]':{
				'select':this.changePidName
			},
			'remotecontrolactionForm combo[id="license_username"]':{
				'select':this.changeLicenseUsername
			},
			'remotecontrolactionForm combo[id="license_machinename"]':{
				'select':this.changeLicenseMachinename
			},
			'remotecontrolactionForm combo[id="ad_username"]':{
				'select':this.changeADUsername
			},
			'remotecontrolactionForm combo[id="select_an_privileged_action"]':{
				'select':this.changePrivilegedAction
			},
			'main' :
			{
				'boxready' : this.loadDefaultFormData
			},
			'main  #upbutton':
			{
				'click':this.toggleForm
			},
			'main button[id="bckBtn"]':
			{
				'click' : this.goBack
			}
		});
	},
	toggleForm:function(){
		var ornt = Ext.getCmp('remotecontrolform');
		ornt.toggleCollapse(true);
	},
	showResult : function()
	{
		Ext.getCmp('remote_cmd').removeAll();
		var allowed="true";
		//rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
		//	//msg : executingLbl+", "+waitLbl+".."
		//	  msg : executingLbl
		//	//msg : "Changing to control mode.<br/> &nbsp &nbsp &nbsp &nbsp &nbsp Please wait ..."
		//});
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var s_username = thisForm.findField('usernames').getValue();
		var s_usernames_multiple = thisForm.findField('usernames_multiple').getValue();		
		var rmt_cmd = thisForm.findField('rmt_cmds').getValue();
		var executionMode = thisForm.findField('executionMode').getValue();	
		var selectedIgelAction = thisForm.findField('select_an_action').getValue();
		var selectedPriviligedAction = thisForm.findField('select_an_privileged_action').getValue();
		var restartMachine = thisForm.findField('restart_a_machine_yes_no').getValue();		
		if(restartMachine=="true" || restartMachine==true)
		{
			restartMachine='yes';
		}
		else
		{
			restartMachine="no";
		}		
		var tmp = rmt_cmd.substring(rmt_cmd.indexOf(":")+1);		
		if(rmt_cmd.indexOf(":")>-1){			
			rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));			
			if(rmt_cmd &&  rmt_cmd.startsWith("FILE#")){
				rmt_cmd = 'executeCustomScript';
				tmp = 'file';
			}
		}
		else if(rmt_cmd &&  rmt_cmd.startsWith("CMD#")){
				tmp = 'CMD';
		}else {
			if(rmt_cmd &&  rmt_cmd.startsWith("FILE#")){
				rmt_cmd = 'executeCustomScript';
			}
		}		
		if(rmt_cmd == "RC_57" && executionMode == "System Wise")
			rmt_cmd = "firewallAuthApp.vbs";
		else if(rmt_cmd == "RC_58" && executionMode == "System Wise")
			rmt_cmd = "set";
		else if(rmt_cmd == "RC_61" && executionMode == "System Wise")
			rmt_cmd = "startupitemslatest.ps1";
		else if(rmt_cmd == "RC_62")
			rmt_cmd = "showWmiClasses.ps1";		
		if((tmp == "OS" && !rmt_cmd.startsWith("RC_") ) || tmp == "Other" || tmp == "CMD"  || (tmp == "VMAgentOS" && (!rmt_cmd.startsWith("RC_") && !rmt_cmd.startsWith("DownloadImage")))){
			if(thisForm.findField('rmt_cmds').getValue() == 'getActiveFilesReport:OS' || thisForm.findField('rmt_cmds').getValue() == 'getActiveFilesReport:VMAgentOS')
			{
				var event_capture_obj = thisForm.findField('event_capture');
				if(Ext.isEmpty(event_capture_obj))
				{
					
					Ext.Msg.show({
						title:alertTitle,
						msg: event_capture_msg_label,
						buttons: Ext.Msg.OK,
						width: 250,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp("event_capture").focus();
						}
					});
					return;
				}
				else if(!checkNumberVal("+",event_capture_obj.getValue()))
				{
					Ext.Msg.show({
						title:alertTitle,
						msg: event_capture_msg_label,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'	
					});
					return false;
				}
				else if(parseInt(event_capture_obj.getValue())<1 || parseFloat(event_capture_obj.getValue())>30)
				{
					Ext.Msg.show({
						title:alertTitle,
						msg: 'Please enter values between 1 and 30',
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'	
					});
					return false;
				}
			}
			this.showOSResult();
		}
		else if(rmt_cmd == "RC_32")
		{
			this.showOSResult();
		}
		else {
		var user_session_id = thisForm.findField('user_session_id').getValue();
		var user_session_id_multiple = thisForm.findField('user_session_id_multiple').getValue();
		var user_process_id = thisForm.findField('user_process_name').getValue();
		var auditlog_user_process_name = '';
		if(user_process_id != null && user_process_id != undefined && user_process_id != 'undefined')
		{
			auditlog_user_process_name=filterEncode(thisForm.findField('user_process_name').displayTplData[0].displayField);
		}
		var user_session_message = thisForm.findField('msg_box').getValue();
		var logon_mode = thisForm.findField('logonModes').getValue();

		var delivery_group_name = thisForm.findField('delivery_grp_name').getValue();
		var delivery_grp_multiSelect = thisForm.findField('delivery_grp_name_multi_select').getValue();	
		var machine_name = thisForm.findField('machine_name').getValue();
		var pid_multiSelect = thisForm.findField('pid_multi_select').getValue();
		var license_user_name = thisForm.findField('license_username').getValue();
		var license_machine_name = thisForm.findField('license_machinename').getValue();

		var ad_user_name = thisForm.findField('ad_username').getValue();
		if(rmt_cmd == 'RC_6' && pid_multiSelect != null && pid_multiSelect.indexOf('-1')>-1)
		{
			Ext.Msg.show({
				title:alertTitle,
				msg: 'Please select a PID',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else if(rmt_cmd == 'RC_29')
		{
			ad_user_name = thisForm.findField('arugumentsTextBox').getValue();
			if(ad_user_name != undefined && ad_user_name!=null && ad_user_name.trim().length ==0){
				Ext.Msg.show({
					title:alertTitle,
					msg: alertMsg1,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		else if(rmt_cmd == 'RC_24')
		{
			var hotfixID = thisForm.findField('arugumentsTextBox').getValue();
			if(Ext.isEmpty(hotfixID))
			{
				Ext.Msg.show({
					title:alertTitle,
					msg: alertMsg2,
					buttons: Ext.Msg.OK,
					width: 250,
					icon: 'iconExclamation',
					fn: function(){
						Ext.getCmp("arugumentsTextBox").focus();
					}
				});
				return;
			}
		}
		else if(rmt_cmd == 'RC_60')
		{
			var object = thisForm.findField('arugumentsTextBox').getValue();
			
			if(Ext.isEmpty(object))
			{
				var objectAlertMsg = "Please enter a valid Object";
				Ext.Msg.show({
					title:alertTitle,
					msg: objectAlertMsg,
					buttons: Ext.Msg.OK,
					width: 250,
					icon: 'iconExclamation',
					fn: function(){
						Ext.getCmp("arugumentsTextBox").focus();
					}
				});
				return;
			}
		}
		else if(rmt_cmd == 'RC_86')
		{
			var svalue = thisForm.findField('pid_multi_select').getValue();
			if(svalue=='-1')
			{
				var objectAlertMsg = "Please select a PID";
				Ext.Msg.show({
					title:alertTitle,
					msg: objectAlertMsg,
					buttons: Ext.Msg.OK,
					width: 250,
					icon: 'iconExclamation',
					fn: function(){
						Ext.getCmp("pid_multi_select").focus();
					}
				});
				return;
			}
		}
		var ad_password = thisForm.findField('ad_password').getValue();
		var ad_confirm_password = thisForm.findField('ad_confirm_password').getValue();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();
		if(rmt_cmd=='RC_30')
		{
			var tmpStr=thisForm.findField('arugumentsTextBox').getValue();
			if(tmpStr.trim().length==0)
			{
				Ext.MessageBox.alert(alertTitle,username_alert);
				return;
			}
			else if(tmpStr.trim().length>0 && (tmpStr.indexOf('\\')==-1 || tmpStr.endsWith('\\') || tmpStr.indexOf('\\') != tmpStr.lastIndexOf('\\')))
			{
				Ext.MessageBox.alert(alertTitle,wrong_format);
				return;
			}
			else if(ad_password.trim().length==0)
			{
				Ext.MessageBox.alert(alertTitle,password_alert);
				return;
			}
			else if(ad_password != ad_confirm_password)
			{
				Ext.MessageBox.alert(alertTitle,password_alert);
				return;
			}
		}
		var delivery_group_enable_disable = thisForm.findField('delivery_group_enable_disable').getValue();
		if(delivery_group_enable_disable=="true" || delivery_group_enable_disable==true)
		{
			delivery_group_enable_disable='enable';
		}
		else
		{
			delivery_group_enable_disable="disable";
		}
		if(rmt_cmd=='RC_5' && user_session_message.trim().length==0)
		{
			Ext.MessageBox.alert(alertTitle,msg_alert);
			allowed="false";
		}
		
		if(allowed=="true")
		{
			var remoteCmd = Ext.getCmp('remote_cmd');
			remoteCmd.removeAll();
			Ext.getCmp('execute').setDisabled(true);
			//if(rmt_cmd != 'RC_17' && rmt_cmd != 'RC_4')	
			{
				//rcLoadMask.show();
			}
			remoteCmd.show();
			var hiddenQStr = publicJson['hiddenQStr'];
			ad_user_name = filterEncode(ad_user_name);
			var displayTxtCmd = filterEncode(thisForm.findField('rmt_cmds').displayTplData[0].displayField);
			var key_value_params = "ctx_username="+s_username+"&rmt_cmd="+rmt_cmd+"&user_session_id="+user_session_id+"&user_process_id="+user_process_id+"&user_session_message="+filterEncode(user_session_message)+'&logon_mode='+logon_mode+'&machine_name='+machine_name+'&delivery_group_name='+delivery_group_name+'&delivery_grp_multiSelect='+delivery_grp_multiSelect+'&delivery_group_enable_disable='+delivery_group_enable_disable+'&license_user_name='+license_user_name+'&license_machine_name='+license_machine_name+'&ad_user_name='+ad_user_name+'&ad_password='+ad_password+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+"&displayTxtCmd="+displayTxtCmd+'&test='+tmp+"&hostname="+hostName+'&port='+init_port+'&comptype='+init_comp_type+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&auditlog_user_process_name='+auditlog_user_process_name+'&pid_multiSelect='+pid_multiSelect+'&processName='+processName+'&s_usernames_multiple='+s_usernames_multiple+'&user_session_id_multiple='+user_session_id_multiple;
			if(rmt_cmd=='executeCustomScript'){
				var fileName = thisForm.findField('rmt_cmds').getValue();
				if(fileName &&  fileName.startsWith("FILE#")){
					fileName = fileName.substring(fileName.indexOf("#") + 1);
					if(fileName.indexOf(":") > -1){
						fileName = fileName.substring(0, fileName.indexOf(":"));
					}
				}
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params = key_value_params + '&agentIP='+agentIP+'&fileName='+fileName+'&customAction='+displayTxtCmd+"&customArguments="+params;
			}		
			else if(rmt_cmd == 'RC_24')
			{
				var hotfixId = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params += "&hotfixid="+hotfixId;
			}
			else if(rmt_cmd == 'RC_30')
			{
				var params = thisForm.findField('arugumentsTextBox').getValue();	
                params = filterEncode(params);			
				key_value_params = key_value_params+"&customArguments="+params;
			}
			else if(rmt_cmd == 'RC_50')
			{			
				var params = thisForm.findField('arugumentsTextBox').getValue();	
                params = filterEncode(params);			
				key_value_params = key_value_params+"&customArguments="+params;
			}
			else if(rmt_cmd == 'RC_51')
			{
				var select_an_privileged_action = thisForm.findField('select_an_privileged_action').getValue();
				key_value_params += "&select_an_privileged_action="+select_an_privileged_action;
			}
			else if(rmt_cmd == 'RC_60')
			{
				var objectName = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params += "&objectName="+objectName; 
			}
			else if(rmt_cmd == 'RC_63')
			{
				var thinClient = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params += "&thinClient="+thinClient+"&selectedIgelAction="+selectedIgelAction; 
			}		
			else if(rmt_cmd == 'RC_67' || rmt_cmd == 'RC_75')
			{
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params = key_value_params+"&customArguments="+params;
			}	
			else if(rmt_cmd == 'RC_68' || rmt_cmd == 'RC_74')
			{
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params = key_value_params+"&restartMachine="+restartMachine+"&customArguments="+params;
			}
			else if(rmt_cmd == 'RC_69')
			{				
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params += "&restartMachine="+restartMachine+"&customArguments="+params;
			}	
			else if(rmt_cmd == 'RC_70')
			{		
				var controller = thisForm.findField('namespace').getValue();
				var duration = thisForm.findField('classes').getValue();
				key_value_params += "&duration="+duration+"&controller="+controller;
			}	
			else if(rmt_cmd == 'RC_73')
			{		
				var params = thisForm.findField('arugumentsTextBox').getValue();
				key_value_params = key_value_params+"&customArguments="+params;
			}
			else if(rmt_cmd == 'RC_77')
			{		
				var params = thisForm.findField('cmdSyntax').getValue();
				key_value_params = key_value_params+"&cmdSyntax="+params;
				var vdaAction = thisForm.findField('shutdown_and_restart_id').getValue();
				key_value_params = key_value_params+"&vdaAction="+vdaAction;
			}
			else if(rmt_cmd == 'RC_80')
			{
				var params = thisForm.findField('cmdSyntax').getValue();
				key_value_params = key_value_params+"&cmdSyntax="+params;
			}
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			var winHeight = Ext.getCmp('remote_control').getHeight();
			var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
			if(rmt_cmd == 'RC_41'){
				var shadowMode = thisForm.findField('shadow_mode').getValue().shadow_mode;
				if(isThisVDICompType=='true')
				{	
					progressBarHandle=showWindow();
					Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionp.jsp',
						method : 'POST',
						params: 'onlyHostname=yes&isJsonResp=true&response1=yes&agentIP='+agentIP+'&hostName='+hostName+'&selCmd=hostname&txtCmd1=hostname&displayTxtCmd=Show server name&arguments=&txtCmd=hostname&response=Yes&txtTimeout=300&txtTimeStamp=1638331441488&vmName='+vmName+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&agentOS=Windows2019',
						timeout:timeOutValForAjax,
						scope:this,
						success: function(response)
						{
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
							var jsonText = response.responseText;
							var jsonData=Ext.decode(jsonText);
							if(!Ext.isEmpty(jsonData))
							{
								var only_hostname='-';
								var errorMessage = jsonData['errorMessage'];
								if(errorMessage!=null && errorMessage!="-")
								{
									alert("error occured");
								}
								else
								{
									only_hostname=jsonData['hostnameOnly'];
								}
								Ext.Ajax.request({
									url : '/final/monitor/RemoteControlActionUtils.jsp?cmd='+rmt_cmd+"&agentIP="+agentIP+"&shadowMode="+shadowMode+"&user_session_id="+user_session_id+"&isAgentBased="+isAgentBased+"&rmtOrExtAgentIp="+rmtOrExtAgentIp+'&init_comp_type='+init_comp_type+'&only_hostname='+only_hostname+'&isThisVDICompType='+isThisVDICompType+'&user_session_id_multiple='+user_session_id_multiple,
									method : 'POST',
									timeout:timeOutValForAjax,
									scope:this,
									success: function(response)
									{
										var displayMsg;
										if(outputRqrd == "Yes" || outputRqrd == "yes"){
											displayMsg = remoteControlLbl+". <br>"+downloadTitle+" ."+batfileTitle+".";
										}
										else{
											displayMsg = remoteControlSuccessTitle;
										}
										window.location.href= "../images/RemoteControl/shadow_"+agentIP+"_session"+user_session_id+".bat";
										Ext.getCmp('execute').setDisabled(false);
										//rcLoadMask.hide();
										var updatepanel=Ext.getCmp('remote_cmd');
										var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/success_msg_icon.png'></div>";
										output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+displayMsg+"<\/li></span></div></div></ul>";
										updatepanel.add({
											xtype: 'panel',
											margin:10,
											height:cmdHeight,
											cls:'formOuter',
											id:'updatepanel',
											html:output
										});
										updatepanel.doLayout();
										remoteCmd.show();
									},
									failure: function(response)
									{
										Ext.getCmp('execute').setDisabled(false);
									}
								});
							}
						},
						failure:function()
						{
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
						}
					});
				}
				else
				{
					progressBarHandle=showWindow();	
					Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionUtils.jsp?cmd='+rmt_cmd+"&agentIP="+agentIP+"&shadowMode="+shadowMode+"&user_session_id="+user_session_id+"&isAgentBased="+isAgentBased+"&rmtOrExtAgentIp="+rmtOrExtAgentIp+'&user_session_id_multiple='+user_session_id_multiple,
						method : 'POST',
						timeout:timeOutValForAjax,
						scope:this,
						success: function(response)
						{
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
							var displayMsg;
							if(outputRqrd == "Yes" || outputRqrd == "yes"){
								displayMsg = remoteControlLbl+". <br>"+downloadTitle+" ."+batfileTitle+".";
							}
							else{
								displayMsg = remoteControlSuccessTitle;
							}
							window.location.href= "../images/RemoteControl/shadow_"+agentIP+"_session"+user_session_id+".bat";
							Ext.getCmp('execute').setDisabled(false);
							//rcLoadMask.hide();
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/success_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+displayMsg+"<\/li></span></div></div></ul>";
							updatepanel.add({
								xtype: 'panel',
								margin:10,
								height:cmdHeight,
								cls:'formOuter',
								//bodyStyle:{'background':'lightred !important'},
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();
							remoteCmd.show();
						},
						failure: function(response)
						{
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
							Ext.getCmp('execute').setDisabled(false);
						}
					});
				}
			}
			else {
				//console.log('238',rmt_cmd);
				key_value_params += "&vmName="+vmName+"&agentIP="+agentIP;			
				var obj = {'key_value_params':key_value_params,'timeOutValForAjax':timeOutValForAjax,'cmdHeight':cmdHeight,'fileName':fileName,'remoteCmd':remoteCmd,'rmt_cmd':rmt_cmd};			
				if(rmt_cmd == 'RC_17' || rmt_cmd == 'RC_4' || rmt_cmd == 'RC_68' || rmt_cmd == 'RC_77' || rmt_cmd == 'RC_74' || rmt_cmd == 'RC_69' ||  rmt_cmd == 'RC_78'){
					var alertMessage = "";
					if(rmt_cmd == 'RC_17')
						alertMessage = "Are you sure want to Lock?"
					else if(rmt_cmd == 'RC_68')
					{
						if(restartMachine.toLowerCase()=='yes') {
							alertMessage = "Do you want to shutdown the machines?"
						}
						else {
							alertMessage = "Do you want to show the machines?"
						}
					}
					else if(rmt_cmd == 'RC_77')
						alertMessage = "Do you want to perform the selected action?"
					else if(rmt_cmd == 'RC_74')
						alertMessage = "Do you want to restart the machines?"
					else if(rmt_cmd == 'RC_69')
						alertMessage = "Do you want to restart the machines?"
					else if(rmt_cmd == 'RC_78')
						alertMessage = "Do you want to log off the selected VDA session?"
					else
						alertMessage = "Do you want to log off this user session?"
					Ext.MessageBox.show({
						title : 'Confirm', 
						msg : alertMessage, 
						buttons : Ext.MessageBox.YESNO, 
						fn : callbackFunction, 
						icon : 'iconConfirmation'
					});
					function callbackFunction(btn){
						if (btn == 'yes') {
							callRemoteControlAppActionP(obj);
						}else {
							Ext.getCmp('execute').setDisabled(false);			
						}
					}
				}
				else {					
					if(rmt_cmd == 'RC_6')
					{
						if(multiple_users_supported_task)
						{
							thisForm.findField("pid_multi_select").hide();
							Ext.getCmp('execute').setVisible(false);
							thisForm.findField("user_process_name").hide();
							thisForm.findField("user_process_name").setValue('-1');
							thisForm.findField("pid_multi_select").setValue('-1');
							thisForm.findField('user_session_id').setValue("-1");
							thisForm.findField('user_session_id_multiple').setValue("-1");
							//thisForm.findField('user_session_id_multiple').boundList.getSelectionModel().selectAll();
						}
						else
						{
							thisForm.findField("pid_multi_select").hide();
							Ext.getCmp('execute').setVisible(false);
							thisForm.findField("user_process_name").hide();
							thisForm.findField('user_session_id').setValue("-1");
							thisForm.findField('user_session_id_multiple').hide;
						}
					}
					callRemoteControlAppActionP(obj);
				}
			}
			}
		}
	},
	changeUsername :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('rmt_cmds').hide();	
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_session_id_multiple').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('pid_multi_select').hide();
		var rmt_cmd = combo.getValue();
		if(combo.getValue() !='-1')
		{
			thisForm.findField('rmt_cmds').show();	
		}
	},
	changePrivilegedAction : function(combo)
	{
		var rmt_cmd = combo.getValue();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		if(rmt_cmd == 'setspn -L')
		{  
			thisForm.findField('arugumentsTextBox').setFieldLabel("Target Account");
			thisForm.findField('arugumentsTextBox').emptyText = "egin.local.hostname";
			thisForm.findField('arugumentsTextBox').applyEmptyText();
			thisForm.findField('arugumentsTextBox').show();
		}
		else if(rmt_cmd == 'setspn -Q')
		{			
			thisForm.findField('arugumentsTextBox').setFieldLabel("SPN Name");
			thisForm.findField('arugumentsTextBox').emptyText = "sample spn name";
			thisForm.findField('arugumentsTextBox').applyEmptyText();
			thisForm.findField('arugumentsTextBox').show();
		}
		else if(rmt_cmd == 'setspn -X')
		{
			thisForm.findField('arugumentsTextBox').hide();
			thisForm.findField('arugumentsTextBox').setValue("");
		}		
	},
	changeDeliveryGroup :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_session_id_multiple').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('pid_multi_select').hide();
		thisForm.findField('machine_name').hide();
		thisForm.findField('delivery_group_status').hide();
		if(combo.getValue() !='-1')
		{
			if(rmt_cmd=='RC_22' || rmt_cmd=='RC_74' || rmt_cmd=='RC_76' || rmt_cmd=='RC_77'){
				thisForm.findField('delivery_group_status').hide();
			}
			else if(rmt_cmd == 'RC_80')
			{				
				this.loadActionData('RC_80');
			}				
			else{			
				thisForm.findField('delivery_group_status').show();
			}
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
			enableDisableEls(rmt_cmd);
		}
	},
	changeDnsName :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		remoteCmd.show();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		Ext.getCmp('execute').setVisible(false);
		
		thisForm.findField('msg_box').hide();			
		thisForm.findField('user_session_id').hide();
		thisForm.findField('user_session_id_multiple').hide();
		thisForm.findField('user_process_name').hide();
		thisForm.findField('pid_multi_select').hide();
		thisForm.findField('delivery_grp_name').hide();
		thisForm.findField('delivery_group_status').hide();
		if(combo.getValue() !='-1')
		{
			thisForm.findField('delivery_group_status').show();
			//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
			enableDisableEls();
		}
	},
	changeCommand :  function()
	{
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		var winHeight = Ext.getCmp('remote_control').getHeight();
		var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
		Ext.getCmp('execute').setVisible(false);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('outputRqrd').setValue('Yes');
		thisForm.findField('shadow_mode').hide();
		//rcLoadMask.hide();
		if(rmt_cmd=='-1')
		{
			thisForm.findField('msg_box').hide();			
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('delivery_group_status').hide();
		}
		else if(rmt_cmd=='DownloadImage')
		{
			// Show me screenshot
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				Ext.getCmp('execute').setVisible(true);
			}
		}
		else if(rmt_cmd=='RC_0')
		{
			//View session
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				Ext.getCmp('execute').setVisible(true);
			}
		}
		else if(rmt_cmd=='RC_1' || rmt_cmd=='RC_11' || rmt_cmd=='RC_12' || rmt_cmd=='RC_13' || rmt_cmd=='RC_21' || rmt_cmd=='RC_45' || rmt_cmd=='RC_46' || rmt_cmd=='RC_47' || rmt_cmd=='RC_66')
		{
			// Get user processes (query process <username>)
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_41' && isThisVDICompType=='true')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			thisForm.findField('shadow_mode').hide();
			Ext.getCmp('execute').setVisible(true);
		}		
		else if(rmt_cmd=='RC_2'  || rmt_cmd=='RC_54' || rmt_cmd=='RC_41' || rmt_cmd=='RC_42' || rmt_cmd=='RC_43' || rmt_cmd=='RC_71' || rmt_cmd=='RC_85')
		{
			//View processes of a session (query process /ID:<session id>)
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				if(rmt_cmd=='RC_41')
				{
					thisForm.findField('shadow_mode').show();
				}
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();

				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(rmt_cmd=='RC_41')
				{
					thisForm.findField('shadow_mode').show();
				}
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_3')
		{
			// Disconnect the session (tsdiscon <session id>)
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_4')
		{
			// Logoff the session  (logoff.exe <sessionid>)
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();			
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_5')
		{
			// Send Message to a session (<msg.exe <sessionid> /Time:10 <message to send>)
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();		
			if(multiple_users_supported_task)
			{
				this.changeSessionId();
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
				{
					thisForm.findField('msg_box').show();
					Ext.getCmp('execute').setVisible(true);
				}
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_6')
		{
			// Kill a process running in a session (taskkill /f /FI "Session eq <sessionid>" /PID <pid> /T)
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				if(singleSessionId!='-1')
				{
					this.getRemotecontrolactionForm().loadSessionData();
				}
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_8')
		{
			// display services hosted in process
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				if(singleSessionId!='-1')
				{
					this.getRemotecontrolactionForm().loadSessionData();
				}
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_9')
		{
			// display services hosted in process
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				this.getRemotecontrolactionForm().loadSessionData();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				if(singleSessionId!='-1')
				{
					this.getRemotecontrolactionForm().loadSessionData();
				}
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_10' || rmt_cmd=='RC_23')
		{
			//printer
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_14')
		{
			// Changes the XenApp Logon Mode for the selected server
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').show();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();

			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_16')
		{
			// Drain Remote Desktop Sessions
			if(multiple_users_supported_task)
			{
				thisForm.findField('usernames').hide();
				thisForm.findField('usernames_multiple').hide();
			}
			else
			{
				thisForm.findField('usernames').hide();
				thisForm.findField('usernames_multiple').hide();
			}
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_17' || rmt_cmd=='RC_56' || rmt_cmd=='RC_83' || rmt_cmd=='RC_84')
		{
			//Lock User's Desktop session
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_57' || rmt_cmd=='RC_58' || rmt_cmd=='RC_61')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').show();			
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').setValue(singleSessionId);
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			if(singleSessionId!='-1')
				Ext.getCmp('execute').setVisible(true);
			else				
				Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_18')
		{
			//List users mapped network drives
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				Ext.getCmp('execute').setVisible(true);
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
				thisForm.findField('user_process_name').hide();
				thisForm.findField('pid_multi_select').hide();
				thisForm.findField('logonModes').hide();
				thisForm.findField('delivery_grp_name').hide();
				thisForm.findField('machine_name').hide();
				thisForm.findField('delivery_group_status').hide();
				thisForm.findField('user_session_id').setValue(singleSessionId);
				thisForm.findField('user_process_name').setValue('-1');
				thisForm.findField('pid_multi_select').setValue('-1');
				thisForm.findField('msg_box').setValue('none');
				thisForm.findField('logonModes').setValue('-1');
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				if(singleSessionId!='-1')
					Ext.getCmp('execute').setVisible(true);
				else				
					Ext.getCmp('execute').setVisible(false);
			}
		}
		else if(rmt_cmd=='RC_19')
		{
			//Enable Maintenance on Brokered machine
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').show();
			thisForm.findField('delivery_grp_name').hide();			
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_20' || rmt_cmd=='RC_22')
		{
			//Enable/Disable Desktop Delivery Group
			//Citrix Delivery Controller 7.x component.
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			Ext.getCmp('deliveryGroupContainer').hide();
			thisForm.findField('delivery_grp_name_multi_select').hide();			
			thisForm.findField('delivery_grp_name').show();			
			thisForm.findField('delivery_group_status').hide();
			
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_grp_name').setValue('-1');
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_65' || rmt_cmd=='RC_79')
		{
			//Enable/Disable Desktop Delivery Group
			//Citrix Delivery Controller 7.x component.
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			Ext.getCmp('deliveryGroupContainer').show();
			thisForm.findField('delivery_grp_name_multi_select').show();			
			thisForm.findField('delivery_grp_name').hide();			
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_grp_name').setValue('-1');
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_68')
		{
			//Enable/Disable Desktop Delivery Group
			//Citrix Delivery Controller 7.x component.											
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			Ext.getCmp('deliveryGroupContainer').show();
			thisForm.findField('delivery_grp_name_multi_select').show();	
			thisForm.findField('restart_a_machine').show();
			thisForm.findField('restart_a_machine').setFieldLabel('Action On Machine');
			thisForm.findField('delivery_grp_name').hide();			
			thisForm.findField('delivery_group_status').hide();											
			thisForm.findField('arugumentsTextBox').setFieldLabel("Days");				
			thisForm.findField('arugumentsTextBox').emptyText = "30";			
			thisForm.findField('arugumentsTextBox').applyEmptyText();				
			thisForm.findField('arugumentsTextBox').show();
			if(multiple_users_supported_task)
			{			
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{			
				thisForm.findField('user_session_id').setValue(singleSessionId);			
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_grp_name').setValue('-1');
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd == 'RC_74')
		{	
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').show();			
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');		
			thisForm.findField('arugumentsTextBox').emptyText = "localhost";
			thisForm.findField('arugumentsTextBox').setFieldLabel("Controller");
			thisForm.findField('arugumentsTextBox').applyEmptyText();				
			thisForm.findField('arugumentsTextBox').show();	
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd == 'RC_76')
		{	
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').show();			
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');				
			//thisForm.findField('arugumentsTextBox').show();	
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd == 'RC_77')
		{	
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').show();			
			thisForm.findField('shutdown_and_restart').show();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');			
			thisForm.findField('delivery_group_status').setFieldLabel("Actions");
			//thisForm.findField('dged1').setFieldLabel("Shutdown");
			//thisForm.findField('dged2').setFieldLabel("Restart");
			thisForm.findField('cmdSyntax').setFieldLabel("VM DNS Name");
			thisForm.findField('cmdSyntax').emptyText="Machine1,Machine2";
			thisForm.findField('cmdSyntax').applyEmptyText();
			thisForm.findField('cmdSyntax').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd == 'RC_78')
		{	
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_grp_name').hide();			
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');				
			//thisForm.findField('arugumentsTextBox').show();	
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_25')
		{
			// Release Citrix user license
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('ctx_user_machine_name').show();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd == 'RC_80')
		{	
			thisForm.findField('msg_box').hide();
			thisForm.findField('delivery_grp_name').show();	
			if(init_test_name == 'CtxXcXDCSessionTest')	
			{				
				thisForm.findField('pid_multi_select').show();
				//thisForm.findField('user_session_id').show();
				thisForm.findField('cmdSyntax').setFieldLabel("Message");
				thisForm.findField('cmdSyntax').emptyText="Hello";
				thisForm.findField('cmdSyntax').applyEmptyText();
				thisForm.findField('cmdSyntax').show();
			}
			else
			{
				if(multiple_users_supported_task)
				{
					thisForm.findField('user_session_id').hide();
					thisForm.findField('user_session_id_multiple').hide();
				}
				else
				{
					thisForm.findField('user_session_id').hide();
					thisForm.findField('user_session_id_multiple').hide();
				}
			}
			thisForm.findField('user_process_name').hide();
			//thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('machine_name').hide();					
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			thisForm.findField('machine_name').setValue('-1');
			thisForm.findField('delivery_group_status').setValue('-1');				
			//thisForm.findField('arugumentsTextBox').show();	
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_27' || rmt_cmd=='RC_28' || rmt_cmd=='RC_29')
		{
			// Unlock AD Accounts // Unlock AD Accounts //Disable Active Directory account
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('ctx_user_machine_name').hide();
			thisForm.findField('ad_username').setValue('-1');
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();
			Ext.getCmp('execute').setVisible(false);
			var adUserNameOpts = thisForm.findField('ad_username');
			if(adUserNameOpts.getStore().totalCount == 1)
			{
				adUserNameOpts.hide();
				var height=Ext.getCmp('remote_control').getHeight();
				var updatepanel=Ext.getCmp('remote_cmd');
				var output="<ul align='center' style='width:100%; height:100%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
				output = output +"<div style='margin-top:15px;' class='f14-normal'><span><li>"+noUsersLbl+"!<\/li></span></div></div></ul>";
				updatepanel.add(
				{
					xtype: 'container',
					margin:10,
					cls:'formOuter',
					height:cmdHeight,
					//style:{'border':'1px solid #d2d2d2 !important'},
					//bodyStyle:{'background':'#fbfbfb','overflow':'auto'},
					html:output
				});
				updatepanel.doLayout();
				updatepanel.show();
			}
			else {
				adUserNameOpts.show();
			}

		}
		else if(rmt_cmd == 'RC_30')
		{
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('ctx_user_machine_name').hide();
			thisForm.findField('arugumentsTextBox').show();	
			thisForm.findField('arugumentsTextBox').setFieldLabel("Username");
			thisForm.findField('arugumentsTextBox').emptyText="domain\\username";
			thisForm.findField('arugumentsTextBox').applyEmptyText();
			Ext.getCmp('ad_password').show();
			Ext.getCmp('ad_confirm_password').show();
			Ext.getCmp('execute').setVisible(true);
		}
		else if( rmt_cmd=='RC_50')
		{
			//Reset Active Directory User Password
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('ctx_user_machine_name').hide();
			
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();		
			/*
			var adUserNameOpts = thisForm.findField('ad_username');
			if(adUserNameOpts.getStore().totalCount == 1)
			{
				adUserNameOpts.hide();
				var height=Ext.getCmp('remote_control').getHeight();
				var updatepanel=Ext.getCmp('remote_cmd');
				updatepanel.removeAll();
				var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
				output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+noUsersLbl+"!<\/li></span></div></div></ul>";
				updatepanel.add({
					xtype: 'container',
					margin:10,
					cls:'formOuter',
					height:cmdHeight,
					border:false,
					html:output
				});
				updatepanel.doLayout();
				updatepanel.show();
			}
			else {
				adUserNameOpts.show();
			}
			*/
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('arugumentsTextBox').show();	
			thisForm.findField('arugumentsTextBox').setFieldLabel("Username");
			thisForm.findField('arugumentsTextBox').emptyText="username";
			thisForm.findField('arugumentsTextBox').applyEmptyText();
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_15' || rmt_cmd=='RC_31' || rmt_cmd=='RC_32' || rmt_cmd=='RC_33' || rmt_cmd=='RC_34' || rmt_cmd=='RC_35' || rmt_cmd=='RC_36' || rmt_cmd=='RC_37' || rmt_cmd=='RC_38' || rmt_cmd=='RC_39' || rmt_cmd=='RC_40' || rmt_cmd == 'RC_47' || rmt_cmd == 'RC_49' || rmt_cmd == 'RC_51' || rmt_cmd == 'RC_52' || rmt_cmd == 'RC_53' || rmt_cmd == 'RC_81' || rmt_cmd == 'RC_82')
		{
			//Reset Active Directory User Password
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('ctx_user_machine_name').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('usernames').hide();
				thisForm.findField('usernames_multiple').hide();
			}
			else
			{
				thisForm.findField('usernames').hide();
				thisForm.findField('usernames_multiple').hide();
			}
			thisForm.findField('ad_username').hide();
			thisForm.findField('ad_password').hide();
			thisForm.findField('ad_confirm_password').hide();
			if(rmt_cmd == 'RC_51')
				thisForm.findField('select_an_privileged_action').show();
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
			
		}
		else
		{
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
		}
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.show();
		enableDisableEls(rmt_cmd);
	},
	resizeMe:function(){
		cmd.setWidth(Ext.getBody().getViewSize().width -10);
		cmd.setHeight(Ext.getBody().getViewSize().height -10)
	},
	showCmd:function(){
		cmd.show();		
	},
	cmdBack:function(bt){
		cmd.hide();
	},
	fileUpload :  function(combo)
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		remoteCmd.removeAll();
		rcLoadMask.hide();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var fileName = thisForm.findField('fileupload').getValue();
		var customTaskName = thisForm.findField('custom_taskname').getValue();
		var isValidArgs = true;
		var argsErrMsg = '';
		if(fileName!=null && fileName.length >0){
			if(Ext.isEmpty(customTaskName)){
				argsErrMsg = taskNameEmptyLbl+', '+taskNameLbl+'.';
				isValidArgs = false;
			}
			else if(!checkspace(fileName)){
				argsErrMsg = spaceLbl+'.';
				isValidArgs = false;
			}
			else if(!checkspecialChar(fileName,"`~!@#%^&*()+={}[]|\\;\"\'<>,?"))
			{
				argsErrMsg = 'Special characters are not allowed for the file name.';
				isValidArgs = false;
			}
		}
		if (thisForm.isValid())
		{
			if(isValidArgs){
				Ext.getCmp('upload').setDisabled(true);
				rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Uploading the script to the Agent, please wait.."
				});
				rcLoadMask.show();
				thisForm.submit(
				{
					url : "/final/monitor/RemoteControlFileUpload.jsp?fileName="+fileName+"&taskName="+customTaskName+"&agentIP="+agentIP,
					scope:this,
					async : true,
					method : 'POST',
					enctype : 'multipart/form-data',
					success: function (form, action)
					{
						var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
						var alertTextSuccessMsg = jsonText['success'];
						var ErrMsgsJson =jsonText['ErrMsgsJson'];
						if (!Ext.isEmpty(jsonText))
						{
							if(Ext.isEmpty(ErrMsgsJson))
							{
								rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
									msg : "Uploading the script to the Agent, please wait.."
								});
								rcLoadMask.show();
								var thisForm = this.getRemotecontrolactionForm().getForm();
								var rmt_cmd = thisForm.findField('rmt_cmds').getValue();
								Ext.getCmp('execute').setDisabled(true);	
								thisForm.findField('fileupload').setRawValue(fileName);
								var hiddenQStr = publicJson['hiddenQStr'];
								var displayTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].displayField;
								var outputRqrd = thisForm.findField('outputRqrd').getValue();
								var timeOut = thisForm.findField('timeOutTextbox').getValue();
								var key_value_params = "rmt_cmd="+rmt_cmd+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+"&displayTxtCmd="+filterEncode(displayTxtCmd)+"&hostname="+hostName+'&port='+init_port+'&comptype='+init_comp_type;
								key_value_params = key_value_params + '&agentIP='+agentIP+'&fileName='+fileName+'&customAction='+customTaskName+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp;
								var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
								var winHeight = Ext.getCmp('remote_control').getHeight();
								var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
								Ext.Ajax.request({
									url : '/final/monitor/RemoteControlAppActionp.jsp',
									method : 'POST',
									params: key_value_params,
									timeout:timeOutValForAjax,
									scope:this,
									success: function(response)
									{
										var jsonData=Ext.decode(response.responseText);
										if(!Ext.isEmpty(jsonData))
										{
											var updatepanel=Ext.getCmp('remote_cmd');
											var result = jsonData['output'];
											updatepanel.add({
												xtype: 'panel',
												scroll:true,
												margin:10,
												border:false,
												cls:'formOuter',
												height:cmdHeight,
												id:'updatepanel',
												html:result,
												//bodyStyle:{'background':'darkblue !important'},
												bodyStyle:'overflowY: auto',
											});
										}
										thisForm.findField('fileupload').setRawValue('');
										updatepanel.doLayout();
										if(rmt_cmd=='fileupload' && result.indexOf("Custom action has been defined successfully")>-1){
											Ext.getCmp('upload').setDisabled(true);
											Ext.Ajax.request({
												url : '/final/monitor/RemoteControlActionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&port='+init_port+'&agentIP='+agentIP+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&vmOS='+vmOS,
												method : 'POST',
												scope:this,
												success: function(response)
												{
													var jsonText = response.responseText;
													var jsonData=Ext.decode(jsonText);
													var rmtCmdOpts = thisForm.findField('rmt_cmds');
													rmtCmdOpts.getStore().loadRawData(jsonData['RemoteCmds']);
													rmtCmdOpts.setValue(fileName);
													Ext.getCmp('execute').setDisabled(false);
													Ext.getCmp('execute').setVisible(true);
													Ext.getCmp('upload').setVisible(false);
													Ext.getCmp('upload').setDisabled(true);
													thisForm.findField('fileupload').hide();
													thisForm.findField('custom_taskname').hide();
													var argumentsObj = thisForm.findField('arugumentsTextBox');
													argumentsObj.emptyText = "none";
													argumentsObj.applyEmptyText();
													argumentsObj.show();
													argumentsObj.setValue('');
												}
											});
										}
										rcLoadMask.hide();
										remoteCmd.show();
									}
								});
								jsonText = null;
								Ext.destroy(jsonText);
							}
							else{
								rcLoadMask.hide();
								var msg = Ext.MessageBox.show({
									title : RCATitle,
									width: 400,
									modal: true,
									msg : ErrMsgsJson ,
									buttons : Ext.MessageBox.OK,
									maskCls :'windowModal',
									icon: 'iconExclamation'
								});
								Ext.WindowManager.bringToFront(msg);
							}
						}
					},
					failure: function (form, action)
					{
						alert("File uploading failed!");						
					}
				});
			}
			else{
				var msg = Ext.MessageBox.show({
					title : RCATitle,
					width:400,
					modal:true,
					msg :  argsErrMsg,
					buttons : Ext.MessageBox.OK,
					maskCls :'windowModal',
					icon: 'iconExclamation'
				});
				Ext.WindowManager.bringToFront(msg);
			}
		}
	},
	loadDefaultFormData : function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		thisForm.findField('executionMode').hide();
		thisForm.findField('select_an_action').hide();
		thisForm.findField('select_an_privileged_action').hide();
		thisForm.findField('restart_a_machine').hide();
		thisForm.findField('shutdown_and_restart').hide();
		if(multiple_users_supported_task)
		{
			thisForm.findField('usernames').hide();
			thisForm.findField('usernames_multiple').hide();
		}
		else
		{
			thisForm.findField('usernames').hide();
			thisForm.findField('usernames_multiple').hide();
		}
		thisForm.findField('msg_box').hide();
		if(multiple_users_supported_task)
		{
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
		}
		else
		{
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
		}
		thisForm.findField('user_process_name').hide();
		thisForm.findField('pid_multi_select').hide();
		thisForm.findField('cmdSyntax').hide();
		thisForm.findField('arugumentsTextBox').hide();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		thisForm.findField('userNameId').hide();
		Ext.getCmp('deliveryGroupContainer').hide();
		thisForm.findField('delivery_grp_name_multi_select').hide();
		Ext.getCmp('execute').setVisible(false);
		
		var screenLabels = publicJson['screenLabels'];				
		var rmtCmdOpts = thisForm.findField('rmt_cmds');
		rmtCmdOpts.getStore().loadRawData(publicJson['RemoteCmds']);
		rmtCmdOpts.setValue(publicJson['pageParams']['selectedCmd']);
		
		var arugumentsTextBox = thisForm.findField('arugumentsTextBox');
		//arugumentsTextBox.setValue(publicJson['pageParams']['arguments']);
		arugumentsTextBox.setFieldLabel(screenLabels['monitor.remotecontrol.Arguments']);

		var outputRqrdCombo = thisForm.findField('outputRqrd');
		outputRqrdCombo.getStore().loadRawData(publicJson['yesNoOpts']);
		outputRqrdCombo.setValue(publicJson['pageParams']['outputRequired']);
		outputRqrdCombo.setFieldLabel(screenLabels['monitor.remotecontrol.Output required']);

		var timeOutTextbox = thisForm.findField('timeOutTextbox');
		timeOutTextbox.setValue(publicJson['pageParams']['selectedTimeOutPeriod']);
		timeOutTextbox.setFieldLabel(screenLabels['monitor.remotecontrol.Timeout']);

		if(userNameDisp!=null && userNameDisp!="")
		{
			thisForm.findField('userNameId').setValue(userNameDisp);
			thisForm.findField('userNameId').show();
		}
		
		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}
	},
	showOSResult : function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var agentOS = publicJson['agentOS'];
		var commandOpts = thisForm.findField('rmt_cmds').getValue();
		//console.log('commandOpts',commandOpts);		
		if(commandOpts == "RC_57:VMAgentOS")
			commandOpts = "firewallAuthApp.vbs";
		if(commandOpts == "RC_58:VMAgentOS")
			commandOpts = "set";
		if(commandOpts == "RC_61:VMAgentOS")
			commandOpts = "startupitemslatest.ps1";
		var displayTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].displayField;		
		if(displayTxtCmd=='List all running windows services')
			commandOpts = 'net start';
		var vm = '';
		var otherStr='';
		if(commandOpts.indexOf(":")>-1)
		{
			otherStr = commandOpts.substring(0,commandOpts.indexOf(":"));
			vm = commandOpts.substring(commandOpts.indexOf(":")+1);
			commandOpts = commandOpts.substring(0,commandOpts.indexOf(":"));
		}
		var command = commandOpts;
		var cmdSyntax = thisForm.findField('cmdSyntax').getValue();
		if(otherStr == "Other" && cmdSyntax != null && (cmdSyntax.trim().indexOf('curl')==0 || cmdSyntax.trim().indexOf('shutdown')==0 || cmdSyntax.trim().indexOf('wget')==0 || cmdSyntax.trim().indexOf('nc')==0))
		{
			Ext.Msg.show({
				title:alertTitle,
				msg: dangerousCommands,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var aruguments = thisForm.findField('arugumentsTextBox').getValue().trim();
		var namespace = thisForm.findField('namespace').getValue().trim();
		var classes = thisForm.findField('classes').getValue().trim();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();
		if(commandOpts == "-1"){
			Ext.Msg.show({
				title:alertTitle,
				msg: commandAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		if(commandOpts == "tracert"){
			if(aruguments!=null && aruguments.length ==0){
				Ext.Msg.show({
					title:alertTitle,
					msg:validIPTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if(commandOpts == "dir" || commandOpts == "ls -alt"){
			if(aruguments != null && aruguments.length == 0){
				Ext.Msg.show({
					title:alertTitle,
					msg: validfilePathTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if((commandOpts == "net start" && displayTxtCmd == "Start a Windows service")  || commandOpts == "net stop" ){
			if(aruguments != null && aruguments.length == 0){
				Ext.Msg.show({
					title:alertTitle,
					msg:serviceNameTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		if(commandOpts=='RC_62') // this is for other option
		{
			commandOpts = "showWmiClasses.ps1";
			var param1 = "root/cimv2";
			var param2 = "win32*";
			//console.log('namespace',namespace);
			//console.log('classes',classes);
			if(namespace != null && namespace != undefined && namespace.trim() != "")
				param1 = namespace;
			if(classes != null && classes != undefined && classes.trim() != "")
				param2 = classes;
			commandOpts = commandOpts + " " + param1 + " " + param2;
			//console.log('commandOpts is ', commandOpts);
		}
		if(commandOpts=='Other') // this is for other option
		{
			commandOpts = filterEncode(cmdSyntax);		
			if(cmdSyntax != null && cmdSyntax != undefined && cmdSyntax.trim() == "")			
			{
				Ext.Msg.show({
					title:alertTitle,
					msg: enterCommandAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("aruguments").focus(true);
					}
				});
				return;
			}
		}
		else if(commandOpts=='getLastNLinesFromErrorLogFile' || commandOpts=='getLastNLinesFromAgentErrFile' || commandOpts=='getLastNLinesFromAgentOutFile')
		{
			if(Ext.isEmpty(aruguments) || isNaN(aruguments) || aruguments.indexOf('.')>-1 || parseInt(aruguments)<1 || parseInt(aruguments)>5000)			
			{
				Ext.Msg.show({
					title:alertTitle,
					msg: validNumberAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				return;
			}
		}
		else
		{
			if(aruguments!=null && (aruguments!="none" && aruguments!=""))
			{				
				if(commandOpts == 'dir' || commandOpts == 'ls -alt')
				{
					aruguments = filterEncode(aruguments);
					commandOpts = commandOpts+ " "+aruguments;
					//commandOpts = filterEncode(commandOpts);					
				}		
				else
				{	
					commandOpts = commandOpts+ " "+aruguments;
				}				
			}
		}
		if(!checkNumberVal("+",timeOut) || timeOut.indexOf(".")>-1)
		{
			Ext.Msg.show({
				title:alertTitle,
				msg: timeoutInpAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'	
			});
			return false;
		}
		else
		{
			var winHeight = Ext.getCmp('remote_control').getHeight();
			var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
			var remoteCmd = Ext.getCmp('remote_cmd');
			remoteCmd.removeAll();
			var commandOpts1 = commandOpts.replace(/\r\n|\r|\n/g,'#');		
			if(displayTxtCmd =='SPNs Operations')
			{
				var thisForm = this.getRemotecontrolactionForm().getForm();			
				var selectedPriviligedAction = thisForm.findField('select_an_privileged_action').getValue();
				commandOpts = selectedPriviligedAction;			
			}
			var hiddenQStr = publicJson['hiddenQStr'];
			var paramsForReq = "isJsonResp=true&response1=yes&&agentIP="+encodeURIComponent(agentIP)+"&hostName="+encodeURIComponent(hostName)
			+"&selCmd="+encodeURIComponent(commandOpts)+"&txtCmd1="+encodeURIComponent(commandOpts)
			+"&displayTxtCmd="+encodeURIComponent(filterEncode(displayTxtCmd))
			+"&arguments="+encodeURIComponent(aruguments)+"&txtCmd="+encodeURIComponent(commandOpts1)+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr+"&vmName="+vmName
			+"&isAgentBased="+encodeURIComponent(isAgentBased)+"&rmtOrExtAgentIp="+encodeURIComponent(rmtOrExtAgentIp)
			+"&agentOS="+encodeURIComponent(agentOS);
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			//rcLoadMask.show();
			if(commandOpts1=="RC_42" || commandOpts1=="RC_43"){
				  var sessionID = Ext.getCmp('user_session_id').getValue();
				  paramsForReq=paramsForReq +"user_session_id="+sessionID+"&user_session_id_multiple="+sessionID;
			}
			Ext.getCmp('execute').setDisabled(true);
			if(isAgentBased == "false")
               agentIP = rmtOrExtAgentIp;
			if(commandOpts1 == "compmgmt" || commandOpts1 == "mstsc"){
				var servUser = thisForm.findField('serv_user').getValue().trim();
				if(commandOpts1 == "compmgmt" && Ext.isEmpty(servUser)){
					Ext.getCmp('execute').setDisabled(false);
					var msg = Ext.MessageBox.show({
						title : RCATitle,
						width:300,
						msg : '<div style="min-height:35px;">'+userNameTitle+', <br>'+validUserNameTitle+'.</div>',
						modal:true,
						maskCls :'windowModal',
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					Ext.WindowManager.bringToFront(msg);
				}
				else{
					progressBarHandle=showWindow();
					Ext.Ajax.request({			
						url : '/final/monitor/RemoteControlActionUtils.jsp?cmd='+commandOpts1+"&agentIP="+agentIP+"&vmName="+vmName+"&username="+encodeURIComponent(servUser)+"&isAgentBased="+isAgentBased+"&rmtOrExtAgentIp="+rmtOrExtAgentIp+'&init_comp_type='+init_comp_type,
						method : 'POST',
						timeout:timeOutValForAjax,
						scope:this,
						success: function(response)
						{
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
							Ext.getCmp('execute').setDisabled(false);
							var displayMsg;
							if(isAgentBased == "false")
								agentIP = rmtOrExtAgentIp;
							if(commandOpts1 == "compmgmt"){
								if(outputRqrd == "Yes" || outputRqrd == "yes"){
									displayMsg = computerManagementTitle+". <br>"+downloadTitle+"."+batfileTitle+".."
								}
								else{
									displayMsg = remoteControlSuccessTitle;
								}
								window.location.href= "../images/RemoteControl/compmgmt_"+agentIP+".bat";
							}else {
								if(outputRqrd == "Yes" || outputRqrd == "yes"){
									displayMsg = RDPInitiateTitle+". "+downTitle+" ."+rdpTitle+"..";
								}
								else{
									displayMsg = remoteControlSuccessTitle;
								}
								var filePath ="../images/RemoteControl/"+agentIP+".rdp";
								var fileName = agentIP + ".rdp";
								
								this.downloadRCAFile(fileName);
								
							}
							Ext.getCmp('execute').setDisabled(false);
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/success_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+displayMsg+"<\/li></span></div></div></ul>";
							
							var updatepanelTitle = commandTitle+" - "+commandOpts1;

							if(commandOpts1 == 'RC_24'){
								updatepanelTitle = outputTitle;//or Result
							}
							else if(commandOpts1 == 'mstsc' || commandOpts1 == 'compmgmt')
							{
								updatepanelTitle=' ';
							}
							updatepanel.add({
								xtype: 'panel',
								margin:'10 10 10 10',
								title:updatepanelTitle,
								bodyStyle:{'overflowY':'auto','box-shadow':'none'},
								border:true,
								ui:"simplePanel withBorder",
								//bodyCls:'configWinBody',
								header:{
									style:{'border':'0px','background':'transparent !important','padding-left':'10px'},
								},
								height:cmdHeight+10,
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();
							remoteCmd.show();
						},
						failure:function()
						{
							Ext.getCmp('execute').setDisabled(false);
							Ext.destroy(progressBarHandle);
							progressBarHandle=null;
							var updatepanel=Ext.getCmp('remote_cmd');
							var output="<ul align='center' class='f11-normal' style='margin:10px; width:95%; height:93%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/error_msg_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+timedoutTitle+"<\/li></span></div></div></ul>";
							updatepanel.add({
								xtype: 'panel',
								margin:10,
								height:cmdHeight,
								//bodyStyle:{'background':'blue !important'},
								cls:'formOuter',
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();
							remoteCmd.show();
						}
					});
				}
			}
			else if(commandOpts1 == "ping" && Ext.isEmpty(aruguments)){
				Ext.getCmp('execute').setDisabled(false);
				var msg = Ext.MessageBox.show({
					title : RCATitle,
					width:300,
					msg : '<div>'+validIPTitle+'.</div>',
					modal:true,
					maskCls :'windowModal',
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
					fn:function(i){
						Ext.getCmp("arugumentsTextBox").focus(true);
					}
				});
				Ext.WindowManager.bringToFront(msg);
			}
			else {
				//console.log('commandOpts1',commandOpts1);
				if(commandOpts1.startsWith("shutdown") || commandOpts1.startsWith("logoff")){
					var displayMsg = "";
					var alertMessage = "";
					var selected_switch=commandOpts1.substring(commandOpts1.indexOf(' ')+2);
					if(selected_switch.indexOf(' ')>-1)
					{
						selected_switch=selected_switch.substring(0,selected_switch.indexOf(' '));
					}
					if(selected_switch=='r'){
						displayMsg = rebootTitle+"..";
						alertMessage = "Are you sure want to reboot?"
					}
					else if(selected_switch=='s'){
						displayMsg = shutdownTitle+"..";
						alertMessage = "Are you sure want to shutdown?"
					}
					else if(commandOpts1.startsWith("logoff")){
						displayMsg = logoffTitle+"..";
						alertMessage = "Do you want to log off this user session?"
					}
					Ext.MessageBox.show({
						title : 'Confirm', 
						msg : alertMessage, 
						buttons : Ext.MessageBox.YESNO, 
						fn : callbackFunction, 
						icon : 'iconConfirmation'
					});
					function callbackFunction(btn) {
						if (btn == 'yes') {	
							Ext.getCmp('execute').setDisabled(true);
							var updatepanel=Ext.getCmp('remote_cmd');
							updatepanel.removeAll();
							//console.log('displayMsg',displayMsg);
							var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
							output = output +"<div style='margin-top:15px;'>"+displayMsg+"</div></div></ul>";
							updatepanel.add({
								xtype: 'panel',
								margin:10,
								height:cmdHeight,
								//bodyStyle:{'background':'green !important'},
								cls:'formOuter',
								id:'updatepanel',
								html:output
							});
							updatepanel.doLayout();							
							//remoteCmd.show();
							callRemoteControlActionP(paramsForReq,timeOutValForAjax,commandOpts1,cmdHeight,remoteCmd);
						}
						else{
							Ext.getCmp('execute').setDisabled(false);
						}
					}
				}
				else {
					if(commandOpts1=='getActiveFilesReport')
					{
						paramsForReq+="&event_capture="+Ext.getCmp('event_capture').getValue();
					}
					//rcLoadMask.show();	
					//console.log('commandOpts1',commandOpts1);					
					callRemoteControlActionP(paramsForReq,timeOutValForAjax,commandOpts1,cmdHeight,remoteCmd);
				}
			}
		}
	},
	downloadRCAFile: function(fileName)
	{
		Ext.defer(function(){
					window.location.href= "../monitor/eg_scripts/RemoteControlAction/data/RCAFileDownload.jsp?fileName=" + encodeURIComponent(fileName);
		},500);
		
	},
	loadFormData: function () {
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var selected_user_name = "";
		var selected_user_name_multiple="";
		var params= "";
		if(init_test_name=='ChangeLoginTest' || init_test_name=='CtxXcXDSiteTest' || init_test_name=='CtxXcXDSiteSiteTest' || init_test_name=='CtxXcXDCGroupTest' || init_test_name=='CtxXcXDCBrMachTest' || init_test_name=='ADUserLockOutTest'  || init_test_name=='CitrixLicenseTest'  || init_test_name=='ADUsersTest' || init_test_name == 'CtxXcXDDesktopsTest')
		{
			params = 'hostname='+hostName+'&comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name;
		}
		else
		{
			if(multiple_users_supported_task)
			{
				selected_user_name_multiple  = Ext.getCmp('usernames_multiple').getValue();
				if(selected_user_name_multiple == null || selected_user_name_multiple=='-1')
				{
					var userSessionOpts_multiple = thisForm.findField('user_session_id_multiple');
					userSessionOpts_multiple.hide();
					var userProcessOpts = thisForm.findField('user_process_name');
					userProcessOpts.setValue("-1");
					Ext.getCmp('user_process_name').hide();
					Ext.getCmp('pid_multi_select').hide();
					Ext.getCmp('msg_box').hide();
					Ext.getCmp('execute').setVisible(false);
					return;
				}
			}
			else
			{
				selected_user_name = Ext.getCmp('usernames').getValue();
				if(selected_user_name == null || selected_user_name=='-1')
				{
					var userSessionOpts = thisForm.findField('user_session_id');
					userSessionOpts.setValue("-1");
					userSessionOpts.hide();

					var userProcessOpts = thisForm.findField('user_process_name');
					userProcessOpts.setValue("-1");
					Ext.getCmp('user_process_name').hide();
					Ext.getCmp('pid_multi_select').hide();
					Ext.getCmp('msg_box').hide();
					Ext.getCmp('execute').setVisible(false);
					return;
				}
			}
			params = 'hostname='+hostName+'&comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&selected_user_name='+encodeURIComponent(selected_user_name)+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&selected_user_name_multiple='+encodeURIComponent(selected_user_name_multiple)+'&multiple_users_supported_task='+multiple_users_supported_task;
		}
		if(progressBarHandle == null)
		{
			progressBarHandle=showWindow();
		}
		Ext.Ajax.request({
			url : '/final/monitor/RemoteControlActionUserInfo.jsp?'+params+'&task_name='+taskName,
			method : 'POST',
			scope:this,
			timeout:300000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				Ext.destroy(progressBarHandle);
				progressBarHandle=null;
				if(multiple_users_supported_task)
				{
					Ext.getCmp('user_session_id').hide();
					var userSessionOpts_multiple = thisForm.findField('user_session_id_multiple');
					userSessionOpts_multiple.getStore().loadRawData(jsonData['sessionIdsOpts']);
					Ext.getCmp('user_session_id_multiple').boundList.getSelectionModel().selectAll();
				}
				else
				{
					Ext.getCmp('user_session_id_multiple').hide();
					var userSessionOpts = thisForm.findField('user_session_id');
					userSessionOpts.getStore().loadRawData(jsonData['sessionIdsOpts']);
					var start_sid = jsonData['pageParams']['selectedSessionId'];
					userSessionOpts.setValue('-1');
					if(start_sid=='-1') {
						Ext.getCmp('user_session_id').hide();
					}
					else {
						Ext.getCmp('user_session_id').show();
					}
				}
				var pid_multi_select = thisForm.findField('pid_multi_select');
				pid_multi_select.getStore().removeAll();
				pid_multi_select.getStore().loadRawData(jsonData['sessionIdsOpts']);	
				pid_multi_select.setValue("-1");
				Ext.getCmp('pid_multi_select').show();	
					
				singleSessionId=jsonData['pageParams']['singleSessionId'];
				var userProcessOpts = thisForm.findField('user_process_name');
				userProcessOpts.getStore().loadRawData(jsonData['processOpts']);
				var start_process = jsonData['pageParams']['selectedProcess'];
				userProcessOpts.setValue('-1');
				if(start_process=='-1') {
					Ext.getCmp('user_process_name').hide();
					Ext.getCmp('pid_multi_select').hide();
				}
				else {
					Ext.getCmp('user_process_name').show();
				}
				var msgBox = thisForm.findField('msg_box');
				msgBox.setValue(jsonData['pageParams']['arguments']);

				var lononModesOpts = thisForm.findField('logonModes');
				lononModesOpts.getStore().loadRawData(jsonData['logonModesOpts']);
				var start_logonMode = jsonData['pageParams']['selectedLogonMode'];
				lononModesOpts.setValue(start_logonMode);
				if(start_logonMode=='-1') {
					Ext.getCmp('logonModes').hide();
				}
				else {
					Ext.getCmp('logonModes').show();
				}
			
				if(init_test_name != 'CtxXcXDCSessionTest')
				{
					var deliveryGroupOpts = thisForm.findField('delivery_grp_name');
					deliveryGroupOpts.getStore().loadRawData(jsonData['deliveryGroupOpts']);
					var start_deliveryGrp = jsonData['pageParams']['selectedLogonMode'];
					deliveryGroupOpts.setValue(deliveryGroupOpts.getStore().getAt(0).getData().valueField);
					deliveryGroupOpts.select(deliveryGroupOpts.getStore().getAt(0));
					if(start_deliveryGrp=='-1') {
						Ext.getCmp('delivery_grp_name').hide();
					}
					else {
						Ext.getCmp('delivery_grp_name').show();
					}
				}

				var deliveryGroupMultiOpts = thisForm.findField('delivery_grp_name_multi_select');
				deliveryGroupMultiOpts.getStore().loadRawData(jsonData['deliveryGroupOpts']);
				var start_deliveryGrpMulti = jsonData['pageParams']['selectedLogonMode'];
				deliveryGroupMultiOpts.setValue(deliveryGroupMultiOpts.getStore().getAt(0).getData().valueField); 
				if(start_deliveryGrpMulti=='-1') {
					Ext.getCmp('deliveryGroupContainer').hide();
					Ext.getCmp('delivery_grp_name_multi_select').hide();
				}
				else {					
					Ext.getCmp('deliveryGroupContainer').show();
					Ext.getCmp('delivery_grp_name_multi_select').show();
				}
				
				var machineNameOpts = thisForm.findField('machine_name');
				machineNameOpts.getStore().loadRawData(jsonData['machineNameOpts']);
				var start_machineName = jsonData['pageParams']['selectedLogonMode'];
				machineNameOpts.setValue(start_machineName);
				if(start_machineName=='-1') {
					Ext.getCmp('machine_name').hide();
				}
				else {
					Ext.getCmp('machine_name').show();
				}

				var adUserNameOpts = thisForm.findField('ad_username');
				adUserNameOpts.getStore().removeAll();
				adUserNameOpts.getStore().loadRawData(jsonData['adUsernamesOpts']);
				adUserNameOpts.setValue('-1');
				Ext.getCmp('ad_username').hide();
				if(selected_user_name != -1){
					this.changeCommand();
				}
			},
			failure: function(response)
			{
				Ext.getCmp('execute').setVisible(false);
				Ext.destroy(progressBarHandle);
				progressBarHandle=null;
				Ext.MessageBox.alert(actionTitle,failedetailsLbl);

				var thisForm = this.getRemotecontrolactionForm().getForm();
				var userSessionOpts = thisForm.findField('user_session_id');
				userSessionOpts.setValue("-1");

				var userSessionOpts_multiple = thisForm.findField('user_session_id_multiple');
				userSessionOpts_multiple.setValue("-1");
				var userProcessOpts = thisForm.findField('user_process_name');
				userProcessOpts.setValue("-1");
				Ext.getCmp('user_process_name').hide();
				Ext.getCmp('pid_multi_select').hide();
				
			}
		});        
    },	
	loadActionData : function(from)
	{
		multiple_users_supported_task=false;
		var task_name ; 
		var isCustomScript = false;
		var remoteCmd = Ext.getCmp('remote_cmd');
		var executionMode = Ext.getCmp('executionMode').getValue();
		//console.log('executionMode',executionMode);
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		if(rmt_cmd == '-1')
		{
			this.loadDefaultFormData();
			Ext.getCmp('infoIcon').hide();
			return;
		}
		else
			Ext.getCmp('infoIcon').show();

		var thisForm = this.getRemotecontrolactionForm().getForm();
		var displayTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].displayField;
		var descTxtCmd = thisForm.findField('rmt_cmds').displayTplData[0].descField;
		if(!Ext.isEmpty(descTxtCmd))
			Ext.getCmp('infoIconTooltip').update(descTxtCmd);
		else
			Ext.getCmp('infoIcon').hide();
		thisForm.findField('executionMode').hide();
		thisForm.findField('restart_a_machine').hide();
		thisForm.findField('shutdown_and_restart').hide();
		thisForm.findField('select_an_privileged_action').hide();
		thisForm.findField('select_an_action').hide();
		if(multiple_users_supported_task)
		{
			thisForm.findField('usernames').hide();
			thisForm.findField('usernames_multiple').hide();
		}
		else
		{
			thisForm.findField('usernames').hide();
			thisForm.findField('usernames_multiple').hide();
		}
		thisForm.findField('ad_username').hide();
		thisForm.findField('ctx_user_machine_name').hide();
		thisForm.findField('license_username').hide();
		thisForm.findField('license_machinename').hide();
		thisForm.findField('fileupload').hide();
		thisForm.findField('custom_taskname').hide();
		thisForm.findField('outputRqrd').hide();
		thisForm.findField('timeOutTextbox').hide();
		thisForm.findField('outputRqrd').setValue("Yes");
		thisForm.findField('ad_password').hide();
		thisForm.findField('ad_confirm_password').hide();
		thisForm.findField('namespace').hide();
		thisForm.findField('classes').hide();
		Ext.getCmp('upload').setVisible(false);
		Ext.getCmp('execute').setVisible(false);
		Ext.getCmp('arugumentsTextBox').setValue("");
		thisForm.findField('shadow_mode').hide();
		Ext.getCmp('deliveryGroupContainer').hide();
		thisForm.findField('delivery_grp_name_multi_select').hide();

		if(rmt_cmd=='getActiveFilesReport:OS' || rmt_cmd=='getActiveFilesReport:VMAgentOS')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
			thisForm.findField('event_capture').show();
		}
		else if(rmt_cmd=='getProfileOfeGAgent:OS' || rmt_cmd=='getProfileOfeGManager:OS')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
		}
		else if(rmt_cmd=='getProfileOfeGAgentByCpu:OS')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
		}
		else if(rmt_cmd=='getProcessesByCpuMemUsage:OS')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
		}
		else if(rmt_cmd=='getNetworkLatencyByProcesses:OS' || rmt_cmd=='getNetworkLatencyByProcesses:VMAgentOS')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
		}
		else if(rmt_cmd=='getAgentOutFile:OS' || rmt_cmd=='getAgentErrFile:OS' || rmt_cmd=='getErrorLogFile:OS')
		{
			Ext.getCmp('arugumentsTextBox').setValue('5000');
			Ext.getCmp('arugumentsTextBox').setFieldLabel(number_lines_label);
		}
		else
		{
			Ext.getCmp('arugumentsTextBox').setVisible(true);
			thisForm.findField('event_capture').hide();
		}

		init_test_name =rmt_cmd;
		if(rmt_cmd.indexOf(":")>-1){
			task_name = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
			taskName = task_name;				
			init_test_name = rmt_cmd.substring(rmt_cmd.indexOf(":")+1);			
		}
		else{
			isCustomScript = true;
		}
		if(from == 'RC_80')
			init_test_name = 'CtxXcXDCSessionTest';
		if((rmt_cmd == "RC_57:VMAgentOS" || rmt_cmd == "RC_58:VMAgentOS" || rmt_cmd == "RC_61:VMAgentOS") && executionMode == null)
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
			thisForm.findField('executionMode').show();
			return;
		}
		if(isAgentVersion7Dot2AndAbove=='true')
		{
			var must='RC_0,RC_1,RC_2,RC_3,RC_4,RC_5,RC_6,DownloadImage,RC_8,RC_9,RC_10,RC_11,RC_17,RC_18,RC_23,RC_43,RC_54,RC_83'.split(',');
			multiple_users_supported_task=must.indexOf(task_name)>-1;
		}
		if(task_name == 'RC_86')
		{
			Ext.getCmp('arugumentsTextBox').setVisible(false);
			progressBarHandle=showWindow();
			thisForm.findField('outputRqrd').hide();
			thisForm.findField('timeOutTextbox').hide();
			Ext.Ajax.request({
				url : '/final/monitor/RemoteControlActionProcessJson.jsp?isAgentBased='+encodeURIComponent(isAgentBased)+'&rmtOrExtAgentIp='+encodeURIComponent(rmtOrExtAgentIp)+'&taskName='+task_name,
				method : 'POST',
				scope:this,
				timeout:300000,
				success: function(response)
				{
					Ext.destroy(progressBarHandle);
					progressBarHandle=null;								
					var jsonData=Ext.decode(response.responseText);

					var userProcessOpts = thisForm.findField('user_process_name');				
					userProcessOpts.getStore().removeAll();
					userProcessOpts.getStore().loadRawData(jsonData['processOpts']);
					userProcessOpts.setValue('-1');
					thisForm.findField("user_process_name").show();

					thisForm.findField('pid_multi_select').getStore().removeAll();
					thisForm.findField("pid_multi_select").hide();

				},
				failure: function(response)
				{
					Ext.destroy(progressBarHandle);
					progressBarHandle=null;
					alert("failure...");
				}
			});
			return;
		}
		if(rmt_cmd == "RC_0:VMAgentOS" || rmt_cmd == "RC_1:VMAgentOS" ||rmt_cmd == "RC_2:VMAgentOS" || rmt_cmd == "RC_3:VMAgentOS" || rmt_cmd == "RC_5:VMAgentOS" || rmt_cmd == "RC_6:VMAgentOS" || rmt_cmd == "RC_8:VMAgentOS" || rmt_cmd == "RC_9:VMAgentOS" || rmt_cmd == "RC_11:VMAgentOS" || rmt_cmd == "RC_18:VMAgentOS" || rmt_cmd == "RC_23:VMAgentOS" || rmt_cmd == "RC_43:VMAgentOS" || rmt_cmd == "RC_84:VMAgentOS" || rmt_cmd == "RC_83:VMAgentOS" || rmt_cmd == "RC_54:VMAgentOS" || rmt_cmd == "RC_57:VMAgentOS" || rmt_cmd == "RC_58:VMAgentOS" || rmt_cmd == "RC_61:VMAgentOS" || rmt_cmd == "RC_71:VMAgentOS" || rmt_cmd == "RC_10:VMAgentOS" || rmt_cmd == "RC_56:VMAgentOS" || rmt_cmd == "RC_17:VMAgentOS" || rmt_cmd == "RC_4:VMAgentOS" || rmt_cmd == "DownloadImage:VMAgentOS" || rmt_cmd == "RC_41:VMAgentOS")
		{
			if(rmt_cmd == "RC_57:VMAgentOS")
			{
				Ext.getCmp('arugumentsTextBox').setVisible(false);
				thisForm.findField('executionMode').show();
				if(executionMode == "System Wise")
				{
					rmt_cmd = "firewallAuthApp.vbs";
					Ext.getCmp('execute').setVisible(true);
					Ext.getCmp('user_session_id').setVisible(false);
					Ext.getCmp('user_session_id_multiple').setVisible(false);
					thisForm.findField('cmdSyntax').hide();
					thisForm.findField('msg_box').hide();
					return;
				}		
			}
			else if(rmt_cmd == "RC_58:VMAgentOS")
			{
				Ext.getCmp('arugumentsTextBox').setVisible(false);
				thisForm.findField('executionMode').show();
				if(executionMode == "System Wise")
				{
					rmt_cmd = "set";
					Ext.getCmp('execute').setVisible(true);
					Ext.getCmp('user_session_id').setVisible(false);
					Ext.getCmp('user_session_id_multiple').setVisible(false);
					thisForm.findField('cmdSyntax').hide();
					thisForm.findField('msg_box').hide();
					return;
				}					
			}
			else if(rmt_cmd == "RC_61:VMAgentOS")
			{
				Ext.getCmp('arugumentsTextBox').setVisible(false);
				thisForm.findField('executionMode').show();
				if(executionMode == "System Wise")
				{
					rmt_cmd = "startupitemslatest.ps1";
					Ext.getCmp('execute').setVisible(true);
					Ext.getCmp('user_session_id').setVisible(false);
					Ext.getCmp('user_session_id_multiple').setVisible(false);
					thisForm.findField('cmdSyntax').hide();
					thisForm.findField('msg_box').hide();
					return;
				}	
			}
			else if(rmt_cmd == "RC_41:VMAgentOS")
			{
				Ext.getCmp('arugumentsTextBox').setVisible(false);
			}
			//console.log('rmt_cmd',rmt_cmd);
			init_test_name = "VMAgentSplTask";
		}		
		if(rmt_cmd == "fileupload"){
			thisForm.findField('serv_user').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			thisForm.findField('cmdSyntax').hide();
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').setValue('300');
			//thisForm.findField('timeOutTextbox').show();
			thisForm.findField('fileupload').show();
			thisForm.findField('fileupload').setRawValue('');
			var argumentsObj = Ext.getCmp('arugumentsTextBox');
			argumentsObj.hide();
			thisForm.findField('custom_taskname').show();
			thisForm.findField('custom_taskname').setValue('');
			var uploadObj = Ext.getCmp('upload');
			uploadObj.setVisible(true);
			if(!uploadObj.isDisabled()){
				uploadObj.setDisabled(true);
			}
		}
		else if(init_test_name == "OS"|| init_test_name == "Other" || init_test_name == "VMAgentOS" || init_test_name == "IGELSrvStateTest" || init_test_name == "IGELSrvStateTest"){
			thisForm.findField('serv_user').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(task_name=='Other')
			{
				thisForm.findField('cmdSyntax').show();
				thisForm.findField('cmdSyntax').setValue('');
				thisForm.findField('arugumentsTextBox').hide();
				thisForm.findField('timeOutTextbox').show();
			}
			else
			{
				thisForm.findField('cmdSyntax').hide();			
				if(task_name == '/sbin/ifconfig -a' || task_name == 'ipconfig' || task_name == 'ps -aef' || task_name == 'hostnamectl' || task_name == 'w' || task_name == 'RC_62' || task_name == 'GetAntivirusStatus.vbs' || task_name == 'startupitems.ps1' || task_name == 'os-info.vbs' || task_name == 'softwares.exe' || task_name == 'RC_47' || task_name == 'RC_44' || task_name == 'RC_64' || rmt_cmd.startsWith("FILE#") || task_name == 'typeperf -q -y' || task_name == 'logoff' || displayTxtCmd == 'List all running windows services' || task_name == 'lastboottime.ps1' || task_name == 'DotNetVersionInstalled.ps1' || task_name == 'hostname' || task_name == 'wmic os list brief' || task_name == 'netstat -rn' || task_name == 'set' || task_name == 'netstat -an' || task_name ==  'GetServiceAccounts.ps1' || task_name == 'RC_64' || task_name == 'RC_72' || task_name == 'getAllRunningProcesses' || task_name == 'netstat' || task_name=='curl api.ipify.org'){
					thisForm.findField('arugumentsTextBox').hide();
					if(task_name == "RC_62")
					{
						thisForm.findField('namespace').show();
						thisForm.findField('classes').show();
					}
					else if(task_name == "FILE#TestRPCPorts.ps1")
						thisForm.findField('arugumentsTextBox').show();
				} else {
					thisForm.findField('arugumentsTextBox').emptyText = "Thin Client";
					thisForm.findField('arugumentsTextBox').applyEmptyText();
					if(rmt_cmd=='getActiveFilesReport:OS' || rmt_cmd=='getActiveFilesReport:VMAgentOS')
					{
						thisForm.findField('arugumentsTextBox').hide();
					}
					else if(rmt_cmd=='getProfileOfeGAgent:OS' || rmt_cmd=='getProfileOfeGManager:OS')
					{
						thisForm.findField('arugumentsTextBox').hide();
					}
					else if(rmt_cmd=='getProfileOfeGAgentByCpu:OS')
					{
						thisForm.findField('arugumentsTextBox').hide();
					}
					else if(rmt_cmd=='getProcessesByCpuMemUsage:OS')
					{
						thisForm.findField('arugumentsTextBox').hide();
					}
					else if(rmt_cmd=='getNetworkLatencyByProcesses:OS' || rmt_cmd=='getNetworkLatencyByProcesses:VMAgentOS')
					{
						thisForm.findField('arugumentsTextBox').hide();
					}
					else
					{
						thisForm.findField('arugumentsTextBox').show();
					}
		
					if(rmt_cmd == "RC_63:IGELSrvStateTest")
					{
						//Ext.getCmp('arugumentsTextBox').setVisible(false);
						thisForm.findField('select_an_action').show();
						//return;
					}
				}
			}
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			if(task_name == "mstsc" || task_name == "compmgmt"){
				thisForm.findField('serv_user').setValue("");
				thisForm.findField('serv_user').show();
				thisForm.findField('arugumentsTextBox').hide();
			}
			else {
				var argumentsTextBox = thisForm.findField('arugumentsTextBox');
				var namespaceTextBox = thisForm.findField('namespace');
				var classesTextBox = thisForm.findField('classes');
				var argument = publicJson['arguments'][task_name];
				//console.log('argument is',argument);
				var namespace = publicJson['namespace'][task_name];
				//console.log('namespace is ',namespace);
				var classes =  publicJson['classes'][task_name];
				//console.log('classes is ',classes);
				var argument_Label = publicJson['arguments'][task_name+"_LABEL"];
				argumentsTextBox.emptyText = argument;
				argumentsTextBox.setFieldLabel(argumentsLbl);
				//console.log('argumentsLbl ',argumentsLbl);
				namespaceTextBox.emptyText = namespace;
				classesTextBox.emptyText = classes;
				if(task_name=='getLastNLinesFromErrorLogFile' || task_name=='getLastNLinesFromAgentErrFile' || task_name=='getLastNLinesFromAgentOutFile')
				{
					argumentsTextBox.setFieldLabel(number_lines_label);
				}
				else
				{
					if(argument_Label != undefined ){
						argumentsTextBox.setFieldLabel(argument_Label);
					}
				}
				argumentsTextBox.applyEmptyText();
				namespaceTextBox.applyEmptyText();
				classesTextBox.applyEmptyText();
			}
			Ext.getCmp('execute').setVisible(true);
		}
		else {
			thisForm.findField('serv_user').hide();
			thisForm.findField('cmdSyntax').hide();
			thisForm.findField('arugumentsTextBox').hide();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			thisForm.findField('delivery_grp_name').hide();
			thisForm.findField('machine_name').hide();
			thisForm.findField('delivery_group_status').hide();
			if(!multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			if(isCustomScript){
				//thisForm.findField('outputRqrd').show();
				//thisForm.findField('timeOutTextbox').show();
				var argumentsObj = Ext.getCmp('arugumentsTextBox');
				argumentsObj.show();
				argumentsObj.emptyText = "none";
				argumentsObj.applyEmptyText();
				Ext.getCmp('execute').setVisible(true);
				Ext.getCmp('execute').setDisabled(false);
			}
			else {
				if(task_name=='RC_15' || task_name=='RC_31' || task_name == 'RC_32' || task_name == 'RC_33' || task_name == 'RC_34' || task_name == 'RC_35' || task_name=='RC_36' || task_name=='RC_37' || task_name == 'RC_49' || task_name == 'RC_51' || task_name == 'RC_52' || task_name == 'RC_53' || task_name == 'RC_55' || task_name == 'RC_81' || task_name == 'RC_82')
				{
					if(multiple_users_supported_task)
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					else
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					//thisForm.findField('outputRqrd').show();
					//thisForm.findField('timeOutTextbox').show();
					if(task_name == 'RC_32')
					{
						var  privilegedValues = thisForm.findField('select_an_privileged_action');
						privilegedValues.getStore().removeAll();
						var arr = [{'displayField':'List SPNs registered to target account','valueField':'setspn -L'},
								  {'displayField':'Check SPN exist','valueField':'setspn -Q'},
								  {'displayField':'List duplicate SPN','valueField':'setspn -X'} 
								  ];
						privilegedValues.getStore().loadRawData(arr); 
						privilegedValues.setValue(arr[0].valueField);
						thisForm.findField('arugumentsTextBox').setFieldLabel("Target Account");
						thisForm.findField('arugumentsTextBox').emptyText = "egin.local.hostname";
						thisForm.findField('arugumentsTextBox').applyEmptyText();
						thisForm.findField('arugumentsTextBox').show();
						//thisForm.findField('arugumentsTextBox').show();
					}
					else if(task_name == 'RC_51')
					{
						var  privilegedValues = thisForm.findField('select_an_privileged_action');
						privilegedValues.getStore().removeAll();
						var arr =  [{'displayField':'Show Privileged Accounts Only','valueField':'ShowPrivilegedAccountsOnly'},
						  {'displayField':'Show System Accounts only','valueField':'ShowSystemAccounts'},
						  {'displayField':'Show Both Accounts','valueField':'Both'}, 
						  {'displayField':'No Account','valueField':'None'}];
						 privilegedValues.getStore().loadRawData(arr); 
						 privilegedValues.setValue(arr[0].valueField);
					}
					if(task_name == 'RC_51' || task_name == 'RC_32')
						thisForm.findField('select_an_privileged_action').show();
					Ext.getCmp('execute').setVisible(true);
				} else if(task_name=='RC_29'){
					
					var argumentsTextBox = thisForm.findField('arugumentsTextBox');
					argumentsTextBox.setFieldLabel(ad_username_label +'&nbsp;(sAMAccountName)');
					argumentsTextBox.emptyText = "Enter username";
					argumentsTextBox.applyEmptyText();
					thisForm.findField('arugumentsTextBox').show();
					if(multiple_users_supported_task)
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					else
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					//thisForm.findField('outputRqrd').show();
					//thisForm.findField('timeOutTextbox').show();
					Ext.getCmp('execute').setVisible(true);
				} else if(task_name=='RC_67'){
					Ext.getCmp('deliveryGroupContainer').hide();
					thisForm.findField('delivery_grp_name_multi_select').hide();
					var argumentsTextBox = thisForm.findField('arugumentsTextBox');
					argumentsTextBox.emptyText = "7";
					argumentsTextBox.applyEmptyText();
					argumentsTextBox.setFieldLabel("Days");					
					thisForm.findField('arugumentsTextBox').show();
					thisForm.findField('usernames').hide();		
					thisForm.findField('usernames_multiple').hide();					
					Ext.getCmp('execute').setVisible(true);
				}				
				else if(task_name=='RC_69'){
					Ext.getCmp('deliveryGroupContainer').hide();
					thisForm.findField('delivery_grp_name_multi_select').hide();
					var argumentsTextBox = thisForm.findField('arugumentsTextBox');
					thisForm.findField('restart_a_machine').show();
					thisForm.findField('restart_a_machine').setFieldLabel('Restart Machine');
					argumentsTextBox.setFieldLabel("Controller");	
					argumentsTextBox.emptyText = "localhost";
					argumentsTextBox.applyEmptyText();
					thisForm.findField('arugumentsTextBox').show();
					if(multiple_users_supported_task)
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					else
					{
						thisForm.findField('usernames').hide();
						thisForm.findField('usernames_multiple').hide();
					}
					Ext.getCmp('execute').setVisible(true);
				}
				else if(task_name == "RC_70")
				{
					thisForm.findField('delivery_grp_name_multi_select').hide();
					var durationTxtBox = thisForm.findField('classes');
					durationTxtBox.show();
					durationTxtBox.setFieldLabel("Duration(Hrs:Mins)");
					durationTxtBox.emptyText = "8:30";
					durationTxtBox.applyEmptyText();
					var controller = thisForm.findField('namespace');
					controller.show();
					controller.emptyText = "localhost";
					controller.applyEmptyText();
					controller.setFieldLabel("Controller");
					
					Ext.getCmp('execute').setVisible(true);
				}
				else if(task_name == 'RC_75'){
					Ext.getCmp('deliveryGroupContainer').hide();
					thisForm.findField('delivery_grp_name_multi_select').hide();
					var argumentsTextBox = thisForm.findField('arugumentsTextBox');
					argumentsTextBox.emptyText = "1";
					argumentsTextBox.applyEmptyText();
					argumentsTextBox.setFieldLabel("Last(Days)");					
					thisForm.findField('arugumentsTextBox').show();
					if(multiple_users_supported_task)
					{
						thisForm.findField('usernames').hide();	
						thisForm.findField('usernames_multiple').hide();
					}
					else
					{
						thisForm.findField('usernames').hide();	
						thisForm.findField('usernames_multiple').hide();
					}
					Ext.getCmp('execute').setVisible(true);
				}			
				else {
					if(init_test_name == "VMAgentSplTask")
					{
						//console.log('rmt_cmd',rmt_cmd);
						progressBarHandle=showWindow();
						thisForm.findField('outputRqrd').hide();
						thisForm.findField('timeOutTextbox').hide();						
						Ext.getCmp('execute').setVisible(false);
						Ext.Ajax.request({
							url : '/final/monitor/RemoteControlActionVMSessionJson.jsp',
							method : 'POST',
							params: 'rmt_cmd='+rmt_cmd+'&comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&task_name='+task_name+'&port='+init_port+'&vmName='+vmName+'&hostname='+hostName+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&multiple_users_supported_task='+multiple_users_supported_task,
							scope:this,
							timeout:300000,
							success: function(response)
							{
								Ext.destroy(progressBarHandle);
								progressBarHandle=null;
								//thisForm.findField('usernames').show();
								var jsonData=Ext.decode(response.responseText);
								if(multiple_users_supported_task)
								{
									thisForm.findField('usernames').hide();
									thisForm.findField('usernames_multiple').show();
									var usernamesOpts_multiple = thisForm.findField('usernames_multiple');								
									usernamesOpts_multiple.getStore().removeAll();
									usernamesOpts_multiple.getStore().loadRawData(jsonData['usernamesOpts']);
									Ext.getCmp('usernames_multiple').boundList.getSelectionModel().selectAll();
								}
								else
								{
									thisForm.findField('usernames').show();
									thisForm.findField('usernames_multiple').hide();
									var usernamesOpts = thisForm.findField('usernames');								
									usernamesOpts.getStore().removeAll();
									usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
								}
								//usernamesOpts.setValue("-1");
								var winHeight = Ext.getCmp('remote_control').getHeight();
								var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
								var usernames=jsonData['usernamesOpts'];
								if((multiple_users_supported_task && usernames.length==0) || (!multiple_users_supported_task && usernames.length == 1))
								{
									if(!multiple_users_supported_task)
									{
										usernamesOpts.setValue("-1");
									}
									thisForm.findField('usernames').hide();
									thisForm.findField('usernames_multiple').hide();
									var height=Ext.getCmp('remote_control').getHeight();
									var updatepanel=Ext.getCmp('remote_cmd');
									updatepanel.removeAll();
									var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
									output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>No Users found!<\/li></span></div></div></ul>";
									updatepanel.add({
										xtype: 'panel',
										margin:10,
										cls:'formOuter',
										//bodyStyle:{'background':'yellow !important'},
										height:cmdHeight,
										border:false,
										html:output
									});
									updatepanel.doLayout();
									updatepanel.show();
								}
								else if(rmt_cmd=='RC_41:VMAgentOS' && isThisVDICompType=='true')
								{
									if(multiple_users_supported_task)
									{
										var usernamesOpts_multiple = thisForm.findField('usernames_multiple');
										usernamesOpts_multiple.hide();
										usernamesOpts_multiple.setEditable(false);
										usernamesOpts_multiple.setHideTrigger(true);
										usernamesOpts_multiple.setValue(jsonData.s_user_for_RC_41);
									}
									else
									{
										var usernamesOpts = thisForm.findField('usernames');	
										usernamesOpts.hide();
										usernamesOpts.setEditable(false);
										usernamesOpts.setHideTrigger(true);
										usernamesOpts.setValue(jsonData.s_user_for_RC_41);
									}
									this.loadSessionFormData();
									this.changeSessionId();
								}
								else
								{
									if(multiple_users_supported_task)
									{
										this.loadSessionFormData();
									}
									else
									{
										usernamesOpts.setValue("-1");
									}
								}
							},
							failure: function(response)
							{
								Ext.destroy(progressBarHandle);
								progressBarHandle=null;
								rcLoadMask.hide();
								//alert("failure...");
							}
						});
					}
					else
					{
						progressBarHandle=showWindow();						
						thisForm.findField('outputRqrd').hide();
						thisForm.findField('timeOutTextbox').hide();
						var dgName;
						if(rmt_cmd == 'RC_80:CtxXcXDCGroupTest')
						{							
							dgName = thisForm.findField('delivery_grp_name').getValue();	
						}				
						Ext.getCmp('execute').setVisible(false);
						Ext.Ajax.request({
							url : '/final/monitor/RemoteControlActionSessionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&test='+init_test_name+'&task_name='+task_name+'&port='+init_port+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&dgName='+dgName+'&userName='+encodeURI(userNameDisp)+'&userBased='+userBased+'&multiple_users_supported_task='+multiple_users_supported_task,
							method : 'POST',
							scope:this,
							timeout:300000,
							success: function(response)
							{
								if(init_test_name=='ChangeLoginTest' || init_test_name=='CtxXcXDSiteTest' || init_test_name=='CtxXcXDSiteSiteTest' || init_test_name=='CtxXcXDCGroupTest' || init_test_name=='CtxXcXDCBrMachTest' || init_test_name=='ADUserLockOutTest'  || init_test_name=='CitrixLicenseTest'  || init_test_name=='ADUsersTest' || init_test_name == 'CtxXcXDDesktopsTest')
								{
									this.loadFormData();
								}
								else
								{
									Ext.destroy(progressBarHandle);
									progressBarHandle=null;								
									if(rmt_cmd == 'RC_80:CtxXcXDCGroupTest')
										thisForm.findField('delivery_grp_name').show();
									if(multiple_users_supported_task)
									{
										thisForm.findField('usernames').hide();
										thisForm.findField('usernames_multiple').show();
									}
									else
									{
										thisForm.findField('usernames').show();
										thisForm.findField('usernames_multiple').hide();
									}
									var jsonData=Ext.decode(response.responseText);
									if(multiple_users_supported_task)
									{
										var usernamesOpts_multiple = thisForm.findField('usernames_multiple');									
										usernamesOpts_multiple.getStore().removeAll();
										usernamesOpts_multiple.getStore().loadRawData(jsonData['usernamesOpts']);
										Ext.getCmp('usernames_multiple').boundList.getSelectionModel().selectAll();
										this.loadSessionFormData();
									}
									else
									{
										var usernamesOpts = thisForm.findField('usernames');									
										usernamesOpts.getStore().removeAll();
										usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
									
										if(userNameDisp!=null && userNameDisp!="")
										{
											usernamesOpts.setValue(userNameDisp);
											usernamesOpts.hide();
											usernamesOpts.setEditable(false);
											usernamesOpts.setHideTrigger(true);
											this.loadSessionFormData();
										}
										else
											usernamesOpts.setValue("-1");
									}
									var winHeight = Ext.getCmp('remote_control').getHeight();
									var cmdHeight = winHeight - Ext.getCmp('remotecontrolform').getHeight()-40;
									var usernames=jsonData['usernamesOpts'];
									if(usernames.length == 1 && (userNameDisp==null || userNameDisp==""))
									if((multiple_users_supported_task && usernames.length==0) || (!multiple_users_supported_task && usernames.length == 1 && (userNameDisp==null || userNameDisp=="")))
									{
										if(multiple_users_supported_task)
										{
											thisForm.findField('usernames').hide();
											thisForm.findField('usernames_multiple').hide();
										}
										else
										{
											thisForm.findField('usernames').hide();
											thisForm.findField('usernames_multiple').hide();
										}
										var height=Ext.getCmp('remote_control').getHeight();
										var updatepanel=Ext.getCmp('remote_cmd');
										updatepanel.removeAll();
										var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
										output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>No Users found!<\/li></span></div></div></ul>";
										updatepanel.add({
											xtype: 'panel',
											margin:10,
											cls:'formOuter',
											height:cmdHeight,
											//bodyStyle:{'background':'brown !important'},
											border:false,
											html:output
										});
										updatepanel.doLayout();
										updatepanel.show();
									}
								}
								
							},
							failure: function(response)
							{
								Ext.destroy(progressBarHandle);
								progressBarHandle=null;
							}
						});
					}
				}
			}
		}
		enableDisableEls(rmt_cmd);
	},
	loadSessionFormData : function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		this.loadFormData();
	},
	changelogonModes: function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var logonModesValue = Ext.getCmp('logonModes').getValue();
		if(logonModesValue == '-1')
		{
			var thisForm = this.getRemotecontrolactionForm().getForm();
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else
		{
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeSessionId: function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		Ext.getCmp('execute').setVisible(true);
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
		var s_session_id = Ext.getCmp('user_session_id').getValue();
		var s_user_session_id_multiple = Ext.getCmp('user_session_id_multiple').getValue();
		if(rmt_cmd == '-1')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(s_session_id == '-1')
		{
			thisForm.findField('msg_box').hide();
			if(Ext.getCmp('user_session_id').isVisible())
			{
				thisForm.findField('user_session_id').show();
			}
			else
			{
				thisForm.findField('user_session_id').hide();
			}
			if(Ext.getCmp('user_session_id_multiple').isVisible())
			{
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			Ext.getCmp('execute').setVisible(false);
		}
		else if(rmt_cmd=='RC_0' || rmt_cmd=='RC_2' || rmt_cmd=='RC_54' || rmt_cmd=='RC_3' || rmt_cmd=='RC_4' || rmt_cmd=='RC_17' || rmt_cmd=='RC_18' || rmt_cmd=='RC_56' || rmt_cmd=='RC_57' || rmt_cmd=='RC_58' || rmt_cmd=='RC_61' || rmt_cmd == 'RC_83' || rmt_cmd == 'RC_84' || rmt_cmd=='RC_85')
		{
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
		}
		else if(rmt_cmd=='RC_5')
		{
			thisForm.findField('msg_box').show();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
		}
		else if(rmt_cmd=='RC_6')
		{
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}		
		else if(rmt_cmd=='RC_8')
		{
			//display services hosted in process
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}
		else if(rmt_cmd=='RC_9')
		{
			Ext.getCmp('execute').setVisible(false);
			this.getRemotecontrolactionForm().loadSessionData();
		}
		else if(rmt_cmd=='RC_14')
		{
			// Changes the XenApp Logon Mode for the selected server
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			Ext.getCmp('execute').setVisible(true);
		}
		else if(rmt_cmd=='RC_41' && isThisVDICompType=='true')
		{
			thisForm.findField('msg_box').hide();
			thisForm.findField('user_session_id').hide();
			thisForm.findField('user_session_id_multiple').hide();
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id_multiple').setValue(singleSessionId);
			}
			else
			{
				thisForm.findField('user_session_id').setValue(singleSessionId);
			}
			thisForm.findField('user_process_name').setValue('-1');
			thisForm.findField('pid_multi_select').setValue('-1');
			thisForm.findField('msg_box').setValue('none');
			thisForm.findField('logonModes').setValue('-1');
			Ext.getCmp('execute').setVisible(true);
		}
		else
		{
			thisForm.findField('msg_box').hide();
			if(multiple_users_supported_task)
			{
				thisForm.findField('user_session_id').hide();
				thisForm.findField('user_session_id_multiple').show();
			}
			else
			{
				thisForm.findField('user_session_id').show();
				thisForm.findField('user_session_id_multiple').hide();
			}
			thisForm.findField('user_process_name').hide();
			thisForm.findField('pid_multi_select').hide();
			thisForm.findField('logonModes').hide();
		}
	},
	changeProcessName: function() 
	{	
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var thisForm = this.getRemotecontrolactionForm().getForm();
		//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();	
		var pidName = Ext.getCmp('user_process_name').getValue();
		var process_Name = Ext.getCmp('user_process_name').getDisplayValue();
		processName = process_Name;		
		if(taskName != "RC_6" && taskName != "RC_86") {	
			if(pidName == '-1') {				
				Ext.getCmp('execute').setVisible(false);
			}
			else {
				Ext.getCmp('execute').setVisible(true);
			}
		}
		else {			
			if(pidName == '-1') {
				Ext.getCmp('pid_multi_select').hide();	
				Ext.getCmp('execute').setVisible(false);
			}
			else {
				var multipleSessionIds=Ext.getCmp('user_session_id_multiple').getValue();
				Ext.Ajax.request({
				url : '/final/monitor/RemoteControlActionPidJson.jsp?processName='+processName+'&task_name='+taskName+'&multipleSessionIds='+encodeURIComponent(multipleSessionIds),
				method : 'POST',
				scope:this,
				timeout:300000,
				success: function(response)
				{					
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					Ext.destroy(progressBarHandle);
					progressBarHandle=null;					
					
					var pid_multi_select = thisForm.findField('pid_multi_select');
					pid_multi_select.getStore().removeAll();
					pid_multi_select.getStore().loadRawData(jsonData['pidOpts']);	
					pid_multi_select.setValue("-1");
					Ext.getCmp('pid_multi_select').show();	
					Ext.getCmp('execute').setVisible(true);
				},
				failure: function(response)
				{
					Ext.getCmp('execute').setVisible(false);
					Ext.destroy(progressBarHandle);
					progressBarHandle=null;
					Ext.MessageBox.alert(actionTitle,failedetailsLbl);

					var thisForm = this.getRemotecontrolactionForm().getForm();
					var userSessionOpts = thisForm.findField('user_session_id');
					userSessionOpts.setValue("-1");

					//var userProcessOpts = thisForm.findField('user_process_name');
					//userProcessOpts.setValue("-1");
					Ext.getCmp('pid_multi_select').hide();
				}
			});        
			//Ext.getCmp('pid_multi_select').setVisible(true);
			}
		}
	},
	changePidName: function() 
	{
		if(Ext.getCmp('user_pid_name') != null && Ext.getCmp('user_pid_name').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeLicenseUsername: function()
	{
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		if(Ext.getCmp('license_username').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			//Ext.getCmp('outputRqrd').show();
			//Ext.getCmp('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeLicenseMachinename: function()
	{	
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		if(Ext.getCmp('license_machinename').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else {
			//Ext.getCmp('outputRqrd').show();
			//Ext.getCmp('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	},
	changeADUsername: function()
	{
		var thisForm = this.getRemotecontrolactionForm().getForm();
		var remoteCmd = Ext.getCmp('remote_cmd');
		if(remoteCmd!=null)
			remoteCmd.removeAll();
		var rmt_cmd = Ext.getCmp('rmt_cmds').getValue();
		rmt_cmd = rmt_cmd.substring(0,rmt_cmd.indexOf(":"));
	
		Ext.getCmp('ad_password').hide();
		Ext.getCmp('ad_confirm_password').hide();
		if(Ext.getCmp('ad_username').getValue() == '-1') {
			Ext.getCmp('execute').setVisible(false);
		}
		else
		{
			if(rmt_cmd=='RC_30')
			{
				Ext.getCmp('ad_password').show();
				Ext.getCmp('ad_confirm_password').show();
			}
			//thisForm.findField('outputRqrd').show();
			//thisForm.findField('timeOutTextbox').show();
			Ext.getCmp('execute').setVisible(true);
		}
	}
});
function checkspace(field)
{
	var s_val;
	if(typeof(field)=='object')
	{
		s_val = field.value;
	}
	else
	{
		s_val = field;
	}
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			//alert(_checkblank);
			return false;
		}
	}
	return true;
}
function checkspecialChar(field,s_spl)
{
	if(typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}
function callRemoteControlActionP(paramsForReq,timeOutValForAjax,commandOpts1,cmdHeight,remoteCmd)
{
	progressBarHandle=showWindow();	
	Ext.Ajax.request({
		url : '/final/monitor/RemoteControlActionp.jsp',
		method : 'POST',
		params: paramsForReq,
		timeout:timeOutValForAjax,
		scope:this,
		success: function(response)
		{
			Ext.getCmp('execute').setDisabled(false);
			Ext.destroy(progressBarHandle);
			progressBarHandle=null;
			var jsonText = response.responseText;	
			var jsonData=Ext.decode(jsonText);			
			if(!Ext.isEmpty(jsonData))
			{
				var errorMessage = jsonData['errorMessage'];
				if(errorMessage!=null && errorMessage!="-")
				{
					alert("error occured");
				}
				else if(!commandOpts1.startsWith("shutdown") || !commandOpts1.startsWith("logoff"))
				{
					var result = jsonData['output'];
					var updatepanel=Ext.getCmp('remote_cmd');
					var isGridView = jsonData['isGridView'];
					var multipleUsersSelected=jsonData['multipleUsersSelected'];
					if(commandOpts1=='getActiveFilesReport')
					{
						var fieldModel = new Array();
						var columns = new Array();
						var tableColumns = new Array();
						tableColumns.push(processname_label);
						tableColumns.push(filename_label);
						tableColumns.push(numberofevents_label);
						tableColumns.push(percentage_label);

						var tableData = jsonData['gridJson'];
						var gridValues = tableData['gridValues'];
						var events_count=jsonData['eventsCount'];

						var readTableData = jsonData['readGridJson'];
						var readGridValues = readTableData['readGridValues'];
						var read_events_count=jsonData['readEventsCount'];

						var writeTableData = jsonData['writeGridJson'];
						var writeGridValues = writeTableData['writeGridValues'];
						var write_events_count=jsonData['writeEventsCouunt'];

						var colIdx = 0;
						if(gridValues.length > 0) 
						{
							for (var key in tableColumns) {                    

								if(colIdx==0 || colIdx==1)
								{
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
								}
								else
								{
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'number'
									});
								}
								columns.push({
										header: tableColumns[colIdx],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, meta){
										meta.style = 'white-space: normal;'; // applied style for DIV element
										meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
										return value;
									}									
								});
								colIdx++;
							}
							var ackStore = Ext.data.Store({
								fields: fieldModel,
								data: gridValues,
								proxy: {
									type: 'ajax',
									reader: {
										type: 'json'
									}
								}
							});
							var r_ackStore = Ext.data.Store({
								fields: fieldModel,
								data: readGridValues,
								proxy: {
									type: 'ajax',
									reader: {
										type: 'json'
									}
								}
							});
							var w_ackStore = Ext.data.Store({
								fields: fieldModel,
								data: writeGridValues,
								proxy: {
									type: 'ajax',
									reader: {
										type: 'json'
									}
								}
							});
							var accordionPanel=Ext.create('Ext.panel.Panel',
							{
								flex:1,
								defaults: {
									bodyStyle: 'padding:15px'
								},
								layout: {
									type: 'accordion',
									titleCollapse: true,
									animate: true,
									activeOnTop: true
								},
								items: [
								{
									xtype: 'grid',
									flex:1,
									scroll:true,
									autoScroll:true,
									store: ackStore,
									margin:'5 10 5 10',
									title:'<span class="f13-bold">'+total_events_label+'&nbsp;:&nbsp;'+events_count+ ',&nbsp;&nbsp;'+read_events_label+'&nbsp;:&nbsp;'+read_events_count+ ',&nbsp;&nbsp;'+write_events_label+'&nbsp;:&nbsp;'+write_events_count+ ',&nbsp;&nbsp;'+read_transfer_label+'&nbsp;:&nbsp;'+read_transfer_size_in_byte+',&nbsp;&nbsp;'+write_transfer_label+'&nbsp;:&nbsp;'+write_transfer_size_in_byte+',&nbsp;&nbsp;'+disk_service_label+'&nbsp;:&nbsp;'+disk_service_time_in_sec+'</span>',
									cls: 'gridSkin',
									header:headerBoolean,
									bodyStyle:'overflowY: auto',
									columns: columns
								},{
									xtype: 'grid',
									flex:1,
									scroll:true,
									autoScroll:true,
									store: r_ackStore,
									margin:'5 10 5 10',
									title:'<span class="f13-bold">'+read_events_label+'&nbsp;:&nbsp;'+read_events_count,
									cls: 'gridSkin',
									header:headerBoolean,
									bodyStyle:'overflowY: auto',
									columns: columns,
									hidden:(readGridValues.length==0)
								},{
									xtype: 'grid',
									store: w_ackStore,
									flex:1,
									scroll:true,
									autoScroll:true,
									margin:'5 10 5 10',
									title:'<span class="f13-bold">'+write_events_label+'&nbsp;:&nbsp;'+write_events_count,
									cls: 'gridSkin',
									header:headerBoolean,
									bodyStyle:'overflowY: auto',
									columns: columns,
									hidden:(writeGridValues.length==0)
								}],
							});
							updatepanel.add(accordionPanel);
						}
					}
					else if(commandOpts1=='getProfileOfeGAgentByCpu')
					{
							var result = jsonData['output'];
							if(result.indexOf('No such file or directory')==-1)
							{
								var fieldModel = new Array();
								var columns = new Array();
								var tableData = jsonData['gridJson'];
								var tableColumns = new Array();
								tableColumns.push(threadName_label);
								tableColumns.push(cpu_label+" ("+ms_label+")");
								tableColumns.push(threadId_label);
								tableColumns.push(nativeThreadId_label);
								tableColumns.push(status_label);
								var gridValues = tableData['gridValues'];
								var gridTitle = tableData['gridTitle'];

								var headerBoolean;

								if(gridTitle == ""){
									headerBoolean = false;
								}else{
									headerBoolean = true;
								}

								var colIdx = 0;
								if (gridValues.length > 0) 
								{
									for (var key in tableColumns)
									{
										if(colIdx==1)
										{
											fieldModel.push({
												name: 'COLUMVal_' + colIdx,
												type: 'number'
											});
										}
										else
										{
											fieldModel.push({
												name: 'COLUMVal_' + colIdx,
												type: 'string'
											});
										}
										columns.push({
											header: tableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, meta){
											meta.style = 'white-space: normal;'; // applied style for DIV element
											meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
											return value;
											}
											
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										proxy: {
											type: 'ajax',
											reader: {
												type: 'json'
											}
										}
									});	
									updatepanel.add({
										xtype: 'grid',
										store: ackStore,
										margin:'5 10 5 10',
										title:'<span class="f13-bold">'+gridTitle+'</span>',
										cls: 'gridSkin',
										//ui:'newGridPanel',
										header:headerBoolean,
										height:cmdHeight+10,
										bodyStyle:'overflowY: auto',
										columns: columns,
									});
								}
							}
							else
							{
								updatepanel.add({
									xtype: 'panel',
									bodyStyle:'overflowY: auto',
									//bodyStyle:{'background':'pink !important'},
									margin:10,
									border:false,
									cls:'formOuter',
									height:cmdHeight,
									id:'updatepanel',
									html:result
								});
							}
					}
					else if(commandOpts1=='getProcessesByCpuMemUsage')
					{
							var result = jsonData['output'];
							if(result.indexOf('No such file or directory')==-1)
							{
								var fieldModel = new Array();
								var columns = new Array();
								var tableData = jsonData['gridJson'];
								var tableColumns = tableData['tableColumns'];
								var gridValues = tableData['gridValues'];
								var gridTitle = tableData['gridTitle'];

								var headerBoolean;

								if(gridTitle == ""){
									headerBoolean = false;
								}else{
									headerBoolean = true;
								}

								var colIdx = 0;
								if (gridValues.length > 0) 
								{
									for (var key in tableColumns)
									{
										if(colIdx==0 || colIdx==2 || colIdx==3)
										{
											fieldModel.push({
												name: 'COLUMVal_' + colIdx,
												type: 'number'
											});
										}
										else
										{
											fieldModel.push({
												name: 'COLUMVal_' + colIdx,
												type: 'string'
											});
										}
										columns.push({
											header: tableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, meta){
											meta.style = 'white-space: normal;'; // applied style for DIV element
											meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
											return value;
											}
											
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										proxy: {
											type: 'ajax',
											reader: {
												type: 'json'
											}
										}
									});	
									updatepanel.add({
										xtype: 'grid',
										store: ackStore,
										margin:'5 10 5 10',
										title:'<span class="f13-bold">'+gridTitle+'</span>',
										cls: 'gridSkin',
										//ui:'newGridPanel',
										header:headerBoolean,
										height:cmdHeight+10,
										bodyStyle:'overflowY: auto',
										columns: columns,
									});
								}
							}
							else
							{
								updatepanel.add({
									xtype: 'panel',
									bodyStyle:'overflowY: auto',
									//bodyStyle:{'background':'pink !important'},
									margin:10,
									border:false,
									cls:'formOuter',
									height:cmdHeight,
									id:'updatepanel',
									html:result
								});
							}
					}
					else if(commandOpts1=='getNetworkLatencyByProcesses')
					{
						var result = jsonData['output'];
						if(result.indexOf('No such file or directory')==-1)
						{
							var fieldModel = new Array();
							var columns = new Array();
							var tableData = jsonData['gridJson'];
							var tableColumns = tableData['tableColumns'];
							var gridValues = tableData['gridValues'];
							var gridTitle = tableData['gridTitle'];

							var headerBoolean;

							if(gridTitle == ""){
								headerBoolean = false;
							}else{
								headerBoolean = true;
							}

							var colIdx = 0;
							if (gridValues.length > 0) 
							{
								for (var key in tableColumns)
								{
									if(colIdx==1 || colIdx==3 || colIdx==5 || colIdx==6)
									{
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'number'
										});
									}
									else
									{
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'string'
										});
									}
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, meta){
										meta.style = 'white-space: normal;'; // applied style for DIV element
										meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
										return value;
										}
										
									});
									colIdx++;
								}
								var ackStore = Ext.data.Store({
									fields: fieldModel,
									data: gridValues,
									proxy: {
										type: 'ajax',
										reader: {
											type: 'json'
										}
									}
								});	
								updatepanel.add({
									xtype: 'grid',
									store: ackStore,
									margin:'5 10 5 10',
									title:'<span class="f13-bold">'+gridTitle+'</span>',
									cls: 'gridSkin',
									//ui:'newGridPanel',
									header:headerBoolean,
									height:cmdHeight+10,
									bodyStyle:'overflowY: auto',
									columns: columns,
								});
							}
						}
						else
						{
							updatepanel.add({
								xtype: 'panel',
								bodyStyle:'overflowY: auto',
								//bodyStyle:{'background':'pink !important'},
								margin:10,
								border:false,
								cls:'formOuter',
								height:cmdHeight,
								id:'updatepanel',
								html:result
							});
						}
					}
					else if(isGridView != 'undefined' && isGridView != undefined && isGridView == "true")
					{
						var fieldModel = new Array();
						var columns = new Array();
						var tableData = jsonData['gridJson'];
						var tableColumns = tableData['tableColumns'];
						var gridValues = tableData['gridValues'];
						var gridTitle = tableData['gridTitle'];

						var headerBoolean;

						if(gridTitle == ""){
							headerBoolean = false;
						}else{
							headerBoolean = true;
						}

						var colIdx = 0;
						if (gridValues.length > 0) 
						{
							for (var key in tableColumns) {                    

								fieldModel.push({
									name: 'COLUMVal_' + colIdx,
									type: 'string'
								});
								columns.push({
									header: tableColumns[key],
									dataIndex: 'COLUMVal_' + colIdx,
									align: 'left',
									flex: 1,
									sortable: true,
									renderer: function(value, meta){
								 	meta.style = 'white-space: normal;'; // applied style for DIV element
								 	meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
								 	return value;
									}
									
								});
								colIdx++;
							}
							var ackStore = Ext.data.Store({
								fields: fieldModel,
								data: gridValues,
								proxy: {
									type: 'ajax',
									reader: {
										type: 'json'
									}
								}
							});	
							if(commandOpts1.indexOf("wmic os list")>-1){
									updatepanel.add({
										xtype: 'panel',
										bodyStyle:'overflowY: auto',
										//bodyStyle:{'background':'white !important'},
										margin:'5 10 0 10',
										border:false,
										cls:'formOuter',
										height:30,
										id:'updatepanel',
										html:'<span class="f13-bold" style="margin: 5px 0 0px 10px;display: block;">'+WMITitle+'..</span>'
									});
									cmdHeight = cmdHeight - 30;
									updatepanel.add({
										xtype: 'grid',
										store: ackStore,
										margin:'5 10 5 10',
										title:'<span class="f13-bold">'+gridTitle+'</span>',
										cls: 'gridSkin',
										//ui:'newGridPanel',
										height:cmdHeight+10,
										header:headerBoolean,
										bodyStyle:'overflowY: auto',
										columns: columns,
									});
							}
							else {
									updatepanel.add({
										xtype: 'grid',
										store: ackStore,
										margin:'5 10 5 10',
										title:'<span class="f13-bold">'+gridTitle+'</span>',
										cls: 'gridSkin',
										//ui:'newGridPanel',
										header:headerBoolean,
										height:cmdHeight+10,
										bodyStyle:'overflowY: auto',
										columns: columns,
									});
						}
						}
						else {
							updatepanel.add({
								xtype: 'panel',
								bodyStyle:'overflowY: auto',
								//bodyStyle:{'background':'pink !important'},
								margin:10,
								border:false,
								cls:'formOuter',
								height:cmdHeight,
								id:'updatepanel',
								html:result
							});
						}
					}
					else if(multipleUsersSelected != 'undefined' && multipleUsersSelected != undefined && multipleUsersSelected == "true")
					{
						var updatepanelTitle1 = commandTitle+" - "+commandOpts1;
						updatepanelTitle1 = "";
						updatepanel.removeAll();
						updatepanel.add({
							xtype: 'panel',
							scroll:true,
							margin:'5 10 5 10',
							title:updatepanelTitle1,
							bodyStyle:{'overflowY':'auto','box-shadow':'none'},
							//bodyStyle:{'background':'lightgreen !important'},
							border:true,
							//ui:'newGraphPanel',
							ui:'simplePanel withBorder',
							//bodyCls:'configWinBody',
							//header:{
								//style:{'border':'0px','background':'transparent !important','padding-left':'0px'},
							//},
							height:cmdHeight+10,
							id:'updatepanel',
							html:result
						});
					}
					else {
						var updatepanelTitle1 = commandTitle+" - "+commandOpts1;
						

						if(commandOpts1 == 'RC_24'){
							updatepanelTitle1 = outputTitle;//or Result
						}
						updatepanelTitle1 = "";
						updatepanel.removeAll();
						updatepanel.add({
							xtype: 'panel',
							scroll:true,
							margin:'5 10 5 10',
							title:updatepanelTitle1,
							bodyStyle:{'overflowY':'auto','box-shadow':'none'},
							//bodyStyle:{'background':'lightgreen !important'},
							border:true,
							//ui:'newGraphPanel',
							ui:'simplePanel withBorder',
							//bodyCls:'configWinBody',
							//header:{
								//style:{'border':'0px','background':'transparent !important','padding-left':'0px'},
							//},
							height:cmdHeight+10,
							id:'updatepanel',
							html:result
						});
					}
					updatepanel.doLayout();
					remoteCmd.show();
				}
			}
		},
		failure:function()
		{
			Ext.getCmp('execute').setDisabled(false);
			Ext.destroy(progressBarHandle);
			progressBarHandle=null;
			var updatepanel=Ext.getCmp('remote_cmd');
			var output="<ul align='center' style='margin:10px; width:95%; height:93%; display:table;' class='f14-normal'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/error_msg_icon.png'></div>";
			output = output +"<div style='margin-top:15px;'>"+timedoutTitle+"</div></div></ul>";
			updatepanel.add({
				xtype: 'panel',
				margin:10,
				height:cmdHeight,
				//bodyStyle:{'background':'lightblue !important'},
				cls:'formOuter',
				id:'updatepanel',
				html:output
			});
			updatepanel.doLayout();
			remoteCmd.show();
		}
	});
}

function callRemoteControlAppActionP(obj)
{
	progressBarHandle=showWindow();
	Ext.Ajax.request({
		url : '/final/monitor/RemoteControlAppActionp.jsp',
		method : 'POST',
		params: obj.key_value_params,
		timeout:obj.timeOutValForAjax,
		scope:this,
		success: function(response)
		{
			if(!Ext.isEmpty(Ext.getCmp('execute'))){
			Ext.getCmp('execute').setDisabled(false);
			}
			Ext.destroy(progressBarHandle);
			var jsonData=Ext.decode(response.responseText);
			if(!Ext.isEmpty(jsonData))
			{
				var result = jsonData['output'];
				var fieldModel = new Array();
				var columns = new Array();
				var updatepanel=Ext.getCmp('remote_cmd');
				var isGridView = jsonData['isGridView'];
				if(jsonData['multipleUsersSelected'] != null && jsonData['multipleUsersSelected'])
				{
					var panel_not_defined=true;
					var accordionPanel="";
					var items = [];
					var grid_users=jsonData['grid_users'];
					if(grid_users != null && grid_users != 'undefined' && grid_users != undefined && grid_users.length>0)
					{
						var grid_users_output=jsonData['grid_users_output'];
						if(grid_users_output != null && grid_users_output != 'undefined' && grid_users_output != undefined && grid_users_output.length>0)
						{
							var tableData = grid_users_output[0];
							var colIdx = 0;
							var tableColumns = tableData['tableColumns'];
							for (var key in tableColumns)
							{
								fieldModel.push({
									name: 'COLUMVal_' + colIdx,
									type: 'string'
								});
								columns.push({
									header: tableColumns[key],
									dataIndex: 'COLUMVal_' + colIdx,
									align: 'left',
									flex: 1,
									sortable: true,
									renderer: function(value, meta){
									meta.style = 'white-space: normal;'; // applied style for DIV element
									meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
									return value;
									}
								});
								colIdx++;
							}
							var storeArray=new Array();
							for(var i=0;i<grid_users.length;i++)
							{
								var tableData1 = grid_users_output[i];
								var ackStore1 = Ext.data.Store({
									fields: fieldModel,
									data: tableData1['gridValues'],
									proxy: {
										type: 'ajax',
										reader: {
											type: 'json'
										}
									}
								});
								storeArray.push(ackStore1);
							}
							accordionPanel=Ext.create('Ext.panel.Panel',
							{
								flex:1,
								defaults: {
									bodyStyle: 'padding:15px'
								},
								layout: {
									type: 'accordion',
									titleCollapse: true,
									animate: true,
									activeOnTop: true
								},
								items: [],
							});
							updatepanel.add(accordionPanel);
							panel_not_defined=false;
							var grid_users_count=grid_users.length;
							for(var i=0;i<grid_users_count;i++)
							{
								items.push({xtype: 'grid',store: storeArray[i],margin:'5 10 5 10',title: '<span class="f13-bold">'+grid_users[i]+'</span>',cls: 'gridSkin',height:obj.cmdHeight+10,header:true,bodyStyle:'overflowY: auto',scroll:true,columns: columns});
							}
						}
					}
					var panel_users=jsonData['panel_users'];
					if(panel_users != null && panel_users != 'undefined' && panel_users != undefined && panel_users.length>0)
					{
						var panel_users_output=jsonData['panel_users_output'];
						if(panel_users_output != null && panel_users_output != 'undefined' && panel_users_output != undefined && panel_users_output.length>0)
						{
							if(panel_not_defined)
							{
								accordionPanel=Ext.create('Ext.panel.Panel',
								{
									flex:1,
									defaults: {
										bodyStyle: 'padding:15px'
									},
									layout: {
										type: 'accordion',
										titleCollapse: true,
										animate: true,
										activeOnTop: true
									},
									items: [],
								});
								updatepanel.add(accordionPanel);
							}
							var panel_users_count=panel_users.length;
							for(var i=0;i<panel_users_count;i++)
							{
								items.push({xtype: 'panel',title: '<span class="f13-bold">'+panel_users[i]+'</span>',scroll:true,margin:10,border:false,cls:'formOuter',height:obj.cmdHeight,bodyStyle:'overflowY: auto',id:'updatepanel'+i,html:panel_users_output[i]});
							}
						}
					}
					if(items.length>0)
					{
						accordionPanel.add(items);
					}
					accordionPanel.doComponentLayout();
				}
				else if(isGridView != 'undefined' && isGridView != undefined && isGridView == "true"){
					var tableData = jsonData['gridJson'];
					var errorMsg = tableData['errorMsg'];
					var gridTitle = tableData['gridTitle'];

					var headerBoolean;

					if(gridTitle == ""){
						headerBoolean = false;
					}else{
						headerBoolean = true;
					}
					var rc_taskname='-';
					var selected_task=Ext.getCmp('rmt_cmds').getValue();
					if(!Ext.isEmpty(selected_task) && selected_task=='RC_73:OS')
					{
						rc_taskname='RC_73';
					}
					var colIdx = 0;
					if (errorMsg=='-') 
					{
						var tableColumns = tableData['tableColumns'];
						var gridValues = tableData['gridValues'];
						for (var key in tableColumns) {
							if(rc_taskname=='RC_73')
							{
								if(colIdx==1 || colIdx==3 || colIdx==4 || colIdx==5)
								{
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'number'
									});
								}
								else
								{
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
								}
							}
							else
							{
								fieldModel.push({
									name: 'COLUMVal_' + colIdx,
									type: 'string'
								});
							}
							columns.push({
								header: tableColumns[key],
								dataIndex: 'COLUMVal_' + colIdx,
								align: 'left',
								flex: 1,
								sortable: true,
								renderer: function(value, meta){
								meta.style = 'white-space: normal;'; // applied style for DIV element
								meta.tdAttr = 'style="white-space: normal;"'; // applied style for TD element
								return value;
								}
							});
							colIdx++;
						}
						var ackStore = Ext.data.Store({
							fields: fieldModel,
							data: gridValues,
							proxy: {
								type: 'ajax',
								reader: {
									type: 'json'
								}
							}
						});	
						updatepanel.add({
							xtype: 'grid',
							store: ackStore,
							margin:'5 10 5 10',
							title: '<span class="f13-bold">'+gridTitle+'</span>',
							cls: 'gridSkin',
							//ui:'newGridPanel',
							height:obj.cmdHeight+10,
							header:headerBoolean,
							bodyStyle:'overflowY: auto',
							scroll:true,
							columns: columns,
						});
					}
					else {
						updatepanel.add({
							xtype: 'panel',
							scroll:true,
							margin:10,
							border:false,
							cls:'formOuter',
							height:obj.cmdHeight,
							//bodyStyle:{'background':'orange !important'},
							bodyStyle:'overflowY: auto',
							id:'updatepanel',
							html:result
						});
					}
				}
				else {
					updatepanel.add({
						xtype: 'panel',
						scroll:true,
						margin:'5 10 5 10',
						//border:false,
						//ui:'newGraphPanel',
						ui:'simplePanel withBorder',
						height:obj.cmdHeight,
						id:'updatepanel',
						html:result,
						bodyStyle:'overflowY: auto',
					});
				}
				updatepanel.doLayout();
				obj.remoteCmd.show();				
				if(obj.rmt_cmd=='fileupload' && result.indexOf("File uploaded successfully")>-1){
					Ext.getCmp('upload').setDisabled(true);
					Ext.Ajax.request({
						url : '/final/monitor/RemoteControlActionJson.jsp?comptype='+init_comp_type+'&layername='+init_layer_name+'&port='+init_port+'&agentIP='+agentIP+'&isAgentBased='+isAgentBased+'&rmtOrExtAgentIp='+rmtOrExtAgentIp+'&vmOS='+vmOS,
						method : 'POST',
						scope:this,
						success: function(response)
						{
							var jsonText = response.responseText;
							var jsonData=Ext.decode(jsonText);
							var rmtCmdOpts = thisForm.findField('rmt_cmds');
							rmtCmdOpts.getStore().loadRawData(publicJson['RemoteCmds']);
							rmtCmdOpts.setValue(obj.fileName);
						}
					});
				}
			
				if(obj.rmt_cmd  == "RC_4")
				{
					if(multiple_users_supported_task)
					{
						var usernamesOpts_multiple = Ext.getCmp('usernames_multiple');
						if(usernamesOpts_multiple != null && usernamesOpts_multiple != undefined)
						{
							Ext.getCmp('user_session_id').hide();
							Ext.getCmp('user_session_id_multiple').hide();
							Ext.getCmp('execute').hide();
							usernamesOpts_multiple.getStore().removeAll();
							if(jsonData['usernamesOpts'] != null && jsonData['usernamesOpts'].length>0)
							{
								usernamesOpts_multiple.getStore().loadRawData(jsonData['usernamesOpts']);
								Ext.getCmp('usernames_multiple').boundList.getSelectionModel().selectAll();								
								me.loadSessionFormData();
							}
						}
					}
					else
					{
						var usernamesOpts = Ext.getCmp('usernames');
						if(usernamesOpts != null && usernamesOpts != undefined)
						{
							usernamesOpts.getStore().removeAll();										
							usernamesOpts.getStore().loadRawData(jsonData['usernamesOpts']);
							usernamesOpts.setValue("-1");
							Ext.getCmp('user_session_id').hide();
							Ext.getCmp('user_session_id_multiple').hide();
							Ext.getCmp('execute').hide();
						}
					}
				}
			}
		},
		failure:function()
		{
			Ext.getCmp('execute').setDisabled(false);
			Ext.destroy(progressBarHandle);
			progressBarHandle=null;
			var updatepanel=Ext.getCmp('remote_cmd');
			var output="<ul align='center' class='f11-normal' style='margin:10px; width:100%; height:100%; display:table;'><div style='text-align:center; vertical-align:middle;display:table-cell;'><div><img src='"+imgPath+"/info_mgs_icon.png'></div>";
			output = output +"<div style='margin-top:15px;'><span style='color:"+fontColorCode+";'><li>"+timedoutTitle+" <\/li></span></div></div></ul>";
			updatepanel.add({
				xtype: 'panel',
				margin:10,
				height:obj.cmdHeight,
				//bodyStyle:{'background':'purple !important'},
				cls:'formOuter',
				id:'updatepanel',
				html:output
			});
			updatepanel.doLayout();
			obj.remoteCmd.show();
		}
		});
}
function showWindow()
{
	progressBarHandle=Ext.create('Ext.window.Window', {
		title: '',
		height: 180,
		width: 400,
		ghost:false,
		header:true,
		bodyPadding:'20 0 0 0',
		bodyStyle: 'background:#6c6c6c!important;',
		layout: 'fit',
		closable : true,
		renderTo: Ext.getBody(),
		//html:'<div><div>Agent IP/Nick Name:  <span></span></div><div>'
		tpl: new Ext.XTemplate(
			'<div style="text-align:center;margin-bottom:20px;color:#fff;">',
			'<p style="margin-bottom:8px"><span style="font-weight:bold">{name}<span></p>',
			'<p style="margin-bottom:8px">Trying to get output for the action</p>',
			'<p style="margin-bottom:8px">Please wait..</p>',
			'</div>'
		),
		data:{
			name:window.parent.rca.title 
		},
		listeners:{
					show:function(win){
						var p =  Ext.create('Ext.ProgressBar', {
								renderTo: win.body.id,
								style:{'margin':'0px auto'},
								width: 300
							});
							p.wait({
									interval: 500, //bar will move fast!
									duration: 500000,
									increment: 15,
									//text: 'Updating...',
									scope: this
									/*fn: function(){
										//Ext.destroy(progresswindow);
									}*/
								});
								p.show();
				},
				close:function(win)
				{
					Ext.getCmp('execute').setDisabled(false); 
				}
			}
		}).show();
	return progressBarHandle;
}
function enableDisableEls(cmd)
{
	if(!Ext.isEmpty(cmd))
	{
		cmd = (cmd.indexOf(':') > -1) ? cmd.substring(0,cmd.indexOf(':')) : cmd;
	}
	if(!Ext.isEmpty(cmd) && cmd == 'RC_68')
	{
		Ext.getCmp('rmyn1').getEl().down('label.x-form-cb-label').update('Shutdown');
		Ext.getCmp('rmyn2').getEl().down('label.x-form-cb-label').update('Show');
		Ext.getCmp('arugumentsTextBox').setDisabled(false); 
		Ext.getCmp('execute').setDisabled(false); 
	}
	else if(!Ext.isEmpty(cmd) && cmd == 'RC_69')
	{
		Ext.getCmp('rmyn1').getEl().down('label.x-form-cb-label').update('Yes');
		Ext.getCmp('rmyn2').getEl().down('label.x-form-cb-label').update('No');
		var machine_val = Ext.getCmp('restart_a_machine').getValue().restart_a_machine_yes_no;
		if(machine_val.toLowerCase() == 'yes')
		{
			Ext.getCmp('arugumentsTextBox').setDisabled(false); 
			Ext.getCmp('execute').setDisabled(false); 
			Ext.getCmp('execute').getEl().down('.x-btn-inner').setStyle({'opacity' : ''},{'filter' : ''});
		}
		else
		{
			Ext.getCmp('arugumentsTextBox').setDisabled(true); 
			Ext.getCmp('execute').setDisabled(true); 
			Ext.getCmp('execute').getEl().down('.x-btn-inner').setStyle({'opacity' : '0.2'},{'filter' : 'alpha(opacity=20)'});
		}
	}
	else
	{
		if(Ext.getCmp('execute').isVisible())
		{
			var btn_opacity = Ext.getCmp('execute').getEl().down('.x-btn-inner').getStyle('opacity');
			if(btn_opacity < 1)
			{
				Ext.getCmp('execute').setDisabled(false);
				Ext.getCmp('execute').getEl().down('.x-btn-inner').setStyle({'opacity' : ''},{'filter' : ''});
			}
		}
		var ipt_box = Ext.getCmp('arugumentsTextBox');
		if(ipt_box.isVisible() && ipt_box.isDisabled())
		{
			ipt_box.setDisabled(false);
		}
	}
}
