Ext.define('SystemList.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main','SystemComponentList','ConfigWindow'],
	requires:['SystemList.view.SystemComponentList','SystemList.view.ConfigWindow'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'systemcomponent',ref:'systemComponent'},
		{selector:'systemcomponentlist',ref:'systemComponentList'},
		{selector:'systemlistForm combo#state', ref:'systemStateCombo'},
		{selector:'systemlistForm combo#type', ref:'systemTypeCombo'},
		{selector:'systemlistForm textfield[action=nickname]',ref:'systemNickName'},
		{selector:'systemlistForm textfield[action=searchtypefield]',ref:'systemSearchTypeField'},
		{selector:'systemlistForm button[action=submit]',ref:'submitSearch'},
		{selector:'systemlistForm',ref:'systemlistForm'},
		{ref:'commonPanel',selector:'generalMeasuresGridPanel[id="perPanel"]'},
		{
    	ref:'configWindowRadio',
    	selector:'configwindow > form > radio'
    },{
    	ref:'configWindow',
    	selector:'configwindow'
    },{
    	ref:'measuresAndAnalysis',
    	selector:'measureandanalysis'
    },{
    	ref:'configWindowForm',
    	selector:'configwindow > form'
    }
	],
	init:function(){
		//refreshFrequency
		//setInterval(this.refresh,refreshFrequency);
		setInterval("execute()",refreshFrequency);
		this.control({
			'main':{
				afterrender:this.defaultRender
			},
			'systemlistForm':{
				render:this.systemDataLoad
			},
			'systemlistForm textfield[action=nickname]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.submitButtonClicked();
					}
				}
			},
			'systemlistForm textfield[action=searchtypefield]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.submitButtonClicked();
					}
				}
			},
			'systemlistForm combo#state': {
				select: function() {
					this.submitButtonClicked();
				}
			},
			'systemlistForm combo#type': {
				select: function() {
					this.submitButtonClicked();
				}
			},
			'systemlistForm button[action=submit]': {
				click: function() {
					this.submitButtonClicked();
				}
			},
			'commonbackbutton':{
				click:this.backButtonHandler
			},
			'generalMeasuresGridPanel combo[id="filterByCombo"]':{
				'select':this.compFilterByComboOnChange
			},
			'generalMeasuresGridPanel combo[id="subFilterCombo"]':{
				change:this.compSubFilterComboOnChange
			},
			'generalMeasuresGridPanel combo[id="componentTypCombo"]':{
				//change:this.componentTypeComboOnChange
			},
			'generalMeasuresGridPanel combo[id="sortByCombo"]':{
				'select':this.componentsmeasureComboChange
			},
			'generalMeasuresGridPanel button[action="submit"]':{
				click: this.componentTypeComboOnChange
			},
			'textfield[id="nickName"]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.compSubmitButtonClicked();
					}
				}
			},
			'main button[action="configsetting"]':{
				scope : this,
				click : this.openConfigWindow
			},
			'configwindow':{
				'render': this.itemset,
				 'close':this.refreshcall
			},
			'configwindow > form > combo':{
				'select':this.combo
			},
			'configwindow > form > radiogroup':{
				'change':this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click:this.buttonclick
			},
			'dashboardgeneralmeasuresgrid':{
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
			}
		});
	},
	defaultRender:function(){
	},
	openConfigWindow : function(button){
		var VWidth = Ext.Element.getViewportWidth( );
		try
		{
			var backButtonExist = Ext.getCmp('back').hidden;
			var popUparrowaxis = '418px';
			if(backButtonExist != undefined && backButtonExist != null && !backButtonExist)
				popUparrowaxis = '357px';				
		}
		catch (e)
		{
			popUparrowaxis = '357px';
		}

		function targetPosition(totalwidth,targetID,popupwidth){
			var left = totalwidth -  Ext.getCmp(targetID).getPosition()[0],
				targetWidth = Ext.getCmp(targetID).getWidth()/2 + 1,
				targetPosition = (popupwidth + targetWidth) - left;
			return targetPosition;
		}		

		var left = targetPosition(VWidth,'settingIconId',490);

		if(this.getConfigWindow())
			this.getConfigWindow().destroy();

		if(!this.getConfigWindow())
		{
			var win=Ext.create('SystemList.view.ConfigWindow');
			win.show();

			container = Ext.create('Ext.container.Container',{
				floating:true,
				frame:true,
				width:490,
				ui:'configOuterContainer',
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				//cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':left+'px'}
					},
					{
						xtype:'container',
						cls:'configMode_header',
						margin:'0 10',
						padding:'10 0 5 0',
						html:'<div class="settingsfont" style="float:left;text-transform:uppercase;">Settings</div><div style="text-align:right;float:right;"><div class="iconCloseNew"></div></div>',
					},
						win
				]
			});

			var containerPosition = VWidth - (container.width + 15);
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: containerPosition,
					top:-500
				},
				to: {
				   top:40,
					left: containerPosition
				}
			});

			container.showAt(containerPosition,5000);
			Ext.select('.iconCloseNew').on('click',function(){
					Ext.create('Ext.fx.Anim', {
						target: container,
						duration: 500,
						from: {
						left: containerPosition,
							top:40
						},
						to: {
						   top:-500,
						left: containerPosition
						},
						callback: function(){
							container.hide();
							SystemList.app.getController("Main").metricRefresh();
						}
					});
			},this);

			Ext.getBody().on('click',function(event){
					var tarid = event.target.id;
					if((tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1) || (tarid.toLowerCase().indexOf("listbutid") != -1) || (tarid.toLowerCase().indexOf("centerp") != -1))))
					{
						container.hide();
					}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
					top:40,
					left: VWidth -615
				}
			});
			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			SystemList.app.getController("Main").metricRefresh();
		}
	},
	compFilterByComboOnChange:function(combo){

		//var hostType=combo.getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		url=url+"&filterBy="+filterByComboVal;

		var subFilterComboObj = Ext.getCmp('subFilterCombo');
		var isOthers=false;

		if(filterByComboVal=='Component' || filterByComboVal=='System' ||  filterByComboVal=='Network')
		{
			subFilterComboObj.hide();
			isOthers = true;
		}
		else
		{
			//subFilterComboObj.show();
		}

		sortState="";
		DirProperty="";
		if(isOthers)
		{
			this.getCommonPanel().loadTab(url,'','','','','','systemList');
			Refurl=url;
		}
		else
		{
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					subFilterComboObj.getStore().loadRawData(jsonData.subFilterOptions);
					subFilterComboObj.setValue(jsonData.pageParams.selectedSubFilterOption);
					subFilterComboObj.setFieldLabel(jsonData.pageParams.subFilterLabel);
					subFilterComboObj.show();
				}
			});
		}
	},
	
	compSubFilterComboOnChange:function(combo){

		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}
		
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		
		sortState="";
		DirProperty="";

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+nickNameVal;
			var url = url;
			Refurl=url;
			this.getCommonPanel().loadTab(url,'','','','','','systemList');
		}
		else if(itemIdVal=='components' || itemIdVal=='Components' )
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal;
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
	},
	componentTypeComboOnChange:function(combo)
	{
		var fromPageView=requestParams.fromPageView;
		//var componentTypeVal=combo.getValue();
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo') != null && Ext.getCmp('componentTypCombo')!=undefined)
		{
			 componentTypeVal=Ext.getCmp('componentTypCombo').getValue();
		}
		//var componentTypeVal=Ext.getCmp('componentTypCombo').getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
			if (subFilterComboVal == -1)
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please choose a Zone',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined)
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=this.getCommonPanel().itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+nickNameVal+"&fromPageView="+fromPageView;

		
		sortState="";
		DirProperty="";

		Refurl=url;
		this.getCommonPanel().loadTab(url,'','','','','','systemList');
	},
	compSubmitButtonClicked:function()
	{
		if(Ext.isEmpty(this.getCommonPanel()))
			return;
		var fromPageView=requestParams.fromPageView;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		var sortByComboVal="";
		if(Ext.getCmp('sortByCombo')!=null && Ext.getCmp('sortByCombo')!=undefined && Ext.getCmp('sortByCombo').getValue()!=null && Ext.getCmp('sortByCombo').getValue()!='null')
		{
			sortByComboVal = Ext.getCmp('sortByCombo').getValue();
		}
		var url="";
		var itemIdVal=this.getCommonPanel().itemId;

		try
		{
			nickNameVal = window.opener.filterEncode(nickNameVal);
		}
		catch (e)
		{
			try{
				nickNameVal = parent.filterEncode(nickNameVal);
			}
			catch(ee)
			{
				nickNameVal = parent.parent.filterEncode(nickNameVal);
			}
		}

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&componentType="+componentTypeVal;
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView;
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+subFilterComboVal+"&componentType="+componentTypeVal+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView;
		}

		var url = url;
		Refurl=url;
		this.getCommonPanel().loadTab(url,'','','','','','systemList');
	},
	loadMetricsView:function(in_url,title_val,pId)
	{
		var mainPanel = this.getMain();

		if(mainPanel!=null && mainPanel!=undefined && mainPanel.items!=null && mainPanel.items!=undefined)
		{
			var resultItems=mainPanel.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				Ext.ComponentQuery.query("[itemId='componentslistToolbar']")[0].removeAll(true);
				resultItems[item].destroy();
			}
		}

		var myMask = null;
		if(!Ext.isEmpty(mainPanel))
		{
			myMask = new Ext.LoadMask(mainPanel, {msg:"Please wait..."});
			myMask.show();
		}

		var listButIdObj=Ext.getCmp('listButId');
		var GridButIdObj=Ext.getCmp('GridButId');

		if(GridButIdObj!=null && GridButIdObj!=undefined)
		{
			GridButIdObj.removeCls('iconCompGridviewSelect');
			GridButIdObj.removeCls('iconCompGridview');

			GridButIdObj.addCls('iconCompGridviewSelect');
		}
		
		if(listButIdObj!=null && listButIdObj!=undefined)
		{
			listButIdObj.removeCls('iconCompListviewSelect');
			listButIdObj.removeCls('iconCompListview');
			listButIdObj.addCls('iconCompListview');
		}

		//Refurl="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		Refurl=in_url;
		Refid=pId;
		Reftext=title_val;

		mainPanel.setTitle(Reftext);
		mainPanel.header.addClass("panelTitle");
		mainPanel.add({
			xtype:'generalMeasuresGridPanel',
			cls:'gridHeadercenter',
			itemId:Refid,
			margin:0,
			padding:0,
			frame:false,
			border:false,
			layout:{type:'vbox',align:'stretch'},
			flex:1,
			screenLabelPath:"monitor.Dashboard",
			url:Refurl,
			listeners: {
				'afterrender': function (obj) {
					this.loadTab(obj.url,'','','','','','systemList');
					myMask.hide();
				}
			}
		});
	},
	systemDataLoad:function(panel){
		var me = this;
		/*Ext.Ajax.on("beforerequest", function(){
			me.getMain().setLoading(true);
		});*/

		var mainPanel = me.getMain();
		var myMask = null;
		if(!Ext.isEmpty(mainPanel))
		{
			myMask = new Ext.LoadMask(mainPanel, {msg:"Please wait..."});
			myMask.show();
		}

		Ext.Ajax.request({
			url:panel.url,
			success:function(response,opts){
				var jsontext=response.responseText;
				var jsondata=Ext.decode(jsontext);
				
				jsontext = null;
				Ext.destroy(jsontext);

				var systemcomponent = Ext.getCmp('systemcomponent');
				if(!Ext.isEmpty(systemcomponent))
				{
					var resultItems=systemcomponent.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}

				if(!Ext.isEmpty(jsondata.ScreenLabels)){

					if(!Ext.isEmpty(jsondata.ScreenLabels.Title)){
						//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
						//me.getMain().setTitle(jsondata.ScreenLabels.Title);
						me.getMain().setTitle(jsondata.ListLabels.ListTitle);
					}

					me.getSystemlistForm().down('scrollcombo[itemId=state]').setFieldLabel(jsondata.SearchLabels.searchStateLabel);

					me.getSystemlistForm().down('textfield[itemId=nicknametext]').setFieldLabel(jsondata.SearchLabels.searchNameLabel);

					me.getSystemlistForm().down('scrollcombo[itemId=type]').setFieldLabel(jsondata.SearchLabels.searchTypeLabel);

					me.getSystemlistForm().down('textfield[itemId=searchtypetext]').setFieldLabel(jsondata.SearchLabels.typeLabel);

					me.getSystemlistForm().down('button[itemId=submit]').setText(jsondata.SearchLabels.submitBtnText);
				}

				if(Ext.isEmpty(jsondata.NoAccess)){
					//Start of combobox
					var stateCombo = me.getSystemStateCombo();
					var typeCombo = me.getSystemTypeCombo();
					
					stateCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.searchStateString
					});
					typeCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.selTypeString
					});

					stateCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.searchStateStringSelected))
							stateCombo.setValue(store.getAt(0).get('value'));
						else
							stateCombo.setValue(jsondata.SearchLabels.searchStateStringSelected);
					});
					typeCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.selTypeStringSelected))
						{
							typeCombo.setValue(store.getAt(0).get('value'));
						}
						else
						{
							typeCombo.setValue(jsondata.SearchLabels.selTypeStringSelected);
						}
					});
								
					stateCombo.getStore().loadRawData(jsondata.SearchLabels.searchStateString);
					typeCombo.getStore().loadRawData(jsondata.SearchLabels.selTypeString);
					//End of Combo

					//Enable and Disable TextField of QuickType
					if(typeCombo.getValue()=='AllServers')
						me.getSystemSearchTypeField().setDisabled(false);
					else
					{
						me.getSystemSearchTypeField().setValue("");
						me.getSystemSearchTypeField().setDisabled(true);
					}

					//textfield values
					if(!Ext.isEmpty(jsondata.SearchLabels.searchNameString))
					{
						me.getSystemNickName().setValue(jsondata.SearchLabels.searchNameString)
					}
					
					if(!Ext.isEmpty(jsondata.SearchLabels.searchTypeString))
					{
						me.getSystemSearchTypeField().setValue(jsondata.SearchLabels.searchTypeString)
					}
					//textfield ends
					if(jsondata.error)
					{
						me.getSystemComponent().removeAll(true);
						var docked = me.getSystemComponent().getDockedItems();
						if(!Ext.isEmpty(docked)){
							for(i = 0; i < docked.length; i++){
								docked[i].hide();
							}
						}

						docked = null;
						delete docked;

						var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>No systems found</div>'
								}
						]
						});
						me.getSystemComponent().add(emptyPanel);

						emptyPanel = null;
						Ext.destroy(emptyPanel);
					}
					else
					{
						//Title
						//me.getSystemComponent().setTitle('SYSTEMS IN ALL STATES');
						//me.getSystemComponent().setTitle(jsondata.ListLabels.ListTitle);
						me.getSystemComponent().down('label[itemId=systemName]').setText(jsondata.ListLabels.ComponentTypeTitle); //Kaliraj set for title
						me.getSystemComponent().down('label[itemId=availableComponents]').setText(jsondata.ListLabels.AvaliableListTitle);
						//list of components 
						var componentTypeArray = jsondata.ListLabels.ComponentList;
						var panelArray = [];
						var compListLength = componentTypeArray.length;
						Ext.suspendLayouts();
						/*for(var t=0;t<componentTypeArray.length;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								var contentSystemlist = Ext.create('SystemList.view.SystemComponentList',{
									jsonData:jsondata.ListLabels.ComponentList[t],
									//title:jsondata.ListLabels.ComponentList[t].title
								});
								//panelArray.push(contentSystemlist);
								systemcomponent.add(contentSystemlist);
							}
						}*/

						var finalData = "";
						for(var t=0;t<compListLength;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								var tempLeft = "";
								tempLeft = '<table class="table-list-layout" style="width:100%"> <tr> <td style="width:203px;text-align:center;display:table-cell !important;vertical-align:top !important;"> <div style="border:0px solid green;margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="/final/images/'+strSkin+'/component_icons/server.png"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+componentTypeArray[t].boxStateName.toUpperCase()+'"></div></div></div><div style="width:182px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[t].title+'">'+componentTypeArray[t].name+'</div></td>';

								tempLeft=tempLeft+"<td>";
								var tempRight="";
								if(!Ext.isEmpty(componentTypeArray[t].children))
								{
									for(j=0;j<componentTypeArray[t].children.length;j++)
									{
										tempRight=tempRight+"<div style='width:240px;float:left;margin-top:4px;margin-bottom:-4px;border:0px solid red'>";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].name)){
											//var widthOfName = getWidthOfText(componentTypeArray[t].children[j].name,"LucidaGrandeRegular","11px") + 15;
											var widthOfName = getWidthOfText(componentTypeArray[t].children[j].name,"f11-normal") + 15;
											if(widthOfName > 180)
												widthOfName = 180;
											var widthOfNameC = widthOfName + 35;
											if(widthOfNameC > 200){
												widthOfNameC = 200;
												widthOfName = 160;
											}
										}else{
											widthOfName = 200;
											widthOfNameC = 200;
										}
										tempRight=tempRight+'<div style="float:left;display:inline-block;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'
													+ componentTypeArray[t].children[j].stateName
													+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:boxListToDashboard("'
													+ componentTypeArray[t].children[j].link + '","' + componentTypeArray[t].children[j].name
													+ '")\' data-qtip="'
													+ componentTypeArray[t].children[j].title
													+ '" ><div style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;">'
													+ componentTypeArray[t].children[j].name + '</div></a></div></div>';

										var maintenanceIcon ="";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].MaintenanceTime)){
											tempRight=tempRight+'<div style="float:left;margin-top:2px;margin-left:8px;"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+componentTypeArray[t].children[j].MaintenanceTime+'"></div></div>';									
										}
										tempRight = tempRight+"</div>";
									}
								}
								tempLeft=tempLeft+tempRight+"</td></tr></table>";
								finalData += tempLeft;
							}
						}
						systemcomponent.update(finalData);
						Ext.resumeLayouts(true);
						//me.getSystemComponent().add(panelArray);

						componentTypeArray = null;
						delete componentTypeArray;

						panelArray = null;
						delete panelArray;
						
					}
					//SystemList.app.getController("Main").getMain().setLoading(false);
					me.getSystemComponent().doLayout();

					stateCombo = null;
					delete stateCombo;

					typeCombo = null;
					delete typeCombo;
				}
				else
				{
					//var mainItems = me.getMain().removeAll();
					
					var mainObj = me.getMain();
					if(!Ext.isEmpty(mainObj))
					{
						var resultItems=mainObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					me.getMain().removeAll();
					//me.getMain().setTitle('System List');
					//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
					me.getMain().addTool({xtype:'commonbackbutton'});
					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								//align:'center'
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconInformation" style="margin:15% auto 0px auto"></div><div>'+jsondata.NoAccess+'</div>'
								}
						]
						});
					me.getMain().add(emptyPanel);

					emptyPanel = null;
					delete emptyPanel;
					
					me.getMain().doLayout();
				}
				jsondata = null;
				Ext.destroy(jsondata);

				myMask.hide();

			}
		});
	
		/*Ext.Ajax.on("requestcomplete", function(){
			me.getMain().setLoading(false);
		});*/
	},
	loadListView:function(url){
		var me = this;
		var mainPanel = me.getMain();
		if(mainPanel!=null && mainPanel!=undefined && mainPanel.items!=null && mainPanel.items!=undefined)
		{
			var resultItems=mainPanel.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				Ext.ComponentQuery.query("[itemId='componentslistToolbar']")[0].removeAll(true);
				resultItems[item].destroy();
			}
		}

		var myMask = null;
		if(!Ext.isEmpty(mainPanel))
		{
			myMask = new Ext.LoadMask(mainPanel, {msg:"Please wait..."});
			myMask.show();
		}

		/*Ext.Ajax.on("beforerequest", function(){
			me.getMain().setLoading(true);
		});*/

		mainPanel.add({
			xtype: 'systemlistForm',
			url : '/final/monitor/boxListData.jsp?'+requestParams.sessionURL
		},
		{
			xtype:'systemcomponent',
			flex:1
		});

		Ext.Ajax.request({
			url:url,
			success:function(response,opts){
				var jsontext=response.responseText;
				var jsondata=Ext.decode(jsontext);
				
				jsontext = null;
				Ext.destroy(jsontext);

				var systemcomponent = Ext.getCmp('systemcomponent');
				if(!Ext.isEmpty(systemcomponent))
				{
					var resultItems=systemcomponent.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}

				if(!Ext.isEmpty(jsondata.ScreenLabels)){

					if(!Ext.isEmpty(jsondata.ScreenLabels.Title)){
						//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
						//me.getMain().setTitle(jsondata.ScreenLabels.Title);
						me.getMain().setTitle(jsondata.ListLabels.ListTitle);
					}

					me.getSystemlistForm().down('scrollcombo[itemId=state]').setFieldLabel(jsondata.SearchLabels.searchStateLabel);

					me.getSystemlistForm().down('textfield[itemId=nicknametext]').setFieldLabel(jsondata.SearchLabels.searchNameLabel);

					me.getSystemlistForm().down('scrollcombo[itemId=type]').setFieldLabel(jsondata.SearchLabels.searchTypeLabel);

					me.getSystemlistForm().down('textfield[itemId=searchtypetext]').setFieldLabel(jsondata.SearchLabels.typeLabel);

					me.getSystemlistForm().down('button[itemId=submit]').setText(jsondata.SearchLabels.submitBtnText);
				}

				if(Ext.isEmpty(jsondata.NoAccess)){
					//Start of combobox
					var stateCombo = me.getSystemStateCombo();
					var typeCombo = me.getSystemTypeCombo();
					
					stateCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.searchStateString
					});
					typeCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.selTypeString
					});

					stateCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.searchStateStringSelected))
							stateCombo.setValue(store.getAt(0).get('value'));
						else
							stateCombo.setValue(jsondata.SearchLabels.searchStateStringSelected);
					});
					typeCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.selTypeStringSelected))
						{
							typeCombo.setValue(store.getAt(0).get('value'));
						}
						else
						{
							typeCombo.setValue(jsondata.SearchLabels.selTypeStringSelected);
						}
					});
								
					stateCombo.getStore().loadRawData(jsondata.SearchLabels.searchStateString);
					typeCombo.getStore().loadRawData(jsondata.SearchLabels.selTypeString);
					//End of Combo

					

					//Enable and Disable TextField of QuickType
					if(typeCombo.getValue()=='AllServers')
						me.getSystemSearchTypeField().setDisabled(false);
					else
					{
						me.getSystemSearchTypeField().setValue("");
						me.getSystemSearchTypeField().setDisabled(true);
					}

					//textfield values
					if(!Ext.isEmpty(jsondata.SearchLabels.searchNameString))
					{
						me.getSystemNickName().setValue(jsondata.SearchLabels.searchNameString)
					}
					
					if(!Ext.isEmpty(jsondata.SearchLabels.searchTypeString))
					{
						me.getSystemSearchTypeField().setValue(jsondata.SearchLabels.searchTypeString)
					}
					//textfield ends
					if(jsondata.error)
					{
						me.getSystemComponent().removeAll(true);
						var docked = me.getSystemComponent().getDockedItems();
						if(!Ext.isEmpty(docked)){
							for(i = 0; i < docked.length; i++){
								docked[i].hide();
							}
						}

						docked = null;
						delete docked;

						var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>No systems found</div>'
								}
						]
						});
						me.getSystemComponent().add(emptyPanel);

						emptyPanel = null;
						Ext.destroy(emptyPanel);
					}
					else
					{
						//Title
						//me.getSystemComponent().setTitle('Systems in All States');
						//me.getSystemComponent().setTitle(jsondata.ListLabels.ListTitle);
						me.getSystemComponent().down('label[itemId=systemName]').setText(jsondata.ListLabels.ComponentTypeTitle); //Kaliraj set for title
						me.getSystemComponent().down('label[itemId=availableComponents]').setText(jsondata.ListLabels.AvaliableListTitle);
						//list of components 
						var componentTypeArray = jsondata.ListLabels.ComponentList;
						var panelArray = [];
						var compListLength = componentTypeArray.length;
						Ext.suspendLayouts();
						/*for(var t=0;t<componentTypeArray.length;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								var contentSystemlist = Ext.create('SystemList.view.SystemComponentList',{
									jsonData:jsondata.ListLabels.ComponentList[t],
									//title:jsondata.ListLabels.ComponentList[t].title
								});
								//panelArray.push(contentSystemlist);
								systemcomponent.add(contentSystemlist);
							}
						}*/

						var finalData = "";
						for(var t=0;t<compListLength;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								var tempLeft = "";
								tempLeft = '<table class="table-list-layout" style="width:100%"> <tr> <td style="width:203px;text-align:center;display:table-cell !important;vertical-align:top !important;"> <div style="border:0px solid green;margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="/final/images/'+strSkin+'/component_icons/server.png"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+componentTypeArray[t].boxStateName.toUpperCase()+'"></div></div></div><div style="width:182px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[t].title+'">'+componentTypeArray[t].name+'</div></td>';

								tempLeft=tempLeft+"<td>";
								var tempRight="";
								if(!Ext.isEmpty(componentTypeArray[t].children))
								{
									for(j=0;j<componentTypeArray[t].children.length;j++)
									{
										tempRight=tempRight+"<div style='width:240px;float:left;margin-top:4px;margin-bottom:-4px;border:0px solid red'>";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].name)){
											//var widthOfName = getWidthOfText(componentTypeArray[t].children[j].name,"LucidaGrandeRegular","11px") + 15;
											var widthOfName = getWidthOfText(componentTypeArray[t].children[j].name,"f11-normal") + 15;
											if(widthOfName > 180)
												widthOfName = 180;
											var widthOfNameC = widthOfName + 35;
											if(widthOfNameC > 200){
												widthOfNameC = 200;
												widthOfName = 160;
											}
										}else{
											widthOfName = 200;
											widthOfNameC = 200;
										}
										tempRight=tempRight+'<div style="float:left;display:inline-block;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'
													+ componentTypeArray[t].children[j].stateName
													+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:boxListToDashboard("'
													+ componentTypeArray[t].children[j].link + '","' + componentTypeArray[t].children[j].name
													+ '")\' data-qtip="'
													+ componentTypeArray[t].children[j].title
													+ '" ><div style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;">'
													+ componentTypeArray[t].children[j].name + '</div></a></div></div>';

										var maintenanceIcon ="";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].MaintenanceTime)){
											tempRight=tempRight+'<div style="float:left;margin-top:2px;margin-left:8px;"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+componentTypeArray[t].children[j].MaintenanceTime+'"></div></div>';									
										}
										tempRight = tempRight+"</div>";
									}
								}
								tempLeft=tempLeft+tempRight+"</td></tr></table>";
								finalData += tempLeft;
							}
						}
						systemcomponent.update(finalData);
						Ext.resumeLayouts(true);
						//me.getSystemComponent().add(panelArray);

						componentTypeArray = null;
						delete componentTypeArray;

						panelArray = null;
						delete panelArray;
						
					}
					//SystemList.app.getController("Main").getMain().setLoading(false);
					me.getSystemComponent().doLayout();

					stateCombo = null;
					delete stateCombo;

					typeCombo = null;
					delete typeCombo;
				}
				else
				{
					//var mainItems = me.getMain().removeAll();
					
					var mainObj = me.getMain();
					if(!Ext.isEmpty(mainObj))
					{
						var resultItems=mainObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}
					me.getMain().removeAll();
					//me.getMain().setTitle('System List');
					//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
					me.getMain().addTool({xtype:'commonbackbutton'});
					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								//align:'center'
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconInformation" style="margin:15% auto 0px auto"></div><div>'+jsondata.NoAccess+'</div>'
								}
						]
						});
					me.getMain().add(emptyPanel);

					emptyPanel = null;
					delete emptyPanel;
					
					me.getMain().doLayout();
				}
				jsondata = null;
				Ext.destroy(jsondata);

				myMask.hide();
			}
		});
	
		/*Ext.Ajax.on("requestcomplete", function(){
			me.getMain().setLoading(false);
		});*/
	},
	submitButtonClicked : function(){
		var selectedType ="";
		if(this.getSystemTypeCombo().getValue()=='AllServers')
			selectedType=this.getSystemSearchTypeField().getValue();
		
		if(this.getSystemTypeCombo().getValue()=='AllServers')
		{
			this.getSystemSearchTypeField().show();
		}
		else
		{
			this.getSystemSearchTypeField().hide();
		}
		url="../servlet/com.eg.EgMonitorController?monCmd=boxList&from=MainDashboard&action=search&searchStateString="+this.getSystemStateCombo().getValue()+"&searchNameString="+this.getSystemNickName().getValue()+"&selTypeString="+this.getSystemTypeCombo().getValue()+"&searchTypeString="+selectedType;
		//document.location=url;
		//this.getMain().setLoading(true);
		this.refresh();
		//this.getMain().setLoading(false);
		
		selectedType = null;
		delete selectedType;
	},
	backButtonHandler:function(btn){
		if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
		{
			window.history.go(-2);
		}
		else
		{
			window.history.go(-1);
		}
	},
/*	refresh:function(refreshURL){
		
			
		document.location = '/final/servlet/com.eg.EgMonitorController?'+requestParams.sessionURL;
	},*/
	boxListToDashboard : function(dashboardUrl, selectedComponent){
		selectedComponent=parent.filterEncode(selectedComponent);
		document.location=dashboardUrl+"&selected="+encodeURIComponent(selectedComponent);
	},
	metricRefresh:function()
	{
		var listButIdObj=Ext.getCmp('listButId');
		var GridButIdObj=Ext.getCmp('GridButId');

		if(GridButIdObj!=null && GridButIdObj!=undefined)
		{
			GridButIdObj.removeCls('iconCompGridviewSelect');
			GridButIdObj.removeCls('iconCompGridview');

			GridButIdObj.addCls('iconCompGridviewSelect');
		}
		
		if(listButIdObj!=null && listButIdObj!=undefined)
		{
			listButIdObj.removeCls('iconCompListviewSelect');
			listButIdObj.removeCls('iconCompListview');
			listButIdObj.addCls('iconCompListview');
		}
		
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined && Refurl.indexOf('com.eg.CSRF_NONCE')==-1)
		{
			Refurl = Refurl+'&com.eg.CSRF_NONCE='+csrfToken;
		}

		if(Refurl!=null)
		{
			var tabUrl1=Refurl;
		}
		if(Refid=='system' || Refid=='component' || Refid=='components' || Refid=='network')
		{
			var curViewPort=  this.getMain();
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			curViewPort.setTitle(Reftext);
			curViewPort.header.addClass("panelTitle");
			curViewPort.add({
				xtype:'generalMeasuresGridPanel',
				//title:Reftext,
				cls:'gridHeadercenter',
				itemId:Refid,
				margin:0,
				padding:0,
				frame:false,
				border:false,
				layout:{type:'vbox',align:'stretch'},
				flex:1,
				screenLabelPath:"monitor.Dashboard",
				url:tabUrl1,
				listeners: {
					'afterrender': function (obj) {
						this.loadTab(obj.url,Reftot,RefpageVal,'','','','systemList');
						//this.loadTab(obj.url);
					}
				}
			});
		}
		else
		{
			var titlesys="Systems";
			var itemIdforsysandcom="system";
			var curViewPort=  this.getMain();
			//curViewPort.removeAll();
			var resultItems=curViewPort.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//commonpanel.destroy(resultItems[item]);
				resultItems[item].destroy();
			}
			if(tabUrl1.indexOf("treeTitle=System") > -1)
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}
			else if(tabUrl1.indexOf("treeTitle=Component") > -1)
			{
				titlesys='Components';
				itemIdforsysandcom="components";
			}
			else
			{
				titlesys="Systems";
				itemIdforsysandcom="system";
			}

			curViewPort.setTitle(titlesys);
			curViewPort.header.addClass("panelTitle");
			curViewPort.add({
				xtype:'generalMeasuresGridPanel',
				//title:titlesys,
				cls:'gridHeadercenter',
				itemId:itemIdforsysandcom,
				margin:0,
				padding:0,
				frame:false,
				border:false,
				layout:{type:'vbox',align:'stretch'},
				flex:1,
				screenLabelPath:"monitor.Dashboard",
				url:tabUrl1,
				listeners: {
					'afterrender': function (obj)
					{
						this.loadTab(obj.url,Reftot,RefpageVal,'','','','systemList');
						//this.loadTab(obj.url);
					}
				}
			});
		}
	},
	refresh : function(){
	
		Ext.Ajax.on("beforerequest", function(){
			SystemList.app.getController("Main").getMain().setLoading(true);
		});

		
		
		var nickNameVal = SystemList.app.getController("Main").getSystemNickName().getValue();
		try
		{
			nickNameVal = window.opener.checkWithSpecialCharEncode(nickNameVal);		
		}
		catch (e)
		{
			try{
				nickNameVal = parent.checkWithSpecialCharEncode(nickNameVal);				
			}
			catch(ee)
			{
				nickNameVal = parent.parent.checkWithSpecialCharEncode(nickNameVal);				
			}
		}
    	var selectedType ="";
		if(SystemList.app.getController("Main").getSystemTypeCombo().getValue()=='AllServers'){
		  selectedType =SystemList.app.getController("Main").getSystemSearchTypeField().getValue();
        try
		{
			selectedType = window.opener.checkWithSpecialCharEncode(selectedType);		
		}
		catch (e)
		{
			try{
				selectedType = parent.checkWithSpecialCharEncode(selectedType);				
			}
			catch(ee)
			{
				selectedType = parent.parent.checkWithSpecialCharEncode(selectedType);				
			}
		}
		}
		
		if(SystemList.app.getController("Main").getSystemTypeCombo().getValue()=='AllServers')
		{
			SystemList.app.getController("Main").getSystemSearchTypeField().show();
		}
		else
		{
			SystemList.app.getController("Main").getSystemSearchTypeField().hide();
		}
		var me = this;
		var url="../servlet/com.eg.EgMonitorController?monCmd=boxList&from=boxList&action=search&searchStateString="+SystemList.app.getController("Main").getSystemStateCombo().getValue()+"&searchNameString="+encodeURI(nickNameVal)+"&selTypeString="+SystemList.app.getController("Main").getSystemTypeCombo().getValue()+"&searchTypeString="+encodeURI(selectedType)+'&componentListRefresh=yes';
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined && url.indexOf('com.eg.CSRF_NONCE')==-1)
		{
			url = url+'&com.eg.CSRF_NONCE='+csrfToken;
		}
		Ext.Ajax.on("requestcomplete", function(){
			SystemList.app.getController("Main").getMain().setLoading(false);
		});
		var systemcomponent = Ext.getCmp('systemcomponent');
		systemcomponent.update("");
		Ext.Ajax.request({
			url:url,
			success:function(response,opts){
				var jsontext=response.responseText;
				var jsondata=Ext.decode(jsontext);				

				jsontext = null;
				Ext.destroy(jsontext);

				/*if(!Ext.isEmpty(jsondata.ScreenLabels)){

					if(!Ext.isEmpty(jsondata.ScreenLabels.Title)){
						//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
						SystemList.app.getController("Main").getMain().setTitle(jsondata.ScreenLabels.Title);
					}

					SystemList.app.getController("Main").getSystemlistForm().down('scrollcombo[itemId=state]').setFieldLabel(jsondata.SearchLabels.searchStateLabel);

					SystemList.app.getController("Main").getSystemlistForm().down('textfield[itemId=nicknametext]').setFieldLabel(jsondata.SearchLabels.searchNameLabel);

					SystemList.app.getController("Main").getSystemlistForm().down('scrollcombo[itemId=type]').setFieldLabel(jsondata.SearchLabels.searchTypeLabel);

					SystemList.app.getController("Main").getSystemlistForm().down('textfield[itemId=searchtypetext]').setFieldLabel(jsondata.SearchLabels.typeLabel);

					SystemList.app.getController("Main").getSystemlistForm().down('button[itemId=submit]').setText(jsondata.SearchLabels.submitBtnText);
				}*/

				if(Ext.isEmpty(jsondata.NoAccess)){
					//Start of combobox
				/*	var stateCombo = SystemList.app.getController("Main").getSystemStateCombo();
					var typeCombo = SystemList.app.getController("Main").getSystemTypeCombo();
					
					stateCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.searchStateString
					});
					typeCombo.store = Ext.create('Ext.data.Store',{
						fields:['name','value'],
						data:jsondata.SearchLabels.selTypeString
					});

					stateCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.searchStateStringSelected))
							stateCombo.setValue(store.getAt(0).get('value'));
						else
							stateCombo.setValue(jsondata.SearchLabels.searchStateStringSelected);
					});
					typeCombo.getStore().on('load',function(store) {
						if(Ext.isEmpty(jsondata.SearchLabels.selTypeStringSelected))
						{
							typeCombo.setValue(store.getAt(0).get('value'));
						}
						else
						{
							typeCombo.setValue(jsondata.SearchLabels.selTypeStringSelected);
						}
					});
								
					stateCombo.getStore().loadRawData(jsondata.SearchLabels.searchStateString);
					typeCombo.getStore().loadRawData(jsondata.SearchLabels.selTypeString);*/
					//End of Combo

					

					//Enable and Disable TextField of QuickType
				/*	if(typeCombo.getValue()=='AllServers')
						SystemList.app.getController("Main").getSystemSearchTypeField().setDisabled(false);
					else
					{
						SystemList.app.getController("Main").getSystemSearchTypeField().setValue("");
						SystemList.app.getController("Main").getSystemSearchTypeField().setDisabled(true);
					}*/

					//textfield values
					/*if(!Ext.isEmpty(jsondata.SearchLabels.searchNameString))
					{
						SystemList.app.getController("Main").getSystemNickName().setValue(jsondata.SearchLabels.searchNameString)
					}
					
					if(!Ext.isEmpty(jsondata.SearchLabels.searchTypeString))
					{	
							SystemList.app.getController("Main").getSystemSearchTypeField().setValue(jsondata.SearchLabels.searchTypeString)
					}*/
					//textfield ends
					
					if(jsondata.error)
					{
						
						SystemList.app.getController("Main").getSystemComponent().removeAll(true);
						var docked = SystemList.app.getController("Main").getSystemComponent().getDockedItems();
						if(!Ext.isEmpty(docked)){
							for(i = 0; i < docked.length; i++){
								docked[i].hide();
							}
						}
						var systemcomponent = Ext.getCmp('systemcomponent');
						var errormsg = '<div style="margin:15% 0 auto 0"><table style="width:100%"><tr><td><div class = "iconInformation" style="margin:auto"></div></td></tr><tr><td style="text-align:center"><div>No systems found</div></td></tr></table></div>';
						systemcomponent.update(errormsg);
						/*var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconExclamation" style="margin:10% auto 0px auto"></div><div>No systems found</div>'
								}
						]
						});
						SystemList.app.getController("Main").getSystemComponent().add(emptyPanel);

						emptyPanel = null;
						Ext.destroy(emptyPanel);*/

						docked = null;
						delete docked;
					}
					else
					{
						SystemList.app.getController("Main").getSystemComponent().removeAll();
						//Title
						
						var docked = SystemList.app.getController("Main").getSystemComponent().getDockedItems();
						if(!Ext.isEmpty(docked)){
							for(i = 0; i < docked.length; i++){
								docked[i].show();
							}
						}

						/*SystemList.app.getController("Main").getSystemComponent().setTitle('Systems in All States');
						SystemList.app.getController("Main").getSystemComponent().setTitle(jsondata.ListLabels.ListTitle);
						SystemList.app.getController("Main").getSystemComponent().down('label[itemId=systemName]').setText(jsondata.ListLabels.ComponentTypeTitle); // set for title

						SystemList.app.getController("Main").getSystemComponent().down('label[itemId=availableComponents]').setText(jsondata.ListLabels.AvaliableListTitle);*/
						//list of components 


						var systemcomponent = Ext.getCmp('systemcomponent');
						if(!Ext.isEmpty(systemcomponent))
						{
							//commonpanel.removeAll();
							var resultItems=systemcomponent.items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy();
							}
						}
						systemcomponent.update("");
						var componentTypeArray = jsondata.ListLabels.ComponentList;
						var panelArray = [];
						var contentSystemlist="";
						Ext.suspendLayouts();
						var compListLength = componentTypeArray.length;
						/*for(var t=0;t<componentTypeArray.length;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								contentSystemlist = Ext.create('SystemList.view.SystemComponentList',{
									jsonData:jsondata.ListLabels.ComponentList[t],
									//title:jsondata.ListLabels.ComponentList[t].title
								});
								//panelArray.push(contentSystemlist);
								systemcomponent.add(contentSystemlist);
							}
						}*/
						var finalData = "";
						for(var t=0;t<compListLength;t++){
							var tempname = jsondata.ListLabels.ComponentList[t].title;
							if(!Ext.isEmpty(tempname)){
								var tempLeft = "";
								tempLeft = '<table class="table-list-layout" style="width:100%"> <tr> <td style="width:203px;text-align:center;display:table-cell !important;vertical-align:top !important;"> <div style="border:0px solid green;margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="/final/images/'+strSkin+'/component_icons/server.png"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+componentTypeArray[t].boxStateName.toUpperCase()+'"></div></div></div><div style="width:182px;" data-qclass="yellowTip" class="component-list-left-font" data-qtip="'+componentTypeArray[t].title+'">'+componentTypeArray[t].name+'</div></td>';

								tempLeft=tempLeft+"<td>";
								var tempRight="";
								if(!Ext.isEmpty(componentTypeArray[t].children))
								{
									for(j=0;j<componentTypeArray[t].children.length;j++)
									{
										tempRight=tempRight+"<div style='width:240px;float:left;margin-top:4px;margin-bottom:-4px;border:0px solid red'>";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].name)){
											var widthOfName = getWidthOfText(componentTypeArray[t].children[j].name,"f11-normal") + 15;
											if(widthOfName > 180)
												widthOfName = 180;
											var widthOfNameC = widthOfName + 35;
											if(widthOfNameC > 200){
												widthOfNameC = 200;
												widthOfName = 160;
											}
										}else{
											widthOfName = 200;
											widthOfNameC = 200;
										}
										tempRight=tempRight+'<div style="float:left;display:inline-block;width:'+widthOfNameC+'px"><div class="serviceSegmentComponentName"><img style="position:relative;" src="/final/images/clear.png" class="'
													+ componentTypeArray[t].children[j].stateName
													+ '"/><a style="width:90%;padding-left:0px" class="component-list-right-link" data-qclass="yellowTip" href="javascript:void(0)" onclick=\'javascript:boxListToDashboard("'
													+ componentTypeArray[t].children[j].link + '","' + componentTypeArray[t].children[j].name
													+ '")\' data-qtip="'
													+ componentTypeArray[t].children[j].title
													+ '" ><div style="overflow:hidden;text-overflow:ellipsis;width:'+widthOfName+'px;">'
													+ componentTypeArray[t].children[j].name + '</div></a></div></div>';

										var maintenanceIcon ="";
										if(!Ext.isEmpty(componentTypeArray[t].children[j].MaintenanceTime)){
											tempRight=tempRight+'<div style="float:left;margin-top:2px;margin-left:8px;"><div class="iconMaintenance" data-qclass="yellowTip" style="margin:auto;text-align:center" data-qtip="'+componentTypeArray[t].children[j].MaintenanceTime+'"></div></div>';									
										}
										tempRight = tempRight+"</div>";
									}
								}
								tempLeft=tempLeft+tempRight+"</td></tr></table>";
								finalData += tempLeft;
							}
						}
						systemcomponent.update(finalData);
						
						Ext.resumeLayouts(true); 

						contentSystemlist = null;
						Ext.destroy(contentSystemlist);
						
						//SystemList.app.getController("Main").getSystemComponent().add(panelArray);

						panelArray = null;
						delete panelArray;
				
						componentTypeArray = null;
						delete componentTypeArray;

						docked = null;
						delete docked;

					}
					SystemList.app.getController("Main").getSystemComponent().doLayout();
				}
				else
				{
					
					SystemList.app.getController("Main").getMain().removeAll();
					//me.getMain().setTitle('System List');
					//me.getMain().down('panel[itemId=centerPanel]').setTitle(jsondata.ScreenLabels.Title);
					SystemList.app.getController("Main").getMain().addTool({xtype:'commonbackbutton'});
					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
								xtype: 'container',
								padding: 50,
								//align:'center'
								style: {
									'text-align': 'center'
								},
								html: '<div class = "iconInformation" style="margin:15% auto 0px auto"></div><div>'+jsondata.NoAccess+'</div>'
								}
						]
						});
						SystemList.app.getController("Main").getMain().add(emptyPanel);
						SystemList.app.getController("Main").getMain().doLayout();

						emptyPanel = null;
						delete emptyPanel;
						Ext.destroy(emptyPanel);
				}

				jsondata = null;
				Ext.destroy(jsondata);
			}
			
		});
		
	 url= null;
	 delete url;

	 selectedType = null;
	 delete selectedType;
	},
	itemset:function(window,e){
			window.add(window.setData("",""));
		},
			
	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		
		if(selectedTab=='Component' || selectedTab=='Aggregate' || selectedTab=='System')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		
		if(name=='serviceComp')
		{
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		}
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceMeasure')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			var dispName=newvalue[0].data.name;
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
		}
		else{}
	},

	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add' || perform=='Modify')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate' || selectedTab=='System')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
				testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
				dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
				name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},

	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
		{
			if(url.indexOf('?')!=-1)
				url = url+'&com.eg.CSRF_NONCE='+csrfToken;
			else
				url = url+'?com.eg.CSRF_NONCE='+csrfToken;
		}
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if(this.hasSpecialCharacters(dispName))
					{
						if(this.hasNumbers(dispName)){
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}

					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
			Ext.Ajax.request({
				url: url,
				params:params,
				method : 'POST',
				scope:this,
				success: function(response){
					var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
					var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
					var dispName="";
					var measureName=-1;
					var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
					var compname='';
					var componentType='';
					var descMeasureUnit='';
					var testfun='';
					if(perform=='Add')
					{
						//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
						//if(descMeasureUnit=='Yes')
						testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Added Successfully',
							buttons: Ext.Msg.OK
						});
					}
					else if(perform=='Delete')
					{
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Deleted Successfully',
							buttons: Ext.Msg.OK
						});
					}
					else if(perform=='Modify')
					{
						Ext.Msg.show({
							title:'STATUS',
							cls:'msgtextalign',
							msg:'Measure Modified Successfully',
							buttons: Ext.Msg.OK
						});
					}
					if(selectedTab=='Component' || selectedTab=='Aggregate' || selectedTab=='System')
						componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
					this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
				},
				failure:function(){
					window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},
	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},
	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		var charAr = t.split('');
		if(charAr != null && charAr != undefined && charAr.length > 0)
		{
			for(var p=0;p<charAr.length;p++)
			{
				var c = charAr[p];
				if(!(c ==' ' || c ==')' || c =='(' || c =='_' || c.match(/^[-'a-z\u4e00-\u9eff]{1,20}$/i)))
					return true;
			}
			return false;
		}
	},
});